# 目标：将扫描版 PDF 转换为结构化 Markdown 电子书

## 输入：
*   待处理文件： 我已上传一份扫描版的 PDF 文件。
*   文件描述： [请在此处替换为 PDF 的简要主题或类型，例如：一本关于人工智能的历史书籍、一份 Python 技术手册、一部科幻小说]

## 核心任务与要求：
请对上传的扫描版 PDF 执行以下操作，最终输出单一、完整的 Markdown (.md) 格式文本。

1.  高精度 OCR 处理：
    *   对整个 PDF 文档执行 OCR，将图像文字转换为可编辑文本。
    *   优先保证识别准确率。

2.  智能结构识别与 Markdown 转换：
    *   结构推断： 基于 OCR 文本和原始视觉布局（如字体大小、加粗、居中、缩进等），自动推断文档的层级结构（章节、子章节、段落等）。
    *   Markdown 标题： 使用 `#`、`##`、`## #` 等标准 Markdown 语法表示各级标题。
    *   列表转换： 将文档中的项目符号或编号列表准确转换为 Markdown 列表格式（例如 `* 项目` 或 `1. 项目`）。

3.  内容清理与智能拼接：
    *   移除页眉页脚： 自动识别并彻底移除每页的页眉（常含书名/章节名）和页脚（常含页码/出版信息）。
    *   移除页码： 确保所有独立页码均被移除。
    *   跨页内容拼接： 在移除页眉页脚后，将跨页的段落或句子自然、无缝地拼接起来，形成连贯的文本流。
    *   移除冗余空白： 清理 OCR 过程中可能产生的多余空格或不必要的空行。

4.  注释（脚注/尾注）处理：
    *   识别标记： 查找文中的注释引用标记（如上标数字 ¹²³、符号 *†‡、括号注释等）。
    *   提取内容： 定位并提取这些标记对应的注释文本（通常在页底、章末或文末）。
    *   Markdown 脚注格式化：
        *   在原文标记处，替换为 Markdown 脚注引用 `[^标识符]` (例如 `[^1]`, `[^noteA]`)。
        *   在文档末尾创建 `## 注释` (或 `## Endnotes`) 部分。
        *   在此部分，使用 `[^标识符]: 注释内容` 格式，将所有提取的注释按顺序或标识符组织起来。
        *   确保原文引用与末尾定义一一对应。

5.  基础排版与一致性：
    *   文本流畅性： 确保整体文本阅读通顺，段落分隔清晰。
    *   标点符号统一： 尽可能统一使用全角或半角标点，保持风格一致（如果 OCR 结果允许）。

6.  处理 OCR 不确定性与复杂布局：
    *   标记无法识别内容： 对于无法识别或高度模糊的文本，使用明确标记，如 `[无法识别]` 或 `[OCR模糊：...]`。
    *   处理复杂元素： 对于图表、图片、多栏排版等复杂布局，优先提取其中的文本内容。若无法完美转换其结构，请在输出中说明情况或尝试用纯文本描述其内容。

## 输出格式：
*   单一 Markdown 文本： 将处理完成的所有内容，严格按照 Markdown 语法，整合到一个 `.md` 格式的文本框中输出。确保没有遗漏，格式干净，将提供的所有内容，包括标题、文本、列表、引用、表格、图片描述、ASCII 图示、Mermaid 代码块以及脚注等，全部包裹在一个单一的 Markdown 代码块中，将提供的所有内容，包括标题、文本、列表、引用、表格、图片描述、ASCII 图示、Mermaid 代码块以及脚注等，全部包裹在一个单一的 Markdown 代码块中，将提供的所有内容，包括标题、文本、列表、引用、表格、图片描述、ASCII 图示、Mermaid 代码块以及脚注等，全部包裹在一个单一的 Markdown 代码块中，将提供的所有内容，包括标题、文本、列表、引用、表格、图片描述、ASCII 图示、Mermaid 代码块以及脚注等，全部包裹在一个单一的 Markdown 代码块中，将提供的所有内容，包括标题、文本、列表、引用、表格、图片描述、ASCII 图示、Mermaid 代码块以及脚注等，全部包裹在一个单一的 Markdown 代码块中，将提供的所有内容，包括标题、文本、列表、引用、表格、图片描述、ASCII 图示、Mermaid 代码块以及脚注等，全部包裹在一个单一的 Markdown 代码块中，将提供的所有内容，包括标题、文本、列表、引用、表格、图片描述、ASCII 图示、Mermaid 代码块以及脚注等，全部包裹在一个单一的 Markdown 代码块中，将提供的所有内容，包括标题、文本、列表、引用、表格、图片描述、ASCII 图示、Mermaid 代码块以及脚注等，全部包裹在一个单一的 Markdown 代码块中，将提供的所有内容，包括标题、文本、列表、引用、表格、图片描述、ASCII 图示、Mermaid 代码块以及脚注等，全部包裹在一个单一的 Markdown 代码块中，将提供的所有内容，包括标题、文本、列表、引用、表格、图片描述、ASCII 图示、Mermaid 代码块以及脚注等，全部包裹在一个单一的 Markdown 代码块中，将提供的所有内容，包括标题、文本、列表、引用、表格、图片描述、ASCII 图示、Mermaid 代码块以及脚注等，全部包裹在一个单一的 Markdown 代码块中，将提供的所有内容，包括标题、文本、列表、引用、表格、图片描述、ASCII 图示、Mermaid 代码块以及脚注等，全部包裹在一个单一的 Markdown 代码块中，将提供的所有内容，包括标题、文本、列表、引用、表格、图片描述、ASCII 图示、Mermaid 代码块以及脚注等，全部包裹在一个单一的 Markdown 代码块中，将提供的所有内容，包括标题、文本、列表、引用、表格、图片描述、ASCII 图示、Mermaid 代码块以及脚注等，全部包裹在一个单一的 Markdown 代码块中，将提供的所有内容，包括标题、文本、列表、引用、表格、图片描述、ASCII 图示、Mermaid 代码块以及脚注等，全部包裹在一个单一的 Markdown 代码块中，将提供的所有内容，包括标题、文本、列表、引用、表格、图片描述、ASCII 图示、Mermaid 代码块以及脚注等，全部包裹在一个单一的 Markdown 代码块中，将提供的所有内容，包括标题、文本、列表、引用、表格、图片描述、ASCII 图示、Mermaid 代码块以及脚注等，全部包裹在一个单一的 Markdown 代码块中，将提供的所有内容，包括标题、文本、列表、引用、表格、图片描述、ASCII 图示、Mermaid 代码块以及脚注等，全部包裹在一个单一的 Markdown 代码块中，将提供的所有内容，包括标题、文本、列表、引用、表格、图片描述、ASCII 图示、Mermaid 代码块以及脚注等，全部包裹在一个单一的 Markdown 代码块中，将提供的所有内容，包括标题、文本、列表、引用、表格、图片描述、ASCII 图示、Mermaid 代码块以及脚注等，全部包裹在一个单一的 Markdown 代码块中。

---

请确认收到文件描述后，开始处理。
