# 目标：将扫描版 PDF 转换为结构化 Markdown 电子书

输入： 我已上传一份扫描版的 PDF 文件，文件内容是关于 [请在此处简要描述 PDF 的主题或类型，例如：一本关于XX的历史书籍、一份XX技术手册、一部XX小说]。

核心任务：
请对这份扫描版 PDF 进行处理，将其转换为一份结构清晰、排版干净的 Markdown 格式电子书，必选全部在一个md格式框输出

具体要求：

1.  OCR 处理： 首先，对整个 PDF 文档执行 OCR（光学字符识别），将图像文字转换为可编辑的文本。请尽最大努力保证识别的准确性。
2.  结构识别与 Markdown 转换：
    *   推断结构： 根据 OCR 识别出的文本内容和原始文档的视觉布局（如字体大小、加粗、居中、缩进等），智能推断文档的结构层次，例如：章节、子章节、段落等。
    *   Markdown 标题： 使用标准的 Markdown 语法表示标题层级。例如：
        *   一级标题（如章节名）使用 `# 标题`
        *   二级标题（如小节名）使用 `## 标题`
        *   三级及以下标题使用 `### 标题` 等。
    *   段落： 保持段落之间的空行。
    *   列表： 将文档中的项目符号列表或编号列表转换为 Markdown 列表（使用 `* ` 或 `1. `）。
3.  内容清理：
    *   移除页眉页脚： 自动识别并彻底移除每一页可能存在的页眉（通常包含书名、章节名）和页脚（通常包含页码、出版社信息等）。不要将它们包含在最终的 Markdown 输出中。
    *   移除页码： 确保所有页码都被移除。
4.  注释处理：
    *   识别注释标记： 查找文本中可能存在的注释标记（例如，上标数字 ¹²³、星号 *†‡、括号内的注释等）。
    *   提取注释内容： 找到这些标记对应的注释文本（可能在页面底部、章节末尾或文档末尾）。
    *   重新定位注释：
        *   在原文中注释标记的位置，替换为 Markdown 的脚注引用格式，例如 `[^1]`, `[^2]`, `[^footnote_identifier]`。
        *   将所有提取到的注释内容，统一整理到一个专门的区域，例如在整个文档的末尾创建一个名为 `## 注释` 或 `## Endnotes` 的部分。
        *   在该注释区域，使用 Markdown 脚注定义格式列出注释内容，例如：
            ```markdown
            [^1]: 这是第一条注释的内容。
            [^2]: 这是第二条注释的内容。
            [^footnote_identifier]: 这是另一条注释。
            ```
        *   确保原文中的引用标记与注释区域的定义一一对应。
5.  基础排版统一：
    *   确保文本流畅，段落分隔清晰。
    *   移除不必要的空行或空格（例如，OCR 过程中可能产生的多余空格）。
    *   统一标点符号（如果可能，尽量使用全角或半角中的一种，保持一致）。
6.  处理 OCR 不确定性：
    *   如果遇到无法识别或高度模糊的文本片段，请使用特殊标记清晰地指出，例如 `[无法识别]` 或 `[OCR模糊：...]`，而不是猜测或省略。
    *   对于复杂的布局（如图表、图片、多栏排版），优先提取文本内容。如果无法完美转换布局，请说明情况或尝试用纯文本描述。

输出格式：
请将最终处理好的、包含完整结构和清理后内容的文本，以单一的 Markdown (.md) 格式框文件格式提供给我。

请开始处理。
