# twscrape Reference Documentation

## Overview

This directory contains detailed reference documentation for twscrape, a Python library for scraping Twitter/X data.

## Reference Files

### Core Documentation
- **[installation.md](installation.md)** - Installation instructions and dependencies
- **[api_methods.md](api_methods.md)** - Complete API method reference with parameters
- **[account_management.md](account_management.md)** - Account setup, login, and rotation
- **[cli_usage.md](cli_usage.md)** - Command-line interface guide
- **[proxy_config.md](proxy_config.md)** - Proxy configuration and setup
- **[examples.md](examples.md)** - Practical code examples and patterns

## Quick Navigation

### Getting Started
1. Read [installation.md](installation.md) for setup
2. Review [account_management.md](account_management.md) for adding accounts
3. Check [examples.md](examples.md) for quick start code

### API Reference
- For programmatic usage: [api_methods.md](api_methods.md)
- For command-line usage: [cli_usage.md](cli_usage.md)

### Advanced Topics
- Proxy configuration: [proxy_config.md](proxy_config.md)
- Rate limit handling: See [api_methods.md](api_methods.md#rate-limits)

## Key Features

- ✅ Async/await support for parallel operations
- ✅ Automatic account rotation
- ✅ Session persistence
- ✅ Multiple proxy support
- ✅ SNScrape-compatible data models
- ✅ Both CLI and Python API
