---
name: timescaledb
description: TimescaleDB - PostgreSQL extension for high-performance time-series and event data analytics, hypertables, continuous aggregates, compression, and real-time analytics
---

# Timescaledb Skill

Comprehensive assistance with timescaledb development, generated from official documentation.

## When to Use This Skill

This skill should be triggered when:
- Working with timescaledb
- Asking about timescaledb features or APIs
- Implementing timescaledb solutions
- Debugging timescaledb code
- Learning timescaledb best practices

## Quick Reference

### Common Patterns

*Quick reference patterns will be added as you use the skill.*

### Example Code Patterns

**Example 1** (bash):
```bash
rails new my_app -d=postgresql
    cd my_app
```

**Example 2** (ruby):
```ruby
gem 'timescaledb'
```

**Example 3** (shell):
```shell
kubectl create namespace timescale
```

**Example 4** (shell):
```shell
kubectl config set-context --current --namespace=timescale
```

**Example 5** (sql):
```sql
DROP EXTENSION timescaledb;
```

## Reference Files

This skill includes comprehensive documentation in `references/`:

- **api.md** - Api documentation
- **compression.md** - Compression documentation
- **continuous_aggregates.md** - Continuous Aggregates documentation
- **getting_started.md** - Getting Started documentation
- **hyperfunctions.md** - Hyperfunctions documentation
- **hypertables.md** - Hypertables documentation
- **installation.md** - Installation documentation
- **other.md** - Other documentation
- **performance.md** - Performance documentation
- **time_buckets.md** - Time Buckets documentation
- **tutorials.md** - Tutorials documentation

Use `view` to read specific reference files when detailed information is needed.

## Working with This Skill

### For Beginners
Start with the getting_started or tutorials reference files for foundational concepts.

### For Specific Features
Use the appropriate category reference file (api, guides, etc.) for detailed information.

### For Code Examples
The quick reference section above contains common patterns extracted from the official docs.

## Resources

### references/
Organized documentation extracted from official sources. These files contain:
- Detailed explanations
- Code examples with language annotations
- Links to original documentation
- Table of contents for quick navigation

### scripts/
Add helper scripts here for common automation tasks.

### assets/
Add templates, boilerplate, or example projects here.

## Notes

- This skill was automatically generated from official documentation
- Reference files preserve the structure and examples from source docs
- Code examples include language detection for better syntax highlighting
- Quick reference patterns are extracted from common usage examples in the docs

## Updating

To refresh this skill with updated documentation:
1. Re-run the scraper with the same configuration
2. The skill will be rebuilt with the latest information
