# Coingecko - Other

**Pages:** 16

---

## Clients

**URL:** llms-txt#clients

**Contents:**
- API Swagger JSON (OAS)
- Official CoinGecko API SDK

Source: https://docs.coingecko.com/docs/clients

Explore client resources, including official Swagger JSON and unofficial Python wrapper

## API Swagger JSON (OAS)

<a href="https://github.com/coingecko/coingecko-api-oas" target="_blank" rel="noopener noreferrer">
  <Frame>
    <img src="https://mintcdn.com/coingecko/HbbqJRkzM8wbxbUM/images/docs/51c3a7e-image.png?fit=max&auto=format&n=HbbqJRkzM8wbxbUM&q=85&s=89a0e23044b6440703a9949f2d111a72" noZoom data-og-width="1404" width="1404" data-og-height="552" height="552" data-path="images/docs/51c3a7e-image.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/coingecko/HbbqJRkzM8wbxbUM/images/docs/51c3a7e-image.png?w=280&fit=max&auto=format&n=HbbqJRkzM8wbxbUM&q=85&s=f790f47b07cb2309a9d8a4ccd644957a 280w, https://mintcdn.com/coingecko/HbbqJRkzM8wbxbUM/images/docs/51c3a7e-image.png?w=560&fit=max&auto=format&n=HbbqJRkzM8wbxbUM&q=85&s=dbff0485155760cc1ba8771bda4323c4 560w, https://mintcdn.com/coingecko/HbbqJRkzM8wbxbUM/images/docs/51c3a7e-image.png?w=840&fit=max&auto=format&n=HbbqJRkzM8wbxbUM&q=85&s=bc7acc8a93d983a1a7850777347ce5f0 840w, https://mintcdn.com/coingecko/HbbqJRkzM8wbxbUM/images/docs/51c3a7e-image.png?w=1100&fit=max&auto=format&n=HbbqJRkzM8wbxbUM&q=85&s=d15a8bd2ddd52e934cc9a07200431b12 1100w, https://mintcdn.com/coingecko/HbbqJRkzM8wbxbUM/images/docs/51c3a7e-image.png?w=1650&fit=max&auto=format&n=HbbqJRkzM8wbxbUM&q=85&s=0b03fab442b9e8129bda1ab9f10c4f12 1650w, https://mintcdn.com/coingecko/HbbqJRkzM8wbxbUM/images/docs/51c3a7e-image.png?w=2500&fit=max&auto=format&n=HbbqJRkzM8wbxbUM&q=85&s=70bb4883d506a864c3f6a2cb09914c97 2500w" />
  </Frame>
</a>

* [CoinGecko Pro OAS](https://docs.coingecko.com/reference/endpoint-overview)
  * CoinGecko Pro API — [coingecko-pro.json](https://raw.githubusercontent.com/coingecko/coingecko-api-oas/refs/heads/main/coingecko-pro.json)
  * GeckoTerminal Onchain API (Pro) — [onchain-pro.json](https://raw.githubusercontent.com/coingecko/coingecko-api-oas/refs/heads/main/onchain-pro.json)

* [CoinGecko Public/Demo OAS](https://docs.coingecko.com/v3.0.1/reference/endpoint-overview)
  * CoinGecko Public/Demo API — [coingecko-demo.json](https://raw.githubusercontent.com/coingecko/coingecko-api-oas/refs/heads/main/coingecko-demo.json)
  * GeckoTerminal Onchain API (Demo) — [onchain-demo.json](https://raw.githubusercontent.com/coingecko/coingecko-api-oas/refs/heads/main/onchain-demo.json)

## Official CoinGecko API SDK

Here are the official API SDKs maintained by us.

* [🐍 coingecko-python (Python)](https://github.com/coingecko/coingecko-python)
* [🟦 coingecko-typescript (Typescript)](https://github.com/coingecko/coingecko-python)

Want us to support your favorite programming language? Let us know [here](https://forms.gle/JJLH3SXiL2eJaGzBA)!

**Not a developer?** Fred not, check our no-code tutorial for beginners here: [Tutorials (Beginner-friendly)](/docs/tutorials-beginner-friendly)

---

## API Status

**URL:** llms-txt#api-status

Source: https://docs.coingecko.com/docs/api-status

CoinGecko's API status page provides information on the current status and incident history of CoinGecko API (Public & Pro)

<Check>
  ### **Tips**

* You can view our live updates, and subscribe to updates via Email, Slack and Discord.
  * Instead of subscribing to all updates, you may click on 'Select services' to subscribe to either Public or Pro API updates.
</Check>

<img src="https://mintcdn.com/coingecko/a7cplMjqO5fc2v5e/images/reference/73a827b-image.png?fit=max&auto=format&n=a7cplMjqO5fc2v5e&q=85&s=5fefdb6ae9202da2644d922ccf79356f" alt="" data-og-width="1840" width="1840" data-og-height="1528" height="1528" data-path="images/reference/73a827b-image.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/coingecko/a7cplMjqO5fc2v5e/images/reference/73a827b-image.png?w=280&fit=max&auto=format&n=a7cplMjqO5fc2v5e&q=85&s=7403db5955420bec7d169d0a4dcac3d1 280w, https://mintcdn.com/coingecko/a7cplMjqO5fc2v5e/images/reference/73a827b-image.png?w=560&fit=max&auto=format&n=a7cplMjqO5fc2v5e&q=85&s=8c74b607d2e47dc3581f21c3de9c1ba3 560w, https://mintcdn.com/coingecko/a7cplMjqO5fc2v5e/images/reference/73a827b-image.png?w=840&fit=max&auto=format&n=a7cplMjqO5fc2v5e&q=85&s=c0daaedaca6d6d3f721eb672c676554f 840w, https://mintcdn.com/coingecko/a7cplMjqO5fc2v5e/images/reference/73a827b-image.png?w=1100&fit=max&auto=format&n=a7cplMjqO5fc2v5e&q=85&s=76e79ef68e3a410718a9d12e6bd4bf3c 1100w, https://mintcdn.com/coingecko/a7cplMjqO5fc2v5e/images/reference/73a827b-image.png?w=1650&fit=max&auto=format&n=a7cplMjqO5fc2v5e&q=85&s=444dda0811606f4c6deffbaddd3d3450 1650w, https://mintcdn.com/coingecko/a7cplMjqO5fc2v5e/images/reference/73a827b-image.png?w=2500&fit=max&auto=format&n=a7cplMjqO5fc2v5e&q=85&s=5e2b0d20dad6ec97b912b05fe235c9a6 2500w" />

* CoinGecko API Status — [https://status.coingecko.com](https://status.coingecko.com)
* Incident & Maintenance History — [https://status.coingecko.com/incidents](https://status.coingecko.com/incidents)
* Uptime Calendar — [https://status.coingecko.com/incidents/uptime-calendar](https://status.coingecko.com/incidents/uptime-calendar)

---

## 🚀 Connecting with ChatGPT

**URL:** llms-txt#🚀-connecting-with-chatgpt

OpenAI ChatGPT have just launched an MCP connector, but requires [developer mode](https://platform.openai.com/docs/guides/developer-mode) toggle turned on.

1. Open your profile > Connectors > Advanced Settings > Toggle Developer Mode On

2. In the Connectors modal, choose "Create" and enter the CoinGecko MCP server info

<Frame>
     <img
       src="https://mintcdn.com/coingecko/-YWykcjHRtoo7cBr/images/reference/mcp-open-ai-chatgpt-1.png?fit=max&auto=format&n=-YWykcjHRtoo7cBr&q=85&s=19b9da2451dbb287b3e14bbd1bb1d6c4"
       style={{
      width: "400px", height: "auto"
    }}
       data-og-width="921"
       width="921"
       data-og-height="1330"
       height="1330"
       data-path="images/reference/mcp-open-ai-chatgpt-1.png"
       data-optimize="true"
       data-opv="3"
       srcset="https://mintcdn.com/coingecko/-YWykcjHRtoo7cBr/images/reference/mcp-open-ai-chatgpt-1.png?w=280&fit=max&auto=format&n=-YWykcjHRtoo7cBr&q=85&s=1e0e27aefe9eed409e50802d46ccbd96 280w, https://mintcdn.com/coingecko/-YWykcjHRtoo7cBr/images/reference/mcp-open-ai-chatgpt-1.png?w=560&fit=max&auto=format&n=-YWykcjHRtoo7cBr&q=85&s=4fa547e688348c71af6bd7a65018a06b 560w, https://mintcdn.com/coingecko/-YWykcjHRtoo7cBr/images/reference/mcp-open-ai-chatgpt-1.png?w=840&fit=max&auto=format&n=-YWykcjHRtoo7cBr&q=85&s=b58a95c0d11926961008038c5c150a2c 840w, https://mintcdn.com/coingecko/-YWykcjHRtoo7cBr/images/reference/mcp-open-ai-chatgpt-1.png?w=1100&fit=max&auto=format&n=-YWykcjHRtoo7cBr&q=85&s=d9a04921b35edb6034fe498ce69e06c2 1100w, https://mintcdn.com/coingecko/-YWykcjHRtoo7cBr/images/reference/mcp-open-ai-chatgpt-1.png?w=1650&fit=max&auto=format&n=-YWykcjHRtoo7cBr&q=85&s=043bd546e1eadb1d7b20b1cdc44fe5d5 1650w, https://mintcdn.com/coingecko/-YWykcjHRtoo7cBr/images/reference/mcp-open-ai-chatgpt-1.png?w=2500&fit=max&auto=format&n=-YWykcjHRtoo7cBr&q=85&s=deb9413356da4ff107766f1c483d14b8 2500w"
     />
   </Frame>

3. Before prompting, choose "+" > More > Developer Mode > CoinGecko MCP tool must be turned on

<Frame>
     <img
       src="https://mintcdn.com/coingecko/-YWykcjHRtoo7cBr/images/reference/mcp-open-ai-chatgpt-2.png?fit=max&auto=format&n=-YWykcjHRtoo7cBr&q=85&s=2dbce0217b55c42f75bcf72b1840261c"
       style={{
      width: "500px", height: "auto"
    }}
       data-og-width="1604"
       width="1604"
       data-og-height="404"
       height="404"
       data-path="images/reference/mcp-open-ai-chatgpt-2.png"
       data-optimize="true"
       data-opv="3"
       srcset="https://mintcdn.com/coingecko/-YWykcjHRtoo7cBr/images/reference/mcp-open-ai-chatgpt-2.png?w=280&fit=max&auto=format&n=-YWykcjHRtoo7cBr&q=85&s=1164c4b43b3973808b53e78219db4544 280w, https://mintcdn.com/coingecko/-YWykcjHRtoo7cBr/images/reference/mcp-open-ai-chatgpt-2.png?w=560&fit=max&auto=format&n=-YWykcjHRtoo7cBr&q=85&s=57565551346ddc2479ec396c5f03a5ad 560w, https://mintcdn.com/coingecko/-YWykcjHRtoo7cBr/images/reference/mcp-open-ai-chatgpt-2.png?w=840&fit=max&auto=format&n=-YWykcjHRtoo7cBr&q=85&s=9ffd706dd65fc5d64cae76ed5c44c6db 840w, https://mintcdn.com/coingecko/-YWykcjHRtoo7cBr/images/reference/mcp-open-ai-chatgpt-2.png?w=1100&fit=max&auto=format&n=-YWykcjHRtoo7cBr&q=85&s=20e6b62405c7069c6c58d6523a98854b 1100w, https://mintcdn.com/coingecko/-YWykcjHRtoo7cBr/images/reference/mcp-open-ai-chatgpt-2.png?w=1650&fit=max&auto=format&n=-YWykcjHRtoo7cBr&q=85&s=963d3992d6e0d46cfbbc56bd4179c099 1650w, https://mintcdn.com/coingecko/-YWykcjHRtoo7cBr/images/reference/mcp-open-ai-chatgpt-2.png?w=2500&fit=max&auto=format&n=-YWykcjHRtoo7cBr&q=85&s=2eabd675061763732754fc304f7e48e9 2500w"
     />
   </Frame>

---

## TypeScript AI Prompts

**URL:** llms-txt#typescript-ai-prompts

**Contents:**
- How to Use Our Prompts
- Resources

Source: https://docs.coingecko.com/docs/typescript-ai-prompts

A comprehensive AI prompt to guide coding assistants in correctly implementing the official CoinGecko TypeScript SDK.

## How to Use Our Prompts

Integrating these prompts into your workflow is simple. Copy the entire markdown prompt for your chosen language and provide it as context to your AI assistant.

1. For **Chat Interfaces (Claude, ChatGPT, etc.)**: Paste the prompt at the beginning of your conversation before asking the AI to write code.
2. For **Cursor IDE**: Add the prompt to your project's `Rules` to enforce the guidelines across all AI interactions.
3. For **GitHub Copilot**: Save the prompt to a file (e.g. `coingecko_rules.md`) and reference it in your chat with `@workspace #coingecko_rules.md`.
4. For **Claude Code**: Include the prompt in your CLAUDE.md file.

<CodeGroup>
  typescript
  // src/api/client.ts
  import Coingecko from '@coingecko/coingecko-typescript';

// Initialize a single, reusable client. This should be imported and used application-wide.
  export const client = new Coingecko({
    proAPIKey: process.env.COINGECKO_PRO_API_KEY,
    environment: 'pro',
    maxRetries: 3, // Rely on the SDK's built-in retry mechanism.
  });

// src/main.ts
  import { client } from './api/client';
  import Coingecko from '@coingecko/coingecko-typescript'; // Import the namespace for types

async function getBitcoinPrice(): Promise<number | null> {
    try {
      const params: Coingecko.Simple.PriceGetParams = {
        ids: 'bitcoin',
        vs_currencies: 'usd',
      };
      const priceData = await client.simple.price.get(params);
      return priceData.bitcoin.usd;
    } catch (err) {
      if (err instanceof Coingecko.RateLimitError) {
        console.error('Rate limit exceeded. Please try again later.');
      } else if (err instanceof Coingecko.APIError) {
        console.error(
          `An API error occurred: ${err.name} (Status: ${err.status})`
        );
      } else {
        console.error('An unexpected error occurred:', err);
      }
      return null;
    }
  }

async function main() {
    const price = await getBitcoinPrice();
    if (price !== null) {
      console.log(`The current price of Bitcoin is: $${price}`);
    }
  }

main();
  typescript
  // ❌ NO direct HTTP requests with fetch or axios.
  import axios from 'axios';
  const response = await axios.get(
    '[https://api.coingecko.com/api/v3/simple/price?ids=bitcoin&vs_currencies=usd](https://api.coingecko.com/api/v3/simple/price?ids=bitcoin&vs_currencies=usd)'
  );

// ❌ NO hardcoded API keys.
  const client = new Coingecko({ proAPIKey: 'CG-abc123xyz789' });

// ❌ NO manual retry loops. The SDK's `maxRetries` handles this.
  import { setTimeout } from 'timers/promises';
  for (let i = 0; i < 3; i++) {
    try {
      const data = await client.simple.price.get({
        ids: 'bitcoin',
        vs_currencies: 'usd',
      });
      break;
    } catch (e) {
      await setTimeout(5000);
    }
  }

// ❌ NO generic exception handling for API errors.
  try {
    const data = await client.simple.price.get({
      ids: 'bitcoin',
      vs_currencies: 'usd',
    });
  } catch (e) {
    console.log(`An error occurred: ${e}`); // Too broad. Use `instanceof` checks.
  }
  `
</CodeGroup>

* **GitHub**: [github.com/coingecko/coingecko-typescript](https://github.com/coingecko/coingecko-typescript)
* **npm**: [npmjs.com/package/@coingecko/coingecko-typescript](https://www.npmjs.com/package/@coingecko/coingecko-typescript)

Notice something off or missing? Let us know by opening an [Issue here](https://github.com/coingecko/coingecko-typescript/issues).

Have feedback, a cool idea, or need help? Reach out to `soonaik@coingecko[dot]com`

**Examples:**

Example 1 (typescript):
```typescript
// src/api/client.ts
  import Coingecko from '@coingecko/coingecko-typescript';

  // Initialize a single, reusable client. This should be imported and used application-wide.
  export const client = new Coingecko({
    proAPIKey: process.env.COINGECKO_PRO_API_KEY,
    environment: 'pro',
    maxRetries: 3, // Rely on the SDK's built-in retry mechanism.
  });

  // src/main.ts
  import { client } from './api/client';
  import Coingecko from '@coingecko/coingecko-typescript'; // Import the namespace for types

  async function getBitcoinPrice(): Promise<number | null> {
    try {
      const params: Coingecko.Simple.PriceGetParams = {
        ids: 'bitcoin',
        vs_currencies: 'usd',
      };
      const priceData = await client.simple.price.get(params);
      return priceData.bitcoin.usd;
    } catch (err) {
      if (err instanceof Coingecko.RateLimitError) {
        console.error('Rate limit exceeded. Please try again later.');
      } else if (err instanceof Coingecko.APIError) {
        console.error(
          `An API error occurred: ${err.name} (Status: ${err.status})`
        );
      } else {
        console.error('An unexpected error occurred:', err);
      }
      return null;
    }
  }

  async function main() {
    const price = await getBitcoinPrice();
    if (price !== null) {
      console.log(`The current price of Bitcoin is: $${price}`);
    }
  }

  main();
```

Example 2 (typescript):
```typescript
// ❌ NO direct HTTP requests with fetch or axios.
  import axios from 'axios';
  const response = await axios.get(
    '[https://api.coingecko.com/api/v3/simple/price?ids=bitcoin&vs_currencies=usd](https://api.coingecko.com/api/v3/simple/price?ids=bitcoin&vs_currencies=usd)'
  );

  // ❌ NO hardcoded API keys.
  const client = new Coingecko({ proAPIKey: 'CG-abc123xyz789' });

  // ❌ NO manual retry loops. The SDK's `maxRetries` handles this.
  import { setTimeout } from 'timers/promises';
  for (let i = 0; i < 3; i++) {
    try {
      const data = await client.simple.price.get({
        ids: 'bitcoin',
        vs_currencies: 'usd',
      });
      break;
    } catch (e) {
      await setTimeout(5000);
    }
  }

  // ❌ NO generic exception handling for API errors.
  try {
    const data = await client.simple.price.get({
      ids: 'bitcoin',
      vs_currencies: 'usd',
    });
  } catch (e) {
    console.log(`An error occurred: ${e}`); // Too broad. Use `instanceof` checks.
  }
```

---

## Best Practices

**URL:** llms-txt#best-practices

**Contents:**
- User Journey for CoinGecko API Endpoints
  - "Discovery/Navigational Endpoints"
  - "Supporting Endpoints"
  - "Data Endpoints"
- User Journey for Onchain DEX API Endpoints (GeckoTerminal data)
  - "Discovery/Navigational Endpoints"
  - "Supporting Endpoints"
  - "Data Endpoints"

Source: https://docs.coingecko.com/docs/best-practices

Wonder how to use different endpoints together? This is the perfect place for you

## User Journey for CoinGecko API Endpoints

<img src="https://mintcdn.com/coingecko/a7cplMjqO5fc2v5e/images/docs/60fecdf-image.png?fit=max&auto=format&n=a7cplMjqO5fc2v5e&q=85&s=509cde2f1085a0102c86f391db0837b1" alt="" data-og-width="1328" width="1328" data-og-height="710" height="710" data-path="images/docs/60fecdf-image.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/coingecko/a7cplMjqO5fc2v5e/images/docs/60fecdf-image.png?w=280&fit=max&auto=format&n=a7cplMjqO5fc2v5e&q=85&s=5ea5fec3760a2bfb5c33277e3511479f 280w, https://mintcdn.com/coingecko/a7cplMjqO5fc2v5e/images/docs/60fecdf-image.png?w=560&fit=max&auto=format&n=a7cplMjqO5fc2v5e&q=85&s=5f926c131c7bb67afb13f89d3ec5e942 560w, https://mintcdn.com/coingecko/a7cplMjqO5fc2v5e/images/docs/60fecdf-image.png?w=840&fit=max&auto=format&n=a7cplMjqO5fc2v5e&q=85&s=574e6d149e5fa962e8f7a3bfe0f5371b 840w, https://mintcdn.com/coingecko/a7cplMjqO5fc2v5e/images/docs/60fecdf-image.png?w=1100&fit=max&auto=format&n=a7cplMjqO5fc2v5e&q=85&s=7a78b8790c86a92040eabf432a6cd64b 1100w, https://mintcdn.com/coingecko/a7cplMjqO5fc2v5e/images/docs/60fecdf-image.png?w=1650&fit=max&auto=format&n=a7cplMjqO5fc2v5e&q=85&s=885633eb663ed8e54827a45a74e67ab8 1650w, https://mintcdn.com/coingecko/a7cplMjqO5fc2v5e/images/docs/60fecdf-image.png?w=2500&fit=max&auto=format&n=a7cplMjqO5fc2v5e&q=85&s=f3051a393bcc6c0ff6a3dee44ec89ac7 2500w" />

### "Discovery/Navigational Endpoints"

* [/coins/list](/reference/coins-list) — can be used to query all the supported coins on CoinGecko with names, symbols and coin IDs that can be used in other endpoints.
* [/search/trending](/reference/trending-search) — can be used to query trending search coins, categories and NFTs on CoinGecko.

### "Supporting Endpoints"

* [/simple/supported\_vs\_currencies](/reference/simple-supported-currencies) — can be used to query the list of currencies for other endpoints that include parameters like `vs_currencies`, allowing to obtain the corresponding data for those currencies.
* [/asset\_platforms](/reference/asset-platforms-list) — can be used to query the list of asset platforms for other endpoints that contain parameters like `id` or `ids` (asset platforms), allowing the retrieval of corresponding data for these asset platforms.

* [/simple/price](/reference/simple-price) — can be used to query the prices of coins using the unique coin IDs that can be obtained from the "Discovery/Navigational Endpoints" mentioned above.
* [/coins/\{id}](/reference/coins-id) — can be used to query the coin data using the unique coin IDs that can be obtained from the "Discovery/Navigational Endpoints" mentioned above.

## User Journey for Onchain DEX API Endpoints (GeckoTerminal data)

<img src="https://mintcdn.com/coingecko/a7cplMjqO5fc2v5e/images/docs/fc38fa8-image.png?fit=max&auto=format&n=a7cplMjqO5fc2v5e&q=85&s=011c5c6d5cb8ff880eb957e528c57891" alt="" data-og-width="1328" width="1328" data-og-height="544" height="544" data-path="images/docs/fc38fa8-image.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/coingecko/a7cplMjqO5fc2v5e/images/docs/fc38fa8-image.png?w=280&fit=max&auto=format&n=a7cplMjqO5fc2v5e&q=85&s=5ec52efdba31f801866c7c7bd041eafd 280w, https://mintcdn.com/coingecko/a7cplMjqO5fc2v5e/images/docs/fc38fa8-image.png?w=560&fit=max&auto=format&n=a7cplMjqO5fc2v5e&q=85&s=fd4e8526d2c0eb8347aa54eca4ed4289 560w, https://mintcdn.com/coingecko/a7cplMjqO5fc2v5e/images/docs/fc38fa8-image.png?w=840&fit=max&auto=format&n=a7cplMjqO5fc2v5e&q=85&s=6f2af440ec46cd89576b60c00f532ea1 840w, https://mintcdn.com/coingecko/a7cplMjqO5fc2v5e/images/docs/fc38fa8-image.png?w=1100&fit=max&auto=format&n=a7cplMjqO5fc2v5e&q=85&s=c8e9cb77c67cf34a1cbb3ad7d99dbe84 1100w, https://mintcdn.com/coingecko/a7cplMjqO5fc2v5e/images/docs/fc38fa8-image.png?w=1650&fit=max&auto=format&n=a7cplMjqO5fc2v5e&q=85&s=5e7bcc911db7af9296a5782886417ddf 1650w, https://mintcdn.com/coingecko/a7cplMjqO5fc2v5e/images/docs/fc38fa8-image.png?w=2500&fit=max&auto=format&n=a7cplMjqO5fc2v5e&q=85&s=62e234622a2ec45e8575c14c0532c6f4 2500w" />

### "Discovery/Navigational Endpoints"

* [/onchain/trending\_pools](/reference/trending-pools-list) - can be used to query trending pools across all networks on GeckoTerminal.
* [/onchain/search/pools](/reference/search-pools) - can be used to search for any pools on GeckoTerminal.

### "Supporting Endpoints"

* [/onchain/networks-list](/reference/networks-list) - can be used to query all the supported networks on GeckoTerminal.
* [/onchain/networks/\{network}/dexes](/reference/dexes-list) - can be used to query all the supported decentralized exchanges (DEXs/`dexes`) on GeckoTerminal based on network id that can be obtained from the endpoint mentioned above.

* [/onchain/simple/networks/\{network}/token\_price/\{addresses}](/reference/onchain-simple-price) - can be used to query any token price using the token address and network id that can be obtained from the "Discovery/Navigational Endpoints" and "Supporting Endpoints" mentioned above.
* [/onchain/networks/\{network}/pools/\{address}](/reference/pool-address) - can be used to query the data of a specific pool based on the pool address and network id that can be obtained from the "Discovery/Navigational Endpoints" and "Supporting Endpoints" mentioned above.

---

## ⚙️ Tips

**URL:** llms-txt#⚙️-tips

**Contents:**
- API Key Differences (Demo vs. Pro)
- Dynamic vs. Static Tools
- Using `llms.txt`

## API Key Differences (Demo vs. Pro)

Choosing between a Demo and Pro key for your MCP server impacts your access to data and tools.

| Feature             | Demo ([Guide here](https://support.coingecko.com/hc/en-us/articles/21880397454233-User-Guide-How-to-sign-up-for-CoinGecko-Demo-API-and-generate-an-API-key)) | Pro                                                                                                                                                                                                                                                                                                          |
| ------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ |
| **Rate Limit**      | 30 calls/min                                                                                                                                                 | Starts at 500 calls/min                                                                                                                                                                                                                                                                                      |
| **Monthly Credits** | 10,000                                                                                                                                                       | Starts at 500,000                                                                                                                                                                                                                                                                                            |
| **Historical Data** | Past 1 year                                                                                                                                                  | From 2013 until now                                                                                                                                                                                                                                                                                          |
| **MCP Tools**       | Limited access                                                                                                                                               | Full access, including exclusive tools:<br />- [Top Gainers & Losers](/reference/coins-top-gainers-losers)<br />- [NFTs Collection Historical Chart](/reference/nfts-id-market-chart)<br />- [🔥 Megafilter for Pools](/reference/pools-megafilter)<br />- [Pools by Category ID](/reference/pools-category) |

🔥 Ready to upgrade? Explore [our API plans](https://www.coingecko.com/en/api/pricing).

## Dynamic vs. Static Tools

When running our CoinGecko MCP server, you can choose how the LLM client discovers tools.

* **Static (Default)**: The AI is given a complete list of tools and their functions upfront. This is faster for specific, known tasks.
* **Dynamic**: The AI first asks the server for available tools based on a keyword search, then learns how to use them. This is flexible but can be slower.

For a deeper dive, read the [official documentation](https://www.stainless.com/changelog/mcp-dynamic-tools) from Stainless.

To help AI models interact with CoinGecko data effectively, we provide an `llms.txt` file at [/llms-full.txt](/llms-full.txt). This file gives models context on how to best query our API, ensuring more accurate and efficient data retrieval. We recommend utilizing this in your integrations.

CoinGecko MCP Server is powered by [Stainless](https://www.stainless.com/) ✱

Have feedback, a cool idea, or need help? Reach out to `soonaik@coingecko[dot]com` or fill in [this feedback form](https://docs.google.com/forms/d/e/1FAIpQLSf06DOBauiZ8XS6NwWXUUwhFluH7jKHOAa3y4VsrkyGbLKyfA/viewform).

---

## 🚀 Connecting with Claude

**URL:** llms-txt#🚀-connecting-with-claude

**Contents:**
- For Claude Free Users (via Claude Desktop)
- For Claude Pro Users

Connecting CoinGecko MCP to Claude is straightforward. The method varies slightly depending on your Claude plan.

## For Claude Free Users (via Claude Desktop)

You **must use the Claude Desktop app** and modify the configuration file.

1. **Locate`claude_desktop_config.json`**: Follow the instructions [here](https://modelcontextprotocol.io/quickstart/user) to find the file on your system.
2. **Add a server config**: Copy and paste one of the server configs above that matches your use case.
3. **Restart Claude Desktop**: Close and reopen the app for the changes to take effect.

## For Claude Pro Users

You can also follow the same steps as the Free users by modifying the `claude_desktop_config.json` file.
</Check>

1. In Claude ([claude.ai](https://claude.ai/) or the Desktop app), click on 'Add connectors' in your chat.

<img src="https://mintcdn.com/coingecko/b3Fla9Sm0TsVrJN4/images/reference/5cd6a58-image.png?fit=max&auto=format&n=b3Fla9Sm0TsVrJN4&q=85&s=73013011cc734857c113270206f71e7b" alt="" data-og-width="1606" width="1606" data-og-height="1122" height="1122" data-path="images/reference/5cd6a58-image.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/coingecko/b3Fla9Sm0TsVrJN4/images/reference/5cd6a58-image.png?w=280&fit=max&auto=format&n=b3Fla9Sm0TsVrJN4&q=85&s=e6833e4c3da93dedaec0f9ee341c0ea7 280w, https://mintcdn.com/coingecko/b3Fla9Sm0TsVrJN4/images/reference/5cd6a58-image.png?w=560&fit=max&auto=format&n=b3Fla9Sm0TsVrJN4&q=85&s=f3176360bc6ddb6195743bcd82cd80ed 560w, https://mintcdn.com/coingecko/b3Fla9Sm0TsVrJN4/images/reference/5cd6a58-image.png?w=840&fit=max&auto=format&n=b3Fla9Sm0TsVrJN4&q=85&s=900afa23a6af477b66b2fc58d1108a14 840w, https://mintcdn.com/coingecko/b3Fla9Sm0TsVrJN4/images/reference/5cd6a58-image.png?w=1100&fit=max&auto=format&n=b3Fla9Sm0TsVrJN4&q=85&s=2a6dbc4be6a8d688e0d037c7ee1ec418 1100w, https://mintcdn.com/coingecko/b3Fla9Sm0TsVrJN4/images/reference/5cd6a58-image.png?w=1650&fit=max&auto=format&n=b3Fla9Sm0TsVrJN4&q=85&s=75dbaec8d5e3d998870e7e07f77b0c51 1650w, https://mintcdn.com/coingecko/b3Fla9Sm0TsVrJN4/images/reference/5cd6a58-image.png?w=2500&fit=max&auto=format&n=b3Fla9Sm0TsVrJN4&q=85&s=c27022d416fe6df622e6f0ac386fea0a 2500w" />

2. Click on 'Add custom connector'

<img src="https://mintcdn.com/coingecko/b3Fla9Sm0TsVrJN4/images/reference/1459ea5-image.png?fit=max&auto=format&n=b3Fla9Sm0TsVrJN4&q=85&s=63c2c7bc4254c52ba263b9617aae51bd" alt="" data-og-width="1843" width="1843" data-og-height="988" height="988" data-path="images/reference/1459ea5-image.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/coingecko/b3Fla9Sm0TsVrJN4/images/reference/1459ea5-image.png?w=280&fit=max&auto=format&n=b3Fla9Sm0TsVrJN4&q=85&s=488051a2a6574be78e62eebf533b7ba9 280w, https://mintcdn.com/coingecko/b3Fla9Sm0TsVrJN4/images/reference/1459ea5-image.png?w=560&fit=max&auto=format&n=b3Fla9Sm0TsVrJN4&q=85&s=0a2dc2058e55364193572e1c5a9162a8 560w, https://mintcdn.com/coingecko/b3Fla9Sm0TsVrJN4/images/reference/1459ea5-image.png?w=840&fit=max&auto=format&n=b3Fla9Sm0TsVrJN4&q=85&s=85d55bb6a7cd9c4ae2b02abce971c344 840w, https://mintcdn.com/coingecko/b3Fla9Sm0TsVrJN4/images/reference/1459ea5-image.png?w=1100&fit=max&auto=format&n=b3Fla9Sm0TsVrJN4&q=85&s=c04b37491fcfc8454d43ccc56dc2cde4 1100w, https://mintcdn.com/coingecko/b3Fla9Sm0TsVrJN4/images/reference/1459ea5-image.png?w=1650&fit=max&auto=format&n=b3Fla9Sm0TsVrJN4&q=85&s=6386434cc86f48afd82a283e676ad6f9 1650w, https://mintcdn.com/coingecko/b3Fla9Sm0TsVrJN4/images/reference/1459ea5-image.png?w=2500&fit=max&auto=format&n=b3Fla9Sm0TsVrJN4&q=85&s=ab805d6c5f0c8745b99a2497eed3074d 2500w" />

3. Remote MCP server URL:

* Keyless access: `https://mcp.api.coingecko.com/mcp`
   * Authenticated access (BYOK): `https://mcp.pro-api.coingecko.com/mcp`

<img src="https://mintcdn.com/coingecko/b3Fla9Sm0TsVrJN4/images/reference/b465d51-image.png?fit=max&auto=format&n=b3Fla9Sm0TsVrJN4&q=85&s=075452b45aa6696f046084f5a23d610b" alt="" data-og-width="1146" width="1146" data-og-height="899" height="899" data-path="images/reference/b465d51-image.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/coingecko/b3Fla9Sm0TsVrJN4/images/reference/b465d51-image.png?w=280&fit=max&auto=format&n=b3Fla9Sm0TsVrJN4&q=85&s=ac7d12f41f9375d1b13e6ddee2d2617c 280w, https://mintcdn.com/coingecko/b3Fla9Sm0TsVrJN4/images/reference/b465d51-image.png?w=560&fit=max&auto=format&n=b3Fla9Sm0TsVrJN4&q=85&s=145c9550a2097b66c3aea388d63f8489 560w, https://mintcdn.com/coingecko/b3Fla9Sm0TsVrJN4/images/reference/b465d51-image.png?w=840&fit=max&auto=format&n=b3Fla9Sm0TsVrJN4&q=85&s=b2c2f85d97c0c320e83045c31dbcfd51 840w, https://mintcdn.com/coingecko/b3Fla9Sm0TsVrJN4/images/reference/b465d51-image.png?w=1100&fit=max&auto=format&n=b3Fla9Sm0TsVrJN4&q=85&s=0914181d22bbe3d687c452b6be3649f2 1100w, https://mintcdn.com/coingecko/b3Fla9Sm0TsVrJN4/images/reference/b465d51-image.png?w=1650&fit=max&auto=format&n=b3Fla9Sm0TsVrJN4&q=85&s=5c7df15af6e89de35ebf07bb186c6332 1650w, https://mintcdn.com/coingecko/b3Fla9Sm0TsVrJN4/images/reference/b465d51-image.png?w=2500&fit=max&auto=format&n=b3Fla9Sm0TsVrJN4&q=85&s=43c552ceb2c3604b16b2018e3dca319c 2500w" />

4. Click on 'Add', and you're ready to go!

---

## Useful Links

**URL:** llms-txt#useful-links

Source: https://docs.coingecko.com/docs/useful-links

Some of the useful links to help you navigate while using the CoinGecko API

#### Pricing Page and Top FAQs

* [https://www.coingecko.com/en/api/pricing#general](https://www.coingecko.com/en/api/pricing#general)

#### CoinGecko API Status

* [https://status.coingecko.com/](https://status.coingecko.com/)

#### CoinGecko API ID List

* [Google Sheets](https://docs.google.com/spreadsheets/d/1wTTuxXt8n9q7C4NDXqQpI3wpKu1_5bGVmP9Xz0XGSyU)

#### [Pro Swagger JSON (OAS)](https://docs.coingecko.com/reference/endpoint-overview)

* CoinGecko Pro API — [coingecko-pro.json](https://raw.githubusercontent.com/coingecko/coingecko-api-oas/refs/heads/main/coingecko-pro.json)
* GeckoTerminal Onchain API (Pro) — [onchain-pro.json](https://raw.githubusercontent.com/coingecko/coingecko-api-oas/refs/heads/main/onchain-pro.json)

#### [Public/Demo Swagger JSON (OAS)](https://docs.coingecko.com/v3.0.1/reference/endpoint-overview)

* CoinGecko Public/Demo API — [coingecko-demo.json](https://raw.githubusercontent.com/coingecko/coingecko-api-oas/refs/heads/main/coingecko-demo.json)
* GeckoTerminal Onchain API (Demo) — [onchain-demo.json](https://raw.githubusercontent.com/coingecko/coingecko-api-oas/refs/heads/main/onchain-demo.json)

#### Subscribe CoinGecko API newsletter update

* [https://newsletter.coingecko.com/landing/api\_updates\_subscribe](https://newsletter.coingecko.com/landing/api_updates_subscribe)

#### CoinGecko Methodologies (Price, Volume, Trust Score, etc.)

* [https://www.coingecko.com/en/methodology](https://www.coingecko.com/en/methodology)

#### Using `llms.txt` for AI use cases

* [/llms-full.txt](/llms-full.txt)

#### Attributing CoinGecko Brand

* [https://brand.coingecko.com/resources/attribution-guide](https://brand.coingecko.com/resources/attribution-guide)

---

## Changelog

**URL:** llms-txt#changelog

Source: https://docs.coingecko.com/changelog

Product updates and announcements

export const GreenSeparator = () => (
  <div style={{
    height: '4px',
    background: 'linear-gradient(to right, transparent, #4BCC00, transparent)',
    margin: '20px 0 60px 0',
    border: 'none'
  }} />
);

<Update label="October 2025">
  ## Websocket is now supported for Self-serve API subscribers

🗓️ **October 23, 2025**

### CoinGecko Websocket (Beta) is now available for [paid plan](https://www.coingecko.com/en/api/pricing) customers (Analyst plan & above)!

For Analyst, Lite, Pro, and Pro+ self-serve customers, you are now eligible to access the following Websocket features, and stream real-time data by utilising your monthly API plan credits:

* Max connections: 10 concurrent socket connections
  * Max subscriptions: 100 token or pool data subscription per channel, per socket
  * Channel Access: [all 4 channels](https://docs.coingecko.com/websocket#channel-%26-data-support)
  * Credit charge: **0.1** credit per response returned, deducting from monthly API plan credits

Please visit [Websocket](https://docs.coingecko.com/websocket) for full details, and test out Websocket data streaming. We will gradually improve the Websocket and expand the feature limits. Please share your feedback and suggestion via this [**survey form**](https://forms.gle/gNE1Txc9FCV55s7ZA), or email soonaik\@coingecko\[dot]com .

### Notice: Temporary Disruption on MagicEden data for NFT Endpoints

Due to recent updates to MagicEden's API, we are updating our integration. During this period, endpoints for NFT data may be temporarily unavailable or return incomplete information.

## More Bonding Curve Support and New Ascending Sort for Megafilter

🗓️ **October 4, 2025**

### Now supported Bonding Curve (non-graduated) Data for More Endpoints

We've added support for bonding curve (e.g. launchpad graduation from PumpFun) data across multiple token endpoints:

* [Token Data by Token Address](/reference/token-data-contract-address) — `/onchain/networks/{network}/tokens/{address}`
  * [Tokens Data by Token Addresses](/reference/tokens-data-contract-addresses) — `/onchain/networks/{network}/tokens/multi/{addresses}`
  * [Token Info by Token Address](/reference/token-info-contract-address) — `/onchain/networks/{network}/tokens/{address}/info`
  * [Pool Tokens Info by Pool Address](/reference/pool-token-info-contract-address) — `/onchain/networks/{network}/pools/{pool_address}/info`

### Megafilter: Ascending Sort Order for Price Change %

The [Megafilter for Pools](/reference/pools-megafilter) endpoint now supports ascending sorting for price change percentage:

* `m5_price_change_percentage_asc`
  * `h1_price_change_percentage_asc`
  * `h6_price_change_percentage_asc`
  * `h24_price_change_percentage_asc`

### Token OHLCV Endpoint Fix to respect Specified Token Address

We've fixed an issue where the [Token OHLCV chart by Token Address](/reference/token-ohlcv-token-address) endpoint returned data for the base token of the top pool instead of the requested token. It will now always return data for the specified token address.
</Update>

<Update label="September 2025">
  ## SDK Gains Public Treasury Coverage, MCP Adds Exchanges, NFTs, and ISO Support

🗓️ **September 25, 2025**

### Expanded SDK Coverage for Public Treasuries

We're broadening our SDK coverage to make treasury-level insights more powerful and easier to access. Check out what's new below (with functions from [our TypeScript SDK](https://github.com/coingecko/coingecko-typescript))

* [`publicTreasury.getCoinID(coinID, { ...params })`](https://github.com/coingecko/coingecko-typescript/blob/main/api.md#publictreasury) \
    to query public companies & governments' cryptocurrency holdings by Coin ID
  * [`publicTreasury.getEntityID(entityID)`](https://github.com/coingecko/coingecko-typescript/blob/main/api.md#publictreasury) \
    to query public companies & governments' cryptocurrency holdings by Entity ID
  * [`entities.getList({ ...params })`](https://github.com/coingecko/coingecko-typescript/blob/main/api.md#entities) \
    to query all the supported entities on CoinGecko with entities ID, name, symbol, and country

### New MCP Tools: Exchanges, NFTs & Multi-Address Queries

We're also surfacing new tools through the MCP to give developers a richer, faster way to query exchanges, NFTs, and onchain activity.

* New tools:
    * Exchange coverage with [/exchanges/list](reference/exchanges-list), [/exchanges/](reference/exchanges-id), [/exchanges//tickers](reference/exchanges-id-tickers), and [/exchanges//volume\_chart/range](reference/exchanges-id-volume-chart-range)
    * NFT markets with [/nfts/markets](reference/nfts-markets)
    * Multi-address queries with [/onchain/networks//pools/multi/](reference/pools-addresses) and [/onchain/networks//tokens/multi/](reference/tokens-data-contract-addresses)
  * Retired tools:
    * We've removed endpoints such as [/coins/list](reference/coins-list), [/onchain/networks/trending\_pools](reference/trending-pools-network), and single-address pool/token queries in favor of more scalable multi-address endpoints

### Friendlier Time-related MCP Queries with ISO Support

Time-based queries just got easier. MCP tools now accept **ISO date strings** (`YYYY-MM-DD` or `YYYY-MM-DDTHH:MM`) alongside UNIX timestamps.

For example, when using the [Coin Historical Chart Data within Time Range](reference/coins-id-market-chart-range) tool, you can now pass ISO date strings directly instead of converting them into UNIX timestamps for your LLM tools.

**CoinGecko API Team**

## New Crypto Treasury Endpoints and Improvements

🗓️ **September 19, 2025**

1. [Crypto Treasury Holdings by Coin ID](https://docs.coingecko.com/reference/companies-public-treasury) endpoint now supports governments and more coins data as seen on [https://www.coingecko.com/en/treasuries/bitcoin](https://www.coingecko.com/en/treasuries/bitcoin)
  2. **New endpoints:**
     1. [Crypto Treasury Holdings by Entity ID](https://docs.coingecko.com/reference/public-treasury-entity)
     2. [Entities List (ID Map)](https://docs.coingecko.com/reference/entities-list)
  3. [Derivatives Exchange Data by ID](https://docs.coingecko.com/reference/derivatives-exchanges-id) endpoint now supports `coin_id` and `target_coin_id` to identify coins of ticker pairs.

## Multiple Improvements: Bonding Curve Data, Pooled Token Balance, and More.

🗓️ **September 12, 2025**

### 🚀 Now Supporting Bonding Curve Data

Bonding curve data (launchpad graduation) is now supported for the followiing endpoints:

* [Specific Pool Data by Pool Address](https://docs.coingecko.com/reference/pool-address)
  * [Multiple Pools Data by Pool Addresses](https://docs.coingecko.com/reference/pools-addresses)

More endpoints to support bonding curve data soon.

### 🚀 Now Supporting Pooled Token Balance Data

The following endpoints now support additional pool token balance data by flagging this parameter `include_composition=true` :

* [Specific Pool Data by Pool Address](https://docs.coingecko.com/reference/pool-address)
  * [Multiple Pools Data by Pool Addresses](https://docs.coingecko.com/reference/pools-addresses)
  * [Token Data by Token Address](https://docs.coingecko.com/reference/token-data-contract-address) (requires `include=top_pools` parameter to be flagged together)
  * [Tokens Data by Token Addresses](https://docs.coingecko.com/reference/tokens-data-contract-addresses) (requires `include=top_pools` parameter to be flagged together)

### 🚀 Other improvements

1. [Onchain Megafilter](https://docs.coingecko.com/reference/pools-megafilter) endpoint now supports more `sort` options:
     * `m5_price_change_percentage_desc`
     * `h1_price_change_percentage_desc`
     * `h6_price_change_percentage_desc`
     * `fdv_usd_asc`
     * `fdv_usd_desc`
     * `reserve_in_usd_asc`
     * `reserve_in_usd_desc`
  2. [Top Gainers & Losers](https://docs.coingecko.com/reference/coins-top-gainers-losers) endpoint now supports additional price change percentage data by flagging `price_change_percentage` parameter. The available options are: `1h,24h,7d,14d,30d,60d,200d,1y`.
     * Payload example:

3. [Exchange Tickers by ID](https://docs.coingecko.com/reference/exchanges-id-tickers) endpoint now supports to sort tickers based on market cap, by flagging the `order` parameter.
     * Available options: `market_cap_desc`, `market_cap_asc`
</Update>

<Update label="August 2025">
  ## Improved Update Frequency for selected Pro-API On-chain Endpoints

🗓️ **August 18, 2025**

\[Changes below are applicable to all [paid plan subscribers](https://www.coingecko.com/en/api/pricing).]

Dear CoinGecko API paid plan subscribers,

We're excited to announce an improvement to our API, aimed at providing you with even faster access to real-time data! Starting **02:00 UTC, September 2, 2025**, the edge cache duration for the following endpoints will be reduced from \*\*30s \*\*to **10s**, allowing you to retrieve updated data more frequently.

| Endpoints                                                                                                    | Effective Date & Time                   | Current Update Frequency | New Update Frequency |
  | :----------------------------------------------------------------------------------------------------------- | :-------------------------------------- | :----------------------- | :------------------- |
  | [Token Price by Token Addresses](https://docs.coingecko.com/reference/onchain-simple-price)                  | Tuesday, 02:00 UTC, September 2, 2025   | 30s                      | 10s                  |
  | [Token Data by Token Address](https://docs.coingecko.com/reference/token-data-contract-address)              | Tuesday, 02:00 UTC, September 2, 2025   | 30s                      | 10s                  |
  | [Tokens Data by Token Addresses](https://docs.coingecko.com/reference/tokens-data-contract-addresses)        | Tuesday, 02:00 UTC, September 2, 2025   | 30s                      | 10s                  |
  | [Specific Pool Data by Pool Address](https://docs.coingecko.com/reference/pool-address)                      | Wednesday, 02:00 UTC, September 3, 2025 | 30s                      | 10s                  |
  | [Multiple Pools Data by Pool Addresses](https://docs.coingecko.com/reference/pools-addresses)                | Wednesday, 02:00 UTC, September 3, 2025 | 30s                      | 10s                  |
  | [Pool OHLCV chart by Pool Address](https://docs.coingecko.com/reference/pool-ohlcv-contract-address)         | Thursday, 02:00 UTC, September 4, 2025  | 30s                      | 10s                  |
  | [Token OHLCV chart by Token Address](https://docs.coingecko.com/reference/token-ohlcv-token-address)         | Thursday, 02:00 UTC, September 4, 2025  | 30s                      | 10s                  |
  | [Past 24 Hour Trades by Pool Address](https://docs.coingecko.com/reference/pool-trades-contract-address)     | Thursday, 02:00 UTC, September 4, 2025  | 30s                      | 10s                  |
  | [Past 24 Hour Trades by Token Address](https://docs.coingecko.com/reference/token-trades-contract-address#/) | Thursday, 02:00 UTC, September 4, 2025  | 30s                      | 10s                  |

#### **What This Means for You:**

* **Fresher Data, Quicker**: With a reduced cache time, you'll now have the option to access more up-to-date data, closer to real-time!
  * **No Extra Credits for Cached Data**: If your request hits the cache (now updated every 10 seconds for endpoints above), there will be no additional credits charged - just like before.

**Things to Keep in Mind:**

* If your request hits our origin server instead of the cache to retrieve the latest data, there may be additional credits used.
  * To balance cost and real-time data needs, we recommend reviewing your request frequency. For those who prefer to obtain data without extra credits, consider keeping your request interval at 30 seconds or more to align with the new cache duration.

We're committed to continuously improving your experience and ensuring you get the data you need, as efficiently as possible. If you have any questions or need assistance, feel free to reach out to [soonaik@coingecko.com](mailto:soonaik@coingecko.com) .

**CoinGecko API Team**

## Now Supported: Launchpad Data (Pump.fun & More), Granular OHLCV, and Honeypot Info

🗓️ **August 05, 2025**

We're excited to announce a major update to our on-chain API endpoints! This release introduces support for popular token launchpads, adds high-frequency OHLCV data, and enhances our honeypot detection capabilities to give you deeper and more timely on-chain insights.

### 🚀 Now Supporting Launchpad Data (Pump.fun & More!)

In addition to the 1,600+ DEXes already integrated with GeckoTerminal.com, you can now track token data from popular launchpad platforms directly through the CoinGecko API. More launchpads will be supported soon!

**New Supported Launchpads:**

| Launchpad                                                                                       | network id (API) | dex id (API)      |
  | :---------------------------------------------------------------------------------------------- | :--------------- | :---------------- |
  | [Meteora DBC](https://www.geckoterminal.com/solana/meteora-dbc/pools)                           | solana           | meteora-dbc       |
  | [Pump.fun](https://www.geckoterminal.com/solana/pump-fun/pools)                                 | solana           | pump-fun          |
  | [Raydium Launchpad](https://www.geckoterminal.com/solana/raydium-launchlab/pools) (LetsBonkFun) | solana           | raydium-launchlab |
  | [Boop.fun](https://www.geckoterminal.com/solana/boop-fun/pools)                                 | solana           | boop-fun          |
  | [Virtuals (Base)](https://www.geckoterminal.com/base/virtuals-base/pools)                       | base             | virtuals-base     |

**Improved endpoints to track launchpad data:**

* [Token Data by Token Address](https://docs.coingecko.com/reference/token-data-contract-address)
  * [Tokens Data by Token Addresses](https://docs.coingecko.com/reference/tokens-data-contract-addresses)
  * [Specific Pool Data by Pool Address](https://docs.coingecko.com/reference/pool-address)
  * [Multiple Pools Data by Pool Addresses](https://docs.coingecko.com/reference/pools-addresses)

More launchpad-specific data will be supported soon for the endpoints above!

**Tips:** use [megafilter endpoint](https://docs.coingecko.com/reference/pools-megafilter) to retrieve latest launchpad data, by flagging `sort=pool_created_at_desc`

**Request example** (Get latest pools on Pump.fun):

### \[Pro-API Exclusive] More Granular OHLCV Data

On-chain OHLCV endpoints now support higher frequency intervals, down to 1-second granularity.

| Timeframe | Aggregate (Before) | Aggregate (New) |
  | :-------- | :----------------- | :-------------- |
  | day       | 1                  | 1               |
  | hour      | 1, 4, 12           | 1, 4, 12        |
  | minute    | 1, 5, 15           | 1, 5, 15        |
  | second    | n/a                | 1, 15, 30       |

**Improved Endpoints:**

* [Pool OHLCV chart by Pool Address](https://docs.coingecko.com/reference/pool-ohlcv-contract-address)
  * [Token OHLCV chart by Token Address](https://docs.coingecko.com/reference/token-ohlcv-token-address)

**New interval supported:**

**Example Request (Get the last 100 1-second intervals for a pool on Ethereum):**

### 🍯 Enhanced Honeypot Information

We've expanded our honeypot detection features to provide more comprehensive risk assessment. You can now check if a token is a potential honeypot using the main info endpoints.

**Improved Endpoints:**

* [Token Info by Token Address](https://docs.coingecko.com/reference/token-info-contract-address)
  * [Pool Tokens Info by Pool Address](https://docs.coingecko.com/reference/pool-token-info-contract-address)

### \[Pro-API Exclusive] New Filtering Option in Megafilter

Previously, the[Pools Megafilter](https://docs.coingecko.com/reference/pools-megafilter) endpoint could only show tokens confirmed as ***not*** a honeypot (`checks=no_honeypot`). Now, you can also include tokens where the honeypot status is 'unknown'.

* To use this, set `include_unknown_honeypot_tokens=true`.
  * Important: This parameter only takes effect when `checks=no_honeypot` is also specified in the request.

**Example Request (Get trending pools that are not confirmed honeypots, including those with an unknown status):**

### 📈 Expanded Pool Data

**Endpoint**: [Pool Tokens Info by Pool Address](https://docs.coingecko.com/reference/pool-token-info-contract-address)

By adding `include=pool` to your request on the pool tokens endpoint, you can now retrieve additional context about the pool itself.

* Base and quote token address
  * Sentiment vote percentage (positive and negative)
  * Community suspicious reports count

<Update label="June 2025">
  ## SOL Currency Is Now Supported for CoinGecko Endpoints

We're excited to announce that you can now obtain real-time and historical price & market data for tokens listed on CoinGecko.com, with the option to return data value in **SOL** (Solana) currency.

Note: for dates prior to May 2025, 'SOL' historical data is limited to hourly and daily granularity

#### **Improved endpoints:**

* [Coin Price by IDs](https://docs.coingecko.com/reference/simple-price)
  * [Coin Price by Token Addresses](https://docs.coingecko.com/reference/simple-token-price)
  * [Supported Currencies List](https://docs.coingecko.com/reference/simple-supported-currencies)
  * [Top Gainers & Losers](https://docs.coingecko.com/reference/coins-top-gainers-losers)
  * [Coins List with Market Data](https://docs.coingecko.com/reference/coins-markets)
  * [Coin Data by ID](https://docs.coingecko.com/reference/coins-id)
  * [Coin Historical Data by ID](https://docs.coingecko.com/reference/coins-id-history)
  * [Coin Historical Chart Data by ID](https://docs.coingecko.com/reference/coins-id-market-chart)
  * [Coin Historical Chart Data within Time Range by ID](https://docs.coingecko.com/reference/coins-id-market-chart-range)
  * [Coin OHLC Chart by ID](https://docs.coingecko.com/reference/coins-id-ohlc)
  * [Coin OHLC Chart within Time Range by ID](https://docs.coingecko.com/reference/coins-id-ohlc-range)
  * [Coin Data by Token Address](https://docs.coingecko.com/reference/coins-contract-address)
  * [Coin Historical Chart Data by Token Address](https://docs.coingecko.com/reference/contract-address-market-chart)
  * [Coin Historical Chart Data within Time Range by Token Address](https://docs.coingecko.com/reference/contract-address-market-chart-range)
  * [Trending Search List](https://docs.coingecko.com/reference/trending-search)
  * [Crypto Global Market Data](https://docs.coingecko.com/reference/crypto-global)

**Example**: price of Bitcoin in Solana, using [Coin Price by IDs](https://docs.coingecko.com/reference/simple-price) endpoint.

**Example:** historical daily price, market cap and volume of Trump in Solana, using [Coin Historical Chart Data by ID](https://docs.coingecko.com/reference/coins-id-market-chart) endpoint.

## New Endpoints & Improvements: Historical Token Holders Chart, OHLCV by Token Address, Multi-pool Token Data Support

### \[Pro-API Exclusive] New Endpoint  - Historical Token Holders Chart by Token Address

This new endpoint allows you to get the historical token holders chart based on the provided token contract address on a network.

* Supported chains include: Solana, EVM (Ethereum, Polygon, BNB, Arbitrum, Optimism, Base), Sui, TON, and Ronin.

Check it out now: [Historical Token Holders Chart by Token Address](https://docs.coingecko.com/reference/token-holders-chart-token-address)

### \[Pro-API Exclusive] New Endpoint  - Token OHLCV chart by Token Address

This endpoint allows you to get the OHLCV chart (Open, High, Low, Close, Volume) of a token based on the provided token address on a network.

* This endpoint will return OHLCV data of the most liquid pool of the specified token. You may use this endpoint Top Pools by Token Address to check the top pools of a token.

Check it out now: [Token OHLCV chart by Token Address](https://docs.coingecko.com/reference/token-ohlcv-token-address#/)

### Improved Endpoints - Support Multi-pool Token Data

Previously, we only surfaced 1 quote token for pools with more than 2 tokens.  With this new improvements, for pools that have 2 or more tokens:

* Extra quote tokens being listed under a new key `relationships.quote_tokens`
  * If `include=quote_token` is flagged, the extra quote tokens will be also listed under `included`

This improvement is applicable to all onchain pool endpoints that support `relationships.quote_token`, including but not limited to:

* [Top Pools by Token Address](https://docs.coingecko.com/reference/top-pools-contract-address#/)
  * [Search Pools](https://docs.coingecko.com/reference/search-pools#/)
  * [Megafilter for Pools](https://docs.coingecko.com/reference/pools-megafilter#/)
  * [Trending Pools List](https://docs.coingecko.com/reference/trending-pools-list#/)
  * [Specific Pool Data by Pool Address](https://docs.coingecko.com/reference/pool-address#/)
  * [Top Pools by Network](https://docs.coingecko.com/reference/top-pools-network#/)
  * [New Pools List](https://docs.coingecko.com/reference/latest-pools-list#/)
</Update>

<Update label="May 2025">
  ## Upcoming Change Notice: Removal of normalized\_volume\_btc Data

**`Notice: Upcoming Change to CoinGecko API Endpoints - Removal ofnormalized_volume_btc Data`**

**Effective Date: 16 June 2025**

**Affected Endpoints:**

* [Exchange Data by ID](https://docs.coingecko.com/reference/exchanges-id)
  * [Exchanges List with Data](https://docs.coingecko.com/reference/exchanges#/)

**Details of the Change:**

Please be advised that the `normalized_volume_btc` data point will be removed from the above-listed API endpoints, effective 16 June 2025. This change is being implemented due to significant recent change to a 3rd party data source provider, which have fundamentally altered how this specific data can be accessed.

Example of Affected Data Structure:

After the effective date, the `trade_volume_24h_btc_normalized` field will no longer be present in the API responses for these endpoints.

If your applications or integrations currently rely on the `trade_volume_24h_btc_normalized` data from these CoinGecko API endpoints, please make the necessary adjustments to your code before 16 June 2025 to avoid potential errors or data discrepancies.

## New Endpoint & Improvements: On-Chain Trades, Net Buy Volume, and More

### \[Pro-API Exclusive] New Endpoint  - On-chain Trades by Token Address

Previously, the [Past 24 Hour Trades by Pool Address](https://docs.coingecko.com/reference/pool-trades-contract-address) endpoint allows you to retrieve the last 300 trades of a specific pool only.

With this new endpoint [Past 24 Hour Trades by Token Address](https://docs.coingecko.com/reference/token-trades-contract-address), you can now retrieve the last 300 trades **across different pools**, based on the provided **token contract address** on a network.

### Improved Endpoints - Support Net Buy Volume Data

The following endpoints now support more volume breakdown data:

* [Specific Pool Data by Pool Address](https://docs.coingecko.com/reference/pool-address)
  * [Multiple Pools Data by Pool Addresses](https://docs.coingecko.com/reference/pools-addresses#/)

By flagging `include_volume_breakdown=true` , you can surface the following data:

* net\_buy\_volume\_usd
  * buy\_volume\_usd
  * sell\_volume\_usd

### Improved Endpoint - On-Chain OHLCV endpoint

[Pool OHLCV chart by Pool Address](https://docs.coingecko.com/reference/pool-ohlcv-contract-address) endpoint now supports to include empty intervals by flagging `include_empty_intervals=true` .

* By default, specific timeframe intervals (e.g. minutely) with no recorded swaps are excluded (or **skipped**) from the response.
  * This new parameter option provides the flexibility to get **padded** data, when there's no trade data.

### Improved Endpoints - Support Large Images

The following endpoints now support more size options for coin logo image:

* [Token Info by Token Address](https://docs.coingecko.com/reference/token-info-contract-address)
  * [Pool Tokens Info by Pool Address](https://docs.coingecko.com/reference/pool-token-info-contract-addres)

### Improved Endpoints - Support Normalized Supply Data

The following endpoints now support `normalized_total_supply`:

* [Token Data by Token Address](https://docs.coingecko.com/reference/token-data-contract-address)
  * [Tokens Data by Token Addresses](https://docs.coingecko.com/reference/tokens-data-contract-addresses)

### Improved Endpoints - Support Pool 'Name' and 'Fee' Data

The following endpoints now support `pool_name` and `pool_fee`:

* [Specific Pool Data by Pool Address](https://docs.coingecko.com/reference/pool-address)
  * [Multiple Pools Data by Pool Addresses](https://docs.coingecko.com/reference/pools-addresses)

### Improved Endpoints - Support Symbols of DEX Pairs

The following endpoints now allow to flag `dex_pair_format=symbol` to return DEX pair symbols instead of contract address.

* [Coin Data by ID](https://docs.coingecko.com/reference/coins-id)
  * [Coin Tickers by ID](https://docs.coingecko.com/reference/coins-id-tickers)
  * [Exchange Tickers by ID](https://docs.coingecko.com/reference/exchanges-id-tickers)
  * [Exchange Data by ID](https://docs.coingecko.com/reference/exchanges-id)

<Update label="April 2025">
  ## New Endpoint & Improvements: On-Chain Trending Data, Enhanced Trending Search, and Improved Token Lookup

🗓️ **April 25, 2025**

### \[Pro-API Exclusive] New Endpoint  - On-chain Trending Search Data

With this new endpoint [Trending Search Pools](https://docs.coingecko.com/reference/trending-search-pools), you can now retrieve the on-chain trending search pools and tokens data, as seen on GeckoTerminal.com .

By default, this endpoint returns the top 4 trending pools data, you may specify the `pools` parameter to retrieve up to top 10 pools data.

Tips: you may flag `include=base_token` to retrieve the trending tokens data.

Note:  this exclusive endpoint is available for our API [paid plan](https://www.coingecko.com/en/api/pricing) subscribers (Analyst plan & above).

### \[Pro-API Exclusive] Improved Endpoint - Trending Search List

[Paid plan](https://www.coingecko.com/en/api/pricing) subscribers (Analyst plan & above) can now use [Trending Search List](https://docs.coingecko.com/reference/trending-search) endpoint and flag `show_max` parameter to retrieve more trending coins, NFTs and coin categories on CoinGecko.com.

| Trending Data   | Public API (Demo plan) | Paid API (Analyst plan & above) |
  | :-------------- | :--------------------- | :------------------------------ |
  | Coins           | 15                     | 30                              |
  | NFTs            | 7                      | 10                              |
  | Coin Categories | 6                      | 10                              |

### Improved Endpoints - Support Token Lookup by Symbol and Name

The following endpoints now support token lookup by symbol and name, in addition to the existing API ID support:

* [Coin Price by IDs and Symbols](https://docs.coingecko.com/reference/simple-price)
  * [Coins List with Market Data](https://docs.coingecko.com/reference/coins-markets)

Previously, these endpoints only supported token lookup by \[API IDs]\([https://docs.coingecko.com/docs/1-get-data-by-id-or-address#/methods-to-query-price--market-data-of-coins](https://docs.coingecko.com/docs/1-get-data-by-id-or-address#/methods-to-query-price--market-data-of-coins\)).  This enhancement streamlines token data retrieval and eliminates the need for manual coin ID mapping.

| API Ids  | Symbol | Name    |
  | :------- | :----- | :------ |
  | bitcoin  | btc    | Bitcoin |
  | tether   | usdt   | Tether  |
  | usd-coin | usdc   | USDC    |

Lookup Priority: When multiple lookup parameters are provided, the system applies the following priority order: id (highest) > name > symbol (lowest).

**`Filtering by Symbol withinclude_tokens`**

The `include_tokens`parameter has been added to provide flexibility when filtering by symbol:

* `include_tokens=top` : Returns only the top market cap token for the specified symbol.
  * `include_tokens=all`: Returns all tokens that share the specified symbol.

Example Request & Data:

| Request Example                                                                               | Token Data Returned                                                                                              | Remarks                                                                                                                                                                                          |
  | :-------------------------------------------------------------------------------------------- | :--------------------------------------------------------------------------------------------------------------- | :----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
  | pro-api.coingecko.com/api/v3/coins/markets?vs\_currency=usd\&symbols=btc\&include\_tokens=top | 1. Bitcoin                                                                                                       | When symbols and 'include\_tokens=**top**' is specified, only the top market cap tokens will be returned.                                                                                        |
  | pro-api.coingecko.com/api/v3/coins/markets?vs\_currency=usd\&symbols=btc\&include\_tokens=all | 1. Bitcoin<br />2. Osmosis allBTC<br />3. atcat<br />4. Meld Bridged BTC (Meld)<br />5. BlackrockTradingCurrency | When symbols and 'include\_tokens=**all**' is specified, all the coins that share the same symbol will be returned.<br /><br />All the 5 coins stated in the example have the same symbol 'btc'. |

### /coins/markets Endpoint Improvement

We've enhanced the`/coins/markets` endpoint [Coins List with Market Data](https://docs.coingecko.com/reference/coins-markets), by including 'total' and 'per-page' values in the Response Headers.

This addition to the Response Headers enables developers to identify the total number of active coins on coingecko.com and specify the required pagination to retrieve all available data.

## Upcoming Change Notice: Removal of twitter\_followers Data

🗓️ **April 25, 2025**

**`Notice: Upcoming Change to CoinGecko API Endpoints - Removal oftwitter_followers Data`**

**Effective Date: 15 May 2025**

**Affected Endpoints:**

* [Coin Data by ID](https://docs.coingecko.com/reference/coins-id)
  * [Coin Data by Token Address](https://docs.coingecko.com/reference/coins-contract-address)
  * [Coin Historical Data by ID](https://docs.coingecko.com/reference/coins-id-history)

**Details of the Change:**

Please be advised that the `twitter_followers` data point within the `community_data` object will be removed from the above-listed API endpoints, effective 15 May 2025. This change is being implemented due to significant recent changes to the X (formerly Twitter) API, which have fundamentally altered how this specific data can be accessed.

Example of Affected Data Structure:

After the effective date, the `twitter_followers` field will no longer be present in the API responses for these endpoints.

If your applications or integrations currently rely on the `twitter_followers` data from these CoinGecko API endpoints, please make the necessary adjustments to your code before 15 May 2025 to avoid potential errors or data discrepancies.

**`Important Note Regarding Previously Storedtwitter_followers Data:`**

Please be aware that if you have previously stored `twitter_followers` data obtained from the CoinGecko API and archived it within your own systems, you are solely responsible for its continued use and any implications thereof.

We appreciate your understanding as we adapt to changes in third-party platforms to maintain the stability and reliability of our API. If you have any questions or require further clarification, please do not hesitate to contact our support team.
</Update>

<Update label="March 2025">
  ## New Endpoint & Multiple Improvements: On-Chain Top Token Holder Address, Security Data, Historical Supply.

🗓️ **March 28, 2025**

### \[Pro-API Exclusive] New Endpoint  - Top Token Holder Address Data

You can now access the top 50 token holder address data for tokens, as seen on GeckoTerminal.com.

By default, this endpoint returns the top 10 holders data, you can also specify the `holders` parameter to retrieve up to top 50 holders data.

**Network supported:**

* EVM: Ethereum, Polygon, BNB, Arbitrum, Optimism, Base
  * Solana
  * Sui
  * TON
  * Ronin

👉 Visit the endpoint reference page - [Top Token Holders by Token Address](https://docs.coingecko.com/reference/top-token-holders-token-address) to learn more and try it out now!

**Note:**  this exclusive endpoint is available for our API [paid plan](https://www.coingecko.com/en/api/pricing) subscribers (Analyst plan & above).

* The holders data is currently in **Beta**, with ongoing improvements to data quality, coverage, and update frequency.
  * For Solana tokens, the maximum number of retrievable top holders data is 40 instead of 50.

**Tips:** You may also use the following endpoints to retrieve **token holders count** and **top holders distribution percentage data**:

* [Token Info by Token Address](https://docs.coingecko.com/reference/token-info-contract-address)
  * [Pool Tokens Info by Pool Address](https://docs.coingecko.com/reference/pool-token-info-contract-address)

### Historical Supply endpoints - Support for Inactive Coins

You may now access historical total and circulating supply data of inactive coins using the following endpoints. To check for list of inactive coins, you may use [Coin List (ID Map)](https://docs.coingecko.com/reference/coins-list) endpoint and flag `status=inactive`.

Note: these endpoints below are exclusive for [Enterprise plan](https://www.coingecko.com/en/api/pricing) customers only.

**Improved endpoints:**

* [Circulating Supply Chart by ID](https://docs.coingecko.com/reference/coins-id-circulating-supply-chart)
  * [Circulating Supply Chart within Time Range by ID](https://docs.coingecko.com/reference/coins-id-circulating-supply-chart-range)
  * [Total Supply Chart by ID](https://docs.coingecko.com/reference/coins-id-total-supply-chart)
  * [Total Supply Chart within time range by ID](https://docs.coingecko.com/reference/coins-id-total-supply-chart-range)

### Onchain Pool Data endpoints - Locked Liquidity

Now support **`locked_liquidity_percentage`** data.

**Improved endpoints:**

* [Specific Pool Data by Pool Address](https://docs.coingecko.com/reference/pool-address)
  * [Multiple Pools Data by Pool Addresses](https://docs.coingecko.com/reference/pools-addresses)

### Onchain Token Info endpoints - GT Score, Mint Authority, Freeze Authority

The following Token Info endpoints now provide more security related information:

* **GeckoTerminal Score Details** - Learn more about GT Score [here](https://support.coingecko.com/hc/en-us/articles/38381394237593-What-is-GT-Score-How-is-GT-Score-calculated).
    * **Pool** - Combination of pool signals such as honeypot risk, buy/sell tax, proxy contract, liquidity amount, and whether the liquidity is locked.
    * **Transaction** - Total number of transactions and trading volume in the last 24 hours.
    * **Creation** - Age of the pool since creation. The longer, the better it is for the score.
    * **Info** - Submitted social info and metadata to the token.
    * **Holders** - Distribution of tokens among unique addresses.
  * **Mint Authority**
  * **Freeze Authority**

**Improved endpoints:**

* [Token Info by Token Address](https://docs.coingecko.com/reference/token-info-contract-address)
  * [Pool Tokens Info by Pool Address](https://docs.coingecko.com/reference/pool-token-info-contract-address)

### Onchain Simple Token Price endpoint - Market Cap to FDV Fallback

The [Onchain Simple Token Price](https://docs.coingecko.com/reference/onchain-simple-price) endpoint now supports fallback option for Market Cap to return FDV value, when the Market Cap value is not available.

* If the token's market cap is not verified by the CoinGecko team, the onchain endpoints will return **null** for its market cap value, even though it has a displayed value on GeckoTerminal, which might not be accurate as it often matches the Fully Diluted Valuation (FDV).
  * Market Cap can be verified by and sourced from CoinGecko, and the number may be higher than FDV as it may include Market Cap of tokens issued on other blockchain network.

If you require the Market Cap key (`market_cap_usd`) to return FDV value (as seen on GeckoTerminal.com) when Market Cap data is unavailable, please specify this parameter `marketcap_fdv_fallback=true`.

## Update Frequency Improvements for selected Pro-API endpoints (March 2025)

🗓️ **March 14, 2025**

\[Changes below are applicable to Analyst/Lite/Pro/Enterprise [plan subscribers](https://www.coingecko.com/en/api/pricing) only.]

Dear CoinGecko API paid plan subscribers,

We're excited to announce an improvement to our API, aimed at providing you with even faster access to real-time data! Starting **02:00 UTC, March 25, 2025**, the edge cache duration for the following endpoints will be reduced from 60s to 30s, allowing you to retrieve updated data more frequently.

1. Effective from 02:00 UTC, March 25, 2025:
     1. [Trending Pools List](https://docs.coingecko.com/reference/trending-pools-list)
     2. [Trending Pools by Network](https://docs.coingecko.com/reference/trending-pools-network)
     3. [Top Pools by Network](https://docs.coingecko.com/reference/top-pools-network)
     4. [Top Pools by Dex](https://docs.coingecko.com/reference/top-pools-dex)
  2. Effective from 02:00 UTC, March 26, 2025:
     1. [New Pools by Network](https://docs.coingecko.com/reference/latest-pools-network)
     2. [New Pools List](https://docs.coingecko.com/reference/latest-pools-list)
     3. [ Megafilter for Pools](https://docs.coingecko.com/reference/pools-megafilter)
     4. [Search Pools](https://docs.coingecko.com/reference/search-pools)
  3. Effective from 02:00 UTC, March 27, 2025:
     1. [Top Pools by Token Address](https://docs.coingecko.com/reference/top-pools-contract-address)
     2. [Most Recently Updated Tokens List](https://docs.coingecko.com/reference/tokens-info-recent-updated)
     3. [Pools by Category ID](https://docs.coingecko.com/reference/pools-category)

**What This Means for You:**

* **Fresher Data, Quicker**: With a reduced cache time, you'll now have the option to access more up-to-date data, closer to real-time!
  * **No Extra Credits for Cached Data**: If your request hits the cache (now updated every 30 seconds for endpoints above), there will be no additional credits charged—just like before.

**Things to Keep in Mind:**

* If your request hits our origin server instead of the cache to retrieve the latest data, there may be additional credits used.
  * To balance cost and real-time data needs, we recommend reviewing your request frequency. For those who prefer to obtain data without extra credits, consider keeping your request interval at 60 seconds or more to align with the new cache duration.

We're committed to continuously improving your experience and ensuring you get the data you need, as efficiently as possible. If you have any questions or need assistance, feel free to reach out to [soonaik@coingecko.com](mailto:soonaik@coingecko.com) .

**CoinGecko API Team**

## Multiple Improvement: Holders data, Pool Stats, Simple Token Price

🗓️ **March 14, 2025**

### Onchain Token Info endpoints - Holders data

Now support the following holder data **(Beta)**:

* holders count
  * top holders distribution percentage

**Improved endpoints:**

* [Token Info by Token Address](https://docs.coingecko.com/reference/token-info-contract-address)
  * [Pool Tokens Info by Pool Address](https://docs.coingecko.com/reference/pool-token-info-contract-address)

### Onchain Pool Data endpoints - More Data Support

Now support the following data:

* `price_change_percentage`: m15, m30
  * `volume_usd`: m15, m30
  * `transactions`: h6

**Improved endpoints:**

* [Specific Pool Data by Pool Address](https://docs.coingecko.com/reference/pool-address)
  * [Multiple Pools Data by Pool Addresses](https://docs.coingecko.com/reference/pools-addresses)

### Onchain Simple Token Price endpoint - Liquidity & Price Change Percentage data

Now supports the following optional parameter to return more data.

* `include_24hr_price_change` (24hr price change percentage)
  * `include_total_reverse_in_usd` (token liquidity data - total liquidity portion attributable to a specific token across all available pools)

**Improved Endpoint:**

* [Token Price by Token Addresses](https://docs.coingecko.com/reference/onchain-simple-price)

<Update label="February 2025">
  ## New Megafilter Endpoint,  200+ Chains Supported: Hyperliquid, Abstract, Berachain & MOAR!

🗓️ **February 27, 2025**

Powered by GeckoTerminal, the CoinGecko API now supports on-chain data across **200+ blockchain networks**, including the latest additions: Hyperliquid, HyperEVM, Abstract, Berachain, Story, Monad, Unichain, and Soneium.

While we offer the widest on-chain data coverage, we understand that you may have specific needs when slicing and dicing data for your use case. That's why we're introducing Megafilter, an exclusive endpoint available for our API paid plan subscribers (Analyst plan & above).

### 🔥 What's Megafilter?

This new endpoint provides unmatched flexibility, allowing you to query and filter data exactly the way you want.

🔗 Docs: [Megafilter for Pools](https://docs.coingecko.com/reference/pools-megafilter)

### 👀 What Can You Do?

With the /megafilter endpoint, you can slice and dice on-chain data your way across:

* 200+ blockchain networks, 1,400+ dexes, 6M+ pools, and 5M+ tokens
  * Advanced filtering options based on liquidity, FDV, volume, transactions, buy/sell trends, and time range
  * Custom sorting, including trending pools (5m), newest pools, or liquidity growth
  * Fraud detection filters: Exclude honeypots, check GT Score, verify CG listings, and track social metrics

Here's some quick examples:

* Track fresh pools on Uniswap V4 & Aerodrome with liquidity above \$1,000
  * Discover trending DEX pools across Solana, Base, and other chains with a high GT Score.
  * Filter out risky pools with built-in honeypot protection & fraud checks
  * Customize data retrieval based on your strategy: time-based, volume-based, or trend-driven

🚀 API Docs: [Megafilter for Pools](https://docs.coingecko.com/reference/pools-megafilter)\
  🔗 Live Filtering on [GeckoTerminal](https://www.geckoterminal.com/)

## Update Frequency Improvements for selected Pro-API endpoints

🗓️ **February 14, 2025**

\[Changes below are applicable to Analyst/Lite/Pro/Enterprise [plan subscribers](https://www.coingecko.com/en/api/pricing) only.]

Dear CoinGecko API paid plan subscribers,

We're excited to announce an improvement to our API, aimed at providing you with even faster access to real-time data! Starting **02:00 UTC, February 24, 2025**, the edge cache duration for the following endpoints will be reduced to 30s, allowing you to retrieve updated data more frequently.

| Endpoints                                                                                                 | Effective Date & Time                                            | Current Update Frequency | New Update Frequency |
  | :-------------------------------------------------------------------------------------------------------- | :--------------------------------------------------------------- | :----------------------- | :------------------- |
  | Onchain [/networks/../tokens/](https://docs.coingecko.com/reference/token-data-contract-address)          | 02:00 UTC, February 24, 2025                                     | 60s                      | 30s                  |
  | Onchain [/networks/../tokens/multi/](https://docs.coingecko.com/reference/tokens-data-contract-addresses) | 06:00 UTC, February 24, 2025                                     | 60s                      | 30s                  |
  | Onchain [/networks/../pools/../ohlcv](https://docs.coingecko.com/reference/pool-ohlcv-contract-address)   | 02:00 UTC, February 25, 2025 - Enterprise plan subscribers only  | 60s                      | 30s                  |
  | Onchain [/networks/../pools/../ohlcv](https://docs.coingecko.com/reference/pool-ohlcv-contract-address)   | 02:00 UTC, February 26, 2025 - Analyst/Lite/Pro plan subscribers | 60s                      | 30s                  |

**What This Means for You:**

* **Fresher Data, Quicker**: With a reduced cache time, you'll now have the option to access more up-to-date data, closer to real-time!
  * **No Extra Credits for Cached Data**: If your request hits the cache (now updated every 30 seconds for endpoints above), there will be no additional credits charged—just like before.

**Things to Keep in Mind:**

* If your request hits our origin server instead of the cache to retrieve the latest data, there may be additional credits used.
  * To balance cost and real-time data needs, we recommend reviewing your request frequency. For those who prefer to obtain data without extra credits, consider keeping your request interval at 60 seconds or more to align with the new cache duration.

We're committed to continuously improving your experience and ensuring you get the data you need, as efficiently as possible. If you have any questions or need assistance, feel free to reach out to [soonaik@coingecko.com](mailto:soonaik@coingecko.com) .

**CoinGecko API Team**

## Enhanced Onchain Metadata, Increased Max Address Limit for Multi Endpoints, Improved Exchange Tickers Sorting

🗓️ **February 09, 2025**

### Onchain Metadata: Improved Coverage

**Previously:** Payload may return 'missing.png' for `image_url` for tokens that do not have image data.

**Now:** Coverage of metadata (images, websites, description, socials) is now improved for tokens on Solana, Ton, Base, and Sui networks. For tokens that do not contain image data, 'null' value will be returned for `image_url`.

**Improved endpoints with image data:**

1. [Trending Pools List](https://docs.coingecko.com/reference/trending-pools-list)
  2. [Trending Pools by Network](https://docs.coingecko.com/reference/trending-pools-network)
  3. [Specific Pool Data by Pool Address](https://docs.coingecko.com/reference/pool-address)
  4. [Multiple Pools Data by Pool Addresses](https://docs.coingecko.com/reference/pools-addresses)
  5. [Top Pools by Network](https://docs.coingecko.com/reference/top-pools-network)
  6. [Top Pools by Dex](https://docs.coingecko.com/reference/top-pools-dex)
  7. [New Pools by Network](https://docs.coingecko.com/reference/latest-pools-network)
  8. [New Pools List](https://docs.coingecko.com/reference/latest-pools-list)
  9. [Search Pools](https://docs.coingecko.com/reference/search-pools)
  10. [Top Pools by Token Address](https://docs.coingecko.com/reference/top-pools-contract-address)
  11. [Token Data by Token Address](https://docs.coingecko.com/reference/token-data-contract-address)
  12. [Tokens Data by Token Addresses](https://docs.coingecko.com/reference/tokens-data-contract-addresses)
  13. [Token Info by Token Address](https://docs.coingecko.com/reference/token-info-contract-address)
  14. [Pool Tokens Info by Pool Address](https://docs.coingecko.com/reference/pool-token-info-contract-address)
  15. [Most Recently Updated Tokens List](https://docs.coingecko.com/reference/tokens-info-recent-updated)

**Improved endpoints with metadata (images, websites, description, socials):**

1. [Token Info by Token Address](https://docs.coingecko.com/reference/token-info-contract-address)
  2. [Pool Tokens Info by Pool Address](https://docs.coingecko.com/reference/pool-token-info-contract-address)
  3. [Most Recently Updated Tokens List](https://docs.coingecko.com/reference/tokens-info-recent-updated)

Note: Metadata may be sourced on-chain and is not vetted by the CoinGecko team. If you wish to get metadata reviewed by CoinGecko team, you may use the following endpoints:

* [Coin Data by ID](https://docs.coingecko.com/reference/coins-id)
  * [Coin Data by Token Address](https://docs.coingecko.com/reference/coins-contract-address)

### Improved Max Address Limit for onchain /multi endpoints

**Previously:** Onchain /multi endpoints support up to 30 token or pool contract addresses per request.

**Now:** Onchain /multi endpoints support up to 50 token or pool contract addresses per request.

**Improved endpoints:**

1. [Tokens Data by Token Addresses](https://docs.coingecko.com/reference/tokens-data-contract-addresses)
  2. [Multiple Pools Data by Pool Addresses ](https://docs.coingecko.com/reference/pools-addresses)

Note: this new max address input limit is exclusive for paid plan subscribers (Analyst plan & above) only.

### Improved Data Consistency for Exchange Tickers by ID

For [Exchange Tickers by ID](https://docs.coingecko.com/reference/exchanges-id-tickers) endpoint, the order is sorted by **trust\_score\_desc** by default.

* Sometimes duplicate or missing data may occur due to paginated cached response, especially when a ticker's rank changes between 2 paginated requests, e.g. it might shift from Page 2 to Page 1, vice versa.
  * We've added a new `order` option: **base\_target**, which will sort the tickers by **base** symbol, then **target** symbol, in lexicographical order, i.e. `0->9`, then `a->Z`.

Example:  flagging ?order=base\_target

This sorting method ensures stable pagination, reducing issues where cached responses may cause duplicate or missing tickers across pages.
</Update>

<Update label="January 2025">
  ## Multiple Improvements: Onchain Pools Page Limit, Trades Token Filter

🗓️ **January 27, 2025**

### Onchain Pools Data: Supports more than 10 pages of data

**Previously:** There was a limitation of a maximum of 10 pages for accessing pools data in the related endpoints.

**Now:** All paid plan subscribers (Analyst & above) can access more than 10 pages of pools data for the endpoints below.

**Improved Endpoints:**

1. [Search Pools](https://docs.coingecko.com/reference/search-pools)
  2. [Top Pools by Token Address](https://docs.coingecko.com/reference/top-pools-contract-address)
  3. [Trending Pools List](https://docs.coingecko.com/reference/trending-pools-list)
  4. [Trending Pools by Network](https://docs.coingecko.com/reference/trending-pools-network)
  5. [New Pools by Network](https://docs.coingecko.com/reference/latest-pools-network)
  6. [New Pools List](https://docs.coingecko.com/reference/latest-pools-list)
  7. [Top Pools by Network](https://docs.coingecko.com/reference/top-pools-network)
  8. [Top Pools by Dex](https://docs.coingecko.com/reference/top-pools-dex)

### Onchain Trades: Added Token Filter

**Endpoint:** [Past 24 Hour Trades by Pool Address](https://docs.coingecko.com/reference/pool-trades-contract-address)

**Previously:** There was no way to filter trades data by base or quote token.

**Now**: A new optional parameter has been added to allow filtering by base or quote token of a pool.

* Parameter: `token`
  * Value options:
    * `base`
    * `quote`
    * `{token_address}`

## Multiple Improvements: Onchain Token Price, NFT Market Cap

🗓️ **January 24, 2025**

### Onchain Simple Token Price: Added Market Cap and 24h Volume Data

**Endpoint:** [Token Price by Token Addresses](https://docs.coingecko.com/reference/onchain-simple-price)

* You can now flag `include_market_cap=true` and `include_24hr_vol=true` to retrieve market cap and 24h trading volume data. e.g.

### NFT Data: Added 'Market Cap Rank'

You can now obtain the `market_cap_rank` data of NFT collections via the following endpoints:

* [NFTs Collection Data by ID](https://docs.coingecko.com/reference/nfts-id)
  * [NFTs Collection Data by Contract Address](https://docs.coingecko.com/reference/nfts-contract-address)

## Removal of Unsupported Categories

🗓️ **January 23, 2025**

### Upcoming Removal of Unsupported Categories from CoinGecko and CoinGecko API

We are announcing the removal of certain categories from CoinGecko and CoinGecko API. These categories will no longer be supported across all API endpoints starting **February 12, 2025**.

| No | Category Name          | Category ID         |
  | :- | :--------------------- | :------------------ |
  | 1  | US Election 2020       | us-election-2020    |
  | 2  | Governance             | governance          |
  | 3  | Cryptocurrency         | cryptocurrency      |
  | 4  | Technology and Science | technology-science  |
  | 5  | Presale Meme           | presale-meme-coins  |
  | 6  | Business Platform      | business-platform   |
  | 7  | Number                 | number              |
  | 8  | Structured Product     | structured-products |
  | 9  | Investment             | investment          |
  | 10 | Niftex Shards          | niftex-shards       |
  | 11 | Ethereum POW IOU       | ethereum-pow-iou    |
  | 12 | Mirrored Assets        | mirrored-assets     |
  | 13 | Remittance             | remittance          |
  | 14 | Protocol               | protocol            |
  | 15 | Unicly Ecosystem       | utokens             |
  | 16 | Finance and Banking    | finance-banking     |
  | 17 | Eth 2.0 Staking        | eth-2-0-staking     |

#### Reason for Removal

Many of these categories no longer have associated coins. Some categories are outdated and no longer relevant in the crypto space. The changes align with updated category topology standards to maintain data accuracy and relevance.

API responses for the `/coins/markets` [endpoint](https://docs.coingecko.com/reference/coins-markets) will no longer support data of the categories above. Any requests specifying these categories will return an error.

Ensure applications using the `/coins/markets` [endpoint](https://docs.coingecko.com/reference/coins-markets) are not querying these removed categories. Please update any code or documentation referencing these categories to prevent errors.

## Extended Historical Data for Onchain OHLCV Endpoint

🗓️ **January 15, 2025**

We've improved the [Pool OHLCV Chart by Pool Address](https://docs.coingecko.com/reference/pool-ohlcv-contract-address) endpoint to provide access to a much broader range of historical data.

* **Previous Behavior:** Users could only query data for the past 6 months from today.
  * **New Behavior**: Users can now access data from September 2021 to the present, depending on the pool's tracking start date on GeckoTerminal.
  * Each API request is **limited to a 6-month date range**, but users can query older data by using the before\_timestamp parameter.

Note: access to data beyond the past 6 months is only available to [Paid Plan](https://www.coingecko.com/en/api/pricing) subscribers (Analyst plan & above).

No changes are required for existing integrations. However, users who need data beyond the past 6 months should adjust their queries to use the `before_timestamp` parameter to fetch additional data.

## Update to Total Supply of POW Coins

🗓️ **January 15, 2025**

#### What's Changing?

We are updating the definition of Total Supply for PoW (Proof-of-Work) coins to reflect the actual number of mined coins rather than the maximum supply. This change ensures consistency and accuracy in representing the supply data.

* **Previous Behavior:**
    * Total Supply: Displayed as the maximum possible supply (e.g., Bitcoin: 21,000,000).
  * **New Behavior:**
    * Total Supply: Now reflects the actual number of mined coins.\
      For example: Bitcoin: \~19,500,000 (as of January 2025).

This update will also affect historical Total Supply data for consistency. This change applies to all affected PoW coins, including Bitcoin, Bitcoin Cash, Litecoin, Ethereum Classic, and more.

#### Affected endpoints that contain "total\_supply" data:

* **Current Data**
    * [Coin Data by ID](https://docs.coingecko.com/reference/coins-id)
    * [Coins List with Market Data](https://docs.coingecko.com/reference/coins-markets)
  * **Historical Darta**
    * [Total Supply Chart by ID](https://docs.coingecko.com/reference/coins-id-total-supply-chart)
    * [Total Supply chart within time range by ID](https://docs.coingecko.com/reference/coins-id-total-supply-chart-range)

**Bitcoin:** Updated on Jan 14, 2025

**Other PoW Coins**: Scheduled for Jan 22, 2025

* [Bitcoin Cash](https://www.coingecko.com/en/coins/bitcoin-cash)
  * [Litecoin](https://www.coingecko.com/en/coins/litecoin)
  * [Ethereum Classic](https://www.coingecko.com/en/coins/ethereum-classic)
  * [Bitcoin SV](https://www.coingecko.com/en/coins/bitcoin-sv)
  * [Zcash](https://www.coingecko.com/en/coins/zcash)
  * [eCash](https://www.coingecko.com/en/coins/ecash)
  * [Dash](https://www.coingecko.com/en/coins/dash)
  * [Verus Coin](https://www.coingecko.com/en/coins/verus-coin)
  * [Ravencoin](https://www.coingecko.com/en/coins/ravencoin)
  * [Kadena](https://www.coingecko.com/en/coins/kadena)
  * [Decred](https://www.coingecko.com/en/coins/decred)
  * [Flux (Zelcash)](https://www.coingecko.com/en/coins/flux-zelcash)
  * [DigiByte](https://www.coingecko.com/en/coins/digibyte)
  * [Quantum Resistant Ledger](https://www.coingecko.com/en/coins/quantum-resistant-ledger)
  * [Komodo](https://www.coingecko.com/en/coins/komodo)
  * [Groestlcoin](https://www.coingecko.com/en/coins/groestlcoin)
  * [Firo](https://www.coingecko.com/en/coins/firo)
  * [Litecoin Cash](https://www.coingecko.com/en/coins/litecoin-cash)
  * [LuckyCoin](https://www.coingecko.com/en/coins/luckycoin)
  * [Enecuum](https://www.coingecko.com/en/coins/enecuum)
  * [Wownero](https://www.coingecko.com/en/coins/wownero)
  * [Radiant](https://www.coingecko.com/en/coins/radiant)
  * [Tidecoin](https://www.coingecko.com/en/coins/tidecoin)
  * [Handshake](https://www.coingecko.com/en/coins/handshake)
  * [Neoxa](https://www.coingecko.com/en/coins/neoxa)
  * [Vertcoin](https://www.coingecko.com/en/coins/vertcoin)
  * [Feathercoin](https://www.coingecko.com/en/coins/feathercoin)
  * [Bitcore](https://www.coingecko.com/en/coins/bitcore)
  * [Phoenixcoin](https://www.coingecko.com/en/coins/phoenixcoin)
  * [BitcoinZ](https://www.coingecko.com/en/coins/bitcoinz)
  * [Hush](https://www.coingecko.com/en/coins/hush)
  * [DigitalNote](https://www.coingecko.com/en/coins/digitalnote)
  * [EquityPay](https://www.coingecko.com/en/coins/equitypay)
  * [Evadore](https://www.coingecko.com/en/coins/evadore)
  * [Swap](https://www.coingecko.com/en/coins/swap)
  * [DeVault](https://www.coingecko.com/en/coins/devault)
  * [AXE](https://www.coingecko.com/en/coins/axe)
  * [Iridium](https://www.coingecko.com/en/coins/iridium)
  * [X-Cash](https://www.coingecko.com/en/coins/x-cash)
  * [Bolivarcoin](https://www.coingecko.com/en/coins/bolivarcoin)
  * [uPlexa](https://www.coingecko.com/en/coins/uplexa)
  * [WorldCoin (WDC)](https://www.coingecko.com/en/coins/worldcoin-wdc)

## Improved Update Frequency for selected Pro-API endpoints

🗓️ **January 13, 2025**

\[Changes below are applicable to Analyst/Lite/Pro/Enterprise [plan subscribers](https://www.coingecko.com/en/api/pricing) only.]

The edge cache duration for the following endpoints are now reduced to 20-30s, allowing you to retrieve updated data more frequently.

| Endpoints                                                                                                 | Previous Update Frequency | Current Update Frequency |
  | :-------------------------------------------------------------------------------------------------------- | :------------------------ | :----------------------- |
  | CoinGecko [/simple/price](https://docs.coingecko.com/reference/simple-price)                              | 30s                       | 20s                      |
  | CoinGecko [/simple/token\_price](https://docs.coingecko.com/reference/simple-token-price)                 | 30s                       | 20s                      |
  | Onchain [/simple/networks/../token\_price](https://docs.coingecko.com/reference/onchain-simple-price)     | 60s                       | 30s                      |
  | Onchain [/networks/../pools/../trades](https://docs.coingecko.com/reference/pool-trades-contract-address) | 60s                       | 30s                      |
  | Onchain [/networks/../pools/..](https://docs.coingecko.com/reference/pool-address)                        | 60s                       | 30s                      |
  | Onchain [/networks/../pools/multi/..](https://docs.coingecko.com/reference/pools-addresses)               | 60s                       | 30s                      |

**What This Means for You:**

* **Fresher Data, Quicker**: With a reduced cache time, you'll now have the option to access more up-to-date data, closer to real-time!
  * **No Extra Credits for Cached Data**: If your request hits the cache (now updated every 20-30 seconds for endpoints above), there will be no additional credits charged—just like before.

**Things to Keep in Mind:**

* If your request hits our origin server instead of the cache to retrieve the latest data, there may be additional credits used.
  * To balance cost and real-time data needs, we recommend reviewing your request frequency. For those who prefer fresher data without extra credits, consider keeping your request interval at 30 seconds or more to align with the new cache duration.

We're committed to continuously improving your experience and ensuring you get the data you need, as efficiently as possible. If you have any questions or need assistance, feel free to reach out to [soonaik@coingecko.com](mailto:soonaik@coingecko.com) .

**CoinGecko API Team**

## Improved 5-minutely data for Historical Chart Data endpoints

🗓️ **January 09, 2025**

For the following 4 historical chart endpoints, the data of the *last 48 hours from now* is no longer excluded.

* [Coin Historical Chart Data by ID](https://docs.coingecko.com/reference/coins-id-market-chart)
  * [Coin Historical Chart Data within Time Range by ID](https://docs.coingecko.com/reference/coins-id-market-chart-range)
  * [Coin Historical Chart Data by Token Address](https://docs.coingecko.com/reference/contract-address-market-chart)
  * [Coin Historical Chart Data within Time Range by Token Address](https://docs.coingecko.com/reference/contract-address-market-chart-range)

**Note:** The **5-minutely** and **hourly** interval params are exclusively available to Enterprise plan subscribers, bypassing auto-granularity:

* `interval=5m`: 5-minutely historical data, supports up to any 10 days date range per request.
  * `interval=hourly`: hourly historical data, supports up to any 100 days date range per request.
  * **Data availability:**
    * `interval=5m`: Available from 9 February 2018 onwards
    * `interval=hourly`: Available from 30 Jan 2018 onwards

For non-Enterprise plan subscribers who would like to get hourly data, please leave the `interval` params empty for auto granularity:

* 1 day from current time = 5-minutely data
  * 1 day from any time (except current time) = hourly data
  * 2 - 90 days from any time = hourly data
  * above 90 days from any time = daily data (00:00 UTC)
</Update>

<Update label="December 2024">
  ## Added: Onchain Categories Data, CG data improvements

🗓️ **December 24, 2024**

### NEW: Onchain Categories : Get Categories on GeckoTerminal.com

This new [Categories List](https://docs.coingecko.com/reference/categories-list) endpoint allows you to query all the categories supported on GeckoTerminal.com such as 'Pump Fun' and 'Animal'.

* This endpoint is exclusively available for [Analyst/Lite/Pro/Enterprise plan](https://www.coingecko.com/en/api/pricing) subscribers only.

### NEW: Onchain Catergory Pools: Get Pools of a specific Category

This new [Pools by Category ID](https://docs.coingecko.com/reference/pools-category) endpoint allows you to query all the pools of a specific category on GeckoTerminal.com.

* This endpoint is exclusively available for [Analyst/Lite/Pro/Enterprise plan](https://www.coingecko.com/en/api/pricing) subscribers only.
  * You can also obtain tokens of a specific category, by flagging `include=base_token`

### Onchain Token Info: Added Categories Data

You can now obtain the categories of a token via the following endpoints:

1. [Token Info by Token Address](https://docs.coingecko.com/reference/token-info-contract-address)
  2. [Pool Tokens Info by Pool Address](https://docs.coingecko.com/reference/pool-token-info-contract-address)

### Onchain New Pools Data: Bug Fixed

Previously, this [/networks/new\_pools](https://docs.coingecko.com/reference/latest-pools-network) endpoint omitted new pools that are created within the last 24 hours.

It now returns all newly created pools in the last 48 hours.

### CoinGecko Exchange Data: Added support of inactive exchange id

You now query the the list of id of delisted exchanges with [Exchanges List (ID Map)](https://docs.coingecko.com/reference/exchanges-list) endpoint, by flagging `status=inactive `

**Tips**: you may query to get historical volume delisted exchanges for via the following endpoints:

* [Exchange Volume Chart by ID](https://docs.coingecko.com/reference/exchanges-id-volume-chart)
  * [Exchange Volume Chart within Time Range by ID](https://docs.coingecko.com/reference/exchanges-id-volume-chart-range)

### CoinGecko Historical Chart Data: Faster Last UTC Day (00:00) Data Update

For [Coin Historical Chart Data by ID](https://docs.coingecko.com/reference/coins-id-market-chart) endpoint, the last completed UTC day (00:00) data is now available **10 minutes after midnight** on the next UTC day (00:10).

Previously, the last completed UTC day (00:00) was only made available **35 minutes** after midnight.

## \[Updated: Q4 2024] CoinGecko Asset Issuance Standardisation Initiative Updates

🗓️ **December 17, 2024**

As part of our commitment to improving data quality and enhancing the consistency of asset information, we are rolling out an asset standardization initiative at CoinGecko.

**What is asset standardization?**\
  Standardization involves refining how we classify and display assets. By systematically organizing asset listings into more precise categories - such as native, bridged, or wrapped tokens each following specific naming conventions, we aim to eliminate confusion and enhance data reliability.

**What changes should I expect?**\
  The most notable change is that non-native token contracts previously grouped under native asset listings will now be assigned their own distinct pages.

For example, a bridged version of USDT that might have been aggregated under the original, native USDT page, will now be featured on a dedicated page specifically for that bridged variant.

Additionally, there may be varying levels of changes in various aggregated data points of the standardized assets, including trading volume, supply, market cap rankings, etc., due to misplaced contracts being transitioned away from the original page to accurately reflect their true metrics.

**Focus for Q3 2024** **\[Completed ✅]**

* [Wrapped Bitcoin (WBTC)](https://www.coingecko.com/en/coins/wrapped-bitcoin)
  * [Wrapped Ethereum (WETH)](https://www.coingecko.com/en/coins/weth)
  * [Dai (DAI)](https://www.coingecko.com/en/coins/dai)

\*\*For full list of FAQs and updated infomation, please refer [here](https://support.coingecko.com/hc/en-us/articles/35555248857497-CoinGecko-Asset-Issuance-Standardisation-Initiative-Updates-and-FAQ)

### What's New in Q4 2024? 👈

Building on Q3's achievements, we're expanding the scope of Standardization to include four additional Coins this quarter, selected based on their significance and impact on the DeFi ecosystem.

* [Frax (FRAX)](https://www.coingecko.com/en/coins/frax)
  * [Wrapped AVAX (WAVAX)](https://www.coingecko.com/en/coins/wrapped-avax)
  * [Wrapped BNB (WBNB)](https://www.coingecko.com/en/coins/wbnb)
  * [Wrapped stETH (wstETH)](https://www.coingecko.com/en/coins/wrapped-steth)

### Tips and FAQs for API users

#### **1. How does this affect my current API setup?**

The following CoinGecko API endpoints will be impacted, with full details tracked in [this spreadsheet](https://docs.google.com/spreadsheets/d/15FyY1gvUi20LdnlJRly-pXvm5ATNbFbSy06VoI1vVs4/edit?usp=sharing). We encourage you to make the necessary adjustments and enable edit notifications on the Google Sheets, to receive real-time updates when non-native token contracts have been successfully standardized.

* /simple/price
  * /simple/token\_price/id

* /coins/markets
  * /coins/id
  * /coins/id/tickers
  * /coins/id/history
  * /coins/id/market\_chart
  * /coins/id/market\_chart/range
  * /coins/id/ohlc
  * /coins/id/ohlc/range
  * /coins/id/circulating\_supply\_chart
  * /coins/id/circulating\_supply\_chart/range
  * /coins/id/total\_supply\_chart
  * /coins/id/total\_supply\_chart/range

* /coins/id/contract/contract\_address
  * /coins/id/contract/contract\_address/market\_chart
  * /coins/id/contract/contract\_address/market\_chart/range

* /exchanges/id/tickers
  * /exchanges/id/volume\_chart
  * /exchanges/id/volume\_chart/range

#### **2. Do I have to make changes to my API?**

**No changes are necessary** if you do not need data for non-native token contracts that will be separated away from the native tokens.

#### **3. What will happen to the coins that are separated into a new coin page?**

Historical data for new non-native or bridged assets will only be available from the date of asset page creation (i.e. stnadardized). To access historical data prior to the asset standardization, we recommend retrieving data from the original native assets.

#### **4. How do I identify the list of coins that will be separated?**

For a finalised list of token contracts and API IDs that have been separated from its native asset page and listed individually, please refer to this [Google Sheets](https://docs.google.com/spreadsheets/d/15FyY1gvUi20LdnlJRly-pXvm5ATNbFbSy06VoI1vVs4/edit?usp=sharing)

You may also identify the list of bridged coins via API: you may also use [/categories/list endpoint](/reference/coins-categories-list) to look for bridged categories such as:

1. bridged-usdc
  2. bridged-wbtc
  3. bridged-weth

Then you may use [/coins/market endpoint](/reference/coins-markets) to retrieve the list of coins

## Enhancing Your Access to Even Fresher Data!

🗓️ **December 16, 2024**

\[Changes below are applicable to Analyst/Lite/Pro/Enterprise [plan subscribers](https://www.coingecko.com/en/api/pricing) only.]

**Dear CoinGecko API paid plan subscribers,**

We're excited to announce an improvement to our API, aimed at providing you with even faster access to real-time data! Starting **02:00 UTC, January 13, 2025**, the edge cache duration for the following endpoints will be reduced to 20-30s, allowing you to retrieve updated data more frequently.

| Endpoints                                                                                                 | Current Update Frequency | New Update Frequency |
  | :-------------------------------------------------------------------------------------------------------- | :----------------------- | :------------------- |
  | CoinGecko [/simple/price](https://docs.coingecko.com/reference/simple-price)                              | 30s                      | 20s                  |
  | CoinGecko [/simple/token\_price](https://docs.coingecko.com/reference/simple-token-price)                 | 30s                      | 20s                  |
  | Onchain [/simple/networks/../token\_price](https://docs.coingecko.com/reference/onchain-simple-price)     | 60s                      | 30s                  |
  | Onchain [/networks/../pools/../trades](https://docs.coingecko.com/reference/pool-trades-contract-address) | 60s                      | 30s                  |
  | Onchain [/networks/../pools/..](https://docs.coingecko.com/reference/pool-address)                        | 60s                      | 30s                  |
  | Onchain [/networks/../pools/multi/..](https://docs.coingecko.com/reference/pools-addresses)               | 60s                      | 30s                  |

**What This Means for You:**

* **Fresher Data, Quicker**: With a reduced cache time, you'll now have the option to access more up-to-date data, closer to real-time!
  * **No Extra Credits for Cached Data**: If your request hits the cache (now updated every 20-30 seconds for endpoints above), there will be no additional credits charged—just like before.

**Things to Keep in Mind:**

* If your request hits our origin server instead of the cache to retrieve the latest data, there may be additional credits used.
  * To balance cost and real-time data needs, we recommend reviewing your request frequency. For those who prefer fresher data without extra credits, consider keeping your request interval at 30 seconds or more to align with the new cache duration.

We're committed to continuously improving your experience and ensuring you get the data you need, as efficiently as possible. If you have any questions or need assistance, feel free to reach out to [soonaik@coingecko.com](mailto:soonaik@coingecko.com) .

**CoinGecko API Team**

## Multiple Improvements: Onchain Trending Pools, CG New Currencies Support, Snapshot, Exchange Info

🗓️ **December 15, 2024**

### Onchain Trending Pools: Added Support to Filter by Duration

You can now query trending pools with the following endpoints, and filter them by different duration: 5m, 1h, 6h, 24h, using `duration` parameter. e.g. `duration=5m`

* [Trending Pools List](https://docs.coingecko.com/reference/trending-pools-list): query all the trending pools across all networks on GeckoTerminal
  * [Trending Pools by Network](https://docs.coingecko.com/reference/trending-pools-network): query the trending pools based on the provided network

### CG Coin Prices: Added Support for New Fiat Currencies

You can now query coin prices in the 13 new currencies for the following 3 endpoints:

* [Coin Price by IDs](https://docs.coingecko.com/reference/simple-price): query latest price in selected currencies, by coin id
  * [Coin Price by Token Addresses](https://docs.coingecko.com/reference/simple-token-price): query latest price in selected currencies, by token address
  * [BTC-to-Currency Exchange Rates](https://docs.coingecko.com/reference/exchange-rates): query BTC exchange rates with other currencies

**New supported currencies:**

1. Colombia | COP
  2. Kenya | KES
  3. Romania | RON
  4. Dominican Republic | DOP
  5. Costa Rica | CRC
  6. Honduras | HNL
  7. Zambia | ZMW
  8. El Salvador | SVC
  9. Bosnia and Herzegovina | BAM
  10. Peru | PEN
  11. Guatemala | GTQ
  12. Lebanon | LBP
  13. Armenian Dram | AMD

### CG Coin Info: Included Snapshot URL

[Coin Data by ID](https://docs.coingecko.com/reference/coins-id) now includes Snapshot link, e.g.

### CG Exchange Info: Included Number of Coins and Pairs

[https://docs.coingecko.com/reference/exchanges-id](https://docs.coingecko.com/reference/exchanges-id) now includes "coins" and "pairs", e.g.

<Update label="October 2024">
  ## Multiple Improvements: Onchain Simple Price, Onchain Recently Updated Info, NFT Collection Data

🗓️ **October 09, 2024**

### Onchain: Simple Price - Increased Token Address Limit from 30 to 100

[Token Price by Token Addresses](/reference/onchain-simple-price) now allows to input up to 100 contract addresses, instead of 30.

* You may now retrieve data of up to 100 token prices of a specific network, in one single request.
  * Available exclusively to Pro API paid plan subscribers.

### Onchain: Recently Updated Info - Added Filter by Network

[Most Recently Updated Token List](/reference/tokens-info-recent-updated) now allows to filter by blockchain network, by flagging the `network` parameter. e.g. `network=eth`.

* You can use the `network` parameter to retrieve the 100 most recently updated token info of a specific network.
  * View list of supported network via [Supported Networks List](https://docs.coingecko.com/reference/networks-list) endpoint.

### NFT Collection Data  - Included Banner Image

[NFTs Collection Data by ID](/reference/nfts-id) now provides banner image of a NFT collection.

View banner image [example](https://coin-images.coingecko.com/nft_contracts/images/38/pudgy-penguins-banner.png?1708416126) on: [https://www.coingecko.com/en/nft/pudgy-penguins](https://www.coingecko.com/en/nft/pudgy-penguins)

<Update label="September 2024">
  ## Multiple Improvements: Global Market Chart, Asset Platforms, Coin Categories, Historical Supply Chart

🗓️ **September 26, 2024**

### Global Market Chart - Improved Daily Data Update

Previously, for [Global Market Cap Chart Data endpoint](https://docs.coingecko.com/reference/global-market-cap-chart) , the daily data is returned at 23:00 UTC. We've made improvement to return daily data at 00:00 UTC.

The last completed UTC day (00:00) is available 5 minutes after midnight on the next UTC day (00:05). The cache will **always expire at 00:05 UTC**. If you wish to get the latest daily data (00:00 UTC), you can make request at 00:05 UTC or later.

### Asset Platforms - Included Images of Blockchain Network Logos

[Asset Platforms List (ID Map)](/reference/asset-platforms-list) now provides the logos of blockchain networks.

### Coins Categories - Included Ids of Top 3 Coins

[Coins Categories List with Market Data](/reference/coins-categories) now provides coins id of the top 3 coins of a category.

### Circulating Supply Chart and Total Supply Chart - Fixed '0' data issue

For the following **Enterprise-plan** exclusive endpoints below, there was a bug that returned wrong '0' value in the payload. This is fixed and will no longer return wrong '0' value in the payload.

1. [👑 Circulating Supply Chart by ID](https://docs.coingecko.com/reference/coins-id-circulating-supply-chart)
  2. [👑 Circulating Supply chart within Time Range by ID](https://docs.coingecko.com/reference/coins-id-circulating-supply-chart-range)
  3. [👑 Total Supply Chart by ID](https://docs.coingecko.com/reference/coins-id-total-supply-chart)
  4. [👑 Total Supply Chart within time range by ID](https://docs.coingecko.com/reference/coins-id-total-supply-chart-range)

## Improvement of update frequency for OHLC endpoints

🗓️ **September 04, 2024**

The cache & update frequency of the following endpoints have been improved from every 30 minutes to every 15 minutes:

* [/coins//ohlc](/reference/coins-id-ohlc)
  * [/coins//ohlc/range](/reference/coins-id-ohlc-range)
</Update>

<Update label="August 2024">
  ## Included new fields - NFT data

🗓️ **August 18, 2024**

We've added  'user\_favorites\_count', and 'ath' (all-time-high) related data to the following NFT endpoints:

* [/nfts/](/reference/nfts-id)
  * [/nfts//contract/](/reference/nfts-contract-address)

**Example of responses:**

<Update label="May 2024">
  ## Introduced /coins/id/ohlc/range endpoint

We've introduced a new endpoint [/coins//ohlc/range](/reference/coins-id-ohlc-range).

This endpoint allows you to get the OHLC chart (Open, High, Low, Close) of a coin within a range of timestamp based on particular coin id.

Please note that this endpoint is available exclusively for **paid plan subscribers only**.

## Added interval hourly params to /coins/id/ohlc

We've expanded functionality to include support for the `interval=hourly` parameter within the [/coins//ohlc](/reference/coins-id-ohlc) endpoint.

Users can use this parameter to retrieve OHLC (Open/High/Low/Close) data on a hourly interval for up to 90 days of the date range.

Example of endpoint request:

`https://pro-api.coingecko.com/api/v3/coins/bitcoin/ohlc?vs_currency=usd&days=1&interval=hourly&x_cg_pro_api_key=YOUR_API_KEY`
</Update>

<Update label="April 2024">
  ## Added support for inactive coins in /coins/list and historical data endpoints

🗓️ **April 30, 2024**

We've now enhanced the [/coins/list](/reference/coins-list) endpoint to include inactive coins

* You may access the inactive coins by specifying `status=inactive` in your query
  * Example of endpoint request:\
    `https://pro-api.coingecko.com/api/v3/coins/list?include_platform=false&status=inactive&x_cg_pro_api_key=YOUR_API_KEY`

Additionally, historical data for inactive coins can be queried using their IDs in the following endpoints:

* [/coins//history](/reference/coins-id-history)
  * [/coins//market\_chart](/reference/coins-id-market-chart)
  * [/coins//market\_chart/range](/reference/coins-id-market-chart-range)
  * [/coins//contract//market\_chart](/reference/contract-address-market-chart)
  * [/coins//contract//market\_chart/range](/reference/contract-address-market-chart-range)

Please note that these features are available exclusively for **paid plan subscribers only**
</Update>

<Update label="March 2024">
  ## Introduced /key endpoint

🗓️ **March 27, 2024**

We've introduced a new endpoint [/key](/reference/api-usage) for conveniently monitoring your account's API usage, including rate limits and remaining credits.

**Example of responses**:

<Update label="February 2024">
  ## Multiple Improvements (Onchain/GT)

🗓️ **February 28, 2024**

* image\_url is now returned in the token response for pools and tokens endpoints:

Example of responses:

* We've added sorting parameters such as order= `h24_volume_usd_desc` and order=` h24_tx_count_desc` for /pools endpoints
  * The 'token' parameter within the [/ohlcv ](/reference/pool-ohlcv-contract-address) endpoint can now accept a token address, provided it exists in the queried pool, to return OHLCV data\
    Example of endpoint request (**token=0xc02aaa39b223fe8d0a0e5c4f27ead9083c756cc2**):\
    `https://pro-api.coingecko.com/api/v3/onchain/networks/eth/pools/0x06da0fd433c1a5d7a4faa01111c044910a184553/ohlcv/day?token=0xc02aaa39b223fe8d0a0e5c4f27ead9083c756cc2&x_cg_pro_api_key=YOUR_API_KEY`
  * [/ohlcv ](/reference/pool-ohlcv-contract-address) endpoint now includes the base and target token metadata in the response\
    Example of responses:

## Introduced /networks/network/trending\_pools endpoint (Onchain/GT)

🗓️ **February 19, 2024**

Trending Pools endpoint, [/networks//trending\_pools](/reference/trending-pools-network) is now available to fetch a list of pools that are trending as seen on GeckoTerminal based on web visits and on-chain activities.

## Introduced /search/pools endpoint (Onchain/GT)

🗓️ **February 19, 2024**

Added new endpoint to search for pools /search/pools based on keywords passed into query.
</Update>

<Update label="January 2024">
  ## Included new field for /coins/id endpoint

🗓️ **January 18, 2024**

We've included a new field "whitepaper" under "links" section for [/coins/](/reference/coins-id) endpoint

**Example of responses:**

<Update label="December 2023">
  ## Deprecated response fields for /coins/id

🗓️ **December 13, 2023**

The following data is now deprecated for [/coins/](/reference/coins-id) endpoint:

* coingecko\_rank
  * coingecko\_score
  * developer\_score
  * community\_score
  * liquidity\_score
  * public\_interest\_score
  * public\_interest\_stats
  * alexa\_rank
  * bing\_matches

## Introduced new historical total supply endpoints

🗓️ **December 12, 2023**

We've introduced Historical Total Supply data to Enterprise plan subscribers via these 2 exclusive endpoints:

* [/coins//total\_supply\_chart](/reference/coins-id-total-supply-chart) : get historical total supply of a coin, by number of days away from now.
  * [/coins//total\_supply\_chart/range](/reference/coins-id-total-supply-chart-range) : get historical total supply of a coin, within a range of timestamp.

## Included more trending coins

🗓️ **December 07, 2023**

We've expanded the capabilities of the [/search/trending](/reference/trending-search) endpoint.

It now supports up to 15 trending coins, a significant increase from the previous limit of 7.

## Improvement on pool data (Onchain/GT)

🗓️ **December 03, 2023**

Pool data now returns transaction stats for the last 1 hour. Unique buyers and sellers in the last 1 hour and 24 hours are now returned in the response
</Update>

<Update label="November 2023">
  ## Multiple Improvements

🗓️ **November 21, 2023**

The web\_slug data is now available in the following endpoints.

* [/coins/](/reference/coins-id)
  * [/coins//contract/](/reference/coins-contract-address)

This addition allows users to accurately link to a CoinGecko coin page using [www.coingecko.com/en/](http://www.coingecko.com/en/\{web_slug}).

**Example of responses:**

For the [/asset\_platforms](/reference/asset-platforms-list) endpoint, we've introduced the native\_coin\_id data. This enables users to obtain the coin ID of different blockchain networks or asset platforms that may not have a contract address to look up

**Example of responses:**

## Introduced /simple/networks/network/token\_price/addresses endpoint (Onchain/GT)

🗓️ **November 10, 2023**

Inspired by CoinGecko API most popular endpoint, we have launched the [/simple/networks//token\_price/](/reference/onchain-simple-price), simple endpoint. Simply pass in addresses of any tokens on supported blockchain and get price data for it

## Introduced /networks/network/pools/pool\_address/trades endpoint (Onchain/GT)

🗓️ **November 08, 2023**

You can now get the latest 300 trades in the past 24 hours of a given pool from this endpoint [/networks//pools//trades](/reference/pool-trades-contract-address). You may optionally filter by trade size as well. You can now build your own telegram bot alert!
</Update>

<Update label="October 2023">
  ## Introduced new endpoints (Onchain/GT)

🗓️ **October 23, 2023**

You can now fetch token information such as name, image, social links, and description via these endpoints:

* To fetch information of tokens inside a pool, use [/networks//pools//info](/reference/pool-token-info-contract-address)
  * To fetch information of a specific token use [/networks//tokens//info](/reference/token-info-contract-address)
  * If you like to get token information of the most recently updated tokens, use [/tokens/info\_recently\_updated](/reference/tokens-info-recent-updated)
</Update>

<Update label="September 2023">
  ## Included new fields (Onchain/GT)

🗓️ **September 11, 2023**

Pool response data now returns price in the base and quote token of the pool base\_token\_price\_quote\_token and quote\_token\_price\_base\_token for your convenience without the need to do additional calculation to derive these values

## Introduced new endpoints (Onchain/GT)

🗓️ **September 06, 2023**

Added new endpoints to allow querying multiple pools and tokens in a single API call. /networks/network/pools/multi/addresses and /networks/network/tokens/multi/addresses
</Update>

<Update label="June 2023">
  ## Included new fields (Onchain/GT)

* More data added to the Pool response such as FDV, market cap (from CoinGecko if available), price change percentage, volume, number of buy/sell transactions
  * More data added when querying for token such as FDV, volume, market cap, and the top 3 pools

## Introduced precision params for other endpoints

The uses of 'precision' parameter allows to specify price data in full or 0-18 decimals, and previously was only made available for [/simple/price](/reference/simple-price) and [/simple/token\_price/](/reference/simple-token-price) endpoints.

This parameter is now supported for more endpoints as listed below:

* [/coins/markets](/reference/coins-markets)
  * [/coins/market\_chart](/reference/coins-id-market-chart)
  * [/coins/market\_chart/range](/reference/coins-id-market-chart)
  * [/coins//contract//market\_chart](/reference/contract-address-market-chart)
  * [/coins//contract//market\_chart/range](/reference/contract-address-market-chart-range)
  * [/coins//ohlc](/reference/coins-id-ohlc)

## Multiple Improvements

We've made enhancements to the /search/trending and /coins/asset\_platform\_id/contract/contract\_address endpoints:

* Top 5 trending NFT data (based on high trading volume in the last 24 hours) is now included in the [/search/trending](/reference/trending-search) endpoint
  * Near Protocol contract address (e.g. wrap.near) is now supported for [/coins//contract/ ](/reference/coins-contract-address) endpoint
</Update>

<Update label="May 2023">
  ## Multiple Improvements (Onchain/GT)

* Token metadata such as name, symbol, and CoinGecko ID are now returned in the responses for pools endpoints. Users will need to pass in this attribute include=base\_token, quote\_token
  * CoinGecko asset platform ID added to the response for [/networks](/reference/networks-list) endpoint

## Added interval daily params to /coins/id/ohlc

The [/coins//ohlc](/reference/coins-id-ohlc) endpoint now supports the "interval=daily" parameter for Paid Plan Subscribers

Users can use this parameter to retrieve OHLC (Open/High/Low/Close) data on a daily interval for up to 180 days of date range.
</Update>

<Update label="April 2023">
  ## Included new fields

🗓️ **April 26, 2023**

We've added  'watchlist\_portfolio\_users' field to [/coins/](/reference/coins-id) endpoint responses.

This refers to number of users who added the coin into a watchlist or portfolio.

**Example of responses:**

## Increased Rate Limit (Onchain/GT)

🗓️ **April 19, 2023**

We've increased the rate limit of Public Plan from 10 calls per minute to 30 calls per minute

## Multiple Improvements (Onchain/GT)

🗓️ **April 18, 2023**

* base\_token\_native\_currency and quote\_token\_native\_currency added to the pools endpoint response. This allows you to obtain price in the network's native currency in addition to in USD
  * reserve\_in\_usd added to the pools endpoint response. This returns the total liquidity/reserve of the pool in USD
  * pool\_created\_at added to the pools endpoint response

Example of responses for [/networks//pools/](/reference/pool-address) :

* [/networks//new\_pools](/reference/latest-pools-network) endpoint added to query new pools discovered for a network
  * [/networks/new\_pools](/reference/latest-pools-list) endpoint added to query new pools discovered across all networks

## Included new fields

🗓️ **April 03, 2023**

We've added "symbol" field to these NFT endpoints responses:

* [/nfts/markets](/reference/nfts-markets)
  * [/nfts/ ](/reference/nfts-id)
  * [/nfts//contract/](/reference/nfts-contract-address)

**Example of responses:**

<Update label="March 2023">
  ## Included new fields

🗓️ **March 27, 2023**

We've added "links" field (e.g. homepage, twitter, discord) to these NFT endpoints responses:

* [/nfts/](/reference/nfts-id)
  * [/nfts//contract/](/reference/nfts-contract-address)

**Example of responses:**

## Introduced /coins/top\_gainer\_losers endpoint

🗓️ **March 23, 2023**

We've added [/coins/top\_gainers\_losers](/reference/coins-top-gainers-losers) endpoint exclusively for Paid Plan Subscribers.

Users can now get the top 30 coins with largest price gain and loss by a specific time duration with this endpoint.

## Improved OHLCV endpoint (Onchain/GT)

🗓️ **March 23, 2023**

[/networks//pools//ohlcv/](/reference/pool-ohlcv-contract-address) now returns more granularity `day,` `hour`, `minute` and multiple aggregates
</Update>

<Update label="February 2023">
  ## Multiple Improvements

🗓️ **February 23, 2023**

We've made some updates to the /coins/categories and /simple/token\_price/id endpoints:

* Market cap and volume data for 'ecosystem' categories in the [/coins/categories](/reference/coins-categories) endpoint will now return 'null' until further notice. The CoinGecko team is actively working on improvements to provide more accurate data. If you have any feedback or suggestions, please reach out via [api@coingecko.com](mailto:api@coingecko.com).
  * Previously, the [/simple/token\_price/](/reference/simple-token-price) endpoint was unable to return data for some Solana coins. This issue has been resolved, and users can now expect accurate data for Solana coins from this endpoint.

## Introduced /exchange/id/volume\_chart/range endpoint

🗓️ **February 15, 2023**

We've introduced the [/exchange//volume\_chart/range](/reference/exchanges-id-volume-chart-range) endpoint for Paid Plan Subscribers.

This exclusive feature allows users to query full historical volume data of an exchange.
</Update>

<Update label="January 2023">
  ## Introduced /coins/list/new endpoint

🗓️ **January 09, 2023**

We've introduced the [/coins/list/new](/reference/coins-list-new) endpoint for Paid Plan Subscribers.

This exclusive feature allows users to query the latest 200 coins on CoinGecko.
</Update>

**Examples:**

Example 1 (unknown):
```unknown
### Megafilter: Ascending Sort Order for Price Change %

  The [Megafilter for Pools](/reference/pools-megafilter) endpoint now supports ascending sorting for price change percentage:

  * `m5_price_change_percentage_asc`
  * `h1_price_change_percentage_asc`
  * `h6_price_change_percentage_asc`
  * `h24_price_change_percentage_asc`

  ### Token OHLCV Endpoint Fix to respect Specified Token Address

  We've fixed an issue where the [Token OHLCV chart by Token Address](/reference/token-ohlcv-token-address) endpoint returned data for the base token of the top pool instead of the requested token. It will now always return data for the specified token address.
</Update>

<Update label="September 2025">
  ## SDK Gains Public Treasury Coverage, MCP Adds Exchanges, NFTs, and ISO Support

  🗓️ **September 25, 2025**

  ### Expanded SDK Coverage for Public Treasuries

  We're broadening our SDK coverage to make treasury-level insights more powerful and easier to access. Check out what's new below (with functions from [our TypeScript SDK](https://github.com/coingecko/coingecko-typescript))

  * [`publicTreasury.getCoinID(coinID, { ...params })`](https://github.com/coingecko/coingecko-typescript/blob/main/api.md#publictreasury) \
    to query public companies & governments' cryptocurrency holdings by Coin ID
  * [`publicTreasury.getEntityID(entityID)`](https://github.com/coingecko/coingecko-typescript/blob/main/api.md#publictreasury) \
    to query public companies & governments' cryptocurrency holdings by Entity ID
  * [`entities.getList({ ...params })`](https://github.com/coingecko/coingecko-typescript/blob/main/api.md#entities) \
    to query all the supported entities on CoinGecko with entities ID, name, symbol, and country

  ### New MCP Tools: Exchanges, NFTs & Multi-Address Queries

  We're also surfacing new tools through the MCP to give developers a richer, faster way to query exchanges, NFTs, and onchain activity.

  * New tools:
    * Exchange coverage with [/exchanges/list](reference/exchanges-list), [/exchanges/](reference/exchanges-id), [/exchanges//tickers](reference/exchanges-id-tickers), and [/exchanges//volume\_chart/range](reference/exchanges-id-volume-chart-range)
    * NFT markets with [/nfts/markets](reference/nfts-markets)
    * Multi-address queries with [/onchain/networks//pools/multi/](reference/pools-addresses) and [/onchain/networks//tokens/multi/](reference/tokens-data-contract-addresses)
  * Retired tools:
    * We've removed endpoints such as [/coins/list](reference/coins-list), [/onchain/networks/trending\_pools](reference/trending-pools-network), and single-address pool/token queries in favor of more scalable multi-address endpoints

  ### Friendlier Time-related MCP Queries with ISO Support

  Time-based queries just got easier. MCP tools now accept **ISO date strings** (`YYYY-MM-DD` or `YYYY-MM-DDTHH:MM`) alongside UNIX timestamps.

  For example, when using the [Coin Historical Chart Data within Time Range](reference/coins-id-market-chart-range) tool, you can now pass ISO date strings directly instead of converting them into UNIX timestamps for your LLM tools.

  **CoinGecko API Team**

  <GreenSeparator />

  ## New Crypto Treasury Endpoints and Improvements

  🗓️ **September 19, 2025**

  1. [Crypto Treasury Holdings by Coin ID](https://docs.coingecko.com/reference/companies-public-treasury) endpoint now supports governments and more coins data as seen on [https://www.coingecko.com/en/treasuries/bitcoin](https://www.coingecko.com/en/treasuries/bitcoin)
  2. **New endpoints:**
     1. [Crypto Treasury Holdings by Entity ID](https://docs.coingecko.com/reference/public-treasury-entity)
     2. [Entities List (ID Map)](https://docs.coingecko.com/reference/entities-list)
  3. [Derivatives Exchange Data by ID](https://docs.coingecko.com/reference/derivatives-exchanges-id) endpoint now supports `coin_id` and `target_coin_id` to identify coins of ticker pairs.
```

Example 2 (unknown):
```unknown
<GreenSeparator />

  ## Multiple Improvements: Bonding Curve Data, Pooled Token Balance, and More.

  🗓️ **September 12, 2025**

  ### 🚀 Now Supporting Bonding Curve Data

  Bonding curve data (launchpad graduation) is now supported for the followiing endpoints:

  * [Specific Pool Data by Pool Address](https://docs.coingecko.com/reference/pool-address)
  * [Multiple Pools Data by Pool Addresses](https://docs.coingecko.com/reference/pools-addresses)

  **Payload example:**
```

Example 3 (unknown):
```unknown
More endpoints to support bonding curve data soon.

  ### 🚀 Now Supporting Pooled Token Balance Data

  The following endpoints now support additional pool token balance data by flagging this parameter `include_composition=true` :

  * [Specific Pool Data by Pool Address](https://docs.coingecko.com/reference/pool-address)
  * [Multiple Pools Data by Pool Addresses](https://docs.coingecko.com/reference/pools-addresses)
  * [Token Data by Token Address](https://docs.coingecko.com/reference/token-data-contract-address) (requires `include=top_pools` parameter to be flagged together)
  * [Tokens Data by Token Addresses](https://docs.coingecko.com/reference/tokens-data-contract-addresses) (requires `include=top_pools` parameter to be flagged together)

  **Payload example:**
```

Example 4 (unknown):
```unknown
### 🚀 Other improvements

  1. [Onchain Megafilter](https://docs.coingecko.com/reference/pools-megafilter) endpoint now supports more `sort` options:
     * `m5_price_change_percentage_desc`
     * `h1_price_change_percentage_desc`
     * `h6_price_change_percentage_desc`
     * `fdv_usd_asc`
     * `fdv_usd_desc`
     * `reserve_in_usd_asc`
     * `reserve_in_usd_desc`
  2. [Top Gainers & Losers](https://docs.coingecko.com/reference/coins-top-gainers-losers) endpoint now supports additional price change percentage data by flagging `price_change_percentage` parameter. The available options are: `1h,24h,7d,14d,30d,60d,200d,1y`.
     * Payload example:
```

---

## Building with AI

**URL:** llms-txt#building-with-ai

**Contents:**
- Using `llms.txt`
- CoinGecko MCP Server
- Tools for Your Workflow

Source: https://docs.coingecko.com/docs/building-with-ai

Quick tips to empower your AI applications with CoinGecko API, and leverage our AI capabilities to help you build better and easier.

CoinGecko provides a powerful suite of AI-native tools to help you integrate real-time, historical, and onchain market data into your applications. Whether you're building a sophisticated trading bot, a market analysis tool, or a simple portfolio tracker, our AI toolkit is here to accelerate your development.

To help AI models interact with CoinGecko data effectively, we provide an `llms.txt` file at [/llms-full.txt](/llms-full.txt). This file gives models context on how to best query our API, ensuring more accurate and efficient data retrieval. We recommend utilizing this in your integrations of MCP and AI applications.

## CoinGecko MCP Server

The **MCP (Model-Context-Protocol)** Server is your gateway for connecting AI agents and large language models, like Claude and Gemini, directly to CoinGecko's live data streams. It's ideal for building conversational applications that can perform complex, real-time crypto analysis and answer user queries with up-to-the-minute information. Learn how to connect your AI agent by checking out [CoinGecko MCP Server](/docs/mcp-server)

## Tools for Your Workflow

We've integrated AI assistance directly into our documentation to help you find answers and ship faster.

1. Use the **'Copy page'** button to copy endpoint-specific markdown prompts. You can take these prompts to your favorite LLM chat interface to explore use cases or generate boilerplate code.
2. Stuck on a problem? Click the **'AI Support'** button anywhere in our docs to chat with our AI Assistant. It's trained to resolve your inquiries instantly.

<Frame>
  <img src="https://mintcdn.com/coingecko/M02rMX2XJMwBGpCe/images/docs/e9b8e85-image.png?fit=max&auto=format&n=M02rMX2XJMwBGpCe&q=85&s=d50f10a06097c241df55c3ab5b809d84" data-og-width="2006" width="2006" data-og-height="1364" height="1364" data-path="images/docs/e9b8e85-image.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/coingecko/M02rMX2XJMwBGpCe/images/docs/e9b8e85-image.png?w=280&fit=max&auto=format&n=M02rMX2XJMwBGpCe&q=85&s=cb8143580ee2990c66855af7ec934061 280w, https://mintcdn.com/coingecko/M02rMX2XJMwBGpCe/images/docs/e9b8e85-image.png?w=560&fit=max&auto=format&n=M02rMX2XJMwBGpCe&q=85&s=c47b12a514d650c26024442ddb64d4f9 560w, https://mintcdn.com/coingecko/M02rMX2XJMwBGpCe/images/docs/e9b8e85-image.png?w=840&fit=max&auto=format&n=M02rMX2XJMwBGpCe&q=85&s=199af9b08dc0bdfae67226399b4409de 840w, https://mintcdn.com/coingecko/M02rMX2XJMwBGpCe/images/docs/e9b8e85-image.png?w=1100&fit=max&auto=format&n=M02rMX2XJMwBGpCe&q=85&s=b44f67afc911a4bbacb227726e9823cb 1100w, https://mintcdn.com/coingecko/M02rMX2XJMwBGpCe/images/docs/e9b8e85-image.png?w=1650&fit=max&auto=format&n=M02rMX2XJMwBGpCe&q=85&s=93c5c92256523702b423fc0547a3a833 1650w, https://mintcdn.com/coingecko/M02rMX2XJMwBGpCe/images/docs/e9b8e85-image.png?w=2500&fit=max&auto=format&n=M02rMX2XJMwBGpCe&q=85&s=a95711c3e148ec09d808029d05006564 2500w" />
</Frame>

---

## Python AI Prompts

**URL:** llms-txt#python-ai-prompts

**Contents:**
- How to Use Our Prompts
- Resources

Source: https://docs.coingecko.com/docs/python-ai-prompts

A comprehensive AI prompt to guide coding assistants in correctly implementing the official CoinGecko Python SDK for reliable API integration.

## How to Use Our Prompts

Integrating these prompts into your workflow is simple. Copy the entire markdown prompt for your chosen language and provide it as context to your AI assistant.

1. For **Chat Interfaces (Claude, ChatGPT, etc.)**: Paste the prompt at the beginning of your conversation before asking the AI to write code.
2. For **Cursor IDE**: Add the prompt to your project's `Rules` to enforce the guidelines across all AI interactions.
3. For **GitHub Copilot**: Save the prompt to a file (e.g. `coingecko_rules.md`) and reference it in your chat with `@workspace #coingecko_rules.md`.
4. For **Claude Code**: Include the prompt in your CLAUDE.md file.

<CodeGroup>
  python
  # src/api/client.py
  import os
  from coingecko_sdk import Coingecko, AsyncCoingecko

# Initialize a single, reusable client. This should be imported and used application-wide.
  client = Coingecko(
      pro_api_key=os.environ.get("COINGECKO_PRO_API_KEY"),
      environment="pro",
      max_retries=3, # Rely on the SDK's built-in retry mechanism.
  )

# Optional: Initialize a single async client for concurrent applications.
  async_client = AsyncCoingecko(
      pro_api_key=os.environ.get("COINGECKO_PRO_API_KEY"),
      environment="pro",
      max_retries=3,
  )

# src/main.py
  from api.client import client
  from coingecko_sdk import RateLimitError, APIError

def get_bitcoin_price():
      try:
          price_data = client.simple.price.get(
              ids="bitcoin",
              vs_currencies="usd",
          )
          # Access data using Pydantic models or dictionary keys
          return price_data['bitcoin'].usd
      except RateLimitError:
          print("Rate limit exceeded. Please try again later.")
          return None
      except APIError as e:
          print(f"An API error occurred: {e}")
          return None

if __name__ == "__main__":
      price = get_bitcoin_price()
      if price:
          print(f"The current price of Bitcoin is: ${price}")

python
  # ❌ NO direct HTTP requests.
  import requests
  response = requests.get('[https://api.coingecko.com/api/v3/simple/price?ids=bitcoin&vs_currencies=usd](https://api.coingecko.com/api/v3/simple/price?ids=bitcoin&vs_currencies=usd)')

# ❌ NO use of the outdated `pycoingecko` library.
  from pycoingecko import CoinGeckoAPI
  cg = CoinGeckoAPI()

# ❌ NO hardcoded API keys.
  client = Coingecko(pro_api_key='CG-abc123xyz789')

# ❌ NO manual retry loops. The SDK's `max_retries` handles this.
  import time
  for i in range(3):
      try:
          data = client.simple.price.get(ids='bitcoin', vs_currencies='usd')
          break
      except:
          time.sleep(5)

# ❌ NO generic exception handling for API errors.
  try:
      data = client.simple.price.get(ids='bitcoin', vs_currencies='usd')
  except Exception as e:
      print(f"An error occurred: {e}")
  `
</CodeGroup>

* **GitHub**: [github.com/coingecko/coingecko-python](https://github.com/coingecko/coingecko-python)
* **PyPI**: [pypi.org/project/coingecko-sdk/](https://pypi.org/project/coingecko-sdk/)

Notice something off or missing? Let us know by opening an [Issue here](https://github.com/coingecko/coingecko-python/issues).

Have feedback, a cool idea, or need help? Reach out to `soonaik@coingecko[dot]com`

**Examples:**

Example 1 (python):
```python
# src/api/client.py
  import os
  from coingecko_sdk import Coingecko, AsyncCoingecko

  # Initialize a single, reusable client. This should be imported and used application-wide.
  client = Coingecko(
      pro_api_key=os.environ.get("COINGECKO_PRO_API_KEY"),
      environment="pro",
      max_retries=3, # Rely on the SDK's built-in retry mechanism.
  )

  # Optional: Initialize a single async client for concurrent applications.
  async_client = AsyncCoingecko(
      pro_api_key=os.environ.get("COINGECKO_PRO_API_KEY"),
      environment="pro",
      max_retries=3,
  )

  # src/main.py
  from api.client import client
  from coingecko_sdk import RateLimitError, APIError

  def get_bitcoin_price():
      try:
          price_data = client.simple.price.get(
              ids="bitcoin",
              vs_currencies="usd",
          )
          # Access data using Pydantic models or dictionary keys
          return price_data['bitcoin'].usd
      except RateLimitError:
          print("Rate limit exceeded. Please try again later.")
          return None
      except APIError as e:
          print(f"An API error occurred: {e}")
          return None

  if __name__ == "__main__":
      price = get_bitcoin_price()
      if price:
          print(f"The current price of Bitcoin is: ${price}")
```

Example 2 (python):
```python
# ❌ NO direct HTTP requests.
  import requests
  response = requests.get('[https://api.coingecko.com/api/v3/simple/price?ids=bitcoin&vs_currencies=usd](https://api.coingecko.com/api/v3/simple/price?ids=bitcoin&vs_currencies=usd)')

  # ❌ NO use of the outdated `pycoingecko` library.
  from pycoingecko import CoinGeckoAPI
  cg = CoinGeckoAPI()

  # ❌ NO hardcoded API keys.
  client = Coingecko(pro_api_key='CG-abc123xyz789')

  # ❌ NO manual retry loops. The SDK's `max_retries` handles this.
  import time
  for i in range(3):
      try:
          data = client.simple.price.get(ids='bitcoin', vs_currencies='usd')
          break
      except:
          time.sleep(5)

  # ❌ NO generic exception handling for API errors.
  try:
      data = client.simple.price.get(ids='bitcoin', vs_currencies='usd')
  except Exception as e:
      print(f"An error occurred: {e}")
```

---

## Common Errors & Rate Limit

**URL:** llms-txt#common-errors-&-rate-limit

**Contents:**
- Common Errors
- Rate Limit

Source: https://docs.coingecko.com/docs/common-errors-rate-limit

The server responds to a user’s request by issuing status codes when the request is made to the server. Kindly refer to the table below to further understand the status codes when indicating the success or failure of an API call.

| Status Codes                  | Description                                                                                                                                                                                                                                                   |
| ----------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `400` (Bad Request)           | This is due to an invalid request and the server could not process the user's request                                                                                                                                                                         |
| `401` (Unauthorized)          | This is due to the lack of valid authentication credentials for the requested resource by the user                                                                                                                                                            |
| `403` (Forbidden)             | This is likely indicating that your access is blocked by our server, and we're unable to authorize your request                                                                                                                                               |
| `408` (Timeout)               | This error indicates that our server did not receive your complete request within our allowed time frame. This is usually caused by a slow network connection on your end or network latency. Please check your connection and try sending the request again. |
| `429` (Too many requests)     | This is likely indicating that the rate limit has reached. The user should reduce the number of calls made, or consider scaling their service plan that has much higher rate limits and call credits                                                          |
| `500` (Internal Server Error) | This is a generic error response indicating that the server has encountered an unexpected issue that prevented it from fulfilling the request                                                                                                                 |
| `503` (Service Unavailable)   | The service is currently unavailable. Please check the API status and updates on [https://status.coingecko.com](https://status.coingecko.com)                                                                                                                 |
| `1020` (Access Denied)        | This is due to violation of CDN firewall rule                                                                                                                                                                                                                 |
| `10005`                       | You may not have access to this endpoint. e.g. 'This request is limited Pro API subscribers'. You may wanna subscribe to a paid plan [here](https://www.coingecko.com/en/api/pricing)                                                                         |
| `10002` (Missing API Key)     | API Key Missing. Please make sure you're using the right authentication method.<br />For Pro API, ensure you pass in `x_cg_pro_api_key` parameter with a Pro Key.<br />For Demo API, ensure you pass in `x_cg_demo_api_key` parameter with a Demo Key.        |
| `10010` (Invalid API Key)     | You have provided incorrect API key credentials. If you are using Pro API key, please change your root URL from `api.coingecko.com` to `pro-api.coingecko.com`                                                                                                |
| `10011` (Invalid API Key)     | You have provided incorrect API key credentials. If you are using Demo API key, please change your root URL from `pro-api.coingecko.com` to `api.coingecko.com`                                                                                               |
| CORS error                    | Occurs when the server doesn't return the CORS headers required. You may learn more and attempt the recommended solutions [here](https://www.bannerbear.com/blog/what-is-a-cors-error-and-how-to-fix-it-3-ways/#how-to-fix-a-cors-error)                      |

<Note>
  ### **Notes**

* If you're using the Public API with Google Sheet and got hit with error, this is due to the IP sharing among Google Sheet users, and we have no control over this.
  * If you need reliable performance, please **register for a demo account** or **subscribe to a paid plan** that comes with dedicated infra (API key) to prevent rate limit issues.
  * For more details, please go to the page [here](https://www.coingecko.com/en/api/pricing).
</Note>

* For Public API user (Demo plan), the rate limit is \~30 calls per minutes and it varies depending on the traffic size.
* If you're Pro API user (any paid plan), the rate limit is depending on the paid plan that you're subscribed to.
* Regardless of the HTTP status code returned (including `4xx` and `5xx` errors), all API requests will count towards your **minute rate limit**.

---

## 2. Get Historical Data

**URL:** llms-txt#2.-get-historical-data

Source: https://docs.coingecko.com/docs/2-get-historical-data

<Check>
  ### **Tips**

* Most of the historical data are returned and queried using UNIX Timestamp.
    * If you are not familiar with UNIX Timestamp, you may use tool like [epochconverter.com](https://www.epochconverter.com/) to convert between UNIX Timestamp and human readable date.
  * You may use either coin ID or contract address to get the historical data.
</Check>

There are five different endpoints to get historical data of a coin:

| Endpoint                                                                                                         | Description                                                                                                                                              |
| ---------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------------------------------------------- |
| [/coins/\{id}/history](/reference/coins-id-history)                                                              | Get the historical data (price, market cap, 24hrs volume, etc.) at a given date for a coin based on a particular coin ID.                                |
| [/coins/\{id}/market\_chart](/reference/coins-id-market-chart)                                                   | Get the historical chart data of a coin including time in UNIX, price, market cap and 24hrs volume based on particular coin ID.                          |
| [/coins/\{id}/market\_chart/range](/reference/coins-id-market-chart-range)                                       | Get the historical chart data of a coin within certain time range in UNIX along with price, market cap and 24hrs volume based on particular coin ID.     |
| [/coins/\{id}/contract/\{contract\_address}/market\_chart](/reference/contract-address-market-chart)             | Get the historical chart data of a coin including time in UNIX, price, market cap and 24hrs volume based on token contract address.                      |
| [/coins/\{id}/contract/\{contract\_address}/market\_chart/range](/reference/contract-address-market-chart-range) | Get the historical chart data of a coin within certain time range in UNIX along with price, market cap and 24hrs volume based on token contract address. |

<Note>
  ### **Notes**

The data granularity (interval) for [/market\_chart](/reference/coins-id-market-chart) and [/market\_chart/range](/reference/coins-id-market-chart-range) endpoints is automatic and based on the date range:

* 1 day from current time = 5-minutely data
  * 1 day from anytime (except from current time) = hourly data
  * 2-90 days from current time or anytime = hourly data
  * above 90 days from current time or anytime = daily data (00:00 UTC)
</Note>

---

## AI Prompts

**URL:** llms-txt#ai-prompts

**Contents:**
- How to Use Our Prompts
- Available Prompts
- Best Practices

Source: https://docs.coingecko.com/docs/ai-prompts

CoinGecko API AI prompt library

Accelerate your development with CoinGecko's curated AI prompts. These prompts are designed to guide AI-powered coding assistants in correctly implementing our official API SDKs (libraries), helping you spend less time debugging and more time building.

## How to Use Our Prompts

Integrating these prompts into your workflow is simple. Copy the entire markdown prompt for your chosen language and provide it as context to your AI assistant.

1. For **Chat Interfaces (Claude, ChatGPT, etc.)**: Paste the prompt at the beginning of your conversation before asking the AI to write code.
2. For **Cursor IDE**: Add the prompt to your project's `Rules` to enforce the guidelines across all AI interactions.
3. For **GitHub Copilot**: Save the prompt to a file (e.g. `coingecko_rules.md`) and reference it in your chat with `@workspace #coingecko_rules.md`.

Select the prompt that matches your project's tech stack.

* 🐍 **[Python](/docs/python-ai-prompts)**: A complete guide for implementing the CoinGecko API using our official [coingecko-sdk](https://pypi.org/project/coingecko-sdk/).
* 🟦 **[TypeScript](/docs/typescript-ai-prompts#/)**: The definitive prompt for integrating the CoinGecko API with our official [@coingecko/coingecko-typescript](https://www.npmjs.com/package/@coingecko/coingecko-typescript) package.

To get the most out of our AI prompts, keep these tips in mind:

* **Be Specific**: After providing the main prompt, give the AI a clear, specific task (e.g. "Write a function to fetch the price of Bitcoin and Ethereum in EUR").
* **Customize**: Feel free to modify the prompts to fit your project's unique requirements or coding standards.
* **Version Control**: Store your customized prompts in your repository to ensure your entire team benefits from consistent AI-generated code.
* **Always Review**: Treat AI-generated code as a starting point. Always review it for security, performance, and correctness.

---

## 10-mins Tutorial Guide

**URL:** llms-txt#10-mins-tutorial-guide

Source: https://docs.coingecko.com/docs/10-mins-tutorial-guide

New to CoinGecko API? Fret not. Whether you're a programmer or someone with zero coding experience, we've got you covered!

If you are not a developer and prefer to learn only specific tutorials on Google Sheet/Excel, feel free to check [👶 Tutorials (Beginner-friendly)](/docs/tutorials-beginner-friendly)

| Tutorial Steps                                                    | Description                                                                                      |
| ----------------------------------------------------------------- | ------------------------------------------------------------------------------------------------ |
| [1. Get data by ID or Address](/docs/1-get-data-by-id-or-address) | Learn how to use different endpoints by obtaining Coin ID and token's contract address at first. |
| [2. Get Historical Data](/docs/2-get-historical-data)             | Learn how to get historical data of a coin by using different historical endpoints.              |
| [3. Get Exchanges & NFT Data](/docs/3-get-exchanges-nft-data)     | Learn how to query exchanges and NFT data by accessing different endpoints.                      |
| [4. Get On-chain Data](/docs/4-get-on-chain-data)                 | Learn how to use `/onchain` GT endpoints to query onchain data.                                  |

---

## Endpoint Showcase

**URL:** llms-txt#endpoint-showcase

**Contents:**
- CoinGecko
  - [Home Page](https://www.coingecko.com)
  - [Coin Page](https://www.coingecko.com/en/coins/bitcoin)
  - [Exchanges Page](https://www.coingecko.com/en/exchanges/hyperliquid-spot)
  - [NFTs Page](https://www.coingecko.com/en/nft/pudgy-penguins)
- GeckoTerminal
  - [Home Page](https://www.geckoterminal.com/)
  - [Chain Page](https://www.geckoterminal.com/eth/pools)
  - [Pool Page](https://www.geckoterminal.com/eth/pools/0x88e6a0c2ddd26feeb64f039a2c41296fcb3f5640)
  - [Categories Page](https://www.geckoterminal.com/category)

Source: https://docs.coingecko.com/docs/endpoint-showcase

Discover how CoinGecko API is used at CoinGecko.com and GeckoTerminal.com

### [Home Page](https://www.coingecko.com)

<img src="https://mintcdn.com/coingecko/M02rMX2XJMwBGpCe/images/docs/5efbe42-image.png?fit=max&auto=format&n=M02rMX2XJMwBGpCe&q=85&s=d63633d56cc7a4d3c7d71a931a7112d8" alt="" data-og-width="2200" width="2200" data-og-height="1528" height="1528" data-path="images/docs/5efbe42-image.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/coingecko/M02rMX2XJMwBGpCe/images/docs/5efbe42-image.png?w=280&fit=max&auto=format&n=M02rMX2XJMwBGpCe&q=85&s=094bb211db972bea7d8b66716f5eed3a 280w, https://mintcdn.com/coingecko/M02rMX2XJMwBGpCe/images/docs/5efbe42-image.png?w=560&fit=max&auto=format&n=M02rMX2XJMwBGpCe&q=85&s=da211f3d8c1aec265d53891dc8f43ed6 560w, https://mintcdn.com/coingecko/M02rMX2XJMwBGpCe/images/docs/5efbe42-image.png?w=840&fit=max&auto=format&n=M02rMX2XJMwBGpCe&q=85&s=fc59610f652ef640696568679b90b723 840w, https://mintcdn.com/coingecko/M02rMX2XJMwBGpCe/images/docs/5efbe42-image.png?w=1100&fit=max&auto=format&n=M02rMX2XJMwBGpCe&q=85&s=4d8905af936b5a34968b6dad1c59f7c5 1100w, https://mintcdn.com/coingecko/M02rMX2XJMwBGpCe/images/docs/5efbe42-image.png?w=1650&fit=max&auto=format&n=M02rMX2XJMwBGpCe&q=85&s=1679ab4c405a2ad10f8037bf0e830a0d 1650w, https://mintcdn.com/coingecko/M02rMX2XJMwBGpCe/images/docs/5efbe42-image.png?w=2500&fit=max&auto=format&n=M02rMX2XJMwBGpCe&q=85&s=299d7edb9949e51d03a2c357eb0ce127 2500w" />

1. [/global](/reference/crypto-global) — Display global crypto data such as number of active cryptocurrencies, exchanges and etc.
2. [/search/trending](/reference/trending-search) — Display trending search coins, NFTs and categories.
3. [/coins/top\_gainers\_losers](/reference/coins-top-gainers-losers) — Display the largest gainers in 24hr.
4. [/coins/categories](/reference/coins-categories) — Display all the categories list.
5. [/coins/markets](/reference/coins-markets) — Display all the supported coins with market related data.

### [Coin Page](https://www.coingecko.com/en/coins/bitcoin)

<img src="https://mintcdn.com/coingecko/M02rMX2XJMwBGpCe/images/docs/2f71923-image.png?fit=max&auto=format&n=M02rMX2XJMwBGpCe&q=85&s=4f3f1e9c241ac3c7fb3c6fdfec6f516d" alt="" data-og-width="2104" width="2104" data-og-height="1492" height="1492" data-path="images/docs/2f71923-image.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/coingecko/M02rMX2XJMwBGpCe/images/docs/2f71923-image.png?w=280&fit=max&auto=format&n=M02rMX2XJMwBGpCe&q=85&s=9a71372f238cd241108306680d5a2a46 280w, https://mintcdn.com/coingecko/M02rMX2XJMwBGpCe/images/docs/2f71923-image.png?w=560&fit=max&auto=format&n=M02rMX2XJMwBGpCe&q=85&s=cad968f1b3cf92f47091e006897bd9c8 560w, https://mintcdn.com/coingecko/M02rMX2XJMwBGpCe/images/docs/2f71923-image.png?w=840&fit=max&auto=format&n=M02rMX2XJMwBGpCe&q=85&s=0977ba4c9e4fd44e025685bd4527bfbe 840w, https://mintcdn.com/coingecko/M02rMX2XJMwBGpCe/images/docs/2f71923-image.png?w=1100&fit=max&auto=format&n=M02rMX2XJMwBGpCe&q=85&s=a7bdbd1e213ad62e8763ad00177567e7 1100w, https://mintcdn.com/coingecko/M02rMX2XJMwBGpCe/images/docs/2f71923-image.png?w=1650&fit=max&auto=format&n=M02rMX2XJMwBGpCe&q=85&s=602e29d2123e3681f7f7eca248348f6c 1650w, https://mintcdn.com/coingecko/M02rMX2XJMwBGpCe/images/docs/2f71923-image.png?w=2500&fit=max&auto=format&n=M02rMX2XJMwBGpCe&q=85&s=1931234bdbbc82514affdaf503710e38 2500w" />

1. [/coins/\{id} ](/reference/coins-id)— Display all the coin data including name, price, market related data, website, explorers and etc.
2. [/simple/price](/reference/simple-price) — Display data such as latest coin price, market cap and 24hr trading volume.
3. * [/coins/\{id}/history](/reference/coins-id-history) — Display the historical price data.
   * [/coins/\{id}/market\_chart](/reference/coins-id-market-chart) — Display the historical data in line chart.
   * [/coins/\{id}/ohlc](/reference/coins-id-ohlc) — Display the historical data in candlestick chart.

### [Exchanges Page](https://www.coingecko.com/en/exchanges/hyperliquid-spot)

<img src="https://mintcdn.com/coingecko/M02rMX2XJMwBGpCe/images/docs/9e12298-image.png?fit=max&auto=format&n=M02rMX2XJMwBGpCe&q=85&s=8306154da0e21d2b902eadda23cb7dfc" alt="" data-og-width="2128" width="2128" data-og-height="1394" height="1394" data-path="images/docs/9e12298-image.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/coingecko/M02rMX2XJMwBGpCe/images/docs/9e12298-image.png?w=280&fit=max&auto=format&n=M02rMX2XJMwBGpCe&q=85&s=cad9ee450cbc127562e5bc65d922339a 280w, https://mintcdn.com/coingecko/M02rMX2XJMwBGpCe/images/docs/9e12298-image.png?w=560&fit=max&auto=format&n=M02rMX2XJMwBGpCe&q=85&s=03edf7a33acb4c998656ce6b1007e6ad 560w, https://mintcdn.com/coingecko/M02rMX2XJMwBGpCe/images/docs/9e12298-image.png?w=840&fit=max&auto=format&n=M02rMX2XJMwBGpCe&q=85&s=ba853e66f1bed4efcf8a6a1bf0ad5c6f 840w, https://mintcdn.com/coingecko/M02rMX2XJMwBGpCe/images/docs/9e12298-image.png?w=1100&fit=max&auto=format&n=M02rMX2XJMwBGpCe&q=85&s=ab46e891e1c84ca00961a549e27e9434 1100w, https://mintcdn.com/coingecko/M02rMX2XJMwBGpCe/images/docs/9e12298-image.png?w=1650&fit=max&auto=format&n=M02rMX2XJMwBGpCe&q=85&s=b741c73166b49da858f7a9de5e9dda45 1650w, https://mintcdn.com/coingecko/M02rMX2XJMwBGpCe/images/docs/9e12298-image.png?w=2500&fit=max&auto=format&n=M02rMX2XJMwBGpCe&q=85&s=063b3126d0c4236464345bb4cf9c38d0 2500w" />

1. [/exchanges/\{id}](/reference/exchanges-id) — Display the exchange information such as name, type, market related data such as trading volume and etc.
2. [/exchanges/\{id}/volume\_chart](/reference/exchanges-id-volume-chart) — Display the historical volume chart data.
3. [/exchanges/\{id}/tickers](/reference/exchanges-id-tickers) — Display the exchange's tickers.

### [NFTs Page](https://www.coingecko.com/en/nft/pudgy-penguins)

<img src="https://mintcdn.com/coingecko/M02rMX2XJMwBGpCe/images/docs/cda9241-image.png?fit=max&auto=format&n=M02rMX2XJMwBGpCe&q=85&s=666f359cbc3e65fef656e351617f2b9f" alt="" data-og-width="1845" width="1845" data-og-height="1867" height="1867" data-path="images/docs/cda9241-image.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/coingecko/M02rMX2XJMwBGpCe/images/docs/cda9241-image.png?w=280&fit=max&auto=format&n=M02rMX2XJMwBGpCe&q=85&s=885542d09a7346a1a7000df7cd2a4452 280w, https://mintcdn.com/coingecko/M02rMX2XJMwBGpCe/images/docs/cda9241-image.png?w=560&fit=max&auto=format&n=M02rMX2XJMwBGpCe&q=85&s=16419d75014aab231cda6c6d7596a1da 560w, https://mintcdn.com/coingecko/M02rMX2XJMwBGpCe/images/docs/cda9241-image.png?w=840&fit=max&auto=format&n=M02rMX2XJMwBGpCe&q=85&s=1df3f1689b943b7a3f53d7e6099b0897 840w, https://mintcdn.com/coingecko/M02rMX2XJMwBGpCe/images/docs/cda9241-image.png?w=1100&fit=max&auto=format&n=M02rMX2XJMwBGpCe&q=85&s=5aa83a631e8e6960cbe416b7d4375fbd 1100w, https://mintcdn.com/coingecko/M02rMX2XJMwBGpCe/images/docs/cda9241-image.png?w=1650&fit=max&auto=format&n=M02rMX2XJMwBGpCe&q=85&s=e037c284ec52bb4f9c9c666c8501d99d 1650w, https://mintcdn.com/coingecko/M02rMX2XJMwBGpCe/images/docs/cda9241-image.png?w=2500&fit=max&auto=format&n=M02rMX2XJMwBGpCe&q=85&s=c27add5b7c705a2034414567ab1693de 2500w" />

1. [/nfts/\{id}](/reference/nfts-id) — Display NFT data such as name, contract address, website, market related data such as floor price, market cap, volume and etc.
2. [/nfts/\{id}/market\_chart](/reference/nfts-id-market-chart) — Display the historical market data in chart.
3. [/nfts/\{id}](/reference/nfts-id) — Display the description of the NFT collection.
4. [/nfts/\{id}/tickers](/reference/nfts-id-tickers) — Display the tickers of the NFT collection on different NFT marketplace.

### [Home Page](https://www.geckoterminal.com/)

<img src="https://mintcdn.com/coingecko/Jrf60GKLjFfVX1SS/images/docs/8d5ac53-image.png?fit=max&auto=format&n=Jrf60GKLjFfVX1SS&q=85&s=006779468e238af7cb515c3b90d478b7" alt="" data-og-width="3023" width="3023" data-og-height="1881" height="1881" data-path="images/docs/8d5ac53-image.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/coingecko/Jrf60GKLjFfVX1SS/images/docs/8d5ac53-image.png?w=280&fit=max&auto=format&n=Jrf60GKLjFfVX1SS&q=85&s=1e64c2a847217aeb6a1524ba665d0bb7 280w, https://mintcdn.com/coingecko/Jrf60GKLjFfVX1SS/images/docs/8d5ac53-image.png?w=560&fit=max&auto=format&n=Jrf60GKLjFfVX1SS&q=85&s=98994fc84ed994e69ef12ea133093092 560w, https://mintcdn.com/coingecko/Jrf60GKLjFfVX1SS/images/docs/8d5ac53-image.png?w=840&fit=max&auto=format&n=Jrf60GKLjFfVX1SS&q=85&s=e1f9614a1227137104e693480cb739cb 840w, https://mintcdn.com/coingecko/Jrf60GKLjFfVX1SS/images/docs/8d5ac53-image.png?w=1100&fit=max&auto=format&n=Jrf60GKLjFfVX1SS&q=85&s=de8a324c611cc5b2557a1d130224346a 1100w, https://mintcdn.com/coingecko/Jrf60GKLjFfVX1SS/images/docs/8d5ac53-image.png?w=1650&fit=max&auto=format&n=Jrf60GKLjFfVX1SS&q=85&s=d94dee12678b5c879f5e6ebafe107d4a 1650w, https://mintcdn.com/coingecko/Jrf60GKLjFfVX1SS/images/docs/8d5ac53-image.png?w=2500&fit=max&auto=format&n=Jrf60GKLjFfVX1SS&q=85&s=96c61ccae7576b9f486e28459ca4e963 2500w" />

1. [/onchain/search/pools ](/reference/search-pools)— Allow users to search for pools on GeckoTerminal.
2. [/onchain/networks](/reference/networks-list) — Display a list of supported networks on GeckoTerminal.
3. [/onchain/networks/trending\_pools](/reference/trending-pools-list) — Display a list of trending pools across all networks on GeckoTerminal.
4. [/onchain/networks/new\_pools](/reference/latest-pools-list) — Display all the latest pools across all networks on GeckoTerminal.
5. [/onchain/categories](/reference/categories-list) — Display all the onchain categories on GeckoTerminal.

### [Chain Page](https://www.geckoterminal.com/eth/pools)

<img src="https://mintcdn.com/coingecko/Jrf60GKLjFfVX1SS/images/docs/7b49f3e-image.png?fit=max&auto=format&n=Jrf60GKLjFfVX1SS&q=85&s=26f7cdd8a92a237ac6358be830d42c55" alt="" data-og-width="3023" width="3023" data-og-height="1883" height="1883" data-path="images/docs/7b49f3e-image.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/coingecko/Jrf60GKLjFfVX1SS/images/docs/7b49f3e-image.png?w=280&fit=max&auto=format&n=Jrf60GKLjFfVX1SS&q=85&s=46918d142183d419c4d2ddb6852c2b9e 280w, https://mintcdn.com/coingecko/Jrf60GKLjFfVX1SS/images/docs/7b49f3e-image.png?w=560&fit=max&auto=format&n=Jrf60GKLjFfVX1SS&q=85&s=2b60fc1e44832b2df0b0fa39e01cc6dc 560w, https://mintcdn.com/coingecko/Jrf60GKLjFfVX1SS/images/docs/7b49f3e-image.png?w=840&fit=max&auto=format&n=Jrf60GKLjFfVX1SS&q=85&s=9ce014411117fb3907620cca658c4b81 840w, https://mintcdn.com/coingecko/Jrf60GKLjFfVX1SS/images/docs/7b49f3e-image.png?w=1100&fit=max&auto=format&n=Jrf60GKLjFfVX1SS&q=85&s=4e1b0fb9ea89441c506fe7cd66007e91 1100w, https://mintcdn.com/coingecko/Jrf60GKLjFfVX1SS/images/docs/7b49f3e-image.png?w=1650&fit=max&auto=format&n=Jrf60GKLjFfVX1SS&q=85&s=bc062efdc17e4506c6d1fa9c203e524f 1650w, https://mintcdn.com/coingecko/Jrf60GKLjFfVX1SS/images/docs/7b49f3e-image.png?w=2500&fit=max&auto=format&n=Jrf60GKLjFfVX1SS&q=85&s=ee169d02c1f17780b97daf3ee9e34189 2500w" />

1. [/onchain/networks/\{network}/dexes](/reference/dexes-list) — Display all the supported dex on a network on GeckoTerminal.
2. [/onchain/networks/\{network}/trending\_pools](/reference/trending-pools-network) — Display a list of trending pools on a network on GeckoTerminal.
3. [/onchain/networks/\{network}/new\_pools](/reference/latest-pools-network) — Display a list of new pools on a network on GeckoTerminal.
4. [/onchain/networks/\{network}/pools](/reference/top-pools-network) — Display all the top pools on a network on GeckoTerminal.
5. [/onchain/categories/\{category\_id}/pools](/reference/pools-category) — Display all the pools under a specific onchain category on GeckoTerminal.

### [Pool Page](https://www.geckoterminal.com/eth/pools/0x88e6a0c2ddd26feeb64f039a2c41296fcb3f5640)

<img src="https://mintcdn.com/coingecko/M02rMX2XJMwBGpCe/images/docs/43e04c2-image.png?fit=max&auto=format&n=M02rMX2XJMwBGpCe&q=85&s=dedf21f04c9bbf11fbf376f83b101969" alt="" data-og-width="3023" width="3023" data-og-height="1887" height="1887" data-path="images/docs/43e04c2-image.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/coingecko/M02rMX2XJMwBGpCe/images/docs/43e04c2-image.png?w=280&fit=max&auto=format&n=M02rMX2XJMwBGpCe&q=85&s=6e355b30d2a491ccf540d269d631721c 280w, https://mintcdn.com/coingecko/M02rMX2XJMwBGpCe/images/docs/43e04c2-image.png?w=560&fit=max&auto=format&n=M02rMX2XJMwBGpCe&q=85&s=2088b61a6ae8a189a4249db17fd75928 560w, https://mintcdn.com/coingecko/M02rMX2XJMwBGpCe/images/docs/43e04c2-image.png?w=840&fit=max&auto=format&n=M02rMX2XJMwBGpCe&q=85&s=ced214f96c8c869eca7627410782dc7a 840w, https://mintcdn.com/coingecko/M02rMX2XJMwBGpCe/images/docs/43e04c2-image.png?w=1100&fit=max&auto=format&n=M02rMX2XJMwBGpCe&q=85&s=722d09f605c5a0eabeda3e194f6bd51c 1100w, https://mintcdn.com/coingecko/M02rMX2XJMwBGpCe/images/docs/43e04c2-image.png?w=1650&fit=max&auto=format&n=M02rMX2XJMwBGpCe&q=85&s=4d921a31f241b78515f25be7a698a6ff 1650w, https://mintcdn.com/coingecko/M02rMX2XJMwBGpCe/images/docs/43e04c2-image.png?w=2500&fit=max&auto=format&n=M02rMX2XJMwBGpCe&q=85&s=1f522f2b1fbc4e1cf96c5e4bf7cb3f44 2500w" />

1. * [/onchain/networks/\{network}/pools/\{address}](/reference/pool-address) — Display pool data such as price, transactions, volume and etc.
   * [/onchain/networks/\{network}/pools/\{pool\_address}/info](/reference/pool-token-info-contract-address) — Display pool information such as name, symbol, image URL, description and etc.
2. [/onchain/networks/\{network}/pools/\{pool\_address}/ohlcv/\{timeframe}](/reference/pool-ohlcv-contract-address) — Display the OHLCV chart of the pool.
3. [/onchain/networks/\{network}/pools/\{pool\_address}/trades](/reference/pool-trades-contract-address) — Display the trades of the pool in the past 24 hours.

### [Categories Page](https://www.geckoterminal.com/category)

<img src="https://mintcdn.com/coingecko/Jrf60GKLjFfVX1SS/images/docs/cd8f5e-image.png?fit=max&auto=format&n=Jrf60GKLjFfVX1SS&q=85&s=912a6001736c59cf4fcdbf7bdce05814" alt="" data-og-width="3023" width="3023" data-og-height="1887" height="1887" data-path="images/docs/cd8f5e-image.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/coingecko/Jrf60GKLjFfVX1SS/images/docs/cd8f5e-image.png?w=280&fit=max&auto=format&n=Jrf60GKLjFfVX1SS&q=85&s=c97b53b79138f3e1e2f909e8e563c7fe 280w, https://mintcdn.com/coingecko/Jrf60GKLjFfVX1SS/images/docs/cd8f5e-image.png?w=560&fit=max&auto=format&n=Jrf60GKLjFfVX1SS&q=85&s=84aedbbff60dc6f80fa478d0f389c31c 560w, https://mintcdn.com/coingecko/Jrf60GKLjFfVX1SS/images/docs/cd8f5e-image.png?w=840&fit=max&auto=format&n=Jrf60GKLjFfVX1SS&q=85&s=80ff73fe40ba9b98c15894752d42a981 840w, https://mintcdn.com/coingecko/Jrf60GKLjFfVX1SS/images/docs/cd8f5e-image.png?w=1100&fit=max&auto=format&n=Jrf60GKLjFfVX1SS&q=85&s=331705cce03b7b5aea56d00bc22a294d 1100w, https://mintcdn.com/coingecko/Jrf60GKLjFfVX1SS/images/docs/cd8f5e-image.png?w=1650&fit=max&auto=format&n=Jrf60GKLjFfVX1SS&q=85&s=28fe2d9a7552ce2477be4c616b7f4fad 1650w, https://mintcdn.com/coingecko/Jrf60GKLjFfVX1SS/images/docs/cd8f5e-image.png?w=2500&fit=max&auto=format&n=Jrf60GKLjFfVX1SS&q=85&s=b7750c4ae2c4de27b6b6bedb41c8af96 2500w" />

1. [/onchain/categories](/reference/categories-list) — Display list of onchain categories with market data.
2. [/onchain/categories/\{id}/pools](/reference/pools-category) — Display list of pools with market data of a specific onchain category.

---
