# 📖 文档库 (Documents)

`i18n/zh/documents/` 目录汇总项目的流程文档、架构说明、开发经验与最佳实践，是理解方法论与协作规则的首选入口。

## 目录结构

```
i18n/zh/documents/
├── README.md
│
├── Methodology and Principles/
│   ├── A Formalization of Recursive Self-Optimizing Generative Systems.md
│   ├── gluecoding.md
│   ├── vibe-coding-经验收集.md
│   ├── 学习经验.md
│   ├── 开发经验.md
│   ├── 编程之道.md
│   ├── 胶水编程.md
│   └── 系统提示词构建原则.md
│
├── Tutorials and Guides/
│   ├── auggie-mcp配置文档.md
│   ├── LazyVim快捷键大全.md
│   ├── tmux快捷键大全.md
│   ├── 关于手机ssh任意位置链接本地计算机，基于frp实现的方法.md
│   └── telegram-dev/
│
└── Templates and Resources/
    ├── 代码组织.md
    ├── 工具集.md
    ├── 编程书籍推荐.md
    └── 通用项目架构模板.md
```

## 文档分类

### Methodology and Principles

此类别存放关于编程思想、开发哲学和项目核心原则的文档。

*   `A Formalization of Recursive Self-Optimizing Generative Systems.md`
*   `gluecoding.md`
*   `vibe-coding-经验收集.md`
*   `学习经验.md`
*   `开发经验.md`
*   `编程之道.md`
*   `胶水编程.md`
*   `系统提示词构建原则.md`

### Tutorials and Guides

此类别存放具体工具的配置、使用指南和操作教程。

*   `auggie-mcp配置文档.md`
*   `LazyVim快捷键大全.md`
*   `tmux快捷键大全.md`
*   `关于手机ssh任意位置链接本地计算机，基于frp实现的方法.md`
*   `telegram-dev/`

### Templates and Resources

此类别存放可复用的项目模板、代码结构规范和资源列表。

*   `代码组织.md`
*   `工具集.md`
*   `编程书籍推荐.md`
*   `通用项目架构模板.md`

## 贡献新文档

1.  将文档放置在最合适的分类目录中。
2.  如果需要，可以创建新的分类目录。
3.  更新本 README 文件以反映变更。

## 相关资源

- [提示词库](../prompts/) - AI 提示词集合
- [技能库](../skills/) - AI Skills 技能
- [通用库](../libs/) - 工具与外部集成
