# 💡एआई संकेत (संकेत)

`i18n/zh/prompts/` इस वेयरहाउस की त्वरित शब्द संपत्तियों को संग्रहीत करता है: एआई की सीमाओं और स्वाद को सीमित करने के लिए **सिस्टम प्रॉम्प्ट शब्दों** का उपयोग करें, और "आवश्यकताओं के स्पष्टीकरण → योजना → निष्पादन → समीक्षा" की विकास पाइपलाइन को चलाने के लिए **कार्य शीघ्र शब्दों** का उपयोग करें।

## अनुशंसित पथ (0 से नियंत्रणीय तक)

1. **पहले सीमा निर्धारित करें**: एक सिस्टम प्रॉम्प्ट शब्द संस्करण चुनें (`v8` या `v10` अनुशंसित है)।
2. **पुनः चलाने की प्रक्रिया**: चरण के अनुसार विशिष्ट कार्यों में `coding_prompts/` (स्पष्टीकरण/योजना/निष्पादन/समीक्षा) का चयन करें।
3. **अंतिम उत्पादीकरण**: जब आप किसी निश्चित क्षेत्र में समान कार्य बार-बार करते हैं, तो "कौशल/" (अधिक पुन: प्रयोज्य और अधिक स्थिर) में "संकेत शब्द + जानकारी" को कौशल में अपग्रेड करें।

## निर्देशिका संरचना (गोदाम की वास्तविक निर्देशिका के अधीन)

```
i18n/zh/prompts/
├── README.md
├── coding_prompts/                 # 编程/研发提示词（当前 41 个 .md）
│   ├── index.md                    # 自动生成的索引与版本矩阵（请勿手改）
│   ├── 标准化流程.md
│   ├── 项目上下文文档生成.md
│   ├── 智能需求理解与研发导航引擎.md
│   └── ...
├── system_prompts/                 # 系统提示词（CLAUDE 多版本 + 其他收集）
│   ├── CLAUDE.md/                  # 1~10 版本目录（v9 目前仅占位）
│   │   ├── 1/CLAUDE.md
│   │   ├── 2/CLAUDE.md
│   │   ├── ...
│   │   ├── 9/AGENTS.md             # v9 当前没有 CLAUDE.md
│   │   └── 10/CLAUDE.md
│   └── ...
└── user_prompts/                   # 用户自用/一次性提示词
    ├── ASCII图生成.md
    ├── 数据管道.md
    └── 项目变量与工具统一维护.md
```

## `system_prompts/`: सिस्टम-स्तरीय त्वरित शब्द (पहले AI को "नियंत्रण योग्य बनाएं")

सिस्टम प्रॉम्प्ट शब्दों का उपयोग **कार्य मोड, कोड स्वाद, आउटपुट स्वरूप और सुरक्षा सीमाओं** को परिभाषित करने के लिए किया जाता है। निर्देशिका में एक संस्करणीकृत संरचना है:

- पथ परिपाटी: `i18n/zh/prompts/system_prompts/CLAUDE.md/<संस्करण संख्या>/CLAUDE.md`
- अनुशंसित संस्करण:
  - `v8`: व्यापक संस्करण, सामान्य वाइब कोडिंग के लिए उपयुक्त
  - `v10`: आंशिक ऑगमेंट/संदर्भ इंजन की सामान्यीकरण बाधाएँ
- नोट: `v9` निर्देशिका वर्तमान में केवल एक प्लेसहोल्डर है (कोई `CLAUDE.md` नहीं)

## `कोडिंग_प्रॉम्प्ट्स/`: कार्य-स्तरीय संकेत शब्द (प्रक्रिया के माध्यम से चलाएँ)

`coding_prompts/` "एक कार्य" की ओर उन्मुख है: आवश्यकता स्पष्टीकरण, योजना निराकरण से लेकर वितरण और समीक्षा तक। इसे वर्कफ़्लो स्क्रिप्ट लाइब्रेरी के रूप में उपयोग करने की अनुशंसा की जाती है:

- **प्रवेश स्तर** (नए सत्र/नई परियोजनाओं के लिए आवश्यक)
  - `प्रोजेक्ट संदर्भ दस्तावेज़ पीढ़ी.एमडी`: संदर्भ को मजबूत करें और क्रॉस-सेशन बहाव को कम करें
  - `बुद्धिमान आवश्यकताओं की समझ और आर एंड डी नेविगेशन इंजन.एमडी`: अस्पष्ट आवश्यकताओं को निष्पादन योग्य कार्यों में विभाजित करें
- **डिलीवरी स्तर** (गारंटी आउटपुट ऑडिट योग्य है)
  - `मानकीकृत प्रक्रिया.एमडी`: नियंत्रण के नुकसान को कम करने के लिए "पहले क्या करें और आगे क्या करें" लिखें
  - `सिस्टम आर्किटेक्चर की विज़ुअल पीढ़ी Mermaid.md`: आर्किटेक्चर को विज़ुअलाइज़ेशन में आउटपुट करें (चित्र एक हज़ार शब्दों के बराबर हैं)

### `index.md` के बारे में (महत्वपूर्ण)

[`coding_prompts/index.md`](./coding_prompts/index.md) एक स्वचालित रूप से उत्पन्न सूचकांक है (संस्करण मैट्रिक्स और जंप लिंक सहित), **इसे मैन्युअल रूप से संपादित न करें**। यदि आप बैचों में संस्करण जोड़ते हैं, हटाते/समायोजित करते हैं, तो टूल श्रृंखला के माध्यम से इंडेक्स उत्पन्न करने और फिर उन्हें सिंक्रनाइज़ करने की अनुशंसा की जाती है।

## `user_prompts/`: व्यक्तिगत कार्यक्षेत्र (व्यवस्थितीकरण का अनुसरण नहीं करना)

कुछ व्यक्तिगत आदतें और अस्थायी मचान शीघ्र शब्द डालें। सिद्धांत यह है कि **उपयोग किया जा सकता है, तोड़ें नहीं, मुख्य पुस्तकालय को प्रदूषित न करें**।

## त्वरित उपयोग (कॉपी करें और उपयोग करें)

```bash
# 查看一个任务提示词
sed -n '1,160p' i18n/zh/prompts/coding_prompts/标准化流程.md

# 选定系统提示词版本（建议先备份你当前的 CLAUDE.md）
cp i18n/zh/prompts/system_prompts/CLAUDE.md/10/CLAUDE.md ./CLAUDE.md
```

## रखरखाव और बैच प्रबंधन (वैकल्पिक)

यदि आपको एक्सेल ↔ मार्कडाउन की बैच रखरखाव क्षमताओं की आवश्यकता है, तो वेयरहाउस में अंतर्निहित तृतीय-पक्ष टूल हैं: `लिब्स/एक्सटर्नल/प्रॉम्प्ट्स-लाइब्रेरी/`। इसे "त्वरित शब्द संपत्तियों के लिए उत्पादन उपकरण" और `i18n/zh/prompts/` को "दैनिक विकास के लिए क्यूरेटेड संग्रह" के रूप में सोचने की अनुशंसा की जाती है।

## संबंधित संसाधन

- [`../skills/`](../skills/): उच्च-आवृत्ति डोमेन क्षमताओं को कौशल में परिवर्तित करें (अधिक पुन: प्रयोज्य)
- [`../documents/`](../documents/): कार्यप्रणाली और सर्वोत्तम प्रथाएं (त्वरित शब्द डिजाइन और वर्कफ़्लो सिद्धांत)
- [`../libs/बाहरी/प्रॉम्पट्स-लाइब्रेरी/`](../libs/बाहरी/प्रॉम्पट्स-लाइब्रेरी/): शीघ्र शब्द एक्सेल ↔ मार्कडाउन प्रबंधन उपकरण
