TRANSLATED CONTENT:
# Polymarket Documentation

## Docs

- [Get comments by comment id](https://docs.polymarket.com/api-reference/comments/get-comments-by-comment-id.md)
- [Get comments by user address](https://docs.polymarket.com/api-reference/comments/get-comments-by-user-address.md)
- [List comments](https://docs.polymarket.com/api-reference/comments/list-comments.md)
- [Get closed positions for a user](https://docs.polymarket.com/api-reference/core/get-closed-positions-for-a-user.md): Fetches closed positions for a user(address)
- [Get current positions for a user](https://docs.polymarket.com/api-reference/core/get-current-positions-for-a-user.md): Returns positions filtered by user and optional filters.
- [Get top holders for markets](https://docs.polymarket.com/api-reference/core/get-top-holders-for-markets.md)
- [Get total value of a user's positions](https://docs.polymarket.com/api-reference/core/get-total-value-of-a-users-positions.md)
- [Get trades for a user or markets](https://docs.polymarket.com/api-reference/core/get-trades-for-a-user-or-markets.md)
- [Get user activity](https://docs.polymarket.com/api-reference/core/get-user-activity.md): Returns on-chain activity for a user.
- [Get event by id](https://docs.polymarket.com/api-reference/events/get-event-by-id.md)
- [Get event by slug](https://docs.polymarket.com/api-reference/events/get-event-by-slug.md)
- [Get event tags](https://docs.polymarket.com/api-reference/events/get-event-tags.md)
- [List events](https://docs.polymarket.com/api-reference/events/list-events.md)
- [Health check](https://docs.polymarket.com/api-reference/health/health-check.md)
- [Get market by id](https://docs.polymarket.com/api-reference/markets/get-market-by-id.md)
- [Get market by slug](https://docs.polymarket.com/api-reference/markets/get-market-by-slug.md)
- [Get market tags by id](https://docs.polymarket.com/api-reference/markets/get-market-tags-by-id.md)
- [List markets](https://docs.polymarket.com/api-reference/markets/list-markets.md)
- [Get live volume for an event](https://docs.polymarket.com/api-reference/misc/get-live-volume-for-an-event.md)
- [Get open interest](https://docs.polymarket.com/api-reference/misc/get-open-interest.md)
- [Get total markets a user has traded](https://docs.polymarket.com/api-reference/misc/get-total-markets-a-user-has-traded.md)
- [Get multiple order books summaries by request](https://docs.polymarket.com/api-reference/orderbook/get-multiple-order-books-summaries-by-request.md): Retrieves order book summaries for specified tokens via POST request
- [Get order book summary](https://docs.polymarket.com/api-reference/orderbook/get-order-book-summary.md): Retrieves the order book summary for a specific token
- [Get market price](https://docs.polymarket.com/api-reference/pricing/get-market-price.md): Retrieves the market price for a specific token and side
- [Get midpoint price](https://docs.polymarket.com/api-reference/pricing/get-midpoint-price.md): Retrieves the midpoint price for a specific token
- [Get multiple market prices](https://docs.polymarket.com/api-reference/pricing/get-multiple-market-prices.md): Retrieves market prices for multiple tokens and sides
- [Get multiple market prices by request](https://docs.polymarket.com/api-reference/pricing/get-multiple-market-prices-by-request.md): Retrieves market prices for specified tokens and sides via POST request
- [Get price history for a traded token](https://docs.polymarket.com/api-reference/pricing/get-price-history-for-a-traded-token.md): Fetches historical price data for a specified market token
- [Search markets, events, and profiles](https://docs.polymarket.com/api-reference/search/search-markets-events-and-profiles.md)
- [Get series by id](https://docs.polymarket.com/api-reference/series/get-series-by-id.md)
- [List series](https://docs.polymarket.com/api-reference/series/list-series.md)
- [Get sports metadata information](https://docs.polymarket.com/api-reference/sports/get-sports-metadata-information.md): Retrieves metadata for various sports including images, resolution sources, ordering preferences, tags, and series information. This endpoint provides comprehensive sport configuration data used throughout the platform.
- [List teams](https://docs.polymarket.com/api-reference/sports/list-teams.md)
- [Get bid-ask spreads](https://docs.polymarket.com/api-reference/spreads/get-bid-ask-spreads.md): Retrieves bid-ask spreads for multiple tokens
- [Get related tags (relationships) by tag id](https://docs.polymarket.com/api-reference/tags/get-related-tags-relationships-by-tag-id.md)
- [Get related tags (relationships) by tag slug](https://docs.polymarket.com/api-reference/tags/get-related-tags-relationships-by-tag-slug.md)
- [Get tag by id](https://docs.polymarket.com/api-reference/tags/get-tag-by-id.md)
- [Get tag by slug](https://docs.polymarket.com/api-reference/tags/get-tag-by-slug.md)
- [Get tags related to a tag id](https://docs.polymarket.com/api-reference/tags/get-tags-related-to-a-tag-id.md)
- [Get tags related to a tag slug](https://docs.polymarket.com/api-reference/tags/get-tags-related-to-a-tag-slug.md)
- [List tags](https://docs.polymarket.com/api-reference/tags/list-tags.md)
- [Polymarket Changelog](https://docs.polymarket.com/changelog/changelog.md): Welcome to the Polymarket Changelog. Here you will find any important changes to Polymarket, including but not limited to CLOB, API, UI and Mobile Applications.
- [null](https://docs.polymarket.com/developers/CLOB/authentication.md)
- [null](https://docs.polymarket.com/developers/CLOB/clients.md)
- [null](https://docs.polymarket.com/developers/CLOB/endpoints.md)
- [CLOB Introduction](https://docs.polymarket.com/developers/CLOB/introduction.md)
- [Cancel Orders(s)](https://docs.polymarket.com/developers/CLOB/orders/cancel-orders.md): Multiple endpoints to cancel a single order, multiple orders, all orders or all orders from a single market.
- [Check Order Reward Scoring](https://docs.polymarket.com/developers/CLOB/orders/check-scoring.md): Check if an order is eligble or scoring for Rewards purposes
- [Place Single Order](https://docs.polymarket.com/developers/CLOB/orders/create-order.md): Detailed instructions for creating, placing, and managing orders using Polymarket's CLOB API.
- [Place Multiple Orders (Batching)](https://docs.polymarket.com/developers/CLOB/orders/create-order-batch.md): Instructions for placing multiple orders(Batch)
- [Get Active Orders](https://docs.polymarket.com/developers/CLOB/orders/get-active-order.md)
- [Get Order](https://docs.polymarket.com/developers/CLOB/orders/get-order.md): Get information about an existing order
- [Onchain Order Info](https://docs.polymarket.com/developers/CLOB/orders/onchain-order-info.md)
- [Orders Overview](https://docs.polymarket.com/developers/CLOB/orders/orders.md): Detailed instructions for creating, placing, and managing orders using Polymarket's CLOB API.
- [null](https://docs.polymarket.com/developers/CLOB/status.md)
- [Get Trades](https://docs.polymarket.com/developers/CLOB/trades/trades.md)
- [Trades Overview](https://docs.polymarket.com/developers/CLOB/trades/trades-overview.md)
- [Market Channel](https://docs.polymarket.com/developers/CLOB/websocket/market-channel.md)
- [User Channel](https://docs.polymarket.com/developers/CLOB/websocket/user-channel.md)
- [WSS Authentication](https://docs.polymarket.com/developers/CLOB/websocket/wss-auth.md)
- [WSS Overview](https://docs.polymarket.com/developers/CLOB/websocket/wss-overview.md): Overview and general information about the Polymarket Websocket
- [Deployment and Additional Information](https://docs.polymarket.com/developers/CTF/deployment-resources.md)
- [Merging Tokens](https://docs.polymarket.com/developers/CTF/merge.md)
- [Overview](https://docs.polymarket.com/developers/CTF/overview.md)
- [Reedeeming Tokens](https://docs.polymarket.com/developers/CTF/redeem.md)
- [Splitting USDC](https://docs.polymarket.com/developers/CTF/split.md)
- [RTDS Comments](https://docs.polymarket.com/developers/RTDS/RTDS-comments.md)
- [RTDS Crypto Prices](https://docs.polymarket.com/developers/RTDS/RTDS-crypto-prices.md)
- [Real Time Data Socket](https://docs.polymarket.com/developers/RTDS/RTDS-overview.md)
- [How to Fetch Markets](https://docs.polymarket.com/developers/gamma-markets-api/fetch-markets-guide.md)
- [Gamma Structure](https://docs.polymarket.com/developers/gamma-markets-api/gamma-structure.md)
- [null](https://docs.polymarket.com/developers/gamma-markets-api/overview.md)
- [Overview](https://docs.polymarket.com/developers/neg-risk/overview.md)
- [null](https://docs.polymarket.com/developers/proxy-wallet.md)
- [Resolution](https://docs.polymarket.com/developers/resolution/UMA.md)
- [Liquidity Rewards](https://docs.polymarket.com/developers/rewards/overview.md): Polymarket provides incentives aimed at catalyzing the supply and demand side of the marketplace. Specifically there is a public liquidity rewards program as well as one-off public pnl/volume competitions.
- [null](https://docs.polymarket.com/developers/subgraph/overview.md)
- [Does Polymarket have an API?](https://docs.polymarket.com/polymarket-learn/FAQ/does-polymarket-have-an-api.md): Getting data from Polymarket
- [How To Use Embeds](https://docs.polymarket.com/polymarket-learn/FAQ/embeds.md): Adding market embeds to your Substack or website.
- [How Do I Export My Key?](https://docs.polymarket.com/polymarket-learn/FAQ/how-to-export-private-key.md): Exporting your private key on Magic.Link
- [Is My Money Safe?](https://docs.polymarket.com/polymarket-learn/FAQ/is-my-money-safe.md): Yes. Polymarket is non-custodial, so you're in control of your funds.
- [Is Polymarket The House?](https://docs.polymarket.com/polymarket-learn/FAQ/is-polymarket-the-house.md): No, Polymarket is not the house. All trades happen peer-to-peer (p2p).
- [Polymarket vs. Polling](https://docs.polymarket.com/polymarket-learn/FAQ/polling.md): How is Polymarket better than traditional / legacy polling?
- [Recover Missing Deposit](https://docs.polymarket.com/polymarket-learn/FAQ/recover-missing-deposit.md): If you deposited the wrong cryptocurrency on Ethereum or Polygon, use these tools to recover those funds.
- [Can I Sell Early?](https://docs.polymarket.com/polymarket-learn/FAQ/sell-early.md)
- [How Do I Contact Support?](https://docs.polymarket.com/polymarket-learn/FAQ/support.md): Polymarket offers technical support through our website chat feature, and through Discord.
- [Does Polymarket Have a Token?](https://docs.polymarket.com/polymarket-learn/FAQ/wen-token.md)
- [What is a Prediction Market?](https://docs.polymarket.com/polymarket-learn/FAQ/what-are-prediction-markets.md): How people collectively forecast the future.
- [Why Crypto?](https://docs.polymarket.com/polymarket-learn/FAQ/why-do-i-need-crypto.md): Why Polymarket uses crypto and blockchain technology to create the world’s largest Prediction market.
- [Deposit with Coinbase](https://docs.polymarket.com/polymarket-learn/deposits/coinbase.md): How to buy and deposit USDC to your Polymarket account using Coinbase.
- [How to Withdraw](https://docs.polymarket.com/polymarket-learn/deposits/how-to-withdraw.md): How to withdraw your cash balance from Polymarket.
- [Large Cross Chain Deposits](https://docs.polymarket.com/polymarket-learn/deposits/large-cross-chain-deposits.md)
- [Deposit Using Your Card](https://docs.polymarket.com/polymarket-learn/deposits/moonpay.md): Use MoonPay to deposit cash using your Visa, Mastercard, or bank account.
- [Deposit by Transfering Crypto](https://docs.polymarket.com/polymarket-learn/deposits/supported-tokens.md): Learn what Tokens and Chains are supported for deposit.
- [Deposit USDC on Ethereum](https://docs.polymarket.com/polymarket-learn/deposits/usdc-on-eth.md): How to deposit USDC on the Ethereum Network to your Polymarket account.
- [How to Deposit](https://docs.polymarket.com/polymarket-learn/get-started/how-to-deposit.md): How to add cash to your balance on Polymarket.
- [How to Sign-Up](https://docs.polymarket.com/polymarket-learn/get-started/how-to-signup.md): How to create a Polymarket account.
- [Making Your First Trade](https://docs.polymarket.com/polymarket-learn/get-started/making-your-first-trade.md): How to buy shares.
- [What is Polymarket?](https://docs.polymarket.com/polymarket-learn/get-started/what-is-polymarket.md)
- [How Are Markets Disputed?](https://docs.polymarket.com/polymarket-learn/markets/dispute.md)
- [How Are Markets Clarified?](https://docs.polymarket.com/polymarket-learn/markets/how-are-markets-clarified.md): How are markets on Polymarket clarified?
- [How Are Markets Created?](https://docs.polymarket.com/polymarket-learn/markets/how-are-markets-created.md): Markets are created by the markets team with input from users and the community.
- [How Are Prediction Markets Resolved?](https://docs.polymarket.com/polymarket-learn/markets/how-are-markets-resolved.md): Markets are resolved by the UMA Optimistic Oracle, a smart-contract based optimistic oracle.
- [Trading Fees](https://docs.polymarket.com/polymarket-learn/trading/fees.md)
- [Holding Rewards](https://docs.polymarket.com/polymarket-learn/trading/holding-rewards.md)
- [How Are Prices Calculated?](https://docs.polymarket.com/polymarket-learn/trading/how-are-prices-calculated.md): The prices probabilities displayed on Polymarket are the midpoint of the bid-ask spread in the orderbook.
- [Limit Orders](https://docs.polymarket.com/polymarket-learn/trading/limit-orders.md): What are limit orders and how to make them.
- [Liquidity Rewards](https://docs.polymarket.com/polymarket-learn/trading/liquidity-rewards.md): Learn how to earn rewards merely by placing trades on Polymarket
- [Market Orders](https://docs.polymarket.com/polymarket-learn/trading/market-orders.md): How to buy shares.
- [Does Polymarket Have Trading Limits?](https://docs.polymarket.com/polymarket-learn/trading/no-limits.md)
- [Using the Order Book](https://docs.polymarket.com/polymarket-learn/trading/using-the-orderbook.md): Understanding the Order Book will help you become an advanced trader.
- [Glossary](https://docs.polymarket.com/quickstart/introduction/definitions.md)
- [Developer Quickstart](https://docs.polymarket.com/quickstart/introduction/main.md)
- [API Rate Limits](https://docs.polymarket.com/quickstart/introduction/rate-limits.md)
- [Your First Order](https://docs.polymarket.com/quickstart/orders/first-order.md)
- [WSS Quickstart](https://docs.polymarket.com/quickstart/websocket/WSS-Quickstart.md)


## Optional

- [Polymarket](https://polymarket.com)
- [Discord Community](https://discord.gg/polymarket)
- [Twitter](https://x.com/polymarket)
