TRANSLATED CONTENT:
# Third Party Integrations

Source: anthropics/claude-cookbooks/third_party

## Vector Databases

### Pinecone
- **Location**: `third_party/Pinecone/rag_using_pinecone.ipynb`
- **Use Case**: Retrieval Augmented Generation with vector search
- **Key Concepts**: Embeddings, similarity search, RAG pipeline

## Embeddings

### Voyage AI
- **Location**: `third_party/VoyageAI/how_to_create_embeddings.md`
- **Use Case**: Creating high-quality embeddings for semantic search
- **Key Concepts**: Embedding models, dimensionality, similarity metrics

## Search Integrations

### Wikipedia
- **Location**: `third_party/Wikipedia/wikipedia-search-cookbook.ipynb`
- **Use Case**: Augment Claude with Wikipedia knowledge
- **Key Concepts**: API integration, knowledge retrieval

### Web Pages
- **Location**: `misc/read_web_pages_with_haiku.ipynb`
- **Use Case**: Extract and analyze web page content
- **Key Concepts**: Web scraping, content extraction

## LlamaIndex
- **Location**: `third_party/LlamaIndex/`
- **Use Case**: Advanced document indexing and retrieval
- **Key Concepts**: Index creation, query engines, document loaders

## Deepgram
- **Location**: `third_party/Deepgram/`
- **Use Case**: Audio transcription integration
- **Key Concepts**: Speech-to-text, audio processing
