TRANSLATED CONTENT:
# 精华技术文档生成提示词

## 精华通用版本

```
根据当前项目文件帮我生成技术文档：

【项目信息】
名称: {项目名}
问题: {核心问题}
技术: {技术栈}

【文档结构 - 4部分】

1️⃣ 问题与解决 (300字)
   - 问题是什么
   - 为什么需要解决
   - 如何解决
   - 为什么选这个方案

2️⃣ 技术实现 (300字)
   - 用了哪些技术
   - 每个技术的作用
   - 关键技术点说明
   - 关键参数或配置

3️⃣ 系统架构 (简单流程图)
   - 完整数据流
   - 各部分关系
   - 执行流程

4️⃣ 成果与收益 (200字)
   - 解决了什么
   - 带来了什么好处
   - 可复用的地方
```

---

## CoinGlass项目 - 实际例子

**1️⃣ 问题与解决**

CoinGlass网站的热力图无法通过API获取，且是React动态渲染。

解决方案：使用Playwright浏览器自动化进行截图
- 启动无头浏览器，访问网站，等待动画完成
- 精确截图并裁剪得到纯净热力图

为什么选这个方案：
- API: 网站无公开API ❌
- 爬虫: 无法处理JavaScript动态渲染 ❌
- 截图: 直接获取最终视觉结果，最准确 ✅

**2️⃣ 技术实现**

- **Playwright** - 浏览器自动化框架，控制浏览器行为
- **Chromium** - 无头浏览器引擎，执行JavaScript
- **PIL** - Python图像库，精确裁剪

关键技术点：
- 等待策略：5秒初始 + 7秒动画（确保React渲染和CSS动画完成）
- CSS选择器：`[class*="treemap"]` 定位热力图容器
- 精确裁剪：左-1px、右-1px、上-1px、下-1px → 840×384px → 838×382px（完全无边框）

**3️⃣ 系统架构**

```
Crontab定时任务(每小时)
         ↓
   Python脚本启动
         ↓
Playwright启动浏览器
         ↓
访问网站 → 等待(5秒) → 点击币种 → 等待(7秒)
         ↓
截图(840×384px)
         ↓
PIL裁剪处理(左-1, 右-1, 上-1, 下-1)
         ↓
最终热力图(838×382px)
         ↓
保存本地目录
```

**4️⃣ 成果与收益**

成果：
- ✓ 自动定期获取热力图（无需人工）
- ✓ 100%成功率（完全可靠）
- ✓ 完整历史数据（持久化保存）

好处：
- 效率：从手动5分钟 → 自动16.5秒
- 年度节省：243小时工作时间
- 质量：一致的截图质量

可复用经验：
- Playwright浏览器自动化最佳实践
- 反爬虫检测绕过策略
- 动态渲染页面等待模式

---

*版本: v1.0 (精华版)*
*更新: 2025-10-19*