/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.logging;

import org.apache.nifi.controller.ParameterProviderNode;
import org.apache.nifi.events.BulletinFactory;
import org.apache.nifi.logging.LogLevel;
import org.apache.nifi.logging.LogMessage;
import org.apache.nifi.logging.LogObserver;
import org.apache.nifi.reporting.Bulletin;
import org.apache.nifi.reporting.BulletinRepository;
import org.apache.nifi.reporting.ComponentType;
import org.apache.nifi.reporting.Severity;

public class ParameterProviderLogObserver
implements LogObserver {
    private final BulletinRepository bulletinRepository;
    private final ParameterProviderNode parameterProviderNode;

    public ParameterProviderLogObserver(BulletinRepository bulletinRepository, ParameterProviderNode parameterProviderNode) {
        this.bulletinRepository = bulletinRepository;
        this.parameterProviderNode = parameterProviderNode;
    }

    public void onLogMessage(LogMessage message) {
        String bulletinLevel = message.getLogLevel() == LogLevel.WARN ? Severity.WARNING.name() : message.getLogLevel().toString();
        Bulletin bulletin = BulletinFactory.createBulletin(null, (String)this.parameterProviderNode.getIdentifier(), (ComponentType)ComponentType.PARAMETER_PROVIDER, (String)this.parameterProviderNode.getName(), (String)"Log Message", (String)bulletinLevel, (String)message.getMessage());
        this.bulletinRepository.addBulletin(bulletin);
    }

    public String getComponentDescription() {
        return this.parameterProviderNode.toString();
    }
}

