/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.status.history;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.controller.status.history.GarbageCollectionHistory;
import org.apache.nifi.controller.status.history.GarbageCollectionStatus;

public class StandardGarbageCollectionHistory
implements GarbageCollectionHistory {
    private final Map<String, List<GarbageCollectionStatus>> statusesByManagerName = new HashMap<String, List<GarbageCollectionStatus>>();

    public Set<String> getMemoryManagerNames() {
        return this.statusesByManagerName.keySet();
    }

    public List<GarbageCollectionStatus> getGarbageCollectionStatuses(String memoryManagerName) {
        List<GarbageCollectionStatus> statuses = this.statusesByManagerName.get(memoryManagerName);
        if (statuses == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(statuses);
    }

    public void addGarbageCollectionStatus(GarbageCollectionStatus status) {
        String managerName = status.getMemoryManagerName();
        List statuses = this.statusesByManagerName.computeIfAbsent(managerName, key -> new ArrayList());
        statuses.add(status);
    }
}

