/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.serialization;

import org.apache.nifi.cluster.protocol.DataFlow;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.MissingBundleException;
import org.apache.nifi.controller.UninheritableFlowException;
import org.apache.nifi.controller.XmlFlowSynchronizer;
import org.apache.nifi.controller.serialization.FlowSerializationException;
import org.apache.nifi.controller.serialization.FlowSynchronizationException;
import org.apache.nifi.controller.serialization.FlowSynchronizer;
import org.apache.nifi.controller.serialization.VersionedFlowSynchronizer;
import org.apache.nifi.groups.BundleUpdateStrategy;
import org.apache.nifi.services.FlowService;

public class StandardFlowSynchronizer
implements FlowSynchronizer {
    private final XmlFlowSynchronizer xmlFlowSynchronizer;
    private final VersionedFlowSynchronizer versionedFlowSynchronizer;

    public StandardFlowSynchronizer(XmlFlowSynchronizer xmlFlowSynchronizer, VersionedFlowSynchronizer versionedFlowSynchronizer) {
        this.xmlFlowSynchronizer = xmlFlowSynchronizer;
        this.versionedFlowSynchronizer = versionedFlowSynchronizer;
    }

    @Override
    public void sync(FlowController controller, DataFlow dataFlow, FlowService flowService, BundleUpdateStrategy bundleUpdateStrategy) throws FlowSerializationException, UninheritableFlowException, FlowSynchronizationException, MissingBundleException {
        FlowSynchronizer synchronizer = StandardFlowSynchronizer.isXml(dataFlow) ? this.xmlFlowSynchronizer : this.versionedFlowSynchronizer;
        synchronizer.sync(controller, dataFlow, flowService, bundleUpdateStrategy);
    }

    public static boolean isFlowEmpty(DataFlow dataFlow) {
        if (dataFlow == null || dataFlow.getFlow() == null || dataFlow.getFlow().length == 0) {
            return true;
        }
        if (StandardFlowSynchronizer.isXml(dataFlow)) {
            return XmlFlowSynchronizer.isFlowEmpty(dataFlow.getFlowDocument());
        }
        return VersionedFlowSynchronizer.isFlowEmpty(dataFlow);
    }

    private static boolean isXml(DataFlow dataFlow) {
        if (dataFlow == null || dataFlow.getFlow() == null || dataFlow.getFlow().length == 0) {
            return true;
        }
        return dataFlow.isXml();
    }
}

