/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.pg;

import java.io.IOException;
import java.util.Collections;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.client.nifi.ProcessGroupClient;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.result.VoidResult;
import org.apache.nifi.web.api.dto.VariableDTO;
import org.apache.nifi.web.api.dto.VariableRegistryDTO;
import org.apache.nifi.web.api.entity.VariableEntity;
import org.apache.nifi.web.api.entity.VariableRegistryEntity;
import org.apache.nifi.web.api.entity.VariableRegistryUpdateRequestEntity;

public class PGSetVar
extends AbstractNiFiCommand<VoidResult> {
    public PGSetVar() {
        super("pg-set-var", VoidResult.class);
    }

    @Override
    public String getDescription() {
        return "Sets the value of a variable in the variable registry for the specified process group.";
    }

    @Override
    protected void doInitialize(Context context) {
        this.addOption(CommandOption.PG_ID.createOption());
        this.addOption(CommandOption.PG_VAR_NAME.createOption());
        this.addOption(CommandOption.PG_VAR_VALUE.createOption());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VoidResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException, CommandException {
        String pgId = this.getRequiredArg(properties, CommandOption.PG_ID);
        String varName = this.getRequiredArg(properties, CommandOption.PG_VAR_NAME);
        String varVal = this.getRequiredArg(properties, CommandOption.PG_VAR_VALUE);
        ProcessGroupClient pgClient = client.getProcessGroupClient();
        VariableRegistryEntity variableRegistry = pgClient.getVariables(pgId);
        VariableRegistryDTO variableRegistryDTO = variableRegistry.getVariableRegistry();
        VariableDTO variableDTO = new VariableDTO();
        variableDTO.setName(varName);
        variableDTO.setValue(varVal);
        VariableEntity variableEntity = new VariableEntity();
        variableEntity.setVariable(variableDTO);
        variableRegistryDTO.setVariables(Collections.singleton(variableEntity));
        VariableRegistryUpdateRequestEntity createdUpdateRequest = pgClient.updateVariableRegistry(pgId, variableRegistry);
        String updateRequestId = createdUpdateRequest.getRequest().getRequestId();
        try {
            boolean completed = false;
            for (int i = 0; i < 30; ++i) {
                VariableRegistryUpdateRequestEntity updateRequest = pgClient.getVariableRegistryUpdateRequest(pgId, updateRequestId);
                if (updateRequest != null && updateRequest.getRequest().isComplete()) {
                    completed = true;
                    break;
                }
                try {
                    if (this.getContext().isInteractive()) {
                        this.println("Waiting for update request to complete...");
                    }
                    Thread.sleep(2000L);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (!completed) {
                throw new NiFiClientException("Unable to update variables of process group, cancelling request");
            }
        }
        finally {
            pgClient.deleteVariableRegistryUpdateRequest(pgId, updateRequestId);
        }
        return VoidResult.getInstance();
    }
}

