/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.catalogue;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TxReader;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.CursorFunction;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.FilesFacade;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.datetime.millitime.MillisecondClock;
import io.questdb.std.str.Path;

public class WalTableListFunctionFactory
implements FunctionFactory {
    private static final Log LOG = LogFactory.getLog(WalTableListFunctionFactory.class);
    private static final RecordMetadata METADATA;
    private static final String SIGNATURE = "wal_tables()";
    private static final int nameColumn;
    private static final int sequencerTxnColumn;
    private static final int suspendedColumn;
    private static final int writerTxnColumn;

    @Override
    public String getSignature() {
        return SIGNATURE;
    }

    @Override
    public boolean isRuntimeConstant() {
        return true;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        return new CursorFunction(new WalTableListCursorFactory(configuration, sqlExecutionContext)){

            @Override
            public boolean isRuntimeConstant() {
                return true;
            }
        };
    }

    static {
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        metadata.add(new TableColumnMetadata("name", 11));
        nameColumn = metadata.getColumnCount() - 1;
        metadata.add(new TableColumnMetadata("suspended", 1));
        suspendedColumn = metadata.getColumnCount() - 1;
        metadata.add(new TableColumnMetadata("writerTxn", 6));
        writerTxnColumn = metadata.getColumnCount() - 1;
        metadata.add(new TableColumnMetadata("sequencerTxn", 6));
        sequencerTxnColumn = metadata.getColumnCount() - 1;
        METADATA = metadata;
    }

    private static class WalTableListCursorFactory
    extends AbstractRecordCursorFactory {
        private final TableListRecordCursor cursor;
        private final FilesFacade ff;
        private final SqlExecutionContext sqlExecutionContext;
        private Path rootPath;
        private CairoEngine engine;

        public WalTableListCursorFactory(CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
            super(METADATA);
            this.ff = configuration.getFilesFacade();
            this.rootPath = new Path().of(configuration.getRoot());
            this.sqlExecutionContext = sqlExecutionContext;
            this.cursor = new TableListRecordCursor();
        }

        @Override
        public RecordCursor getCursor(SqlExecutionContext executionContext) {
            this.engine = executionContext.getCairoEngine();
            this.cursor.toTop();
            return this.cursor;
        }

        @Override
        public boolean recordCursorSupportsRandomAccess() {
            return false;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(WalTableListFunctionFactory.SIGNATURE);
        }

        @Override
        protected void _close() {
            this.rootPath = Misc.free(this.rootPath);
        }

        private class TableListRecordCursor
        implements RecordCursor {
            private final TableListRecord record = new TableListRecord();
            private final TxReader txReader = new TxReader(WalTableListCursorFactory.access$200(WalTableListCursorFactory.this));
            private final ObjList<TableToken> tableBucket = new ObjList();
            private int tableIndex = -1;

            private TableListRecordCursor() {
            }

            @Override
            public void close() {
                this.tableIndex = -1;
                this.txReader.close();
            }

            @Override
            public Record getRecord() {
                return this.record;
            }

            @Override
            public Record getRecordB() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasNext() {
                if (this.tableIndex < 0) {
                    WalTableListCursorFactory.this.engine.getTableTokens(this.tableBucket, false);
                    this.tableIndex = -1;
                }
                ++this.tableIndex;
                int n = this.tableBucket.size();
                while (this.tableIndex < n) {
                    TableToken tableToken = this.tableBucket.get(this.tableIndex);
                    if (WalTableListCursorFactory.this.engine.isWalTable(tableToken) && this.record.switchTo(tableToken)) break;
                    ++this.tableIndex;
                }
                return this.tableIndex < n;
            }

            @Override
            public void recordAt(Record record, long atRowId) {
                throw new UnsupportedOperationException();
            }

            @Override
            public long size() {
                return -1L;
            }

            @Override
            public void toTop() {
                this.close();
            }

            public class TableListRecord
            implements Record {
                private long sequencerTxn;
                private boolean suspendedFlag;
                private String tableName;
                private long writerTxn;

                @Override
                public boolean getBool(int col) {
                    if (col == suspendedColumn) {
                        return this.suspendedFlag;
                    }
                    return false;
                }

                @Override
                public long getLong(int col) {
                    if (col == writerTxnColumn) {
                        return this.writerTxn;
                    }
                    if (col == sequencerTxnColumn) {
                        return this.sequencerTxn;
                    }
                    return Long.MIN_VALUE;
                }

                @Override
                public CharSequence getStr(int col) {
                    if (col == nameColumn) {
                        return this.tableName;
                    }
                    return null;
                }

                @Override
                public CharSequence getStrB(int col) {
                    return this.getStr(col);
                }

                @Override
                public int getStrLen(int col) {
                    return this.getStr(col).length();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private boolean switchTo(TableToken tableToken) {
                    this.tableName = tableToken.getTableName();
                    int rootLen = WalTableListCursorFactory.this.rootPath.length();
                    WalTableListCursorFactory.this.rootPath.concat(tableToken).concat("txn_seq");
                    int metaFd = -1;
                    int txnFd = -1;
                    try {
                        metaFd = TableUtils.openRO(WalTableListCursorFactory.this.ff, WalTableListCursorFactory.this.rootPath, "_meta", LOG);
                        txnFd = TableUtils.openRO(WalTableListCursorFactory.this.ff, WalTableListCursorFactory.this.rootPath, "_txnlog", LOG);
                        this.suspendedFlag = WalTableListCursorFactory.this.ff.readNonNegativeByte(metaFd, 28L) > 0;
                        this.sequencerTxn = WalTableListCursorFactory.this.ff.readNonNegativeLong(txnFd, 4L);
                    }
                    finally {
                        WalTableListCursorFactory.this.rootPath.trimTo(rootLen);
                        WalTableListCursorFactory.this.ff.close(metaFd);
                        WalTableListCursorFactory.this.ff.close(txnFd);
                    }
                    WalTableListCursorFactory.this.rootPath.concat(tableToken).concat("_txn").$();
                    TableListRecordCursor.this.txReader.ofRO(WalTableListCursorFactory.this.rootPath, 3);
                    WalTableListCursorFactory.this.rootPath.trimTo(rootLen);
                    CairoEngine engine = WalTableListCursorFactory.this.sqlExecutionContext.getCairoEngine();
                    MillisecondClock millisecondClock = engine.getConfiguration().getMillisecondClock();
                    long spinLockTimeout = engine.getConfiguration().getSpinLockTimeout();
                    TableUtils.safeReadTxn(TableListRecordCursor.this.txReader, millisecondClock, spinLockTimeout);
                    this.writerTxn = TableListRecordCursor.this.txReader.getSeqTxn();
                    return true;
                }
            }
        }
    }
}

