---
summary: "斜杠命令：文本与原生命令、配置和受支持的命令"
read_when:
  - 使用或配置聊天命令时
  - 调试命令路由或权限时
---
# 斜杠命令

命令由网关处理。大多数命令必须作为以 `/` 开头的**独立**消息发送。
仅限主机的 bash 聊天命令使用 `! <cmd>`（`/bash <cmd>` 作为别名）。

有两个相关系统：

- **命令**：独立的 `/...` 消息。
- **指令**：`/think`、`/verbose`、`/reasoning`、`/elevated`、`/exec`、`/model`、`/queue`。
  - 在模型看到消息之前，指令会从消息中被剥离。
  - 在普通聊天消息中（非仅指令），它们被视为"内联提示"，并且**不会**保留会话设置。
  - 在仅包含指令的消息中（消息只包含指令），它们会保留在会话中并回复确认信息。

还有几个**内联快捷方式**（仅限列入白名单/授权的发送者）：`/help`、`/commands`、`/status`、`/whoami`（`/id`）。
它们立即运行，在模型看到消息之前被剥离，剩余文本继续通过正常流程。

## 配置

```json5
{
  commands: {
    native: "auto",
    nativeSkills: "auto",
    text: true,
    bash: false,
    bashForegroundMs: 2000,
    config: false,
    debug: false,
    restart: false,
    useAccessGroups: true
  }
}
```

- `commands.text`（默认值 `true`）启用在聊天消息中解析 `/...`。
  - 在没有原生命令的界面上（WhatsApp/WebChat/Signal/iMessage/Google Chat/MS Teams），即使将此选项设置为 `false`，文本命令仍然有效。
- `commands.native`（默认值 `"auto"`）注册原生命令。
  - 自动：Discord/Telegram 上开启；Slack 上关闭（直到您添加斜杠命令）；对于不支持原生功能的提供商则忽略。
  - 设置 `channels.discord.commands.native`、`channels.telegram.commands.native` 或 `channels.slack.commands.native` 以覆盖每个提供商（布尔值或 `"auto"`）。
  - `false` 在启动时清除 Discord/Telegram 上先前注册的命令。Slack 命令在 Slack 应用中管理，不会自动删除。
- `commands.nativeSkills`（默认值 `"auto"`）在支持时以原生方式注册**技能**命令。
  - 自动：Discord/Telegram 上开启；Slack 上关闭（Slack 需要为每个技能创建一个斜杠命令）。
  - 设置 `channels.discord.commands.nativeSkills`、`channels.telegram.commands.nativeSkills` 或 `channels.slack.commands.nativeSkills` 以覆盖每个提供商（布尔值或 `"auto"`）。
- `commands.bash`（默认值 `false`）启用 `! <cmd>` 来运行主机 shell 命令（`/bash <cmd>` 是别名；需要 `tools.elevated` 白名单）。
- `commands.bashForegroundMs`（默认值 `2000`）控制 bash 在切换到后台模式之前的等待时间（`0` 立即进入后台）。
- `commands.config`（默认值 `false`）启用 `/config`（读取/写入 `openclaw.json`）。
- `commands.debug`（默认值 `false`）启用 `/debug`（仅运行时覆盖）。
- `commands.useAccessGroups`（默认值 `true`）强制执行命令的白名单/策略。

## 命令列表

文本 + 原生（启用时）：
- `/help`
- `/commands`
- `/skill <name> [input]`（按名称运行技能）
- `/status`（显示当前状态；包括当前模型提供商的用量/配额（如果可用））
- `/allowlist`（列出/添加/删除白名单条目）
- `/approve <id> allow-once|allow-always|deny`（解决执行批准提示）
- `/context [list|detail|json]`（解释"上下文"；`detail` 显示每个文件 + 每个工具 + 每个技能 + 系统提示大小）
- `/whoami`（显示您的发送者 ID；别名：`/id`）
- `/subagents list|stop|log|info|send`（检查、停止、记录或向当前会话的子代理运行发送消息）
- `/config show|get|set|unset`（将配置持久化到磁盘，仅所有者；需要 `commands.config: true`）
- `/debug show|set|unset|reset`（运行时覆盖，仅所有者；需要 `commands.debug: true`）
- `/usage off|tokens|full|cost`（每次响应的用量页脚或本地成本摘要）
- `/tts off|always|inbound|tagged|status|provider|limit|summary|audio`（控制 TTS；参见 [/tts](/tts))
  - Discord：原生命令是 `/voice`（Discord 保留 `/tts`）；文本 `/tts` 仍有效。
- `/stop`
- `/restart`
- `/dock-telegram`（别名：`/dock_telegram`）（切换回复到 Telegram）
- `/dock-discord`（别名：`/dock_discord`）（切换回复到 Discord）
- `/dock-slack`（别名：`/dock_slack`）（切换回复到 Slack）
- `/activation mention|always`（仅限群组）
- `/send on|off|inherit`（仅所有者）
- `/reset` 或 `/new [model]`（可选模型提示；其余部分通过）
- `/think <off|minimal|low|medium|high|xhigh>`（根据模型/提供商的动态选择；别名：`/thinking`，`/t`）
- `/verbose on|full|off`（别名：`/v`）
- `/reasoning on|off|stream`（别名：`/reason`；开启时，发送带有 `Reasoning:` 前缀的单独消息；`stream` = 仅 Telegram 草稿）
- `/elevated on|off|ask|full`（别名：`/elev`；`full` 跳过执行批准）
- `/exec host=<sandbox|gateway|node> security=<deny|allowlist|full> ask=<off|on-miss|always> node=<id>`（发送 `/exec` 以显示当前设置）
- `/model <name>`（别名：`/models`；或来自 `agents.defaults.models.*.alias` 的 `/<alias>`）
- `/queue <mode>`（加上类似 `debounce:2s cap:25 drop:summarize` 的选项；发送 `/queue` 以查看当前设置）
- `/bash <command>`（仅限主机；`! <command>` 的别名；需要 `commands.bash: true` + `tools.elevated` 白名单）

仅文本：
- `/compact [instructions]`（参见 [/concepts/compaction](/concepts/compaction))
- `! <command>`（仅限主机；一次一个；长时间运行的作业使用 `!poll` + `!stop`）
- `!poll`（检查输出/状态；接受可选的 `sessionId`；`/bash poll` 同样有效）
- `!stop`（停止正在运行的 bash 作业；接受可选的 `sessionId`；`/bash stop` 同样有效）

注意事项：
- 命令在命令和参数之间接受可选的 `:`（例如 `/think: high`、`/send: on`、`/help:`）。
- `/new <model>` 接受模型别名、`provider/model` 或提供商名称（模糊匹配）；如果没有匹配项，则将文本视为消息正文。
- 要获取完整的提供商用量分解，请使用 `openclaw-cn status --usage`。
- `/allowlist add|remove` 需要 `commands.config=true` 并遵循频道 `configWrites`。
- `/usage` 控制每次响应的用量页脚；`/usage cost` 从 OpenClaw 会话日志打印本地成本摘要。
- `/restart` 默认禁用；设置 `commands.restart: true` 以启用。
- `/verbose` 用于调试和额外可见性；正常使用时请保持**关闭**。
- `/reasoning`（和 `/verbose`）在群组环境中存在风险：可能会暴露您不想公开的内部推理或工具输出。建议将其关闭，尤其是在群聊中。
- **快速路径：**来自列入白名单发送者的仅命令消息会被立即处理（绕过队列 + 模型）。
- **群组提及门控：**来自列入白名单发送者的仅命令消息绕过提及要求。
- **内联快捷方式（仅限列入白名单的发送者）：**某些命令在嵌入普通消息中时也有效，并且在模型看到剩余文本之前被剥离。
  - 示例：`hey /status` 触发状态回复，剩余文本继续通过正常流程。
- 当前：`/help`、`/commands`、`/status`、`/whoami`（`/id`）。
- 未授权的仅命令消息会被静默忽略，内联的 `/...` 标记被视为纯文本。
- **技能命令：**`user-invocable` 技能作为斜杠命令暴露。名称被清理为 `a-z0-9_`（最多 32 个字符）；冲突项获得数字后缀（例如 `_2`）。
  - `/skill <name> [input]` 按名称运行技能（当原生命令限制阻止每技能命令时很有用）。
  - 默认情况下，技能命令作为普通请求转发给模型。
  - 技能可以选择声明 `command-dispatch: tool` 以直接将命令路由到工具（确定性的，无需模型）。
  - 示例：`/prose`（OpenProse 插件）— 参见 [OpenProse](/prose)。
- **原生命令参数：**Discord 对动态选项使用自动补全（以及在省略必需参数时显示按钮菜单）。当命令支持选择且省略参数时，Telegram 和 Slack 显示按钮菜单。

## 用量显示（在哪里显示）

- **提供商用量/配额**（示例：“Claude 80% 剩余”）在启用用量跟踪时出现在 `/status` 中，针对当前模型提供商。
- **每次响应的令牌/成本** 由 `/usage off|tokens|full` 控制（附加到正常回复）。
- `/model status` 关于**模型/认证/端点**，而不是用量。

## 模型选择（`/model`）

`/model` 实现为指令。

示例：

```
/model
/model list
/model 3
/model openai/gpt-5.2
/model opus@anthropic:claude-cli
/model status
```

注意事项：
- `/model` 和 `/model list` 显示紧凑的编号选择器（模型系列 + 可用提供商）。
- `/model <#>` 从该选择器中选择（并在可能时首选当前提供商）。
- `/model status` 显示详细视图，包括配置的提供商端点（`baseUrl`）和 API 模式（`api`）（如果可用）。

## 调试覆盖

`/debug` 让您可以设置**仅运行时**配置覆盖（内存，而非磁盘）。仅所有者。默认禁用；使用 `commands.debug: true` 启用。

示例：

```
/debug show
/debug set messages.responsePrefix="[openclaw-cn]"
/debug set channels.whatsapp.allowFrom=["+1555","+4477"]
/debug unset messages.responsePrefix
/debug reset
```

注意事项：
- 覆盖立即应用于新的配置读取，但**不会**写入 `openclaw.json`。
- 使用 `/debug reset` 清除所有覆盖并返回到磁盘上的配置。

## 配置更新

`/config` 写入磁盘上的配置（`openclaw.json`）。仅所有者。默认禁用；使用 `commands.config: true` 启用。

示例：

```
/config show
/config show messages.responsePrefix
/config get messages.responsePrefix
/config set messages.responsePrefix="[openclaw-cn]"
/config unset messages.responsePrefix
```

注意事项：
- 配置在写入前经过验证；无效更改被拒绝。
- `/config` 更新在重启后持续存在。

## 表面注意事项

- **文本命令** 在正常聊天会话中运行（私信共享 `main`，群组有自己的会话）。
- **原生命令** 使用隔离会话：
  - Discord：`agent:<agentId>:discord:slash:<userId>`
  - Slack：`agent:<agentId>:slack:slash:<userId>`（前缀可通过 `channels.slack.slashCommand.sessionPrefix` 配置）
  - Telegram：`telegram:slash:<userId>`（通过 `CommandTargetSessionKey` 定位聊天会话）
- **`/stop`** 定位活跃聊天会话，以便它可以中止当前运行。
- **Slack：** `channels.slack.slashCommand` 仍支持单个 `/openclaw` 风格的命令。如果启用 `commands.native`，您必须为每个内置命令创建一个 Slack 斜杠命令（与 `/help` 相同名称）。Slack 的命令参数菜单以临时 Block Kit 按钮形式提供。
