---
title: "展示"
description: "社区的真实 Clawdbot 项目"
summary: "由 Clawdbot 提供支持的社区构建项目和集成"
---

# 展示

来自社区的真实项目。看看人们正在用 Clawdbot 构建什么。

<Info>
**想被展示吗？** 在 Discord 的 [#showcase](https://discord.gg/KFTVvJUu) 中分享您的项目或在 X 上 [标记 @clawdbot](https://x.com/clawdbot)。
</Info>

## 🎥 Clawdbot 实战演示

VelvetShark 制作的完整设置教程（28分钟）。

<div
  style={{
    position: "relative",
    paddingBottom: "56.25%",
    height: 0,
    overflow: "hidden",
    borderRadius: 16,
  }}
>
  <iframe
    src="https://www.youtube-nocookie.com/embed/SaWSPZoPX34"
    title="Clawdbot: Siri 本应成为的自托管 AI（完整设置）"
    style={{ position: "absolute", top: 0, left: 0, width: "100%", height: "100%" }}
    frameBorder="0"
    loading="lazy"
    allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
    allowFullScreen
  />
</div>

[在 YouTube 上观看](https://www.youtube.com/watch?v=SaWSPZoPX34)

<div
  style={{
    position: "relative",
    paddingBottom: "56.25%",
    height: 0,
    overflow: "hidden",
    borderRadius: 16,
  }}
>
  <iframe
    src="https://www.youtube-nocookie.com/embed/mMSKQvlmFuQ"
    title="Clawdbot 展示视频"
    style={{ position: "absolute", top: 0, left: 0, width: "100%", height: "100%" }}
    frameBorder="0"
    loading="lazy"
    allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
    allowFullScreen
  />
</div>

[在 YouTube 上观看](https://www.youtube.com/watch?v=mMSKQvlmFuQ)

<div
  style={{
    position: "relative",
    paddingBottom: "56.25%",
    height: 0,
    overflow: "hidden",
    borderRadius: 16,
  }}
>
  <iframe
    src="https://www.youtube-nocookie.com/embed/5kkIJNUGFho"
    title="Clawdbot 社区展示"
    style={{ position: "absolute", top: 0, left: 0, width: "100%", height: "100%" }}
    frameBorder="0"
    loading="lazy"
    allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
    allowFullScreen
  />
</div>

[在 YouTube 上观看](https://www.youtube.com/watch?v=5kkIJNUGFho)

## 🆕 来自 Discord 的新鲜内容

<CardGroup cols={2}>

<Card title="PR 审查 → Telegram 反馈" icon="code-pull-request" href="https://x.com/i/status/2010878524543131691">
  **@bangnokia** • `审查` `github` `telegram`

  OpenCode 完成更改 → 打开 PR → Clawdbot 审查差异并在 Telegram 中回复 "小幅建议" 以及明确的合并判断（包括需要首先应用的关键修复）。

  <img src="/assets/showcase/pr-review-telegram.jpg" alt="Clawdbot PR 审查反馈发送到 Telegram" />
</Card>

<Card title="几分钟内的酒窖技能" icon="wine-glass" href="https://x.com/i/status/2010916352454791216">
  **@prades_maxime** • `技能` `本地` `csv`

  向 "Robby" (@clawdbot) 请求了一个本地酒窖技能。它请求一个示例 CSV 导出 + 存储位置，然后快速构建/测试技能（示例中有 962 瓶酒）。

  <img src="/assets/showcase/wine-cellar-skill.jpg" alt="Clawdbot 从 CSV 构建本地酒窖技能" />
</Card>

<Card title="Tesco 商店自动驾驶" icon="cart-shopping" href="https://x.com/i/status/2009724862470689131">
  **@marchattonhere** • `自动化` `浏览器` `购物`

  每周餐食计划 → 常客 → 预订配送时段 → 确认订单。没有 API，只有浏览器控制。

  <img src="/assets/showcase/tesco-shop.jpg" alt="通过聊天实现 Tesco 商店自动化" />
</Card>

<Card title="SNAG 截图转 Markdown" icon="scissors" href="https://github.com/am-will/snag">
  **@am-will** • `开发工具` `截图` `markdown`

  快捷键截取屏幕区域 → Gemini 视觉 → 立即将 Markdown 放入剪贴板。

  <img src="/assets/showcase/snag.png" alt="SNAG 截图转 markdown 工具" />
</Card>

<Card title="Agents UI" icon="window-maximize" href="https://releaseflow.net/kitze/agents-ui">
  **@kitze** • `UI` `技能` `同步`

  桌面应用，用于管理 Agents、Claude、Codex 和 Clawdbot 之间的技能/命令。

  <img src="/assets/showcase/agents-ui.jpg" alt="Agents UI 应用" />
</Card>

<Card title="Telegram 语音笔记 (papla.media)" icon="microphone" href="https://papla.media/docs">
  **社区** • `语音` `tts` `telegram`

  包装 papla.media TTS 并将结果作为 Telegram 语音笔记发送（没有烦人的自动播放）。

  <img src="/assets/showcase/papla-tts.jpg" alt="来自 TTS 的 Telegram 语音笔记输出" />
</Card>

<Card title="CodexMonitor" icon="eye" href="https://clawdhub.com/odrobnik/codexmonitor">
  **@odrobnik** • `开发工具` `codex` `brew`

  通过 Homebrew 安装的辅助工具，用于列出/检查/监控本地 OpenAI Codex 会话（CLI + VS Code）。

  <img src="/assets/showcase/codexmonitor.png" alt="ClawdHub 上的 CodexMonitor" />
</Card>

<Card title="Bambu 3D 打印机控制" icon="print" href="https://clawdhub.com/tobiasbischoff/bambu-cli">
  **@tobiasbischoff** • `硬件` `3d-printing` `技能`

  控制和排查 BambuLab 打印机：状态、作业、摄像头、AMS、校准等。

  <img src="/assets/showcase/bambu-cli.png" alt="ClawdHub 上的 Bambu CLI 技能" />
</Card>

<Card title="维也纳交通 (Wiener Linien)" icon="train" href="https://clawdhub.com/hjanuschka/wienerlinien">
  **@hjanuschka** • `旅行` `交通` `技能`

  维也纳公共交通的实时出发、中断、电梯状态和路线规划。

  <img src="/assets/showcase/wienerlinien.png" alt="ClawdHub 上的 Wiener Linien 技能" />
</Card>

<Card title="ParentPay 学校餐食" icon="utensils" href="#">
  **@George5562** • `自动化` `浏览器` `育儿`

  通过 ParentPay 自动预订英国学校餐食。使用鼠标坐标进行可靠的表格单元格点击。
</Card>

<Card title="R2 上传 (Send Me My Files)" icon="cloud-arrow-up" href="https://clawdhub.com/skills/r2-upload">
  **@julianengel** • `文件` `r2` `预签名链接`

  上传到 Cloudflare R2/S3 并生成安全的预签名下载链接。非常适合远程 Clawdbot 实例。
</Card>

<Card title="通过 Telegram 的 iOS 应用" icon="mobile" href="#">
  **@coard** • `ios` `xcode` `testflight`

  构建了一个包含地图和语音录音的完整 iOS 应用，完全通过 Telegram 聊天部署到 TestFlight。

  <img src="/assets/showcase/ios-testflight.jpg" alt="TestFlight 上的 iOS 应用" />
</Card>

<Card title="Oura 戒指健康助手" icon="heart-pulse" href="#">
  **@AS** • `健康` `oura` `日历`

  个人 AI 健康助手，将 Oura 戒指数据与日历、预约和健身房安排整合。

  <img src="/assets/showcase/oura-health.png" alt="Oura 戒指健康助手" />
</Card>
<Card title="Kev 的梦之队 (14+ 代理)" icon="robot" href="https://github.com/adam91holt/orchestrated-ai-articles">
  **@adam91holt** • `多代理` `编排` `架构` `宣言`

  一个网关下的 14+ 个代理，使用 Opus 4.5 编排器委托给 Codex 工作者。全面的[技术文章](https://github.com/adam91holt/orchestrated-ai-articles)涵盖了梦之队成员、模型选择、沙盒、webhooks、心跳和委托流程。用于代理沙盒的 [Clawdspace](https://github.com/adam91holt/clawdspace)。[博客文章](https://adams-ai-journey.ghost.io/2026-the-year-of-the-orchestrator/)。
</Card>

<Card title="Linear CLI" icon="terminal" href="https://github.com/Finesssee/linear-cli">
  **@NessZerra** • `开发工具` `linear` `cli` `问题`

  与代理工作流集成的 Linear CLI（Claude Code、Clawdbot）。从终端管理问题、项目和工作流。第一个外部 PR 已合并！
</Card>

<Card title="Beeper CLI" icon="message" href="https://github.com/blqke/beepcli">
  **@jules** • `消息` `beeper` `cli` `自动化`

  通过 Beeper Desktop 读取、发送和归档消息。使用 Beeper 本地 MCP API，因此代理可以在一个地方管理您的所有聊天（iMessage、WhatsApp 等）。
</Card>

</CardGroup>

## 🤖 自动化与工作流

<CardGroup cols={2}>

<Card title="Winix 空气净化器控制" icon="wind" href="https://x.com/antonplex/status/2010518442471006253">
  **@antonplex** • `自动化` `硬件` `空气质量`

  Claude Code 发现并确认了净化器控制，然后 Clawdbot 接管房间空气质量管理。

  <img src="/assets/showcase/winix-air-purifier.jpg" alt="通过 Clawdbot 控制 Winix 空气净化器" />
</Card>

<Card title="美丽天空相机拍摄" icon="camera" href="https://x.com/signalgaining/status/2010523120604746151">
  **@signalgaining** • `自动化` `相机` `技能` `图像`

  由屋顶相机触发：每当天空看起来漂亮时，请 Clawdbot 拍摄天空照片 — 它设计了一个技能并拍下了照片。

  <img src="/assets/showcase/roof-camera-sky.jpg" alt="Clawdbot 捕获的屋顶相机天空快照" />
</Card>

<Card title="视觉晨间简报场景" icon="robot" href="https://x.com/buddyhadry/status/2010005331925954739">
  **@buddyhadry** • `自动化` `简报` `图像` `telegram`

  一个定时提示每天早上生成一张 "场景" 图片（天气、任务、日期、最喜欢的帖子/引用），通过 Clawdbot 人格。
</Card>

<Card title="Padel 球场预订" icon="calendar-check" href="https://github.com/joshp123/padel-cli">
  **@joshp123** • `自动化` `预订` `cli`
  
  Playtomic 可用性检查器 + 预订 CLI。再也不会错过开放球场。
  
  <img src="/assets/showcase/padel-screenshot.jpg" alt="padel-cli 截图" />
</Card>

<Card title="会计接收" icon="file-invoice-dollar">
  **社区** • `自动化` `邮件` `pdf`
  
  从邮件中收集 PDF，为税务顾问准备文件。每月会计自动化。
</Card>

<Card title="沙发土豆开发者模式" icon="couch" href="https://davekiss.com">
  **@davekiss** • `telegram` `网站` `迁移` `astro`

  在看 Netflix 的同时通过 Telegram 重建整个个人网站 — Notion → Astro，迁移了 18 篇帖子，DNS 到 Cloudflare。从未打开笔记本电脑。
</Card>

<Card title="求职代理" icon="briefcase">
  **@attol8** • `自动化` `api` `技能`

  搜索职位列表，与简历关键词匹配，并返回相关机会和链接。使用 JSearch API 在 30 分钟内构建。
</Card>

<Card title="Jira 技能构建器" icon="diagram-project" href="https://x.com/jdrhyne/status/2008336434827002232">
  **@jdrhyne** • `自动化` `jira` `技能` `开发工具`

  Clawdbot 连接到 Jira，然后即时生成新技能（在它存在于 ClawdHub 之前）。
</Card>

<Card title="通过 Telegram 的 Todoist 技能" icon="list-check" href="https://x.com/iamsubhrajyoti/status/2009949389884920153">
  **@iamsubhrajyoti** • `自动化` `todoist` `技能` `telegram`

  自动化 Todoist 任务并让 Clawdbot 直接在 Telegram 聊天中生成技能。
</Card>

<Card title="TradingView 分析" icon="chart-line">
  **@bheem1798** • `金融` `浏览器` `自动化`

  通过浏览器自动化登录 TradingView，截取图表并按需执行技术分析。不需要 API — 只需要浏览器控制。
</Card>

<Card title="Slack 自动支持" icon="slack">
  **@henrymascot** • `slack` `自动化` `支持`

  监控公司 Slack 频道，提供帮助回复，并将通知转发到 Telegram。自主修复了已部署应用程序中的生产错误，无需被要求。
</Card>

</CardGroup>

## 🧠 知识与记忆

<CardGroup cols={2}>

<Card title="xuezh 中文学习" icon="language" href="https://github.com/joshp123/xuezh">
  **@joshp123** • `学习` `语音` `技能`
  
  通过 Clawdbot 进行发音反馈和学习流程的中文学习引擎。
  
  <img src="/assets/showcase/xuezh-pronunciation.jpeg" alt="xuezh 发音反馈" />
</Card>

<Card title="WhatsApp 记忆库" icon="vault">
  **社区** • `记忆` `转录` `索引`
  
  摄取完整的 WhatsApp 导出，转录 1000+ 语音笔记，与 git 日志交叉检查，输出链接的 markdown 报告。
</Card>

<Card title="Karakeep 语义搜索" icon="magnifying-glass" href="https://github.com/jamesbrooksco/karakeep-semantic-search">
  **@jamesbrooksco** • `搜索` `向量` `书签`
  
  使用 Qdrant + OpenAI/Ollama 嵌入为 Karakeep 书签添加向量搜索。
</Card>

<Card title="由内而外-2 记忆" icon="brain">
  **社区** • `记忆` `信念` `自我模型`
  
  独立的记忆管理器，将会话文件转换为记忆 → 信念 → 演进的自我模型。
</Card>

</CardGroup>

## 🎙️ 语音与电话

<CardGroup cols={2}>

<Card title="Clawdia 电话桥接" icon="phone" href="https://github.com/alejandroOPI/clawdia-bridge">
  **@alejandroOPI** • `语音` `vapi` `桥接`
  
  Vapi 语音助手 ↔ Clawdbot HTTP 桥接。与您的代理进行近乎实时的电话通话。
</Card>

<Card title="OpenRouter 转录" icon="microphone" href="https://clawdhub.com/obviyus/openrouter-transcribe">
  **@obviyus** • `转录` `多语言` `技能`

  通过 OpenRouter（Gemini 等）进行多语言音频转录。可在 ClawdHub 上获取。
</Card>

</CardGroup>

## 🏗️ 基础设施与部署

<CardGroup cols={2}>

<Card title="Home Assistant 附加组件" icon="home" href="https://github.com/ngutman/clawdbot-ha-addon">
  **@ngutman** • `homeassistant` `docker` `树莓派`
  
  在 Home Assistant OS 上运行的 Clawdbot 网关，支持 SSH 隧道和持久状态。
</Card>

<Card title="Home Assistant 技能" icon="toggle-on" href="https://clawdhub.com/skills/homeassistant">
  **ClawdHub** • `homeassistant` `技能` `自动化`
  
  通过自然语言控制和自动化 Home Assistant 设备。
</Card>

<Card title="Nix 打包" icon="snowflake" href="https://github.com/clawdbot/nix-clawdbot">
  **@clawdbot** • `nix` `打包` `部署`
  
  包含完整功能的 nixified Clawdbot 配置，用于可重现的部署。
</Card>

<Card title="CalDAV 日历" icon="calendar" href="https://clawdhub.com/skills/caldav-calendar">
  **ClawdHub** • `日历` `caldav` `技能`
  
  使用 khal/vdirsyncer 的日历技能。自托管日历集成。
</Card>

</CardGroup>

## 🏠 家庭与硬件

<CardGroup cols={2}>

<Card title="GoHome 自动化" icon="house-signal" href="https://github.com/joshp123/gohome">
  **@joshp123** • `家庭` `nix` `grafana`
  
  以 Nix 原生的家庭自动化，Clawdbot 作为接口，加上美观的 Grafana 仪表板。
  
  <img src="/assets/showcase/gohome-grafana.png" alt="GoHome Grafana 仪表板" />
</Card>

<Card title="Roborock 扫地机器人" icon="robot" href="https://github.com/joshp123/gohome/tree/main/plugins/roborock">
  **@joshp123** • `扫地机器人` `物联网` `插件`
  
  通过自然对话控制您的 Roborock 扫地机器人。
  
  <img src="/assets/showcase/roborock-screenshot.jpg" alt="Roborock 状态" />
</Card>

</CardGroup>

## 🌟 社区项目

<CardGroup cols={2}>

<Card title="StarSwap 市场" icon="star" href="https://star-swap.com/">
  **社区** • `市场` `天文学` `网页应用`
  
  完整的天文器材市场。围绕 Clawdbot 生态系统构建。
</Card>

</CardGroup>

---

## 提交您的项目

有什么要分享的吗？我们很乐意展示它！

<Steps>
  <Step title="分享它">
    在 Discord 的 [#showcase](https://discord.gg/KFTVvJUu) 中发布或 [在 X 上标记 @clawdbot](https://x.com/clawdbot)
  </Step>
  <Step title="包含详细信息">
    告诉我们它是做什么的，链接到仓库/演示，分享截图（如果有）
  </Step>
  <Step title="获得特色展示">
    我们会将杰出项目添加到此页面
  </Step>
</Steps>
