# 上游合并流程图

## 整体流程

```
┌─────────────────────────────────────────────────────────────────┐
│                         开始合并流程                              │
└─────────────────┬───────────────────────────────────────────────┘
                  │
                  ▼
        ┌─────────────────────┐
        │  运行预检查          │◄────┐
        │ pre-merge-check.sh  │     │
        └─────────┬───────────┘     │
                  │                  │
                  ▼                  │
            检查是否通过？            │
                  │                  │
          ┌───────┴───────┐          │
          │ 否            │ 是       │ 修复问题
          ▼               ▼          │
    显示错误信息     继续流程         │
          │               │          │
          └───────────────┘──────────┘
                  │
                  ▼
        ┌─────────────────────┐
        │  创建备份分支        │
        │ backup-before-merge │
        └─────────┬───────────┘
                  │
                  ▼
        ┌─────────────────────┐
        │  创建合并分支        │
        │ merge-upstream-DATE │
        └─────────┬───────────┘
                  │
                  ▼
        ┌─────────────────────┐
        │  配置 upstream      │
        │  git remote add     │
        └─────────┬───────────┘
                  │
                  ▼
        ┌─────────────────────┐
        │  获取上游更新        │
        │  git fetch upstream │
        └─────────┬───────────┘
                  │
                  ▼
        ┌─────────────────────────────────────┐
        │        选择合并策略                   │
        └─┬───────────┬───────────┬───────────┘
          │           │           │
    策略1 │     策略2 │     策略3 │
          │           │           │
          ▼           ▼           ▼
    ┌─────────┐ ┌─────────┐ ┌──────────────┐
    │完整合并 │ │部分合并 │ │ Cherry-pick  │
    │ merge   │ │merge SHA│ │ pick commits │
    └────┬────┘ └────┬────┘ └──────┬───────┘
         │           │              │
         └───────────┴──────────────┘
                     │
                     ▼
               是否有冲突？
                     │
         ┌───────────┴───────────┐
         │ 否                    │ 是
         │                       │
         ▼                       ▼
   跳到测试阶段        ┌─────────────────────┐
                       │  运行冲突分类工具    │
                       │ classify-conflicts  │
                       └─────────┬───────────┘
                                 │
                                 ▼
                     ┌────────────────────────┐
                     │  自动处理简单冲突      │
                     │  • 保留本地: README   │
                     │  • 采用上游: src/infra│
                     └────────┬───────────────┘
                              │
                              ▼
                     ┌────────────────────────┐
                     │  手动处理复杂冲突      │
                     │  • package.json       │
                     │  • src/cli/*          │
                     │  • 中文化文件         │
                     └────────┬───────────────┘
                              │
                              ▼
                     每个文件: git add
                              │
                              ▼
                     git merge --continue
                              │
         ┌────────────────────┴────────────────────┐
         │                                         │
         ▼                                         ▼
   ┌─────────────────────┐              ┌────────────────────┐
   │  同步版本号          │              │   运行测试          │
   │  sync-version.sh    │              │  pnpm build        │
   │  X.Y.Z → X.Y.Z-cn.N │              │  pnpm test         │
   └─────────┬───────────┘              └────────┬───────────┘
             │                                   │
             └───────────────┬───────────────────┘
                             │
                             ▼
                       测试是否通过？
                             │
                 ┌───────────┴───────────┐
                 │ 否                    │ 是
                 │                       │
                 ▼                       ▼
           修复问题并重新测试      ┌──────────────────┐
                 │                │  推送到远程       │
                 │                │  git push origin  │
                 │                └────────┬─────────┘
                 │                         │
                 └─────────────────────────┘
                                          │
                                          ▼
                                ┌──────────────────┐
                                │  创建 PR 审查    │
                                └────────┬─────────┘
                                         │
                                         ▼
                                ┌──────────────────┐
                                │  合并到 main     │
                                └────────┬─────────┘
                                         │
                                         ▼
                                ┌──────────────────┐
                                │  完成！          │
                                │  清理分支        │
                                └──────────────────┘
```

## 冲突处理决策树

```
                        发现冲突文件
                             │
                             ▼
                    ┌────────────────────┐
                    │  文件类型判断      │
                    └────┬──────┬────┬───┘
                         │      │    │
           ┌─────────────┘      │    └──────────────┐
           │                    │                   │
           ▼                    ▼                   ▼
    ┌──────────────┐    ┌──────────────┐    ┌─────────────┐
    │ 文档/配置    │    │ 核心代码      │    │ 混合文件    │
    │ README.md    │    │ src/infra/*   │    │package.json │
    │ docs/*       │    │ src/media/*   │    │ src/cli/*   │
    │ workflows    │    │ src/providers*│    │ .env.example│
    └──────┬───────┘    └──────┬───────┘    └──────┬──────┘
           │                   │                    │
           ▼                   ▼                    ▼
    保留本地版本         采用上游版本          需要手动合并
    git checkout         git checkout        编辑解决冲突
    --ours               --theirs            保留中文+上游逻辑
           │                   │                    │
           └───────────────────┴────────────────────┘
                              │
                              ▼
                        git add <file>
```

## 版本号演进

```
时间线：
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

上游 openclaw:
  v2026.1.15  ───→  v2026.1.24  ───→  v2026.1.30
                         ↑                  ↑
                         │                  │
本地 openclaw-cn:        │                  │
  v2026.1.15-cn.1 ───→  │                  │
                         │                  │
                    分叉点                  │
                                            │
                                      合并后新版本
                                            ↓
                                    v2026.1.30-cn.1


版本号规则：
━━━━━━━━━━
<上游版本>-cn.<补丁号>

示例：
  上游: 2026.1.30
  本地: 2026.1.30-cn.1  (首次同步到此版本)
       2026.1.30-cn.2  (第二次修复/更新)
```

## 文件分类矩阵

```
┌─────────────────────────────────────────────────────────────────┐
│                          文件分类                                │
├───────────────────┬─────────────────┬───────────────────────────┤
│   文件类型        │   处理策略      │        示例               │
├───────────────────┼─────────────────┼───────────────────────────┤
│ 文档 (中文化)     │ 保留本地 (ours)│ README.md                 │
│                   │                 │ FEISHU_NPM_READY.md       │
│                   │                 │ docs/_config.yml          │
├───────────────────┼─────────────────┼───────────────────────────┤
│ 自定义配置        │ 保留本地 (ours)│ .github/workflows/*.yml   │
│                   │                 │ docs/CNAME                │
├───────────────────┼─────────────────┼───────────────────────────┤
│ 核心功能代码      │采用上游(theirs)│ src/infra/*               │
│                   │                 │ src/media/*               │
│                   │                 │ src/providers/*           │
├───────────────────┼─────────────────┼───────────────────────────┤
│ 测试文件          │采用上游(theirs)│ **/*.test.ts              │
│                   │                 │ test/*                    │
├───────────────────┼─────────────────┼───────────────────────────┤
│ 包配置            │ 手动合并        │ package.json              │
│                   │                 │ .env.example              │
├───────────────────┼─────────────────┼───────────────────────────┤
│ UI/CLI (中文提示) │ 手动合并        │ src/cli/*                 │
│                   │                 │ src/commands/*            │
│                   │                 │ src/gateway/config/*      │
└───────────────────┴─────────────────┴───────────────────────────┘
```

## 工具使用时机

```
阶段              工具                     作用
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
准备阶段          pre-merge-check.sh      检查环境和依赖
  ↓
开始合并          merge-wizard.sh         引导整个流程
  ↓               (可选，自动调用其他工具)
执行合并          git merge
  ↓
冲突处理          classify-conflicts.sh   自动分类和处理冲突
  ↓
版本更新          sync-version.sh         同步版本号
  ↓
测试验证          pnpm build/test         构建和测试
  ↓
完成              git push                推送到远程
```

## 快速参考卡片

```
╔═══════════════════════════════════════════════════════════════╗
║                     快速命令参考                              ║
╠═══════════════════════════════════════════════════════════════╣
║                                                               ║
║  一键合并:                                                    ║
║  $ ./scripts/merge-helpers/merge-wizard.sh                   ║
║                                                               ║
║  只检查环境:                                                  ║
║  $ ./scripts/merge-helpers/pre-merge-check.sh                ║
║                                                               ║
║  处理冲突:                                                    ║
║  $ ./scripts/merge-helpers/classify-conflicts.sh             ║
║                                                               ║
║  同步版本:                                                    ║
║  $ ./scripts/merge-helpers/sync-version.sh                   ║
║                                                               ║
║  回滚合并:                                                    ║
║  $ git reset --hard backup-before-merge                      ║
║                                                               ║
║  查看差异:                                                    ║
║  $ git diff --name-status upstream/main..HEAD                ║
║                                                               ║
║  手动解决冲突:                                                ║
║  $ git checkout --ours <file>    # 保留本地                  ║
║  $ git checkout --theirs <file>  # 采用上游                  ║
║                                                               ║
╚═══════════════════════════════════════════════════════════════╝
```

## 推荐阅读顺序

```
1️⃣  QUICKSTART_MERGE.md         ← 从这里开始！
    ↓
2️⃣  scripts/merge-helpers/README.md   工具使用说明
    ↓
3️⃣  MERGE_UPSTREAM_STRATEGY.md  详细策略（需要时查阅）
    ↓
4️⃣  MERGE_FLOW_DIAGRAM.md       本文档（流程可视化）
```

---

**提示**: 保存此文档作为快速参考！
