/**
 * Enums define for all #define in phnt.h
 * Not include #define which already defined in Windows Kit (SDK)
 * Created by HTC - 2024
 */

#pragma once

#ifndef _ENUMS_PHNT_H_
#define _ENUMS_PHNT_H_

#define WIN32_NO_STATUS

#include <windows.h>
#include <evntrace.h>

#pragma region phnt_windows.h

enum DESKTOP_ACCESS_MASK
{
    DESKTOP_ALL_ACCESS = (DESKTOP_CREATEMENU | DESKTOP_CREATEWINDOW | DESKTOP_ENUMERATE |
        DESKTOP_HOOKCONTROL | DESKTOP_JOURNALPLAYBACK | DESKTOP_JOURNALRECORD |
        DESKTOP_READOBJECTS | DESKTOP_SWITCHDESKTOP | DESKTOP_WRITEOBJECTS |
        STANDARD_RIGHTS_REQUIRED),
        DESKTOP_GENERIC_READ = (DESKTOP_ENUMERATE | DESKTOP_READOBJECTS | STANDARD_RIGHTS_READ),
        DESKTOP_GENERIC_WRITE = (DESKTOP_CREATEMENU | DESKTOP_CREATEWINDOW | DESKTOP_HOOKCONTROL |
            DESKTOP_JOURNALPLAYBACK | DESKTOP_JOURNALRECORD | DESKTOP_WRITEOBJECTS |
            STANDARD_RIGHTS_WRITE),
        DESKTOP_GENERIC_EXECUTE = (DESKTOP_SWITCHDESKTOP | STANDARD_RIGHTS_EXECUTE),
};

enum WINDOW_STATION_ACCESS_MASK
{
    WINSTA_GENERIC_READ = (WINSTA_ENUMDESKTOPS | WINSTA_ENUMERATE | WINSTA_READATTRIBUTES | WINSTA_READSCREEN | STANDARD_RIGHTS_READ),
    WINSTA_GENERIC_WRITE = (WINSTA_ACCESSCLIPBOARD | WINSTA_CREATEDESKTOP | WINSTA_WRITEATTRIBUTES | STANDARD_RIGHTS_WRITE),
    WINSTA_GENERIC_EXECUTE = (WINSTA_ACCESSGLOBALATOMS | WINSTA_EXITWINDOWS | STANDARD_RIGHTS_EXECUTE),
};

enum WMI_ACCESS_MASK
{
    WMIGUID_GENERIC_READ = (WMIGUID_QUERY | WMIGUID_NOTIFICATION | WMIGUID_READ_DESCRIPTION | STANDARD_RIGHTS_READ),
    WMIGUID_GENERIC_WRITE = (WMIGUID_SET | TRACELOG_CREATE_REALTIME | TRACELOG_CREATE_ONDISK | STANDARD_RIGHTS_WRITE),
    WMIGUID_GENERIC_EXECUTE = (WMIGUID_EXECUTE | TRACELOG_GUID_ENABLE | TRACELOG_LOG_EVENT |
        TRACELOG_ACCESS_REALTIME | TRACELOG_REGISTER_GUIDS | STANDARD_RIGHTS_EXECUTE),
};

enum NONAME_PHNT
{
    MAXIMUM_LEADBYTES = 12,
    RTL_BALANCED_NODE_RESERVED_PARENT_MASK = 3,
    LDR_ADDREF_DLL_PIN = 0x00000001,
    LDR_GET_PROCEDURE_ADDRESS_DONT_RECORD_FORWARDER = 0x00000001,
    LDR_UNLOCK_LOADER_LOCK_FLAG_RAISE_ON_ERRORS = 0x00000001,
    MAILSLOT_SIZE_AUTO = 0,
};

#pragma endregion phnt_windows.h

#pragma region phnt_ntdef.h

enum OBJ_FLAGS
{
    OBJ_PROTECT_CLOSE = 0x00000001L,
    OBJ_INHERIT = 0x00000002L,
    OBJ_AUDIT_OBJECT_CLOSE = 0x00000004L,
    OBJ_NO_RIGHTS_UPGRADE = 0x00000008L,
    OBJ_PERMANENT = 0x00000010L,
    OBJ_EXCLUSIVE = 0x00000020L,
    OBJ_CASE_INSENSITIVE = 0x00000040L,
    OBJ_OPENIF = 0x00000080L,
    OBJ_OPENLINK = 0x00000100L,
    OBJ_KERNEL_HANDLE = 0x00000200L,
    OBJ_FORCE_ACCESS_CHECK = 0x00000400L,
    OBJ_IGNORE_IMPERSONATED_DEVICEMAP = 0x00000800L,
    OBJ_DONT_REPARSE = 0x00001000L,
    OBJ_VALID_ATTRIBUTES = 0x00001FF2L,
};

#pragma endregion phnt_ntdef.h

#pragma region ntldr.h

enum LDR_DATA_TABLE_ENTRY_FLAGS
{
    LDRP_PACKAGED_BINARY = 0x00000001,
    LDRP_MARKED_FOR_REMOVAL = 0x00000002,
    LDRP_IMAGE_DLL = 0x00000004,
    LDRP_LOAD_NOTIFICATIONS_SENT = 0x00000008,
    LDRP_TELEMETRY_ENTRY_PROCESSED = 0x00000010,
    LDRP_PROCESS_STATIC_IMPORT = 0x00000020,
    LDRP_IN_LEGACY_LISTS = 0x00000040,
    LDRP_IN_INDEXES = 0x00000080,
    LDRP_SHIM_DLL = 0x00000100,
    LDRP_IN_EXCEPTION_TABLE = 0x00000200,
    LDRP_LOAD_IN_PROGRESS = 0x00001000,
    LDRP_LOAD_CONFIG_PROCESSED = 0x00002000,
    LDRP_ENTRY_PROCESSED = 0x00004000,
    LDRP_PROTECT_DELAY_LOAD = 0x00008000,
    LDRP_DONT_CALL_FOR_THREADS = 0x00040000,
    LDRP_PROCESS_ATTACH_CALLED = 0x00080000,
    LDRP_PROCESS_ATTACH_FAILED = 0x00100000,
    LDRP_COR_DEFERRED_VALIDATE = 0x00200000,
    LDRP_COR_IMAGE = 0x00400000,
    LDRP_DONT_RELOCATE = 0x00800000,
    LDRP_COR_IL_ONLY = 0x01000000,
    LDRP_CHPE_IMAGE = 0x02000000,
    LDRP_CHPE_EMULATOR_IMAGE = 0x04000000,
    LDRP_REDIRECTED = 0x10000000,
    LDRP_COMPAT_DATABASE_PROCESSED = 0x80000000,
};

enum LDR_GET_DLL_HANDLE_EX_FLAGS
{
    LDR_GET_DLL_HANDLE_EX_UNCHANGED_REFCOUNT = 0x00000001,
    LDR_GET_DLL_HANDLE_EX_PIN = 0x00000002,
};

enum LDR_LOCK_LOADER_LOCK_FLAGS
{
    LDR_LOCK_LOADER_LOCK_FLAG_RAISE_ON_ERRORS = 0x00000001,
    LDR_LOCK_LOADER_LOCK_FLAG_TRY_ONLY = 0x00000002,
};

enum LDR_LOCK_LOADER_LOCK_DISPOSITION
{
    LDR_LOCK_LOADER_LOCK_DISPOSITION_INVALID = 0,
    LDR_LOCK_LOADER_LOCK_DISPOSITION_LOCK_ACQUIRED = 1,
    LDR_LOCK_LOADER_LOCK_DISPOSITION_LOCK_NOT_ACQUIRED = 2,
};

enum LDR_DLL_NOTIFICATION_REASON_FLAGS
{
    LDR_DLL_NOTIFICATION_REASON_LOADED = 1,
    LDR_DLL_NOTIFICATION_REASON_UNLOADED = 2,
};

enum RESOURCE_LEVELS
{
    RESOURCE_TYPE_LEVEL = 0,
    RESOURCE_NAME_LEVEL = 1,
    RESOURCE_LANGUAGE_LEVEL = 2,
    RESOURCE_DATA_LEVEL = 3,
};

enum ENCLAVE_STATES
{
    ENCLAVE_STATE_CREATED = 0x00000000ul,
    ENCLAVE_STATE_INITIALIZED = 0x00000001ul,
    ENCLAVE_STATE_INITIALIZED_VBS = 0x00000002ul,
};

#pragma endregion ntldr.h

#pragma region ntexapi.h

enum EFI_VARIABLE_ATTRIBUTES
{
    EFI_VARIABLE_NON_VOLATILE = 0x00000001,
    EFI_VARIABLE_BOOTSERVICE_ACCESS = 0x00000002,
    EFI_VARIABLE_RUNTIME_ACCESS = 0x00000004,
    EFI_VARIABLE_HARDWARE_ERROR_RECORD = 0x00000008,
    EFI_VARIABLE_AUTHENTICATED_WRITE_ACCESS = 0x00000010,
    EFI_VARIABLE_TIME_BASED_AUTHENTICATED_WRITE_ACCESS = 0x00000020,
    EFI_VARIABLE_APPEND_WRITE = 0x00000040,
    EFI_VARIABLE_ENHANCED_AUTHENTICATED_ACCESS = 0x00000080,
};

enum EVENT_ACCESS_MASK
{
    _EVENT_QUERY_STATE = 0x0001,
    _EVENT_MODIFY_STATE = 0x0002,
    _EVENT_ALL_ACCESS = (_EVENT_QUERY_STATE | _EVENT_MODIFY_STATE | STANDARD_RIGHTS_REQUIRED | SYNCHRONIZE),
    EVENT_PAIR_ALL_ACCESS = (STANDARD_RIGHTS_REQUIRED | SYNCHRONIZE),
};

enum MUTANT_ACCESS_MASK
{
    _MUTANT_QUERY_STATE = 0x0001,
    _MUTANT_ALL_ACCESS = (MUTANT_QUERY_STATE | STANDARD_RIGHTS_REQUIRED | SYNCHRONIZE),
};

enum SEMAPHORE_ACCESS_MASK
{
    _SEMAPHORE_QUERY_STATE = 0x0001,
    _SEMAPHORE_MODIFY_STATE = 0x002,
    _SEMAPHORE_ALL_ACCESS = (_SEMAPHORE_QUERY_STATE | _SEMAPHORE_MODIFY_STATE | STANDARD_RIGHTS_REQUIRED | SYNCHRONIZE)
};

enum PROFILER_ACCESS_MASK
{
    PROFILE_CONTROL = 0x0001,
    PROFILE_ALL_ACCESS = (STANDARD_RIGHTS_REQUIRED | PROFILE_CONTROL),
};

enum KEYEDEVENT_ACCESS_MASK
{
    KEYEDEVENT_WAIT = 0x0001,
    KEYEDEVENT_WAKE = 0x0002,
    KEYEDEVENT_ALL_ACCESS = (STANDARD_RIGHTS_REQUIRED | KEYEDEVENT_WAIT | KEYEDEVENT_WAKE),
};

enum WORKER_FACTORY_ACCESS_MASK
{
    WORKER_FACTORY_RELEASE_WORKER = 0x0001,
    WORKER_FACTORY_WAIT = 0x0002,
    WORKER_FACTORY_SET_INFORMATION = 0x0004,
    WORKER_FACTORY_QUERY_INFORMATION = 0x0008,
    WORKER_FACTORY_READY_WORKER = 0x0010,
    WORKER_FACTORY_SHUTDOWN = 0x0020,
    WORKER_FACTORY_ALL_ACCESS = (STANDARD_RIGHTS_REQUIRED |
        WORKER_FACTORY_RELEASE_WORKER |
        WORKER_FACTORY_WAIT |
        WORKER_FACTORY_SET_INFORMATION |
        WORKER_FACTORY_QUERY_INFORMATION |
        WORKER_FACTORY_READY_WORKER |
        WORKER_FACTORY_SHUTDOWN),
};

enum SYSTEM_PROCESSOR_FEATURE_BITS
{
    KF_V86_VIS = 0x00000001,
    KF_RDTSC = 0x00000002,
    KF_CR4 = 0x00000004,
    KF_CMOV = 0x00000008,
    KF_GLOBAL_PAGE = 0x00000010,
    KF_LARGE_PAGE = 0x00000020,
    KF_MTRR = 0x00000040,
    KF_CMPXCHG8B = 0x00000080,
    KF_MMX = 0x00000100,
    KF_WORKING_PTE = 0x00000200,
    KF_PAT = 0x00000400,
    KF_FXSR = 0x00000800,
    KF_FAST_SYSCALL = 0x00001000,
    KF_XMMI = 0x00002000,
    KF_3DNOW = 0x00004000,
    KF_AMDK6MTRR = 0x00008000,
    KF_XMMI64 = 0x00010000,
    KF_DTS = 0x00020000,
    KF_NOEXECUTE = 0x20000000,
    KF_GLOBAL_32BIT_EXECUTE = 0x40000000,
    KF_GLOBAL_32BIT_NOEXECUTE = 0x80000000,
    KF_BRANCH = 0x0000000000020000,
    KF_XSTATE = 0x0000000000800000,
    KF_RDTSCP = 0x0000000400000000,
    KF_CET_SS = 0x0000400000000000,
    KF_XFD = 0x0080000000000000,
};

enum SYSTEM_FILECACHE_INFORMATION_FLAGS
{
    MM_WORKING_SET_MAX_HARD_ENABLE = 0x1,
    MM_WORKING_SET_MAX_HARD_DISABLE = 0x2,
    MM_WORKING_SET_MIN_HARD_ENABLE = 0x4,
    MM_WORKING_SET_MIN_HARD_DISABLE = 0x8,
};

enum MAXIMUM_NODE_COUNT
{
    MAXIMUM_NODE_COUNT_X64 = 0x40,
    MAXIMUM_NODE_COUNT_X86 = 0x10
};

enum SYSTEM_CODEINTEGRITY_OPTIONS
{
    CODEINTEGRITY_OPTION_ENABLED = 0x01,
    CODEINTEGRITY_OPTION_TESTSIGN = 0x02,
    CODEINTEGRITY_OPTION_UMCI_ENABLED = 0x04,
    CODEINTEGRITY_OPTION_UMCI_AUDITMODE_ENABLED = 0x08,
    CODEINTEGRITY_OPTION_UMCI_EXCLUSIONPATHS_ENABLED = 0x10,
    CODEINTEGRITY_OPTION_TEST_BUILD = 0x20,
    CODEINTEGRITY_OPTION_PREPRODUCTION_BUILD = 0x40,
    CODEINTEGRITY_OPTION_DEBUGMODE_ENABLED = 0x80,
    CODEINTEGRITY_OPTION_FLIGHT_BUILD = 0x100,
    CODEINTEGRITY_OPTION_FLIGHTING_ENABLED = 0x200,
    CODEINTEGRITY_OPTION_HVCI_KMCI_ENABLED = 0x400,
    CODEINTEGRITY_OPTION_HVCI_KMCI_AUDITMODE_ENABLED = 0x800,
    CODEINTEGRITY_OPTION_HVCI_KMCI_STRICTMODE_ENABLED = 0x1000,
    CODEINTEGRITY_OPTION_HVCI_IUM_ENABLED = 0x2000,
    CODEINTEGRITY_OPTION_WHQL_ENFORCEMENT_ENABLED = 0x4000,
    CODEINTEGRITY_OPTION_WHQL_AUDITMODE_ENABLED = 0x8000,
};

enum SYSTEM_INFORMATION_VERSIONS
{
    SYSTEM_STORE_INFORMATION_VERSION = 1,
    SYSTEM_STORE_STATS_INFORMATION_VERSION = 2,
    SYSTEM_STORE_CREATE_INFORMATION_VERSION = 6,
    SYSTEM_STORE_DELETE_INFORMATION_VERSION = 1,
    SYSTEM_STORE_LIST_INFORMATION_VERSION = 2,
    SYSTEM_CACHE_LIST_INFORMATION_VERSION = 2,
    SYSTEM_CACHE_CREATE_INFORMATION_VERSION = 3,
    SYSTEM_CACHE_DELETE_INFORMATION_VERSION = 1,
    SYSTEM_CACHE_STORE_CREATE_INFORMATION_VERSION = 2,
    SYSTEM_CACHE_STORE_DELETE_INFORMATION_VERSION = 1,
    SYSTEM_CACHE_STATS_INFORMATION_VERSION = 3,
    SYSTEM_STORE_REGISTRATION_INFORMATION_VERSION = 2,
    SYSTEM_STORE_RESIZE_INFORMATION_VERSION = 6,
    SYSTEM_CACHE_STORE_RESIZE_INFORMATION_VERSION = 1,
    SYSTEM_STORE_CONFIG_INFORMATION_VERSION = 4,
    SYSTEM_STORE_HIGH_MEM_PRIORITY_INFORMATION_VERSION = 1,
    SYSTEM_STORE_TRIM_INFORMATION_VERSION = 1,
    SYSTEM_STORE_COMPRESSION_INFORMATION_VERSION = 3,
};

enum
{
    MEMORY_COMBINE_FLAGS_COMMON_PAGES_ONLY = 0x4,
};

enum SYSTEM_CODEINTEGRITYPOLICY_OPTIONS
{
    CODEINTEGRITYPOLICY_OPTION_ENABLED = 0x01,
    CODEINTEGRITYPOLICY_OPTION_AUDIT = 0x02,
    CODEINTEGRITYPOLICY_OPTION_REQUIRE_WHQL = 0x04,
    CODEINTEGRITYPOLICY_OPTION_DISABLED_FLIGHTSIGNING = 0x08,
    CODEINTEGRITYPOLICY_OPTION_ENABLED_UMCI = 0x10,
    CODEINTEGRITYPOLICY_OPTION_ENABLED_UPDATE_POLICY_NOREBOOT = 0x20,
    CODEINTEGRITYPOLICY_OPTION_ENABLED_SECURE_SETTING_POLICY = 0x40,
    CODEINTEGRITYPOLICY_OPTION_ENABLED_UNSIGNED_SYSTEMINTEGRITY_POLICY = 0x80,
    CODEINTEGRITYPOLICY_OPTION_DYNAMIC_CODE_POLICY_ENABLED = 0x100,
    CODEINTEGRITYPOLICY_OPTION_RELOAD_POLICY_NO_REBOOT = 0x10000000,
    CODEINTEGRITYPOLICY_OPTION_CONDITIONAL_LOCKDOWN = 0x20000000,
    CODEINTEGRITYPOLICY_OPTION_NOLOCKDOWN = 0x40000000,
    CODEINTEGRITYPOLICY_OPTION_LOCKDOWN = 0x80000000,
};

enum SYSTEM_CODEINTEGRITYPOLICY_HVCIOPTIONS
{
    CODEINTEGRITYPOLICY_HVCIOPTION_ENABLED = 0x01,
    CODEINTEGRITYPOLICY_HVCIOPTION_STRICT = 0x02,
    CODEINTEGRITYPOLICY_HVCIOPTION_DEBUG = 0x04,
};

enum SYSDBG_LIVEDUMP_CONTROL_VERSIONS
{
    SYSDBG_LIVEDUMP_CONTROL_VERSION_1 = 1,
    SYSDBG_LIVEDUMP_CONTROL_VERSION_2 = 2,
    SYSDBG_LIVEDUMP_CONTROL_VERSION = SYSDBG_LIVEDUMP_CONTROL_VERSION_2,
};

enum
{
    HARDERROR_OVERRIDE_ERRORMODE = 0x10000000,
    PROCESSOR_FEATURE_MAX = 64,
    MAX_WOW64_SHARED_ENTRIES = 16,
};

enum NX_SUPPORT_POLICIE_FLAGS
{
    NX_SUPPORT_POLICY_ALWAYSOFF = 0,
    NX_SUPPORT_POLICY_ALWAYSON = 1,
    NX_SUPPORT_POLICY_OPTIN = 2,
    NX_SUPPORT_POLICY_OPTOUT = 3,
};

enum SEH_VALIDATION_POLICIE_FLAGS
{
    SEH_VALIDATION_POLICY_ON = 0,
    SEH_VALIDATION_POLICY_OFF = 1,
    SEH_VALIDATION_POLICY_TELEMETRY = 2,
    SEH_VALIDATION_POLICY_DEFER = 3,
};

enum SHARED_GLOBAL_FLAGS
{
    SHARED_GLOBAL_FLAGS_ERROR_PORT_V = 0x0,
    SHARED_GLOBAL_FLAGS_ERROR_PORT = (1UL << SHARED_GLOBAL_FLAGS_ERROR_PORT_V),
    SHARED_GLOBAL_FLAGS_ELEVATION_ENABLED_V = 0x1,
    SHARED_GLOBAL_FLAGS_ELEVATION_ENABLED = (1UL << SHARED_GLOBAL_FLAGS_ELEVATION_ENABLED_V),
    SHARED_GLOBAL_FLAGS_VIRT_ENABLED_V = 0x2,
    SHARED_GLOBAL_FLAGS_VIRT_ENABLED = (1UL << SHARED_GLOBAL_FLAGS_VIRT_ENABLED_V),
    SHARED_GLOBAL_FLAGS_INSTALLER_DETECT_ENABLED_V = 0x3,
    SHARED_GLOBAL_FLAGS_INSTALLER_DETECT_ENABLED = (1UL << SHARED_GLOBAL_FLAGS_INSTALLER_DETECT_ENABLED_V),
    SHARED_GLOBAL_FLAGS_LKG_ENABLED_V = 0x4,
    SHARED_GLOBAL_FLAGS_LKG_ENABLED = (1UL << SHARED_GLOBAL_FLAGS_LKG_ENABLED_V),
    SHARED_GLOBAL_FLAGS_DYNAMIC_PROC_ENABLED_V = 0x5,
    SHARED_GLOBAL_FLAGS_DYNAMIC_PROC_ENABLED = (1UL << SHARED_GLOBAL_FLAGS_DYNAMIC_PROC_ENABLED_V),
    SHARED_GLOBAL_FLAGS_CONSOLE_BROKER_ENABLED_V = 0x6,
    SHARED_GLOBAL_FLAGS_CONSOLE_BROKER_ENABLED = (1UL << SHARED_GLOBAL_FLAGS_CONSOLE_BROKER_ENABLED_V),
    SHARED_GLOBAL_FLAGS_SECURE_BOOT_ENABLED_V = 0x7,
    SHARED_GLOBAL_FLAGS_SECURE_BOOT_ENABLED = (1UL << SHARED_GLOBAL_FLAGS_SECURE_BOOT_ENABLED_V),
    SHARED_GLOBAL_FLAGS_MULTI_SESSION_SKU_V = 0x8,
    SHARED_GLOBAL_FLAGS_MULTI_SESSION_SKU = (1UL << SHARED_GLOBAL_FLAGS_MULTI_SESSION_SKU_V),
    SHARED_GLOBAL_FLAGS_MULTIUSERS_IN_SESSION_SKU_V = 0x9,
    SHARED_GLOBAL_FLAGS_MULTIUSERS_IN_SESSION_SKU = (1UL << SHARED_GLOBAL_FLAGS_MULTIUSERS_IN_SESSION_SKU_V),
    SHARED_GLOBAL_FLAGS_STATE_SEPARATION_ENABLED_V = 0xA,
    SHARED_GLOBAL_FLAGS_STATE_SEPARATION_ENABLED = (1UL << SHARED_GLOBAL_FLAGS_STATE_SEPARATION_ENABLED_V),
    SHARED_GLOBAL_FLAGS_SET_GLOBAL_DATA_FLAG = 0x40000000,
    SHARED_GLOBAL_FLAGS_CLEAR_GLOBAL_DATA_FLAG = 0x80000000,
};

enum SYSTEM_CALL
{
    SYSTEM_CALL_SYSCALL = 0,
    SYSTEM_CALL_INT_2E = 1,
};

enum SHARED_GLOBAL_FLAGS_QPC_BYPASS
{
    SHARED_GLOBAL_FLAGS_QPC_BYPASS_ENABLED = (0x01),
    SHARED_GLOBAL_FLAGS_QPC_BYPASS_USE_HV_PAGE = (0x02),
    SHARED_GLOBAL_FLAGS_QPC_BYPASS_DISABLE_32BIT = (0x04),
    SHARED_GLOBAL_FLAGS_QPC_BYPASS_USE_MFENCE = (0x10),
    SHARED_GLOBAL_FLAGS_QPC_BYPASS_USE_LFENCE = (0x20),
    SHARED_GLOBAL_FLAGS_QPC_BYPASS_A73_ERRATA = (0x40),
    SHARED_GLOBAL_FLAGS_QPC_BYPASS_USE_RDTSCP = (0x80),
};

// HTC: https://www.geoffchappell.com/studies/windows/km/ntoskrnl/api/ex/sysinfo/flags.htm
enum GLOBAL_FLAGS
{
    FLG_STOP_ON_EXCEPTION = 0x00000001,
    FLG_SHOW_LDR_SNAPS = 0x00000002,
    FLG_DEBUG_INITIAL_COMMAND = 0x00000004,
    FLG_STOP_ON_HUNG_GUI = 0x00000008,

    FLG_HEAP_ENABLE_TAIL_CHECK = 0x00000010,
    FLG_HEAP_ENABLE_FREE_CHECK = 0x00000020,
    FLG_HEAP_VALIDATE_PARAMETERS = 0x00000040,
    FLG_HEAP_VALIDATE_ALL = 0x00000080,

    FLG_APPLICATION_VERIFIER = 0x00000100,
    FLG_POOL_ENABLE_TAIL_CHECK = FLG_APPLICATION_VERIFIER,
    FLG_MONITOR_SILENT_PROCESS_EXIT = 0x00000200,
    FLG_POOL_ENABLE_FREE_CHECK = FLG_MONITOR_SILENT_PROCESS_EXIT,
    FLG_POOL_ENABLE_TAGGING = 0x00000400,
    FLG_HEAP_ENABLE_TAGGING = 0x00000800,

    FLG_USER_STACK_TRACE_DB = 0x00001000,
    FLG_KERNEL_STACK_TRACE_DB = 0x00002000,
    FLG_MAINTAIN_OBJECT_TYPELIST = 0x00004000,
    FLG_HEAP_ENABLE_TAG_BY_DLL = 0x00008000,

    FLG_DISABLE_STACK_EXTENSION = 0x00010000,
    FLG_IGNORE_DEBUG_PRIV = FLG_DISABLE_STACK_EXTENSION,
    FLG_ENABLE_CSRDEBUG = 0x00020000,
    FLG_ENABLE_KDEBUG_SYMBOL_LOAD = 0x00040000,
    FLG_DISABLE_PAGE_KERNEL_STACKS = 0x00080000,

    FLG_ENABLE_SYSTEM_CRIT_BREAKS = 0x00100000,
    FLG_HEAP_ENABLE_CALL_TRACING = FLG_ENABLE_SYSTEM_CRIT_BREAKS,
    FLG_HEAP_DISABLE_COALESCING = 0x00200000,
    FLG_ENABLE_CLOSE_EXCEPTIONS = 0x00400000,
    FLG_ENABLE_EXCEPTION_LOGGING = 0x00800000,

    FLG_ENABLE_HANDLE_TYPE_TAGGING = 0x01000000,
    FLG_HEAP_PAGE_ALLOCS = 0x02000000,
    FLG_DEBUG_INITIAL_COMMAND_EX = 0x04000000,
    FLG_DISABLE_DBGPRINT = 0x08000000,

    FLG_CRITSEC_EVENT_CREATION = 0x10000000,
    FLG_STOP_ON_UNHANDLED_EXCEPTION = 0x20000000,
    FLG_LDR_TOP_DOWN = FLG_STOP_ON_UNHANDLED_EXCEPTION,
    FLG_ENABLE_HANDLE_EXCEPTIONS = 0x40000000,
    FLG_DISABLE_PROTDLLS = 0x80000000,

    FLG_VALID_BITS = 0xfffffdff,

    FLG_USERMODE_VALID_BITS = (FLG_STOP_ON_EXCEPTION |
        FLG_SHOW_LDR_SNAPS |
        FLG_HEAP_ENABLE_TAIL_CHECK |
        FLG_HEAP_ENABLE_FREE_CHECK |
        FLG_HEAP_VALIDATE_PARAMETERS |
        FLG_HEAP_VALIDATE_ALL |
        FLG_APPLICATION_VERIFIER |
        FLG_HEAP_ENABLE_TAGGING |
        FLG_USER_STACK_TRACE_DB |
        FLG_HEAP_ENABLE_TAG_BY_DLL |
        FLG_DISABLE_STACK_EXTENSION |
        FLG_ENABLE_SYSTEM_CRIT_BREAKS |
        FLG_HEAP_DISABLE_COALESCING |
        FLG_DISABLE_PROTDLLS |
        FLG_HEAP_PAGE_ALLOCS |
        FLG_CRITSEC_EVENT_CREATION |
        FLG_LDR_TOP_DOWN),

    FLG_BOOTONLY_VALID_BITS = (FLG_KERNEL_STACK_TRACE_DB |
        FLG_MAINTAIN_OBJECT_TYPELIST |
        FLG_ENABLE_CSRDEBUG |
        FLG_DEBUG_INITIAL_COMMAND |
        FLG_DEBUG_INITIAL_COMMAND_EX |
        FLG_DISABLE_PAGE_KERNEL_STACKS),

    FLG_KERNELMODE_VALID_BITS = (FLG_STOP_ON_EXCEPTION |
        FLG_SHOW_LDR_SNAPS |
        FLG_STOP_ON_HUNG_GUI |
        FLG_POOL_ENABLE_TAGGING |
        FLG_ENABLE_KDEBUG_SYMBOL_LOAD |
        FLG_ENABLE_CLOSE_EXCEPTIONS |
        FLG_ENABLE_EXCEPTION_LOGGING |
        FLG_ENABLE_HANDLE_TYPE_TAGGING |
        FLG_DISABLE_DBGPRINT |
        FLG_ENABLE_HANDLE_EXCEPTIONS)
};

#pragma endregion ntexapi.h

#pragma region ntbcd.h

enum
{
    BCD_OBJECT_DESCRIPTION_VERSION = 0x1,
};

#pragma endregion ntbcd.h

#pragma region ntmmapi.h

enum MEMORY_WORKING_SET_BLOCK_PROTECTION
{
    MEMORY_BLOCK_NOT_ACCESSED = 0,
    MEMORY_BLOCK_READONLY = 1,
    MEMORY_BLOCK_EXECUTABLE = 2,
    MEMORY_BLOCK_EXECUTABLE_READONLY = 3,
    MEMORY_BLOCK_READWRITE = 4,
    MEMORY_BLOCK_COPYONWRITE = 5,
    MEMORY_BLOCK_EXECUTABLE_READWRITE = 6,
    MEMORY_BLOCK_EXECUTABLE_COPYONWRITE = 7,
    MEMORY_BLOCK_NOT_ACCESSED_2 = 8,
    MEMORY_BLOCK_NON_CACHEABLE_READONLY = 9,
    MEMORY_BLOCK_NON_CACHEABLE_EXECUTABLE = 10,
    MEMORY_BLOCK_NON_CACHEABLE_EXECUTABLE_READONLY = 11,
    MEMORY_BLOCK_NON_CACHEABLE_READWRITE = 12,
    MEMORY_BLOCK_NON_CACHEABLE_COPYONWRITE = 13,
    MEMORY_BLOCK_NON_CACHEABLE_EXECUTABLE_READWRITE = 14,
    MEMORY_BLOCK_NON_CACHEABLE_EXECUTABLE_COPYONWRITE = 15,
    MEMORY_BLOCK_NOT_ACCESSED_3 = 16,
    MEMORY_BLOCK_GUARD_READONLY = 17,
    MEMORY_BLOCK_GUARD_EXECUTABLE = 18,
    MEMORY_BLOCK_GUARD_EXECUTABLE_READONLY = 19,
    MEMORY_BLOCK_GUARD_READWRITE = 20,
    MEMORY_BLOCK_GUARD_COPYONWRITE = 21,
    MEMORY_BLOCK_GUARD_EXECUTABLE_READWRITE = 22,
    MEMORY_BLOCK_GUARD_EXECUTABLE_COPYONWRITE = 23,
    MEMORY_BLOCK_NOT_ACCESSED_4 = 24,
    MEMORY_BLOCK_NON_CACHEABLE_GUARD_READONLY = 25,
    MEMORY_BLOCK_NON_CACHEABLE_GUARD_EXECUTABLE = 26,
    MEMORY_BLOCK_NON_CACHEABLE_GUARD_EXECUTABLE_READONLY = 27,
    MEMORY_BLOCK_NON_CACHEABLE_GUARD_READWRITE = 28,
    MEMORY_BLOCK_NON_CACHEABLE_GUARD_COPYONWRITE = 29,
    MEMORY_BLOCK_NON_CACHEABLE_GUARD_EXECUTABLE_READWRITE = 30,
    MEMORY_BLOCK_NON_CACHEABLE_GUARD_EXECUTABLE_COPYONWRITE = 31,
};

enum MMPFNLIST
{
    MMPFNLIST_ZERO = 0,
    MMPFNLIST_FREE = 1,
    MMPFNLIST_STANDBY = 2,
    MMPFNLIST_MODIFIED = 3,
    MMPFNLIST_MODIFIEDNOWRITE = 4,
    MMPFNLIST_BAD = 5,
    MMPFNLIST_ACTIVE = 6,
    MMPFNLIST_TRANSITION = 7,
};

enum MMLISTS
{
    ZeroedPageList = 0,
    FreePageList = 1,
    StandbyPageList = 2,
    ModifiedPageList = 3,
    ModifiedNoWritePageList = 4,
    BadPageList = 5,
    ActiveAndValid = 6,
    TransitionPage = 7
};

enum _MMPFNUSE
{
    MMPFNUSE_PROCESSPRIVATE = 0,
    MMPFNUSE_FILE = 1,
    MMPFNUSE_PAGEFILEMAPPED = 2,
    MMPFNUSE_PAGETABLE = 3,
    MMPFNUSE_PAGEDPOOL = 4,
    MMPFNUSE_NONPAGEDPOOL = 5,
    MMPFNUSE_SYSTEMPTE = 6,
    MMPFNUSE_SESSIONPRIVATE = 7,
    MMPFNUSE_METAFILE = 8,
    MMPFNUSE_AWEPAGE = 9,
    MMPFNUSE_DRIVERLOCKPAGE = 10,
    MMPFNUSE_KERNELSTACK = 11,
};

enum MMPFNUSE
{
    ProcessPrivatePage,
    MemoryMappedFilePage,
    PageFileMappedPage,
    PageTablePage,
    PagedPoolPage,
    NonPagedPoolPage,
    SystemPTEPage,
    SessionPrivatePage,
    MetafilePage,
    AWEPage,
    DriverLockedPage,
    KernelStackPage
};

enum MEM_EXECUTE_OPTIONS
{
    MEM_EXECUTE_OPTION_ENABLE = 0x1,
    MEM_EXECUTE_OPTION_DISABLE = 0x2,
    MEM_EXECUTE_OPTION_DISABLE_THUNK_EMULATION = 0x4,
    MEM_EXECUTE_OPTION_PERMANENT = 0x8,
    MEM_EXECUTE_OPTION_EXECUTE_DISPATCH_ENABLE = 0x10,
    MEM_EXECUTE_OPTION_IMAGE_DISPATCH_ENABLE = 0x20,
    MEM_EXECUTE_OPTION_DISABLE_EXCEPTION_CHAIN_VALIDATION = 0x40,
    MEM_EXECUTE_OPTION_VALID_FLAGS = 0x7f,
};

enum MAP_TYPE
{
    MAP_PROCESS = 1,
    MAP_SYSTEM = 2,
};

enum MEMORY_PARTITION_ACCESSES
{
    MEMORY_PARTITION_QUERY_ACCESS_PHNT = 0x0001,
    MEMORY_PARTITION_MODIFY_ACCESS_PHNT = 0x0002,
    MEMORY_PARTITION_ALL_ACCESS_PHNT = (STANDARD_RIGHTS_REQUIRED | SYNCHRONIZE |
        MEMORY_PARTITION_QUERY_ACCESS_PHNT | MEMORY_PARTITION_MODIFY_ACCESS_PHNT),
};

enum TERMINATE_ENCLAVE_FLAGS
{
    TERMINATE_ENCLAVE_VALID_FLAGS = 0x00000005ul,
    TERMINATE_ENCLAVE_FLAG_NO_WAIT = 0x00000001ul,
    TERMINATE_ENCLAVE_FLAG_WAIT_ERROR = 0x00000004ul, // STATUS_PENDING -> STATUS_ENCLAVE_NOT_TERMINATED
};

enum ENCLAVE_CALL_FLAGS
{
    ENCLAVE_CALL_VALID_FLAGS = 0x00000001ul,
    ENCLAVE_CALL_FLAG_NO_WAIT = 0x00000001ul,
};

#pragma endregion ntmmapi.h

#pragma region ntobapi.h

enum OBJECT_TYPE_FLAGS
{
    OBJECT_TYPE_CREATE = 0x0001,
    OBJECT_TYPE_ALL_ACCESS = (STANDARD_RIGHTS_REQUIRED | OBJECT_TYPE_CREATE),
};

enum DIRECTORY_FLAGS
{
    DIRECTORY_QUERY = 0x0001,
    DIRECTORY_TRAVERSE = 0x0002,
    DIRECTORY_CREATE_OBJECT = 0x0004,
    DIRECTORY_CREATE_SUBDIRECTORY = 0x0008,
    DIRECTORY_ALL_ACCESS = (STANDARD_RIGHTS_REQUIRED | DIRECTORY_QUERY |
        DIRECTORY_TRAVERSE | DIRECTORY_CREATE_OBJECT | DIRECTORY_CREATE_SUBDIRECTORY),
};

enum SYMBOLIC_LINK_FLAGS
{
    SYMBOLIC_LINK_QUERY = 0x0001,
    SYMBOLIC_LINK_SET = 0x0002,
    SYMBOLIC_LINK_ALL_ACCESS = (STANDARD_RIGHTS_REQUIRED | SYMBOLIC_LINK_QUERY),
    SYMBOLIC_LINK_ALL_ACCESS_EX = (STANDARD_RIGHTS_REQUIRED | 0xFFFF),
};

enum DUPLICATE_OBJECT_OPTIONS
{
    _DUPLICATE_CLOSE_SOURCE = 0x00000001,
    _DUPLICATE_SAME_ACCESS = 0x00000002,
    _DUPLICATE_SAME_ATTRIBUTES = 0x00000004,
};

enum
{
    OBJECT_BOUNDARY_DESCRIPTOR_VERSION = 1
};

#pragma endregion

#pragma region ntpsapi.h

#pragma region ntpebteb.h

#pragma region ntsxs.h

enum ACTIVATION_CONTEXT_MAGICS
{
    ACTIVATION_CONTEXT_DATA_MAGIC = ('xtcA'),
    ACTIVATION_CONTEXT_STRING_SECTION_MAGIC = ('dHsS'),
    ACTIVATION_CONTEXT_GUID_SECTION_MAGIC = ('dHsG'),
};

enum ACTIVATION_CONTEXT_FORMATS
{
    ACTIVATION_CONTEXT_DATA_FORMAT_WHISTLER = 1,
    ACTIVATION_CONTEXT_STRING_SECTION_FORMAT_WHISTLER = 1,
    ACTIVATION_CONTEXT_GUID_SECTION_FORMAT_WHISTLER = 1,
    ACTIVATION_CONTEXT_DATA_ASSEMBLY_INFORMATION_FORMAT_WHISTLER = 1,
    ACTIVATION_CONTEXT_DATA_DLL_REDIRECTION_FORMAT_WHISTLER = 1,
    ACTIVATION_CONTEXT_DATA_WINDOW_CLASS_REDIRECTION_FORMAT_WHISTLER = 1,
    ACTIVATION_CONTEXT_DATA_COM_SERVER_REDIRECTION_FORMAT_WHISTLER = 1,
    ACTIVATION_CONTEXT_DATA_COM_INTERFACE_REDIRECTION_FORMAT_WHISTLER = 1,
    ACTIVATION_CONTEXT_DATA_COM_TYPE_LIBRARY_REDIRECTION_FORMAT_WHISTLER = 1,
    ACTIVATION_CONTEXT_DATA_COM_PROGID_REDIRECTION_FORMAT_WHISTLER = 1,
    ACTIVATION_CONTEXT_DATA_CLR_SURROGATE_FORMAT_WHISTLER = 1,
    ACTIVATION_CONTEXT_DATA_APPLICATION_SETTINGS_FORMAT_LONGHORN = 1,
};

enum ACTIVATION_CONTEXT_FLAGS
{
    ACTIVATION_CONTEXT_FLAG_NO_INHERIT = 0x00000001,
};

enum ACTIVATION_CONTEXT_DATA_TOC_HEADER_FLAGS
{
    ACTIVATION_CONTEXT_DATA_TOC_HEADER_DENSE = 0x00000001,
    ACTIVATION_CONTEXT_DATA_TOC_HEADER_INORDER = 0x00000002,
};

enum ACTIVATION_CONTEXT_DATA_ASSEMBLY_ROSTER_ENTRY_FLAGS
{
    ACTIVATION_CONTEXT_DATA_ASSEMBLY_ROSTER_ENTRY_INVALID = 0x00000001,
    ACTIVATION_CONTEXT_DATA_ASSEMBLY_ROSTER_ENTRY_ROOT = 0x00000002,
};

enum ACTIVATION_CONTEXT_SECTION_FORMAT_FLAGS
{
    ACTIVATION_CONTEXT_SECTION_FORMAT_UNKNOWN = 0,
    ACTIVATION_CONTEXT_SECTION_FORMAT_STRING_TABLE = 1,
    ACTIVATION_CONTEXT_SECTION_FORMAT_GUID_TABLE = 2,
};

enum ACTIVATION_CONTEXT_STRING_SECTION_FLAGS
{
    ACTIVATION_CONTEXT_STRING_SECTION_CASE_INSENSITIVE = 0x00000001,
    ACTIVATION_CONTEXT_STRING_SECTION_ENTRIES_IN_PSEUDOKEY_ORDER = 0x00000002,
};

enum ACTIVATION_CONTEXT_GUID_SECTION_HEADER_FLAGS
{
    ACTIVATION_CONTEXT_GUID_SECTION_ENTRIES_IN_ORDER = 0x00000001,
};

enum ACTIVATION_CONTEXT_DATA_ASSEMBLY_INFORMATION_FLAGS
{
    ACTIVATION_CONTEXT_DATA_ASSEMBLY_INFORMATION_ROOT_ASSEMBLY = 0x00000001,
    ACTIVATION_CONTEXT_DATA_ASSEMBLY_INFORMATION_POLICY_APPLIED = 0x00000002,
    ACTIVATION_CONTEXT_DATA_ASSEMBLY_INFORMATION_ASSEMBLY_POLICY_APPLIED = 0x00000004,
    ACTIVATION_CONTEXT_DATA_ASSEMBLY_INFORMATION_ROOT_POLICY_APPLIED = 0x00000008,
    ACTIVATION_CONTEXT_DATA_ASSEMBLY_INFORMATION_PRIVATE_ASSEMBLY = 0x00000010,
};

enum ACTIVATION_CONTEXT_DATA_DLL_REDIRECTION_FLAGS
{
    ACTIVATION_CONTEXT_DATA_DLL_REDIRECTION_PATH_INCLUDES_BASE_NAME = 0x00000001,
    ACTIVATION_CONTEXT_DATA_DLL_REDIRECTION_PATH_OMITS_ASSEMBLY_ROOT = 0x00000002,
    ACTIVATION_CONTEXT_DATA_DLL_REDIRECTION_PATH_EXPAND = 0x00000004,
    ACTIVATION_CONTEXT_DATA_DLL_REDIRECTION_PATH_SYSTEM_DEFAULT_REDIRECTED_SYSTEM32_DLL = 0x00000008,
};

enum ACTIVATION_CONTEXT_DATA_COM_SERVER_REDIRECTION_THREADING_MODELS
{
    ACTIVATION_CONTEXT_DATA_COM_SERVER_REDIRECTION_THREADING_MODEL_INVALID = 0,
    ACTIVATION_CONTEXT_DATA_COM_SERVER_REDIRECTION_THREADING_MODEL_APARTMENT = 1,
    ACTIVATION_CONTEXT_DATA_COM_SERVER_REDIRECTION_THREADING_MODEL_FREE = 2,
    ACTIVATION_CONTEXT_DATA_COM_SERVER_REDIRECTION_THREADING_MODEL_SINGLE = 3,
    ACTIVATION_CONTEXT_DATA_COM_SERVER_REDIRECTION_THREADING_MODEL_BOTH = 4,
    ACTIVATION_CONTEXT_DATA_COM_SERVER_REDIRECTION_THREADING_MODEL_NEUTRAL = 5,
};

enum ACTIVATION_CONTEXT_DATA_COM_SERVER_MISCSTATUS_FLAGS
{
    ACTIVATION_CONTEXT_DATA_COM_SERVER_MISCSTATUS_FLAG_OFFSET = 8,
    ACTIVATION_CONTEXT_DATA_COM_SERVER_MISCSTATUS_HAS_DEFAULT = (0x01 << ACTIVATION_CONTEXT_DATA_COM_SERVER_MISCSTATUS_FLAG_OFFSET),
    ACTIVATION_CONTEXT_DATA_COM_SERVER_MISCSTATUS_HAS_ICON = (0x02 << ACTIVATION_CONTEXT_DATA_COM_SERVER_MISCSTATUS_FLAG_OFFSET),
    ACTIVATION_CONTEXT_DATA_COM_SERVER_MISCSTATUS_HAS_CONTENT = (0x04 << ACTIVATION_CONTEXT_DATA_COM_SERVER_MISCSTATUS_FLAG_OFFSET),
    ACTIVATION_CONTEXT_DATA_COM_SERVER_MISCSTATUS_HAS_THUMBNAIL = (0x08 << ACTIVATION_CONTEXT_DATA_COM_SERVER_MISCSTATUS_FLAG_OFFSET),
    ACTIVATION_CONTEXT_DATA_COM_SERVER_MISCSTATUS_HAS_DOCPRINT = (0x10 << ACTIVATION_CONTEXT_DATA_COM_SERVER_MISCSTATUS_FLAG_OFFSET),
};

enum ACTIVATION_CONTEXT_DATA_COM_SERVER_REDIRECTION_SHIM_TYPES
{
    ACTIVATION_CONTEXT_DATA_COM_SERVER_REDIRECTION_SHIM_TYPE_OTHER = 1,
    ACTIVATION_CONTEXT_DATA_COM_SERVER_REDIRECTION_SHIM_TYPE_CLR_CLASS = 2,
};

enum ACTIVATION_CONTEXT_DATA_COM_INTERFACE_REDIRECTION_FLAGS
{
    ACTIVATION_CONTEXT_DATA_COM_INTERFACE_REDIRECTION_FLAG_NUM_METHODS_VALID = 0x00000001,
    ACTIVATION_CONTEXT_DATA_COM_INTERFACE_REDIRECTION_FLAG_BASE_INTERFACE_VALID = 0x00000002,
};

enum ASSEMBLY_STORAGE_MAP_FLAGS
{
    ASSEMBLY_STORAGE_MAP_ASSEMBLY_ARRAY_IS_HEAP_ALLOCATED = 0x00000001,
};

enum ACTIVATION_CONTEXT_NOTIFICATION_TYPES
{
    ACTIVATION_CONTEXT_NOTIFICATION_DESTROY = 1,
    ACTIVATION_CONTEXT_NOTIFICATION_ZOMBIFY = 2,
    ACTIVATION_CONTEXT_NOTIFICATION_USED = 3,
};

enum RTL_ACTIVATION_CONTEXT_STACK_FRAME_FLAGS
{
    RTL_ACTIVATION_CONTEXT_STACK_FRAME_FLAG_RELEASE_ON_DEACTIVATION = 0x00000001,
    RTL_ACTIVATION_CONTEXT_STACK_FRAME_FLAG_NO_DEACTIVATE = 0x00000002,
    RTL_ACTIVATION_CONTEXT_STACK_FRAME_FLAG_ON_FREE_LIST = 0x00000004,
    RTL_ACTIVATION_CONTEXT_STACK_FRAME_FLAG_HEAP_ALLOCATED = 0x00000008,
    RTL_ACTIVATION_CONTEXT_STACK_FRAME_FLAG_NOT_REALLY_ACTIVATED = 0x00000010,
};

enum ACTIVATION_CONTEXT_STACK_FLAGS
{
    ACTIVATION_CONTEXT_STACK_FLAG_QUERIES_DISABLED = 0x00000001,
};

#pragma endregion ntsxs.h

enum GDI_HANDLE_BUFFER_SIZE
{
    GDI_HANDLE_BUFFER_SIZE32 = 34,
    GDI_HANDLE_BUFFER_SIZE64 = 60,
};

enum FLS_TLS_MIN_MAX_VALUES
{
    _FLS_MAXIMUM_AVAILABLE = 128, // Windows Kit 10.0.22621.0 = 4080 ???
    _TLS_MINIMUM_AVAILABLE = 64,
    _TLS_EXPANSION_SLOTS = 1024,
};

enum KACF_FLAGS
{
    KACF_OLDGETSHORTPATHNAME = 0x00000001,
    KACF_VERSIONLIE_NOT_USED = 0x00000002,
    KACF_GETDISKFREESPACE = 0x00000008,
    KACF_FTMFROMCURRENTAPT = 0x00000020,
    KACF_DISALLOWORBINDINGCHANGES = 0x00000040,
    KACF_OLE32VALIDATEPTRS = 0x00000080,
    KACF_DISABLECICERO = 0x00000100,
    KACF_OLE32ENABLEASYNCDOCFILE = 0x00000200,
    KACF_OLE32ENABLELEGACYEXCEPTIONHANDLING = 0x00000400,
    KACF_RPCDISABLENDRCLIENTHARDENING = 0x00000800,
    KACF_RPCDISABLENDRMAYBENULL_SIZEIS = 0x00001000,
    KACF_DISABLEALLDDEHACK_NOT_USED = 0x00002000,
    KACF_RPCDISABLENDR61_RANGE = 0x00004000,
    KACF_RPC32ENABLELEGACYEXCEPTIONHANDLING = 0x00008000,
    KACF_OLE32DOCFILEUSELEGACYNTFSFLAGS = 0x00010000,
    KACF_RPCDISABLENDRCONSTIIDCHECK = 0x00020000,
    KACF_USERDISABLEFORWARDERPATCH = 0x00040000,
    KACF_OLE32DISABLENEW_WMPAINT_DISPATCH = 0x00100000,
    KACF_ADDRESTRICTEDSIDINCOINITIALIZESECURITY = 0x00200000,
    KACF_ALLOCDEBUGINFOFORCRITSECTIONS = 0x00400000,
    KACF_OLEAUT32ENABLEUNSAFELOADTYPELIBRELATIVE = 0x00800000,
    KACF_ALLOWMAXIMIZEDWINDOWGAMMA = 0x01000000,
    KACF_DONOTADDTOCACHE = 0x80000000,
};

enum TEB_FIELDS_SIZE
{
    GDI_BATCH_BUFFER_SIZE = 310,
    STATIC_UNICODE_BUFFER_LENGTH = 261,
    WIN32_CLIENT_INFO_LENGTH = 62,
};

#pragma endregion ntpebteb.h

// ntpsapi.h body

enum PROCESS_EXCEPTION_PORT_STATE_FLAGS
{
    PROCESS_EXCEPTION_PORT_ALL_STATE_BITS = 0x00000003,
    PROCESS_EXCEPTION_PORT_ALL_STATE_FLAGS = ((ULONG_PTR)((1UL << PROCESS_EXCEPTION_PORT_ALL_STATE_BITS) - 1)),
};

enum PROCESS_PRIORITY_CLASS_FLAGS
{
    PROCESS_PRIORITY_CLASS_UNKNOWN = 0,
    PROCESS_PRIORITY_CLASS_IDLE = 1,
    PROCESS_PRIORITY_CLASS_NORMAL = 2,
    PROCESS_PRIORITY_CLASS_HIGH = 3,
    PROCESS_PRIORITY_CLASS_REALTIME = 4,
    PROCESS_PRIORITY_CLASS_BELOW_NORMAL = 5,
    PROCESS_PRIORITY_CLASS_ABOVE_NORMAL = 6,
};

enum PROCESS_DEVICEMAP_INFORMATION_EX_FLAGS
{
    PROCESS_LUID_DOSDEVICES_ONLY = 0x00000001,
};

enum PROCESS_HANDLE_TRACING_ENABLE_FLAGS
{
    PROCESS_HANDLE_EXCEPTIONS_ENABLED = 0x00000001,
    PROCESS_HANDLE_RAISE_EXCEPTION_ON_INVALID_HANDLE_CLOSE_DISABLED = 0x00000000,
    PROCESS_HANDLE_RAISE_EXCEPTION_ON_INVALID_HANDLE_CLOSE_ENABLED = 0x00000001,
};

enum PROCESS_HANDLE_TRACING_ENTRY_MAX_VALUES
{
    PROCESS_HANDLE_TRACING_MAX_STACKS = 16,
    PROCESS_HANDLE_TRACING_MAX_SLOTS = 0x20000,
};

enum PROCESS_HANDLE_TRACING_ENTRY_TYPES
{
    PROCESS_HANDLE_TRACE_TYPE_OPEN = 1,
    PROCESS_HANDLE_TRACE_TYPE_CLOSE = 2,
    PROCESS_HANDLE_TRACE_TYPE_BADREF = 3,
};

enum PROCESS_WORKING_SET_CONTROL_VERSIONS
{
    PROCESS_WORKING_SET_CONTROL_VERSION = 3,
};

enum PS_PROTECTED_MASKS
{
    PS_PROTECTED_SIGNER_MASK = 0xFF,
    PS_PROTECTED_AUDIT_MASK = 0x08,
    PS_PROTECTED_TYPE_MASK = 0x07,
};

enum POWER_THROTTLING_PROCESS_STATE_MASKS
{
    POWER_THROTTLING_PROCESS_CURRENT_VERSION = 1,
    POWER_THROTTLING_PROCESS_EXECUTION_SPEED = 0x1,
    POWER_THROTTLING_PROCESS_DELAYTIMERS = 0x2,
    POWER_THROTTLING_PROCESS_IGNORE_TIMER_RESOLUTION = 0x4,
    POWER_THROTTLING_PROCESS_VALID_FLAGS = ((POWER_THROTTLING_PROCESS_EXECUTION_SPEED |
        POWER_THROTTLING_PROCESS_DELAYTIMERS |
        POWER_THROTTLING_PROCESS_IGNORE_TIMER_RESOLUTION)),
};

enum WIN32K_SYSCALL_FILTER_STATE
{
    WIN32K_SYSCALL_FILTER_STATE_ENABLE = 0x1,
    WIN32K_SYSCALL_FILTER_STATE_AUDIT = 0x2,
};

enum POWER_THROTTLING_THREAD_STATE_MASK
{
    POWER_THROTTLING_THREAD_CURRENT_VERSION = 1,
    POWER_THROTTLING_THREAD_EXECUTION_SPEED = 0x1,
    POWER_THROTTLING_THREAD_VALID_FLAGS = POWER_THROTTLING_THREAD_EXECUTION_SPEED,
};

enum PROCESS_READWRITEVM_LOGGING_INFORMATION_FLAGS
{
    PROCESS_READWRITEVM_LOGGING_ENABLE_READVM = 1,
    PROCESS_READWRITEVM_LOGGING_ENABLE_WRITEVM = 2,
    PROCESS_READWRITEVM_LOGGING_ENABLE_READVM_V = 1UL,
    PROCESS_READWRITEVM_LOGGING_ENABLE_WRITEVM_V = 2UL,
};

enum PROCESS_CREATE_FLAGS
{
    PROCESS_CREATE_FLAGS_NONE = 0x00000000,
    PROCESS_CREATE_FLAGS_BREAKAWAY = 0x00000001,              // NtCreateProcessEx & NtCreateUserProcess
    PROCESS_CREATE_FLAGS_NO_DEBUG_INHERIT = 0x00000002,       // NtCreateProcessEx & NtCreateUserProcess
    PROCESS_CREATE_FLAGS_INHERIT_HANDLES = 0x00000004,        // NtCreateProcessEx & NtCreateUserProcess
    PROCESS_CREATE_FLAGS_OVERRIDE_ADDRESS_SPACE = 0x00000008, // NtCreateProcessEx only
    PROCESS_CREATE_FLAGS_LARGE_PAGES = 0x00000010,            // NtCreateProcessEx only, requires SeLockMemory
    PROCESS_CREATE_FLAGS_LARGE_PAGE_SYSTEM_DLL = 0x00000020,  // NtCreateProcessEx only, requires SeLockMemory
    PROCESS_CREATE_FLAGS_PROTECTED_PROCESS = 0x00000040,      // NtCreateUserProcess only
    PROCESS_CREATE_FLAGS_CREATE_SESSION = 0x00000080,         // NtCreateProcessEx & NtCreateUserProcess, requires SeLoadDriver
    PROCESS_CREATE_FLAGS_INHERIT_FROM_PARENT = 0x00000100,    // NtCreateProcessEx & NtCreateUserProcess
    PROCESS_CREATE_FLAGS_SUSPENDED = 0x00000200,              // NtCreateProcessEx & NtCreateUserProcess
    PROCESS_CREATE_FLAGS_FORCE_BREAKAWAY = 0x00000400,        // NtCreateProcessEx & NtCreateUserProcess, requires SeTcb
    PROCESS_CREATE_FLAGS_MINIMAL_PROCESS = 0x00000800,        // NtCreateProcessEx only
    PROCESS_CREATE_FLAGS_RELEASE_SECTION = 0x00001000,        // NtCreateProcessEx & NtCreateUserProcess
    PROCESS_CREATE_FLAGS_CLONE_MINIMAL = 0x00002000,          // NtCreateProcessEx only
    PROCESS_CREATE_FLAGS_CLONE_MINIMAL_REDUCED_COMMIT = 0x00004000,
    PROCESS_CREATE_FLAGS_AUXILIARY_PROCESS = 0x00008000,         // NtCreateProcessEx & NtCreateUserProcess, requires SeTcb
    PROCESS_CREATE_FLAGS_CREATE_STORE = 0x00020000,              // NtCreateProcessEx & NtCreateUserProcess
    PROCESS_CREATE_FLAGS_USE_PROTECTED_ENVIRONMENT = 0x00040000, // NtCreateProcessEx & NtCreateUserProcess
    PROCESS_CREATE_FLAGS_IMAGE_EXPANSION_MITIGATION_DISABLE = 0x00080000,
    PROCESS_CREATE_FLAGS_PARTITION_CREATE_SLAB_IDENTITY = 0x00400000, // NtCreateProcessEx & NtCreateUserProcess (requires SeLockMemoryPrivilege)
};

enum NtCurrentHandle
{
    NtCurrentProcess = ((LONG_PTR)-1),
    ZwCurrentProcess = NtCurrentProcess,
    NtCurrentThread = ((LONG_PTR)-2),
    ZwCurrentThread = NtCurrentThread,
    NtCurrentSession = ((LONG_PTR)-3),
    ZwCurrentSession = NtCurrentSession,
    NtCurrentProcessToken = ((LONG_PTR)-4),
    NtCurrentThreadToken = ((LONG_PTR)-5),
    NtCurrentThreadEffectiveToken = ((LONG_PTR)-6),
    NtCurrentSilo = ((LONG_PTR)-1),
};

enum PROCESS_GET_NEXT_FLAGS
{
    PROCESS_GET_NEXT_FLAGS_PREVIOUS_PROCESS = 0x00000001,
};

enum PROCESS_STATECHANGE_MASKS
{
    STATECHANGE_SET_ATTRIBUTES = 0x0001,
};

enum EXTENDED_PROCESS_CREATION_FLAGS
{
    EXTENDED_PROCESS_CREATION_FLAG_ELEVATION_HANDLED = 0x00000001,
    EXTENDED_PROCESS_CREATION_FLAG_FORCELUA = 0x00000002,
    EXTENDED_PROCESS_CREATION_FLAG_FORCE_BREAKAWAY = 0x00000004,
};

enum PROTECTION_LEVELS
{
    _PROTECTION_LEVEL_WINTCB_LIGHT = 0x00000000,
    _PROTECTION_LEVEL_WINDOWS = 0x00000001,
    _PROTECTION_LEVEL_WINDOWS_LIGHT = 0x00000002,
    _PROTECTION_LEVEL_ANTIMALWARE_LIGHT = 0x00000003,
    _PROTECTION_LEVEL_LSA_LIGHT = 0x00000004,
    _PROTECTION_LEVEL_WINTCB = 0x00000005,
    _PROTECTION_LEVEL_CODEGEN_LIGHT = 0x00000006,
    _PROTECTION_LEVEL_AUTHENTICODE = 0x00000007,
    _PROTECTION_LEVEL_PPL_APP = 0x00000008,
    _PROTECTION_LEVEL_SAME = 0xFFFFFFFF,
    _PROTECTION_LEVEL_NONE = 0xFFFFFFFE,
};

enum PS_ATTRIBUTES
{
    PS_ATTRIBUTE_NUMBER_MASK = 0x0000ffff,
    PS_ATTRIBUTE_THREAD = 0x00010000,
    PS_ATTRIBUTE_INPUT = 0x00020000,
    PS_ATTRIBUTE_ADDITIVE = 0x00040000,
};

enum PS_STD_HANDLE_INFO_FLAGS
{
    PS_STD_INPUT_HANDLE = 0x1,
    PS_STD_OUTPUT_HANDLE = 0x2,
    PS_STD_ERROR_HANDLE = 0x4,
};

enum THREAD_CREATE_FLAGS
{
    THREAD_CREATE_FLAGS_NONE = 0x00000000,
    THREAD_CREATE_FLAGS_CREATE_SUSPENDED = 0x00000001,
    THREAD_CREATE_FLAGS_SKIP_THREAD_ATTACH = 0x00000002,
    THREAD_CREATE_FLAGS_HIDE_FROM_DEBUGGER = 0x00000004,
    THREAD_CREATE_FLAGS_LOADER_WORKER = 0x00000010,
    THREAD_CREATE_FLAGS_SKIP_LOADER_INIT = 0x00000020,
    THREAD_CREATE_FLAGS_BYPASS_PROCESS_FREEZE = 0x00000040,
};

enum JOB_OBJECT_LIMIT
{
    JOB_OBJECT_LIMIT_SILO_READY = 0x00400000,
};

enum SILO_OBJECT_ROOT_DIRECTORY_FLAGS
{
    SILO_OBJECT_ROOT_DIRECTORY_SHADOW_ROOT = 0x00000001,
    SILO_OBJECT_ROOT_DIRECTORY_INITIALIZE = 0x00000002,
    SILO_OBJECT_ROOT_DIRECTORY_SHADOW_DOS_DEVICES = 0x00000004,
};

enum MEMORY_BULK_INFORMATION_FLAGS
{
    MEMORY_BULK_INFORMATION_FLAG_BASIC = 0x00000001,
};

#pragma endregion ntpsapi.h

#pragma region ntdbg.h

enum DBG_STATUS
{
    DBG_STATUS_CONTROL_C = 1,
    DBG_STATUS_SYSRQ = 2,
    DBG_STATUS_BUGCHECK_FIRST = 3,
    DBG_STATUS_BUGCHECK_SECOND = 4,
    DBG_STATUS_FATAL = 5,
    DBG_STATUS_DEBUG_CONTROL = 6,
    DBG_STATUS_WORKER = 7,
};

enum DEBUG_OBJECT_ACCESS_MASK
{
    DEBUG_READ_EVENT = 0x0001,
    DEBUG_PROCESS_ASSIGN = 0x0002,
    DEBUG_SET_INFORMATION = 0x0004,
    DEBUG_QUERY_INFORMATION = 0x0008,
    DEBUG_ALL_ACCESS = (STANDARD_RIGHTS_REQUIRED | SYNCHRONIZE |
        DEBUG_READ_EVENT | DEBUG_PROCESS_ASSIGN |
        DEBUG_SET_INFORMATION | DEBUG_QUERY_INFORMATION),
};

enum DEBUG_OBJECT_CREATE_FLAGS
{
    DEBUG_KILL_ON_CLOSE = 0x1,
};

#pragma endregion ntdbg.h

#pragma region ntioapi.h

enum FILE_SHARE_MODES
{
    _FILE_SHARE_NONE = 0x00000000,
    _FILE_SHARE_READ = 0x00000001,
    _FILE_SHARE_WRITE = 0x00000002,
    _FILE_SHARE_DELETE = 0x00000004,
};

enum FILE_CREATE_DISPOSITION_FLAGS
{
    FILE_SUPERSEDE = 0x00000000,
    FILE_OPEN = 0x00000001,
    FILE_CREATE = 0x00000002,
    FILE_OPEN_IF = 0x00000003,
    FILE_OVERWRITE = 0x00000004,
    FILE_OVERWRITE_IF = 0x00000005,
    FILE_MAXIMUM_DISPOSITION = 0x00000005,
};

enum FILE_CREATE_OPTIONS
{
    FILE_DIRECTORY_FILE = 0x00000001,
    FILE_WRITE_THROUGH = 0x00000002,
    FILE_SEQUENTIAL_ONLY = 0x00000004,
    FILE_NO_INTERMEDIATE_BUFFERING = 0x00000008,

    FILE_SYNCHRONOUS_IO_ALERT = 0x00000010,
    FILE_SYNCHRONOUS_IO_NONALERT = 0x00000020,
    FILE_NON_DIRECTORY_FILE = 0x00000040,
    FILE_CREATE_TREE_CONNECTION = 0x00000080,

    TREE_CONNECT_NO_CLIENT_BUFFERING = 0x00000008,
    TREE_CONNECT_WRITE_THROUGH = 0x00000002,

    FILE_COMPLETE_IF_OPLOCKED = 0x00000100,
    FILE_NO_EA_KNOWLEDGE = 0x00000200,
    FILE_OPEN_REMOTE_INSTANCE = 0x00000400,
    FILE_RANDOM_ACCESS = 0x00000800,

    FILE_DELETE_ON_CLOSE = 0x00001000,
    FILE_OPEN_BY_FILE_ID = 0x00002000,
    FILE_OPEN_FOR_BACKUP_INTENT = 0x00004000,
    FILE_NO_COMPRESSION = 0x00008000,

    FILE_OPEN_REQUIRING_OPLOCK = 0x00010000,
    FILE_DISALLOW_EXCLUSIVE = 0x00020000,

    FILE_SESSION_AWARE = 0x00040000,

    FILE_RESERVE_OPFILTER = 0x00100000,
    FILE_OPEN_REPARSE_POINT = 0x00200000,
    FILE_OPEN_NO_RECALL = 0x00400000,
    FILE_OPEN_FOR_FREE_SPACE_QUERY = 0x00800000,
};

enum EXTENDED_CREATE_INFORMATION_FLAGS
{
    FILE_CONTAINS_EXTENDED_CREATE_INFORMATION = 0x10000000,
    FILE_VALID_EXTENDED_OPTION_FLAGS = 0x10000000,
};

enum EXTENDED_CREATE_FLAGS
{
    EX_CREATE_FLAG_FILE_SOURCE_OPEN_FOR_COPY = 0x00000001,
    EX_CREATE_FLAG_FILE_DEST_OPEN_FOR_COPY = 0x00000002,
};

enum FILE_VALID_FLAGS
{
    FILE_VALID_OPTION_FLAGS = 0x00ffffff,
    FILE_VALID_PIPE_OPTION_FLAGS = 0x00000032,
    FILE_VALID_MAILSLOT_OPTION_FLAGS = 0x00000032,
    FILE_VALID_SET_FLAGS = 0x00000036,
};

enum FILE_STORAGE_FLAGS
{
    FILE_COPY_STRUCTURED_STORAGE = 0x00000041,
    FILE_STRUCTURED_STORAGE = 0x00000441,
};

enum FILE_IO_STATUS_VALUES
{
    FILE_SUPERSEDED = 0x00000000,
    FILE_OPENED = 0x00000001,
    FILE_CREATED = 0x00000002,
    FILE_OVERWRITTEN = 0x00000003,
    FILE_EXISTS = 0x00000004,
    FILE_DOES_NOT_EXIST = 0x00000005,
};

enum FILE_BYTEOFFSET_PARAMS
{
    FILE_WRITE_TO_END_OF_FILE = 0xffffffff,
    FILE_USE_FILE_POINTER_POSITION = 0xfffffffe,
};

enum FILE_ALIGNMENT_VALUES
{
    FILE_BYTE_ALIGNMENT = 0x00000000,
    FILE_WORD_ALIGNMENT = 0x00000001,
    FILE_LONG_ALIGNMENT = 0x00000003,
    FILE_QUAD_ALIGNMENT = 0x00000007,
    FILE_OCTA_ALIGNMENT = 0x0000000f,
    FILE_32_BYTE_ALIGNMENT = 0x0000001f,
    FILE_64_BYTE_ALIGNMENT = 0x0000003f,
    FILE_128_BYTE_ALIGNMENT = 0x0000007f,
    FILE_256_BYTE_ALIGNMENT = 0x000000ff,
    FILE_512_BYTE_ALIGNMENT = 0x000001ff,
};

enum DOS_MAX_FILENAME_LENGTH
{
    DOS_MAX_COMPONENT_LENGTH = 255,
    DOS_MAX_PATH_LENGTH = (DOS_MAX_COMPONENT_LENGTH + 5),
    MAXIMUM_FILENAME_LENGTH = 256,
};

enum FILE_EXTENDED_ATTRIBUTES
{
    FILE_NEED_EA = 0x00000080,
    FILE_EA_TYPE_BINARY = 0xfffe,
    FILE_EA_TYPE_ASCII = 0xfffd,
    FILE_EA_TYPE_BITMAP = 0xfffb,
    FILE_EA_TYPE_METAFILE = 0xfffa,
    FILE_EA_TYPE_ICON = 0xfff9,
    FILE_EA_TYPE_EA = 0xffee,
    FILE_EA_TYPE_MVMT = 0xffdf,
    FILE_EA_TYPE_MVST = 0xffde,
    FILE_EA_TYPE_ASN1 = 0xffdd,
    FILE_EA_TYPE_FAMILY_IDS = 0xff01,
};

enum FILE_CHARACTERISTICS
{
    FILE_REMOVABLE_MEDIA = 0x00000001,
    FILE_READ_ONLY_DEVICE = 0x00000002,
    FILE_FLOPPY_DISKETTE = 0x00000004,
    FILE_WRITE_ONCE_MEDIA = 0x00000008,
    FILE_REMOTE_DEVICE = 0x00000010,
    FILE_DEVICE_IS_MOUNTED = 0x00000020,
    FILE_VIRTUAL_VOLUME = 0x00000040,
    FILE_AUTOGENERATED_DEVICE_NAME = 0x00000080,
    FILE_DEVICE_SECURE_OPEN = 0x00000100,
    FILE_CHARACTERISTIC_PNP_DEVICE = 0x00000800,
    FILE_CHARACTERISTIC_TS_DEVICE = 0x00001000,
    FILE_CHARACTERISTIC_WEBDAV_DEVICE = 0x00002000,
    FILE_CHARACTERISTIC_CSV = 0x00010000,
    FILE_DEVICE_ALLOW_APPCONTAINER_TRAVERSAL = 0x00020000,
    FILE_PORTABLE_DEVICE = 0x00040000,
    FILE_REMOTE_DEVICE_VSMB = 0x00080000,
    FILE_DEVICE_REQUIRE_SECURITY_CHECK = 0x00100000,
};

enum FILE_PIPE_TYPES
{
    FILE_PIPE_BYTE_STREAM_TYPE = 0x00000000,
    FILE_PIPE_MESSAGE_TYPE = 0x00000001,
    FILE_PIPE_ACCEPT_REMOTE_CLIENTS = 0x00000000,
    FILE_PIPE_REJECT_REMOTE_CLIENTS = 0x00000002,
    FILE_PIPE_TYPE_VALID_MASK = 0x00000003,
};

enum FILE_PIPE_COMPLETION_MODES
{
    FILE_PIPE_QUEUE_OPERATION = 0x00000000,
    FILE_PIPE_COMPLETE_OPERATION = 0x00000001,
};

enum FILE_PIPE_READ_MODES
{
    FILE_PIPE_BYTE_STREAM_MODE = 0x00000000,
    FILE_PIPE_MESSAGE_MODE = 0x00000001,
};

enum FILE_PIPE_CONFIGURATIONS
{
    FILE_PIPE_INBOUND = 0x00000000,
    FILE_PIPE_OUTBOUND = 0x00000001,
    FILE_PIPE_FULL_DUPLEX = 0x00000002,
};

enum FILE_PIPE_STATES
{
    FILE_PIPE_DISCONNECTED_STATE = 0x00000001,
    FILE_PIPE_LISTENING_STATE = 0x00000002,
    FILE_PIPE_CONNECTED_STATE = 0x00000003,
    FILE_PIPE_CLOSING_STATE = 0x00000004,
};

enum FILE_PIPE_END
{
    FILE_PIPE_CLIENT_END = 0x00000000,
    FILE_PIPE_SERVER_END = 0x00000001,
};

enum FILE_PIPE_INSTANCE_LIMIT
{
    FILE_PIPE_UNLIMITED_INSTANCES = 0xffffffff,
};

enum FILE_END_OF_FILE_INFORMATION_FLAGS
{
    FLAGS_END_OF_FILE_INFO_EX_EXTEND_PAGING = 0x00000001,
    FLAGS_END_OF_FILE_INFO_EX_NO_EXTRA_PAGING_EXTEND = 0x00000002,
    FLAGS_END_OF_FILE_INFO_EX_TIME_CONSTRAINED = 0x00000004,
    FLAGS_DELAY_REASONS_LOG_FILE_FULL = 0x00000001,
    FLAGS_DELAY_REASONS_BITMAP_SCANNED = 0x00000002,
};

enum FILE_LINK_INFORMATION_EX_FLAGS
{
    FILE_LINK_REPLACE_IF_EXISTS = 0x00000001,
    FILE_LINK_POSIX_SEMANTICS = 0x00000002,

    FILE_LINK_SUPPRESS_STORAGE_RESERVE_INHERITANCE = 0x00000008,
    FILE_LINK_NO_INCREASE_AVAILABLE_SPACE = 0x00000010,
    FILE_LINK_NO_DECREASE_AVAILABLE_SPACE = 0x00000020,
    FILE_LINK_PRESERVE_AVAILABLE_SPACE = 0x00000030,
    FILE_LINK_IGNORE_READONLY_ATTRIBUTE = 0x00000040,
    FILE_LINK_FORCE_RESIZE_TARGET_SR = 0x00000080,
    FILE_LINK_FORCE_RESIZE_SOURCE_SR = 0x00000100,
    FILE_LINK_FORCE_RESIZE_SR = 0x00000180,
};

enum FILE_RENAME_INFORMATION_EX_FLAGS
{
    FILE_RENAME_REPLACE_IF_EXISTS = 0x00000001,
    FILE_RENAME_POSIX_SEMANTICS = 0x00000002,
    FILE_RENAME_SUPPRESS_PIN_STATE_INHERITANCE = 0x00000004,
    FILE_RENAME_SUPPRESS_STORAGE_RESERVE_INHERITANCE = 0x00000008,
    FILE_RENAME_NO_INCREASE_AVAILABLE_SPACE = 0x00000010,
    FILE_RENAME_NO_DECREASE_AVAILABLE_SPACE = 0x00000020,
    FILE_RENAME_PRESERVE_AVAILABLE_SPACE = 0x00000030,
    FILE_RENAME_IGNORE_READONLY_ATTRIBUTE = 0x00000040,
    FILE_RENAME_FORCE_RESIZE_TARGET_SR = 0x00000080,
    FILE_RENAME_FORCE_RESIZE_SOURCE_SR = 0x00000100,
    FILE_RENAME_FORCE_RESIZE_SR = 0x00000180,
};

enum FILE_IO_COMPLETION_NOTIFICATION_FLAGS
{
    FILE_SKIP_COMPLETION_PORT_ON_SUCCESS_ = 0x1,
    FILE_SKIP_SET_EVENT_ON_HANDLE_ = 0x2,
    FILE_SKIP_SET_USER_EVENT_ON_FAST_IO = 0x4,
};

enum FILE_STAT_LX_INFORMATION_LXFLAGS
{
    LX_FILE_METADATA_HAS_UID = 0x1,
    LX_FILE_METADATA_HAS_GID = 0x2,
    LX_FILE_METADATA_HAS_MODE = 0x4,
    LX_FILE_METADATA_HAS_DEVICE_ID = 0x8,
    LX_FILE_CASE_SENSITIVE_DIR = 0x10,
};

enum FILE_CASE_SENSITIVE_INFORMATION_FLAGS
{
    _FILE_CS_FLAG_CASE_SENSITIVE_DIR = 0x00000001,
};

enum FILE_FULL_EA_INFORMATION_FLAGS
{
    FILE_ID_GLOBAL_TX_DIR_INFO_FLAG_WRITELOCKED = 0x00000001,
    FILE_ID_GLOBAL_TX_DIR_INFO_FLAG_VISIBLE_TO_TX = 0x00000002,
    FILE_ID_GLOBAL_TX_DIR_INFO_FLAG_VISIBLE_OUTSIDE_TX = 0x00000004,
};

enum FILE_SYSTEM_CONTROL_FLAGS
{
    FILE_VC_QUOTA_NONE = 0x00000000,
    FILE_VC_QUOTA_TRACK = 0x00000001,
    FILE_VC_QUOTA_ENFORCE = 0x00000002,
    FILE_VC_QUOTA_MASK = 0x00000003,
    FILE_VC_CONTENT_INDEX_DISABLED = 0x00000008,
    FILE_VC_LOG_QUOTA_THRESHOLD = 0x00000010,
    FILE_VC_LOG_QUOTA_LIMIT = 0x00000020,
    FILE_VC_LOG_VOLUME_THRESHOLD = 0x00000040,
    FILE_VC_LOG_VOLUME_LIMIT = 0x00000080,
    FILE_VC_QUOTAS_INCOMPLETE = 0x00000100,
    FILE_VC_QUOTAS_REBUILDING = 0x00000200,
    FILE_VC_VALID_MASK = 0x000003ff,
};

enum FILE_FS_SECTOR_SIZE_INFORMATION_FLAGS
{
    SSINFO_FLAGS_ALIGNED_DEVICE = 0x00000001,
    SSINFO_FLAGS_PARTITION_ALIGNED_ON_DEVICE = 0x00000002,
    SSINFO_FLAGS_NO_SEEK_PENALTY = 0x00000004,
    SSINFO_FLAGS_TRIM_ENABLED = 0x00000008,
    SSINFO_FLAGS_BYTE_ADDRESSABLE = 0x00000010,
};

enum
{
    SSINFO_OFFSET_UNKNOWN = 0xffffffff,
};

enum FILE_FLUSH_FLAGS
{
    _FLUSH_FLAGS_FILE_DATA_ONLY = 0x00000001,
    _FLUSH_FLAGS_NO_SYNC = 0x00000002,
    _FLUSH_FLAGS_FILE_DATA_SYNC_ONLY = 0x00000004,
    _FLUSH_FLAGS_FLUSH_AND_PURGE = 0x00000008,
};

enum FILE_QUERY_FLAGS
{
    FILE_QUERY_RESTART_SCAN = 0x00000001,
    FILE_QUERY_RETURN_SINGLE_ENTRY = 0x00000002,
    FILE_QUERY_INDEX_SPECIFIED = 0x00000004,
    FILE_QUERY_RETURN_ON_DISK_ENTRIES_ONLY = 0x00000008,
    FILE_QUERY_NO_CURSOR_UPDATE = 0x00000010,
};

enum FILE_NOTIFY_CHANGE_FILTER_FLAGS
{
    _FILE_NOTIFY_CHANGE_FILE_NAME = 0x00000001,
    _FILE_NOTIFY_CHANGE_DIR_NAME = 0x00000002,
    _FILE_NOTIFY_CHANGE_NAME = 0x00000003,
    _FILE_NOTIFY_CHANGE_ATTRIBUTES = 0x00000004,
    _FILE_NOTIFY_CHANGE_SIZE = 0x00000008,
    _FILE_NOTIFY_CHANGE_LAST_WRITE = 0x00000010,
    _FILE_NOTIFY_CHANGE_LAST_ACCESS = 0x00000020,
    _FILE_NOTIFY_CHANGE_CREATION = 0x00000040,
    _FILE_NOTIFY_CHANGE_EA = 0x00000080,
    _FILE_NOTIFY_CHANGE_SECURITY = 0x00000100,
    _FILE_NOTIFY_CHANGE_STREAM_NAME = 0x00000200,
    _FILE_NOTIFY_CHANGE_STREAM_SIZE = 0x00000400,
    _FILE_NOTIFY_CHANGE_STREAM_WRITE = 0x00000800,
    _FILE_NOTIFY_VALID_MASK = 0x00000fff,
};

enum FILE_ACTION_TYPE_CODES
{
    _FILE_ACTION_ADDED = 0x00000001,
    _FILE_ACTION_REMOVED = 0x00000002,
    _FILE_ACTION_MODIFIED = 0x00000003,
    _FILE_ACTION_RENAMED_OLD_NAME = 0x00000004,
    _FILE_ACTION_RENAMED_NEW_NAME = 0x00000005,
    _FILE_ACTION_ADDED_STREAM = 0x00000006,
    _FILE_ACTION_REMOVED_STREAM = 0x00000007,
    _FILE_ACTION_MODIFIED_STREAM = 0x00000008,
    _FILE_ACTION_REMOVED_BY_DELETE = 0x00000009,
    _FILE_ACTION_ID_NOT_TUNNELLED = 0x0000000A,
    _FILE_ACTION_TUNNELLED_ID_COLLISION = 0x0000000B,
};

enum FILE_NOTIFY_FULL_INFORMATION_FILENAME_FLAGS
{
    _FILE_NAME_FLAG_HARDLINK = 0,
    _FILE_NAME_FLAG_NTFS = 0x01,
    _FILE_NAME_FLAG_DOS = 0x02,
    _FILE_NAME_FLAG_BOTH = 0x03,
    _FILE_NAME_FLAGS_UNSPECIFIED = 0x80,
};

enum REPARSE_DATA_BUFFER_FLAGS
{
    SYMLINK_FLAG_RELATIVE = 0x00000001,
    SYMLINK_DIRECTORY = 0x80000000,
    SYMLINK_FILE = 0x40000000,
};

enum FSCTL_PIPE_CTL_CODES
{
    FSCTL_PIPE_ASSIGN_EVENT = CTL_CODE(FILE_DEVICE_NAMED_PIPE, 0, METHOD_BUFFERED, FILE_ANY_ACCESS),
    FSCTL_PIPE_DISCONNECT = CTL_CODE(FILE_DEVICE_NAMED_PIPE, 1, METHOD_BUFFERED, FILE_ANY_ACCESS),
    FSCTL_PIPE_LISTEN = CTL_CODE(FILE_DEVICE_NAMED_PIPE, 2, METHOD_BUFFERED, FILE_ANY_ACCESS),
    FSCTL_PIPE_PEEK = CTL_CODE(FILE_DEVICE_NAMED_PIPE, 3, METHOD_BUFFERED, FILE_READ_DATA),
    FSCTL_PIPE_QUERY_EVENT = CTL_CODE(FILE_DEVICE_NAMED_PIPE, 4, METHOD_BUFFERED, FILE_ANY_ACCESS),
    FSCTL_PIPE_TRANSCEIVE = CTL_CODE(FILE_DEVICE_NAMED_PIPE, 5, METHOD_NEITHER, FILE_READ_DATA | FILE_WRITE_DATA),
    FSCTL_PIPE_WAIT = CTL_CODE(FILE_DEVICE_NAMED_PIPE, 6, METHOD_BUFFERED, FILE_ANY_ACCESS),
    FSCTL_PIPE_IMPERSONATE = CTL_CODE(FILE_DEVICE_NAMED_PIPE, 7, METHOD_BUFFERED, FILE_ANY_ACCESS),
    FSCTL_PIPE_SET_CLIENT_PROCESS = CTL_CODE(FILE_DEVICE_NAMED_PIPE, 8, METHOD_BUFFERED, FILE_ANY_ACCESS),
    FSCTL_PIPE_QUERY_CLIENT_PROCESS = CTL_CODE(FILE_DEVICE_NAMED_PIPE, 9, METHOD_BUFFERED, FILE_ANY_ACCESS),
    FSCTL_PIPE_GET_PIPE_ATTRIBUTE = CTL_CODE(FILE_DEVICE_NAMED_PIPE, 10, METHOD_BUFFERED, FILE_ANY_ACCESS),
    FSCTL_PIPE_SET_PIPE_ATTRIBUTE = CTL_CODE(FILE_DEVICE_NAMED_PIPE, 11, METHOD_BUFFERED, FILE_ANY_ACCESS),
    FSCTL_PIPE_GET_CONNECTION_ATTRIBUTE = CTL_CODE(FILE_DEVICE_NAMED_PIPE, 12, METHOD_BUFFERED, FILE_ANY_ACCESS),
    FSCTL_PIPE_SET_CONNECTION_ATTRIBUTE = CTL_CODE(FILE_DEVICE_NAMED_PIPE, 13, METHOD_BUFFERED, FILE_ANY_ACCESS),
    FSCTL_PIPE_GET_HANDLE_ATTRIBUTE = CTL_CODE(FILE_DEVICE_NAMED_PIPE, 14, METHOD_BUFFERED, FILE_ANY_ACCESS),
    FSCTL_PIPE_SET_HANDLE_ATTRIBUTE = CTL_CODE(FILE_DEVICE_NAMED_PIPE, 15, METHOD_BUFFERED, FILE_ANY_ACCESS),
    FSCTL_PIPE_FLUSH = CTL_CODE(FILE_DEVICE_NAMED_PIPE, 16, METHOD_BUFFERED, FILE_WRITE_DATA),
    FSCTL_PIPE_DISABLE_IMPERSONATE = CTL_CODE(FILE_DEVICE_NAMED_PIPE, 17, METHOD_BUFFERED, FILE_ANY_ACCESS),
    FSCTL_PIPE_SILO_ARRIVAL = CTL_CODE(FILE_DEVICE_NAMED_PIPE, 18, METHOD_BUFFERED, FILE_WRITE_DATA),
    FSCTL_PIPE_CREATE_SYMLINK = CTL_CODE(FILE_DEVICE_NAMED_PIPE, 19, METHOD_BUFFERED, FILE_SPECIAL_ACCESS),
    FSCTL_PIPE_DELETE_SYMLINK = CTL_CODE(FILE_DEVICE_NAMED_PIPE, 20, METHOD_BUFFERED, FILE_SPECIAL_ACCESS),
    FSCTL_PIPE_QUERY_CLIENT_PROCESS_V2 = CTL_CODE(FILE_DEVICE_NAMED_PIPE, 21, METHOD_BUFFERED, FILE_ANY_ACCESS),
    FSCTL_PIPE_INTERNAL_READ = CTL_CODE(FILE_DEVICE_NAMED_PIPE, 2045, METHOD_BUFFERED, FILE_READ_DATA),
    FSCTL_PIPE_INTERNAL_WRITE = CTL_CODE(FILE_DEVICE_NAMED_PIPE, 2046, METHOD_BUFFERED, FILE_WRITE_DATA),
    FSCTL_PIPE_INTERNAL_TRANSCEIVE = CTL_CODE(FILE_DEVICE_NAMED_PIPE, 2047, METHOD_NEITHER, FILE_READ_DATA | FILE_WRITE_DATA),
    FSCTL_PIPE_INTERNAL_READ_OVFLOW = CTL_CODE(FILE_DEVICE_NAMED_PIPE, 2048, METHOD_BUFFERED, FILE_READ_DATA),
};

enum
{
    MOUNTMGRCONTROLTYPE = 0x0000006D,    // 'm'
    MOUNTDEVCONTROLTYPE = 0x0000004D,    // 'M'
};

enum IOCTL_MOUNTMGR_CTL_CODES
{
    IOCTL_MOUNTMGR_CREATE_POINT = CTL_CODE(MOUNTMGRCONTROLTYPE, 0, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS),
    IOCTL_MOUNTMGR_DELETE_POINTS = CTL_CODE(MOUNTMGRCONTROLTYPE, 1, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS),
    IOCTL_MOUNTMGR_QUERY_POINTS = CTL_CODE(MOUNTMGRCONTROLTYPE, 2, METHOD_BUFFERED, FILE_ANY_ACCESS),
    IOCTL_MOUNTMGR_DELETE_POINTS_DBONLY = CTL_CODE(MOUNTMGRCONTROLTYPE, 3, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS),
    IOCTL_MOUNTMGR_NEXT_DRIVE_LETTER = CTL_CODE(MOUNTMGRCONTROLTYPE, 4, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS),
    IOCTL_MOUNTMGR_AUTO_DL_ASSIGNMENTS = CTL_CODE(MOUNTMGRCONTROLTYPE, 5, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS),
    IOCTL_MOUNTMGR_VOLUME_MOUNT_POINT_CREATED = CTL_CODE(MOUNTMGRCONTROLTYPE, 6, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS),
    IOCTL_MOUNTMGR_VOLUME_MOUNT_POINT_DELETED = CTL_CODE(MOUNTMGRCONTROLTYPE, 7, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS),
    IOCTL_MOUNTMGR_CHANGE_NOTIFY = CTL_CODE(MOUNTMGRCONTROLTYPE, 8, METHOD_BUFFERED, FILE_READ_ACCESS),
    IOCTL_MOUNTMGR_KEEP_LINKS_WHEN_OFFLINE = CTL_CODE(MOUNTMGRCONTROLTYPE, 9, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS),
    IOCTL_MOUNTMGR_CHECK_UNPROCESSED_VOLUMES = CTL_CODE(MOUNTMGRCONTROLTYPE, 10, METHOD_BUFFERED, FILE_READ_ACCESS),
    IOCTL_MOUNTMGR_VOLUME_ARRIVAL_NOTIFICATION = CTL_CODE(MOUNTMGRCONTROLTYPE, 11, METHOD_BUFFERED, FILE_READ_ACCESS),
    IOCTL_MOUNTMGR_QUERY_DOS_VOLUME_PATH = CTL_CODE(MOUNTMGRCONTROLTYPE, 12, METHOD_BUFFERED, FILE_ANY_ACCESS),
    IOCTL_MOUNTMGR_QUERY_DOS_VOLUME_PATHS = CTL_CODE(MOUNTMGRCONTROLTYPE, 13, METHOD_BUFFERED, FILE_ANY_ACCESS),
    IOCTL_MOUNTMGR_SCRUB_REGISTRY = CTL_CODE(MOUNTMGRCONTROLTYPE, 14, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS),
    IOCTL_MOUNTMGR_QUERY_AUTO_MOUNT = CTL_CODE(MOUNTMGRCONTROLTYPE, 15, METHOD_BUFFERED, FILE_ANY_ACCESS),
    IOCTL_MOUNTMGR_SET_AUTO_MOUNT = CTL_CODE(MOUNTMGRCONTROLTYPE, 16, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS),
    IOCTL_MOUNTMGR_BOOT_DL_ASSIGNMENT = CTL_CODE(MOUNTMGRCONTROLTYPE, 17, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS),
    IOCTL_MOUNTMGR_TRACELOG_CACHE = CTL_CODE(MOUNTMGRCONTROLTYPE, 18, METHOD_BUFFERED, FILE_READ_ACCESS),
    IOCTL_MOUNTMGR_PREPARE_VOLUME_DELETE = CTL_CODE(MOUNTMGRCONTROLTYPE, 19, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS),
    IOCTL_MOUNTMGR_CANCEL_VOLUME_DELETE = CTL_CODE(MOUNTMGRCONTROLTYPE, 20, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS),
    IOCTL_MOUNTMGR_SILO_ARRIVAL = CTL_CODE(MOUNTMGRCONTROLTYPE, 21, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS),
    IOCTL_MOUNTDEV_QUERY_DEVICE_NAME = CTL_CODE(MOUNTDEVCONTROLTYPE, 2, METHOD_BUFFERED, FILE_ANY_ACCESS),
};

enum FLT_CTL_CODES
{
    FLT_CTL_LOAD = CTL_CODE(FILE_DEVICE_DISK_FILE_SYSTEM, 1, METHOD_BUFFERED, FILE_WRITE_ACCESS),
    FLT_CTL_UNLOAD = CTL_CODE(FILE_DEVICE_DISK_FILE_SYSTEM, 2, METHOD_BUFFERED, FILE_WRITE_ACCESS),
    FLT_CTL_LINK_HANDLE = CTL_CODE(FILE_DEVICE_DISK_FILE_SYSTEM, 3, METHOD_BUFFERED, FILE_READ_ACCESS),
    FLT_CTL_ATTACH = CTL_CODE(FILE_DEVICE_DISK_FILE_SYSTEM, 4, METHOD_BUFFERED, FILE_WRITE_ACCESS),
    FLT_CTL_DETATCH = CTL_CODE(FILE_DEVICE_DISK_FILE_SYSTEM, 5, METHOD_BUFFERED, FILE_WRITE_ACCESS),
    FLT_CTL_SEND_MESSAGE = CTL_CODE(FILE_DEVICE_DISK_FILE_SYSTEM, 6, METHOD_NEITHER, FILE_WRITE_ACCESS),
    FLT_CTL_GET_MESSAGE = CTL_CODE(FILE_DEVICE_DISK_FILE_SYSTEM, 7, METHOD_NEITHER, FILE_READ_ACCESS),
    FLT_CTL_REPLY_MESSAGE = CTL_CODE(FILE_DEVICE_DISK_FILE_SYSTEM, 8, METHOD_NEITHER, FILE_WRITE_ACCESS),
    FLT_CTL_FIND_FIRST = CTL_CODE(FILE_DEVICE_DISK_FILE_SYSTEM, 9, METHOD_BUFFERED, FILE_READ_ACCESS),
    FLT_CTL_FIND_NEXT = CTL_CODE(FILE_DEVICE_DISK_FILE_SYSTEM, 10, METHOD_BUFFERED, FILE_READ_ACCESS),
    FLT_CTL_GET_INFORMATION = CTL_CODE(FILE_DEVICE_DISK_FILE_SYSTEM, 11, METHOD_BUFFERED, FILE_READ_ACCESS),
};

enum FSCTL_MUP_CTL_CODES
{
    FSCTL_MUP_GET_UNC_CACHE_INFO = CTL_CODE(FILE_DEVICE_MULTI_UNC_PROVIDER, 11, METHOD_BUFFERED, FILE_ANY_ACCESS), // out: MUP_FSCTL_UNC_CACHE_INFORMATION
    FSCTL_MUP_GET_UNC_PROVIDER_LIST = CTL_CODE(FILE_DEVICE_MULTI_UNC_PROVIDER, 12, METHOD_BUFFERED, FILE_ANY_ACCESS), // out: MUP_FSCTL_UNC_PROVIDER_INFORMATION
    FSCTL_MUP_GET_SURROGATE_PROVIDER_LIST = CTL_CODE(FILE_DEVICE_MULTI_UNC_PROVIDER, 13, METHOD_BUFFERED, FILE_ANY_ACCESS), // out: MUP_FSCTL_SURROGATE_PROVIDER_INFORMATION
    FSCTL_MUP_GET_UNC_HARDENING_CONFIGURATION = CTL_CODE(FILE_DEVICE_MULTI_UNC_PROVIDER, 14, METHOD_BUFFERED, FILE_ANY_ACCESS), // out: MUP_FSCTL_UNC_HARDENING_PREFIX_TABLE_ENTRY[]
    FSCTL_MUP_GET_UNC_HARDENING_CONFIGURATION_FOR_PATH = CTL_CODE(FILE_DEVICE_MULTI_UNC_PROVIDER, 15, METHOD_BUFFERED, FILE_ANY_ACCESS), // in: MUP_FSCTL_QUERY_UNC_HARDENING_CONFIGURATION_IN; out: MUP_FSCTL_QUERY_UNC_HARDENING_CONFIGURATION_OUT
};

enum IRP_MAJOR_FUNCTION_CODES
{
    IRP_MJ_CREATE = 0x00,
    IRP_MJ_CREATE_NAMED_PIPE = 0x01,
    IRP_MJ_CLOSE = 0x02,
    IRP_MJ_READ = 0x03,
    IRP_MJ_WRITE = 0x04,
    IRP_MJ_QUERY_INFORMATION = 0x05,
    IRP_MJ_SET_INFORMATION = 0x06,
    IRP_MJ_QUERY_EA = 0x07,
    IRP_MJ_SET_EA = 0x08,
    IRP_MJ_FLUSH_BUFFERS = 0x09,
    IRP_MJ_QUERY_VOLUME_INFORMATION = 0x0a,
    IRP_MJ_SET_VOLUME_INFORMATION = 0x0b,
    IRP_MJ_DIRECTORY_CONTROL = 0x0c,
    IRP_MJ_FILE_SYSTEM_CONTROL = 0x0d,
    IRP_MJ_DEVICE_CONTROL = 0x0e,
    IRP_MJ_INTERNAL_DEVICE_CONTROL = 0x0f,
    IRP_MJ_SHUTDOWN = 0x10,
    IRP_MJ_LOCK_CONTROL = 0x11,
    IRP_MJ_CLEANUP = 0x12,
    IRP_MJ_CREATE_MAILSLOT = 0x13,
    IRP_MJ_QUERY_SECURITY = 0x14,
    IRP_MJ_SET_SECURITY = 0x15,
    IRP_MJ_POWER = 0x16,
    IRP_MJ_SYSTEM_CONTROL = 0x17,
    IRP_MJ_DEVICE_CHANGE = 0x18,
    IRP_MJ_QUERY_QUOTA = 0x19,
    IRP_MJ_SET_QUOTA = 0x1a,
    IRP_MJ_PNP = 0x1b,
    IRP_MJ_PNP_POWER = IRP_MJ_PNP,
    IRP_MJ_MAXIMUM_FUNCTION = 0x1b,
    IRP_MJ_ACQUIRE_FOR_SECTION_SYNCHRONIZATION = ((UCHAR)-1),
    IRP_MJ_RELEASE_FOR_SECTION_SYNCHRONIZATION = ((UCHAR)-2),
    IRP_MJ_ACQUIRE_FOR_MOD_WRITE = ((UCHAR)-3),
    IRP_MJ_RELEASE_FOR_MOD_WRITE = ((UCHAR)-4),
    IRP_MJ_ACQUIRE_FOR_CC_FLUSH = ((UCHAR)-5),
    IRP_MJ_RELEASE_FOR_CC_FLUSH = ((UCHAR)-6),
    IRP_MJ_QUERY_OPEN = ((UCHAR)-7),
    IRP_MJ_FAST_IO_CHECK_IF_POSSIBLE = ((UCHAR)-13),
    IRP_MJ_NETWORK_QUERY_OPEN = ((UCHAR)-14),
    IRP_MJ_MDL_READ = ((UCHAR)-15),
    IRP_MJ_MDL_READ_COMPLETE = ((UCHAR)-16),
    IRP_MJ_PREPARE_MDL_WRITE = ((UCHAR)-17),
    IRP_MJ_MDL_WRITE_COMPLETE = ((UCHAR)-18),
    IRP_MJ_VOLUME_MOUNT = ((UCHAR)-19),
    IRP_MJ_VOLUME_DISMOUNT = ((UCHAR)-20),
    FLT_INTERNAL_OPERATION_COUNT = 22,
};

enum IRP_MINOR_SCSI_FUNCTION_CODES
{
    IRP_MN_SCSI_CLASS = 0x01,
};

enum IRP_MINOR_PNP_FUNCTION_CODES
{
    IRP_MN_START_DEVICE = 0x00,
    IRP_MN_QUERY_REMOVE_DEVICE = 0x01,
    IRP_MN_REMOVE_DEVICE = 0x02,
    IRP_MN_CANCEL_REMOVE_DEVICE = 0x03,
    IRP_MN_STOP_DEVICE = 0x04,
    IRP_MN_QUERY_STOP_DEVICE = 0x05,
    IRP_MN_CANCEL_STOP_DEVICE = 0x06,
    IRP_MN_QUERY_DEVICE_RELATIONS = 0x07,
    IRP_MN_QUERY_INTERFACE = 0x08,
    IRP_MN_QUERY_CAPABILITIES = 0x09,
    IRP_MN_QUERY_RESOURCES = 0x0A,
    IRP_MN_QUERY_RESOURCE_REQUIREMENTS = 0x0B,
    IRP_MN_QUERY_DEVICE_TEXT = 0x0C,
    IRP_MN_FILTER_RESOURCE_REQUIREMENTS = 0x0D,
    IRP_MN_READ_CONFIG = 0x0F,
    IRP_MN_WRITE_CONFIG = 0x10,
    IRP_MN_EJECT = 0x11,
    IRP_MN_SET_LOCK = 0x12,
    IRP_MN_QUERY_ID = 0x13,
    IRP_MN_QUERY_PNP_DEVICE_STATE = 0x14,
    IRP_MN_QUERY_BUS_INFORMATION = 0x15,
    IRP_MN_DEVICE_USAGE_NOTIFICATION = 0x16,
    IRP_MN_SURPRISE_REMOVAL = 0x17,
    IRP_MN_DEVICE_ENUMERATED = 0x19,
};

enum IRP_MINOR_POWER_FUNCTION_CODES
{
    IRP_MN_WAIT_WAKE = 0x00,
    IRP_MN_POWER_SEQUENCE = 0x01,
    IRP_MN_SET_POWER = 0x02,
    IRP_MN_QUERY_POWER = 0x03,
};

enum IRP_MINOR_WMI_FUNCTION_CODES
{
    IRP_MN_QUERY_ALL_DATA = 0x00,
    IRP_MN_QUERY_SINGLE_INSTANCE = 0x01,
    IRP_MN_CHANGE_SINGLE_INSTANCE = 0x02,
    IRP_MN_CHANGE_SINGLE_ITEM = 0x03,
    IRP_MN_ENABLE_EVENTS = 0x04,
    IRP_MN_DISABLE_EVENTS = 0x05,
    IRP_MN_ENABLE_COLLECTION = 0x06,
    IRP_MN_DISABLE_COLLECTION = 0x07,
    IRP_MN_REGINFO = 0x08,
    IRP_MN_EXECUTE_METHOD = 0x09,
};

enum FLTFL_CALLBACK_DATA_FLAGS
{
    FLTFL_CALLBACK_DATA_REISSUE_MASK = 0x0000FFFF,
    FLTFL_CALLBACK_DATA_IRP_OPERATION = 0x00000001,
    FLTFL_CALLBACK_DATA_FAST_IO_OPERATION = 0x00000002,
    FLTFL_CALLBACK_DATA_FS_FILTER_OPERATION = 0x00000004,
    FLTFL_CALLBACK_DATA_SYSTEM_BUFFER = 0x00000008,
    FLTFL_CALLBACK_DATA_GENERATED_IO = 0x00010000,
    FLTFL_CALLBACK_DATA_REISSUED_IO = 0x00020000,
    FLTFL_CALLBACK_DATA_DRAINING_IO = 0x00040000,
    FLTFL_CALLBACK_DATA_POST_OPERATION = 0x00080000,
    FLTFL_CALLBACK_DATA_NEW_SYSTEM_BUFFER = 0x00100000,
    FLTFL_CALLBACK_DATA_DIRTY = 0x80000000,
};

enum IRP_FLAGS
{
    IRP_NOCACHE = 0x00000001,
    IRP_PAGING_IO = 0x00000002,
    IRP_MOUNT_COMPLETION = 0x00000002,
    IRP_SYNCHRONOUS_API = 0x00000004,
    IRP_ASSOCIATED_IRP = 0x00000008,
    IRP_BUFFERED_IO = 0x00000010,
    IRP_DEALLOCATE_BUFFER = 0x00000020,
    IRP_INPUT_OPERATION = 0x00000040,
    IRP_SYNCHRONOUS_PAGING_IO = 0x00000040,
    IRP_CREATE_OPERATION = 0x00000080,
    IRP_READ_OPERATION = 0x00000100,
    IRP_WRITE_OPERATION = 0x00000200,
    IRP_CLOSE_OPERATION = 0x00000400,
    IRP_DEFER_IO_COMPLETION = 0x00000800,
    IRP_OB_QUERY_NAME = 0x00001000,
    IRP_HOLD_DEVICE_QUEUE = 0x00002000,
    IRP_UM_DRIVER_INITIATED_IO = 0x00400000,
};

enum FILE_OBJECT_FLAGS
{
    FO_FILE_OPEN = 0x00000001,
    FO_SYNCHRONOUS_IO = 0x00000002,
    FO_ALERTABLE_IO = 0x00000004,
    FO_NO_INTERMEDIATE_BUFFERING = 0x00000008,
    FO_WRITE_THROUGH = 0x00000010,
    FO_SEQUENTIAL_ONLY = 0x00000020,
    FO_CACHE_SUPPORTED = 0x00000040,
    FO_NAMED_PIPE = 0x00000080,
    FO_STREAM_FILE = 0x00000100,
    FO_MAILSLOT = 0x00000200,
    FO_GENERATE_AUDIT_ON_CLOSE = 0x00000400,
    FO_QUEUE_IRP_TO_THREAD = FO_GENERATE_AUDIT_ON_CLOSE,
    FO_DIRECT_DEVICE_OPEN = 0x00000800,
    FO_FILE_MODIFIED = 0x00001000,
    FO_FILE_SIZE_CHANGED = 0x00002000,
    FO_CLEANUP_COMPLETE = 0x00004000,
    FO_TEMPORARY_FILE = 0x00008000,
    FO_DELETE_ON_CLOSE = 0x00010000,
    FO_OPENED_CASE_SENSITIVE = 0x00020000,
    FO_HANDLE_CREATED = 0x00040000,
    FO_FILE_FAST_IO_READ = 0x00080000,
    FO_RANDOM_ACCESS = 0x00100000,
    FO_FILE_OPEN_CANCELLED = 0x00200000,
    FO_VOLUME_OPEN = 0x00400000,
    FO_BYPASS_IO_ENABLED = 0x00800000,
    FO_REMOTE_ORIGIN = 0x01000000,
    FO_DISALLOW_EXCLUSIVE = 0x02000000,
    FO_SKIP_COMPLETION_PORT = FO_DISALLOW_EXCLUSIVE,
    FO_SKIP_SET_EVENT = 0x04000000,
    FO_SKIP_SET_FAST_IO = 0x08000000,
    FO_INDIRECT_WAIT_OBJECT = 0x10000000,
    FO_SECTION_MINSTORE_TREATMENT = 0x20000000,
};

enum IO_STACK_LOCATION_FLAGS
{
    SL_PENDING_RETURNED = 0x01,
    SL_ERROR_RETURNED = 0x02,
    SL_INVOKE_ON_CANCEL = 0x20,
    SL_INVOKE_ON_SUCCESS = 0x40,
    SL_INVOKE_ON_ERROR = 0x80,
    SL_FORCE_ACCESS_CHECK = 0x01,
    SL_OPEN_PAGING_FILE = 0x02,
    SL_OPEN_TARGET_DIRECTORY = 0x04,
    SL_STOP_ON_SYMLINK = 0x08,
    SL_IGNORE_READONLY_ATTRIBUTE = 0x40,
    SL_CASE_SENSITIVE = 0x80,
    SL_KEY_SPECIFIED = 0x01,
    SL_OVERRIDE_VERIFY_VOLUME = 0x02,
    SL_WRITE_THROUGH = 0x04,
    SL_FT_SEQUENTIAL_WRITE = 0x08,
    SL_FORCE_DIRECT_WRITE = 0x10,
    SL_REALTIME_STREAM = 0x20,
    SL_PERSISTENT_MEMORY_FIXED_MAPPING = 0x20,
    SL_BYPASS_IO = 0x40,
    SL_FORCE_ASYNCHRONOUS = 0x01,
    SL_READ_ACCESS_GRANTED = 0x01,
    SL_WRITE_ACCESS_GRANTED = 0x04,
    SL_FAIL_IMMEDIATELY = 0x01,
    SL_EXCLUSIVE_LOCK = 0x02,
    SL_RESTART_SCAN = 0x01,
    SL_RETURN_SINGLE_ENTRY = 0x02,
    SL_INDEX_SPECIFIED = 0x04,
    SL_RETURN_ON_DISK_ENTRIES_ONLY = 0x08,
    SL_NO_CURSOR_UPDATE = 0x10,
    SL_QUERY_DIRECTORY_MASK = 0x1b,
    SL_WATCH_TREE = 0x01,
    SL_ALLOW_RAW_MOUNT = 0x01,
    SL_BYPASS_ACCESS_CHECK = 0x01,
    SL_INFO_FORCE_ACCESS_CHECK = 0x01,
    SL_INFO_IGNORE_READONLY_ATTRIBUTE = 0x40,
};

enum DEVICE_OBJECT_FLAGS
{
    DO_VERIFY_VOLUME = 0x00000002,
    DO_BUFFERED_IO = 0x00000004,
    DO_EXCLUSIVE = 0x00000008,
    DO_DIRECT_IO = 0x00000010,
    DO_MAP_IO_BUFFER = 0x00000020,
    DO_DEVICE_INITIALIZING = 0x00000080,
    DO_SHUTDOWN_REGISTERED = 0x00000800,
    DO_BUS_ENUMERATED_DEVICE = 0x00001000,
    DO_POWER_PAGABLE = 0x00002000,
    DO_POWER_INRUSH = 0x00004000,
    DO_DEVICE_TO_BE_RESET = 0x04000000,
    DO_DAX_VOLUME = 0x10000000,
};

enum KSECDD_FS_CTL_CODES
{
    IOCTL_KSEC_CONNECT_LSA = CTL_CODE(FILE_DEVICE_KSEC, 0, METHOD_BUFFERED, FILE_WRITE_ACCESS),
    IOCTL_KSEC_RNG = CTL_CODE(FILE_DEVICE_KSEC, 1, METHOD_BUFFERED, FILE_ANY_ACCESS),
    IOCTL_KSEC_RNG_REKEY = CTL_CODE(FILE_DEVICE_KSEC, 2, METHOD_BUFFERED, FILE_ANY_ACCESS),
    IOCTL_KSEC_ENCRYPT_MEMORY = CTL_CODE(FILE_DEVICE_KSEC, 3, METHOD_OUT_DIRECT, FILE_ANY_ACCESS),
    IOCTL_KSEC_DECRYPT_MEMORY = CTL_CODE(FILE_DEVICE_KSEC, 4, METHOD_OUT_DIRECT, FILE_ANY_ACCESS),
    IOCTL_KSEC_ENCRYPT_MEMORY_CROSS_PROC = CTL_CODE(FILE_DEVICE_KSEC, 5, METHOD_OUT_DIRECT, FILE_ANY_ACCESS),
    IOCTL_KSEC_DECRYPT_MEMORY_CROSS_PROC = CTL_CODE(FILE_DEVICE_KSEC, 6, METHOD_OUT_DIRECT, FILE_ANY_ACCESS),
    IOCTL_KSEC_ENCRYPT_MEMORY_SAME_LOGON = CTL_CODE(FILE_DEVICE_KSEC, 7, METHOD_OUT_DIRECT, FILE_ANY_ACCESS),
    IOCTL_KSEC_DECRYPT_MEMORY_SAME_LOGON = CTL_CODE(FILE_DEVICE_KSEC, 8, METHOD_OUT_DIRECT, FILE_ANY_ACCESS),
    IOCTL_KSEC_FIPS_GET_FUNCTION_TABLE = CTL_CODE(FILE_DEVICE_KSEC, 9, METHOD_BUFFERED, FILE_ANY_ACCESS),
    IOCTL_KSEC_ALLOC_POOL = CTL_CODE(FILE_DEVICE_KSEC, 10, METHOD_BUFFERED, FILE_ANY_ACCESS),
    IOCTL_KSEC_FREE_POOL = CTL_CODE(FILE_DEVICE_KSEC, 11, METHOD_BUFFERED, FILE_ANY_ACCESS),
    IOCTL_KSEC_COPY_POOL = CTL_CODE(FILE_DEVICE_KSEC, 12, METHOD_BUFFERED, FILE_ANY_ACCESS),
    IOCTL_KSEC_DUPLICATE_HANDLE = CTL_CODE(FILE_DEVICE_KSEC, 13, METHOD_BUFFERED, FILE_ANY_ACCESS),
    IOCTL_KSEC_REGISTER_EXTENSION = CTL_CODE(FILE_DEVICE_KSEC, 14, METHOD_BUFFERED, FILE_ANY_ACCESS),
    IOCTL_KSEC_CLIENT_CALLBACK = CTL_CODE(FILE_DEVICE_KSEC, 15, METHOD_BUFFERED, FILE_ANY_ACCESS),
    IOCTL_KSEC_GET_BCRYPT_EXTENSION = CTL_CODE(FILE_DEVICE_KSEC, 16, METHOD_BUFFERED, FILE_ANY_ACCESS),
    IOCTL_KSEC_GET_SSL_EXTENSION = CTL_CODE(FILE_DEVICE_KSEC, 17, METHOD_BUFFERED, FILE_ANY_ACCESS),
    IOCTL_KSEC_GET_DEVICECONTROL_EXTENSION = CTL_CODE(FILE_DEVICE_KSEC, 18, METHOD_BUFFERED, FILE_ANY_ACCESS),
    IOCTL_KSEC_ALLOC_VM = CTL_CODE(FILE_DEVICE_KSEC, 19, METHOD_BUFFERED, FILE_ANY_ACCESS),
    IOCTL_KSEC_FREE_VM = CTL_CODE(FILE_DEVICE_KSEC, 20, METHOD_BUFFERED, FILE_ANY_ACCESS),
    IOCTL_KSEC_COPY_VM = CTL_CODE(FILE_DEVICE_KSEC, 21, METHOD_BUFFERED, FILE_ANY_ACCESS),
    IOCTL_KSEC_CLIENT_FREE_VM = CTL_CODE(FILE_DEVICE_KSEC, 22, METHOD_BUFFERED, FILE_ANY_ACCESS),
    IOCTL_KSEC_INSERT_PROTECTED_PROCESS_ADDRESS = CTL_CODE(FILE_DEVICE_KSEC, 23, METHOD_BUFFERED, FILE_ANY_ACCESS),
    IOCTL_KSEC_REMOVE_PROTECTED_PROCESS_ADDRESS = CTL_CODE(FILE_DEVICE_KSEC, 24, METHOD_BUFFERED, FILE_ANY_ACCESS),
    IOCTL_KSEC_GET_BCRYPT_EXTENSION2 = CTL_CODE(FILE_DEVICE_KSEC, 25, METHOD_BUFFERED, FILE_ANY_ACCESS),
    IOCTL_KSEC_IPC_GET_QUEUED_FUNCTION_CALLS = CTL_CODE(FILE_DEVICE_KSEC, 26, METHOD_OUT_DIRECT, FILE_ANY_ACCESS),
    IOCTL_KSEC_IPC_SET_FUNCTION_RETURN = CTL_CODE(FILE_DEVICE_KSEC, 27, METHOD_NEITHER, FILE_ANY_ACCESS),
};

enum OPLOCK_KEY_VERSIONS
{
    OPLOCK_KEY_VERSION_WIN7 = 0x0001,
    OPLOCK_KEY_VERSION_WIN8 = 0x0002,
};

enum OPLOCK_KEY_FLAGS
{
    OPLOCK_KEY_FLAG_PARENT_KEY = 0x0001,
    OPLOCK_KEY_FLAG_TARGET_KEY = 0x0002,
};

enum SUPPORTED_FS_FEATURES
{
    SUPPORTED_FS_FEATURES_OFFLOAD_READ = 0x00000001,
    SUPPORTED_FS_FEATURES_OFFLOAD_WRITE = 0x00000002,
    SUPPORTED_FS_FEATURES_QUERY_OPEN = 0x00000004,
    SUPPORTED_FS_FEATURES_BYPASS_IO = 0x00000008,
    SUPPORTED_FS_FEATURES_VALID_MASK_V3 = (SUPPORTED_FS_FEATURES_OFFLOAD_READ | \
        SUPPORTED_FS_FEATURES_OFFLOAD_WRITE | \
        SUPPORTED_FS_FEATURES_QUERY_OPEN | \
        SUPPORTED_FS_FEATURES_BYPASS_IO),
    SUPPORTED_FS_FEATURES_VALID_MASK_V2 = (SUPPORTED_FS_FEATURES_OFFLOAD_READ | \
        SUPPORTED_FS_FEATURES_OFFLOAD_WRITE | \
        SUPPORTED_FS_FEATURES_QUERY_OPEN),
    SUPPORTED_FS_FEATURES_VALID_MASK_V1 = (SUPPORTED_FS_FEATURES_OFFLOAD_READ | \
        SUPPORTED_FS_FEATURES_OFFLOAD_WRITE),
    SUPPORTED_FS_FEATURES_VALID_MASK = SUPPORTED_FS_FEATURES_VALID_MASK_V3,
};

#pragma endregion ntioapi.h

#pragma region ntlpcapi.h

// noname
enum NTLPCAPI_H
{
    PORT_CONNECT = 0x0001,
    PORT_ALL_ACCESS = (STANDARD_RIGHTS_REQUIRED | SYNCHRONIZE | 0x1),
    PORT_VALID_OBJECT_ATTRIBUTES = OBJ_CASE_INSENSITIVE,
#ifdef _WIN64
    PORT_MAXIMUM_MESSAGE_LENGTH = 512,
#else
    PORT_MAXIMUM_MESSAGE_LENGTH = 256,
#endif
    LPC_MAX_CONNECTION_INFO_SIZE = (16 * sizeof(ULONG_PTR)),
    ALPC_COMPLETION_LIST_BUFFER_GRANULARITY_MASK = 0x3f,
    ALPC_CREATEPORTSECTIONFLG_SECURE = 0x40000,
};

enum LPC_TYPES
{
    LPC_REQUEST = 1,
    LPC_REPLY = 2,
    LPC_DATAGRAM = 3,
    LPC_LOST_REPLY = 4,
    LPC_PORT_CLOSED = 5,
    LPC_CLIENT_DIED = 6,
    LPC_EXCEPTION = 7,
    LPC_DEBUG_EVENT = 8,
    LPC_ERROR_EVENT = 9,
    LPC_CONNECTION_REQUEST = 10,

    LPC_CONTINUATION_REQUIRED = 0x2000,
    LPC_NO_IMPERSONATE = 0x4000,
    LPC_KERNELMODE_MESSAGE = 0x8000,
};

enum ALPC_PORT_FLAGS
{
    ALPC_PORFLG_LPC_MODE = 0x1000, // kernel only
    ALPC_PORFLG_ALLOW_IMPERSONATION = 0x10000,
    ALPC_PORFLG_ALLOW_LPC_REQUESTS = 0x20000, // rev
    ALPC_PORFLG_WAITABLE_PORT = 0x40000, // dbg
    ALPC_PORFLG_ALLOW_DUP_OBJECT = 0x80000,
    ALPC_PORFLG_SYSTEM_PROCESS = 0x100000, // dbg
    ALPC_PORFLG_WAKE_POLICY1 = 0x200000,
    ALPC_PORFLG_WAKE_POLICY2 = 0x400000,
    ALPC_PORFLG_WAKE_POLICY3 = 0x800000,
    ALPC_PORFLG_DIRECT_MESSAGE = 0x1000000,
    ALPC_PORFLG_ALLOW_MULTIHANDLE_ATTRIBUTE = 0x2000000,

    ALPC_PORFLG_OBJECT_TYPE_FILE = 0x0001,
    ALPC_PORFLG_OBJECT_TYPE_INVALID = 0x0002,
    ALPC_PORFLG_OBJECT_TYPE_THREAD = 0x0004,
    ALPC_PORFLG_OBJECT_TYPE_SEMAPHORE = 0x0008,
    ALPC_PORFLG_OBJECT_TYPE_EVENT = 0x0010,
    ALPC_PORFLG_OBJECT_TYPE_PROCESS = 0X0020,
    ALPC_PORFLG_OBJECT_TYPE_MUTEX = 0x0040,
    ALPC_PORFLG_OBJECT_TYPE_SECTION = 0x0080,
    ALPC_PORFLG_OBJECT_TYPE_REGKEY = 0x0100,
    ALPC_PORFLG_OBJECT_TYPE_TOKEN = 0x0200,
    ALPC_PORFLG_OBJECT_TYPE_COMPOSITION = 0x0400,
    ALPC_PORFLG_OBJECT_TYPE_JOB = 0x0800,

    ALPC_PORFLG_OBJECT_TYPE_ALL = (ALPC_PORFLG_OBJECT_TYPE_FILE | ALPC_PORFLG_OBJECT_TYPE_THREAD | \
        ALPC_PORFLG_OBJECT_TYPE_SEMAPHORE | ALPC_PORFLG_OBJECT_TYPE_EVENT | \
        ALPC_PORFLG_OBJECT_TYPE_PROCESS | ALPC_PORFLG_OBJECT_TYPE_MUTEX | \
        ALPC_PORFLG_OBJECT_TYPE_SECTION | ALPC_PORFLG_OBJECT_TYPE_REGKEY | \
        ALPC_PORFLG_OBJECT_TYPE_TOKEN | ALPC_PORFLG_OBJECT_TYPE_COMPOSITION | \
        ALPC_PORFLG_OBJECT_TYPE_JOB),
};

enum E_ALPC_MESSAGE_ATTRIBUTES
{
    ALPC_MESSAGE_HANDLE_ATTRIBUTE = 0x10000000,
    ALPC_MESSAGE_CONTEXT_ATTRIBUTE = 0x20000000,
    ALPC_MESSAGE_VIEW_ATTRIBUTE = 0x40000000,
    ALPC_MESSAGE_SECURITY_ATTRIBUTE = 0x80000000,
};

enum ALPC_HANDLE_FLAGS
{
    ALPC_HANDLEFLG_DUPLICATE_SAME_ACCESS = 0x10000,
    ALPC_HANDLEFLG_DUPLICATE_SAME_ATTRIBUTES = 0x20000,
    ALPC_HANDLEFLG_DUPLICATE_INHERIT = 0x80000,
};

enum ALPC_SECURITY_FLAGS
{
    ALPC_SECFLG_CREATE_HANDLE = 0x20000,
    ALPC_SECFLG_NO_SECTION_HANDLE = 0x40000,
};

enum ALPC_DATA_VIEW_FLAGS
{
    ALPC_VIEWFLG_UNMAP_EXISTING = 0x10000,
    ALPC_VIEWFLG_AUTO_RELEASE = 0x20000,
    ALPC_VIEWFLG_NOT_SECURE = 0x40000,
};

enum ALPC_CONECTION_PORT_FLAGS
{
    ALPC_MSGFLG_REPLY_MESSAGE = 0x1,
    ALPC_MSGFLG_LPC_MODE = 0x2,
    ALPC_MSGFLG_RELEASE_MESSAGE = 0x10000,
    ALPC_MSGFLG_SYNC_REQUEST = 0x20000,
    ALPC_MSGFLG_TRACK_PORT_REFERENCES = 0x40000,
    ALPC_MSGFLG_WAIT_USER_MODE = 0x100000,
    ALPC_MSGFLG_WAIT_ALERTABLE = 0x200000,
    ALPC_MSGFLG_WOW64_CALL = 0x80000000,
};

enum ALPC_CANCEL_FLAGS
{
    ALPC_CANCELFLG_TRY_CANCEL = 0x1,
    ALPC_CANCELFLG_NO_CONTEXT_CHECK = 0x8,
    ALPC_CANCELFLGP_FLUSH = 0x10000,
};

enum ALPC_IMPERSONATE_FLAGS
{
    ALPC_IMPERSONATEFLG_ANONYMOUS = 0x1,
    ALPC_IMPERSONATEFLG_REQUIRE_IMPERSONATE = 0x2,
};

enum ALPC_HEADER_SIZE_FLAGS
{
    ALPC_ATTRFLG_ALLOCATEDATTR = 0x20000000,
    ALPC_ATTRFLG_VALIDATTR = 0x40000000,
    ALPC_ATTRFLG_KEEPRUNNINGATTR = 0x60000000,
};

#pragma endregion ntlpcapi.h

#pragma region ntpfapi.h

enum PF_VERSIOSN
{
    PF_BOOT_CONTROL_VERSION = 1,
    PF_SCENARIO_PHASE_INFO_VERSION = 4,
    PF_ROBUSTNESS_CONTROL_VERSION = 1,
    PF_MEMORY_LIST_INFO_VERSION = 1,
    PF_PHYSICAL_MEMORY_RANGE_INFO_V1_VERSION = 1,
    PF_PHYSICAL_MEMORY_RANGE_INFO_V2_VERSION = 2,
    PF_REPURPOSED_BY_PREFETCH_INFO_VERSION = 1,
    PF_VIRTUAL_QUERY_VERSION = 1,
    PF_MIN_WS_AGE_RATE_CONTROL_VERSION = 1,
    PF_DEPRIORITIZE_OLD_PAGES_VERSION = 3,
    PF_GPU_UTILIZATION_INFO_VERSION = 1,
};

enum PREFETCHER_INFORMATIONS
{
    PREFETCHER_INFORMATION_VERSION = 23, // r
    PREFETCHER_INFORMATION_MAGIC = ('kuhC'),
};

enum PF_PFN_PRIO_REQUEST_FLAGS
{
    PF_PFN_PRIO_REQUEST_VERSION = 1,
    PF_PFN_PRIO_REQUEST_QUERY_MEMORY_LIST = 0x1,
    PF_PFN_PRIO_REQUEST_VALID_FLAGS = 0x1,
};

enum PF_PRIVSOURCE_QUERY_REQUEST_FLAGS
{
    PF_PRIVSOURCE_QUERY_REQUEST_VERSION = 8,
    PF_PRIVSOURCE_QUERY_REQUEST_FLAGS_QUERYWSPAGES = 0x1,
    PF_PRIVSOURCE_QUERY_REQUEST_FLAGS_QUERYCOMPRESSEDPAGES = 0x2,
    PF_PRIVSOURCE_QUERY_REQUEST_FLAGS_QUERYSKIPPAGES = 0x4,
};

enum SUPERFETCH_INFORMATIONS
{
    SUPERFETCH_INFORMATION_VERSION = 45, // rev
    SUPERFETCH_INFORMATION_MAGIC = ('kuhC'), // rev
};

#pragma endregion ntpfapi.h

#pragma region ntpoapi.h

// noname
enum NTPOAPI_H
{
    POWER_PERF_SCALE = 100,
    POWER_STATE_DISABLED_TYPE_MAX = 8,
    POWER_REQUEST_CONTEXT_NOT_SPECIFIED = DIAGNOSTIC_REASON_NOT_SPECIFIED,
    POWER_INTERNAL_PROCESSOR_BRANDED_FREQUENCY_VERSION = 1,
};

enum PO_REASON_STATES
{
#ifndef PO_REASON_STATE_S1
    // HTC: in km\ntpoaapi.h
    PO_REASON_STATE_S1 = 0x00000001,
    PO_REASON_STATE_S2 = 0x00000002,
    PO_REASON_STATE_S3 = 0x00000004,
    PO_REASON_STATE_S4 = 0x00000008,
    PO_REASON_STATE_S4FIRM = 0x00000010,
    PO_REASON_STATE_S0IDLE = 0x00000020,
    PO_REASON_STATE_STANDBY = (PO_REASON_STATE_S1 | PO_REASON_STATE_S2 | PO_REASON_STATE_S3),
    PO_REASON_STATE_ALL = (PO_REASON_STATE_STANDBY | PO_REASON_STATE_S4 | PO_REASON_STATE_S4FIRM),
#endif
};

enum PROCESSOR_STATE_TYPES
{
    PROCESSOR_STATE_TYPE_PERFORMANCE = 0x1,
    PROCESSOR_STATE_TYPE_THROTTLE = 0x2,
};

enum PROCESSOR_IDLE_STATE_FLAGS
{
    IDLE_STATE_FLAGS_C1_HLT = 0x01,
    IDLE_STATE_FLAGS_C1_IO_HLT = 0x02,
    IDLE_STATE_FLAGS_IO = 0x04,
    IDLE_STATE_FLAGS_MWAIT = 0x08,
};

enum POWER_REQUEST_SUPPORTED_TYPES
{
    POWER_REQUEST_SUPPORTED_TYPES_V1 = 3,
    POWER_REQUEST_SUPPORTED_TYPES_V2 = 9,
    POWER_REQUEST_SUPPORTED_TYPES_V3 = 5,
    POWER_REQUEST_SUPPORTED_TYPES_V4 = 6,
};

#pragma endregion ntpoapi.h

#pragma region ntregapi.h

// noname
enum NTREGAPI_H
{
    CM_EXTENDED_PARAMETER_TYPE_BITS = 8,
};

enum REG_INIT_BOOT_FLAGS
{
    REG_INIT_BOOT_SM = 0x0000,
    REG_INIT_BOOT_SETUP = 0x0001,
    REG_INIT_BOOT_ACCEPTED_BASE = 0x0002,
    REG_INIT_BOOT_ACCEPTED_MAX = REG_INIT_BOOT_ACCEPTED_BASE + 999,
};

enum REG_MAX_KEY_LENGTH
{
    REG_MAX_KEY_VALUE_NAME_LENGTH = 32767,
    REG_MAX_KEY_NAME_LENGTH = 512,
};

enum REG_KEY_FLAGS
{
    REG_FLAG_VOLATILE = 0x0001,
    REG_FLAG_LINK = 0x0002,
    REG_KEY_DONT_VIRTUALIZE = 0x0002,
    REG_KEY_DONT_SILENT_FAIL = 0x0004,
    REG_KEY_RECURSE_FLAG = 0x0008,
};

enum IOCTL_VR
{
    IOCTL_VR_INITIALIZE_JOB_FOR_VREG = CTL_CODE(FILE_DEVICE_UNKNOWN, 1, METHOD_BUFFERED, FILE_ANY_ACCESS),
    IOCTL_VR_LOAD_DIFFERENCING_HIVE = CTL_CODE(FILE_DEVICE_UNKNOWN, 2, METHOD_BUFFERED, FILE_ANY_ACCESS),
    IOCTL_VR_CREATE_NAMESPACE_NODE = CTL_CODE(FILE_DEVICE_UNKNOWN, 3, METHOD_BUFFERED, FILE_ANY_ACCESS),
    IOCTL_VR_MODIFY_FLAGS = CTL_CODE(FILE_DEVICE_UNKNOWN, 4, METHOD_BUFFERED, FILE_ANY_ACCESS),
    IOCTL_VR_CREATE_MULTIPLE_NAMESPACE_NODES = CTL_CODE(FILE_DEVICE_UNKNOWN, 5, METHOD_BUFFERED, FILE_ANY_ACCESS),
    IOCTL_VR_UNLOAD_DYNAMICALLY_LOADED_HIVES = CTL_CODE(FILE_DEVICE_UNKNOWN, 6, METHOD_BUFFERED, FILE_ANY_ACCESS),
    IOCTL_VR_GET_VIRTUAL_ROOT_KEY = CTL_CODE(FILE_DEVICE_UNKNOWN, 7, METHOD_BUFFERED, FILE_ANY_ACCESS),
    IOCTL_VR_LOAD_DIFFERENCING_HIVE_FOR_HOST = CTL_CODE(FILE_DEVICE_UNKNOWN, 8, METHOD_BUFFERED, FILE_ANY_ACCESS),
    IOCTL_VR_UNLOAD_DIFFERENCING_HIVE_FOR_HOST = CTL_CODE(FILE_DEVICE_UNKNOWN, 9, METHOD_BUFFERED, FILE_ANY_ACCESS),
};

enum VR_FLAGS
{
    VR_FLAG_INHERIT_TRUST_CLASS = 0x00000001,
    VR_FLAG_WRITE_THROUGH_HIVE = 0x00000002, // since REDSTONE2
    VR_FLAG_LOCAL_MACHINE_TRUST_CLASS = 0x00000004, // since 21H1
};

enum VR_KEYS
{
    VR_KEY_COMROOT = 0,
    VR_KEY_MACHINE_SOFTWARE = 1,
    VR_KEY_CONTROL_SET = 2,
};

#pragma endregion ntregapi.h

#pragma region ntrtl.h

// noname
enum NTRTL_H
{
    RTL_MEG = (1024UL * 1024UL),
    RTL_IMAGE_MAX_DOS_HEADER = (256UL * RTL_MEG),
    RTL_RESOURCE_FLAG_LONG_TERM = 0x00000001,
    RTL_MAX_DRIVE_LETTERS = 32,
    RTL_DRIVE_LETTER_VALID = 0x0001,
    RTL_USER_PROCESS_EXTENDED_PARAMETERS_VERSION = 1,
    RTL_ACTIVATE_ACTIVATION_CONTEXT_EX_FLAG_RELEASE_ON_STACK_DEALLOCATION = 0x00000001,
    RTL_DEACTIVATE_ACTIVATION_CONTEXT_FLAG_FORCE_EARLY_DEACTIVATION = 0x00000001,
    RTL_IMAGE_NT_HEADER_EX_FLAG_NO_RANGE_CHECK = 0x00000001,
    RTL_SEGHEAP_MEM_SOURCE_ANY_NODE = ((ULONG)-1),
    RTL_IMPORT_TABLE_HASH_REVISION = 1,
    RTL_HANDLE_ALLOCATED = 0x0001,
    MAX_UNICODE_STACK_BUFFER_LENGTH = 256,
    BOUNDARY_DESCRIPTOR_ADD_APPCONTAINER_SID = 0x0001,

    RTL_WAITER_DEREGISTER_WAIT_FOR_COMPLETION = ((LONG_PTR)-1),
    RTL_TIMER_DELETE_WAIT_FOR_COMPLETION = ((LONG_PTR)-1),

    RTL_UNLOAD_EVENT_TRACE_NUMBER = 64,

    WNF_STATE_KEY = 0x41C64E6DA3BC0074,

    COPY_FILE_CHUNK_DUPLICATE_EXTENTS = 0x00000001L, // 24H2
    VALID_COPY_FILE_CHUNK_FLAGS = COPY_FILE_CHUNK_DUPLICATE_EXTENTS,
};

enum RTL_HASH_FLAGS
{
    RTL_HASH_ALLOCATED_HEADER = 0x00000001,
    RTL_HASH_RESERVED_SIGNATURE = 0,
};

enum RTL_BARRIER_FLAGS
{
    RTL_BARRIER_FLAGS_SPIN_ONLY = 0x00000001,
    RTL_BARRIER_FLAGS_BLOCK_ONLY = 0x00000002,
    RTL_BARRIER_FLAGS_NO_DELETE = 0x00000004,
};

enum RTL_DUPLICATE_UNICODE_FLAGS
{
    RTL_DUPLICATE_UNICODE_STRING_NULL_TERMINATE = 0x00000001,
    RTL_DUPLICATE_UNICODE_STRING_ALLOCATE_NULL_STRING = 0x00000002,
};

enum HASH_STRING_ALGORITHMS
{
    HASH_STRING_ALGORITHM_DEFAULT = 0,
    HASH_STRING_ALGORITHM_X65599 = 1,
    HASH_STRING_ALGORITHM_INVALID = 0xffffffff,
};

enum RTL_FIND_CHAR_IN_UNICODE_STRING_FLAGS
{
    RTL_FIND_CHAR_IN_UNICODE_STRING_START_AT_END = 0x00000001,
    RTL_FIND_CHAR_IN_UNICODE_STRING_COMPLEMENT_CHAR_SET = 0x00000002,
    RTL_FIND_CHAR_IN_UNICODE_STRING_CASE_INSENSITIVE = 0x00000004,
};

enum COMPRESSION_FORMATS
{
    _COMPRESSION_FORMAT_NONE = 0x0000,
    _COMPRESSION_FORMAT_DEFAULT = 0x0001,
    _COMPRESSION_FORMAT_LZNT1 = 0x0002,
    _COMPRESSION_FORMAT_XPRESS = 0x0003,
    _COMPRESSION_FORMAT_XPRESS_HUFF = 0x0004,
    _COMPRESSION_FORMAT_XP10 = 0x0005,
    _COMPRESSION_FORMAT_LZ4 = 0x0006,
    _COMPRESSION_FORMAT_DEFLATE = 0x0007,
    _COMPRESSION_FORMAT_ZLIB = 0x0008,
    _COMPRESSION_FORMAT_MAX = 0x0008,
    _COMPRESSION_FORMAT_MASK = 0x00FF,
};

enum COMPRESSION_ENGINES
{
    _COMPRESSION_ENGINE_STANDARD = 0x0000,
    _COMPRESSION_ENGINE_MAXIMUM = 0x0100,
    _COMPRESSION_ENGINE_HIBER = 0x0200,
    _COMPRESSION_ENGINE_MAX = 0x0200,
    _COMPRESSION_ENGINE_MASK = 0xFF00,
    _COMPRESSION_FORMAT_ENGINE_MASK = _COMPRESSION_FORMAT_MASK | _COMPRESSION_ENGINE_MASK,
};

enum RTL_DRIVE_LETTER_CURDIR_FLAGS
{
    RTL_USER_PROC_CURDIR_CLOSE = 0x00000002,
    RTL_USER_PROC_CURDIR_INHERIT = 0x00000003,
};

enum RTL_USER_PROCESS_PARAMETERS_FLAGS
{
    RTL_USER_PROC_PARAMS_NORMALIZED = 0x00000001,
    RTL_USER_PROC_PROFILE_USER = 0x00000002,
    RTL_USER_PROC_PROFILE_KERNEL = 0x00000004,
    RTL_USER_PROC_PROFILE_SERVER = 0x00000008,
    RTL_USER_PROC_RESERVE_1MB = 0x00000020,
    RTL_USER_PROC_RESERVE_16MB = 0x00000040,
    RTL_USER_PROC_CASE_SENSITIVE = 0x00000080,
    RTL_USER_PROC_DISABLE_HEAP_DECOMMIT = 0x00000100,
    RTL_USER_PROC_DLL_REDIRECTION_LOCAL = 0x00001000,
    RTL_USER_PROC_APP_MANIFEST_PRESENT = 0x00002000,
    RTL_USER_PROC_IMAGE_KEY_MISSING = 0x00004000,
    RTL_USER_PROC_OPTIN_PROCESS = 0x00020000,
    RTL_USER_PROC_SESSION_OWNER = 0x00040000,
    RTL_USER_PROC_HANDLE_USER_CALLBACK_EXCEPTIONS = 0x00080000,
    RTL_USER_PROC_PROTECTED_PROCESS = 0x00400000,
    RTL_USER_PROC_SECURE_PROCESS = 0x80000000,
};

enum RTL_CLONE_PROCESS_FLAGS
{
    RTL_CLONE_PROCESS_FLAGS_CREATE_SUSPENDED = 0x00000001,
    RTL_CLONE_PROCESS_FLAGS_INHERIT_HANDLES = 0x00000002,
    RTL_CLONE_PROCESS_FLAGS_NO_SYNCHRONIZE = 0x00000004,
};

enum RTL_PROCESS_REFLECTION_FLAGS
{
    RTL_PROCESS_REFLECTION_FLAGS_INHERIT_HANDLES = 0x2,
    RTL_PROCESS_REFLECTION_FLAGS_NO_SUSPEND = 0x4,
    RTL_PROCESS_REFLECTION_FLAGS_NO_SYNCHRONIZE = 0x8,
    RTL_PROCESS_REFLECTION_FLAGS_NO_CLOSE_EVENT = 0x10,
};

enum ACTIVATION_CONTEXTS
{
    INVALID_ACTIVATION_CONTEXT = (LONG_PTR)-1,
    ACTCTX_PROCESS_DEFAULT = (LONG_PTR)0,
    ACTCTX_EMPTY = (LONG_PTR)-3,
    ACTCTX_SYSTEM_DEFAULT = (LONG_PTR)-4,
};

enum FIND_ACTIVATION_CONTEXT_SECTION_FLAGS
{
    FIND_ACTIVATION_CONTEXT_SECTION_KEY_RETURN_ACTIVATION_CONTEXT = 0x00000001,
    FIND_ACTIVATION_CONTEXT_SECTION_KEY_RETURN_FLAGS = 0x00000002,
    FIND_ACTIVATION_CONTEXT_SECTION_KEY_RETURN_ASSEMBLY_METADATA = 0x00000004,
};

enum RTL_QUERY_INFORMATION_ACTIVATION_CONTEXT_FLAGS
{
    RTL_QUERY_INFORMATION_ACTIVATION_CONTEXT_FLAG_USE_ACTIVE_ACTIVATION_CONTEXT = 0x00000001,
    RTL_QUERY_INFORMATION_ACTIVATION_CONTEXT_FLAG_ACTIVATION_CONTEXT_IS_MODULE = 0x00000002,
    RTL_QUERY_INFORMATION_ACTIVATION_CONTEXT_FLAG_ACTIVATION_CONTEXT_IS_ADDRESS = 0x00000004,
    RTL_QUERY_INFORMATION_ACTIVATION_CONTEXT_FLAG_NO_ADDREF = 0x80000000,
};

enum RTL_CREATE_ENVIRONMENT_FLAGS
{
    RTL_CREATE_ENVIRONMENT_TRANSLATE = 0x1,
    RTL_CREATE_ENVIRONMENT_TRANSLATE_FROM_OEM = 0x2,
    RTL_CREATE_ENVIRONMENT_EMPTY = 0x4,
};

enum RTL_DOS_SEARCH_PATH_FLAGS
{
    RTL_DOS_SEARCH_PATH_FLAG_APPLY_ISOLATION_REDIRECTION = 0x00000001,
    RTL_DOS_SEARCH_PATH_FLAG_DISALLOW_DOT_RELATIVE_PATH_SEARCH = 0x00000002,
    RTL_DOS_SEARCH_PATH_FLAG_APPLY_DEFAULT_EXTENSION_WHEN_NOT_RELATIVE_PATH_EVEN_IF_FILE_HAS_EXTENSION = 0x00000004,
};

enum IMAGE_FILE_NATIVE_MACHINES
{
    IMAGE_FILE_NATIVE_MACHINE_I386 = 0x1,
    IMAGE_FILE_NATIVE_MACHINE_AMD64 = 0x2,
    IMAGE_FILE_NATIVE_MACHINE_ARMNT = 0x4,
    IMAGE_FILE_NATIVE_MACHINE_ARM64 = 0x8,
};

enum RTL_HEAP_FLAGS
{
    RTL_HEAP_BUSY = 0x0001,
    RTL_HEAP_SEGMENT = 0x0002,
    RTL_HEAP_SETTABLE_VALUE = 0x0010,
    RTL_HEAP_SETTABLE_FLAG1 = 0x0020,
    RTL_HEAP_SETTABLE_FLAG2 = 0x0040,
    RTL_HEAP_SETTABLE_FLAG3 = 0x0080,
    RTL_HEAP_SETTABLE_FLAGS = 0x00e0,
    RTL_HEAP_UNCOMMITTED_RANGE = 0x1000,
    RTL_HEAP_PROTECTED_ENTRY = 0x2000,
    RTL_HEAP_LARGE_ALLOC = 0x4000,
    RTL_HEAP_LFH_ALLOC = 0x8000,
};

enum RTL_HEAP_SIGNATURES
{
    RTL_HEAP_SIGNATURE = 0xFFEEFFEEUL,
    RTL_HEAP_SEGMENT_SIGNATURE = 0xDDEEDDEEUL,
};

enum RTL_SEGMENT_HEAP_FLAGS
{
    SEGMENT_HEAP_PARAMETERS_VERSION = 3,
    SEGMENT_HEAP_FLG_USE_PAGE_HEAP = 0x1,
    SEGMENT_HEAP_FLG_NO_LFH = 0x2,
    SEGMENT_HEAP_PARAMS_VALID_FLAGS = 0x3,
};

enum RTL_CREATE_HEAP_FLAGS
{
    HEAP_SETTABLE_USER_VALUE = 0x00000100,
    HEAP_SETTABLE_USER_FLAG1 = 0x00000200,
    HEAP_SETTABLE_USER_FLAG2 = 0x00000400,
    HEAP_SETTABLE_USER_FLAG3 = 0x00000800,
    HEAP_SETTABLE_USER_FLAGS = 0x00000e00,

    HEAP_CLASS_0 = 0x00000000, // Process heap
    HEAP_CLASS_1 = 0x00001000, // Private heap
    HEAP_CLASS_2 = 0x00002000, // Kernel heap
    HEAP_CLASS_3 = 0x00003000, // GDI heap
    HEAP_CLASS_4 = 0x00004000, // User heap
    HEAP_CLASS_5 = 0x00005000, // Console heap
    HEAP_CLASS_6 = 0x00006000, // User desktop heap
    HEAP_CLASS_7 = 0x00007000, // CSR shared heap
    HEAP_CLASS_8 = 0x00008000, // CSR port heap
    HEAP_CLASS_MASK = 0x0000f000,

    _HEAP_MAXIMUM_TAG = 0x0FFF,
    HEAP_GLOBAL_TAG = 0x0800,
    _HEAP_PSEUDO_TAG_FLAG = 0x8000,
    _HEAP_TAG_SHIFT = 18,
    HEAP_TAG_MASK = (_HEAP_MAXIMUM_TAG << _HEAP_TAG_SHIFT),

    _HEAP_CREATE_SEGMENT_HEAP = 0x00000100,
    _HEAP_CREATE_HARDENED = 0x00000200,
};

enum RTL_HEAP_USAGE_FLAGS
{
    HEAP_USAGE_ALLOCATED_BLOCKS = HEAP_REALLOC_IN_PLACE_ONLY,
    HEAP_USAGE_FREE_BUFFER = HEAP_ZERO_MEMORY,
};

enum HEAP_INFORMATION_CLASS_FLAGS
{
    _HeapCompatibilityInformation = 0x0,
    _HeapEnableTerminationOnCorruption = 0x1,
    _HeapExtendedInformation = 0x2,
    _HeapOptimizeResources = 0x3,
    _HeapTaggingInformation = 0x4,
    _HeapStackDatabase = 0x5,
    _HeapMemoryLimit = 0x6,
    _HeapTag = 0x7,
    _HeapDetailedFailureInformation = 0x80000001,
    _HeapSetDebuggingInformation = 0x80000002,
};

enum HEAP_PERFORMANCE_COUNTERS_INFORMATION_VERSIONS
{
    HeapPerformanceCountersInformationStandardHeapVersion = 0x1,
    HeapPerformanceCountersInformationSegmentHeapVersion = 0x2,
};

enum HEAP_EXTENDED_INFORMATION_LEVELS
{
    HeapExtendedProcessHeapInformationLevel = 0x1,
    HeapExtendedHeapInformationLevel = 0x2,
    HeapExtendedHeapRegionInformationLevel = 0x3,
    HeapExtendedHeapRangeInformationLevel = 0x4,
    HeapExtendedHeapBlockInformationLevel = 0x5,
    HeapExtendedHeapHeapPerfInformationLevel = 0x80000000,
};

enum HEAP_STACK_VERSIONS_FLAGS
{
    HEAP_STACK_QUERY_VERSION = 0x2,
    HEAP_STACK_CONTROL_VERSION = 0x1,
    HEAP_STACK_CONTROL_FLAGS_STACKTRACE_ENABLE = 0x1,
    HEAP_STACK_CONTROL_FLAGS_STACKTRACE_DISABLE = 0x2,
};

enum RTL_QUERY_PROCESS_INFORMATION_FLAGS
{
    RTL_QUERY_PROCESS_MODULES = 0x00000001,
    RTL_QUERY_PROCESS_BACKTRACES = 0x00000002,
    RTL_QUERY_PROCESS_HEAP_SUMMARY = 0x00000004,
    RTL_QUERY_PROCESS_HEAP_TAGS = 0x00000008,
    RTL_QUERY_PROCESS_HEAP_ENTRIES = 0x00000010,
    RTL_QUERY_PROCESS_LOCKS = 0x00000020,
    RTL_QUERY_PROCESS_MODULES32 = 0x00000040,
    RTL_QUERY_PROCESS_VERIFIER_OPTIONS = 0x00000080,
    RTL_QUERY_PROCESS_MODULESEX = 0x00000100,
    RTL_QUERY_PROCESS_HEAP_SEGMENTS = 0x00000200,
    RTL_QUERY_PROCESS_CS_OWNER = 0x00000400,
    RTL_QUERY_PROCESS_NONINVASIVE = 0x80000000,
    RTL_QUERY_PROCESS_NONINVASIVE_CS_OWNER = 0x80000800,
};

enum RTL_ERRORMODES
{
    RTL_ERRORMODE_FAILCRITICALERRORS = 0x0010,
    RTL_ERRORMODE_NOGPFAULTERRORBOX = 0x0020,
    RTL_ERRORMODE_NOOPENFILEERRORBOX = 0x0040,
};

enum SecondsToStartOf
{
    SecondsToStartOf1980 = 11960006400,
    SecondsToStartOf1970 = 11644473600,
};

enum RTL_ACQUIRE_PRIVILEGE_FLAGS
{
    RTL_ACQUIRE_PRIVILEGE_REVERT = 0x00000001,
    RTL_ACQUIRE_PRIVILEGE_PROCESS = 0x00000002,
};

enum RTL_CREATE_REGISTRY_RELATIVE_TO
{
    RTL_REGISTRY_ABSOLUTE = 0,
    RTL_REGISTRY_SERVICES = 1,
    RTL_REGISTRY_CONTROL = 2,
    RTL_REGISTRY_WINDOWS_NT = 3,
    RTL_REGISTRY_DEVICEMAP = 4,
    RTL_REGISTRY_USER = 5,
    RTL_REGISTRY_MAXIMUM = 6,
    RTL_REGISTRY_HANDLE = 0x40000000,
    RTL_REGISTRY_OPTIONAL = 0x80000000,
};

enum RTL_QUERY_REGISTRY_RELATIVE_TO
{
    RTL_QUERY_REGISTRY_SUBKEY = 0x00000001,
    RTL_QUERY_REGISTRY_TOPKEY = 0x00000002,
    RTL_QUERY_REGISTRY_REQUIRED = 0x00000004,
    RTL_QUERY_REGISTRY_NOVALUE = 0x00000008,
    RTL_QUERY_REGISTRY_NOEXPAND = 0x00000010,
    RTL_QUERY_REGISTRY_DIRECT = 0x00000020,
    RTL_QUERY_REGISTRY_DELETE = 0x00000040,
};

enum RTL_WALK_FLAGS
{
    RTL_WALK_USER_MODE_STACK = 0x00000001,
    RTL_WALK_VALID_FLAGS = 0x00000001,
    RTL_STACK_WALKING_MODE_FRAMES_TO_SKIP_SHIFT = 0x00000008,
};

enum ELEVATION_FLAGS
{
    ELEVATION_FLAG_TOKEN_CHECKS = 0x00000001,
    ELEVATION_FLAG_VIRTUALIZATION = 0x00000002,
    ELEVATION_FLAG_SHORTCUT_REDIR = 0x00000004,
    ELEVATION_FLAG_NO_SIGNATURE_CHECK = 0x00000008,
};

enum RTL_IMAGE_MITIGATION_OPTIONS
{
    RTL_IMAGE_MITIGATION_OPTION_STATEMASK = 3UL,
    RTL_IMAGE_MITIGATION_OPTION_FORCEMASK = 4UL,
    RTL_IMAGE_MITIGATION_OPTION_OPTIONMASK = 8UL,
};

enum RTL_IMAGE_MITIGATION_FLAGS
{
    RTL_IMAGE_MITIGATION_FLAG_RESET = 0x1,
    RTL_IMAGE_MITIGATION_FLAG_REMOVE = 0x2,
    RTL_IMAGE_MITIGATION_FLAG_OSDEFAULT = 0x4,
    RTL_IMAGE_MITIGATION_FLAG_AUDIT = 0x8,
};

enum PHCM
{
    PHCM_APPLICATION_DEFAULT = ((CHAR)0),
    PHCM_DISGUISE_PLACEHOLDERS = ((CHAR)1),
    PHCM_EXPOSE_PLACEHOLDERS = ((CHAR)2),
    PHCM_DISGUISE_FULL_PLACEHOLDERS = ((CHAR)3),
    PHCM_MAX = ((CHAR)3),
    PHCM_ERROR_INVALID_PARAMETER = ((CHAR)-1),
    PHCM_ERROR_NO_TEB = ((CHAR)-2),
    PHCM_ERROR_NO_PEB = ((CHAR)-3),
};

enum PSM_ACTIVATION_TOKEN_FLAGS
{
    PSM_ACTIVATION_TOKEN_PACKAGED_APPLICATION = 0x1,
    PSM_ACTIVATION_TOKEN_SHARED_ENTITY = 0x2,
    PSM_ACTIVATION_TOKEN_FULL_TRUST = 0x4,
    PSM_ACTIVATION_TOKEN_NATIVE_SERVICE = 0x8,
    PSM_ACTIVATION_TOKEN_DEVELOPMENT_APP = 0x10,
    PSM_ACTIVATION_TOKEN_BREAKAWAY_INHIBITED = 0x20,
    PSM_ACTIVATION_TOKEN_RUNTIME_BROKER = 0x40,
    PSM_ACTIVATION_TOKEN_UNIVERSAL_CONSOLE = 0x200,
    PSM_ACTIVATION_TOKEN_WIN32ALACARTE_PROCESS = 0x10000,
};

enum PSMP_SYSAPP_VALUES
{
    PSMP_MINIMUM_SYSAPP_CLAIM_VALUES = 2,
    PSMP_MAXIMUM_SYSAPP_CLAIM_VALUES = 4,
};

enum RTL_RUN_ONCE_FLAGS
{
    _RTL_RUN_ONCE_INIT = 0,
    _RTL_RUN_ONCE_CHECK_ONLY = 0x00000001UL,
    _RTL_RUN_ONCE_ASYNC = 0x00000002UL,
    _RTL_RUN_ONCE_INIT_FAILED = 0x00000004UL,
    _RTL_RUN_ONCE_CTX_RESERVED_BITS = 2,
};

#pragma endregion ntrtl.h

#pragma region ntimage.h

enum IMAGE_FILE_MACHINES
{
    // not included in winnt.h
    IMAGE_FILE_MACHINE_CHPE_X86 = 0x3A64,
    IMAGE_FILE_MACHINE_ARM64EC = 0xA641,
    IMAGE_FILE_MACHINE_ARM64X = 0xA64E,
};

enum IMAGE_DEBUG_POGO_SIGNATURES
{
    IMAGE_DEBUG_POGO_SIGNATURE_LTCG = 'LTCG',
    IMAGE_DEBUG_POGO_SIGNATURE_PGU = 'PGU\0',
};

enum IMAGE_ARM64EC_CODE_MAP_TYPES
{
    IMAGE_ARM64EC_CODE_MAP_TYPE_ARM64 = 0,
    IMAGE_ARM64EC_CODE_MAP_TYPE_ARM64EC = 1,
    IMAGE_ARM64EC_CODE_MAP_TYPE_AMD64 = 2,
};

enum IMAGE_DVRT_ARM64X_FIXUP_TYPES
{
    IMAGE_DVRT_ARM64X_FIXUP_TYPE_ZEROFILL = 0,
    IMAGE_DVRT_ARM64X_FIXUP_TYPE_VALUE = 1,
    IMAGE_DVRT_ARM64X_FIXUP_TYPE_DELTA = 2,
};

enum IMAGE_DVRT_ARM64X_FIXUP_SIZES
{
    IMAGE_DVRT_ARM64X_FIXUP_SIZE_2BYTES = 1,
    IMAGE_DVRT_ARM64X_FIXUP_SIZE_4BYTES = 2,
    IMAGE_DVRT_ARM64X_FIXUP_SIZE_8BYTES = 3,
};

enum IMAGE_DYNAMIC_RELOCATION_ENTRIES
{
    _IMAGE_DYNAMIC_RELOCATION_GUARD_RF_PROLOGUE = 0x00000001,
    _IMAGE_DYNAMIC_RELOCATION_GUARD_RF_EPILOGUE = 0x00000002,
    _IMAGE_DYNAMIC_RELOCATION_GUARD_IMPORT_CONTROL_TRANSFER = 0x00000003,
    _IMAGE_DYNAMIC_RELOCATION_GUARD_INDIR_CONTROL_TRANSFER = 0x00000004,
    _IMAGE_DYNAMIC_RELOCATION_GUARD_SWITCHTABLE_BRANCH = 0x00000005,
    _IMAGE_DYNAMIC_RELOCATION_FUNCTION_OVERRIDE = 0x00000007,
    _IMAGE_DYNAMIC_RELOCATION_ARM64X = 0x00000006,
    _IMAGE_DYNAMIC_RELOCATION_MM_SHARED_USER_DATA_VA = 0x7FFE0000,
    _IMAGE_DYNAMIC_RELOCATION_KI_USER_SHARED_DATA64 = 0xFFFFF78000000000UI64,
};

enum IMAGE_FUNCTION_OVERRIDE_TYPES
{
    _IMAGE_FUNCTION_OVERRIDE_INVALID = 0,
    _IMAGE_FUNCTION_OVERRIDE_X64_REL32 = 1,
    _IMAGE_FUNCTION_OVERRIDE_ARM64_BRANCH26 = 2,
    _IMAGE_FUNCTION_OVERRIDE_ARM64_THUNK = 3,
};

enum IMAGE_DLLCHARACTERISTICS_EX
{
    IMAGE_DLLCHARACTERISTICS_EX_FORWARD_CFI_COMPAT = 0x40,
    IMAGE_DLLCHARACTERISTICS_EX_HOTPATCH_COMPATIBLE = 0x80,
};

#pragma endregion ntimage.h

#pragma region ntseapi.h

enum SE_PRIVILEGES
{
    SE_MIN_WELL_KNOWN_PRIVILEGE = (2L),
    SE_CREATE_TOKEN_PRIVILEGE = (2L),
    SE_ASSIGNPRIMARYTOKEN_PRIVILEGE = (3L),
    SE_LOCK_MEMORY_PRIVILEGE = (4L),
    SE_INCREASE_QUOTA_PRIVILEGE = (5L),
    SE_MACHINE_ACCOUNT_PRIVILEGE = (6L),
    SE_TCB_PRIVILEGE = (7L),
    SE_SECURITY_PRIVILEGE = (8L),
    SE_TAKE_OWNERSHIP_PRIVILEGE = (9L),
    SE_LOAD_DRIVER_PRIVILEGE = (10L),
    SE_SYSTEM_PROFILE_PRIVILEGE = (11L),
    SE_SYSTEMTIME_PRIVILEGE = (12L),
    SE_PROF_SINGLE_PROCESS_PRIVILEGE = (13L),
    SE_INC_BASE_PRIORITY_PRIVILEGE = (14L),
    SE_CREATE_PAGEFILE_PRIVILEGE = (15L),
    SE_CREATE_PERMANENT_PRIVILEGE = (16L),
    SE_BACKUP_PRIVILEGE = (17L),
    SE_RESTORE_PRIVILEGE = (18L),
    SE_SHUTDOWN_PRIVILEGE = (19L),
    SE_DEBUG_PRIVILEGE = (20L),
    SE_AUDIT_PRIVILEGE = (21L),
    SE_SYSTEM_ENVIRONMENT_PRIVILEGE = (22L),
    SE_CHANGE_NOTIFY_PRIVILEGE = (23L),
    SE_REMOTE_SHUTDOWN_PRIVILEGE = (24L),
    SE_UNDOCK_PRIVILEGE = (25L),
    SE_SYNC_AGENT_PRIVILEGE = (26L),
    SE_ENABLE_DELEGATION_PRIVILEGE = (27L),
    SE_MANAGE_VOLUME_PRIVILEGE = (28L),
    SE_IMPERSONATE_PRIVILEGE = (29L),
    SE_CREATE_GLOBAL_PRIVILEGE = (30L),
    SE_TRUSTED_CREDMAN_ACCESS_PRIVILEGE = (31L),
    SE_RELABEL_PRIVILEGE = (32L),
    SE_INC_WORKING_SET_PRIVILEGE = (33L),
    SE_TIME_ZONE_PRIVILEGE = (34L),
    SE_CREATE_SYMBOLIC_LINK_PRIVILEGE = (35L),
    SE_DELEGATE_SESSION_USER_IMPERSONATE_PRIVILEGE = (36L),
    SE_MAX_WELL_KNOWN_PRIVILEGE = SE_DELEGATE_SESSION_USER_IMPERSONATE_PRIVILEGE,
};

enum TOKEN_SECURITY_ATTRIBUTE_TYPES
{
    TOKEN_SECURITY_ATTRIBUTE_TYPE_INVALID = 0x00,
    TOKEN_SECURITY_ATTRIBUTE_TYPE_INT64 = 0x01,
    TOKEN_SECURITY_ATTRIBUTE_TYPE_UINT64 = 0x02,
    TOKEN_SECURITY_ATTRIBUTE_TYPE_STRING = 0x03,
    TOKEN_SECURITY_ATTRIBUTE_TYPE_FQBN = 0x04,
    TOKEN_SECURITY_ATTRIBUTE_TYPE_SID = 0x05,
    TOKEN_SECURITY_ATTRIBUTE_TYPE_BOOLEAN = 0x06,
    TOKEN_SECURITY_ATTRIBUTE_TYPE_OCTET_STRING = 0x10,
};

enum TOKEN_SECURITY_ATTRIBUTE_FLAGS
{
    TOKEN_SECURITY_ATTRIBUTE_NON_INHERITABLE = 0x0001,
    TOKEN_SECURITY_ATTRIBUTE_VALUE_CASE_SENSITIVE = 0x0002,
    TOKEN_SECURITY_ATTRIBUTE_USE_FOR_DENY_ONLY = 0x0004,
    TOKEN_SECURITY_ATTRIBUTE_DISABLED_BY_DEFAULT = 0x0008,
    TOKEN_SECURITY_ATTRIBUTE_DISABLED = 0x0010,
    TOKEN_SECURITY_ATTRIBUTE_MANDATORY = 0x0020,
    TOKEN_SECURITY_ATTRIBUTE_COMPARE_IGNORE = 0x0040,
    TOKEN_SECURITY_ATTRIBUTE_VALID_FLAGS = (\
        TOKEN_SECURITY_ATTRIBUTE_NON_INHERITABLE | \
        TOKEN_SECURITY_ATTRIBUTE_VALUE_CASE_SENSITIVE | \
        TOKEN_SECURITY_ATTRIBUTE_USE_FOR_DENY_ONLY | \
        TOKEN_SECURITY_ATTRIBUTE_DISABLED_BY_DEFAULT | \
        TOKEN_SECURITY_ATTRIBUTE_DISABLED | \
        TOKEN_SECURITY_ATTRIBUTE_MANDATORY),
    TOKEN_SECURITY_ATTRIBUTE_CUSTOM_FLAGS = 0xffff0000,
};

enum TOKEN_SECURITY_ATTRIBUTES_INFORMATION_VERSION
{
    TOKEN_SECURITY_ATTRIBUTES_INFORMATION_VERSION_V1 = 1,
};

#pragma endregion ntseapi.h

#pragma region ntxcapi.h

enum KCONTINUE_FLAGS
{
    KCONTINUE_FLAG_TEST_ALERT = 0x00000001,
    KCONTINUE_FLAG_DELIVER_APC = 0x00000002,
};

#pragma endregion ntxcapi.h

#pragma region ntwow64.h

enum PAGE_SIZE
{
    PAGE_SIZE_X86NT = 0x1000,
    PAGE_SHIFT_X86NT = 12L,
    WOW64_SPLITS_PER_PAGE = (PAGE_SIZE_X86NT / PAGE_SIZE_X86NT),
};

enum WOW64_CPUFLAGS
{
    WOW64_CPUFLAGS_MSFT64 = 0x00000001,
    WOW64_CPUFLAGS_SOFTWARE = 0x00000002,
    WOW64_CPUFLAGS_IA64 = 0x00000004,
};

#pragma endregion ntwow64.h

#pragma region ntsam.h

enum SAM_MAX_VALUES
{
    SAM_MAXIMUM_LOOKUP_COUNT = (1000),
    SAM_MAXIMUM_LOOKUP_LENGTH = (32000),
    SAM_MAX_PASSWORD_LENGTH = (256),
    SAM_PASSWORD_ENCRYPTION_SALT_LEN = (16),
};

enum SAM_SERVER_ACCESS_MASK
{
    SAM_SERVER_CONNECT = 0x0001,
    SAM_SERVER_SHUTDOWN = 0x0002,
    SAM_SERVER_INITIALIZE = 0x0004,
    SAM_SERVER_CREATE_DOMAIN = 0x0008,
    SAM_SERVER_ENUMERATE_DOMAINS = 0x0010,
    SAM_SERVER_LOOKUP_DOMAIN = 0x0020,

    SAM_SERVER_ALL_ACCESS = (STANDARD_RIGHTS_REQUIRED | \
        SAM_SERVER_CONNECT | \
        SAM_SERVER_INITIALIZE | \
        SAM_SERVER_CREATE_DOMAIN | \
        SAM_SERVER_SHUTDOWN | \
        SAM_SERVER_ENUMERATE_DOMAINS | \
        SAM_SERVER_LOOKUP_DOMAIN),

    SAM_SERVER_READ = (STANDARD_RIGHTS_READ | \
        SAM_SERVER_ENUMERATE_DOMAINS),

    SAM_SERVER_WRITE = (STANDARD_RIGHTS_WRITE | \
        SAM_SERVER_INITIALIZE | \
        SAM_SERVER_CREATE_DOMAIN | \
        SAM_SERVER_SHUTDOWN),

    SAM_SERVER_EXECUTE = (STANDARD_RIGHTS_EXECUTE | \
        SAM_SERVER_CONNECT | \
        SAM_SERVER_LOOKUP_DOMAIN),
};

enum DOMAIN_ACCESS_MASK
{
    DOMAIN_READ_PASSWORD_PARAMETERS = 0x0001,
    DOMAIN_WRITE_PASSWORD_PARAMS = 0x0002,
    DOMAIN_READ_OTHER_PARAMETERS = 0x0004,
    DOMAIN_WRITE_OTHER_PARAMETERS = 0x0008,
    DOMAIN_CREATE_USER = 0x0010,
    DOMAIN_CREATE_GROUP = 0x0020,
    DOMAIN_CREATE_ALIAS = 0x0040,
    DOMAIN_GET_ALIAS_MEMBERSHIP = 0x0080,
    DOMAIN_LIST_ACCOUNTS = 0x0100,
    DOMAIN_LOOKUP = 0x0200,
    DOMAIN_ADMINISTER_SERVER = 0x0400,

    DOMAIN_ALL_ACCESS = (STANDARD_RIGHTS_REQUIRED | \
        DOMAIN_READ_OTHER_PARAMETERS | \
        DOMAIN_WRITE_OTHER_PARAMETERS | \
        DOMAIN_WRITE_PASSWORD_PARAMS | \
        DOMAIN_CREATE_USER | \
        DOMAIN_CREATE_GROUP | \
        DOMAIN_CREATE_ALIAS | \
        DOMAIN_GET_ALIAS_MEMBERSHIP | \
        DOMAIN_LIST_ACCOUNTS | \
        DOMAIN_READ_PASSWORD_PARAMETERS | \
        DOMAIN_LOOKUP | \
        DOMAIN_ADMINISTER_SERVER),

    DOMAIN_READ = (STANDARD_RIGHTS_READ | \
        DOMAIN_GET_ALIAS_MEMBERSHIP | \
        DOMAIN_READ_OTHER_PARAMETERS),

    DOMAIN_WRITE = (STANDARD_RIGHTS_WRITE | \
        DOMAIN_WRITE_OTHER_PARAMETERS | \
        DOMAIN_WRITE_PASSWORD_PARAMS | \
        DOMAIN_CREATE_USER | \
        DOMAIN_CREATE_GROUP | \
        DOMAIN_CREATE_ALIAS | \
        DOMAIN_ADMINISTER_SERVER),

    DOMAIN_EXECUTE = (STANDARD_RIGHTS_EXECUTE | \
        DOMAIN_READ_PASSWORD_PARAMETERS | \
        DOMAIN_LIST_ACCOUNTS | \
        DOMAIN_LOOKUP),
};

enum DOMAIN_PASSWORD_PROPERTIES_FLAGS
{
    DOMAIN_PASSWORD_COMPLEX = 0x00000001L,
    DOMAIN_PASSWORD_NO_ANON_CHANGE = 0x00000002L,
    DOMAIN_PASSWORD_NO_CLEAR_CHANGE = 0x00000004L,
    DOMAIN_LOCKOUT_ADMINS = 0x00000008L,
    DOMAIN_PASSWORD_STORE_CLEARTEXT = 0x00000010L,
    DOMAIN_REFUSE_PASSWORD_CHANGE = 0x00000020L,
    DOMAIN_NO_LM_OWF_CHANGE = 0x00000040L,
};

enum GROUP_ACCESS_MASK
{
    GROUP_READ_INFORMATION = 0x0001,
    GROUP_WRITE_ACCOUNT = 0x0002,
    GROUP_ADD_MEMBER = 0x0004,
    GROUP_REMOVE_MEMBER = 0x0008,
    GROUP_LIST_MEMBERS = 0x0010,

    GROUP_ALL_ACCESS = (STANDARD_RIGHTS_REQUIRED | \
        GROUP_LIST_MEMBERS | \
        GROUP_WRITE_ACCOUNT | \
        GROUP_ADD_MEMBER | \
        GROUP_REMOVE_MEMBER | \
        GROUP_READ_INFORMATION),

    GROUP_READ = (STANDARD_RIGHTS_READ | \
        GROUP_LIST_MEMBERS),

    GROUP_WRITE = (STANDARD_RIGHTS_WRITE | \
        GROUP_WRITE_ACCOUNT | \
        GROUP_ADD_MEMBER | \
        GROUP_REMOVE_MEMBER),

    GROUP_EXECUTE = (STANDARD_RIGHTS_EXECUTE | \
        GROUP_READ_INFORMATION),
};

enum ALIAS_ACCESS_MASK
{
    ALIAS_ADD_MEMBER = 0x0001,
    ALIAS_REMOVE_MEMBER = 0x0002,
    ALIAS_LIST_MEMBERS = 0x0004,
    ALIAS_READ_INFORMATION = 0x0008,
    ALIAS_WRITE_ACCOUNT = 0x0010,
    ALIAS_ALL_ACCESS = (STANDARD_RIGHTS_REQUIRED | \
        ALIAS_READ_INFORMATION | \
        ALIAS_WRITE_ACCOUNT | \
        ALIAS_LIST_MEMBERS | \
        ALIAS_ADD_MEMBER | \
        ALIAS_REMOVE_MEMBER),

    ALIAS_READ = (STANDARD_RIGHTS_READ | \
        ALIAS_LIST_MEMBERS),

    ALIAS_WRITE = (STANDARD_RIGHTS_WRITE | \
        ALIAS_WRITE_ACCOUNT | \
        ALIAS_ADD_MEMBER | \
        ALIAS_REMOVE_MEMBER),

    ALIAS_EXECUTE = (STANDARD_RIGHTS_EXECUTE | \
        ALIAS_READ_INFORMATION),
};

enum ALIAS_EXTENDED_INFORMATION_WHICH_FIELDS
{
    ALIAS_ALL_NAME = (0x00000001L),
    ALIAS_ALL_MEMBER_COUNT = (0x00000002L),
    ALIAS_ALL_ADMIN_COMMENT = (0x00000004L),
    ALIAS_ALL_SHELL_ADMIN_OBJECT_PROPERTIES = (0x00000008L),
};

enum GROUP_TYPES
{
    GROUP_TYPE_BUILTIN_LOCAL_GROUP = 0x00000001,
    GROUP_TYPE_ACCOUNT_GROUP = 0x00000002,
    GROUP_TYPE_RESOURCE_GROUP = 0x00000004,
    GROUP_TYPE_UNIVERSAL_GROUP = 0x00000008,
    GROUP_TYPE_APP_BASIC_GROUP = 0x00000010,
    GROUP_TYPE_APP_QUERY_GROUP = 0x00000020,
    GROUP_TYPE_SECURITY_ENABLED = 0x80000000,
    GROUP_TYPE_RESOURCE_BEHAVOIR = (GROUP_TYPE_RESOURCE_GROUP | \
        GROUP_TYPE_APP_BASIC_GROUP | \
        GROUP_TYPE_APP_QUERY_GROUP),
};

enum USER_ACCESS_MASK
{
    USER_READ_GENERAL = 0x0001,
    USER_READ_PREFERENCES = 0x0002,
    USER_WRITE_PREFERENCES = 0x0004,
    USER_READ_LOGON = 0x0008,
    USER_READ_ACCOUNT = 0x0010,
    USER_WRITE_ACCOUNT = 0x0020,
    USER_CHANGE_PASSWORD = 0x0040,
    USER_FORCE_PASSWORD_CHANGE = 0x0080,
    USER_LIST_GROUPS = 0x0100,
    USER_READ_GROUP_INFORMATION = 0x0200,
    USER_WRITE_GROUP_INFORMATION = 0x0400,
    USER_ALL_ACCESS = (STANDARD_RIGHTS_REQUIRED | \
        USER_READ_PREFERENCES | \
        USER_READ_LOGON | \
        USER_LIST_GROUPS | \
        USER_READ_GROUP_INFORMATION | \
        USER_WRITE_PREFERENCES | \
        USER_CHANGE_PASSWORD | \
        USER_FORCE_PASSWORD_CHANGE | \
        USER_READ_GENERAL | \
        USER_READ_ACCOUNT | \
        USER_WRITE_ACCOUNT | \
        USER_WRITE_GROUP_INFORMATION),

    USER_READ = (STANDARD_RIGHTS_READ | \
        USER_READ_PREFERENCES | \
        USER_READ_LOGON | \
        USER_READ_ACCOUNT | \
        USER_LIST_GROUPS | \
        USER_READ_GROUP_INFORMATION),

    USER_WRITE = (STANDARD_RIGHTS_WRITE | \
        USER_WRITE_PREFERENCES | \
        USER_CHANGE_PASSWORD),

    USER_EXECUTE = (STANDARD_RIGHTS_EXECUTE | \
        USER_READ_GENERAL | \
        USER_CHANGE_PASSWORD),
};

enum USER_ACCOUNT_CONTROL_FLAGS
{
    USER_ACCOUNT_DISABLED = (0x00000001),
    USER_HOME_DIRECTORY_REQUIRED = (0x00000002),
    USER_PASSWORD_NOT_REQUIRED = (0x00000004),
    USER_TEMP_DUPLICATE_ACCOUNT = (0x00000008),
    USER_NORMAL_ACCOUNT = (0x00000010),
    USER_MNS_LOGON_ACCOUNT = (0x00000020),
    USER_INTERDOMAIN_TRUST_ACCOUNT = (0x00000040),
    USER_WORKSTATION_TRUST_ACCOUNT = (0x00000080),
    USER_SERVER_TRUST_ACCOUNT = (0x00000100),
    USER_DONT_EXPIRE_PASSWORD = (0x00000200),
    USER_ACCOUNT_AUTO_LOCKED = (0x00000400),
    USER_ENCRYPTED_TEXT_PASSWORD_ALLOWED = (0x00000800),
    USER_SMARTCARD_REQUIRED = (0x00001000),
    USER_TRUSTED_FOR_DELEGATION = (0x00002000),
    USER_NOT_DELEGATED = (0x00004000),
    USER_USE_DES_KEY_ONLY = (0x00008000),
    USER_DONT_REQUIRE_PREAUTH = (0x00010000),
    USER_PASSWORD_EXPIRED = (0x00020000),
    USER_TRUSTED_TO_AUTHENTICATE_FOR_DELEGATION = (0x00040000),
    USER_NO_AUTH_DATA_REQUIRED = (0x00080000),
    USER_PARTIAL_SECRETS_ACCOUNT = (0x00100000),
    USER_USE_AES_KEYS = (0x00200000),

    NEXT_FREE_ACCOUNT_CONTROL_BIT = (USER_USE_AES_KEYS << 1),
    USER_MACHINE_ACCOUNT_MASK = (USER_INTERDOMAIN_TRUST_ACCOUNT | \
        USER_WORKSTATION_TRUST_ACCOUNT | \
        USER_SERVER_TRUST_ACCOUNT),

    USER_ACCOUNT_TYPE_MASK = (USER_TEMP_DUPLICATE_ACCOUNT | \
        USER_NORMAL_ACCOUNT | \
        USER_MACHINE_ACCOUNT_MASK),

    USER_COMPUTED_ACCOUNT_CONTROL_BITS = (USER_ACCOUNT_AUTO_LOCKED | USER_PASSWORD_EXPIRED),
};

enum LOGON_TIMES
{
    SAM_DAYS_PER_WEEK = (7),
    SAM_HOURS_PER_WEEK = (24 * SAM_DAYS_PER_WEEK),
    SAM_MINUTES_PER_WEEK = (60 * SAM_HOURS_PER_WEEK),
};

enum
{
    CYPHER_BLOCK_LENGTH = 8,
};

enum USER_ALL_INFORMATION_WHICH_FIELDS
{
    USER_ALL_USERNAME = 0x00000001,
    USER_ALL_FULLNAME = 0x00000002,
    USER_ALL_USERID = 0x00000004,
    USER_ALL_PRIMARYGROUPID = 0x00000008,
    USER_ALL_ADMINCOMMENT = 0x00000010,
    USER_ALL_USERCOMMENT = 0x00000020,
    USER_ALL_HOMEDIRECTORY = 0x00000040,
    USER_ALL_HOMEDIRECTORYDRIVE = 0x00000080,
    USER_ALL_SCRIPTPATH = 0x00000100,
    USER_ALL_PROFILEPATH = 0x00000200,
    USER_ALL_WORKSTATIONS = 0x00000400,
    USER_ALL_LASTLOGON = 0x00000800,
    USER_ALL_LASTLOGOFF = 0x00001000,
    USER_ALL_LOGONHOURS = 0x00002000,
    USER_ALL_BADPASSWORDCOUNT = 0x00004000,
    USER_ALL_LOGONCOUNT = 0x00008000,
    USER_ALL_PASSWORDCANCHANGE = 0x00010000,
    USER_ALL_PASSWORDMUSTCHANGE = 0x00020000,
    USER_ALL_PASSWORDLASTSET = 0x00040000,
    USER_ALL_ACCOUNTEXPIRES = 0x00080000,
    USER_ALL_USERACCOUNTCONTROL = 0x00100000,
    USER_ALL_PARAMETERS = 0x00200000,
    USER_ALL_COUNTRYCODE = 0x00400000,
    USER_ALL_CODEPAGE = 0x00800000,
    USER_ALL_NTPASSWORDPRESENT = 0x01000000,
    USER_ALL_LMPASSWORDPRESENT = 0x02000000,
    USER_ALL_PRIVATEDATA = 0x04000000,
    USER_ALL_PASSWORDEXPIRED = 0x08000000,
    USER_ALL_SECURITYDESCRIPTOR = 0x10000000,
    USER_ALL_OWFPASSWORD = 0x20000000,

    USER_ALL_UNDEFINED_MASK = 0xc0000000,

    USER_ALL_READ_GENERAL_MASK = (USER_ALL_USERNAME | \
        USER_ALL_FULLNAME | \
        USER_ALL_USERID | \
        USER_ALL_PRIMARYGROUPID | \
        USER_ALL_ADMINCOMMENT | \
        USER_ALL_USERCOMMENT),

    USER_ALL_READ_LOGON_MASK = (USER_ALL_HOMEDIRECTORY | \
        USER_ALL_HOMEDIRECTORYDRIVE | \
        USER_ALL_SCRIPTPATH | \
        USER_ALL_PROFILEPATH | \
        USER_ALL_WORKSTATIONS | \
        USER_ALL_LASTLOGON | \
        USER_ALL_LASTLOGOFF | \
        USER_ALL_LOGONHOURS | \
        USER_ALL_BADPASSWORDCOUNT | \
        USER_ALL_LOGONCOUNT | \
        USER_ALL_PASSWORDCANCHANGE | \
        USER_ALL_PASSWORDMUSTCHANGE),

    USER_ALL_READ_ACCOUNT_MASK = (USER_ALL_PASSWORDLASTSET | \
        USER_ALL_ACCOUNTEXPIRES | \
        USER_ALL_USERACCOUNTCONTROL | \
        USER_ALL_PARAMETERS),

    USER_ALL_READ_PREFERENCES_MASK = (USER_ALL_COUNTRYCODE | USER_ALL_CODEPAGE),

    USER_ALL_READ_TRUSTED_MASK = (USER_ALL_NTPASSWORDPRESENT | \
        USER_ALL_LMPASSWORDPRESENT | \
        USER_ALL_PASSWORDEXPIRED | \
        USER_ALL_SECURITYDESCRIPTOR | \
        USER_ALL_PRIVATEDATA),

    USER_ALL_WRITE_ACCOUNT_MASK = (USER_ALL_USERNAME | \
        USER_ALL_FULLNAME | \
        USER_ALL_PRIMARYGROUPID | \
        USER_ALL_HOMEDIRECTORY | \
        USER_ALL_HOMEDIRECTORYDRIVE | \
        USER_ALL_SCRIPTPATH | \
        USER_ALL_PROFILEPATH | \
        USER_ALL_ADMINCOMMENT | \
        USER_ALL_WORKSTATIONS | \
        USER_ALL_LOGONHOURS | \
        USER_ALL_ACCOUNTEXPIRES | \
        USER_ALL_USERACCOUNTCONTROL | \
        USER_ALL_PARAMETERS),

    USER_ALL_WRITE_PREFERENCES_MASK = (USER_ALL_USERCOMMENT | USER_ALL_COUNTRYCODE | USER_ALL_CODEPAGE),

    USER_ALL_WRITE_FORCE_PASSWORD_CHANGE_MASK = (USER_ALL_NTPASSWORDPRESENT | \
        USER_ALL_LMPASSWORDPRESENT | \
        USER_ALL_PASSWORDEXPIRED),

    USER_ALL_WRITE_TRUSTED_MASK = (USER_ALL_LASTLOGON | \
        USER_ALL_LASTLOGOFF | \
        USER_ALL_BADPASSWORDCOUNT | \
        USER_ALL_LOGONCOUNT | \
        USER_ALL_PASSWORDLASTSET | \
        USER_ALL_SECURITYDESCRIPTOR | \
        USER_ALL_PRIVATEDATA),

    USER_ALL_WRITE_CANT_MASK = (USER_ALL_USERID | \
        USER_ALL_PASSWORDCANCHANGE | \
        USER_ALL_PASSWORDMUSTCHANGE | \
        USER_ALL_UNDEFINED_MASK),
};

enum USER_EXTENDED_FIELDS
{
    USER_EXTENDED_FIELD_UPN = 0x00000001L,
    USER_EXTENDED_FIELD_A2D2 = 0x00000002L,
    USER_EXTENDED_FIELD_USER_TILE = (0x00001000L),
    USER_EXTENDED_FIELD_PASSWORD_HINT = (0x00002000L),
    USER_EXTENDED_FIELD_DONT_SHOW_IN_LOGON_UI = (0x00004000L),
    USER_EXTENDED_FIELD_SHELL_ADMIN_OBJECT_PROPERTIES = (0x00008000L),
};

enum USER_PWD_CHANGE_EXTENDED_FAILURE_REASON
{
    SAM_PWD_CHANGE_NO_ERROR = 0,
    SAM_PWD_CHANGE_PASSWORD_TOO_SHORT = 1,
    SAM_PWD_CHANGE_PWD_IN_HISTORY = 2,
    SAM_PWD_CHANGE_USERNAME_IN_PASSWORD = 3,
    SAM_PWD_CHANGE_FULLNAME_IN_PASSWORD = 4,
    SAM_PWD_CHANGE_NOT_COMPLEX = 5,
    SAM_PWD_CHANGE_MACHINE_PASSWORD_NOT_DEFAULT = 6,
    SAM_PWD_CHANGE_FAILED_BY_FILTER = 7,
    SAM_PWD_CHANGE_PASSWORD_TOO_LONG = 8,
    SAM_PWD_CHANGE_FAILURE_REASON_MAX = 8,
};

enum SAM_GROUP_MEMBER_RID
{
    SAM_USER_ACCOUNT = (0x00000001),
    SAM_GLOBAL_GROUP_ACCOUNT = (0x00000002),
    SAM_LOCAL_GROUP_ACCOUNT = (0x00000004),
};

enum SAM_VALIDATE_PRESENT_FIELDS
{
    SAM_VALIDATE_PASSWORD_LAST_SET = 0x00000001,
    SAM_VALIDATE_BAD_PASSWORD_TIME = 0x00000002,
    SAM_VALIDATE_LOCKOUT_TIME = 0x00000004,
    SAM_VALIDATE_BAD_PASSWORD_COUNT = 0x00000008,
    SAM_VALIDATE_PASSWORD_HISTORY_LENGTH = 0x00000010,
    SAM_VALIDATE_PASSWORD_HISTORY = 0x00000020,
};

#pragma endregion ntsam.h

#pragma region ntmisc.h

enum FLT_PORT
{
    FLT_PORT_CONNECT = 0x0001,
    FLT_PORT_ALL_ACCESS = (FLT_PORT_CONNECT | STANDARD_RIGHTS_ALL),
};

#pragma endregion ntmisc.h

#pragma region ntwmi.h

enum ETW_BUFFER_SIZE
{
    MIN_ETW_BUFFER_SIZE = 1,
    MAX_ETW_BUFFER_SIZE = (16 * 1024),
    MAX_ETW_BUFFER_SIZE_WIN7 = (1 * 1024),
    MAX_ETW_EVENT_SIZE = 0xFFFF,
};

enum SYSTEM_TRACE_CONTROL
{
    ETW_KERNEL_RUNDOWN_START = 0x00000001,
    ETW_KERNEL_RUNDOWN_STOP = 0x00000002,
    ETW_CKCL_RUNDOWN_START = 0x00000004,
    ETW_CKCL_RUNDOWN_STOP = 0x00000008,
    ETW_FILENAME_RUNDOWN = 0x00000010,
};

enum EVENT_TRACE_GROUPS
{
    EVENT_TRACE_GROUP_HEADER = 0x0000,
    EVENT_TRACE_GROUP_IO = 0x0100,
    EVENT_TRACE_GROUP_MEMORY = 0x0200,
    EVENT_TRACE_GROUP_PROCESS = 0x0300,
    EVENT_TRACE_GROUP_FILE = 0x0400,
    EVENT_TRACE_GROUP_THREAD = 0x0500,
    EVENT_TRACE_GROUP_TCPIP = 0x0600,
    EVENT_TRACE_GROUP_JOB = 0x0700,
    EVENT_TRACE_GROUP_UDPIP = 0x0800,
    EVENT_TRACE_GROUP_REGISTRY = 0x0900,
    EVENT_TRACE_GROUP_DBGPRINT = 0x0A00,
    EVENT_TRACE_GROUP_CONFIG = 0x0B00,
    EVENT_TRACE_GROUP_SPARE1 = 0x0C00,
    EVENT_TRACE_GROUP_WNF = 0x0D00,
    EVENT_TRACE_GROUP_POOL = 0x0E00,
    EVENT_TRACE_GROUP_PERFINFO = 0x0F00,
    EVENT_TRACE_GROUP_HEAP = 0x1000,
    EVENT_TRACE_GROUP_OBJECT = 0x1100,
    EVENT_TRACE_GROUP_POWER = 0x1200,
    EVENT_TRACE_GROUP_MODBOUND = 0x1300,
    EVENT_TRACE_GROUP_IMAGE = 0x1400,
    EVENT_TRACE_GROUP_DPC = 0x1500,
    EVENT_TRACE_GROUP_CC = 0x1600,
    EVENT_TRACE_GROUP_CRITSEC = 0x1700,
    EVENT_TRACE_GROUP_STACKWALK = 0x1800,
    EVENT_TRACE_GROUP_UMS = 0x1900,
    EVENT_TRACE_GROUP_ALPC = 0x1A00,
    EVENT_TRACE_GROUP_SPLITIO = 0x1B00,
    EVENT_TRACE_GROUP_THREAD_POOL = 0x1C00,
    EVENT_TRACE_GROUP_HYPERVISOR = 0x1D00,
    EVENT_TRACE_GROUP_HYPERVISORX = 0x1E00,
};

// noname
enum
{
    MAX_KERNEL_TRACE_EVENTS = 0x1F,
    TRACE_HEADER_FLAG = 0x80000000,
};

// Còn rất rất nhiều, chưa tạo xong

#pragma endregion ntwmi.h

#pragma region ntgdi.h

enum GDI_HANDLE_VALUES
{
    GDI_MAX_HANDLE_COUNT = 0xFFFF,

    GDI_HANDLE_INDEX_SHIFT = 0,
    GDI_HANDLE_INDEX_BITS = 16,
    GDI_HANDLE_INDEX_MASK = 0xffff,

    GDI_HANDLE_TYPE_SHIFT = 16,
    GDI_HANDLE_TYPE_BITS = 5,
    GDI_HANDLE_TYPE_MASK = 0x1f,

    GDI_HANDLE_ALTTYPE_SHIFT = 21,
    GDI_HANDLE_ALTTYPE_BITS = 2,
    GDI_HANDLE_ALTTYPE_MASK = 0x3,

    GDI_HANDLE_STOCK_SHIFT = 23,
    GDI_HANDLE_STOCK_BITS = 1,
    GDI_HANDLE_STOCK_MASK = 0x1,

    GDI_HANDLE_UNIQUE_SHIFT = 24,
    GDI_HANDLE_UNIQUE_BITS = 8,
    GDI_HANDLE_UNIQUE_MASK = 0xff,
};

enum GDI_SERVER_SIDE_TYPES
{
    GDI_DEF_TYPE = 0, // invalid handle
    GDI_DC_TYPE = 1,
    GDI_DD_DIRECTDRAW_TYPE = 2,
    GDI_DD_SURFACE_TYPE = 3,
    GDI_RGN_TYPE = 4,
    GDI_SURF_TYPE = 5,
    GDI_CLIENTOBJ_TYPE = 6,
    GDI_PATH_TYPE = 7,
    GDI_PAL_TYPE = 8,
    GDI_ICMLCS_TYPE = 9,
    GDI_LFONT_TYPE = 10,
    GDI_RFONT_TYPE = 11,
    GDI_PFE_TYPE = 12,
    GDI_PFT_TYPE = 13,
    GDI_ICMCXF_TYPE = 14,
    GDI_ICMDLL_TYPE = 15,
    GDI_BRUSH_TYPE = 16,
    GDI_PFF_TYPE = 17,
    GDI_CACHE_TYPE = 18,
    GDI_SPACE_TYPE = 19,
    GDI_DBRUSH_TYPE = 20,
    GDI_META_TYPE = 21,
    GDI_EFSTATE_TYPE = 22,
    GDI_BMFD_TYPE = 23,
    GDI_VTFD_TYPE = 24,
    GDI_TTFD_TYPE = 25,
    GDI_RC_TYPE = 26,
    GDI_TEMP_TYPE = 27,
    GDI_DRVOBJ_TYPE = 28,
    GDI_DCIOBJ_TYPE = 29,
    GDI_SPOOL_TYPE = 30,
};

enum GDI_CLIENT_SIDE_TYPES
{
    GDI_ALTTYPE_1 = (1 << GDI_HANDLE_ALTTYPE_SHIFT),
    GDI_ALTTYPE_2 = (2 << GDI_HANDLE_ALTTYPE_SHIFT),
    GDI_ALTTYPE_3 = (3 << GDI_HANDLE_ALTTYPE_SHIFT),

    GDI_CLIENT_BITMAP_TYPE = (GDI_SURF_TYPE << GDI_HANDLE_TYPE_SHIFT),
    GDI_CLIENT_BRUSH_TYPE = (GDI_BRUSH_TYPE << GDI_HANDLE_TYPE_SHIFT),
    GDI_CLIENT_CLIENTOBJ_TYPE = (GDI_CLIENTOBJ_TYPE << GDI_HANDLE_TYPE_SHIFT),
    GDI_CLIENT_DC_TYPE = (GDI_DC_TYPE << GDI_HANDLE_TYPE_SHIFT),
    GDI_CLIENT_FONT_TYPE = (GDI_LFONT_TYPE << GDI_HANDLE_TYPE_SHIFT),
    GDI_CLIENT_PALETTE_TYPE = (GDI_PAL_TYPE << GDI_HANDLE_TYPE_SHIFT),
    GDI_CLIENT_REGION_TYPE = (GDI_RGN_TYPE << GDI_HANDLE_TYPE_SHIFT),

    GDI_CLIENT_ALTDC_TYPE = (GDI_CLIENT_DC_TYPE | GDI_ALTTYPE_1),
    GDI_CLIENT_DIBSECTION_TYPE = (GDI_CLIENT_BITMAP_TYPE | GDI_ALTTYPE_1),
    GDI_CLIENT_EXTPEN_TYPE = (GDI_CLIENT_BRUSH_TYPE | GDI_ALTTYPE_2),
    GDI_CLIENT_METADC16_TYPE = (GDI_CLIENT_CLIENTOBJ_TYPE | GDI_ALTTYPE_3),
    GDI_CLIENT_METAFILE_TYPE = (GDI_CLIENT_CLIENTOBJ_TYPE | GDI_ALTTYPE_2),
    GDI_CLIENT_METAFILE16_TYPE = (GDI_CLIENT_CLIENTOBJ_TYPE | GDI_ALTTYPE_1),
    GDI_CLIENT_PEN_TYPE = (GDI_CLIENT_BRUSH_TYPE | GDI_ALTTYPE_1),
};

#pragma endregion ntgdi.h

#pragma region ntsmss.h

enum SBCREATEPROCESS_FLAGS
{
    SMP_DEBUG_FLAG = 0x00000001,
    SMP_ASYNC_FLAG = 0x00000002,
    SMP_DONT_START = 0x00000004,
};

#pragma endregion ntsmss.h

#pragma region winsta.h

// noname
enum WINSTA_H
{
    WINSTATION_CURRENT_SERVER = NULL,
    WINSTATION_CURRENT_SERVER_HANDLE = NULL,
    WINSTATION_CURRENT_SERVER_NAME = NULL,
    TS_PROCESS_INFO_MAGIC_NT4 = 0x23495452,
    SIZEOF_TS4_SYSTEM_THREAD_INFORMATION = 64,
    SIZEOF_TS4_SYSTEM_PROCESS_INFORMATION = 136,
    WNOTIFY_ALL_SESSIONS = 0x1,
    LOGONID_CURRENT = -1,
    SERVERNAME_CURRENT = NULL,
};

enum WINSTATION_SESSION_ID
{
    WINSTATION_CURRENT_SESSION = ((ULONG)-1),
    WINSTATION_ANY_SESSION = ((ULONG)-2),
};

enum WINSTATION_ACCESS_MASK
{
    WINSTATION_QUERY = 0x00000001,
    WINSTATION_SET = 0x00000002,
    WINSTATION_RESET = 0x00000004,
    WINSTATION_VIRTUAL = 0x00000008,
    WINSTATION_SHADOW = 0x00000010,
    WINSTATION_LOGON = 0x00000020,
    WINSTATION_LOGOFF = 0x00000040,
    WINSTATION_MSG = 0x00000080,
    WINSTATION_CONNECT = 0x00000100,
    WINSTATION_DISCONNECT = 0x00000200,
    WINSTATION_GUEST_ACCESS = WINSTATION_LOGON,

    WINSTATION_CURRENT_GUEST_ACCESS = (WINSTATION_VIRTUAL | WINSTATION_LOGOFF),
    WINSTATION_USER_ACCESS = (WINSTATION_GUEST_ACCESS | WINSTATION_QUERY | WINSTATION_CONNECT),
    WINSTATION_CURRENT_USER_ACCESS = (WINSTATION_SET | WINSTATION_RESET | WINSTATION_VIRTUAL | \
        WINSTATION_LOGOFF | WINSTATION_DISCONNECT),
    WINSTATION_ALL_ACCESS = (STANDARD_RIGHTS_REQUIRED | WINSTATION_QUERY | \
        WINSTATION_SET | WINSTATION_RESET | WINSTATION_VIRTUAL | \
        WINSTATION_SHADOW | WINSTATION_LOGON | WINSTATION_MSG | \
        WINSTATION_CONNECT | WINSTATION_DISCONNECT),
};

enum
{
    WDPREFIX_LENGTH = 12,
    CALLBACK_LENGTH = 50,
    DLLNAME_LENGTH = 32,
    CDNAME_LENGTH = 32,
    WDNAME_LENGTH = 32,
    PDNAME_LENGTH = 32,
    DEVICENAME_LENGTH = 128,
    MODEMNAME_LENGTH = DEVICENAME_LENGTH,
    STACK_ADDRESS_LENGTH = 128,
    MAX_BR_NAME = 65,
    DIRECTORY_LENGTH = 256,
    INITIALPROGRAM_LENGTH = 256,
    USERNAME_LENGTH = 20,
    DOMAIN_LENGTH = 17,
    PASSWORD_LENGTH = 14,
    NASISPECIFICNAME_LENGTH = 14,
    NASIUSERNAME_LENGTH = 47,
    NASIPASSWORD_LENGTH = 24,
    NASISESSIONNAME_LENGTH = 16,
    NASIFILESERVER_LENGTH = 47,

    CLIENTDATANAME_LENGTH = 7,
    CLIENTNAME_LENGTH = 20,
    CLIENTADDRESS_LENGTH = 30,
    IMEFILENAME_LENGTH = 32,
    CLIENTLICENSE_LENGTH = 32,
    CLIENTMODEM_LENGTH = 40,
    CLIENT_PRODUCT_ID_LENGTH = 32,
    MAX_COUNTER_EXTENSIONS = 2,
    WINSTATIONNAME_LENGTH = 32,
};

enum
{
    TERMSRV_TOTAL_SESSIONS = 1,
    TERMSRV_DISC_SESSIONS = 2,
    TERMSRV_RECON_SESSIONS = 3,
    TERMSRV_CURRENT_ACTIVE_SESSIONS = 4,
    TERMSRV_CURRENT_DISC_SESSIONS = 5,
    TERMSRV_PENDING_SESSIONS = 6,
    TERMSRV_SUCC_TOTAL_LOGONS = 7,
    TERMSRV_SUCC_LOCAL_LOGONS = 8,
    TERMSRV_SUCC_REMOTE_LOGONS = 9,
    TERMSRV_SUCC_SESSION0_LOGONS = 10,
    TERMSRV_CURRENT_TERMINATING_SESSIONS = 11,
    TERMSRV_CURRENT_LOGGEDON_SESSIONS = 12,
};

enum PROTOCOL_TYPES
{
    PROTOCOL_CONSOLE = 0,
    PROTOCOL_OTHERS = 1,
    PROTOCOL_RDP = 2,
};

enum WSD_FLAGS
{
    WSD_LOGOFF = 0x1,
    WSD_SHUTDOWN = 0x2,
    WSD_REBOOT = 0x4,
    WSD_POWEROFF = 0x8,
};

enum WEVENT_FLAGS
{
    WEVENT_NONE = 0x0,
    WEVENT_CREATE = 0x1,
    WEVENT_DELETE = 0x2,
    WEVENT_RENAME = 0x4,
    WEVENT_CONNECT = 0x8,
    WEVENT_DISCONNECT = 0x10,
    WEVENT_LOGON = 0x20,
    WEVENT_LOGOFF = 0x40,
    WEVENT_STATECHANGE = 0x80,
    WEVENT_LICENSE = 0x100,
    WEVENT_ALL = 0x7fffffff,
    WEVENT_FLUSH = 0x80000000,
};

enum WSS_HOTKEYS
{
    KBDSHIFT = 0x1,
    KBDCTRL = 0x2,
    KBDALT = 0x4,
};

#pragma endregion winsta.h

#pragma region ntuser.h

enum CONSOLE_PROCESS_INFO_FLAGS
{
    CPI_NEWPROCESSWINDOW = 0x0001,
};

#pragma endregion ntuser.h

#pragma region ntstrsafe.h

enum STRSAFE_FLAGS
{
    STRSAFE_FILL_BYTE_0xFF = 0x000000FF,
    STRSAFE_IGNORE_NULLS = 0x00000100,
    STRSAFE_FILL_BEHIND_NULL = 0x00000200,
    STRSAFE_FILL_ON_FAILURE = 0x00000400,
    STRSAFE_NULL_ON_FAILURE = 0x00000800,
    STRSAFE_NO_TRUNCATION = 0x00001000,
    STRSAFE_FILL_BEHIND = 0x00000200,
    STRSAFE_ZERO_LENGTH_ON_FAILURE = 0x00000800,
    STRSAFE_VALID_FLAGS = (STRSAFE_FILL_BYTE_0xFF | STRSAFE_IGNORE_NULLS | STRSAFE_FILL_BEHIND_NULL | STRSAFE_FILL_ON_FAILURE | STRSAFE_NULL_ON_FAILURE | STRSAFE_NO_TRUNCATION),
    STRSAFE_UNICODE_STRING_VALID_FLAGS = (STRSAFE_FILL_BYTE_0xFF | STRSAFE_IGNORE_NULLS | STRSAFE_FILL_BEHIND | STRSAFE_FILL_ON_FAILURE | STRSAFE_ZERO_LENGTH_ON_FAILURE | STRSAFE_NO_TRUNCATION),
};

#pragma endregion ntstrsafe.h

#pragma region smbios.h

enum SMBIOS_NONANME
{
    SMBIOS_INVALID_HANDLE = ((USHORT)0x0FFFF),
    SMBIOS_INVALID_STRING = ((UCHAR)0),
};

enum SMBIOS_TABLE_TYPE
{
    SMBIOS_SYSTEM_INFORMATION_TYPE = ((UCHAR)1),
    SMBIOS_BASEBOARD_INFORMATION_TYPE = ((UCHAR)2),
    SMBIOS_CHASSIS_INFORMATION_TYPE = ((UCHAR)3),
    SMBIOS_PROCESSOR_INFORMATION_TYPE = ((UCHAR)4),
    SMBIOS_MEMORY_CONTROLLER_INFORMATION_TYPE = ((UCHAR)5),
    SMBIOS_MEMORY_MODULE_INFORMATION_TYPE = ((UCHAR)6),
    SMBIOS_CACHE_INFORMATION_TYPE = ((UCHAR)7),
    SMBIOS_PORT_CONNECTOR_INFORMATION_TYPE = ((UCHAR)8),
    SMBIOS_ON_BOARD_DEVICE_INFORMATION_TYPE = ((UCHAR)10),
    SMBIOS_OEM_STRING_INFORMATION_TYPE = ((UCHAR)11),
    SMBIOS_SYSTEM_CONFIGURATION_OPTION_INFORMATION_TYPE = ((UCHAR)12),
    SMBIOS_FIRMWARE_LANGUAGE_INFORMATION_TYPE = ((UCHAR)13),
    SMBIOS_GROUP_ASSOCIATION_INFORMATION_TYPE = ((UCHAR)14),
    SMBIOS_SYSTEM_EVENT_LOG_INFORMATION_TYPE = ((UCHAR)15),
    SMBIOS_PHYSICAL_MEMORY_ARRAY_INFORMATION_TYPE = ((UCHAR)16),
    SMBIOS_MEMORY_DEVICE_INFORMATION_TYPE = ((UCHAR)17),
    SMBIOS_32_BIT_MEMORY_ERROR_INFORMATION_TYPE = ((UCHAR)18),
    SMBIOS_MEMORY_ARRAY_MAPPED_ADDRESS_INFORMATION_TYPE = ((UCHAR)19),
    SMBIOS_MEMORY_DEVICE_MAPPED_ADDRESS_INFORMATION_TYPE = ((UCHAR)20),
    SMBIOS_BUILT_IN_POINTING_DEVICE_INFORMATION_TYPE = ((UCHAR)21),
    SMBIOS_PORTABLE_BATTERY_INFORMATION_TYPE = ((UCHAR)22),
    SMBIOS_SYSTEM_RESET_INFORMATION_TYPE = ((UCHAR)23),
    SMBIOS_HARDWARE_SECURITY_INFORMATION_TYPE = ((UCHAR)24),
    SMBIOS_SYSTEM_POWER_CONTROLS_INFORMATION_TYPE = ((UCHAR)25),
    SMBIOS_VOLTAGE_PROBE_INFORMATION_TYPE = ((UCHAR)26),
    SMBIOS_VOLTAGE_PROBE_INFORMATION_TYPE = ((UCHAR)26),
    SMBIOS_COOLING_DEVICE_INFORMATION_TYPE = ((UCHAR)27),
    SMBIOS_TEMPERATURE_PROBE_INFORMATION_TYPE = ((UCHAR)28),
    SMBIOS_ELECTRICAL_CURRENT_PROBE_INFORMATION_TYPE = ((UCHAR)29),
    SMBIOS_OUT_OF_BAND_REMOTE_ACCESS_INFORMATION_TYPE= ((UCHAR)30),
    SMBIOS_BOOT_INTEGRITY_SERVICES_ENTRY_POINT = ((UCHAR)31),
    SMBIOS_SYSTEM_BOOT_INFORMATION_TYPE = ((UCHAR)32),
    SMBIOS_64_BIT_MEMORY_ERROR_INFORMATION_TYPE = ((UCHAR)33),
    SMBIOS_MANAGEMENT_DEVICE_INFORMATION_TYPE = ((UCHAR)34),
    SMBIOS_MANAGEMENT_DEVICE_COMPONENT_INFORMATION_TYPE = ((UCHAR)35),
    SMBIOS_MANAGEMENT_DEVICE_THRESHOLD_INFORMATION_TYPE = ((UCHAR)36),
    SMBIOS_MEMORY_CHANNEL_INFORMATION_TYPE = ((UCHAR)37),
    SMBIOS_IPMI_DEVICE_INFORMATION_TYPE = ((UCHAR)38),
    SMBIOS_SYSTEM_POWER_SUPPLY_INFORMATION_TYPE = ((UCHAR)39),
    SMBIOS_ADDITIONAL_INFORMATION_TYPE = ((UCHAR)40),
    SMBIOS_ONBOARD_DEVICE_INFORMATION_TYPE = ((UCHAR)41),
    SMBIOS_MCHI_INFORMATION_TYPE = ((UCHAR)42),
    SMBIOS_TPM_DEVICE_INFORMATION_TYPE = ((UCHAR)43),
    SMBIOS_PROCESSOR_ADDITIONAL_INFORMATION_TYPE = ((UCHAR)44),
    SMBIOS_FIRMWARE_INVENTORY_INFORMATION_TYPE = ((UCHAR)45),
    SMBIOS_STRING_PROPERTY_TYPE = ((UCHAR)46),
    SMBIOS_INACTIVE_TYPE = ((UCHAR)126),
    SMBIOS_END_OF_TABLE_TYPE = ((UCHAR)127),
};

enum SMBIOS_PROBE_STATUS
{
    SMBIOS_PROBE_STATUS_OTHER = ((UCHAR)1),
    SMBIOS_PROBE_STATUS_UNKNOWN = ((UCHAR)2),
    SMBIOS_PROBE_STATUS_OK = ((UCHAR)3),
    SMBIOS_PROBE_STATUS_NON_CRITICAL = ((UCHAR)4),
    SMBIOS_PROBE_STATUS_CRITICAL = ((UCHAR)5),
    SMBIOS_PROBE_STATUS_NON_RECOVERABLE = ((UCHAR)6),
};

enum SMBIOS_MEMORY_ERROR_TYPE
{
    SMBIOS_MEMORY_ERROR_TYPE_OTHER = ((UCHAR)1),
    SMBIOS_MEMORY_ERROR_TYPE_UNKNOWN = ((UCHAR)2),
    SMBIOS_MEMORY_ERROR_TYPE_OK = ((UCHAR)3),
    SMBIOS_MEMORY_ERROR_TYPE_BAD_READ = ((UCHAR)4),
    SMBIOS_MEMORY_ERROR_TYPE_PARITY = ((UCHAR)5),
    SMBIOS_MEMORY_ERROR_TYPE_SINGLE_BIT = ((UCHAR)6),
    SMBIOS_MEMORY_ERROR_TYPE_DOUBLE_BIT = ((UCHAR)7),
    SMBIOS_MEMORY_ERROR_TYPE_MULTI_BIT = ((UCHAR)8),
    SMBIOS_MEMORY_ERROR_TYPE_NIBBLE = ((UCHAR)9),
    SMBIOS_MEMORY_ERROR_TYPE_CHECKSUM = ((UCHAR)10),
    SMBIOS_MEMORY_ERROR_TYPE_CRC = ((UCHAR)11),
    SMBIOS_MEMORY_ERROR_TYPE_CORRECTED_SINGLE_BIT = ((UCHAR)12),
    SMBIOS_MEMORY_ERROR_TYPE_CORRECTED = ((UCHAR)13),
    SMBIOS_MEMORY_ERROR_TYPE_UNCORRECTABLE = ((UCHAR)14),
};

enum SMBIOS_MEMORY_ERROR_GRANULARITY
{
    SMBIOS_MEMORY_ERROR_GRANULARITY_OTHER = ((UCHAR)1),
    SMBIOS_MEMORY_ERROR_GRANULARITY_UNKNOWN = ((UCHAR)2),
    SMBIOS_MEMORY_ERROR_GRANULARITY_DEVICE = ((UCHAR)3),
    SMBIOS_MEMORY_ERROR_GRANULARITY_PARTITION = ((UCHAR)4),
};

enum SMBIOS_MEMORY_ERROR_OPERATION
{
    SMBIOS_MEMORY_ERROR_OPERATION_OTHER = ((UCHAR)1),
    SMBIOS_MEMORY_ERROR_OPERATION_UNKNOWN = ((UCHAR)2),
    SMBIOS_MEMORY_ERROR_OPERATION_READ = ((UCHAR)3),
    SMBIOS_MEMORY_ERROR_OPERATION_WRITE = ((UCHAR)4),
    SMBIOS_MEMORY_ERROR_OPERATION_PARTIAL_WRITE = ((UCHAR)5),
};

enum SMBIOS_FIRMWARE_FLAG
{
    SMBIOS_FIRMWARE_FLAG_RESERVED_0 = 0x0000000000000001UL,
    SMBIOS_FIRMWARE_FLAG_RESERVED_1 = 0x0000000000000002UL,
    SMBIOS_FIRMWARE_FLAG_UNKNOWN = 0x0000000000000004UL,
    SMBIOS_FIRMWARE_FLAG_NOT_SUPPORTED = 0x0000000000000008UL,
    SMBIOS_FIRMWARE_FLAG_ISA_SUPPORTED = 0x0000000000000010UL,
    SMBIOS_FIRMWARE_FLAG_MCA_SUPPORTED = 0x0000000000000020UL,
    SMBIOS_FIRMWARE_FLAG_EISA_SUPPORTED = 0x0000000000000040UL,
    SMBIOS_FIRMWARE_FLAG_PCI_SUPPORTED = 0x0000000000000080UL,
    SMBIOS_FIRMWARE_FLAG_PCMCIA_SUPPORTED = 0x0000000000000100UL,
    SMBIOS_FIRMWARE_FLAG_PNP_SUPPORTED = 0x0000000000000200UL,
    SMBIOS_FIRMWARE_FLAG_APM_SUPPORTED = 0x0000000000000400UL,
    SMBIOS_FIRMWARE_FLAG_UPGRADE_SUPPORTED = 0x0000000000000800UL,
    SMBIOS_FIRMWARE_FLAG_SHADOWING_SUPPORTED = 0x0000000000001000UL,
    SMBIOS_FIRMWARE_FLAG_VL_VESA_SUPPORTED = 0x0000000000002000UL,
    SMBIOS_FIRMWARE_FLAG_ESCD_SUPPORTED = 0x0000000000004000UL,
    SMBIOS_FIRMWARE_FLAG_BOOT_FROM_CD_SUPPORTED = 0x0000000000008000UL,
    SMBIOS_FIRMWARE_FLAG_SELECTABLE_BOOT_SUPPORTED = 0x0000000000010000UL,
    SMBIOS_FIRMWARE_FLAG_ROM_SOCKETED = 0x0000000000020000UL,
    SMBIOS_FIRMWARE_FLAG_PCMCIA_BOOT_SUPPORTED = 0x0000000000040000UL,
    SMBIOS_FIRMWARE_FLAG_EDD_SUPPORTED = 0x0000000000080000UL,
    SMBIOS_FIRMWARE_FLAG_FLOPPY_NEC_9800_SUPPORTED = 0x0000000000100000UL,
    SMBIOS_FIRMWARE_FLAG_FLOPPY_TOSHIBA_SUPPORTED = 0x0000000000200000UL,
    SMBIOS_FIRMWARE_FLAG_FLOPPY_5_25_360KB_SUPPORTED = 0x0000000000400000UL,
    SMBIOS_FIRMWARE_FLAG_FLOPPY_5_25_1_2_MB_SUPPORTED = 0x0000000000800000UL,
    SMBIOS_FIRMWARE_FLAG_FLOPPY_3_5_720KB_SUPPORTED = 0x0000000001000000UL,
    SMBIOS_FIRMWARE_FLAG_FLOPPY_3_5_2_88MB_SUPPORTED = 0x0000000002000000UL,
    SMBIOS_FIRMWARE_FLAG_PRINT_SCREEN_SUPPORTED = 0x0000000004000000UL,
    SMBIOS_FIRMWARE_FLAG_8042_KEYBOARD_SUPPORTED = 0x0000000008000000UL,
    SMBIOS_FIRMWARE_FLAG_SERIAL_SUPPORTED = 0x0000000010000000UL,
    SMBIOS_FIRMWARE_FLAG_PRINTER_SUPPORTED = 0x0000000020000000UL,
    SMBIOS_FIRMWARE_FLAG_CGA_VIDEO_SUPPORTED = 0x0000000040000000UL,
    SMBIOS_FIRMWARE_FLAG_NEC_PC_98 = 0x0000000080000000UL,
    SMBIOS_FIRMWARE_FLAG_PLATFORM_RESERVED = 0x0000FFFF00000000UL,
    SMBIOS_FIRMWARE_FLAG_SYSTEM_RESERVED = 0xFFFF000000000000UL,
};

enum SMBIOS_FIRMWARE_FLAG_2
{
    SMBIOS_FIRMWARE_FLAG_2_ACPI_SUPPORTED = ((USHORT)0x0001),
    SMBIOS_FIRMWARE_FLAG_2_USB_LEGACY_SUPPORTED = ((USHORT)0x0002),
    SMBIOS_FIRMWARE_FLAG_2_AGP_SUPPORTED = ((USHORT)0x0004),
    SMBIOS_FIRMWARE_FLAG_2_I20_BOOT_SUPPORTED = ((USHORT)0x0008),
    SMBIOS_FIRMWARE_FLAG_2_LS_120_BOOT_SUPPORTED = ((USHORT)0x0010),
    SMBIOS_FIRMWARE_FLAG_2_ZIP_BOOT_SUPPORTED = ((USHORT)0x0020),
    SMBIOS_FIRMWARE_FLAG_2_1394_BOOT_SUPPORTED = ((USHORT)0x0040),
    SMBIOS_FIRMWARE_FLAG_2_SMART_BATTERY_SUPPORTED = ((USHORT)0x0080),
    SMBIOS_FIRMWARE_FLAG_2_BIOS_BOOT_SUPPORTED = ((USHORT)0x0100),
    SMBIOS_FIRMWARE_FLAG_2_FN_KEY_NET_BOOT_SUPPORTED = ((USHORT)0x0200),
    SMBIOS_FIRMWARE_FLAG_2_CONTENT_DISTRIBUTION_SUPPORTED = ((USHORT)0x0400),
    SMBIOS_FIRMWARE_FLAG_2_UEFI_SUPPORTED = ((USHORT)0x0800),
    SMBIOS_FIRMWARE_FLAG_2_MANUFACTURING_MODE_ENABLED = ((USHORT)0x1000),
    SMBIOS_FIRMWARE_FLAG_2_RESERVED = ((USHORT)0xE000),
};

enum SMBIOS_FIRMWARE_ROM_UNIT
{
    SMBIOS_FIRMWARE_ROM_UNIT_MB = 0,
    SMBIOS_FIRMWARE_ROM_UNIT_GB = 1,
    SMBIOS_FIRMWARE_ROM_UNIT_RESERVED_1 = 2,
    SMBIOS_FIRMWARE_ROM_UNIT_RESERVED_2 = 3,
};

enum SMBIOS_SYSTEM_WAKE_UP
{
    SMBIOS_SYSTEM_WAKE_UP_TYPE_RESERVED = ((UCHAR)0),
    SMBIOS_SYSTEM_WAKE_UP_TYPE_OTHER = ((UCHAR)1),
    SMBIOS_SYSTEM_WAKE_UP_UNKNOWN = ((UCHAR)2),
    SMBIOS_SYSTEM_WAKE_UP_APM_TIMER = ((UCHAR)3),
    SMBIOS_SYSTEM_WAKE_UP_MODEM_RING = ((UCHAR)4),
    SMBIOS_SYSTEM_WAKE_UP_LAN_REMOTE = ((UCHAR)5),
    SMBIOS_SYSTEM_WAKE_UP_POWER_SWITCH = ((UCHAR)6),
    SMBIOS_SYSTEM_WAKE_UP_PCI_PME = ((UCHAR)7),
    SMBIOS_SYSTEM_WAKE_UP_AC_POWER_RESTORED = ((UCHAR)8),
};

enum SMBIOS_BASEBOARD_FEATURE
{
    SMBIOS_BASEBOARD_FEATURE_HOSTING_BOARD = ((UCHAR)0x01),
    SMBIOS_BASEBOARD_FEATURE_REQUIRES_DAUGHTER_BOARD = ((UCHAR)0x02),
    SMBIOS_BASEBOARD_FEATURE_REMOVABLE_BOARD = ((UCHAR)0x04),
    SMBIOS_BASEBOARD_FEATURE_REPLACEABLE_BOARD = ((UCHAR)0x08),
    SMBIOS_BASEBOARD_FEATURE_HOT_SWAP_BOARD = ((UCHAR)0x10),
    SMBIOS_BASEBOARD_FEATURE_RESERVED = ((UCHAR)0xE0),
};

enum SMBIOS_BASEBOARD_TYPE
{
    SMBIOS_BASEBOARD_TYPE_UNKNOWN = ((UCHAR)1),
    SMBIOS_BASEBOARD_TYPE_OTHER = ((UCHAR)2),
    SMBIOS_BASEBOARD_TYPE_SERVER_BLADE = ((UCHAR)3),
    SMBIOS_BASEBOARD_TYPE_CONNECTIVITY_SWITCH = ((UCHAR)4),
    SMBIOS_BASEBOARD_TYPE_SYSTEM_MANAGEMENT_MODULE = ((UCHAR)5),
    SMBIOS_BASEBOARD_TYPE_PROCESSOR_MODULE = ((UCHAR)6),
    SMBIOS_BASEBOARD_TYPE_IO_MODULE = ((UCHAR)7),
    SMBIOS_BASEBOARD_TYPE_MEMORY_MODULE = ((UCHAR)8),
    SMBIOS_BASEBOARD_TYPE_DAUGHTER_BOARD = ((UCHAR)9),
    SMBIOS_BASEBOARD_TYPE_MOTHERBOARD = ((UCHAR)10),
    SMBIOS_BASEBOARD_TYPE_PROCESSOR_MEMORY_MODULE = ((UCHAR)11),
    SMBIOS_BASEBOARD_TYPE_PROCESSOR_IO_MODULE = ((UCHAR)12),
    SMBIOS_BASEBOARD_TYPE_INTERCONNECT = ((UCHAR)13),
};

enum SMBIOS_CHASSIS_TYPE
{
    SMBIOS_CHASSIS_TYPE_OTHER = 1,
    SMBIOS_CHASSIS_TYPE_UNKNOWN = 2,
    SMBIOS_CHASSIS_TYPE_DESKTOP = 3,
    SMBIOS_CHASSIS_TYPE_LOW_PROFILE_DESKTOP = 4,
    SMBIOS_CHASSIS_TYPE_PIZZA_BOX = 5,
    SMBIOS_CHASSIS_TYPE_MINI_TOWER = 6,
    SMBIOS_CHASSIS_TYPE_TOWER = 7,
    SMBIOS_CHASSIS_TYPE_PORTABLE = 8,
    SMBIOS_CHASSIS_TYPE_LAPTOP = 9,
    SMBIOS_CHASSIS_TYPE_NOTEBOOK = 10,
    SMBIOS_CHASSIS_TYPE_HAND_HELD = 11,
    SMBIOS_CHASSIS_TYPE_DOCKING_STATION = 12,
    SMBIOS_CHASSIS_TYPE_ALL_IN_ONE = 13,
    SMBIOS_CHASSIS_TYPE_SUB_NOTEBOOK = 14,
    SMBIOS_CHASSIS_TYPE_SPACE_SAVING = 15,
    SMBIOS_CHASSIS_TYPE_LUNCH_BOX = 16,
    SMBIOS_CHASSIS_TYPE_MAIN_SERVER = 17,
    SMBIOS_CHASSIS_TYPE_EXPANSION = 18,
    SMBIOS_CHASSIS_TYPE_SUB = 19,
    SMBIOS_CHASSIS_TYPE_BUS_EXPANSION = 20,
    SMBIOS_CHASSIS_TYPE_PERIPHERAL = 21,
    SMBIOS_CHASSIS_TYPE_RAID = 22,
    SMBIOS_CHASSIS_TYPE_RACK_MOUNT = 23,
    SMBIOS_CHASSIS_TYPE_SEALED_CASE_PC = 24,
    SMBIOS_CHASSIS_TYPE_MULTI_SYSTEM = 25,
    SMBIOS_CHASSIS_TYPE_COMPACT_PCI = 26,
    SMBIOS_CHASSIS_TYPE_ADVANCED_TCA = 27,
    SMBIOS_CHASSIS_TYPE_BLADE = 28,
    SMBIOS_CHASSIS_TYPE_BLADE_ENCLOSURE = 29,
    SMBIOS_CHASSIS_TYPE_TABLET = 30,
    SMBIOS_CHASSIS_TYPE_CONVERTIBLE = 31,
    SMBIOS_CHASSIS_TYPE_DETACHABLE = 32,
    SMBIOS_CHASSIS_TYPE_IOT_GATEWAY = 33,
    SMBIOS_CHASSIS_TYPE_EMBEDDED_PC = 34,
    SMBIOS_CHASSIS_TYPE_MINI_PC = 35,
    SMBIOS_CHASSIS_TYPE_STICK_PC = 36,
};

enum SMBIOS_CHASSIS_STATE
{
    SMBIOS_CHASSIS_STATE_OTHER = ((UCHAR)1),
    SMBIOS_CHASSIS_STATE_UNKNOWN = ((UCHAR)2),
    SMBIOS_CHASSIS_STATE_SAFE = ((UCHAR)3),
    SMBIOS_CHASSIS_STATE_WARNING = ((UCHAR)4),
    SMBIOS_CHASSIS_STATE_CRITICAL = ((UCHAR)5),
    SMBIOS_CHASSIS_STATE_NON_RECOVERABLE = ((UCHAR)6),
};

enum SMBIOS_CHASSIS_SECURITY_STATE
{
    SMBIOS_CHASSIS_SECURITY_STATE_OTHER = ((UCHAR)1),
    SMBIOS_CHASSIS_SECURITY_STATE_UNKNOWN = ((UCHAR)2),
    SMBIOS_CHASSIS_SECURITY_STATE_NONE = ((UCHAR)3),
    SMBIOS_CHASSIS_SECURITY_STATE_LOCKED_OUT = ((UCHAR)4),
    SMBIOS_CHASSIS_SECURITY_STATE_ENABLED = ((UCHAR)5),
};

enum SMBIOS_PROCESSOR_TYPE
{
    SMBIOS_PROCESSOR_TYPE_OTHER = ((UCHAR)1),
    SMBIOS_PROCESSOR_TYPE_UNKNOWN = ((UCHAR)2),
    SMBIOS_PROCESSOR_TYPE_CENTRAL = ((UCHAR)3),
    SMBIOS_PROCESSOR_TYPE_MATH = ((UCHAR)4),
    SMBIOS_PROCESSOR_TYPE_DSP = ((UCHAR)5),
    SMBIOS_PROCESSOR_TYPE_VIDEO = ((UCHAR)6),
};

enum SMBIOS_PROCESSOR_FAMILY
{
    SMBIOS_PROCESSOR_FAMILY_OTHER = 1,
    SMBIOS_PROCESSOR_FAMILY_UNKNOWN = 2,
    SMBIOS_PROCESSOR_FAMILY_8086 = 3,
    SMBIOS_PROCESSOR_FAMILY_80286 = 4,
    SMBIOS_PROCESSOR_FAMILY_INTEL386_PROCESSOR = 5,
    SMBIOS_PROCESSOR_FAMILY_INTEL486_PROCESSOR = 6,
    SMBIOS_PROCESSOR_FAMILY_8087 = 7,
    SMBIOS_PROCESSOR_FAMILY_80287 = 8,
    SMBIOS_PROCESSOR_FAMILY_80387 = 9,
    SMBIOS_PROCESSOR_FAMILY_80487 = 10,
    SMBIOS_PROCESSOR_FAMILY_INTEL_PENTIUM_PROCESSOR = 11,
    SMBIOS_PROCESSOR_FAMILY_PENTIUM_PRO_PROCESSOR = 12,
    SMBIOS_PROCESSOR_FAMILY_PENTIUM_II_PROCESSOR = 13,
    SMBIOS_PROCESSOR_FAMILY_PENTIUM_PROCESSOR_WITH_MMX_TECHNOLOGY = 14,
    SMBIOS_PROCESSOR_FAMILY_INTEL_CELERON_PROCESSOR = 15,
    SMBIOS_PROCESSOR_FAMILY_PENTIUM_II_XEON_PROCESSOR = 16,
    SMBIOS_PROCESSOR_FAMILY_PENTIUM_III_PROCESSOR = 17,
    SMBIOS_PROCESSOR_FAMILY_M1_FAMILY = 18,
    SMBIOS_PROCESSOR_FAMILY_M2_FAMILY = 19,
    SMBIOS_PROCESSOR_FAMILY_INTEL_CELERON_M_PROCESSOR = 20,
    SMBIOS_PROCESSOR_FAMILY_INTEL_PENTIUM_4_HT_PROCESSOR = 21,
    SMBIOS_PROCESSOR_FAMILY_INTEL_PROCESSOR = 22,
    // 23 - Available for assignment
    SMBIOS_PROCESSOR_FAMILY_AMD_DURON_PROCESSOR_FAMILY = 24,
    SMBIOS_PROCESSOR_FAMILY_K5_FAMILY = 25,
    SMBIOS_PROCESSOR_FAMILY_K6_FAMILY = 26,
    SMBIOS_PROCESSOR_FAMILY_K6_2 = 27,
    SMBIOS_PROCESSOR_FAMILY_K6_3 = 28,
    SMBIOS_PROCESSOR_FAMILY_AMD_ATHLON_PROCESSOR_FAMILY = 29,
    SMBIOS_PROCESSOR_FAMILY_AMD29000_FAMILY = 30,
    SMBIOS_PROCESSOR_FAMILY_K6_2_PLUS = 31,
    SMBIOS_PROCESSOR_FAMILY_POWER_PC_FAMILY = 32,
    SMBIOS_PROCESSOR_FAMILY_POWER_PC_601 = 33,
    SMBIOS_PROCESSOR_FAMILY_POWER_PC_603 = 34,
    SMBIOS_PROCESSOR_FAMILY_POWER_PC_603_PLUS = 35,
    SMBIOS_PROCESSOR_FAMILY_POWER_PC_604 = 36,
    SMBIOS_PROCESSOR_FAMILY_POWER_PC_620 = 37,
    SMBIOS_PROCESSOR_FAMILY_POWER_PC_X704 = 38,
    SMBIOS_PROCESSOR_FAMILY_POWER_PC_750 = 39,
    SMBIOS_PROCESSOR_FAMILY_INTEL_CORE_DUO_PROCESSOR = 40,
    SMBIOS_PROCESSOR_FAMILY_INTEL_CORE_DUO_MOBILE_PROCESSOR = 41,
    SMBIOS_PROCESSOR_FAMILY_INTEL_CORE_SOLO_MOBILE_PROCESSOR = 42,
    SMBIOS_PROCESSOR_FAMILY_INTEL_ATOM_PROCESSOR = 43,
    SMBIOS_PROCESSOR_FAMILY_INTEL_CORE_M_PROCESSOR = 44,
    SMBIOS_PROCESSOR_FAMILY_INTEL_CORE_M3_PROCESSOR = 45,
    SMBIOS_PROCESSOR_FAMILY_INTEL_CORE_M5_PROCESSOR = 46,
    SMBIOS_PROCESSOR_FAMILY_INTEL_CORE_M7_PROCESSOR = 47,
    SMBIOS_PROCESSOR_FAMILY_ALPHA_FAMILY = 48,
    SMBIOS_PROCESSOR_FAMILY_ALPHA_21064 = 49,
    SMBIOS_PROCESSOR_FAMILY_ALPHA_21066 = 50,
    SMBIOS_PROCESSOR_FAMILY_ALPHA_21164 = 51,
    SMBIOS_PROCESSOR_FAMILY_ALPHA_21164PC = 52,
    SMBIOS_PROCESSOR_FAMILY_ALPHA_21164A = 53,
    SMBIOS_PROCESSOR_FAMILY_ALPHA_21264 = 54,
    SMBIOS_PROCESSOR_FAMILY_ALPHA_21364 = 55,
    SMBIOS_PROCESSOR_FAMILY_AMD_TURION_II_ULTRA_DUAL_CORE_MOBILE_M_PROCESSOR_FAMILY = 56,
    SMBIOS_PROCESSOR_FAMILY_AMD_TURION_II_DUAL_CORE_MOBILE_M_PROCESSOR_FAMILY = 57,
    SMBIOS_PROCESSOR_FAMILY_AMD_ATHLON_II_DUAL_CORE_M_PROCESSOR_FAMILY = 58,
    SMBIOS_PROCESSOR_FAMILY_AMD_OPTERON_6100_SERIES_PROCESSOR = 59,
    SMBIOS_PROCESSOR_FAMILY_AMD_OPTERON_4100_SERIES_PROCESSOR = 60,
    SMBIOS_PROCESSOR_FAMILY_AMD_OPTERON_6200_SERIES_PROCESSOR = 61,
    SMBIOS_PROCESSOR_FAMILY_AMD_OPTERON_4200_SERIES_PROCESSOR = 62,
    SMBIOS_PROCESSOR_FAMILY_AMD_FX_SERIES_PROCESSOR = 63,
    SMBIOS_PROCESSOR_FAMILY_MIPS_FAMILY = 64,
    SMBIOS_PROCESSOR_FAMILY_MIPS_R4000 = 65,
    SMBIOS_PROCESSOR_FAMILY_MIPS_R4200 = 66,
    SMBIOS_PROCESSOR_FAMILY_MIPS_R4400 = 67,
    SMBIOS_PROCESSOR_FAMILY_MIPS_R4600 = 68,
    SMBIOS_PROCESSOR_FAMILY_MIPS_R10000 = 69,
    SMBIOS_PROCESSOR_FAMILY_AMD_C_SERIES_PROCESSOR = 70,
    SMBIOS_PROCESSOR_FAMILY_AMD_E_SERIES_PROCESSOR = 71,
    SMBIOS_PROCESSOR_FAMILY_AMD_A_SERIES_PROCESSOR = 72,
    SMBIOS_PROCESSOR_FAMILY_AMD_G_SERIES_PROCESSOR = 73,
    SMBIOS_PROCESSOR_FAMILY_AMD_Z_SERIES_PROCESSOR = 74,
    SMBIOS_PROCESSOR_FAMILY_AMD_R_SERIES_PROCESSOR = 75,
    SMBIOS_PROCESSOR_FAMILY_AMD_OPTERON_4300_SERIES_PROCESSOR = 76,
    SMBIOS_PROCESSOR_FAMILY_AMD_OPTERON_6300_SERIES_PROCESSOR = 77,
    SMBIOS_PROCESSOR_FAMILY_AMD_OPTERON_3300_SERIES_PROCESSOR = 78,
    SMBIOS_PROCESSOR_FAMILY_AMD_FIREPRO_SERIES_PROCESSOR = 79,
    SMBIOS_PROCESSOR_FAMILY_SPARC_FAMILY = 80,
    SMBIOS_PROCESSOR_FAMILY_SUPERSPARC = 81,
    SMBIOS_PROCESSOR_FAMILY_MICROSPARC_II = 82,
    SMBIOS_PROCESSOR_FAMILY_MICROSPARC_IIep = 83,
    SMBIOS_PROCESSOR_FAMILY_ULTRASPARC = 84,
    SMBIOS_PROCESSOR_FAMILY_ULTRASPARC_II = 85,
    SMBIOS_PROCESSOR_FAMILY_ULTRASPARC_Iii = 86,
    SMBIOS_PROCESSOR_FAMILY_ULTRASPARC_III = 87,
    SMBIOS_PROCESSOR_FAMILY_ULTRASPARC_IIIi = 88,
    // 89-95 - Available for assignment
    SMBIOS_PROCESSOR_FAMILY_68040_FAMILY = 96,
    SMBIOS_PROCESSOR_FAMILY_68XXX = 97,
    SMBIOS_PROCESSOR_FAMILY_68000 = 98,
    SMBIOS_PROCESSOR_FAMILY_68010 = 99,
    SMBIOS_PROCESSOR_FAMILY_68020 = 100,
    SMBIOS_PROCESSOR_FAMILY_68030 = 101,
    SMBIOS_PROCESSOR_FAMILY_AMD_ATHLON_X4_QUAD_CORE_PROCESSOR_FAMILY = 102,
    SMBIOS_PROCESSOR_FAMILY_AMD_OPTERON_X1000_SERIES_PROCESSOR = 103,
    SMBIOS_PROCESSOR_FAMILY_AMD_OPTERON_X2000_SERIES_APU = 104,
    SMBIOS_PROCESSOR_FAMILY_AMD_OPTERON_A_SERIES_PROCESSOR = 105,
    SMBIOS_PROCESSOR_FAMILY_AMD_OPTERON_X3000_SERIES_APU = 106,
    SMBIOS_PROCESSOR_FAMILY_AMD_ZEN_PROCESSOR_FAMILY = 107,
    // 108-111 - Available for assignment
    SMBIOS_PROCESSOR_FAMILY_HOBBIT_FAMILY = 112,
    // 113-119 - Available for assignment
    SMBIOS_PROCESSOR_FAMILY_CRUSOE_TM5000_FAMILY = 120,
    SMBIOS_PROCESSOR_FAMILY_CRUSOE_TM3000_FAMILY = 121,
    SMBIOS_PROCESSOR_FAMILY_EFFICEON_TM8000_FAMILY = 122,
    // 123-127 - Available for assignment
    SMBIOS_PROCESSOR_FAMILY_WEITEK = 128,
    // 129 - Available for assignment
    SMBIOS_PROCESSOR_FAMILY_ITANIUM_PROCESSOR = 130,
    SMBIOS_PROCESSOR_FAMILY_AMD_ATHLON_64_PROCESSOR_FAMILY = 131,
    SMBIOS_PROCESSOR_FAMILY_AMD_OPTERON_PROCESSOR_FAMILY = 132,
    SMBIOS_PROCESSOR_FAMILY_AMD_SEMPRON_PROCESSOR_FAMILY = 133,
    SMBIOS_PROCESSOR_FAMILY_AMD_TURION_64_MOBILE_TECHNOLOGY = 134,
    SMBIOS_PROCESSOR_FAMILY_DUAL_CORE_AMD_OPTERON_PROCESSOR_FAMILY = 135,
    SMBIOS_PROCESSOR_FAMILY_AMD_ATHLON_64_X2_DUAL_CORE_PROCESSOR_FAMILY = 136,
    SMBIOS_PROCESSOR_FAMILY_AMD_TURION_64_X2_MOBILE_TECHNOLOGY = 137,
    SMBIOS_PROCESSOR_FAMILY_QUAD_CORE_AMD_OPTERON_PROCESSOR_FAMILY = 138,
    SMBIOS_PROCESSOR_FAMILY_THIRD_GENERATION_AMD_OPTERON_PROCESSOR_FAMILY = 139,
    SMBIOS_PROCESSOR_FAMILY_AMD_PHENOM_FX_QUAD_CORE_PROCESSOR_FAMILY = 140,
    SMBIOS_PROCESSOR_FAMILY_AMD_PHENOM_X4_QUAD_CORE_PROCESSOR_FAMILY = 141,
    SMBIOS_PROCESSOR_FAMILY_AMD_PHENOM_X2_DUAL_CORE_PROCESSOR_FAMILY = 142,
    SMBIOS_PROCESSOR_FAMILY_AMD_ATHLON_X2_DUAL_CORE_PROCESSOR_FAMILY = 143,
    SMBIOS_PROCESSOR_FAMILY_PA_RISC_FAMILY = 144,
    SMBIOS_PROCESSOR_FAMILY_PA_RISC_8500 = 145,
    SMBIOS_PROCESSOR_FAMILY_PA_RISC_8000 = 146,
    SMBIOS_PROCESSOR_FAMILY_PA_RISC_7300LC = 147,
    SMBIOS_PROCESSOR_FAMILY_PA_RISC_7200 = 148,
    SMBIOS_PROCESSOR_FAMILY_PA_RISC_7100LC = 149,
    SMBIOS_PROCESSOR_FAMILY_PA_RISC_7100 = 150,
    // 151-159 - Available for assignment
    SMBIOS_PROCESSOR_FAMILY_V30_FAMILY = 160,
    SMBIOS_PROCESSOR_FAMILY_QUAD_CORE_INTEL_XEON_PROCESSOR_3200_SERIES = 161,
    SMBIOS_PROCESSOR_FAMILY_DUAL_CORE_INTEL_XEON_PROCESSOR_3000_SERIES = 162,
    SMBIOS_PROCESSOR_FAMILY_QUAD_CORE_INTEL_XEON_PROCESSOR_5300_SERIES = 163,
    SMBIOS_PROCESSOR_FAMILY_DUAL_CORE_INTEL_XEON_PROCESSOR_5100_SERIES = 164,
    SMBIOS_PROCESSOR_FAMILY_DUAL_CORE_INTEL_XEON_PROCESSOR_5000_SERIES = 165,
    SMBIOS_PROCESSOR_FAMILY_DUAL_CORE_INTEL_XEON_PROCESSOR_LV = 166,
    SMBIOS_PROCESSOR_FAMILY_DUAL_CORE_INTEL_XEON_PROCESSOR_ULV = 167,
    SMBIOS_PROCESSOR_FAMILY_DUAL_CORE_INTEL_XEON_PROCESSOR_7100_SERIES = 168,
    SMBIOS_PROCESSOR_FAMILY_QUAD_CORE_INTEL_XEON_PROCESSOR_5400_SERIES = 169,
    SMBIOS_PROCESSOR_FAMILY_QUAD_CORE_INTEL_XEON_PROCESSOR = 170,
    SMBIOS_PROCESSOR_FAMILY_DUAL_CORE_INTEL_XEON_PROCESSOR_5200_SERIES = 171,
    SMBIOS_PROCESSOR_FAMILY_DUAL_CORE_INTEL_XEON_PROCESSOR_7200_SERIES = 172,
    SMBIOS_PROCESSOR_FAMILY_QUAD_CORE_INTEL_XEON_PROCESSOR_7300_SERIES = 173,
    SMBIOS_PROCESSOR_FAMILY_QUAD_CORE_INTEL_XEON_PROCESSOR_7400_SERIES = 174,
    SMBIOS_PROCESSOR_FAMILY_MULTI_CORE_INTEL_XEON_PROCESSOR_7400_SERIES = 175,
    SMBIOS_PROCESSOR_FAMILY_PENTIUM_III_XEON_PROCESSOR = 176,
    SMBIOS_PROCESSOR_FAMILY_PENTIUM_III_PROCESSOR_WITH_INTEL_SPEEDSTEP_TECHNOLOGY = 177,
    SMBIOS_PROCESSOR_FAMILY_PENTIUM_4_PROCESSOR = 178,
    SMBIOS_PROCESSOR_FAMILY_INTEL_XEON_PROCESSOR = 179,
    SMBIOS_PROCESSOR_FAMILY_AS400_FAMILY = 180,
    SMBIOS_PROCESSOR_FAMILY_INTEL_XEON_PROCESSOR_MP = 181,
    SMBIOS_PROCESSOR_FAMILY_AMD_ATHLON_XP_PROCESSOR_FAMILY = 182,
    SMBIOS_PROCESSOR_FAMILY_AMD_ATHLON_MP_PROCESSOR_FAMILY = 183,
    SMBIOS_PROCESSOR_FAMILY_INTEL_ITANIUM_2_PROCESSOR = 184,
    SMBIOS_PROCESSOR_FAMILY_INTEL_PENTIUM_M_PROCESSOR = 185,
    SMBIOS_PROCESSOR_FAMILY_INTEL_CELERON_D_PROCESSOR = 186,
    SMBIOS_PROCESSOR_FAMILY_INTEL_PENTIUM_D_PROCESSOR = 187,
    SMBIOS_PROCESSOR_FAMILY_INTEL_PENTIUM_PROCESSOR_EXTREME_EDITION = 188,
    SMBIOS_PROCESSOR_FAMILY_INTEL_CORE_SOLO_PROCESSOR = 189,
    SMBIOS_PROCESSOR_FAMILY_RESERVED = 190,
    SMBIOS_PROCESSOR_FAMILY_INTEL_CORE_2_DUO_PROCESSOR = 191,
    SMBIOS_PROCESSOR_FAMILY_INTEL_CORE_2_SOLO_PROCESSOR = 192,
    SMBIOS_PROCESSOR_FAMILY_INTEL_CORE_2_EXTREME_PROCESSOR = 193,
    SMBIOS_PROCESSOR_FAMILY_INTEL_CORE_2_QUAD_PROCESSOR = 194,
    SMBIOS_PROCESSOR_FAMILY_INTEL_CORE_2_EXTREME_MOBILE_PROCESSOR = 195,
    SMBIOS_PROCESSOR_FAMILY_INTEL_CORE_2_DUO_MOBILE_PROCESSOR = 196,
    SMBIOS_PROCESSOR_FAMILY_INTEL_CORE_2_SOLO_MOBILE_PROCESSOR = 197,
    SMBIOS_PROCESSOR_FAMILY_INTEL_CORE_I7_PROCESSOR = 198,
    SMBIOS_PROCESSOR_FAMILY_DUAL_CORE_INTEL_CELERO_PROCESSOR = 199,
    SMBIOS_PROCESSOR_FAMILY_IBM390_FAMILY = 200,
    SMBIOS_PROCESSOR_FAMILY_G4 = 201,
    SMBIOS_PROCESSOR_FAMILY_G5 = 202,
    SMBIOS_PROCESSOR_FAMILY_ESA_390_G6 = 203,
    SMBIOS_PROCESSOR_FAMILY_Z_ARCHITECTURE_BASE = 204,
    SMBIOS_PROCESSOR_FAMILY_INTEL_CORE_I5_PROCESSOR = 205,
    SMBIOS_PROCESSOR_FAMILY_INTEL_CORE_I3_PROCESSOR = 206,
    SMBIOS_PROCESSOR_FAMILY_INTEL_CORE_I9_PROCESSOR = 207,
    SMBIOS_PROCESSOR_FAMILY_INTEL_XEON_D_PROCESSOR_FAMILY = 208,
    // 209 - Available for assignment
    SMBIOS_PROCESSOR_FAMILY_VIA_C7_M_PROCESSOR_FAMILY = 210,
    SMBIOS_PROCESSOR_FAMILY_VIA_C7_D_PROCESSOR_FAMILY = 211,
    SMBIOS_PROCESSOR_FAMILY_VIA_C7_PROCESSOR_FAMILY = 212,
    SMBIOS_PROCESSOR_FAMILY_VIA_EDEN_PROCESSOR_FAMILY = 213,
    SMBIOS_PROCESSOR_FAMILY_MULTI_CORE_INTEL_XEON_PROCESSOR = 214,
    SMBIOS_PROCESSOR_FAMILY_DUAL_CORE_INTEL_XEON_PROCESSOR_3XXX_SERIES = 215,
    SMBIOS_PROCESSOR_FAMILY_QUAD_CORE_INTEL_XEON_PROCESSOR_3XXX_SERIES = 216,
    SMBIOS_PROCESSOR_FAMILY_VIA_NANO_PROCESSOR_FAMILY = 217,
    SMBIOS_PROCESSOR_FAMILY_DUAL_CORE_INTEL_XEON_PROCESSOR_5XXX_SERIES = 218,
    SMBIOS_PROCESSOR_FAMILY_QUAD_CORE_INTEL_XEON_PROCESSOR_5XXX_SERIES = 219,
    // 220 - Available for assignment
    SMBIOS_PROCESSOR_FAMILY_DUAL_CORE_INTEL_XEON_PROCESSOR_7XXX_SERIES = 221,
    SMBIOS_PROCESSOR_FAMILY_QUAD_CORE_INTEL_XEON_PROCESSOR_7XXX_SERIES = 222,
    SMBIOS_PROCESSOR_FAMILY_MULTI_CORE_INTEL_XEON_PROCESSOR_7XXX_SERIES = 223,
    SMBIOS_PROCESSOR_FAMILY_MULTI_CORE_INTEL_XEON_PROCESSOR_3400_SERIES = 224,
    // 225-227 - Available for assignment
    SMBIOS_PROCESSOR_FAMILY_AMD_OPTERON_3000_SERIES_PROCESSOR = 228,
    SMBIOS_PROCESSOR_FAMILY_AMD_SEMPRON_II_PROCESSOR = 229,
    SMBIOS_PROCESSOR_FAMILY_EMBEDDED_AMD_OPTERON_QUAD_CORE_PROCESSOR_FAMILY = 230,
    SMBIOS_PROCESSOR_FAMILY_AMD_PHENOM_TRIPLE_CORE_PROCESSOR_FAMILY = 231,
    SMBIOS_PROCESSOR_FAMILY_AMD_TURION_ULTRA_DUAL_CORE_MOBILE_PROCESSOR_FAMILY = 232,
    SMBIOS_PROCESSOR_FAMILY_AMD_TURION_DUAL_CORE_MOBILE_PROCESSOR_FAMILY = 233,
    SMBIOS_PROCESSOR_FAMILY_AMD_ATHLON_DUAL_CORE_PROCESSOR_FAMILY = 234,
    SMBIOS_PROCESSOR_FAMILY_AMD_SEMPRON_SI_PROCESSOR_FAMILY = 235,
    SMBIOS_PROCESSOR_FAMILY_AMD_PHENOM_II_PROCESSOR_FAMILY = 236,
    SMBIOS_PROCESSOR_FAMILY_AMD_ATHLON_II_PROCESSOR_FAMILY = 237,
    SMBIOS_PROCESSOR_FAMILY_SIX_CORE_AMD_OPTERON_PROCESSOR_FAMILY = 238,
    SMBIOS_PROCESSOR_FAMILY_AMD_SEMPRON_M_PROCESSOR_FAMILY = 239,
    // 240-249 - Available for assignment
    SMBIOS_PROCESSOR_FAMILY_I860 = 250,
    SMBIOS_PROCESSOR_FAMILY_I960 = 251,
    // 252-253 - Available for assignment
    SMBIOS_PROCESSOR_FAMILY_USE_2ND_FIELD = 254,
    // 255 RESERVED
    // 256-511 - Available for assignment, except for:
    SMBIOS_PROCESSOR_FAMILY_ARMV7 = 256,
    SMBIOS_PROCESSOR_FAMILY_ARMV8 = 257,
    SMBIOS_PROCESSOR_FAMILY_ARMV9 = 258,
    // 259 - Reserved for future use by ARM
    SMBIOS_PROCESSOR_FAMILY_SH_3 = 260,
    SMBIOS_PROCESSOR_FAMILY_SH_4 = 261,
    SMBIOS_PROCESSOR_FAMILY_ARM = 280,
    SMBIOS_PROCESSOR_FAMILY_STRONGARM = 281,
    SMBIOS_PROCESSOR_FAMILY_6X86 = 300,
    SMBIOS_PROCESSOR_FAMILY_MEDIAGX = 301,
    SMBIOS_PROCESSOR_FAMILY_MII = 302,
    SMBIOS_PROCESSOR_FAMILY_WINCHIP = 320,
    SMBIOS_PROCESSOR_FAMILY_DSP = 350,
    SMBIOS_PROCESSOR_FAMILY_VIDEO_PROCESSOR = 500,
    // 512-767 - Available for assignment, except for:
    SMBIOS_PROCESSOR_FAMILY_RISC_V_RV32 = 512,
    SMBIOS_PROCESSOR_FAMILY_RISC_V_RV64 = 513,
    SMBIOS_PROCESSOR_FAMILY_RISC_V_RV128 = 514,
    SMBIOS_PROCESSOR_FAMILY_LOONGARCH = 600,
    SMBIOS_PROCESSOR_FAMILY_LOONGSON_1_PROCESSOR_FAMILY = 601,
    SMBIOS_PROCESSOR_FAMILY_LOONGSON_2_PROCESSOR_FAMILY = 602,
    SMBIOS_PROCESSOR_FAMILY_LOONGSON_3_PROCESSOR_FAMILY = 603,
    SMBIOS_PROCESSOR_FAMILY_LOONGSON_2K_PROCESSOR_FAMILY = 604,
    SMBIOS_PROCESSOR_FAMILY_LOONGSON_3A_PROCESSOR_FAMILY = 605,
    SMBIOS_PROCESSOR_FAMILY_LOONGSON_3B_PROCESSOR_FAMILY = 606,
    SMBIOS_PROCESSOR_FAMILY_LOONGSON_3C_PROCESSOR_FAMILY = 607,
    SMBIOS_PROCESSOR_FAMILY_LOONGSON_3D_PROCESSOR_FAMILY = 608,
    SMBIOS_PROCESSOR_FAMILY_LOONGSON_3E_PROCESSOR_FAMILY = 609,
    SMBIOS_PROCESSOR_FAMILY_DUAL_CORE_LOONGSON_2K_PROCESSOR_2XXX_SERIES = 610,
    SMBIOS_PROCESSOR_FAMILY_QUAD_CORE_LOONGSON_3A_PROCESSOR_5XXX_SERIES = 620,
    SMBIOS_PROCESSOR_FAMILY_MULTI_CORE_LOONGSON_3A_PROCESSOR_5XXX_SERIES = 621,
    SMBIOS_PROCESSOR_FAMILY_QUAD_CORE_LOONGSON_3B_PROCESSOR_5XXX_SERIES = 622,
    SMBIOS_PROCESSOR_FAMILY_MULTI_CORE_LOONGSON_3B_PROCESSOR_5XXX_SERIES = 623,
    SMBIOS_PROCESSOR_FAMILY_MULTI_CORE_LOONGSON_3C_PROCESSOR_5XXX_SERIES = 624,
    SMBIOS_PROCESSOR_FAMILY_MULTI_CORE_LOONGSON_3D_PROCESSOR_5XXX_SERIES = 625,
    // 768-1023 - Available for assignment, except for:
    SMBIOS_PROCESSOR_FAMILY_INTEL_CORE_3 = 768,
    SMBIOS_PROCESSOR_FAMILY_INTEL_CORE_5 = 769,
    SMBIOS_PROCESSOR_FAMILY_INTEL_CORE_7 = 770,
    SMBIOS_PROCESSOR_FAMILY_INTEL_CORE_9 = 771,
    SMBIOS_PROCESSOR_FAMILY_INTEL_CORE_ULTRA_3 = 772,
    SMBIOS_PROCESSOR_FAMILY_INTEL_CORE_ULTRA_5 = 773,
    SMBIOS_PROCESSOR_FAMILY_INTEL_CORE_ULTRA_7 = 774,
    SMBIOS_PROCESSOR_FAMILY_INTEL_CORE_ULTRA_9 = 775,
    // 1024-65533 - Available for assignment
    // 65534–65535 - RESERVED
};

enum SMBIOS_PROCESSOR_STATUS
{
    SMBIOS_PROCESSOR_STATUS_UNKNOWN = 0,
    SMBIOS_PROCESSOR_STATUS_ENABLED = 1,
    SMBIOS_PROCESSOR_STATUS_DISABLED_BY_USER = 2,
    SMBIOS_PROCESSOR_STATUS_DISABLED_BY_FIRMWARE = 3,
    SMBIOS_PROCESSOR_STATUS_IDLE = 4,
    SMBIOS_PROCESSOR_STATUS_RESERVED_5 = 5,
    SMBIOS_PROCESSOR_STATUS_RESERVED_6 = 6,
    SMBIOS_PROCESSOR_STATUS_OTHER = 7,
};

enum SMBIOS_PROCESSOR_UPGRADE
{
    SMBIOS_PROCESSOR_UPGRADE_OTHER = 1,
    SMBIOS_PROCESSOR_UPGRADE_UNKNOWN = 2,
    SMBIOS_PROCESSOR_UPGRADE_DAUGHTER_BOARD = 3,
    SMBIOS_PROCESSOR_UPGRADE_ZIF_SOCKET = 4,
    SMBIOS_PROCESSOR_UPGRADE_REPLACEABLE_PIGGY_BACK = 5,
    SMBIOS_PROCESSOR_UPGRADE_NONE = 6,
    SMBIOS_PROCESSOR_UPGRADE_LIF_SOCKET = 7,
    SMBIOS_PROCESSOR_UPGRADE_SLOT_1 = 8,
    SMBIOS_PROCESSOR_UPGRADE_SLOT_2 = 9,
    SMBIOS_PROCESSOR_UPGRADE_370_PIN_SOCKET = 10,
    SMBIOS_PROCESSOR_UPGRADE_SLOT_A = 11,
    SMBIOS_PROCESSOR_UPGRADE_SLOT_M = 12,
    SMBIOS_PROCESSOR_UPGRADE_SOCKET_423 = 13,
    SMBIOS_PROCESSOR_UPGRADE_SOCKET_A = 14, // (Socket 462)
    SMBIOS_PROCESSOR_UPGRADE_SOCKET_478 = 15,
    SMBIOS_PROCESSOR_UPGRADE_SOCKET_754 = 16,
    SMBIOS_PROCESSOR_UPGRADE_SOCKET_940 = 17,
    SMBIOS_PROCESSOR_UPGRADE_SOCKET_939 = 18,
    SMBIOS_PROCESSOR_UPGRADE_SOCKET_MPGA604 = 19,
    SMBIOS_PROCESSOR_UPGRADE_SOCKET_LGA771 = 20,
    SMBIOS_PROCESSOR_UPGRADE_SOCKET_LGA775 = 21,
    SMBIOS_PROCESSOR_UPGRADE_SOCKET_S1 = 22,
    SMBIOS_PROCESSOR_UPGRADE_SOCKET_AM2 = 23,
    SMBIOS_PROCESSOR_UPGRADE_SOCKET_F = 24, // (1207)
    SMBIOS_PROCESSOR_UPGRADE_SOCKET_LGA1366 = 25,
    SMBIOS_PROCESSOR_UPGRADE_SOCKET_G34 = 26,
    SMBIOS_PROCESSOR_UPGRADE_SOCKET_AM3 = 27,
    SMBIOS_PROCESSOR_UPGRADE_SOCKET_C32 = 28,
    SMBIOS_PROCESSOR_UPGRADE_SOCKET_LGA1156 = 29,
    SMBIOS_PROCESSOR_UPGRADE_SOCKET_LGA1567 = 30,
    SMBIOS_PROCESSOR_UPGRADE_SOCKET_PGA988A = 31,
    SMBIOS_PROCESSOR_UPGRADE_SOCKET_BGA1288 = 32,
    SMBIOS_PROCESSOR_UPGRADE_SOCKET_RPGA988B = 33,
    SMBIOS_PROCESSOR_UPGRADE_SOCKET_BGA1023 = 34,
    SMBIOS_PROCESSOR_UPGRADE_SOCKET_BGA1224 = 35,
    SMBIOS_PROCESSOR_UPGRADE_SOCKET_LGA1155 = 36,
    SMBIOS_PROCESSOR_UPGRADE_SOCKET_LGA1356 = 37,
    SMBIOS_PROCESSOR_UPGRADE_SOCKET_LGA2011 = 38,
    SMBIOS_PROCESSOR_UPGRADE_SOCKET_FS1 = 39,
    SMBIOS_PROCESSOR_UPGRADE_SOCKET_FS2 = 40,
    SMBIOS_PROCESSOR_UPGRADE_SOCKET_FM1 = 41,
    SMBIOS_PROCESSOR_UPGRADE_SOCKET_FM2 = 42,
    SMBIOS_PROCESSOR_UPGRADE_SOCKET_LGA2011_3 = 43,
    SMBIOS_PROCESSOR_UPGRADE_SOCKET_LGA1356_3 = 44,
    SMBIOS_PROCESSOR_UPGRADE_SOCKET_LGA1150 = 45,
    SMBIOS_PROCESSOR_UPGRADE_SOCKET_BGA1168 = 46,
    SMBIOS_PROCESSOR_UPGRADE_SOCKET_BGA1234 = 47,
    SMBIOS_PROCESSOR_UPGRADE_SOCKET_BGA1364 = 48,
    SMBIOS_PROCESSOR_UPGRADE_SOCKET_AM4 = 49,
    SMBIOS_PROCESSOR_UPGRADE_SOCKET_LGA1151 = 50,
    SMBIOS_PROCESSOR_UPGRADE_SOCKET_BGA1356 = 51,
    SMBIOS_PROCESSOR_UPGRADE_SOCKET_BGA1440 = 52,
    SMBIOS_PROCESSOR_UPGRADE_SOCKET_BGA1515 = 53,
    SMBIOS_PROCESSOR_UPGRADE_SOCKET_LGA3647_1 = 54,
    SMBIOS_PROCESSOR_UPGRADE_SOCKET_SP3 = 55,
    SMBIOS_PROCESSOR_UPGRADE_SOCKET_SP3R2 = 56,
    SMBIOS_PROCESSOR_UPGRADE_SOCKET_LGA2066 = 57,
    SMBIOS_PROCESSOR_UPGRADE_SOCKET_BGA1392 = 58,
    SMBIOS_PROCESSOR_UPGRADE_SOCKET_BGA1510 = 59,
    SMBIOS_PROCESSOR_UPGRADE_SOCKET_BGA1528 = 60,
    SMBIOS_PROCESSOR_UPGRADE_SOCKET_LGA4189 = 61,
    SMBIOS_PROCESSOR_UPGRADE_SOCKET_LGA1200 = 62,
    SMBIOS_PROCESSOR_UPGRADE_SOCKET_LGA4677 = 63,
    SMBIOS_PROCESSOR_UPGRADE_SOCKET_LGA1700 = 64,
    SMBIOS_PROCESSOR_UPGRADE_SOCKET_BGA1744 = 65,
    SMBIOS_PROCESSOR_UPGRADE_SOCKET_BGA1781 = 66,
    SMBIOS_PROCESSOR_UPGRADE_SOCKET_BGA1211 = 67,
    SMBIOS_PROCESSOR_UPGRADE_SOCKET_BGA2422 = 68,
    SMBIOS_PROCESSOR_UPGRADE_SOCKET_LGA1211 = 69,
    SMBIOS_PROCESSOR_UPGRADE_SOCKET_LGA2422 = 70,
    SMBIOS_PROCESSOR_UPGRADE_SOCKET_LGA5773 = 71,
    SMBIOS_PROCESSOR_UPGRADE_SOCKET_BGA5773 = 72,
    SMBIOS_PROCESSOR_UPGRADE_SOCKET_AM5 = 73,
    SMBIOS_PROCESSOR_UPGRADE_SOCKET_SP5 = 74,
    SMBIOS_PROCESSOR_UPGRADE_SOCKET_SP6 = 75,
    SMBIOS_PROCESSOR_UPGRADE_SOCKET_BGA883 = 76,
    SMBIOS_PROCESSOR_UPGRADE_SOCKET_BGA1190 = 77,
    SMBIOS_PROCESSOR_UPGRADE_SOCKET_BGA4129 = 78,
    SMBIOS_PROCESSOR_UPGRADE_SOCKET_LGA4710 = 79,
    SMBIOS_PROCESSOR_UPGRADE_SOCKET_LGA7529 = 80,
    SMBIOS_PROCESSOR_UPGRADE_SOCKET_BGA1964 = 81,
    SMBIOS_PROCESSOR_UPGRADE_SOCKET_BGA1792 = 82,
    SMBIOS_PROCESSOR_UPGRADE_SOCKET_BGA2049 = 83,
    SMBIOS_PROCESSOR_UPGRADE_SOCKET_BGA2551 = 84,
    SMBIOS_PROCESSOR_UPGRADE_SOCKET_LGA1851 = 85,
    SMBIOS_PROCESSOR_UPGRADE_SOCKET_BGA2114 = 86,
    SMBIOS_PROCESSOR_UPGRADE_SOCKET_BGA2833 = 87,
    SMBIOS_PROCESSOR_UPGRADE_INVALID = 255,
};

enum SMBIOS_PROCESSOR_FLAG
{
    SMBIOS_PROCESSOR_FLAG_RESERVED = ((USHORT)0x0001),
    SMBIOS_PROCESSOR_FLAG_UNKNOWN = ((USHORT)0x0002),
    SMBIOS_PROCESSOR_FLAG_64_BIT_CAPABLE = ((USHORT)0x0004),
    SMBIOS_PROCESSOR_FLAG_MILT_CORE = ((USHORT)0x0008),
    SMBIOS_PROCESSOR_FLAG_HARDWARE_THREADED = ((USHORT)0x0010),
    SMBIOS_PROCESSOR_FLAG_EXECUTE_PROTECTION = ((USHORT)0x0020),
    SMBIOS_PROCESSOR_FLAG_ENHANCED_VIRTUALIZATION = ((USHORT)0x0040),
    SMBIOS_PROCESSOR_FLAG_POWER_PERFORMANCE_CONTROL = ((USHORT)0x0080),
    SMBIOS_PROCESSOR_FLAG_128_BIT_CAPABLE = ((USHORT)0x0100),
    SMBIOS_PROCESSOR_FLAG_ARM64_SOC = ((USHORT)0x0200),
    SMBIOS_PROCESSOR_FLAG_RESERVED_2 = ((USHORT)0xFC00),
};

enum SMBIOS_MEMORY_CONTROLLER_ERROR_DETECTION
{
    SMBIOS_MEMORY_CONTROLLER_ERROR_DETECTION_OTHER = ((UCHAR)1),
    SMBIOS_MEMORY_CONTROLLER_ERROR_DETECTION_UNKNOWN = ((UCHAR)2),
    SMBIOS_MEMORY_CONTROLLER_ERROR_DETECTION_NONE = ((UCHAR)3),
    SMBIOS_MEMORY_CONTROLLER_ERROR_DETECTION_8_BIT_PARITY = ((UCHAR)4),
    SMBIOS_MEMORY_CONTROLLER_ERROR_DETECTION_32_BIT_ECC = ((UCHAR)5),
    SMBIOS_MEMORY_CONTROLLER_ERROR_DETECTION_64_BIT_ECC = ((UCHAR)6),
    SMBIOS_MEMORY_CONTROLLER_ERROR_DETECTION_128_BIT_ECC = ((UCHAR)7),
    SMBIOS_MEMORY_CONTROLLER_ERROR_DETECTION_CRC = ((UCHAR)8),
};

enum SMBIOS_MEMORY_CONTROLLER_ERROR_CORRECTION
{
    SMBIOS_MEMORY_CONTROLLER_ERROR_CORRECTION_OTHER = ((UCHAR)0x01),
    SMBIOS_MEMORY_CONTROLLER_ERROR_CORRECTION_UNKNOWN = ((UCHAR)0x02),
    SMBIOS_MEMORY_CONTROLLER_ERROR_CORRECTION_SINGLE_BIT = ((UCHAR)0x04),
    SMBIOS_MEMORY_CONTROLLER_ERROR_CORRECTION_DOUBLE_BIT = ((UCHAR)0x10),
    SMBIOS_MEMORY_CONTROLLER_ERROR_CORRECTION_SCRUBBING = ((UCHAR)0x20),
};

enum SMBIOS_MEMORY_CONTROLLER_INTERLEAVE
{
    SMBIOS_MEMORY_CONTROLLER_INTERLEAVE_OTHER = ((UCHAR)1),
    SMBIOS_MEMORY_CONTROLLER_INTERLEAVE_UNKNOWN = ((UCHAR)2),
    SMBIOS_MEMORY_CONTROLLER_INTERLEAVE_ONE_WAY = ((UCHAR)3),
    SMBIOS_MEMORY_CONTROLLER_INTERLEAVE_TWO_WAY = ((UCHAR)4),
    SMBIOS_MEMORY_CONTROLLER_INTERLEAVE_FOUR_WAY = ((UCHAR)5),
    SMBIOS_MEMORY_CONTROLLER_INTERLEAVE_EIGHT_WAY = ((UCHAR)6),
    SMBIOS_MEMORY_CONTROLLER_INTERLEAVE_SIXTEEN_WAY = ((UCHAR)7),
};

enum SMBIOS_MEMORY_CONTROLLER_SPEEDS
{
    SMBIOS_MEMORY_CONTROLLER_SPEEDS_OTHER = ((USHORT)0x0001),
    SMBIOS_MEMORY_CONTROLLER_SPEEDS_UNKNOWN = ((USHORT)0x0002),
    SMBIOS_MEMORY_CONTROLLER_SPEEDS_70NS = ((USHORT)0x0004),
    SMBIOS_MEMORY_CONTROLLER_SPEEDS_60NS = ((USHORT)0x0008),
    SMBIOS_MEMORY_CONTROLLER_SPEEDS_50NS = ((USHORT)0x0010),
    SMBIOS_MEMORY_CONTROLLER_SPEEDS_RESERVED = ((USHORT)0xFFE0),
};

enum SMBIOS_MEMORY_MDOULE_SIZE_VALUE_NOT
{
    SMBIOS_MEMORY_MDOULE_SIZE_VALUE_NOT_DETERMINABLE = ((UCHAR)0x7D),
    SMBIOS_MEMORY_MDOULE_SIZE_VALUE_NOT_ENABLED = ((UCHAR)0x7E),
    SMBIOS_MEMORY_MDOULE_SIZE_VALUE_NOT_INSTALLED = ((UCHAR)0x7F),
};

enum SMBIOS_MEMORY_MODULE_TYPE
{
    SMBIOS_MEMORY_MODULE_TYPE_OTHER = ((USHORT)0x0001),
    SMBIOS_MEMORY_MODULE_TYPE_UNKNOWN = ((USHORT)0x0002),
    SMBIOS_MEMORY_MODULE_TYPE_STANDARD = ((USHORT)0x0004),
    SMBIOS_MEMORY_MODULE_TYPE_FAST_PAGE_MODE = ((USHORT)0x0008),
    SMBIOS_MEMORY_MODULE_TYPE_EDO = ((USHORT)0x0010),
    SMBIOS_MEMORY_MODULE_TYPE_PARITY = ((USHORT)0x0020),
    SMBIOS_MEMORY_MODULE_TYPE_ECC = ((USHORT)0x0040),
    SMBIOS_MEMORY_MODULE_TYPE_SIMM = ((USHORT)0x0080),
    SMBIOS_MEMORY_MODULE_TYPE_DIMM = ((USHORT)0x0100),
    SMBIOS_MEMORY_MODULE_TYPE_BURST_EDO = ((USHORT)0x0200),
    SMBIOS_MEMORY_MODULE_TYPE_SDRAM = ((USHORT)0x0400),
    SMBIOS_MEMORY_MODULE_TYPE_RESERVED = ((USHORT)0xF800),
};

enum SMBIOS_CACHE_LOCATION
{
    SMBIOS_CACHE_LOCATION_INTERNAL = ((USHORT)0),
    SMBIOS_CACHE_LOCATION_EXTERNAL = ((USHORT)1),
    SMBIOS_CACHE_LOCATION_RESERVED = ((USHORT)2),
    SMBIOS_CACHE_LOCATION_UNKNOWN = ((USHORT)3),
};

enum SMBIOS_CACHE_MODE
{
    SMBIOS_CACHE_MODE_WRITE_THROUGH = ((USHORT)0),
    SMBIOS_CACHE_MODE_WRITE_BACK = ((USHORT)1),
    SMBIOS_CACHE_MODE_VARIES_WITH_MEMORY_ADDRESS = ((USHORT)2),
    SMBIOS_CACHE_MODE_UNKNOWN = ((USHORT)3),
};

enum SMBIOS_CACHE_SUPPORTED
{
    SMBIOS_CACHE_SUPPORTED_SRAM_OTHER = ((USHORT)0x0001),
    SMBIOS_CACHE_SUPPORTED_SRAM_UNKNOWN = ((USHORT)0x0002),
    SMBIOS_CACHE_SUPPORTED_SRAM_NON_BURST = ((USHORT)0x0004),
    SMBIOS_CACHE_SUPPORTED_SRAM_BURST = ((USHORT)0x0008),
    SMBIOS_CACHE_SUPPORTED_SRAM_PIPELINE_BURST = ((USHORT)0x0010),
    SMBIOS_CACHE_SUPPORTED_SRAM_SYNCHRONOUS = ((USHORT)0x0020),
    SMBIOS_CACHE_SUPPORTED_SRAM_ASYNCHRONOUS = ((USHORT)0x0040),
    SMBIOS_CACHE_SUPPORTED_SRAM_RESERVED = ((USHORT)0xFF80),
};

enum SMBIOS_CACHE_ERROR_CORRECTION
{
    SMBIOS_CACHE_ERROR_CORRECTION_OTHER = ((UCHAR)1),
    SMBIOS_CACHE_ERROR_CORRECTION_UNKNOWN = ((UCHAR)2),
    SMBIOS_CACHE_ERROR_CORRECTION_NONE = ((UCHAR)3),
    SMBIOS_CACHE_ERROR_CORRECTION_PARITY = ((UCHAR)4),
    SMBIOS_CACHE_ERROR_CORRECTION_SINGLE_BIT_ECC = ((UCHAR)5),
    SMBIOS_CACHE_ERROR_CORRECTION_MULTI_BIT_ECC = ((UCHAR)6),
};

enum SMBIOS_CACHE_SYSTEM_CACHE
{
    SMBIOS_CACHE_SYSTEM_CACHE_OTHER = ((UCHAR)1),
    SMBIOS_CACHE_SYSTEM_CACHE_UNKNOWN = ((UCHAR)2),
    SMBIOS_CACHE_SYSTEM_CACHE_INSTRUCTION = ((UCHAR)3),
    SMBIOS_CACHE_SYSTEM_CACHE_DATA = ((UCHAR)4),
    SMBIOS_CACHE_SYSTEM_CACHE_UNIFIED = ((UCHAR)5),
};

enum SMBIOS_CACHE_ASSOCIATIVITY
{
    SMBIOS_CACHE_ASSOCIATIVITY_OTHER = ((UCHAR)1),
    SMBIOS_CACHE_ASSOCIATIVITY_UNKNOWN = ((UCHAR)2),
    SMBIOS_CACHE_ASSOCIATIVITY_DIRECT_MAPPED = ((UCHAR)3),
    SMBIOS_CACHE_ASSOCIATIVITY_2_WAY = ((UCHAR)4),
    SMBIOS_CACHE_ASSOCIATIVITY_4_WAY = ((UCHAR)5),
    SMBIOS_CACHE_ASSOCIATIVITY_FULL = ((UCHAR)6),
    SMBIOS_CACHE_ASSOCIATIVITY_8_WAY = ((UCHAR)7),
    SMBIOS_CACHE_ASSOCIATIVITY_16_WAY = ((UCHAR)8),
    SMBIOS_CACHE_ASSOCIATIVITY_12_WAY = ((UCHAR)9),
    SMBIOS_CACHE_ASSOCIATIVITY_24_WAY = ((UCHAR)10),
    SMBIOS_CACHE_ASSOCIATIVITY_32_WAY = ((UCHAR)11),
    SMBIOS_CACHE_ASSOCIATIVITY_48_WAY = ((UCHAR)12),
    SMBIOS_CACHE_ASSOCIATIVITY_64_WAY = ((UCHAR)13),
    SMBIOS_CACHE_ASSOCIATIVITY_20_WAY = ((UCHAR)14),
};

enum SMBIOS_PORT_CONNECTOR_TYPE
{
    SMBIOS_PORT_CONNECTOR_TYPE_NONE = ((UCHAR)0),
    SMBIOS_PORT_CONNECTOR_TYPE_CENTRONICS = ((UCHAR)1),
    SMBIOS_PORT_CONNECTOR_TYPE_MINI_CENTRONICS = ((UCHAR)2),
    SMBIOS_PORT_CONNECTOR_TYPE_PROPRIETARY = ((UCHAR)3),
    SMBIOS_PORT_CONNECTOR_TYPE_DB_25_PIN_MALE = ((UCHAR)4),
    SMBIOS_PORT_CONNECTOR_TYPE_DB_25_PIN_FEMALE = ((UCHAR)5),
    SMBIOS_PORT_CONNECTOR_TYPE_DB_15_PIN_MALE = ((UCHAR)6),
    SMBIOS_PORT_CONNECTOR_TYPE_DB_15_PIN_FEMALE = ((UCHAR)7),
    SMBIOS_PORT_CONNECTOR_TYPE_DB_9_PIN_MALE = ((UCHAR)8),
    SMBIOS_PORT_CONNECTOR_TYPE_DB_9_PIN_FEMALE = ((UCHAR)9),
    SMBIOS_PORT_CONNECTOR_TYPE_RJ_11 = ((UCHAR)10),
    SMBIOS_PORT_CONNECTOR_TYPE_RJ_54 = ((UCHAR)11),
    SMBIOS_PORT_CONNECTOR_TYPE_50_PIN_MINI_SCSI = ((UCHAR)12),
    SMBIOS_PORT_CONNECTOR_TYPE_MINI_DIN = ((UCHAR)13),
    SMBIOS_PORT_CONNECTOR_TYPE_MICRO_DIN = ((UCHAR)14),
    SMBIOS_PORT_CONNECTOR_TYPE_PS2 = ((UCHAR)15),
    SMBIOS_PORT_CONNECTOR_TYPE_INFRARED = ((UCHAR)16),
    SMBIOS_PORT_CONNECTOR_TYPE_HP_HIL = ((UCHAR)17),
    SMBIOS_PORT_CONNECTOR_TYPE_USB = ((UCHAR)18),
    SMBIOS_PORT_CONNECTOR_TYPE_SSA_SCSI = ((UCHAR)19),
    SMBIOS_PORT_CONNECTOR_TYPE_CIRCULAR_DIN_8_MALE = ((UCHAR)20),
    SMBIOS_PORT_CONNECTOR_TYPE_CIRCULAR_DIN_8_FEMALE = ((UCHAR)21),
    SMBIOS_PORT_CONNECTOR_TYPE_ON_BOARD_IDE = ((UCHAR)22),
    SMBIOS_PORT_CONNECTOR_TYPE_ON_BOARD_FLOPPY = ((UCHAR)23),
    SMBIOS_PORT_CONNECTOR_TYPE_9_PIN_DIAL_INLINE = ((UCHAR)24),
    SMBIOS_PORT_CONNECTOR_TYPE_25_PIN_DIAL_INLINE = ((UCHAR)25),
    SMBIOS_PORT_CONNECTOR_TYPE_50_PIN_DIAL_INLINE = ((UCHAR)26),
    SMBIOS_PORT_CONNECTOR_TYPE_68_PIN_DIAL_INLINE = ((UCHAR)27),
    SMBIOS_PORT_CONNECTOR_TYPE_ON_BOARD_INPUT_CD_ROM = ((UCHAR)28),
    SMBIOS_PORT_CONNECTOR_TYPE_MINI_CENTRONICS_TYPE_14 = ((UCHAR)29),
    SMBIOS_PORT_CONNECTOR_TYPE_MINI_CENTRONICS_TYPE_26 = ((UCHAR)30),
    SMBIOS_PORT_CONNECTOR_TYPE_MINI_JACK = ((UCHAR)31),
    SMBIOS_PORT_CONNECTOR_TYPE_BNC = ((UCHAR)32),
    SMBIOS_PORT_CONNECTOR_TYPE_1394 = ((UCHAR)33),
    SMBIOS_PORT_CONNECTOR_TYPE_SAS_SATA = ((UCHAR)34),
    SMBIOS_PORT_CONNECTOR_TYPE_USB_TYPE_C = ((UCHAR)35),
    SMBIOS_PORT_CONNECTOR_TYPE_PC_98 = ((UCHAR)160),
    SMBIOS_PORT_CONNECTOR_TYPE_PC_98_HIRESO = ((UCHAR)161),
    SMBIOS_PORT_CONNECTOR_TYPE_PC_H98 = ((UCHAR)162),
    SMBIOS_PORT_CONNECTOR_TYPE_PC_98_NOTE = ((UCHAR)163),
    SMBIOS_PORT_CONNECTOR_TYPE_PC_98_FULL = ((UCHAR)164),
    SMBIOS_PORT_CONNECTOR_TYPE_OTHER = ((UCHAR)255),
};

enum SMBIOS_PORT_CONNECTOR_PORT_TYPE
{
    SMBIOS_PORT_CONNECTOR_PORT_TYPE_NONE = ((UCHAR)0),
    SMBIOS_PORT_CONNECTOR_PORT_TYPE_PARALLEL_XT_AT = ((UCHAR)1),
    SMBIOS_PORT_CONNECTOR_PORT_TYPE_PARALLEL_PS2 = ((UCHAR)2),
    SMBIOS_PORT_CONNECTOR_PORT_TYPE_PARALLEL_ECP = ((UCHAR)3),
    SMBIOS_PORT_CONNECTOR_PORT_TYPE_PARALLEL_EPP = ((UCHAR)4),
    SMBIOS_PORT_CONNECTOR_PORT_TYPE_PARALLEL_ECP_EPP = ((UCHAR)5),
    SMBIOS_PORT_CONNECTOR_PORT_TYPE_SERIAL_XT_AT = ((UCHAR)6),
    SMBIOS_PORT_CONNECTOR_PORT_TYPE_SERIAL_16450 = ((UCHAR)7),
    SMBIOS_PORT_CONNECTOR_PORT_TYPE_SERIAL_16550 = ((UCHAR)8),
    SMBIOS_PORT_CONNECTOR_PORT_TYPE_SERIAL_16550A = ((UCHAR)9),
    SMBIOS_PORT_CONNECTOR_PORT_TYPE_SCSI = ((UCHAR)10),
    SMBIOS_PORT_CONNECTOR_PORT_TYPE_MIDI = ((UCHAR)11),
    SMBIOS_PORT_CONNECTOR_PORT_TYPE_JOY_STICK = ((UCHAR)12),
    SMBIOS_PORT_CONNECTOR_PORT_TYPE_KEYBOARD = ((UCHAR)13),
    SMBIOS_PORT_CONNECTOR_PORT_TYPE_MOUSE = ((UCHAR)14),
    SMBIOS_PORT_CONNECTOR_PORT_TYPE_SSA_SCSI = ((UCHAR)15),
    SMBIOS_PORT_CONNECTOR_PORT_TYPE_USB = ((UCHAR)16),
    SMBIOS_PORT_CONNECTOR_PORT_TYPE_FIRE_WIRE = ((UCHAR)17),
    SMBIOS_PORT_CONNECTOR_PORT_TYPE_PCMCIA_TYPE_I = ((UCHAR)18),
    SMBIOS_PORT_CONNECTOR_PORT_TYPE_PCMCIA_TYPE_II = ((UCHAR)19),
    SMBIOS_PORT_CONNECTOR_PORT_TYPE_PCMCIA_TYPE_III = ((UCHAR)20),
    SMBIOS_PORT_CONNECTOR_PORT_TYPE_CARD_BUS = ((UCHAR)21),
    SMBIOS_PORT_CONNECTOR_PORT_TYPE_ACCESS_BUS = ((UCHAR)22),
    SMBIOS_PORT_CONNECTOR_PORT_TYPE_SCSI_II = ((UCHAR)23),
    SMBIOS_PORT_CONNECTOR_PORT_TYPE_SCSI_WIDE = ((UCHAR)24),
    SMBIOS_PORT_CONNECTOR_PORT_TYPE_PC_98 = ((UCHAR)25),
    SMBIOS_PORT_CONNECTOR_PORT_TYPE_PC_98_HIRESO = ((UCHAR)26),
    SMBIOS_PORT_CONNECTOR_PORT_TYPE_PC_98H = ((UCHAR)27),
    SMBIOS_PORT_CONNECTOR_PORT_TYPE_VIDEO = ((UCHAR)28),
    SMBIOS_PORT_CONNECTOR_PORT_TYPE_AUDIO = ((UCHAR)29),
    SMBIOS_PORT_CONNECTOR_PORT_TYPE_MODEM = ((UCHAR)30),
    SMBIOS_PORT_CONNECTOR_PORT_TYPE_NETWORK = ((UCHAR)31),
    SMBIOS_PORT_CONNECTOR_PORT_TYPE_SATA = ((UCHAR)32),
    SMBIOS_PORT_CONNECTOR_PORT_TYPE_SAS = ((UCHAR)33),
    SMBIOS_PORT_CONNECTOR_PORT_TYPE_MFDP = ((UCHAR)34),
    SMBIOS_PORT_CONNECTOR_PORT_TYPE_THUNDERBOLT = ((UCHAR)35),
    SMBIOS_PORT_CONNECTOR_PORT_TYPE_8251 = ((UCHAR)160),
    SMBIOS_PORT_CONNECTOR_PORT_TYPE_8251_FIFO = ((UCHAR)161),
    SMBIOS_PORT_CONNECTOR_PORT_TYPE_8251_OTHER = ((UCHAR)255),
};

enum SMBIOS_SYSTEM_SLOT_TYPE
{
    SMBIOS_SYSTEM_SLOT_TYPE_OTHER = ((UCHAR)1),
    SMBIOS_SYSTEM_SLOT_TYPE_UNKNOWN = ((UCHAR)2),
    SMBIOS_SYSTEM_SLOT_TYPE_ISA = ((UCHAR)3),
    SMBIOS_SYSTEM_SLOT_TYPE_MCA = ((UCHAR)4),
    SMBIOS_SYSTEM_SLOT_TYPE_EISA = ((UCHAR)5),
    SMBIOS_SYSTEM_SLOT_TYPE_PCI = ((UCHAR)6),
    SMBIOS_SYSTEM_SLOT_TYPE_PCMCIA = ((UCHAR)7),
    SMBIOS_SYSTEM_SLOT_TYPE_VL_VESA = ((UCHAR)8),
    SMBIOS_SYSTEM_SLOT_TYPE_PROPRIETARY = ((UCHAR)9),
    SMBIOS_SYSTEM_SLOT_TYPE_PROCESSOR_CARD_SLOT = ((UCHAR)10),
    SMBIOS_SYSTEM_SLOT_TYPE_PROPRIETARY_MEMORY_CARD_SLOT = ((UCHAR)11),
    SMBIOS_SYSTEM_SLOT_TYPE_IO_RISER_CARD_SLOT = ((UCHAR)12),
    SMBIOS_SYSTEM_SLOT_TYPE_NUBUS = ((UCHAR)13),
    SMBIOS_SYSTEM_SLOT_TYPE_PCI_66MHZ_CAPABLE = ((UCHAR)14),
    SMBIOS_SYSTEM_SLOT_TYPE_AGP = ((UCHAR)15),
    SMBIOS_SYSTEM_SLOT_TYPE_AGP_2X = ((UCHAR)16),
    SMBIOS_SYSTEM_SLOT_TYPE_AGP_4X = ((UCHAR)17),
    SMBIOS_SYSTEM_SLOT_TYPE_PCI_X = ((UCHAR)18),
    SMBIOS_SYSTEM_SLOT_TYPE_AGP_8X = ((UCHAR)19),
    SMBIOS_SYSTEM_SLOT_TYPE_M_2_SOCKET_1_DP_MECHANICAL_KEY_A = ((UCHAR)20),
    SMBIOS_SYSTEM_SLOT_TYPE_M_2_SOCKET_1_SD_MECHANICAL_KEY_E = ((UCHAR)21),
    SMBIOS_SYSTEM_SLOT_TYPE_M_2_SOCKET_2_MECHANICAL_KEY_B = ((UCHAR)22),
    SMBIOS_SYSTEM_SLOT_TYPE_M_2_SOCKET_3_MECHANICAL_KEY_M = ((UCHAR)23),
    SMBIOS_SYSTEM_SLOT_TYPE_MXM_TYPE_I = ((UCHAR)24),
    SMBIOS_SYSTEM_SLOT_TYPE_MXM_TYPE_II = ((UCHAR)25),
    SMBIOS_SYSTEM_SLOT_TYPE_MXM_TYPE_III_STANDARD_CONNECTOR = ((UCHAR)26),
    SMBIOS_SYSTEM_SLOT_TYPE_MXM_TYPE_III_HE_CONNECTOR = ((UCHAR)27),
    SMBIOS_SYSTEM_SLOT_TYPE_MXM_TYPE_IV = ((UCHAR)28),
    SMBIOS_SYSTEM_SLOT_TYPE_MXM_3_0_TYPE_A = ((UCHAR)29),
    SMBIOS_SYSTEM_SLOT_TYPE_MXM_3_0_TYPE_B = ((UCHAR)30),
    SMBIOS_SYSTEM_SLOT_TYPE_PCI_EXPRESS_GEN_2_SFF_8639_U_2 = ((UCHAR)31),
    SMBIOS_SYSTEM_SLOT_TYPE_PCI_EXPRESS_GEN_3_SFF_8639_U_2 = ((UCHAR)32),
    SMBIOS_SYSTEM_SLOT_TYPE_PCI_EXPRESS_MINI_52_PIN_CEM_2_0_WITH_KEEP_OUTS = ((UCHAR)33),
    SMBIOS_SYSTEM_SLOT_TYPE_PCI_EXPRESS_MINI_52_PIN_CEM_2_0_WITHOUT_KEEP_OUTS = ((UCHAR)34),
    SMBIOS_SYSTEM_SLOT_TYPE_PCI_EXPRESS_MINI_76_PIN_CEM_2_0 = ((UCHAR)35),
    SMBIOS_SYSTEM_SLOT_TYPE_PCI_EXPRESS_GEN_4_SFF_8639_U_2 = ((UCHAR)36),
    SMBIOS_SYSTEM_SLOT_TYPE_PCI_EXPRESS_GEN_5_SFF_8639_U_2 = ((UCHAR)37),
    SMBIOS_SYSTEM_SLOT_TYPE_OCP_NIC_3_0_SMALL_FORM_FACTOR_SFF = ((UCHAR)38),
    SMBIOS_SYSTEM_SLOT_TYPE_OCP_NIC_3_0_LARGE_FORM_FACTOR_LFF = ((UCHAR)39),
    SMBIOS_SYSTEM_SLOT_TYPE_OCP_NIC_PRIOR_TO_3_0 = ((UCHAR)40),
    SMBIOS_SYSTEM_SLOT_TYPE_CXL_FLEXBUS_1_0 = ((UCHAR)48),
    SMBIOS_SYSTEM_SLOT_TYPE_PC_98_C20 = ((UCHAR)160),
    SMBIOS_SYSTEM_SLOT_TYPE_PC_98_C24 = ((UCHAR)161),
    SMBIOS_SYSTEM_SLOT_TYPE_PC_98_E = ((UCHAR)162),
    SMBIOS_SYSTEM_SLOT_TYPE_PC_98_LOCAL_BUS = ((UCHAR)163),
    SMBIOS_SYSTEM_SLOT_TYPE_PC_98_CARD = ((UCHAR)164),
    SMBIOS_SYSTEM_SLOT_TYPE_PCI_EXPRESS = ((UCHAR)165),
    SMBIOS_SYSTEM_SLOT_TYPE_PCI_EXPRESS_X1 = ((UCHAR)166),
    SMBIOS_SYSTEM_SLOT_TYPE_PCI_EXPRESS_X2 = ((UCHAR)167),
    SMBIOS_SYSTEM_SLOT_TYPE_PCI_EXPRESS_X4 = ((UCHAR)168),
    SMBIOS_SYSTEM_SLOT_TYPE_PCI_EXPRESS_X8 = ((UCHAR)169),
    SMBIOS_SYSTEM_SLOT_TYPE_PCI_EXPRESS_X16 = ((UCHAR)170),
    SMBIOS_SYSTEM_SLOT_TYPE_PCI_EXPRESS_GEN_2 = ((UCHAR)171),
    SMBIOS_SYSTEM_SLOT_TYPE_PCI_EXPRESS_GEN_2_X1 = ((UCHAR)172),
    SMBIOS_SYSTEM_SLOT_TYPE_PCI_EXPRESS_GEN_2_X2 = ((UCHAR)173),
    SMBIOS_SYSTEM_SLOT_TYPE_PCI_EXPRESS_GEN_2_X4 = ((UCHAR)174),
    SMBIOS_SYSTEM_SLOT_TYPE_PCI_EXPRESS_GEN_2_X8 = ((UCHAR)175),
    SMBIOS_SYSTEM_SLOT_TYPE_PCI_EXPRESS_GEN_2_X16 = ((UCHAR)176),
    SMBIOS_SYSTEM_SLOT_TYPE_PCI_EXPRESS_GEN_3 = ((UCHAR)177),
    SMBIOS_SYSTEM_SLOT_TYPE_PCI_EXPRESS_GEN_3_X1 = ((UCHAR)178),
    SMBIOS_SYSTEM_SLOT_TYPE_PCI_EXPRESS_GEN_3_X2 = ((UCHAR)179),
    SMBIOS_SYSTEM_SLOT_TYPE_PCI_EXPRESS_GEN_3_X4 = ((UCHAR)180),
    SMBIOS_SYSTEM_SLOT_TYPE_PCI_EXPRESS_GEN_3_X8 = ((UCHAR)181),
    SMBIOS_SYSTEM_SLOT_TYPE_PCI_EXPRESS_GEN_3_X16 = ((UCHAR)182),
    SMBIOS_SYSTEM_SLOT_TYPE_PCI_EXPRESS_GEN_4 = ((UCHAR)183),
    SMBIOS_SYSTEM_SLOT_TYPE_PCI_EXPRESS_GEN_4_X1 = ((UCHAR)184),
    SMBIOS_SYSTEM_SLOT_TYPE_PCI_EXPRESS_GEN_4_X2 = ((UCHAR)185),
    SMBIOS_SYSTEM_SLOT_TYPE_PCI_EXPRESS_GEN_4_X4 = ((UCHAR)186),
    SMBIOS_SYSTEM_SLOT_TYPE_PCI_EXPRESS_GEN_4_X8 = ((UCHAR)187),
    SMBIOS_SYSTEM_SLOT_TYPE_PCI_EXPRESS_GEN_4_X16 = ((UCHAR)188),
    SMBIOS_SYSTEM_SLOT_TYPE_PCI_EXPRESS_GEN_5 = ((UCHAR)189),
    SMBIOS_SYSTEM_SLOT_TYPE_PCI_EXPRESS_GEN_5_X1 = ((UCHAR)190),
    SMBIOS_SYSTEM_SLOT_TYPE_PCI_EXPRESS_GEN_5_X2 = ((UCHAR)191),
    SMBIOS_SYSTEM_SLOT_TYPE_PCI_EXPRESS_GEN_5_X4 = ((UCHAR)192),
    SMBIOS_SYSTEM_SLOT_TYPE_PCI_EXPRESS_GEN_5_X8 = ((UCHAR)193),
    SMBIOS_SYSTEM_SLOT_TYPE_PCI_EXPRESS_GEN_5_X16 = ((UCHAR)194),
    SMBIOS_SYSTEM_SLOT_TYPE_PCI_EXPRESS_GEN_6 = ((UCHAR)195),
    SMBIOS_SYSTEM_SLOT_TYPE_EDSFF_E1_S_E1_L = ((UCHAR)196),
    SMBIOS_SYSTEM_SLOT_TYPE_EDSFF_E3_S_E3_L = ((UCHAR)197),
};

enum SMBIOS_SYSTEM_SLOT_BUS_WIDTH
{
    SMBIOS_SYSTEM_SLOT_BUS_WIDTH_OTHER = ((UCHAR)1),
    SMBIOS_SYSTEM_SLOT_BUS_WIDTH_UNKNOWN = ((UCHAR)2),
    SMBIOS_SYSTEM_SLOT_BUS_WIDTH_8_BIT = ((UCHAR)3),
    SMBIOS_SYSTEM_SLOT_BUS_WIDTH_16_BIT = ((UCHAR)4),
    SMBIOS_SYSTEM_SLOT_BUS_WIDTH_32_BIT = ((UCHAR)5),
    SMBIOS_SYSTEM_SLOT_BUS_WIDTH_64_BIT = ((UCHAR)6),
    SMBIOS_SYSTEM_SLOT_BUS_WIDTH_128_BIT = ((UCHAR)7),
    SMBIOS_SYSTEM_SLOT_BUS_WIDTH_1X_OR_1X = ((UCHAR)8),
    SMBIOS_SYSTEM_SLOT_BUS_WIDTH_2X_OR_2X = ((UCHAR)9),
    SMBIOS_SYSTEM_SLOT_BUS_WIDTH_4X_OR_4X = ((UCHAR)10),
    SMBIOS_SYSTEM_SLOT_BUS_WIDTH_8X_OR_8X = ((UCHAR)11),
    SMBIOS_SYSTEM_SLOT_BUS_WIDTH_12X_OR_12X = ((UCHAR)12),
    SMBIOS_SYSTEM_SLOT_BUS_WIDTH_16X_OR_16X = ((UCHAR)13),
    SMBIOS_SYSTEM_SLOT_BUS_WIDTH_32X_OR_32X = ((UCHAR)14),
};

enum SMBIOS_SYSTEM_SLOT_USAGE
{
    SMBIOS_SYSTEM_SLOT_USAGE_OTHER = ((UCHAR)1),
    SMBIOS_SYSTEM_SLOT_USAGE_UNKNOWN = ((UCHAR)2),
    SMBIOS_SYSTEM_SLOT_USAGE_AVAILABLE = ((UCHAR)3),
    SMBIOS_SYSTEM_SLOT_USAGE_IN_USE = ((UCHAR)4),
    SMBIOS_SYSTEM_SLOT_USAGE_UNAVAILABLE = ((UCHAR)5),
};

enum SMBIOS_SYSTEM_SLOT_LENGTH
{
    SMBIOS_SYSTEM_SLOT_LENGTH_OTHER = ((UCHAR)1),
    SMBIOS_SYSTEM_SLOT_LENGTH_UNKNOWN = ((UCHAR)2),
    SMBIOS_SYSTEM_SLOT_LENGTH_SHORT = ((UCHAR)3),
    SMBIOS_SYSTEM_SLOT_LENGTH_LONG = ((UCHAR)4),
    SMBIOS_SYSTEM_SLOT_LENGTH_2_5_DRIVE = ((UCHAR)5),
    SMBIOS_SYSTEM_SLOT_LENGTH_3_4_DRIVE = ((UCHAR)6),
};

enum SMBIOS_SYSTEM_SLOT_FLAG
{
    SMBIOS_SYSTEM_SLOT_FLAG_UNKNOWN = ((UCHAR)0x01),
    SMBIOS_SYSTEM_SLOT_FLAG_5000MV = ((UCHAR)0x02),
    SMBIOS_SYSTEM_SLOT_FLAG_3300MV = ((UCHAR)0x04),
    SMBIOS_SYSTEM_SLOT_FLAG_SHARED = ((UCHAR)0x08),
    SMBIOS_SYSTEM_SLOT_FLAG_CARD_16 = ((UCHAR)0x10),
    SMBIOS_SYSTEM_SLOT_FLAG_CARD_BUS = ((UCHAR)0x20),
    SMBIOS_SYSTEM_SLOT_FLAG_CARD_ZOOM_VIDEO = ((UCHAR)0x40),
    SMBIOS_SYSTEM_SLOT_FLAG_CARD_MODEN_RING_RESUME = ((UCHAR)0x80),
};

enum SMBIOS_SYSTEM_SLOT_FLAG_2
{
    SMBIOS_SYSTEM_SLOT_FLAG_2_PME_SIGNAL = ((UCHAR)0x01),
    SMBIOS_SYSTEM_SLOT_FLAG_2_HOT_PLUG = ((UCHAR)0x02),
    SMBIOS_SYSTEM_SLOT_FLAG_2_SMBUS_SIGNAL = ((UCHAR)0x04),
    SMBIOS_SYSTEM_SLOT_FLAG_2_PCIE_BIFURCATION = ((UCHAR)0x08),
    SMBIOS_SYSTEM_SLOT_FLAG_2_SURPRISE_REMOVAL = ((UCHAR)0x10),
    SMBIOS_SYSTEM_SLOT_FLAG_2_FLEXBUS_CLX_1 = ((UCHAR)0x20),
    SMBIOS_SYSTEM_SLOT_FLAG_2_FLEXBUS_CLX_2 = ((UCHAR)0x40),
    SMBIOS_SYSTEM_SLOT_FLAG_2_FLEXBUS_CLX_4 = ((UCHAR)0x80),
};

enum SMBIOS_SYSTEM_SLOT_HEIGHT
{
    SMBIOS_SYSTEM_SLOT_HEIGHT_NOT_APPLICABLE = ((UCHAR)0),
    SMBIOS_SYSTEM_SLOT_HEIGHT_OTHER = ((UCHAR)1),
    SMBIOS_SYSTEM_SLOT_HEIGHT_UNKNOWN = ((UCHAR)2),
    SMBIOS_SYSTEM_SLOT_HEIGHT_FULL_HEIGHT = ((UCHAR)3),
    SMBIOS_SYSTEM_SLOT_HEIGHT_LOW_PROFILE = ((UCHAR)4),
};

enum SMBIOS_ON_BOARD_DEVICE_TYPE
{
    SMBIOS_ON_BOARD_DEVICE_TYPE_OTHER = ((UCHAR)1),
    SMBIOS_ON_BOARD_DEVICE_TYPE_UNKNOWN = ((UCHAR)2),
    SMBIOS_ON_BOARD_DEVICE_TYPE_VIDEO = ((UCHAR)3),
    SMBIOS_ON_BOARD_DEVICE_TYPE_SCSI_CONTROLLER = ((UCHAR)4),
    SMBIOS_ON_BOARD_DEVICE_TYPE_ETHERNET = ((UCHAR)5),
    SMBIOS_ON_BOARD_DEVICE_TYPE_TOKEN_RING = ((UCHAR)6),
    SMBIOS_ON_BOARD_DEVICE_TYPE_SOUND = ((UCHAR)7),
    SMBIOS_ON_BOARD_DEVICE_TYPE_PATA_CONTROLLER = ((UCHAR)8),
    SMBIOS_ON_BOARD_DEVICE_TYPE_SATA_CONTROLLER = ((UCHAR)9),
    SMBIOS_ON_BOARD_DEVICE_TYPE_SAS_CONTROLLER = ((UCHAR)10),
};

enum SMBIOS_PHYSICAL_MEMORY_ARRAY_LOCATION
{
    SMBIOS_PHYSICAL_MEMORY_ARRAY_LOCATION_OTHER = ((UCHAR)1),
    SMBIOS_PHYSICAL_MEMORY_ARRAY_LOCATION_UNKNOWN = ((UCHAR)2),
    SMBIOS_PHYSICAL_MEMORY_ARRAY_LOCATION_MOTHERBOARD = ((UCHAR)3),
    SMBIOS_PHYSICAL_MEMORY_ARRAY_LOCATION_ISA = ((UCHAR)4),
    SMBIOS_PHYSICAL_MEMORY_ARRAY_LOCATION_EISA = ((UCHAR)5),
    SMBIOS_PHYSICAL_MEMORY_ARRAY_LOCATION_PCI = ((UCHAR)6),
    SMBIOS_PHYSICAL_MEMORY_ARRAY_LOCATION_MCA = ((UCHAR)7),
    SMBIOS_PHYSICAL_MEMORY_ARRAY_LOCATION_PCMCIA = ((UCHAR)8),
    SMBIOS_PHYSICAL_MEMORY_ARRAY_LOCATION_PROPRIETARY = ((UCHAR)9),
    SMBIOS_PHYSICAL_MEMORY_ARRAY_LOCATION_NUBUS = ((UCHAR)10),
    SMBIOS_PHYSICAL_MEMORY_ARRAY_LOCATION_PC_98_C20 = ((UCHAR)160),
    SMBIOS_PHYSICAL_MEMORY_ARRAY_LOCATION_PC_98_C24 = ((UCHAR)161),
    SMBIOS_PHYSICAL_MEMORY_ARRAY_LOCATION_PC_98_E = ((UCHAR)162),
    SMBIOS_PHYSICAL_MEMORY_ARRAY_LOCATION_PC_98_LOCAL_BUS = ((UCHAR)163),
    SMBIOS_PHYSICAL_MEMORY_ARRAY_LOCATION_PC_98_CXL = ((UCHAR)164),
};

enum SMBIOS_PHYSICAL_MEMORY_ARRAY_USE
{
    SMBIOS_PHYSICAL_MEMORY_ARRAY_USE_OTHER = ((UCHAR)1),
    SMBIOS_PHYSICAL_MEMORY_ARRAY_USE_UNKNOWN = ((UCHAR)2),
    SMBIOS_PHYSICAL_MEMORY_ARRAY_USE_SYSTEM = ((UCHAR)3),
    SMBIOS_PHYSICAL_MEMORY_ARRAY_USE_VIDEO = ((UCHAR)4),
    SMBIOS_PHYSICAL_MEMORY_ARRAY_USE_FLASH = ((UCHAR)5),
    SMBIOS_PHYSICAL_MEMORY_ARRAY_USE_NON_VOLATILE = ((UCHAR)6),
    SMBIOS_PHYSICAL_MEMORY_ARRAY_USE_CACHE = ((UCHAR)7),
};

enum SMBIOS_PHYSICAL_MEMORY_ARRAY_ERROR_CORRECTION
{
    SMBIOS_PHYSICAL_MEMORY_ARRAY_ERROR_CORRECTION_OTHER = ((UCHAR)1),
    SMBIOS_PHYSICAL_MEMORY_ARRAY_ERROR_CORRECTION_UNKNOWN = ((UCHAR)2),
    SMBIOS_PHYSICAL_MEMORY_ARRAY_ERROR_CORRECTION_NONE = ((UCHAR)3),
    SMBIOS_PHYSICAL_MEMORY_ARRAY_ERROR_CORRECTION_PARITY = ((UCHAR)4),
    SMBIOS_PHYSICAL_MEMORY_ARRAY_ERROR_CORRECTION_SINGLE_BIT_ECC = ((UCHAR)5),
    SMBIOS_PHYSICAL_MEMORY_ARRAY_ERROR_CORRECTION_MULTI_BIT_ECC = ((UCHAR)6),
    SMBIOS_PHYSICAL_MEMORY_ARRAY_ERROR_CORRECTION_CRC = ((UCHAR)7),
};

enum SMBIOS_MEMORY_DEVICE_FORM_FACTOR
{
SMBIOS_MEMORY_DEVICE_FORM_FACTOR_OTHER=                ((UCHAR)1),
SMBIOS_MEMORY_DEVICE_FORM_FACTOR_UNKNOWN=              ((UCHAR)2),
SMBIOS_MEMORY_DEVICE_FORM_FACTOR_SIMM=                 ((UCHAR)3),
SMBIOS_MEMORY_DEVICE_FORM_FACTOR_SIP=                  ((UCHAR)4),
SMBIOS_MEMORY_DEVICE_FORM_FACTOR_CHIP=                 ((UCHAR)5),
SMBIOS_MEMORY_DEVICE_FORM_FACTOR_DIP=                  ((UCHAR)6),
SMBIOS_MEMORY_DEVICE_FORM_FACTOR_ZIP=                  ((UCHAR)7),
SMBIOS_MEMORY_DEVICE_FORM_FACTOR_PROPRIETARY=          ((UCHAR)8),
SMBIOS_MEMORY_DEVICE_FORM_FACTOR_DIMM=                 ((UCHAR)9),
SMBIOS_MEMORY_DEVICE_FORM_FACTOR_TSOP=                 ((UCHAR)10),
SMBIOS_MEMORY_DEVICE_FORM_FACTOR_ROW_OF_CHIPS=         ((UCHAR)11),
SMBIOS_MEMORY_DEVICE_FORM_FACTOR_RIMM=                 ((UCHAR)12),
SMBIOS_MEMORY_DEVICE_FORM_FACTOR_SODIMM=               ((UCHAR)13),
SMBIOS_MEMORY_DEVICE_FORM_FACTOR_SRIMM=                ((UCHAR)14),
SMBIOS_MEMORY_DEVICE_FORM_FACTOR_FB_DIMM=              ((UCHAR)15),
SMBIOS_MEMORY_DEVICE_FORM_FACTOR_DIE=                  ((UCHAR)16),
SMBIOS_MEMORY_DEVICE_FORM_FACTOR_CAMM=                 ((UCHAR)17),
};

enum SMBIOS_MEMORY_DEVICE_TYPE
{
SMBIOS_MEMORY_DEVICE_TYPE_OTHER=                       ((UCHAR)1),
SMBIOS_MEMORY_DEVICE_TYPE_UNKNOWN=                     ((UCHAR)2),
SMBIOS_MEMORY_DEVICE_TYPE_DRAM=                        ((UCHAR)3),
SMBIOS_MEMORY_DEVICE_TYPE_EDRAM=                       ((UCHAR)4),
SMBIOS_MEMORY_DEVICE_TYPE_VRAM=                        ((UCHAR)5),
SMBIOS_MEMORY_DEVICE_TYPE_SRAM=                        ((UCHAR)6),
SMBIOS_MEMORY_DEVICE_TYPE_RAM=                         ((UCHAR)7),
SMBIOS_MEMORY_DEVICE_TYPE_ROM=                         ((UCHAR)8),
SMBIOS_MEMORY_DEVICE_TYPE_FLASH=                       ((UCHAR)9),
SMBIOS_MEMORY_DEVICE_TYPE_EEPROM=                      ((UCHAR)10),
SMBIOS_MEMORY_DEVICE_TYPE_FEPROM=                      ((UCHAR)11),
SMBIOS_MEMORY_DEVICE_TYPE_EPROM=                       ((UCHAR)12),
SMBIOS_MEMORY_DEVICE_TYPE_CDRAM=                       ((UCHAR)13),
SMBIOS_MEMORY_DEVICE_TYPE_3DRAM=                       ((UCHAR)14),
SMBIOS_MEMORY_DEVICE_TYPE_SDRAM=                       ((UCHAR)15),
SMBIOS_MEMORY_DEVICE_TYPE_SGRAM=                       ((UCHAR)16),
SMBIOS_MEMORY_DEVICE_TYPE_RDRAM=                       ((UCHAR)17),
SMBIOS_MEMORY_DEVICE_TYPE_DDR=                         ((UCHAR)18),
SMBIOS_MEMORY_DEVICE_TYPE_DDR2=                        ((UCHAR)19),
SMBIOS_MEMORY_DEVICE_TYPE_DDR2_FB_DIMM=                ((UCHAR)20),
// 21-23 reserved
SMBIOS_MEMORY_DEVICE_TYPE_DDR3=                        ((UCHAR)24),
SMBIOS_MEMORY_DEVICE_TYPE_FBD2=                        ((UCHAR)25),
SMBIOS_MEMORY_DEVICE_TYPE_DDR4=                        ((UCHAR)26),
SMBIOS_MEMORY_DEVICE_TYPE_LPDDR=                       ((UCHAR)27),
SMBIOS_MEMORY_DEVICE_TYPE_LPDDR2=                      ((UCHAR)28),
SMBIOS_MEMORY_DEVICE_TYPE_LPDDR3=                      ((UCHAR)29),
SMBIOS_MEMORY_DEVICE_TYPE_LPDDR4=                      ((UCHAR)30),
SMBIOS_MEMORY_DEVICE_TYPE_LOCAL_NON_VOLATILE=          ((UCHAR)31),
SMBIOS_MEMORY_DEVICE_TYPE_HBM=                         ((UCHAR)32),
SMBIOS_MEMORY_DEVICE_TYPE_HBM2=                        ((UCHAR)33),
SMBIOS_MEMORY_DEVICE_TYPE_DDR5=                        ((UCHAR)34),
SMBIOS_MEMORY_DEVICE_TYPE_LPDDR5=                      ((UCHAR)35),
SMBIOS_MEMORY_DEVICE_TYPE_HBM3=                        ((UCHAR)36),
};

enum SMBIOS_MEMORY_DEVICE_TYPE_DETAIL
{
SMBIOS_MEMORY_DEVICE_TYPE_DETAIL_RESERVED=             ((USHORT)0x0001),
SMBIOS_MEMORY_DEVICE_TYPE_DETAIL_OTHER=                ((USHORT)0x0002),
SMBIOS_MEMORY_DEVICE_TYPE_DETAIL_UNKNOWN=              ((USHORT)0x0004),
SMBIOS_MEMORY_DEVICE_TYPE_DETAIL_FAST_PAGED=           ((USHORT)0x0008),
SMBIOS_MEMORY_DEVICE_TYPE_DETAIL_STATIC_COL=           ((USHORT)0x0010),
SMBIOS_MEMORY_DEVICE_TYPE_DETAIL_PSEUDO_STATIC=        ((USHORT)0x0020),
SMBIOS_MEMORY_DEVICE_TYPE_DETAIL_RAMBUS=               ((USHORT)0x0040),
SMBIOS_MEMORY_DEVICE_TYPE_DETAIL_SYNCHRONOUS=          ((USHORT)0x0080),
SMBIOS_MEMORY_DEVICE_TYPE_DETAIL_CMOS=                 ((USHORT)0x0100),
SMBIOS_MEMORY_DEVICE_TYPE_DETAIL_EDO=                  ((USHORT)0x0200),
SMBIOS_MEMORY_DEVICE_TYPE_DETAIL_WINDOW_DRAM=          ((USHORT)0x0400),
SMBIOS_MEMORY_DEVICE_TYPE_DETAIL_CACHE_DRAM=           ((USHORT)0x0800),
SMBIOS_MEMORY_DEVICE_TYPE_DETAIL_NON_VOLATILE=         ((USHORT)0x1000),
SMBIOS_MEMORY_DEVICE_TYPE_DETAIL_BUFFERED=             ((USHORT)0x2000),
SMBIOS_MEMORY_DEVICE_TYPE_DETAIL_UNBUFFERED=           ((USHORT)0x4000),
SMBIOS_MEMORY_DEVICE_TYPE_DETAIL_LRDIMM=               ((USHORT)0x8000),
};

enum SMBIOS_MEMORY_DEVICE_TECHNOLOGY
{
SMBIOS_MEMORY_DEVICE_TECHNOLOGY_OTHER=                 ((UCHAR)1),
SMBIOS_MEMORY_DEVICE_TECHNOLOGY_UNKNOWN=               ((UCHAR)2),
SMBIOS_MEMORY_DEVICE_TECHNOLOGY_DRAM=                  ((UCHAR)3),
SMBIOS_MEMORY_DEVICE_TECHNOLOGY_NVDIMM_N=              ((UCHAR)4),
SMBIOS_MEMORY_DEVICE_TECHNOLOGY_NVDIMM_F=              ((UCHAR)5),
SMBIOS_MEMORY_DEVICE_TECHNOLOGY_NVDIMM_P=              ((UCHAR)6),
SMBIOS_MEMORY_DEVICE_TECHNOLOGY_INTEL_OPTANE=          ((UCHAR)7),
SMBIOS_MEMORY_DEVICE_TECHNOLOGY_MRDIMM=                ((UCHAR)8),
};

enum SMBIOS_MEMORY_DEVICE_MODE
{
SMBIOS_MEMORY_DEVICE_MODE_RESERVED=                    ((USHORT)0x0001),
SMBIOS_MEMORY_DEVICE_MODE_OTHER=                       ((USHORT)0x0002),
SMBIOS_MEMORY_DEVICE_MODE_UNKNOWN=                     ((USHORT)0x0004),
SMBIOS_MEMORY_DEVICE_MODE_VOLATILE=                    ((USHORT)0x0008),
SMBIOS_MEMORY_DEVICE_MODE_BYTE_ACCESSIBLE_PERSISTENT=  ((USHORT)0x0010),
SMBIOS_MEMORY_DEVICE_MODE_BLOCK_ACCESSIBLE_PERSISTENT= ((USHORT)0x0020),
SMBIOS_MEMORY_DEVICE_MODE_RESERVED2=                   ((USHORT)0xFFC0),
};

enum SMBIOS_BUILT_IN_POINTING_DEVICE_TYPE
{
SMBIOS_BUILT_IN_POINTING_DEVICE_TYPE_OTHER=          ((UCHAR)1),
SMBIOS_BUILT_IN_POINTING_DEVICE_TYPE_UNKNOWN=        ((UCHAR)2),
SMBIOS_BUILT_IN_POINTING_DEVICE_TYPE_MOUSE=          ((UCHAR)3),
SMBIOS_BUILT_IN_POINTING_DEVICE_TYPE_TRACK_BALL=     ((UCHAR)4),
SMBIOS_BUILT_IN_POINTING_DEVICE_TYPE_TRACK_POINT=    ((UCHAR)5),
SMBIOS_BUILT_IN_POINTING_DEVICE_TYPE_GLIDE_POINT=    ((UCHAR)6),
SMBIOS_BUILT_IN_POINTING_DEVICE_TYPE_TOUCH_PAD=      ((UCHAR)7),
SMBIOS_BUILT_IN_POINTING_DEVICE_TYPE_TOUCH_SCREEN=   ((UCHAR)8),
SMBIOS_BUILT_IN_POINTING_DEVICE_TYPE_OPTICAL_SENSOR= ((UCHAR)9),
};

enum SMBIOS_BUILT_IN_POINTING_DEVICE_INTERFACE
{
SMBIOS_BUILT_IN_POINTING_DEVICE_INTERFACE_OTHER=     ((UCHAR)1),
SMBIOS_BUILT_IN_POINTING_DEVICE_INTERFACE_UNKNOWN=   ((UCHAR)2),
SMBIOS_BUILT_IN_POINTING_DEVICE_INTERFACE_SERIAL=    ((UCHAR)3),
SMBIOS_BUILT_IN_POINTING_DEVICE_INTERFACE_PS2=       ((UCHAR)4),
SMBIOS_BUILT_IN_POINTING_DEVICE_INTERFACE_INFRARED=  ((UCHAR)5),
SMBIOS_BUILT_IN_POINTING_DEVICE_INTERFACE_HP_HIL=    ((UCHAR)6),
SMBIOS_BUILT_IN_POINTING_DEVICE_INTERFACE_BUS_MOUSE= ((UCHAR)7),
SMBIOS_BUILT_IN_POINTING_DEVICE_INTERFACE_ADB=       ((UCHAR)8),
SMBIOS_BUILT_IN_POINTING_DEVICE_INTERFACE_DB_9=      ((UCHAR)160),
SMBIOS_BUILT_IN_POINTING_DEVICE_INTERFACE_MICRO_DIN= ((UCHAR)161),
SMBIOS_BUILT_IN_POINTING_DEVICE_INTERFACE_USB=       ((UCHAR)162),
SMBIOS_BUILT_IN_POINTING_DEVICE_INTERFACE_I2C=       ((UCHAR)163),
SMBIOS_BUILT_IN_POINTING_DEVICE_INTERFACE_SPI=       ((UCHAR)164),
};

enum SMBIO_PORTABLE_BATTERY_CHEMISTRY
{
SMBIO_PORTABLE_BATTERY_CHEMISTRY_OTHER=           ((UCHAR)1),
SMBIO_PORTABLE_BATTERY_CHEMISTRY_UNKNOWN=         ((UCHAR)2),
SMBIO_PORTABLE_BATTERY_CHEMISTRY_LEAD_ACID=       ((UCHAR)3),
SMBIO_PORTABLE_BATTERY_CHEMISTRY_NICKEL_CADMIUM=  ((UCHAR)4),
SMBIO_PORTABLE_BATTERY_CHEMISTRY_NICKEL_METAL=    ((UCHAR)5),
SMBIO_PORTABLE_BATTERY_CHEMISTRY_LITHIUM_ION=     ((UCHAR)6),
SMBIO_PORTABLE_BATTERY_CHEMISTRY_ZINC_AIR=        ((UCHAR)7),
SMBIO_PORTABLE_BATTERY_CHEMISTRY_LITHIUM_POLYMER= ((UCHAR)8),
};

enum SMBIOS_SYSTEM_RESET_WATCHDOG
{
SMBIOS_SYSTEM_RESET_WATCHDOG_RESERVED=         ((UCHAR)0),
SMBIOS_SYSTEM_RESET_WATCHDOG_OPERATING_SYSTEM= ((UCHAR)1),
SMBIOS_SYSTEM_RESET_WATCHDOG_SYSTEM_UTILITES=  ((UCHAR)2),
SMBIOS_SYSTEM_RESET_WATCHDOG_DO_NOT_REBOOT=    ((UCHAR)3),
};

enum SMBIOS_HARDWARE_SECURITY_SETTING
{
SMBIOS_HARDWARE_SECURITY_SETTING_DISABLED=        ((UCHAR)0),
SMBIOS_HARDWARE_SECURITY_SETTING_ENABLED=         ((UCHAR)1),
SMBIOS_HARDWARE_SECURITY_SETTING_NOT_IMPLEMENTED= ((UCHAR)2),
SMBIOS_HARDWARE_SECURITY_SETTING_UNKNOWN=         ((UCHAR)3),
};

enum SMBIOS_VOLTAGE_PROBE_LOCATION
{
SMBIOS_VOLTAGE_PROBE_LOCATION_OTHER=                    ((UCHAR)1),
SMBIOS_VOLTAGE_PROBE_LOCATION_UNKNOWN=                  ((UCHAR)2),
SMBIOS_VOLTAGE_PROBE_LOCATION_PROCESSOR=                ((UCHAR)3),
SMBIOS_VOLTAGE_PROBE_LOCATION_DISK=                     ((UCHAR)4),
SMBIOS_VOLTAGE_PROBE_LOCATION_PERIPHERAL_BAY=           ((UCHAR)5),
SMBIOS_VOLTAGE_PROBE_LOCATION_SYSTEM_MANAGEMENT_MODULE= ((UCHAR)6),
SMBIOS_VOLTAGE_PROBE_LOCATION_MOTHERBOARD=              ((UCHAR)7),
SMBIOS_VOLTAGE_PROBE_LOCATION_MEMORY_MODULE=            ((UCHAR)8),
SMBIOS_VOLTAGE_PROBE_LOCATION_PROCESSOR_MODULE=         ((UCHAR)9),
SMBIOS_VOLTAGE_PROBE_LOCATION_POWER_UNIT=               ((UCHAR)10),
SMBIOS_VOLTAGE_PROBE_LOCATION_ADD_IN_CARD=              ((UCHAR)11),
};

enum SMBIOS_COOLING_DEVICE_TYPE
{
SMBIOS_COOLING_DEVICE_TYPE_OTHER=                    ((UCHAR)1),
SMBIOS_COOLING_DEVICE_TYPE_UNKNOWN=                  ((UCHAR)2),
SMBIOS_COOLING_DEVICE_TYPE_FAN=                      ((UCHAR)3),
SMBIOS_COOLING_DEVICE_TYPE_CENTRIFUGAL_BLOWER=       ((UCHAR)4),
SMBIOS_COOLING_DEVICE_TYPE_CHIP_FAN=                 ((UCHAR)5),
SMBIOS_COOLING_DEVICE_TYPE_CABINET_FAN=              ((UCHAR)6),
SMBIOS_COOLING_DEVICE_TYPE_POWER_SUPPLY_FAN=         ((UCHAR)7),
SMBIOS_COOLING_DEVICE_TYPE_HEAT_PIPE=                ((UCHAR)8),
SMBIOS_COOLING_DEVICE_TYPE_INTEGRATED_REFRIGERATION= ((UCHAR)9),
SMBIOS_COOLING_DEVICE_TYPE_ACTIVE_COOLING=           ((UCHAR)10),
SMBIOS_COOLING_DEVICE_TYPE_PASSIVE_COOLING=          ((UCHAR)11),
};

enum SMBIOS_COOLING_DEVICE_STATUS
{
SMBIOS_COOLING_DEVICE_STATUS_OTHER=                  ((UCHAR)1),
SMBIOS_COOLING_DEVICE_STATUS_UNKNOWN=                ((UCHAR)2),
SMBIOS_COOLING_DEVICE_STATUS_OK=                     ((UCHAR)3),
SMBIOS_COOLING_DEVICE_STATUS_NON_CRITICAL=           ((UCHAR)4),
SMBIOS_COOLING_DEVICE_STATUS_CRITICAL=               ((UCHAR)5),
SMBIOS_COOLING_DEVICE_STATUS_NON_RECOVERABLE=        ((UCHAR)6),
};

enum SMBIOS_TEMPERATURE_PROBE_LOCATION
{
SMBIOS_TEMPERATURE_PROBE_LOCATION_OTHER=                    ((UCHAR)1),
SMBIOS_TEMPERATURE_PROBE_LOCATION_UNKNOWN=                  ((UCHAR)2),
SMBIOS_TEMPERATURE_PROBE_LOCATION_PROCESSOR=                ((UCHAR)3),
SMBIOS_TEMPERATURE_PROBE_LOCATION_DISK=                     ((UCHAR)4),
SMBIOS_TEMPERATURE_PROBE_LOCATION_PERIPHERAL_BAY=           ((UCHAR)5),
SMBIOS_TEMPERATURE_PROBE_LOCATION_SYSTEM_MANAGEMENT_MODULE= ((UCHAR)6),
SMBIOS_TEMPERATURE_PROBE_LOCATION_MOTHERBOARD=              ((UCHAR)7),
SMBIOS_TEMPERATURE_PROBE_LOCATION_MEMORY_MODULE=            ((UCHAR)8),
SMBIOS_TEMPERATURE_PROBE_LOCATION_PROCESSOR_MODULE=         ((UCHAR)9),
SMBIOS_TEMPERATURE_PROBE_LOCATION_POWER_UNIT=               ((UCHAR)10),
SMBIOS_TEMPERATURE_PROBE_LOCATION_ADD_IN_CARD=              ((UCHAR)11),
SMBIOS_TEMPERATURE_PROBE_LOCATION_FRONT_PANEL_BOARD=        ((UCHAR)12),
SMBIOS_TEMPERATURE_PROBE_LOCATION_BACK_PANEL_BOARD=         ((UCHAR)13),
SMBIOS_TEMPERATURE_PROBE_LOCATION_POWER_SYSTEM_BOARD=       ((UCHAR)14),
SMBIOS_TEMPERATURE_PROBE_LOCATION_DRIVE_BACK_PLANE=         ((UCHAR)15),
};

enum SMBIOS_ELECTRICAL_CURRENT_PROBE_LOCATION
{
SMBIOS_ELECTRICAL_CURRENT_PROBE_LOCATION_OTHER=                    ((UCHAR)1),
SMBIOS_ELECTRICAL_CURRENT_PROBE_LOCATION_UNKNOWN=                  ((UCHAR)2),
SMBIOS_ELECTRICAL_CURRENT_PROBE_LOCATION_PROCESSOR=                ((UCHAR)3),
SMBIOS_ELECTRICAL_CURRENT_PROBE_LOCATION_DISK=                     ((UCHAR)4),
SMBIOS_ELECTRICAL_CURRENT_PROBE_LOCATION_PERIPHERAL_BAY=           ((UCHAR)5),
SMBIOS_ELECTRICAL_CURRENT_PROBE_LOCATION_SYSTEM_MANAGEMENT_MODULE= ((UCHAR)6),
SMBIOS_ELECTRICAL_CURRENT_PROBE_LOCATION_MOTHERBOARD=              ((UCHAR)7),
SMBIOS_ELECTRICAL_CURRENT_PROBE_LOCATION_MEMORY_MODULE=            ((UCHAR)8),
SMBIOS_ELECTRICAL_CURRENT_PROBE_LOCATION_PROCESSOR_MODULE=         ((UCHAR)9),
SMBIOS_ELECTRICAL_CURRENT_PROBE_LOCATION_POWER_UNIT=               ((UCHAR)10),
SMBIOS_ELECTRICAL_CURRENT_PROBE_LOCATION_ADD_IN_CARD=              ((UCHAR)11),
};

enum SMBIOS_SYSTEM_BOOT_STATUS
{
SMBIOS_SYSTEM_BOOT_STATUS_NO_ERROR=                           ((UCHAR)0),
SMBIOS_SYSTEM_BOOT_STATUS_NO_BOOTABLE_MEDIA=                  ((UCHAR)1),
SMBIOS_SYSTEM_BOOT_STATUS_OPERATING_SYSTEM_FAILED_TO_LOAD=    ((UCHAR)2),
SMBIOS_SYSTEM_BOOT_STATUS_FIRMWARE_DETECTED_HARDWARE_FAILURE= ((UCHAR)3),
SMBIOS_SYSTEM_BOOT_STATUS_OPERATING_SYSTEM_DETECTED_FAILURE=  ((UCHAR)4),
SMBIOS_SYSTEM_BOOT_STATUS_USER_REQUESTED_BOOT=                ((UCHAR)5),
SMBIOS_SYSTEM_BOOT_STATUS_SECURITY_VIOLATION=                 ((UCHAR)6),
SMBIOS_SYSTEM_BOOT_STATUS_PREVIOUS_REQUESTED_IMAGE=           ((UCHAR)7),
SMBIOS_SYSTEM_BOOT_STATUS_WATCHDOG_EXPIRED=                   ((UCHAR)8),
};

enum SMBIOS_MANAGEMENT_DEVICE_TYPE
{
    SMBIOS_MANAGEMENT_DEVICE_TYPE_OTHER=           ((UCHAR)1),
    SMBIOS_MANAGEMENT_DEVICE_TYPE_UNKNOWN=         ((UCHAR)2),
    SMBIOS_MANAGEMENT_DEVICE_TYPE_LM75=            ((UCHAR)3),
    SMBIOS_MANAGEMENT_DEVICE_TYPE_LM78=            ((UCHAR)4),
    SMBIOS_MANAGEMENT_DEVICE_TYPE_LM79=            ((UCHAR)5),
    SMBIOS_MANAGEMENT_DEVICE_TYPE_LM80=            ((UCHAR)6),
    SMBIOS_MANAGEMENT_DEVICE_TYPE_LM81=            ((UCHAR)7),
    SMBIOS_MANAGEMENT_DEVICE_TYPE_ADM9240=         ((UCHAR)8),
    SMBIOS_MANAGEMENT_DEVICE_TYPE_DS1780=          ((UCHAR)9),
    SMBIOS_MANAGEMENT_DEVICE_TYPE_1617=            ((UCHAR)10),
    SMBIOS_MANAGEMENT_DEVICE_TYPE_GL518SM=         ((UCHAR)11),
    SMBIOS_MANAGEMENT_DEVICE_TYPE_W83781D=         ((UCHAR)12),
    SMBIOS_MANAGEMENT_DEVICE_TYPE_HT82H791=        ((UCHAR)13),
};

enum SMBIOS_MANAGEMENT_DEVICE_ADDRESS_TYPE
{
SMBIOS_MANAGEMENT_DEVICE_ADDRESS_TYPE_OTHER=   ((UCHAR)1),
SMBIOS_MANAGEMENT_DEVICE_ADDRESS_TYPE_UNKNOWN= ((UCHAR)2),
SMBIOS_MANAGEMENT_DEVICE_ADDRESS_TYPE_IO_PORT= ((UCHAR)3),
SMBIOS_MANAGEMENT_DEVICE_ADDRESS_TYPE_MEMORY=  ((UCHAR)4),
SMBIOS_MANAGEMENT_DEVICE_ADDRESS_TYPE_SMBUS=   ((UCHAR)5),
};

enum SMBIOS_MEMORY_CHANNEL_TYPE
{
    SMBIOS_MEMORY_CHANNEL_TYPE_OTHER=     ((UCHAR)1),
    SMBIOS_MEMORY_CHANNEL_TYPE_UNKNOWN=   ((UCHAR)2),
    SMBIOS_MEMORY_CHANNEL_TYPE_RAMBUS=    ((UCHAR)3),
    SMBIOS_MEMORY_CHANNEL_TYPE_SYNC_LINK= ((UCHAR)4),
};

enum SMBIOS_IPMI_INTERFACE_TYPE
{
    SMBIOS_IPMI_INTERFACE_TYPE_UNKONWN=((UCHAR)0),
    SMBIOS_IPMI_INTERFACE_TYPE_KCS=((UCHAR)1),
    SMBIOS_IPMI_INTERFACE_TYPE_SMIC=((UCHAR)2),
    SMBIOS_IPMI_INTERFACE_TYPE_BT=((UCHAR)3),
    SMBIOS_IPMI_INTERFACE_TYPE_SSIF=((UCHAR)4),
};

enum SMBIOS_IPMI_REGISTER_SPACING
{
    SMBIOS_IPMI_REGISTER_SPACING_SUCCESSIVE=((UCHAR)0),
    SMBIOS_IPMI_REGISTER_SPACING_32_BIT=((UCHAR)1),
    SMBIOS_IPMI_REGISTER_SPACING_16_BIT=((UCHAR)2),
    SMBIOS_IPMI_REGISTER_SPACING_RESERVED=((UCHAR)3),
};

enum SMBIOS_POWER_SUPPLY_RANGE_SWITCHING
{
    SMBIOS_POWER_SUPPLY_RANGE_SWITCHING_OTHER = ((USHORT)1),
    SMBIOS_POWER_SUPPLY_RANGE_SWITCHING_UNKNOWN = ((USHORT)2),
    SMBIOS_POWER_SUPPLY_RANGE_SWITCHING_MANUAL = ((USHORT)3),
    SMBIOS_POWER_SUPPLY_RANGE_SWITCHING_AUTO_SWITCH = ((USHORT)4),
    SMBIOS_POWER_SUPPLY_RANGE_SWITCHING_WIDE_RANGE = ((USHORT)5),
    SMBIOS_POWER_SUPPLY_RANGE_SWITCHING_NOT_APPLICABLE = ((USHORT)6),
};

enum SMBIOS_POWER_SUPPLY_STATUS
{
    SMBIOS_POWER_SUPPLY_STATUS_OTHER = ((USHORT)1),
    SMBIOS_POWER_SUPPLY_STATUS_UNKNOWN = ((USHORT)2),
    SMBIOS_POWER_SUPPLY_STATUS_OK = ((USHORT)3),
    SMBIOS_POWER_SUPPLY_STATUS_NON_CRITICAL = ((USHORT)4),
    SMBIOS_POWER_SUPPLY_STATUS_CRITICAL = ((USHORT)5),
};

enum SMBIOS_POWER_SUPPLY_TYPE
{
    SMBIOS_POWER_SUPPLY_TYPE_OTHER = ((USHORT)1),
    SMBIOS_POWER_SUPPLY_TYPE_UNKNOWN = ((USHORT)2),
    SMBIOS_POWER_SUPPLY_TYPE_LINEAR = ((USHORT)3),
    SMBIOS_POWER_SUPPLY_TYPE_SWITCHING = ((USHORT)4),
    SMBIOS_POWER_SUPPLY_TYPE_BATTERY = ((USHORT)5),
    SMBIOS_POWER_SUPPLY_TYPE_UPS = ((USHORT)6),
    SMBIOS_POWER_SUPPLY_TYPE_CONVERTER = ((USHORT)7),
    SMBIOS_POWER_SUPPLY_TYPE_REGULATOR = ((USHORT)8),
};

enum SMBIOS_ONBOARD_DEVICE_TYPE
{
    SMBIOS_ONBOARD_DEVICE_TYPE_OTHER = ((UCHAR)1),
    SMBIOS_ONBOARD_DEVICE_TYPE_UNKNOWN = ((UCHAR)2),
    SMBIOS_ONBOARD_DEVICE_TYPE_VIDEO = ((UCHAR)3),
    SMBIOS_ONBOARD_DEVICE_TYPE_SCSI = ((UCHAR)4),
    SMBIOS_ONBOARD_DEVICE_TYPE_ETHERNET = ((UCHAR)5),
    SMBIOS_ONBOARD_DEVICE_TYPE_TOKEN_RING = ((UCHAR)6),
    SMBIOS_ONBOARD_DEVICE_TYPE_SOUND = ((UCHAR)7),
    SMBIOS_ONBOARD_DEVICE_TYPE_PATA = ((UCHAR)8),
    SMBIOS_ONBOARD_DEVICE_TYPE_SATA = ((UCHAR)9),
    SMBIOS_ONBOARD_DEVICE_TYPE_SAS = ((UCHAR)10),
    SMBIOS_ONBOARD_DEVICE_TYPE_WIRELESS_LAN = ((UCHAR)11),
    SMBIOS_ONBOARD_DEVICE_TYPE_BLUETOOTH = ((UCHAR)12),
    SMBIOS_ONBOARD_DEVICE_TYPE_WWAN = ((UCHAR)13),
    SMBIOS_ONBOARD_DEVICE_TYPE_EMMC = ((UCHAR)14),
    SMBIOS_ONBOARD_DEIVCE_TYPE_NVME = ((UCHAR)15),
    SMBIOS_ONBOARD_DEVICE_TYPE_UFS = ((UCHAR)16),
};

enum SMBIOS_MCHI_TYPE
{
    SMBIOS_MCHI_TYPE_NETWORK_INTERFACE = ((UCHAR)64),
    SMBIOS_MCHI_TYPE_OEM_DEFINED = ((UCHAR)240),
};

enum SMBIOS_MCHI_PROTOCOL_TYPE
{
    SMBIOS_MCHI_PROTOCOL_TYPE_RESERVED_0 = ((UCHAR)0),
    SMBIOS_MCHI_PROTOCOL_TYPE_RESERVED_1 = ((UCHAR)1),
    SMBIOS_MCHI_PROTOCOL_TYPE_IPMI = ((UCHAR)2),
    SMBIOS_MCHI_PROTOCOL_TYPE_MCTP = ((UCHAR)3),
    SMBIOS_MCHI_PROTOCOL_TYPE_REFRESH_OVER_IP = ((UCHAR)4),
    SMBIOS_MCHI_PROTOCOL_TYPE_OEM_DEFINED = ((UCHAR)240),
};

enum SMBIOS_TPM_DEVICE
{
    SMBIOS_TPM_DEVICE_RESERVED_0 = 0x0000000000000001ULL,
    SMBIOS_TPM_DEVICE_RESERVED_1 = 0x0000000000000002ULL,
    SMBIOS_TPM_DEVICE_CONFIGURABLE_VIA_FIRMWARE_UPDATE = 0x0000000000000004ULL,
    SMBIOS_TPM_DEVICE_CONFIGURABLE_VIA_SOFTWARE_UPDATE = 0x0000000000000008ULL,
    SMBIOS_TPM_DEVICE_CONFIGURABLE_VIA_PROPRIETARY_UPDATE = 0x0000000000000010ULL,
    SMBIOS_TPM_DEIVCE_RESERVED = 0xFFFFFFFFFFFFFFE0ULL,
};

enum SMBIOS_PROCESSOR_ARCHITECTURE_TYPE
{
    SMBIOS_PROCESSOR_ARCHITECTURE_TYPE_X86 = ((UCHAR)1),
    SMBIOS_PROCESSOR_ARCHITECTURE_TYPE_X64 = ((UCHAR)2),
    SMBIOS_PROCESSOR_ARCHITECTURE_TYPE_IA64 = ((UCHAR)3),
    SMBIOS_PROCESSOR_ARCHITECTURE_TYPE_ARM32 = ((UCHAR)4),
    SMBIOS_PROCESSOR_ARCHITECTURE_TYPE_ARM64 = ((UCHAR)5),
    SMBIOS_PROCESSOR_ARCHITECTURE_TYPE_RISCV32 = ((UCHAR)6),
    SMBIOS_PROCESSOR_ARCHITECTURE_TYPE_RISCV64 = ((UCHAR)7),
    SMBIOS_PROCESSOR_ARCHITECTURE_TYPE_RISCV128 = ((UCHAR)8),
    SMBIOS_PROCESSOR_ARCHITECTURE_TYPE_LOONGARCH32 = ((UCHAR)9),
    SMBIOS_PROCESSOR_ARCHITECTURE_TYPE_LOONGARCH64 = ((UCHAR)10),
};

enum SMBIOS_FIRMWARE_INVENTORY_FLAG
{
    SMBIOS_FIRMWARE_INVENTORY_FLAG_UPDATABLE = 0x00000001UL,
    SMBIOS_FIRMWARE_INVENTORY_FLAG_WRITE_PROTECTED = 0x00000002UL,
    SMBIOS_FIRMWARE_INVENTORY_FLAG_RESERVED = 0xFFFFFFFCUL,
};

enum SMBIOS_FIRMWARE_INVENTORY_STATE
{
    SMBIOS_FIRMWARE_INVENTORY_STATE_OTHER = ((UCHAR)1),
    SMBIOS_FIRMWARE_INVENTORY_STATE_UNKNOWN = ((UCHAR)2),
    SMBIOS_FIRMWARE_INVENTORY_STATE_DISABLED = ((UCHAR)3),
    SMBIOS_FIRMWARE_INVENTORY_STATE_ENABLED = ((UCHAR)4),
    SMBIOS_FIRMWARE_INVENTORY_STATE_ABSENT = ((UCHAR)5),
    SMBIOS_FIRMWARE_INVENTORY_STATE_STANDBY_OFFLINE = ((UCHAR)6),
    SMBIOS_FIRMWARE_INVENTORY_STATE_STANDBY_SPARE = ((UCHAR)7),
    SMBIOS_FIRMWARE_INVENTORY_STATE_OFFLINE = ((UCHAR)8),
};

enum SMBIOS_STRING_PROPERTY_ID
{
    SMBIOS_STRING_PROPERTY_ID_RESERVED = ((UCHAR)1),
    SMBIOS_STRING_PROPERTY_ID_UEIF_DEVICE_PATH = ((UCHAR)2),
};

#pragma endregion smbios.h

#endif // _ENUMS_PHNT_H_
