#pragma once

#ifndef ENUMS_NETFXSDK
#define ENUMS_NETFXSDK

#pragma region cor.h

enum META_DATA_META_CONSTANTS
{
    iRidMax = 63,
    iCodedToken = 64,   // base of coded tokens.
    iCodedTokenMax = 95,
    iSHORT = 96,   // fixed types.
    iUSHORT = 97,
    iLONG = 98,
    iULONG = 99,
    iBYTE = 100,
    iSTRING = 101,  // pool types.
    iGUID = 102,
    iBLOB = 103,
};

#pragma endregion cor.h

#pragma region CorError.h

// Run cl preprocessor on CorError.h

enum COMMON_LANGUAGE_RUNTIME_HRESULTS
{
    CLDB_S_TRUNCATION = 0x00131106,
    CLDB_S_NULL = 0x00131109,
    CLDB_S_INDEX_TABLESCANREQUIRED = 0x00131125,
    TLBX_I_TYPEINFO_IMPORTED = 0x0013116c,
    TLBX_I_PIA_REGISTERED_FOR_TLB = 0x0013116d,
    TLBX_I_AGNOSTIC_ASSEMBLY = 0x0013116e,
    TLBX_I_USEIUNKNOWN = 0x0013116f,
    TLBX_I_UNCONVERTABLE_ARGS = 0x00131170,
    TLBX_I_UNCONVERTABLE_FIELD = 0x00131171,
    TLBX_W_WARNING_MESSAGE = 0x00131173,
    TLBX_W_ASSEMBLY_HAS_EMBEDDED_TLB = 0x00131174,
    TLBX_W_CROSS_COMPILE_NO_REFS = 0x00131175,
    TLBX_W_PURE_CROSS_COMPILE = 0x00131176,
    TLBX_I_TYPE_EXPORTED = 0x00131179,
    TLBX_I_DUPLICATE_DISPID = 0x0013117a,
    TLBX_I_REF_TYPE_AS_STRUCT = 0x0013117c,
    TLBX_I_GENERIC_TYPE = 0x0013117f,
    TLBX_W_NON_INTEGRAL_CA_TYPE = 0x00131184,
    TLBX_W_IENUM_CA_ON_IUNK = 0x00131185,
    META_S_PARAM_MISMATCH = 0x00131189,
    META_S_DUPLICATE = 0x00131197,
    TLBX_S_REFERENCED_TYPELIB = 0x001311ac,
    TLBX_S_NOSTDINTERFACE = 0x001311b3,
    TLBX_S_DUPLICATE_DISPID = 0x001311b4,
    TLBX_W_ENUM_VALUE_TOOBIG = 0x001311d5,
    TLBX_W_EXPORTING_AUTO_LAYOUT = 0x001311d9,
    TLBX_W_DEFAULT_INTF_NOT_VISIBLE = 0x001311db,
    TLBX_W_BAD_SAFEARRAYFIELD_NO_ELEMENTVT = 0x001311de,
    TLBX_W_LAYOUTCLASS_AS_INTERFACE = 0x001311df,
    TLBX_I_GENERIC_BASE_TYPE = 0x001311e0,
    VLDTR_S_WRN = 0x00131200,
    VLDTR_S_ERR = 0x00131201,
    VLDTR_S_WRNERR = 0x00131202,
    CORDBG_S_BAD_START_SEQUENCE_POINT = 0x0013130b,
    CORDBG_S_BAD_END_SEQUENCE_POINT = 0x0013130c,
    CORDBG_S_INSUFFICIENT_INFO_FOR_SET_IP = 0x0013130d,
    CORDBG_S_FUNC_EVAL_HAS_NO_RESULT = 0x00131316,
    CORDBG_S_VALUE_POINTS_TO_VOID = 0x00131317,
    CORDBG_S_FUNC_EVAL_ABORTED = 0x00131319,
    CORDBG_S_AT_END_OF_STACK = 0x00131324,
    CORDBG_S_NOT_ALL_BITS_SET = 0x00131c13,
    CEE_E_ENTRYPOINT = 0x80131000,
    CEE_E_CVTRES_NOT_FOUND = 0x80131001,
    MSEE_E_LOADLIBFAILED = 0x80131010,
    MSEE_E_GETPROCFAILED = 0x80131011,
    MSEE_E_MULTCOPIESLOADED = 0x80131012,
    COR_E_TYPEUNLOADED = 0x80131013,
    COR_E_APPDOMAINUNLOADED = 0x80131014,
    COR_E_CANNOTUNLOADAPPDOMAIN = 0x80131015,
    MSEE_E_ASSEMBLYLOADINPROGRESS = 0x80131016,
    MSEE_E_CANNOTCREATEAPPDOMAIN = 0x80131017,
    COR_E_ASSEMBLYEXPECTED = 0x80131018,
    COR_E_FIXUPSINEXE = 0x80131019,
    COR_E_NO_LOADLIBRARY_ALLOWED = 0x8013101a,
    COR_E_NEWER_RUNTIME = 0x8013101b,
    COR_E_CANNOT_SET_POLICY = 0x8013101c,
    COR_E_CANNOT_SPECIFY_EVIDENCE = 0x8013101d,
    COR_E_MULTIMODULEASSEMBLIESDIALLOWED = 0x8013101e,
    HOST_E_DEADLOCK = 0x80131020,
    HOST_E_INTERRUPTED = 0x80131021,
    HOST_E_INVALIDOPERATION = 0x80131022,
    HOST_E_CLRNOTAVAILABLE = 0x80131023,
    HOST_E_TIMEOUT = 0x80131024,
    HOST_E_NOT_OWNER = 0x80131025,
    HOST_E_ABANDONED = 0x80131026,
    HOST_E_EXITPROCESS_THREADABORT = 0x80131027,
    HOST_E_EXITPROCESS_ADUNLOAD = 0x80131028,
    HOST_E_EXITPROCESS_TIMEOUT = 0x80131029,
    HOST_E_EXITPROCESS_OUTOFMEMORY = 0x8013102a,
    HOST_E_EXITPROCESS_STACKOVERFLOW = 0x8013102b,
    COR_E_MODULE_HASH_CHECK_FAILED = 0x80131039,
    FUSION_E_REF_DEF_MISMATCH = 0x80131040,
    FUSION_E_INVALID_PRIVATE_ASM_LOCATION = 0x80131041,
    FUSION_E_ASM_MODULE_MISSING = 0x80131042,
    FUSION_E_UNEXPECTED_MODULE_FOUND = 0x80131043,
    FUSION_E_PRIVATE_ASM_DISALLOWED = 0x80131044,
    FUSION_E_SIGNATURE_CHECK_FAILED = 0x80131045,
    FUSION_E_DATABASE_ERROR = 0x80131046,
    FUSION_E_INVALID_NAME = 0x80131047,
    FUSION_E_CODE_DOWNLOAD_DISABLED = 0x80131048,
    FUSION_E_UNINSTALL_DISALLOWED = 0x80131049,
    CLR_E_APP_CONFIG_NOT_ALLOWED_IN_APPX_PROCESS = 0x8013104a,
    FUSION_E_HOST_GAC_ASM_MISMATCH = 0x80131050,
    FUSION_E_LOADFROM_BLOCKED = 0x80131051,
    FUSION_E_CACHEFILE_FAILED = 0x80131052,
    FUSION_E_APP_DOMAIN_LOCKED = 0x80131053,
    FUSION_E_CONFIGURATION_ERROR = 0x80131054,
    FUSION_E_MANIFEST_PARSE_ERROR = 0x80131055,
    FUSION_E_INVALID_ASSEMBLY_REFERENCE = 0x80131056,
    COR_E_ASSEMBLY_NOT_EXPECTED = 0x80131057,
    COR_E_LOADING_REFERENCE_ASSEMBLY = 0x80131058,
    COR_E_NI_AND_RUNTIME_VERSION_MISMATCH = 0x80131059,
    COR_E_LOADING_WINMD_REFERENCE_ASSEMBLY = 0x80131069,
    CLDB_E_FILE_BADREAD = 0x80131100,
    CLDB_E_FILE_BADWRITE = 0x80131101,
    CLDB_E_FILE_READONLY = 0x80131103,
    CLDB_E_NAME_ERROR = 0x80131105,
    CLDB_E_TRUNCATION = 0x80131106,
    CLDB_E_FILE_OLDVER = 0x80131107,
    CLDB_E_RELOCATED = 0x80131108,
    CLDB_E_SMDUPLICATE = 0x8013110a,
    CLDB_E_NO_DATA = 0x8013110b,
    CLDB_E_READONLY = 0x8013110c,
    CLDB_E_INCOMPATIBLE = 0x8013110d,
    CLDB_E_FILE_CORRUPT = 0x8013110e,
    CLDB_E_SCHEMA_VERNOTFOUND = 0x8013110f,
    CLDB_E_BADUPDATEMODE = 0x80131110,
    CLDB_E_INDEX_NONULLKEYS = 0x80131121,
    CLDB_E_INDEX_DUPLICATE = 0x80131122,
    CLDB_E_INDEX_BADTYPE = 0x80131123,
    CLDB_E_INDEX_NOTFOUND = 0x80131124,
    CLDB_E_RECORD_NOTFOUND = 0x80131130,
    CLDB_E_RECORD_OVERFLOW = 0x80131131,
    CLDB_E_RECORD_DUPLICATE = 0x80131132,
    CLDB_E_RECORD_PKREQUIRED = 0x80131133,
    CLDB_E_RECORD_DELETED = 0x80131134,
    CLDB_E_RECORD_OUTOFORDER = 0x80131135,
    CLDB_E_COLUMN_OVERFLOW = 0x80131140,
    CLDB_E_COLUMN_READONLY = 0x80131141,
    CLDB_E_COLUMN_SPECIALCOL = 0x80131142,
    CLDB_E_COLUMN_PKNONULLS = 0x80131143,
    CLDB_E_TABLE_CANTDROP = 0x80131150,
    CLDB_E_OBJECT_NOTFOUND = 0x80131151,
    CLDB_E_OBJECT_COLNOTFOUND = 0x80131152,
    CLDB_E_VECTOR_BADINDEX = 0x80131153,
    CLDB_E_TOO_BIG = 0x80131154,
    META_E_INVALID_TOKEN_TYPE = 0x8013115f,
    TLBX_E_INVALID_TYPEINFO = 0x80131160,
    TLBX_E_INVALID_TYPEINFO_UNNAMED = 0x80131161,
    TLBX_E_CTX_NESTED = 0x80131162,
    TLBX_E_ERROR_MESSAGE = 0x80131163,
    TLBX_E_CANT_SAVE = 0x80131164,
    TLBX_W_LIBNOTREGISTERED = 0x80131165,
    TLBX_E_CANTLOADLIBRARY = 0x80131166,
    TLBX_E_BAD_VT_TYPE = 0x80131167,
    TLBX_E_NO_MSCOREE_TLB = 0x80131168,
    TLBX_E_BAD_MSCOREE_TLB = 0x80131169,
    TLBX_E_TLB_EXCEPTION = 0x8013116a,
    TLBX_E_MULTIPLE_LCIDS = 0x8013116b,
    TLBX_E_AMBIGUOUS_RETURN = 0x8013116d,
    TLBX_E_DUPLICATE_TYPE_NAME = 0x8013116e,
    TLBX_I_NONSEQUENTIALSTRUCT = 0x80131172,
    TLBX_I_RESOLVEREFFAILED = 0x80131174,
    TLBX_E_ASANY = 0x80131175,
    TLBX_E_INVALIDLCIDPARAM = 0x80131176,
    TLBX_E_LCIDONDISPONLYITF = 0x80131177,
    TLBX_E_NONPUBLIC_FIELD = 0x80131178,
    TLBX_E_BAD_NAMES = 0x8013117b,
    TLBX_E_GENERICINST_SIGNATURE = 0x8013117d,
    TLBX_E_GENERICPAR_SIGNATURE = 0x8013117e,
    META_E_DUPLICATE = 0x80131180,
    META_E_GUID_REQUIRED = 0x80131181,
    META_E_TYPEDEF_MISMATCH = 0x80131182,
    META_E_MERGE_COLLISION = 0x80131183,
    TLBX_E_NO_SAFEHANDLE_ARRAYS = 0x80131186,
    META_E_METHD_NOT_FOUND = 0x80131187,
    META_E_FIELD_NOT_FOUND = 0x80131188,
    META_E_PARAM_MISMATCH = 0x80131189,
    META_E_BADMETADATA = 0x8013118a,
    META_E_INTFCEIMPL_NOT_FOUND = 0x8013118b,
    TLBX_E_NO_CRITICALHANDLE_ARRAYS = 0x8013118c,
    META_E_CLASS_LAYOUT_INCONSISTENT = 0x8013118d,
    META_E_FIELD_MARSHAL_NOT_FOUND = 0x8013118e,
    META_E_METHODSEM_NOT_FOUND = 0x8013118f,
    META_E_EVENT_NOT_FOUND = 0x80131190,
    META_E_PROP_NOT_FOUND = 0x80131191,
    META_E_BAD_SIGNATURE = 0x80131192,
    META_E_BAD_INPUT_PARAMETER = 0x80131193,
    META_E_METHDIMPL_INCONSISTENT = 0x80131194,
    META_E_MD_INCONSISTENCY = 0x80131195,
    META_E_CANNOTRESOLVETYPEREF = 0x80131196,
    META_E_STRINGSPACE_FULL = 0x80131198,
    META_E_UNEXPECTED_REMAP = 0x80131199,
    META_E_HAS_UNMARKALL = 0x8013119a,
    META_E_MUST_CALL_UNMARKALL = 0x8013119b,
    META_E_GENERICPARAM_INCONSISTENT = 0x8013119c,
    META_E_EVENT_COUNTS = 0x8013119d,
    META_E_PROPERTY_COUNTS = 0x8013119e,
    META_E_TYPEDEF_MISSING = 0x8013119f,
    TLBX_E_CANT_LOAD_MODULE = 0x801311a0,
    TLBX_E_CANT_LOAD_CLASS = 0x801311a1,
    TLBX_E_NULL_MODULE = 0x801311a2,
    TLBX_E_NO_CLSID_KEY = 0x801311a3,
    TLBX_E_CIRCULAR_EXPORT = 0x801311a4,
    TLBX_E_CIRCULAR_IMPORT = 0x801311a5,
    TLBX_E_BAD_NATIVETYPE = 0x801311a6,
    TLBX_E_BAD_VTABLE = 0x801311a7,
    TLBX_E_CRM_NON_STATIC = 0x801311a8,
    TLBX_E_CRM_INVALID_SIG = 0x801311a9,
    TLBX_E_CLASS_LOAD_EXCEPTION = 0x801311aa,
    TLBX_E_UNKNOWN_SIGNATURE = 0x801311ab,
    TLBX_E_REFERENCED_TYPELIB = 0x801311ac,
    TLBX_E_INVALID_NAMESPACE = 0x801311ad,
    TLBX_E_LAYOUT_ERROR = 0x801311ae,
    TLBX_E_NOTIUNKNOWN = 0x801311af,
    TLBX_E_NONVISIBLEVALUECLASS = 0x801311b0,
    TLBX_E_LPTSTR_NOT_ALLOWED = 0x801311b1,
    TLBX_E_AUTO_CS_NOT_ALLOWED = 0x801311b2,
    TLBX_E_ENUM_VALUE_INVALID = 0x801311b5,
    TLBX_E_DUPLICATE_IID = 0x801311b6,
    TLBX_E_NO_NESTED_ARRAYS = 0x801311b7,
    TLBX_E_PARAM_ERROR_NAMED = 0x801311b8,
    TLBX_E_PARAM_ERROR_UNNAMED = 0x801311b9,
    TLBX_E_AGNOST_SIGNATURE = 0x801311ba,
    TLBX_E_CONVERT_FAIL = 0x801311bb,
    TLBX_W_DUAL_NOT_DISPATCH = 0x801311bc,
    TLBX_E_BAD_SIGNATURE = 0x801311bd,
    TLBX_E_ARRAY_NEEDS_NT_FIXED = 0x801311be,
    TLBX_E_CLASS_NEEDS_NT_INTF = 0x801311bf,
    META_E_CA_INVALID_TARGET = 0x801311c0,
    META_E_CA_INVALID_VALUE = 0x801311c1,
    META_E_CA_INVALID_BLOB = 0x801311c2,
    META_E_CA_REPEATED_ARG = 0x801311c3,
    META_E_CA_UNKNOWN_ARGUMENT = 0x801311c4,
    META_E_CA_VARIANT_NYI = 0x801311c5,
    META_E_CA_ARRAY_NYI = 0x801311c6,
    META_E_CA_UNEXPECTED_TYPE = 0x801311c7,
    META_E_CA_INVALID_ARGTYPE = 0x801311c8,
    META_E_CA_INVALID_ARG_FOR_TYPE = 0x801311c9,
    META_E_CA_INVALID_UUID = 0x801311ca,
    META_E_CA_INVALID_MARSHALAS_FIELDS = 0x801311cb,
    META_E_CA_NT_FIELDONLY = 0x801311cc,
    META_E_CA_NEGATIVE_PARAMINDEX = 0x801311cd,
    META_E_CA_NEGATIVE_MULTIPLIER = 0x801311ce,
    META_E_CA_NEGATIVE_CONSTSIZE = 0x801311cf,
    META_E_CA_FIXEDSTR_SIZE_REQUIRED = 0x801311d0,
    META_E_CA_CUSTMARSH_TYPE_REQUIRED = 0x801311d1,
    META_E_CA_FILENAME_REQUIRED = 0x801311d2,
    TLBX_W_NO_PROPS_IN_EVENTS = 0x801311d3,
    META_E_NOT_IN_ENC_MODE = 0x801311d4,
    META_E_METHOD_COUNTS = 0x801311d6,
    META_E_FIELD_COUNTS = 0x801311d7,
    META_E_PARAM_COUNTS = 0x801311d8,
    TLBX_E_TYPED_REF = 0x801311da,
    TLBX_E_BITNESS_MISMATCH = 0x801311e1,
    TLBX_E_EVENT_WITH_NEWENUM = 0x801311e2,
    TLBX_E_PROPGET_WITHOUT_RETURN = 0x801311e3,
    META_E_MISMATCHED_VISIBLITY = 0x801311e4,
    META_E_CA_BAD_FRIENDS_ARGS = 0x801311e5,
    META_E_CA_FRIENDS_SN_REQUIRED = 0x801311e6,
    VLDTR_E_RID_OUTOFRANGE = 0x80131203,
    VLDTR_E_CDTKN_OUTOFRANGE = 0x80131204,
    VLDTR_E_CDRID_OUTOFRANGE = 0x80131205,
    VLDTR_E_STRING_INVALID = 0x80131206,
    VLDTR_E_GUID_INVALID = 0x80131207,
    VLDTR_E_BLOB_INVALID = 0x80131208,
    VLDTR_E_MOD_MULTI = 0x80131209,
    VLDTR_E_MOD_NULLMVID = 0x8013120a,
    VLDTR_E_TR_NAMENULL = 0x8013120b,
    VLDTR_E_TR_DUP = 0x8013120c,
    VLDTR_E_TD_NAMENULL = 0x8013120d,
    VLDTR_E_TD_DUPNAME = 0x8013120e,
    VLDTR_E_TD_DUPGUID = 0x8013120f,
    VLDTR_E_TD_NOTIFACEOBJEXTNULL = 0x80131210,
    VLDTR_E_TD_OBJEXTENDSNONNULL = 0x80131211,
    VLDTR_E_TD_EXTENDSSEALED = 0x80131212,
    VLDTR_E_TD_DLTNORTSPCL = 0x80131213,
    VLDTR_E_TD_RTSPCLNOTDLT = 0x80131214,
    VLDTR_E_MI_DECLPRIV = 0x80131215,
    VLDTR_E_AS_BADNAME = 0x80131216,
    VLDTR_E_FILE_SYSNAME = 0x80131217,
    VLDTR_E_MI_BODYSTATIC = 0x80131218,
    VLDTR_E_TD_IFACENOTABS = 0x80131219,
    VLDTR_E_TD_IFACEPARNOTNIL = 0x8013121a,
    VLDTR_E_TD_IFACEGUIDNULL = 0x8013121b,
    VLDTR_E_MI_DECLFINAL = 0x8013121c,
    VLDTR_E_TD_VTNOTSEAL = 0x8013121d,
    VLDTR_E_PD_BADFLAGS = 0x8013121e,
    VLDTR_E_IFACE_DUP = 0x8013121f,
    VLDTR_E_MR_NAMENULL = 0x80131220,
    VLDTR_E_MR_VTBLNAME = 0x80131221,
    VLDTR_E_MR_DELNAME = 0x80131222,
    VLDTR_E_MR_PARNIL = 0x80131223,
    VLDTR_E_MR_BADCALLINGCONV = 0x80131224,
    VLDTR_E_MR_NOTVARARG = 0x80131225,
    VLDTR_E_MR_NAMEDIFF = 0x80131226,
    VLDTR_E_MR_SIGDIFF = 0x80131227,
    VLDTR_E_MR_DUP = 0x80131228,
    VLDTR_E_CL_TDAUTO = 0x80131229,
    VLDTR_E_CL_BADPCKSZ = 0x8013122a,
    VLDTR_E_CL_DUP = 0x8013122b,
    VLDTR_E_FL_BADOFFSET = 0x8013122c,
    VLDTR_E_FL_TDNIL = 0x8013122d,
    VLDTR_E_FL_NOCL = 0x8013122e,
    VLDTR_E_FL_TDNOTEXPLCT = 0x8013122f,
    VLDTR_E_FL_FLDSTATIC = 0x80131230,
    VLDTR_E_FL_DUP = 0x80131231,
    VLDTR_E_MODREF_NAMENULL = 0x80131232,
    VLDTR_E_MODREF_DUP = 0x80131233,
    VLDTR_E_TR_BADSCOPE = 0x80131234,
    VLDTR_E_TD_NESTEDNOENCL = 0x80131235,
    VLDTR_E_TD_EXTTRRES = 0x80131236,
    VLDTR_E_SIGNULL = 0x80131237,
    VLDTR_E_SIGNODATA = 0x80131238,
    VLDTR_E_MD_BADCALLINGCONV = 0x80131239,
    VLDTR_E_MD_THISSTATIC = 0x8013123a,
    VLDTR_E_MD_NOTTHISNOTSTATIC = 0x8013123b,
    VLDTR_E_MD_NOARGCNT = 0x8013123c,
    VLDTR_E_SIG_MISSELTYPE = 0x8013123d,
    VLDTR_E_SIG_MISSTKN = 0x8013123e,
    VLDTR_E_SIG_TKNBAD = 0x8013123f,
    VLDTR_E_SIG_MISSFPTR = 0x80131240,
    VLDTR_E_SIG_MISSFPTRARGCNT = 0x80131241,
    VLDTR_E_SIG_MISSRANK = 0x80131242,
    VLDTR_E_SIG_MISSNSIZE = 0x80131243,
    VLDTR_E_SIG_MISSSIZE = 0x80131244,
    VLDTR_E_SIG_MISSNLBND = 0x80131245,
    VLDTR_E_SIG_MISSLBND = 0x80131246,
    VLDTR_E_SIG_BADELTYPE = 0x80131247,
    VLDTR_E_SIG_MISSVASIZE = 0x80131248,
    VLDTR_E_FD_BADCALLINGCONV = 0x80131249,
    VLDTR_E_MD_NAMENULL = 0x8013124a,
    VLDTR_E_MD_PARNIL = 0x8013124b,
    VLDTR_E_MD_DUP = 0x8013124c,
    VLDTR_E_FD_NAMENULL = 0x8013124d,
    VLDTR_E_FD_PARNIL = 0x8013124e,
    VLDTR_E_FD_DUP = 0x8013124f,
    VLDTR_E_AS_MULTI = 0x80131250,
    VLDTR_E_AS_NAMENULL = 0x80131251,
    VLDTR_E_SIG_TOKTYPEMISMATCH = 0x80131252,
    VLDTR_E_CL_TDINTF = 0x80131253,
    VLDTR_E_ASOS_OSPLTFRMIDINVAL = 0x80131254,
    VLDTR_E_AR_NAMENULL = 0x80131255,
    VLDTR_E_TD_ENCLNOTNESTED = 0x80131256,
    VLDTR_E_AROS_OSPLTFRMIDINVAL = 0x80131257,
    VLDTR_E_FILE_NAMENULL = 0x80131258,
    VLDTR_E_CT_NAMENULL = 0x80131259,
    VLDTR_E_TD_EXTENDSCHILD = 0x8013125a,
    VLDTR_E_MAR_NAMENULL = 0x8013125b,
    VLDTR_E_FILE_DUP = 0x8013125c,
    VLDTR_E_FILE_NAMEFULLQLFD = 0x8013125d,
    VLDTR_E_CT_DUP = 0x8013125e,
    VLDTR_E_MAR_DUP = 0x8013125f,
    VLDTR_E_MAR_NOTPUBPRIV = 0x80131260,
    VLDTR_E_TD_ENUMNOVALUE = 0x80131261,
    VLDTR_E_TD_ENUMVALSTATIC = 0x80131262,
    VLDTR_E_TD_ENUMVALNOTSN = 0x80131263,
    VLDTR_E_TD_ENUMFLDNOTST = 0x80131264,
    VLDTR_E_TD_ENUMFLDNOTLIT = 0x80131265,
    VLDTR_E_TD_ENUMNOLITFLDS = 0x80131266,
    VLDTR_E_TD_ENUMFLDSIGMISMATCH = 0x80131267,
    VLDTR_E_TD_ENUMVALNOT1ST = 0x80131268,
    VLDTR_E_FD_NOTVALUERTSN = 0x80131269,
    VLDTR_E_FD_VALUEPARNOTENUM = 0x8013126a,
    VLDTR_E_FD_INSTINIFACE = 0x8013126b,
    VLDTR_E_FD_NOTPUBINIFACE = 0x8013126c,
    VLDTR_E_FMD_GLOBALNOTPUBPRIVSC = 0x8013126d,
    VLDTR_E_FMD_GLOBALNOTSTATIC = 0x8013126e,
    VLDTR_E_FD_GLOBALNORVA = 0x8013126f,
    VLDTR_E_MD_CTORZERORVA = 0x80131270,
    VLDTR_E_FD_MARKEDNOMARSHAL = 0x80131271,
    VLDTR_E_FD_MARSHALNOTMARKED = 0x80131272,
    VLDTR_E_FD_MARKEDNODEFLT = 0x80131273,
    VLDTR_E_FD_DEFLTNOTMARKED = 0x80131274,
    VLDTR_E_FMD_MARKEDNOSECUR = 0x80131275,
    VLDTR_E_FMD_SECURNOTMARKED = 0x80131276,
    VLDTR_E_FMD_PINVOKENOTSTATIC = 0x80131277,
    VLDTR_E_FMD_MARKEDNOPINVOKE = 0x80131278,
    VLDTR_E_FMD_PINVOKENOTMARKED = 0x80131279,
    VLDTR_E_FMD_BADIMPLMAP = 0x8013127a,
    VLDTR_E_IMAP_BADMODREF = 0x8013127b,
    VLDTR_E_IMAP_BADMEMBER = 0x8013127c,
    VLDTR_E_IMAP_BADIMPORTNAME = 0x8013127d,
    VLDTR_E_IMAP_BADCALLCONV = 0x8013127e,
    VLDTR_E_FMD_BADACCESSFLAG = 0x8013127f,
    VLDTR_E_FD_INITONLYANDLITERAL = 0x80131280,
    VLDTR_E_FD_LITERALNOTSTATIC = 0x80131281,
    VLDTR_E_FMD_RTSNNOTSN = 0x80131282,
    VLDTR_E_MD_ABSTPARNOTABST = 0x80131283,
    VLDTR_E_MD_NOTSTATABSTININTF = 0x80131284,
    VLDTR_E_MD_NOTPUBININTF = 0x80131285,
    VLDTR_E_MD_CTORININTF = 0x80131286,
    VLDTR_E_MD_GLOBALCTORCCTOR = 0x80131287,
    VLDTR_E_MD_CTORSTATIC = 0x80131288,
    VLDTR_E_MD_CTORNOTSNRTSN = 0x80131289,
    VLDTR_E_MD_CTORVIRT = 0x8013128a,
    VLDTR_E_MD_CTORABST = 0x8013128b,
    VLDTR_E_MD_CCTORNOTSTATIC = 0x8013128c,
    VLDTR_E_MD_ZERORVA = 0x8013128d,
    VLDTR_E_MD_FINNOTVIRT = 0x8013128e,
    VLDTR_E_MD_STATANDFINORVIRT = 0x8013128f,
    VLDTR_E_MD_ABSTANDFINAL = 0x80131290,
    VLDTR_E_MD_ABSTANDIMPL = 0x80131291,
    VLDTR_E_MD_ABSTANDPINVOKE = 0x80131292,
    VLDTR_E_MD_ABSTNOTVIRT = 0x80131293,
    VLDTR_E_MD_NOTABSTNOTIMPL = 0x80131294,
    VLDTR_E_MD_NOTABSTBADFLAGSRVA = 0x80131295,
    VLDTR_E_MD_PRIVSCOPENORVA = 0x80131296,
    VLDTR_E_MD_GLOBALABSTORVIRT = 0x80131297,
    VLDTR_E_SIG_LONGFORM = 0x80131298,
    VLDTR_E_MD_MULTIPLESEMANTICS = 0x80131299,
    VLDTR_E_MD_INVALIDSEMANTICS = 0x8013129a,
    VLDTR_E_MD_SEMANTICSNOTEXIST = 0x8013129b,
    VLDTR_E_MI_DECLNOTVIRT = 0x8013129c,
    VLDTR_E_FMD_GLOBALITEM = 0x8013129d,
    VLDTR_E_MD_MULTSEMANTICFLAGS = 0x8013129e,
    VLDTR_E_MD_NOSEMANTICFLAGS = 0x8013129f,
    VLDTR_E_FD_FLDINIFACE = 0x801312a0,
    VLDTR_E_AS_HASHALGID = 0x801312a1,
    VLDTR_E_AS_PROCID = 0x801312a2,
    VLDTR_E_AR_PROCID = 0x801312a3,
    VLDTR_E_CN_PARENTRANGE = 0x801312a4,
    VLDTR_E_AS_BADFLAGS = 0x801312a5,
    VLDTR_E_TR_HASTYPEDEF = 0x801312a6,
    VLDTR_E_IFACE_BADIMPL = 0x801312a7,
    VLDTR_E_IFACE_BADIFACE = 0x801312a8,
    VLDTR_E_TD_SECURNOTMARKED = 0x801312a9,
    VLDTR_E_TD_MARKEDNOSECUR = 0x801312aa,
    VLDTR_E_MD_CCTORHASARGS = 0x801312ab,
    VLDTR_E_CT_BADIMPL = 0x801312ac,
    VLDTR_E_MI_ALIENBODY = 0x801312ad,
    VLDTR_E_MD_CCTORCALLCONV = 0x801312ae,
    VLDTR_E_MI_BADCLASS = 0x801312af,
    VLDTR_E_MI_CLASSISINTF = 0x801312b0,
    VLDTR_E_MI_BADDECL = 0x801312b1,
    VLDTR_E_MI_BADBODY = 0x801312b2,
    VLDTR_E_MI_DUP = 0x801312b3,
    VLDTR_E_FD_BADPARENT = 0x801312b4,
    VLDTR_E_MD_PARAMOUTOFSEQ = 0x801312b5,
    VLDTR_E_MD_PARASEQTOOBIG = 0x801312b6,
    VLDTR_E_MD_PARMMARKEDNOMARSHAL = 0x801312b7,
    VLDTR_E_MD_PARMMARSHALNOTMARKED = 0x801312b8,
    VLDTR_E_MD_PARMMARKEDNODEFLT = 0x801312ba,
    VLDTR_E_MD_PARMDEFLTNOTMARKED = 0x801312bb,
    VLDTR_E_PR_BADSCOPE = 0x801312bc,
    VLDTR_E_PR_NONAME = 0x801312bd,
    VLDTR_E_PR_NOSIG = 0x801312be,
    VLDTR_E_PR_DUP = 0x801312bf,
    VLDTR_E_PR_BADCALLINGCONV = 0x801312c0,
    VLDTR_E_PR_MARKEDNODEFLT = 0x801312c1,
    VLDTR_E_PR_DEFLTNOTMARKED = 0x801312c2,
    VLDTR_E_PR_BADSEMANTICS = 0x801312c3,
    VLDTR_E_PR_BADMETHOD = 0x801312c4,
    VLDTR_E_PR_ALIENMETHOD = 0x801312c5,
    VLDTR_E_CN_BLOBNOTNULL = 0x801312c6,
    VLDTR_E_CN_BLOBNULL = 0x801312c7,
    VLDTR_E_EV_BADSCOPE = 0x801312c8,
    VLDTR_E_EV_NONAME = 0x801312ca,
    VLDTR_E_EV_DUP = 0x801312cb,
    VLDTR_E_EV_BADEVTYPE = 0x801312cc,
    VLDTR_E_EV_EVTYPENOTCLASS = 0x801312cd,
    VLDTR_E_EV_BADSEMANTICS = 0x801312ce,
    VLDTR_E_EV_BADMETHOD = 0x801312cf,
    VLDTR_E_EV_ALIENMETHOD = 0x801312d0,
    VLDTR_E_EV_NOADDON = 0x801312d1,
    VLDTR_E_EV_NOREMOVEON = 0x801312d2,
    VLDTR_E_CT_DUPTDNAME = 0x801312d3,
    VLDTR_E_MAR_BADOFFSET = 0x801312d4,
    VLDTR_E_DS_BADOWNER = 0x801312d5,
    VLDTR_E_DS_BADFLAGS = 0x801312d6,
    VLDTR_E_DS_NOBLOB = 0x801312d7,
    VLDTR_E_MAR_BADIMPL = 0x801312d8,
    VLDTR_E_MR_VARARGCALLINGCONV = 0x801312da,
    VLDTR_E_MD_CTORNOTVOID = 0x801312db,
    VLDTR_E_EV_FIRENOTVOID = 0x801312dc,
    VLDTR_E_AS_BADLOCALE = 0x801312dd,
    VLDTR_E_CN_PARENTTYPE = 0x801312de,
    VLDTR_E_SIG_SENTINMETHODDEF = 0x801312df,
    VLDTR_E_SIG_SENTMUSTVARARG = 0x801312e0,
    VLDTR_E_SIG_MULTSENTINELS = 0x801312e1,
    VLDTR_E_SIG_LASTSENTINEL = 0x801312e2,
    VLDTR_E_SIG_MISSARG = 0x801312e3,
    VLDTR_E_SIG_BYREFINFIELD = 0x801312e4,
    VLDTR_E_MD_SYNCMETHODINVTYPE = 0x801312e5,
    VLDTR_E_TD_NAMETOOLONG = 0x801312e6,
    VLDTR_E_AS_PROCDUP = 0x801312e7,
    VLDTR_E_ASOS_DUP = 0x801312e8,
    VLDTR_E_MAR_BADFLAGS = 0x801312e9,
    VLDTR_E_CT_NOTYPEDEFID = 0x801312ea,
    VLDTR_E_FILE_BADFLAGS = 0x801312eb,
    VLDTR_E_FILE_NULLHASH = 0x801312ec,
    VLDTR_E_MOD_NONAME = 0x801312ed,
    VLDTR_E_MOD_NAMEFULLQLFD = 0x801312ee,
    VLDTR_E_TD_RTSPCLNOTSPCL = 0x801312ef,
    VLDTR_E_TD_EXTENDSIFACE = 0x801312f0,
    VLDTR_E_MD_CTORPINVOKE = 0x801312f1,
    VLDTR_E_TD_SYSENUMNOTCLASS = 0x801312f2,
    VLDTR_E_TD_SYSENUMNOTEXTVTYPE = 0x801312f3,
    VLDTR_E_MI_SIGMISMATCH = 0x801312f4,
    VLDTR_E_TD_ENUMHASMETHODS = 0x801312f5,
    VLDTR_E_TD_ENUMIMPLIFACE = 0x801312f6,
    VLDTR_E_TD_ENUMHASPROP = 0x801312f7,
    VLDTR_E_TD_ENUMHASEVENT = 0x801312f8,
    VLDTR_E_TD_BADMETHODLST = 0x801312f9,
    VLDTR_E_TD_BADFIELDLST = 0x801312fa,
    VLDTR_E_CN_BADTYPE = 0x801312fb,
    VLDTR_E_TD_ENUMNOINSTFLD = 0x801312fc,
    VLDTR_E_TD_ENUMMULINSTFLD = 0x801312fd,
    VLDTR_E_INTERRUPTED = 0x801312fe,
    VLDTR_E_NOTINIT = 0x801312ff,
    CORDBG_E_UNRECOVERABLE_ERROR = 0x80131300,
    CORDBG_E_PROCESS_TERMINATED = 0x80131301,
    CORDBG_E_PROCESS_NOT_SYNCHRONIZED = 0x80131302,
    CORDBG_E_CLASS_NOT_LOADED = 0x80131303,
    CORDBG_E_IL_VAR_NOT_AVAILABLE = 0x80131304,
    CORDBG_E_BAD_REFERENCE_VALUE = 0x80131305,
    CORDBG_E_FIELD_NOT_AVAILABLE = 0x80131306,
    CORDBG_E_NON_NATIVE_FRAME = 0x80131307,
    CORDBG_E_NONCONTINUABLE_EXCEPTION = 0x80131308,
    CORDBG_E_CODE_NOT_AVAILABLE = 0x80131309,
    CORDBG_E_FUNCTION_NOT_IL = 0x8013130a,
    CORDBG_E_CANT_SET_IP_INTO_FINALLY = 0x8013130e,
    CORDBG_E_CANT_SET_IP_OUT_OF_FINALLY = 0x8013130f,
    CORDBG_E_CANT_SET_IP_INTO_CATCH = 0x80131310,
    CORDBG_E_SET_IP_NOT_ALLOWED_ON_NONLEAF_FRAME = 0x80131311,
    CORDBG_E_SET_IP_IMPOSSIBLE = 0x80131312,
    CORDBG_E_FUNC_EVAL_BAD_START_POINT = 0x80131313,
    CORDBG_E_INVALID_OBJECT = 0x80131314,
    CORDBG_E_FUNC_EVAL_NOT_COMPLETE = 0x80131315,
    CORDBG_E_INPROC_NOT_IMPL = 0x80131318,
    CORDBG_E_STATIC_VAR_NOT_AVAILABLE = 0x8013131a,
    CORDBG_E_OBJECT_IS_NOT_COPYABLE_VALUE_CLASS = 0x8013131b,
    CORDBG_E_CANT_SETIP_INTO_OR_OUT_OF_FILTER = 0x8013131c,
    CORDBG_E_CANT_CHANGE_JIT_SETTING_FOR_ZAP_MODULE = 0x8013131d,
    CORDBG_E_CANT_SET_IP_OUT_OF_FINALLY_ON_WIN64 = 0x8013131e,
    CORDBG_E_CANT_SET_IP_OUT_OF_CATCH_ON_WIN64 = 0x8013131f,
    CORDBG_E_REMOTE_CONNECTION_CONN_RESET = 0x80131320,
    CORDBG_E_REMOTE_CONNECTION_KEEP_ALIVE = 0x80131321,
    CORDBG_E_REMOTE_CONNECTION_FATAL_ERROR = 0x80131322,
    CORDBG_E_CANT_SET_TO_JMC = 0x80131323,
    CORDBG_E_NO_CONTEXT_FOR_INTERNAL_FRAME = 0x80131325,
    CORDBG_E_NOT_CHILD_FRAME = 0x80131326,
    CORDBG_E_NON_MATCHING_CONTEXT = 0x80131327,
    CORDBG_E_PAST_END_OF_STACK = 0x80131328,
    CORDBG_E_FUNC_EVAL_CANNOT_UPDATE_REGISTER_IN_NONLEAF_FRAME = 0x80131329,
    CORDBG_E_BAD_THREAD_STATE = 0x8013132d,
    CORDBG_E_DEBUGGER_ALREADY_ATTACHED = 0x8013132e,
    CORDBG_E_SUPERFLOUS_CONTINUE = 0x8013132f,
    CORDBG_E_SET_VALUE_NOT_ALLOWED_ON_NONLEAF_FRAME = 0x80131330,
    CORDBG_E_ENC_EH_MAX_NESTING_LEVEL_CANT_INCREASE = 0x80131331,
    CORDBG_E_ENC_MODULE_NOT_ENC_ENABLED = 0x80131332,
    CORDBG_E_SET_IP_NOT_ALLOWED_ON_EXCEPTION = 0x80131333,
    CORDBG_E_VARIABLE_IS_ACTUALLY_LITERAL = 0x80131334,
    CORDBG_E_PROCESS_DETACHED = 0x80131335,
    CORDBG_E_ENC_METHOD_SIG_CHANGED = 0x80131336,
    CORDBG_E_ENC_METHOD_NO_LOCAL_SIG = 0x80131337,
    CORDBG_E_ENC_CANT_ADD_FIELD_TO_VALUE_OR_LAYOUT_CLASS = 0x80131338,
    CORDBG_E_ENC_CANT_CHANGE_FIELD = 0x80131339,
    CORDBG_E_ENC_CANT_ADD_NON_PRIVATE_MEMBER = 0x8013133a,
    CORDBG_E_FIELD_NOT_STATIC = 0x8013133b,
    CORDBG_E_FIELD_NOT_INSTANCE = 0x8013133c,
    CORDBG_E_ENC_ZAPPED_WITHOUT_ENC = 0x8013133d,
    CORDBG_E_ENC_BAD_METHOD_INFO = 0x8013133e,
    CORDBG_E_ENC_JIT_CANT_UPDATE = 0x8013133f,
    CORDBG_E_ENC_MISSING_CLASS = 0x80131340,
    CORDBG_E_ENC_INTERNAL_ERROR = 0x80131341,
    CORDBG_E_ENC_HANGING_FIELD = 0x80131342,
    CORDBG_E_MODULE_NOT_LOADED = 0x80131343,
    CORDBG_E_ENC_CANT_CHANGE_SUPERCLASS = 0x80131344,
    CORDBG_E_UNABLE_TO_SET_BREAKPOINT = 0x80131345,
    CORDBG_E_DEBUGGING_NOT_POSSIBLE = 0x80131346,
    CORDBG_E_KERNEL_DEBUGGER_ENABLED = 0x80131347,
    CORDBG_E_KERNEL_DEBUGGER_PRESENT = 0x80131348,
    CORDBG_E_HELPER_THREAD_DEAD = 0x80131349,
    CORDBG_E_INTERFACE_INHERITANCE_CANT_CHANGE = 0x8013134a,
    CORDBG_E_INCOMPATIBLE_PROTOCOL = 0x8013134b,
    CORDBG_E_TOO_MANY_PROCESSES = 0x8013134c,
    CORDBG_E_INTEROP_NOT_SUPPORTED = 0x8013134d,
    CORDBG_E_NO_REMAP_BREAKPIONT = 0x8013134e,
    CORDBG_E_OBJECT_NEUTERED = 0x8013134f,
    CORPROF_E_FUNCTION_NOT_COMPILED = 0x80131350,
    CORPROF_E_DATAINCOMPLETE = 0x80131351,
    CORPROF_E_NOT_REJITABLE_METHODS = 0x80131352,
    CORPROF_E_CANNOT_UPDATE_METHOD = 0x80131353,
    CORPROF_E_FUNCTION_NOT_IL = 0x80131354,
    CORPROF_E_NOT_MANAGED_THREAD = 0x80131355,
    CORPROF_E_CALL_ONLY_FROM_INIT = 0x80131356,
    CORPROF_E_INPROC_NOT_ENABLED = 0x80131357,
    CORPROF_E_JITMAPS_NOT_ENABLED = 0x80131358,
    CORPROF_E_INPROC_ALREADY_BEGUN = 0x80131359,
    CORPROF_E_INPROC_NOT_AVAILABLE = 0x8013135a,
    CORPROF_E_NOT_YET_AVAILABLE = 0x8013135b,
    CORPROF_E_TYPE_IS_PARAMETERIZED = 0x8013135c,
    CORPROF_E_FUNCTION_IS_PARAMETERIZED = 0x8013135d,
    CORPROF_E_STACKSNAPSHOT_INVALID_TGT_THREAD = 0x8013135e,
    CORPROF_E_STACKSNAPSHOT_UNMANAGED_CTX = 0x8013135f,
    CORPROF_E_STACKSNAPSHOT_UNSAFE = 0x80131360,
    CORPROF_E_STACKSNAPSHOT_ABORTED = 0x80131361,
    CORPROF_E_LITERALS_HAVE_NO_ADDRESS = 0x80131362,
    CORPROF_E_UNSUPPORTED_CALL_SEQUENCE = 0x80131363,
    CORPROF_E_ASYNCHRONOUS_UNSAFE = 0x80131364,
    CORPROF_E_CLASSID_IS_ARRAY = 0x80131365,
    CORPROF_E_CLASSID_IS_COMPOSITE = 0x80131366,
    CORPROF_E_PROFILER_DETACHING = 0x80131367,
    CORPROF_E_PROFILER_NOT_ATTACHABLE = 0x80131368,
    CORPROF_E_UNRECOGNIZED_PIPE_MSG_FORMAT = 0x80131369,
    CORPROF_E_PROFILER_ALREADY_ACTIVE = 0x8013136a,
    CORPROF_E_PROFILEE_INCOMPATIBLE_WITH_TRIGGER = 0x8013136b,
    CORPROF_E_IPC_FAILED = 0x8013136c,
    CORPROF_E_PROFILEE_PROCESS_NOT_FOUND = 0x8013136d,
    CORPROF_E_CALLBACK3_REQUIRED = 0x8013136e,
    CORPROF_E_UNSUPPORTED_FOR_ATTACHING_PROFILER = 0x8013136f,
    CORPROF_E_IRREVERSIBLE_INSTRUMENTATION_PRESENT = 0x80131370,
    CORPROF_E_RUNTIME_UNINITIALIZED = 0x80131371,
    CORPROF_E_IMMUTABLE_FLAGS_SET = 0x80131372,
    CORPROF_E_PROFILER_NOT_YET_INITIALIZED = 0x80131373,
    CORPROF_E_INCONSISTENT_WITH_FLAGS = 0x80131374,
    CORPROF_E_PROFILER_CANCEL_ACTIVATION = 0x80131375,
    CORPROF_E_CONCURRENT_GC_NOT_PROFILABLE = 0x80131376,
    CORPROF_E_INCONSISTENT_FLAGS_WITH_HOST_PROTECTION_SETTING = 0x80131377,
    CORPROF_E_DEBUGGING_DISABLED = 0x80131378,
    CORPROF_E_TIMEOUT_WAITING_FOR_CONCURRENT_GC = 0x80131379,
    CORPROF_E_MODULE_IS_DYNAMIC = 0x8013137a,
    CORPROF_E_CALLBACK4_REQUIRED = 0x8013137b,
    CORPROF_E_REJIT_NOT_ENABLED = 0x8013137c,
    CORPROF_E_ACTIVE_REJIT_REQUEST_NOT_FOUND = 0x8013137d,
    CORPROF_E_FUNCTION_IS_COLLECTIBLE = 0x8013137e,
    CORPROF_E_REJIT_REQUIRES_DISABLE_NGEN = 0x8013137f,
    CORPROF_E_CALLBACK6_REQUIRED = 0x80131380,
    CORPROF_E_CALLBACK7_REQUIRED = 0x80131382,
    SECURITY_E_XML_TO_ASN_ENCODING = 0x80131400,
    SECURITY_E_INCOMPATIBLE_SHARE = 0x80131401,
    SECURITY_E_UNVERIFIABLE = 0x80131402,
    SECURITY_E_INCOMPATIBLE_EVIDENCE = 0x80131403,
    CORSEC_E_DECODE_SET = 0x80131410,
    CORSEC_E_ENCODE_SET = 0x80131411,
    CORSEC_E_UNSUPPORTED_FORMAT = 0x80131412,
    SN_CRYPTOAPI_CALL_FAILED = 0x80131413,
    CORSEC_E_CRYPTOAPI_CALL_FAILED = 0x80131413,
    SN_NO_SUITABLE_CSP = 0x80131414,
    CORSEC_E_NO_SUITABLE_CSP = 0x80131414,
    CORSEC_E_INVALID_ATTR = 0x80131415,
    CORSEC_E_POLICY_EXCEPTION = 0x80131416,
    CORSEC_E_MIN_GRANT_FAIL = 0x80131417,
    CORSEC_E_NO_EXEC_PERM = 0x80131418,
    CORSEC_E_XMLSYNTAX = 0x80131419,
    CORSEC_E_INVALID_STRONGNAME = 0x8013141a,
    CORSEC_E_MISSING_STRONGNAME = 0x8013141b,
    CORSEC_E_CONTAINER_NOT_FOUND = 0x8013141c,
    CORSEC_E_INVALID_IMAGE_FORMAT = 0x8013141d,
    CORSEC_E_INVALID_PUBLICKEY = 0x8013141e,
    CORSEC_E_SIGNATURE_MISMATCH = 0x80131420,
    SN_E_PUBLICKEY_MISMATCH = 0x80131421,
    CORSEC_E_INVALID_SIGNATUREKEY = 0x80131422,
    CORSEC_E_INVALID_COUNTERSIGNATURE = 0x80131423,
    CORSEC_E_CRYPTO = 0x80131430,
    CORSEC_E_CRYPTO_UNEX_OPER = 0x80131431,
    CORSECATTR_E_BAD_ATTRIBUTE = 0x8013143a,
    CORSECATTR_E_MISSING_CONSTRUCTOR = 0x8013143b,
    CORSECATTR_E_FAILED_TO_CREATE_PERM = 0x8013143c,
    CORSECATTR_E_BAD_ACTION_ASM = 0x8013143d,
    CORSECATTR_E_BAD_ACTION_OTHER = 0x8013143e,
    CORSECATTR_E_BAD_PARENT = 0x8013143f,
    CORSECATTR_E_TRUNCATED = 0x80131440,
    CORSECATTR_E_BAD_VERSION = 0x80131441,
    CORSECATTR_E_BAD_ACTION = 0x80131442,
    CORSECATTR_E_NO_SELF_REF = 0x80131443,
    CORSECATTR_E_BAD_NONCAS = 0x80131444,
    CORSECATTR_E_ASSEMBLY_LOAD_FAILED = 0x80131445,
    CORSECATTR_E_ASSEMBLY_LOAD_FAILED_EX = 0x80131446,
    CORSECATTR_E_TYPE_LOAD_FAILED = 0x80131447,
    CORSECATTR_E_TYPE_LOAD_FAILED_EX = 0x80131448,
    CORSECATTR_E_ABSTRACT = 0x80131449,
    CORSECATTR_E_UNSUPPORTED_TYPE = 0x8013144a,
    CORSECATTR_E_UNSUPPORTED_ENUM_TYPE = 0x8013144b,
    CORSECATTR_E_NO_FIELD = 0x8013144c,
    CORSECATTR_E_NO_PROPERTY = 0x8013144d,
    CORSECATTR_E_EXCEPTION = 0x8013144e,
    CORSECATTR_E_EXCEPTION_HR = 0x8013144f,
    ISS_E_ISOSTORE_START = 0x80131450,
    ISS_E_ISOSTORE = 0x80131450,
    ISS_E_OPEN_STORE_FILE = 0x80131460,
    ISS_E_OPEN_FILE_MAPPING = 0x80131461,
    ISS_E_MAP_VIEW_OF_FILE = 0x80131462,
    ISS_E_GET_FILE_SIZE = 0x80131463,
    ISS_E_CREATE_MUTEX = 0x80131464,
    ISS_E_LOCK_FAILED = 0x80131465,
    ISS_E_FILE_WRITE = 0x80131466,
    ISS_E_SET_FILE_POINTER = 0x80131467,
    ISS_E_CREATE_DIR = 0x80131468,
    ISS_E_STORE_NOT_OPEN = 0x80131469,
    ISS_E_CORRUPTED_STORE_FILE = 0x80131480,
    ISS_E_STORE_VERSION = 0x80131481,
    ISS_E_FILE_NOT_MAPPED = 0x80131482,
    ISS_E_BLOCK_SIZE_TOO_SMALL = 0x80131483,
    ISS_E_ALLOC_TOO_LARGE = 0x80131484,
    ISS_E_USAGE_WILL_EXCEED_QUOTA = 0x80131485,
    ISS_E_TABLE_ROW_NOT_FOUND = 0x80131486,
    ISS_E_DEPRECATE = 0x801314a0,
    ISS_E_CALLER = 0x801314a1,
    ISS_E_PATH_LENGTH = 0x801314a2,
    ISS_E_MACHINE = 0x801314a3,
    ISS_E_MACHINE_DACL = 0x801314a4,
    ISS_E_ISOSTORE_END = 0x801314ff,
    COR_E_EXCEPTION = 0x80131500,
    COR_E_SYSTEM = 0x80131501,
    COR_E_ARGUMENTOUTOFRANGE = 0x80131502,
    COR_E_ARRAYTYPEMISMATCH = 0x80131503,
    COR_E_CONTEXTMARSHAL = 0x80131504,
    COR_E_TIMEOUT = 0x80131505,
    COR_E_EXECUTIONENGINE = 0x80131506,
    COR_E_FIELDACCESS = 0x80131507,
    COR_E_INDEXOUTOFRANGE = 0x80131508,
    COR_E_INVALIDOPERATION = 0x80131509,
    COR_E_SECURITY = 0x8013150a,
    COR_E_REMOTING = 0x8013150b,
    COR_E_SERIALIZATION = 0x8013150c,
    COR_E_VERIFICATION = 0x8013150d,
    COR_E_SERVER = 0x8013150e,
    COR_E_SERVICEDCOMPONENT = 0x8013150f,
    COR_E_METHODACCESS = 0x80131510,
    COR_E_MISSINGFIELD = 0x80131511,
    COR_E_MISSINGMEMBER = 0x80131512,
    COR_E_MISSINGMETHOD = 0x80131513,
    COR_E_MULTICASTNOTSUPPORTED = 0x80131514,
    COR_E_NOTSUPPORTED = 0x80131515,
    COR_E_OVERFLOW = 0x80131516,
    COR_E_RANK = 0x80131517,
    COR_E_SYNCHRONIZATIONLOCK = 0x80131518,
    COR_E_THREADINTERRUPTED = 0x80131519,
    COR_E_MEMBERACCESS = 0x8013151a,
    COR_E_THREADSTATE = 0x80131520,
    COR_E_THREADSTOP = 0x80131521,
    COR_E_TYPELOAD = 0x80131522,
    COR_E_ENTRYPOINTNOTFOUND = 0x80131523,
    COR_E_DLLNOTFOUND = 0x80131524,
    COR_E_THREADSTART = 0x80131525,
    COR_E_INVALIDCOMOBJECT = 0x80131527,
    COR_E_NOTFINITENUMBER = 0x80131528,
    COR_E_DUPLICATEWAITOBJECT = 0x80131529,
    COR_E_SEMAPHOREFULL = 0x8013152b,
    COR_E_WAITHANDLECANNOTBEOPENED = 0x8013152c,
    COR_E_ABANDONEDMUTEX = 0x8013152d,
    COR_E_THREADABORTED = 0x80131530,
    COR_E_INVALIDOLEVARIANTTYPE = 0x80131531,
    COR_E_MISSINGMANIFESTRESOURCE = 0x80131532,
    COR_E_SAFEARRAYTYPEMISMATCH = 0x80131533,
    COR_E_TYPEINITIALIZATION = 0x80131534,
    COR_E_MARSHALDIRECTIVE = 0x80131535,
    COR_E_MISSINGSATELLITEASSEMBLY = 0x80131536,
    COR_E_FORMAT = 0x80131537,
    COR_E_SAFEARRAYRANKMISMATCH = 0x80131538,
    COR_E_PLATFORMNOTSUPPORTED = 0x80131539,
    COR_E_INVALIDPROGRAM = 0x8013153a,
    COR_E_OPERATIONCANCELED = 0x8013153b,
    COR_E_INSUFFICIENTMEMORY = 0x8013153d,
    COR_E_RUNTIMEWRAPPED = 0x8013153e,
    COR_E_DEVICESNOTSUPPORTED = 0x80131540,
    COR_E_DATAMISALIGNED = 0x80131541,
    COR_E_CODECONTRACTFAILED = 0x80131542,
    COR_E_TYPEACCESS = 0x80131543,
    COR_E_ACCESSING_CCW = 0x80131544,
    COR_E_MAXMETHODSIZE = 0x80131545,
    COR_E_KEYNOTFOUND = 0x80131577,
    COR_E_INSUFFICIENTEXECUTIONSTACK = 0x80131578,
    COR_E_APPLICATION = 0x80131600,
    COR_E_INVALIDFILTERCRITERIA = 0x80131601,
    COR_E_REFLECTIONTYPELOAD = 0x80131602,
    COR_E_TARGET = 0x80131603,
    COR_E_TARGETINVOCATION = 0x80131604,
    COR_E_CUSTOMATTRIBUTEFORMAT = 0x80131605,
    COR_E_IO = 0x80131620,
    COR_E_FILELOAD = 0x80131621,
    COR_E_OBJECTDISPOSED = 0x80131622,
    COR_E_FAILFAST = 0x80131623,
    COR_E_HOSTPROTECTION = 0x80131640,
    COR_E_ILLEGAL_REENTRANCY = 0x80131641,
    CLR_E_SHIM_RUNTIMELOAD = 0x80131700,
    CLR_E_SHIM_RUNTIMEEXPORT = 0x80131701,
    CLR_E_SHIM_INSTALLROOT = 0x80131702,
    CLR_E_SHIM_INSTALLCOMP = 0x80131703,
    CLR_E_SHIM_LEGACYRUNTIMEALREADYBOUND = 0x80131704,
    CLR_E_SHIM_SHUTDOWNINPROGRESS = 0x80131705,
    VER_E_HRESULT = 0x80131801,
    VER_E_OFFSET = 0x80131802,
    VER_E_OPCODE = 0x80131803,
    VER_E_OPERAND = 0x80131804,
    VER_E_TOKEN = 0x80131805,
    VER_E_EXCEPT = 0x80131806,
    VER_E_STACK_SLOT = 0x80131807,
    VER_E_LOC = 0x80131808,
    VER_E_ARG = 0x80131809,
    VER_E_FOUND = 0x8013180a,
    VER_E_EXPECTED = 0x8013180b,
    VER_E_LOC_BYNAME = 0x8013180c,
    VER_E_UNKNOWN_OPCODE = 0x80131810,
    VER_E_SIG_CALLCONV = 0x80131811,
    VER_E_SIG_ELEMTYPE = 0x80131812,
    VER_E_RET_SIG = 0x80131814,
    VER_E_FIELD_SIG = 0x80131815,
    VER_E_OPEN_DLGT_PROT_ACC = 0x80131816,
    VER_E_INTERNAL = 0x80131818,
    VER_E_STACK_TOO_LARGE = 0x80131819,
    VER_E_ARRAY_NAME_LONG = 0x8013181a,
    VER_E_FALLTHRU = 0x80131820,
    VER_E_TRY_GTEQ_END = 0x80131821,
    VER_E_TRYEND_GT_CS = 0x80131822,
    VER_E_HND_GTEQ_END = 0x80131823,
    VER_E_HNDEND_GT_CS = 0x80131824,
    VER_E_FLT_GTEQ_CS = 0x80131825,
    VER_E_TRY_START = 0x80131826,
    VER_E_HND_START = 0x80131827,
    VER_E_FLT_START = 0x80131828,
    VER_E_TRY_OVERLAP = 0x80131829,
    VER_E_TRY_EQ_HND_FIL = 0x8013182a,
    VER_E_TRY_SHARE_FIN_FAL = 0x8013182b,
    VER_E_HND_OVERLAP = 0x8013182c,
    VER_E_HND_EQ = 0x8013182d,
    VER_E_FIL_OVERLAP = 0x8013182e,
    VER_E_FIL_EQ = 0x8013182f,
    VER_E_FIL_CONT_TRY = 0x80131830,
    VER_E_FIL_CONT_HND = 0x80131831,
    VER_E_FIL_CONT_FIL = 0x80131832,
    VER_E_FIL_GTEQ_CS = 0x80131833,
    VER_E_FIL_START = 0x80131834,
    VER_E_FALLTHRU_EXCEP = 0x80131835,
    VER_E_FALLTHRU_INTO_HND = 0x80131836,
    VER_E_FALLTHRU_INTO_FIL = 0x80131837,
    VER_E_LEAVE = 0x80131838,
    VER_E_RETHROW = 0x80131839,
    VER_E_ENDFINALLY = 0x8013183a,
    VER_E_ENDFILTER = 0x8013183b,
    VER_E_ENDFILTER_MISSING = 0x8013183c,
    VER_E_BR_INTO_TRY = 0x8013183d,
    VER_E_BR_INTO_HND = 0x8013183e,
    VER_E_BR_INTO_FIL = 0x8013183f,
    VER_E_BR_OUTOF_TRY = 0x80131840,
    VER_E_BR_OUTOF_HND = 0x80131841,
    VER_E_BR_OUTOF_FIL = 0x80131842,
    VER_E_BR_OUTOF_FIN = 0x80131843,
    VER_E_RET_FROM_TRY = 0x80131844,
    VER_E_RET_FROM_HND = 0x80131845,
    VER_E_RET_FROM_FIL = 0x80131846,
    VER_E_BAD_JMP_TARGET = 0x80131847,
    VER_E_PATH_LOC = 0x80131848,
    VER_E_PATH_THIS = 0x80131849,
    VER_E_PATH_STACK = 0x8013184a,
    VER_E_PATH_STACK_DEPTH = 0x8013184b,
    VER_E_THIS = 0x8013184c,
    VER_E_THIS_UNINIT_EXCEP = 0x8013184d,
    VER_E_THIS_UNINIT_STORE = 0x8013184e,
    VER_E_THIS_UNINIT_RET = 0x8013184f,
    VER_E_THIS_UNINIT_V_RET = 0x80131850,
    VER_E_THIS_UNINIT_BR = 0x80131851,
    VER_E_LDFTN_CTOR = 0x80131852,
    VER_E_STACK_NOT_EQ = 0x80131853,
    VER_E_STACK_UNEXPECTED = 0x80131854,
    VER_E_STACK_EXCEPTION = 0x80131855,
    VER_E_STACK_OVERFLOW = 0x80131856,
    VER_E_STACK_UNDERFLOW = 0x80131857,
    VER_E_STACK_EMPTY = 0x80131858,
    VER_E_STACK_UNINIT = 0x80131859,
    VER_E_STACK_I_I4_I8 = 0x8013185a,
    VER_E_STACK_R_R4_R8 = 0x8013185b,
    VER_E_STACK_NO_R_I8 = 0x8013185c,
    VER_E_STACK_NUMERIC = 0x8013185d,
    VER_E_STACK_OBJREF = 0x8013185e,
    VER_E_STACK_P_OBJREF = 0x8013185f,
    VER_E_STACK_BYREF = 0x80131860,
    VER_E_STACK_METHOD = 0x80131861,
    VER_E_STACK_ARRAY_SD = 0x80131862,
    VER_E_STACK_VALCLASS = 0x80131863,
    VER_E_STACK_P_VALCLASS = 0x80131864,
    VER_E_STACK_NO_VALCLASS = 0x80131865,
    VER_E_LOC_DEAD = 0x80131866,
    VER_E_LOC_NUM = 0x80131867,
    VER_E_ARG_NUM = 0x80131868,
    VER_E_TOKEN_RESOLVE = 0x80131869,
    VER_E_TOKEN_TYPE = 0x8013186a,
    VER_E_TOKEN_TYPE_MEMBER = 0x8013186b,
    VER_E_TOKEN_TYPE_FIELD = 0x8013186c,
    VER_E_TOKEN_TYPE_SIG = 0x8013186d,
    VER_E_UNVERIFIABLE = 0x8013186e,
    VER_E_LDSTR_OPERAND = 0x8013186f,
    VER_E_RET_PTR_TO_STACK = 0x80131870,
    VER_E_RET_VOID = 0x80131871,
    VER_E_RET_MISSING = 0x80131872,
    VER_E_RET_EMPTY = 0x80131873,
    VER_E_RET_UNINIT = 0x80131874,
    VER_E_ARRAY_ACCESS = 0x80131875,
    VER_E_ARRAY_V_STORE = 0x80131876,
    VER_E_ARRAY_SD = 0x80131877,
    VER_E_ARRAY_SD_PTR = 0x80131878,
    VER_E_ARRAY_FIELD = 0x80131879,
    VER_E_ARGLIST = 0x8013187a,
    VER_E_VALCLASS = 0x8013187b,
    VER_E_METHOD_ACCESS = 0x8013187c,
    VER_E_FIELD_ACCESS = 0x8013187d,
    VER_E_DEAD = 0x8013187e,
    VER_E_FIELD_STATIC = 0x8013187f,
    VER_E_FIELD_NO_STATIC = 0x80131880,
    VER_E_ADDR = 0x80131881,
    VER_E_ADDR_BYREF = 0x80131882,
    VER_E_ADDR_LITERAL = 0x80131883,
    VER_E_INITONLY = 0x80131884,
    VER_E_THROW = 0x80131885,
    VER_E_CALLVIRT_VALCLASS = 0x80131886,
    VER_E_CALL_SIG = 0x80131887,
    VER_E_CALL_STATIC = 0x80131888,
    VER_E_CTOR = 0x80131889,
    VER_E_CTOR_VIRT = 0x8013188a,
    VER_E_CTOR_OR_SUPER = 0x8013188b,
    VER_E_CTOR_MUL_INIT = 0x8013188c,
    VER_E_SIG = 0x8013188d,
    VER_E_SIG_ARRAY = 0x8013188e,
    VER_E_SIG_ARRAY_PTR = 0x8013188f,
    VER_E_SIG_ARRAY_BYREF = 0x80131890,
    VER_E_SIG_ELEM_PTR = 0x80131891,
    VER_E_SIG_VARARG = 0x80131892,
    VER_E_SIG_VOID = 0x80131893,
    VER_E_SIG_BYREF_BYREF = 0x80131894,
    VER_E_CODE_SIZE_ZERO = 0x80131896,
    VER_E_BAD_VARARG = 0x80131897,
    VER_E_TAIL_CALL = 0x80131898,
    VER_E_TAIL_BYREF = 0x80131899,
    VER_E_TAIL_RET = 0x8013189a,
    VER_E_TAIL_RET_VOID = 0x8013189b,
    VER_E_TAIL_RET_TYPE = 0x8013189c,
    VER_E_TAIL_STACK_EMPTY = 0x8013189d,
    VER_E_METHOD_END = 0x8013189e,
    VER_E_BAD_BRANCH = 0x8013189f,
    VER_E_FIN_OVERLAP = 0x801318a0,
    VER_E_LEXICAL_NESTING = 0x801318a1,
    VER_E_VOLATILE = 0x801318a2,
    VER_E_UNALIGNED = 0x801318a3,
    VER_E_INNERMOST_FIRST = 0x801318a4,
    VER_E_CALLI_VIRTUAL = 0x801318a5,
    VER_E_CALL_ABSTRACT = 0x801318a6,
    VER_E_STACK_UNEXP_ARRAY = 0x801318a7,
    VER_E_NOT_IN_GC_HEAP = 0x801318a8,
    VER_E_TRY_N_EMPTY_STACK = 0x801318a9,
    VER_E_DLGT_CTOR = 0x801318aa,
    VER_E_DLGT_BB = 0x801318ab,
    VER_E_DLGT_PATTERN = 0x801318ac,
    VER_E_DLGT_LDFTN = 0x801318ad,
    VER_E_FTN_ABSTRACT = 0x801318ae,
    VER_E_SIG_C_VC = 0x801318af,
    VER_E_SIG_VC_C = 0x801318b0,
    VER_E_BOX_PTR_TO_STACK = 0x801318b1,
    VER_E_SIG_BYREF_TB_AH = 0x801318b2,
    VER_E_SIG_ARRAY_TB_AH = 0x801318b3,
    VER_E_ENDFILTER_STACK = 0x801318b4,
    VER_E_DLGT_SIG_I = 0x801318b5,
    VER_E_DLGT_SIG_O = 0x801318b6,
    VER_E_RA_PTR_TO_STACK = 0x801318b7,
    VER_E_CATCH_VALUE_TYPE = 0x801318b8,
    VER_E_CATCH_BYREF = 0x801318b9,
    VER_E_FIL_PRECEED_HND = 0x801318ba,
    VER_E_LDVIRTFTN_STATIC = 0x801318bb,
    VER_E_CALLVIRT_STATIC = 0x801318bc,
    VER_E_INITLOCALS = 0x801318bd,
    VER_E_BR_TO_EXCEPTION = 0x801318be,
    VER_E_CALL_CTOR = 0x801318bf,
    VER_E_VALCLASS_OBJREF_VAR = 0x801318c0,
    VER_E_STACK_P_VALCLASS_OBJREF_VAR = 0x801318c1,
    VER_E_SIG_VAR_PARAM = 0x801318c2,
    VER_E_SIG_MVAR_PARAM = 0x801318c3,
    VER_E_SIG_VAR_ARG = 0x801318c4,
    VER_E_SIG_MVAR_ARG = 0x801318c5,
    VER_E_SIG_GENERICINST = 0x801318c6,
    VER_E_SIG_METHOD_INST = 0x801318c7,
    VER_E_SIG_METHOD_PARENT_INST = 0x801318c8,
    VER_E_SIG_FIELD_PARENT_INST = 0x801318c9,
    VER_E_CALLCONV_NOT_GENERICINST = 0x801318ca,
    VER_E_TOKEN_BAD_METHOD_SPEC = 0x801318cb,
    VER_E_BAD_READONLY_PREFIX = 0x801318cc,
    VER_E_BAD_CONSTRAINED_PREFIX = 0x801318cd,
    VER_E_CIRCULAR_VAR_CONSTRAINTS = 0x801318ce,
    VER_E_CIRCULAR_MVAR_CONSTRAINTS = 0x801318cf,
    VER_E_UNSATISFIED_METHOD_INST = 0x801318d0,
    VER_E_UNSATISFIED_METHOD_PARENT_INST = 0x801318d1,
    VER_E_UNSATISFIED_FIELD_PARENT_INST = 0x801318d2,
    VER_E_UNSATISFIED_BOX_OPERAND = 0x801318d3,
    VER_E_CONSTRAINED_CALL_WITH_NON_BYREF_THIS = 0x801318d4,
    VER_E_CONSTRAINED_OF_NON_VARIABLE_TYPE = 0x801318d5,
    VER_E_READONLY_UNEXPECTED_CALLEE = 0x801318d6,
    VER_E_READONLY_ILLEGAL_WRITE = 0x801318d7,
    VER_E_READONLY_IN_MKREFANY = 0x801318d8,
    VER_E_UNALIGNED_ALIGNMENT = 0x801318d9,
    VER_E_TAILCALL_INSIDE_EH = 0x801318da,
    VER_E_BACKWARD_BRANCH = 0x801318db,
    VER_E_CALL_TO_VTYPE_BASE = 0x801318dc,
    VER_E_NEWOBJ_OF_ABSTRACT_CLASS = 0x801318dd,
    VER_E_UNMANAGED_POINTER = 0x801318de,
    VER_E_LDFTN_NON_FINAL_VIRTUAL = 0x801318df,
    VER_E_FIELD_OVERLAP = 0x801318e0,
    VER_E_THIS_MISMATCH = 0x801318e1,
    VER_E_STACK_I_I4 = 0x801318e2,
    VER_E_BAD_PE = 0x801318f0,
    VER_E_BAD_MD = 0x801318f1,
    VER_E_BAD_APPDOMAIN = 0x801318f2,
    VER_E_TYPELOAD = 0x801318f3,
    VER_E_PE_LOAD = 0x801318f4,
    VER_E_WRITE_RVA_STATIC = 0x801318f5,
    VER_E_INITIALIZE_ARRAY_MISSING_TOKEN = 0x801318f6,
    COR_E_SqlException = 0x80131904,
    COR_E_Data = 0x80131920,
    COR_E_DataDeletedRowInaccessible = 0x80131921,
    COR_E_DataDuplicateName = 0x80131922,
    COR_E_DataInRowChangingEvent = 0x80131923,
    COR_E_DataInvalidConstraint = 0x80131924,
    COR_E_DataMissingPrimaryKey = 0x80131925,
    COR_E_DataNoNullAllowed = 0x80131926,
    COR_E_DataReadOnly = 0x80131927,
    COR_E_DataRowNotInTable = 0x80131928,
    COR_E_DataVersionNotFound = 0x80131929,
    COR_E_DataConstraint = 0x8013192a,
    COR_E_StrongTyping = 0x8013192b,
    COR_E_SqlType = 0x80131930,
    COR_E_SqlNullValue = 0x80131931,
    COR_E_SqlTruncate = 0x80131932,
    COR_E_AdapterMapping = 0x80131933,
    COR_E_DataAdapter = 0x80131934,
    COR_E_DBConcurrency = 0x80131935,
    COR_E_OperationAborted = 0x80131936,
    COR_E_InvalidUdt = 0x80131937,
    COR_E_OdbcException = 0x80131937,
    COR_E_OracleException = 0x80131938,
    COR_E_Xml = 0x80131940,
    COR_E_XmlSchema = 0x80131941,
    COR_E_XmlXslt = 0x80131942,
    COR_E_XmlXPath = 0x80131943,
    COR_E_XmlQuery = 0x80131944,
    VLDTR_E_IFACE_NOTIFACE = 0x80131b00,
    VLDTR_E_FD_RVAHASNORVA = 0x80131b01,
    VLDTR_E_FD_RVAHASZERORVA = 0x80131b02,
    VLDTR_E_MD_RVAANDIMPLMAP = 0x80131b03,
    VLDTR_E_TD_EXTRAFLAGS = 0x80131b04,
    VLDTR_E_TD_EXTENDSITSELF = 0x80131b05,
    VLDTR_E_TD_SYSVTNOTEXTOBJ = 0x80131b06,
    VLDTR_E_TD_EXTTYPESPEC = 0x80131b07,
    VLDTR_E_TD_VTNOSIZE = 0x80131b09,
    VLDTR_E_TD_IFACESEALED = 0x80131b0a,
    VLDTR_E_NC_BADNESTED = 0x80131b0b,
    VLDTR_E_NC_BADENCLOSER = 0x80131b0c,
    VLDTR_E_NC_DUP = 0x80131b0d,
    VLDTR_E_NC_DUPENCLOSER = 0x80131b0e,
    VLDTR_E_FRVA_ZERORVA = 0x80131b0f,
    VLDTR_E_FRVA_BADFIELD = 0x80131b10,
    VLDTR_E_FRVA_DUPRVA = 0x80131b11,
    VLDTR_E_FRVA_DUPFIELD = 0x80131b12,
    VLDTR_E_EP_BADTOKEN = 0x80131b13,
    VLDTR_E_EP_INSTANCE = 0x80131b14,
    VLDTR_E_TD_ENUMFLDBADTYPE = 0x80131b15,
    VLDTR_E_MD_BADRVA = 0x80131b16,
    VLDTR_E_FD_LITERALNODEFAULT = 0x80131b17,
    VLDTR_E_IFACE_METHNOTIMPL = 0x80131b18,
    VLDTR_E_CA_BADPARENT = 0x80131b19,
    VLDTR_E_CA_BADTYPE = 0x80131b1a,
    VLDTR_E_CA_NOTCTOR = 0x80131b1b,
    VLDTR_E_CA_BADSIG = 0x80131b1c,
    VLDTR_E_CA_NOSIG = 0x80131b1d,
    VLDTR_E_CA_BADPROLOG = 0x80131b1e,
    VLDTR_E_MD_BADLOCALSIGTOK = 0x80131b1f,
    VLDTR_E_MD_BADHEADER = 0x80131b20,
    VLDTR_E_EP_TOOMANYARGS = 0x80131b21,
    VLDTR_E_EP_BADRET = 0x80131b22,
    VLDTR_E_EP_BADARG = 0x80131b23,
    VLDTR_E_SIG_BADVOID = 0x80131b24,
    VLDTR_E_IFACE_METHMULTIMPL = 0x80131b25,
    VLDTR_E_GP_NAMENULL = 0x80131b26,
    VLDTR_E_GP_OWNERNIL = 0x80131b27,
    VLDTR_E_GP_DUPNAME = 0x80131b28,
    VLDTR_E_GP_DUPNUMBER = 0x80131b29,
    VLDTR_E_GP_NONSEQ_BY_OWNER = 0x80131b2a,
    VLDTR_E_GP_NONSEQ_BY_NUMBER = 0x80131b2b,
    VLDTR_E_GP_UNEXPECTED_OWNER_FOR_VARIANT_VAR = 0x80131b2c,
    VLDTR_E_GP_ILLEGAL_VARIANT_MVAR = 0x80131b2d,
    VLDTR_E_GP_ILLEGAL_VARIANCE_FLAGS = 0x80131b2e,
    VLDTR_E_GP_REFANDVALUETYPE = 0x80131b2f,
    VLDTR_E_GPC_OWNERNIL = 0x80131b30,
    VLDTR_E_GPC_DUP = 0x80131b31,
    VLDTR_E_GPC_NONCONTIGUOUS = 0x80131b32,
    VLDTR_E_MS_METHODNIL = 0x80131b33,
    VLDTR_E_MS_DUP = 0x80131b34,
    VLDTR_E_MS_BADCALLINGCONV = 0x80131b35,
    VLDTR_E_MS_MISSARITY = 0x80131b36,
    VLDTR_E_MS_MISSARG = 0x80131b37,
    VLDTR_E_MS_ARITYMISMATCH = 0x80131b38,
    VLDTR_E_MS_METHODNOTGENERIC = 0x80131b39,
    VLDTR_E_SIG_MISSARITY = 0x80131b3a,
    VLDTR_E_SIG_ARITYMISMATCH = 0x80131b3b,
    VLDTR_E_MD_GENERIC_CCTOR = 0x80131b3c,
    VLDTR_E_MD_GENERIC_CTOR = 0x80131b3d,
    VLDTR_E_MD_GENERIC_IMPORT = 0x80131b3e,
    VLDTR_E_MD_GENERIC_BADCALLCONV = 0x80131b3f,
    VLDTR_E_EP_GENERIC_METHOD = 0x80131b40,
    VLDTR_E_MD_MISSARITY = 0x80131b41,
    VLDTR_E_MD_ARITYZERO = 0x80131b42,
    VLDTR_E_SIG_ARITYZERO = 0x80131b43,
    VLDTR_E_MS_ARITYZERO = 0x80131b44,
    VLDTR_E_MD_GPMISMATCH = 0x80131b45,
    VLDTR_E_EP_GENERIC_TYPE = 0x80131b46,
    VLDTR_E_MI_DECLNOTGENERIC = 0x80131b47,
    VLDTR_E_MI_IMPLNOTGENERIC = 0x80131b48,
    VLDTR_E_MI_ARITYMISMATCH = 0x80131b49,
    VLDTR_E_TD_EXTBADTYPESPEC = 0x80131b4a,
    VLDTR_E_SIG_BYREFINST = 0x80131b4b,
    VLDTR_E_MS_BYREFINST = 0x80131b4c,
    VLDTR_E_TS_EMPTY = 0x80131b4d,
    VLDTR_E_TS_HASSENTINALS = 0x80131b4e,
    VLDTR_E_TD_GENERICHASEXPLAYOUT = 0x80131b4f,
    VLDTR_E_SIG_BADTOKTYPE = 0x80131b50,
    VLDTR_E_IFACE_METHNOTIMPLTHISMOD = 0x80131b51,
    TLBX_E_CIRCULAR_EXPORT2 = 0x80131b52,
    CORDBG_E_THREAD_NOT_SCHEDULED = 0x80131c00,
    CORDBG_E_HANDLE_HAS_BEEN_DISPOSED = 0x80131c01,
    CORDBG_E_NONINTERCEPTABLE_EXCEPTION = 0x80131c02,
    CORDBG_E_CANT_UNWIND_ABOVE_CALLBACK = 0x80131c03,
    CORDBG_E_INTERCEPT_FRAME_ALREADY_SET = 0x80131c04,
    CORDBG_E_NO_NATIVE_PATCH_AT_ADDR = 0x80131c05,
    CORDBG_E_MUST_BE_INTEROP_DEBUGGING = 0x80131c06,
    CORDBG_E_NATIVE_PATCH_ALREADY_AT_ADDR = 0x80131c07,
    CORDBG_E_TIMEOUT = 0x80131c08,
    CORDBG_E_CANT_CALL_ON_THIS_THREAD = 0x80131c09,
    CORDBG_E_ENC_INFOLESS_METHOD = 0x80131c0a,
    CORDBG_E_ENC_NESTED_HANLDERS = 0x80131c0b,
    CORDBG_E_ENC_IN_FUNCLET = 0x80131c0c,
    CORDBG_E_ENC_LOCALLOC = 0x80131c0d,
    CORDBG_E_ENC_EDIT_NOT_SUPPORTED = 0x80131c0e,
    CORDBG_E_FEABORT_DELAYED_UNTIL_THREAD_RESUMED = 0x80131c0f,
    CORDBG_E_NOTREADY = 0x80131c10,
    CORDBG_E_CANNOT_RESOLVE_ASSEMBLY = 0x80131c11,
    CORDBG_E_MUST_BE_IN_LOAD_MODULE = 0x80131c12,
    CORDBG_E_CANNOT_BE_ON_ATTACH = 0x80131c13,
    CORDBG_E_NGEN_NOT_SUPPORTED = 0x80131c14,
    CORDBG_E_ILLEGAL_SHUTDOWN_ORDER = 0x80131c15,
    CORDBG_E_CANNOT_DEBUG_FIBER_PROCESS = 0x80131c16,
    CORDBG_E_MUST_BE_IN_CREATE_PROCESS = 0x80131c17,
    CORDBG_E_DETACH_FAILED_OUTSTANDING_EVALS = 0x80131c18,
    CORDBG_E_DETACH_FAILED_OUTSTANDING_STEPPERS = 0x80131c19,
    CORDBG_E_CANT_INTEROP_STEP_OUT = 0x80131c20,
    CORDBG_E_DETACH_FAILED_OUTSTANDING_BREAKPOINTS = 0x80131c21,
    CORDBG_E_ILLEGAL_IN_STACK_OVERFLOW = 0x80131c22,
    CORDBG_E_ILLEGAL_AT_GC_UNSAFE_POINT = 0x80131c23,
    CORDBG_E_ILLEGAL_IN_PROLOG = 0x80131c24,
    CORDBG_E_ILLEGAL_IN_NATIVE_CODE = 0x80131c25,
    CORDBG_E_ILLEGAL_IN_OPTIMIZED_CODE = 0x80131c26,
    CORDBG_E_MINIDUMP_UNSUPPORTED = 0x80131c27,
    CORDBG_E_APPDOMAIN_MISMATCH = 0x80131c28,
    CORDBG_E_CONTEXT_UNVAILABLE = 0x80131c29,
    CORDBG_E_UNCOMPATIBLE_PLATFORMS = 0x80131c30,
    CORDBG_E_DEBUGGING_DISABLED = 0x80131c31,
    CORDBG_E_DETACH_FAILED_ON_ENC = 0x80131c32,
    CORDBG_E_CURRENT_EXCEPTION_IS_OUTSIDE_CURRENT_EXECUTION_SCOPE = 0x80131c33,
    CORDBG_E_HELPER_MAY_DEADLOCK = 0x80131c34,
    CORDBG_E_MISSING_METADATA = 0x80131c35,
    CORDBG_E_TARGET_INCONSISTENT = 0x80131c36,
    CORDBG_E_DETACH_FAILED_OUTSTANDING_TARGET_RESOURCES = 0x80131c37,
    CORDBG_E_TARGET_READONLY = 0x80131c38,
    CORDBG_E_MISMATCHED_CORWKS_AND_DACWKS_DLLS = 0x80131c39,
    CORDBG_E_MODULE_LOADED_FROM_DISK = 0x80131c3a,
    CORDBG_E_SYMBOLS_NOT_AVAILABLE = 0x80131c3b,
    CORDBG_E_DEBUG_COMPONENT_MISSING = 0x80131c3c,
    CORDBG_E_REMOTE_MISMATCHED_CERTS = 0x80131c3d,
    CORDBG_E_REMOTE_NETWORK_FAILURE = 0x80131c3e,
    CORDBG_E_REMOTE_NO_LISTENER = 0x80131c3f,
    CORDBG_E_REMOTE_UNKNOWN_TARGET = 0x80131c40,
    CORDBG_E_REMOTE_INVALID_CONFIG = 0x80131c41,
    CORDBG_E_REMOTE_MISMATCHED_PROTOCOLS = 0x80131c42,
    CORDBG_E_LIBRARY_PROVIDER_ERROR = 0x80131c43,
    CORDBG_E_NOT_CLR = 0x80131c44,
    CORDBG_E_MISSING_DATA_TARGET_INTERFACE = 0x80131c45,
    CORDBG_E_UNSUPPORTED_DEBUGGING_MODEL = 0x80131c46,
    CORDBG_E_UNSUPPORTED_FORWARD_COMPAT = 0x80131c47,
    CORDBG_E_UNSUPPORTED_VERSION_STRUCT = 0x80131c48,
    CORDBG_E_READVIRTUAL_FAILURE = 0x80131c49,
    CORDBG_E_VALUE_POINTS_TO_FUNCTION = 0x80131c4a,
    CORDBG_E_CORRUPT_OBJECT = 0x80131c4b,
    CORDBG_E_GC_STRUCTURES_INVALID = 0x80131c4c,
    CORDBG_E_INVALID_OPCODE = 0x80131c4d,
    CORDBG_E_UNSUPPORTED = 0x80131c4e,
    CORDBG_E_MISSING_DEBUGGER_EXPORTS = 0x80131c4f,
    CORDBG_E_DATA_TARGET_ERROR = 0x80131c61,
    CORDBG_E_CODE_HAS_NO_METADATA = 0x80131c62,
    CORDBG_E_CODE_UNRECOGNIZED = 0x80131c63,
    CORDBG_E_NO_IMAGE_AVAILABLE = 0x80131c64,
    CORDBG_E_TYPE_NOT_FOUND = 0x80131c65,
    CORDBG_E_VTABLE_HAS_NO_METADATA = 0x80131c66,
    CORDBG_E_NO_GENERIC_INFO = 0x80131c67,
    PEFMT_E_NO_CONTENTS = 0x80131d00,
    PEFMT_E_NO_NTHEADERS = 0x80131d01,
    PEFMT_E_64BIT = 0x80131d02,
    PEFMT_E_NO_CORHEADER = 0x80131d03,
    PEFMT_E_NOT_ILONLY = 0x80131d04,
    PEFMT_E_IMPORT_DLLS = 0x80131d05,
    PEFMT_E_EXE_NOENTRYPOINT = 0x80131d06,
    PEFMT_E_BASE_RELOCS = 0x80131d07,
    PEFMT_E_ENTRYPOINT = 0x80131d08,
    PEFMT_E_ZERO_SIZEOFCODE = 0x80131d09,
    PEFMT_E_BAD_CORHEADER = 0x80131d0a,
    PEFMT_E_32BIT = 0x80131d0b,
    CLR_OPTSVC_E_CONTROLLER_INTERRUPT = 0x80131e00,
    NGEN_FAILED_GET_DEPENDENCIES = 0x80131f00,
    NGEN_FAILED_NATIVE_IMAGE_DELETE = 0x80131f01,
    NGEN_E_TOO_MANY_INTERFACES = 0x80131f02,
    NGEN_E_OLDER_RUNTIME = 0x80131f03,
    NGEN_E_WORKER_UNEXPECTED_EXIT = 0x80131f04,
    NGEN_E_WORKER_UNEXPECTED_SYNC = 0x80131f05,
    NGEN_E_SYS_ASM_NI_MISSING = 0x80131f06,
    NGEN_E_EXE_MACHINE_TYPE_MISMATCH = 0x80131f07,
    NGEN_E_ASSEMBLY_EXCLUSION_FILE_PARSE_ERROR = 0x80131f08,
    NGEN_E_HARDBOUND_DEPENDENCY_MISSING = 0x80131f09,
    NGEN_E_NOT_RUNNING_IN_EXPECTED_PACKAGE = 0x80131f0a,
    NGEN_E_FILE_NOT_ASSEMBLY = 0x80131f0b,
    CLDB_E_INTERNALERROR = 0x80131fff,
    CLR_E_BIND_ASSEMBLY_VERSION_TOO_LOW = 0x80132000,
    CLR_E_BIND_ASSEMBLY_PUBLIC_KEY_MISMATCH = 0x80132001,
    CLR_E_BIND_IMAGE_UNAVAILABLE = 0x80132002,
    CLR_E_BIND_UNRECOGNIZED_IDENTITY_FORMAT = 0x80132003,
    CLR_E_BIND_ASSEMBLY_NOT_FOUND = 0x80132004,
    CLR_E_BIND_TYPE_NOT_FOUND = 0x80132005,
    CLR_E_BIND_SYS_ASM_NI_MISSING = 0x80132006,
    CLR_E_BIND_NI_SECURITY_FAILURE = 0x80132007,
    CLR_E_BIND_NI_DEP_IDENTITY_MISMATCH = 0x80132008,
    CLR_E_GC_OOM = 0x80132009,
    COR_E_UNAUTHORIZEDACCESS = 0x80070005L,
    COR_E_ARGUMENT = 0x80070057L,
    COR_E_INVALIDCAST = 0x80004002L,
    COR_E_OUTOFMEMORY = 0x8007000EL,
    COR_E_NULLREFERENCE = 0x80004003L,
    COR_E_ARITHMETIC = 0x80070216,
    COR_E_BAD_PATHNAME = 0x800700A1,
    COR_E_PATHTOOLONG = 0x800700CE,
    COR_E_FILENOTFOUND = 0x80070002,
    COR_E_ENDOFSTREAM = 0x80070026,
    COR_E_DIRECTORYNOTFOUND = 0x80070003,
    COR_E_STACKOVERFLOW = 0x800703E9,
    COR_E_AMBIGUOUSMATCH = 0x8000211DL,
    COR_E_TARGETPARAMCOUNT = 0x8002000EL,
    COR_E_DIVIDEBYZERO = 0x80020012L,
    COR_E_BADIMAGEFORMAT = 0x8007000BL,
};

#pragma endregion CorError.h

#pragma region corhlpr.h

enum
{
    MAX_CLASSNAME_LENGTH = 1024,
};

#pragma endregion corhlpr.h

#pragma region fusion.h

enum IASSEMBLYCACHE_INSTALL_FLAGS
{
    IASSEMBLYCACHE_INSTALL_FLAG_REFRESH = (0x00000001),
    IASSEMBLYCACHE_INSTALL_FLAG_FORCE_REFRESH = (0x00000002),
};

enum IASSEMBLYCACHE_UNINSTALL_FLAGS
{
    IASSEMBLYCACHE_UNINSTALL_DISPOSITION_UNINSTALLED = 1,
    IASSEMBLYCACHE_UNINSTALL_DISPOSITION_STILL_IN_USE = 2,
    IASSEMBLYCACHE_UNINSTALL_DISPOSITION_ALREADY_UNINSTALED = 3,
    IASSEMBLYCACHE_UNINSTALL_DISPOSITION_DELETE_PENDING = 4,
    IASSEMBLYCACHE_UNINSTALL_DISPOSITION_HAS_INSTALL_REFERENCES = 5,
    IASSEMBLYCACHE_UNINSTALL_DISPOSITION_REFERENCE_NOT_FOUN = 6,
};

enum QUERYASMINFO_FLAGS
{
    QUERYASMINFO_FLAG_VALIDATE = 0x00000001,
    QUERYASMINFO_FLAG_GETSIZE = 0x00000002,
};

enum ASSEMBLYINFO_FLAGS
{
    ASSEMBLYINFO_FLAG_INSTALLED = 0x00000001,
    ASSEMBLYINFO_FLAG_PAYLOADRESIDENT = 0x00000002,
};

enum STREAM_FORMATS
{
    STREAM_FORMAT_COMPLIB_MODULE = 0,
    STREAM_FORMAT_COMPLIB_MANIFEST = 1,
    STREAM_FORMAT_WIN32_MODULE = 2,
    STREAM_FORMAT_WIN32_MANIFEST = 4,
};

enum IASSEMBLYCACHEITEM_COMMIT_FLAGS
{
    IASSEMBLYCACHEITEM_COMMIT_FLAG_REFRESH = 0x00000001,
    IASSEMBLYCACHEITEM_COMMIT_FLAG_FORCE_REFRESH = 0x00000002,
};

enum IASSEMBLYCACHEITEM_COMMIT_DISPOSITION_FLAGS
{
    IASSEMBLYCACHEITEM_COMMIT_DISPOSITION_INSTALLED = 1,
    IASSEMBLYCACHEITEM_COMMIT_DISPOSITION_REFRESHED = 2,
    IASSEMBLYCACHEITEM_COMMIT_DISPOSITION_ALREADY_INSTALD = 3,
};

#pragma endregion fusion.h

#pragma region ICeeFileGen.h

enum ICEE_CREATE_FLAGS
{
    ICEE_CREATE_FILE_PE32 = 0x00000001,  // Create a PE  (32-bit)
    ICEE_CREATE_FILE_PE64 = 0x00000002,  // Create a PE+ (64-bit)
    ICEE_CREATE_FILE_CORMAIN_STUB = 0x00000004,  // add a mscoree!_Cor___Main call stub
    ICEE_CREATE_FILE_STRIP_RELOCS = 0x00000008,  // strip the .reloc section
    ICEE_CREATE_FILE_EMIT_FIXUPS = 0x00000010,  // emit fixups for use by Vulcan
    ICEE_CREATE_SET_FILE_INTEGRITY = 0x00010000,  // Set a code integrity indicator on the file after writing it
    ICEE_CREATE_MACHINE_MASK = 0x0000FF00,  // space for up to 256 machine targets
    ICEE_CREATE_MACHINE_ILLEGAL = 0x00000000,  // An illegal machine name
    ICEE_CREATE_MACHINE_I386 = 0x00000100,  // Create a IMAGE_FILE_MACHINE_I386
    ICEE_CREATE_MACHINE_IA64 = 0x00000200,  // Create a IMAGE_FILE_MACHINE_IA64
    ICEE_CREATE_MACHINE_AMD64 = 0x00000400,  // Create a IMAGE_FILE_MACHINE_AMD64
    ICEE_CREATE_MACHINE_ARM = 0x00000800,  // Create a IMAGE_FILE_MACHINE_ARMNT
    ICEE_CREATE_FILE_PURE_IL = ICEE_CREATE_FILE_PE32 | ICEE_CREATE_FILE_CORMAIN_STUB | ICEE_CREATE_MACHINE_I386,    // Create a pure IL Exe or DLL
};

#pragma endregion ICeeFileGen.h

#pragma region mscoree.h

enum BucketParam
{
    BucketParamsCount = 10,
    BucketParamLength = 255,
};

#pragma endregion mscoree.h

#pragma region StrongName.h

enum StrongNameKeyGen_dwFlags
{
    SN_LEAVE_KEY = 0x00000001,    // Leave key pair registered with CSP
};

enum StrongNameSignatureGenerationEx_dwFlags
{
    SN_SIGN_ALL_FILES = 0x00000001, // Rehash all linked modules as well as resigning the manifest
    SN_TEST_SIGN = 0x00000002,      // Test sign the assembly
    SN_ECMA_SIGN = 0x00000004,      // Sign the assembly treating the input key as the real ECMA key
};

enum StrongNameSignatureVerification_InOut_Flags
{
    SN_INFLAG_FORCE_VER = 0x00000001,               // verify even if settings in the registry disable it
    SN_INFLAG_INSTALL = 0x00000002,                 // verification is the first (on entry to the cache)
    SN_INFLAG_ADMIN_ACCESS = 0x00000004,            // cache protects assembly from all but admin access
    SN_INFLAG_USER_ACCESS = 0x00000008,             // cache protects user's assembly from other users
    SN_INFLAG_ALL_ACCESS = 0x00000010,              // cache provides no access restriction guarantees
    SN_INFLAG_RUNTIME = 0x80000000,                 // internal debugging use only
    SN_OUTFLAG_WAS_VERIFIED = 0x00000001,           // set to false if verify succeeded due to registry settings
    SN_OUTFLAG_MICROSOFT_SIGNATURE = 0x00000002,    // set if the public key corresponds to SN_THE_KEY
};

enum StrongNameCompareAssemblies_Results
{
    SN_CMP_DIFFERENT = 0,   // Assemblies contain different data
    SN_CMP_IDENTICAL = 1,   // Assemblies are exactly the same, even signatures
    SN_CMP_SIGONLY = 2,     // Assemblies differ only by signature (and checksum etc.)
};

#pragma endregion StrongName.h

#pragma region VerError.h

enum VERIFIER_ERRORS
{
    VER_ERR_FATAL = 0x80000000L,	// Cannot Continue
    VER_ERR_OFFSET = 0x00000001L,
    VER_ERR_OPCODE = 0x00000002L,
    VER_ERR_OPERAND = 0x00000004L,
    VER_ERR_TOKEN = 0x00000008L,
    VER_ERR_EXCEP_NUM_1 = 0x00000010L,
    VER_ERR_EXCEP_NUM_2 = 0x00000020L,
    VER_ERR_STACK_SLOT = 0x00000040L,
    VER_ERR_ITEM_1 = 0x00000080L,
    VER_ERR_ITEM_2 = 0x00000100L,
    VER_ERR_ITEM_F = 0x00000200L,
    VER_ERR_ITEM_E = 0x00000400L,
    VER_ERR_TYPE_1 = 0x00000800L,
    VER_ERR_TYPE_2 = 0x00001000L,
    VER_ERR_TYPE_F = 0x00002000L,
    VER_ERR_TYPE_E = 0x00004000L,
    VER_ERR_ADDL_MSG = 0x00008000L,
    VER_ERR_SIG_MASK = 0x07000000L,	// Enum
    VER_ERR_METHOD_SIG = 0x01000000L,
    VER_ERR_LOCAL_SIG = 0x02000000L,
    VER_ERR_FIELD_SIG = 0x03000000L,
    VER_ERR_CALL_SIG = 0x04000000L,
    VER_ERR_OPCODE_OFFSET = (VER_ERR_OPCODE | VER_ERR_OFFSET),
    VER_ERR_LOCAL_VAR = VER_ERR_LOCAL_SIG,
    VER_ERR_ARGUMENT = VER_ERR_METHOD_SIG,
    VER_ERR_ARG_RET = 0xFFFFFFFEL,		// The Argument # is return
    VER_ERR_NO_ARG = 0xFFFFFFFFL,		// Argument # is not valid
    VER_ERR_NO_LOC = VER_ERR_NO_ARG,	// Local # is not valid
};

#pragma endregion VerError.h

#endif  // ENUMS_NETFXSDK
