// enums declares for IISSDK

#pragma once

#ifndef ENUMS_IISSDK
#define ENUMS_IISSDK

// httpserv.h

enum RQ_NOTIFICATIONS
{
    RQ_BEGIN_REQUEST = 0x00000001,
    RQ_AUTHENTICATE_REQUEST = 0x00000002,
    RQ_AUTHORIZE_REQUEST = 0x00000004,
    RQ_RESOLVE_REQUEST_CACHE = 0x00000008,
    RQ_MAP_REQUEST_HANDLER = 0x00000010,
    RQ_ACQUIRE_REQUEST_STATE = 0x00000020,
    RQ_PRE_EXECUTE_REQUEST_HANDLER = 0x00000040,
    RQ_EXECUTE_REQUEST_HANDLER = 0x00000080,
    RQ_RELEASE_REQUEST_STATE = 0x00000100,
    RQ_UPDATE_REQUEST_CACHE = 0x00000200,
    RQ_LOG_REQUEST = 0x00000400,
    RQ_END_REQUEST = 0x00000800,
    RQ_SEND_RESPONSE_STATUS_AND_HEADERS = 0x08000000,
    RQ_CUSTOM_NOTIFICATION = 0x10000000,
    RQ_SEND_RESPONSE = 0x20000000,
    RQ_READ_ENTITY = 0x40000000,
    RQ_MAP_PATH = 0x80000000,
};

enum GL_NOTIFICATIONS
{
    GL_STOP_LISTENING = 0x00000002,
    GL_CACHE_CLEANUP = 0x00000004,
    GL_CACHE_OPERATION = 0x00000010,
    GL_HEALTH_CHECK = 0x00000020,
    GL_CONFIGURATION_CHANGE = 0x00000040,
    GL_FILE_CHANGE = 0x00000080,
    GL_PRE_BEGIN_REQUEST = 0x00000100,
    GL_APPLICATION_START = 0x00000200,
    GL_APPLICATION_RESOLVE_MODULES = 0x00000400,
    GL_APPLICATION_STOP = 0x00000800,
    GL_RSCA_QUERY = 0x00001000,
    GL_TRACE_EVENT = 0x00002000,
    GL_CUSTOM_NOTIFICATION = 0x00004000,
    GL_THREAD_CLEANUP = 0x00008000,
    GL_APPLICATION_PRELOAD = 0x00010000,
    GL_SUSPEND_PROCESS = 0x00020000,
};

// Flags for IHttpContext->CloneContext()
enum CLONE_FLAGS
{
    CLONE_FLAG_BASICS = 0x01,
    CLONE_FLAG_HEADERS = 0x02,
    CLONE_FLAG_ENTITY = 0x04,
    CLONE_FLAG_NO_PRECONDITION = 0x08,
    CLONE_FLAG_NO_DAV = 0x10,
    CLONE_FLAG_USER_CACHE_VARY_BY = 0x20,
    CLONE_FLAG_SERVER_VARIABLE = 0x40,
};

// Flags for IHttpContext->ExecuteRequest()
enum EXECUTE_FLAGS
{
    EXECUTE_FLAG_NO_HEADERS = 0x01,
    EXECUTE_FLAG_IGNORE_CURRENT_INTERCEPTOR = 0x02,
    EXECUTE_FLAG_IGNORE_APPPOOL = 0x04,
    EXECUTE_FLAG_DISABLE_CUSTOM_ERROR = 0x08,
    EXECUTE_FLAG_SAME_URL = 0x10,
    EXECUTE_FLAG_BUFFER_RESPONSE = 0x20,
    EXECUTE_FLAG_HTTP_CACHE_ELIGIBLE = 0x40,
};

// httptrace.h

enum
{
    HTTP_TRACE_EVENT_FLAG_STATIC_DESCRIPTIVE_FIELDS = 0x01,
};

enum HTTP_TRACE_LEVELS
{
    HTTP_TRACE_LEVEL_START = 6,
    HTTP_TRACE_LEVEL_END = 7,
};

// httpcompression.h

enum IIS_COMPRESSION_OPERATIONS
{
    IIS_COMPRESSION_OPERATION_PROCESS = 0,
    IIS_COMPRESSION_OPERATION_FLUSH = 1,
    IIS_COMPRESSION_OPERATION_FINISH = 2,
};

// httpext.h

enum
{
    HSE_VERSION_MAJOR = 8,
    HSE_VERSION_MINOR = 0,
    HSE_LOG_BUFFER_LEN = 80,
    HSE_MAX_EXT_DLL_NAME_LEN = 256,
    HSE_VERSION = 0x80000,
};

enum HSE_STATUS
{
    HSE_STATUS_SUCCESS = 1,
    HSE_STATUS_SUCCESS_AND_KEEP_CONN = 2,
    HSE_STATUS_PENDING = 3,
    HSE_STATUS_ERROR = 4,
};

enum HSE_REQ_VALUES
{
    HSE_REQ_BASE = 0,
    HSE_REQ_SEND_URL_REDIRECT_RESP = (HSE_REQ_BASE + 1),
    HSE_REQ_SEND_URL = (HSE_REQ_BASE + 2),
    HSE_REQ_SEND_RESPONSE_HEADER = (HSE_REQ_BASE + 3),
    HSE_REQ_DONE_WITH_SESSION = (HSE_REQ_BASE + 4),
    HSE_REQ_END_RESERVED = 1000,
    HSE_REQ_MAP_URL_TO_PATH = (HSE_REQ_END_RESERVED + 1),
    HSE_REQ_GET_SSPI_INFO = (HSE_REQ_END_RESERVED + 2),
    HSE_APPEND_LOG_PARAMETER = (HSE_REQ_END_RESERVED + 3),
    HSE_REQ_IO_COMPLETION = (HSE_REQ_END_RESERVED + 5),
    HSE_REQ_TRANSMIT_FILE = (HSE_REQ_END_RESERVED + 6),
    HSE_REQ_REFRESH_ISAPI_ACL = (HSE_REQ_END_RESERVED + 7),
    HSE_REQ_IS_KEEP_CONN = (HSE_REQ_END_RESERVED + 8),
    HSE_REQ_ASYNC_READ_CLIENT = (HSE_REQ_END_RESERVED + 10),
    HSE_REQ_GET_IMPERSONATION_TOKEN = (HSE_REQ_END_RESERVED + 11),
    HSE_REQ_MAP_URL_TO_PATH_EX = (HSE_REQ_END_RESERVED + 12),
    HSE_REQ_ABORTIVE_CLOSE = (HSE_REQ_END_RESERVED + 14),
    HSE_REQ_GET_CERT_INFO_EX = (HSE_REQ_END_RESERVED + 15),
    HSE_REQ_SEND_RESPONSE_HEADER_EX = (HSE_REQ_END_RESERVED + 16),
    HSE_REQ_CLOSE_CONNECTION = (HSE_REQ_END_RESERVED + 17),
    HSE_REQ_IS_CONNECTED = (HSE_REQ_END_RESERVED + 18),
    HSE_REQ_MAP_UNICODE_URL_TO_PATH = (HSE_REQ_END_RESERVED + 23),
    HSE_REQ_MAP_UNICODE_URL_TO_PATH_EX = (HSE_REQ_END_RESERVED + 24),
    HSE_REQ_EXEC_UNICODE_URL = (HSE_REQ_END_RESERVED + 25),
    HSE_REQ_EXEC_URL = (HSE_REQ_END_RESERVED + 26),
    HSE_REQ_GET_EXEC_URL_STATUS = (HSE_REQ_END_RESERVED + 27),
    HSE_REQ_SEND_CUSTOM_ERROR = (HSE_REQ_END_RESERVED + 28),
    HSE_REQ_IS_IN_PROCESS = (HSE_REQ_END_RESERVED + 30),
    HSE_REQ_REPORT_UNHEALTHY = (HSE_REQ_END_RESERVED + 32),
    HSE_REQ_NORMALIZE_URL = (HSE_REQ_END_RESERVED + 33),
    HSE_REQ_VECTOR_SEND = (HSE_REQ_END_RESERVED + 37),
    HSE_REQ_GET_ANONYMOUS_TOKEN = (HSE_REQ_END_RESERVED + 38),
    HSE_REQ_GET_CACHE_INVALIDATION_CALLBACK = (HSE_REQ_END_RESERVED + 40),
    HSE_REQ_GET_UNICODE_ANONYMOUS_TOKEN = (HSE_REQ_END_RESERVED + 41),
    HSE_REQ_GET_TRACE_INFO = (HSE_REQ_END_RESERVED + 42),
    HSE_REQ_SET_FLUSH_FLAG = (HSE_REQ_END_RESERVED + 43),
    HSE_REQ_GET_TRACE_INFO_EX = (HSE_REQ_END_RESERVED + 44),
    HSE_REQ_RAISE_TRACE_EVENT = (HSE_REQ_END_RESERVED + 45),
    HSE_REQ_GET_CONFIG_OBJECT = (HSE_REQ_END_RESERVED + 46),
    HSE_REQ_GET_WORKER_PROCESS_SETTINGS = (HSE_REQ_END_RESERVED + 47),
    HSE_REQ_GET_PROTOCOL_MANAGER_CUSTOM_INTERFACE_CALLBACK = (HSE_REQ_END_RESERVED + 48),
    HSE_REQ_CANCEL_IO = (HSE_REQ_END_RESERVED + 49),
    HSE_REQ_GET_CHANNEL_BINDING_TOKEN = (HSE_REQ_END_RESERVED + 50),

};

enum HSE_TERM_FLAGS
{
    HSE_TERM_ADVISORY_UNLOAD = 0x00000001,
    HSE_TERM_MUST_UNLOAD = 0x00000002,
};

enum HSE_IO_FLAGS
{
    HSE_IO_SYNC = 0x00000001,
    HSE_IO_ASYNC = 0x00000002,
    HSE_IO_DISCONNECT_AFTER_SEND = 0x00000004,
    HSE_IO_SEND_HEADERS = 0x00000008,
    HSE_IO_FINAL_SEND = 0x00000010,
    HSE_IO_CACHE_RESPONSE = 0x00000020,
    HSE_IO_TRY_SKIP_CUSTOM_ERRORS = 0x00000040,
    HSE_IO_NODELAY = 0x00001000,
};

enum HSE_URL_FLAGS
{
    HSE_URL_FLAGS_READ = 0x00000001,
    HSE_URL_FLAGS_WRITE = 0x00000002,
    HSE_URL_FLAGS_EXECUTE = 0x00000004,
    HSE_URL_FLAGS_SSL = 0x00000008,
    HSE_URL_FLAGS_DONT_CACHE = 0x00000010,
    HSE_URL_FLAGS_NEGO_CERT = 0x00000020,
    HSE_URL_FLAGS_REQUIRE_CERT = 0x00000040,
    HSE_URL_FLAGS_MAP_CERT = 0x00000080,
    HSE_URL_FLAGS_SSL128 = 0x00000100,
    HSE_URL_FLAGS_SCRIPT = 0x00000200,
    HSE_URL_FLAGS_MASK = 0x000003ff,
};

enum HSE_EXEC_URL_FLAGS
{
    HSE_EXEC_URL_NO_HEADERS = 0x02,
    HSE_EXEC_URL_IGNORE_CURRENT_INTERCEPTOR = 0x04,
    HSE_EXEC_URL_IGNORE_VALIDATION_AND_RANGE = 0x10,
    HSE_EXEC_URL_DISABLE_CUSTOM_ERROR = 0x20,
    HSE_EXEC_URL_SSI_CMD = 0x40,
    HSE_EXEC_URL_HTTP_CACHE_ELIGIBLE = 0x80,
};

enum HSE_VECTOR_ELEMENT_TYPE
{
    HSE_VECTOR_ELEMENT_TYPE_MEMORY_BUFFER = 0,
    HSE_VECTOR_ELEMENT_TYPE_FILE_HANDLE = 1,
};

enum HSE_APP_FLAGS
{
    HSE_APP_FLAG_IN_PROCESS = 0,
    HSE_APP_FLAG_ISOLATED_OOP = 1,
    HSE_APP_FLAG_POOLED_OOP = 2,
};

// httpfilt.h

enum
{
    HTTP_FILTER_REVISION = 0xA0000,
    SF_MAX_USERNAME = (256 + 1),
    SF_MAX_PASSWORD = (256 + 1),
    SF_MAX_AUTH_TYPE = (32 + 1),
    SF_MAX_FILTER_DESC_LEN = (256 + 1),
};

enum SF_DENIED
{
    SF_DENIED_LOGON = 0x00000001,
    SF_DENIED_RESOURCE = 0x00000002,
    SF_DENIED_FILTER = 0x00000004,
    SF_DENIED_APPLICATION = 0x00000008,
    SF_DENIED_BY_CONFIG = 0x00010000,
};

enum SF_NOTIFIES
{
    SF_NOTIFY_SECURE_PORT = 0x00000001,
    SF_NOTIFY_NONSECURE_PORT = 0x00000002,
    SF_NOTIFY_READ_RAW_DATA = 0x00008000,
    SF_NOTIFY_PREPROC_HEADERS = 0x00004000,
    SF_NOTIFY_AUTHENTICATION = 0x00002000,
    SF_NOTIFY_URL_MAP = 0x00001000,
    SF_NOTIFY_ACCESS_DENIED = 0x00000800,
    SF_NOTIFY_SEND_RESPONSE = 0x00000040,
    SF_NOTIFY_SEND_RAW_DATA = 0x00000400,
    SF_NOTIFY_LOG = 0x00000200,
    SF_NOTIFY_END_OF_REQUEST = 0x00000080,
    SF_NOTIFY_END_OF_NET_SESSION = 0x00000100,
    SF_NOTIFY_AUTH_COMPLETE = 0x04000000,
    SF_NOTIFY_ORDER_HIGH = 0x00080000,
    SF_NOTIFY_ORDER_MEDIUM = 0x00040000,
    SF_NOTIFY_ORDER_LOW = 0x00020000,
    SF_NOTIFY_ORDER_DEFAULT = SF_NOTIFY_ORDER_LOW,
    SF_NOTIFY_ORDER_MASK = (SF_NOTIFY_ORDER_HIGH | SF_NOTIFY_ORDER_MEDIUM | SF_NOTIFY_ORDER_LOW),
};

#endif  // ENUMS_IISSDK
