/**
 * Enums define for all #define in IDA SDK 7.x - 8.3, 8.4 and 9.0 Beta
 * HTC: 2023 - 2024
 */

#ifndef _ENUMS_IDASDK_H_
#define _ENUMS_IDASDK_H_

enum NONAME_IDASDK
{
    // bytes.hpp
    DTP_NODUP = 0x0001,
    SKIP_FF_MASK = 0xFF,
    // dbg.hpp
    SRCDBG_PROV_VERSION = 4,

    // dirtree.hpp
    BAD_BLOB_IDX = -1,

    // enum.hpp
    DEFMASK = -1,
    MAX_ENUM_SERIAL = 255,

    // network.hpp
    AUF_SILENT_UPDATE_FAILURE = 0x1,

    // pro.h
#ifndef __X86__
    BADMEMSIZE = 0x7FFFFFFFFFFFFFFFull,
#else
    BADMEMSIZE = 0x7FFFFFFFu,
#endif
    QMAXPATH = 260,
    QMAXFILE = 260,

    // typeinf.hpp
    DEFMASK64 = -1,
    BADORD = -1,

    // hexrays.hpp
    MAX_VLR_SIZE = sizeof(unsigned __int64),
    MAX_SUPPORTED_STACK_SIZE = 0x100000, // 1MB
    NOSIZE = -1,
    SIZEOF_BLOCK_CHAINS = 24,
    HEXRAYS_API_MAGIC_7x_84 = 0x00DEC0DE00000003LL,
    HEXRAYS_API_MAGIC_90 = 0x00DEC0DE00000004LL,
};

// auto.hpp

enum atype_e
{
    AU_NONE = 00,
    AU_UNK = 10,
    AU_CODE = 20,
    AU_WEAK = 25,
    AU_PROC = 30,
    AU_TAIL = 35,
    AU_FCHUNK = 38,
    AU_USED = 40,
    AU_USD2 = 45,
    AU_TYPE = 50,
    AU_LIBF = 60,
    AU_LBF2 = 70,
    AU_LBF3 = 80,
    AU_CHLB = 90,
    AU_FINAL = 200,
};

enum idastate_e
{
    st_Ready = 0,
    st_Think = 1,
    st_Waiting = 2,
    st_Work = 3,
};

// bytes.hpp

enum ITEM_END // Item end search flags
{
    ITEM_END_FIXUP = 0x0001,
    ITEM_END_INITED = 0x0002,
    ITEM_END_NAME = 0x0004,
    ITEM_END_XREF = 0x0008,
    ITEM_END_CANCEL = 0x0010,
};

enum GFE // Get flags for the specified address, extended form
{
    GFE_VALUE = 0x0001,
    GFE_IDB_VALUE = 0x0002,
};

enum FF_MASK
{
    MS_VAL = 0x000000FFLU,
    FF_IVL = 0x00000100LU,
    MS_CLS = 0x00000600LU,
    MS_COMM = 0x000FF800LU,
    MS_0TYPE = 0x00F00000LU,
    MS_1TYPE = 0x0F000000LU,
    DT_TYPE = 0xF0000000LU,
    MS_CODE = 0xF0000000LU,
};

enum FF_FLAGS
{
    FF_CODE = 0x00000600LU,
    FF_DATA = 0x00000400LU,
    FF_TAIL = 0x00000200LU,
    FF_UNK = 0x00000000LU,
    FF_COMM = 0x00000800,
    FF_REF = 0x00001000,
    FF_LINE = 0x00002000,
    FF_NAME = 0x00004000,
    FF_LABL = 0x00008000,
    FF_FLOW = 0x00010000,
    FF_SIGN = 0x00020000,
    FF_BNOT = 0x00040000,
    FF_UNUSED = 0x00080000,
    FF_ANYNAME = (FF_LABL | FF_NAME),

    FF_0VOID = 0x00000000LU,
    FF_0NUMH = 0x00100000LU,
    FF_0NUMD = 0x00200000LU,
    FF_0CHAR = 0x00300000LU,
    FF_0SEG = 0x00400000LU,
    FF_0OFF = 0x00500000LU,
    FF_0NUMB = 0x00600000LU,
    FF_0NUMO = 0x00700000LU,
    FF_0ENUM = 0x00800000LU,
    FF_0FOP = 0x00900000LU,
    FF_0STRO = 0x00A00000LU,
    FF_0STK = 0x00B00000LU,
    FF_0FLT = 0x00C00000LU,
    FF_0CUST = 0x00D00000LU,

    FF_1VOID = 0x00000000LU,
    FF_1NUMH = 0x01000000LU,
    FF_1NUMD = 0x02000000LU,
    FF_1CHAR = 0x03000000LU,
    FF_1SEG = 0x04000000LU,
    FF_1OFF = 0x05000000LU,
    FF_1NUMB = 0x06000000LU,
    FF_1NUMO = 0x07000000LU,
    FF_1ENUM = 0x08000000LU,
    FF_1FOP = 0x09000000LU,
    FF_1STRO = 0x0A000000LU,
    FF_1STK = 0x0B000000LU,
    FF_1FLT = 0x0C000000LU,
    FF_1CUST = 0x0D000000LU,

    FF_BYTE = 0x00000000,
    FF_WORD = 0x10000000,
    FF_DWORD = 0x20000000,
    FF_QWORD = 0x30000000,
    FF_TBYTE = 0x40000000,
    FF_STRLIT = 0x50000000,
    FF_STRUCT = 0x60000000,
    FF_OWORD = 0x70000000,
    FF_FLOAT = 0x80000000,
    FF_DOUBLE = 0x90000000,
    FF_PACKREAL = 0xA0000000,
    FF_ALIGN = 0xB0000000,
    FF_CUSTOM = 0xD0000000,
    FF_YWORD = 0xE0000000,
    FF_ZWORD = 0xF0000000,

    FF_FUNC = 0x10000000LU,
    FF_IMMD = 0x40000000LU,
    FF_JUMP = 0x80000000LU,
};

enum DELIT
{
    DELIT_SIMPLE = 0x0000,
    DELIT_EXPAND = 0x0001,
    DELIT_DELNAMES = 0x0002,
    DELIT_NOTRUNC = 0x0004,
    DELIT_NOUNAME = 0x0008,
    DELIT_NOCMT = 0x0010,
    DELIT_KEEPFUNC = 0x0020,
};

enum GMB
{
    GMB_READALL = 0x01,
    GMB_WAITBOX = 0x02,
};

enum OPND
{
    OPND_OUTER = 0x80,
    OPND_MASK = 0x0F,
    OPND_ALL = OPND_MASK,
};

enum ALOPT
{
    ALOPT_IGNHEADS = 0x01,
    ALOPT_IGNPRINT = 0x02,
    ALOPT_IGNCLT = 0x04,
    ALOPT_MAX4K = 0x08,
    ALOPT_ONLYTERM = 0x10,
    ALOPT_APPEND = 0x20,
};

enum STRCONV
{
    STRCONV_ESCAPE = 0x00000001,
    STRCONV_REPLCHAR = 0x00000002,
    STRCONV_INCLLEN = 0x00000004,
};

enum PSTF
{
    PSTF_TNORM = 0,
    PSTF_TBRIEF = 1,
    PSTF_TINLIN = 2,
    PSTF_TMASK = 3,
    PSTF_HOTKEY = 0x4,
    PSTF_ENC = 0x8,
    PSTF_ONLY_ENC = 0xB,
    PSTF_ATTRIB = 0x10,
};

enum PBSENC
{
    PBSENC_DEF1BPU = 0,
    PBSENC_ALL = -1,
};

enum BIN_SEARCH
{
    BIN_SEARCH_CASE = 0x01,
    BIN_SEARCH_NOCASE = 0x00,
    BIN_SEARCH_NOBREAK = 0x02,
    BIN_SEARCH_INITED = 0x04,
    BIN_SEARCH_NOSHOW = 0x08,
    BIN_SEARCH_FORWARD = 0x00,
    BIN_SEARCH_BACKWARD = 0x10,
    BIN_SEARCH_BITMASK = 0x20,
};

// compress.hpp

enum PKZ_ERR_CODES
{
    PKZ_OK = 0,
    PKZ_ERRNO = 1,
    PKZ_STREAM_ERROR = 2,
    PKZ_DATA_ERROR = 3,
    PKZ_MEM_ERROR = 4,
    PKZ_BUF_ERROR = 5,
    PKZ_VERSION_ERROR = 6,
    PKZ_RERR = 777,
    PKZ_WERR = 778,
};

enum COMPRESSION_METHODS
{
    STORED = 0,
    SHRUNK = 1,
    REDUCED1 = 2,
    REDUCED2 = 3,
    REDUCED3 = 4,
    REDUCED4 = 5,
    IMPLODED = 6,
    TOKENIZED = 7,
    DEFLATED = 8,
    NUM_METHODS = 9,
};

// config.hpp

enum IDPOPT_T
{
    IDPOPT_STR = 1,
    IDPOPT_NUM = 2,
    IDPOPT_BIT = 3,
    IDPOPT_I64 = 5,
    IDPOPT_CST = 6,
};

enum IDPOPT_RET
{
    IDPOPT_OK = 0,
    IDPOPT_BADKEY = 1,
    IDPOPT_BADTYPE = 2,
    IDPOPT_BADVALUE = 3,
};

enum IDAOPT_PRIO
{
    IDPOPT_PRI_DEFAULT = 1,
    IDPOPT_PRI_HIGH = 2,
};

enum IDPOPT
{
    IDPOPT_NUM_INT = (0),
    IDPOPT_NUM_CHAR = (1 << 24),
    IDPOPT_NUM_SHORT = (2 << 24),
    IDPOPT_NUM_RANGE = (1 << 26),
    IDPOPT_NUM_UNS = (1 << 27),

    IDPOPT_BIT_UINT = 0,
    IDPOPT_BIT_UCHAR = (1 << 24),
    IDPOPT_BIT_USHORT = (2 << 24),
    IDPOPT_BIT_BOOL = (3 << 24),

    IDPOPT_STR_QSTRING = (1 << 24),
    IDPOPT_STR_LONG = (1 << 25),

    IDPOPT_I64_RANGE = (1 << 24),
    IDPOPT_I64_UNS = (1 << 25),

    IDPOPT_CST_PARAMS = (1 << 24),
    IDPOPT_MBROFF = (1 << 18),
};

// dbg.hpp

enum BPTEV
{
    BPTEV_ADDED = 0,
    BPTEV_REMOVED = 1,
    BPTEV_CHANGED = 2,
};

enum DSTATE
{
    DSTATE_SUSP = -1,
    DSTATE_NOTASK = 0,
    DSTATE_RUN = 1,
};

enum DBGINV
{
    DBGINV_MEMORY = 0x0001,
    DBGINV_MEMCFG = 0x0002,
    DBGINV_REGS = 0x0004,
    DBGINV_ALL = 0x7FFF,
    DBGINV_REDRAW = 0x8000,
    DBGINV_NONE = 0,
};

enum BPT_T
{
    BPT_BRK = 0x001,
    BPT_TRACE = 0x002,
    BPT_UPDMEM = 0x004,
    BPT_ENABLED = 0x008,
    BPT_LOWCND = 0x010,
    BPT_TRACEON = 0x020,
    BPT_TRACE_INSN = 0x040,
    BPT_TRACE_FUNC = 0x080,
    BPT_TRACE_BBLK = 0x100,
    BPT_TRACE_TYPES = (BPT_TRACE_INSN | BPT_TRACE_FUNC | BPT_TRACE_BBLK),
    BPT_ELANG_MASK = 0xF0000000u,
    BPT_ELANG_SHIFT = 28,
};

enum BKPT
{
    BKPT_BADBPT = 0x01,
    BKPT_LISTBPT = 0x02,
    BKPT_TRACE = 0x04,
    BKPT_ACTIVE = 0x08,
    BKPT_PARTIAL = 0x10,
    BKPT_CNDREADY = 0x20,
    BKPT_FAKEPEND = 0x40,
    BKPT_PAGE = 0x80,
};

enum BPTCK
{
    BPTCK_NONE = -1,
    BPTCK_NO = 0,
    BPTCK_YES = 1,
    BPTCK_ACT = 2,
};

enum BVF
{
    BVF_ABS = 0x0001,
    BVF_REL = 0x0002,
    BVF_SYM = 0x0004,
    BVF_SRC = 0x0008,
    BVF_ALL = 0x000F,
    BVF_STATE = 0x0030,
    BVFS_ANY = 0x0000,
    BVFS_INPROC = 0x0010,
    BVFS_PENDING = 0x0020,
    BVFS_DISABLED = 0x0030,
};

enum ST
{
    ST_OVER_DEBUG_SEG = 0x01,
    ST_OVER_LIB_FUNC = 0x02,
    ST_ALREADY_LOGGED = 0x04,
    ST_SKIP_LOOPS = 0x08,
    ST_DIFFERENTIAL = 0x10,
    ST_OPTIONS_MASK = (ST_OVER_DEBUG_SEG | ST_OVER_LIB_FUNC | ST_ALREADY_LOGGED | ST_SKIP_LOOPS | ST_DIFFERENTIAL),
    ST_OPTIONS_DEFAULT = (ST_OVER_DEBUG_SEG | ST_OVER_LIB_FUNC),
};

enum TRACE_OPT
{
    IT_LOG_SAME_IP = 0x01,
    FT_LOG_RET = 0x01,
    BT_LOG_INSTS = 0x01,
};

enum WFNE
{
    WFNE_ANY = 0x0001,
    WFNE_SUSP = 0x0002,
    WFNE_SILENT = 0x0004,
    WFNE_CONT = 0x0008,
    WFNE_NOWAIT = 0x0010,
    WFNE_USEC = 0x0020,
};

enum DOPT
{
    DOPT_SEGM_MSGS = 0x00000001,
    DOPT_START_BPT = 0x00000002,
    DOPT_THREAD_MSGS = 0x00000004,
    DOPT_THREAD_BPT = 0x00000008,
    DOPT_BPT_MSGS = 0x00000010,
    DOPT_BINS_BPT = 0x00000020,
    DOPT_LIB_MSGS = 0x00000040,
    DOPT_LIB_BPT = 0x00000080,
    DOPT_INFO_MSGS = 0x00000100,
    DOPT_INFO_BPT = 0x00000200,
    DOPT_REAL_MEMORY = 0x00000400,
    DOPT_REDO_STACK = 0x00000800,
    DOPT_ENTRY_BPT = 0x00001000,
    DOPT_EXCDLG = 0x00006000,
    EXCDLG_NEVER = 0x00000000,
    EXCDLG_UNKNOWN = 0x00002000,
    EXCDLG_ALWAYS = 0x00006000,
    DOPT_LOAD_DINFO = 0x00008000,
    DOPT_END_BPT = 0x00010000,
    DOPT_TEMP_HWBPT = 0x00020000,
    DOPT_FAST_STEP = 0x00040000,
    DOPT_DISABLE_ASLR = 0x00080000,
};

enum SPF
{
    SPF_DECOMPILER = 0x0001,
    SPF_ENABLED = 0x0002,
    SPF_ACTIVE = 0x0004,
    SPF_VERSION_MASK = 0xFF000000,
};

enum SPCH
{
    SPCH_NONE = 0x0000,
    SPCH_FILES = 0x0001,
    SPCH_ITEMS = 0x0002,
    SPCH_LINES = 0x0004,
};

// demangle.hpp

enum DEMANGLE_RESULT_CODE
{
    ME_INTERR = -1,
    ME_PARAMERR = -2,
    ME_ILLSTR = -3,
    ME_SMALLANS = -4,
    ME_FRAME = -5,
    ME_NOCOMP = -6,
    ME_ERRAUTO = -7,
    ME_NOHASHMEM = -8,
    ME_NOSTRMEM = -9,
    ME_NOERROR_LIMIT = -10,
    M_PRCMSK = 0x0000000F,
    MT_DEFAULT = 0x00000001,
    MT_CDECL = 0x00000002,
    MT_PASCAL = 0x00000003,
    MT_STDCALL = 0x00000004,
    MT_FASTCALL = 0x00000005,
    MT_THISCALL = 0x00000006,
    MT_FORTRAN = 0x00000007,
    MT_SYSCALL = 0x00000008,
    MT_INTERRUPT = 0x00000009,
    MT_MSFASTCALL = 0x0000000A,
    MT_CLRCALL = 0x0000000B,
    MT_DMDCALL = 0x0000000C,
    MT_VECTORCALL = 0x0000000D,
    MT_REGCALL = 0x0000000E,
    MT_LOCALNAME = 0x0000000F,
    M_SAVEREGS = 0x00000010,
    M_CLASS = 0x000000E0,
    MT_PUBLIC = 0x00000020,
    MT_PRIVATE = 0x00000040,
    MT_PROTECT = 0x00000060,
    MT_MEMBER = 0x00000080,
    MT_VTABLE = 0x000000A0,
    MT_RTTI = 0x000000C0,
    M_PARMSK = 0x0000FF00,
    MT_PARSHF = 8,
    MT_PARMAX = 0xFF,
    M_ELLIPSIS = 0x00010000,
    MT_VOIDARG = 0x0001FF00,
    M_STATIC = 0x00020000,
    M_VIRTUAL = 0x00040000,
    M_AUTOCRT = 0x00080000,
    M_TYPMASK = 0x00700000,
    MT_OPERAT = 0x00100000,
    MT_CONSTR = 0x00200000,
    MT_DESTR = 0x00300000,
    MT_CASTING = 0x00400000,
    MT_CLRCDTOR = 0x00500000,
    M_TRUNCATE = 0x00800000,
    M_THUNK = 0x01000000,
    M_ANONNSP = 0x02000000,
    M_TMPLNAM = 0x04000000,
    M_DBGNAME = 0x08000000,
    M_COMPILER = 0x70000000,
    MT_MSCOMP = 0x10000000,
    MT_BORLAN = 0x20000000,
    MT_WATCOM = 0x30000000,
    MT_OTHER = 0x40000000,
    MT_GNU = 0x50000000,
    MT_GCC3 = 0x60000000,
    MT_VISAGE = 0x70000000,
};

// Flags to inhibit different parts of the demangled name
enum MNG
{
    MNG_PTRMSK = 0x7,

    MNG_DEFNEAR = 0x0,
    MNG_DEFNEARANY = 0x1,
    MNG_DEFFAR = 0x2,
    MNG_NOPTRTYP16 = 0x3,
    MNG_DEFHUGE = 0x4,
    MNG_DEFPTR64 = 0x5,
    MNG_DEFNONE = 0x6,
    MNG_NOPTRTYP = 0x7,

    MNG_NODEFINIT = 0x00000008,
    MNG_NOUNDERSCORE = 0x00000010,
    MNG_NOTYPE = 0x00000020,
    MNG_NORETTYPE = 0x00000040,
    MNG_NOBASEDT = 0x00000080,
    MNG_NOCALLC = 0x00000100,
    MNG_NOPOSTFC = 0x00000200,
    MNG_NOSCTYP = 0x00000400,
    MNG_NOTHROW = 0x00000800,
    MNG_NOSTVIR = 0x00001000,
    MNG_NOECSU = 0x00002000,
    MNG_NOCSVOL = 0x00004000,
    MNG_NOCLOSUR = 0x00008000,
    MNG_NOUNALG = 0x00010000,
    MNG_NOMANAGE = 0x00020000,
    MNG_NOMODULE = 0x00040000,

    MNG_SHORT_S = 0x00100000,
    MNG_SHORT_U = 0x00200000,
    MNG_ZPT_SPACE = 0x00400000,
    MNG_DROP_IMP = 0x00800000,

    MNG_IGN_ANYWAY = 0x02000000,
    MNG_IGN_JMP = 0x04000000,
    MNG_MOVE_JMP = 0x08000000,

    MNG_COMPILER_MSK = 0x70000000,

    MNG_SHORT_FORM = (MNG_NOTYPE | MNG_NORETTYPE | MNG_NOPOSTFC | MNG_NOPTRTYP | MNG_NOSCTYP | MNG_NOTHROW | MNG_NOSTVIR | MNG_NOECSU | MNG_NOCLOSUR | MNG_SHORT_U | MNG_DROP_IMP | MNG_NOUNALG | MNG_NOMANAGE | MNG_IGN_JMP | MNG_MOVE_JMP | MNG_IGN_ANYWAY),
    MNG_LONG_FORM = (MNG_ZPT_SPACE | MNG_IGN_JMP | MNG_IGN_ANYWAY | MNG_NOPTRTYP),

    MNG_CALC_VALID = (MNG_COMPILER_MSK | MNG_IGN_JMP | MNG_IGN_ANYWAY),
};

enum mangled_name_type_e
{
    MANGLED_CODE = 0,
    MANGLED_DATA = 1,
    MANGLED_UNKNOWN = 2,
};

// diskio.hpp

enum IDA_SUBDIR
{
    IDA_SUBDIR_IDP = 0x0001,
    IDA_SUBDIR_IDADIR_FIRST = 0x0002,
    IDA_SUBDIR_ONLY_EXISTING = 0x0004,
};

// entry.hpp

enum AEF
{
    AEF_UTF8 = 0x0,
    AEF_IDBENC = 0x1,
    AEF_NODUMMY = 0x2,
};

// enum.hpp

enum ENFL
{
    ENFL_REGEX = 0x0001,
};

enum ENUM_MEMBER
{
    ENUM_MEMBER_ERROR_NAME = 1,
    ENUM_MEMBER_ERROR_VALUE = 2,
    ENUM_MEMBER_ERROR_ENUM = 3,
    ENUM_MEMBER_ERROR_MASK = 4,
    ENUM_MEMBER_ERROR_ILLV = 5,
};

// expr.hpp

enum VARSLICE
{
    VARSLICE_SINGLE = 0x0001,
};

enum VREF
{
    VREF_LOOP = 0x0000,
    VREF_ONCE = 0x0001,
    VREF_COPY = 0x0002,
};

enum VT
{
    VT_LONG = 2,
    VT_FLOAT = 3,
    VT_WILD = 4,
    VT_OBJ = 5,
    VT_FUNC = 6,
    VT_STR = 7,
    VT_PVOID = 8,
    VT_INT64 = 9,
    VT_REF = 10,
};

enum EXTFUN
{
    EXTFUN_BASE = 0x0001,
    EXTFUN_NORET = 0x0002,
    EXTFUN_SAFE = 0x0004,
};

enum CPL
{
    CPL_DEL_MACROS = 0x0001,
    CPL_USE_LABELS = 0x0002,
    CPL_ONLY_SAFE = 0x0004,

};

// fixup.hpp

enum fixup_type_e
{
    FIXUP_OFF8 = 13,
    FIXUP_OFF16 = 1,
    FIXUP_SEG16 = 2,
    FIXUP_PTR16 = 3,
    FIXUP_OFF32 = 4,
    FIXUP_PTR32 = 5,
    FIXUP_HI8 = 6,
    FIXUP_HI16 = 7,
    FIXUP_LOW8 = 8,
    FIXUP_LOW16 = 9,
    V695_FIXUP_VHIGH = 10,
    V695_FIXUP_VLOW = 11,
    FIXUP_OFF64 = 12,
    FIXUP_OFF8S = 14,
    FIXUP_OFF16S = 15,
    FIXUP_OFF32S = 16,
    FIXUP_CUSTOM = 0x8000,
};

enum FIXUPF
{
    FIXUPF_REL = 0x0001,
    FIXUPF_EXTDEF = 0x0002,
    FIXUPF_UNUSED = 0x0004,
    FIXUPF_CREATED = 0x0008,
    FIXUPF_LOADER_MASK = 0xF0000000,
};

enum FHF
{
    FHF_VERIFY = 0x0001,
    FHF_CODE = 0x0002,
    FHF_FORCE_CODE = 0x0004,
    FHF_ABS_OPVAL = 0x0008,
    FHF_SIGNED = 0x0010,
};

// frame.hpp

enum STKVAR
{
    STKVAR_VALID_SIZE = 0x0001,
};

enum REGVAR_ERROR
{
    REGVAR_ERROR_OK = 0,
    REGVAR_ERROR_ARG = -1,
    REGVAR_ERROR_RANGE = -2,
    REGVAR_ERROR_NAME = -3,
};

// funcs.hpp

enum FUNC
{
    FUNC_NORET = 0x00000001,
    FUNC_FAR = 0x00000002,
    FUNC_LIB = 0x00000004,
    FUNC_STATICDEF = 0x00000008,
    FUNC_FRAME = 0x00000010,
    FUNC_USERFAR = 0x00000020,
    FUNC_HIDDEN = 0x00000040,
    FUNC_THUNK = 0x00000080,
    FUNC_BOTTOMBP = 0x00000100,
    FUNC_NORET_PENDING = 0x00200,
    FUNC_SP_READY = 0x00000400,
    FUNC_FUZZY_SP = 0x00000800,
    FUNC_PROLOG_OK = 0x00001000,
    FUNC_PURGED_OK = 0x00004000,
    FUNC_TAIL = 0x00008000,
    FUNC_LUMINA = 0x00010000,
    FUNC_OUTLINE = 0x00020000,
    FUNC_REANALYZE = 0x00040000,
    FUNC_RESERVED = 0x8000000000000000LL,
};

enum MOVE_FUNC
{
    MOVE_FUNC_OK = 0,
    MOVE_FUNC_NOCODE = 1,
    MOVE_FUNC_BADSTART = 2,
    MOVE_FUNC_NOFUNC = 3,
    MOVE_FUNC_REFUSED = 4,
};

enum FIND_FUNC_F
{
    FIND_FUNC_NORMAL = 0x0000,
    FIND_FUNC_DEFINE = 0x0001,
    FIND_FUNC_IGNOREFN = 0x0002,
    FIND_FUNC_KEEPBD = 0x0004,
};

enum FIND_FUNC_R
{
    FIND_FUNC_UNDEF = 0,
    FIND_FUNC_OK = 1,
    FIND_FUNC_EXIST = 2,
};

enum IDASNG
{
    IDASGN_OK = 0,
    IDASGN_BADARG = 1,
    IDASGN_APPLIED = 2,
    IDASGN_CURRENT = 3,
    IDASGN_PLANNED = 4,
};

enum LIBFUNC
{
    LIBFUNC_FOUND = 0,
    LIBFUNC_NONE = 1,
    LIBFUNC_DELAY = 2,
};

// gdl.hpp

enum CHART_1
{
    CHART_PRINT_NAMES = 0x1000,
    CHART_GEN_DOT = 0x2000,
    CHART_GEN_GDL = 0x4000,
    CHART_WINGRAPH = 0x8000,
};

enum CHART_2
{
    CHART_NOLIBFUNCS = 0x0400,
    CHART_REFERENCING = 0x0001,
    CHART_REFERENCED = 0x0002,
    CHART_RECURSIVE = 0x0004,
    CHART_FOLLOW_DIRECTION = 0x0008,
    CHART_IGNORE_XTRN = 0x0010,
    CHART_IGNORE_DATA_BSS = 0x0020,
    CHART_IGNORE_LIB_TO = 0x0040,
    CHART_IGNORE_LIB_FROM = 0x0080,
    CHART_PRINT_COMMENTS = 0x0100,
    CHART_PRINT_DOTS = 0x0200,
};

enum FC
{
    FC_PRINT = 0x0001,
    FC_NOEXT = 0x0002,
    FC_RESERVED = 0x0004,
    FC_APPND = 0x0008,
    FC_CHKBREAK = 0x0010,
    FC_CALL_ENDS = 0x0020,
    FC_NOPREDS = 0x0040,
    FC_OUTLINES = 0x0080,
};

// graph.hpp

enum NIF
{
    NIF_BG_COLOR = (1 << 0),
    NIF_FRAME_COLOR = (1 << 1),
    NIF_EA = (1 << 2),
    NIF_TEXT = (1 << 3),
    NIF_FLAGS = (1 << 4),
    NIF_ALL = (NIF_BG_COLOR | NIF_FRAME_COLOR | NIF_EA | NIF_TEXT | NIF_FLAGS),
};

enum GLICTL
{
    GLICTL_CENTER = (1 << 0),
};

enum layout_type_e
{
    layout_none = 0,
    layout_digraph = 1,
    layout_tree = 2,
    layout_circle = 3,
    layout_polar_tree = 4,
    layout_orthogonal = 5,
    layout_radial_tree = 6,
};

enum MTG
{
    MTG_GROUP_NODE = 0x01,
    MTG_DOT_NODE = 0x02,
    MTG_NON_DISPLAYABLE_NODE = 0x08,
    COLLAPSED_NODE = 0x80000000,
};

// ida.hpp

enum IDAINFO
{
    IDAINFO_TAG_SIZE = 3,
    IDAINFO_PROCNAME_SIZE = 16,
    IDAINFO_STRLIT_PREF_SIZE = 16,
};

enum INFFL
{
    INFFL_AUTO = 0x01,
    INFFL_ALLASM = 0x02,
    INFFL_LOADIDC = 0x04,
    INFFL_NOUSER = 0x08,
    INFFL_READONLY = 0x10,
    INFFL_CHKOPS = 0x20,
    INFFL_NMOPS = 0x40,
    INFFL_GRAPH_VIEW = 0x80,
};

enum LFLG
{
    LFLG_PC_FPP = 0x00000001,
    LFLG_PC_FLAT = 0x00000002,
    LFLG_64BIT = 0x00000004,
    LFLG_IS_DLL = 0x00000008,
    LFLG_FLAT_OFF32 = 0x00000010,
    LFLG_MSF = 0x00000020,
    LFLG_WIDE_HBF = 0x00000040,
    LFLG_DBG_NOPATH = 0x00000080,
    LFLG_SNAPSHOT = 0x00000100,
    LFLG_PACK = 0x00000200,
    LFLG_COMPRESS = 0x00000400,
    LFLG_KERNMODE = 0x00000800,
};

enum IDB
{
    IDB_UNPACKED = 0,
    IDB_PACKED = 1,
    IDB_COMPRESSED = 2,
};

enum AF
{
    AF_CODE = 0x00000001,
    AF_MARKCODE = 0x00000002,
    AF_JUMPTBL = 0x00000004,
    AF_PURDAT = 0x00000008,
    AF_USED = 0x00000010,
    AF_UNK = 0x00000020,
    AF_PROCPTR = 0x00000040,
    AF_PROC = 0x00000080,
    AF_FTAIL = 0x00000100,
    AF_LVAR = 0x00000200,
    AF_STKARG = 0x00000400,
    AF_REGARG = 0x00000800,
    AF_TRACE = 0x00001000,
    AF_VERSP = 0x00002000,
    AF_ANORET = 0x00004000,
    AF_MEMFUNC = 0x00008000,
    AF_TRFUNC = 0x00010000,
    AF_STRLIT = 0x00020000,
    AF_CHKUNI = 0x00040000,
    AF_FIXUP = 0x00080000,
    AF_DREFOFF = 0x00100000,
    AF_IMMOFF = 0x00200000,
    AF_DATOFF = 0x00400000,
    AF_FLIRT = 0x00800000,
    AF_SIGCMT = 0x01000000,
    AF_SIGMLT = 0x02000000,
    AF_HFLIRT = 0x04000000,
    AF_JFUNC = 0x08000000,
    AF_NULLSUB = 0x10000000,
    AF_DODATA = 0x20000000,
    AF_DOCODE = 0x40000000,
    AF_FINAL = 0x80000000,
};

enum AF2
{
    AF2_DOEH = 0x00000001,
    AF2_DORTTI = 0x00000002,
    AF2_MACRO = 0x00000004,
    AF2_MERGESTR = 0x00000008,
};

enum SW_X
{
    SW_SEGXRF = 0x01,
    SW_XRFMRK = 0x02,
    SW_XRFFNC = 0x04,
    SW_XRFVAL = 0x08,
};

enum NM
{
    NM_REL_OFF = 0,
    NM_PTR_OFF = 1,
    NM_NAM_OFF = 2,
    NM_REL_EA = 3,
    NM_PTR_EA = 4,
    NM_NAM_EA = 5,
    NM_EA = 6,
    NM_EA4 = 7,
    NM_EA8 = 8,
    NM_SHORT = 9,
    NM_SERIAL = 10,
};

enum DEMNAM
{
    DEMNAM_MASK = 3,
    DEMNAM_CMNT = 0,
    DEMNAM_NAME = 1,
    DEMNAM_NONE = 2,
    DEMNAM_GCC3 = 4,
    DEMNAM_FIRST = 8,
};

enum LN
{
    LN_NORMAL = 0x01,
    LN_PUBLIC = 0x02,
    LN_AUTO = 0x04,
    LN_WEAK = 0x08,
};

enum OFLG
{
    OFLG_SHOW_VOID = 0x002,
    OFLG_SHOW_AUTO = 0x004,
    OFLG_GEN_NULL = 0x010,
    OFLG_SHOW_PREF = 0x020,
    OFLG_PREF_SEG = 0x040,
    OFLG_LZERO = 0x080,
    OFLG_GEN_ORG = 0x100,
    OFLG_GEN_ASSUME = 0x200,
    OFLG_GEN_TRYBLKS = 0x400,
};

enum SCF
{
    SCF_RPTCMT = 0x01,
    SCF_ALLCMT = 0x02,
    SCF_NOCMT = 0x04,
    SCF_LINNUM = 0x08,
    SCF_TESTMODE = 0x10,
    SCF_SHHID_ITEM = 0x20,
    SCF_SHHID_FUNC = 0x40,
    SCF_SHHID_SEGM = 0x80,
    SW_RPTCMT = SCF_RPTCMT,
    SW_ALLCMT = SCF_ALLCMT,
    SW_NOCMT = SCF_NOCMT,
    SW_LINNUM = SCF_LINNUM,
    SW_TESTMODE = SCF_TESTMODE,
    SW_SHHID_ITEM = SCF_SHHID_ITEM,
    SW_SHHID_FUNC = SCF_SHHID_FUNC,
    SW_SHHID_SEGM = SCF_SHHID_SEGM,
};

enum LMT
{
    LMT_THIN = 0x01,
    LMT_THICK = 0x02,
    LMT_EMPTY = 0x04,
};

enum PREF
{
    PREF_SEGADR = 0x01,
    PREF_FNCOFF = 0x02,
    PREF_STACK = 0x04,
    PREF_PFXTRUNC = 0x08,
};

enum STRF
{
    STRF_GEN = 0x01,
    STRF_AUTO = 0x02,
    STRF_SERIAL = 0x04,
    STRF_UNICODE = 0x08,
    STRF_COMMENT = 0x10,
    STRF_SAVECASE = 0x20,
};

enum ABI
{
    ABI_8ALIGN4 = 0x00000001,
    ABI_PACK_STKARGS = 0x00000002,
    ABI_BIGARG_ALIGN = 0x00000004,
    ABI_STACK_LDBL = 0x00000008,
    ABI_STACK_VARARGS = 0x00000010,
    ABI_HARD_FLOAT = 0x00000020,
    ABI_SET_BY_USER = 0x00000040,
    ABI_GCC_LAYOUT = 0x00000080,
    ABI_MAP_STKARGS = 0x00000100,
    ABI_HUGEARG_ALIGN = 0x00000200
};

enum noname_ida_hpp
{
    UA_MAXOP = 8,
    mask32 = 0xFFFFFFFF,
    mask64 = 0xFFFFFFFFFFFFFFFFULL,
};

enum VLD
{
    VLD_AUTO_REPAIR = 0x01,
    VLD_DIALOG = 0x02,
    VLD_SILENT = 0x04,
};

enum idi_flags
{
    IDI_STRUCFLD = 0,
    IDI_ALTVAL = 0x00001,
    IDI_SUPVAL = 0x00002,
    IDI_VALOBJ = 0x00004,
    IDI_BLOB = 0x00008,
    IDI_SCALAR = 0,
    IDI_CSTR = 0x00010,
    IDI_QSTRING = 0x00020,
    IDI_BYTEARRAY = 0x00040,
    IDI_EA_HEX = 0,
    IDI_DEC = 0x00080,
    IDI_HEX = 0x00100,
    IDI_INC = 0x00200,
    IDI_MAP_VAL = 0x00400,
    IDI_HASH = 0x00800,
    IDI_HLPSTRUC = 0x01000,
    IDI_READONLY = 0x02000,
    IDI_BITMAP = 0x04000,
    IDI_ONOFF = 0x08000,
    IDI_NOMERGE = 0x10000,
    IDI_NODEVAL = (IDI_ALTVAL | IDI_SUPVAL | IDI_VALOBJ | IDI_BLOB),
    IDI_BUFVAR = (IDI_CSTR | IDI_BYTEARRAY | IDI_QSTRING | IDI_BITMAP),
};

// ida_highlighter.hpp

enum noname_ida_highlighter_hpp
{
    MLTCMTMASK = 0xF,
    PREPROC_FLAG = 0x10,
};

// idd.hpp

enum noname_idd_hpp
{
    IDD_INTERFACE_VERSION_72 = 25,
    IDD_INTERFACE_VERSION_77 = 27,
    IDD_INTERFACE_VERSION_8x = 28,
    IDD_INTERFACE_VERSION_9x = 30,
    NO_PROCESS = -1,
    NO_THREAD = 0,
};

enum DEF_ADDRSIZE
{
    DEF_ADDRSIZE_EA64 = 8,
    DEF_ADDRSIZE = 4,
};

enum REGISTER
{
    REGISTER_READONLY = 0x0001,
    REGISTER_IP = 0x0002,
    REGISTER_SP = 0x0004,
    REGISTER_FP = 0x0008,
    REGISTER_ADDRESS = 0x0010,
    REGISTER_CS = 0x0020,
    REGISTER_SS = 0x0040,
    REGISTER_NOLF = 0x0080,
    REGISTER_CUSTFMT = 0x0100,
};

enum bpttype_e
{
    BPT_WRITE = 1,
    BPT_READ = 2,
    BPT_RDWR = 3,
    BPT_SOFT = 4,
    BPT_EXEC = 8,
    BPT_DEFAULT = (BPT_SOFT | BPT_EXEC),
};

enum EXC
{
    EXC_BREAK = 0x0001,
    EXC_HANDLE = 0x0002,
    EXC_MSG = 0x0004,
    EXC_SILENT = 0x0008,
};

enum RVT
{
    RVT_INT = -1,
    RVT_FLOAT = -2,
    RVT_UNAVAILABLE = -3,
};

enum TRACE
{
    STEP_TRACE = 0x01,
    INSN_TRACE = 0x02,
    FUNC_TRACE = 0x04,
    BBLK_TRACE = 0x08,
};

enum DEBUGGER_ID
{
    DEBUGGER_ID_X86_IA32_WIN32_USER = 0,
    DEBUGGER_ID_X86_IA32_LINUX_USER = 1,
    DEBUGGER_ID_X86_IA32_MACOSX_USER = 3,
    DEBUGGER_ID_ARM_IPHONE_USER = 5,
    DEBUGGER_ID_X86_IA32_BOCHS = 6,
    DEBUGGER_ID_6811_EMULATOR = 7,
    DEBUGGER_ID_GDB_USER = 8,
    DEBUGGER_ID_WINDBG = 9,
    DEBUGGER_ID_X86_DOSBOX_EMULATOR = 10,
    DEBUGGER_ID_ARM_LINUX_USER = 11,
    DEBUGGER_ID_TRACE_REPLAYER = 12,
    DEBUGGER_ID_X86_PIN_TRACER = 14,
    DEBUGGER_ID_DALVIK_USER = 15,
    DEBUGGER_ID_XNU_USER = 16,
    DEBUGGER_ID_ARM_MACOS_USER = 17,
};

enum DBG_FLAG
{
    DBG_FLAG_REMOTE = 0x00000001,
    DBG_FLAG_NOHOST = 0x00000002,
    DBG_FLAG_FAKE_ATTACH = 0x00000004,
    DBG_FLAG_HWDATBPT_ONE = 0x00000008,
    DBG_FLAG_CAN_CONT_BPT = 0x00000010,
    DBG_FLAG_NEEDPORT = 0x00000020,
    DBG_FLAG_DONT_DISTURB = 0x00000040,
    DBG_FLAG_SAFE = 0x00000080,
    DBG_FLAG_CLEAN_EXIT = 0x00000100,
    DBG_FLAG_USE_SREGS = 0x00000200,
    DBG_FLAG_NOSTARTDIR = 0x00000400,
    DBG_FLAG_NOPARAMETERS = 0x00000800,
    DBG_FLAG_NOPASSWORD = 0x00001000,
    DBG_FLAG_CONNSTRING = 0x00002000,
    DBG_FLAG_SMALLBLKS = 0x00004000,
    DBG_FLAG_MANMEMINFO = 0x00008000,
    DBG_FLAG_EXITSHOTOK = 0x00010000,
    DBG_FLAG_VIRTHREADS = 0x00020000,
    DBG_FLAG_LOWCNDS = 0x00040000,
    DBG_FLAG_DEBTHREAD = 0x00080000,
    DBG_FLAG_DEBUG_DLL = 0x00100000,
    DBG_FLAG_FAKE_MEMORY = 0x00200000,
    DBG_FLAG_ANYSIZE_HWBPT = 0x00400000,
    DBG_FLAG_TRACER_MODULE = 0x00800000,
    DBG_FLAG_PREFER_SWBPTS = 0x01000000,
    DBG_FLAG_LAZY_WATCHPTS = 0x02000000,
    DBG_FLAG_FAST_STEP = 0x04000000,
    DBG_FLAG_ADD_ENVS = 0x08000000,
    DBG_FLAG_MERGE_ENVS = 0x10000000,
};

enum DBG_FLAG2
{
    DBG_HAS_GET_PROCESSES = 0x00000001,
    DBG_HAS_ATTACH_PROCESS = 0x00000002,
    DBG_HAS_DETACH_PROCESS = 0x00000004,
    DBG_HAS_REQUEST_PAUSE = 0x00000008,
    DBG_HAS_SET_EXCEPTION_INFO = 0x00000010,
    DBG_HAS_THREAD_SUSPEND = 0x00000020,
    DBG_HAS_THREAD_CONTINUE = 0x00000040,
    DBG_HAS_SET_RESUME_MODE = 0x00000080,
    DBG_HAS_THREAD_GET_SREG_BASE = 0x00000100,
    DBG_HAS_CHECK_BPT = 0x00000200,
    DBG_HAS_OPEN_FILE = 0x00000400,
    DBG_HAS_UPDATE_CALL_STACK = 0x00000800,
    DBG_HAS_APPCALL = 0x00001000,
    DBG_HAS_REXEC = 0x00002000,
    DBG_HAS_MAP_ADDRESS = 0x00004000,
};

enum DBG_RESMOD
{
    DBG_RESMOD_STEP_INTO = 0x0001,
    DBG_RESMOD_STEP_OVER = 0x0002,
    DBG_RESMOD_STEP_OUT = 0x0004,
    DBG_RESMOD_STEP_SRCINTO = 0x0008,
    DBG_RESMOD_STEP_SRCOVER = 0x0010,
    DBG_RESMOD_STEP_SRCOUT = 0x0020,
    DBG_RESMOD_STEP_USER = 0x0040,
    DBG_RESMOD_STEP_HANDLE = 0x0080,
};

enum DBG_PROC
{
    DBG_PROC_IS_DLL = 0x01,
    DBG_PROC_IS_GUI = 0x02,
    DBG_PROC_32BIT = 0x04,
    DBG_PROC_64BIT = 0x08,
    DBG_NO_TRACE = 0x10,
    DBG_HIDE_WINDOW = 0x20,
    DBG_SUSPENDED = 0x40,
    DBG_NO_ASLR = 0x80,
};

enum BPT
{
    BPT_OK = 0,
    BPT_INTERNAL_ERR = 1,
    BPT_BAD_TYPE = 2,
    BPT_BAD_ALIGN = 3,
    BPT_BAD_ADDR = 4,
    BPT_BAD_LEN = 5,
    BPT_TOO_MANY = 6,
    BPT_READ_ERROR = 7,
    BPT_WRITE_ERROR = 8,
    BPT_SKIP = 9,
    BPT_PAGE_OK = 10,
};

enum APPCALL
{
    APPCALL_MANUAL = 0x0001,
    APPCALL_DEBEV = 0x0002,
    APPCALL_TIMEOUT = 0x0004,
};

enum RQ
{
    RQ_MASKING = 0x0001,
    RQ_SUSPEND = 0x0002,
    RQ_NOSUSP = 0x0000,
    RQ_IGNWERR = 0x0004,
    RQ_SILENT = 0x0008,
    RQ_VERBOSE = 0x0000,
    RQ_SWSCREEN = 0x0010,
    RQ__NOTHRRF = 0x0020,
    RQ_PROCEXIT = 0x0040,
    RQ_IDAIDLE = 0x0080,
    RQ_SUSPRUN = 0x0100,
    RQ_RESUME = 0x0200,
    RQ_RESMOD = 0xF000,
    RQ_RESMOD_SHIFT = 12,
    RQ_INTO = (1 << RQ_RESMOD_SHIFT),
};

// idp.hpp

enum noname_idp_hpp
{
    IDP_INTERFACE_VERSION_7x_8x = 700,
    IDP_INTERFACE_VERSION_9x = 900,
    HKCB_GLOBAL = 0x0001,
    CUSTOM_INSN_ITYPE = 0x8000,
    REG_SPOIL = 0x80000000L,
};

enum CF
{
    CF_STOP = 0x00001,
    CF_CALL = 0x00002,
    CF_CHG1 = 0x00004,
    CF_CHG2 = 0x00008,
    CF_CHG3 = 0x00010,
    CF_CHG4 = 0x00020,
    CF_CHG5 = 0x00040,
    CF_CHG6 = 0x00080,
    CF_USE1 = 0x00100,
    CF_USE2 = 0x00200,
    CF_USE3 = 0x00400,
    CF_USE4 = 0x00800,
    CF_USE5 = 0x01000,
    CF_USE6 = 0x02000,
    CF_JUMP = 0x04000,
    CF_SHFT = 0x08000,
    CF_HLL = 0x10000,
    CF_CHG7 = 0x020000,
    CF_CHG8 = 0x040000,
    CF_USE7 = 0x080000,
    CF_USE8 = 0x100000,
};

enum IRI
{
    IRI_EXTENDED = 0x00,
    IRI_RET_LITERALLY = 0x01,
    IRI_SKIP_RETTARGET = 0x02,
    IRI_STRICT = (IRI_RET_LITERALLY | IRI_SKIP_RETTARGET),
};

enum AS
{
    AS_OFFST = 0x00000001L,
    AS_COLON = 0x00000002L,
    AS_UDATA = 0x00000004L,
    AS_2CHRE = 0x00000008L,
    AS_NCHRE = 0x00000010L,
    AS_N2CHR = 0x00000020L,
    AS_1TEXT = 0x00000040L,
    AS_NHIAS = 0x00000080L,
    AS_NCMAS = 0x00000100L,
    AS_HEXFM = 0x00000E00L,
    ASH_HEXF0 = 0x00000000L,
    ASH_HEXF1 = 0x00000200L,
    ASH_HEXF2 = 0x00000400L,
    ASH_HEXF3 = 0x00000600L,
    ASH_HEXF4 = 0x00000800L,
    ASH_HEXF5 = 0x00000A00L,
    AS_DECFM = 0x00003000L,
    ASD_DECF0 = 0x00000000L,
    ASD_DECF1 = 0x00001000L,
    ASD_DECF2 = 0x00002000L,
    ASD_DECF3 = 0x00003000L,
    AS_OCTFM = 0x0001C000L,
    ASO_OCTF0 = 0x00000000L,
    ASO_OCTF1 = 0x00004000L,
    ASO_OCTF2 = 0x00008000L,
    ASO_OCTF3 = 0x0000C000L,
    ASO_OCTF4 = 0x00010000L,
    ASO_OCTF5 = 0x00014000L,
    ASO_OCTF6 = 0x00018000L,
    ASO_OCTF7 = 0x0001C000L,
    AS_BINFM = 0x000E0000L,
    ASB_BINF0 = 0x00000000L,
    ASB_BINF1 = 0x00020000L,
    ASB_BINF2 = 0x00040000L,
    ASB_BINF3 = 0x00060000L,
    ASB_BINF4 = 0x00080000L,
    ASB_BINF5 = 0x000A0000L,
    AS_UNEQU = 0x00100000L,
    AS_ONEDUP = 0x00200000L,
    AS_NOXRF = 0x00400000L,
    AS_XTRNTYPE = 0x00800000L,
    AS_RELSUP = 0x01000000L,
    AS_LALIGN = 0x02000000L,
    AS_NOCODECLN = 0x04000000L,
    AS_NOSPACE = 0x10000000L,
    AS_ALIGN2 = 0x20000000L,
    AS_ASCIIC = 0x40000000L,
    AS_ASCIIZ = 0x80000000L,
};

enum AS2
{
    AS2_BRACE = 0x00000001,
    AS2_STRINV = 0x00000002,
    AS2_BYTE1CHAR = 0x00000004,
    AS2_IDEALDSCR = 0x00000008,
    AS2_TERSESTR = 0x00000010,
    AS2_COLONSUF = 0x00000020,
    AS2_YWORD = 0x00000040,
    AS2_ZWORD = 0x00000080,
};

enum PLFM
{
    PLFM_386 = 0,
    PLFM_Z80 = 1,
    PLFM_I860 = 2,
    PLFM_8051 = 3,
    PLFM_TMS = 4,
    PLFM_6502 = 5,
    PLFM_PDP = 6,
    PLFM_68K = 7,
    PLFM_JAVA = 8,
    PLFM_6800 = 9,
    PLFM_ST7 = 10,
    PLFM_MC6812 = 11,
    PLFM_MIPS = 12,
    PLFM_ARM = 13,
    PLFM_TMSC6 = 14,
    PLFM_PPC = 15,
    PLFM_80196 = 16,
    PLFM_Z8 = 17,
    PLFM_SH = 18,
    PLFM_NET = 19,
    PLFM_AVR = 20,
    PLFM_H8 = 21,
    PLFM_PIC = 22,
    PLFM_SPARC = 23,
    PLFM_ALPHA = 24,
    PLFM_HPPA = 25,
    PLFM_H8500 = 26,
    PLFM_TRICORE = 27,
    PLFM_DSP56K = 28,
    PLFM_C166 = 29,
    PLFM_ST20 = 30,
    PLFM_IA64 = 31,
    PLFM_I960 = 32,
    PLFM_F2MC = 33,
    PLFM_TMS320C54 = 34,
    PLFM_TMS320C55 = 35,
    PLFM_TRIMEDIA = 36,
    PLFM_M32R = 37,
    PLFM_NEC_78K0 = 38,
    PLFM_NEC_78K0S = 39,
    PLFM_M740 = 40,
    PLFM_M7700 = 41,
    PLFM_ST9 = 42,
    PLFM_FR = 43,
    PLFM_MC6816 = 44,
    PLFM_M7900 = 45,
    PLFM_TMS320C3 = 46,
    PLFM_KR1878 = 47,
    PLFM_AD218X = 48,
    PLFM_OAKDSP = 49,
    PLFM_TLCS900 = 50,
    PLFM_C39 = 51,
    PLFM_CR16 = 52,
    PLFM_MN102L00 = 53,
    PLFM_TMS320C1X = 54,
    PLFM_NEC_V850X = 55,
    PLFM_SCR_ADPT = 56,
    PLFM_EBC = 57,
    PLFM_MSP430 = 58,
    PLFM_SPU = 59,
    PLFM_DALVIK = 60,
    PLFM_65C816 = 61,
    PLFM_M16C = 62,
    PLFM_ARC = 63,
    PLFM_UNSP = 64,
    PLFM_TMS320C28 = 65,
    PLFM_DSP96K = 66,
    PLFM_SPC700 = 67,
    PLFM_AD2106X = 68,
    PLFM_PIC16 = 69,
    PLFM_S390 = 70,
    PLFM_XTENSA = 71,
    PLFM_RISCV = 72,
    PLFM_RL78 = 73,
    PLFM_RX = 74,
};

enum PR
{
    PR_SEGS = 0x000001,
    PR_USE32 = 0x000002,
    PR_DEFSEG32 = 0x000004,
    PR_RNAMESOK = 0x000008,
    PR_DB2CSEG = 0x0010,
    PR_ADJSEGS = 0x000020,
    PR_DEFNUM = 0x0000C0,
    PRN_HEX = 0x000000,
    PRN_OCT = 0x000040,
    PRN_DEC = 0x000080,
    PRN_BIN = 0x0000C0,
    PR_WORD_INS = 0x000100,
    PR_NOCHANGE = 0x000200,
    PR_ASSEMBLE = 0x000400,
    PR_ALIGN = 0x000800,
    PR_TYPEINFO = 0x001000,
    PR_USE64 = 0x002000,
    PR_SGROTHER = 0x004000,
    PR_STACK_UP = 0x008000,
    PR_BINMEM = 0x010000,
    PR_SEGTRANS = 0x020000,
    PR_CHK_XREF = 0x040000,
    PR_NO_SEGMOVE = 0x080000,
    PR_FULL_HIFXP = 0x100000,
    PR_USE_ARG_TYPES = 0x200000,
    PR_SCALE_STKVARS = 0x400000,
    PR_DELAYED = 0x800000,
    PR_ALIGN_INSN = 0x1000000,
    PR_PURGING = 0x2000000,
    PR_CNDINSNS = 0x4000000,
    PR_USE_TBYTE = 0x8000000,
    PR_DEFSEG64 = 0x10000000,
    PR_OUTER = 0x20000000,
};

enum PR2
{
    PR2_MAPPINGS = 0x000001,
    PR2_IDP_OPTS = 0x000002,
    PR2_REALCVT = 0x000004,
    PR2_CODE16_BIT = 0x000008,
    PR2_MACRO = 0x000010,
    PR2_USE_CALCREL = 0x000020,
    PR2_REL_BITS = 0x000040,
    PR2_FORCE_16BIT = 0x000080,
};

enum OP_FP_SP
{
    OP_FP_BASED = 0x00000000,
    OP_SP_BASED = 0x00000001,
    OP_SP_ADD = 0x00000000,
    OP_SP_SUB = 0x00000002,
};

enum IM
{
    IM_NONE = 0,
    IM_PROLOG = 1,
    IM_EPILOG = 2,
    IM_SWITCH = 3,
};

// ieee.h

enum noname_ieee_h
{
    FPVAL_NWORDS_7x_8x = 6,
    FPVAL_NWORDS_9x = 8,
};

enum max_exp
{
    MAXEXP_FLOAT = 0x80,
    MAXEXP_DOUBLE = 0x400,
    MAXEXP_LNGDBL = 0x4000,
};

enum IEEE
{
    IEEE_EXONE = 0x3FFF,
    E_SPECIAL_EXP = 0x7FFF,
    IEEE_NI_7x_8x = FPVAL_NWORDS_7x_8x + 3,
    IEEE_NI_9x = FPVAL_NWORDS_9x + 3,
    IEEE_E = 1,
    IEEE_M = 2,
};

// intel.hpp

enum noname_intel_hpp
{
    PROC_MAXOP = 5,
    SEGREG_IMM = 0xFFFF,
};

enum auxpref
{
    aux_lock = 0x00000001,
    aux_rep = 0x00000002,
    aux_repne = 0x00000004,
    aux_use32 = 0x00000008,
    aux_use64 = 0x00000010,
    aux_large = 0x00000020,
    aux_short = 0x00000040,
    aux_sgpref = 0x00000080,
    aux_oppref = 0x00000100,
    aux_adpref = 0x00000200,
    aux_basess = 0x00000400,
    aux_natop = 0x00000800,
    aux_natad = 0x00001000,
    aux_fpemu = 0x00002000,
    aux_vexpr = 0x00004000,
    aux_bnd = 0x00008000,
    aux_evex = 0x00010000,
    aux_xop = 0x00020000,
    aux_xacquire = 0x00040000,
    aux_xrelease = 0x00080000,
};

enum o_reg
{
    o_trreg = 8,   // o_idpspec0
    o_dbreg = 9,   // o_idpspec1
    o_crreg = 10,  // o_idpspec2
    o_fpreg = 11,  // o_idpspec3
    o_mmxreg = 12, // o_idpspec4
    o_xmmreg = 13, // o_idpspec5,
    o_ymmreg = 14, // o_idpspec5 + 1
    o_zmmreg = 15, // o_idpspec5 + 2
    o_kreg = 16,   // o_idpspec5 + 3
};

enum EVEX
{
    EVEX_R = 0x01,
    EVEX_L = 0x02,
    EVEX_z = 0x04,
    EVEX_b = 0x08,
    EVEX_V = 0x10,
};

enum REX
{
    REX_W = 8,
    REX_R = 4,
    REX_X = 2,
    REX_B = 1,
    VEX_L = 0x80,
};

enum PRF
{
    PRF_NONE = 0x0000,
    PRF_MOVE = 0x0001,
    PRF_SPILL = 0x0002,
    PRF_MASK = (PRF_MOVE | PRF_SPILL),
};

enum PINF
{
    PINF_SEHCALL = 0x0001,
    PINF_SEHMAN = 0x0002,
    PINF_COOKIE = 0x0004,
    PINF_ALIGNED = 0x0008,
    PINF_VARARG = 0x0010,
    PINF_BPOFF = 0x0020,
    PINF_HAVE_SSIZE = 0x0040,
    PINF_PSI_FLAGS = 0x0080,
};

enum EH
{
    EH_NONE = 0,
    EH_VCSEH = 1,
    EH_VCCPPEH = 2,
};

enum AFIDP
{
    AFIDP_PUSH = 0x0001,
    AFIDP_NOP = 0x0002,
    AFIDP_MOVOFF = 0x0004,
    AFIDP_MOVOFF2 = 0x0008,
    AFIDP_ZEROINS = 0x0010,
    AFIDP_BRTTI = 0x0020,
    AFIDP_UNKRTTI = 0x0040,
    AFIDP_EXPFUNC = 0x0080,
    AFIDP_DIFBASE = 0x0100,
    AFIDP_NOPREF = 0x0200,
    AFIDP_NOVXD = 0x0400,
    AFIDP_NOFPEMU = 0x0800,
    AFIDP_SHOWRIP = 0x1000,
    AFIDP_NOSEH = 0x2000,
    AFIDP_INT3STOP = 0x4000,
    AFIDP_NOAGGRJMPS = 0x8000,
};

enum PT
{
    _PT_486p = 0x00000001,
    _PT_486r = 0x00000002,
    _PT_386p = 0x00000004,
    _PT_386r = 0x00000008,
    _PT_286p = 0x00000010,
    _PT_286r = 0x00000020,
    _PT_086 = 0x00000040,
    _PT_586p = 0x00000080,
    _PT_586r = 0x00000100,
    _PT_686r = 0x00000200,
    _PT_686p = 0x00000400,
    _PT_mmx = 0x00000800,
    _PT_pii = 0x00001000,
    _PT_3d = 0x00002000,
    _PT_piii = 0x00004000,
    _PT_k7 = 0x00008000,
    _PT_p4 = 0x00010000,
    _PT_sse3 = 0x00020000,
    _PT_sse4 = 0x00040000,
    PT_sse4 = _PT_sse4,
    PT_sse3 = (_PT_sse3 | _PT_sse4),
    PT_p4 = (PT_sse3 | _PT_p4),
    PT_k7 = (PT_p4 | _PT_k7),
    PT_piii = (PT_k7 | _PT_piii),
    PT_k62 = (PT_piii | _PT_3d),
    PT_3d = _PT_3d,
    PT_pii = (PT_piii | _PT_pii),
    PT_mmx = (_PT_mmx | _PT_3d),
    PT_686p = (PT_pii | _PT_686p),
    PT_686r = (PT_686p | _PT_686r),
    PT_586p = (PT_686r | _PT_586p),
    PT_586r = (PT_586p | _PT_586r),
    PT_486p = (PT_586r | _PT_486p),
    PT_486r = (PT_486p | _PT_486r),
    PT_386p = (PT_486r | _PT_386p),
    PT_386r = (PT_386p | _PT_386r),
    PT_286p = (PT_386r | _PT_286p),
    PT_286r = (PT_286p | _PT_286r),
    PT_086 = (PT_286r | _PT_086),
    PT_ismmx = (_PT_mmx),
    PT_is686 = (_PT_686r | _PT_686p),
    PT_is586 = (_PT_586r | _PT_586p),
    PT_is486 = (_PT_486r | _PT_486p),
    PT_is386 = (_PT_386r | _PT_386p),
    PT_is286 = (_PT_286r | _PT_286p),
    PT_is086 = (_PT_086),
};

// jumptable.hpp

enum noname_jumptable_hpp
{
    NINS = 16,
    INS_MASK = 0x0F,
    o_condjump = 99,
    cc_inc_ncases = 0x01,
    cc_check_max_ncases = 0x02,
};

enum JPT
{
    JPT_OPT = 0x10,
    JPT_NEAR = 0x20,
};

enum dt_bit
{
    dt_7bit = 255,
    dt_6bit = 254,
    dt_5bit = 253,
    dt_4bit = 252,
    dt_3bit = 251,
    dt_2bit = 250,
};

// kernwin.hpp

enum noname_kernwin_hpp
{
    IDALIB_API_MAGIC = 0x001DA11B00000000LL,
    DEFAULT_PLACE_LNNUM = -1,
    MAX_PLACE_LNNUM = 2147483647,   // INT_MAX = 0x7FFFFFFF
    MAX_NUMBUF = (128 + 8), ///< 16-byte value in binary base (0b00101010...)
};

enum SETMENU
{
    SETMENU_POSMASK = 0x3,
    SETMENU_INS = 0x0,
    SETMENU_APP = 0x1,
    SETMENU_FIRST = 0x2,
    SETMENU_ENSURE_SEP = 0x8,
};

enum CREATETB
{
    CREATETB_ADV = 0x1,
};

enum HIF
{
    HIF_IDENTIFIER = 0x1,
    HIF_REGISTER = 0x2,
    HIF_LOCKED = 0x4,
    HIF_NOCASE = 0x8,
    HIF_USE_SLOT = (1 << 27),
    HIF_SLOT_SHIFT = 28,
    HIF_SLOT_0 = (HIF_USE_SLOT | (0 << HIF_SLOT_SHIFT)),
    HIF_SLOT_1 = (HIF_USE_SLOT | (1 << HIF_SLOT_SHIFT)),
    HIF_SLOT_2 = (HIF_USE_SLOT | (2 << HIF_SLOT_SHIFT)),
    HIF_SLOT_3 = (HIF_USE_SLOT | (3 << HIF_SLOT_SHIFT)),
    HIF_SLOT_4 = (HIF_USE_SLOT | (4 << HIF_SLOT_SHIFT)),
    HIF_SLOT_5 = (HIF_USE_SLOT | (5 << HIF_SLOT_SHIFT)),
    HIF_SLOT_6 = (HIF_USE_SLOT | (6 << HIF_SLOT_SHIFT)),
    HIF_SLOT_7 = (HIF_USE_SLOT | (7 << HIF_SLOT_SHIFT)),
};

enum CDVF
{
    CDVF_NOLINES = 0x0001,
    CDVF_LINEICONS = 0x0002,
    CDVF_STATUSBAR = 0x0004,
};

enum IDCHK
{
    IDCHK_OK = 0,
    IDCHK_ARG = -1,
    IDCHK_KEY = -2,
    IDCHK_MAX = -3,
};

enum WIDGET_CLOSE
{
    WCLS_SAVE = 0x1,
    WCLS_NO_CONTEXT = 0x2,
    WCLS_DONT_SAVE_SIZE = 0x4,
    WCLS_DELETE_LATER = 0x8,
    WCLS_CLOSE_LATER = WCLS_DELETE_LATER,
};

enum DP
{
    DP_LEFT = 0x0001,
    DP_TOP = 0x0002,
    DP_RIGHT = 0x0004,
    DP_BOTTOM = 0x0008,
    DP_INSIDE = 0x0010,
    DP_TAB = 0x0040,
    DP_BEFORE = 0x0020,
    DP_FLOATING = 0x0080,
    DP_SZHINT = 0x0100,
};

enum SVF
{
    SVF_COPY_LINES = 0x0000,
    SVF_LINES_BYPTR = 0x0001,
};

enum CVNF
{
    CVNF_LAZY = (1 << 0),
    CVNF_JUMP = (1 << 1),
    CVNF_ACT = (1 << 2),
};

enum WIDGET_OPEN
{
    WOPN_RESTORE = 0x00000004u,
    WOPN_PERSIST = 0x00000040u,
    WOPN_CLOSED_BY_ESC = 0x00000080u,
    WOPN_NOT_CLOSED_BY_ESC = 0x00000100u,
    WOPN_DP_MASK = 0x0FFF0000u,
    WOPN_DP_SHIFT = 16,
    WOPN_DP_LEFT = (DP_LEFT << WOPN_DP_SHIFT),
    WOPN_DP_TOP = (DP_TOP << WOPN_DP_SHIFT),
    WOPN_DP_RIGHT = (DP_RIGHT << WOPN_DP_SHIFT),
    WOPN_DP_BOTTOM = (DP_BOTTOM << WOPN_DP_SHIFT),
    WOPN_DP_INSIDE = (DP_INSIDE << WOPN_DP_SHIFT),
    WOPN_DP_TAB = (DP_TAB << WOPN_DP_SHIFT),
    WOPN_DP_BEFORE = (DP_BEFORE << WOPN_DP_SHIFT),
    WOPN_DP_FLOATING = (DP_FLOATING << WOPN_DP_SHIFT),
    WOPN_DP_SZHINT = (DP_SZHINT << WOPN_DP_SHIFT),
    WOPN_DP_INSIDE_BEFORE = (WOPN_DP_INSIDE | WOPN_DP_BEFORE),
    WOPN_DP_TAB_BEFORE = (WOPN_DP_TAB | WOPN_DP_BEFORE),
};

enum RENADDR_DIALOGS
{
    RENADDR_IDA = 0,
    RENADDR_HR = 1,
};

enum CVLF
{
    CVLF_USE_MOUSE = 0x1,
};

enum HEXPLACE_COLOR
{
    HEXPLACE_COLOR_EDITED = 0x09,     // COLOR_SYMBOL
    HEXPLACE_COLOR_PATCHED = 0x0D,    // COLOR_VOIDOP
    HEXPLACE_COLOR_SHOWSPACES = 0x29, // COLOR_RESERVED1 = COLOR_ADDR + 11 = COLOR_FG_MAX + 1 = 0x28 + 1
};

enum tif_cursor_e
{
    TIF_CURSOR_HEADER = -2,
    TIF_CURSOR_FOOTER = -1,
};

enum PCF
{
    PCF_EA_CAPABLE = 0x00000001,
    PCF_MAKEPLACE_ALLOCATES = 0x00000002,
};

enum CK
{
    CK_TRACE = 80,
    CK_TRACE_OVL = 81,
    CK_EXTRA1 = 82,
    CK_EXTRA2 = 83,
    CK_EXTRA3 = 84,
    CK_EXTRA4 = 85,
    CK_EXTRA5 = 86,
    CK_EXTRA6 = 87,
    CK_EXTRA7 = 88,
    CK_EXTRA8 = 89,
    CK_EXTRA9 = 90,
    CK_EXTRA10 = 91,
    CK_EXTRA11 = 92,
    CK_EXTRA12 = 93,
    CK_EXTRA13 = 94,
    CK_EXTRA14 = 95,
    CK_EXTRA15 = 96,
    CK_EXTRA16 = 97,
};

enum LROEF
{
    LROEF_MASK = 0x00FFFFFF,
    LROEF_FULL_LINE = 0x00000000,
    LROEF_CPS_RANGE = 0x00000001,
};

enum class BWN_7x_83 : unsigned long long
{
    BWN_UNKNOWN = -1ULL,
    BWN_EXPORTS = 0ULL,
    BWN_IMPORTS = 1,
    BWN_NAMES = 2,
    BWN_FUNCS = 3,
    BWN_STRINGS = 4,
    BWN_SEGS = 5,
    BWN_SEGREGS = 6,
    BWN_SELS = 7,
    BWN_SIGNS = 8,
    BWN_TILS = 9,
    BWN_LOCTYPS = 10,
    BWN_CALLS = 11,
    BWN_PROBS = 12,
    BWN_BPTS = 13,
    BWN_THREADS = 14,
    BWN_MODULES = 15,
    BWN_TRACE = 16,
    BWN_CALL_STACK = 17,
    BWN_XREFS = 18,
    BWN_SEARCH = 19,
    BWN_FRAME = 25,
    BWN_NAVBAND = 26,
    BWN_ENUMS = 27,
    BWN_STRUCTS = 28,
    BWN_DISASM = 29,
    BWN_DUMP = 30,
    BWN_NOTEPAD = 31,
    BWN_OUTPUT = 32,
    BWN_CLI = 33,
    BWN_WATCH = 34,
    BWN_LOCALS = 35,
    BWN_STKVIEW = 36,
    BWN_CHOOSER = 37,
    BWN_SHORTCUTCSR = 38,
    BWN_SHORTCUTWIN = 39,
    BWN_CPUREGS = 40,
    BWN_SO_STRUCTS = 41,
    BWN_SO_OFFSETS = 42,
    BWN_CMDPALCSR = 43,
    BWN_CMDPALWIN = 44,
    BWN_SNIPPETS = 45,
    BWN_CUSTVIEW = 46,
    BWN_ADDRWATCH = 47,
    BWN_PSEUDOCODE = 48,
    BWN_CALLS_CALLERS = 49,
    BWN_CALLS_CALLEES = 50,
    BWN_MDVIEWCSR = 51,
    BWN_DISASM_ARROWS = 52,
    BWN_CV_LINE_INFOS = 53,
    BWN_SRCPTHMAP_CSR = 54,
    BWN_SRCPTHUND_CSR = 55,
    BWN_UNDOHIST = 56,
    BWN_SNIPPETS_CSR = 57,
    BWN_SCRIPTS_CSR = 58,
    BWN_BOOKMARKS = 59,
    BWN_TILIST = 60,
    BWN_STACK = BWN_CALL_STACK,
    BWN_DISASMS = BWN_DISASM,
    BWN_DUMPS = BWN_DUMP,
    BWN_SEARCHS = BWN_SEARCH,
};

enum class IWID_7x_83 : unsigned long long
{
    IWID_EXPORTS = (1ULL << (unsigned long long)BWN_7x_83::BWN_EXPORTS),
    IWID_IMPORTS = (1ULL << (unsigned long long)BWN_7x_83::BWN_IMPORTS),
    IWID_NAMES = (1ULL << (unsigned long long)BWN_7x_83::BWN_NAMES),
    IWID_FUNCS = (1ULL << (unsigned long long)BWN_7x_83::BWN_FUNCS),
    IWID_STRINGS = (1ULL << (unsigned long long)BWN_7x_83::BWN_STRINGS),
    IWID_SEGS = (1ULL << (unsigned long long)BWN_7x_83::BWN_SEGS),
    IWID_SEGREGS = (1ULL << (unsigned long long)BWN_7x_83::BWN_SEGREGS),
    IWID_SELS = (1ULL << (unsigned long long)BWN_7x_83::BWN_SELS),
    IWID_SIGNS = (1ULL << (unsigned long long)BWN_7x_83::BWN_SIGNS),
    IWID_TILS = (1ULL << (unsigned long long)BWN_7x_83::BWN_TILS),
    IWID_LOCTYPS = (1ULL << (unsigned long long)BWN_7x_83::BWN_LOCTYPS),
    IWID_CALLS = (1ULL << (unsigned long long)BWN_7x_83::BWN_CALLS),
    IWID_PROBS = (1ULL << (unsigned long long)BWN_7x_83::BWN_PROBS),
    IWID_BPTS = (1ULL << (unsigned long long)BWN_7x_83::BWN_BPTS),
    IWID_THREADS = (1ULL << (unsigned long long)BWN_7x_83::BWN_THREADS),
    IWID_MODULES = (1ULL << (unsigned long long)BWN_7x_83::BWN_MODULES),
    IWID_TRACE = (1ULL << (unsigned long long)BWN_7x_83::BWN_TRACE),
    IWID_CALL_STACK = (1ULL << (unsigned long long)BWN_7x_83::BWN_CALL_STACK),
    IWID_SEARCH = (1ULL << (unsigned long long)BWN_7x_83::BWN_SEARCH),
    IWID_FRAME = (1ULL << (unsigned long long)BWN_7x_83::BWN_FRAME),
    IWID_NAVBAND = (1ULL << (unsigned long long)BWN_7x_83::BWN_NAVBAND),
    IWID_ENUMS = (1ULL << (unsigned long long)BWN_7x_83::BWN_ENUMS),
    IWID_STRUCTS = (1ULL << (unsigned long long)BWN_7x_83::BWN_STRUCTS),
    IWID_DISASM = (1ULL << (unsigned long long)BWN_7x_83::BWN_DISASM),
    IWID_DUMP = (1ULL << (unsigned long long)BWN_7x_83::BWN_DUMP),
    IWID_NOTEPAD = (1ULL << (unsigned long long)BWN_7x_83::BWN_NOTEPAD),
    IWID_OUTPUT = (1ULL << (unsigned long long)BWN_7x_83::BWN_OUTPUT),
    IWID_CLI = (1ULL << (unsigned long long)BWN_7x_83::BWN_CLI),
    IWID_WATCH = (1ULL << (unsigned long long)BWN_7x_83::BWN_WATCH),
    IWID_LOCALS = (1ULL << (unsigned long long)BWN_7x_83::BWN_LOCALS),
    IWID_STKVIEW = (1ULL << (unsigned long long)BWN_7x_83::BWN_STKVIEW),
    IWID_CHOOSER = (1ULL << (unsigned long long)BWN_7x_83::BWN_CHOOSER),
    IWID_SHORTCUTCSR = (1ULL << (unsigned long long)BWN_7x_83::BWN_SHORTCUTCSR),
    IWID_SHORTCUTWIN = (1ULL << (unsigned long long)BWN_7x_83::BWN_SHORTCUTWIN),
    IWID_CPUREGS = (1ULL << (unsigned long long)BWN_7x_83::BWN_CPUREGS),
    IWID_SO_STRUCTS = (1ULL << (unsigned long long)BWN_7x_83::BWN_SO_STRUCTS),
    IWID_SO_OFFSETS = (1ULL << (unsigned long long)BWN_7x_83::BWN_SO_OFFSETS),
    IWID_CMDPALCSR = (1ULL << (unsigned long long)BWN_7x_83::BWN_CMDPALCSR),
    IWID_CMDPALWIN = (1ULL << (unsigned long long)BWN_7x_83::BWN_CMDPALWIN),
    IWID_SNIPPETS = (1ULL << (unsigned long long)BWN_7x_83::BWN_SNIPPETS),
    IWID_CUSTVIEW = (1ULL << (unsigned long long)BWN_7x_83::BWN_CUSTVIEW),
    IWID_ADDRWATCH = (1ULL << (unsigned long long)BWN_7x_83::BWN_ADDRWATCH),
    IWID_PSEUDOCODE = (1ULL << (unsigned long long)BWN_7x_83::BWN_PSEUDOCODE),
    IWID_CALLS_CALLERS = (1ULL << (unsigned long long)BWN_7x_83::BWN_CALLS_CALLERS),
    IWID_CALLS_CALLEES = (1ULL << (unsigned long long)BWN_7x_83::BWN_CALLS_CALLEES),
    IWID_MDVIEWCSR = (1ULL << (unsigned long long)BWN_7x_83::BWN_MDVIEWCSR),
    IWID_DISASM_ARROWS = (1ULL << (unsigned long long)BWN_7x_83::BWN_DISASM_ARROWS),
    IWID_CV_LINE_INFOS = (1ULL << (unsigned long long)BWN_7x_83::BWN_CV_LINE_INFOS),
    IWID_SRCPTHMAP_CSR = (1ULL << (unsigned long long)BWN_7x_83::BWN_SRCPTHMAP_CSR),
    IWID_SRCPTHUND_CSR = (1ULL << (unsigned long long)BWN_7x_83::BWN_SRCPTHUND_CSR),
    IWID_UNDOHIST = (1ULL << (unsigned long long)BWN_7x_83::BWN_UNDOHIST),
    IWID_SNIPPETS_CSR = (1ULL << (unsigned long long)BWN_7x_83::BWN_SNIPPETS_CSR),
    IWID_SCRIPTS_CSR = (1ULL << (unsigned long long)BWN_7x_83::BWN_SCRIPTS_CSR),
    IWID_BOOKMARKS = (1ULL << (unsigned long long)BWN_7x_83::BWN_BOOKMARKS),
    IWID_TILIST = (1ULL << (unsigned long long)BWN_7x_83::BWN_TILIST),
    IWID_ALL = 0xFFFFFFFFFFFFFFFFULL,
    IWID_STACK = IWID_CALL_STACK,
    IWID_DISASMS = IWID_DISASM,
    IWID_DUMPS = IWID_DUMP,
    IWID_SEARCHS = IWID_SEARCH,
    IWID_IDAMEMOS = (IWID_DISASMS | IWID_DUMPS),
};

enum class BWN_84_9x : unsigned long long
{
    BWN_UNKNOWN = -1ULL,
    BWN_EXPORTS = 0ULL,
    BWN_IMPORTS = 1,
    BWN_NAMES = 2,
    BWN_FUNCS = 3,
    BWN_STRINGS = 4,
    BWN_SEGS = 5,
    BWN_SEGREGS = 6,
    BWN_SELS = 7,
    BWN_SIGNS = 8,
    BWN_TILS = 9,
    BWN_TILVIEW = 10,
    BWN_CALLS = 11,
    BWN_PROBS = 12,
    BWN_BPTS = 13,
    BWN_THREADS = 14,
    BWN_MODULES = 15,
    BWN_TRACE = 16,
    BWN_CALL_STACK = 17,
    BWN_XREFS = 18,
    BWN_SEARCH = 19,
    BWN_FRAME = 25,
    BWN_NAVBAND = 26,
    BWN_DISASM = 27,
    BWN_DUMP = 28,
    BWN_HEXVIEW = BWN_DUMP, // 9.0 Release
    BWN_NOTEPAD = 29,
    BWN_OUTPUT = 30,
    BWN_CLI = 31,
    BWN_WATCH = 32,
    BWN_LOCALS = 33,
    BWN_STKVIEW = 34,
    BWN_CHOOSER = 35,
    BWN_SHORTCUTCSR = 36,
    BWN_SHORTCUTWIN = 37,
    BWN_CPUREGS = 38,
    BWN_SO_STRUCTS = 39,
    BWN_SO_OFFSETS = 40,
    BWN_CMDPALCSR = 41,
    BWN_CMDPALWIN = 42,
    BWN_SNIPPETS = 43,
    BWN_CUSTVIEW = 44,
    BWN_ADDRWATCH = 45,
    BWN_PSEUDOCODE = 46,
    BWN_CALLS_CALLERS = 47,
    BWN_CALLS_CALLEES = 48,
    BWN_MDVIEWCSR = 49,
    BWN_DISASM_ARROWS = 50,
    BWN_CV_LINE_INFOS = 51,
    BWN_SRCPTHMAP_CSR = 52,
    BWN_SRCPTHUND_CSR = 53,
    BWN_UNDOHIST = 54,
    BWN_SNIPPETS_CSR = 55,
    BWN_SCRIPTS_CSR = 56,
    BWN_BOOKMARKS = 57,
    BWN_TILIST = 58,
    BWN_TIL_VIEW = 59,  // 9.0 SP1
    BWN_STACK = BWN_CALL_STACK,
    BWN_DISASMS = BWN_DISASM,
    BWN_DUMPS = BWN_DUMP,
    BWN_SEARCHS = BWN_SEARCH,
};

enum class IWID_84_9x : unsigned long long
{
    IWID_EXPORTS = (1ULL << (unsigned long long)BWN_84_9x::BWN_EXPORTS),
    IWID_IMPORTS = (1ULL << (unsigned long long)BWN_84_9x::BWN_IMPORTS),
    IWID_NAMES = (1ULL << (unsigned long long)BWN_84_9x::BWN_NAMES),
    IWID_FUNCS = (1ULL << (unsigned long long)BWN_84_9x::BWN_FUNCS),
    IWID_STRINGS = (1ULL << (unsigned long long)BWN_84_9x::BWN_STRINGS),
    IWID_SEGS = (1ULL << (unsigned long long)BWN_84_9x::BWN_SEGS),
    IWID_SEGREGS = (1ULL << (unsigned long long)BWN_84_9x::BWN_SEGREGS),
    IWID_SELS = (1ULL << (unsigned long long)BWN_84_9x::BWN_SELS),
    IWID_SIGNS = (1ULL << (unsigned long long)BWN_84_9x::BWN_SIGNS),
    IWID_TILS = (1ULL << (unsigned long long)BWN_84_9x::BWN_TILS),
    IWID_TILVIEW = (1ULL << (unsigned long long)BWN_84_9x::BWN_TILVIEW),
    IWID_CALLS = (1ULL << (unsigned long long)BWN_84_9x::BWN_CALLS),
    IWID_PROBS = (1ULL << (unsigned long long)BWN_84_9x::BWN_PROBS),
    IWID_BPTS = (1ULL << (unsigned long long)BWN_84_9x::BWN_BPTS),
    IWID_THREADS = (1ULL << (unsigned long long)BWN_84_9x::BWN_THREADS),
    IWID_MODULES = (1ULL << (unsigned long long)BWN_84_9x::BWN_MODULES),
    IWID_TRACE = (1ULL << (unsigned long long)BWN_84_9x::BWN_TRACE),
    IWID_CALL_STACK = (1ULL << (unsigned long long)BWN_84_9x::BWN_CALL_STACK),
    IWID_SEARCH = (1ULL << (unsigned long long)BWN_84_9x::BWN_SEARCH),
    IWID_FRAME = (1ULL << (unsigned long long)BWN_84_9x::BWN_FRAME),
    IWID_NAVBAND = (1ULL << (unsigned long long)BWN_84_9x::BWN_NAVBAND),
    IWID_DISASM = (1ULL << (unsigned long long)BWN_84_9x::BWN_DISASM),
    IWID_DUMP = (1ULL << (unsigned long long)BWN_84_9x::BWN_DUMP),
    IWID_HEXVIEW = (1ULL << (unsigned long long)BWN_84_9x::BWN_HEXVIEW),
    IWID_NOTEPAD = (1ULL << (unsigned long long)BWN_84_9x::BWN_NOTEPAD),
    IWID_OUTPUT = (1ULL << (unsigned long long)BWN_84_9x::BWN_OUTPUT),
    IWID_CLI = (1ULL << (unsigned long long)BWN_84_9x::BWN_CLI),
    IWID_WATCH = (1ULL << (unsigned long long)BWN_84_9x::BWN_WATCH),
    IWID_LOCALS = (1ULL << (unsigned long long)BWN_84_9x::BWN_LOCALS),
    IWID_STKVIEW = (1ULL << (unsigned long long)BWN_84_9x::BWN_STKVIEW),
    IWID_CHOOSER = (1ULL << (unsigned long long)BWN_84_9x::BWN_CHOOSER),
    IWID_SHORTCUTCSR = (1ULL << (unsigned long long)BWN_84_9x::BWN_SHORTCUTCSR),
    IWID_SHORTCUTWIN = (1ULL << (unsigned long long)BWN_84_9x::BWN_SHORTCUTWIN),
    IWID_CPUREGS = (1ULL << (unsigned long long)BWN_84_9x::BWN_CPUREGS),
    IWID_SO_STRUCTS = (1ULL << (unsigned long long)BWN_84_9x::BWN_SO_STRUCTS),
    IWID_SO_OFFSETS = (1ULL << (unsigned long long)BWN_84_9x::BWN_SO_OFFSETS),
    IWID_CMDPALCSR = (1ULL << (unsigned long long)BWN_84_9x::BWN_CMDPALCSR),
    IWID_CMDPALWIN = (1ULL << (unsigned long long)BWN_84_9x::BWN_CMDPALWIN),
    IWID_SNIPPETS = (1ULL << (unsigned long long)BWN_84_9x::BWN_SNIPPETS),
    IWID_CUSTVIEW = (1ULL << (unsigned long long)BWN_84_9x::BWN_CUSTVIEW),
    IWID_ADDRWATCH = (1ULL << (unsigned long long)BWN_84_9x::BWN_ADDRWATCH),
    IWID_PSEUDOCODE = (1ULL << (unsigned long long)BWN_84_9x::BWN_PSEUDOCODE),
    IWID_CALLS_CALLERS = (1ULL << (unsigned long long)BWN_84_9x::BWN_CALLS_CALLERS),
    IWID_CALLS_CALLEES = (1ULL << (unsigned long long)BWN_84_9x::BWN_CALLS_CALLEES),
    IWID_MDVIEWCSR = (1ULL << (unsigned long long)BWN_84_9x::BWN_MDVIEWCSR),
    IWID_DISASM_ARROWS = (1ULL << (unsigned long long)BWN_84_9x::BWN_DISASM_ARROWS),
    IWID_CV_LINE_INFOS = (1ULL << (unsigned long long)BWN_84_9x::BWN_CV_LINE_INFOS),
    IWID_SRCPTHMAP_CSR = (1ULL << (unsigned long long)BWN_84_9x::BWN_SRCPTHMAP_CSR),
    IWID_SRCPTHUND_CSR = (1ULL << (unsigned long long)BWN_84_9x::BWN_SRCPTHUND_CSR),
    IWID_UNDOHIST = (1ULL << (unsigned long long)BWN_84_9x::BWN_UNDOHIST),
    IWID_SNIPPETS_CSR = (1ULL << (unsigned long long)BWN_84_9x::BWN_SNIPPETS_CSR),
    IWID_SCRIPTS_CSR = (1ULL << (unsigned long long)BWN_84_9x::BWN_SCRIPTS_CSR),
    IWID_BOOKMARKS = (1ULL << (unsigned long long)BWN_84_9x::BWN_BOOKMARKS),
    IWID_TILIST = (1ULL << (unsigned long long)BWN_84_9x::BWN_TILIST),
    IWID_TIL_VIEW = (1ULL << (unsigned long long)BWN_84_9x::BWN_TIL_VIEW),  // 9.0 SP1
    IWID_IDAMEMOS = (IWID_DISASM | IWID_DUMP),

    IWID_ALL = 0xFFFFFFFFFFFFFFFFULL,
    IWID_STACK = IWID_CALL_STACK,
    IWID_DISASMS = IWID_DISASM,
    IWID_DUMPS = IWID_DUMP,
    IWID_SEARCHS = IWID_SEARCH,

    // 9.0 Release
    IWID_ANY_LISTING = (IWID_DISASM | IWID_HEXVIEW | IWID_TILIST | IWID_FRAME | IWID_PSEUDOCODE | IWID_CUSTVIEW),
    IWID_EA_LISTING = (IWID_DISASM | IWID_HEXVIEW | IWID_PSEUDOCODE),
};

enum IDA_DEBUG
{
    IDA_DEBUG_DREFS = 0x00000001,
    IDA_DEBUG_OFFSET = 0x00000002,
    IDA_DEBUG_FLIRT = 0x00000004,
    IDA_DEBUG_IDP = 0x00000008,
    IDA_DEBUG_LDR = 0x00000010,
    IDA_DEBUG_PLUGIN = 0x00000020,
    IDA_DEBUG_IDS = 0x00000040,
    IDA_DEBUG_CONFIG = 0x00000080,
    IDA_DEBUG_CHECKMEM = 0x00000100,
    IDA_DEBUG_LICENSE = 0x00000200,
    IDA_DEBUG_DEMANGLE = 0x00000400,
    IDA_DEBUG_QUEUE = 0x00000800,
    IDA_DEBUG_ROLLBACK = 0x00001000,
    IDA_DEBUG_ALREADY = 0x00002000,
    IDA_DEBUG_TIL = 0x00004000,
    IDA_DEBUG_NOTIFY = 0x00008000,
    IDA_DEBUG_DEBUGGER = 0x00010000,
    IDA_DEBUG_APPCALL = 0x00020000,
    IDA_DEBUG_SRCDBG = 0x00040000,
    IDA_DEBUG_ACCESSIBILITY = 0x00080000,
    IDA_DEBUG_NETWORK = 0x00100000,
    IDA_DEBUG_INTERNET = IDA_DEBUG_NETWORK,
    IDA_DEBUG_SIMPLEX = 0x00200000,
    IDA_DEBUG_DBGINFO = 0x00400000,
    IDA_DEBUG_LUMINA = 0x00800000,
    IDA_DEBUG_THEMES = 0x01000000,
    IDA_DEBUG_REGEX = 0x02000000,
    IDA_DEBUG_SUBPROC = 0x04000000,
    IDA_DEBUG_RANGECB = 0x08000000,
    IDA_DEBUG_ALWAYS = 0xFFFFFFFF,
};

enum CH
{
    CH_MODAL = 0x00000001,
    CH_KEEP = 0x00000002,
    CH_MULTI = 0x00000004,
    CH_MULTI_EDIT = 0x00000008,
    CH_NOBTNS = 0x00000010,
    CH_ATTRS = 0x00000020,
    CH_NOIDB = 0x00000040,
    CH_FORCE_DEFAULT = 0x00000080,
    CH_CAN_INS = 0x00000100,
    CH_CAN_DEL = 0x00000200,
    CH_CAN_EDIT = 0x00000400,
    CH_CAN_REFRESH = 0x00000800,
    CH_QFLT = 0x00001000,
    CH_QFTYP_SHIFT = 13,
    CH_QFTYP_DEFAULT = 0,                         ///< set quick filtering type to the
    CH_QFTYP_NORMAL = (1 << CH_QFTYP_SHIFT),      ///< normal (i.e.
    CH_QFTYP_WHOLE_WORDS = (2 << CH_QFTYP_SHIFT), ///< whole words
    CH_QFTYP_REGEX = (3 << CH_QFTYP_SHIFT),       ///< regex quick
    CH_QFTYP_FUZZY = (4 << CH_QFTYP_SHIFT),       ///< fuzzy search
    CH_QFTYP_MASK = (0x7 << CH_QFTYP_SHIFT),
    CH_NO_STATUS_BAR = 0x00010000,
    CH_RESTORE = 0x00020000,
    CH_RENAME_IS_EDIT = 0x00040000,
    CH_BUILTIN_SHIFT = 19,
    CH_BUILTIN_MASK = (0x3F << CH_BUILTIN_SHIFT),
    CH_HAS_DIRTREE = 0x02000000,
    CH_TM_NO_TREE = 0x00000000,      ///< chooser will show up in n
    CH_TM_FOLDERS_ONLY = 0x04000000, ///< chooser will show in fold
    CH_TM_FULL_TREE = 0x08000000,    ///< chooser will show in no-t
    CH_TM_SHIFT = 26,
    CH_TM_MASK = (0x3 << CH_TM_SHIFT),
    CH_HAS_DIFF = 0x10000000,
    CH_NO_SORT = 0x20000000,
    CH_NO_FILTER = 0x40000000,
    CH_NON_PERSISTED_TREE = 0x80000000,
};

enum CH2
{
    CH2_LAZY_LOADED = 0x0001,
    CH2_HAS_INODE2INDEX = 0x0002,
};

enum CHCOL
{
    CHCOL_PLAIN = 0x00000000,
    CHCOL_PATH = 0x00010000,
    CHCOL_HEX = 0x00020000,
    CHCOL_DEC = 0x00030000,
    CHCOL_EA = 0x00040000,
    CHCOL_FNAME = 0x00050000,
    CHCOL_FORMAT = 0x00070000,
    CHCOL_DEFHIDDEN = 0x00100000,
    CHCOL_DRAGHINT = 0x00200000,
    CHCOL_INODENAME = 0x00400000
};

enum CHITEM
{
    CHITEM_BOLD = 0x0001,
    CHITEM_ITALIC = 0x0002,
    CHITEM_UNDER = 0x0004,
    CHITEM_STRIKE = 0x0008,
    CHITEM_GRAY = 0x0010,
};

enum GCRF
{
    GCRF_HIGH_BIT = (0x8000000000000000ULL),
    GCRF_HEADER = (GCRF_HIGH_BIT | 0),
    GCRF_SELECTION = (GCRF_HIGH_BIT | 1),
    GCRF_CURRENT = (GCRF_HIGH_BIT | 2),
    GCRF_ALL = (GCRF_HIGH_BIT | 3),
};

enum chooser_index
{
    NO_SELECTION = -1,
    EMPTY_CHOOSER = -2,
    ALREADY_EXISTS = -3,
    NO_ATTR = -4,
};

enum TXTF
{
    TXTF_AUTOINDENT = 0x0001,
    TXTF_ACCEPTTABS = 0x0002,
    TXTF_READONLY = 0x0004,
    TXTF_SELECTED = 0x0008,
    TXTF_MODIFIED = 0x0010,
    TXTF_FIXEDFONT = 0x0020,
    TXTF_LINENUMBERS = 0x0040,
};

enum view_event_state_e
{
    VES_SHIFT = (1 << 0),
    VES_ALT = (1 << 1),
    VES_CTRL = (1 << 2),
    VES_MOUSE_LEFT = (1 << 3),
    VES_MOUSE_RIGHT = (1 << 4),
    VES_MOUSE_MIDDLE = (1 << 5),
    VES_META = (1 << 7),
};

enum LCMD
{
    LCMD_SYNC = (1 << 0),
};

enum CLIF
{
    CLIF_QT_AWARE = 1,
};

enum MMF
{
    MFF_FAST = 0x0000,
    MFF_READ = 0x0001,
    MFF_WRITE = 0x0002,
    MFF_NOWAIT = 0x0004,
    MFF_MAGIC = 0x12345678,
};

enum UIJMP
{
    UIJMP_ACTIVATE = 0x0001,
    UIJMP_DONTPUSH = 0x0002,
    UIJMP_VIEWMASK = 0x000C,
    UIJMP_ANYVIEW = 0x0000,
    UIJMP_IDAVIEW = 0x0004,
    UIJMP_IDAVIEW_NEW = 0x0008,
};

enum ACF
{
    ACF_HAS_SELECTION = (1 << 0),
    ACF_XTRN_EA = (1 << 1),
    ACF_HAS_FIELD_DIRTREE_SELECTION = (1 << 2),
    ACF_HAS_SOURCE = (1 << 3),
    ACF_HAS_TYPE_REF = (1 << 4),
};

enum AHF
{
    AHF_VERSION = 1,
    AHF_VERSION_MASK = 0xFF,
};

enum ADF
{
    ADF_OWN_HANDLER = 0x01,
    ADF_NO_UNDO = 0x02,
    ADF_OT_MASK = 0x0C,
    ADF_OT_PLUGIN = 0x00,
    ADF_OT_PLUGMOD = 0x04,
    ADF_OT_PROCMOD = 0x08,
    ADF_GLOBAL = 0x10,
    ADF_NO_HIGHLIGHT = 0x20,
    ADF_CHECKABLE = 0x40,
    ADF_CHECKED = 0x80,
};

enum ASKBTN
{
    ASKBTN_YES = 1,
    ASKBTN_NO = 0,
    ASKBTN_CANCEL = -1,
    ASKBTN_BTN1 = 1,
    ASKBTN_BTN2 = 0,
    ASKBTN_BTN3 = -1,
};

enum HIST
{
    HIST_SEG = 1,
    HIST_CMT = 2,
    HIST_SRCH = 3,
    HIST_IDENT = 4,
    HIST_FILE = 5,
    HIST_TYPE = 6,
    HIST_CMD = 7,
    HIST_DIR = 8,
    HIST_IDENT2 = 9,
};

enum CLNL
{
    CLNL_RTRIM = (1 << 0),   ///< Remove tr
    CLNL_LTRIM = (1 << 1),   ///< Remove le
    CLNL_FINDCMT = (1 << 2), ///< Search fo
    CLNL_TRIM = (CLNL_RTRIM | CLNL_LTRIM),
};

enum S2EAOPT
{
    S2EAOPT_NOCALC = 0x00000001,
};

enum IK
{
    IK_CANCEL = 0x03,
    IK_BACK = 0x08,
    IK_TAB = 0x09,
    IK_CLEAR = 0x0C,
    IK_RETURN = 0x0D,
    IK_SHIFT = 0x10,
    IK_CONTROL = 0x11,
    IK_MENU = 0x12,
    IK_PAUSE = 0x13,
    IK_CAPITAL = 0x14,
    IK_KANA = 0x15,
    IK_ESCAPE = 0x1B,
    IK_MODECHANGE = 0x1F,
    IK_SPACE = 0x20,
    IK_PRIOR = 0x21,
    IK_NEXT = 0x22,
    IK_END = 0x23,
    IK_HOME = 0x24,
    IK_LEFT = 0x25,
    IK_UP = 0x26,
    IK_RIGHT = 0x27,
    IK_DOWN = 0x28,
    IK_SELECT = 0x29,
    IK_PRINT = 0x2A,
    IK_EXECUTE = 0x2B,
    IK_SNAPSHOT = 0x2C,
    IK_INSERT = 0x2D,
    IK_DELETE = 0x2E,
    IK_HELP = 0x2F,
    IK_LWIN = 0x5B,
    IK_RWIN = 0x5C,
    IK_APPS = 0x5D,
    IK_SLEEP = 0x5F,
    IK_NUMPAD0 = 0x60,
    IK_NUMPAD1 = 0x61,
    IK_NUMPAD2 = 0x62,
    IK_NUMPAD3 = 0x63,
    IK_NUMPAD4 = 0x64,
    IK_NUMPAD5 = 0x65,
    IK_NUMPAD6 = 0x66,
    IK_NUMPAD7 = 0x67,
    IK_NUMPAD8 = 0x68,
    IK_NUMPAD9 = 0x69,
    IK_MULTIPLY = 0x6A,
    IK_ADD = 0x6B,
    IK_SEPARATOR = 0x6C,
    IK_SUBTRACT = 0x6D,
    IK_DECIMAL = 0x6E,
    IK_DIVIDE = 0x6F,
    IK_F1 = 0x70,
    IK_F2 = 0x71,
    IK_F3 = 0x72,
    IK_F4 = 0x73,
    IK_F5 = 0x74,
    IK_F6 = 0x75,
    IK_F7 = 0x76,
    IK_F8 = 0x77,
    IK_F9 = 0x78,
    IK_F10 = 0x79,
    IK_F11 = 0x7A,
    IK_F12 = 0x7B,
    IK_F13 = 0x7C,
    IK_F14 = 0x7D,
    IK_F15 = 0x7E,
    IK_F16 = 0x7F,
    IK_F17 = 0x80,
    IK_F18 = 0x81,
    IK_F19 = 0x82,
    IK_F20 = 0x83,
    IK_F21 = 0x84,
    IK_F22 = 0x85,
    IK_F23 = 0x86,
    IK_F24 = 0x87,
    IK_NUMLOCK = 0x90,
    IK_SCROLL = 0x91,
    IK_OEM_FJ_MASSHOU = 0x93,
    IK_OEM_FJ_TOUROKU = 0x94,
    IK_LSHIFT = 0xA0,
    IK_RSHIFT = 0xA1,
    IK_LCONTROL = 0xA2,
    IK_RCONTROL = 0xA3,
    IK_LMENU = 0xA4,
    IK_RMENU = 0xA5,
    IK_BROWSER_BACK = 0xA6,
    IK_BROWSER_FORWARD = 0xA7,
    IK_BROWSER_REFRESH = 0xA8,
    IK_BROWSER_STOP = 0xA9,
    IK_BROWSER_SEARCH = 0xAA,
    IK_BROWSER_FAVORITES = 0xAB,
    IK_BROWSER_HOME = 0xAC,
    IK_VOLUME_MUTE = 0xAD,
    IK_VOLUME_DOWN = 0xAE,
    IK_VOLUME_UP = 0xAF,
    IK_MEDIA_NEXT_TRACK = 0xB0,
    IK_MEDIA_PREV_TRACK = 0xB1,
    IK_MEDIA_STOP = 0xB2,
    IK_MEDIA_PLAY_PAUSE = 0xB3,
    IK_LAUNCH_MAIL = 0xB4,
    IK_LAUNCH_MEDIA_SELECT = 0xB5,
    IK_LAUNCH_APP1 = 0xB6,
    IK_LAUNCH_APP2 = 0xB7,
    IK_OEM_1 = 0xBA,
    IK_OEM_PLUS = 0xBB,
    IK_OEM_COMMA = 0xBC,
    IK_OEM_MINUS = 0xBD,
    IK_OEM_PERIOD = 0xBE,
    IK_OEM_2 = 0xBF,
    IK_OEM_3 = 0xC0,
    IK_OEM_4 = 0xDB,
    IK_OEM_5 = 0xDC,
    IK_OEM_6 = 0xDD,
    IK_OEM_7 = 0xDE,
    IK_OEM_102 = 0xE2,
    IK_PLAY = 0xFA,
    IK_ZOOM = 0xFB,
    IK_OEM_CLEAR = 0xFE,
};

// lex.hpp

enum lxtype_e
{
    lx_end = 1,
    lx_ident = 2,
    lx_number = 3,
    lx_string = 4,
    lx_char = 5,
    lx_typename = 6,
    lx_float = 7,
    lx_int64 = 8,
    lx_key = 128,
};

enum LXOPT
{
    LXOPT_PARSE_FLOATS = 0x0001,
    LXOPT_REQ_SEPARATOR = 0x0002,
    LXOPT_NOCASE_FILES = 0x0004,
    LXOPT_C99_CONSTANTS = 0x0008,
};

// lines.hpp

enum color_esc
{
    COLOR_ON = '\1',
    COLOR_OFF = '\2',
    COLOR_ESC = '\3',
    COLOR_INV = '\4',
    SCOLOR_ON = '\1\0',
    SCOLOR_OFF = '\2\0',
    SCOLOR_ESC = '\3\0',
    SCOLOR_INV = '\4\0',
};

enum color_e : unsigned char
{
    COLOR_DEFAULT = 0x01,
    COLOR_REGCMT = 0x02,
    COLOR_RPTCMT = 0x03,
    COLOR_AUTOCMT = 0x04,
    COLOR_INSN = 0x05,
    COLOR_DATNAME = 0x06,
    COLOR_DNAME = 0x07,
    COLOR_DEMNAME = 0x08,
    COLOR_SYMBOL = 0x09,
    COLOR_CHAR = 0x0A,
    COLOR_STRING = 0x0B,
    COLOR_NUMBER = 0x0C,
    COLOR_VOIDOP = 0x0D,
    COLOR_CREF = 0x0E,
    COLOR_DREF = 0x0F,
    COLOR_CREFTAIL = 0x10,
    COLOR_DREFTAIL = 0x11,
    COLOR_ERROR = 0x12,
    COLOR_PREFIX = 0x13,
    COLOR_BINPREF = 0x14,
    COLOR_EXTRA = 0x15,
    COLOR_ALTOP = 0x16,
    COLOR_HIDNAME = 0x17,
    COLOR_LIBNAME = 0x18,
    COLOR_LOCNAME = 0x19,
    COLOR_CODNAME = 0x1A,
    COLOR_ASMDIR = 0x1B,
    COLOR_MACRO = 0x1C,
    COLOR_DSTR = 0x1D,
    COLOR_DCHAR = 0x1E,
    COLOR_DNUM = 0x1F,
    COLOR_KEYWORD = 0x20,
    COLOR_REG = 0x21,
    COLOR_IMPNAME = 0x22,
    COLOR_SEGNAME = 0x23,
    COLOR_UNKNAME = 0x24,
    COLOR_CNAME = 0x25,
    COLOR_UNAME = 0x26,
    COLOR_COLLAPSED = 0x27,
    COLOR_FG_MAX = 0x28,
    COLOR_ADDR = COLOR_FG_MAX,
    COLOR_OPND1 = COLOR_ADDR + 1,
    COLOR_OPND2 = COLOR_ADDR + 2,
    COLOR_OPND3 = COLOR_ADDR + 3,
    COLOR_OPND4 = COLOR_ADDR + 4,
    COLOR_OPND5 = COLOR_ADDR + 5,
    COLOR_OPND6 = COLOR_ADDR + 6,
    COLOR_OPND7 = COLOR_ADDR + 7,
    COLOR_OPND8 = COLOR_ADDR + 8,
    COLOR_RESERVED1 = COLOR_ADDR + 11,
    COLOR_LUMINA = COLOR_ADDR + 12,
};

enum SCOLOR : unsigned short
{
    SCOLOR_DEFAULT = '\x01\0',
    SCOLOR_REGCMT = '\x02\0',
    SCOLOR_RPTCMT = '\x03\0',
    SCOLOR_AUTOCMT = '\x04\0',
    SCOLOR_INSN = '\x05\0',
    SCOLOR_DATNAME = '\x06\0',
    SCOLOR_DNAME = '\x07\0',
    SCOLOR_DEMNAME = '\x08\0',
    SCOLOR_SYMBOL = '\x09\0',
    SCOLOR_CHAR = '\x0A\0',
    SCOLOR_STRING = '\x0B\0',
    SCOLOR_NUMBER = '\x0C\0',
    SCOLOR_VOIDOP = '\x0D\0',
    SCOLOR_CREF = '\x0E\0',
    SCOLOR_DREF = '\x0F\0',
    SCOLOR_CREFTAIL = '\x10\0',
    SCOLOR_DREFTAIL = '\x11\0',
    SCOLOR_ERROR = '\x12\0',
    SCOLOR_PREFIX = '\x13\0',
    SCOLOR_BINPREF = '\x14\0',
    SCOLOR_EXTRA = '\x15\0',
    SCOLOR_ALTOP = '\x16\0',
    SCOLOR_HIDNAME = '\x17\0',
    SCOLOR_LIBNAME = '\x18\0',
    SCOLOR_LOCNAME = '\x19\0',
    SCOLOR_CODNAME = '\x1A\0',
    SCOLOR_ASMDIR = '\x1B\0',
    SCOLOR_MACRO = '\x1C\0',
    SCOLOR_DSTR = '\x1D\0',
    SCOLOR_DCHAR = '\x1E\0',
    SCOLOR_DNUM = '\x1F\0',
    SCOLOR_KEYWORD = '\x20\0',
    SCOLOR_REG = '\x21\0',
    SCOLOR_IMPNAME = '\x22\0',
    SCOLOR_SEGNAME = '\x23\0',
    SCOLOR_UNKNAME = '\x24\0',
    SCOLOR_CNAME = '\x25\0',
    SCOLOR_UNAME = '\x26\0',
    SCOLOR_COLLAPSED = '\x27\0',
    SCOLOR_ADDR = '\x28\0',
};

enum COLOR_ADDR_SIZE
{
    COLOR_ADDR_SIZE_32 = 8,
    COLOR_ADDR_SIZE_64 = 16,
};

// Line prefix colors
enum COLOR_PFX
{
    COLOR_DEFAULT_ = 0x01,
    COLOR_SELECTED = 0x02,
    COLOR_LIBFUNC = 0x03,
    COLOR_REGFUNC = 0x04,
    COLOR_CODE = 0x05,
    COLOR_DATA = 0x06,
    COLOR_UNKNOWN = 0x07,
    COLOR_EXTERN = 0x08,
    COLOR_CURITEM = 0x09,
    COLOR_CURLINE = 0x0A,
    COLOR_HIDLINE = 0x0B,
    COLOR_LUMFUNC = 0x0C,
    COLOR_BG_MAX = 0x0D,
};

enum noname_lines_hpp
{
    PALETTE_SIZE = COLOR_FG_MAX + COLOR_BG_MAX,
};

enum GDISMF
{
    GDISMF_AS_STACK = (1 << 0),
    GDISMF_ADDR_TAG = (1 << 1),
};

enum GENDSM
{
    GENDSM_FORCE_CODE = (1 << 0),
    GENDSM_MULTI_LINE = (1 << 1),
    GENDSM_REMOVE_TAGS = (1 << 2),
};

enum E_PREV_NEXT
{
    E_PREV = 1000,
    E_NEXT = 2000,
};

// loader.hpp

enum LDRF
{
    LDRF_RELOAD = 0x0001,
    LDRF_REQ_PROC = 0x0002,
};

enum ACCEPT
{
    ACCEPT_ARCHIVE = 0x2000,
    ACCEPT_CONTINUE = 0x4000,
    ACCEPT_FIRST = 0x8000,
};

enum NEF
{
    NEF_SEGS = 0x0001,
    NEF_RSCS = 0x0002,
    NEF_NAME = 0x0004,
    NEF_MAN = 0x0008,
    NEF_FILL = 0x0010,
    NEF_IMPS = 0x0020,
    NEF_FIRST = 0x0080,
    NEF_CODE = 0x0100,
    NEF_RELOAD = 0x0200,
    NEF_FLAT = 0x0400,
    NEF_MINI = 0x0800,
    NEF_LOPT = 0x1000,
    NEF_LALL = 0x2000
};

enum LIF
{
    LIF_ARCHLDR = 0x0001,
};

enum GENFLG
{
    GENFLG_MAPSEG = 0x0001,
    GENFLG_MAPNAME = 0x0002,
    GENFLG_MAPDMNG = 0x0004,
    GENFLG_MAPLOC = 0x0008,
    GENFLG_IDCTYPE = 0x0008,
    GENFLG_ASMTYPE = 0x0010,
    GENFLG_GENHTML = 0x0020,
    GENFLG_ASMINC = 0x0040
};

enum FILEREG
{
    FILEREG_PATCHABLE = 1,
    FILEREG_NOTPATCHABLE = 0,
};

enum PLUGIN_FLAGS
{
    PLUGIN_MOD = 0x0001,
    PLUGIN_DRAW = 0x0002,
    PLUGIN_SEG = 0x0004,
    PLUGIN_UNL = 0x0008,
    PLUGIN_HIDE = 0x0010,
    PLUGIN_DBG = 0x0020,
    PLUGIN_PROC = 0x0040,
    PLUGIN_FIX = 0x0080,
    PLUGIN_MULTI = 0x0100,
    PLUGIN_SCRIPTED = 0x8000,
};

enum PLUGIN_RETURN_CODES
{
    PLUGIN_SKIP = 0,
    PLUGIN_OK = 1,
    PLUGIN_KEEP = 2,
};

enum noname_loader_hpp
{
    LNE_MAXSEG = 10,
    DLLDATASTART = 0xA0,
    LDRDATASTART = DLLDATASTART + 4096,
    MAX_DATABASE_DESCRIPTION = 128,
};

enum load_core_module_RE
{
    RE_NOFILE = 1, /* No such file */
    RE_NOTIDP = 2, /* Not IDP file */
    RE_NOPAGE = 3, /* Can't load: bad segments */
    RE_NOLINK = 4, /* No linkage info */
    RE_BADRTP = 5, /* Bad relocation type */
    RE_BADORD = 6, /* Bad imported ordinal */
    RE_BADATP = 7, /* Bad relocation atype */
    RE_BADMAP = 8, /* DLLDATA offset is invalid */
};

enum SSF
{
    SSF_AUTOMATIC = 0x0001,
};

enum SSFU
{
    SSUF_DESC = 0x00000001,
    SSUF_PATH = 0x00000002,
    SSUF_FLAGS = 0x00000004,
};

enum DBFL
{
    DBFL_KILL = 0x01,
    DBFL_COMP = 0x02,
    DBFL_BAK = 0x04,
    DBFL_TEMP = 0x08,
};

// merge.hpp

enum MH_FLAGS
{
    MH_LISTEN = 0x00000001,
    MH_TERSE = 0x00000002,
    MH_UI_NODETAILS = 0x00000100,
    MH_UI_COMPLEX = 0x00000200,
    MH_UI_DP_NOLINEDIFF = 0x00000400,
    MH_UI_DP_SHORTNAME = 0x00000800,
    MH_UI_INDENT = 0x00001000,
    MH_UI_SPLITNAME = 0x00800000,
    MH_UI_CHAR_MASK = 0x007F0000,

#define MH_UI_DEF_CHAR(v)   ((((v) & 0x7F) << 16) | MH_UI_SPLITNAME)

#ifndef SWIG
    MH_UI_COMMANAME = MH_UI_DEF_CHAR(','),
    MH_UI_COLONNAME = MH_UI_DEF_CHAR(':'),
#else
    MH_UI_COMMANAME = 0x00AC0000,
    MH_UI_COLONNAME = 0x00BA0000,
#endif

    MH_DUMMY = 0x80000000,
};

// moves.hpp

enum LSEF
{
    LSEF_PLACE = (1 << 0),
    LSEF_RINFO = (1 << 1),
    LSEF_PTYPE = (1 << 2),
    LSEF_ALL = (LSEF_PLACE | LSEF_RINFO | LSEF_PTYPE),
};

enum UNHID
{
    UNHID_SEGM = 0x0001,
    UNHID_FUNC = 0x0002,
    UNHID_RANGE = 0x0004,
};

enum noname_moves_hpp
{
    DEFAULT_CURSOR_Y = 0xFFFF,
    DEFAULT_LNNUM = -1,
    MAX_MARK_SLOT = 1024,
};

enum BOOKMARKS
{
    BOOKMARKS_CHOOSE_INDEX = -1,
    BOOKMARKS_BAD_INDEX = -1,
    BOOKMARKS_PROMPT_WITH_HINT_PREFIX = '\x01',
};

// nalt.hpp

enum NALT
{
    NALT_ENUM = -2,
    NALT_WIDE = -1,
    NALT_SWITCH = 1,
    NALT_OBASE1 = 2,
    NALT_STRUCT = 3,
    NALT_SEENF = 4,
    NALT_OOBASE0 = 5,
    NALT_OOBASE1 = 6,
    NALT_XREFPOS = 7,
    NALT_AFLAGS = 8,
    NALT_LINNUM = 9,
    NALT_ABSBASE = 10,
    NALT_ENUM0 = 11,
    NALT_ENUM1 = 12,
    NALT_STROFF0 = 13,
    NALT_STROFF1 = 14,
    NALT_PURGE = 15,
    NALT_STRTYPE = 16,
    NALT_ALIGN = 17,
    NALT_HIGH0 = 18,
    NALT_HIGH1 = 19,
    NALT_COLOR = 20,
};

enum NSUP
{
    NSUP_CMT = 0,
    NSUP_REPCMT = 1,
    NSUP_FOP1 = 2,
    NSUP_FOP2 = 3,
    NSUP_JINFO = 4,
    NSUP_ARRAY = 5,
    NSUP_OMFGRP = 6,
    NSUP_FOP3 = 7,
    NSUP_SWITCH = 8,
    NSUP_REF0 = 9,
    NSUP_REF1 = 10,
    NSUP_REF2 = 11,
    NSUP_OREF0 = 12,
    NSUP_OREF1 = 13,
    NSUP_OREF2 = 14,
    NSUP_STROFF0 = 15,
    NSUP_STROFF1 = 16,
    NSUP_SEGTRANS = 17,
    NSUP_FOP4 = 18,
    NSUP_FOP5 = 19,
    NSUP_FOP6 = 20,
    NSUP_REF3 = 21,
    NSUP_REF4 = 22,
    NSUP_REF5 = 23,
    NSUP_OREF3 = 24,
    NSUP_OREF4 = 25,
    NSUP_OREF5 = 26,
    NSUP_XREFPOS = 27,
    NSUP_CUSTDT = 28,
    NSUP_GROUPS = 29,
    NSUP_ARGEAS = 30,
    NSUP_FOP7 = 31,
    NSUP_FOP8 = 32,
    NSUP_REF6 = 33,
    NSUP_REF7 = 34,
    NSUP_OREF6 = 35,
    NSUP_OREF7 = 36,
    NSUP_EX_FLAGS = 37,
    NSUP_POINTS = 0x1000,
    NSUP_MANUAL = 0x2000,
    NSUP_TYPEINFO = 0x3000,
    NSUP_REGVAR = 0x4000,
    NSUP_LLABEL = 0x5000,
    NSUP_REGARG = 0x6000,
    NSUP_FTAILS = 0x7000,
    NSUP_GROUP = 0x8000,
    NSUP_OPTYPES = 0x9000,
    NSUP_ORIGFMD = 0x109000,
    NSUP_FRAME = 0x10A000,
};

enum NALT_X
{
    NALT_CREF_TO = 'X',
    NALT_CREF_FROM = 'x',
    NALT_DREF_TO = 'D',
    NALT_DREF_FROM = 'd',
};

enum N_TAG
{
    NSUP_GR_INFO = 'g',
    NALT_GR_LAYX = 'p',
    NSUP_GR_LAYT = 'l',
};

enum noname_nalt_hpp
{
    PATCH_TAG = 'P',
    IDB_DESKTOPS_TAG = 'S',
    IDB_DESKTOPS_TIMESTAMP = -1,
};

enum AFL
{
    AFL_LINNUM = 0x00000001L,
    AFL_USERSP = 0x00000002L,
    AFL_PUBNAM = 0x00000004L,
    AFL_WEAKNAM = 0x00000008L,
    AFL_HIDDEN = 0x00000010L,
    AFL_MANUAL = 0x00000020L,
    AFL_NOBRD = 0x00000040L,
    AFL_ZSTROFF = 0x00000080L,
    AFL_BNOT0 = 0x00000100L,
    AFL_BNOT1 = 0x00000200L,
    AFL_LIB = 0x00000400L,
    AFL_TI = 0x00000800L,
    AFL_TI0 = 0x00001000L,
    AFL_TI1 = 0x00002000L,
    AFL_LNAME = 0x00004000L,
    AFL_TILCMT = 0x00008000L,
    AFL_LZERO0 = 0x00010000L,
    AFL_LZERO1 = 0x00020000L,
    AFL_COLORED = 0x00040000L,
    AFL_TERSESTR = 0x00080000L,
    AFL_SIGN0 = 0x00100000L,
    AFL_SIGN1 = 0x00200000L,
    AFL_NORET = 0x00400000L,
    AFL_FIXEDSPD = 0x00800000L,
    AFL_ALIGNFLOW = 0x01000000L,
    AFL_USERTI = 0x02000000L,
    AFL_RETFP = 0x04000000L,
    AFL_USEMODSP = 0x08000000L,
    AFL_NOTCODE = 0x10000000L,
    AFL_NOTPROC = 0x20000000L,
    AFL_TYPE_GUESSED = 0xC2000000L,
    AFL_IDA_GUESSED = 0x00000000L,
    AFL_HR_GUESSED_FUNC = 0x40000000L,
    AFL_HR_GUESSED_DATA = 0x80000000L,
    AFL_HR_DETERMINED = 0xC0000000L,
};

enum STRWIDTH
{
    STRWIDTH_1B = 0,
    STRWIDTH_2B = 1,
    STRWIDTH_4B = 2,
    STRWIDTH_MASK = 0x03,
};

enum STRLYT
{
    STRLYT_TERMCHR = 0,
    STRLYT_PASCAL1 = 1,
    STRLYT_PASCAL2 = 2,
    STRLYT_PASCAL4 = 3,
    STRLYT_MASK = 0xFC,
    STRLYT_SHIFT = 2,
};

enum STRTYPE
{
    STRTYPE_TERMCHR = (STRWIDTH_1B | STRLYT_TERMCHR << STRLYT_SHIFT),
    STRTYPE_C = STRTYPE_TERMCHR,
    STRTYPE_C_16 = (STRWIDTH_2B | STRLYT_TERMCHR << STRLYT_SHIFT),
    STRTYPE_C_32 = (STRWIDTH_4B | STRLYT_TERMCHR << STRLYT_SHIFT),
    STRTYPE_PASCAL = (STRWIDTH_1B | STRLYT_PASCAL1 << STRLYT_SHIFT),
    STRTYPE_PASCAL_16 = (STRWIDTH_2B | STRLYT_PASCAL1 << STRLYT_SHIFT),
    STRTYPE_PASCAL_32 = (STRWIDTH_4B | STRLYT_PASCAL1 << STRLYT_SHIFT),
    STRTYPE_LEN2 = (STRWIDTH_1B | STRLYT_PASCAL2 << STRLYT_SHIFT),
    STRTYPE_LEN2_16 = (STRWIDTH_2B | STRLYT_PASCAL2 << STRLYT_SHIFT),
    STRTYPE_LEN2_32 = (STRWIDTH_4B | STRLYT_PASCAL2 << STRLYT_SHIFT),
    STRTYPE_LEN4 = (STRWIDTH_1B | STRLYT_PASCAL4 << STRLYT_SHIFT),
    STRTYPE_LEN4_16 = (STRWIDTH_2B | STRLYT_PASCAL4 << STRLYT_SHIFT),
    STRTYPE_LEN4_32 = (STRWIDTH_4B | STRLYT_PASCAL4 << STRLYT_SHIFT),
};

enum array_parameters_flags
{
    AP_ALLOWDUPS = 0x00000001L,
    AP_SIGNED = 0x00000002L,
    AP_INDEX = 0x00000004L,
    AP_ARRAY = 0x00000008L,
    AP_IDXBASEMASK = 0x000000F0L,
    AP_IDXDEC = 0x00000000L,
    AP_IDXHEX = 0x00000010L,
    AP_IDXOCT = 0x00000020L,
    AP_IDXBIN = 0x00000030L,
};

enum switch_info_flags
{
    SWI_SPARSE = 0x00000001,
    SWI_V32 = 0x00000002,
    SWI_J32 = 0x00000004,
    SWI_VSPLIT = 0x00000008,
    SWI_USER = 0x00000010,
    SWI_DEF_IN_TBL = 0x00000020,
    SWI_JMP_INV = 0x00000040,
    SWI_SHIFT_MASK = 0x00000180,
    SWI_ELBASE = 0x00000200,
    SWI_JSIZE = 0x00000400,
    SWI_VSIZE = 0x00000800,
    SWI_SEPARATE = 0x00001000,
    SWI_SIGNED = 0x00002000,
    SWI_CUSTOM = 0x00004000,
    SWI_EXTENDED = 0x00008000,
    SWI_INDIRECT = 0x00010000,
    SWI_SUBTRACT = 0x00020000,
    SWI_HXNOLOWCASE = 0x00040000,
    SWI_STDTBL = 0x00080000,
    SWI_DEFRET = 0x00100000,
    SWI_SELFREL = 0x00200000,
    SWI_JMPINSN = 0x00400000,
    SWI_VERSION = 0x00800000,
};

enum reftype_e
{
    V695_REF_OFF8 = 0,
    REF_OFF16 = 1,
    REF_OFF32 = 2,
    REF_LOW8 = 3,
    REF_LOW16 = 4,
    REF_HIGH8 = 5,
    REF_HIGH16 = 6,
    V695_REF_VHIGH = 7,
    V695_REF_VLOW = 8,
    REF_OFF64 = 9,
    REF_OFF8 = 10,
    REF_LAST = REF_OFF8,
};

enum refinfo_e
{
    REFINFO_TYPE = 0x000F,
    REFINFO_RVAOFF = 0x0010,
    REFINFO_PASTEND = 0x0020,
    REFINFO_CUSTOM = 0x0040,
    REFINFO_NOBASE = 0x0080,
    REFINFO_SUBTRACT = 0x0100,
    REFINFO_SIGNEDOP = 0x0200,
    REFINFO_NO_ZEROS = 0x0400,
    REFINFO_NO_ONES = 0x0800,
    REFINFO_SELFREF = 0x1000,
};

enum RHF
{
    RHF_TGTOPT = 0x0001,
};

enum POF
{
    POF_VALID_TI = 0x1,
    POF_VALID_AFLAGS = 0x2,
    POF_IS_F64 = 0x4,
};

enum RIDX
{
    RIDX_FILE_FORMAT_NAME = 1,
    RIDX_SELECTORS = 2,
    RIDX_GROUPS = 64,
    RIDX_H_PATH = 65,
    RIDX_C_MACROS = 66,
    RIDX_SMALL_IDC_OLD = 67,
    RIDX_NOTEPAD = 68,
    RIDX_INCLUDE = 1100,
    RIDX_SMALL_IDC = 1200,
    RIDX_DUALOP_GRAPH = 1300,
    RIDX_DUALOP_TEXT = 1301,
    RIDX_MD5 = 1302,
    RIDX_IDA_VERSION = 1303,
    RIDX_STR_ENCODINGS = 1305,
    RIDX_SRCDBG_PATHS = 1306,
    RIDX_DBG_BINPATHS = 1328,
    RIDX_SHA256 = 1349,
    RIDX_ABINAME = 1350,
    RIDX_ARCHIVE_PATH = 1351,
    RIDX_PROBLEMS = 1352,
    RIDX_SRCDBG_UNDESIRED = 1353,
    RIDX_ALT_VERSION = -1,
    RIDX_ALT_CTIME = -2,
    RIDX_ALT_ELAPSED = -3,
    RIDX_ALT_NOPENS = -4,
    RIDX_ALT_CRC32 = -5,
    RIDX_ALT_IMAGEBASE = -6,
    RIDX_ALT_IDSNODE = -7,
    RIDX_ALT_FSIZE = -8,
    RIDX_ALT_OUTFILEENC = -9,
};

enum BPU
{
    BPU_1B = 1,
    BPU_2B = 2,
    BPU_4B = 4,
};

// name.hpp

enum noname_name_hpp
{
    MAXNAMELEN = 512,
    CN_KEEP_TRAILING__DIGITS = 0x01,
};

enum SN
{
    SN_CHECK = 0x00,
    SN_NOCHECK = 0x01,
    SN_PUBLIC = 0x02,
    SN_NON_PUBLIC = 0x04,
    SN_WEAK = 0x08,
    SN_NON_WEAK = 0x10,
    SN_AUTO = 0x20,
    SN_NON_AUTO = 0x40,
    SN_NOLIST = 0x80,
    SN_NOWARN = 0x100,
    SN_LOCAL = 0x200,
    SN_IDBENC = 0x400,
    SN_FORCE = 0x800,
    SN_NODUMMY = 0x1000,
    SN_DELTAIL = 0x2000,
};

enum NT
{
    NT_NONE = 0,
    NT_BYTE = 1,
    NT_LOCAL = 2,
    NT_STKVAR = 3,
    NT_ENUM = 4,
    NT_ABS = 5,
    NT_SEG = 6,
    NT_STROFF = 7,
    NT_BMASK = 8,
    NT_REGVAR = 9,
};

enum GN
{
    GN_VISIBLE = 0x0001,
    GN_COLORED = 0x0002,
    GN_DEMANGLED = 0x0004,
    GN_STRICT = 0x0008,
    GN_SHORT = 0x0010,
    GN_LONG = 0x0020,
    GN_LOCAL = 0x0040,
    GN_ISRET = 0x0080,
    GN_NOT_ISRET = 0x0100,
    GN_NOT_DUMMY = 0x0200,
};

enum GETN
{
    GETN_APPZERO = 0x0001,
    GETN_NOFIXUP = 0x0002,
    GETN_NODUMMY = 0x0004,
};

enum GNCN
{
    GNCN_NOSEG = 0x0001,
    GNCN_NOCOLOR = 0x0002,
    GNCN_NOLABEL = 0x0004,
    GNCN_NOFUNC = 0x0008,
    GNCN_SEG_FUNC = 0x0010,
    GNCN_SEGNUM = 0x0020,
    GNCN_REQFUNC = 0x0040,
    GNCN_REQNAME = 0x0080,
    GNCN_NODBGNM = 0x0100,
    GNCN_PREFDBG = 0x0200,
};

enum ignore_name_def_e
{
    ignore_none = 0,
    ignore_regvar = 1,
    ignore_llabel = 2,
    ignore_stkvar = 3,
    ignore_glabel = 4,
};

// netnode.hpp

enum noname_netnode_hpp
{
    MAXNAMESIZE = 512,
    MAX_NODENAME_SIZE = 32 * 1024,
    MAXSPECSIZE = 1024,
    BADNODE = -1,
};

enum nn_res
{
    atag = 'A',
    stag = 'S',
    htag = 'H',
    vtag = 'V',
    ntag = 'N',
    ltag = 'L',
};

enum NETMAP
{
    NETMAP_IDX = 0x100,
    NETMAP_VAL = 0x200,
    NETMAP_STR = 0x400,
    NETMAP_X8 = 0x800,
    NETMAP_V8 = 0x1000,
    NETMAP_VAL_NDX = 0x2000,
};

// network.hpp
enum timeout_e
{
    TIMEOUT = (1000 / 25),
    TIMEOUT_INFINITY = -1,
    RECV_HELLO_TIMEOUT = 1000,
    RECV_TIMEOUT_PERIOD = 10000,
};

enum RPC_CODES
{
    RPC_OPEN = 3,
    RPC_EVENT = 4,
    RPC_EVOK = 5,
    RPC_CANCELLED = 6,
    RPC_INIT = 10,
    RPC_TERM = 11,
    RPC_GET_PROCESSES = 12,
    RPC_START_PROCESS = 13,
    RPC_EXIT_PROCESS = 14,
    RPC_ATTACH_PROCESS = 15,
    RPC_DETACH_PROCESS = 16,
    RPC_GET_DEBUG_EVENT = 17,
    RPC_PREPARE_TO_PAUSE_PROCESS = 18,
    RPC_STOPPED_AT_DEBUG_EVENT = 19,
    RPC_CONTINUE_AFTER_EVENT = 20,
    RPC_TH_SUSPEND = 21,
    RPC_TH_CONTINUE = 22,
    RPC_SET_RESUME_MODE = 23,
    RPC_GET_MEMORY_INFO = 24,
    RPC_READ_MEMORY = 25,
    RPC_WRITE_MEMORY = 26,
    RPC_UPDATE_BPTS = 27,
    RPC_UPDATE_LOWCNDS = 28,
    RPC_EVAL_LOWCND = 29,
    RPC_ISOK_BPT = 30,
    RPC_READ_REGS = 31,
    RPC_WRITE_REG = 32,
    RPC_GET_SREG_BASE = 33,
    RPC_SET_EXCEPTION_INFO = 34,

    RPC_OPEN_FILE = 35,
    RPC_CLOSE_FILE = 36,
    RPC_READ_FILE = 37,
    RPC_WRITE_FILE = 38,
    RPC_IOCTL = 39,
    RPC_UPDATE_CALL_STACK = 40,
    RPC_APPCALL = 41,
    RPC_CLEANUP_APPCALL = 42,
    RPC_REXEC = 43,
    RPC_GET_SCATTERED_IMAGE = 44,
    RPC_GET_IMAGE_UUID = 45,
    RPC_GET_SEGM_START = 46,
    RPC_BIN_SEARCH = 47,

    RPC_SET_DEBUG_NAMES = 50,
    RPC_SYNC_STUB = 51,
    RPC_ERROR = 52,
    RPC_MSG = 53,
    RPC_WARNING = 54,
    RPC_HANDLE_DEBUG_EVENT = 55,
    RPC_REPORT_IDC_ERROR = 56,
    RPC_IMPORT_DLL = 57,
};

enum BCF
{
    BCF_INCLUDE_USER = 1,
    BCF_INCLUDE_PASS = 2,
};

enum TIMESTAMP
{
    TIMESTAMP_UTC = 0x01,
    TIMESTAMP_ISO8601 = 0x02,
    TIMESTAMP_WITH_MS = 0x04,
    TIMESTAMP_BUFSZ = 25,
};

enum login_credentials_state
{
    LCS_NO_TLS = 0x1,
    LCS_SEEN_PROXY_OPTION = 0x2,
    LCS_RESERVED_BITS = 8,
};

enum vault_credentials_state
{
    VCS_SEEN_SITE_OPTION = (0x1 << LCS_RESERVED_BITS),
    VCS_UPDATE_REG_INFO = (0x2 << LCS_RESERVED_BITS),
    VCS_USE_PROXY = (0x4 << LCS_RESERVED_BITS),
};

enum PORTS
{
    DEFAULT_VAULT_PORT = 65433,
    DEFAULT_LUMINA_PORT = 443,
    PUBLIC_DEC_PORT = 443,
    PUBLIC_TLM_PORT = 443,
};

// pro.h

enum noname_pro_h
{
    IDBDEC_ESCAPE = 0x00000001,
    MAX_UTF8_SEQ_LEN = (6 + 1 + 1),
    BADCP = -1,
    CEF_RETERR = 0x1,
};

enum IRSERR
{
    IRSERR_TIMEOUT = 258L, // WAIT_TIMEOUT
    IRSERR_CANCELLED = -0xE5CA7E,
    IRSERR_SKIP_ITER = -0x5217,
};

enum error_codes
{
    eOk = 0,           ///< no error
    eOS = 1,           ///< os error, see errno
    eDiskFull = 2,     ///< disk full
    eReadError = 3,    ///< read error
    eFileTooLarge = 4, ///< file too large
};

enum packed_sizes
{
    ea_packed_size = 5,
    ea64_packed_size = 10,
    dq_packed_size = 10,
    dd_packed_size = 5,
    dw_packed_size = 3,
};

enum RELOBJ
{
    RELOBJ_MASK = 0xF,
    RELSIZE_1 = 0,
    RELSIZE_2 = 1,
    RELSIZE_4 = 2,
    RELSIZE_8 = 3,
    RELSIZE_CUST = 15,
    RELOBJ_CNT = 0x80,
};

enum IOREDIR
{
    IOREDIR_INPUT = 0x01,
    IOREDIR_OUTPUT = 0x02,
    IOREDIR_APPEND = 0x04,
    IOREDIR_QUOTED = 0x08,
};

enum launch_process_params_flags
{
    LP_NEW_CONSOLE = 0x0001,
    LP_TRACE = 0x0002,
    LP_PATH_WITH_ARGS = 0x0004,
    LP_USE_SHELL = 0x0008,
    LP_LAUNCH_32_BIT = 0x0010,
    LP_LAUNCH_64_BIT = 0x0020,
    LP_NO_ASLR = 0x0040,
    LP_DETACH_TTY = 0x0080,
    LP_HIDE_WINDOW = 0x0100,
    LP_SUSPENDED = 0x0200,
    LP_DETACHED = 0x0400,
    LP_REPLACE_ENV = 0x0800,
};

// problems.hpp

enum problist_id_e
{
    PR_NOBASE = 1,
    PR_NONAME = 2,
    PR_NOFOP = 3,
    PR_NOCMT = 4,
    PR_NOXREFS = 5,
    PR_JUMP = 6,
    PR_DISASM = 7,
    PR_HEAD = 8,
    PR_ILLADDR = 9,
    PR_MANYLINES = 10,
    PR_BADSTACK = 11,
    PR_ATTN = 12,
    PR_FINAL = 13,
    PR_ROLLED = 14,
    PR_COLLISION = 15,
    PR_DECIMP = 16,
    PR_END = 17,
};

// regex.h

enum REG
{
    REG_EXTENDED = 0,
    REG_TRACE = 0,
    REG_ICASE = 0x0001,
    REG_NEWLINE = 0x0002,
    REG_NOTBOL = 0x0004,
    REG_NOTEOL = 0x0008,
    REG_DOTALL = 0x0010,
    REG_NOSUB = 0x0020,
    REG_UTF = 0x0040,
    REG_STARTEND = 0x0080,
    REG_NOTEMPTY = 0x0100,
    REG_UNGREEDY = 0x0200,
    REG_UCP = 0x0400,
};

// regfinder.hpp

enum DEF_BIT : unsigned short
{
    DEF_BIT_SHORT_INSN = 0x0001,
    DEF_BIT_PC_BASED = 0x0010,
    DEF_BIT_LIKE_GOT = 0x0020,
};

// registry.hpp

enum noname_registry_hpp
{
    MAX_HISTORY_FILES_DEF = 10, // default value
};

// search.hpp

enum SEARCH
{
    SEARCH_UP = 0x000,
    SEARCH_DOWN = 0x001,
    SEARCH_NEXT = 0x002,
    SEARCH_CASE = 0x004,
    SEARCH_REGEX = 0x008,
    SEARCH_NOBRK = 0x010,
    SEARCH_NOSHOW = 0x020,
    SEARCH_IDENT = 0x080,
    SEARCH_BRK = 0x100,
    SEARCH_USE = 0x200,
    SEARCH_DEF = 0x400,
    SEARCH_USESEL = 0x800,
};

// segment.hpp

enum noname_segment_hpp
{
    SREG_NUM = 16,
    SEG_MAX_BITNESS_CODE = 2,
    MAX_GROUPS = 8,
};

enum segment_align
{
    saAbs = 0,
    saRelByte = 1,
    saRelWord = 2,
    saRelPara = 3,
    saRelPage = 4,
    saRelDble = 5,
    saRel4K = 6,
    saGroup = 7,
    saRel32Bytes = 8,
    saRel64Bytes = 9,
    saRelQword = 10,
    saRel128Bytes = 11,
    saRel512Bytes = 12,
    saRel1024Bytes = 13,
    saRel2048Bytes = 14,
    saRel_MAX_ALIGN_CODE = saRel2048Bytes,
};

enum segment_comb
{
    scPriv = 0,
    scGroup = 1,
    scPub = 2,
    scPub2 = 4,
    scStack = 5,
    scCommon = 6,
    scPub3 = 7,
    sc_MAX_COMB_CODE = scPub3,
};

enum SEGPERM // segment_t::perm
{
    SEGPERM_EXEC = 1,
    SEGPERM_WRITE = 2,
    SEGPERM_READ = 4,
    SEGPERM_MAXVAL = (SEGPERM_EXEC + SEGPERM_WRITE + SEGPERM_READ),
};

enum SFL
{
    SFL_COMORG = 0x01,
    SFL_OBOK = 0x02,
    SFL_HIDDEN = 0x04,
    SFL_DEBUG = 0x08,
    SFL_LOADER = 0x10,
    SFL_HIDETYPE = 0x20,
    SFL_HEADER = 0x40,
};

enum segment_type_e // Used by segment_t::type
{
    SEG_NORM = 0,
    SEG_XTRN = 1,
    SEG_CODE = 2,
    SEG_DATA = 3,
    SEG_IMP = 4,
    SEG_GRP = 6,
    SEG_NULL = 7,
    SEG_UNDF = 8,
    SEG_BSS = 9,
    SEG_ABSSYM = 10,
    SEG_COMM = 11,
    SEG_IMEM = 12,
    SEG_MAX_SEGTYPE_CODE = SEG_IMEM
};

enum ADDSET
{
    ADDSEG_NOSREG = 0x0001,
    ADDSEG_OR_DIE = 0x0002,
    ADDSEG_NOTRUNC = 0x0004,
    ADDSEG_QUIET = 0x0008,
    ADDSEG_FILLGAP = 0x0010,
    ADDSEG_SPARSE = 0x0020,
    ADDSEG_NOAA = 0x0040,
    ADDSEG_IDBENC = 0x0080,
};

enum SEGMOD
{
    SEGMOD_KILL = 0x0001,
    SEGMOD_KEEP = 0x0002,
    SEGMOD_SILENT = 0x0004,
    SEGMOD_KEEP0 = 0x0008,
    SEGMOD_KEEPSEL = 0x0010,
    SEGMOD_NOMOVE = 0x0020,
    SEGMOD_SPARSE = 0x0040,
};

enum MSF
{
    MSF_SILENT = 0x0001,
    MSF_NOFIX = 0x0002,
    MSF_LDKEEP = 0x0004,
    MSF_FIXONCE = 0x0008,
    MSF_PRIORITY = 0x0020,
    MSF_NETNODES = 0x0080,
};

enum CSS
{
    CSS_OK = 0,
    CSS_NODBG = -1,
    CSS_NORANGE = -2,
    CSS_NOMEM = -3,
    CSS_BREAK = -4,
};

enum SNAP
{
    SNAP_ALL_SEG = 0,
    SNAP_LOAD_SEG = 1,
    SNAP_CUR_SEG = 2,
};

// segregs.hpp

enum SR
{
    SR_inherit = 1,
    SR_user = 2,
    SR_auto = 3,
    SR_autostart = 4,
};

// srclang.hpp

enum SRCLANG
{
    SRCLANG_C = 0x01,
    SRCLANG_CPP = 0x02,
    SRCLANG_OBJC = 0x04,
    SRCLANG_SWIFT = 0x08,
    SRCLANG_GO = 0x10,
};

// struct.hpp

enum MF
{
    MF_OK = 0x00000001,
    MF_UNIMEM = 0x00000002,
    MF_HASUNI = 0x00000004,
    MF_BYTIL = 0x00000008,
    MF_HASTI = 0x00000010,
    MF_BASECLASS = 0x00000020,
    MF_DTOR = 0x00000040,
    MF_DUPNAME = 0x00000080,
    MF_RESERVED1 = 0x80000000,
};

enum SF
{
    SF_VAR = 0x00000001,
    SF_UNION = 0x00000002,
    SF_HASUNI = 0x00000004,
    SF_NOLIST = 0x00000008,
    SF_TYPLIB = 0x00000010,
    SF_HIDDEN = 0x00000020,
    SF_FRAME = 0x00000040,
    SF_ALIGN = 0x00000F80,
    SF_GHOST = 0x00001000,
    SF_ASMTIL = 0x80000000,
};

enum SET_MEMTI
{
    SET_MEMTI_MAY_DESTROY = 0x0001,
    SET_MEMTI_COMPATIBLE = 0x0002,
    SET_MEMTI_FUNCARG = 0x0004,
    SET_MEMTI_BYTIL = 0x0008,
    SET_MEMTI_USERTI = 0x0010,
};

//  tryblks.hpp

enum TB
{
    TB_NONE = 0,
    TB_SEH = 1,
    TB_CPP = 2,
};

enum TBERR
{
    TBERR_OK = 0,
    TBERR_START = 1,
    TBERR_END = 2,
    TBERR_ORDER = 3,
    TBERR_EMPTY = 4,
    TBERR_KIND = 5,
    TBERR_NO_CATCHES = 6,
    TBERR_INTERSECT = 7,
};

enum TBEA
{
    TBEA_TRY = 0x01,
    TBEA_CATCH = 0x02,
    TBEA_SEHTRY = 0x04,
    TBEA_SEHLPAD = 0x08,
    TBEA_SEHFILT = 0x10,
    TBEA_ANY = 0x1f,
    TBEA_FALLTHRU = 0x20,
};

// typeinf.hpp

enum tf_mask
{
    TYPE_BASE_MASK = 0x0F,
    TYPE_FLAGS_MASK = 0x30,
    TYPE_MODIF_MASK = 0xC0,
    TYPE_FULL_MASK = (TYPE_BASE_MASK | TYPE_FLAGS_MASK),
};

enum tf_unk
{
    BT_UNK = 0x00,
    BT_VOID = 0x01,
    BTMT_SIZE0 = 0x00,
    BTMT_SIZE12 = 0x10,
    BTMT_SIZE48 = 0x20,
    BTMT_SIZE128 = 0x30,
};

enum tf_int
{
    BT_INT8 = 0x02,
    BT_INT16 = 0x03,
    BT_INT32 = 0x04,
    BT_INT64 = 0x05,
    BT_INT128 = 0x06,
    BT_INT = 0x07,
    BTMT_UNKSIGN = 0x00,
    BTMT_SIGNED = 0x10,
    BTMT_USIGNED = 0x20,
    BTMT_UNSIGNED = BTMT_USIGNED,
    BTMT_CHAR = 0x30,
};

enum tf_bool
{
    BT_BOOL = 0x08,
    BTMT_DEFBOOL = 0x00,
    BTMT_BOOL1 = 0x10,
    BTMT_BOOL2 = 0x20,
    BTMT_BOOL8 = 0x20,
    BTMT_BOOL4 = 0x30,
};

enum tf_float
{
    BT_FLOAT = 0x09,
    BTMT_FLOAT = 0x00,
    BTMT_DOUBLE = 0x10,
    BTMT_LNGDBL = 0x20,
    BTMT_SPECFLT = 0x30,
};

enum tf_last_basic
{
    _BT_LAST_BASIC = BT_FLOAT,
};

enum tf_ptr
{
    BT_PTR = 0x0A,
    BTMT_DEFPTR = 0x00,
    BTMT_NEAR = 0x10,
    BTMT_FAR = 0x20,
    BTMT_CLOSURE = 0x30,
};

enum tf_array
{
    BT_ARRAY = 0x0B,
    BTMT_NONBASED = 0x10,
    BTMT_ARRESERV = 0x20,
};

enum tf_func
{
    BT_FUNC = 0x0C,
    BTMT_DEFCALL = 0x00,
    BTMT_NEARCALL = 0x10,
    BTMT_FARCALL = 0x20,
    BTMT_INTCALL = 0x30,
};

enum tf_complex
{
    BT_COMPLEX = 0x0D,
    BTMT_STRUCT = 0x00,
    BTMT_UNION = 0x10,
    BTMT_ENUM = 0x20,
    BTMT_TYPEDEF = 0x30,
};

enum tf_bitfield
{
    BT_BITFIELD = 0x0E,
    BTMT_BFLDI8 = 0x00,
    BTMT_BFLDI16 = 0x10,
    BTMT_BFLDI32 = 0x20,
    BTMT_BFLDI64 = 0x30,
};

enum noname_typeinf_hpp
{
    BT_RESERVED = 0x0F,
    BADSIZE = -1,
    MAX_FUNC_ARGS = 256,
};

enum tf_modifiers
{
    BTM_CONST = 0x40,
    BTM_VOLATILE = 0x80,
};

enum tf_enum
{
    BTE_SIZE_MASK = 0x07,
    BTE_RESERVED = 0x08,
    BTE_BITFIELD = 0x10,
    BTE_BITMASK = 0x10,
    BTE_OUT_MASK = 0x60,
    BTE_HEX = 0x00,
    BTE_CHAR = 0x20,
    BTE_SDEC = 0x40,
    BTE_UDEC = 0x60,
    BTE_ALWAYS = 0x80,
};

enum tf_conv_segreg
{
    BT_SEGREG = (BT_INT | BTMT_CHAR),
};

enum tf_conv_unk
{
    BT_UNK_BYTE = (BT_VOID | BTMT_SIZE12),
    BT_UNK_WORD = (BT_UNK | BTMT_SIZE12),
    BT_UNK_DWORD = (BT_VOID | BTMT_SIZE48),
    BT_UNK_QWORD = (BT_UNK | BTMT_SIZE48),
    BT_UNK_OWORD = (BT_VOID | BTMT_SIZE128),
    BT_UNKNOWN = (BT_UNK | BTMT_SIZE128),
};

enum tf_shortcuts
{
    BTF_BYTE = BT_UNK_BYTE,
    BTF_UNK = BT_UNKNOWN,
    BTF_VOID = BT_VOID | BTMT_SIZE0,
    BTF_INT8 = BT_INT8 | BTMT_SIGNED,
    BTF_CHAR = BT_INT8 | BTMT_CHAR,
    BTF_UCHAR = BT_INT8 | BTMT_USIGNED,
    BTF_UINT8 = BT_INT8 | BTMT_USIGNED,
    BTF_INT16 = BT_INT16 | BTMT_SIGNED,
    BTF_UINT16 = BT_INT16 | BTMT_USIGNED,
    BTF_INT32 = BT_INT32 | BTMT_SIGNED,
    BTF_UINT32 = BT_INT32 | BTMT_USIGNED,
    BTF_INT64 = BT_INT64 | BTMT_SIGNED,
    BTF_UINT64 = BT_INT64 | BTMT_USIGNED,
    BTF_INT128 = BT_INT128 | BTMT_SIGNED,
    BTF_UINT128 = BT_INT128 | BTMT_USIGNED,
    BTF_INT = BT_INT | BTMT_UNKSIGN,
    BTF_UINT = BT_INT | BTMT_USIGNED,
    BTF_SINT = BT_INT | BTMT_SIGNED,
    BTF_BOOL = BT_BOOL,
    BTF_FLOAT = BT_FLOAT | BTMT_FLOAT,
    BTF_DOUBLE = BT_FLOAT | BTMT_DOUBLE,
    BTF_LDOUBLE = BT_FLOAT | BTMT_LNGDBL,
    BTF_TBYTE = BT_FLOAT | BTMT_SPECFLT,
    BTF_STRUCT = BT_COMPLEX | BTMT_STRUCT,
    BTF_UNION = BT_COMPLEX | BTMT_UNION,
    BTF_ENUM = BT_COMPLEX | BTMT_ENUM,
    BTF_TYPEDEF = BT_COMPLEX | BTMT_TYPEDEF,
};

enum tattr
{
    TAH_BYTE = 0xFE,
    FAH_BYTE = 0xFF,
    MAX_DECL_ALIGN = 0x000F,
    TAH_ALL_83 = 0x03F0,
    TAH_ALL_84 = 0x0FF0,
};

enum tattr_udt
{
    TAUDT_UNALIGNED = 0x0040,
    TAUDT_MSSTRUCT = 0x0020,
    TAUDT_CPPOBJ = 0x0080,
    TAUDT_VFTABLE = 0x0100,
};

enum tattr_field
{
    TAFLD_BASECLASS = 0x0020,
    TAFLD_UNALIGNED = 0x0040,
    TAFLD_VIRTBASE = 0x0080,
    TAFLD_VFTABLE = 0x0100,
    TAFLD_METHOD = 0x0200,
    TAFLD_GAP = 0x0400,
    TAFLD_REGCMT = 0x0800,
    TAFLD_FRAME_R = 0x1000,
    TAFLD_FRAME_S = 0x2000,
    TAFLD_BYTIL = 0x4000,
};

enum tattr_ptr
{
    TAPTR_PTR32 = 0x0020,
    TAPTR_PTR64 = 0x0040,
    TAPTR_RESTRICT = 0x0060,
    TAPTR_SHIFTED = 0x0080,
};

enum tattr_enum
{
    TAENUM_64BIT = 0x0020,
    TAENUM_UNSIGNED = 0x0040,
    TAENUM_SIGNED = 0x0080,
    TAENUM_OCT = 0x0100,
    TAENUM_BIN = 0x0200,
    TAENUM_NUMSIGN = 0x0400,
    TAENUM_LZERO = 0x0800,
    TAH_ALL = 0x7FF0,
};

enum type_sign_e
{
    no_sign = 0,
    type_signed = 1,
    type_unsigned = 2,
};

enum TIL
{
    TIL_ZIP = 0x0001,
    TIL_MAC = 0x0002,
    TIL_ESI = 0x0004,
    TIL_UNI = 0x0008,
    TIL_ORD = 0x0010,
    TIL_ALI = 0x0020,
    TIL_MOD = 0x0040,
    TIL_STM = 0x0080,
    TIL_SLD = 0x0100,
};

enum TIL_ADD
{
    TIL_ADD_FAILED = 0,
    TIL_ADD_OK = 1,
    TIL_ADD_ALREADY = 2,
};

enum CM
{
    CM_MASK = 0x03,
    CM_UNKNOWN = 0x00,
    CM_N8_F16 = 0x01,
    CM_N64 = 0x01,
    CM_N16_F32 = 0x02,
    CM_N32_F48 = 0x03,
};

enum CM_M
{
    CM_M_MASK = 0x0C,
    CM_M_NN = 0x00,
    CM_M_FF = 0x04,
    CM_M_NF = 0x08,
    CM_M_FN = 0x0C,
};

enum CM_CC
{
    CM_CC_MASK = 0xF0,
    CM_CC_INVALID = 0x00,
    CM_CC_UNKNOWN = 0x10,
    CM_CC_VOIDARG = 0x20,

    CM_CC_CDECL = 0x30,
    CM_CC_ELLIPSIS = 0x40,
    CM_CC_STDCALL = 0x50,
    CM_CC_PASCAL = 0x60,
    CM_CC_FASTCALL = 0x70,
    CM_CC_THISCALL = 0x80,
    CM_CC_SWIFT = 0x90,
    CM_CC_SPOILED = 0xA0,

    CM_CC_GOLANG = 0xB0,
    CM_CC_RESERVE3 = 0xC0,
    CM_CC_SPECIALE = 0xD0,
    CM_CC_SPECIALP = 0xE0,
    CM_CC_SPECIAL = 0xF0,
};

enum BFA
{
    BFA_NORET = 0x01,
    BFA_PURE = 0x02,
    BFA_HIGH = 0x04,
    BFA_STATIC = 0x08,
    BFA_VIRTUAL = 0x10,
    BFA_FUNC_MARKER = 0x0F,
    BFA_FUNC_EXT_FORMAT = 0x80,
};

enum argloc_type_e
{
    ALOC_NONE = 0,
    ALOC_STACK = 1,
    ALOC_DIST = 2,
    ALOC_REG1 = 3,
    ALOC_REG2 = 4,
    ALOC_RREL = 5,
    ALOC_STATIC = 6,
    ALOC_CUSTOM = 7,
};

enum PRALOC
{
    PRALOC_VERIFY = 0x01,
    PRALOC_STKOFF = 0x02,
};

enum C_PC
{
    C_PC_TINY = (CM_N16_F32 | CM_M_NN),
    C_PC_SMALL = (CM_N16_F32 | CM_M_NN),
    C_PC_COMPACT = (CM_N16_F32 | CM_M_NF),
    C_PC_MEDIUM = (CM_N16_F32 | CM_M_FN),
    C_PC_LARGE = (CM_N16_F32 | CM_M_FF),
    C_PC_HUGE = (CM_N16_F32 | CM_M_FF),
    C_PC_FLAT = (CM_N32_F48 | CM_M_NN),
};

enum COMP
{
    COMP_MASK = 0x0F,
    COMP_UNK = 0x00,
    COMP_MS = 0x01,
    COMP_BC = 0x02,
    COMP_WATCOM = 0x03,
    COMP_GNU = 0x06,
    COMP_VISAGE = 0x07,
    COMP_BP = 0x08,
    COMP_UNSURE = 0x80,
};

enum SETCOM
{
    SETCOMP_OVERRIDE = 0x0001,
    SETCOMP_ONLY_ID = 0x0002,
    SETCOMP_ONLY_ABI = 0x0004,
    SETCOMP_BY_USER = 0x0008,
};

enum HTI
{
    HTI_CPP = 0x00000001,
    HTI_INT = 0x00000002,
    HTI_EXT = 0x00000004,
    HTI_LEX = 0x00000008,
    HTI_UNP = 0x00000010,
    HTI_TST = 0x00000020,
    HTI_FIL = 0x00000040,
    HTI_MAC = 0x00000080,
    HTI_NWR = 0x00000100,
    HTI_NER = 0x00000200,
    HTI_DCL = 0x00000400,
    HTI_NDC = 0x00000800,
    HTI_PAK = 0x00007000,
    HTI_PAK_SHIFT = 12,
    HTI_PAKDEF = 0x00000000,
    HTI_PAK1 = 0x00001000,
    HTI_PAK2 = 0x00002000,
    HTI_PAK4 = 0x00003000,
    HTI_PAK8 = 0x00004000,
    HTI_PAK16 = 0x00005000,
    HTI_HIGH = 0x00008000,
    HTI_LOWER = 0x00010000,
    HTI_RAWARGS = 0x00020000,
    HTI_RELAXED = 0x00080000,
    HTI_NOBASE = 0x00100000,
};

enum PT_F
{
    PT_SIL = 0x0001,
    PT_NDC = 0x0002,
    PT_TYP = 0x0004,
    PT_VAR = 0x0008,
    PT_PACKMASK = 0x0070,
    PT_HIGH = 0x0080,
    PT_LOWER = 0x0100,
    PT_REPLACE = 0x0200,
    PT_RAWARGS = 0x0400,
    PT_RELAXED = 0x1000,
    PT_SEMICOLON = 0x4000,  // 9.0 SP1
};

enum PRTYPE
{
    PRTYPE_1LINE = 0x0000,
    PRTYPE_MULTI = 0x0001,
    PRTYPE_TYPE = 0x0002,
    PRTYPE_PRAGMA = 0x0004,
    PRTYPE_SEMI = 0x0008,
    PRTYPE_CPP = 0x0010,
    PRTYPE_DEF = 0x0020,
    PRTYPE_NOARGS = 0x0040,
    PRTYPE_NOARRS = 0x0080,
    PRTYPE_NORES = 0x0100,
    PRTYPE_RESTORE = 0x0200,
    PRTYPE_NOREGEX = 0x0400,
    PRTYPE_COLORED = 0x0800,
    PRTYPE_METHODS = 0x1000,
    PRTYPE_1LINCMT = 0x2000,
    PRTYPE_HEADER = 0x4000,
    PRTYPE_OFFSETS = 0x8000,
    PRTYPE_MAXSTR = 0x10000,
    PRTYPE_TAIL = 0x20000,
};

enum NTF
{
    NTF_TYPE = 0x0001,
    NTF_SYMU = 0x0008,
    NTF_SYMM = 0x0000,
    NTF_NOBASE = 0x0002,
    NTF_REPLACE = 0x0004,
    NTF_UMANGLED = 0x0008,
    NTF_NOCUR = 0x0020,
    NTF_64BIT = 0x0040,
    NTF_FIXNAME = 0x0080,
    NTF_IDBENC = 0x0100,
    NTF_CHKSYNC = 0x0200,
    NTF_NO_NAMECHK = 0x0400,
    NTF_NOSYNC = 0x0800,
    NTF_COPY = 0x1000,
};

enum CCN
{
    CCN_C = 0x00,
    CCN_CPP = 0x01,
};

enum IMPTYPE
{
    IMPTYPE_VERBOSE = 0x0001,
    IMPTYPE_OVERRIDE = 0x0002,
    IMPTYPE_LOCAL = 0x0004,
};

enum ADDTIL_F
{
    ADDTIL_DEFAULT = 0x0000,
    ADDTIL_INCOMP = 0x0001,
    ADDTIL_SILENT = 0x0002,
};

enum ADDTIL_R
{
    ADDTIL_FAILED = 0,
    ADDTIL_OK = 1,
    ADDTIL_COMP = 2,
    ADDTIL_ABORTED = 3,
};

enum TINFO
{
    TINFO_GUESSED = 0x0000,
    TINFO_DEFINITE = 0x0001,
    TINFO_DELAYFUNC = 0x0002,
    TINFO_STRICT = 0x0004,
};

enum GUESS
{
    GUESS_FUNC_FAILED = 0,
    GUESS_FUNC_TRIVIAL = 1,
    GUESS_FUNC_OK = 2,
};

enum SUDT
{
    SUDT_SORT = 0x0001,
    SUDT_ALIGN = 0x0002,
    SUDT_GAPS = 0x0004,
    SUDT_UNEX = 0x0008,
    SUDT_FAST = 0x0010,
    SUDT_CONST = 0x0040,
    SUDT_VOLATILE = 0x0080,
    SUDT_TRUNC = 0x0100,
    SUDT_SERDEF = 0x0200,
};

enum tf_nontrivial
{
    FIRST_NONTRIVIAL_TYPID = 0x100,
    TYPID_ISREF = 0x100,
    TYPID_SHIFT = 9,
};

enum STRMEM
{
    STRMEM_MASK = 0x0007,
    STRMEM_OFFSET = 0x0000,
    STRMEM_INDEX = 0x0001,
    STRMEM_AUTO = 0x0002,
    STRMEM_NAME = 0x0003,
    STRMEM_TYPE = 0x0004,
    STRMEM_SIZE = 0x0005,
    STRMEM_MINS = 0x0006,
    STRMEM_MAXS = 0x0007,
    STRMEM_LOWBND = 0x0008,
    STRMEM_NEXT = 0x0009,
    STRMEM_VFTABLE = 0x10000000,
    STRMEM_SKIP_EMPTY = 0x20000000,
    STRMEM_CASTABLE_TO = 0x40000000,
    STRMEM_ANON = 0x80000000,
    STRMEM_SKIP_GAPS = 0x01000000,
};

enum TCMP
{
    TCMP_EQUAL = 0x0000,
    TCMP_IGNMODS = 0x0001,
    TCMP_AUTOCAST = 0x0002,
    TCMP_MANCAST = 0x0004,
    TCMP_CALL = 0x0008,
    TCMP_DELPTR = 0x0010,
    TCMP_DECL = 0x0020,
    TCMP_ANYBASE = 0x0040,
    TCMP_SKIPTHIS = 0x0080,
};

enum FAI
{
    FAI_HIDDEN = 0x0001,
    FAI_RETPTR = 0x0002,
    FAI_STRUCT = 0x0004,
    FAI_ARRAY = 0x0008,
    FAI_UNUSED = 0x0010,
};

enum FTI
{
    FTI_SPOILED = 0x0001,
    FTI_NORET = 0x0002,
    FTI_PURE = 0x0004,
    FTI_HIGH = 0x0008,
    FTI_STATIC = 0x0010,
    FTI_VIRTUAL = 0x0020,
    FTI_CALLTYPE = 0x00C0,
    FTI_DEFCALL = 0x0000,
    FTI_NEARCALL = 0x0040,
    FTI_FARCALL = 0x0080,
    FTI_INTCALL = 0x00C0,
    FTI_ARGLOCS = 0x0100,
    FTI_EXPLOCS = 0x0200,
    FTI_CONST = 0x0400,
    FTI_CTOR = 0x0800,
    FTI_DTOR = 0x1000,
    FTI_ALL = 0x1FFF,
};

enum TVIS
{
    TVIS_TYPE = 0x0001,
    TVIS_NAME = 0x0002,
    TVIS_CMT = 0x0004,
    TVIS_RPTCMT = 0x0008,
};

enum TVST
{
    TVST_PRUNE = 0x01,
    TVST_DEF = 0x02,
    TVST_LEVEL = 0x04,
};

enum FRB
{
    FRB_MASK = 0xF,
    FRB_UNK = 0x0,
    FRB_NUMB = 0x1,
    FRB_NUMO = 0x2,
    FRB_NUMH = 0x3,
    FRB_NUMD = 0x4,
    FRB_FLOAT = 0x5,
    FRB_CHAR = 0x6,
    FRB_SEG = 0x7,
    FRB_ENUM = 0x8,
    FRB_OFFSET = 0x9,
    FRB_STRLIT = 0xA,
    FRB_STROFF = 0xB,
    FRB_CUSTOM = 0xC,
    FRB_INVSIGN = 0x0100,
    FRB_INVBITS = 0x0200,
    FRB_SIGNED = 0x0400,
    FRB_LZERO = 0x0800,
    FRB_TABFORM = 0x1000,
};

enum TPOS
{
    TPOS_LNNUM = '\x05',
    TPOS_REGCMT = '\x06',
};

enum pio_flags
{
    PIO_NOATTR_FAIL = 0x0004,
    PIO_IGNORE_PTRS = 0x0008,
};

enum PTV
{
    PTV_DEREF = 0x0001,
    PTV_QUEST = 0x0002,
    PTV_EMPTY = 0x0004,
    PTV_CSTR = 0x0008,
    PTV_EXPAND = 0x0010,
    PTV_LZHEX = 0x0020,
    PTV_LZERO = PTV_LZHEX,
    PTV_STPFLT = 0x0040,
    PTV_SPACE = 0x0080,
    PTV_DEBUG = 0x0100,
    PTV_NOPTR = 0x0200,
    PTV_NTOP = 0x40000000,
    PTV_KEEP = 0x80000000,
};

enum PDF
{
    PDF_INCL_DEPS = 0x1,
    PDF_DEF_FWD = 0x2,
    PDF_DEF_BASE = 0x4,
    PDF_HEADER_CMT = 0x8,
};

enum PCN
{
    PCN_RADIX = 0x07,
    PCN_DEC = 0x00,
    PCN_HEX = 0x01,
    PCN_OCT = 0x02,
    PCN_CHR = 0x03,
    PCN_UNSIGNED = 0x08,
    PCN_LZHEX = 0x10,
    PCN_NEGSIGN = 0x20,
    PCN_DECSEXT = 0x40,
};

// ua.hpp

enum noname_ua_hpp
{
    DEFAULT_INDENT = 0xFFFF,
};

enum optype_e
{
    o_void = 0,
    o_reg = 1,
    o_mem = 2,
    o_phrase = 3,
    o_displ = 4,
    o_imm = 5,
    o_far = 6,
    o_near = 7,
    o_idpspec0 = 8,
    o_idpspec1 = 9,
    o_idpspec2 = 10,
    o_idpspec3 = 11,
    o_idpspec4 = 12,
    o_idpspec5 = 13,
};

enum OF
{
    OF_NO_BASE_DISP = 0x80,
    OF_OUTER_DISP = 0x40,
    PACK_FORM_DEF = 0x20,
    OF_NUMBER = 0x10,
    OF_SHOW = 0x08,
};

enum op_dtype_e
{
    dt_byte = 0,
    dt_word = 1,
    dt_dword = 2,
    dt_float = 3,
    dt_double = 4,
    dt_tbyte = 5,
    dt_packreal = 6,
    dt_qword = 7,
    dt_byte16 = 8,
    dt_code = 9,
    dt_void = 10,
    dt_fword = 11,
    dt_bitfild = 12,
    dt_string = 13,
    dt_unicode = 14,
    dt_ldbl = 15,
    dt_byte32 = 16,
    dt_byte64 = 17,
    dt_half = 18,
};

enum INSN
{
    INSN_MACRO = 0x01,
    INSN_MODMAC = 0x02,
    INSN_64BIT = 0x04,
};

enum CTXF
{
    CTXF_MAIN = 0x00001,
    CTXF_MULTI = 0x00002,
    CTXF_CODE = 0x00004,
    CTXF_STACK = 0x00008,
    CTXF_GEN_XREFS = 0x00010,
    CTXF_XREF_STATE = 0x00060,
    XREFSTATE_NONE = 0x00,
    XREFSTATE_GO = 0x20,
    XREFSTATE_DONE = 0x40,
    CTXF_GEN_CMT = 0x00080,
    CTXF_CMT_STATE = 0x00300,
    COMMSTATE_NONE = 0x000,
    COMMSTATE_GO = 0x100,
    COMMSTATE_DONE = 0x200,
    CTXF_VOIDS = 0x00400,
    CTXF_NORMAL_LABEL = 0x00800,
    CTXF_DEMANGLED_LABEL = 0x01000,
    CTXF_LABEL_OK = 0x02000,
    CTXF_DEMANGLED_OK = 0x04000,
    CTXF_OVSTORE_PRNT = 0x08000,
    CTXF_OUTCTX_T = 0x10000,
    CTXF_DBLIND_OPND = 0x20000,
    CTXF_BINOP_STATE = 0xC0000,
    BINOPSTATE_NONE = 0x00000,
    BINOPSTATE_GO = 0x40000,
    BINOPSTATE_DONE = 0x80000,
    CTXF_HIDDEN_ADDR = 0x100000,
    CTXF_BIT_PREFIX = 0x200000,
};

enum OOF
{
    OOF_SIGNMASK = 0x0003,
    OOFS_IFSIGN = 0x0000,
    OOFS_NOSIGN = 0x0001,
    OOFS_NEEDSIGN = 0x0002,
    OOF_SIGNED = 0x0004,
    OOF_NUMBER = 0x0008,
    OOF_WIDTHMASK = 0x0070,
    OOFW_IMM = 0x0000,
    OOFW_8 = 0x0010,
    OOFW_16 = 0x0020,
    OOFW_24 = 0x0030,
    OOFW_32 = 0x0040,
    OOFW_64 = 0x0050,
    OOF_ADDR = 0x0080,
    OOF_OUTER = 0x0100,
    OOF_ZSTROFF = 0x0200,
    OOF_NOBNOT = 0x0400,
    OOF_SPACES = 0x0800,
    OOF_ANYSERIAL = 0x1000,
    OOF_LZEROES = 0x2000,
    OOF_NO_LZEROES = 0x4000,
};

enum MAKELINE
{
    MAKELINE_NONE = 0x00,
    MAKELINE_BINPREF = 0x01,
    MAKELINE_VOID = 0x02,
    MAKELINE_STACK = 0x04,
};

enum GH
{
    GH_PRINT_PROC = (1 << 0),
    GH_PRINT_ASM = (1 << 1),
    GH_PRINT_BYTESEX = (1 << 2),
    GH_PRINT_HEADER = (1 << 3),
    GH_BYTESEX_HAS_HIGHBYTE = (1 << 4),
    GH_PRINT_PROC_AND_ASM = (GH_PRINT_PROC | GH_PRINT_ASM),
    GH_PRINT_PROC_ASM_AND_BYTESEX = (GH_PRINT_PROC_AND_ASM | GH_PRINT_BYTESEX),
    GH_PRINT_ALL = (GH_PRINT_PROC_ASM_AND_BYTESEX | GH_PRINT_HEADER),
    GH_PRINT_ALL_BUT_BYTESEX = (GH_PRINT_PROC_AND_ASM | GH_PRINT_HEADER),
};

enum FCBF
{
    FCBF_CONT = 0x00000001,
    FCBF_ERR_REPL = 0x00000002,
    FCBF_FF_LIT = 0x00000004,
    FCBF_DELIM = 0x00000008,
};

// xref.hpp

enum XREF_T
{
    XREF_USER = 0x20,
    XREF_TAIL = 0x40,
    XREF_BASE = 0x80,
    XREF_MASK = 0x1F,
    XREF_PASTEND = 0x100,
};

enum XREF
{
    XREF_ALL = 0x00,
    XREF_FAR = 0x01,
    XREF_DATA = 0x02,
};

#pragma region libfuncs.hpp of 9.0 SP1

enum idasgn_header_ostype
{
    OSTYPE_MSDOS = 0x0001,
    OSTYPE_WIN = 0x0002,
    OSTYPE_OS2 = 0x0004,
    OSTYPE_NETW = 0x0008,
    OSTYPE_UNIX = 0x0010,
    OSTYPE_OTHER = 0x0020,
};

enum idasgn_header_apptype
{
    APPT_CONSOLE = 0x0001,
    APPT_GRAPHIC = 0x0002,
    APPT_PROGRAM = 0x0004,
    APPT_LIBRARY = 0x0008,
    APPT_DRIVER = 0x0010,
    APPT_1THREAD = 0x0020,
    APPT_MTHREAD = 0x0040,
    APPT_16BIT = 0x0080,
    APPT_32BIT = 0x0100,
    APPT_64BIT = 0x0200,
};

enum idasgn_header_flags
{
    LS_STARTUP = 0x0001,
    LS_CTYPE = 0x0002,
    LS_CTYPE2 = 0x0004,
    LS_CTYPE_ALT = 0x0008,
    LS_ZIP = 0x0010,
    LS_CTYPE_3V = 0x0020,
};

#pragma endregion libfuncs.hpp of 9.0 SP1

#pragma region hexrays.hpp

enum VLR
{
    VLR_TYPE = 0x0F,
    VLR_NONE = 0x00,
    VLR_ALL = 0x01,
    VLR_IVLS = 0x02,
    VLR_RANGE = 0x03,
    VLR_SRANGE = 0x04,
    VLR_BITS = 0x05,
    VLR_SECT = 0x06,
    VLR_UNION = 0x07,
    VLR_UNK = 0x08,
};

enum maymust_e
{
    MUST_ACCESS = 0x00,
    MAY_ACCESS = 0x01,
    MAYMUST_ACCESS_MASK = 0x01,
    ONE_ACCESS_TYPE = 0x20,
    INCLUDE_SPOILED_REGS = 0x40,
    EXCLUDE_PASS_REGS = 0x80,
    FULL_XDSU = 0x100,
    WITH_ASSERTS = 0x200,
    EXCLUDE_VOLATILE = 0x400,
    INCLUDE_UNUSED_SRC = 0x800,
    INCLUDE_DEAD_RETREGS = 0x1000,
    INCLUDE_RESTRICTED = 0x2000,
    CALL_SPOILS_ONLY_ARGS = 0x4000,
};

enum NF
{
    NF_FIXED = 0x01,
    NF_NEGDONE = 0x02,
    NF_BINVDONE = 0x04,
    NF_NEGATE = 0x08,
    NF_BITNOT = 0x10,
    NF_STROFF = 0x20,
    NF_VALID = 0x20,
};

enum CVAR
{
    CVAR_USED = 0x00000001,
    CVAR_TYPE = 0x00000002,
    CVAR_NAME = 0x00000004,
    CVAR_MREG = 0x00000008,
    CVAR_NOWD = 0x00000010,
    CVAR_UNAME = 0x00000020,
    CVAR_UTYPE = 0x00000040,
    CVAR_RESULT = 0x00000080,
    CVAR_ARG = 0x00000100,
    CVAR_FAKE = 0x00000200,
    CVAR_OVER = 0x00000400,
    CVAR_FLOAT = 0x00000800,
    CVAR_SPOILED = 0x00001000,
    CVAR_MAPDST = 0x00002000,
    CVAR_PARTIAL = 0x00004000,
    CVAR_THISARG = 0x00008000,
    CVAR_FORCED = 0x00010000,
    CVAR_SPLIT = CVAR_FORCED,
    CVAR_REGNAME = 0x00020000,
    CVAR_NOPTR = 0x00040000,
    CVAR_DUMMY = 0x00080000,
    CVAR_NOTARG = 0x00100000,
    CVAR_AUTOMAP = 0x00200000,
    CVAR_BYREF = 0x00400000,
    CVAR_INASM = 0x00800000,
    CVAR_UNUSED = 0x01000000,
    CVAR_SHARED = 0x02000000,
    CVAR_SCARG = 0x04000000,
};

enum svw_flags
{
    SVW_INT = 0x00,
    SVW_FLOAT = 0x01,
    SVW_SOFT = 0x02,
};

enum LVINF
{
    LVINF_KEEP = 0x0001,
    LVINF_FORCE = 0x0002,
    LVINF_SPLIT = LVINF_FORCE,
    LVINF_NOPTR = 0x0004,
    LVINF_NOMAP = 0x0008,
    LVINF_UNUSED = 0x0010,
};

enum ulv_flags
{
    ULV_PRECISE_DEFEA = 0x0001,
};

enum MLI
{
    MLI_NAME = 0x01,
    MLI_TYPE = 0x02,
    MLI_CMT = 0x04,
    MLI_SET_FLAGS = 0x08,
    MLI_CLR_FLAGS = 0x10,
};

enum mopt_e
{
    mop_z = 0,
    mop_r = 1,
    mop_n = 2,
    mop_str = 3,
    mop_d = 4,
    mop_S = 5,
    mop_v = 6,
    mop_b = 7,
    mop_f = 8,
    mop_l = 9,
    mop_a = 10,
    mop_h = 11,
    mop_c = 12,
    mop_fn = 13,
    mop_p = 14,
    mop_sc = 15,
};

enum SHINS
{
    SHINS_NUMADDR = 0x01,
    SHINS_VALNUM = 0x02,
    SHINS_SHORT = 0x04,
    SHINS_LDXEA = 0x08,
};

enum OPROP
{
    OPROP_IMPDONE = 0x01,
    OPROP_UDT = 0x02,
    OPROP_FLOAT = 0x04,
    OPROP_CCFLAGS = 0x08,
    OPROP_UDEFVAL = 0x10,
    OPROP_LOWADDR = 0x20,
};

enum FCI
{
    FCI_PROP = 0x001,
    FCI_DEAD = 0x002,
    FCI_FINAL = 0x004,
    FCI_NORET = 0x008,
    FCI_PURE = 0x010,
    FCI_NOSIDE = 0x020,
    FCI_SPLOK = 0x040,
    FCI_HASCALL = 0x080,
    FCI_HASFMT = 0x100,
    FCI_EXPLOCS = 0x400,
};

enum CHF
{
    CHF_INITED = 0x01,
    CHF_REPLACED = 0x02,
    CHF_OVER = 0x04,
    CHF_FAKE = 0x08,
    CHF_PASSTHRU = 0x10,
    CHF_TERM = 0x20,
};

enum gca_flags
{
    GCA_EMPTY = 0x01,
    GCA_SPEC = 0x02,
    GCA_ALLOC = 0x04,
    GCA_NALLOC = 0x08,
    GCA_OFIRST = 0x10,
    GCA_OLAST = 0x20,
};

enum IPROP
{
    IPROP_OPTIONAL = 0x0001,
    IPROP_PERSIST = 0x0002,
    IPROP_WILDMATCH = 0x0004,
    IPROP_CLNPOP = 0x0008,
    IPROP_FPINSN = 0x0010,
    IPROP_FARCALL = 0x0020,
    IPROP_TAILCALL = 0x0040,
    IPROP_ASSERT = 0x0080,
    IPROP_SPLIT = 0x0700,
    IPROP_SPLIT1 = 0x0100,
    IPROP_SPLIT2 = 0x0200,
    IPROP_SPLIT4 = 0x0300,
    IPROP_SPLIT8 = 0x0400,
    IPROP_COMBINED = 0x0800,
    IPROP_EXTSTX = 0x1000,
    IPROP_IGNLOWSRC = 0x2000,
    IPROP_INV_JX = 0x4000,
    IPROP_WAS_NORET = 0x8000,
    IPROP_MULTI_MOV = 0x10000,
    IPROP_DONT_PROP = 0x20000,
    IPROP_DONT_COMB = 0x40000,
    IPROP_MBARRIER = 0x80000,
    IPROP_UNMERGED = 0x100000,
    IPROP_UNPAIRED = 0x200000,
};

enum OPTI
{
    OPTI_ADDREXPRS = 0x0001,
    OPTI_MINSTKREF = 0x0002,
    OPTI_COMBINSNS = 0x0004,
    OPTI_NO_LDXOPT = 0x0008,
    OPTI_NO_VALRNG = 0x0010,
};

enum EQ
{
    EQ_IGNSIZE = 0x0001,
    EQ_IGNCODE = 0x0002,
    EQ_CMPDEST = 0x0004,
    EQ_OPTINSN = 0x0008,
};

enum is_noret_call_flags
{
    NORET_IGNORE_WAS_NORET_ICALL = 0x01,
    NORET_FORBID_ANALYSIS = 0x02,
};

enum MBL
{
    MBL_PRIV = 0x0001,
    MBL_NONFAKE = 0x0000,
    MBL_FAKE = 0x0002,
    MBL_GOTO = 0x0004,
    MBL_TCAL = 0x0008,
    MBL_PUSH = 0x0010,
    MBL_DMT64 = 0x0020,
    MBL_COMB = 0x0040,
    MBL_PROP = 0x0080,
    MBL_DEAD = 0x0100,
    MBL_LIST = 0x0200,
    MBL_INCONST = 0x0400,
    MBL_CALL = 0x0800,
    MBL_BACKPROP = 0x1000,
    MBL_NORET = 0x2000,
    MBL_DSLOT = 0x4000,
    MBL_VALRANGES = 0x8000,
    MBL_KEEP = 0x10000,
    MBL_INLINED = 0x20000,
    MBL_EXTFRAME = 0x40000,
};

enum FD
{
    FD_BACKWARD = 0x0000,
    FD_FORWARD = 0x0001,
    FD_USE = 0x0000,
    FD_DEF = 0x0002,
    FD_DIRTY = 0x0004,
};

enum vrflags
{
    VR_AT_START = 0x0000,
    VR_AT_END = 0x0001,
    VR_EXACT = 0x0002,
};

enum MBA
{
    MBA_PRCDEFS = 0x00000001,
    MBA_NOFUNC = 0x00000002,
    MBA_PATTERN = 0x00000004,
    MBA_LOADED = 0x00000008,
    MBA_RETFP = 0x00000010,
    MBA_SPLINFO = 0x00000020,
    MBA_PASSREGS = 0x00000040,
    MBA_THUNK = 0x00000080,
    MBA_CMNSTK = 0x00000100,
    MBA_PREOPT = 0x00000200,
    MBA_CMBBLK = 0x00000400,
    MBA_ASRTOK = 0x00000800,
    MBA_CALLS = 0x00001000,
    MBA_ASRPROP = 0x00002000,
    MBA_SAVRST = 0x00004000,
    MBA_RETREF = 0x00008000,
    MBA_GLBOPT = 0x00010000,
    MBA_OVERVAR = 0x00020000,
    MBA_LVARS0 = 0x00040000,
    MBA_LVARS1 = 0x00080000,
    MBA_DELPAIRS = 0x00100000,
    MBA_CHVARS = 0x00200000,
    MBA_SHORT = 0x00400000,
    MBA_COLGDL = 0x00800000,
    MBA_INSGDL = 0x01000000,
    MBA_NICE = 0x02000000,
    MBA_REFINE = 0x04000000,
    MBA_DELASRT = 0x08000000,
    MBA_WINGR32 = 0x10000000,
    MBA_NUMADDR = 0x20000000,
    MBA_VALNUM = 0x40000000,
    MBA_INITIAL_FLAGS = (MBA_INSGDL | MBA_NICE | MBA_CMBBLK | MBA_REFINE | MBA_PRCDEFS | MBA_WINGR32 | MBA_VALNUM),
};

enum MBA2
{
    MBA2_LVARNAMES_OK = 0x00000001,
    MBA2_LVARS_RENAMED = 0x00000002,
    MBA2_OVER_CHAINS = 0x00000004,
    MBA2_VALRNG_DONE = 0x00000008,
    MBA2_IS_CTR = 0x00000010,
    MBA2_IS_DTR = 0x00000020,
    MBA2_ARGIDX_OK = 0x00000040,
    MBA2_NO_DUP_CALLS = 0x00000080,
    MBA2_NO_DUP_LVARS = 0x00000100,
    MBA2_UNDEF_RETVAR = 0x00000200,
    MBA2_ARGIDX_SORTED = 0x00000400,
    MBA2_CODE16_BIT = 0x00000800,
    MBA2_STACK_RETVAL = 0x00001000,
    MBA2_HAS_OUTLINES = 0x00002000,
    MBA2_NO_FRAME = 0x00004000,
    MBA2_PROP_COMPLEX = 0x00008000,
    MBA2_DONT_VERIFY = 0x80000000,
    MBA2_INITIAL_FLAGS = (MBA2_LVARNAMES_OK | MBA2_LVARS_RENAMED),
    MBA2_ALL_FLAGS_72 = 0x0000003F,
    MBA2_ALL_FLAGS_77 = 0x00001FFF,
    MBA2_ALL_FLAGS_83 = 0x0000FFFF,
    MBA2_ALL_FLAGS_84_90 = 0x0001FFFF,
};

enum LOCOPT
{
    LOCOPT_ALL = 0x0001,
    LOCOPT_REFINE = 0x0002,
    LOCOPT_REFINE2 = 0x0004,
};

enum ACFL
{
    ACFL_LOCOPT = 0x01,
    ACFL_BLKOPT = 0x02,
    ACFL_GLBPROP = 0x04,
    ACFL_GLBDEL = 0x08,
    ACFL_GUESS = 0x10,
};

enum CPBLK
{
    CPBLK_FAST = 0x0000,
    CPBLK_MINREF = 0x0001,
    CPBLK_OPTJMP = 0x0002,
};

enum INLINE
{
    NLINE_EXTFRAME = 0x0001,
    NLINE_DONTCOPY = 0x0002,
};

enum OPF
{
    OPF_REUSE = 0x00,
    OPF_NEW_WINDOW = 0x01,
    OPF_REUSE_ACTIVE = 0x02,
    OPF_NO_WAIT = 0x08,
    OPF_WINDOW_MGMT_MASK = 0x07,
};

enum VDRUN
{
    VDRUN_NEWFILE = 0x00000000,
    VDRUN_APPEND = 0x00000001,
    VDRUN_ONLYNEW = 0x00000002,
    VDRUN_SILENT = 0x00000004,
    VDRUN_SENDIDB = 0x00000008,
    VDRUN_MAYSTOP = 0x00000010,
    VDRUN_CMDLINE = 0x00000020,
    VDRUN_STATS = 0x00000040,
    VDRUN_LUMINA = 0x00000080,
};

enum GCO
{
    GCO_STK = 0x0000,
    GCO_REG = 0x0001,
    GCO_USE = 0x0002,
    GCO_DEF = 0x0004,
};

enum CV
{
    CV_FAST = 0x0000,
    CV_PRUNE = 0x0001,
    CV_PARENTS = 0x0002,
    CV_POST = 0x0004,
    CV_RESTART = 0x0008,
    CV_INSNS = 0x0010,
};

enum fixtype_t // 7.2
{
    FX_NONE = 0,
    FX_INFIX = 1,
    FX_PREFIX = 2,
    FX_POSTFIX = 3,
    FX_TERNARY = 4,
};

enum opattrs_t // 7.2
{
    COI_RL = 0x00,
    COI_LR = 0x01,
    COI_INT = 0x02,
    COI_FP = 0x04,
    COI_SH = 0x08,
    COI_SGN = 0x10,
    COI_SBN = 0x20,
};

enum EXFL
{
    EXFL_CPADONE = 0x0001,
    EXFL_LVALUE = 0x0002,
    EXFL_FPOP = 0x0004,
    EXFL_ALONE = 0x0008,
    EXFL_CSTR = 0x0010,
    EXFL_PARTIAL = 0x0020,
    EXFL_UNDEF = 0x0040,
    EXFL_JUMPOUT = 0x0080,
    EXFL_VFTABLE = 0x0100,
    EXFL_ALL = 0x01FF,
};

enum CFL
{
    CFL_FINAL = 0x0001,
    CFL_HELPER = 0x0002,
    CFL_NORET = 0x0004,
};

enum ANCHOR
{
    ANCHOR_INDEX = 0x1FFFFFFF,
    ANCHOR_MASK = 0xC0000000,
    ANCHOR_CITEM = 0x00000000,
    ANCHOR_LVAR = 0x40000000,
    ANCHOR_ITP = 0x80000000,
    ANCHOR_BLKCMT = 0x20000000,
};

enum GLN
{
    GLN_CURRENT = 0x01,
    GLN_GOTO_TARGET = 0x02,
    GLN_ALL = 0x03,
};

enum CIT
{
    CIT_COLLAPSED = 0x0001,
};

enum cfs_statebits
{
    CFS_BOUNDS = 0x0001,
    CFS_TEXT = 0x0002,
    CFS_LVARS_HIDDEN = 0x0004,
    CFS_LOCKED = 0x0008,
};

enum DECOMP
{
    DECOMP_NO_WAIT = 0x0001,
    DECOMP_NO_CACHE = 0x0002,
    DECOMP_NO_FRAME = 0x0004,
    DECOMP_WARNINGS = 0x0008,
    DECOMP_ALL_BLKS = 0x0010,
    DECOMP_NO_HIDE = 0x0020,
    DECOMP_NO_XREFS = 0x0040,
    DECOMP_GXREFS_DEFLT = 0x0000,
    DECOMP_GXREFS_NOUPD = 0x0040,
    DECOMP_GXREFS_FORCE = 0x0080,
    DECOMP_VOID_MBA = 0x0100,
};

enum cmt_type_e
{
    CMT_NONE = 0x0000,
    CMT_TAIL = 0x0001,
    CMT_BLOCK1 = 0x0002,
    CMT_BLOCK2 = 0x0004,
    CMT_LVAR = 0x0008,
    CMT_FUNC = 0x0010,
    CMT_ALL = 0x001F,
};

enum VDUI
{
    VDUI_VISIBLE = 0x0001,
    VDUI_VALID = 0x0002,
};

#ifndef mbl_array_t
struct mba_t;
#define mbl_array_t mba_t
#endif

#pragma endregion hexrays.hpp

// Done :D

#endif // _ENUMS_IDASDK_H_
