#
# Table structure for table `mob_db`
#

DROP TABLE IF EXISTS `mob_db`;
CREATE TABLE `mob_db` (
  `ID` mediumint(9) unsigned NOT NULL default '0',
  `Sprite` text NOT NULL,
  `kName` text NOT NULL,
  `iName` text NOT NULL,
  `LV` tinyint(6) unsigned NOT NULL default '0',
  `HP` int(9) unsigned NOT NULL default '0',
  `SP` mediumint(9) unsigned NOT NULL default '0',
  `EXP` mediumint(9) unsigned NOT NULL default '0',
  `JEXP` mediumint(9) unsigned NOT NULL default '0',
  `Range1` tinyint(4) unsigned NOT NULL default '0',
  `ATK1` smallint(6) unsigned NOT NULL default '0',
  `ATK2` smallint(6) unsigned NOT NULL default '0',
  `DEF` smallint(6) unsigned NOT NULL default '0',
  `MDEF` smallint(6) unsigned NOT NULL default '0',
  `STR` smallint(6) unsigned NOT NULL default '0',
  `AGI` smallint(6) unsigned NOT NULL default '0',
  `VIT` smallint(6) unsigned NOT NULL default '0',
  `INT` smallint(6) unsigned NOT NULL default '0',
  `DEX` smallint(6) unsigned NOT NULL default '0',
  `LUK` smallint(6) unsigned NOT NULL default '0',
  `Range2` tinyint(4) unsigned NOT NULL default '0',
  `Range3` tinyint(4) unsigned NOT NULL default '0',
  `Scale` tinyint(4) unsigned NOT NULL default '0',
  `Race` tinyint(4) unsigned NOT NULL default '0',
  `Element` tinyint(4) unsigned NOT NULL default '0',
  `Mode` smallint(6) unsigned NOT NULL default '0',
  `Speed` smallint(6) unsigned NOT NULL default '0',
  `aDelay` smallint(6) unsigned NOT NULL default '0',
  `aMotion` smallint(6) unsigned NOT NULL default '0',
  `dMotion` smallint(6) unsigned NOT NULL default '0',
  `MEXP` mediumint(9) unsigned NOT NULL default '0',
  `ExpPer` smallint(9) unsigned NOT NULL default '0',
  `MVP1id` smallint(9) unsigned NOT NULL default '0',
  `MVP1per` smallint(9) unsigned NOT NULL default '0',
  `MVP2id` smallint(9) unsigned NOT NULL default '0',
  `MVP2per` smallint(9) unsigned NOT NULL default '0',
  `MVP3id` smallint(9) unsigned NOT NULL default '0',
  `MVP3per` smallint(9) unsigned NOT NULL default '0',
  `Drop1id` smallint(9) unsigned NOT NULL default '0',
  `Drop1per` smallint(9) unsigned NOT NULL default '0',
  `Drop2id` smallint(9) unsigned NOT NULL default '0',
  `Drop2per` smallint(9) unsigned NOT NULL default '0',
  `Drop3id` smallint(9) unsigned NOT NULL default '0',
  `Drop3per` smallint(9) unsigned NOT NULL default '0',
  `Drop4id` smallint(9) unsigned NOT NULL default '0',
  `Drop4per` smallint(9) unsigned NOT NULL default '0',
  `Drop5id` smallint(9) unsigned NOT NULL default '0',
  `Drop5per` smallint(9) unsigned NOT NULL default '0',
  `Drop6id` smallint(9) unsigned NOT NULL default '0',
  `Drop6per` smallint(9) unsigned NOT NULL default '0',
  `Drop7id` smallint(9) unsigned NOT NULL default '0',
  `Drop7per` smallint(9) unsigned NOT NULL default '0',
  `Drop8id` smallint(9) unsigned NOT NULL default '0',
  `Drop8per` smallint(9) unsigned NOT NULL default '0',
  `Drop9id` smallint(9) unsigned NOT NULL default '0',
  `Drop9per` smallint(9) unsigned NOT NULL default '0',
  `DropCardid` smallint(9) unsigned NOT NULL default '0',
  `DropCardper` smallint(9) unsigned NOT NULL default '0',
  PRIMARY KEY  (`ID`)
) ENGINE=MyISAM;

#  Monster Database
# 
#  Structure of Database :
# REPLACE INTO `mob_db` VALUES ('ID','Sprite_Name','kROName','iROName','LV','HP','SP','EXP','JEXP','Range1','ATK1','ATK2','DEF','MDEF','STR','AGI','VIT','INT','DEX','LUK','Range2','Range3','Scale','Race','Element','Mode','Speed','aDelay','aMotion','dMotion','MEXP','ExpPer','MVP1id','MVP1per','MVP2id','MVP2per','MVP3id','MVP3per','Drop1id','Drop1per','Drop2id','Drop2per','Drop3id','Drop3per','Drop4id','Drop4per','Drop5id','Drop5per','Drop6id','Drop6per','Drop7id','Drop7per','Drop8id','Drop8per','Drop9id','Drop9per','DropCardid','DropCardper');
#  Note: Keep the Sprite_Name field as it is (in the game client). You may change Name,JName field tough

REPLACE INTO `mob_db` VALUES (1001,'SCORPION','Scorpion','Scorpion',24,1109,0,287,176,1,80,135,30,0,1,24,24,5,52,5,10,12,0,4,23,0x3195,200,1564,864,576,0,0,0,0,0,0,0,0,990,70,904,5500,757,57,943,210,7041,100,508,200,625,20,0,0,0,0,4068,1);
REPLACE INTO `mob_db` VALUES (1002,'PORING','Poring','Poring',1,50,0,2,1,1,7,10,0,5,1,1,1,0,6,30,10,12,1,3,21,0x83,400,1872,672,480,0,0,0,0,0,0,0,0,909,7000,1202,100,938,400,512,1000,713,1500,512,150,619,20,0,0,0,0,4001,1);
# REPLACE INTO `mob_db` VALUES (1003,'TESTEGG','Test Egg','Test Egg',2,100000,0,10,10,0,3,9,99,0,1,99,1,1,1,1,10,12,0,4,22,0,512,0,512,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1004,'HORNET','Hornet','Hornet',8,169,0,19,15,1,22,27,5,5,6,20,8,10,17,5,10,12,0,4,24,0x1189,150,1292,792,216,0,0,0,0,0,0,0,0,992,80,939,9000,909,3500,1208,15,511,350,518,150,0,0,0,0,0,0,4019,1);
REPLACE INTO `mob_db` VALUES (1005,'FARMILIAR','Familiar','Familiar',8,155,0,28,15,1,20,28,0,0,1,12,8,5,28,0,10,12,0,2,27,0x3885,150,1276,576,384,0,0,0,0,0,0,0,0,913,5500,1105,20,2209,15,601,50,514,100,507,700,645,50,0,0,0,0,4020,1);
# REPLACE INTO `mob_db` VALUES (1006,'THIEF_BUG_LARVA','Thief Bug Larva','Thief Bug Larva',1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,651,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1007,'FABRE','Fabre','Fabre',2,63,0,3,2,1,8,11,0,0,1,2,4,0,7,5,10,12,0,4,22,0x181,400,1672,672,480,0,0,0,0,0,0,0,0,914,6500,949,500,1502,80,721,5,511,700,705,1000,1501,200,0,0,0,0,4002,1);
REPLACE INTO `mob_db` VALUES (1008,'PUPA','Pupa','Pupa',2,427,0,2,4,0,1,2,0,20,1,1,1,0,1,20,10,12,0,4,22,0x100,1000,1001,1,1,0,0,0,0,0,0,0,0,1010,80,915,5500,938,600,2102,2,935,1000,938,600,1002,200,0,0,0,0,4003,1);
REPLACE INTO `mob_db` VALUES (1009,'CONDOR','Condor','Condor',5,92,0,6,5,1,11,14,0,0,1,13,5,0,13,10,10,12,1,2,24,0x1089,150,1148,648,480,0,0,0,0,0,0,0,0,917,9000,1702,150,715,80,1750,5500,517,400,916,2000,582,600,0,0,0,0,4015,1);
REPLACE INTO `mob_db` VALUES (1010,'WILOW','Willow','Willow',4,95,0,5,4,1,9,12,5,15,1,4,8,30,9,10,10,12,1,3,22,0x81,200,1672,672,432,0,0,0,0,0,0,0,0,902,9000,1019,100,907,1500,516,700,1068,3500,1067,2000,1066,1000,0,0,0,0,4010,1);
REPLACE INTO `mob_db` VALUES (1011,'CHONCHON','Chonchon','Chonchon',4,67,0,5,4,1,10,13,10,0,1,10,4,5,12,2,10,12,0,4,24,0x181,200,1076,576,480,0,0,0,0,0,0,0,0,998,50,935,6500,909,1500,1205,55,601,100,742,5,1002,150,0,0,0,0,4009,1);
REPLACE INTO `mob_db` VALUES (1012,'RODA_FROG','Roda Frog','Roda Frog',5,133,0,6,5,1,11,14,0,5,1,5,5,5,10,5,10,12,1,5,21,0x81,200,2016,816,288,0,0,0,0,0,0,0,0,918,9000,908,500,511,300,721,7,713,2000,0,0,0,0,0,0,0,0,4014,1);
REPLACE INTO `mob_db` VALUES (1013,'WOLF','Wolf','Wolf',25,919,0,329,199,1,37,46,0,0,1,20,28,15,32,20,10,12,1,2,22,0x1089,200,1054,504,432,0,0,0,0,0,0,0,0,1011,20,920,9000,2308,10,517,650,528,1050,919,5500,578,600,0,0,0,0,4029,1);
REPLACE INTO `mob_db` VALUES (1014,'SPORE','Spore','Spore',16,510,0,66,108,1,24,48,0,5,1,12,12,5,19,8,10,12,1,3,21,0x81,200,1872,672,288,0,0,0,0,0,0,0,0,921,9000,507,800,510,50,743,10,2220,40,7033,5,578,600,0,0,0,0,4022,1);
REPLACE INTO `mob_db` VALUES (1015,'ZOMBIE','Zombie','Zombie',15,534,0,50,33,1,67,79,0,10,1,8,7,0,15,0,10,12,1,1,29,0x3885,400,2612,912,288,0,0,0,0,0,0,0,0,957,9000,724,5,938,1000,958,50,727,70,0,0,0,0,0,0,0,0,4038,1);
REPLACE INTO `mob_db` VALUES (1016,'ARCHER_SKELETON','Archer Skeleton','Archer Skeleton',31,3040,0,483,283,9,128,153,0,0,1,8,14,5,90,5,10,12,1,1,29,0x2085,300,2864,864,576,0,0,0,0,0,0,0,0,932,4500,756,70,2285,3,1708,35,1752,1000,507,1800,1701,150,0,0,0,0,4094,1);
# REPLACE INTO `mob_db` VALUES (1017,'THIEF_BUG_FEMALE','Thief Bug Female','Thief Bug Female',10,170,0,35,18,1,33,40,5,5,1,15,10,5,23,5,10,12,1,4,27,651,200,988,288,768,0,0,0,0,0,0,0,0,955,3500,910,250,1108,15,928,200,507,400,716,50,1002,400,0,0,0,0,4026,1);
REPLACE INTO `mob_db` VALUES (1018,'CREAMY','Creamy','Creamy',16,595,0,105,70,1,53,64,0,30,1,40,16,15,16,55,10,12,0,4,24,0x181,150,1136,720,840,0,0,0,0,0,0,0,0,924,9000,2322,10,518,150,602,100,2207,2,712,500,692,100,0,0,0,0,4040,1);
REPLACE INTO `mob_db` VALUES (1019,'PECOPECO','Peco Peco','Peco Peco',19,531,0,159,72,1,50,64,0,0,1,13,13,25,27,9,10,12,2,2,23,0x1089,200,1564,864,576,0,0,0,0,0,0,0,0,925,9000,2402,20,508,200,507,900,1604,100,0,0,582,1000,0,0,0,0,4031,1);
REPLACE INTO `mob_db` VALUES (1020,'MANDRAGORA','Mandragora','Mandragora',12,405,0,45,32,4,26,35,0,25,1,12,24,0,36,15,10,12,1,3,62,0x84,1000,1768,768,576,0,0,0,0,0,0,0,0,993,50,905,9000,1405,30,511,350,711,300,706,3,1967,10,0,0,0,0,4030,1);
# REPLACE INTO `mob_db` VALUES (1021,'THIEF_BUG_MALE','Thief Bug Male','Thief Bug Male',19,583,0,223,93,1,76,88,15,5,1,29,16,5,36,1,10,12,1,4,27,653,300,988,288,768,0,0,0,0,0,0,0,0,1011,40,928,5500,955,1500,1152,10,508,90,729,5,1116,50,0,0,0,0,4050,1);
# REPLACE INTO `mob_db` VALUES (1022,'WEREWOLF','Werewolf','Werewolf',80,28600,0,11813,7289,2,2560,3280,65,35,1,97,60,1,135,52,10,10,2,0,40,163,200,1500,768,652,0,0,0,0,0,0,0,0,999,500,1034,4000,984,500,985,500,7017,800,0,0,1912,300,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1023,'ORK_WARRIOR','Orc Warrior','Orc Warrior',24,1400,0,408,160,1,104,126,10,5,1,24,48,25,34,10,10,12,1,7,22,0x3885,200,1864,864,288,0,0,0,0,0,0,0,0,998,210,931,9000,756,40,2267,3,1352,10,1304,5,1301,100,0,0,0,0,4066,1);
REPLACE INTO `mob_db` VALUES (1024,'WORM_TAIL','Wormtail','Wormtail',14,426,0,59,40,2,42,51,5,0,1,14,28,5,46,5,10,12,1,3,22,0x91,200,1048,48,192,0,0,0,0,0,0,0,0,993,60,1011,25,906,5500,1408,30,508,70,721,5,10015,100,0,0,0,0,4034,1);
REPLACE INTO `mob_db` VALUES (1025,'SNAKE','Snake','Boa',15,471,0,72,48,1,46,55,0,0,1,15,15,10,35,5,10,12,1,2,22,0x81,200,1576,576,576,0,0,0,0,0,0,0,0,926,9000,1117,15,507,900,1011,35,937,800,954,1,578,600,0,0,0,0,4037,1);
REPLACE INTO `mob_db` VALUES (1026,'MUNAK','Munak','Munak',30,2872,0,601,318,1,150,230,0,0,1,15,20,5,46,15,10,12,1,1,29,0x3885,200,2468,768,288,0,0,0,0,0,0,0,0,901,9000,2264,2,2404,15,609,20,2337,1,2305,100,1558,5,0,0,0,0,4090,1);
# REPLACE INTO `mob_db` VALUES (1027,'RAPTICE','Raptice','Raptice',17,600,0,100,55,1,0,0,5,10,5,20,20,0,28,10,10,12,1,2,22,131,200,2000,1000,500,0,0,0,0,0,0,0,0,909,7000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1028,'SOLDIER_SKELETON','Soldier Skeleton','Soldier Skeleton',29,2334,0,372,226,1,221,245,10,15,1,15,22,5,40,15,10,12,1,1,29,0x3885,200,2276,576,432,0,0,0,0,0,0,0,0,932,5500,756,60,1214,12,507,700,934,10,1201,150,1216,50,0,0,0,0,4086,1);
REPLACE INTO `mob_db` VALUES (1029,'ISIS','Isis','Isis',47,7003,0,3709,1550,1,423,507,10,35,38,65,43,50,66,15,10,12,2,6,27,0x3195,200,1384,768,336,0,0,0,0,0,0,0,0,936,5335,2233,5,2603,1,733,150,732,20,954,1000,731,5,0,0,0,0,4116,1);
REPLACE INTO `mob_db` VALUES (1030,'ANACONDAQ','Anacondaq','Anacondaq',23,1109,0,300,149,1,124,157,0,0,1,23,28,10,36,5,10,12,1,2,25,0x91,200,1576,576,576,0,0,0,0,0,0,0,0,1011,50,937,9000,1455,10,926,1500,936,200,508,150,756,50,0,0,0,0,4062,1);
REPLACE INTO `mob_db` VALUES (1031,'POPORING','Poporing','Poporing',14,344,0,81,44,1,59,72,0,10,1,14,14,0,19,15,10,12,1,3,25,0x83,300,1672,672,480,0,0,0,0,0,0,0,0,938,5500,910,1500,511,500,514,200,512,5,1207,5,512,250,0,0,0,0,4033,1);
REPLACE INTO `mob_db` VALUES (1032,'VERIT','Verit','Verit',38,5272,0,835,517,1,389,469,0,5,1,19,38,0,38,20,10,12,1,1,29,0x83,250,2468,768,480,0,0,0,0,0,0,0,0,929,9000,912,700,930,1100,509,600,2609,1,2612,200,639,20,0,0,0,0,4107,1);
REPLACE INTO `mob_db` VALUES (1033,'ELDER_WILOW','Elder Willow','Elder Willow',20,693,0,163,101,1,58,70,10,30,1,20,25,35,38,30,10,12,1,3,43,0x3095,200,1372,672,432,0,0,0,0,0,0,0,0,990,50,907,9000,1019,350,757,40,2329,30,690,100,604,100,0,0,0,0,4052,1);
REPLACE INTO `mob_db` VALUES (1034,'THARA_FROG','Thara Frog','Thara Frog',22,2152,0,219,138,1,105,127,0,10,1,22,22,5,34,10,10,12,1,5,41,0x81,200,2016,816,288,0,0,0,0,0,0,0,0,1011,45,908,5500,911,600,509,30,725,5,918,2000,0,0,0,0,0,0,4058,1);
REPLACE INTO `mob_db` VALUES (1035,'HUNTER_FLY','Hunter Fly','Hunter Fly',42,5242,0,1517,952,1,246,333,25,15,33,105,32,15,72,30,10,12,0,4,44,0x3985,150,676,576,480,0,0,0,0,0,0,0,0,996,30,999,100,943,5335,912,1300,756,129,2259,1,1226,2,0,0,0,0,4115,1);
REPLACE INTO `mob_db` VALUES (1036,'GHOUL','Ghoul','Ghoul',40,5418,0,1088,622,1,420,500,5,20,1,20,29,0,45,20,10,12,1,1,49,0x3885,250,2456,912,504,0,0,0,0,0,0,0,0,958,6000,756,110,509,700,511,800,2609,60,934,150,1260,1,0,0,0,0,4110,1);
REPLACE INTO `mob_db` VALUES (1037,'SIDE_WINDER','Side Winder','Side Winder',43,4929,0,1996,993,1,240,320,5,10,38,43,40,15,115,20,10,12,1,2,25,0x3095,200,1576,576,576,0,0,0,0,0,0,0,0,954,5335,912,1400,756,134,1120,2,937,2500,926,5000,509,1000,0,0,0,0,4117,1);
REPLACE INTO `mob_db` VALUES (1038,'OSIRIS','Osiris','Osiris',78,415400,0,71500,28600,1,780,2880,10,25,1,75,30,37,86,40,10,12,1,1,89,0x37B5,100,1072,672,384,35750,10000,603,4000,608,3000,751,500,617,2000,1232,150,2235,200,1255,600,1009,1000,5053,150,1285,100,0,0,0,0,4144,1);
REPLACE INTO `mob_db` VALUES (1039,'BAPHOMET','Baphomet','Baphomet',81,668000,0,107250,37895,2,3220,4040,35,45,1,152,30,85,120,95,10,12,2,6,67,0x37B5,100,768,768,576,53625,10000,607,2000,750,500,923,5000,1466,200,2256,200,1476,50,714,500,5160,10,985,5432,984,4171,0,0,0,0,4147,1);
REPLACE INTO `mob_db` VALUES (1040,'GOLEM','Golem','Golem',25,3900,0,465,94,1,175,187,40,0,1,15,25,0,15,0,10,12,2,0,60,0x91,300,1608,816,396,0,0,0,0,0,0,0,0,999,150,953,9000,912,220,757,70,1003,210,715,200,998,350,0,0,0,0,4072,1);
REPLACE INTO `mob_db` VALUES (1041,'MUMMY','Mummy','Mummy',37,5176,0,800,602,1,305,360,0,10,28,19,32,0,63,20,10,12,1,1,49,0x3885,300,1772,72,384,0,0,0,0,0,0,0,0,930,9000,756,100,934,550,2604,1,2611,10,525,250,508,850,0,0,0,0,4106,1);
REPLACE INTO `mob_db` VALUES (1042,'STEEL_CHONCHON','Steel Chonchon','Steel Chonchon',17,530,0,109,71,1,54,65,15,0,1,43,17,5,33,10,10,12,0,4,24,0x118B,150,1076,576,480,0,0,0,0,0,0,0,0,992,90,999,30,910,2400,935,9000,943,30,998,200,1002,300,0,0,0,0,4042,1);
# REPLACE INTO `mob_db` VALUES (1043,'SEAHORES','Seahorse','Seahorse',18,1452,0,122,78,3,100,150,15,7,1,1,1,1,1,1,10,10,0,5,22,131,200,1500,800,600,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1044,'OBEAUNE','Obeaune','Obeaune',31,3952,0,644,407,1,141,165,0,40,1,31,31,55,74,85,10,12,1,5,41,0x3095,200,1872,672,288,0,0,0,0,0,0,0,0,995,13,950,9000,5014,1,2326,10,720,10,951,500,748,30,0,0,0,0,4093,1);
REPLACE INTO `mob_db` VALUES (1045,'MARC','Marc','Marc',36,6900,0,988,625,1,220,280,5,10,1,36,36,20,56,30,10,12,1,5,41,0x3885,150,1272,72,480,0,0,0,0,0,0,0,0,995,18,956,9000,756,95,951,1000,720,10,717,200,509,700,0,0,0,0,4105,1);
REPLACE INTO `mob_db` VALUES (1046,'DOPPELGANGER','Doppelganger','Doppelganger',72,249000,0,51480,10725,1,1340,1590,60,35,88,90,30,35,125,65,10,12,1,6,67,0x37B5,100,480,480,288,25740,10000,724,1500,505,6000,0,0,2317,250,1162,220,1168,150,2258,350,1411,550,985,3686,984,2700,0,0,0,0,4142,1);
REPLACE INTO `mob_db` VALUES (1047,'PECOPECO_EGG','Peco Peco Egg','Peco Peco Egg',3,420,0,4,4,0,1,2,20,20,1,1,1,0,1,20,10,12,0,0,60,0x0,1000,1001,1,1,0,0,0,0,0,0,0,0,1010,250,935,1500,2102,2,507,400,507,400,713,1800,736,10,0,0,0,0,4007,1);
REPLACE INTO `mob_db` VALUES (1048,'THIEF_BUG_EGG','Thief Bug Egg','Thief Bug Egg',4,48,0,8,4,0,13,17,20,0,1,6,4,0,14,20,10,12,0,4,27,0x100,1000,701,1,1,0,0,0,0,0,0,0,0,1010,300,915,5000,2102,2,938,600,716,100,737,10,1002,250,0,0,0,0,4012,1);
REPLACE INTO `mob_db` VALUES (1049,'PICKY','Picky','Picky',3,80,0,4,3,1,9,12,0,0,1,3,3,5,10,30,10,12,0,2,23,0x81,200,988,288,168,0,0,0,0,0,0,0,0,916,9000,949,700,2302,150,507,550,519,300,715,50,0,0,0,0,0,0,4008,1);
REPLACE INTO `mob_db` VALUES (1050,'PICKY_','Picky','Picky',4,83,0,5,4,1,8,11,20,0,1,3,3,10,11,20,10,12,0,2,23,0x81,200,988,288,168,0,0,0,0,0,0,0,0,916,9000,949,700,5015,10,507,600,519,300,715,50,10012,10,0,0,0,0,4011,1);
REPLACE INTO `mob_db` VALUES (1051,'THIEF_BUG','Thief Bug','Thief Bug',6,126,0,17,5,1,18,24,5,0,1,6,6,0,11,0,10,12,0,4,60,0x118B,150,1288,288,768,0,0,0,0,0,0,0,0,955,2500,2304,80,507,350,909,2000,2303,120,1002,250,0,0,0,0,0,0,4016,1);
REPLACE INTO `mob_db` VALUES (1052,'ROCKER','Rocker','Rocker',9,198,0,20,16,1,24,29,5,10,1,9,18,10,14,15,10,12,1,4,22,0x181,200,1864,864,540,0,0,0,0,0,0,0,0,940,9000,1916,10,2298,4,1402,80,520,10,752,10,703,10,0,0,0,0,4021,1);
REPLACE INTO `mob_db` VALUES (1053,'THIEF_BUG_','Thief Bug Female','Thief Bug Female',10,170,0,35,18,1,33,40,5,5,1,15,10,5,23,5,10,12,1,4,27,0x118B,200,988,288,768,0,0,0,0,0,0,0,0,955,3500,910,250,1108,15,928,200,507,400,716,50,1002,300,0,0,0,0,4026,1);
REPLACE INTO `mob_db` VALUES (1054,'THIEF_BUG__','Thief Bug Male','Thief Bug Male',19,583,0,223,93,1,76,88,15,5,1,29,16,5,36,0,10,12,1,4,27,0x318D,300,988,288,768,0,0,0,0,0,0,0,0,1011,40,928,5500,955,1500,1152,10,508,90,729,5,1116,50,0,0,0,0,4050,1);
REPLACE INTO `mob_db` VALUES (1055,'MUKA','Muka','Muka',17,610,0,273,120,1,40,49,5,5,15,15,30,5,20,10,10,12,2,3,22,0x81,300,1960,960,384,0,0,0,0,0,0,0,0,993,70,952,9000,713,2000,511,400,507,1000,1451,50,1002,250,0,0,0,0,4036,1);
REPLACE INTO `mob_db` VALUES (1056,'SMOKIE','Smokie','Smokie',18,641,0,134,86,1,61,72,0,10,1,18,36,25,26,35,10,12,0,2,22,0x91,200,1576,576,420,0,0,0,0,0,0,0,0,945,5500,919,5500,516,800,2213,1,754,2,912,5,729,2,0,0,0,0,4044,1);
REPLACE INTO `mob_db` VALUES (1057,'YOYO','Yoyo','Yoyo',21,879,0,280,111,1,71,82,0,0,1,24,30,35,32,55,10,12,0,2,22,0x108B,200,1054,54,384,0,0,0,0,0,0,0,0,942,9000,513,1500,508,200,7182,900,753,10,756,24,578,1000,0,0,0,0,4051,1);
REPLACE INTO `mob_db` VALUES (1058,'METALLER','Metaller','Metaller',22,926,0,241,152,1,131,159,15,30,1,22,22,20,49,50,10,12,1,4,23,0x118B,200,1708,1008,540,0,0,0,0,0,0,0,0,990,60,940,6500,911,400,757,49,707,20,935,3000,1914,10,0,0,0,0,4057,1);
REPLACE INTO `mob_db` VALUES (1059,'MISTRESS','Mistress','Mistress',74,212000,0,39325,27170,1,880,1110,40,60,50,165,60,95,70,130,10,12,0,4,84,0x37B5,100,1148,648,300,19662,10000,996,1500,526,4000,722,3000,1413,150,518,10000,2249,250,616,1000,7018,10,985,4268,16001,100,0,0,0,0,4132,1);
REPLACE INTO `mob_db` VALUES (1060,'BIGFOOT','Bigfoot','Bigfoot',25,1619,0,310,188,1,198,220,10,0,1,25,55,15,20,25,10,12,2,2,22,0x91,300,1260,192,192,0,0,0,0,0,0,0,0,948,9000,2289,5,919,5000,740,80,516,1500,518,450,756,43,0,0,0,0,4074,1);
REPLACE INTO `mob_db` VALUES (1061,'NIGHTMARE','Nightmare','Nightmare',49,4437,0,1912,1912,1,447,529,0,40,1,74,25,15,64,10,10,12,2,6,68,0x3395,150,1816,816,432,0,0,0,0,0,0,0,0,944,6000,510,500,2608,2,603,30,505,100,1261,1,984,60,0,0,0,0,4127,1);
REPLACE INTO `mob_db` VALUES (1062,'PORING_','Santa Poring','Santa Poring',3,69,0,4,5,1,12,16,0,0,1,14,3,10,12,90,10,12,1,3,26,0x81,400,1672,672,480,0,0,0,0,0,0,0,0,529,2000,530,1000,507,1000,512,1000,2236,100,512,7,0,0,0,0,0,0,4005,1);
REPLACE INTO `mob_db` VALUES (1063,'LUNATIC','Lunatic','Lunatic',3,60,0,6,2,1,9,12,0,20,1,3,3,10,8,60,10,12,0,2,60,0x81,200,1456,456,336,0,0,0,0,0,0,0,0,705,6500,949,1000,2262,4,512,2000,507,600,515,1100,622,20,0,0,0,0,4006,1);
REPLACE INTO `mob_db` VALUES (1064,'MEGALODON','Megalodon','Megalodon',24,1648,0,215,132,1,155,188,0,15,1,12,24,0,26,5,10,12,1,1,29,0x81,200,2492,792,432,0,0,0,0,0,0,0,0,959,5500,932,1500,510,80,717,120,719,10,603,2,624,20,0,0,0,0,4067,1);
REPLACE INTO `mob_db` VALUES (1065,'STROUF','Strouf','Strouf',48,11990,0,3080,2098,1,200,1250,5,50,1,40,45,92,43,65,10,12,2,5,61,0x3885,150,1872,672,384,0,0,0,0,0,0,0,0,951,5335,756,115,2241,2,1461,2,949,3000,720,20,956,1500,0,0,0,0,4111,1);
REPLACE INTO `mob_db` VALUES (1066,'VADON','Vadon','Vadon',19,1017,0,135,85,1,74,85,20,0,1,19,16,10,36,15,10,12,0,5,21,0x91,300,1632,432,540,0,0,0,0,0,0,0,0,991,40,960,9000,910,3000,2313,5,943,100,757,40,717,50,0,0,0,0,4049,1);
REPLACE INTO `mob_db` VALUES (1067,'CORNUTUS','Cornutus','Cornutus',23,1620,0,240,149,1,109,131,30,0,1,23,23,5,36,12,10,12,0,5,21,0x91,200,1248,48,480,0,0,0,0,0,0,0,0,991,45,961,5500,911,800,757,53,2106,5,943,1000,717,100,0,0,0,0,4061,1);
REPLACE INTO `mob_db` VALUES (1068,'HYDRA','Hydra','Hydra',14,660,0,59,40,7,22,28,0,40,1,14,14,0,40,2,10,12,0,3,41,0x84,1000,800,432,600,0,0,0,0,0,0,0,0,1011,25,962,5500,938,1500,971,20,525,5,517,700,0,0,0,0,0,0,4035,1);
REPLACE INTO `mob_db` VALUES (1069,'SWORD_FISH','Swordfish','Swordfish',30,4299,0,1251,638,1,168,199,5,20,1,30,30,41,62,30,10,12,2,5,41,0x3885,200,1968,768,384,0,0,0,0,0,0,0,0,995,10,963,9000,756,33,2257,2,757,50,1117,25,956,600,0,0,0,0,4089,1);
REPLACE INTO `mob_db` VALUES (1070,'KUKRE','Kukre','Kukre',11,507,0,38,28,1,28,37,15,0,1,11,11,5,16,2,10,12,0,5,21,0x83,150,1776,576,288,0,0,0,0,0,0,0,0,991,30,955,5500,910,400,528,500,507,650,928,450,623,20,0,0,0,0,4027,1);
REPLACE INTO `mob_db` VALUES (1071,'PIRATE_SKEL','Pirate Skeleton','Pirate Skeleton',25,1676,0,233,142,1,145,178,10,15,25,13,25,5,25,10,10,12,1,1,29,0x3885,200,1754,554,288,0,0,0,0,0,0,0,0,932,3000,2287,15,7477,5,2211,250,1104,250,756,43,628,20,0,0,0,0,4073,1);
REPLACE INTO `mob_db` VALUES (1072,'KAHO','Kaho','Kaho',60,8409,0,3990,450,1,110,760,5,50,1,55,43,88,80,46,10,12,1,6,83,0x3985,150,1700,1000,500,0,0,0,0,0,0,0,0,994,30,1003,150,7097,3000,690,100,757,1000,716,300,970,5,0,0,0,0,4065,1);
REPLACE INTO `mob_db` VALUES (1073,'CRAB','Crab','Crab',20,2451,0,163,101,1,71,81,35,0,18,20,15,0,36,15,7,12,0,5,21,0x81,200,992,792,360,0,0,0,0,0,0,0,0,964,5500,960,1500,7049,700,1001,13,0,0,0,0,757,37,0,0,0,0,4153,1);
REPLACE INTO `mob_db` VALUES (1074,'SHELLFISH','Shellfish','Shellfish',15,920,0,66,44,1,35,42,35,0,1,12,8,0,32,5,10,12,0,5,21,0x91,200,864,864,384,0,0,0,0,0,0,0,0,965,5500,966,1000,7049,500,1056,1000,1001,10,0,0,757,18,0,0,0,0,4273,1);
# REPLACE INTO `mob_db` VALUES (1075,'TURTLE','Turtle','Turtle',3,77,0,0,0,1,1,2,35,0,1,1,1,1,1,1,7,12,0,5,22,0x81,200,500,500,500,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1076,'SKELETON','Skeleton','Skeleton',10,234,0,18,14,1,39,47,10,10,1,5,10,0,12,0,10,12,1,1,29,0x91,200,2228,528,576,0,0,0,0,0,0,0,0,1010,90,932,800,1505,80,909,3000,507,850,2609,30,0,0,0,0,0,0,4025,1);
REPLACE INTO `mob_db` VALUES (1077,'POISON_SPORE','Poison Spore','Poison Spore',19,665,0,186,93,1,89,101,0,0,1,19,25,0,24,0,10,12,1,3,25,0x3885,200,1672,672,288,0,0,0,0,0,0,0,0,7033,9000,2221,20,511,550,510,60,972,50,921,1200,912,5,0,0,0,0,4048,1);
REPLACE INTO `mob_db` VALUES (1078,'RED_PLANT','Red Plant','Red Plant',1,10,0,0,0,1,1,2,100,99,0,0,0,0,0,0,7,12,0,3,22,0x40,2000,1,1,1,0,0,0,0,0,0,0,0,507,5500,712,1000,711,1000,905,500,906,300,914,500,708,50,2269,2,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1079,'BLUE_PLANT','Blue Plant','Blue Plant',1,10,0,0,0,1,1,2,100,99,0,0,0,0,0,0,7,12,0,3,22,0x40,2000,1,1,1,0,0,0,0,0,0,0,0,510,5500,712,1000,711,1000,905,500,906,300,522,50,514,1000,2270,2,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1080,'GREEN_PLANT','Green Plant','Green Plant',1,10,0,0,0,1,1,2,100,99,0,0,0,0,0,0,7,12,0,3,22,0x40,2000,1,1,1,0,0,0,0,0,0,0,0,511,7000,712,1000,621,20,905,3000,906,1500,704,50,521,50,2270,2,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1081,'YELLOW_PLANT','Yellow Plant','Yellow Plant',1,10,0,0,0,1,1,2,100,99,0,0,0,0,0,0,7,12,0,3,22,0x40,2000,1,1,1,0,0,0,0,0,0,0,0,508,5500,712,1000,711,1000,905,500,906,300,707,5,914,500,2269,2,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1082,'WHITE_PLANT','White Plant','White Plant',1,10,0,0,0,1,1,2,100,99,0,0,0,0,0,0,7,12,0,3,22,0x40,2000,1,1,1,0,0,0,0,0,0,0,0,509,5500,712,1000,631,20,905,3000,906,1500,521,50,703,50,2269,2,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1083,'SHINING_PLANT','Shining Plant','Shining Plant',1,20,0,0,0,1,1,2,100,99,0,0,0,0,0,90,7,12,0,3,26,0x40,2000,1,1,1,0,0,0,0,0,0,0,0,510,5500,508,1000,509,1000,710,5,608,20,518,500,607,50,714,1,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1084,'BLACK_MUSHROOM','Black Mushroom','Black Mushroom',1,15,0,0,0,1,1,2,100,99,0,0,0,0,0,0,7,12,0,3,22,0x40,2000,1,1,1,0,0,0,0,0,0,0,0,970,50,971,50,630,20,949,2000,991,800,921,5500,921,5500,7033,5500,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1085,'RED_MUSHROOM','Red Mushroom','Red Mushroom',1,15,0,0,0,1,1,2,100,99,0,0,0,0,0,0,7,12,0,3,22,0x40,2000,1,1,1,0,0,0,0,0,0,0,0,970,50,972,50,630,20,949,2000,990,1000,921,5500,921,5500,7033,5500,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1086,'GOLDEN_BUG','Golden Thief Bug','Golden Thief Bug',64,126000,0,14300,7150,1,870,1145,60,45,65,75,35,45,85,150,10,12,2,4,43,0x11AB,100,768,768,480,7150,10000,2610,2000,701,1000,0,0,969,1000,1524,150,2246,250,10016,500,714,300,985,2000,984,1500,0,0,0,0,4128,1);
REPLACE INTO `mob_db` VALUES (1087,'ORK_HERO','Orc Hero','Orc Hero',77,585700,0,58630,32890,1,2257,2542,40,45,1,91,30,70,105,90,10,12,2,7,42,0x37B5,150,1678,780,648,29315,10000,725,2000,607,1500,999,5000,968,9700,10018,500,1366,150,2106,250,1124,1000,985,4559,1387,100,0,0,0,0,4143,1);
REPLACE INTO `mob_db` VALUES (1088,'VOCAL','Vocal','Vocal',18,3016,0,110,88,1,71,82,10,30,77,28,26,30,53,40,10,12,1,4,22,0x3795,200,1080,648,480,0,0,0,0,0,0,0,0,2247,50,940,8000,721,1000,752,1500,2420,1000,645,700,1917,10,0,0,0,0,4211,1);
REPLACE INTO `mob_db` VALUES (1089,'TOAD','Toad','Toad',10,5065,0,100,50,1,26,32,0,0,1,5,10,10,10,25,10,12,1,5,21,0x37B5,200,1236,336,432,0,0,0,0,0,0,0,0,2244,50,518,2000,729,1000,746,1500,970,100,971,100,5125,1000,0,0,0,0,4306,1);
REPLACE INTO `mob_db` VALUES (1090,'MASTERING','Mastering','Mastering',2,2415,0,30,10,1,18,24,0,10,1,2,2,0,17,60,10,12,1,3,21,0x37B5,300,1072,672,480,0,0,0,0,0,0,0,0,2257,200,619,50,722,1000,2116,1000,512,8000,512,8000,531,4000,0,0,0,0,4197,1);
REPLACE INTO `mob_db` VALUES (1091,'DRAGON_FLY','Dragon Fly','Dragon Fly',8,2400,0,88,44,1,22,27,40,0,1,20,8,15,17,5,10,12,0,4,24,0x37B5,100,1076,576,480,0,0,0,0,0,0,0,0,2245,200,507,8000,719,1500,742,2000,2607,3000,625,50,533,3000,0,0,0,0,4179,1);
REPLACE INTO `mob_db` VALUES (1092,'VAGABOND_WOLF','Vagabond Wolf','Vagabond Wolf',24,12240,0,247,176,1,135,159,10,0,57,45,48,20,50,65,10,12,1,2,22,0x37B5,150,1048,648,432,0,0,0,0,0,0,0,0,2248,200,920,8000,728,1500,1148,100,2521,1000,725,10,626,50,0,0,0,0,4183,1);
REPLACE INTO `mob_db` VALUES (1093,'ECLIPSE','Eclipse','Eclipse',6,1800,0,60,55,1,20,26,0,40,1,36,6,0,11,80,10,12,1,2,60,0x37B5,200,1456,456,336,0,0,0,0,0,0,0,0,2250,200,507,8000,727,1200,746,1500,706,30,622,50,2355,1000,0,0,0,0,4266,1);
REPLACE INTO `mob_db` VALUES (1094,'AMBERNITE','Ambernite','Ambernite',13,495,0,57,38,1,39,46,30,0,1,13,13,5,18,5,10,12,2,4,21,0x191,400,2048,648,648,0,0,0,0,0,0,0,0,991,50,946,9000,910,1200,935,3000,943,2,757,14,1002,150,0,0,0,0,4032,1);
REPLACE INTO `mob_db` VALUES (1095,'ANDRE','Andre','Andre',17,688,0,109,71,1,60,71,10,0,1,17,24,20,26,20,10,12,0,4,22,0x118B,300,1288,288,384,0,0,0,0,0,0,0,0,955,9000,910,1000,938,500,993,50,1001,4,1002,350,757,28,0,0,0,0,4043,1);
REPLACE INTO `mob_db` VALUES (1096,'ANGELING','Angeling','Angeling',20,55000,0,163,144,1,120,195,0,70,1,50,20,75,68,200,10,12,1,8,86,0x37B5,200,1072,672,672,0,0,0,0,0,0,0,0,2254,100,2324,60,610,500,2282,1,509,2000,512,28,714,40,0,0,0,0,4054,1);
REPLACE INTO `mob_db` VALUES (1097,'ANT_EGG','Ant Egg','Ant Egg',4,420,0,5,4,0,1,2,20,20,1,1,1,0,1,20,10,12,0,0,60,0x0,1000,1001,1,1,0,0,0,0,0,0,0,0,1010,320,935,2000,909,2000,938,650,713,2000,1002,200,0,0,0,0,0,0,4013,1);
REPLACE INTO `mob_db` VALUES (1098,'ANUBIS','Anubis','Anubis',75,38000,0,28000,22000,1,530,1697,25,31,5,65,10,82,77,33,10,12,2,7,49,0x3695,150,1250,768,360,0,0,0,0,0,0,0,0,930,3000,1625,10,934,550,984,105,1045,4365,2617,1,1614,3,0,0,0,0,4138,1);
REPLACE INTO `mob_db` VALUES (1099,'ARGIOPE','Argiope','Argiope',41,4382,0,1797,849,1,395,480,30,0,1,41,31,10,56,30,10,12,2,4,25,0x3795,300,1792,792,336,0,0,0,0,0,0,0,0,1042,5335,912,1200,757,175,2406,5,511,1500,719,10,0,0,0,0,0,0,4114,1);
REPLACE INTO `mob_db` VALUES (1100,'ARGOS','Argos','Argos',25,1117,0,388,188,1,158,191,15,0,1,25,25,5,32,15,10,12,2,4,25,0x3195,300,1468,468,768,0,0,0,0,0,0,0,0,1025,9000,911,1200,1042,500,757,61,511,670,508,250,10017,15,0,0,0,0,4075,1);
REPLACE INTO `mob_db` VALUES (1101,'BAPHOMET_','Baphomet Jr.','Baphomet Jr.',50,8578,0,2706,1480,1,487,590,15,25,1,75,55,1,93,45,10,12,0,6,27,0x3795,100,868,480,120,0,0,0,0,0,0,0,0,923,500,984,63,1464,2,607,50,610,100,508,1300,2405,50,0,0,0,0,4129,1);
REPLACE INTO `mob_db` VALUES (1102,'BATHORY','Bathory','Bathory',44,5415,0,2503,1034,1,198,398,0,60,1,76,24,85,65,15,10,12,1,7,27,0x3695,100,1504,840,900,0,0,0,0,0,0,0,0,1001,200,1061,4850,2252,3,1611,5,1000,30,1006,15,637,20,0,0,0,0,4119,1);
REPLACE INTO `mob_db` VALUES (1103,'CARAMEL','Caramel','Caramel',23,1424,0,264,162,1,90,112,5,5,35,23,46,5,38,10,10,12,0,2,22,0x91,200,1604,840,756,0,0,0,0,0,0,0,0,1027,9000,2310,5,919,5500,1455,10,1405,15,1408,20,0,0,0,0,0,0,4063,1);
REPLACE INTO `mob_db` VALUES (1104,'COCO','Coco','Coco',17,817,0,120,78,1,56,67,0,0,24,17,34,20,24,10,10,12,0,2,22,0x91,150,1864,864,1008,0,0,0,0,0,0,0,0,1026,9000,2502,20,914,3000,919,2500,516,500,2402,25,578,600,0,0,0,0,4041,1);
REPLACE INTO `mob_db` VALUES (1105,'DENIRO','Deniro','Deniro',19,760,0,135,85,1,68,79,15,0,1,19,30,20,43,10,10,12,0,4,22,0x118B,150,1288,288,576,0,0,0,0,0,0,0,0,955,9000,910,3000,938,1200,990,50,1001,8,1002,450,757,34,0,0,0,0,4043,1);
REPLACE INTO `mob_db` VALUES (1106,'DESERT_WOLF','Desert Wolf','Desert Wolf',27,1716,0,427,266,1,169,208,0,10,56,27,45,15,56,10,10,12,1,2,23,0x308D,200,1120,420,288,0,0,0,0,0,0,0,0,1253,5,7030,5500,2311,1,517,1200,920,2000,756,53,1217,140,0,0,0,0,4082,1);
REPLACE INTO `mob_db` VALUES (1107,'DESERT_WOLF_B','Desert Wolf Baby','Baby Desert Wolf',9,164,0,20,16,1,30,36,0,0,1,9,9,5,21,40,10,12,0,2,23,0x1089,300,1600,900,240,0,0,0,0,0,0,0,0,1010,85,919,5500,2306,80,517,600,2301,200,13011,5,582,1000,0,0,0,0,4023,1);
REPLACE INTO `mob_db` VALUES (1108,'DEVIACE','Deviace','Deviace',47,20090,0,9988,7207,1,514,1024,10,20,1,47,62,48,62,25,10,12,1,5,81,0x91,400,1680,480,384,0,0,0,0,0,0,0,0,995,25,1053,9000,1054,1000,5011,2,971,200,1256,3,756,161,0,0,0,0,4125,1);
REPLACE INTO `mob_db` VALUES (1109,'DEVIRUCHI','Deviruchi','Deviruchi',46,6666,0,2662,1278,1,475,560,10,25,1,69,40,55,70,30,10,12,0,6,27,0x3795,150,980,600,384,0,0,0,0,0,0,0,0,1038,5335,1039,400,984,2,1458,2,1009,5,912,1500,756,154,0,0,0,0,4122,1);
REPLACE INTO `mob_db` VALUES (1110,'DOKEBI','Dokebi','Dokebi',33,2697,0,889,455,1,197,249,0,10,50,50,40,35,69,40,10,12,0,6,27,0x191,250,1156,456,384,0,0,0,0,0,0,0,0,1021,9000,757,150,1517,2,1613,1,969,1,1501,300,1005,5,0,0,0,0,4098,1);
REPLACE INTO `mob_db` VALUES (1111,'DRAINLIAR','Drainliar','Drainliar',24,1162,0,431,176,1,74,84,0,0,1,36,24,0,78,0,10,12,0,2,47,0x3095,250,1276,576,384,0,0,0,0,0,0,0,0,1011,60,913,3000,725,20,507,1000,7006,5500,7006,1500,756,40,0,0,0,0,4069,1);
REPLACE INTO `mob_db` VALUES (1112,'DRAKE','Drake','Drake',70,326666,0,28600,22880,1,1800,2100,20,35,85,80,49,75,79,50,10,12,1,1,29,0x37B5,400,620,420,360,14300,10000,504,5000,719,500,0,0,1127,600,1125,950,1135,150,1128,400,5019,350,985,3200,1189,100,0,0,0,0,4137,1);
REPLACE INTO `mob_db` VALUES (1113,'DROPS','Drops','Drops',3,55,0,4,3,1,10,13,0,0,1,3,3,0,12,15,10,12,1,3,23,0x83,400,1372,672,480,0,0,0,0,0,0,0,0,909,7500,1602,80,938,500,512,1100,713,1700,512,800,620,20,0,0,0,0,4004,1);
REPLACE INTO `mob_db` VALUES (1114,'DUSTINESS','Dustiness','Dustiness',21,1044,0,218,140,1,80,102,0,10,1,53,17,0,38,5,10,12,0,4,44,0x191,150,1004,504,384,0,0,0,0,0,0,0,0,1057,9000,1058,500,2291,4,928,2000,1001,10,507,1200,0,0,0,0,0,0,4056,1);
REPLACE INTO `mob_db` VALUES (1115,'EDDGA','Eddga','Eddga',65,152000,0,25025,12870,1,1215,1565,15,15,78,70,85,66,90,85,10,12,2,2,23,0x37B5,300,872,1344,432,12512,10000,1029,5000,1030,1000,994,3000,1133,150,2268,250,518,10000,1258,500,1030,250,985,2300,13046,100,0,0,0,0,4123,1);
REPLACE INTO `mob_db` VALUES (1116,'EGGYRA','Eggyra','Eggyra',24,633,0,215,220,1,85,107,20,25,1,36,24,0,32,0,10,12,1,0,48,0x91,200,1816,816,288,0,0,0,0,0,0,0,0,911,1000,5015,20,7032,550,507,1000,643,300,645,250,757,57,0,0,0,0,4070,1);
REPLACE INTO `mob_db` VALUES (1117,'EVIL_DRUID','Evil Druid','Evil Druid',58,16506,0,2890,1827,1,420,670,5,60,1,29,58,80,68,30,10,12,2,1,89,0x3695,300,2276,576,336,0,0,0,0,0,0,0,0,2217,10,1615,1,2508,2,1551,10,610,200,7478,4,509,2000,0,0,0,0,4141,1);
REPLACE INTO `mob_db` VALUES (1118,'FLORA','Flora','Flora',26,2092,0,357,226,3,242,273,10,35,1,26,35,5,43,80,10,12,2,3,22,0x84,1000,1432,432,576,0,0,0,0,0,0,0,0,1032,9000,2253,3,704,10,521,50,629,20,905,2000,748,1,0,0,0,0,4080,1);
REPLACE INTO `mob_db` VALUES (1119,'FRILLDORA','Frilldora','Frilldora',30,2023,0,529,319,1,200,239,0,10,35,30,38,15,53,30,10,12,1,2,23,0x3885,300,1540,720,432,0,0,0,0,0,0,0,0,1012,5500,757,90,903,1500,721,15,715,200,507,800,912,120,0,0,0,0,4088,1);
REPLACE INTO `mob_db` VALUES (1120,'GHOSTRING','Ghostring','Ghostring',18,73300,0,101,108,1,82,122,0,60,40,27,18,45,72,30,10,12,1,6,88,0x37B5,300,1220,1080,648,0,0,0,0,0,0,0,0,1059,5335,2274,100,2336,50,604,500,603,10,714,30,695,100,0,0,0,0,4047,1);
REPLACE INTO `mob_db` VALUES (1121,'GIEARTH','Giearth','Giearth',29,2252,0,495,301,1,154,185,10,50,25,29,46,60,64,105,10,12,0,6,22,0x191,200,1848,1296,432,0,0,0,0,0,0,0,0,997,30,1003,150,1040,5500,2286,1,2227,10,1001,100,0,0,0,0,0,0,4087,1);
REPLACE INTO `mob_db` VALUES (1122,'GOBLIN_1','Goblin','Goblin',25,1176,0,310,188,1,118,140,10,5,1,53,25,20,38,10,10,12,1,7,24,0x3695,100,1120,620,240,0,0,0,0,0,0,0,0,998,270,911,9000,756,43,2297,3,1211,10,2104,5,507,1800,0,0,0,0,4060,1);
REPLACE INTO `mob_db` VALUES (1123,'GOBLIN_2','Goblin','Goblin',24,1034,0,287,176,1,88,100,10,5,1,24,24,15,66,10,10,12,1,7,23,0x3095,150,1320,620,240,0,0,0,0,0,0,0,0,998,250,911,9000,5010,3,1511,10,2104,1,507,1550,2297,3,0,0,0,0,4060,1);
REPLACE INTO `mob_db` VALUES (1124,'GOBLIN_3','Goblin','Goblin',24,1034,0,357,176,1,132,165,10,5,1,24,24,15,24,10,10,12,1,7,25,0x308D,250,1624,624,240,0,0,0,0,0,0,0,0,998,230,911,9000,2275,3,5088,15,2104,1,507,1550,508,220,0,0,0,0,4060,1);
REPLACE INTO `mob_db` VALUES (1125,'GOBLIN_4','Goblin','Goblin',23,1359,0,264,164,1,109,131,10,5,1,23,46,15,36,10,10,12,1,7,22,0x308D,200,1624,624,240,0,0,0,0,0,0,0,0,993,100,998,170,5087,15,2263,3,1508,10,2104,1,507,1500,0,0,0,0,4060,1);
REPLACE INTO `mob_db` VALUES (1126,'GOBLIN_5','Goblin','Goblin',22,1952,0,241,152,1,105,127,10,5,1,22,22,15,32,10,10,12,1,7,21,0x308D,300,3074,1874,480,0,0,0,0,0,0,0,0,998,150,911,9000,1605,15,2104,1,5089,15,507,1500,508,220,0,0,0,0,4060,1);
REPLACE INTO `mob_db` VALUES (1127,'HODE','Hode','Hode',26,2282,0,550,300,1,146,177,0,30,1,26,42,5,49,40,10,12,1,2,42,0x81,200,1480,480,720,0,0,0,0,0,0,0,0,993,120,1055,9000,757,80,938,3000,1147,10,7021,1,632,20,0,0,0,0,4081,1);
REPLACE INTO `mob_db` VALUES (1128,'HORN','Horn','Horn',18,659,0,134,86,1,58,69,10,0,22,18,28,10,47,15,10,12,1,4,22,0x191,200,1528,528,288,0,0,0,0,0,0,0,0,993,80,1011,35,947,5500,1452,15,935,5500,943,70,0,0,0,0,0,0,4045,1);
REPLACE INTO `mob_db` VALUES (1129,'HORONG','Horong','Horong',34,1939,0,786,479,1,275,327,99,50,1,34,10,0,50,0,10,12,0,0,83,0x308D,400,1888,1152,828,0,0,0,0,0,0,0,0,953,6500,912,500,2279,5,1752,10000,757,118,633,20,970,50,0,0,0,0,4103,1);
REPLACE INTO `mob_db` VALUES (1130,'JAKK','Jakk','Jakk',38,3581,0,1408,880,1,315,382,5,30,1,38,38,43,75,45,10,12,1,0,43,0x3695,200,1180,480,648,0,0,0,0,0,0,0,0,1062,9000,912,900,985,31,2331,5,1008,5,535,1000,0,0,0,0,0,0,4109,1);
REPLACE INTO `mob_db` VALUES (1131,'JOKER','Joker','Joker',57,12450,0,3706,2362,1,621,738,10,35,1,143,47,75,98,175,10,12,2,7,84,0x3695,100,1364,864,432,0,0,0,0,0,0,0,0,912,2000,616,2,641,20,508,1000,1259,1,984,100,695,100,0,0,0,0,4139,1);
REPLACE INTO `mob_db` VALUES (1132,'KHALITZBURG','Khalitzburg','Khalitzburg',63,19276,0,4378,2750,1,875,1025,45,10,58,65,48,5,73,40,10,12,2,1,29,0x3695,350,528,1000,396,0,0,0,0,0,0,0,0,932,8000,985,191,5017,1,2108,2,1004,10,509,2000,1127,2,0,0,0,0,4136,1);
REPLACE INTO `mob_db` VALUES (1133,'KOBOLD_1','Kobold','Kobold',36,3893,0,988,625,1,265,318,15,10,1,90,36,30,52,20,10,12,1,7,44,0x308D,150,1028,528,360,0,0,0,0,0,0,0,0,999,100,1034,5335,912,700,757,25,1220,2,2104,5,0,0,0,0,0,0,4091,1);
REPLACE INTO `mob_db` VALUES (1134,'KOBOLD_2','Kobold','Kobold',31,2179,0,806,407,1,262,324,15,10,1,31,31,20,46,20,10,12,1,7,45,0x308D,200,1528,528,360,0,0,0,0,0,0,0,0,999,100,1034,5335,912,200,2104,3,508,100,2101,100,0,0,0,0,0,0,4091,1);
REPLACE INTO `mob_db` VALUES (1135,'KOBOLD_3','Kobold','Kobold',31,2179,0,644,407,1,186,216,15,10,1,31,31,20,88,20,10,12,1,7,43,0x308D,300,1228,528,360,0,0,0,0,0,0,0,0,990,35,999,100,1034,5335,912,200,1355,5,2104,3,508,100,0,0,0,0,4091,1);
# REPLACE INTO `mob_db` VALUES (1136,'KOBOLD_4','Kobold','Kobold',31,2179,0,806,407,1,262,324,15,10,1,31,31,20,46,20,10,12,1,7,45,0x31AD,200,1528,528,360,0,0,0,0,0,0,0,0,999,50,1034,5335,912,100,1355,5,2104,3,508,100,1301,150,0,0,0,0,4091,1);
# REPLACE INTO `mob_db` VALUES (1137,'KOBOLD_5','Kobold','Kobold',31,2179,0,644,407,1,186,216,15,10,1,31,31,20,88,20,10,12,1,7,43,0x31AD,300,1228,528,360,0,0,0,0,0,0,0,0,999,40,1034,5335,912,100,1514,5,2104,3,508,100,1501,150,0,0,0,0,4091,1);
REPLACE INTO `mob_db` VALUES (1138,'MAGNOLIA','Magnolia','Magnolia',26,3195,0,393,248,1,120,151,5,30,1,26,26,0,39,5,10,12,0,6,21,0x183,250,1560,360,360,0,0,0,0,0,0,0,0,7031,9000,910,800,911,100,912,10,737,40,508,400,12127,5,0,0,0,0,4076,1);
REPLACE INTO `mob_db` VALUES (1139,'MANTIS','Mantis','Mantis',26,2472,0,393,248,1,118,149,10,0,1,26,24,5,45,15,10,12,1,4,22,0x3195,200,1528,660,432,0,0,0,0,0,0,0,0,993,110,1031,9000,911,1400,757,70,943,250,721,10,507,650,0,0,0,0,4079,1);
REPLACE INTO `mob_db` VALUES (1140,'MARDUK','Marduk','Marduk',40,4214,0,1238,752,1,315,382,0,60,1,40,20,79,78,20,10,12,2,7,23,0x3095,300,1540,840,504,0,0,0,0,0,0,0,0,994,35,1045,4365,1608,10,2617,1,1614,3,691,100,642,20,0,0,0,0,4112,1);
REPLACE INTO `mob_db` VALUES (1141,'MARINA','Marina','Marina',21,2087,0,218,140,1,84,106,0,5,1,21,21,0,36,10,10,12,0,3,41,0x81,400,2280,1080,864,0,0,0,0,0,0,0,0,1052,5000,938,1500,991,45,995,2,717,200,631,20,0,0,0,0,0,0,4055,1);
REPLACE INTO `mob_db` VALUES (1142,'MARINE_SPHERE','Marine Sphere','Marine Sphere',28,3518,0,461,284,1,120,320,0,40,1,28,28,0,33,50,10,12,0,3,41,0x0,800,1201,1,1,0,0,0,0,0,0,0,0,1050,5000,1051,2500,1520,10,720,10,717,150,10003,10,0,0,0,0,0,0,4084,1);
REPLACE INTO `mob_db` VALUES (1143,'MARIONETTE','Marionette','Marionette',41,3222,0,1078,1276,1,355,422,0,25,1,62,36,44,69,45,10,12,0,6,68,0x3195,300,1480,480,1056,0,0,0,0,0,0,0,0,1060,9000,2294,5,2605,1,699,100,1520,15,2407,1,5141,3,0,0,0,0,4113,1);
REPLACE INTO `mob_db` VALUES (1144,'MARSE','Marse','Marse',31,5034,0,586,370,1,211,252,0,5,1,31,25,5,52,30,10,12,0,5,41,0x91,300,1956,756,528,0,0,0,0,0,0,0,0,1024,9000,962,3000,717,200,720,10,995,12,1007,5,514,300,0,0,0,0,4095,1);
REPLACE INTO `mob_db` VALUES (1145,'MARTIN','Martin','Martin',18,1109,0,134,86,1,52,63,0,5,12,18,30,15,15,5,10,12,0,2,42,0x81,300,1480,480,480,0,0,0,0,0,0,0,0,1017,9000,1018,500,1251,10,2225,5,5009,1,10010,10,2224,15,0,0,0,0,4046,1);
REPLACE INTO `mob_db` VALUES (1146,'MATYR','Matyr','Matyr',31,2585,0,967,407,1,134,160,0,0,1,47,38,5,64,5,10,12,1,2,27,0x3095,150,432,432,360,0,0,0,0,0,0,0,0,2618,10,528,5000,919,5500,537,400,757,100,514,200,0,0,0,0,0,0,4097,1);
REPLACE INTO `mob_db` VALUES (1147,'MAYA','Maya','Maya',81,169000,0,42900,17875,1,1800,2070,60,25,95,97,76,95,82,105,10,12,2,4,82,0x37B5,100,864,1000,480,21450,10000,730,2000,603,3000,617,2000,10006,500,2615,200,2234,200,639,500,7020,10,985,3500,2005,100,0,0,0,0,4146,1);
REPLACE INTO `mob_db` VALUES (1148,'MEDUSA','Medusa','Medusa',79,16408,0,6876,4697,1,827,1100,28,18,1,74,50,57,77,69,10,12,1,6,40,0x3795,180,1720,1320,360,0,0,0,0,0,0,0,0,1048,5335,1965,250,702,200,1973,20,722,250,967,3500,1007,3,0,0,0,0,4124,1);
REPLACE INTO `mob_db` VALUES (1149,'MINOROUS','Minorous','Minorous',52,7431,0,2750,1379,1,590,770,15,5,65,42,61,66,52,25,10,12,2,2,43,0x3095,200,1360,960,432,0,0,0,0,0,0,0,0,941,5335,756,196,1361,2,1005,10,516,1500,1301,200,568,300,0,0,0,0,4126,1);
REPLACE INTO `mob_db` VALUES (1150,'MOONLIGHT','Moonlight Flower','Moonlight Flower',67,120000,0,27500,14300,1,1200,1700,10,55,55,99,55,82,95,120,10,12,1,6,63,0x37B5,150,1276,576,288,13750,10000,1022,5000,504,1500,728,500,1477,500,1234,100,1525,150,10008,500,638,650,985,2600,1648,100,0,0,0,0,4131,1);
REPLACE INTO `mob_db` VALUES (1151,'MYST','Myst','Myst',38,3745,0,1391,688,1,365,445,0,40,1,38,18,0,53,10,10,12,2,0,25,0x3695,200,1576,576,384,0,0,0,0,0,0,0,0,5005,2,1019,800,10005,10,756,65,757,97,605,20,514,35,0,0,0,0,4108,1);
REPLACE INTO `mob_db` VALUES (1152,'ORC_SKELETON','Orc Skeleton','Orc Skeleton',28,2278,0,315,194,1,190,236,10,10,1,14,18,0,30,15,10,12,1,1,29,0x3885,200,2420,720,648,0,0,0,0,0,0,0,0,922,5500,932,3500,757,80,2299,2,1358,10,511,50,0,0,0,0,0,0,4085,1);
REPLACE INTO `mob_db` VALUES (1153,'ORC_ZOMBIE','Orc Zombie','Orc Zombie',24,1568,0,196,120,1,151,184,5,10,1,12,24,0,24,5,10,12,1,1,29,0x3885,400,2852,1152,840,0,0,0,0,0,0,0,0,1043,5500,938,3000,714,1,0,0,0,0,0,0,0,0,0,0,0,0,4071,1);
REPLACE INTO `mob_db` VALUES (1154,'PASANA','Pasana','Pasana',61,8289,0,4087,2135,1,513,682,29,35,1,73,50,61,59,43,10,12,1,7,43,0x3095,165,976,576,288,0,0,0,0,0,0,0,0,7110,4365,7121,2500,757,20,1105,500,1217,150,2522,100,0,0,0,0,0,0,4099,1);
REPLACE INTO `mob_db` VALUES (1155,'PETIT','Petite','Petite',44,6881,0,1677,1034,1,360,427,30,30,1,44,62,55,79,60,10,12,1,9,22,0x3095,200,1624,620,384,0,0,0,0,0,0,0,0,1035,5335,1037,300,756,140,509,1000,1510,150,912,1500,606,15,0,0,0,0,4118,1);
REPLACE INTO `mob_db` VALUES (1156,'PETIT_','Petite','Petite',45,5747,0,1758,1075,1,300,355,20,45,1,113,45,55,73,80,10,12,1,9,24,0x3095,150,1420,1080,528,0,0,0,0,0,0,0,0,1036,5335,1037,300,985,61,509,1000,13006,5,912,1500,606,15,0,0,0,0,4120,1);
REPLACE INTO `mob_db` VALUES (1157,'PHARAOH','Pharaoh','Pharaoh',93,445997,0,114990,41899,1,2267,3015,67,70,1,93,100,104,89,112,10,12,2,7,67,0x37B5,125,868,768,288,57495,10000,607,5500,526,5000,732,5000,7113,5820,7114,2500,1136,100,2327,150,5002,500,1552,300,1231,80,0,0,0,0,4148,1);
REPLACE INTO `mob_db` VALUES (1158,'PHEN','Phen','Phen',26,3347,0,357,226,1,138,150,0,15,1,26,26,0,88,75,10,12,1,5,41,0x91,150,2544,1344,1152,0,0,0,0,0,0,0,0,1023,5500,963,2000,720,5,517,1000,951,500,756,25,0,0,0,0,0,0,4077,1);
REPLACE INTO `mob_db` VALUES (1159,'PHREEONI','Phreeoni','Phreeoni',69,188000,0,32175,16445,1,880,1530,10,20,1,85,78,35,130,60,10,12,2,2,60,0x37B5,200,1020,1020,288,16087,10000,1008,500,730,1000,1000,4000,1015,9700,1223,500,1236,150,1014,5000,2288,300,985,2900,13047,100,0,0,0,0,4121,1);
REPLACE INTO `mob_db` VALUES (1160,'PIERE','Piere','Piere',18,733,0,122,78,1,64,75,15,0,1,18,26,20,27,15,10,12,0,4,22,0x118B,200,1288,288,576,0,0,0,0,0,0,0,0,955,9000,910,1100,938,600,992,30,1001,5,1002,400,757,31,0,0,0,0,4043,1);
REPLACE INTO `mob_db` VALUES (1161,'PLANKTON','Plankton','Plankton',10,354,0,23,18,1,26,31,0,5,1,10,10,0,15,0,10,12,0,3,61,0x81,400,2208,1008,324,0,0,0,0,0,0,0,0,1052,9000,910,300,938,700,970,4,713,1000,630,20,645,50,0,0,0,0,4024,1);
REPLACE INTO `mob_db` VALUES (1162,'RAFFLESIA','Rafflesia','Rafflesia',17,1333,0,333,333,3,105,127,0,2,1,18,24,11,37,10,10,12,0,3,22,0x3885,150,512,528,240,0,0,0,0,0,0,0,0,1033,5500,911,1600,706,2,708,10,703,10,711,550,509,30,0,0,0,0,4083,1);
REPLACE INTO `mob_db` VALUES (1163,'RAYDRIC','Raydric','Raydric',52,8613,0,3410,1795,1,830,930,40,15,58,47,42,5,69,26,10,12,2,7,47,0x3095,150,824,780,420,0,0,0,0,0,0,0,0,985,106,2266,1,2315,2,1158,2,1116,100,1004,10,7054,4850,0,0,0,0,4133,1);
REPLACE INTO `mob_db` VALUES (1164,'REQUIEM','Requiem','Requiem',35,3089,0,800,458,1,220,272,0,15,1,53,35,5,57,2,10,12,1,7,27,0x3885,400,1516,816,432,0,0,0,0,0,0,0,0,603,35,714,1,912,2500,958,3500,934,1500,2308,10,7477,1,0,0,0,0,4104,1);
REPLACE INTO `mob_db` VALUES (1165,'SAND_MAN','Sandman','Sandman',34,3413,0,810,492,1,180,205,10,25,24,34,58,38,60,5,10,12,1,0,62,0x3885,250,1672,720,288,0,0,0,0,0,0,0,0,997,35,1056,5335,757,118,7043,350,1001,200,1257,1,1622,5,0,0,0,0,4101,1);
REPLACE INTO `mob_db` VALUES (1166,'SAVAGE','Savage','Savage',26,2092,0,521,248,1,120,150,10,5,1,26,54,10,37,15,10,12,2,2,42,0x91,150,1960,960,384,0,0,0,0,0,0,0,0,1028,9000,514,300,702,2,2276,1,605,10,757,70,526,2,0,0,0,0,4078,1);
REPLACE INTO `mob_db` VALUES (1167,'SAVAGE_BABE','Savage Babe','Savage Babe',7,182,0,14,12,1,20,25,0,0,1,7,14,5,12,35,10,12,0,2,22,0x81,400,1624,624,576,0,0,0,0,0,0,0,0,919,9000,1302,100,517,500,1750,1000,949,850,1010,80,627,40,0,0,0,0,4017,1);
# REPLACE INTO `mob_db` VALUES (1168,'SCORPION_KING','Scorpion King','Scorpion King',50,6354,0,2187,1346,1,500,603,40,10,1,50,47,1,83,30,10,12,2,7,23,0x1B1,200,1700,1000,500,0,0,0,0,0,0,0,0,994,45,1046,4850,1005,15,904,5000,943,3000,509,700,0,0,0,0,0,0,4130,1);
REPLACE INTO `mob_db` VALUES (1169,'SKEL_WORKER','Skeleton Worker','Skeleton Worker',30,2872,0,397,240,1,242,288,0,15,1,15,30,5,42,10,10,12,1,1,29,0x3885,400,2420,720,384,0,0,0,0,0,0,0,0,998,400,1041,5500,757,90,5009,2,999,100,1003,200,1002,800,0,0,0,0,4092,1);
REPLACE INTO `mob_db` VALUES (1170,'SOHEE','Sohee','Sohee',33,5628,0,739,455,1,210,251,0,10,1,33,33,10,58,15,10,12,1,6,21,0x191,250,2112,912,576,0,0,0,0,0,0,0,0,1020,9000,1049,50,2277,1,2504,5,1217,5,507,1000,662,350,0,0,0,0,4100,1);
# REPLACE INTO `mob_db` VALUES (1171,'SOLDIER_ANDRE','Soldier Andre','Soldier Andre',22,1245,0,219,138,1,105,127,20,0,1,22,44,20,40,10,10,12,0,4,42,0x3095,200,1001,1,1,0,0,0,0,0,0,0,0,1014,2700,911,800,757,10,1111,15,1001,30,943,150,0,0,0,0,0,0,4059,1);
# REPLACE INTO `mob_db` VALUES (1172,'SOLDIER_DENIRO','Soldier Deniro','Soldier Deniro',29,2047,0,450,274,1,162,193,20,0,1,29,58,20,54,10,10,12,0,4,42,0x3095,200,2000,1000,500,0,0,0,0,0,0,0,0,1014,5500,911,2000,757,15,1111,20,943,270,1001,50,0,0,0,0,0,0,4059,1);
# REPLACE INTO `mob_db` VALUES (1173,'SOLDIER_PIERE','Soldier Piere','Soldier Piere',23,1217,0,240,149,1,109,131,25,0,1,23,46,20,38,10,10,12,0,4,42,0x3095,200,1001,1,1,0,0,0,0,0,0,0,0,1014,3100,911,800,911,10,1114,15,1001,35,943,200,0,0,0,0,0,0,4059,1);
REPLACE INTO `mob_db` VALUES (1174,'STAINER','Stainer','Stainer',16,538,0,105,70,1,53,64,10,0,1,40,16,5,30,5,10,12,0,4,24,0x191,200,1688,1188,612,0,0,0,0,0,0,0,0,992,70,1011,30,1013,9000,910,2100,757,25,943,10,1002,300,0,0,0,0,4039,1);
REPLACE INTO `mob_db` VALUES (1175,'TAROU','Tarou','Tarou',11,284,0,57,28,1,34,45,0,0,1,20,11,10,24,5,10,12,0,2,27,0x91,150,1744,1044,684,0,0,0,0,0,0,0,0,1016,9000,919,3000,949,800,528,1000,701,2,0,0,0,0,0,0,0,0,4028,1);
REPLACE INTO `mob_db` VALUES (1176,'VITATA','Vitata','Vitata',20,894,0,163,101,1,69,80,15,20,1,20,25,65,40,70,10,12,0,4,22,0x191,300,1768,768,384,0,0,0,0,0,0,0,0,993,90,955,5000,911,200,518,350,518,350,526,200,756,26,0,0,0,0,4053,1);
REPLACE INTO `mob_db` VALUES (1177,'ZENORC','Zenorc','Zenorc',31,2585,0,967,407,1,188,223,0,15,1,77,15,0,76,10,10,12,1,7,27,0x83,150,1180,480,360,0,0,0,0,0,0,0,0,1044,5500,756,70,938,2500,1006,5,508,100,640,20,0,0,0,0,0,0,4096,1);
REPLACE INTO `mob_db` VALUES (1178,'ZEROM','Zerom','Zerom',23,1109,0,240,149,1,127,155,0,10,1,23,23,5,42,0,10,12,1,7,23,0x3885,200,1780,1080,432,0,0,0,0,0,0,0,0,1011,55,998,190,2339,200,2265,3,2408,10,1002,300,1002,300,0,0,0,0,4064,1);
REPLACE INTO `mob_db` VALUES (1179,'WHISPER','Whisper','Whisper',34,1796,0,591,599,1,180,221,0,45,1,51,14,0,60,0,10,12,0,6,68,0x3195,150,1960,960,504,0,0,0,0,0,0,0,0,1001,150,1059,5335,2282,1,2333,10,0,0,0,0,0,0,0,0,0,0,4102,1);
REPLACE INTO `mob_db` VALUES (1180,'NINE_TAIL','Nine Tail','Nine Tail',51,7766,0,2812,825,1,610,734,10,25,1,80,46,1,74,85,10,12,1,2,63,0x3695,150,840,540,480,0,0,0,0,0,0,0,0,1022,4656,746,200,603,100,604,100,526,250,525,350,756,100,0,0,0,0,4159,1);
# REPLACE INTO `mob_db` VALUES (1181,'ZOMBIE_DRAGON','Zombie Dragon','Zombie Dragon',1,1000,0,49500,1650,3,7900,9140,0,0,120,145,145,145,130,120,10,12,2,9,89,0x37B5,400,2700,1000,500,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1182,'THIEF_MUSHROOM','Thief Mushroom','Thief Mushroom',1,15,0,0,0,1,1,2,100,99,0,0,0,0,0,0,7,12,0,3,22,0x40,2000,1,1,1,0,0,0,0,0,0,0,0,1069,1500,1070,3000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1183,'CHONCHON_','Chonchon','Chonchon',4,67,0,5,4,1,10,13,10,0,1,10,4,5,12,2,10,12,0,4,24,0x3985,200,1076,576,480,0,0,0,0,0,0,0,0,998,50,935,5500,909,1500,1205,55,601,100,742,5,0,0,0,0,0,0,4009,1);
REPLACE INTO `mob_db` VALUES (1184,'FABRE_','Fabre','Fabre',1,30,0,1,0,1,4,7,0,0,1,2,1,1,4,5,10,12,0,4,22,0x3985,400,1672,672,480,0,0,0,0,0,0,0,0,914,2000,949,250,1502,80,721,2,511,350,705,500,1501,200,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1185,'WHISPER_','Whisper','Whisper',34,1796,0,537,545,1,198,239,0,45,1,51,14,0,60,0,10,12,0,1,28,0x0,150,1960,960,504,0,0,0,0,0,0,0,0,1001,10,1059,100,0,0,2333,1,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1186,'WHISPER_BOSS','Giant Whisper','Giant Whisper',34,5040,0,537,545,1,198,239,0,45,1,51,14,0,60,0,10,12,0,6,48,0x3795,250,2536,1536,672,0,0,0,0,0,0,0,0,1001,150,1059,5335,2282,1,2333,10,0,0,0,0,0,0,0,0,0,0,4303,1);
REPLACE INTO `mob_db` VALUES (1187,'SWITCH','Switch','Switch',1,2,0,1,1,1,1,2,0,0,1,1,1,0,1,0,1,12,1,0,20,0x0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1188,'BON_GUN','Bongun','Bongun',32,3520,0,424,242,1,220,260,0,0,45,15,36,10,48,15,10,12,1,1,29,0x3095,200,1720,500,420,0,0,0,0,0,0,0,0,1094,5500,7014,40,618,60,5046,1,609,15,508,1000,508,1250,0,0,0,0,4212,1);
REPLACE INTO `mob_db` VALUES (1189,'ORC_ARCHER','Orc Archer','Orc Archer',49,7440,0,1729,1787,9,310,390,10,5,1,44,25,20,125,20,10,12,1,7,22,0x3095,300,1960,620,480,0,0,0,0,0,0,0,0,1063,4656,1753,1000,1756,2500,1755,2500,1734,2,507,1400,509,900,0,0,0,0,4256,1);
REPLACE INTO `mob_db` VALUES (1190,'ORC_LORD','Orc Lord','Orc Lord',74,783000,0,62205,8580,1,3700,4150,40,5,85,82,30,70,110,85,10,12,2,7,82,0x37B5,100,1248,500,360,31102,10000,968,5500,617,2000,0,0,1363,200,2601,500,5007,150,1371,400,617,1000,985,4268,16000,3100,0,0,0,0,4135,1);
REPLACE INTO `mob_db` VALUES (1191,'MIMIC','Mimic','Mimic',51,6120,182,165,165,1,150,900,10,40,44,121,1,60,75,110,10,12,1,0,60,0x3095,100,972,500,288,0,0,0,0,0,0,0,0,617,5,603,45,1065,1200,611,3000,714,3,2626,1,757,270,0,0,0,0,4205,1);
REPLACE INTO `mob_db` VALUES (1192,'WRAITH','Wraith','Wraith',53,10999,0,2199,1099,1,580,760,5,30,1,95,30,65,95,35,10,12,2,1,89,0x3695,300,1816,576,240,0,0,0,0,0,0,0,0,1059,5820,2206,10,2506,2,716,650,602,1300,2505,10,731,5,0,0,0,0,4190,1);
REPLACE INTO `mob_db` VALUES (1193,'ALARM','Alarm','Alarm',58,10647,0,3987,2300,1,480,600,15,15,1,62,72,10,85,45,10,12,1,0,60,0x3695,300,1020,500,768,0,0,0,0,0,0,0,0,1095,5335,2607,1,7005,1500,611,1300,984,105,7026,20,912,1500,0,0,0,0,4244,1);
REPLACE INTO `mob_db` VALUES (1194,'ARCLOUSE','Arclouse','Arclouze',59,6075,0,860,1000,1,570,640,10,15,1,75,5,5,75,50,10,12,1,4,42,0x3195,100,960,500,480,0,0,0,0,0,0,0,0,1096,3500,938,3000,943,800,912,450,716,300,997,20,912,2500,0,0,0,0,4240,1);
REPLACE INTO `mob_db` VALUES (1195,'RIDEWORD','Rideword','Rideword',59,11638,0,2007,3106,1,584,804,5,35,48,75,10,20,120,45,10,12,0,0,60,0x3695,150,864,500,192,0,0,0,0,0,0,0,0,1097,4850,1553,4,1554,4,1555,2,1556,2,7015,300,1006,20,0,0,0,0,4185,1);
REPLACE INTO `mob_db` VALUES (1196,'SKEL_PRISONER','Skeleton Prisoner','Skeleton Prisoner',52,8691,0,2466,1562,1,660,890,10,20,55,20,36,0,76,25,10,12,1,1,69,0x308D,350,1848,500,576,0,0,0,0,0,0,0,0,1098,3500,7016,100,2320,1,716,600,930,3500,2408,35,934,1500,0,0,0,0,4222,1);
REPLACE INTO `mob_db` VALUES (1197,'ZOMBIE_PRISONER','Zombie Prisoner','Zombie Prisoner',53,11280,0,2635,1724,1,780,930,10,20,1,24,39,0,72,25,10,12,1,1,69,0x308D,350,1768,500,192,0,0,0,0,0,0,0,0,1099,3500,7016,105,2266,1,716,600,930,3500,2408,39,985,112,0,0,0,0,4275,1);
REPLACE INTO `mob_db` VALUES (1198,'DARK_PRIEST','Dark Priest','Dark Priest',79,101992,0,12192,5152,2,1238,2037,56,70,5,91,41,101,103,42,10,12,1,6,89,0x31AD,200,864,1252,476,0,0,0,0,0,0,0,0,1557,5,2608,30,505,100,716,450,1009,50,2319,5,1241,1,0,0,0,0,4171,1);
REPLACE INTO `mob_db` VALUES (1199,'PUNK','Punk','Punk',43,3620,0,1699,1033,1,292,365,0,45,1,105,5,45,65,20,10,12,0,3,24,0x3095,300,1500,500,1000,0,0,0,0,0,0,0,0,7001,5335,715,800,10004,100,1061,1000,1057,3000,601,1100,2502,15,0,0,0,0,4313,1);
REPLACE INTO `mob_db` VALUES (1200,'ZHERLTHSH','Zherlthsh','Zealotus',63,18300,0,3608,2304,1,700,850,10,15,70,85,40,30,125,60,10,12,1,7,60,0x308D,200,800,2112,768,0,0,0,0,0,0,0,0,7017,5,509,1800,7293,1500,2331,8,2622,1,1970,100,2291,3,0,0,0,0,4277,1);
REPLACE INTO `mob_db` VALUES (1201,'RYBIO','Rybio','Rybio',71,9572,0,6317,3520,1,686,912,45,37,1,97,75,74,77,90,10,12,2,6,40,0x318D,200,1790,1440,540,0,0,0,0,0,0,0,0,1015,3880,7017,3,509,1800,731,30,1008,10,984,100,709,30,0,0,0,0,4194,1);
REPLACE INTO `mob_db` VALUES (1202,'PHENDARK','Phendark','Phendark',73,22729,0,6826,3443,2,794,1056,52,36,1,62,120,65,76,66,10,12,2,7,40,0x308D,175,1744,1344,600,0,0,0,0,0,0,0,0,1015,3880,7017,4,509,1800,0,0,984,150,1971,100,0,0,0,0,0,0,4329,1);
REPLACE INTO `mob_db` VALUES (1203,'MYSTELTAINN','Mysteltainn','Mysteltainn',76,33350,0,6457,5159,2,1160,1440,30,30,77,139,80,35,159,65,10,12,2,0,87,0x37B5,250,1152,500,240,0,0,0,0,0,0,0,0,7019,1,7297,1500,1152,70,1155,40,1163,2,999,120,984,243,0,0,0,0,4207,1);
REPLACE INTO `mob_db` VALUES (1204,'TIRFING','Tirfing','Ogretooth',71,29900,0,5412,4235,1,950,1146,30,35,58,87,55,35,132,65,10,12,1,0,67,0x37B5,100,816,500,240,0,0,0,0,0,0,0,0,7022,1,638,50,7292,1500,1214,70,1217,40,999,120,984,189,0,0,0,0,4254,1);
REPLACE INTO `mob_db` VALUES (1205,'EXECUTIONER','Executioner','Executioner',65,28980,0,4730,3536,2,570,950,35,35,64,85,40,25,88,60,10,12,2,0,47,0x37B5,200,768,500,384,0,0,0,0,0,0,0,0,7024,5,7290,1500,1111,80,1114,60,1125,40,999,120,984,145,0,0,0,0,4250,1);
REPLACE INTO `mob_db` VALUES (1206,'ANOLIAN','Anolian','Anolian',61,18960,0,5900,3700,1,640,980,15,15,1,43,58,25,80,65,10,12,1,5,41,0x3695,190,900,500,864,0,0,0,0,0,0,0,0,7003,4850,1754,2000,526,5,10019,10,943,5335,2625,1,984,134,0,0,0,0,4234,1);
REPLACE INTO `mob_db` VALUES (1207,'STING','Sting','Sting',61,9500,0,4081,2970,1,850,1032,5,30,57,45,55,5,120,85,10,12,1,0,62,0x3695,300,528,500,240,0,0,0,0,0,0,0,0,7004,4850,1756,1500,2624,1,1003,130,997,25,10007,10,719,3,0,0,0,0,4226,1);
REPLACE INTO `mob_db` VALUES (1208,'WANDER_MAN','Wander Man','Wanderer',74,8170,0,5786,4730,2,450,1170,5,5,1,192,38,45,127,85,10,12,1,6,24,0x3795,100,672,500,192,0,0,0,0,0,0,0,0,7005,4850,616,1,13015,5,2270,5,610,650,984,217,1164,1,0,0,0,0,4210,1);
REPLACE INTO `mob_db` VALUES (1209,'CRAMP','Cramp','Cramp',56,4720,0,2300,1513,1,395,465,0,5,1,85,35,5,65,60,10,12,0,2,45,0x3095,100,1000,500,1000,0,0,0,0,0,0,0,0,7007,4656,528,1000,726,80,746,110,568,250,510,70,984,95,0,0,0,0,4296,1);
# REPLACE INTO `mob_db` VALUES (1210,'FILAMENTOUS','Filamentous','Filamentous',51,6088,0,1926,1353,1,425,525,35,10,1,35,30,5,83,40,10,12,1,4,23,0x3095,200,1500,500,1000,0,0,0,0,0,0,0,0,7008,4850,947,8000,943,3880,993,200,1451,40,757,18,509,1600,0,0,0,0,4045,1);
REPLACE INTO `mob_db` VALUES (1211,'BRILIGHT','Brilight','Brilight',46,5562,0,1826,1331,1,298,383,30,5,1,90,15,10,50,35,10,12,0,4,23,0x3195,200,1500,500,1000,0,0,0,0,0,0,0,0,7009,5335,992,200,912,1200,602,1000,757,220,610,250,509,2600,0,0,0,0,4213,1);
REPLACE INTO `mob_db` VALUES (1212,'IRON_FIST','Iron Fist','Iron Fist',47,4221,0,1435,1520,1,430,590,40,5,1,25,15,10,81,20,10,12,1,4,60,0x3195,200,1500,500,1000,0,0,0,0,0,0,0,0,7010,5335,757,229,757,22,1002,750,999,180,998,300,0,0,0,0,0,0,4239,1);
REPLACE INTO `mob_db` VALUES (1213,'HIGH_ORC','High Orc','High Orc',52,6890,0,3618,1639,1,428,533,15,5,55,46,55,35,82,40,10,12,2,7,43,0x3695,150,1500,500,1000,0,0,0,0,0,0,0,0,7002,2500,1304,10,999,90,931,7500,912,1300,756,196,508,900,0,0,0,0,4322,1);
REPLACE INTO `mob_db` VALUES (1214,'CHOCO','Choco','Choco',43,4278,0,1265,1265,1,315,402,5,5,65,68,55,45,65,25,10,12,0,2,23,0x3095,200,1500,500,1000,0,0,0,0,0,0,0,0,7011,5335,942,7000,985,53,513,5000,634,20,532,1000,607,25,0,0,0,0,4285,1);
REPLACE INTO `mob_db` VALUES (1215,'STEM_WORM','Stem Worm','Stem Worm',40,6136,0,1452,939,2,290,375,5,10,1,30,26,15,79,35,10,12,1,3,24,0x3095,200,1500,500,1000,0,0,0,0,0,0,0,0,7012,5335,509,1800,1968,10,756,115,997,5,1454,20,608,45,0,0,0,0,4224,1);
REPLACE INTO `mob_db` VALUES (1216,'PENOMENA','Penomena','Penomena',57,7256,0,2870,2200,7,415,565,5,50,1,5,35,15,136,30,10,12,1,5,25,0x3695,400,832,500,600,0,0,0,0,0,0,0,0,7013,4850,962,8000,938,7000,525,200,719,15,1258,1,716,550,0,0,0,0,4314,1);
REPLACE INTO `mob_db` VALUES (1219,'KNIGHT_OF_ABYSS','Knight of Abyss','Abysmal Knight',79,36140,0,8469,6268,1,1600,2150,55,50,66,68,64,25,135,50,10,12,2,7,87,0x3695,300,1500,500,1000,0,0,0,0,0,0,0,0,1064,5335,7023,5,2318,1,1421,25,1162,1,985,369,984,259,0,0,0,0,4140,1);
REPLACE INTO `mob_db` VALUES (1220,'M_DESERT_WOLF','Desert Wolf','Desert Wolf',27,1716,0,388,242,1,169,208,0,10,1,27,45,15,56,10,10,12,1,2,23,0x3695,200,1120,420,288,0,0,0,0,0,0,0,0,1253,5,7030,5500,2311,1,517,1200,920,2000,756,53,0,0,0,0,0,0,4082,1);
REPLACE INTO `mob_db` VALUES (1221,'M_SAVAGE','Savage','Savage',26,2092,0,357,226,1,146,177,10,5,1,26,54,10,37,10,10,12,2,2,42,0x3695,150,1960,960,384,0,0,0,0,0,0,0,0,1028,6000,514,150,702,3,2276,2,605,15,757,70,0,0,0,0,0,0,4078,1);
# REPLACE INTO `mob_db` VALUES (1222,'L_HIGH_ORC','High Orc','High Orc',52,6890,0,2128,1490,1,428,533,15,5,1,46,55,35,82,40,10,12,2,7,43,0x3695,200,1500,500,1000,0,0,0,0,0,0,0,0,7002,2500,1304,10,999,120,931,8000,912,1600,756,196,508,1100,0,0,0,0,4066,1);
# REPLACE INTO `mob_db` VALUES (1223,'L_ORC','Orc','Orc',24,1400,0,261,160,1,114,136,10,5,1,24,48,25,34,10,10,12,1,7,22,0x3695,200,1864,864,288,0,0,0,0,0,0,0,0,998,210,931,5500,756,40,2267,3,1352,10,1304,5,1301,100,0,0,0,0,4066,1);
# REPLACE INTO `mob_db` VALUES (1224,'L_POISON_SPORE','Poison Spore','Poison Spore',19,665,0,169,85,1,89,101,0,0,1,19,25,1,24,1,10,12,1,3,25,0x3695,200,1672,672,288,0,0,0,0,0,0,0,0,921,8000,2221,20,511,650,510,55,972,35,0,0,0,0,0,0,0,0,4048,1);
# REPLACE INTO `mob_db` VALUES (1225,'L_CHOCO','Choco','Choco',43,4278,0,1150,1150,1,315,402,5,5,1,68,55,45,65,25,10,12,0,2,23,0x3695,200,1500,500,1000,0,0,0,0,0,0,0,0,7011,5335,942,7000,508,1900,513,5000,2311,2,532,1000,607,25,0,0,0,0,4051,1);
# REPLACE INTO `mob_db` VALUES (1226,'L_KOBOLD','Kobold','Kobold',36,3893,0,898,568,1,265,318,15,10,1,90,36,30,52,30,10,12,1,7,44,0x3695,200,1028,528,360,0,0,0,0,0,0,0,0,999,90,1034,5820,912,750,985,25,1220,2,2104,5,0,0,0,0,0,0,4091,1);
# REPLACE INTO `mob_db` VALUES (1227,'L_GOBLIN','Goblin','Goblin',25,1176,0,282,171,1,118,140,10,5,1,63,25,20,38,45,10,12,1,7,24,0x3695,100,1120,620,240,0,0,0,0,0,0,0,0,998,270,911,1200,756,43,2297,3,1211,10,2104,5,507,800,0,0,0,0,4060,1);
# REPLACE INTO `mob_db` VALUES (1228,'L_PHEN','Phen','Phen',26,3347,0,357,226,1,138,150,0,15,1,26,26,1,88,75,10,12,1,5,41,0x3695,150,2544,1344,1152,0,0,0,0,0,0,0,0,1023,6000,963,2300,720,8,517,1100,951,550,756,25,0,0,0,0,0,0,4077,1);
REPLACE INTO `mob_db` VALUES (1229,'META_FABRE','Fabre','Fabre',2,63,0,3,2,1,8,11,0,0,1,2,4,0,7,5,10,12,0,4,22,0x181,400,1672,672,480,0,0,0,0,0,0,0,0,914,6500,949,600,1502,80,721,8,511,750,705,1500,1501,200,0,0,0,0,4002,1);
REPLACE INTO `mob_db` VALUES (1230,'META_PUPA','Pupa','Pupa',2,427,0,2,4,0,1,2,20,20,1,1,1,0,1,20,10,12,0,4,22,0x100,1000,1001,1,1,0,0,0,0,0,0,0,0,1010,300,915,6000,938,700,2102,2,935,1300,938,700,1002,300,0,0,0,0,4003,1);
REPLACE INTO `mob_db` VALUES (1231,'META_CREAMY','Creamy','Creamy',16,595,0,96,64,1,53,64,0,30,1,40,16,15,16,55,10,12,0,4,24,0x181,200,1220,720,288,0,0,0,0,0,0,0,0,924,6000,2322,10,518,180,602,200,2207,4,712,800,0,0,0,0,0,0,4040,1);
REPLACE INTO `mob_db` VALUES (1232,'META_PECOPECO_EGG','Peco Peco Egg','Peco Peco Egg',3,420,0,4,4,0,1,2,20,20,1,1,1,0,1,20,10,12,0,0,60,0x0,1000,1001,1,1,0,0,0,0,0,0,0,0,1010,120,935,1500,2102,2,507,450,507,450,713,2000,736,15,0,0,0,0,4007,1);
# REPLACE INTO `mob_db` VALUES (1233,'CONCEIVE_PECOPECO','Peco Peco','Peco Peco',19,531,0,159,36,1,50,64,0,0,1,13,13,25,27,9,10,12,2,2,23,0x81,200,1564,864,576,0,0,0,0,0,0,0,0,925,6000,2402,20,508,55,507,950,1604,100,0,0,582,1000,0,0,0,0,4031,1);
REPLACE INTO `mob_db` VALUES (1234,'PROVOKE_YOYO','Yoyo','Yoyo',19,879,0,135,85,1,71,82,0,0,1,24,30,35,32,55,10,12,0,2,22,0x108B,200,1054,54,384,0,0,0,0,0,0,0,0,942,6000,7182,500,508,130,919,5500,753,7,578,500,582,1000,0,0,0,0,4051,1);
REPLACE INTO `mob_db` VALUES (1235,'SMOKING_ORC','Smoking Orc','Smoking Orc',24,1400,0,261,160,1,114,136,10,20,1,24,48,20,34,0,10,12,1,7,22,0x308D,200,1864,864,288,0,0,0,0,0,0,0,0,998,210,931,5500,756,40,2267,3,1352,10,1304,5,1301,100,0,0,0,0,4066,1);
REPLACE INTO `mob_db` VALUES (1236,'META_ANT_EGG','Ant Egg','Ant Egg',4,420,0,5,4,0,1,2,20,20,1,1,1,0,1,20,10,12,0,0,60,0x0,1000,1001,1,1,0,0,0,0,0,0,0,0,1010,135,935,2740,909,3000,938,750,713,2000,1002,220,0,0,0,0,0,0,4013,1);
REPLACE INTO `mob_db` VALUES (1237,'META_ANDRE','Andre','Andre',17,688,0,109,71,1,60,71,10,0,1,17,24,20,26,20,10,12,0,4,22,0x118B,300,1288,288,576,0,0,0,0,0,0,0,0,955,6000,910,3000,938,1000,935,3000,1001,6,1002,350,757,28,0,0,0,0,4043,1);
REPLACE INTO `mob_db` VALUES (1238,'META_PIERE','Piere','Piere',18,733,0,122,78,1,64,75,15,0,1,18,26,20,27,15,10,12,0,4,22,0x118B,200,1288,288,576,0,0,0,0,0,0,0,0,955,5700,910,1100,938,600,992,15,1001,5,1002,400,757,31,0,0,0,0,4043,1);
REPLACE INTO `mob_db` VALUES (1239,'META_DENIRO','Deniro','Deniro',19,760,0,135,85,1,68,79,15,0,1,19,30,20,43,10,10,12,0,4,22,0x118B,150,1288,288,576,0,0,0,0,0,0,0,0,955,6000,910,3000,938,1200,990,45,1001,8,1002,450,757,34,0,0,0,0,4043,1);
REPLACE INTO `mob_db` VALUES (1240,'META_PICKY','Picky','Picky',3,80,0,4,3,1,9,12,0,0,1,3,3,0,10,30,10,12,0,2,23,0x81,200,988,288,168,0,0,0,0,0,0,0,0,916,6500,949,850,2302,150,507,650,519,350,715,60,0,0,0,0,0,0,4008,1);
REPLACE INTO `mob_db` VALUES (1241,'META_PICKY_','Picky','Picky',4,83,0,5,4,1,8,11,20,0,1,3,3,0,11,20,10,12,0,2,23,0x81,200,988,288,168,0,0,0,0,0,0,0,0,916,6500,949,850,5015,7,507,750,519,350,715,60,0,0,0,0,0,0,4011,1);
REPLACE INTO `mob_db` VALUES (1242,'MARIN','Marin','Marin',15,742,0,66,44,1,39,43,0,10,1,10,10,5,35,15,10,12,1,3,41,0x81,400,1872,672,480,0,0,0,0,0,0,0,0,910,3200,938,1500,700,100,720,40,510,75,529,350,5035,1,0,0,0,0,4196,1);
REPLACE INTO `mob_db` VALUES (1243,'SASQUATCH','Sasquatch','Sasquatch',30,3163,0,529,319,1,250,280,5,0,75,25,60,10,34,20,10,12,2,2,60,0x3695,300,1260,192,192,0,0,0,0,0,0,0,0,912,750,509,800,949,1000,5030,1,948,5000,727,30,757,90,0,0,0,0,4216,1);
REPLACE INTO `mob_db` VALUES (1244,'JAKK_XMAS','Christmas Jakk','Christmas Jakk',38,3581,0,1113,688,1,315,382,5,30,1,38,38,43,75,45,10,12,1,0,43,0x81,200,1180,480,648,0,0,0,0,0,0,0,0,1062,5335,912,900,985,31,2331,5,644,20,7175,1200,7174,1200,0,0,0,0,4109,1);
REPLACE INTO `mob_db` VALUES (1245,'GOBLINE_XMAS','Christmas Goblin','Christmas Goblin',25,1176,0,282,171,1,118,140,10,5,1,53,25,20,38,45,10,12,1,7,24,0x81,100,1120,620,240,0,0,0,0,0,0,0,0,7174,550,7175,550,756,43,644,10,1211,10,2104,5,2236,10,0,0,0,0,4060,1);
REPLACE INTO `mob_db` VALUES (1246,'COOKIE_XMAS','Christmas Cookie','Christmas Cookie',28,2090,0,461,284,1,140,170,0,50,1,24,30,53,45,100,10,12,0,7,46,0x91,400,1248,1248,240,0,0,0,0,0,0,0,0,538,1500,722,45,912,200,2502,25,644,5,688,100,507,1700,0,0,0,0,4235,1);
REPLACE INTO `mob_db` VALUES (1247,'ANTONIO','Antonio','Antonio',10,10,0,3,2,1,13,20,100,0,1,1,1,50,100,100,10,12,1,3,66,0xC1,100,720,720,432,0,0,0,0,0,0,0,0,7034,10000,644,200,538,1500,539,1000,529,5500,530,5500,2236,250,0,0,0,0,4243,1);
REPLACE INTO `mob_db` VALUES (1248,'CRUISER','Cruiser','Cruiser',35,2820,0,1100,450,7,175,215,5,5,1,40,10,10,90,25,10,12,1,0,60,0x2085,400,1296,1296,432,0,0,0,0,0,0,0,0,1098,900,2251,2,998,320,996,5,911,3500,13150,5,756,87,0,0,0,0,4297,1);
REPLACE INTO `mob_db` VALUES (1249,'MYSTCASE','Myst Case','Myst Case',38,3450,0,1113,688,1,160,360,5,10,65,50,25,5,48,75,10,12,1,0,60,0x91,400,1248,1248,432,0,0,0,0,0,0,0,0,530,90,912,1500,603,20,539,800,722,150,731,5,529,340,0,0,0,0,4206,1);
REPLACE INTO `mob_db` VALUES (1250,'CHEPET','Chepet','Chepet',42,4950,0,1518,946,1,380,440,0,25,1,72,35,71,65,85,10,12,1,7,23,0x3695,400,672,672,288,0,0,0,0,0,0,0,0,7035,2500,912,750,512,5500,619,40,10019,5,508,1300,2508,5,0,0,0,0,4284,1);
REPLACE INTO `mob_db` VALUES (1251,'KNIGHT_OF_WINDSTORM','Knight of Windstorm','Stormy Knight',77,240000,0,64350,21450,2,1425,1585,35,60,75,185,83,55,130,79,10,12,2,0,84,0x37B5,200,468,468,288,32175,10000,720,4500,2406,500,995,3000,1468,150,603,3000,617,4000,2621,200,2506,500,985,4559,5007,1,0,0,0,0,4318,1);
REPLACE INTO `mob_db` VALUES (1252,'GARM','Garm','Garm',73,197000,0,50050,20020,3,1700,1900,40,45,85,126,82,65,95,60,10,12,2,2,81,0x37B5,400,608,408,336,25025,10000,7036,1000,603,3000,995,3000,7036,5500,1131,150,1256,500,1815,500,0,0,985,3977,984,2900,0,0,0,0,4324,1);
REPLACE INTO `mob_db` VALUES (1253,'GARGOYLE','Gargoyle','Gargoyle',48,3950,0,1650,1650,9,290,360,10,10,15,61,20,20,126,40,10,12,1,6,64,0x2185,200,1020,720,384,0,0,0,0,0,0,0,0,912,3880,1039,500,0,0,0,0,2619,1,1769,2000,757,238,0,0,0,0,4149,1);
REPLACE INTO `mob_db` VALUES (1254,'RAGGLER','Raggler','Raggler',21,1020,0,218,140,1,102,113,0,5,18,10,32,20,39,35,10,12,0,2,24,0x3695,200,1000,900,384,0,0,0,0,0,0,0,0,7053,3000,916,5000,645,200,514,200,992,90,2225,7,756,32,0,0,0,0,4186,1);
REPLACE INTO `mob_db` VALUES (1255,'NERAID','Neraid','Nereid',40,4120,0,1126,684,1,325,360,0,10,1,45,50,5,64,5,10,12,0,2,22,0x3695,200,776,576,288,0,0,0,0,0,0,0,0,1055,5100,7053,1000,510,230,1966,10,514,250,757,180,985,37,0,0,0,0,4167,1);
REPLACE INTO `mob_db` VALUES (1256,'PEST','Pest','Pest',40,3240,0,1238,752,1,375,450,0,5,1,60,22,5,80,5,10,12,0,2,47,0x3695,165,700,648,480,0,0,0,0,0,0,0,0,1055,5500,7054,200,702,10,605,100,716,250,0,0,756,115,0,0,0,0,4315,1);
REPLACE INTO `mob_db` VALUES (1257,'INJUSTICE','Injustice','Injustice',51,7600,0,2118,1488,1,480,600,0,0,84,42,39,0,71,35,10,12,1,1,47,0x3695,400,770,720,336,0,0,0,0,0,0,0,0,999,300,7054,5335,7053,3500,2313,5,2316,2,660,2,1255,2,0,0,0,0,4268,1);
REPLACE INTO `mob_db` VALUES (1258,'GOBLIN_ARCHER','Goblin Archer','Goblin Archer',28,1750,0,461,284,9,89,113,0,0,10,15,20,15,72,20,10,12,0,7,25,0x2085,200,1172,672,420,0,0,0,0,0,0,0,0,2297,3,998,250,911,1000,1765,3000,507,600,1705,25,514,300,0,0,0,0,4157,1);
REPLACE INTO `mob_db` VALUES (1259,'GRYPHON','Gryphon','Gryphon',72,27800,0,5896,4400,1,880,1260,35,35,68,95,78,65,115,75,10,12,2,2,84,0x37B5,100,704,504,432,0,0,0,0,0,0,0,0,7048,2500,7054,5335,7063,120,1452,1500,1417,1,984,185,996,150,0,0,0,0,4163,1);
REPLACE INTO `mob_db` VALUES (1260,'DARK_FRAME','Dark Frame','Dark Frame',59,7500,0,3652,3271,1,960,1210,10,45,1,72,42,45,85,25,10,12,1,6,67,0x3795,200,920,720,200,0,0,0,0,0,0,0,0,7054,4656,734,1000,2505,30,0,0,0,0,1000,80,747,3,0,0,0,0,4170,1);
REPLACE INTO `mob_db` VALUES (1261,'WILD_ROSE','Wild Rose','Wild Rose',38,2980,0,1113,688,1,315,360,0,15,65,85,15,35,65,80,10,12,0,2,24,0x83,100,964,864,288,0,0,0,0,0,0,0,0,7053,5335,748,50,5037,120,1767,3000,624,35,528,600,2244,2,0,0,0,0,4257,1);
REPLACE INTO `mob_db` VALUES (1262,'MUTANT_DRAGON','Mutant Dragon','Mutant Dragonoid',65,62600,0,4730,3536,4,2400,3400,15,20,75,47,30,68,45,35,10,12,2,9,43,0x37B5,250,1280,1080,240,0,0,0,0,0,0,0,0,7054,4850,1035,500,1036,500,930,500,1559,400,7296,1500,2527,50,0,0,0,0,4203,1);
REPLACE INTO `mob_db` VALUES (1263,'WIND_GHOST','Wind Ghost','Wind Ghost',51,4820,0,2424,1488,2,489,639,0,45,1,89,15,90,85,25,10,12,1,6,64,0x3795,150,1056,1056,336,0,0,0,0,0,0,0,0,912,4559,932,6000,7005,500,693,100,1611,8,996,100,1615,1,0,0,0,0,4264,1);
REPLACE INTO `mob_db` VALUES (1264,'MERMAN','Merman','Merman',53,14690,0,4500,3000,2,482,964,10,35,72,45,46,35,60,55,10,12,1,7,61,0x3695,220,916,816,336,0,0,0,0,0,0,0,0,1054,1300,523,300,568,400,720,40,995,35,1460,3,756,203,0,0,0,0,4199,1);
REPLACE INTO `mob_db` VALUES (1265,'COOKIE','Cookie','Cookie',25,950,0,310,188,1,130,145,0,25,1,35,20,53,37,90,10,12,0,7,60,0x1089,200,1036,936,240,0,0,0,0,0,0,0,0,538,1000,530,150,979,1,11002,50,2402,30,12001,100,529,320,0,0,0,0,4293,1);
REPLACE INTO `mob_db` VALUES (1266,'ASTER','Aster','Aster',18,1372,0,122,78,1,56,64,0,10,1,19,15,0,34,5,10,12,0,5,22,0x91,400,1264,864,216,0,0,0,0,0,0,0,0,938,500,7013,40,1052,1200,508,200,912,60,512,100,0,0,0,0,0,0,4247,1);
REPLACE INTO `mob_db` VALUES (1267,'CARAT','Carat','Carat',51,5200,0,1926,1353,1,330,417,0,25,1,41,45,5,85,155,10,12,1,6,44,0x3795,200,1078,768,384,0,0,0,0,0,0,0,0,7054,3200,536,1000,2409,5,5003,1,0,0,0,0,509,1450,0,0,0,0,4288,1);
REPLACE INTO `mob_db` VALUES (1268,'BLOODY_KNIGHT','Bloody Knight','Bloody Knight',82,57870,0,10120,6820,3,2150,3030,60,50,88,75,70,77,125,55,10,12,2,0,87,0x3695,250,828,528,192,0,0,0,0,0,0,0,0,7054,4850,2229,45,2317,5,2125,62,1170,1,1417,2,985,433,0,0,0,0,4320,1);
REPLACE INTO `mob_db` VALUES (1269,'CLOCK','Clock','Clock',60,11050,0,3410,2904,1,720,909,15,10,1,70,50,25,90,50,10,12,1,0,42,0x91,200,1092,792,480,0,0,0,0,0,0,0,0,1095,5335,1019,800,509,1900,568,320,7026,30,7027,30,985,163,0,0,0,0,4299,1);
REPLACE INTO `mob_db` VALUES (1270,'C_TOWER_MANAGER','Clock Tower Manager','Clock Tower Manager',63,18600,0,4378,2850,3,880,1180,35,30,1,75,20,64,75,60,10,12,2,0,80,0x91,200,1072,672,384,0,0,0,0,0,0,0,0,1095,5335,7054,5335,999,500,520,850,2109,1,7026,2000,7027,2000,0,0,0,0,4229,1);
REPLACE INTO `mob_db` VALUES (1271,'ALLIGATOR','Alligator','Alligator',42,6962,0,1379,866,1,315,360,2,5,1,45,50,10,69,65,10,12,1,2,21,0x91,200,1100,900,480,0,0,0,0,0,0,0,0,912,1000,1099,600,7003,2000,608,50,0,0,0,0,756,129,0,0,0,0,4252,1);
REPLACE INTO `mob_db` VALUES (1272,'DARK_LORD','Dark Lord','Dark Lord',80,720000,0,65780,45045,2,2800,3320,30,70,1,120,30,118,99,60,10,12,2,6,89,0x37B5,100,868,768,480,32890,10000,7005,6000,5093,500,617,2000,1615,800,2004,100,1237,300,2334,300,2507,100,985,5141,984,3977,0,0,0,0,4168,1);
REPLACE INTO `mob_db` VALUES (1273,'ORC_LADY','Orc Lady','Orc Lady',31,2000,0,644,407,1,135,170,10,10,35,42,25,15,69,55,10,12,1,7,42,0x3695,200,1050,900,288,0,0,0,0,0,0,0,0,7053,4656,998,300,2602,1,2206,1,12127,10,7477,3,2338,1,0,0,0,0,4255,1);
REPLACE INTO `mob_db` VALUES (1274,'MEGALITH','Megalith','Megalith',45,5300,0,1758,1075,9,264,314,50,25,1,45,60,5,95,5,10,12,2,0,80,0x84,200,1332,1332,672,0,0,0,0,0,0,0,0,912,100,7049,1000,617,1,0,0,0,0,985,61,757,207,0,0,0,0,4200,1);
REPLACE INTO `mob_db` VALUES (1275,'ALICE','Alice','Alice',62,10000,221,3583,2400,1,550,700,5,5,64,64,42,85,100,130,10,12,1,7,60,0x91,200,502,2304,480,0,0,0,0,0,0,0,0,7047,2500,637,40,2407,3,739,30,5085,1,12128,10,12002,100,0,0,0,0,4253,1);
REPLACE INTO `mob_db` VALUES (1276,'RAYDRIC_ARCHER','Raydric Archer','Raydric Archer',52,5250,0,3025,2125,9,415,500,35,5,15,25,22,5,145,35,10,12,1,6,47,0x2185,200,1152,1152,480,0,0,0,0,0,0,0,0,7054,4656,0,0,2315,2,1701,150,1764,2000,1715,3,985,106,0,0,0,0,4187,1);
REPLACE INTO `mob_db` VALUES (1277,'GREATEST_GENERAL','Greatest General','Greatest General',40,3632,0,1238,752,3,350,400,15,15,1,20,60,55,82,140,10,12,1,0,43,0x84,200,1152,1152,384,0,0,0,0,0,0,0,0,7054,2000,1019,2000,1501,100,662,300,2272,1,508,250,686,100,0,0,0,0,4283,1);
REPLACE INTO `mob_db` VALUES (1278,'STALACTIC_GOLEM','Stalactic Golem','Stalactic Golem',60,18700,0,5808,2695,1,950,1260,50,5,73,45,85,5,90,25,10,12,2,0,80,0x91,200,1264,864,288,0,0,0,0,0,0,0,0,7004,2000,7054,4850,1000,250,997,30,757,250,0,0,985,163,0,0,0,0,4223,1);
REPLACE INTO `mob_db` VALUES (1279,'TRI_JOINT','Tri Joint','Tri Joint',32,2300,0,386,220,1,178,206,20,5,1,48,24,10,67,20,10,12,0,4,22,0x3795,200,860,660,624,0,0,0,0,0,0,0,0,7053,100,943,380,606,200,993,160,1001,140,0,0,757,106,0,0,0,0,4308,1);
REPLACE INTO `mob_db` VALUES (1280,'STEAM_GOBLIN','Steam Goblin','Goblin Steamrider',35,2490,0,864,495,1,234,269,20,5,58,59,32,15,75,25,10,12,1,7,44,0x91,200,1008,1008,528,0,0,0,0,0,0,0,0,911,2500,7053,3880,998,300,999,55,1003,320,13104,5,757,124,0,0,0,0,4156,1);
REPLACE INTO `mob_db` VALUES (1281,'SAGEWORM','Sage Worm','Sage Worm',43,3850,0,1155,1320,1,120,280,0,50,1,52,24,88,79,55,10,12,0,2,60,0x91,200,936,936,288,0,0,0,0,0,0,0,0,2716,5,1097,1000,1055,3000,691,100,505,40,689,100,5012,1,0,0,0,0,4219,1);
REPLACE INTO `mob_db` VALUES (1282,'KOBOLD_ARCHER','Kobold Archer','Kobold Archer',33,2560,0,739,455,9,155,185,10,5,10,20,15,30,100,25,10,12,0,7,23,0x2085,200,1008,1008,384,0,0,0,0,0,0,0,0,912,250,999,60,1034,4850,5118,50,1763,2000,1711,5,756,79,0,0,0,0,4292,1);
REPLACE INTO `mob_db` VALUES (1283,'CHIMERA','Chimera','Chimera',70,32600,0,4950,3000,1,1200,1320,30,10,1,72,110,88,75,85,10,12,2,2,63,0x37B5,200,772,672,360,0,0,0,0,0,0,0,0,7054,5335,1048,2500,568,1000,1306,1,7295,1500,1364,1,984,160,0,0,0,0,4300,1);
# REPLACE INTO `mob_db` VALUES (1284,'HUGELING','Hugeling','Hugeling',1,5000,0,2,1,4,7,10,0,0,1,1,1,1,6,1,10,12,2,3,21,0x91,200,1872,672,480,0,0,0,0,0,0,0,0,512,100,512,100,512,100,512,100,512,100,512,100,512,100,512,100,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1285,'ARCHER_GUARDIAN','Archer Guardian','Archer Guardian',74,28634,0,1,1,12,1120,1600,35,60,95,80,80,90,165,55,14,16,2,7,80,0x1FA5,265,1200,1200,384,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1286,'KNIGHT_GUARDIAN','Knight Guardian','Knight Guardian',86,30214,0,1,1,2,1280,1560,55,30,110,40,140,65,125,65,14,16,2,7,80,0x1FA5,275,1200,1200,384,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1287,'SOLDIER_GUARDIAN','Soldier Guardian','Soldier Guardian',56,15670,0,1,1,1,873,1036,35,0,85,56,100,45,103,43,10,12,0,4,22,0x21A5,265,1288,288,384,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1288,'EMPELIUM','Emperium','Emperium',90,68430,0,0,0,1,60,71,40,50,1,17,80,50,26,20,10,12,0,8,26,0x120,300,1288,288,384,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1289,'MAYA_PUPLE','Maya Purple','Maya Purple',81,55479,0,10496,3893,2,1447,2000,68,48,95,90,80,95,90,119,10,12,2,4,82,0x37B5,100,1024,1000,480,0,0,0,0,0,0,0,0,7053,4413,757,250,756,300,969,100,984,150,10006,1,7481,2,0,0,0,0,4198,1);
REPLACE INTO `mob_db` VALUES (1290,'SKELETON_GENERAL','Skeleton General','Skeleton General',73,17402,0,8170,3370,1,910,1089,25,25,90,25,40,20,77,25,10,12,1,1,29,0x3695,150,2276,576,432,0,0,0,0,0,0,0,0,7068,2550,756,160,508,800,1220,35,1219,80,13035,15,2274,1,0,0,0,0,4221,1);
REPLACE INTO `mob_db` VALUES (1291,'WRAITH_DEAD','Wraith Dead','Wraith Dead',74,43021,0,10341,3618,2,1366,1626,25,30,5,99,55,75,115,45,10,12,2,1,89,0x3695,175,1816,576,240,0,0,0,0,0,0,0,0,1059,4413,2206,10,2506,8,716,700,732,5,603,100,568,300,0,0,0,0,4189,1);
REPLACE INTO `mob_db` VALUES (1292,'MINI_DEMON','Mini Demon','Mini Demon',68,32538,0,8396,3722,1,1073,1414,30,25,5,75,40,55,89,42,10,12,0,6,27,0x3795,150,1000,600,384,0,0,0,0,0,0,0,0,1038,4413,1039,450,2255,3,757,160,912,2500,1009,10,1478,5,0,0,0,0,4204,1);
REPLACE INTO `mob_db` VALUES (1293,'CREMY_FEAR','Creamy Fear','Creamy Fear',62,13387,0,7365,2691,2,666,829,45,30,5,40,16,15,68,55,10,12,0,4,24,0x3795,155,1136,720,840,0,0,0,0,0,0,0,0,924,4550,2333,10,518,550,602,200,1550,8,2726,5,522,50,0,0,0,0,4298,1);
REPLACE INTO `mob_db` VALUES (1294,'KILLER_MANTIS','Killer Mantis','Killer Mantis',56,13183,0,6509,2366,1,764,927,35,20,5,26,24,5,75,40,10,12,1,4,22,0x3795,175,1528,660,432,0,0,0,0,0,0,0,0,1031,4550,943,2500,721,10,509,15,514,25,1262,1,2108,1,0,0,0,0,4301,1);
REPLACE INTO `mob_db` VALUES (1295,'OWL_BARON','Owl Baron','Owl Baron',75,60746,0,10967,4811,2,1252,1610,65,25,25,25,80,95,95,55,10,12,2,6,60,0x37B5,175,1345,824,440,0,0,0,0,0,0,0,0,7071,3500,7063,2500,1716,2,1472,1,1629,2,693,100,5045,5,0,0,0,0,4238,1);
REPLACE INTO `mob_db` VALUES (1296,'KOBOLD_LEADER','Kobold Leader','Kobold Leader',65,18313,0,7432,2713,1,649,958,37,37,5,90,36,30,77,59,10,12,1,7,44,0x3695,150,1028,528,360,0,0,0,0,0,0,0,0,999,450,1034,6305,912,1200,1511,6,1613,2,525,150,526,100,0,0,0,0,4291,1);
REPLACE INTO `mob_db` VALUES (1297,'ANCIENT_MUMMY','Ancient Mummy','Ancient Mummy',64,40599,0,8040,3499,1,836,1129,27,27,28,19,32,5,83,35,10,12,1,1,49,0x3695,175,1772,120,384,0,0,0,0,0,0,0,0,930,4413,934,1800,2624,1,2611,150,508,650,756,150,757,100,0,0,0,0,4248,1);
REPLACE INTO `mob_db` VALUES (1298,'ZOMBIE_MASTER','Zombie Master','Zombie Master',62,14211,0,7610,2826,1,824,1084,37,26,25,20,30,5,77,35,10,12,1,1,29,0x3695,175,2612,912,288,0,0,0,0,0,0,0,0,7071,4413,938,1500,958,1500,723,200,727,100,1260,1,2324,2,0,0,0,0,4274,1);
REPLACE INTO `mob_db` VALUES (1299,'GOBLIN_LEADER','Goblin Leader','Goblin Leader',64,20152,0,6036,2184,1,663,752,48,16,5,55,37,30,69,58,10,12,1,7,24,0x3695,120,1120,620,240,0,0,0,0,0,0,0,0,7054,1500,999,800,756,120,5090,50,2106,2,508,650,5113,10,0,0,0,0,4155,1);
REPLACE INTO `mob_db` VALUES (1300,'CATERPILLAR','Caterpillar','Caterpillar',64,14439,0,6272,3107,1,894,1447,47,29,35,25,85,15,69,45,10,12,0,4,22,0x3795,300,1672,672,480,0,0,0,0,0,0,0,0,949,3000,7054,5335,13034,20,1000,100,997,50,505,12,508,500,0,0,0,0,4289,1);
REPLACE INTO `mob_db` VALUES (1301,'AM_MUT','Am Mut','Am Mut',61,12099,0,7709,2690,1,1040,1121,50,10,50,65,40,35,83,45,10,12,0,6,27,0x3795,200,1156,456,384,0,0,0,0,0,0,0,0,1021,4550,757,250,1517,3,969,5,2282,1,616,1,746,250,0,0,0,0,4245,1);
REPLACE INTO `mob_db` VALUES (1302,'DARK_ILLUSION','Dark Illusion','Dark Illusion',77,103631,0,11163,4181,2,1300,1983,64,70,5,100,40,100,97,40,10,12,2,6,89,0x37B5,145,1024,768,480,0,0,0,0,0,0,0,0,1615,3,5017,2,2508,3,7054,5335,522,120,509,1550,1162,2,0,0,0,0,4169,1);
REPLACE INTO `mob_db` VALUES (1303,'GIANT_HONET','Giant Hornet','Giant Hornet',56,13105,0,5785,2006,1,650,852,38,43,35,38,32,10,71,64,10,12,0,4,24,0x3795,155,1292,792,340,0,0,0,0,0,0,0,0,526,550,518,1200,522,12,610,15,1608,3,722,20,1736,15,0,0,0,0,4271,1);
REPLACE INTO `mob_db` VALUES (1304,'GIANT_SPIDER','Giant Spider','Giant Spider',55,11874,0,6211,2146,1,624,801,41,28,5,36,43,5,73,69,10,12,2,4,25,0x3795,165,1468,468,768,0,0,0,0,0,0,0,0,1025,4550,1042,1200,757,140,525,450,943,1200,1096,680,7053,800,0,0,0,0,4270,1);
REPLACE INTO `mob_db` VALUES (1305,'ANCIENT_WORM','Ancient Worm','Ancient Worm',67,22598,0,8174,3782,1,948,1115,35,30,5,35,56,55,81,72,10,12,2,4,25,0x3795,165,1792,792,336,0,0,0,0,0,0,0,0,1042,4413,912,2500,2406,9,2727,5,1096,680,938,3500,7054,2500,0,0,0,0,4249,1);
REPLACE INTO `mob_db` VALUES (1306,'LEIB_OLMAI','Leib Olmai','Leib Olmai',58,24233,0,6011,2171,1,740,1390,27,31,5,35,95,5,64,85,10,12,2,2,22,0x3695,175,1260,230,192,0,0,0,0,0,0,0,0,948,4550,2289,8,740,120,518,500,2717,5,969,5,7053,800,0,0,0,0,4188,1);
REPLACE INTO `mob_db` VALUES (1307,'CAT_O_NINE_TAIL','Cat o\' Nine Tails','Cat o\' Nine Tails',76,64512,0,10869,4283,1,1112,1275,61,55,55,75,55,82,86,120,10,12,1,6,63,0x37B5,155,1276,576,288,0,0,0,0,0,0,0,0,5008,1,638,150,10008,5,985,600,984,800,969,6,617,1,0,0,0,0,4290,1);
REPLACE INTO `mob_db` VALUES (1308,'PANZER_GOBLIN','Panzer Goblin','Panzer Goblin',59,14130,0,7212,2697,1,683,878,41,28,60,60,40,20,81,160,10,12,1,7,44,0x3695,200,960,1008,840,0,0,0,0,0,0,0,0,7053,4413,7054,3500,999,180,998,360,1003,580,13158,5,994,160,0,0,0,0,4310,1);
REPLACE INTO `mob_db` VALUES (1309,'GAJOMART','Gajomart','Gajomart',63,13669,0,6625,2900,1,917,950,85,50,5,34,10,5,75,140,10,12,0,0,83,0x3695,300,1000,1152,828,0,0,0,0,0,0,0,0,953,6500,912,2300,508,870,2279,8,1752,10000,2131,20,994,180,0,0,0,0,4151,1);
REPLACE INTO `mob_db` VALUES (1310,'MAJORUROS','Majoruros','Majoruros',66,57991,0,8525,3799,1,780,1300,10,25,65,50,75,50,85,48,10,12,2,2,43,0x3695,250,1100,960,780,0,0,0,0,0,0,0,0,941,4413,1361,4,568,300,984,16,509,1850,2611,160,1000,250,0,0,0,0,4201,1);
REPLACE INTO `mob_db` VALUES (1311,'GULLINBURSTI','Gullinbursti','Gullinbursti',62,21331,0,5814,2376,1,699,1431,10,15,55,25,60,5,70,45,10,12,2,2,42,0x3695,150,1960,960,384,0,0,0,0,0,0,0,0,1028,3500,514,290,702,6,2276,1,605,15,2627,1,912,160,0,0,0,0,4164,1);
REPLACE INTO `mob_db` VALUES (1312,'TURTLE_GENERAL','Turtle General','Turtle General',97,320700,0,18202,9800,2,2438,3478,50,54,100,45,55,65,105,164,10,12,2,2,42,0x37B5,200,900,1000,500,9101,10000,967,5500,607,1500,617,2000,1529,8,1306,5,7480,200,1417,9,7070,5335,1141,80,658,1,0,0,0,0,4305,1);
REPLACE INTO `mob_db` VALUES (1313,'MOBSTER','Mobster','Mobster',61,7991,0,4424,1688,1,910,1128,41,37,76,46,20,35,76,55,10,12,1,7,20,0x3695,250,1100,560,580,0,0,0,0,0,0,0,0,1239,3,726,4559,2621,1,716,600,912,2500,525,450,505,60,0,0,0,0,4317,1);
REPLACE INTO `mob_db` VALUES (1314,'PERMETER','Permeter','Permeter',63,8228,0,3756,1955,2,943,1211,46,45,69,59,60,5,69,100,10,12,1,2,40,0x91,250,1100,483,528,0,0,0,0,0,0,0,0,967,4413,7070,45,1019,1240,507,2450,912,1240,522,25,605,1,0,0,0,0,4311,1);
REPLACE INTO `mob_db` VALUES (1315,'ASSULTER','Assaulter','Assaulter',71,11170,0,4854,2654,2,764,1499,35,28,85,74,10,35,100,100,10,12,1,7,44,0x3695,155,1000,900,432,0,0,0,0,0,0,0,0,967,4413,7069,1200,7072,840,508,1280,912,1240,13300,5,603,1,0,0,0,0,4246,1);
REPLACE INTO `mob_db` VALUES (1316,'SOLIDER','Solider','Solider',70,12099,0,4458,1951,2,797,979,57,43,69,35,85,5,74,100,10,12,1,2,42,0x91,250,1452,483,528,0,0,0,0,0,0,0,0,967,4413,7070,64,7067,850,508,2100,912,1240,518,850,1519,1,0,0,0,0,4220,1);
REPLACE INTO `mob_db` VALUES (1317,'FUR_SEAL','Fur Seal','Seal',63,9114,0,3765,1824,1,845,1203,25,33,5,28,22,15,69,84,10,12,1,2,21,0x3885,200,1612,622,583,0,0,0,0,0,0,0,0,912,4365,510,250,2310,5,7053,1200,1452,1,525,200,746,120,0,0,0,0,4312,1);
REPLACE INTO `mob_db` VALUES (1318,'HEATER','Heater','Heater',68,11020,0,3766,2359,2,683,1008,40,42,69,47,25,5,71,100,10,12,1,2,43,0x3695,250,1452,483,528,0,0,0,0,0,0,0,0,967,4413,7070,750,697,100,912,1640,526,140,7054,600,7068,1250,0,0,0,0,4331,1);
REPLACE INTO `mob_db` VALUES (1319,'FREEZER','Freezer','Freezer',72,8636,0,3665,2197,2,671,983,55,43,69,41,59,5,67,100,10,12,1,2,41,0x3695,250,1452,483,528,0,0,0,0,0,0,0,0,967,4413,7070,850,7066,1250,912,1800,526,160,7053,600,689,100,0,0,0,0,4319,1);
REPLACE INTO `mob_db` VALUES (1320,'OWL_DUKE','Owl Duke','Owl Duke',75,26623,0,7217,3474,1,715,910,27,49,15,45,40,75,79,88,10,12,2,6,60,0x37B5,195,1345,824,440,0,0,0,0,0,0,0,0,7071,4413,7063,1500,693,100,747,1,1451,3,1513,2,5045,1,0,0,0,0,4237,1);
REPLACE INTO `mob_db` VALUES (1321,'DRAGON_TAIL','Dragon Tail','Dragon Tail',61,8368,0,3587,1453,1,520,715,25,19,10,68,15,5,67,67,10,12,1,4,44,0x3795,175,862,534,312,0,0,0,0,0,0,0,0,7064,4413,1096,400,943,800,2207,8,2226,2,601,300,602,150,0,0,0,0,4178,1);
REPLACE INTO `mob_db` VALUES (1322,'SPRING_RABBIT','Spring Rabbit','Spring Rabbit',58,9045,0,3982,1766,1,585,813,29,21,45,61,5,15,77,90,10,12,1,2,42,0x83,160,1120,552,511,0,0,0,0,0,0,0,0,7054,3500,7053,2500,949,2500,511,4500,508,800,510,200,509,800,0,0,0,0,4227,1);
REPLACE INTO `mob_db` VALUES (1323,'SEE_OTTER','Sea Otter','Sea Otter',59,9999,0,3048,1642,1,650,813,33,35,5,36,40,25,82,65,10,12,1,2,61,0x3885,190,1132,583,532,0,0,0,0,0,0,0,0,722,150,965,5500,7065,4365,725,50,726,50,746,650,7053,1200,0,0,0,0,4326,1);
REPLACE INTO `mob_db` VALUES (1324,'TREASURE_BOX1','Treasure Chest','Treasure Chest',99,0,0,0,0,0,0,0,0,0,0,0,0,0,999,0,0,0,0,0,20,0x120,0,0,0,0,0,0,0,0,0,0,0,0,732,7760,608,3000,607,2500,2504,800,2404,800,2315,800,2104,800,616,1000,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1325,'TREASURE_BOX2','Treasure Chest','Treasure Chest',99,0,0,0,0,0,0,0,0,0,0,0,0,0,999,0,0,0,0,0,20,0x120,0,0,0,0,0,0,0,0,0,0,0,0,7073,80,658,500,604,10000,984,4850,985,7275,1239,1500,5027,75,1165,8,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1326,'TREASURE_BOX3','Treasure Chest','Treasure Chest',99,0,0,0,0,0,0,0,0,0,0,0,0,0,999,0,0,0,0,0,20,0x120,0,0,0,0,0,0,0,0,0,0,0,0,732,7760,608,3000,607,2500,2504,800,2404,800,2315,800,2104,800,616,1000,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1327,'TREASURE_BOX4','Treasure Chest','Treasure Chest',99,0,0,0,0,0,0,0,0,0,0,0,0,0,999,0,0,0,0,0,20,0x120,0,0,0,0,0,0,0,0,0,0,0,0,7074,80,658,500,604,10000,984,4850,985,7275,2108,1000,1306,75,5022,2,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1328,'TREASURE_BOX5','Treasure Chest','Treasure Chest',99,0,0,0,0,0,0,0,0,0,0,0,0,0,999,0,0,0,0,0,20,0x120,0,0,0,0,0,0,0,0,0,0,0,0,732,7760,608,3000,607,2500,2504,800,2404,800,2315,800,2104,800,616,1000,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1329,'TREASURE_BOX6','Treasure Chest','Treasure Chest',99,0,0,0,0,0,0,0,0,0,0,0,0,0,999,0,0,0,0,0,20,0x120,0,0,0,0,0,0,0,0,0,0,0,0,7075,80,658,500,604,10000,984,4850,985,7275,2102,834,5019,100,5002,9,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1330,'TREASURE_BOX7','Treasure Chest','Treasure Chest',99,0,0,0,0,0,0,0,0,0,0,0,0,0,999,0,0,0,0,0,20,0x120,0,0,0,0,0,0,0,0,0,0,0,0,732,7760,608,3000,607,2500,2504,800,2404,800,2315,800,2104,800,616,1000,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1331,'TREASURE_BOX8','Treasure Chest','Treasure Chest',99,0,0,0,0,0,0,0,0,0,0,0,0,0,999,0,0,0,0,0,20,0x120,0,0,0,0,0,0,0,0,0,0,0,0,7076,80,658,500,604,10000,984,4850,985,7275,2616,500,2334,125,2622,9,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1332,'TREASURE_BOX9','Treasure Chest','Treasure Chest',99,0,0,0,0,0,0,0,0,0,0,0,0,0,999,0,0,0,0,0,20,0x120,0,0,0,0,0,0,0,0,0,0,0,0,732,7760,608,3000,607,2500,2504,800,2404,800,2315,800,2104,800,616,1000,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1333,'TREASURE_BOX10','Treasure Chest','Treasure Chest',99,0,0,0,0,0,0,0,0,0,0,0,0,0,999,0,0,0,0,0,20,0x120,0,0,0,0,0,0,0,0,0,0,0,0,7077,80,658,500,604,10000,984,4850,985,7275,2104,500,2331,150,2623,10,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1334,'TREASURE_BOX11','Treasure Chest','Treasure Chest',99,0,0,0,0,0,0,0,0,0,0,0,0,0,999,0,0,0,0,0,20,0x120,0,0,0,0,0,0,0,0,0,0,0,0,732,7760,608,3000,607,2500,2504,800,2404,800,2315,800,2104,800,616,1000,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1335,'TREASURE_BOX12','Treasure Chest','Treasure Chest',99,0,0,0,0,0,0,0,0,0,0,0,0,0,999,0,0,0,0,0,20,0x120,0,0,0,0,0,0,0,0,0,0,0,0,7078,80,658,500,604,10000,984,4850,985,7275,2270,500,1716,150,2256,10,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1336,'TREASURE_BOX13','Treasure Chest','Treasure Chest',99,0,0,0,0,0,0,0,0,0,0,0,0,0,999,0,0,0,0,0,20,0x120,0,0,0,0,0,0,0,0,0,0,0,0,732,7760,608,3000,607,2500,2504,800,2404,800,2315,800,2104,800,616,1000,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1337,'TREASURE_BOX14','Treasure Chest','Treasure Chest',99,0,0,0,0,0,0,0,0,0,0,0,0,0,999,0,0,0,0,0,20,0x120,0,0,0,0,0,0,0,0,0,0,0,0,7079,80,658,500,604,10000,984,4850,985,7275,1238,375,1531,150,2318,10,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1338,'TREASURE_BOX15','Treasure Chest','Treasure Chest',99,0,0,0,0,0,0,0,0,0,0,0,0,0,999,0,0,0,0,0,20,0x120,0,0,0,0,0,0,0,0,0,0,0,0,732,7760,608,3000,607,2500,2504,800,2404,800,2315,800,2104,800,616,1000,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1339,'TREASURE_BOX16','Treasure Chest','Treasure Chest',99,0,0,0,0,0,0,0,0,0,0,0,0,0,999,0,0,0,0,0,20,0x120,0,0,0,0,0,0,0,0,0,0,0,0,7080,80,658,500,604,10000,984,4850,985,7275,2626,300,1472,167,2327,10,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1340,'TREASURE_BOX17','Treasure Chest','Treasure Chest',99,0,0,0,0,0,0,0,0,0,0,0,0,0,999,0,0,0,0,0,20,0x120,0,0,0,0,0,0,0,0,0,0,0,0,732,7760,608,3000,607,2500,2504,800,2404,800,2315,800,2104,800,616,1000,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1341,'TREASURE_BOX18','Treasure Chest','Treasure Chest',99,0,0,0,0,0,0,0,0,0,0,0,0,0,999,0,0,0,0,0,20,0x120,0,0,0,0,0,0,0,0,0,0,0,0,7081,80,658,500,604,10000,984,4850,985,7275,1143,250,1237,188,2235,12,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1342,'TREASURE_BOX19','Treasure Chest','Treasure Chest',99,0,0,0,0,0,0,0,0,0,0,0,0,0,999,0,0,0,0,0,20,0x120,0,0,0,0,0,0,0,0,0,0,0,0,732,7760,608,3000,607,2500,2504,800,2404,800,2315,800,2104,800,616,1000,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1343,'TREASURE_BOX20','Treasure Chest','Treasure Chest',99,0,0,0,0,0,0,0,0,0,0,0,0,0,999,0,0,0,0,0,20,0x120,0,0,0,0,0,0,0,0,0,0,0,0,7082,80,658,500,604,10000,984,4850,985,7275,617,250,1144,188,5007,19,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1344,'TREASURE_BOX21','Treasure Chest','Treasure Chest',99,0,0,0,0,0,0,0,0,0,0,0,0,0,999,0,0,0,0,0,20,0x120,0,0,0,0,0,0,0,0,0,0,0,0,732,7760,608,3000,607,2500,2504,800,2404,800,2315,800,2104,800,616,1000,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1345,'TREASURE_BOX22','Treasure Chest','Treasure Chest',99,0,0,0,0,0,0,0,0,0,0,0,0,0,999,0,0,0,0,0,20,0x120,0,0,0,0,0,0,0,0,0,0,0,0,7083,80,658,500,604,10000,984,4850,985,7275,2508,1000,2336,69,2621,20,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1346,'TREASURE_BOX23','Treasure Chest','Treasure Chest',99,0,0,0,0,0,0,0,0,0,0,0,0,0,999,0,0,0,0,0,20,0x120,0,0,0,0,0,0,0,0,0,0,0,0,732,7760,608,3000,607,2500,2504,800,2404,800,2315,800,2104,800,616,1000,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1347,'TREASURE_BOX24','Treasure Chest','Treasure Chest',99,0,0,0,0,0,0,0,0,0,0,0,0,0,999,0,0,0,0,0,20,0x120,0,0,0,0,0,0,0,0,0,0,0,0,7084,80,658,500,604,10000,984,4850,985,7275,2106,1000,1164,50,5025,24,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1348,'TREASURE_BOX25','Treasure Chest','Treasure Chest',99,0,0,0,0,0,0,0,0,0,0,0,0,0,999,0,0,0,0,0,20,0x120,0,0,0,0,0,0,0,0,0,0,0,0,732,7760,608,3000,607,2500,2504,800,2404,800,2315,800,2104,800,616,1000,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1349,'TREASURE_BOX26','Treasure Chest','Treasure Chest',99,0,0,0,0,0,0,0,0,0,0,0,0,0,999,0,0,0,0,0,20,0x120,0,0,0,0,0,0,0,0,0,0,0,0,7085,80,658,500,604,10000,984,4850,985,7275,2231,750,2624,46,2286,25,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1350,'TREASURE_BOX27','Treasure Chest','Treasure Chest',99,0,0,0,0,0,0,0,0,0,0,0,0,0,999,0,0,0,0,0,20,0x120,0,0,0,0,0,0,0,0,0,0,0,0,732,7760,608,3000,607,2500,2504,800,2404,800,2315,800,2104,800,616,1000,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1351,'TREASURE_BOX28','Treasure Chest','Treasure Chest',99,0,0,0,0,0,0,0,0,0,0,0,0,0,999,0,0,0,0,0,20,0x120,0,0,0,0,0,0,0,0,0,0,0,0,7086,80,658,500,604,10000,984,4850,985,7275,2283,500,2615,41,2234,32,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1352,'TREASURE_BOX29','Treasure Chest','Treasure Chest',99,0,0,0,0,0,0,0,0,0,0,0,0,0,999,0,0,0,0,0,20,0x120,0,0,0,0,0,0,0,0,0,0,0,0,732,7760,608,3000,607,2500,2504,800,2404,800,2315,800,2104,800,616,1000,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1353,'TREASURE_BOX30','Treasure Chest','Treasure Chest',99,0,0,0,0,0,0,0,0,0,0,0,0,0,999,0,0,0,0,0,20,0x120,0,0,0,0,0,0,0,0,0,0,0,0,7087,80,658,500,604,10000,984,4850,985,7275,2507,500,2625,38,5045,34,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1354,'TREASURE_BOX31','Treasure Chest','Treasure Chest',99,0,0,0,0,0,0,0,0,0,0,0,0,0,999,0,0,0,0,0,20,0x120,0,0,0,0,0,0,0,0,0,0,0,0,732,7760,608,3000,607,2500,2504,800,2404,800,2315,800,2104,800,616,1000,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1355,'TREASURE_BOX32','Treasure Chest','Treasure Chest',99,0,0,0,0,0,0,0,0,0,0,0,0,0,999,0,0,0,0,0,20,0x120,0,0,0,0,0,0,0,0,0,0,0,0,7088,80,658,500,604,10000,984,4850,985,7275,2407,429,2269,250,2317,35,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1356,'TREASURE_BOX33','Treasure Chest','Treasure Chest',99,0,0,0,0,0,0,0,0,0,0,0,0,0,999,0,0,0,0,0,20,0x120,0,0,0,0,0,0,0,0,0,0,0,0,732,7760,608,3000,607,2500,2504,800,2404,800,2315,800,2104,800,616,1000,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1357,'TREASURE_BOX34','Treasure Chest','Treasure Chest',99,0,0,0,0,0,0,0,0,0,0,0,0,0,999,0,0,0,0,0,20,0x120,0,0,0,0,0,0,0,0,0,0,0,0,7089,80,658,500,604,10000,984,4850,985,7275,2109,300,2406,273,2258,38,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1358,'TREASURE_BOX35','Treasure Chest','Treasure Chest',99,0,0,0,0,0,0,0,0,0,0,0,0,0,999,0,0,0,0,0,20,0x120,0,0,0,0,0,0,0,0,0,0,0,0,732,7760,608,3000,607,2500,2504,800,2404,800,2315,800,2104,800,616,1000,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1359,'TREASURE_BOX36','Treasure Chest','Treasure Chest',99,0,0,0,0,0,0,0,0,0,0,0,0,0,999,0,0,0,0,0,20,0x120,0,0,0,0,0,0,0,0,0,0,0,0,7090,80,658,500,604,10000,984,4850,985,7275,1142,215,2255,60,5017,38,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1360,'TREASURE_BOX37','Treasure Chest','Treasure Chest',99,0,0,0,0,0,0,0,0,0,0,0,0,0,999,0,0,0,0,0,20,0x120,0,0,0,0,0,0,0,0,0,0,0,0,732,7760,608,3000,607,2500,2504,800,2404,800,2315,800,2104,800,616,1000,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1361,'TREASURE_BOX38','Treasure Chest','Treasure Chest',99,0,0,0,0,0,0,0,0,0,0,0,0,0,999,0,0,0,0,0,20,0x120,0,0,0,0,0,0,0,0,0,0,0,0,7091,80,658,500,604,10000,984,4850,985,7275,1417,50,5053,50,2229,50,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1362,'TREASURE_BOX39','Treasure Chest','Treasure Chest',99,0,0,0,0,0,0,0,0,0,0,0,0,0,999,0,0,0,0,0,20,0x120,0,0,0,0,0,0,0,0,0,0,0,0,732,7760,608,3000,607,2500,2504,800,2404,800,2315,800,2104,800,616,1000,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1363,'TREASURE_BOX40','Treasure Chest','Treasure Chest',99,0,0,0,0,0,0,0,0,0,0,0,0,0,999,0,0,0,0,0,20,0x120,0,0,0,0,0,0,0,0,0,0,0,0,7092,80,658,500,604,10000,984,4850,985,7275,2506,43,2254,43,1529,38,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1364,'G_ASSULTER','Assaulter','Assaulter',59,12853,0,0,0,2,152,177,35,36,85,55,10,35,145,100,10,12,1,6,44,0x3795,155,1000,900,432,0,0,0,0,0,0,0,0,1019,9000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1365,'APOCALIPS','Apocalypse','Apocalypse',66,22880,0,6540,4935,2,1030,1370,62,49,1,48,120,48,66,85,10,12,2,0,60,0x91,400,1840,1440,384,0,0,0,0,0,0,0,0,7095,5335,7094,2400,7093,2200,985,5,13161,1,2506,20,999,2500,0,0,0,0,4242,1);
REPLACE INTO `mob_db` VALUES (1366,'LAVA_GOLEM','Lava Golem','Lava Golem',77,24324,0,6470,3879,1,1541,2049,65,50,1,57,115,70,76,68,10,12,2,0,83,0x3095,400,2190,2040,336,0,0,0,0,0,0,0,0,7096,4559,7097,3686,2317,1,2316,2,509,2500,1818,20,0,0,0,0,0,0,4184,1);
REPLACE INTO `mob_db` VALUES (1367,'BLAZZER','Blazer','Blazer',43,8252,0,3173,1871,2,533,709,50,40,1,52,50,39,69,40,10,12,1,6,43,0x3395,180,1732,1332,540,0,0,0,0,0,0,0,0,7097,4850,7098,3400,509,3000,0,0,0,0,0,0,0,0,0,0,0,0,4215,1);
REPLACE INTO `mob_db` VALUES (1368,'GEOGRAPHER','Geographer','Geographer',56,8071,0,2715,2000,3,467,621,28,26,1,66,47,60,68,44,10,12,1,3,62,0x84,2000,1308,1008,480,0,0,0,0,0,0,0,0,1032,6200,1033,5500,2253,30,2207,50,12002,100,0,0,0,0,0,0,0,0,4280,1);
REPLACE INTO `mob_db` VALUES (1369,'GRAND_PECO','Grand Peco','Grand Peco',58,8054,0,2387,1361,2,444,565,37,30,1,66,66,50,71,51,10,12,2,2,43,0x1089,165,1460,960,432,0,0,0,0,0,0,0,0,7101,4850,522,300,992,1000,969,1,0,0,0,0,582,500,0,0,0,0,4161,1);
REPLACE INTO `mob_db` VALUES (1370,'SUCCUBUS','Succubus','Succubus',85,16955,0,5357,4322,2,1268,1686,54,48,1,97,95,103,89,87,10,12,1,6,67,0x3795,155,1306,1056,288,0,0,0,0,0,0,0,0,522,1500,2407,3,12373,1,2613,250,5066,1,1472,1,505,1000,0,0,0,0,4218,1);
REPLACE INTO `mob_db` VALUES (1371,'FAKE_ANGEL','Fake Angel','False Angel',65,16845,0,3371,1949,2,513,682,50,35,1,64,57,70,61,88,10,12,0,8,66,0x3885,160,920,720,336,0,0,0,0,0,0,0,0,0,0,0,0,717,1000,715,1000,716,1000,12020,1000,1974,20,0,0,0,0,4316,1);
REPLACE INTO `mob_db` VALUES (1372,'GOAT','Goat','Goat',69,11077,0,3357,2015,1,457,608,44,25,1,58,66,62,67,43,10,12,1,2,63,0x1089,165,1380,1080,336,0,0,0,0,0,0,0,0,7106,4559,7107,2500,713,5000,507,500,510,1000,508,2500,511,5500,0,0,0,0,4150,1);
REPLACE INTO `mob_db` VALUES (1373,'LORD_OF_DEATH','Lord of Death','Lord of the Dead',94,603383,0,131343,43345,3,3430,4232,77,73,1,99,30,109,100,106,10,12,2,6,67,0x37B5,180,1446,1296,360,65671,10000,607,5500,732,5000,617,5000,7108,5335,1417,5,1230,10,2621,2,7109,10,1306,1,1529,2,0,0,0,0,4276,1);
REPLACE INTO `mob_db` VALUES (1374,'INCUBUS','Incubus','Incubus',75,17281,0,5254,4212,2,1408,1873,58,46,1,97,95,103,89,87,10,12,1,6,67,0x3795,165,850,600,336,0,0,0,0,0,0,0,0,522,1500,509,5500,5072,1,2621,1,2610,500,2613,150,509,2200,0,0,0,0,4269,1);
REPLACE INTO `mob_db` VALUES (1375,'THE_PAPER','The Paper','The Paper',56,18557,0,2849,1998,1,845,1124,25,24,1,66,52,76,71,79,10,12,1,0,60,0x3885,170,1160,960,336,0,0,0,0,0,0,0,0,7111,4947,7112,3200,508,1800,511,2000,13009,5,0,0,0,0,0,0,0,0,4172,1);
REPLACE INTO `mob_db` VALUES (1376,'HARPY','Harpy','Harpy',70,16599,0,3562,2133,1,926,1231,42,44,1,112,72,67,74,76,10,12,1,6,64,0x3985,155,972,672,470,0,0,0,0,0,0,0,0,7115,4850,7116,2500,508,1500,508,800,709,20,1820,20,0,0,0,0,0,0,4325,1);
REPLACE INTO `mob_db` VALUES (1377,'ELDER','Elder','Elder',64,21592,0,5650,3408,3,421,560,45,68,1,76,68,108,72,86,10,12,2,7,80,0x3885,165,1552,1152,336,0,0,0,0,0,0,0,0,7099,4000,7117,1500,7118,1500,1564,10,1473,1,616,1,7027,3000,0,0,0,0,4251,1);
REPLACE INTO `mob_db` VALUES (1378,'DEMON_PUNGUS','Demon Pungus','Demon Pungus',56,7259,0,3148,1817,1,360,479,48,31,1,83,55,59,63,34,10,12,0,6,65,0x3985,170,1260,960,672,0,0,0,0,0,0,0,0,7119,4074,7001,4559,715,3880,1061,5000,0,0,0,0,0,0,0,0,0,0,4173,1);
REPLACE INTO `mob_db` VALUES (1379,'NIGHTMARE_TERROR','Nightmare Terror','Nightmare Terror',78,22605,0,6683,4359,1,757,1007,37,37,1,76,55,60,76,54,10,12,2,6,67,0x3985,165,1216,816,432,0,0,0,0,0,0,0,0,7120,4947,2626,1,2608,30,505,50,510,150,695,100,1261,1,0,0,0,0,4166,1);
REPLACE INTO `mob_db` VALUES (1380,'DRILLER','Driller','Driller',52,7452,0,3215,1860,1,666,886,48,31,1,66,58,50,60,47,10,12,1,2,22,0x3885,165,1300,900,336,0,0,0,0,0,0,0,0,1012,7500,715,3880,716,3500,0,0,0,0,0,0,0,0,0,0,0,0,4180,1);
REPLACE INTO `mob_db` VALUES (1381,'GRIZZLY','Grizzly','Grizzly',68,11733,0,3341,2012,1,809,1076,44,32,1,55,68,58,70,61,10,12,2,2,63,0x3885,165,1492,1092,192,0,0,0,0,0,0,0,0,948,5000,919,5000,549,2500,0,0,0,0,0,0,0,0,0,0,0,0,4162,1);
REPLACE INTO `mob_db` VALUES (1382,'DIABOLIC','Diabolic','Diabolic',67,9642,0,3662,2223,1,796,1059,64,36,1,84,53,67,71,69,10,12,0,6,47,0x3985,150,1080,780,180,0,0,0,0,0,0,0,0,1038,5820,1039,4850,2605,3,984,20,1263,10,0,0,0,0,0,0,0,0,4182,1);
REPLACE INTO `mob_db` VALUES (1383,'EXPLOSION','Explosion','Explosion',46,8054,0,2404,1642,1,336,447,35,27,1,61,56,50,66,38,10,12,0,2,63,0x3885,165,1260,960,336,0,0,0,0,0,0,0,0,7006,5500,7097,2200,7122,3200,756,800,522,400,0,0,0,0,0,0,0,0,4267,1);
REPLACE INTO `mob_db` VALUES (1384,'DELETER','Deleter','Deleter',66,17292,0,3403,2066,1,446,593,45,53,1,104,40,65,72,54,10,12,1,9,43,0x308D,175,1020,720,384,0,0,0,0,0,0,0,0,7123,4074,1035,5335,1037,3880,1036,3589,0,0,0,0,0,0,0,0,0,0,4158,1);
REPLACE INTO `mob_db` VALUES (1385,'DELETER_','Deleter','Deleter',65,15168,0,3403,2066,1,446,593,52,53,1,66,40,65,72,68,10,12,1,9,43,0x308D,175,1024,624,336,0,0,0,0,0,0,0,0,7123,4074,1035,5335,1037,3880,1036,3589,0,0,0,0,0,0,0,0,0,0,4279,1);
REPLACE INTO `mob_db` VALUES (1386,'SLEEPER','Sleeper','Sleeper',67,8237,0,3603,2144,1,593,789,49,35,1,48,100,57,75,28,10,12,1,0,42,0x3885,195,1350,1200,432,0,0,0,0,0,0,0,0,7124,4947,1056,5335,997,2500,756,300,1226,5,1622,5,7043,1200,0,0,0,0,4228,1);
REPLACE INTO `mob_db` VALUES (1387,'GIG','Gig','Gig',60,8409,0,3934,2039,1,360,479,60,28,1,61,80,53,59,46,10,12,0,2,43,0x3885,170,1264,864,576,0,0,0,0,0,0,0,0,7125,4365,904,5500,716,150,525,2500,994,850,0,0,0,0,0,0,0,0,4165,1);
REPLACE INTO `mob_db` VALUES (1388,'ARCHANGELING','Archangeling','Arc Angeling',60,79523,0,4152,2173,1,669,890,54,58,1,65,80,74,65,105,10,12,1,8,66,0x37B5,180,1072,672,480,0,0,0,0,0,0,0,0,2255,5,610,1800,608,150,7291,1500,2254,5,2317,3,7294,1500,0,0,0,0,4241,1);
REPLACE INTO `mob_db` VALUES (1389,'DRACULA','Dracula','Dracula',85,320096,0,120157,38870,3,1625,1890,45,76,1,95,90,87,85,100,10,12,2,6,87,0x37B5,145,1290,1140,576,60078,10000,607,5500,732,5000,522,5000,607,4700,1473,5,1722,5,2507,15,2621,4,1557,4,0,0,0,0,0,0,4134,1);
REPLACE INTO `mob_db` VALUES (1390,'VIOLY','Violy','Violy',75,18257,0,6353,3529,10,738,982,37,36,1,93,54,58,101,83,10,12,1,7,40,0x2085,170,1356,1056,540,0,0,0,0,0,0,0,0,1060,6305,12127,50,740,1200,1919,50,526,1400,12020,1000,1902,500,0,0,0,0,4209,1);
REPLACE INTO `mob_db` VALUES (1391,'GALAPAGO','Galapago','Galapago',61,9145,0,3204,1966,1,457,608,33,33,1,56,56,45,66,57,10,12,0,2,22,0x108B,165,1430,1080,1080,0,0,0,0,0,0,0,0,7053,5335,610,100,508,3500,606,100,605,100,5111,1,582,1000,0,0,0,0,4152,1);
REPLACE INTO `mob_db` VALUES (1392,'ROTAR_ZAIRO','Rotar Zairo','Rotar Zairo',25,1209,0,351,215,10,109,137,4,34,1,62,45,26,55,5,10,12,2,0,44,0x2085,155,2416,2016,432,0,0,0,0,0,0,0,0,7126,500,2312,1,7053,1000,999,450,984,1,912,2500,910,5500,0,0,0,0,4192,1);
REPLACE INTO `mob_db` VALUES (1393,'G_MUMMY','Mummy','Mummy',37,5176,0,0,0,1,305,360,0,10,28,19,32,0,63,20,10,12,1,1,49,0x3885,300,1772,72,384,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1394,'G_ZOMBIE','Zombie','Zombie',15,534,0,0,0,1,67,79,0,10,1,8,7,0,15,0,10,12,1,1,29,0x3885,400,2612,912,288,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1395,'CRYSTAL_1','Wind Crystal','Wind Crystal',1,15,0,0,0,0,0,0,100,99,1,1,1,1,999,1,0,0,0,0,20,0x161,190,0,0,0,0,0,0,0,0,0,0,0,539,3800,530,4500,561,5000,665,4900,5097,7000,532,6500,558,5000,607,200,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1396,'CRYSTAL_2','Earth Crystal','Earth Crystal',1,15,0,0,0,0,0,0,100,99,1,1,1,1,999,1,0,0,0,0,20,0x161,190,0,0,0,0,0,0,0,0,0,0,0,539,3800,530,4500,561,5000,667,4900,5097,7000,531,6500,558,5000,608,250,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1397,'CRYSTAL_3','Fire Crystal','Fire Crystal',1,15,0,0,0,0,0,0,100,99,1,1,1,1,999,1,0,0,0,0,20,0x161,190,0,0,0,0,0,0,0,0,0,0,0,539,3800,530,4500,561,5000,664,4900,5097,7000,534,6500,558,5000,604,300,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1398,'CRYSTAL_4','Water Crystal','Water Crystal',1,15,0,0,0,0,0,0,100,99,1,1,1,1,999,1,0,0,0,0,20,0x161,190,0,0,0,0,0,0,0,0,0,0,0,539,3800,530,4500,561,5000,666,4900,5097,7000,533,6500,558,5000,603,100,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1399,'EVENT_BAPHO','Baphomet','Baphomet',68,1264000,0,261750,83685,3,1847,2267,35,45,1,152,96,85,120,95,10,12,2,6,67,0x37B5,130,768,768,576,130875,10000,607,5500,526,5000,732,5000,1417,550,1306,680,1145,480,2110,640,2327,1500,2111,500,2621,1720,2256,1550,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1400,'KARAKASA','Karakasa','Karakasa',30,3092,0,489,322,1,141,183,1,5,1,45,12,20,49,60,10,12,1,0,60,0x81,155,1638,2016,576,0,0,0,0,0,0,0,0,7151,5000,7150,4268,1019,3200,7111,2200,912,4074,746,30,13012,5,0,0,0,0,4286,1);
REPLACE INTO `mob_db` VALUES (1401,'SHINOBI','Shinobi','Shinobi',69,12700,0,4970,3010,2,460,1410,34,21,85,85,25,25,100,100,10,12,1,7,67,0x3695,150,1003,1152,336,0,0,0,0,0,0,0,0,7156,5335,2337,2,7053,2200,2654,100,2336,1,7157,2000,13013,5,0,0,0,0,4230,1);
REPLACE INTO `mob_db` VALUES (1402,'POISON_TOAD','Poison Toad','Poison Toad',46,6629,0,1929,1457,3,288,408,5,10,20,34,19,14,66,55,10,12,1,2,45,0x81,160,1148,1728,864,0,0,0,0,0,0,0,0,7155,5500,7154,2400,2610,4,511,540,724,2,526,2,1246,10,0,0,0,0,4175,1);
REPLACE INTO `mob_db` VALUES (1403,'ANTIQUE_FIRELOCK','Antique Firelock','Firelock Soldier',47,3852,0,1293,1003,10,289,336,10,10,15,35,29,15,120,42,10,12,1,1,49,0x2085,170,1084,2304,576,0,0,0,0,0,0,0,0,998,5500,2285,1,7126,1400,508,40,549,350,525,250,13152,5,0,0,0,0,4160,1);
REPLACE INTO `mob_db` VALUES (1404,'MIYABI_NINGYO','Miyabi Ningyo','Miyabi Doll',33,6300,0,795,453,1,250,305,1,20,1,52,15,10,62,15,10,12,1,6,27,0x191,250,1938,2112,768,0,0,0,0,0,0,0,0,7152,5335,7153,2500,509,1550,1000,1250,12127,10,13014,5,1904,2,0,0,0,0,4208,1);
REPLACE INTO `mob_db` VALUES (1405,'TENGU','Tengu','Tengu',65,16940,0,4207,2843,2,660,980,12,82,90,42,69,45,78,80,10,12,2,6,42,0x3985,200,1439,1920,672,0,0,0,0,0,0,0,0,7159,3500,7158,5500,13301,5,522,150,13302,5,12128,20,687,100,0,0,0,0,4282,1);
REPLACE INTO `mob_db` VALUES (1406,'KAPHA','Kapha','Kapha',41,7892,0,2278,1552,3,399,719,20,38,1,51,49,22,73,45,10,12,1,5,21,0x3885,165,2012,1728,672,0,0,0,0,0,0,0,0,7149,6500,7053,3500,13304,20,521,2300,708,2,1915,10,13008,5,0,0,0,0,4287,1);
# REPLACE INTO `mob_db` VALUES (1407,'DOKEBI_','Dokebi','Dokebi',1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1408,'BLOOD_BUTTERFLY','Bloody Butterfly','Bloody Butterfly',55,8082,0,2119,1562,3,121,342,5,23,1,59,14,55,68,15,10,12,1,4,44,0x318D,145,472,576,288,0,0,0,0,0,0,0,0,7163,4608,7168,2500,602,1200,924,5500,1802,3,1962,1,0,0,0,0,0,0,4327,1);
REPLACE INTO `mob_db` VALUES (1409,'RICE_CAKE_BOY','Rice Cake Boy','Dumpling Child',27,2098,0,231,149,1,112,134,5,12,1,22,29,5,41,10,10,12,0,7,20,0x91,160,647,768,420,0,0,0,0,0,0,0,0,7150,3200,7151,2500,2262,1,7192,5000,553,1000,7187,3000,0,0,0,0,0,0,4154,1);
REPLACE INTO `mob_db` VALUES (1410,'LIVE_PEACH_TREE','Live Peach Tree','Enchanted Peach Tree',53,8905,0,2591,1799,7,301,351,10,38,72,45,35,39,80,5,10,12,1,3,42,0x2085,410,400,672,480,0,0,0,0,0,0,0,0,7164,4365,0,0,526,1000,604,400,532,100,603,5,0,0,0,0,0,0,4217,1);
# REPLACE INTO `mob_db` VALUES (1411,'PEACH_TREE_BULLET','Peach Tree Bullet','Peach Tree Bullet... (mode  129)',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1412,'EVIL_CLOUD_HERMIT','Evil Cloud Hermit','Taoist Hermit',56,10392,0,3304,2198,10,311,333,25,59,1,20,18,50,136,11,10,12,2,0,40,0x2085,190,480,840,432,0,0,0,0,0,0,0,0,7162,4656,548,5600,550,4500,553,6800,1908,2,757,150,693,100,0,0,0,0,4262,1);
REPLACE INTO `mob_db` VALUES (1413,'WILD_GINSENG','Wild Ginseng','Hermit Plant',46,6900,0,1038,692,1,220,280,10,20,13,42,36,55,66,30,10,12,0,3,43,0x91,140,512,756,360,0,0,0,0,0,0,0,0,520,3500,521,3500,1033,3800,1032,4800,516,4800,1951,1,578,1000,0,0,0,0,4232,1);
# REPLACE INTO `mob_db` VALUES (1414,'GINSENG_BULLET','Ginseng Bullet','Ginseng Bullet... (mode 129)',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1415,'BABY_LEOPARD','Baby Leopard','Baby Leopard',32,2590,0,352,201,2,155,207,0,5,20,44,20,4,49,10,10,12,0,2,28,0x3885,150,318,528,420,0,0,0,0,0,0,0,0,7171,5200,7172,3200,756,150,517,2000,1214,100,537,500,0,0,0,0,0,0,4233,1);
REPLACE INTO `mob_db` VALUES (1416,'WICKED_NYMPH','Wicked Nymph','Evil Nymph',63,16029,0,3945,2599,2,399,1090,12,75,1,64,12,69,100,80,10,12,1,6,67,0x3795,200,637,1008,360,0,0,0,0,0,0,0,0,7165,3977,7166,1380,984,10,1904,4,1906,1,12002,100,1918,10,0,0,0,0,4258,1);
REPLACE INTO `mob_db` VALUES (1417,'ZIPPER_BEAR','Zipper Bear','Zipper Bear',35,2901,0,370,225,1,248,289,10,5,30,25,55,15,28,25,10,12,1,2,27,0x91,155,780,1008,420,0,0,0,0,0,0,0,0,7161,4462,7167,3500,526,400,518,900,512,90,0,0,0,0,0,0,0,0,4281,1);
REPLACE INTO `mob_db` VALUES (1418,'DARK_SNAKE_LORD','Evil Snake Lord','Evil Snake Lord',73,254993,0,34288,17950,3,2433,4210,25,55,70,83,30,80,164,88,10,12,2,2,68,0x37B5,200,588,816,420,17144,10000,607,5500,608,3500,985,5500,7169,5820,10020,5100,1471,80,5012,80,1474,500,7226,900,661,2000,0,0,0,0,4330,1);
REPLACE INTO `mob_db` VALUES (1419,'G_FARMILIAR','Familiar','Familiar',8,155,0,0,0,1,20,28,0,0,1,12,8,5,28,0,10,12,0,2,27,0x3885,150,1276,576,384,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1420,'G_ARCHER_SKELETON','Archer Skeleton','Archer Skeleton',31,3040,0,0,0,9,128,153,0,0,1,8,14,5,90,5,10,12,1,1,29,0x3885,300,2864,864,576,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1421,'G_ISIS','Isis','Isis',43,4828,0,0,0,1,423,507,10,35,38,65,43,30,72,15,10,12,2,6,27,0x3985,200,1384,768,336,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1422,'G_HUNTER_FLY','Hunter Fly','Hunter Fly',42,5242,0,0,0,1,246,333,25,15,33,105,32,15,72,30,10,12,0,4,44,0x3985,150,676,576,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1423,'G_GHOUL','Ghoul','Ghoul',39,5118,0,0,0,1,420,500,5,20,1,20,29,0,33,20,10,12,1,1,49,0x3885,250,2456,912,504,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1424,'G_SIDE_WINDER','Side Winder','Side Winder',43,4929,0,0,0,1,240,320,5,10,38,43,40,15,115,20,10,12,1,2,25,0x3885,200,1576,576,576,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1425,'G_OBEAUNE','Obeaune','Obeaune',31,3952,0,0,0,1,141,165,0,40,1,31,31,55,74,85,10,12,1,5,41,0x3885,200,1872,672,288,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1426,'G_MARC','Marc','Marc',36,6900,0,0,0,1,220,280,5,10,1,36,36,20,56,30,10,12,1,5,41,0x3885,150,1272,72,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1427,'G_NIGHTMARE','Nightmare','Nightmare',49,4437,0,0,0,1,447,529,0,40,1,74,25,15,64,10,10,12,2,6,68,0x3985,150,1816,816,432,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1428,'G_POISON_SPORE','Poison Spore','Poison Spore',19,665,0,0,0,1,89,101,0,0,1,19,25,0,24,0,10,12,1,3,25,0x3885,200,1672,672,288,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1429,'G_ARGIOPE','Argiope','Argiope',41,4382,0,0,0,1,395,480,30,0,1,41,31,10,56,30,10,12,2,4,25,0x3985,300,1792,792,336,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1430,'G_ARGOS','Argos','Argos',25,1117,0,0,0,1,158,191,15,0,1,25,25,5,32,15,10,12,2,4,25,0x3985,300,1468,468,768,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1431,'G_BAPHOMET_','Baphomet Jr.','Baphomet Jr.',50,8578,0,0,0,1,487,590,15,25,1,75,55,1,93,45,10,12,0,6,27,0x3985,100,868,480,120,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1432,'G_DESERT_WOLF','Desert Wolf','Desert Wolf',27,1716,0,0,0,1,169,208,0,10,56,27,45,15,56,10,10,12,1,2,23,0x3885,200,1120,420,288,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1433,'G_DEVIRUCHI','Deviruchi','Deviruchi',46,7360,0,0,0,1,475,560,10,25,1,69,40,55,87,30,10,12,0,6,27,0x3985,150,980,600,384,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1434,'G_DRAINLIAR','Drainliar','Drainliar',24,1162,0,0,0,1,74,84,0,0,1,36,24,0,78,0,10,12,0,2,47,0x3885,250,1276,576,384,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1435,'G_EVIL_DRUID','Evil Druid','Evil Druid',58,16506,0,0,0,1,420,670,5,60,1,29,58,80,68,30,10,12,2,1,89,0x3885,300,2276,576,336,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1436,'G_JAKK','Jakk','Jakk',38,3581,0,0,0,1,315,382,5,30,1,38,38,43,75,45,10,12,1,0,43,0x3885,200,1180,480,648,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1437,'G_JOKER','Joker','Joker',57,12450,0,0,0,1,621,738,10,35,1,143,47,75,98,175,10,12,2,7,84,0x3885,100,1364,864,432,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1438,'G_KHALITZBURG','Khalitzburg','Khalitzburg',63,19276,0,0,0,1,875,1025,45,10,58,65,48,5,73,40,10,12,2,1,29,0x3885,350,528,1000,396,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1439,'G_HIGH_ORC','High Orc','High Orc',52,6890,0,0,0,1,428,533,15,5,55,46,55,35,82,40,10,12,2,7,43,0x3885,150,1500,500,1000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1440,'G_STEM_WORM','Stem Worm','Stem Worm',40,6136,0,0,0,2,290,375,5,10,1,30,26,15,79,35,10,12,1,3,24,0x3885,200,1500,500,1000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1441,'G_PENOMENA','Penomena','Penomena',57,7256,0,0,0,7,415,565,5,50,1,5,35,15,136,30,10,12,1,5,25,0x3885,400,832,500,600,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1442,'G_SASQUATCH','Sasquatch','Sasquatch',30,3163,0,0,0,1,250,280,5,0,75,25,60,10,34,20,10,12,2,2,60,0x3885,300,1260,192,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1443,'G_CRUISER','Cruiser','Cruiser',35,2820,0,0,0,7,175,215,5,5,1,40,10,10,90,25,10,12,1,0,60,0x3885,400,1296,1296,432,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1444,'G_CHEPET','Chepet','Chepet',42,4950,0,0,0,1,380,440,0,25,1,72,35,71,65,85,10,12,1,7,23,0x3885,400,672,672,288,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1445,'G_RAGGLER','Raggler','Raggler',21,1020,0,0,0,1,102,113,0,5,18,10,32,20,39,35,10,12,0,2,24,0x3885,200,1000,900,384,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1446,'G_INJUSTICE','Injustice','Injustice',51,7600,0,0,0,1,480,600,0,0,84,42,39,0,71,35,10,12,1,1,47,0x3885,400,770,720,336,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1447,'G_GRYPHON','Gryphon','Gryphon',72,27800,0,0,0,1,880,1260,35,35,68,95,78,65,115,75,10,12,2,2,84,0x39A5,100,704,504,432,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1448,'G_DARK_FRAME','Dark Frame','Dark Frame',59,7500,0,0,0,1,960,1210,10,45,1,72,42,45,85,25,10,12,1,6,67,0x3985,200,920,720,200,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1449,'G_MUTANT_DRAGON','Mutant Dragon','Mutant Dragonoid',65,62600,0,0,0,4,2400,3400,15,20,75,47,30,68,45,35,10,12,2,9,43,0x39A5,250,1280,1080,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1450,'G_WIND_GHOST','Wind Ghost','Wind Ghost',51,4820,0,0,0,2,489,639,0,45,1,89,15,90,85,25,10,12,1,6,64,0x3985,150,1056,1056,336,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1451,'G_MERMAN','Merman','Merman',53,12300,0,0,0,2,482,603,10,35,72,45,46,15,85,55,10,12,1,7,41,0x3885,220,916,816,336,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1452,'G_ORC_LADY','Orc Lady','Orc Lady',31,2000,0,0,0,1,135,170,10,10,35,42,25,15,69,55,10,12,1,7,42,0x3885,200,1050,900,288,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1453,'G_RAYDRIC_ARCHER','Raydric Archer','Raydric Archer',52,5250,0,0,0,9,415,500,35,5,15,25,22,5,145,35,10,12,1,6,47,0x3985,200,1152,1152,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1454,'G_TRI_JOINT','Tri Joint','Tri Joint',32,2300,0,0,0,1,178,206,20,5,1,48,24,10,67,20,10,12,0,4,22,0x3985,200,860,660,624,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1455,'G_KOBOLD_ARCHER','Kobold Archer','Kobold Archer',33,2560,0,0,0,9,155,185,10,5,10,20,15,30,100,25,10,12,0,7,23,0x3885,200,1008,1008,384,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1456,'G_CHIMERA','Chimera','Chimera',70,32600,0,0,0,1,1200,1320,30,10,1,72,110,88,75,85,10,12,2,2,63,0x39A5,200,772,672,360,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1457,'G_MANTIS','Mantis','Mantis',26,2472,0,0,0,1,118,149,10,0,1,26,24,5,45,15,10,12,1,4,22,0x3985,200,1528,660,432,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1458,'G_MARDUK','Marduk','Marduk',40,4214,0,0,0,1,315,382,0,60,1,40,20,79,78,20,10,12,2,7,23,0x3885,300,1540,840,504,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1459,'G_MARIONETTE','Marionette','Marionette',41,3222,0,0,0,1,355,422,0,25,1,62,36,44,69,45,10,12,0,6,68,0x3985,300,1480,480,1056,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1460,'G_MATYR','Matyr','Matyr',31,2585,0,0,0,1,134,160,0,0,1,47,38,5,64,5,10,12,1,2,27,0x3885,150,432,432,360,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1461,'G_MINOROUS','Minorous','Minorous',52,7431,0,0,0,1,590,770,15,5,65,42,61,66,52,25,10,12,2,2,43,0x3885,200,1360,960,432,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1462,'G_ORC_SKELETON','Orc Skeleton','Orc Skeleton',28,2278,0,0,0,1,190,236,10,10,1,14,18,0,30,15,10,12,1,1,29,0x3885,200,2420,720,648,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1463,'G_ORC_ZOMBIE','Orc Zombie','Orc Zombie',24,1568,0,0,0,1,151,184,5,10,1,12,24,0,24,5,10,12,1,1,29,0x3885,400,2852,1152,840,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1464,'G_PASANA','Pasana','Pasana',61,8289,0,0,0,1,513,682,29,35,1,73,50,61,69,43,10,12,1,7,43,0x3885,165,976,576,288,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1465,'G_PETIT','Petite','Petite',44,6881,0,0,0,1,360,427,30,30,1,44,62,55,79,60,10,12,1,9,22,0x3885,200,1624,620,384,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1466,'G_PETIT_','Petite','Petite',45,5747,0,0,0,1,300,355,20,45,1,113,45,55,73,80,10,12,1,9,24,0x3885,150,1420,1080,528,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1467,'G_RAYDRIC','Raydric','Raydric',52,8613,0,0,0,1,830,930,40,15,58,47,42,5,69,26,10,12,2,7,47,0x3885,150,824,780,420,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1468,'G_REQUIEM','Requim','Requim',35,3089,0,0,0,1,220,272,0,15,1,53,35,5,57,2,10,12,1,7,27,0x3885,400,1516,816,432,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1469,'G_SKEL_WORKER','Skeleton Worker','Skeleton Worker',30,2872,0,0,0,1,242,288,0,15,1,15,30,5,42,10,10,12,1,1,29,0x3885,400,2420,720,384,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1470,'G_ZEROM','Zerom','Zerom',23,1109,0,0,0,1,127,155,0,10,1,23,23,5,42,0,10,12,1,7,23,0x3885,200,1780,1080,432,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1471,'G_NINE_TAIL','Nine Tail','Nine Tail',51,9466,0,0,0,1,610,734,10,25,1,80,46,1,89,85,10,12,1,2,63,0x3885,150,840,540,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1472,'G_BON_GUN','Bongun','Bongun',32,3520,0,0,0,1,220,260,0,0,45,15,36,10,48,15,10,12,1,1,29,0x3885,200,1720,500,420,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1473,'G_ORC_ARCHER','Orc Archer','Orc Archer',49,7440,0,0,0,9,310,390,10,5,1,44,25,20,125,20,10,12,1,7,22,0x3885,300,1960,620,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1474,'G_MIMIC','Mimic','Mimic',51,6120,0,0,0,1,150,900,10,40,44,121,1,60,75,110,10,12,1,0,60,0x3885,100,972,500,288,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1475,'G_WRAITH','Wraith','Wraith',53,10999,0,0,0,1,580,760,5,30,1,95,30,65,95,35,10,12,2,1,89,0x3885,300,1816,576,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1476,'G_ALARM','Alarm','Alarm',58,10647,0,0,0,1,480,600,15,15,1,62,72,10,85,45,10,12,1,0,60,0x3885,300,1020,500,768,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1477,'G_ARCLOUSE','Arclouse','Arclouze',59,6075,0,0,0,1,570,640,10,15,1,75,5,5,75,50,10,12,1,4,42,0x3985,100,960,500,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1478,'G_RIDEWORD','Rideword','Rideword',59,11638,0,0,0,1,584,804,5,35,48,75,10,20,120,45,10,12,0,0,60,0x3885,150,864,500,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1479,'G_SKEL_PRISONER','Skeleton Prisoner','Skeleton Prisoner',52,8691,0,0,0,1,660,890,10,20,55,20,36,0,76,25,10,12,1,1,69,0x3885,350,1848,500,576,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1480,'G_ZOMBIE_PRISONER','Zombie Prisoner','Zombie Prisoner',53,11280,0,0,0,1,780,930,10,20,1,24,39,0,72,25,10,12,1,1,69,0x3885,350,1768,500,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1481,'G_PUNK','Punk','Punk',43,3620,0,0,0,1,292,365,0,45,1,105,5,45,65,20,10,12,0,3,24,0x3885,300,1500,500,1000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1482,'G_ZHERLTHSH','Zherlthsh','Zealotus',63,18300,0,0,0,1,700,850,10,15,70,85,40,30,125,60,10,12,1,7,60,0x3885,200,800,792,384,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1483,'G_RYBIO','Rybio','Rybio',71,9572,0,0,0,1,686,912,45,37,1,97,75,74,77,90,10,12,2,6,40,0x3985,200,1790,1440,540,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1484,'G_PHENDARK','Phendark','Phendark',73,22729,0,0,0,2,794,1056,52,36,1,62,120,65,76,66,10,12,2,7,40,0x3885,175,1744,1344,600,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1485,'G_MYSTELTAINN','Mysteltainn','Mysteltainn',76,33350,0,0,0,2,1160,1440,30,30,77,139,80,35,159,65,10,12,2,0,87,0x39A5,250,1152,500,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1486,'G_TIRFING','Tirfing','Ogretooth',71,29900,0,0,0,1,950,1146,30,35,58,87,55,35,132,65,10,12,1,0,67,0x39A5,100,816,500,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1487,'G_EXECUTIONER','Executioner','Executioner',65,28980,0,0,0,2,570,950,35,35,64,85,40,25,88,60,10,12,2,0,47,0x39A5,200,768,500,384,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1488,'G_ANOLIAN','Anolian','Anolian',63,18960,0,0,0,1,640,760,15,15,1,43,58,25,97,65,10,12,1,5,41,0x3885,190,900,500,864,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1489,'G_STING','Sting','Sting',61,9500,0,0,0,1,850,1032,5,30,57,45,55,5,120,85,10,12,1,0,62,0x3885,300,528,500,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1490,'G_WANDER_MAN','Wander Man','Wanderer',74,8170,0,0,0,2,450,1170,5,5,1,192,38,45,127,85,10,12,1,6,24,0x3985,100,672,500,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1491,'G_DOKEBI','Dokebi','Dokebi',33,2697,0,0,0,1,197,249,0,10,50,50,40,35,69,40,10,12,0,6,27,0x3985,250,1156,456,384,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);

# Umbala
REPLACE INTO `mob_db` VALUES (1492,'INCANTATION_SAMURAI','Incantation Samurai','Samurai Specter',71,218652,0,33095,18214,3,2219,3169,10,51,91,85,30,85,150,60,10,12,2,7,67,0x37B5,135,874,1344,576,16547,10000,607,5500,608,3500,985,5500,1165,2,985,3500,5096,500,607,4500,999,6305,13303,7500,1235,80,0,0,0,0,4263,1);
REPLACE INTO `mob_db` VALUES (1493,'DRYAD','Dryad','Dryad',50,8791,0,2763,1493,3,499,589,15,33,1,75,55,1,78,45,10,12,1,3,82,0x3885,170,950,2520,576,0,0,0,0,0,0,0,0,7197,5335,7198,1000,7188,3000,1951,80,1964,1,2270,10,7100,3000,0,0,0,0,4177,1);
REPLACE INTO `mob_db` VALUES (1494,'KIND_OF_BEETLE','Beetle King','Beetle King',34,1874,0,679,442,1,191,243,45,12,1,34,10,0,40,0,10,12,0,4,22,0x1189,165,1247,768,576,0,0,0,0,0,0,0,0,7190,6500,7202,4500,928,1000,955,500,2102,1,0,0,0,0,0,0,0,0,4307,1);
REPLACE INTO `mob_db` VALUES (1495,'STONE_SHOOTER','Stone Shooter','Stone Shooter',42,4104,0,1238,752,10,309,350,12,45,1,40,20,79,92,20,10,12,1,3,63,0x3885,175,2413,1248,768,0,0,0,0,0,0,0,0,7203,5000,7201,5000,7188,1000,1019,2000,756,100,7049,1000,0,0,0,0,0,0,4225,1);
# REPLACE INTO `mob_db` VALUES (1496,'STONE_SHOOTER_BULLET','Stone Shooter Bullet','Stone Shooter Bullet','(mode 2181)',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1497,'WOODEN_GOLEM','Wooden Golem','Wooden Golem',51,9200,0,1926,1353,1,570,657,32,36,1,41,69,5,85,155,10,12,2,3,82,0x3885,165,1543,1632,480,0,0,0,0,0,0,0,0,7189,4000,7188,4000,757,110,2270,10,604,100,7201,5000,921,1000,0,0,0,0,4259,1);
REPLACE INTO `mob_db` VALUES (1498,'WOOTAN_SHOOTER','Wootan Shooter','Wootan Shooter',39,3977,0,886,453,10,84,105,10,28,15,35,29,15,100,42,10,12,1,7,42,0x3885,200,857,1056,576,0,0,0,0,0,0,0,0,7195,4500,7200,3500,513,1000,7049,1000,512,100,7182,100,5116,10,0,0,0,0,4260,1);
REPLACE INTO `mob_db` VALUES (1499,'WOOTAN_FIGHTER','Wootan Fighter','Wootan Fighter',41,4457,0,1790,833,1,395,480,30,19,1,41,31,10,45,30,10,12,1,7,43,0x3885,200,912,1344,480,0,0,0,0,0,0,0,0,517,4500,7196,4000,1801,3,1812,1,513,1000,7198,1000,5116,5,0,0,0,0,4261,1);
REPLACE INTO `mob_db` VALUES (1500,'PARASITE','Parasite','Parasite',49,5188,0,1098,1453,8,215,430,10,19,1,40,30,30,90,50,10,12,1,3,44,0x84,400,864,864,672,0,0,0,0,0,0,0,0,7193,5500,7194,2000,7186,3880,7198,500,1957,1,1969,1,711,500,0,0,0,0,4309,1);
# REPLACE INTO `mob_db` VALUES (1501,'PARASITE_BULLET','Parasite Bullet','Parasite Bullet... (mode 2181)',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1502,'PORING_V','Pori Pori','Bring it on!',99,95000000,0,87250,27895,1,10000,30000,0,10,100,100,65,100,255,255,10,12,1,3,25,0x39A5,160,1672,672,480,43625,10000,10020,1000,4005,100,2286,200,5035,10000,2344,2500,2346,2500,2350,2500,2348,2500,2655,4000,7126,10000,2110,4500,0,0,0,0);

# Niflheim
REPLACE INTO `mob_db` VALUES (1503,'GIBBET','Gibbet','Gibbet',58,6841,0,4011,1824,1,418,656,28,31,0,42,42,27,46,28,10,12,2,6,27,0x3985,180,917,1584,576,0,0,0,0,0,0,0,0,7212,1800,7218,5335,7222,4074,724,300,716,100,604,10,0,0,0,0,0,0,4278,1);
REPLACE INTO `mob_db` VALUES (1504,'DULLAHAN','Dullahan','Dullahan',62,12437,0,4517,2963,2,647,1065,47,38,0,30,5,45,62,22,10,12,1,1,49,0x3885,155,847,1152,480,0,0,0,0,0,0,0,0,7209,3200,7210,4850,2614,1,2505,13,2506,1,0,0,0,0,0,0,0,0,4176,1);
REPLACE INTO `mob_db` VALUES (1505,'LOLI_RURI','Loli Ruri','Loli Ruri',71,23470,0,6641,4314,2,1476,2317,39,44,0,66,54,74,81,43,10,12,2,6,87,0x3985,125,747,1632,576,0,0,0,0,0,0,0,0,7206,800,7219,3000,7214,5044,985,100,7019,1,2718,5,0,0,0,0,0,0,4191,1);
REPLACE INTO `mob_db` VALUES (1506,'DISGUISE','Disguise','Disguise',55,7543,180,2815,1919,2,279,546,18,29,0,72,45,35,48,65,10,12,1,6,82,0x3985,147,516,768,384,0,0,0,0,0,0,0,0,7216,4850,7221,3686,2502,50,518,100,2508,50,2504,2,2529,5,0,0,0,0,4181,1);
REPLACE INTO `mob_db` VALUES (1507,'BLOODY_MURDERER','Bloody Murderer','Bloody Murderer',72,27521,0,9742,3559,2,864,1081,37,41,0,30,90,15,52,12,10,12,2,7,67,0x3885,175,914,1344,384,0,0,0,0,0,0,0,0,7207,4171,7223,1000,7208,2000,2288,50,984,100,1229,3,13002,1,0,0,0,0,4214,1);
REPLACE INTO `mob_db` VALUES (1508,'QUVE','Quve','Quve',40,4559,0,414,306,1,299,469,12,12,0,61,24,19,37,24,10,12,0,1,29,0x3885,150,912,1248,576,0,0,0,0,0,0,0,0,7205,3200,7220,5723,601,1000,7154,100,756,10,0,0,0,0,0,0,0,0,4294,1);
REPLACE INTO `mob_db` VALUES (1509,'LUDE','Lude','Lude',36,3214,0,392,247,2,287,451,14,10,0,59,21,18,36,21,10,12,0,1,29,0x3885,150,890,960,480,0,0,0,0,0,0,0,0,7225,3200,7220,5723,1059,1000,2282,10,757,10,12001,100,0,0,0,0,0,0,4193,1);
REPLACE INTO `mob_db` VALUES (1510,'HYLOZOIST','Hylozoist','Heirozoist',51,7186,0,2314,1297,1,317,498,16,51,0,28,26,47,66,14,10,12,0,6,47,0x3985,155,741,1536,480,0,0,0,0,0,0,0,0,7215,4365,7217,5335,7213,2000,740,80,7220,300,757,10,5113,1,0,0,0,0,4321,1);

REPLACE INTO `mob_db` VALUES (1511,'AMON_RA','Amon Ra','Amon Ra',88,1214138,0,87264,35891,3,1647,2576,26,52,0,1,90,124,74,45,14,12,2,7,62,0x1A4,170,854,2016,480,43632,10000,607,5500,608,3500,732,5500,5053,150,2615,50,7211,7760,985,3880,616,400,1552,10,607,3000,0,0,0,0,4236,1);

# Louyang
REPLACE INTO `mob_db` VALUES (1512,'HYEGUN','Hyegun','Yao Jun',56,9981,0,2199,1022,1,710,1128,12,10,60,40,36,10,73,15,10,12,1,1,49,0x3885,180,890,1320,720,0,0,0,0,0,0,0,0,7054,3880,609,100,985,10,2406,1,7277,300,0,0,0,0,0,0,0,0,4328,1);
REPLACE INTO `mob_db` VALUES (1513,'CIVIL_SERVANT','Civil Servant','Mao Guai',62,14390,0,4023,2750,2,650,1010,42,5,58,15,20,60,80,50,10,12,1,2,44,0x3885,200,1257,528,432,0,0,0,0,0,0,0,0,7262,4171,7263,2000,606,10,1023,100,693,100,0,0,0,0,0,0,0,0,4202,1);
REPLACE INTO `mob_db` VALUES (1514,'DANCING_DRAGON','Dancing Dragon','Zhu Po Long',54,9136,0,3030,769,2,550,789,39,10,55,62,55,25,72,22,10,12,1,9,44,0x83,160,600,840,504,0,0,0,0,0,0,0,0,7266,4365,7265,3000,7268,800,1036,1000,7038,3000,0,0,0,0,0,0,0,0,4272,1);
REPLACE INTO `mob_db` VALUES (1515,'GARM_BABY','Garm Baby','Garm Baby',61,20199,0,1022,2980,1,680,1179,34,13,45,30,56,55,85,30,10,12,1,2,41,0x3885,450,879,672,576,0,0,0,0,0,0,0,0,7270,1500,7269,2500,7066,4365,749,100,12000,100,0,0,0,0,0,0,0,0,4323,1);
REPLACE INTO `mob_db` VALUES (1516,'INCREASE_SOIL','Increase Soil','Mi Gao',51,8230,0,2760,2110,1,560,700,30,12,40,45,23,12,69,12,10,12,1,0,62,0x91,445,106,1056,576,0,0,0,0,0,0,0,0,7264,4365,7004,2300,997,10,969,2,0,0,0,0,0,0,0,0,0,0,4231,1);
REPLACE INTO `mob_db` VALUES (1517,'LI_ME_MANG_RYANG','Li Me Mang Ryang','Jing Guai',48,5920,0,1643,1643,1,434,633,23,16,46,51,19,8,57,30,10,12,1,6,62,0x3985,165,1120,576,420,0,0,0,0,0,0,0,0,7267,4500,7268,400,1501,10,1523,1,0,0,0,0,0,0,0,0,0,0,4265,1);
REPLACE INTO `mob_db` VALUES (1518,'BACSOJIN','Bacsojin','White Lady',72,56380,0,5590,1659,2,560,1446,10,15,38,65,34,80,102,35,10,12,2,7,41,0x3695,160,576,960,480,0,0,0,0,0,0,0,0,1020,5500,603,2,617,2,7165,3000,7166,1000,747,500,0,0,2234,1,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1519,'CHUNG_E','Chung E','Green Maiden',49,23900,0,2396,993,1,460,1050,8,15,38,65,43,30,90,15,10,12,1,7,40,0x3695,170,1728,816,1188,0,0,0,0,0,0,0,0,7053,4850,740,100,1806,10,518,500,12395,20,5024,50,0,0,5042,2,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1520,'BOILED_RICE','Boiled Rice','Boiled Rice',15,400,0,84,45,1,49,82,0,10,1,14,14,0,19,15,10,12,1,3,21,0x81,170,1152,672,672,0,0,0,0,0,0,0,0,564,5500,7272,3000,7194,1000,7198,1000,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1521,'G_ALICE','Alice','Alice',62,10000,0,0,0,1,550,700,5,5,64,64,42,85,100,130,10,12,1,7,60,0x91,200,520,2304,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1522,'G_ANCIENT_MUMMY','Ancient Mummy','Ancient Mummy',64,40599,0,0,0,1,836,1129,27,27,28,19,32,5,83,35,10,12,1,1,49,0x3695,175,1772,120,384,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1523,'G_ANTIQUE_FIRELOCK','Antique Firelock','Firelock Soldier',47,3852,0,0,0,10,289,336,10,10,15,35,29,15,120,42,10,12,1,1,49,0x2085,170,1084,2304,576,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1524,'G_BABY_LEOPARD','Baby Leopard','Baby Leopard',32,2590,0,0,0,2,155,207,0,5,20,44,20,4,49,10,10,12,0,2,28,0x3885,150,318,528,420,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1525,'G_BATHORY','Bathory','Bathory',44,5415,0,0,0,1,198,398,0,60,1,76,24,85,65,15,10,12,1,7,27,0x3695,100,1504,840,900,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1526,'G_BLOOD_BUTTERFLY','Bloody Butterfly','Bloody Butterfly',55,8082,0,0,0,3,121,342,5,23,1,59,14,55,68,15,10,12,1,4,44,0x318D,145,472,576,288,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1527,'G_C_TOWER_MANAGER','Clock Tower Manager','Clock Tower Manager',63,18600,0,0,0,3,880,1180,35,30,1,75,20,64,75,60,10,12,2,0,80,0x91,200,1072,672,384,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1528,'G_CLOCK','Clock','Clock',60,11050,0,0,0,1,720,909,15,10,1,70,50,25,90,50,10,12,1,0,42,0x91,200,1092,792,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1529,'G_DARK_SNAKE_LORD','Dark Snake Lord','Evil Snake Lord',73,254993,0,0,0,3,1433,2210,25,55,70,83,62,80,164,88,10,12,2,2,68,0x37B5,200,588,816,420,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1530,'G_DRACULA','Dracula','Dracula',85,320096,0,0,0,3,1625,1890,45,76,1,95,90,87,85,100,10,12,2,6,87,0x37B5,145,1290,1140,576,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1531,'G_EVIL_CLOUD_HERMIT','Evil Cloud Hermit','Taoist Hermit',56,10392,0,0,0,10,311,333,25,59,1,20,18,50,136,11,10,12,2,0,40,0x2085,190,480,840,432,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1532,'G_EXPLOSION','Explosion','Explosion',46,8054,0,0,0,1,336,447,35,27,1,61,56,50,66,38,10,12,0,2,63,0x3885,165,1260,960,336,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1533,'G_FUR_SEAL','Fur Seal','Seal',63,9114,0,0,0,1,845,1203,25,33,5,28,22,15,69,84,10,12,1,2,21,0x3095,200,1612,622,583,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1534,'G_GOBLIN_1','Goblin','Goblin',25,1176,0,0,0,1,118,140,10,5,1,53,25,20,38,10,10,12,1,7,24,0x3695,100,1120,620,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1535,'G_GOBLIN_2','Goblin','Goblin',24,1034,0,0,0,1,88,100,10,5,1,24,24,15,66,10,10,12,1,7,23,0x3095,150,1320,620,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1536,'G_GOBLIN_3','Goblin','Goblin',24,1034,0,0,0,1,132,165,10,5,1,24,24,15,24,10,10,12,1,7,25,0x308D,250,1624,624,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1537,'G_GOBLIN_4','Goblin','Goblin',23,1359,0,0,0,1,109,131,10,5,1,23,46,15,36,10,10,12,1,7,22,0x308D,200,1624,624,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1538,'G_GOBLIN_5','Goblin','Goblin',22,1952,0,0,0,1,105,127,10,5,1,22,22,15,32,10,10,12,1,7,21,0x308D,300,3074,1874,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1539,'G_GOBLIN_LEADER','Goblin Leader','Goblin Leader',64,20152,0,0,0,1,663,752,48,16,5,55,37,30,69,58,10,12,1,7,24,0x3695,120,1120,620,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1540,'G_GOLEM','Golem','Golem',25,3900,0,0,0,1,175,187,40,0,1,15,25,0,15,0,10,12,2,0,60,0x91,300,1608,816,396,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1541,'G_GREATEST_GENERAL','Greatest General','Greatest General',40,3632,0,0,0,3,350,400,15,15,1,20,60,55,82,140,10,12,1,0,43,0x84,200,1152,1152,384,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1542,'G_INCANTATION_SAMURA','Incantation Samurai','Incantation Samurai',71,218652,0,0,0,3,1219,2169,10,51,91,85,78,85,150,60,10,12,2,7,67,0x37B5,135,874,1344,576,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1543,'G_KAPHA','Kapha','Kapha',41,7892,0,0,0,3,399,719,20,38,1,51,49,22,73,45,10,12,1,5,21,0x3885,165,2012,1728,672,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1544,'G_KARAKASA','Karakasa','Karakasa',30,3092,0,0,0,1,141,183,1,5,1,45,12,20,49,60,10,12,1,0,60,0x81,155,1638,2016,576,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1545,'G_KOBOLD_1','Kobold','Kobold',36,3893,0,0,0,1,265,318,15,10,1,90,36,30,52,20,10,12,1,7,44,0x308D,150,1028,528,360,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1546,'G_KOBOLD_2','Kobold','Kobold',31,2179,0,0,0,1,262,324,15,10,1,31,31,20,46,20,10,12,1,7,45,0x308D,200,1528,528,360,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1547,'G_KOBOLD_3','Kobold','Kobold',31,2179,0,0,0,1,186,216,15,10,1,31,31,20,88,20,10,12,1,7,43,0x308D,300,1228,528,360,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1548,'G_KOBOLD_LEADER','Kobold Leader','Kobold Leader',65,18313,0,0,0,1,649,958,37,37,5,90,36,30,77,59,10,12,1,7,44,0x3695,150,1028,528,360,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1549,'G_LAVA_GOLEM','Lava Golem','Lava Golem',77,24324,0,0,0,1,1541,2049,65,50,1,57,115,70,76,68,10,12,2,0,83,0x3095,400,2190,2040,336,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1550,'G_LIVE_PEACH_TREE','Live Peach Tree','Enchanted Peach Tree',53,8905,0,0,0,7,301,351,10,38,72,45,35,39,80,5,10,12,1,3,42,0x2085,410,400,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1551,'G_MARSE','Marse','Marse',31,5034,0,0,0,1,211,252,0,5,1,31,25,5,52,30,10,12,0,5,41,0x91,300,1956,756,528,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1552,'G_MIYABI_NINGYO','Miyabi Ningyo','Miyabi Doll',33,6300,0,0,0,1,250,305,1,20,1,52,15,10,62,15,10,12,1,6,27,0x191,250,1938,2112,768,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1553,'G_MYST','Myst','Myst',38,3745,0,0,0,1,365,445,0,40,1,38,18,0,53,10,10,12,2,0,25,0x3695,200,1576,576,384,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1554,'G_NIGHTMARE_TERROR','Nightmare Terror','Nightmare Terror',78,22605,0,0,0,1,757,1007,37,37,1,76,55,60,76,54,10,12,2,6,67,0x3985,165,1216,816,432,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1555,'G_PARASITE','Parasite','Parasite',49,5188,0,0,0,8,215,430,10,19,1,40,30,30,90,50,10,12,1,3,44,0x84,400,864,864,672,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1556,'G_POISON_TOAD','Poison Toad','Poisonous Toad',46,6629,0,0,0,3,288,408,5,10,20,34,19,14,66,55,10,12,1,2,45,0x81,160,1148,1728,864,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1557,'G_ROTAR_ZAIRO','Rotar Zairo','Rotar Zairo',25,1209,0,0,0,10,109,137,4,34,1,62,45,26,55,5,10,12,2,0,44,0x2085,155,2416,2016,432,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1558,'G_SAND_MAN','Sandman','Sandman',34,3413,0,0,0,1,180,205,10,25,24,34,58,38,60,5,10,12,1,0,62,0x3885,250,1672,720,288,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1559,'G_SCORPION','Scorpion','Scorpion',24,1109,0,0,0,1,80,135,30,0,1,24,24,5,52,5,10,12,0,4,23,0x3195,200,1564,864,576,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1560,'G_SHINOBI','Shinobi','Shinobi',69,12700,0,0,0,2,460,1410,34,21,85,85,25,25,100,100,10,12,1,7,67,0x3695,150,1003,1152,336,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1561,'G_SMOKIE','Smokie','Smokie',18,641,0,0,0,1,61,72,0,10,1,18,36,25,26,35,10,12,0,2,22,0x91,200,1576,576,420,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1562,'G_SOLDIER_SKELETON','Soldier Skeleton','Soldier Skeleton',29,2334,0,0,0,1,221,245,10,15,1,15,22,5,40,15,10,12,1,1,29,0x3885,200,2276,576,432,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1563,'G_TENGU','Tengu','Tengu',65,16940,0,0,0,2,660,980,12,82,90,42,69,45,78,80,10,12,2,6,42,0x3985,200,1439,1920,672,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1564,'G_WICKED_NYMPH','Wicked Nymph','Evil Nymph',63,16029,0,0,0,2,399,1090,12,75,1,64,12,69,100,80,10,12,1,6,67,0x3795,200,637,1008,360,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1565,'G_WILD_GINSENG','Wild Ginseng','Hermit Plant',46,6900,0,0,0,1,220,280,10,20,13,42,36,55,66,30,10,12,0,3,43,0x91,140,512,756,360,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1566,'G_WRAITH_DEAD','Wraith Dead','Wraith Dead',74,43021,0,0,0,2,1366,1626,25,30,5,99,55,75,115,45,10,12,2,1,89,0x3695,175,1816,576,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1567,'G_ANCIENT_WORM','Ancient Worm','Ancient Worm',67,22598,0,0,0,1,948,1115,35,30,5,35,56,55,81,72,10,12,2,4,25,0x3795,165,1792,792,336,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1568,'G_ANGELING','Angeling','Angeling',20,55000,0,0,0,1,120,195,0,70,1,50,20,75,68,200,10,12,1,8,86,0x37B5,200,1072,672,672,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1569,'G_BLOODY_KNIGHT','Bloody Knight','Bloody Knight',82,57870,0,0,0,3,2150,3030,60,50,88,75,70,77,125,55,10,12,2,0,87,0x3695,250,828,528,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1570,'G_CRAMP','Cramp','Cramp',56,4720,0,0,0,1,395,465,0,5,1,85,35,5,65,60,10,12,0,2,45,0x3095,100,1000,500,1000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1571,'G_DEVIACE','Deviace','Deviace',47,19192,0,0,0,1,514,674,10,20,1,47,62,48,62,25,10,12,1,5,81,0x91,400,1680,480,384,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1572,'G_DROPS','Drops','Drops',3,55,0,0,0,1,10,13,0,0,1,3,3,0,12,15,10,12,1,3,23,0x83,400,1372,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1573,'G_ELDER','Elder','Elder',64,21592,0,0,0,3,421,560,45,68,1,76,68,108,72,86,10,12,2,7,80,0x3885,165,1552,1152,336,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1574,'G_ELDER_WILOW','Elder Willow','Elder Willow',20,693,0,0,0,1,58,70,10,30,1,20,25,35,38,30,10,12,1,3,43,0x3095,200,1372,672,432,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1575,'G_FLORA','Flora','Flora',26,2092,0,0,0,3,242,273,10,35,1,26,35,5,43,80,10,12,2,3,22,0x84,1000,1432,432,576,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1576,'G_GHOSTRING','Ghostring','Ghostring',18,73300,0,0,0,1,82,122,0,60,40,27,18,45,72,30,10,12,1,6,88,0x37B5,300,1220,1080,648,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1577,'G_GOBLIN_ARCHER','Goblin Archer','Goblin Archer',28,1750,0,0,0,9,89,113,0,0,10,15,20,15,72,20,10,12,0,7,25,0x2085,200,1172,672,420,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1578,'G_HORONG','Horong','Horong',34,1939,0,0,0,1,275,327,99,50,1,34,10,0,50,0,10,12,0,0,83,0x308D,400,1888,1152,828,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1579,'G_HYDRA','Hydra','Hydra',14,660,0,0,0,7,22,28,0,40,1,14,14,0,40,2,10,12,0,3,41,0x84,1000,800,432,600,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1580,'G_INCUBUS','Incubus','Incubus',75,17281,0,0,0,2,1408,1873,58,46,1,97,95,103,89,87,10,12,1,6,67,0x3795,165,850,600,336,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1581,'G_VOCAL','Vocal','Vocal',18,3016,0,0,0,1,71,82,10,30,77,28,26,30,53,40,10,12,1,4,22,0x3795,200,1080,648,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1582,'DEVILING','Deviling','Deviling',31,64500,0,211,412,1,135,270,5,70,30,50,20,75,77,200,10,12,1,6,87,0x37B5,200,1072,1056,384,0,0,0,0,0,0,0,0,1039,3000,912,4850,2255,100,512,5000,7023,1,983,100,694,100,0,0,0,0,4174,1);
REPLACE INTO `mob_db` VALUES (1583,'TAO_GUNKA','Tao Gunka','Tao Gunka',70,193000,0,59175,10445,2,1450,1770,20,20,1,85,78,35,140,60,10,12,2,6,60,0x37B5,150,1020,288,144,29587,10000,984,6000,617,3000,505,6000,7300,4850,7067,4850,728,1000,2296,400,504,3000,1002,1000,2231,5,0,0,0,0,4302,1);

# Ayothaya
REPLACE INTO `mob_db` VALUES (1584,'TAMRUAN','Tamruan','Tamruan',52,10234,0,3812,55,1,489,534,15,35,80,62,38,75,72,15,10,12,2,6,67,0x318D,140,512,1152,672,0,0,0,0,0,0,0,0,7301,4850,7069,3000,1117,40,1155,8,2315,3,0,0,0,0,0,0,0,0,4304,1);
REPLACE INTO `mob_db` VALUES (1585,'MIME_MONKEY','Mime Monkey','Mime Monkey',40,6000,0,200,22,3,300,350,40,40,1,40,40,40,40,30,10,12,1,3,21,0x83,400,1872,672,480,0,0,0,0,0,0,0,0,909,7000,1202,100,938,400,512,1000,713,1500,741,5,619,20,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1586,'LEAF_CAT','Leaf Cat','Leaf Cat',38,2396,0,165,1212,1,266,307,5,19,25,67,12,45,60,29,10,12,0,2,22,0x83,150,960,864,720,0,0,0,0,0,0,0,0,7198,4365,520,300,608,5,1023,1100,568,250,567,500,7298,5335,0,0,0,0,4195,1);
REPLACE INTO `mob_db` VALUES (1587,'KRABEN','Kraben','Kraben',50,5880,0,206,1322,1,125,765,5,42,50,125,1,66,75,50,10,12,1,0,48,0x3095,100,1152,1536,576,0,0,0,0,0,0,0,0,912,3500,519,3000,521,1000,2102,1,7299,4850,7286,1000,603,10,0,0,0,0,4295,1);

# Some more G_Mobs and Xmas_Orc
REPLACE INTO `mob_db` VALUES (1588,'ORC_XMAS','Christmas Orc','Christmas Orc',24,1400,0,261,160,1,104,126,10,5,1,24,48,25,34,10,10,12,1,7,22,0x81,200,1864,864,288,0,0,0,0,0,0,0,0,998,210,931,5500,756,40,7175,1600,1352,10,644,15,7174,1600,0,0,0,0,4066,1);
REPLACE INTO `mob_db` VALUES (1589,'G_MANDRAGORA','Mandragora','Mandragora',12,405,0,0,0,4,26,35,0,25,1,12,24,0,36,15,10,12,1,3,62,0x84,1000,1768,768,576,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1590,'G_GEOGRAPHER','Geographer','Geographer',56,8071,0,0,0,3,467,621,28,26,1,66,47,60,68,44,10,12,1,3,62,0x84,2000,1308,1008,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1591,'A_LUNATIC','Lunatic','Lunatic',29,2334,0,0,0,1,221,245,10,20,1,15,22,5,40,15,10,12,0,2,60,0xA1,200,1456,456,336,0,0,0,0,0,0,0,0,502,2000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1592,'A_MOBSTER','Gangster','Gangster',40,8000,0,0,0,1,300,355,20,27,1,50,45,45,73,30,10,12,1,7,20,0x11A9,250,1100,560,580,0,0,0,0,0,0,0,0,7049,10000,601,2000,1206,3000,713,1000,550,10000,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1593,'A_ANCIENT_MUMMY','Ancient Mummy','Ancient Mummy',52,8613,0,0,0,1,830,930,40,27,58,47,42,5,69,26,10,12,1,1,69,0xB5,175,1772,120,384,0,0,0,0,0,0,0,0,502,2000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1594,'G_FREEZER','Freezer','Freezer',72,8636,0,0,0,2,671,983,55,43,69,41,59,5,67,100,10,12,1,2,41,0x3695,250,1452,483,528,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1595,'G_MARIN','Marin','Marin',15,742,0,0,0,1,39,43,0,10,1,10,10,5,35,15,10,12,1,3,41,0x81,400,1872,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1596,'G_TAMRUAN','Tamruan','Tamruan',52,10234,0,0,0,1,489,534,15,35,80,62,38,75,72,15,10,12,2,6,67,0x318D,140,512,1152,672,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1597,'G_GARGOYLE','Gargoyle','Gargoyle',48,3950,0,0,0,9,290,360,10,10,15,61,20,20,126,40,10,12,1,6,64,0x2185,200,1020,720,384,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1598,'G_BLAZZER','Blazzer','Blazzer',43,8252,0,0,0,2,533,709,50,40,1,52,50,39,69,40,10,12,1,6,43,0x3395,180,1732,1332,540,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1599,'G_WHISPER_BOSS','Giant Whisper','Giant Whisper',34,5040,0,0,0,1,198,239,0,45,1,51,14,0,60,0,10,12,0,6,48,0x3795,250,2536,1536,672,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1600,'G_HEATER','Heater','Heater',68,11020,0,0,0,2,683,1008,40,42,69,47,25,5,71,100,10,12,1,2,43,0x3695,250,1452,483,528,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1601,'G_PERMETER','Permeter','Permeter',63,8228,0,0,0,2,943,1211,46,45,69,59,60,5,69,100,10,12,1,2,40,0x3695,250,1100,483,528,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1602,'G_SOLIDER','Solider','Solider',70,12099,0,0,0,2,797,979,57,43,69,35,85,5,74,100,10,12,1,2,42,0x3695,250,1452,483,528,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1603,'G_BIGFOOT','Bigfoot','Bigfoot',25,1619,0,0,0,1,198,220,10,0,1,25,55,15,20,25,10,12,2,2,22,0x91,300,1260,192,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1604,'G_GIANT_HONET','Giant Hornet','Giant Hornet',56,13105,0,0,0,1,650,852,38,43,35,38,32,10,71,64,10,12,0,4,24,0x3795,155,1292,792,340,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1605,'G_DARK_ILLUSION','Dark Illusion','Dark Illusion',77,103631,0,0,0,2,1300,1983,64,70,5,100,40,100,97,40,10,12,2,6,89,0x37B5,145,1024,768,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1606,'G_GARM_BABY','Garm Baby','Garm Baby',61,20199,0,0,0,1,680,1179,34,13,45,30,56,55,85,30,10,12,1,2,41,0x3885,450,879,672,576,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1607,'G_GOBLINE_XMAS','Christmas Goblin','Christmas Goblin',25,1176,0,0,0,1,118,140,10,5,1,53,25,20,38,45,10,12,1,7,24,0x3695,100,1120,620,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1608,'G_THIEF_BUG__','Thief Bug Male','Thief Bug Male',19,583,0,0,0,1,76,88,15,5,1,29,16,5,36,0,10,12,1,4,27,0x318D,300,988,288,768,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1609,'G_DANCING_DRAGON','Dancing Dragon','Zhu Po Long',54,9136,0,3030,769,2,550,789,39,10,55,62,55,25,72,22,10,12,1,9,44,0xA3,160,600,840,504,0,0,0,0,0,0,0,0,570,500,571,50,572,20,515,10000,12018,5000,0,0,0,0,668,100,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1610,'A_MUNAK','Munak','Munak',30,2872,0,0,0,1,40,50,0,0,1,15,20,5,120,15,10,12,1,1,89,0x39A5,100,2468,768,288,0,0,0,0,0,0,0,0,502,2000,0,0,0,0,0,0,0,0,0,0,12017,100,12016,100,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1611,'A_BON_GUN','Bongun','Bongun',32,3520,0,0,0,1,220,260,0,0,45,15,36,10,48,15,10,12,1,1,89,0x31B5,200,1720,500,420,0,0,0,0,0,0,0,0,502,2000,0,0,0,0,0,0,0,0,0,0,12017,100,12016,100,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1612,'A_HYEGUN','Hyegun','Yao Jun',56,9981,0,0,0,1,710,1128,12,10,60,40,36,10,73,15,10,12,1,1,89,0x39A5,180,890,1320,720,0,0,0,0,0,0,0,0,502,2000,0,0,0,0,0,0,0,0,0,0,12017,100,12016,100,0,0,0,0);

# Einbroch
REPLACE INTO `mob_db` VALUES (1613,'METALING','Metaling','Metaling',26,889,0,492,249,1,135,270,5,3,30,15,10,18,35,2,10,12,0,0,20,0x83,300,384,672,480,0,0,0,0,0,0,0,0,7325,4000,1002,1000,998,500,7126,1000,7317,200,13103,5,7312,5000,0,0,0,0,4341,1);
REPLACE INTO `mob_db` VALUES (1614,'MINERAL','Mineral','Mineral',56,7950,0,3563,1768,1,723,812,29,35,60,52,35,21,67,32,10,12,0,0,40,0x91,250,648,480,360,0,0,0,0,0,0,0,0,7321,3000,728,500,714,2,984,80,1011,800,715,100,969,2,0,0,0,0,4339,1);
REPLACE INTO `mob_db` VALUES (1615,'OBSIDIAN','Obsidian','Obsidian',50,8812,0,2799,1802,1,841,980,35,5,62,32,42,24,61,55,10,12,0,0,42,0x3885,350,720,864,504,0,0,0,0,0,0,0,0,7315,3000,730,500,1003,500,985,50,999,500,1263,10,0,0,0,0,0,0,4338,1);
REPLACE INTO `mob_db` VALUES (1616,'PITMAN','Pitman','Pitman',43,5015,0,1799,1083,1,290,486,22,26,0,15,5,5,52,36,10,12,2,1,42,0x91,180,960,336,300,0,0,0,0,0,0,0,0,7318,3000,7319,500,998,800,999,500,1003,100,1041,1000,7327,80,0,0,0,0,4335,1);
REPLACE INTO `mob_db` VALUES (1617,'WASTE_STOVE','Waste Stove','Old Stove',68,15895,0,4412,1135,1,692,1081,23,10,20,69,55,5,59,77,10,12,2,0,20,0x3885,300,1152,528,360,0,0,0,0,0,0,0,0,7323,1000,7068,1000,998,500,625,50,1002,1000,604,50,7319,3800,0,0,0,0,4332,1);
REPLACE INTO `mob_db` VALUES (1618,'UNGOLIANT','Ungoliant','Ungoliant',69,29140,0,8211,142,1,1290,2280,25,25,33,52,57,25,119,43,10,12,2,4,45,0x3795,350,420,576,420,0,0,0,0,0,0,0,0,7316,4500,1014,3500,1013,1000,7289,1500,7326,2500,718,1500,2406,500,0,0,0,0,4336,1);
REPLACE INTO `mob_db` VALUES (1619,'PORCELLIO','Porcellio','Porcellio',28,1654,0,512,346,1,82,247,0,8,0,31,21,50,54,85,10,12,0,4,62,0x183,150,720,360,360,0,0,0,0,0,0,0,0,7312,5000,1208,25,928,1000,1052,3000,630,2,7326,30,0,0,0,0,0,0,4337,1);
REPLACE INTO `mob_db` VALUES (1620,'NOXIOUS','Noxious','Noxious',35,2038,0,698,698,1,299,400,0,60,12,41,10,30,44,2,10,12,1,0,68,0x3885,350,768,1440,672,0,0,0,0,0,0,0,0,7322,1000,7001,3000,605,50,7320,3000,0,0,0,0,603,1,0,0,0,0,4334,1);
REPLACE INTO `mob_db` VALUES (1621,'VENOMOUS','Venomous','Venomous',42,4653,0,1780,1280,1,422,844,0,49,12,60,17,19,60,1,10,12,1,0,25,0x3885,350,768,1440,672,0,0,0,0,0,0,0,0,7320,5000,7119,3000,7154,1000,7322,2000,0,0,0,0,603,1,0,0,0,0,4333,1);
REPLACE INTO `mob_db` VALUES (1622,'TEDDY_BEAR','Teddy Bear','Teddy Bear',71,8109,0,5891,3455,1,621,1432,19,32,5,155,32,41,121,26,10,12,0,0,60,0x3295,200,512,780,504,0,0,0,0,0,0,0,0,7317,3800,518,1000,615,300,13106,5,5113,50,2652,10,985,100,0,0,0,0,4340,1);
REPLACE INTO `mob_db` VALUES (1623,'RSX_0806','RSX 0806','RSX-0806',86,560733,0,31010,32011,1,2740,5620,39,41,85,51,30,25,93,84,10,12,2,0,60,0x37B5,220,128,1104,240,15505,10000,607,5500,5104,3500,732,5500,7093,6000,1230,10,13017,1,617,1000,7327,5000,1242,50,1531,20,0,0,0,0,4342,1);
REPLACE INTO `mob_db` VALUES (1624,'G_WASTE_STOVE','Waste Stove','Old Stove',68,15895,0,0,0,1,500,889,23,10,20,69,55,5,79,77,10,12,2,0,20,0x3885,220,1152,528,360,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1625,'G_PORCELLIO','Porcellio','Porcellio',43,5523,0,1024,693,1,164,494,0,8,0,31,21,50,64,85,10,12,0,4,62,0x3985,150,720,360,360,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);

#  Hellion Revenant
REPLACE INTO `mob_db` VALUES (1626,'G_DARK_PRIEST','Hellion Revenant','Hellion Revenant',88,286900,0,1,1,2,50,3150,25,50,1,80,50,99,130,99,10,12,1,6,69,0x37B5,150,432,384,192,0,0,0,0,0,0,0,0,7337,8000,7337,5000,7337,3000,7337,1000,7337,500,7337,100,0,0,0,0,0,0,0,0);

# Lighthalzen
REPLACE INTO `mob_db` VALUES (1627,'ANOPHELES','Anopheles','Anopheles',23,100,0,99,55,1,48,63,0,90,1,200,4,5,120,5,10,12,0,4,64,0x3985,200,140,864,430,0,0,0,0,0,0,0,0,601,1000,7119,500,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4344,1);
REPLACE INTO `mob_db` VALUES (1628,'MOLE','Mole','Holden',36,2209,0,268,172,9,52,63,0,5,24,18,23,30,45,5,10,12,0,2,42,0x1089,300,140,960,504,0,0,0,0,0,0,0,0,1017,5000,1018,5000,5119,50,13101,5,0,0,0,0,0,0,0,0,0,0,4343,1);
REPLACE INTO `mob_db` VALUES (1629,'HILL_WIND','Hill Wind','Hill Wind',43,3189,0,1800,1100,3,290,480,10,15,21,42,31,50,41,23,10,12,1,2,64,0x3885,200,336,540,432,0,0,0,0,0,0,0,0,517,1000,528,1000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4345,1);
REPLACE INTO `mob_db` VALUES (1630,'BACSOJIN_','Bacsojin','White Lady',85,253221,0,45250,16445,3,1868,6124,20,55,52,65,44,112,152,35,10,12,2,7,64,0x39A5,130,576,960,480,22625,10000,607,5500,2513,2000,617,5000,1020,5500,603,5000,12395,50,7165,3000,7166,1000,2700,100,2234,10,0,0,0,0,4372,1);
REPLACE INTO `mob_db` VALUES (1631,'CHUNG_E_','Chung E','Green Maiden',59,23900,0,4256,920,2,460,1050,8,15,38,65,43,30,90,15,10,12,1,7,44,0x3885,150,1728,816,1188,0,0,0,0,0,0,0,0,7053,4200,740,100,1806,10,518,500,12395,10,0,0,5042,50,0,0,0,0,4373,1);
REPLACE INTO `mob_db` VALUES (1632,'GREMLIN','Gremlin','Gremlin',53,9280,0,4355,1768,1,329,762,29,25,80,41,59,75,62,15,10,12,2,6,47,0x191,140,432,540,432,0,0,0,0,0,0,0,0,7340,3000,938,3000,719,100,2406,1,1265,1,0,0,603,2,0,0,0,0,4355,1);
REPLACE INTO `mob_db` VALUES (1633,'BEHOLDER','Beholder','Beholder',56,7950,0,4821,3822,6,723,812,17,30,60,62,25,59,85,32,10,12,0,0,44,0x91,190,336,840,360,0,0,0,0,0,0,0,0,576,3000,605,100,996,100,985,10,0,0,0,0,603,2,0,0,0,0,4356,1);
# Normal advanced class mobs
REPLACE INTO `mob_db` VALUES (1634,'SEYREN','Seyren','Seyren Windsor',91,88402,0,100000,116460,1,2100,2530,63,12,90,89,72,20,99,25,10,12,1,6,63,0x3195,170,76,384,288,0,0,0,0,0,0,0,0,7345,3000,13001,2,1163,200,603,30,2229,12,2317,1,13421,1,0,0,0,0,4358,1);
REPLACE INTO `mob_db` VALUES (1635,'EREMES','Eremes','Eremes Guile',87,60199,0,100000,99800,1,2020,2320,23,12,45,138,31,19,99,30,10,12,1,6,85,0x3195,180,76,384,288,0,0,0,0,0,0,0,0,7347,2000,1284,1,2514,1,1262,3,1264,30,678,110,2336,2,0,0,0,0,4360,1);
REPLACE INTO `mob_db` VALUES (1636,'HARWORD','Harword','Howard Alt-Eisen',83,78690,0,100000,112540,1,1890,2390,59,10,90,62,99,35,98,66,10,12,1,7,81,0x3095,180,76,384,288,0,0,0,0,0,0,0,0,7345,3000,2514,1,1311,1,1361,110,2104,10,2318,1,603,50,0,0,0,0,4362,1);
REPLACE INTO `mob_db` VALUES (1637,'MAGALETA','Magaleta','Margaretha Sorin',90,61282,0,100000,117800,1,1300,2053,35,60,1,9,97,145,88,40,10,12,1,7,66,0x3295,180,1152,384,288,0,0,0,0,0,0,0,0,7347,2000,1647,2,1602,200,1561,10,2327,1,603,50,2504,10,0,0,0,0,4364,1);
REPLACE INTO `mob_db` VALUES (1638,'SHECIL','Shecil','Cecil Damon',82,58900,0,100000,118260,14,1226,1854,25,15,1,145,27,32,134,80,10,12,1,7,64,0x3095,180,76,384,288,0,0,0,0,0,0,0,0,7345,3000,12014,110,2331,10,1711,100,12007,150,603,50,1745,1,0,0,0,0,4368,1);
REPLACE INTO `mob_db` VALUES (1639,'KATRINN','Katrinn','Kathryne Keyron',92,47280,0,100000,116470,1,497,1697,10,74,1,5,77,180,110,39,10,12,1,7,68,0x3295,150,1152,384,288,0,0,0,0,0,0,0,0,7345,3000,603,50,1646,1,1620,5,2102,30,5085,1,2404,20,0,0,0,0,4366,1);
# MVP Slaves
REPLACE INTO `mob_db` VALUES (1640,'G_SEYREN','Lord Knight Seyren','Lord Knight Seyren',99,347590,0,18000,10000,1,4238,5040,72,37,120,110,81,65,130,52,10,12,1,7,83,0x37B5,100,76,384,288,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,617,10,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1641,'G_EREMES','Assassin Cross Eremes','Assassin Cross Eremes',99,211230,0,18000,10000,1,3189,5289,27,39,90,181,62,37,122,60,10,12,1,7,85,0x37B5,100,76,384,288,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,617,10,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1642,'G_HARWORD','Whitesmith Harword','Whitesmith Howard',99,310000,0,18000,10000,1,4822,5033,66,36,100,73,112,35,136,60,10,12,1,7,81,0x37B5,100,76,384,288,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,617,10,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1643,'G_MAGALETA','High Priest Magaleta','High Priest Margaretha',99,182910,0,18000,10000,1,1688,2580,35,78,1,84,64,182,92,100,10,12,1,7,86,0x37B5,125,1152,384,288,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,617,10,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1644,'G_SHECIL','Sniper Shecil','Sniper Cecil',99,209000,0,18000,10000,14,1892,5113,22,35,1,180,39,67,193,130,10,12,1,7,84,0x37B5,100,76,384,288,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,617,10,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1645,'G_KATRINN','High Wizard Katrinn','High Wizard Kathryne',99,189920,0,18000,10000,1,497,2094,10,88,1,89,42,223,128,93,10,12,1,7,68,0x37B5,150,1152,384,288,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,617,10,0,0,0,0);
# MVP Monsters
REPLACE INTO `mob_db` VALUES (1646,'B_SEYREN','Lord Knight Seyren','Lord Knight Seyren',99,1647590,0,4835600,1569970,1,7238,11040,72,37,120,110,81,65,130,52,10,12,1,7,83,0x37B5,100,76,384,288,2417800,10000,617,5500,603,5000,732,2000,1132,2500,2342,3500,2412,9000,1470,3500,1469,3000,1166,2500,1415,1500,0,0,0,0,4357,1);
REPLACE INTO `mob_db` VALUES (1647,'B_EREMES','Assassin Cross Eremes','Assassin Cross Eremes',99,1411230,0,4083400,1592380,1,4189,8289,37,39,90,181,62,37,122,60,10,12,1,7,85,0x37B5,100,76,384,288,2041700,10000,617,5500,603,5000,732,2000,1234,1500,1230,1500,2319,9000,1233,3500,1232,3500,1265,3500,13002,3500,0,0,0,0,4359,1);
REPLACE INTO `mob_db` VALUES (1648,'B_HARWORD','Whitesmith Harword','Whitesmith Howard',99,1460000,0,4002340,1421000,1,7822,8251,66,36,100,73,112,35,136,60,10,12,1,7,82,0x37B5,100,76,384,288,2001170,10000,617,5500,603,5000,732,2000,1138,3500,1140,2500,2318,9000,1365,3500,1364,3500,1369,2500,1368,3500,0,0,0,0,4361,1);
REPLACE INTO `mob_db` VALUES (1649,'B_MAGALETA','High Priest Magaleta','High Priest Margaretha',99,1092910,0,4257000,1318800,1,4688,5580,35,78,1,84,64,182,92,100,10,12,1,7,86,0x37B5,125,1152,384,288,2128500,10000,617,5500,603,5000,732,2000,1814,3500,2615,2500,2513,9000,1557,3500,1527,3500,1528,2500,1560,3500,0,0,0,0,4363,1);
REPLACE INTO `mob_db` VALUES (1650,'B_SHECIL','Sniper Shecil','Sniper Cecil',99,1349000,0,4093000,1526000,14,4892,9113,22,35,1,180,39,67,193,130,10,12,1,7,84,0x37B5,100,76,384,288,2046500,10000,617,5500,603,5000,1723,2000,1228,3500,1236,3500,617,9000,1234,1500,1237,3500,1720,1500,1724,2500,0,0,0,0,4367,1);
REPLACE INTO `mob_db` VALUES (1651,'B_KATRINN','High Wizard Katrinn','High Wizard Kathryne',99,1069920,0,4008200,1636700,1,1197,4394,10,88,1,89,42,223,128,93,10,12,1,7,68,0x37B5,150,1152,384,288,2004100,10000,617,5500,603,5000,732,2000,1241,3500,1242,3500,2616,9000,2343,2500,2513,2500,1618,3000,2319,3500,0,0,0,0,4365,1);
# 1'st Class Mobs
REPLACE INTO `mob_db` VALUES (1652,'YGNIZEM','Ygnizem','Egnigem Cenia',58,11200,0,4870,98,1,823,1212,35,8,60,35,52,18,79,20,10,12,1,7,43,0x3885,145,576,432,288,0,0,0,0,0,0,0,0,7347,1000,1170,1,1158,20,1127,20,2313,10,1152,80,2317,1,0,0,0,0,4346,1);
REPLACE INTO `mob_db` VALUES (1653,'WHIKEBAIN','Whikebain','Wickebine Tres',62,7320,0,4204,21,1,693,889,9,8,1,102,34,20,83,30,10,12,1,7,65,0x3885,120,576,432,288,0,0,0,0,0,0,0,0,7345,2000,1223,1,2306,40,1220,10,2315,2,2620,2,13004,10,0,0,0,0,4348,1);
REPLACE INTO `mob_db` VALUES (1654,'ARMAIA','Armaia','Armeyer Dinze',66,7110,0,4008,35,1,750,913,42,6,5,36,50,15,89,60,10,12,1,7,62,0x3885,120,576,432,288,0,0,0,0,0,0,0,0,7345,1000,2504,1,1358,50,1352,40,2311,10,1302,80,1307,10,0,0,0,0,4347,1);
REPLACE INTO `mob_db` VALUES (1655,'EREND','Erend','Errende Ebecee',59,6980,0,4501,67,1,896,1159,14,30,1,31,41,93,67,30,10,12,1,7,46,0x3885,130,576,432,288,0,0,0,0,0,0,0,0,7345,500,2217,5,1514,50,1517,20,2326,5,2324,10,1523,1,0,0,0,0,4349,1);
REPLACE INTO `mob_db` VALUES (1656,'KAVAC','Kavac','Kavach Icarus',60,7899,0,4090,86,9,684,904,12,5,48,100,10,15,118,40,10,12,1,7,44,0x3885,150,576,432,288,0,0,0,0,0,0,0,0,7347,2000,1716,1,12006,100,1708,10,2308,5,2402,30,2404,2,0,0,0,0,4351,1);
REPLACE INTO `mob_db` VALUES (1657,'RAWREL','Rawrel','Laurell Weinder',61,6168,0,4620,30,1,430,517,8,48,1,41,5,120,45,10,10,12,1,7,48,0x3885,150,576,432,288,0,0,0,0,0,0,0,0,934,1000,1616,1,2102,5,1608,50,2322,10,2333,30,2607,1,0,0,0,0,4350,1);
# 1'st Class MvP (Ygnizem/Egnigem Cenia) and her mobs.
REPLACE INTO `mob_db` VALUES (1658,'B_YGNIZEM','Ygnizem','Egnigem Cenia',79,214200,0,258760,86000,1,3890,5690,48,25,82,60,45,31,110,40,10,12,1,7,43,0x37B5,100,1008,864,288,129380,10000,617,5500,603,5000,732,2000,1162,1000,644,5000,603,5000,1167,1000,2320,1000,2406,1000,1130,1000,0,0,0,0,4352,1);
REPLACE INTO `mob_db` VALUES (1659,'G_WHIKEBAIN','Whikebain','Wickebine Tres',62,7320,0,0,0,1,593,789,9,12,1,102,34,23,74,30,10,12,1,7,65,0x3885,120,1008,864,288,0,0,0,0,0,0,0,0,0,0,644,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1660,'G_ARMAIA','Armaia','Armeyer Dinze',66,7110,0,0,0,1,650,813,42,6,5,36,40,15,80,60,10,12,1,7,62,0x3885,120,1008,864,288,0,0,0,0,0,0,0,0,0,0,644,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1661,'G_EREND','Erend','Errende Ebecee',59,6980,0,0,0,1,796,1059,14,30,1,31,41,93,60,30,10,12,1,7,46,0x3885,130,1008,864,288,0,0,0,0,0,0,0,0,0,0,644,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1662,'G_KAVAC','Kavac','Kavach Icarus',60,7899,0,0,0,9,584,804,12,5,48,100,10,20,118,40,10,12,1,7,44,0x3885,150,1008,864,288,0,0,0,0,0,0,0,0,0,0,644,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1663,'G_RAWREL','Rawrel','Laurell Weinder',61,6168,0,0,0,1,330,417,8,48,1,41,5,100,45,10,10,12,1,7,48,0x3885,150,1008,864,288,0,0,0,0,0,0,0,0,0,0,644,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);

#  Juperos
REPLACE INTO `mob_db` VALUES (1664,'POTON_CANON','Photon Cannon','Photon Cannon',66,8000,0,3900,1800,9,800,900,10,30,1,40,25,20,80,80,10,12,1,0,40,0x84,300,1536,960,480,0,0,0,0,0,0,0,0,7126,5000,718,1000,938,1000,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1665,'POTON_CANON_1','Photon Cannon','Photon Cannon',67,7500,0,4300,2000,9,700,800,15,30,1,40,30,40,86,80,10,12,1,0,40,0x84,300,1536,960,480,0,0,0,0,0,0,0,0,7126,5000,726,1000,938,1000,13160,5,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1666,'POTON_CANON_2','Photon Cannon','Photon Cannon',64,7100,0,3100,2700,9,800,900,8,30,1,40,21,29,80,91,10,12,1,0,40,0x84,300,1536,960,480,0,0,0,0,0,0,0,0,7126,5000,721,1000,938,1000,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1667,'POTON_CANON_3','Photon Cannon','Photon Cannon',65,7800,0,3800,2300,9,700,800,15,30,1,40,23,30,90,99,10,12,1,0,40,0x84,300,1536,960,480,0,0,0,0,0,0,0,0,7126,5000,728,1000,938,1000,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1668,'ARCHDAM','Archdam','Archdam',79,25000,0,8000,5000,3,1000,2000,15,15,65,65,35,75,75,15,10,12,2,7,60,0x3695,180,580,288,360,0,0,0,0,0,0,0,0,7317,5000,999,500,984,200,985,200,13156,5,13167,5,0,0,0,0,0,0,4371,1);
REPLACE INTO `mob_db` VALUES (1669,'DIMIK','Dimik','Dimik',77,10000,0,0,0,5,1040,1880,45,28,15,35,40,15,120,42,10,12,1,0,40,0x3885,200,576,720,432,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4370,1);
REPLACE INTO `mob_db` VALUES (1670,'DIMIK_1','Dimik','Dimik',79,16000,0,6400,3500,7,1140,1980,45,28,15,88,20,20,120,40,10,12,1,0,44,0x3885,150,576,720,432,0,0,0,0,0,0,0,0,7319,2000,7352,50,999,300,7094,300,13153,5,984,10,12128,50,0,0,0,0,4370,1);
REPLACE INTO `mob_db` VALUES (1671,'DIMIK_2','Dimik','Dimik',89,29000,0,8000,5000,5,1440,2280,45,28,15,40,30,30,150,70,10,12,1,0,41,0x3885,200,576,720,432,0,0,0,0,0,0,0,0,7319,2000,7353,50,999,300,7094,300,13169,10,984,10,12128,50,0,0,0,0,4370,1);
REPLACE INTO `mob_db` VALUES (1672,'DIMIK_3','Dimik','Dimik',80,19000,0,5900,2800,5,1240,2080,68,28,15,30,78,20,120,30,10,12,1,0,42,0x3885,200,576,720,432,0,0,0,0,0,0,0,0,7319,2000,7354,50,999,300,7094,300,2656,10,984,10,12128,50,0,0,0,0,4370,1);
REPLACE INTO `mob_db` VALUES (1673,'DIMIK_4','Dimik','Dimik',82,13900,0,5800,4500,5,1840,2840,45,28,15,20,20,10,120,30,10,12,1,0,43,0x3885,200,576,720,432,0,0,0,0,0,0,0,0,7319,2000,7355,50,999,300,7094,300,2656,10,984,10,12128,50,0,0,0,0,4370,1);
REPLACE INTO `mob_db` VALUES (1674,'MONEMUS','Monemus','Monemus',88,80000,0,0,0,5,2000,3000,54,25,0,1,90,24,144,45,14,12,2,0,63,0x1A4,400,1368,1344,432,0,0,0,0,0,0,0,0,7049,2000,953,1000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1675,'VENATU','Venatu','Venatu',77,8000,0,0,0,2,1200,1800,35,20,5,26,24,5,75,40,10,12,1,0,43,0x3885,150,504,1020,360,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4369,1);
REPLACE INTO `mob_db` VALUES (1676,'VENATU_1','Venatu','Venatu',72,8900,0,4000,2000,2,800,1400,30,20,5,26,24,5,82,30,10,12,1,0,40,0x3885,150,504,1020,360,0,0,0,0,0,0,0,0,7317,2000,7356,350,999,300,7094,300,13157,5,985,10,12127,100,0,0,0,0,4369,1);
REPLACE INTO `mob_db` VALUES (1677,'VENATU_2','Venatu','Venatu',80,9000,0,4000,2000,2,900,1500,30,20,5,82,32,5,105,30,10,12,1,0,44,0x3885,150,504,1020,360,0,0,0,0,0,0,0,0,7317,2000,7357,500,999,300,7094,300,13164,10,985,10,12127,100,0,0,0,0,4369,1);
REPLACE INTO `mob_db` VALUES (1678,'VENATU_3','Venatu','Venatu',78,9500,0,4500,2000,2,800,1400,30,20,5,26,68,5,95,30,10,12,1,0,42,0x3885,150,504,1020,360,0,0,0,0,0,0,0,0,7317,2000,7358,400,999,300,7094,300,2656,10,985,10,12127,100,0,0,0,0,4369,1);
REPLACE INTO `mob_db` VALUES (1679,'VENATU_4','Venatu','Venatu',75,12300,0,4000,2000,2,800,1400,30,20,5,26,24,5,100,30,10,12,1,0,41,0x3885,150,504,1020,360,0,0,0,0,0,0,0,0,7317,2000,7359,300,999,300,7094,300,2656,10,985,10,12127,100,0,0,0,0,4369,1);
REPLACE INTO `mob_db` VALUES (1680,'HILL_WIND_1','Hill Wind','Hill Wind',45,4233,0,2132,1722,3,320,510,10,15,21,42,31,50,67,23,10,12,1,2,64,0x3885,170,504,480,360,0,0,0,0,0,0,0,0,7115,4000,7116,3000,528,1000,510,10,0,0,0,0,0,0,0,0,0,0,4345,1);
REPLACE INTO `mob_db` VALUES (1681,'GEMINI','Gemini-S58','Gemini-S58',72,57870,0,22024,9442,3,2150,3030,60,45,88,75,70,77,105,55,10,12,1,0,21,0x39A5,200,1872,360,864,0,0,0,0,0,0,0,0,7005,3000,603,1000,13159,5,546,500,547,400,7479,6,12040,300,0,0,0,0,4354,1);
REPLACE INTO `mob_db` VALUES (1682,'REMOVAL','Removal','Remover',55,10289,0,3831,1278,1,558,797,5,20,1,20,56,35,57,20,10,12,1,1,49,0x3885,250,1536,1056,1152,0,0,0,0,0,0,0,0,713,5000,7319,5000,5005,10,549,500,971,50,972,100,5120,6,0,0,0,0,4353,1);
REPLACE INTO `mob_db` VALUES (1683,'G_POTON_CANON','Photon Cannon','Photon Cannon',46,7000,0,0,0,9,560,570,5,10,1,36,36,20,56,30,10,12,1,0,43,0x3885,300,1536,960,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1684,'G_ARCHDAM','Archdam','Archdam',57,11000,0,0,0,3,600,700,15,15,65,65,35,75,75,15,10,12,2,8,60,0x3885,180,1080,288,360,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1685,'APOCALIPS_H','Vesper','Vesper',97,640700,0,200000,100000,3,4000,10000,50,54,100,50,30,70,160,150,10,12,2,2,46,0x37B5,180,504,912,432,100000,10000,617,5500,603,5000,732,2000,7095,5000,7094,3000,617,1000,2659,100,2660,100,2661,100,2662,100,0,0,0,0,4374,1);
REPLACE INTO `mob_db` VALUES (1686,'ORC_BABY','Orc Baby','Orc Baby',21,912,0,220,220,1,135,270,10,10,30,15,10,18,35,2,10,12,0,7,22,0x3885,200,672,864,288,0,0,0,0,0,0,0,0,7126,1000,10004,100,2299,1,519,5000,7270,200,7269,100,0,0,0,0,0,0,4375,1);
REPLACE INTO `mob_db` VALUES (1687,'GREEN_IGUANA','Green Iguana','Grove',54,6444,0,2400,2050,1,550,650,0,10,1,52,64,5,98,14,10,12,1,2,42,0x83,200,720,528,432,0,0,0,0,0,0,0,0,521,1500,903,1000,520,1000,511,1000,528,2000,606,10,511,1,0,0,0,0,4377,1);
REPLACE INTO `mob_db` VALUES (1688,'LADY_TANEE','Lady Tanee','Lady Tanee',89,493000,0,64995,43222,14,450,2170,20,44,1,125,48,78,210,38,10,12,2,3,64,0x1A4,100,576,432,360,32497,10000,617,5500,12095,5000,732,2000,12090,5000,634,4000,12129,1000,5116,1000,985,5000,617,2000,1716,6000,0,0,0,0,4376,1);
REPLACE INTO `mob_db` VALUES (1689,'G_BACSOJIN','Bacsojin','White Lady',85,253221,0,45250,16445,3,1868,6124,20,55,52,65,44,112,152,35,10,12,2,7,64,0x37B5,130,576,960,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1690,'G_SPRING_RABBIT','Spring Rabbit','Spring Rabbit',12,15,0,0,0,1,0,0,100,99,1,1,1,1,1,1,10,12,1,2,42,0xC3,160,1120,552,511,0,0,0,0,0,0,0,0,12194,100,12706,300,12708,300,7888,5000,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1691,'G_KRABEN','Kraben','Kraben',70,10880,0,0,0,1,125,765,5,42,50,155,1,66,112,60,10,12,1,0,48,0x3885,100,1152,1536,576,0,0,0,0,0,0,0,0,521,1,521,1,521,1,521,1,521,1,521,1,521,1,0,0,0,0,0,0);

#  Thanatos Tower & Abyss
REPLACE INTO `mob_db` VALUES (1692,'BREEZE','Breeze','Breeze',56,5099,0,2390,1340,2,94,215,7,32,1,96,6,38,91,45,10,12,1,0,64,0x3885,100,140,384,504,0,0,0,0,0,0,0,0,945,500,706,10,2270,10,1733,10,604,10,2269,10,996,10,0,0,0,0,4390,1);
REPLACE INTO `mob_db` VALUES (1693,'PLASMA_Y','Plasma','Plasma',56,8400,0,2200,2100,3,400,900,0,40,1,30,10,83,105,45,10,12,0,0,88,0x3885,100,608,1440,576,0,0,0,0,0,0,0,0,911,100,644,10,731,2,715,100,969,1,0,0,0,0,0,0,0,0,4389,1);
REPLACE INTO `mob_db` VALUES (1694,'PLASMA_R','Plasma','Plasma',43,5700,0,2000,1000,3,300,700,0,30,1,30,5,56,90,30,10,12,0,0,83,0x3885,150,608,1440,576,0,0,0,0,0,0,0,0,911,100,644,10,731,2,716,100,990,45,0,0,0,0,0,0,0,0,4389,1);
REPLACE INTO `mob_db` VALUES (1695,'PLASMA_G','Plasma','Plasma',47,7600,0,2000,1000,3,300,700,0,30,1,30,5,61,90,30,10,12,0,0,82,0x3885,150,608,1440,576,0,0,0,0,0,0,0,0,911,100,644,10,731,2,717,100,993,40,0,0,0,0,0,0,0,0,4389,1);
REPLACE INTO `mob_db` VALUES (1696,'PLASMA_P','Plasma','Plasma',49,5900,0,2000,1000,3,300,700,0,30,1,30,5,54,90,30,10,12,0,0,87,0x3885,150,608,1440,576,0,0,0,0,0,0,0,0,911,100,644,10,731,2,716,100,724,100,0,0,0,0,0,0,0,0,4389,1);
REPLACE INTO `mob_db` VALUES (1697,'PLASMA_B','Plasma','Plasma',44,8200,0,2000,1000,3,300,700,0,30,1,30,5,73,90,30,10,12,0,0,81,0x3885,150,608,1440,576,0,0,0,0,0,0,0,0,911,100,644,10,731,2,717,100,991,35,0,0,0,0,0,0,0,0,4389,1);
REPLACE INTO `mob_db` VALUES (1698,'DEATHWORD','Deathword','Death Word',65,18990,0,2986,4912,1,622,1102,10,40,50,75,10,20,140,45,10,12,1,0,60,0x3695,150,176,912,300,0,0,0,0,0,0,0,0,1097,4000,7015,300,11003,50,7449,500,2418,10,7479,2,7480,1,0,0,0,0,4388,1);
REPLACE INTO `mob_db` VALUES (1699,'ANCIENT_MIMIC','Ancient Mimic','Ancient Mimic',60,8080,0,2950,2650,1,530,1697,20,40,50,100,30,40,150,110,10,12,2,0,60,0x3885,100,168,480,360,0,0,0,0,0,0,0,0,603,30,617,1,644,50,2404,5,2506,1,2417,10,2610,100,0,0,0,0,4387,1);
REPLACE INTO `mob_db` VALUES (1700,'OBSERVATION','Observation','Dame of Sentinel',81,65111,0,39872,33120,2,1666,2609,55,55,30,74,56,126,145,114,10,12,1,8,80,0x33B5,100,432,480,360,0,0,0,0,0,0,0,0,7441,500,2621,1,7442,100,728,1000,12040,100,2210,10,7435,100,0,0,0,0,4392,1);
REPLACE INTO `mob_db` VALUES (1701,'SHELTER','Shelter','Mistress of Shelter',80,38000,0,29010,25110,2,1871,1971,22,63,12,67,34,167,157,120,10,12,1,8,66,0x33B5,160,432,420,360,0,0,0,0,0,0,0,0,7440,200,7442,1,12040,50,722,1000,7005,1000,7442,50,0,0,0,0,0,0,4393,1);
REPLACE INTO `mob_db` VALUES (1702,'RETRIBUTION','Retribution','Baroness of Retribution',79,46666,0,28332,33120,2,2022,2288,35,35,30,142,66,72,133,39,10,12,1,8,67,0x33B5,120,360,480,360,0,0,0,0,0,0,0,0,7440,400,2621,1,12040,50,723,1000,2506,5,1158,10,7442,50,0,0,0,0,4391,1);
REPLACE INTO `mob_db` VALUES (1703,'SOLACE','Solace','Lady Solace',77,25252,0,21000,25110,2,1392,1462,21,67,12,76,29,145,99,100,10,12,1,8,66,0x33B5,180,576,420,360,0,0,0,0,0,0,0,0,7441,200,2621,1,12040,50,718,1000,1910,50,1909,100,7442,50,0,0,0,0,4394,1);
REPLACE INTO `mob_db` VALUES (1704,'THA_ODIUM','Thanatos Odium','Odium of Thanatos',92,72389,0,88420,63880,9,2100,2800,68,30,100,52,165,62,185,90,10,12,2,1,88,0x37B5,100,432,288,420,0,0,0,0,0,0,0,0,7054,1000,731,500,732,100,7438,10000,616,10,2520,1000,0,0,0,0,0,0,4396,1);
REPLACE INTO `mob_db` VALUES (1705,'THA_DESPERO','Thanatos Despero','Despero of Thanatos',88,86666,0,62001,51220,2,2182,3082,38,39,100,167,79,92,151,120,10,12,2,1,88,0x37B5,150,160,528,360,0,0,0,0,0,0,0,0,7054,1000,731,500,732,100,7439,10000,616,10,2419,1000,0,0,0,0,0,0,4397,1);
REPLACE INTO `mob_db` VALUES (1706,'THA_MAERO','Thanatos Maero','Maero of Thanatos',83,62000,0,56699,63880,2,2022,2288,29,72,100,176,30,200,122,29,10,12,1,1,88,0x37B5,150,160,480,360,0,0,0,0,0,0,0,0,7054,1000,731,500,732,100,7437,10000,616,10,2354,1000,0,0,0,0,0,0,4395,1);
REPLACE INTO `mob_db` VALUES (1707,'THA_DOLOR','Thanatos Dolor','Dolor of Thanatos',83,59922,0,43200,51220,2,1392,2092,21,80,100,76,29,206,139,44,10,12,0,1,88,0x37B5,150,160,672,480,0,0,0,0,0,0,0,0,7054,1000,731,500,732,100,7436,10000,616,10,5128,1000,0,0,0,0,0,0,4398,1);
REPLACE INTO `mob_db` VALUES (1708,'THANATOS','Thanatos','Memory of Thanatos',99,445660,0,3666000,2145060,3,3812,7483,35,35,100,108,30,86,147,32,10,12,2,6,88,0x37B5,120,115,816,504,1833000,10000,617,5500,603,5000,732,2000,7444,1000,2519,1000,7450,5000,2342,5000,2412,5000,2515,1000,2655,500,0,0,0,0,4399,1);
REPLACE INTO `mob_db` VALUES (1709,'G_THA_ODIUM','Thanatos Odium','Odium of Thanatos',92,72389,0,10000,5000,9,2100,2800,68,30,100,52,165,62,185,90,10,12,2,1,88,0x33B5,100,115,288,420,0,0,0,0,0,0,0,0,7054,1000,731,500,732,100,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1710,'G_THA_DESPERO','Thanatos Despero','Despero of Thanatos',88,86666,0,10000,5000,2,2182,3082,38,39,100,167,79,92,151,120,10,12,2,1,88,0x33B5,150,160,528,360,0,0,0,0,0,0,0,0,7054,1000,731,500,732,100,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1711,'G_THA_MAERO','Thanatos Maero','Maero of Thanatos',83,62000,0,10000,5000,2,2022,2288,29,72,100,176,30,200,122,29,10,12,1,1,88,0x33B5,150,160,480,360,0,0,0,0,0,0,0,0,7054,1000,731,500,732,100,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1712,'G_THA_DOLOR','Thanatos Dolor','Dolor of Thanatos',83,59922,0,10000,5000,2,1392,2092,21,80,100,76,29,206,139,44,10,12,0,1,88,0x33B5,150,160,672,480,0,0,0,0,0,0,0,0,7054,1000,731,500,732,100,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1713,'ACIDUS','Acidus','Acidus',80,51112,0,28043,8023,2,1289,2109,29,69,1,71,55,135,103,69,10,12,2,9,46,0x3095,170,168,1008,300,0,0,0,0,0,0,0,0,582,5100,1035,4000,7444,5,1036,3589,7448,800,1269,10,2114,50,0,0,0,0,4378,1);
REPLACE INTO `mob_db` VALUES (1714,'FERUS','Ferus','Ferus',70,29218,0,8093,3952,2,1056,1496,14,45,1,78,45,72,81,73,10,12,2,9,43,0x3095,100,108,576,432,0,0,0,0,0,0,0,0,578,2200,1035,1000,7123,1000,1036,2000,7447,800,994,20,5122,50,0,0,0,0,4380,1);
REPLACE INTO `mob_db` VALUES (1715,'NOVUS','Novus','Novus',42,5430,0,1320,1002,1,284,384,20,28,1,56,43,45,124,43,10,12,0,9,20,0x3885,110,151,288,360,0,0,0,0,0,0,0,0,511,3000,7053,1035,0,0,1036,589,0,0,0,0,0,0,0,0,0,0,4383,1);
REPLACE INTO `mob_db` VALUES (1716,'ACIDUS_','Acidus','Acidus',76,39111,0,14392,4203,2,1180,2000,21,47,1,78,31,93,88,52,10,12,2,9,44,0x3095,180,168,768,360,0,0,0,0,0,0,0,0,505,150,1035,4000,510,150,1036,3589,7446,800,996,20,7446,100,0,0,0,0,4379,1);
REPLACE INTO `mob_db` VALUES (1717,'FERUS_','Ferus','Ferus',69,21182,0,6750,2230,2,930,1170,14,38,1,66,77,60,79,35,10,12,2,9,42,0x3095,120,108,576,432,0,0,0,0,0,0,0,0,579,5100,1035,1000,0,0,1036,3589,7445,800,997,20,7445,100,0,0,0,0,4381,1);
REPLACE INTO `mob_db` VALUES (1718,'NOVUS_','Novus','Novus',43,5830,0,1411,1100,1,314,414,24,28,1,60,43,39,119,43,10,12,0,9,20,0x3885,100,252,816,480,0,0,0,0,0,0,0,0,508,2000,7053,1035,0,0,1036,589,0,0,0,0,0,0,0,0,0,0,4382,1);
REPLACE INTO `mob_db` VALUES (1719,'DETALE','Detale','Detardeurus',90,960000,0,291850,123304,3,4560,5548,66,59,100,90,30,136,140,56,10,12,2,9,67,0x37B5,250,432,936,360,145925,10000,617,5500,603,5000,732,2000,2649,1000,2648,1000,7444,5000,7451,3589,12080,1000,1417,100,5002,500,0,0,0,0,4386,1);
REPLACE INTO `mob_db` VALUES (1720,'HYDRO','Hydro','Hydrolancer',89,308230,0,83450,2480,3,2554,3910,52,62,1,96,110,86,94,32,10,12,2,9,47,0x37B5,160,140,672,432,0,0,0,0,0,0,0,0,7123,4000,1035,4000,7443,3880,5126,500,5127,500,12085,300,5124,500,0,0,0,0,4384,1);
REPLACE INTO `mob_db` VALUES (1721,'DRAGON_EGG','Dragon Egg','Dragon Egg',43,18322,0,6740,0,0,1,2,78,60,1,1,56,67,1,63,10,12,1,9,40,0x0,1000,24,0,0,0,0,0,0,0,0,0,0,985,5,7032,100,731,10,732,5,718,10,720,10,728,10,0,0,0,0,4385,1);
REPLACE INTO `mob_db` VALUES (1722,'EVENT_JAKK','Jakk','Jakk',99,10310,0,103,100,1,115,182,5,11,1,28,18,13,35,45,10,12,1,0,43,0x81,240,1180,480,648,0,0,0,0,0,0,0,0,7225,1000,1062,1000,535,1000,0,0,0,0,0,0,0,0,0,0,0,0,5134,10000);
REPLACE INTO `mob_db` VALUES (1723,'A_SHECIL','Shecil Damon','Cecil Damon',82,30000,0,0,0,14,600,900,25,15,1,145,27,32,134,80,10,12,1,7,64,0x3695,180,1008,384,288,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1724,'A_POTON_CANON','Photon Cannon','Photon Cannon',66,8000,0,0,0,9,1000,1300,10,30,1,40,25,20,80,80,10,12,1,0,40,0x84,300,1536,960,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1725,'R_PORING','Poring','Poring',1,50,0,0,0,1,7,10,0,5,1,1,1,0,6,30,10,12,1,3,21,0x83,150,1872,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1726,'R_LUNATIC','Lunatic','Lunatic',3,60,0,0,0,1,9,12,0,20,1,3,3,10,8,60,10,12,0,2,60,0x83,150,1456,456,336,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1727,'R_SAVAGE_BABE','Savage Babe','Savage Babe',7,182,0,0,0,1,20,25,0,0,1,7,14,5,12,35,10,12,0,2,22,0x83,150,1624,624,576,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1728,'R_DESERT_WOLF_B','Desert Wolf Baby','Baby Desert Wolf',9,164,0,0,0,1,30,36,0,0,1,9,9,5,21,40,10,12,0,2,23,0x83,150,1600,900,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1729,'R_BAPHOMET_','Baphomet Jr.','Baphomet Jr.',50,8578,0,0,0,1,487,590,15,25,1,75,55,1,93,45,10,12,0,6,27,0x183,150,868,480,120,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1730,'R_DEVIRUCHI','Deviruchi','Deviruchi',46,7360,0,0,0,1,475,560,10,25,1,69,40,55,87,30,10,12,0,6,27,0x183,150,980,600,384,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1731,'G_DOPPELGANGER','Doppelganger','Doppelganger',72,12000000,0,3000000,2000000,1,5000,10000,99,99,88,180,70,75,180,65,10,12,2,8,48,0x37B5,190,480,480,288,0,0,0,0,0,0,0,0,7484,10000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1732,'G_TREASURE_BOX','Treasure Chest','Treasure Chest',98,0,0,0,0,0,0,0,0,0,0,0,0,0,999,0,0,0,0,0,20,0x120,0,0,0,0,0,0,0,0,0,0,0,0,7486,1000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);

#  Kiel Dungeon monsters
REPLACE INTO `mob_db` VALUES (1733,'KIEL','Kiel','Kiehl',90,523000,0,36500,23405,3,1682,3311,28,32,100,112,76,89,156,102,10,12,1,0,47,0x37B5,140,1152,576,432,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1734,'KIEL_','Kiel D-01','Kiel D-01',90,1523000,0,2356200,512602,3,3280,6560,28,32,100,130,30,160,199,180,10,12,1,0,47,0x37B5,130,1152,576,432,1178100,10000,617,5500,603,5000,616,2000,7513,3000,617,3000,2651,1000,2319,1000,1618,500,1242,500,2650,1000,0,0,0,0,4403,1);
REPLACE INTO `mob_db` VALUES (1735,'ALICEL','Alicel','Alicel',75,37520,0,8890,5420,2,1800,2770,30,30,50,58,50,51,92,40,10,12,1,6,60,0x318D,250,1080,480,504,0,0,0,0,0,0,0,0,7512,2000,7507,3000,999,200,7317,500,1270,5,985,10,2517,20,0,0,0,0,4401,1);
REPLACE INTO `mob_db` VALUES (1736,'ALIOT','Aliot','Aliot',75,48290,0,13020,4006,2,950,2470,35,15,50,32,87,12,68,19,10,12,1,6,60,0x318D,200,1296,432,360,0,0,0,0,0,0,0,0,7512,2000,7507,3000,2516,10,7317,500,1810,10,985,10,13405,15,0,0,0,0,4402,1);
REPLACE INTO `mob_db` VALUES (1737,'ALIZA','Aliza','Aliza',69,19000,0,6583,3400,1,750,1100,8,5,74,74,52,35,110,140,10,12,1,7,60,0x91,220,1440,576,600,0,0,0,0,0,0,0,0,7054,4000,2518,10,2626,10,7047,5,12128,50,661,1,2123,5,0,0,0,0,4400,1);
REPLACE INTO `mob_db` VALUES (1738,'CONSTANT','Constant','Constant',55,10000,0,3230,116,1,460,580,12,12,50,28,26,47,66,14,10,12,0,0,67,0x3885,150,720,360,360,0,0,0,0,0,0,0,0,7512,100,7507,1500,7325,10,999,10,757,10,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1739,'G_ALICEL','Alicel','Alicel',75,37520,0,0,0,2,1600,2570,30,30,50,60,50,51,92,40,10,12,1,6,60,0x318D,150,1080,480,504,0,0,0,0,0,0,0,0,7507,500,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1740,'G_ALIOT','Aliot','Aliot',75,43290,0,0,0,2,950,2070,35,15,50,32,87,12,68,19,10,12,1,6,60,0x318D,150,1296,432,360,0,0,0,0,0,0,0,0,7507,500,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1741,'G_COOKIE_XMAS','Christmas Cookie','Christmas Cookie',28,2090,0,0,0,1,140,170,0,50,1,24,30,53,45,100,10,12,0,7,46,0x3885,400,1248,1248,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1742,'G_CARAT','Carat','Carat',51,5200,0,0,0,1,330,417,0,25,1,41,45,5,85,155,10,12,1,6,44,0x3985,200,1078,768,384,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1743,'G_MYSTCASE','Myst Case','Myst Case',38,3450,0,0,0,1,160,360,5,10,65,50,25,5,48,75,10,12,1,0,60,0x3885,400,1248,1248,432,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1744,'G_WILD_ROSE','Wild Rose','Wild Rose',38,2980,0,0,0,1,315,360,0,15,65,85,15,35,65,80,10,12,0,2,24,0x3885,100,964,864,288,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1745,'G_CONSTANT','Constant','Constant',55,1000,0,0,0,1,460,580,12,12,50,28,26,47,66,14,10,12,0,6,67,0x2185,110,720,360,360,0,0,0,0,0,0,0,0,7507,500,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1746,'G_ALIZA','Aliza','Aliza',69,15000,0,0,0,1,750,1100,8,5,74,74,52,35,110,140,10,12,1,7,60,0x3885,200,1440,576,600,0,0,0,0,0,0,0,0,7507,500,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1747,'G_SNAKE','Snake','Boa',15,471,0,0,0,1,46,55,0,0,1,15,15,10,35,5,10,12,1,2,22,0x3885,200,1576,576,576,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1748,'G_ANACONDAQ','Anacondaq','Anacondaq',23,1109,0,0,0,1,124,157,0,0,1,23,28,10,36,5,10,12,1,2,25,0x3885,200,1576,576,576,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1749,'G_MEDUSA','Medusa','Medusa',79,22408,0,0,0,1,827,1100,48,38,1,74,50,57,77,69,10,12,1,6,40,0x3985,180,1720,1320,360,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1750,'G_RED_PLANT','Red Plant','Red Plant',1,100,0,0,0,1,100,200,100,99,0,0,0,0,0,100,7,12,0,3,22,0x40,2000,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);

#  Odin monsters
REPLACE INTO `mob_db` VALUES (1751,'RANDGRIS','Valkyrie Randgris','Valkyrie Randgris',99,3567200,0,2854900,3114520,3,5560,9980,25,42,100,120,30,120,220,210,10,12,2,8,86,0x37B5,100,576,576,480,1427450,10000,617,5500,603,5000,616,2000,7510,5000,2357,800,2524,1500,2421,1500,2229,2500,7024,2500,0,0,0,0,0,0,4407,1);
REPLACE INTO `mob_db` VALUES (1752,'SKOGUL','Skogul','Skogul',70,87544,0,27620,10,2,1110,1930,20,15,1,69,70,50,67,52,10,12,1,6,67,0x3395,190,720,384,480,0,0,0,0,0,0,0,0,7511,3500,7054,1000,716,1000,739,500,2609,100,757,500,1271,5,0,0,0,0,4404,1);
REPLACE INTO `mob_db` VALUES (1753,'FRUS','Frus','Frus',69,83422,0,20620,10,2,1110,1780,20,15,1,69,60,50,76,52,10,12,1,6,67,0x3395,150,480,576,432,0,0,0,0,0,0,0,0,7511,3500,7054,1000,716,1000,2622,3,2308,10,757,500,0,0,0,0,0,0,4405,1);
REPLACE INTO `mob_db` VALUES (1754,'SKEGGIOLD','Skeggiold','Skeggiold',81,295200,0,91100,10,1,1400,2020,12,24,80,100,50,72,90,50,10,12,0,8,46,0x37B5,250,672,780,480,0,0,0,0,0,0,0,0,7511,6000,2254,1,7063,1000,2001,25,7511,1000,2322,100,2353,100,0,0,0,0,4406,1);
REPLACE INTO `mob_db` VALUES (1755,'SKEGGIOLD_','Skeggiold','Skeggiold',83,315200,0,99200,10,1,1600,2050,15,24,80,120,60,85,98,80,10,12,0,8,46,0x37B5,250,672,780,480,0,0,0,0,0,0,0,0,7511,6000,2254,1,7063,1000,2001,25,7511,1000,2322,100,2353,100,0,0,0,0,4406,1);
REPLACE INTO `mob_db` VALUES (1756,'G_HYDRO','Hydro','Hydrolancer',89,308230,0,0,0,3,2554,3910,52,62,1,96,110,86,94,32,10,12,2,9,47,0x39A5,160,140,672,432,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1757,'G_ACIDUS','Acidus','Acidus',80,51112,0,0,0,2,1289,2109,39,69,1,71,55,135,103,69,10,12,2,9,46,0x3885,170,168,1008,300,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1758,'G_FERUS','Ferus','Ferus',70,29218,0,0,0,2,1056,1496,34,45,1,78,45,72,81,73,10,12,2,9,43,0x3885,100,108,576,432,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1759,'G_ACIDUS_','Acidus','Acidus',76,39111,0,0,0,2,1180,2000,31,47,1,78,31,93,88,52,10,12,2,9,44,0x3885,180,168,768,360,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1760,'G_FERUS_','Ferus','Ferus',69,21182,0,0,0,2,930,1170,24,38,1,66,77,60,79,35,10,12,2,9,42,0x3885,120,108,576,432,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1761,'G_SKOGUL','Skogul','Skogul',70,57544,0,0,0,2,1110,1930,20,15,1,69,70,50,67,52,10,12,1,6,67,0x3985,170,720,384,480,0,0,0,0,0,0,0,0,7511,500,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1762,'G_FRUS','Frus','Frus',69,53422,0,0,0,2,1110,1780,20,15,1,69,60,50,76,52,10,12,1,6,67,0x3985,130,480,576,432,0,0,0,0,0,0,0,0,7511,500,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1763,'G_SKEGGIOLD','Skeggiold','Skeggiold',81,100200,0,0,0,1,1400,3410,12,24,80,100,50,72,90,50,10,12,0,8,46,0x39A5,200,672,780,480,0,0,0,0,0,0,0,0,7511,500,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1764,'G_SKEGGIOLD_','Skeggiold','Skeggiold',83,103000,0,0,0,1,1600,4110,15,24,80,120,60,85,98,80,10,12,0,8,46,0x39A5,200,672,780,480,0,0,0,0,0,0,0,0,7511,500,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1765,'G_RANDGRIS','Valkyrie','Valkyrie',99,1567200,0,10000,10000,3,5560,9980,25,42,100,120,80,120,220,210,10,12,2,8,86,0x37B5,100,576,576,480,0,0,0,0,0,0,0,0,7510,500,617,100,2115,500,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1766,'EM_ANGELING','Angeling','Angeling',99,128430,0,0,0,1,60,71,40,50,1,17,80,80,126,20,10,12,0,8,66,0x4B5,300,1288,288,384,0,0,909,5000,909,5000,741,5000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1767,'EM_DEVILING','Deviling','Deviling',99,128430,0,0,0,1,60,71,40,50,1,17,80,80,126,20,10,12,0,8,66,0x4B5,300,1288,288,384,0,0,909,5000,909,5000,741,5000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);

#  Rachel / Ice Dungeon monsters
REPLACE INTO `mob_db` VALUES (1768,'GLOOMUNDERNIGHT','Gloom Under Night','Gloom Under Night',89,2298000,0,962175,276445,3,5880,9516,10,20,100,115,98,78,111,50,10,12,2,0,68,0x37B5,200,1344,2880,576,481087,10000,607,5500,617,5000,617,5000,7566,7000,7023,4000,7022,2000,616,5000,2513,1000,1377,100,0,0,0,0,0,0,4408,1);
REPLACE INTO `mob_db` VALUES (1769,'AGAV','Agav','Agav',73,29620,0,9780,6622,1,103,1109,15,35,1,32,27,132,69,15,10,12,1,7,80,0x3295,300,768,360,360,0,0,0,0,0,0,0,0,7567,2500,2422,2,7563,4000,2109,1,12183,50,7563,100,0,0,0,0,0,0,4409,1);
REPLACE INTO `mob_db` VALUES (1770,'ECHIO','Echio','Echio',69,34900,0,13560,4300,1,750,1800,33,11,74,74,52,35,59,56,10,12,1,7,80,0x3295,250,768,360,360,0,0,0,0,0,0,0,0,7567,2500,608,10,7563,4000,5172,500,12183,20,7563,100,2366,20,0,0,0,0,4410,1);
REPLACE INTO `mob_db` VALUES (1771,'VANBERK','Vanberk','Vanberk',59,9988,0,4203,901,1,230,660,24,6,69,66,39,29,51,41,10,12,1,7,80,0x3885,250,768,360,360,0,0,0,0,0,0,0,0,7568,2500,526,10,7563,1000,5172,10,13027,5,7563,100,0,0,0,0,0,0,4411,1);
REPLACE INTO `mob_db` VALUES (1772,'ISILLA','Isilla','Isilla',62,8297,0,3001,3001,1,89,733,11,19,1,28,12,97,57,12,10,12,1,7,80,0x3885,300,768,360,432,0,0,0,0,0,0,0,0,7568,2500,2422,1,7563,1000,2610,10,2601,1,7563,100,0,0,0,0,0,0,4412,1);
REPLACE INTO `mob_db` VALUES (1773,'HODREMLIN','Hodremlin','Hodremlin',61,12180,0,6782,2022,1,845,1678,29,25,80,41,81,56,62,11,10,12,1,6,67,0x3985,140,960,528,432,0,0,0,0,0,0,0,0,587,1000,7340,1000,2406,2,938,1000,7563,1000,1061,2000,2426,10,0,0,0,0,4413,1);
REPLACE INTO `mob_db` VALUES (1774,'SEEKER','Seeker','Seeker',65,10090,0,5671,4278,6,723,852,17,30,60,52,34,143,107,27,10,12,0,0,64,0x3295,190,576,432,300,0,0,0,0,0,0,0,0,587,1000,7340,1000,985,20,1061,4000,7563,1000,1375,20,0,0,0,0,0,0,4414,1);
REPLACE INTO `mob_db` VALUES (1775,'SNOWIER','Snowier','Snowier',60,19230,0,5882,2699,2,770,1347,22,12,73,46,72,15,52,25,10,12,2,0,41,0x3885,220,936,1020,420,0,0,0,0,0,0,0,0,7561,3000,7066,1000,757,100,510,50,509,500,1819,3,991,100,0,0,0,0,4415,1);
REPLACE INTO `mob_db` VALUES (1776,'SIROMA','Siroma','Siroma',42,6800,0,2230,1005,1,220,440,12,8,33,23,52,11,40,19,10,12,0,0,61,0x83,180,432,648,240,0,0,0,0,0,0,0,0,7561,1000,7066,500,510,10,0,0,0,0,0,0,991,20,0,0,0,0,4416,1);
REPLACE INTO `mob_db` VALUES (1777,'ICE_TITAN','Ice Titan','Ice Titan',60,38200,0,13872,7928,1,1090,1570,71,15,99,34,88,10,79,29,10,12,2,0,61,0x3885,250,861,660,144,0,0,0,0,0,0,0,0,7561,5000,7066,3000,749,100,984,10,985,30,0,0,995,100,0,0,0,0,4417,1);
REPLACE INTO `mob_db` VALUES (1778,'GAZETI','Gazeti','Gazeti',55,12300,0,5758,2075,10,512,612,65,25,1,12,20,60,101,5,10,12,1,6,21,0x3395,190,576,370,270,0,0,0,0,0,0,0,0,7561,3000,7066,3000,985,20,1731,1,0,0,0,0,0,0,0,0,0,0,4418,1);
REPLACE INTO `mob_db` VALUES (1779,'KTULLANUX','Ktullanux','Ktullanux',98,4417000,0,2720050,1120020,3,1680,10360,40,42,85,126,30,125,177,112,10,12,2,2,81,0x37B5,400,432,840,216,1360025,10000,607,5500,617,5000,617,5000,7562,9000,616,3000,2509,3000,2111,5000,617,5000,607,5000,0,0,0,0,0,0,4419,1);
REPLACE INTO `mob_db` VALUES (1780,'MUSCIPULAR','Muscipular','Muscipular',57,4332,0,1706,1706,3,521,726,12,12,1,53,39,25,92,51,10,12,1,3,22,0x84,2000,672,648,360,0,0,0,0,0,0,0,0,7565,3000,1032,3000,629,2,1033,2000,905,1000,631,3,0,0,0,0,0,0,4420,1);
REPLACE INTO `mob_db` VALUES (1781,'DROSERA','Drosera','Drosera',46,7221,0,2612,1022,7,389,589,10,13,1,30,27,17,76,41,10,12,1,3,22,0x84,2000,864,576,336,0,0,0,0,0,0,0,0,7565,3000,938,3000,1032,2000,1033,2000,621,3,905,1000,0,0,0,0,0,0,4421,1);
REPLACE INTO `mob_db` VALUES (1782,'ROWEEN','Roween','Roween',31,5716,0,1669,1266,1,298,377,0,7,51,39,48,18,67,19,10,12,1,2,24,0x108B,200,412,840,300,0,0,0,0,0,0,0,0,7564,3000,919,3000,992,50,1822,2,0,0,0,0,0,0,0,0,0,0,4422,1);
REPLACE INTO `mob_db` VALUES (1783,'GALION','Galion','Galion',44,32240,0,10020,3368,1,336,441,11,12,51,52,59,25,72,32,10,12,1,2,44,0x11AB,150,864,624,360,0,0,0,0,0,0,0,0,7564,3000,919,3000,996,10,2531,5,0,0,0,0,0,0,0,0,0,0,4423,1);
REPLACE INTO `mob_db` VALUES (1784,'STAPO','Stapo','Stapo',23,666,0,332,221,1,135,370,90,5,12,11,15,12,23,1,10,12,0,0,42,0x83,300,936,792,432,0,0,0,0,0,0,0,0,909,1000,7312,1000,512,1000,7126,100,993,10,1821,3,0,0,0,0,0,0,4424,1);
REPLACE INTO `mob_db` VALUES (1785,'ATROCE','Atroce','Atroce',82,1008420,0,295550,118895,2,2526,3646,25,25,100,87,30,49,89,72,10,12,2,2,67,0x37B5,150,576,600,240,147775,10000,607,5500,617,5000,617,5000,7563,7000,608,1000,2621,1000,617,5000,607,5000,5123,100,1175,100,0,0,0,0,4425,1);
REPLACE INTO `mob_db` VALUES (1786,'G_AGAV','Agav','Agav',73,25620,0,0,0,1,103,909,15,35,1,32,27,132,69,15,10,12,1,7,40,0x3295,300,768,360,360,0,0,0,0,0,0,0,0,7567,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1787,'G_ECHIO','Echio','Echio',69,36900,0,0,0,1,750,1500,33,11,74,74,52,35,59,56,10,12,1,7,40,0x3295,250,768,360,360,0,0,0,0,0,0,0,0,7567,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1788,'G_ICE_TITAN','Ice Titan','Ice Titan',60,32900,0,0,0,1,1090,1570,71,15,99,34,88,10,79,29,10,12,2,0,61,0x3295,250,861,660,144,0,0,0,0,0,0,0,0,7561,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1789,'ICEICLE','Iceicle','Iceicle',38,10,0,5,5,3,241,1082,0,10,1,10,10,10,172,5,10,12,0,0,41,0x84,2000,1344,0,0,0,0,0,0,0,0,0,0,7066,1000,7066,1000,7066,1000,7066,500,7066,500,7066,500,7066,500,0,0,0,0,7066,500);
REPLACE INTO `mob_db` VALUES (1790,'G_RAFFLESIA','Rafflesia','Rafflesia',17,1333,0,0,0,3,105,127,0,2,1,18,24,11,37,10,10,12,0,3,22,0x3885,150,512,528,240,0,0,0,0,0,0,0,0,7577,3000,7575,4000,7576,2000,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1791,'G_GALION','Galion','Galion',44,32240,0,0,0,1,336,441,11,12,51,52,59,25,72,32,10,12,1,2,44,0x11AB,150,864,624,360,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1792,'SOCCER_BALL','Soccer Ball','Soccer Ball',1,1000,0,0,0,0,0,0,128,99,0,0,0,0,0,0,0,0,0,0,20,0x40,2000,96,96,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1793,'G_MEGALITH','Megalith','Megalith',45,5300,0,0,0,9,264,314,50,25,1,45,60,5,95,5,10,12,2,0,80,0x3695,200,1332,1332,672,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1794,'G_ROWEEN','Roween','Roween',31,5716,0,0,0,1,298,377,0,7,51,39,48,18,67,19,10,12,1,2,24,0x3295,200,412,840,300,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1795,'BLOODY_KNIGHT_','Bloody Knight','Bloody Knight',82,800000,0,0,0,3,10000,30000,60,60,88,121,100,100,125,55,10,12,2,8,28,0x37B5,250,828,528,192,0,0,0,0,0,0,0,0,1417,100,2412,100,2514,200,2342,300,2513,200,1620,200,617,7000,7578,10000,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1796,'AUNOE','Aunoe','Aunoe',62,21297,0,7102,5102,1,1500,2144,11,19,1,28,12,91,57,12,10,12,1,7,80,0x3295,250,768,432,360,0,0,0,0,0,0,0,0,7568,2500,2422,1,7563,1000,2109,1,12183,50,7563,100,2545,1,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1797,'FANAT','Fanat','Fanat',62,21297,0,7102,5102,1,1500,2144,11,19,1,28,12,91,57,12,10,12,1,7,80,0x3885,250,768,432,360,0,0,0,0,0,0,0,0,2388,1,2422,1,7563,1000,2109,1,12183,10,7568,2500,0,0,0,0,0,0,0,0);

REPLACE INTO `mob_db` VALUES (1798,'TREASURE_BOX_','Treasure Chest','Treasure Chest',99,0,0,0,0,0,0,0,0,0,0,0,0,0,999,0,0,0,0,0,20,0x40,0,0,0,0,0,0,0,0,0,0,0,0,7582,10000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1799,'G_SEYREN_','Lord Knight Seyren','Lord Knight Seyren',99,347590,0,18000,10000,1,4238,5040,72,37,120,110,81,65,130,52,10,12,1,7,83,0x37B5,100,76,384,288,0,0,0,0,0,0,0,0,7583,300,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1800,'G_EREMES_','Assassin Cross Eremes','Assassin Cross Eremes',99,211230,0,18000,10000,1,3189,5289,27,39,90,181,62,37,122,60,10,12,1,7,85,0x37B5,100,76,384,288,0,0,0,0,0,0,0,0,7583,300,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1801,'G_HARWORD_','Whitesmith Harword','Mastersmith Howard',99,310000,0,18000,10000,1,4822,5033,66,36,100,73,112,35,136,60,10,12,1,7,81,0x37B5,100,76,384,288,0,0,0,0,0,0,0,0,7583,300,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1802,'G_MAGALETA_','High Priest Magaleta','High Priest Margaretha',99,182910,0,18000,10000,1,1688,2580,35,78,1,84,64,182,92,100,10,12,1,7,86,0x37B5,125,1152,384,288,9000,0,0,0,0,0,0,0,7583,300,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1803,'G_SHECIL_','Sniper Shecil','Sniper Cecil',99,209000,0,18000,10000,14,1892,5113,22,35,1,180,39,67,193,130,10,12,1,7,84,0x33B5,100,76,384,288,0,0,0,0,0,0,0,0,7583,300,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1804,'G_KATRINN_','High Wizard Katrinn','High Wizard Kathryne',99,189920,0,18000,10000,1,497,2094,10,88,1,89,42,223,128,93,10,12,1,7,68,0x37B5,150,1152,384,288,0,0,0,0,0,0,0,0,7583,300,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1805,'B_SEYREN_','Lord Knight Seyren','Lord Knight Seyren',99,1647590,0,4835600,1569970,1,7238,11040,72,37,120,110,81,65,130,52,10,12,1,7,83,0x37B5,100,76,384,288,0,0,0,0,0,0,0,0,7583,10000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1806,'B_EREMES_','Assassin Cross Eremes','Assassin Cross Eremes',99,1411230,0,4083400,1592380,1,4189,8289,37,39,90,181,62,37,122,60,10,12,1,7,85,0x37B5,100,76,384,288,0,0,0,0,0,0,0,0,7583,10000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1807,'B_HARWORD_','Whitesmith Harword','Mastersmith Howard',99,1460000,0,4002340,1421000,1,7822,8251,66,36,100,73,112,35,136,60,10,12,1,7,82,0x37B5,100,76,384,288,0,0,0,0,0,0,0,0,7583,10000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1808,'B_MAGALETA_','High Priest Magaleta','High Priest Margaretha',99,1092910,0,4257000,1318800,1,4688,5580,35,78,1,84,64,182,92,100,10,12,1,7,86,0x37B5,125,1152,384,288,0,0,0,0,0,0,0,0,7583,10000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1809,'B_SHECIL_','Sniper Shecil','Sniper Cecil',99,1349000,0,4093000,1526000,14,4892,9113,22,35,1,180,39,67,193,130,10,12,1,7,84,0x37B5,100,76,384,288,0,0,0,0,0,0,0,0,7583,10000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1810,'B_KATRINN_','High Wizard Katrinn','High Wizard Kathryne',99,1069920,0,4008200,1636700,1,1197,4394,10,88,1,89,42,223,128,93,10,12,1,7,68,0x37B5,150,1152,384,288,0,0,0,0,0,0,0,0,7583,10000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1811,'G_SMOKIE_','Smokie','Bandit',18,641,0,0,0,1,61,72,0,10,1,18,36,25,26,35,10,12,0,2,22,0x91,200,1576,576,420,0,0,0,0,0,0,0,0,2201,100,7267,500,606,1000,536,2000,7299,500,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1812,'EVENT_LUDE','Lude','Delightful Lude',99,15,0,0,0,0,0,0,100,99,1,1,1,1,999,1,0,0,0,0,20,0x40,190,890,960,480,0,0,0,0,0,0,0,0,7225,5000,1062,5000,535,5000,7609,5000,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1813,'EVENT_HYDRO','Hydro','Hydrolancer',99,1880000,0,4000000,2000000,3,15000,47767,60,55,1,142,200,250,189,32,10,12,2,8,28,0x37B5,100,972,672,432,0,0,0,0,0,0,0,0,7607,10000,13001,500,5002,500,1417,500,12080,1500,7444,5500,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1814,'EVENT_MOON','Moonlight Flower','Moonlight Flower',80,30000,0,30000,30000,1,500,800,50,50,1,35,45,112,69,93,10,12,1,2,63,0x37B5,150,1276,576,288,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1815,'EVENT_RICECAKE','Rice Cake','Rice Cake',12,20,0,0,0,1,1,2,100,99,1,1,1,1,1,1,0,0,1,0,20,0x40,2000,1320,0,300,0,0,0,0,0,0,0,0,7613,10000,7613,10000,7613,10000,7613,10000,7613,10000,7613,5000,7613,4000,0,0,0,0,7613,3000);
REPLACE INTO `mob_db` VALUES (1816,'EVENT_GOURD','Gourd','Gourd',12,1000,0,0,0,1,1,2,100,99,1,1,1,1,1,1,0,0,1,0,20,0x40,2000,96,96,96,0,0,0,0,0,0,0,0,512,10000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1817,'EVENT_DETALE','Detale','Detarderous',99,8880000,0,4500000,2500000,3,32767,65534,65,65,1,142,200,250,189,50,10,12,2,8,48,0x37B5,100,972,936,360,0,0,0,0,0,0,0,0,7701,10000,1724,500,1473,500,1265,500,12080,1500,12100,1500,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1818,'EVENT_ALARM','Alarm','Alarm',58,10647,0,0,0,0,1,2,15,15,1,62,72,10,85,45,10,12,1,0,60,0x3695,1000,1020,500,768,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7703,7000);
REPLACE INTO `mob_db` VALUES (1819,'EVENT_BATHORY','Bathory','Bathory',44,5415,0,0,0,1,198,398,0,60,1,76,24,85,65,15,10,12,1,7,27,0x3695,100,1504,840,900,0,0,0,0,0,0,0,0,7850,2000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1820,'EVENT_BIGFOOT','Bigfoot','Bigfoot',25,1619,0,0,0,1,198,220,10,0,1,25,55,15,20,25,10,12,2,2,22,0x91,300,1260,192,192,0,0,0,0,0,0,0,0,7850,2000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1821,'EVENT_DESERT_WOLF','Desert Wolf','Desert Wolf',27,1716,0,0,0,1,169,208,0,10,56,27,45,15,56,10,10,12,1,2,23,0x308D,200,1120,420,288,0,0,0,0,0,0,0,0,7850,2000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1822,'EVENT_DEVIRUCHI','Deviruchi','Deviruchi',46,6666,0,0,0,1,475,560,10,25,1,69,40,55,70,30,10,12,0,6,27,0x3795,150,980,600,384,0,0,0,0,0,0,0,0,7850,3000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1823,'EVENT_FREEZER','Freezer','Freezer',72,8636,0,0,0,2,671,983,55,43,69,41,59,5,67,100,10,12,1,2,41,0x3695,250,1452,483,528,0,0,0,0,0,0,0,0,7850,3000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1824,'EVENT_GARM_BABY','Garm Baby','Garm Baby',61,20199,0,0,0,1,680,1179,34,13,45,30,56,55,85,30,10,12,1,2,41,0x3885,450,879,672,576,0,0,0,0,0,0,0,0,7850,5000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1825,'EVENT_GOBLINE_XMAS','Christmas Goblin','Christmas Goblin',25,1176,0,0,0,1,118,140,10,5,1,53,25,20,38,45,10,12,1,7,24,0x3695,100,1120,620,240,0,0,0,0,0,0,0,0,7850,5000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1826,'EVENT_MYST','Myst','Myst',38,3745,0,0,0,1,365,445,0,40,1,38,18,0,53,10,10,12,2,0,25,0x3695,200,1576,576,384,0,0,0,0,0,0,0,0,7850,3000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1827,'EVENT_SASQUATCH','Sasquatch','Sasquatch',30,3163,0,0,0,1,250,280,5,0,75,25,60,10,34,20,10,12,2,2,60,0x3695,300,1260,192,192,0,0,0,0,0,0,0,0,7850,3000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1828,'EVENT_GULLINBURSTI','Gullinbrusti','Gullinbrusti',20,20,0,0,0,1,59,72,100,99,1,14,14,0,19,15,10,12,2,2,42,0x3695,150,1960,960,384,0,0,0,0,0,0,0,0,7303,6000,570,9000,571,8000,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1829,'SWORD_GUARDIAN','Sword Guardian','Sword Master',86,152533,0,155013,122604,2,7590,9140,60,33,110,40,54,65,125,65,14,16,2,7,80,0x37B5,170,140,384,288,0,0,0,0,0,0,0,0,7069,3000,1370,30,1163,50,1168,1,2122,10,1176,50,0,0,0,0,0,0,4427,1);
REPLACE INTO `mob_db` VALUES (1830,'BOW_GUARDIAN','Bow Guardian','Bow Master',80,80404,0,50149,23006,12,1840,2520,40,62,95,80,33,90,165,55,14,16,2,7,80,0x37B5,170,76,384,288,0,0,0,0,0,0,0,0,7069,3000,1723,30,1701,50,2367,20,2701,4,0,0,0,0,0,0,0,0,4428,1);
REPLACE INTO `mob_db` VALUES (1831,'SALAMANDER','Salamander','Salamander',91,97934,0,72000,55000,2,7590,10860,65,50,90,55,44,45,180,25,10,12,2,0,63,0x37B5,160,140,384,288,0,0,0,0,0,0,0,0,7097,3000,994,30,716,100,2680,1,1920,50,2621,1,2364,20,0,0,0,0,4429,1);
REPLACE INTO `mob_db` VALUES (1832,'IFRIT','Ifrit','Ifrit',99,7700000,0,3154321,3114520,3,13530,17000,40,50,120,180,25,190,199,50,10,12,2,0,83,0x37B5,130,212,384,360,1577160,10000,603,5500,617,5000,616,2000,994,10000,2677,3000,2678,200,2679,200,1471,2000,1133,2000,2345,100,0,0,0,0,4430,1);
REPLACE INTO `mob_db` VALUES (1833,'KASA','Kasa','Kasa',85,80375,0,49000,38000,2,3030,3500,23,70,45,110,31,200,140,30,10,12,2,0,63,0x37B5,150,800,600,288,0,0,0,0,0,0,0,0,7097,3000,7122,2500,994,30,2680,1,2344,10,1730,10,1626,10,0,0,0,0,4431,1);
REPLACE INTO `mob_db` VALUES (1834,'G_SALAMANDER','Salamander','Salamander',91,97934,0,0,0,2,9590,12860,65,60,90,55,44,45,180,25,10,12,2,0,63,0x37B5,160,140,384,288,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1835,'G_KASA','Kasa','Kasa',85,80375,0,0,0,2,3030,3500,23,70,45,158,31,250,160,30,10,12,2,0,63,0x37B5,150,800,600,288,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1836,'MAGMARING','Magmaring','Magmaring',40,5300,0,2110,1910,1,550,700,25,24,40,60,30,10,60,17,10,12,0,0,43,0x83,300,1472,384,288,0,0,0,0,0,0,0,0,7097,3000,757,34,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4432,1);
REPLACE INTO `mob_db` VALUES (1837,'IMP','Imp','Fire Imp',76,46430,0,25200,11077,1,1059,1509,27,50,37,76,30,150,99,10,10,12,0,6,63,0x3395,150,824,432,360,0,0,0,0,0,0,0,0,7122,3000,13303,3,7098,2500,1376,10,1972,25,12374,20,0,0,0,0,0,0,4433,1);
REPLACE INTO `mob_db` VALUES (1838,'KNOCKER','Knocker','Knocker',50,7755,0,2202,4023,1,889,990,28,50,25,44,50,62,65,60,10,12,0,6,22,0x191,200,1548,384,288,0,0,0,0,0,0,0,0,997,30,1003,150,1040,5500,2286,1,2208,10,2124,3,1732,5,0,0,0,0,4434,1);
REPLACE INTO `mob_db` VALUES (1839,'BYORGUE','Byorgue','Byorgue',86,38133,0,19000,9500,2,1340,2590,20,13,25,80,12,30,70,10,14,16,1,7,20,0x37B5,170,800,600,360,0,0,0,0,0,0,0,0,1270,50,5096,3,13027,150,12087,500,603,40,2530,1,7110,4365,0,0,0,0,4426,1);
REPLACE INTO `mob_db` VALUES (1840,'GOLDEN_SAVAGE','Golden Savage','Golden Savage',99,500,0,1,1,1,500,700,100,99,0,1,1,50,120,1,10,12,2,2,42,0xF1,150,1960,480,384,0,0,0,0,0,0,0,0,610,3000,7444,100,616,5,969,500,714,100,5159,1,12238,3000,12239,3000,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1841,'G_SNAKE_','Snake Lord\'s Minion','Snake Lord\'s Minion',15,10,0,1,1,1,46,55,100,99,1,15,15,10,35,5,10,12,1,2,22,0x81,200,1576,576,576,0,0,0,0,0,0,0,0,7720,2000,12245,200,7721,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1842,'G_ANACONDAQ_','Snake Lord\'s Minion','Snake Lord\'s Minion',23,15,0,1,1,1,124,157,100,99,1,23,28,10,36,5,10,12,1,2,25,0x91,200,1576,576,576,0,0,0,0,0,0,0,0,7720,3500,12245,400,7721,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1843,'G_SIDE_WINDER_','Snake Lord\'s Minion','Snake Lord\'s Minion',43,18,0,1,1,1,240,320,100,99,38,43,40,15,115,20,10,12,1,2,25,0x3095,200,1576,576,576,0,0,0,0,0,0,0,0,7720,7000,12245,600,7721,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1844,'G_ISIS_','Snake Lord\'s Minion','Snake Lord\'s Minion',47,25,0,1,1,1,423,507,100,99,38,65,43,50,66,15,10,12,2,6,27,0x3195,200,1384,768,336,0,0,0,0,0,0,0,0,7720,8000,12245,800,7721,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1845,'G_TREASURE_BOX_','Treasure Box','Treasure Box',98,0,0,0,0,0,0,0,0,0,0,0,0,0,999,0,0,0,0,0,20,0x120,0,0,0,0,0,0,0,0,0,0,0,0,7720,10000,7720,10000,7720,10000,7721,10000,12245,2500,7720,5000,12245,2500,0,0,0,0,12245,2500);
REPLACE INTO `mob_db` VALUES (1846,'DREAMMETAL','Dream Metal','Dream Metal',90,999,0,1,1,1,1,2,100,99,1,1,1,1,1,1,10,12,0,0,26,0x120,300,1288,288,384,0,0,0,0,0,0,0,0,7858,2000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1847,'EVENT_PORING','Poring','Poring',98,10000000,0,1000000,1000000,1,15000,20000,60,60,1,60,120,120,160,30,10,12,1,8,28,0x37B5,100,76,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1848,'EVENT_BAPHOMET','Baphomet','Baphomet',50,45000,0,1000,1000,2,1500,3000,10,10,1,60,15,15,160,30,10,12,2,6,67,0x37B5,100,768,768,576,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1849,'EVENT_OSIRIS','Osiris','Osiris',60,125000,0,2000,2000,1,3500,5000,20,20,1,60,25,25,160,30,10,12,1,1,89,0x37B5,100,1072,672,384,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1850,'EVENT_ORCHERO','Orc Hero','Orc Hero',50,175000,0,3000,3000,1,4000,5500,25,45,1,60,35,80,160,30,10,12,2,7,82,0x37B5,150,1678,780,648,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1851,'EVENT_MOBSTER','Mobster','Mobster',61,7991,0,2,2,1,500,1000,45,35,76,46,20,35,76,55,10,12,1,7,20,0x3695,250,1100,560,580,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1852,'G_EM_ANGELING','Angeling','Angeling',99,120,0,0,0,1,60,71,100,99,1,17,80,80,126,20,10,12,0,8,66,0x37B5,300,1288,288,384,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1853,'G_EM_DEVILING','Deviling','Deviling',99,120,0,0,0,1,60,71,100,99,1,17,80,80,126,20,10,12,0,8,66,0x37B5,300,1288,288,384,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1854,'E_MUKA','Muka','Muka',17,610,0,273,120,1,40,49,5,5,15,15,30,5,20,10,10,12,2,3,22,0x83,300,1960,960,384,0,0,0,0,0,0,0,0,993,70,952,9000,713,2000,7742,400,507,1000,1451,50,1002,250,0,0,0,0,4036,1);
REPLACE INTO `mob_db` VALUES (1855,'E_POISONSPORE','Poison Spore','Poison Spore',19,665,0,186,93,1,89,101,0,0,1,19,25,0,24,0,10,12,1,3,25,0x3885,200,1672,672,288,0,0,0,0,0,0,0,0,7033,9000,2221,20,511,550,7743,60,972,50,921,1200,912,5,0,0,0,0,4048,1);
REPLACE INTO `mob_db` VALUES (1856,'E_MAGNOLIA','Magnolia','Magnolia',26,3195,0,393,248,1,120,151,5,30,1,26,26,0,39,5,10,12,0,6,21,0x183,250,1560,360,360,0,0,0,0,0,0,0,0,7031,9000,910,800,911,100,912,10,737,40,7744,400,12127,5,0,0,0,0,4076,1);
REPLACE INTO `mob_db` VALUES (1857,'E_MARIN','Marin','Marin',15,742,0,66,44,1,39,43,0,10,1,10,10,5,35,15,10,12,1,3,41,0x81,400,1872,672,480,0,0,0,0,0,0,0,0,910,3200,938,1500,700,100,720,40,7745,75,529,350,5035,1,0,0,0,0,4196,1);
REPLACE INTO `mob_db` VALUES (1858,'E_PLANKTON','Plankton','Plankton',10,354,0,23,18,1,26,31,0,5,1,10,10,0,15,0,10,12,0,3,61,0x81,400,2208,1008,324,0,0,0,0,0,0,0,0,1052,9000,7746,300,938,700,970,4,713,1000,630,20,645,50,0,0,0,0,4024,1);
REPLACE INTO `mob_db` VALUES (1859,'E_MANDRAGORA','Mandragora','Mandragora',12,405,0,45,32,4,26,35,0,25,1,12,24,0,36,15,10,12,1,3,62,0x84,1000,1768,768,576,0,0,0,0,0,0,0,0,993,50,905,9000,1405,30,7747,350,711,300,706,3,1967,10,0,0,0,0,4030,1);
REPLACE INTO `mob_db` VALUES (1860,'E_COCO','Coco','Coco',17,817,0,120,78,1,56,67,0,0,24,17,34,20,24,10,10,12,0,2,22,0x91,150,1864,864,1008,0,0,0,0,0,0,0,0,1026,9000,2502,20,914,3000,919,2500,516,500,2402,25,7748,600,0,0,0,0,4041,1);
REPLACE INTO `mob_db` VALUES (1861,'E_CHOCO','Choco','Choco',43,4278,0,1265,1265,1,315,402,5,5,65,68,55,45,65,25,10,12,0,2,23,0x3095,200,1500,500,1000,0,0,0,0,0,0,0,0,7011,5335,942,7000,985,53,513,5000,634,20,7749,1000,607,25,0,0,0,0,4285,1);
REPLACE INTO `mob_db` VALUES (1862,'E_MARTIN','Martin','Martin',18,1109,0,134,86,1,52,63,0,5,12,18,30,15,15,5,10,12,0,2,42,0x81,300,1480,480,480,0,0,0,0,0,0,0,0,1017,9000,7750,500,1251,10,2225,5,5009,1,10010,10,2224,15,0,0,0,0,4046,1);
REPLACE INTO `mob_db` VALUES (1863,'E_SPRING_RABBIT','Spring Rabbit','Spring Rabbit',25,4500,0,0,0,1,292,406,14,10,20,15,15,5,15,5,10,12,1,2,42,0x83,160,1120,552,511,0,0,0,0,0,0,0,0,7860,5000,7861,5000,7862,5000,0,0,0,0,0,0,0,0,0,0,0,0,0,0);

#  Cursed Abbey
REPLACE INTO `mob_db` VALUES (1864,'ZOMBIE_SLAUGHTER','Zombie Slaughter','Zombie Slaughter',77,43000,0,12000,8500,1,1055,1655,35,45,1,30,50,1,75,35,10,12,1,1,69,0x3695,200,676,648,432,0,0,0,0,0,0,0,0,7752,3000,13404,10,934,1500,7753,3000,938,3000,0,0,0,0,0,0,0,0,4435,1);
REPLACE INTO `mob_db` VALUES (1865,'RAGGED_ZOMBIE','Ragged Zombie','Ragged Zombie',75,25000,0,8500,5500,9,1200,1500,25,35,1,77,25,10,101,50,10,12,1,1,69,0x3695,150,1960,576,420,0,0,0,0,0,0,0,0,7752,3000,2424,15,934,1500,932,4500,2703,2,13107,10,0,0,0,0,0,0,4436,1);
REPLACE INTO `mob_db` VALUES (1866,'HELL_POODLE','Hell Poodle','Hell Poodle',71,9000,0,4000,3000,1,400,600,35,20,5,26,14,5,39,10,10,12,0,6,27,0x3795,140,824,432,360,0,0,0,0,0,0,0,0,528,5000,13028,10,1268,10,932,4500,628,20,919,5500,537,400,0,0,0,0,4437,1);
REPLACE INTO `mob_db` VALUES (1867,'BANSHEE','Banshee','Banshee',81,35111,0,17000,12000,1,1666,2609,30,55,30,74,1,120,75,1,10,12,1,6,47,0x3795,150,576,504,504,0,0,0,0,0,0,0,0,7751,3000,2365,10,13027,10,2528,10,934,1500,7054,5335,0,0,0,0,0,0,4438,1);
REPLACE INTO `mob_db` VALUES (1868,'G_BANSHEE','Banshee','Banshee',81,35111,0,0,0,1,1666,2609,30,55,30,74,1,120,120,1,10,12,1,6,47,0x3795,150,576,504,504,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1869,'FLAME_SKULL','Flame Skull','Flame Skull',60,10080,0,3000,2600,1,100,1200,20,40,50,100,30,40,140,110,10,12,0,6,68,0x3195,150,972,648,432,0,0,0,0,0,0,0,0,7005,5000,2425,20,13170,20,958,6000,0,0,0,0,0,0,0,0,0,0,4439,1);
REPLACE INTO `mob_db` VALUES (1870,'NECROMANCER','Necromancer','Necromancer',88,98000,0,45000,35000,1,3500,4000,0,40,1,50,1,190,166,10,10,12,1,1,89,0x37B5,150,1816,1320,420,0,0,0,0,0,0,0,0,7752,3000,1624,20,932,4500,2532,10,717,100,609,100,7117,1500,0,0,0,0,4440,1);
REPLACE INTO `mob_db` VALUES (1871,'FALLINGBISHOP','Fallen Bishop','Fallen Bishop Hibram',80,3333333,0,1111111,1111111,1,3220,5040,50,0,1,80,15,126,120,20,10,12,1,6,47,0x37B5,150,432,1152,360,555555,10000,607,5500,617,5000,617,5000,523,10000,1420,1000,2677,500,1422,1000,985,5432,1614,2000,0,0,0,0,0,0,4441,1);
REPLACE INTO `mob_db` VALUES (1872,'BEELZEBUB_FLY','Hell Fly','Hell Fly',66,500000,0,0,0,1,1200,2000,25,15,33,105,60,15,72,30,10,12,0,4,84,0x37B5,100,676,576,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1873,'BEELZEBUB','Beelzebub','Beelzebub',98,6666666,0,0,0,1,4100,4960,40,35,6,110,200,250,120,66,10,12,0,6,88,0x37B5,100,100,576,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1874,'BEELZEBUB_','Beelzebub','Beelzebub',98,6666666,0,6666666,6666666,2,10000,13410,40,40,6,110,200,250,166,66,10,12,2,6,88,0x37B5,100,212,504,432,3333333,10000,607,5500,617,5000,617,5000,7754,9000,2423,2000,1565,2000,2000,2000,2702,2000,985,5432,742,5500,0,0,0,0,4145,1);
REPLACE INTO `mob_db` VALUES (1875,'TRISTAN_3RD','Tristan III','Dead King',80,43000,0,1,1,2,1366,1626,25,30,5,10,10,69,70,1,10,12,1,1,89,0x3695,175,1816,1152,360,0,0,0,0,0,0,0,0,7754,9000,938,9000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1876,'E_LORD_OF_DEATH','Lord of the Dead','Lord of the Dead',99,99000000,0,131343,43345,3,3430,4232,75,73,120,120,120,169,150,106,10,12,2,6,67,0x37B5,180,1446,1296,360,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1877,'CRYSTAL_5','Crystal','Crystal',1,15,0,0,0,0,0,0,100,99,1,1,1,1,999,1,0,0,0,0,20,0x161,190,0,0,0,0,0,0,0,0,0,0,0,7863,10,644,100,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1878,'E_SHINING_PLANT','Shining Plant','Shining Plant',1,20,0,0,0,1,1,2,100,99,0,0,0,0,0,90,7,12,0,3,26,0x40,2000,1,1,1,0,0,0,0,0,0,0,0,7864,3000,906,1500,511,500,507,2000,508,1500,914,500,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1879,'ECLIPSE_P','Eclipse Pet','Eclipse',6,1800,0,0,0,1,20,26,0,40,1,36,6,0,11,80,10,12,1,2,60,0x37B5,200,1456,456,336,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);

#  Moscovia monsters
REPLACE INTO `mob_db` VALUES (1880,'WOOD_GOBLIN','Wood Goblin','Wood Goblin',42,6982,0,2201,1552,1,600,620,32,3,1,5,45,45,55,155,10,12,1,3,62,0x81,320,2304,840,360,0,0,0,0,0,0,0,0,2719,5,7203,4000,7201,2000,907,2000,916,500,7032,500,574,50,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1881,'LES','Les','Les',39,3080,0,1521,912,1,102,113,0,17,1,33,12,32,52,38,10,12,1,3,82,0x1089,230,1728,720,576,0,0,0,0,0,0,0,0,7100,2000,511,1000,711,1000,905,2500,2270,1,521,500,510,50,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1882,'VAVAYAGA','Baba Yaga','Baba Yaga',49,7444,0,2583,2583,2,255,387,4,29,1,76,24,88,55,18,10,12,1,7,21,0x3885,270,1536,600,420,0,0,0,0,0,0,0,0,7099,1000,7762,5000,1630,10,7226,150,539,1500,519,1500,580,1500,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1883,'UZHAS','Uzhas','Uzhas',61,13707,0,4002,3003,1,293,960,11,34,1,33,19,72,75,77,10,12,1,7,61,0x3885,200,576,672,384,0,0,0,0,0,0,0,0,520,900,1573,5,621,100,522,100,918,3500,579,1500,603,3,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1884,'MAVKA','Mavka','Mavka',63,19200,0,8301,6353,7,589,623,32,19,1,42,55,35,89,177,10,12,1,3,62,0x3885,170,1536,504,360,0,0,0,0,0,0,0,0,1572,5,629,300,707,300,710,50,747,1500,748,300,510,3000,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1885,'GOPINICH','Gopinich','Gopinich',85,299321,0,45250,16445,3,1868,6124,20,42,50,65,55,103,152,35,10,12,2,2,62,0x37B5,150,1536,864,432,22625,10000,607,5500,617,5000,617,5000,617,4000,2621,200,12080,1000,1737,100,1417,5,7444,5000,5007,1,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1886,'G_MAVKA','Mavka','Mavka',63,19200,0,0,0,7,589,623,32,19,1,42,55,35,89,177,10,12,1,3,62,0x3885,170,1536,504,360,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);

#  Additional Monsters
REPLACE INTO `mob_db` VALUES (1887,'FREEZER_R','Freezer','Freezer',72,8636,0,0,0,2,671,983,55,43,69,41,59,5,67,100,10,12,1,2,41,0x3695,250,1452,483,528,0,0,0,0,0,0,0,0,7053,2000,7066,2000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1888,'GARM_BABY_R','Hatii Baby','Hatii Baby',61,15199,0,100,100,1,680,1580,24,13,45,30,36,55,85,30,10,12,1,2,41,0x3885,450,879,672,576,0,0,0,0,0,0,0,0,0,0,7066,2000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1889,'GARM_R','Marozka\'s Guard','Marozka\'s Guard',73,100000,0,1000,1000,3,900,2200,20,23,85,126,10,50,95,60,10,12,2,2,81,0x37B5,400,608,408,336,0,0,0,0,0,0,0,0,7053,2000,7066,2000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1890,'GOPINICH_R','The Immortal Koshei','The Immortal Koshei',85,299321,0,1000,1000,3,1868,6124,20,42,50,65,55,50,152,35,10,12,2,2,62,0x3295,150,1536,864,432,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1891,'G_RANDGRIS_','Valkyrie','Valkyrie',99,1567200,0,0,0,3,5560,9980,25,42,100,120,80,120,220,210,10,12,2,8,86,0x37B5,100,576,576,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1892,'G_LOLI_RURI','Lolo Ruri','Lolo Ruri',71,23470,0,0,0,2,1476,2317,39,44,0,66,54,74,81,43,10,12,2,6,87,0x3985,125,747,1632,576,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1893,'G_KNIGHT_OF_ABYSS','Knight of the Abyss','Abysmal Knight',79,36140,0,0,0,1,1600,2150,55,50,66,68,64,25,135,50,10,12,2,7,87,0x3695,300,1500,500,1000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1894,'POURING','Pouring','Pouring',50,100000,0,0,0,1,550,1450,20,50,45,30,36,55,85,30,0,0,0,3,68,0x11AB,300,1672,672,480,0,0,0,0,0,0,0,0,0,0,0,0,12257,8335,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1895,'EVENT_SEYREN','Seyren','Seyren Windsor',91,88402,0,0,0,1,2100,2530,63,12,90,89,72,20,99,25,10,12,1,6,63,0x3295,170,76,384,288,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1896,'EVENT_KATRINN','Katrinn','Kathryne Keyron',92,47280,0,0,0,1,497,1697,10,74,1,5,77,180,110,39,10,12,1,7,68,0x3295,150,1152,384,288,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1897,'EVENT_BAPHOMET_','Baphomet','Baphomet',81,668000,0,0,0,2,3220,4040,35,45,1,152,30,85,120,95,10,12,2,6,67,0x37B5,100,768,768,576,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1898,'EVENT_ZOMBIE','Zombie','Zombie',12,434,0,0,0,1,67,79,0,10,1,1,1,1,1,1,10,12,1,1,29,0x3885,400,2612,912,288,0,0,0,0,0,0,0,0,7884,10000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1899,'SWORD_GUARDIAN_','Sword Guardian','Sword Guardian',86,152533,0,0,0,2,7590,9140,60,33,110,40,54,65,125,65,14,16,2,7,80,0x20A5,170,140,384,288,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (1900,'BOW_GUARDIAN_','Archer Guardian','Archer Guardian',80,80404,0,0,0,12,1840,2520,40,62,95,80,33,90,165,55,14,16,2,7,80,0x20A5,170,76,384,288,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1901,'E_CONDOR','Condor','Condor',5,8000,0,100,100,1,200,400,10,15,1,13,10,25,95,10,10,12,0,8,26,0x1089,150,1148,648,480,0,0,0,0,0,0,0,0,7781,5000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1902,'E_TREASURE1','Treasure Box','Treasure Box',99,49,0,0,0,0,0,0,100,0,0,0,0,0,999,0,0,0,0,0,26,0x120,0,0,0,0,0,0,0,0,0,0,0,0,7782,1000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1903,'E_TREASURE2','Treasure Box','Treasure Box',99,49,0,0,0,0,0,0,100,0,0,0,0,0,999,0,0,0,0,0,26,0x120,0,0,0,0,0,0,0,0,0,0,0,0,7783,1000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1904,'BOMBPORING','Bomb Poring','Bomb Poring',28,1000000,0,461,284,1,120,320,100,99,1,28,28,0,33,50,10,12,0,0,20,0x11AB,300,1672,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);

#  WoE Second Edition; Battle Fields
REPLACE INTO `mob_db` VALUES (1905,'BARRICADE','Barricade','Barricade',98,120000,0,0,0,1,0,0,0,0,1,17,1,80,126,20,10,12,2,0,20,0x120,300,1288,288,384,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1906,'BARRICADE_','Barricade','Barricade',98,150,0,0,0,1,0,0,100,99,1,17,1,80,126,20,10,12,2,0,20,0x160,300,1288,288,384,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1907,'S_EMPEL_1','Guardian Stone','Guardian Stone',90,120000,0,0,0,0,1,2,40,50,1,1,1,1,1,1,0,0,0,0,20,0x120,300,1288,288,384,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1908,'S_EMPEL_2','Guardian Stone','Guardian Stone',90,120000,0,0,0,0,1,2,40,50,1,1,1,1,1,1,0,0,0,0,20,0x120,300,1288,288,384,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1909,'OBJ_A','Food Storage','Food Storage',90,250,0,0,0,0,1,2,100,99,1,1,1,1,1,1,0,0,2,0,20,0x160,300,1288,288,384,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1910,'OBJ_B','Food Depot','Food Depot',90,250,0,0,0,0,1,2,100,99,1,1,1,1,1,1,0,0,2,0,20,0x160,300,1288,288,384,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1911,'OBJ_NEUTRAL','Neutrality Flag','Neutrality Flag',90,150,0,0,0,0,1,2,100,99,1,1,1,1,1,1,0,0,2,0,20,0x160,300,1288,288,384,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1912,'OBJ_FLAG_A','Lion Flag','Lion Flag',90,150,0,0,0,0,1,2,100,99,1,1,1,1,1,1,0,0,2,0,20,0x160,300,1288,288,384,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1913,'OBJ_FLAG_B','Eagle Flag','Eagle Flag',90,150,0,0,0,0,1,2,100,99,1,1,1,1,1,1,0,0,2,0,20,0x160,300,1288,288,384,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1914,'OBJ_A2','Blue Crystal','Blue Crystal',90,250,0,0,0,0,1,2,100,99,1,1,1,1,1,1,0,0,2,0,20,0x160,300,1288,288,384,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1915,'OBJ_B2','Pink Crystal','Pink Crystal',90,250,0,0,0,0,1,2,100,99,1,1,1,1,1,1,0,0,2,0,20,0x160,300,1288,288,384,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);

#  Satan Morroc
REPLACE INTO `mob_db` VALUES (1916,'MOROCC','Satan Morroc','Satan Morroc',99,8388607,0,6700000,4500000,2,32000,32001,29,65,140,160,30,250,180,50,10,12,2,6,87,0x37B5,100,76,540,432,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1917,'MOROCC_','Wounded Morroc','Wounded Morroc',99,8388607,0,3600000,3000000,2,15000,18000,29,65,140,160,30,250,180,40,10,12,2,6,87,0x37B5,100,576,540,432,3600000,5000,607,5500,617,5000,617,5000,5808,1000,2374,5000,2375,5000,2433,5000,7799,9000,7798,9000,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1918,'MOROCC_1','Incarnation of Morroc','Incarnation of Morroc',97,190000,0,61000,140000,1,7000,8600,20,35,150,152,30,180,186,70,10,12,2,8,27,0x37B5,110,576,540,432,0,0,0,0,0,0,0,0,2111,10,7799,1000,7798,3000,985,160,7054,4850,2537,3,1541,20,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1919,'MOROCC_2','Incarnation of Morroc','Incarnation of Morroc',97,190000,0,65000,120000,1,3500,5100,20,5,120,83,20,10,166,50,10,12,1,6,67,0x37B5,150,576,540,432,0,0,0,0,0,0,0,0,2536,3,7799,1000,7798,3000,984,160,7053,3500,2130,15,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1920,'MOROCC_3','Incarnation of Morroc','Incarnation of Morroc',96,143000,0,50000,80000,2,3400,5000,15,37,40,200,20,60,100,37,10,12,1,6,69,0x37B5,150,212,540,432,0,0,0,0,0,0,0,0,2508,10,7799,1000,7798,3000,985,160,7054,4850,2728,3,1182,15,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1921,'MOROCC_4','Incarnation of Morroc','Incarnation of Morroc',98,150000,0,51000,70000,1,3000,4025,18,54,60,60,30,220,125,20,10,12,1,6,68,0x37B5,150,1536,540,432,0,0,0,0,0,0,0,0,2729,5,7799,1000,7798,3000,984,160,7053,3500,2129,20,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1922,'G_MOROCC_1','Incarnation of Morroc','Incarnation of Morroc',97,1200000,0,0,0,1,16000,16001,20,35,150,152,30,180,186,70,10,12,2,8,27,0x37B5,110,576,540,432,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1923,'G_MOROCC_2','Incarnation of Morroc','Incarnation of Morroc',97,1200000,0,0,0,1,16000,16001,20,5,120,83,20,10,166,50,10,12,1,6,67,0x37B5,150,576,540,432,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1924,'G_MOROCC_3','Incarnation of Morroc','Incarnation of Morroc',96,1200000,0,0,0,2,16000,16001,15,37,40,200,20,60,100,37,10,12,1,6,69,0x37B5,150,212,540,432,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1925,'G_MOROCC_4','Incarnation of Morroc','Incarnation of Morroc',98,1200000,0,0,0,1,16000,16001,18,54,60,60,30,220,125,20,10,12,1,6,68,0x37B5,150,1536,540,432,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
#  God Item Creation (WoE SE); Catacombs
REPLACE INTO `mob_db` VALUES (1926,'JAKK_H','Jakk','Jakk',38,300,0,0,0,1,5,10,5,30,1,38,38,43,75,45,10,12,1,0,43,0x3695,200,1180,480,648,0,0,0,0,0,0,0,0,1062,3000,1062,3000,0,0,535,3000,535,3000,535,3000,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1927,'WHISPER_H','Whisper','Whisper',34,100,0,0,0,1,5,10,0,45,1,51,14,0,60,0,10,12,0,6,68,0x3195,150,1960,960,504,0,0,0,0,0,0,0,0,1059,5000,1059,5000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1928,'DEVIRUCHI_H','Deviruchi','Deviruchi',46,500,0,0,0,1,5,10,10,25,1,69,40,55,70,30,10,12,0,6,27,0x3795,150,980,600,384,0,0,0,0,0,0,0,0,1038,3000,1039,3000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1929,'BAPHOMET_I','Great Demon Baphomet','Great Demon Baphomet',98,4520000,0,4520000,2520000,2,16000,16001,35,45,1,152,5,85,200,95,10,12,2,6,67,0x37B5,100,768,768,576,0,0,0,0,0,0,0,0,6004,500,2514,7000,1181,5000,2655,100,2513,7000,2327,7000,1466,9000,0,0,0,0,4147,1);
REPLACE INTO `mob_db` VALUES (1930,'PIAMETTE','Piamette','Piamette',90,3000000,0,0,0,2,15000,20000,35,35,1,66,5,99,120,15,10,12,0,7,20,0x37B5,100,432,768,576,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1931,'WISH_MAIDEN','Wish Maiden','Wish Maiden',98,3567200,0,0,0,3,32000,32001,25,42,100,120,30,120,220,210,10,12,2,8,28,0x37B5,100,576,576,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1932,'GARDEN_KEEPER','Garden Keeper','Garden Keeper',80,100,0,0,0,1,1,2,100,99,1,1,1,1,1,1,10,12,0,0,42,0xE1,100,768,768,576,0,0,0,0,0,0,0,0,7839,9000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1933,'GARDEN_WATCHER','Garden Watcher','Garden Watcher',81,300000,0,0,0,1,1666,2609,55,55,30,74,56,126,145,114,10,12,1,8,80,0x37B5,100,432,480,360,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1934,'BLUE_FLOWER','Blue Flower','Blue Flower',98,10000,0,0,0,0,1,2,100,99,1,1,1,1,1,1,10,12,1,3,22,0x60,100,768,768,576,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1935,'RED_FLOWER','Red Flower','Red Flower',98,10000,0,0,0,0,1,2,100,99,1,1,1,1,1,1,10,12,1,3,22,0x60,100,768,768,576,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1936,'YELL_FLOWER','Yellow Flower','Yellow Flower',98,10000,0,0,0,0,1,2,100,99,1,1,1,1,1,1,10,12,1,3,22,0x60,100,768,768,576,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1937,'CONSTANT_','Constant','Constant',55,10000,0,0,0,1,460,580,12,12,50,28,26,47,66,14,10,12,0,0,67,0x3885,150,720,360,360,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1938,'TREASURE_BOX41','Treasure Chest','Treasure Chest',99,0,0,0,0,0,0,0,0,0,0,0,0,0,999,0,0,0,0,0,20,0x120,0,0,0,0,0,0,0,0,0,0,0,0,7830,80,658,500,12999,10000,984,4850,985,7275,2514,40,1625,150,1268,150,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1939,'TREASURE_BOX42','Treasure Chest','Treasure Chest',99,0,0,0,0,0,0,0,0,0,0,0,0,0,999,0,0,0,0,0,20,0x120,0,0,0,0,0,0,0,0,0,0,0,0,7831,80,658,500,12999,10000,984,4850,985,7275,2513,40,1375,150,1269,150,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1940,'TREASURE_BOX43','Treasure Chest','Treasure Chest',99,0,0,0,0,0,0,0,0,0,0,0,0,0,999,0,0,0,0,0,20,0x120,0,0,0,0,0,0,0,0,0,0,0,0,7832,80,658,500,12999,10000,984,4850,985,7275,13027,150,1376,150,1271,150,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1941,'TREASURE_BOX44','Treasure Chest','Treasure Chest',99,0,0,0,0,0,0,0,0,0,0,0,0,0,999,0,0,0,0,0,20,0x120,0,0,0,0,0,0,0,0,0,0,0,0,7833,80,658,500,12999,10000,984,4850,985,7275,13404,150,1730,150,2001,50,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1942,'TREASURE_BOX45','Treasure Chest','Treasure Chest',99,0,0,0,0,0,0,0,0,0,0,0,0,0,999,0,0,0,0,0,20,0x120,0,0,0,0,0,0,0,0,0,0,0,0,7834,80,658,500,12999,10000,984,4850,985,7275,1176,150,1734,150,1819,150,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1943,'TREASURE_BOX46','Treasure Chest','Treasure Chest',99,0,0,0,0,0,0,0,0,0,0,0,0,0,999,0,0,0,0,0,20,0x120,0,0,0,0,0,0,0,0,0,0,0,0,7835,80,658,500,12999,10000,984,4850,985,7275,1421,150,1731,150,1822,150,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1944,'TREASURE_BOX47','Treasure Chest','Treasure Chest',99,0,0,0,0,0,0,0,0,0,0,0,0,0,999,0,0,0,0,0,20,0x120,0,0,0,0,0,0,0,0,0,0,0,0,7836,80,658,500,12999,10000,984,4850,985,7275,1478,150,1732,150,2531,50,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1945,'TREASURE_BOX48','Treasure Chest','Treasure Chest',99,0,0,0,0,0,0,0,0,0,0,0,0,0,999,0,0,0,0,0,20,0x120,0,0,0,0,0,0,0,0,0,0,0,0,7837,80,658,500,12999,10000,984,4850,985,7275,1624,150,1733,150,1821,150,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1946,'TREASURE_BOX49','Treasure Chest','Treasure Chest',99,0,0,0,0,0,0,0,0,0,0,0,0,0,999,0,0,0,0,0,20,0x120,0,0,0,0,0,0,0,0,0,0,0,0,7838,80,658,500,12999,10000,984,4850,985,7275,1626,150,1270,150,2532,50,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1947,'PIAMETTE_','Piamette','Piamette',90,500000,0,0,0,2,5000,6000,35,35,1,66,5,99,120,15,10,12,0,7,20,0x37B5,100,432,768,576,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1948,'G_YGNIZEM','Ygnizem','Egnigem Cenia',58,11200,0,0,0,1,823,1212,35,8,60,35,52,18,79,20,10,12,1,7,43,0x3885,145,576,432,288,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1949,'B_S_GUARDIAN','Camp Guardian','Camp Guardian',86,457599,0,0,0,2,7590,9140,60,33,110,40,5,65,125,65,14,16,2,7,80,0x20A5,170,140,384,288,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1950,'B_B_GUARDIAN','Camp Guardian','Camp Guardian',80,241212,0,0,0,12,1840,2520,40,62,95,80,5,90,165,55,14,16,2,7,80,0x20A5,170,76,384,288,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
#  Ravies Sister's 'Valyrie's Gift' monsters.
REPLACE INTO `mob_db` VALUES (1951,'CRYSTAL_6','Crystal','Crystal',1,15,0,0,0,0,0,0,100,99,1,1,1,1,999,1,0,0,0,0,20,0x161,190,0,0,0,0,0,0,0,0,0,0,0,539,3800,530,4500,561,5000,665,4900,0,0,532,6500,558,5000,607,200,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1952,'CRYSTAL_7','Crystal','Crystal',1,15,0,0,0,0,0,0,100,99,1,1,1,1,999,1,0,0,0,0,20,0x161,190,0,0,0,0,0,0,0,0,0,0,0,539,3800,530,4500,561,5000,667,4900,0,0,531,6500,558,5000,608,250,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1953,'CRYSTAL_8','Crystal','Crystal',1,15,0,0,0,0,0,0,100,99,1,1,1,1,999,1,0,0,0,0,20,0x161,190,0,0,0,0,0,0,0,0,0,0,0,539,3800,530,4500,561,5000,664,4900,0,0,534,6500,558,5000,604,300,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1954,'CRYSTAL_9','Crystal','Crystal',1,15,0,0,0,0,0,0,100,99,1,1,1,1,999,1,0,0,0,0,20,0x161,190,0,0,0,0,0,0,0,0,0,0,0,539,3800,530,4500,561,5000,666,4900,0,0,533,6500,558,5000,603,100,0,0,0,0);
#  ?
REPLACE INTO `mob_db` VALUES (1955,'TREASURE_BOX_I','Treasure Chest','Treasure Chest',99,0,0,0,0,0,0,0,0,0,0,0,0,0,999,0,0,0,0,0,20,0x83,0,0,0,0,0,0,0,0,0,0,0,0,12281,3000,7849,4000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
#  Endless Tower
REPLACE INTO `mob_db` VALUES (1956,'NAGHT_SIEGER','Naght Sieger','Naght Sieger',99,8000000,0,4000000,2000000,2,32000,64000,60,40,1,50,80,220,220,30,10,12,2,6,88,0x37B5,100,76,432,504,0,0,0,0,0,0,0,0,13412,9000,13413,9000,2542,9000,5017,9000,616,9000,2514,9000,7294,9000,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1957,'ENTWEIHEN','Entweihen Crothen','Entweihen Crothen',90,5400000,0,2700000,1350000,12,32000,40000,44,66,1,70,40,250,220,30,14,16,1,6,87,0x1A4,0,140,540,576,0,0,0,0,0,0,0,0,1636,9000,1631,9000,2513,9000,1624,9000,616,9000,1618,9000,7291,9000,0,0,0,0,4451,1);
REPLACE INTO `mob_db` VALUES (1958,'G_ENTWEIHEN_R','Thorny Skeleton','Thorny Skeleton',89,5400000,0,0,0,12,4040,4720,44,66,1,35,33,180,125,30,14,16,0,6,87,0x1A4,0,432,288,576,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1959,'G_ENTWEIHEN_H','Thorn of Recovery','Thorn of Recovery',89,350000,0,0,0,12,2040,2720,44,66,1,35,33,180,125,30,14,16,0,6,88,0x1A4,0,2864,288,576,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1960,'G_ENTWEIHEN_M','Thorn of Magic','Thorn of Magic',89,5400000,0,0,0,12,2040,2720,44,66,1,35,33,180,125,30,14,16,0,6,87,0x1A4,0,1024,288,576,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1961,'G_ENTWEIHEN_S','Thorn of Purification','Thorn of Purification',89,5400000,0,0,0,12,2040,2720,44,66,1,35,33,180,125,30,14,16,0,6,87,0x1A4,0,2864,288,576,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
#  Additional Monsters
REPLACE INTO `mob_db` VALUES (1962,'ANTONIO_','Christmas Thief','Christmas Thief',10,15,0,0,0,1,13,20,100,99,1,1,1,50,100,100,10,12,1,7,20,0x83,100,720,720,432,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1963,'P_CHUNG_E','New Year Doll','New Year Doll',49,23900,0,2396,993,1,460,1050,8,15,38,65,43,30,90,15,10,12,1,7,40,0x3695,170,1728,816,1188,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1964,'NIGHTMARE_T','Nightmare','Nightmare',30,2000,0,512,387,1,100,200,0,40,1,100,1,1,100,1,10,12,2,2,68,0x120,150,1816,816,432,0,0,0,0,0,0,0,0,505,2000,510,3000,7913,5000,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1965,'M_WILD_ROSE','Wild Rose','Wild Rose',38,4000,50,0,0,1,100,145,0,15,0,85,15,35,65,80,10,12,0,2,24,0x120,100,964,864,288,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1966,'M_DOPPELGANGER','Doppelganger','Doppelganger',72,7800,200,0,0,1,200,250,30,20,0,38,30,35,65,65,10,12,1,6,67,0x120,100,300,480,288,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1967,'M_YGNIZEM','Ygnizem','Egnigem Cenia',79,7800,200,0,0,1,200,250,30,20,0,38,30,35,65,65,10,12,1,7,43,0x120,100,300,480,288,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1968,'E_STROUF','Strouf','Strouf',48,11990,0,6160,4196,1,200,1250,5,50,1,40,45,92,43,65,10,12,2,5,61,0x120,150,1872,672,384,0,0,0,0,0,0,0,0,951,5335,756,230,2241,4,1461,4,949,3000,720,40,956,1500,0,0,0,0,4111,1);
REPLACE INTO `mob_db` VALUES (1969,'E_MARC','Marc','Marc',36,6900,0,1976,1250,1,220,280,5,10,1,36,36,20,56,30,10,12,1,5,41,0x120,150,1272,72,480,0,0,0,0,0,0,0,0,995,36,956,9000,756,190,951,1000,720,20,717,200,509,700,0,0,0,0,4105,1);
REPLACE INTO `mob_db` VALUES (1970,'E_OBEAUNE','Obeune','Obeune',31,3952,0,1288,814,1,141,165,0,40,1,31,31,55,74,85,10,12,1,5,41,0x120,200,1872,672,288,0,0,0,0,0,0,0,0,995,26,950,9000,5014,2,2326,20,720,20,951,500,748,60,0,0,0,0,4093,1);
REPLACE INTO `mob_db` VALUES (1971,'E_VADON','Vadon','Vadon',19,1017,0,270,170,1,74,85,20,0,1,19,16,10,36,15,10,12,0,5,21,0x120,300,1632,432,540,0,0,0,0,0,0,0,0,991,40,960,9000,910,3000,2313,10,943,100,757,80,717,50,0,0,0,0,4049,1);
REPLACE INTO `mob_db` VALUES (1972,'E_MARINA','Marina','Marina',21,2087,0,436,280,1,84,106,0,5,1,21,21,0,36,10,10,12,0,3,41,0x120,400,2280,1080,864,0,0,0,0,0,0,0,0,1052,5000,938,1500,991,90,995,4,717,200,631,40,0,0,0,0,0,0,4055,1);
REPLACE INTO `mob_db` VALUES (1973,'E_PORING','Poring','Poring',1,50,0,2,1,1,7,10,0,5,1,1,1,0,6,30,10,12,1,3,21,0x120,400,1872,672,480,0,0,0,0,0,0,0,0,909,7000,938,400,512,1000,713,1500,12303,3000,0,0,0,0,0,0,0,0,0,0);
#  WoE SE Guild Dungeon
REPLACE INTO `mob_db` VALUES (1974,'BANSHEE_MASTER','Banshee Master','Banshee Master',84,47222,0,30000,24000,2,2666,3609,20,40,30,74,1,180,105,1,10,12,1,6,47,0x3795,150,676,504,504,0,0,0,0,0,0,0,0,7054,5335,7751,3000,2365,10,2748,2,2528,10,934,1500,2135,20,0,0,0,0,4450,1);
REPLACE INTO `mob_db` VALUES (1975,'BEHOLDER_MASTER','Beholder Master','Beholder master',70,24150,0,9000,11400,6,1723,2300,17,30,60,62,25,89,85,32,10,12,1,0,44,0x3885,190,336,840,360,0,0,0,0,0,0,0,0,576,3000,605,100,996,100,985,10,2386,10,603,2,2749,2,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1976,'COBALT_MINERAL','Cobalt Mineral','Cobalt Mineral',72,29665,0,12332,10379,1,1446,2979,40,30,60,77,35,57,77,32,10,12,1,0,40,0x3885,200,648,480,360,0,0,0,0,0,0,0,0,7321,3000,728,500,13414,5,984,80,1011,800,715,100,969,2,0,0,0,0,714,2);
REPLACE INTO `mob_db` VALUES (1977,'HEAVY_METALING','Heavy Metaling','Heavy Metaling',73,28433,0,9320,8831,1,1350,1700,40,30,30,65,28,40,77,2,10,12,0,0,20,0x3885,200,384,672,480,0,0,0,0,0,0,0,0,7325,4000,1002,1000,998,500,7126,1000,7317,200,13038,5,7312,5000,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1978,'HELL_APOCALIPS','Hell Apocalips','Hell Apocalypse',86,65433,0,46666,32000,2,5733,6073,62,23,1,48,30,98,110,85,10,12,2,0,60,0x3885,250,1840,1440,384,0,0,0,0,0,0,0,0,7095,5335,999,2500,7094,2400,7093,2200,2506,20,985,5,2391,1,0,0,0,0,1484,1);
REPLACE INTO `mob_db` VALUES (1979,'ZAKUDAM','Zukadam','Zakudam',82,43699,0,27213,16300,3,2000,3227,30,30,65,65,35,75,80,15,10,12,2,7,60,0x3885,180,580,288,360,0,0,0,0,0,0,0,0,7317,5000,999,500,984,200,985,200,13156,5,13167,5,2390,10,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1980,'KUBLIN','Kubkin','Kublin',85,1176000,0,100000,100000,1,1180,1400,20,10,1,106,25,40,72,20,10,12,1,7,22,0x37B5,100,964,648,300,100000,5000,6010,10000,0,0,0,0,998,270,911,9000,756,43,2297,3,0,0,0,0,507,1800,0,0,0,0,0,0);
#  Orc Dungeon Instance
REPLACE INTO `mob_db` VALUES (1981,'I_HIGH_ORC','Safeguard Chief','Safeguard Chief',88,111111,0,3618,1639,1,428,533,15,5,55,46,55,35,82,40,10,12,2,7,43,0x3695,150,1500,500,1000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1982,'I_ORC_ARCHER','Orc Sniper','Orc Sniper',85,62000,0,1729,1787,9,1310,1390,10,5,1,44,25,20,125,20,10,12,1,7,22,0x3095,300,1960,620,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1983,'I_ORC_SKELETON','Depraved Orc Spirit','Depraved Orc Spirit',87,80087,0,4501,67,1,896,1159,14,30,1,31,41,93,67,30,10,12,1,1,29,0x3885,130,2420,720,648,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1984,'I_ORC_LADY','Shaman Cargalache','Shaman Cargalache',58,50058,0,4870,98,1,823,1212,35,10,60,35,52,18,79,20,10,12,1,7,42,0x3695,145,1050,900,288,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
#  Another World (13.1)
REPLACE INTO `mob_db` VALUES (1985,'DANDELION','Dandelion Member','Dandelion Member',37,5176,0,0,0,1,305,360,0,10,28,19,32,0,63,20,10,12,1,7,47,0x3695,250,1772,72,384,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1986,'TATACHO','Tatacho','Tatacho',106,39500,0,23700,13825,2,10000,11000,20,17,106,40,30,25,115,6,10,12,1,2,22,0x108B,150,1000,768,360,0,0,0,0,0,0,0,0,1544,20,1925,10,6020,4000,6021,3000,579,3100,516,3000,0,0,0,0,0,0,4442,1);
REPLACE INTO `mob_db` VALUES (1987,'CENTIPEDE','Centipede','Centipede',110,45662,0,27397,15982,2,15000,16000,40,25,112,43,30,5,131,12,10,12,1,4,45,0x3795,150,1000,792,336,0,0,0,0,0,0,0,0,2746,2,2747,2,1741,10,1042,5335,912,5000,955,9000,943,2500,0,0,0,0,4447,1);
REPLACE INTO `mob_db` VALUES (1988,'NEPENTHES','Nepenthes','Nepenthes',75,10350,0,5175,2587,7,415,565,25,10,75,20,30,5,65,5,10,12,1,3,45,0x84,1000,500,576,504,0,0,0,0,0,0,0,0,5399,1,1979,1,1926,1,1740,1,6041,3000,993,50,905,9000,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1989,'HILLSRION','Hillslion','Hillslion',105,34600,0,20760,12110,1,5000,5500,28,15,105,60,30,15,115,5,10,12,0,2,22,0x308D,100,400,780,576,0,0,0,0,0,0,0,0,2440,10,1825,20,6032,3000,6020,2000,1268,10,7063,120,7054,4850,0,0,0,0,4453,1);
REPLACE INTO `mob_db` VALUES (1990,'HARDROCK_MOMMOTH','Hardrock Mammoth','Hardrock Mammoth',115,4137000,0,827400,413700,2,30000,36000,50,60,115,35,1,30,150,15,10,12,2,2,62,0x37B5,150,1000,660,588,0,0,0,0,0,0,0,0,5398,100,2133,200,1483,500,13039,400,6022,9000,2257,20,985,9000,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1991,'TENDRILRION','Tendrillion','Tendrilion',113,3657330,0,731466,365733,2,20000,24000,33,30,113,60,1,45,147,13,10,12,1,2,42,0x37B5,100,500,960,360,0,0,0,0,0,0,0,0,2544,500,1186,100,1637,100,6033,9000,6020,4000,7197,5335,7008,4850,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1992,'CORNUS','Cornus','Cornus',108,41220,0,30854,4427,2,12000,13000,35,80,110,45,80,200,105,10,10,12,1,2,66,0x1089,120,1000,624,300,0,0,0,0,0,0,0,0,2387,10,2743,1,6023,4000,7063,3000,944,6000,2257,2,1420,1,0,0,0,0,4448,1);
REPLACE INTO `mob_db` VALUES (1993,'NAGA','Naga','Naga',111,46708,0,30360,16348,3,8000,8800,38,15,113,42,30,108,122,13,10,12,2,2,42,0x3695,150,400,864,432,0,0,0,0,0,0,0,0,2389,10,2134,10,1485,10,926,5000,936,3500,954,2000,1408,20,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1994,'LUCIOLA_VESPA','Luciola Vespa','Luciola Vespa',104,32600,0,16300,11410,1,9000,9900,29,5,104,56,30,20,116,4,10,12,1,4,24,0x7795,110,1000,864,432,0,0,0,0,0,0,0,0,2744,2,955,9000,939,9000,518,300,992,160,526,200,943,3000,0,0,0,0,4445,1);
REPLACE INTO `mob_db` VALUES (1995,'PINGUICULA','Pinguicula','Pinguicula',80,13680,0,6840,3420,1,600,720,25,5,102,23,30,10,86,2,10,12,1,3,62,0x308D,150,700,600,360,0,0,0,0,0,0,0,0,2745,1,1980,10,2270,10,7100,5000,7198,2000,7188,3000,712,1000,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (1996,'BACSOJIN_T','Bacsojin','White Lady',85,253221,0,45250,16445,3,1868,6124,20,55,52,65,44,112,152,35,10,12,2,7,64,0x37B5,130,576,960,480,0,0,0,0,0,0,0,0,5411,500,2638,80,2639,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1997,'G_TATACHO','Tatacho','Tatacho',106,39500,0,0,0,2,10000,11000,20,17,106,40,30,25,115,6,10,12,1,2,22,0x108B,150,1000,768,360,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1998,'G_HILLSRION','Hillslion','Hillslion',105,34600,0,0,0,1,5000,5500,28,15,105,60,30,15,115,5,10,12,0,2,22,0x308D,100,400,780,576,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (1999,'CENTIPEDE_LARVA','Centipede Larva','Centipede Larva',80,12000,0,3600,4800,2,948,1115,20,20,80,33,15,3,75,10,10,12,0,4,25,0x3795,150,1000,792,336,0,0,0,0,0,0,0,0,2406,9,732,50,0,0,1042,5335,912,5000,955,9000,943,2500,0,0,0,0,4452,1);
# REPLACE INTO `mob_db` VALUES (2000,'M_GAMEMASTER','Male Game Master','Game Master',50,7000,250,0,0,1,25,25,10,10,44,121,1,60,75,110,10,12,1,7,20,0x120,200,300,384,288,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2001,'F_GAMEMASTER','Female Game Master','Game Master',50,7000,250,0,0,1,25,25,10,10,44,121,1,60,75,110,10,12,1,7,20,0x120,200,300,384,288,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2002,'T_SPRING_RABBIT','Spring Rabbit','Spring Rabbit',50,8000,0,3982,1766,1,585,813,29,21,45,61,5,15,77,90,10,12,1,2,42,0x120,160,1120,552,511,0,0,0,0,0,0,0,0,12190,1000,6061,500,6068,1500,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2003,'T_BACSOJIN','White Lady','White Lady',72,56380,0,0,0,2,560,1446,10,15,38,65,34,80,102,35,10,12,2,7,41,0x3695,160,576,960,480,0,0,0,0,0,0,0,0,7406,1000,7407,1000,6062,1000,6063,1000,6064,1000,6065,1000,6066,1000,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2004,'T_WICKED_NYMPH','Evil Nymph','Evil Nymph',63,16029,0,0,0,2,399,1090,12,75,1,64,12,69,100,80,10,12,1,6,67,0x3695,200,637,1008,360,0,0,0,0,0,0,0,0,7406,800,7407,800,6063,800,6064,800,6065,800,6066,800,6067,800,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2005,'T_PLASMA_B','Plasma','Plasma',44,8200,0,0,0,3,300,700,0,30,1,30,5,73,90,30,10,12,0,0,81,0x120,150,608,1440,576,0,0,0,0,0,0,0,0,7406,500,7407,500,6062,500,6063,500,6064,500,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2006,'T_PLASMA_P','Plasma','Plasma',49,5900,0,0,0,3,300,700,0,30,1,30,5,54,90,30,10,12,0,0,87,0x120,150,608,1440,576,0,0,0,0,0,0,0,0,6062,500,6063,500,6064,500,6065,500,6066,500,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2007,'T_PLASMA_R','Plasma','Plasma',43,5700,0,0,0,3,300,700,0,30,1,30,5,56,90,30,10,12,0,0,83,0x120,150,608,1440,576,0,0,0,0,0,0,0,0,7406,500,7407,500,6064,500,6065,500,6066,500,6067,500,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (2008,'WOOMAWANG','Woomawang','Woomawang',82,4000000,0,100000,100000,3,8000,10000,40,40,60,110,200,250,166,66,10,12,2,6,48,0x3695,250,828,528,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (2009,'WOOMAWANG_','Woomawang','Woomawang',82,2000000,0,100000,100000,1,16000,20000,40,40,60,110,200,250,166,66,10,12,1,6,48,0x3695,100,414,1080,336,0,0,0,0,0,0,0,0,7930,10000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (2010,'G_MAJORUROS','Ox','Ox',66,500000,0,10,10,1,1200,3200,25,15,65,50,20,20,85,48,10,12,2,6,28,0x120,250,1100,960,780,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2011,'E_GHOUL','Ghoul','Ghoul',40,99999,0,1088,622,1,2100,2500,100,20,1,20,29,0,180,20,10,12,1,1,49,0x120,100,2456,912,504,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2012,'E_ZOMBIE','Zombie','Zombie',15,99999,0,50,33,1,335,395,100,10,1,8,7,0,60,0,10,12,1,1,29,0x120,150,2612,912,288,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
#  Another World (13.2)
REPLACE INTO `mob_db` VALUES (2013,'DRACO','Draco','Draco',82,18300,0,6100,4100,1,410,710,10,5,1,23,30,34,62,2,10,12,1,9,22,0x1089,250,576,960,504,0,0,0,0,0,0,0,0,6073,3000,7123,100,1035,100,1037,1000,1036,1000,518,500,0,0,0,0,0,0,4444,1);
REPLACE INTO `mob_db` VALUES (2014,'DRACO_EGG','Draco Egg','Draco Egg',67,9822,0,1200,1600,0,1,2,56,40,1,1,56,34,1,63,10,12,1,9,82,0x0,1000,24,0,0,0,0,0,0,0,0,0,0,7032,5000,5015,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (2015,'PINGUICULA_D','Dark Pinguicula','Dark Pinguicula',83,8780,0,7740,5200,1,600,1450,15,5,1,23,22,12,89,2,10,12,1,3,45,0x308D,290,1426,600,360,0,0,0,0,0,0,0,0,7100,5000,7198,2000,7188,3000,972,10,6086,1000,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (2016,'AQUA_ELEMENTAL','Aqua Elemental','Aqua Elemental',83,33220,0,5430,15300,1,400,1600,8,12,1,23,19,87,77,2,10,12,2,0,81,0x3095,230,504,960,576,0,0,0,0,0,0,0,0,6075,1000,7326,5000,12353,100,0,0,0,0,0,0,0,0,0,0,0,0,4443,1);
REPLACE INTO `mob_db` VALUES (2017,'RATA','Rata','Rata',107,216600,0,70012,34000,1,8000,15000,32,52,1,51,22,132,99,15,10,12,1,7,62,0x3295,150,792,540,420,0,0,0,0,0,0,0,0,12346,5000,1026,5000,6089,500,1548,100,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (2018,'DUNEYRR','Duneyrr','Duneyrr',107,265100,0,83030,52000,1,16000,19000,39,35,1,60,45,89,105,15,10,12,1,7,62,0x3295,200,672,420,360,0,0,0,0,0,0,0,0,515,5000,6020,4000,6089,500,2783,1,1188,10,1384,100,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (2019,'ANCIENT_TREE','Ancient Tree','Ancient Tree',102,30030,0,11020,8900,1,13200,17400,39,43,1,30,73,58,45,30,10,12,2,3,62,0x308D,290,504,960,576,0,0,0,0,0,0,0,0,7197,1000,7198,1000,7201,5000,1643,10,2450,30,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (2020,'RHYNCHO','Rhyncho','Rhyncho',85,18900,0,2040,6000,1,350,2300,5,19,1,56,12,35,89,10,10,12,1,0,61,0x308D,240,576,660,420,0,0,0,0,0,0,0,0,7326,5000,972,5,6087,500,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (2021,'PHYLLA','Phylla','Phylla',85,23880,0,3040,6600,10,350,2550,8,22,1,59,15,25,99,10,10,12,1,0,61,0x2085,240,360,780,432,0,0,0,0,0,0,0,0,7326,5000,971,5,6088,500,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (2022,'S_NYDHOG','Nidhoggr\'s Shadow','Nidhoggr\'s Shadow',117,3450000,0,4800000,3900000,2,17000,49000,60,75,1,34,62,236,188,34,10,12,2,9,87,0x37B5,150,1596,1620,864,2400000,1000,0,0,0,0,0,0,6091,5000,7444,5000,2610,5000,1484,500,1170,500,1417,500,2554,2000,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (2023,'DARK_SHADOW','Dark Shadow','Dark Shadow',114,42900,0,21000,14000,1,10000,15000,35,44,1,23,12,145,102,60,10,12,0,0,47,0x3195,220,768,1776,648,0,0,0,0,0,0,0,0,7205,5000,2609,1000,13038,5,6089,1000,2783,5,1385,10,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (2024,'BRADIUM_GOLEM','Bradium Golem','Bradium Golem',101,45200,0,14000,18920,1,12000,13000,78,22,0,10,82,25,60,12,10,12,2,0,42,0x3295,300,1008,1200,540,0,0,0,0,0,0,0,0,7067,3000,953,5000,6090,500,2138,10,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2025,'MYSTCASE_EVENT','Mystcase','Mystcase',10,15,0,0,0,1,160,360,99,99,65,50,25,5,48,75,10,12,1,0,20,0x120,400,1248,1248,432,0,0,0,0,0,0,0,0,14550,5000,14546,5000,12355,50,6092,2000,7175,2000,7174,2000,529,3000,0,0,0,0,530,3000);
REPLACE INTO `mob_db` VALUES (2026,'DANDELION_','Runaway Dandelion Member','Runaway Dandelion Member',90,552000,0,50000,25000,1,3050,4300,25,35,1,66,66,45,88,66,10,12,1,7,27,0x3695,230,1772,72,384,0,0,0,0,0,0,0,0,7031,5000,579,500,7016,2000,581,3000,12125,500,511,5000,7032,3000,0,0,0,0,902,2000);
REPLACE INTO `mob_db` VALUES (2027,'G_DARK_SHADOW','Dark Shadow','Dark Shadow',114,42900,0,0,0,1,10000,15000,35,44,1,23,12,145,102,60,10,12,0,0,47,0x3795,220,768,1776,648,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2028,'E_MINOROUS','Minorous','Minorous',1,741,0,0,0,1,30,48,2,5,6,4,6,6,5,3,10,12,2,2,43,0x120,200,1360,960,432,0,0,0,0,0,0,0,0,7606,5000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2029,'E_MINOROUS_','Minorous','Minorous',10,15,0,10,0,1,100,150,100,99,1,1,1,1,100,100,10,12,2,2,43,0x120,200,1360,960,432,0,0,0,0,0,0,0,0,941,10,11708,2000,11708,4000,11708,1000,516,1000,2289,1,577,1000,0,0,0,0,644,1);
# REPLACE INTO `mob_db` VALUES (2030,'HIDEN_PRIEST','Hiden Priest','Hiden Priest',90,240000,0,0,0,2,1300,1983,0,30,1,32,40,100,82,40,10,12,2,6,89,0x120,150,432,432,360,0,0,0,0,0,0,0,0,12379,5000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2031,'DANDELION_H','Dandelion','Dandelion',80,120000,0,0,0,1,305,610,0,10,1,19,32,0,63,20,10,12,1,7,47,0x120,250,1772,72,384,0,0,0,0,0,0,0,0,12379,5000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2032,'GUARDIAN_FOREST','Forest Guardian','Forest Guardian',50,8578,0,0,0,1,1000,1103,15,25,1,75,55,1,93,45,10,12,0,6,27,0x120,100,868,480,120,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2033,'GOLDEN_TULIP','Golden Tulip','Golden Tulip',1,299,0,0,0,1,1,2,100,99,0,0,0,0,0,0,7,12,0,3,22,0x120,2000,1,1,1,0,0,0,0,0,0,0,0,7951,10000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2034,'M_DESERT_WOLF_B','Baby Desert Wolf','Baby Desert Wolf',9,164,15,0,0,1,500,600,0,0,1,9,9,5,40,40,10,12,0,2,23,0x120,100,1600,900,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2035,'NIHILITY_ZEM','Nihility Zem','Nihility Zem',90,200000,0,0,0,0,1,2,0,20,1,1,1,0,1,20,10,12,0,4,22,0x120,1000,1001,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2036,'VALKYRIE_N','Valkyrie Randgris','Valkyrie Randgris',53,11280,0,0,0,1,780,930,10,20,1,24,39,0,72,25,10,12,1,1,69,0x120,170,576,576,480,0,0,0,0,0,0,0,0,6154,10000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2037,'VALKYRIE_A','Valkyrie Randgris','Valkyrie Randgris',90,5000,15,0,0,1,10,160,10,20,1,20,40,0,20,20,10,12,1,8,66,0x120,100,576,576,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2038,'VALKYRIE_B','Valkyrie Randgris','Valkyrie Randgris',90,10000,15,0,0,1,300,450,10,40,1,20,80,0,80,20,10,12,1,8,66,0x120,100,576,576,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2039,'EXECUTIONER_R','Executioner','Executioner',65,28980,0,0,0,2,570,950,35,35,64,85,40,25,88,60,10,12,2,0,47,0x120,200,768,500,384,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2040,'TIRFING_R','Tirfing','Ogretooth',71,29900,0,0,0,1,950,1146,30,35,58,87,55,35,132,65,10,12,1,0,67,0x120,100,816,500,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2041,'MYSTELTAINN_R','Mysteltainn','Mysteltainn',76,33350,0,0,0,2,1160,1440,30,30,77,139,80,35,159,65,10,12,2,0,87,0x120,250,1152,500,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2042,'SILVERSNIPER','Silver Sniper','Silver Sniper',1,50,0,0,0,1,7,10,0,5,1,1,1,1,6,30,10,12,1,3,21,0x120,400,1872,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2043,'MAGICDECOY_FIRE','Magic Decoy','Magic Decoy',1,50,0,0,0,1,7,10,0,5,1,1,1,1,6,30,10,12,1,3,21,0x120,400,1872,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2044,'MAGICDECOY_WATER','Magic Decoy','Magic Decoy',1,50,0,0,0,1,7,10,0,5,1,1,1,1,6,30,10,12,1,3,21,0x120,400,1872,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2045,'MAGICDECOY_EARTH','Magic Decoy','Magic Decoy',1,50,0,0,0,1,7,10,0,5,1,1,1,1,6,30,10,12,1,3,21,0x120,400,1872,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2046,'MAGICDECOY_WIND','Magic Decoy','Magic Decoy',1,50,0,0,0,1,7,10,0,5,1,1,1,1,6,30,10,12,1,3,21,0x120,400,1872,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2047,'W_NAGA','Naga','Naga',1,50,0,0,0,1,7,10,0,5,1,1,1,1,6,30,10,12,1,3,21,0x120,400,1872,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2048,'W_PINGUICULA_D','Dark Pinguicula','Dark Pinguicula',1,50,0,0,0,1,7,10,0,5,1,1,1,1,6,30,10,12,1,3,21,0x120,400,1872,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2049,'W_BRADIUM_GOLEM','Bradium Golem','Bradium Golem',1,50,0,0,0,1,7,10,0,5,1,1,1,1,6,30,10,12,1,3,21,0x120,400,1872,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2050,'W_AQUA_ELEMENTAL','Aqua Elemental','Aqua Elemental',1,50,0,0,0,1,7,10,0,5,1,1,1,1,6,30,10,12,1,3,21,0x120,400,1872,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2051,'E_BAPHOMET','Baphomet','Baphomet',1,1,0,0,0,1,1,2,1,0,1,1,1,1,1,1,10,12,2,6,20,0x120,100,768,768,576,0,0,0,0,0,0,0,0,12396,5000,12397,5000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2052,'E_DARK_LORD','Dark Lord','Dark Lord',1,50,0,0,0,1,7,10,0,5,1,1,1,1,6,30,10,12,1,3,21,0x120,400,1872,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2053,'NC_DIMIK','Dimik','Dimik',1,50,0,0,0,1,7,10,0,5,1,1,1,1,6,30,10,12,1,3,21,0x120,400,1872,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2054,'E_BATHORY','Bathory','Bathory',1,50,0,0,0,1,7,10,0,5,1,1,1,1,6,30,10,12,1,3,21,0x120,400,1872,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2055,'E_INCUBUS','Incubus','Incubus',1,50,0,0,0,1,7,10,0,5,1,1,1,1,6,30,10,12,1,3,21,0x120,400,1872,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2056,'E_ZHERLTHSH','Zherlthsh','Zealotus',1,50,0,0,0,1,7,10,0,5,1,1,1,1,6,30,10,12,1,3,21,0x120,400,1872,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (2057,'E_CRAMP','Cramp','Cramp',1,50,0,0,0,1,7,10,0,5,1,1,1,1,6,30,10,12,1,3,21,0x120,400,1872,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2058,'M_MIMIC','Mimic','Mimic',1,50,0,0,0,1,7,10,0,5,1,1,1,1,6,30,10,12,1,3,21,0x120,400,1872,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2059,'M_DISGUISE','Disguise','Disguise',1,50,0,0,0,1,7,10,0,5,1,1,1,1,6,30,10,12,1,3,21,0x120,400,1872,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2060,'M_ALICE','Alice','Alice',1,50,0,0,0,1,7,10,0,5,1,1,1,1,6,30,10,12,1,3,21,0x120,400,1872,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2061,'E_STAPO','Stapo','Stapo',1,50,0,0,0,1,7,10,0,5,1,1,1,1,6,30,10,12,1,3,21,0x120,400,1872,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2062,'E_POPORING','Poporing','poporing',1,50,0,0,0,1,7,10,0,5,1,1,1,1,6,30,10,12,1,3,21,0x120,400,1872,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2063,'E_DROPS','Drops','Drops',1,50,0,0,0,1,7,10,0,5,1,1,1,1,6,30,10,12,1,3,21,0x120,400,1872,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2064,'E_MAGMARING','Magmaring','Magmaring',1,50,0,0,0,1,7,10,0,5,1,1,1,1,6,30,10,12,1,3,21,0x120,400,1872,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2065,'E_METALING','Metaling','Metaling',1,50,0,0,0,1,7,10,0,5,1,1,1,1,6,30,10,12,1,3,21,0x120,400,1872,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2066,'E_ANOPHELES','Anopheles','Anopheles',1,50,0,0,0,1,7,10,0,5,1,1,1,1,6,30,10,12,1,3,21,0x120,400,1872,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2067,'E_ANOPHELES_','Anopheles','Anopheles',1,50,0,0,0,1,7,10,0,5,1,1,1,1,6,30,10,12,1,3,21,0x120,400,1872,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (2068,'BOITATA','Boitata','Boitata',93,1283990,0,74288,77950,2,1060,2022,7,36,140,99,30,109,100,90,10,12,2,0,63,0x37B5,200,1150,1150,288,37144,10000,0,0,0,0,0,0,7444,5000,985,1000,984,1000,607,500,1377,100,1422,100,1471,100,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (2069,'IARA','Iara','Iara',79,5890,0,1070,890,1,171,270,0,39,69,14,41,60,69,20,10,12,1,5,61,0x91,200,672,380,288,0,0,0,0,0,0,0,0,950,9000,951,500,747,100,748,50,710,10,995,5,2334,1,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (2070,'PIRANHA','Piranha','Piranha',75,4522,0,899,1023,1,182,223,2,10,69,45,30,30,66,35,10,12,1,5,61,0x3295,200,768,768,384,0,0,0,0,0,0,0,0,963,9000,956,600,1053,500,1054,500,995,5,1249,5,13027,1,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (2071,'HEADLESS_MULE','Headless Mule','Headless Mule',80,6620,0,1011,1120,1,210,267,7,27,68,51,50,35,67,20,10,12,2,6,63,0x3985,165,1216,816,432,0,0,0,0,0,0,0,0,7120,4000,7097,1000,7122,1000,2317,5,1255,2,1269,1,2317,1,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (2072,'JAGUAR','Jaguar','Jaguar',71,3914,0,720,512,1,192,234,9,12,69,30,45,5,59,5,10,12,1,2,42,0x3885,150,1250,580,360,0,0,0,0,0,0,0,0,7171,3000,7172,2000,919,1000,756,40,1810,1,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (2073,'TOUCAN','Toucan','Toucan',70,3640,0,659,544,1,166,201,3,10,54,14,40,35,44,10,10,12,0,2,44,0x3885,155,1450,960,480,0,0,0,0,0,0,0,0,917,3000,7053,1000,2612,200,508,100,510,50,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (2074,'CURUPIRA','Curupira','Curupira',68,3096,0,622,450,1,140,175,9,10,32,23,38,20,45,10,10,12,1,6,22,0x118B,250,530,530,384,0,0,0,0,0,0,0,0,517,3000,7267,500,757,250,1505,100,1011,10,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2075,'E_VADON_X','Vadon','Vadon',1,50,0,0,0,1,7,10,0,5,1,1,1,1,6,30,10,12,1,3,21,0x120,400,1872,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2076,'S_WIND_GHOST','Wind Ghost','Wind Ghost',1,50,0,0,0,1,7,10,0,5,1,1,1,1,6,30,10,12,1,3,21,0x120,400,1872,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2077,'S_SKOGUL','Skogul','Skogul',1,50,0,0,0,1,7,10,0,5,1,1,1,1,6,30,10,12,1,3,21,0x120,400,1872,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2078,'S_SUCCUBUS','Succubus','Succubus',1,50,0,0,0,1,7,10,0,5,1,1,1,1,6,30,10,12,1,3,21,0x120,400,1872,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2079,'CRYSTAL_H','Crystal','Crystal',1,50,0,0,0,1,7,10,0,5,1,1,1,1,6,30,10,12,1,3,21,0x120,400,1872,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2080,'CRYSTAL_L','Crystal','Crystal',1,50,0,0,0,1,7,10,0,5,1,1,1,1,6,30,10,12,1,3,21,0x120,400,1872,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (2081,'E_HYDRA','Suspicious Hydra','Strange Hydra',34,854,1,0,0,7,1,2,100,100,1,1,1,1,1,1,10,12,0,3,41,0x0,1000,800,432,600,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
REPLACE INTO `mob_db` VALUES (2082,'G_PIRANHA','Piranha','Piranha',75,4522,0,0,0,1,182,223,2,10,69,45,30,30,66,35,10,12,1,5,61,0x3295,200,768,768,384,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2083,'HORN_SCARABA','Scaraba','Scaraba',1,50,0,0,0,1,7,10,0,5,1,1,1,1,6,30,10,12,1,3,21,0x120,400,1872,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2084,'HORN_SCARABA2','Scaraba','Scaraba',1,50,0,0,0,1,7,10,0,5,1,1,1,1,6,30,10,12,1,3,21,0x120,400,1872,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2085,'ANTLER_SCARABA','Antler Scaraba','Antler Scaraba',1,50,0,0,0,1,7,10,0,5,1,1,1,1,6,30,10,12,1,3,21,0x120,400,1872,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2086,'RAKE_SCARABA','Rake Scaraba','Rake Scaraba',1,50,0,0,0,1,7,10,0,5,1,1,1,1,6,30,10,12,1,3,21,0x120,400,1872,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2087,'QUEEN_SCARABA','Queen Scaraba','Queen Scaraba',1,50,0,0,0,1,7,10,0,5,1,1,1,1,6,30,10,12,1,3,21,0x120,400,1872,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2088,'HORN_SCARABA_EGG','Scaraba Egg','Scaraba Egg',1,50,0,0,0,1,7,10,0,5,1,1,1,1,6,30,10,12,1,3,21,0x120,400,1872,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2089,'HORN_SCARABA2_EGG','Scaraba Egg','Scaraba Egg',1,50,0,0,0,1,7,10,0,5,1,1,1,1,6,30,10,12,1,3,21,0x120,400,1872,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2090,'ANTLER_SCARABA_EGG','Antler Scaraba Egg','Antler Scaraba Egg',1,50,0,0,0,1,7,10,0,5,1,1,1,1,6,30,10,12,1,3,21,0x120,400,1872,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2091,'RAKE_SCARABA_EGG','Rake Scaraba Egg','Rake Scaraba Egg',1,50,0,0,0,1,7,10,0,5,1,1,1,1,6,30,10,12,1,3,21,0x120,400,1872,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2092,'DOLOMEDES','Dolomedes','Dolomedes',1,50,0,0,0,1,7,10,0,5,1,1,1,1,6,30,10,12,1,3,21,0x120,400,1872,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2093,'BOTARING','Botaring','Botaring',1,50,0,0,0,1,7,10,0,5,1,1,1,1,6,30,10,12,1,3,21,0x120,400,1872,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# 2094,E_ORK_HERO2,Orc Hero,1,50,0,0,0,1,7,10,0,5,1,1,1,1,6,30,10,12,1,3,21,0x120,400,1872,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
# REPLACE INTO `mob_db` VALUES (2095,'E_EDDGA','Eddga','Eddga',1,50,0,0,0,1,7,10,0,5,1,1,1,1,6,30,10,12,1,3,21,0x120,400,1872,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2096,'E_OSIRIS2','Osiris','Osiris',1,50,0,0,0,1,7,10,0,5,1,1,1,1,6,30,10,12,1,3,21,0x120,400,1872,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2097,'E_DRACULA','Dracula','Dracula',1,50,0,0,0,1,7,10,0,5,1,1,1,1,6,30,10,12,1,3,21,0x120,400,1872,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2098,'E_DOPPELGANGER','Doppelganger','Doppelganger',1,50,0,0,0,1,7,10,0,5,1,1,1,1,6,30,10,12,1,3,21,0x120,400,1872,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2099,'E_MISTRESS','Mistress','Mistress',1,50,0,0,0,1,7,10,0,5,1,1,1,1,6,30,10,12,1,3,21,0x120,400,1872,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2100,'E_BAPHOMET2','Baphomet','Baphomet',1,50,0,0,0,1,7,10,0,5,1,1,1,1,6,30,10,12,1,3,21,0x120,400,1872,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2101,'E_LORD_OF_DEATH2','Lord of Death','Lord of the Dead',1,50,0,0,0,1,7,10,0,5,1,1,1,1,6,30,10,12,1,3,21,0x120,400,1872,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2102,'E_DARKLORD','Dark Lord','Dark Lord',1,1,0,0,0,1,1,2,1,0,1,1,1,1,1,1,10,12,2,6,20,0x120,100,868,768,480,0,0,0,0,0,0,0,0,12396,5000,12397,5000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# 2103,E_KTULLANUX,Ktullanux,1,50,0,0,0,1,7,10,0,5,1,1,1,1,6,30,10,12,1,3,21,0x120,400,1872,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
# REPLACE INTO `mob_db` VALUES (2104,'E_DARK_SNAKE_LORD','Dark Snake Lord','Evil Snake Lord',1,50,0,0,0,1,7,10,0,5,1,1,1,1,6,30,10,12,1,3,21,0x120,400,1872,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2105,'E_TURTLE_GENERAL','Turtle General','Turtle General',1,50,0,0,0,1,7,10,0,5,1,1,1,1,6,30,10,12,1,3,21,0x120,400,1872,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2106,'E_APOCALIPS_H','Vesper','Vesper',1,50,0,0,0,1,7,10,0,5,1,1,1,1,6,30,10,12,1,3,21,0x120,400,1872,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2107,'E_FALLINGBISHOP','Fallen Bishop','Fallen Bishop Hibram',1,50,0,0,0,1,7,10,0,5,1,1,1,1,6,30,10,12,1,3,21,0x120,400,1872,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2108,'E_GLOOMUNDERNIGHT','Gloom Under Night','Gloom Under Night',1,50,0,0,0,1,7,10,0,5,1,1,1,1,6,30,10,12,1,3,21,0x120,400,1872,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# 2109,E_RANDGRIS,Valkyrie Randgris,Valkyrie Randgris1,50,0,0,0,1,7,10,0,5,1,1,1,1,6,30,10,12,1,3,21,0x120,400,1872,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
# REPLACE INTO `mob_db` VALUES (2110,'E_IFRIT','Ifrit','Ifrit',1,50,0,0,0,1,7,10,0,5,1,1,1,1,6,30,10,12,1,3,21,0x120,400,1872,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2111,'E_B_HARWORD','Whitesmith Harword','Whitesmith Howard',1,50,0,0,0,1,7,10,0,5,1,1,1,1,6,30,10,12,1,3,21,0x120,400,1872,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2112,'E_B_SEYREN','Lord Knight Seyren','Lord Knight Seyren',1,50,0,0,0,1,7,10,0,5,1,1,1,1,6,30,10,12,1,3,21,0x120,400,1872,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2113,'E_B_EREMES','Assassin Cross Eremes','Assassin Cross Eremes',1,50,0,0,0,1,7,10,0,5,1,1,1,1,6,30,10,12,1,3,21,0x120,400,1872,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2114,'EL_AGNI_S','Agni','Agni',1,50,0,0,0,1,7,10,0,5,1,1,1,1,6,30,10,12,1,3,21,0x120,400,1872,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2115,'EL_AGNI_M','Agni','Agni',1,50,0,0,0,1,7,10,0,5,1,1,1,1,6,30,10,12,1,3,21,0x120,400,1872,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2116,'EL_AGNI_L','Agni','Agni',1,50,0,0,0,1,7,10,0,5,1,1,1,1,6,30,10,12,1,3,21,0x120,400,1872,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2117,'EL_AQUA_S','Aqua','Aqua',1,50,0,0,0,1,7,10,0,5,1,1,1,1,6,30,10,12,1,3,21,0x120,400,1872,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2118,'EL_AQUA_M','Aqua','Aqua',1,50,0,0,0,1,7,10,0,5,1,1,1,1,6,30,10,12,1,3,21,0x120,400,1872,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2119,'EL_AQUA_L','Aqua','Aqua',1,50,0,0,0,1,7,10,0,5,1,1,1,1,6,30,10,12,1,3,21,0x120,400,1872,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2120,'EL_VENTUS_S','Ventus','Ventus',1,50,0,0,0,1,7,10,0,5,1,1,1,1,6,30,10,12,1,3,21,0x120,400,1872,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2121,'EL_VENTUS_M','Ventus','Ventus',1,50,0,0,0,1,7,10,0,5,1,1,1,1,6,30,10,12,1,3,21,0x120,400,1872,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2122,'EL_VENTUS_L','Ventus','Ventus',1,50,0,0,0,1,7,10,0,5,1,1,1,1,6,30,10,12,1,3,21,0x120,400,1872,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2123,'EL_TERA_S','Tera','Tera',1,50,0,0,0,1,7,10,0,5,1,1,1,1,6,30,10,12,1,3,21,0x120,400,1872,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2124,'EL_TERA_M','Tera','Tera',1,50,0,0,0,1,7,10,0,5,1,1,1,1,6,30,10,12,1,3,21,0x120,400,1872,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
# REPLACE INTO `mob_db` VALUES (2125,'EL_TERA_L','Tera','Tera',1,50,0,0,0,1,7,10,0,5,1,1,1,1,6,30,10,12,1,3,21,0x120,400,1872,672,480,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
