#
# Table structure for table `item_db`
#

DROP TABLE IF EXISTS `item_db`;
CREATE TABLE `item_db` (
  `id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `name_english` varchar(50) NOT NULL DEFAULT '',
  `name_japanese` varchar(50) NOT NULL DEFAULT '',
  `type` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `price_buy` mediumint(8) unsigned DEFAULT NULL,
  `price_sell` mediumint(8) unsigned DEFAULT NULL,
  `weight` smallint(5) unsigned NOT NULL DEFAULT '0',
  `attack` smallint(5) unsigned DEFAULT NULL,
  `defence` smallint(5) unsigned DEFAULT NULL,
  `range` tinyint(2) unsigned DEFAULT NULL,
  `slots` tinyint(2) unsigned DEFAULT NULL,
  `equip_jobs` bigint(20) unsigned DEFAULT NULL,
  `equip_upper` tinyint(2) unsigned DEFAULT NULL,
  `equip_genders` tinyint(1) unsigned DEFAULT NULL,
  `equip_locations` mediumint(7) unsigned DEFAULT NULL,
  `weapon_level` tinyint(1) unsigned DEFAULT NULL,
  `equip_level` tinyint(3) unsigned DEFAULT NULL,
  `refineable` tinyint(1) unsigned DEFAULT NULL,
  `view` smallint(5) unsigned DEFAULT NULL,
  `script` text,
  `equip_script` text,
  `unequip_script` text,
  PRIMARY KEY (`id`),
  UNIQUE INDEX `UniqueAegisName` (`name_english`)
) ENGINE=MyISAM;

# Items Database
#
# Structure of Database:
#REPLACE INTO `item_db` VALUES ( ID,'AegisName','Name',Type,Buy,Sell,Weight,ATK,DEF,Range,Slots,Job,Class,Gender,Loc,wLV,eLV[:maxLevel],Refineable,View,'Script','OnEquip_Script','OnUnequip_Script');
#
# Healing Items
#=============================================================
REPLACE INTO `item_db` VALUES (501,'Red_Potion','Red Potion',0,50,NULL,70,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(45,65),0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (502,'Orange_Potion','Orange Potion',0,200,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(105,145),0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (503,'Yellow_Potion','Yellow Potion',0,550,NULL,130,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(175,235),0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (504,'White_Potion','White Potion',0,1200,NULL,150,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(325,405),0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (505,'Blue_Potion','Blue Potion',0,5000,NULL,150,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal 0,rand(40,60);',NULL,NULL);
REPLACE INTO `item_db` VALUES (506,'Green_Potion','Green Potion',0,40,NULL,70,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_end SC_Poison; sc_end SC_Silence; sc_end SC_Blind; sc_end SC_Confusion;',NULL,NULL);
REPLACE INTO `item_db` VALUES (507,'Red_Herb','Red Herb',0,18,NULL,30,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(18,28),0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (508,'Yellow_Herb','Yellow Herb',0,40,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(38,58),0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (509,'White_Herb','White Herb',0,120,NULL,70,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(75,115),0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (510,'Blue_Herb','Blue Herb',0,60,NULL,70,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal 0,rand(15,30);',NULL,NULL);
REPLACE INTO `item_db` VALUES (511,'Green_Herb','Green Herb',0,10,NULL,30,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_end SC_Poison;',NULL,NULL);
REPLACE INTO `item_db` VALUES (512,'Apple','Apple',0,15,NULL,20,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(16,22),0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (513,'Banana','Banana',0,15,NULL,20,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(17,21),0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (514,'Grape','Grape',0,200,NULL,20,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal 0,rand(10,15);',NULL,NULL);
REPLACE INTO `item_db` VALUES (515,'Carrot','Carrot',0,15,NULL,20,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(18,20),0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (516,'Sweet_Potato','Potato',0,15,NULL,20,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(15,23),0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (517,'Meat','Meat',0,50,NULL,150,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(70,100),0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (518,'Honey','Honey',0,500,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(70,100),rand(20,40);',NULL,NULL);
REPLACE INTO `item_db` VALUES (519,'Milk','Milk',0,25,NULL,30,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(27,37),0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (520,'Leaflet_Of_Hinal','Hinalle Leaflet',0,150,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(175,235),0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (521,'Leaflet_Of_Aloe','Aloe Leaflet',0,360,NULL,20,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(325,405),0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (522,'Fruit_Of_Mastela','Mastela Fruit',0,8500,NULL,30,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(400,600),0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (523,'Holy_Water','Holy Water',0,20,NULL,30,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_end SC_Curse;',NULL,NULL);
REPLACE INTO `item_db` VALUES (525,'Panacea','Panacea',0,500,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_end SC_Poison; sc_end SC_Silence; sc_end SC_Blind; sc_end SC_Confusion; sc_end SC_Curse; sc_end SC_Hallucination;',NULL,NULL);
REPLACE INTO `item_db` VALUES (526,'Royal_Jelly','Royal Jelly',0,7000,NULL,150,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(325,405),rand(40,60); sc_end SC_Poison; sc_end SC_Silence; sc_end SC_Blind; sc_end SC_Confusion; sc_end SC_Curse; sc_end SC_Hallucination;',NULL,NULL);
REPLACE INTO `item_db` VALUES (528,'Monster\'s_Feed','Monster\'s Feed',0,60,NULL,150,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(72,108),0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (529,'Candy','Candy',0,10,NULL,30,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(45,65),0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (530,'Candy_Striper','Candy Cane',0,20,NULL,40,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(105,145),0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (531,'Apple_Juice','Apple Juice',0,20,NULL,40,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(25,35),0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (532,'Banana_Juice','Banana Juice',0,20,NULL,40,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(26,34),0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (533,'Grape_Juice','Grape Juice',0,250,NULL,40,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal 0,rand(15,25);',NULL,NULL);
REPLACE INTO `item_db` VALUES (534,'Carrot_Juice','Carrot Juice',0,20,NULL,40,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(27,33),0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (535,'Pumpkin','Pumpkin',0,15,NULL,20,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal 19,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (536,'Ice_Cream','Ice Cream',0,150,NULL,80,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(105,145),0; sc_start SC_Freeze,10000,0,2500,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (537,'Pet_Food','Pet Food',0,1000,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(50,90),0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (538,'Well_Baked_Cookie','Well-baked Cookie',0,1000,NULL,30,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(160,200),0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (539,'Piece_Of_Cake','Piece of Cake',0,3000,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(270,330),0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (540,'Falcon\'s_Feed','Falcon Food',0,2000,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(185,225),0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (541,'Pecopeco\'s_Feed','PecoPeco Food',0,3000,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(325,405),0;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (542,'Festive_Cookie','Festival Cookie',0,10,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(325,405),0;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (543,'Festive_Rainbow_Cake','Festival Rainbow Cake',0,10,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(325,405),0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (544,'Fish_Slice','Raw Fish',0,20,NULL,30,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(25,60),0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (545,'Red_Slim_Potion','Condensed Red Potion',0,150,NULL,20,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(45,65),0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (546,'Yellow_Slim_Potion','Condensed Yellow Potion',0,600,NULL,30,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(175,235),0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (547,'White_Slim_Potion','Condensed White Potion',0,1650,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(325,405),0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (548,'Cheese','Cheese',0,2800,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal 0,rand(10,15);',NULL,NULL);
REPLACE INTO `item_db` VALUES (549,'Nice_Sweet_Potato','Yam',0,180,NULL,80,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(50,100),0; sc_start SC_Stun,3000,0,1500,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (550,'Popped_Rice','Rice Cake',0,10,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(10,15),0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (551,'Shusi','Sushi',0,1,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(50,60),0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (552,'KETUPAT','Ketupat',0,1,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(70,90),rand(20,30);',NULL,NULL);
REPLACE INTO `item_db` VALUES (553,'Bun','Bao',0,1,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(35,70),0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (554,'Mojji','Mochi',0,400,NULL,80,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(105,145),0; sc_start SC_Stun,3000,0; sc_start SC_Blind,2000,0,1500,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (555,'Rice_Cake','Traditional Rice Cake',0,100,NULL,20,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(105,145),0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (556,'Long_Rice_Cake','Rice Cake Stick',0,10,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(20,25),0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (557,'Hash_Rice_Cake','Neatly Sliced Rice Cake',0,10,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(25,30),0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (558,'Chocolate','Chocolate',0,1,NULL,20,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal 1,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (559,'HandMade_Chocolate','Hand-made Chocolate',0,1,NULL,80,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal 50,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (560,'HandMade_Chocolate_','Handmade White Chocolate',0,5000,NULL,80,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal 50,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (561,'White_Chocolate','White Chocolate',0,5000,NULL,80,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal 50,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (562,'Pizza','Doublecrust Swiss Fondue',0,100,NULL,150,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(70,100),0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (563,'Pizza_01','Doublecrust Swiss Fondue',0,1200,NULL,150,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(375,445),0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (564,'Rice_Ball','Rice Ball',0,1,NULL,30,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal 200,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (565,'Vita500_Bottle','Vita500',0,580,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(142,274),0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (566,'Tomyumkung','Tom Yum Goong',0,10000,NULL,150,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(244,350),rand(10,30); sc_end SC_Poison; sc_end SC_Silence; sc_end SC_Blind; sc_end SC_Confusion; sc_end SC_Curse; sc_end SC_Hallucination;',NULL,NULL);
REPLACE INTO `item_db` VALUES (567,'Prawn','Shrimp',0,500,NULL,40,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(117,192),0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (568,'Lemon','Lemon',0,60,NULL,40,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal 0,rand(10,20);',NULL,NULL);
REPLACE INTO `item_db` VALUES (569,'Novice_Potion','Novice Potion',0,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(22,33),0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (570,'Lucky_Candy','Lucky Candy',0,10,NULL,30,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(45,65),0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (571,'Lucky_Candy_Cane','Lucky Candy Cane',0,20,NULL,40,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(105,145),0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (572,'Lucky_Cookie','Lucky Cookie',0,1000,NULL,30,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(160,200),0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (573,'Chocolate_Drink','Chocolate Drink',0,7000,NULL,150,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(330,410),rand(45,65); sc_end SC_Poison; sc_end SC_Silence; sc_end SC_Blind; sc_end SC_Confusion; sc_end SC_Curse; sc_end SC_Hallucination;',NULL,NULL);
REPLACE INTO `item_db` VALUES (574,'Egg','Egg',0,20,NULL,30,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(33,42),0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (575,'Piece_Of_Cake_','2nd Anniversary Cake',0,10,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(270,330),0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (576,'Prickly_Fruit','Prickly Fruit',0,540,NULL,60,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(150,300),rand(20,30);',NULL,NULL);
REPLACE INTO `item_db` VALUES (577,'Grain','Bag of Grain',0,200,NULL,20,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(60,70),0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (578,'Strawberry','Strawberry',0,200,NULL,20,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal 0,rand(16,28);',NULL,NULL);
REPLACE INTO `item_db` VALUES (579,'Delicious_Fish','Fresh Fish',0,250,NULL,20,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(100,150),0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (580,'Bread','Bread',0,150,NULL,20,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(50,90),0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (581,'Mushroom','Edible Mushroom',0,40,NULL,20,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(20,30),0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (582,'Orange','Orange',0,300,NULL,20,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(10,20),rand(10,20);',NULL,NULL);
REPLACE INTO `item_db` VALUES (583,'KETUPAT_','Ketupat Sayur',0,7000,NULL,150,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(325,405),rand(40,60); sc_end SC_Poison; sc_end SC_Silence; sc_end SC_Blind; sc_end SC_Confusion; sc_end SC_Curse; sc_end SC_Hallucination;',NULL,NULL);
REPLACE INTO `item_db` VALUES (584,'Fish_Ball_Soup','Fish Cake Soup',0,100,NULL,60,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(40,70),0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (585,'Wurst','Brusti',11,2,NULL,40,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(15,20),0; itemskill "PR_MAGNIFICAT",3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (586,'Mother\'s_Cake','Mother\'s Cake',0,20,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(325,405),0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (587,'Prickly_Fruit_','Red Prickly Fruit',0,880,NULL,60,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(270,330),rand(20,30);',NULL,NULL);
REPLACE INTO `item_db` VALUES (588,'Spaghetti','Spaghetti',0,100,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(40,70),0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (589,'Pizza_02','Pizza',0,1200,NULL,150,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(375,445),0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (590,'Brezel_','Pretzel',0,2,NULL,20,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(50,90),0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (591,'Caviar_Pancake','Caviar Pancake',0,0,NULL,150,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(325,405),rand(40,60); sc_end SC_Poison; sc_end SC_Silence; sc_end SC_Blind; sc_end SC_Confusion; sc_end SC_Curse; sc_end SC_Hallucination;',NULL,NULL);
REPLACE INTO `item_db` VALUES (592,'Jam_Pancake','Jam Pancake',0,0,NULL,150,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(325,405),rand(40,60); sc_end SC_Poison; sc_end SC_Silence; sc_end SC_Blind; sc_end SC_Confusion; sc_end SC_Curse; sc_end SC_Hallucination;',NULL,NULL);
REPLACE INTO `item_db` VALUES (593,'Honey_Pancake','Honey Pancake',0,0,NULL,150,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(325,405),rand(40,60); sc_end SC_Poison; sc_end SC_Silence; sc_end SC_Blind; sc_end SC_Confusion; sc_end SC_Curse; sc_end SC_Hallucination;',NULL,NULL);
REPLACE INTO `item_db` VALUES (594,'Sour_Cream_Pancake','Sour-Cream Pancake',0,0,NULL,150,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(325,405),rand(40,60); sc_end SC_Poison; sc_end SC_Silence; sc_end SC_Blind; sc_end SC_Confusion; sc_end SC_Curse; sc_end SC_Hallucination;',NULL,NULL);
REPLACE INTO `item_db` VALUES (595,'Mushroom_Pancake','Mushroom Pancake',0,0,NULL,150,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(325,405),rand(40,60); sc_end SC_Poison; sc_end SC_Silence; sc_end SC_Blind; sc_end SC_Confusion; sc_end SC_Curse; sc_end SC_Hallucination;',NULL,NULL);
REPLACE INTO `item_db` VALUES (596,'Cute_Strawberry_Choco','Cute Strawberry-Choco',0,20,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal 0,rand(1,100);',NULL,NULL);
REPLACE INTO `item_db` VALUES (597,'Lovely_Choco_Tart','Lovely Choco-Tart',0,20,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(10,400),0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (598,'Light_Red_Pot','Light Red Potion',0,50,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(45,65),0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (599,'Light_Orange_Pot','Light Orange Potion',0,200,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(105,145),0;',NULL,NULL);
# Usable Items
#===================================================================
REPLACE INTO `item_db` VALUES (601,'Wing_Of_Fly','Fly Wing',11,60,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemskill "AL_TELEPORT",1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (602,'Wing_Of_Butterfly','Butterfly Wing',11,300,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemskill "AL_TELEPORT",3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (603,'Old_Blue_Box','Old Blue Box',2,10000,NULL,200,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getrandgroupitem(IG_BlueBox),1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (604,'Branch_Of_Dead_Tree','Dead Branch',2,50,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'monster "this",-1,-1,"--ja--",-1,1,"";',NULL,NULL);
REPLACE INTO `item_db` VALUES (605,'Anodyne','Anodyne',11,2000,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemskill "SM_ENDURE",1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (606,'Aloebera','Aloevera',11,1500,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemskill "SM_SELFPROVOKE",1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (607,'Yggdrasilberry','Yggdrasil Berry',0,5000,NULL,300,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'percentheal 100,100;',NULL,NULL);
REPLACE INTO `item_db` VALUES (608,'Seed_Of_Yggdrasil','Yggdrasil Seed',0,5000,NULL,300,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'percentheal 50,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (609,'Amulet','Amulet',2,100,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (610,'Leaf_Of_Yggdrasil','Yggdrasil Leaf',11,4000,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemskill "ALL_RESURRECTION",1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (611,'Spectacles','Magnifier',11,40,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemskill "MC_IDENTIFY",1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (612,'Portable_Furnace','Mini Furnace',2,150,NULL,200,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'produce 21;',NULL,NULL);
REPLACE INTO `item_db` VALUES (613,'Iron_Hammer','Iron Hammer',2,1000,NULL,200,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'produce 1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (614,'Golden_Hammer','Golden Hammer',2,3000,NULL,300,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'produce 2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (615,'Oridecon_Hammer','Oridecon Hammer',2,5000,NULL,400,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'produce 3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (616,'Old_Card_Album','Old Card Album',2,10000,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getrandgroupitem(IG_CardAlbum),1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (617,'Old_Violet_Box','Old Purple Box',2,10000,NULL,200,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getrandgroupitem(IG_VioletBox),1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (618,'Worn_Out_Scroll','Worn Out Scroll',2,50,NULL,20,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (619,'Unripe_Apple','Unripe Apple',2,1000,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'pet 1002;',NULL,NULL);
REPLACE INTO `item_db` VALUES (620,'Orange_Juice','Orange Juice',2,1500,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'pet 1113;',NULL,NULL);
REPLACE INTO `item_db` VALUES (621,'Bitter_Herb','Bitter Herb',2,20,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'pet 1031;',NULL,NULL);
REPLACE INTO `item_db` VALUES (622,'Rainbow_Carrot','Rainbow Carrot',2,2500,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'pet 1063;',NULL,NULL);
REPLACE INTO `item_db` VALUES (623,'Earthworm_The_Dude','Earthworm the Dude',2,4000,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'pet 1049;',NULL,NULL);
REPLACE INTO `item_db` VALUES (624,'Rotten_Fish','Rotten Fish',2,2500,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'pet 1011;',NULL,NULL);
REPLACE INTO `item_db` VALUES (625,'Lusty_Iron','Rusty Iron',2,100,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'pet 1042;',NULL,NULL);
REPLACE INTO `item_db` VALUES (626,'Monster_Juice','Monster Juice',2,1500,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'pet 1035;',NULL,NULL);
REPLACE INTO `item_db` VALUES (627,'Sweet_Milk','Sweet Milk',2,7000,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'pet 1167;',NULL,NULL);
REPLACE INTO `item_db` VALUES (628,'Well_Dried_Bone','Well-Dried Bone',2,10000,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'pet 1107;',NULL,NULL);
REPLACE INTO `item_db` VALUES (629,'Singing_Flower','Singing Flower',2,300,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'pet 1052;',NULL,NULL);
REPLACE INTO `item_db` VALUES (630,'Dew_Laden_Moss','Dew Laden Moss',2,10,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'pet 1014;',NULL,NULL);
REPLACE INTO `item_db` VALUES (631,'Deadly_Noxious_Herb','Deadly Noxious Herb',2,20,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'pet 1077;',NULL,NULL);
REPLACE INTO `item_db` VALUES (632,'Fatty_Chubby_Earthworm','Fatty Chubby Earthworm',2,5000,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'pet 1019;',NULL,NULL);
REPLACE INTO `item_db` VALUES (633,'Baked_Yam','Sweet Potato',2,20,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'pet 1056;',NULL,NULL);
REPLACE INTO `item_db` VALUES (634,'Tropical_Banana','Tropical Banana',2,20,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'pet 1057;',NULL,NULL);
REPLACE INTO `item_db` VALUES (635,'Horror_Of_Tribe','Orc Trophy',2,300,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'pet 1023;',NULL,NULL);
REPLACE INTO `item_db` VALUES (636,'No_Recipient','No Recipient',2,100,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'pet 1026;',NULL,NULL);
REPLACE INTO `item_db` VALUES (637,'Old_Broom','Old Broom',2,350,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'pet 1110;',NULL,NULL);
REPLACE INTO `item_db` VALUES (638,'Silver_Knife_Of_Chaste','Silver Knife of Chastity',2,12000,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'pet 1170;',NULL,NULL);
REPLACE INTO `item_db` VALUES (639,'Armlet_Of_Obedience','Armlet of Obedience',2,18000,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'pet 1029;',NULL,NULL);
REPLACE INTO `item_db` VALUES (640,'Shining_Stone','Shining Stone',2,3000,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'pet 1155;',NULL,NULL);
REPLACE INTO `item_db` VALUES (641,'Contracts_In_Shadow','Contract in Shadow',2,100,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'pet 1109;',NULL,NULL);
REPLACE INTO `item_db` VALUES (642,'Book_Of_Devil','Book of the Devil',2,1800,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'pet 1101;',NULL,NULL);
REPLACE INTO `item_db` VALUES (643,'Pet_Incubator','Pet Incubator',2,3000,NULL,30,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'bpet;',NULL,NULL);
REPLACE INTO `item_db` VALUES (644,'Gift_Box','Gift Box',2,1000,NULL,200,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getrandgroupitem(IG_GiftBox),1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (645,'Center_Potion','Concentration Potion',2,800,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_ASPDPOTION0,1800000,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (656,'Awakening_Potion','Awakening Potion',2,1500,NULL,150,NULL,NULL,NULL,NULL,0xFFF7FEEF,7,2,NULL,NULL,40,NULL,NULL,'sc_start SC_ASPDPOTION1,1800000,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (657,'Berserk_Potion','Berserk Potion',2,3000,NULL,200,NULL,NULL,NULL,NULL,0x41E646A6,7,2,NULL,NULL,85,NULL,NULL,'sc_start SC_ASPDPOTION2,1800000,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (658,'Union_Of_Tribe','Union of Tribe',2,2,NULL,500,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'guildgetexp rand(600000,1200000);',NULL,NULL);
REPLACE INTO `item_db` VALUES (659,'Heart_Of_Her','Her Heart',2,500,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'pet 1188;',NULL,NULL);
REPLACE INTO `item_db` VALUES (660,'Prohibition_Red_Candle','Forbidden Red Candle',2,20000,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'pet 1200;',NULL,NULL);
REPLACE INTO `item_db` VALUES (661,'Sway_Apron','Soft Apron',2,20000,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'pet 1275;',NULL,NULL);
REPLACE INTO `item_db` VALUES (662,'Inspector_Certificate','Authoritative Badge',2,1450,NULL,30,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_SPEEDUP0,180000,25;',NULL,NULL);
REPLACE INTO `item_db` VALUES (663,'Korea_Rice_Cake','Korean Rice Cake',0,1,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'percentheal 10,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (664,'Gift_Box_1','Gift Box',2,1000,NULL,200,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getrandgroupitem(IG_GiftBox_1),1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (665,'Gift_Box_2','Gift Box',2,1000,NULL,200,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getrandgroupitem(IG_GiftBox_2),1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (666,'Gift_Box_3','Gift Box',2,1000,NULL,200,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getrandgroupitem(IG_GiftBox_3),1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (667,'Gift_Box_4','Gift Box',2,1000,NULL,200,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getrandgroupitem(IG_GiftBox_4),1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (668,'Handsei','Red Envelope',2,0,NULL,20,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'set Zeny,Zeny+rand(1000,10000);',NULL,NULL);
REPLACE INTO `item_db` VALUES (669,'Rice_Cake_Soup','Tempting Rice-Cake Soup',0,500,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'percentheal -100,-100;',NULL,NULL);
REPLACE INTO `item_db` VALUES (670,'Gold_Coin_Moneybag','Bag of Gold Coins',3,100000,NULL,400,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (671,'Gold_Coin','Gold Coin',3,10000,NULL,40,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (672,'Copper_Coin_Moneybag','Bag of Bronze Coins',3,1000,NULL,400,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (673,'Copper_Coin','Bronze Coin',3,100,NULL,40,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (674,'Mithril_Coin','Mithril Coin',3,5000,NULL,40,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (675,'Silver_Coin','Silver Coin',3,5000,NULL,40,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (676,'Silver_Coin_Moneybag','Bag of Silver Coins',3,50000,NULL,400,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (677,'White_Gold_Coin','Platinum Coin',3,2000,NULL,40,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (678,'Poison_Bottle','Poison Bottle',2,5000,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'if(Class==Job_Assassin_Cross) { sc_start SC_DPoison,60000,0; sc_start SC_ASPDPOTION3,60000,0; } else percentheal -100,-100;',NULL,NULL);
REPLACE INTO `item_db` VALUES (679,'Gold_Pill','Pilule',2,5000,NULL,300,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_DPoison,10000,0,1000,0; sc_start SC_Poison,50000,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (680,'Magical_Carnation','Magic Carnation',0,0,NULL,1000,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'percentheal 0,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (681,'Memory_Of_Wedding','Sweet Memory of Marriage',2,50000,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'if(getpartnerid()) sc_start SC_WEDDING,600000,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (682,'Realgar_Wine','Distilled Fighting Spirit',2,0,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_ATKPOTION,60000,30;',NULL,NULL);
REPLACE INTO `item_db` VALUES (683,'Exorcize_Herb','Herb of Incantation',2,0,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_MATKPOTION,60000,30;',NULL,NULL);
REPLACE INTO `item_db` VALUES (684,'Durian','Durian',2,15000,NULL,300,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_ATKPOTION,60000,10; sc_start SC_MATKPOTION,60000,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (685,'RAMADAN','Ramadan',0,5000,NULL,300,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'percentheal 100,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (686,'Earth_Scroll_1_3','Level 3 Earth Spike',11,1000,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemskill "WZ_EARTHSPIKE",3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (687,'Earth_Scroll_1_5','Level 5 Earth Spike',11,2000,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemskill "WZ_EARTHSPIKE",5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (688,'Cold_Scroll_1_3','Level 3 Cold Bolt',11,1000,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemskill "MG_COLDBOLT",3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (689,'Cold_Scroll_1_5','Level 5 Cold Bolt',11,2000,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemskill "MG_COLDBOLT",5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (690,'Fire_Scroll_1_3','Level 3 Fire Bolt',11,1000,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemskill "MG_FIREBOLT",3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (691,'Fire_Scroll_1_5','Level 5 Fire Bolt',11,2000,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemskill "MG_FIREBOLT",5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (692,'Wind_Scroll_1_3','Level 3 Lightening Bolt',11,1000,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemskill "MG_LIGHTNINGBOLT",3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (693,'Wind_Scroll_1_5','Level 5 Lightening Bolt',11,2000,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemskill "MG_LIGHTNINGBOLT",5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (694,'Ghost_Scroll_1_3','Level 3 Soul Strike',11,1000,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemskill "MG_SOULSTRIKE",3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (695,'Ghost_Scroll_1_5','Level 5 Soul Strike',11,2000,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemskill "MG_SOULSTRIKE",5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (696,'Fire_Scroll_2_1','Level 1 Fire Ball',11,1000,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemskill "MG_FIREBALL",1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (697,'Fire_Scroll_2_5','Level 5 Fire Ball',11,2000,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemskill "MG_FIREBALL",5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (698,'Fire_Scroll_3_1','Level 1 Fire Wall',11,1000,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemskill "MG_FIREWALL",1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (699,'Fire_Scroll_3_5','Level 5 Fire Wall',11,2000,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemskill "MG_FIREWALL",5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (700,'Cold_Scroll_2_1','Level 1 Frost Diver',11,1000,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemskill "MG_FROSTDIVER",1;',NULL,NULL);
# Etc Items
#===================================================================
REPLACE INTO `item_db` VALUES (701,'Ora_Ora','Ora Ora',3,55000,NULL,200,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (702,'Animal_Blood','Animal Gore',3,450,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (703,'Hinalle','Hinalle',3,500,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (704,'Aloe','Aloe',3,500,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (705,'Clover','Clover',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (706,'Four_Leaf_Clover','Four Leaf Clover',3,80000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (707,'Singing_Plant','Singing Plant',3,500,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (708,'Ment','Ment',3,500,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (709,'Izidor','Izidor',3,500,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (710,'Illusion_Flower','Illusion Flower',3,1000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (711,'Shoot','Shoot',3,16,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (712,'Flower','Flower',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (713,'Empty_Bottle','Empty Bottle',3,6,NULL,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (714,'Emperium','Emperium',3,2,NULL,1000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (715,'Yellow_Gemstone','Yellow Gemstone',3,600,NULL,30,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (716,'Red_Gemstone','Red Gemstone',3,600,NULL,30,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (717,'Blue_Gemstone','Blue Gemstone',3,600,NULL,30,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (718,'Dark_Red_Jewel','Garnet',3,6000,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (719,'Violet_Jewel','Amethyst',3,6000,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (720,'Skyblue_Jewel','Aquamarine',3,6000,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (721,'Azure_Jewel','Emerald',3,6000,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (722,'Scarlet_Jewel','Pearl',3,6000,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (723,'Cardinal_Jewel','Ruby',3,6000,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (724,'Cardinal_Jewel_','Cursed Ruby',3,600,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (725,'Red_Jewel','Sardonyx',3,6000,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (726,'Blue_Jewel','Sapphire',3,6000,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (727,'White_Jewel','Opal',3,6000,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (728,'Golden_Jewel','Topaz',3,6000,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (729,'Bluish_Green_Jewel','Zircon',3,6000,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (730,'Crystal_Jewel','1carat Diamond',3,10000,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (731,'Crystal_Jewel_','2carat Diamond',3,25000,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (732,'Crystal_Jewel__','3carat Diamond',3,55000,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (733,'Crystal_Jewel___','Cracked Diamond',3,10,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (734,'Red_Frame','Red Frame',3,3000,NULL,200,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (735,'Blue_Porcelain','Chung Jah',3,5000,NULL,500,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (736,'White_Platter','China',3,1000,NULL,300,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (737,'Black_Ladle','Black Ladle',3,400,NULL,50,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (738,'Pencil_Case','Pencil Case',3,400,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (739,'Rouge','Rouge',3,10000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (740,'Stuffed_Doll','Puppet',3,1000,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (741,'Poring_Doll','Poring Doll',3,1800,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (742,'Chonchon_Doll','Chonchon Doll',3,3000,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (743,'Spore_Doll','Spore Doll',3,5500,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (744,'Bunch_Of_Flowers','Bouquet',3,2000,NULL,50,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (745,'Wedding_Bouquet','Wedding Bouquet',3,12000,NULL,50,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (746,'Glass_Bead','Glass Bead',3,1400,NULL,50,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (747,'Crystal_Mirror','Crystal Mirror',3,15000,NULL,50,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (748,'Witherless_Rose','Witherless Rose',3,55000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (749,'Frozen_Rose','Frozen Rose',3,35000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (750,'Baphomet_Doll','Baphomet Doll',3,18000,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (751,'Osiris_Doll','Osiris Doll',3,14000,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (752,'Grasshopper_Doll','Rocker Doll',3,4000,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (753,'Monkey_Doll','Yoyo Doll',3,6000,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (754,'Raccoondog_Doll','Raccoon Doll',3,5000,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (756,'Oridecon_Stone','Rough Oridecon',3,550,NULL,200,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (757,'Elunium_Stone','Rough Elunium',3,650,NULL,200,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (901,'Danggie','Daenggie',3,260,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (902,'Tree_Root','Tree Root',3,12,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (903,'Reptile_Tongue','Reptile Tongue',3,140,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (904,'Scorpion\'s_Tail','Scorpion Tail',3,124,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (905,'Stem','Stem',3,46,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (906,'Pointed_Scale','Pointed Scale',3,68,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (907,'Resin','Resin',3,120,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (908,'Spawn','Spawn',3,140,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (909,'Jellopy','Jellopy',3,6,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (910,'Garlet','Garlet',3,40,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (911,'Scell','Scell',3,160,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (912,'Zargon','Zargon',3,480,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (913,'Tooth_Of_Bat','Tooth of Bat',3,34,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (914,'Fluff','Fluff',3,8,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (915,'Chrysalis','Chrysalis',3,8,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (916,'Feather_Of_Birds','Feather of Birds',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (917,'Talon','Talon',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (918,'Sticky_Webfoot','Sticky Webfoot',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (919,'Animal\'s_Skin','Animal Skin',3,36,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (920,'Claw_Of_Wolves','Wolf Claw',3,58,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (921,'Mushroom_Spore','Mushroom Spore',3,36,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (922,'Orcish_Cuspid','Orc\'s Fang',3,220,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (923,'Evil_Horn','Evil Horn',3,1200,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (924,'Powder_Of_Butterfly','Powder of Butterfly',3,90,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (925,'Bill_Of_Birds','Bill of Birds',3,64,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (926,'Scale_Of_Snakes','Snake Scale',3,82,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (928,'Insect_Feeler','Insect Feeler',3,114,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (929,'Immortal_Heart','Immortal Heart',3,374,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (930,'Rotten_Bandage','Rotten Bandage',3,350,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (931,'Orcish_Voucher','Orcish Voucher',3,142,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (932,'Skel_Bone','Skel-Bone',3,232,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (934,'Mementos','Memento',3,600,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (935,'Shell','Shell',3,14,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (936,'Scales_Shell','Scale Shell',3,466,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (937,'Posionous_Canine','Venom Canine',3,148,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (938,'Sticky_Mucus','Sticky Mucus',3,70,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (939,'Bee_Sting','Bee Sting',3,32,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (940,'Grasshopper\'s_Leg','Grasshopper\'s Leg',3,36,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (941,'Nose_Ring','Nose Ring',3,568,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (942,'Yoyo_Tail','Yoyo Tail',3,114,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (943,'Solid_Shell','Solid Shell',3,448,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (944,'Horseshoe','Horseshoe',3,588,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (945,'Raccoon_Leaf','Raccoon Leaf',3,106,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (946,'Snail\'s_Shell','Snail\'s Shell',3,64,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (947,'Horn','Horn',3,116,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (948,'Bear\'s_Foot','Bear\'s Footskin',3,174,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (949,'Feather','Feather',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (950,'Heart_Of_Mermaid','Heart of Mermaid',3,264,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (951,'Fin','Fin',3,412,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (952,'Cactus_Needle','Cactus Needle',3,82,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (953,'Stone_Heart','Stone Heart',3,184,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (954,'Shining_Scales','Shining Scale',3,466,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (955,'Worm_Peelings','Worm Peeling',3,52,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (956,'Gill','Gill',3,342,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (957,'Decayed_Nail','Decayed Nail',3,82,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (958,'Horrendous_Mouth','Horrendous Mouth',3,390,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (959,'Rotten_Scale','Stinky Scale',3,168,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (960,'Nipper','Nipper',3,114,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (961,'Conch','Conch',3,158,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (962,'Tentacle','Tentacle',3,70,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (963,'Sharp_Scale','Sharp Scale',3,250,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (964,'Crap_Shell','Crab Shell',3,90,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (965,'Clam_Shell','Clam Shell',3,56,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (966,'Flesh_Of_Clam','Clam Flesh',3,158,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (967,'Turtle_Shell','Turtle Shell',3,680,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (968,'Voucher_Of_Orcish_Hero','Heroic Emblem',3,3000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (969,'Gold','Gold',3,200000,NULL,200,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (970,'Alchol','Alcohol',3,400,NULL,30,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (971,'Detrimindexta','Detrimindexta',3,400,NULL,30,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (972,'Karvodailnirol','Karvodailnirol',3,400,NULL,30,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (973,'Counteragent','Counteragent',3,800,NULL,70,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (974,'Mixture','Mixture',3,800,NULL,70,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (975,'Scarlet_Dyestuffs','Scarlet Dyestuffs',3,8000,NULL,150,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (976,'Lemon_Dyestuffs','Lemon Dyestuffs',3,8000,NULL,150,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (978,'Cobaltblue_Dyestuffs','Cobaltblue Dyestuffs',3,8000,NULL,150,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (979,'Darkgreen_Dyestuffs','Darkgreen Dyestuffs',3,8000,NULL,150,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (980,'Orange_Dyestuffs','Orange Dyestuffs',3,8000,NULL,150,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (981,'Violet_Dyestuffs','Violet Dyestuffs',3,8000,NULL,150,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (982,'White_Dyestuffs','White Dyestuffs',3,8000,NULL,150,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (983,'Black_Dyestuffs','Black Dyestuffs',3,8000,NULL,150,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (984,'Oridecon','Oridecon',3,1100,NULL,200,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (985,'Elunium','Elunium',3,1100,NULL,200,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (986,'Anvil','Anvil',3,30000,NULL,500,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (987,'Oridecon_Anvil','Oridecon Anvil',3,120000,NULL,700,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (988,'Golden_Anvil','Golden Anvil',3,300000,NULL,900,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (989,'Emperium_Anvil','Emperium Anvil',3,600000,NULL,1000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (990,'Boody_Red','Red Blood',3,1000,NULL,50,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (991,'Crystal_Blue','Crystal Blue',3,1000,NULL,50,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (992,'Wind_Of_Verdure','Wind of Verdure',3,1000,NULL,50,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (993,'Yellow_Live','Green Live',3,1000,NULL,50,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (994,'Flame_Heart','Flame Heart',3,3000,NULL,300,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (995,'Mistic_Frozen','Mystic Frozen',3,3000,NULL,300,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (996,'Rough_Wind','Rough Wind',3,3000,NULL,300,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (997,'Great_Nature','Great Nature',3,3000,NULL,300,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (998,'Iron','Iron',3,100,NULL,50,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (999,'Steel','Steel',3,1000,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1000,'Star_Crumb','Star Crumb',3,4500,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1001,'Sparkling_Dust','Star Dust',3,1500,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1002,'Iron_Ore','Iron Ore',3,50,NULL,150,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1003,'Coal','Coal',3,500,NULL,50,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1004,'Patriotism_Marks','Chivalry Emblem',3,2,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1005,'Hammer_Of_Blacksmith','Hammer of Blacksmith',3,2,NULL,800,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1006,'Old_Magic_Book','Old Magicbook',3,2,NULL,30,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1007,'Penetration','Necklace of Wisdom',3,2,NULL,40,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1008,'Frozen_Heart','Necklace of Oblivion',3,2,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1009,'Sacred_Marks','Hand of God',3,2,NULL,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1010,'Phracon','Phracon',3,200,NULL,200,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1011,'Emveretarcon','Emveretarcon',3,1000,NULL,200,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1012,'Lizard_Scruff','Frill',3,250,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1013,'Colorful_Shell','Rainbow Shell',3,90,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1014,'Jaws_Of_Ant','Ant Jaw',3,232,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1015,'Thin_N\'_Long_Tongue','Tongue',3,528,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1016,'Rat_Tail','Rat Tail',3,52,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1017,'Moustache_Of_Mole','Mole Whiskers',3,106,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1018,'Nail_Of_Mole','Mole Claw',3,210,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1019,'Wooden_Block','Trunk',3,60,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1020,'Long_Hair','Black Hair',3,292,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1021,'Dokkaebi_Horn','Dokebi Horn',3,292,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1022,'Fox_Tail','Nine Tails',3,650,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1023,'Fish_Tail','Fish Tail',3,196,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1024,'Chinese_Ink','Squid Ink',3,264,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1025,'Spiderweb','Cobweb',3,184,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1026,'Acorn','Acorn',3,98,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1027,'Porcupine_Spike','Porcupine Quill',3,158,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1028,'Wild_Boar\'s_Mane','Mane',3,196,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1029,'Tiger\'s_Skin','Tiger Skin',3,548,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1030,'Tiger_Footskin','Tiger\'s Footskin',3,1500,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1031,'Limb_Of_Mantis','Mantis Scythe',3,196,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1032,'Blossom_Of_Maneater','Maneater Blossom',3,196,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1033,'Root_Of_Maneater','Maneater Root',3,208,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1034,'Cobold_Hair','Blue Hair',3,342,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1035,'Dragon_Canine','Dragon Canine',3,484,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1036,'Dragon_Scale','Dragon Scale',3,500,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1037,'Dragon_Train','Dragon Tail',3,1200,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1038,'Petite_DiablOfs_Horn','Little Evil Horn',3,528,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1039,'Petite_DiablOfs_Wing','Little Evil Wing',3,2000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1040,'Elder_Pixie\'s_Beard','Elder Pixie\'s Moustache',3,232,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1041,'Lantern','Lantern',3,250,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1042,'Short_Leg','Bug Leg',3,430,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1043,'Nail_Of_Orc','Orc Claw',3,168,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1044,'Tooth_Of_','Zenorc\'s Fang',3,264,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1045,'Sacred_Masque','Cultish Masque',3,412,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1046,'Tweezer','Scorpion Nipper',3,614,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1047,'Head_Of_Medusa','Dead Medusa',3,548,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1048,'Slender_Snake','Horrendous Hair',3,800,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1049,'Skirt_Of_Virgin','Skirt of Virgin',3,1700,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1050,'Tendon','Tendon',3,220,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1051,'Detonator','Detonator',3,450,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1052,'Single_Cell','Single Cell',3,46,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1053,'Tooth_Of_Ancient_Fish','Ancient Tooth',3,548,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1054,'Lip_Of_Ancient_Fish','Ancient Lips',3,1000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1055,'Earthworm_Peeling','Earthworm Peeling',3,196,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1056,'Grit','Grit',3,306,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1057,'Moth_Dust','Moth Dust',3,138,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1058,'Wing_Of_Moth','Moth Wings',3,200,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1059,'Transparent_Cloth','Fabric',3,306,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1060,'Golden_Hair','Golden Hair',3,430,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1061,'Starsand_Of_Witch','Witched Starsand',3,484,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1062,'Pumpkin_Head','Jack o\' Pumpkin',3,374,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1063,'Sharpened_Cuspid','Fang',3,680,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1064,'Reins','Reins',3,802,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1065,'Booby_Trap','Trap',3,100,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1066,'Tree_Of_Archer_1','Fine-grained Trunk',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1067,'Tree_Of_Archer_2','Solid Trunk',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1068,'Tree_Of_Archer_3','Barren Trunk',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1069,'Mushroom_Of_Thief_1','Orange Net Mushroom',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1070,'Mushroom_Of_Thief_2','Orange Gooey Mushroom',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1071,'Mage_Test_1','Unknown Test Tube',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1072,'Delivery_Message','Delivery Message',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1073,'Merchant_Voucher_1','Voucher',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1074,'Merchant_Voucher_2','Voucher',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1075,'Merchant_Voucher_3','Voucher',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1076,'Merchant_Voucher_4','Voucher',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1077,'Merchant_Voucher_5','Voucher',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1078,'Merchant_Voucher_6','Voucher',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1079,'Merchant_Voucher_7','Voucher',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1080,'Merchant_Voucher_8','Voucher',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1081,'Merchant_Box_1','Delivery Box',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1082,'Merchant_Box_2','Delivery Box',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1083,'Merchant_Box_3','Delivery Box',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1084,'Kapra\'s_Pass','Kafra Pass',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1085,'Mage_Test_2','Unknown Test Tube',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1086,'Mage_Test_3','Unknown Test Tube',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1087,'Mage_Test_4','Unknown Test Tube',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1088,'Morocc_Potion','Morroc Solution',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1089,'Payon_Potion','Payon Solution',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1090,'Mage_Test_Etc','Unknown Test Tube',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1091,'Merchant_Box_Etc','Delivery Box',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1092,'Empty_Cylinder','Empty Test Tube',3,3,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1093,'Empty_Potion','Empty Potion Bottle',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1094,'Short_Daenggie','Short Daenggie',3,278,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1095,'Needle_Of_Alarm','Needle of Alarm',3,546,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1096,'Round_Shell','Round Shell',3,780,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1097,'Worn_Out_Page','Worn Out Page',3,948,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1098,'Manacles','Manacles',3,658,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1099,'Worn_Out_Prison_Uniform','Worn-out Prison Uniform',3,680,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
# Weapons
#===================================================================
# 1-Handed Swords
REPLACE INTO `item_db` VALUES (1101,'Sword','Sword',5,100,NULL,500,25,NULL,1,3,0x000654E3,7,2,2,1,2,1,2,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1102,'Sword_','Sword',5,100,NULL,500,25,NULL,1,4,0x000654E3,7,2,2,1,2,1,2,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1103,'Sword__','Sword',5,100,NULL,500,25,NULL,1,0,0x000654E3,7,2,2,1,2,1,2,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1104,'Falchion','Falchion',5,1500,NULL,600,39,NULL,1,3,0x000654E3,7,2,2,1,2,1,2,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1105,'Falchion_','Falchion',5,1500,NULL,600,39,NULL,1,4,0x000654E3,7,2,2,1,2,1,2,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1106,'Falchion__','Falchion',5,1500,NULL,600,39,NULL,1,0,0x000654E3,7,2,2,1,2,1,2,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1107,'Blade','Blade',5,2900,NULL,700,53,NULL,1,3,0x000654E3,7,2,2,1,2,1,2,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1108,'Blade_','Blade',5,2900,NULL,700,53,NULL,1,4,0x000654E3,7,2,2,1,2,1,2,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1109,'Blade__','Blade',5,2900,NULL,700,53,NULL,1,0,0x000654E3,7,2,2,1,2,1,2,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1110,'Lapier','Rapier',5,10000,NULL,500,70,NULL,1,2,0x000654E3,7,2,2,2,14,1,2,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1111,'Lapier_','Rapier',5,10000,NULL,500,70,NULL,1,3,0x000654E3,7,2,2,2,14,1,2,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1112,'Lapier__','Rapier',5,10000,NULL,500,70,NULL,1,0,0x000654E3,7,2,2,2,14,1,2,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1113,'Scimiter','Scimitar',5,17000,NULL,700,85,NULL,1,2,0x000654E3,7,2,2,2,14,1,2,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1114,'Scimiter_','Scimitar',5,17000,NULL,700,85,NULL,1,3,0x000654E3,7,2,2,2,14,1,2,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1115,'Scimiter__','Scimitar',5,17000,NULL,700,85,NULL,1,3,0x000654E3,7,2,2,2,14,1,2,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1116,'Katana','Katana',5,2000,NULL,1000,60,NULL,1,3,0x00004082,7,2,34,1,4,1,3,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1117,'Katana_','Katana',5,2000,NULL,1000,60,NULL,1,4,0x00004082,7,2,34,1,4,1,3,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1118,'Katana__','Katana',5,2000,NULL,1000,60,NULL,1,0,0x00004082,7,2,34,1,4,1,3,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1119,'Tsurugi','Tsurugi',5,51000,NULL,1200,130,NULL,1,1,0x000654E2,7,2,2,3,27,1,2,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1120,'Tsurugi_','Tsurugi',5,51000,NULL,1200,130,NULL,1,2,0x000654E2,7,2,2,3,27,1,2,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1121,'Tsurugi__','Tsurugi',5,51000,NULL,1200,130,NULL,1,0,0x000654E2,7,2,2,3,27,1,2,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1122,'Ring_Pommel_Saber','Ring Pommel Saber',5,24000,NULL,900,100,NULL,1,2,0x000654E2,7,2,2,2,14,1,2,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1123,'Haedonggum','Haedonggum',5,50000,NULL,900,120,NULL,1,1,0x000654E2,7,2,2,3,27,1,2,'bonus bInt,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1124,'Orcish_Sword','Orcish Sword',5,20,NULL,800,90,NULL,1,0,0x000654E3,7,2,2,3,5,1,2,'bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1125,'Ring_Pommel_Saber_','Ring Pommel Saber',5,24000,NULL,900,100,NULL,1,3,0x000654E2,7,2,2,2,14,1,2,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1126,'Saber','Saber',5,49000,NULL,1000,115,NULL,1,2,0x000654E2,7,2,2,3,27,1,2,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1127,'Saber_','Saber',5,49000,NULL,1000,115,NULL,1,3,0x000654E2,7,2,2,3,27,1,2,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1128,'Hae_Dong_Gum_','Haedonggum',5,50000,NULL,900,120,NULL,1,2,0x000654E2,7,2,2,3,27,1,2,'bonus bInt,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1129,'Flamberge','Flamberge',5,60000,NULL,1500,150,NULL,1,0,0x00004080,7,2,2,3,27,1,2,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1130,'Nagan','Nagan',5,20,NULL,500,120,NULL,1,0,0x000654E2,7,2,2,4,40,1,2,'skill "TF_DOUBLE",5; bonus bDoubleRate,25; bonus2 bAddRace,RC_DemiHuman,5; bonus2 bAddRace,RC_Player,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1131,'Ice_Falchon','Ice Falchion',5,20,NULL,600,100,NULL,1,0,0x000654E2,7,2,2,4,40,1,2,'bonus bAtkEle,Ele_Water; bonus2 bAddEff,Eff_Freeze,500; bonus2 bAddEff2,Eff_Freeze,10; skill "MG_COLDBOLT",3; bonus3 bAutoSpell,"MG_COLDBOLT",3,100;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1132,'Edge','Edge',5,20,NULL,700,115,NULL,1,0,0x000654E2,7,2,2,4,40,1,2,'bonus2 bAddEff,Eff_Curse,30; bonus2 bComaClass,Class_Normal,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1133,'Fire_Brand','Fireblend',5,20,NULL,500,100,NULL,1,0,0x000654E2,7,2,2,4,40,1,2,'bonus bAtkEle,Ele_Fire; skill "MG_FIREBOLT",3; bonus3 bAutoSpell,"MG_FIREBOLT",3,100;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1134,'Scissores_Sword','Caesar\'s Sword',5,20,NULL,700,140,NULL,1,0,0x000654E2,7,2,2,4,40,1,2,'bonus2 bAddRace,RC_Plant,25; bonus bIgnoreDefRace,RC_Plant;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1135,'Cutlas','Cutlus',5,20,NULL,900,150,NULL,1,0,0x000654E2,7,2,2,4,40,1,2,'skill "SM_BASH",5; bonus bStr,2; bonus bDef,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1136,'Solar_Sword','Solar Sword',5,20,NULL,1200,85,NULL,1,0,0x000654E2,7,2,2,4,40,1,2,'bonus bAtkEle,Ele_Fire; bonus2 bHPDrainRate,1000,1; bonus2 bSPLossRate,15,10000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1137,'Excalibur','Excalibur',5,20,NULL,1200,150,NULL,1,0,0x000654E2,7,2,2,4,40,1,2,'bonus bInt,5; bonus bLuk,10; bonus bDex,-1; bonus bAtkEle,Ele_Holy;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1138,'Mysteltainn_','Mysteltainn',5,20,NULL,1000,170,NULL,1,0,0x000654E2,7,2,2,4,40,1,2,'bonus bAtkEle,Ele_Dark; bonus2 bAddEle,Ele_Ghost,15; bonus3 bAutoSpell,"MG_STONECURSE",3,100; bonus2 bAddEff,Eff_Stone,10; bonus bDex,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1139,'Tale_Fing_','Tirfing',5,20,NULL,1000,200,NULL,1,0,0x000654E2,7,2,2,4,40,1,2,'bonus bAtkEle,Ele_Dark; bonus2 bHPLossRate,35,10000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1140,'Byeorrun_Gum','Byeollungum',5,20,NULL,900,150,NULL,1,0,0x000654E2,7,2,2,4,40,1,2,'bonus2 bSubClass,Class_Normal,-10; bonus2 bAddClass,Class_Boss,50; bonus bAllStats,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1141,'Immaterial_Sword','Immaterial Sword',5,20,NULL,900,140,NULL,1,0,0x000654E2,7,2,2,4,40,1,2,'bonus bAtkEle,Ele_Ghost; bonus2 bSPVanishRate,30,30; bonus bSPDrainValue,-1; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1142,'Jewel_Sword','Jeweled Sword',5,20,NULL,2200,104,NULL,1,0,0x000654E2,7,2,2,3,68,1,2,'bonus2 bAddMonsterDropItemGroup,IG_Jewel,100;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1143,'Gaia_Sword','Gaia Sword',5,20,NULL,2500,140,NULL,1,0,0x000654E2,7,2,2,3,74,1,2,'bonus2 bAddMonsterDropItemGroup,IG_Ore,30;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1144,'Sasimi','Sashimi',5,20,NULL,1400,75,NULL,1,0,0x000654E2,7,2,2,3,48,1,2,'bonus bAtkEle,Ele_Wind; bonus3 bAddMonsterDropItem,544,RC_Fish,4000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1145,'Holy_Avenger','Holy Avenger',5,450000,NULL,1350,125,NULL,1,0,0x00004000,7,2,2,3,75,1,2,'bonus bAtkEle,Ele_Holy; bonus bVit,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1146,'Town_Sword','Town Sword',5,42000,NULL,800,100,NULL,1,1,0x00000001,7,2,2,3,30,1,2,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1147,'Town_Sword_','Town Sword',5,42000,NULL,800,100,NULL,1,2,0x00000001,7,2,2,3,30,1,2,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1148,'Star_Dust_Blade','Star Dust Blade',5,20,NULL,1000,140,NULL,1,1,0x00000001,7,2,2,4,45,1,2,'bonus2 bAddEff,Eff_Stun,500; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1149,'Flamberge_','Flamberge',5,60000,NULL,1500,150,NULL,1,2,0x00004080,7,2,2,3,27,1,2,NULL,NULL,NULL);
# 2-Handed Swords
REPLACE INTO `item_db` VALUES (1151,'Slayer','Slayer',5,15000,NULL,1300,90,NULL,1,2,0x00004082,7,2,34,2,18,1,3,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1152,'Slayer_','Slayer',5,15000,NULL,1300,90,NULL,1,3,0x00004082,7,2,34,2,18,1,3,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1153,'Slayer__','Slayer',5,15000,NULL,1300,90,NULL,1,0,0x00004082,7,2,34,2,18,1,3,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1154,'Bastard_Sword','Bastard Sword',5,22500,NULL,1600,115,NULL,1,2,0x00004082,7,2,34,2,18,1,3,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1155,'Bastard_Sword_','Bastard Sword',5,22500,NULL,1600,115,NULL,1,3,0x00004082,7,2,34,2,18,1,3,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1156,'Bastard_Sword__','Bastard Sword',5,22500,NULL,1600,115,NULL,1,0,0x00004082,7,2,34,2,18,1,3,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1157,'Two_Hand_Sword','Two-Handed Sword',5,60000,NULL,2200,160,NULL,1,1,0x00004082,7,2,34,3,33,1,3,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1158,'Two_Hand_Sword_','Two-Handed Sword',5,60000,NULL,2200,160,NULL,1,2,0x00004082,7,2,34,3,33,1,3,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1159,'Two_Hand_Sword__','Two-Handed Sword',5,60000,NULL,2200,160,NULL,1,0,0x00004082,7,2,34,3,33,1,3,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1160,'Broad_Sword','Broad Sword',5,65000,NULL,2000,140,NULL,1,1,0x00004082,7,2,34,3,33,1,3,'bonus bDef,5; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1161,'Balmung','Balmung',5,20,NULL,1000,250,NULL,1,0,0xFFFFFFFF,7,2,34,4,48,1,3,'bonus bUnbreakableWeapon; bonus bAtkEle,Ele_Holy;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1162,'Broad_Sword_','Broad Sword',5,65000,NULL,2000,140,NULL,1,2,0x00004082,7,2,34,3,33,1,3,'bonus bDef,5; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1163,'Claymore','Claymore',5,74000,NULL,2500,180,NULL,1,0,0x00004080,7,2,34,3,33,1,3,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1164,'Muramasa','Muramasa',5,20,NULL,1000,155,NULL,1,0,0x00004082,7,2,34,4,48,1,3,'bonus bCritical,30; bonus bAspdRate,8; bonus2 bAddEff2,Eff_Curse,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1165,'Masamune','Masamune',5,20,NULL,1000,200,NULL,1,0,0x00004082,7,2,34,4,48,1,3,'bonus bFlee,30; bonus bStr,-5; bonus bAspd,2; bonus bDefRate,-67; bonus bDef2Rate,-67;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1166,'Dragon_Slayer','Dragon Slayer',5,20,NULL,1300,150,NULL,1,0,0x00004082,7,2,34,4,48,1,3,'bonus bIgnoreDefRace,RC_Dragon; bonus2 bAddRace,RC_Dragon,15;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1167,'Schweizersabel','Schweizersabel',5,20,NULL,1600,160,NULL,1,0,0x00004082,7,2,34,4,48,1,3,'bonus bAtkEle,Ele_Wind; bonus bDef,1; bonus3 bAutoSpell,"MG_LIGHTNINGBOLT",3,100;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1168,'Zweihander','Zweihander',5,20,NULL,2200,200,NULL,1,0,0x00004082,7,2,34,4,48,1,3,'bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1169,'Executioner_','Executioner',5,20,NULL,2200,155,NULL,1,0,0x00004082,7,2,34,4,48,1,3,'bonus bIgnoreDefRace,RC_DemiHuman; bonus bIgnoreDefRace,RC_Player; bonus2 bAddRace,RC_DemiHuman,20; bonus2 bAddRace,RC_Player,20; bonus2 bSubRace,RC_DemiHuman,-10; bonus2 bSubRace,RC_Player,-10; bonus bAtkEle,Ele_Dark;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1170,'Katzbalger','Katzbalger',5,20,NULL,2000,175,NULL,1,0,0x00004082,7,2,34,4,48,1,3,'bonus bVit,5; bonus bDef,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1171,'Zweihander_','Zweihander',5,20,NULL,2200,200,NULL,1,2,0x00004082,7,2,34,4,48,1,3,'bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1172,'Claymore_','Claymore',5,74000,NULL,2500,180,NULL,1,2,0x00004080,7,2,34,3,33,1,3,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1173,'Muramasa_C','Muramasa',5,1,NULL,0,204,NULL,1,0,0x00004082,7,2,34,4,1,0,3,'bonus bCritical,30; bonus bAspdRate,8;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1174,'Executioner_C','Executioner',5,2,NULL,0,190,NULL,1,0,0x00004082,7,2,34,4,0,0,3,'bonus bIgnoreDefRace,RC_DemiHuman; bonus bIgnoreDefRace,RC_Player; bonus2 bAddRace,RC_DemiHuman,20; bonus2 bAddRace,RC_Player,20; bonus2 bSubRace,RC_DemiHuman,-10; bonus2 bSubRace,RC_Player,-10; bonus bAtkEle,Ele_Dark;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1175,'Altas_Weapon','Atlas Weapon',5,20,NULL,3500,200,NULL,1,1,0x00004082,2,2,34,4,55,1,3,'bonus bCritical,10; if(readparam(bStr)>=80) bonus bBreakArmorRate,500;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1176,'Muscle_Cutter','Muscle Cutter',5,20,NULL,2200,160,NULL,1,2,0x00004082,2,2,34,4,55,1,3,'bonus2 bAddEff,Eff_Bleeding,800; bonus3 bAutoSpell,"AL_DECAGI",1,30;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1177,'Muramash','Muramash',5,20,NULL,0,120,NULL,1,0,0x00004082,7,2,34,1,0,0,3,'bonus2 bAddClass,Class_All,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1178,'Schweizersabel_','Schweizersabel',5,20,NULL,1600,160,NULL,1,2,0x00004082,7,2,34,4,48,1,3,'bonus bAtkEle,Ele_Wind; bonus bDef,1; bonus3 bAutoSpell,"MG_LIGHTNINGBOLT",3,100;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1179,'Executioner__','Executioner',5,20,NULL,2200,155,NULL,1,1,0x00004082,7,2,34,4,48,1,3,'bonus bIgnoreDefRace,RC_DemiHuman; bonus bIgnoreDefRace,RC_Player; bonus2 bAddRace,RC_DemiHuman,20; bonus2 bAddRace,RC_Player,20; bonus2 bSubRace,RC_DemiHuman,-10; bonus2 bSubRace,RC_Player,-10; bonus bAtkEle,Ele_Dark;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1180,'Dragon_Slayer_','Dragon Slayer',5,20,NULL,1300,150,NULL,1,2,0x00004082,7,2,34,4,48,1,3,'bonus bIgnoreDefRace,RC_Dragon; bonus2 bAddRace,RC_Dragon,15;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1181,'Tae_Goo_Lyeon','Tae Goo Lyeon',5,20,NULL,2000,250,NULL,1,2,0x00004082,2,2,34,4,90,1,3,'bonus bFlee2,10; if(JobLevel>=70) autobonus "{ bonus bBaseAtk,50; }",10,10000,BF_WEAPON,"{ specialeffect2 EF_POTION_BERSERK; }"; if(getrefine()>8) { bonus bCastrate,-20; bonus bDelayRate,-20; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (1182,'Bloody_Eater','Bloody Eater',5,20,NULL,1200,200,NULL,1,2,0x00004082,2,2,34,4,50,1,3,'bonus bAtkEle,Ele_Ghost; autobonus "{ bonus bCritical,100; bonus bBaseAtk,50; }",1,5000,0,"{ specialeffect2 EF_FIRESPLASHHIT; }"; bonus bHPGainValue,100;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1183,'BF_Two_Handed_Sword1','Brave Assaulter\'s Katzbalger',5,20,NULL,0,200,NULL,1,0,0x00004082,7,2,34,3,80,1,3,'bonus bStr,2; bonus2 bAddRace,RC_DemiHuman,55; bonus2 bAddRace,RC_Player,55; bonus2 bIgnoreDefRaceRate,RC_DemiHuman,20; bonus2 bIgnoreDefRaceRate,RC_Player,20; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1184,'BF_Two_Handed_Sword2','Valorous Assaulter\'s Katzbalger',5,20,NULL,0,200,NULL,1,0,0x00004082,7,2,34,3,80,1,3,'bonus bCritical,20; bonus2 bAddRace,RC_DemiHuman,55; bonus2 bAddRace,RC_Player,55; bonus bCritAtkRate,20; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1185,'Violet_Fear','Violet Fear',5,20,NULL,2200,275,NULL,1,2,0x00004082,2,2,34,4,80,1,3,'bonus3 bAutoSpell,"WZ_METEOR",3,30; bonus3 bAutoSpell,"WZ_FROSTNOVA",5,50; autobonus "{ bonus bIgnoreDefClass,Class_Normal; }",50,5000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1186,'Death_Guidance','Death Guidance',5,20,NULL,2000,200,NULL,1,2,0x00004082,2,2,34,4,70,1,3,'bonus bStr,5; bonus bAgi,2; bonus bFlee2,20; bonus3 bAutoSpell,"NPC_HELLPOWER",1,10; bonus4 bAutoSpell,"NPC_HELLPOWER",1,10,0; if( getrefine()>8 ) bonus3 bAutoSpell,"NPC_VAMPIRE_GIFT",2,20; else bonus3 bAutoSpell,"NPC_VAMPIRE_GIFT",1,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1187,'Krieger_Twohand_Sword1','Glorious Claymore',5,20,NULL,0,220,NULL,1,0,0x00004082,7,2,34,4,80,1,3,'bonus2 bAddRace,RC_DemiHuman,70; bonus2 bAddRace,RC_Player,70; bonus2 bIgnoreDefRaceRate,RC_DemiHuman,25; bonus2 bIgnoreDefRaceRate,RC_Player,25; bonus bUnbreakableWeapon; if(getrefine()>5) { bonus2 bAddRace,RC_DemiHuman,(getrefine()-3)*(getrefine()-3); bonus2 bAddRace,RC_Player,(getrefine()-3)*(getrefine()-3); bonus2 bIgnoreDefRaceRate,RC_DemiHuman,5; bonus2 bIgnoreDefRaceRate,RC_Player,5; } if(getrefine()>8) { bonus3 bAutoSpell,"LK_CONCENTRATION",max(getskilllv("LK_CONCENTRATION"),1),30; bonus3 bAutoSpell,"LK_AURABLADE",max(getskilllv("LK_AURABLADE"),1),30; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (1188,'Veteran_Sword','Veteran Sword',5,10000,NULL,2000,180,NULL,1,1,0x00004082,7,2,34,4,80,1,3,'if(getskilllv("SM_BASH")==10) { bonus2 bSkillAtk,"SM_BASH",50; } if(getskilllv("KN_BOWLINGBASH")==10) { bonus2 bSkillAtk,"KN_BOWLINGBASH",50; } bonus bStr,1; bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1189,'Krasnaya','Krasnaya',5,20,NULL,3800,200,NULL,2,3,0x00004082,2,2,34,2,50,1,3,'if(readparam(bStr)>=95) { bonus bBaseAtk,20; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (1190,'Claymore_C','Claymore',5,0,NULL,0,220,NULL,1,0,0x00004080,7,2,34,3,1,0,3,'bonus2 bAddSize,Size_All,40;',NULL,NULL);
# Daggers
REPLACE INTO `item_db` VALUES (1201,'Knife','Knife',5,50,NULL,400,17,NULL,1,3,0x3E9F7EEF,7,2,2,1,1,1,1,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1202,'Knife_','Knife',5,50,NULL,400,17,NULL,1,4,0x3E9F7EEF,7,2,2,1,1,1,1,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1203,'Knife__','Knife',5,50,NULL,400,17,NULL,1,0,0x3E9F7EEF,7,2,2,1,1,1,1,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1204,'Cutter','Cutter',5,1250,NULL,500,30,NULL,1,3,0x3E9F7EEF,7,2,2,1,1,1,1,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1205,'Cutter_','Cutter',5,1250,NULL,500,30,NULL,1,4,0x3E9F7EEF,7,2,2,1,1,1,1,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1206,'Cutter__','Cutter',5,1250,NULL,500,30,NULL,1,0,0x3E9F7EEF,7,2,2,1,1,1,1,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1207,'Main_Gauche','Main Gauche',5,2400,NULL,600,43,NULL,1,3,0x3E9F7EEF,7,2,2,1,1,1,1,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1208,'Main_Gauche_','Main Gauche',5,2400,NULL,600,43,NULL,1,4,0x3E9F7EEF,7,2,2,1,1,1,1,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1209,'Main_Gauche__','Main Gauche',5,2400,NULL,600,43,NULL,1,0,0x3E9F7EEF,7,2,2,1,1,1,1,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1210,'Dirk','Dirk',5,8500,NULL,500,59,NULL,1,2,0x3E9F7EEF,7,2,2,2,12,1,1,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1211,'Dirk_','Dirk',5,8500,NULL,500,59,NULL,1,3,0x3E9F7EEF,7,2,2,2,12,1,1,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1212,'Dirk__','Dirk',5,8500,NULL,500,59,NULL,1,0,0x3E9F7EEF,7,2,2,2,12,1,1,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1213,'Dagger','Dagger',5,14000,NULL,600,73,NULL,1,2,0x3E9F7EEF,7,2,2,2,12,1,1,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1214,'Dagger_','Dagger',5,14000,NULL,600,73,NULL,1,3,0x3E9F7EEF,7,2,2,2,12,1,1,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1215,'Dagger__','Dagger',5,14000,NULL,600,73,NULL,1,0,0x3E9F7EEF,7,2,2,2,12,1,1,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1216,'Stiletto','Stiletto',5,19500,NULL,700,87,NULL,1,2,0x3E9F7EEF,7,2,2,2,12,1,1,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1217,'Stiletto_','Stiletto',5,19500,NULL,700,87,NULL,1,3,0x3E9F7EEF,7,2,2,2,12,1,1,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1218,'Stiletto__','Stiletto',5,19500,NULL,700,87,NULL,1,0,0x3E9F7EEF,7,2,2,2,12,1,1,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1219,'Gladius','Gladius',5,43000,NULL,700,105,NULL,1,2,0x028F5EEE,7,2,2,3,24,1,1,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1220,'Gladius_','Gladius',5,43000,NULL,700,105,NULL,1,3,0x028F5EEE,7,2,2,3,24,1,1,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1221,'Gladius__','Gladius',5,43000,NULL,700,105,NULL,1,0,0x028F5EEE,7,2,2,3,24,1,1,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1222,'Damascus','Damascus',5,49000,NULL,800,118,NULL,1,1,0x028F5EEE,7,2,2,3,24,1,1,'bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1223,'Forturn_Sword','Fortune Sword',5,20,NULL,500,90,NULL,1,0,0x028F5EEE,7,2,2,4,24,1,1,'bonus bLuk,5; bonus bFlee2,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1224,'Sword_Breaker','Swordbreaker',5,20,NULL,1000,70,NULL,1,0,0x028F5EEE,7,2,2,4,36,1,1,'bonus bBreakWeaponRate,500;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1225,'Mail_Breaker','Mailbreaker',5,20,NULL,1000,70,NULL,1,0,0x028F5EEE,7,2,2,4,36,1,1,'bonus bBreakArmorRate,500;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1226,'Damascus_','Damascus',5,49000,NULL,800,118,NULL,1,2,0x028F5EEE,7,2,2,3,24,1,1,'bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1227,'Weeder_Knife','Weeder Knife',5,20,NULL,400,80,NULL,1,0,0x028F5EEE,7,2,2,4,36,1,1,'bonus bIgnoreDefRace,RC_Plant; bonus2 bAddRace,RC_Plant,15; bonus2 bSubRace,RC_Plant,15;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1228,'Combat_Knife','Combat Knife',5,20,NULL,400,80,NULL,1,0,0x028F5EEE,7,2,2,4,36,1,1,'bonus bIgnoreDefRace,RC_DemiHuman; bonus bIgnoreDefRace,RC_Player; bonus2 bSubRace,RC_DemiHuman,10; bonus2 bSubRace,RC_Player,10; bonus2 bSubRace,RC_Demon,-10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1229,'Mama\'s_Knife','Kitchen Knife',5,20,NULL,500,75,NULL,1,0,0x028F5EEE,7,2,2,4,36,1,1,'bonus bCritical,30; bonus3 bAddMonsterDropItem,517,RC_Brute,5000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1230,'House_Auger','Ice Pick',5,20,NULL,600,80,NULL,1,0,0x028F5EEE,7,2,2,4,36,1,1,'bonus bDefRatioAtkClass,Class_All;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1231,'Bazerald','Bazerald',5,20,NULL,500,70,NULL,1,0,0x028F5EEE,7,2,2,4,36,1,1,'bonus bAtkEle,Ele_Fire; bonus bInt,5; bonus bMatkRate,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1232,'Assasin_Dagger','Assassin Dagger',5,20,NULL,600,140,NULL,1,0,0x00001000,7,2,2,4,36,1,1,'bonus bMaxHPrate,20; bonus bMaxSPrate,15; bonus bAspdRate,2; bonus bAtkEle,Ele_Dark;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1233,'Exercise','Exorciser',5,20,NULL,700,90,NULL,1,0,0x028F5EEE,7,2,2,4,36,1,1,'bonus bIgnoreDefRace,RC_Demon; bonus2 bSubRace,RC_Demon,5; bonus2 bSubRace,RC_DemiHuman,-10; bonus2 bSubRace,RC_Player,-10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1234,'Moonlight_Sword','Moonlight Dagger',5,20,NULL,700,50,NULL,1,0,0x028F5EEE,7,2,2,4,36,1,1,'bonus bMaxSPrate,10; bonus bSPDrainValue,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1235,'Azoth','Azoth',5,20,NULL,700,110,NULL,1,0,0x00040000,7,2,2,4,36,1,1,'bonus bClassChange,300;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1236,'Sucsamad','Sucsamad',5,20,NULL,800,140,NULL,1,0,0x028F5EEE,7,2,2,4,36,1,1,'bonus2 bAddEle,Ele_Earth,10; bonus2 bAddEle,Ele_Wind,10; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1237,'Grimtooth_','Grimtooth',5,20,NULL,800,180,NULL,1,0,0x028F5EEE,7,2,2,4,36,1,1,'bonus bFlee,10; bonus bFlee2,5; bonus bDefRate,-50; bonus bDef2Rate,-50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1238,'Zeny_Knife','Zeny Knife',5,20,NULL,1200,64,NULL,1,0,0x028F5EEE,7,2,2,3,70,1,1,'bonus2 bGetZenyNum,100,40;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1239,'Poison_Knife','Poison Knife',5,20,NULL,800,64,NULL,1,0,0x028F5EEE,7,2,2,3,65,1,1,'bonus bAtkEle,Ele_Poison; bonus2 bAddEff,Eff_Poison,3000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1240,'Princess_Knife','Princess Knife',5,20,NULL,400,84,NULL,1,0,0x028F5EEE,7,2,2,4,1,1,1,'bonus bAllStats,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1241,'Cursed_Dagger','Cursed Dagger',5,80000,NULL,400,55,NULL,1,0,0x00810204,7,2,2,4,85,1,1,'bonus2 bAddEff,Eff_Curse,5000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1242,'Counter_Dagger','Dagger of Counter',5,120000,NULL,550,140,NULL,1,0,0x00810204,7,2,2,4,55,1,1,'bonus bCritical,90;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1243,'Novice_Knife','Novice Main-Gauche',5,1,NULL,1,45,NULL,1,0,0x00000001,7,2,2,1,1,0,1,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1244,'Holy_Dagger','Holy Dagger',5,20,NULL,800,100,NULL,1,0,0x02021040,7,2,2,4,55,1,1,'bonus bAtkEle,Ele_Holy; bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1245,'Cinquedea','Cinquedea',5,40000,NULL,700,110,NULL,1,1,0x00000001,7,2,2,3,30,1,1,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1246,'Cinquedea_','Cinquedea',5,40000,NULL,700,110,NULL,1,2,0x00000001,7,2,2,3,30,1,1,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1247,'Kindling_Dagger','Kindle Dagger',5,10000,NULL,600,39,NULL,1,0,0x3E9F7EEF,7,2,2,1,1,1,1,'bonus bAtkEle,Ele_Fire;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1248,'Obsidian_Dagger','Obsidian Dagger',5,10000,NULL,600,39,NULL,1,0,0x3E9F7EEF,7,2,2,1,1,1,1,'bonus bAtkEle,Ele_Earth;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1249,'Fisherman\'s_Dagger','Fisherman\'s Dagger',5,10000,NULL,600,39,NULL,1,0,0x3E9F7EEF,7,2,2,1,1,1,1,'bonus bAtkEle,Ele_Water;',NULL,NULL);
# Katars
REPLACE INTO `item_db` VALUES (1250,'Jur','Jur',5,19500,NULL,800,125,NULL,1,2,0x00001000,7,2,34,2,18,1,16,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1251,'Jur_','Jur',5,19500,NULL,800,125,NULL,1,3,0x00001000,7,2,34,2,18,1,16,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1252,'Katar','Katar',5,41000,NULL,1200,148,NULL,1,1,0x00001000,7,2,34,3,33,1,16,'bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1253,'Katar_','Katar',5,41000,NULL,1200,148,NULL,1,2,0x00001000,7,2,34,3,33,1,16,'bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1254,'Jamadhar','Jamadhar',5,37200,NULL,1500,165,NULL,1,0,0x00001000,7,2,34,3,33,1,16,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1255,'Jamadhar_','Jamadhar',5,37200,NULL,1500,165,NULL,1,1,0x00001000,7,2,34,3,33,1,16,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1256,'Katar_Of_Cold_Icicle','Katar of Frozen Icicle',5,45000,NULL,1200,105,NULL,1,0,0x00001000,7,2,34,3,55,1,16,'bonus bAtkEle,Ele_Water; bonus2 bAddEff,Eff_Freeze,500;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1257,'Katar_Of_Thornbush','Katar of Quaking',5,45000,NULL,1200,105,NULL,1,0,0x00001000,7,2,34,3,55,1,16,'bonus bAtkEle,Ele_Earth; bonus2 bAddEff,Eff_Blind,500;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1258,'Katar_Of_Raging_Blaze','Katar of Raging Blaze',5,45000,NULL,1200,105,NULL,1,0,0x00001000,7,2,34,3,55,1,16,'bonus bAtkEle,Ele_Fire; bonus2 bAddEff,Eff_Silence,500;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1259,'Katar_Of_Piercing_Wind','Katar of Piercing Wind',5,45000,NULL,1200,105,NULL,1,0,0x00001000,7,2,34,3,55,1,16,'bonus bAtkEle,Ele_Wind; bonus2 bAddEff,Eff_Sleep,500;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1260,'Ghoul_Leg','Sharpened Legbone of Ghoul',5,52500,NULL,1700,150,NULL,1,0,0x00001000,7,2,34,3,65,1,16,'bonus bAtkEle,Ele_Undead;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1261,'Infiltrator','Infiltrator',5,57000,NULL,1500,140,NULL,1,0,0x00001000,7,2,34,4,75,1,16,'bonus2 bAddRace,RC_DemiHuman,50; bonus2 bAddRace,RC_Player,50; bonus bDef,3; bonus bFlee,5; bonus bFlee2,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1262,'Nail_Of_Loki','Loki\'s Nail',5,20,NULL,1200,115,NULL,1,0,0x00001000,7,2,34,3,55,1,16,'bonus2 bAddEff,Eff_Bleeding,300;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1263,'Unholy_Touch','Unholy Touch',5,20,NULL,1250,151,NULL,1,0,0x00001000,7,2,34,4,70,1,16,'bonus bAtkEle,Ele_Dark; bonus2 bAddEff,Eff_Curse,200; bonus bCritical,-1; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1264,'Various_Jur','Specialty Jur',5,20,NULL,800,90,NULL,1,4,0x00001000,7,2,34,1,1,1,16,'bonus2 bAddEff2,Eff_Bleeding,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1265,'Bloody_Roar','Bloody Roar',5,20,NULL,1000,120,NULL,1,0,0x00001000,7,2,34,4,75,1,16,'bonus bIgnoreDefRace,RC_DemiHuman; bonus bIgnoreDefRace,RC_Player; bonus bFlee,-(readparam(bAgi)+BaseLevel); bonus bHPrecovRate,-100; bonus bSPrecovRate,-100;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1266,'Infiltrator_','Infiltrator',5,57000,NULL,1500,140,NULL,1,1,0x00001000,7,2,34,4,75,1,16,'bonus2 bAddRace,RC_DemiHuman,50; bonus2 bAddRace,RC_Player,50; bonus bDef,3; bonus bFlee,5; bonus bFlee2,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1267,'Infiltrator_C','Infiltrator',5,1,NULL,0,189,NULL,1,0,0x00001000,7,2,34,4,1,0,16,'bonus2 bAddRace,RC_DemiHuman,70; bonus2 bAddRace,RC_Player,70; bonus bDef,3; bonus bFlee,5; bonus bFlee2,2; bonus bAspdRate,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1268,'Wild_Beast_Claw','Wild Beast Claw',5,20,NULL,1450,160,NULL,1,1,0x00001000,2,2,34,4,55,1,16,'if(getrefine()>=9){ bonus3 bAutoSpell,"NPC_CRITICALWOUND",2,100; } else bonus3 bAutoSpell,"NPC_CRITICALWOUND",1,100;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1269,'Inverse_Scale','Inverse Scale',5,20,NULL,1500,140,NULL,1,0,0x00001000,2,2,34,4,55,1,16,'bonus bAtkEle,Ele_Holy; bonus3 bAutoSpell,"NPC_DRAGONFEAR",1,30;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1270,'Drill_Katar','Drill Katar',5,20,NULL,1400,110,NULL,1,1,0x00001000,2,2,34,4,55,1,16,'bonus bHit,30; bonus3 bAutoSpell,"ST_FULLSTRIP",1,150;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1271,'Blood_Tears','Blood Tears',5,20,NULL,1700,120,NULL,1,2,0x00001000,2,2,34,4,55,1,16,'if(getrefine()>=9){ bonus3 bAutoSpell,"NPC_WIDEBLEEDING",2,30; } else bonus3 bAutoSpell,"NPC_WIDEBLEEDING",1,30;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1272,'Scratcher','Scratcher',5,20,NULL,0,120,NULL,1,0,0x00001000,7,2,34,1,0,0,16,'bonus2 bAddClass,Class_All,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1273,'Bloody_Roar_C','Refined Bloody Roar',5,1,NULL,0,148,NULL,1,0,0x00001000,7,2,34,4,0,0,16,'bonus bIgnoreDefRace,RC_DemiHuman; bonus bIgnoreDefRace,RC_Player; bonus2 bHPRegenRate,3,5000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1274,'Unholy_Touch_C','Refined Unholy Touch',5,1,NULL,0,179,NULL,1,0,0x00001000,7,2,34,4,0,0,16,'bonus bAtkEle,Ele_Dark; bonus2 bAddEff,Eff_Curse,5000; bonus bCritical,-1; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1275,'Katar_Of_Cold_Icicle_','Katar of Frozen Icicle',5,45000,NULL,1200,105,NULL,1,3,0x00001000,7,2,34,3,55,1,16,'bonus bAtkEle,Ele_Water; bonus2 bAddEff,Eff_Freeze,500;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1276,'Katar_Of_Thornbush_','Katar of Quaking',5,45000,NULL,1200,105,NULL,1,3,0x00001000,7,2,34,3,55,1,16,'bonus bAtkEle,Ele_Earth; bonus2 bAddEff,Eff_Blind,500;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1277,'Katar_Of_Raging_Blaze_','Katar of Raging Blaze',5,45000,NULL,1200,105,NULL,1,3,0x00001000,7,2,34,3,55,1,16,'bonus bAtkEle,Ele_Fire; bonus2 bAddEff,Eff_Silence,500;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1278,'Katar_Of_Piercing_Wind_','Katar of Piercing Wind',5,45000,NULL,1200,105,NULL,1,3,0x00001000,7,2,34,3,55,1,16,'bonus bAtkEle,Ele_Wind; bonus2 bAddEff,Eff_Sleep,500;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1279,'BF_Katar1','Brave Carnage Katar',5,20,NULL,0,130,NULL,1,0,0x00001000,7,2,34,3,80,1,16,'bonus bStr,1; bonus bDex,1; bonus bLuk,1; bonus2 bAddRace,RC_DemiHuman,70; bonus2 bAddRace,RC_Player,70; bonus2 bIgnoreDefRaceRate,RC_DemiHuman,20; bonus2 bIgnoreDefRaceRate,RC_Player,20; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1280,'BF_Katar2','Valorous Carnage Katar',5,20,NULL,0,130,NULL,1,0,0x00001000,7,2,34,3,80,1,16,'bonus bStr,1; bonus bDex,1; bonus bLuk,1; bonus2 bAddRace,RC_DemiHuman,70; bonus2 bAddRace,RC_Player,70; bonus bCritAtkRate,20; bonus bAspdRate,5; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1281,'Krieger_Katar1','Glorious Bloody Roar',5,20,NULL,0,140,NULL,1,0,0x00001000,7,2,34,4,80,1,16,'bonus2 bAddRace,RC_DemiHuman,70; bonus2 bAddRace,RC_Player,70; bonus2 bIgnoreDefRaceRate,RC_DemiHuman,20; bonus2 bIgnoreDefRaceRate,RC_Player,20; bonus bUnbreakableWeapon; if(getrefine()>5) { bonus2 bAddRace,RC_DemiHuman,(getrefine()-4)*(getrefine()-4); bonus2 bAddRace,RC_Player,(getrefine()-4)*(getrefine()-4); bonus2 bIgnoreDefRaceRate,RC_DemiHuman,5; bonus2 bIgnoreDefRaceRate,RC_Player,5; } if(getrefine()>8) autobonus "{ bonus bAspdRate,100; }",70,3000,BF_WEAPON,"{ specialeffect2 EF_POTION_BERSERK; }";',NULL,NULL);
REPLACE INTO `item_db` VALUES (1282,'Krieger_Katar2','Glorious Jamadhar',5,20,NULL,0,140,NULL,1,0,0x00001000,7,2,34,4,80,1,16,'bonus2 bAddRace,RC_DemiHuman,70; bonus2 bAddRace,RC_Player,70; bonus2 bIgnoreDefRaceRate,RC_DemiHuman,20; bonus2 bIgnoreDefRaceRate,RC_Player,20; bonus bUnbreakableWeapon; if(getrefine()>5) { bonus2 bAddRace,RC_DemiHuman,(getrefine()-4)*(getrefine()-4); bonus2 bAddRace,RC_Player,(getrefine()-4)*(getrefine()-4); bonus2 bCriticalAddRace,RC_DemiHuman,5; bonus2 bCriticalAddRace,RC_Player,5; } if(getrefine()>8) autobonus "{ bonus bAspdRate,100; }",70,3000,BF_WEAPON,"{ specialeffect2 EF_POTION_BERSERK; }";',NULL,NULL);
REPLACE INTO `item_db` VALUES (1283,'Katar_Of_Speed','Katar Of Speed',5,20,NULL,0,175,NULL,1,0,0x00001000,7,2,34,4,0,0,16,'bonus2 bSkillAtk,"AS_SONICBLOW",25; bonus bAspdRate,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1284,'Krishna','Krishna',5,20,NULL,1200,120,NULL,1,2,0x00001000,2,2,34,3,50,1,16,'bonus2 bSkillAtk,"AS_GRIMTOOTH",10; if(getskilllv("AS_SONICBLOW")) { bonus3 bAutoSpell,"AS_SONICBLOW",getskilllv("AS_SONICBLOW"),5; }else{ bonus3 bAutoSpell,"AS_SONICBLOW",1,5; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (1285,'Cakram','Chakram',5,20,NULL,1000,130,NULL,1,2,0x00001000,2,2,34,3,50,1,16,'if(getskilllv("AS_KATAR")==10) { bonus bHit,10; } bonus2 bSkillAtk,"ASC_METEORASSAULT",20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1286,'Jamadhar_C','Jamadhar',5,0,NULL,0,200,NULL,1,0,0x00001000,7,2,34,3,1,0,16,'bonus bUnbreakableWeapon; bonus2 bAddSize,Size_All,40;',NULL,NULL);
# 1-Handed Axes
REPLACE INTO `item_db` VALUES (1301,'Axe','Axe',5,500,NULL,800,38,NULL,1,3,0x000654E3,7,2,2,1,3,1,6,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1302,'Axe_','Axe',5,500,NULL,800,38,NULL,1,4,0x000654E3,7,2,2,1,3,1,6,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1303,'Axe__','Axe',5,500,NULL,800,38,NULL,1,0,0x000654E3,7,2,2,1,3,1,6,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1304,'Orcish_Axe','Orcish Axe',5,20,NULL,1500,75,NULL,1,0,0x000654E3,7,2,2,3,3,1,6,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1305,'Cleaver','Cleaver',5,20,NULL,1200,140,NULL,1,0,0x000444A2,7,2,2,4,44,1,6,'bonus2 bSubRace,RC_DemiHuman,5; bonus2 bSubRace,RC_Player,5; bonus3 bAddMonsterDropItem,517,RC_Brute,3000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1306,'War_Axe','War Axe',5,20,NULL,4200,140,NULL,1,1,0x00040400,7,2,2,3,76,1,6,'bonus bDex,2; bonus bLuk,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1307,'Windhawk','Windhawk',5,18000,NULL,1500,115,NULL,1,0,0x000654E2,7,2,2,2,14,1,6,'bonus bAtkEle,Ele_Wind; bonus bAspdRate,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1308,'Golden_Axe','Golden Axe',5,20,NULL,3000,170,NULL,1,0,0x00000001,7,2,2,4,45,1,6,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1309,'Orcish_Axe_','Orcish Axe',5,20,NULL,1500,75,NULL,1,4,0x000654E3,7,2,2,3,3,1,6,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1310,'Krieger_Onehand_Axe1','Glorious Cleaver',5,20,NULL,0,130,NULL,1,0,0x000444A2,7,2,2,4,80,1,6,'bonus2 bAddRace,RC_DemiHuman,75; bonus2 bAddRace,RC_Player,75; bonus2 bIgnoreDefRaceRate,RC_DemiHuman,20; bonus2 bIgnoreDefRaceRate,RC_Player,20; bonus bUnbreakableWeapon; if(getrefine()>5) { bonus2 bAddRace,RC_DemiHuman,(getrefine()-4)*(getrefine()-4); bonus2 bAddRace,RC_Player,(getrefine()-4)*(getrefine()-4); bonus2 bIgnoreDefRaceRate,RC_DemiHuman,5; bonus2 bIgnoreDefRaceRate,RC_Player,5; bonus bAspdRate,5; } if(getrefine()>8) { bonus bAspdRate,5; bonus3 bAutoSpell,"NPC_CRITICALWOUND",1,50; bonus4 bAutoSpellOnSkill,"MC_MAMMONITE","NPC_CRITICALWOUND",2,200; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (1311,'Vecer_Axe','Vecer Axe',5,20,NULL,1500,140,NULL,1,2,0x000444A2,2,2,2,3,50,1,6,'if(readparam(bLuk)>=90) { bonus bBaseAtk,20; } if(readparam(bDex)>=90) { bonus bCritical,5; } if(readparam(bDex)>=90||readparam(bLuk)>=90) { bonus2 bSkillAtk,"MC_MAMMONITE",15; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (1312,'Orcish_Axe_C','Orcish Axe',5,0,NULL,0,110,NULL,1,0,0x000654E3,7,2,2,3,1,0,6,'bonus2 bAddSize,Size_All,70;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1313,'Tourist_Axe','Tourist Axe',5,0,NULL,500,77,NULL,1,0,0x000654E3,7,2,2,1,1,0,6,'bonus bStr,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1314,'F_Tomahawk_C','Tomahawk',5,2,NULL,0,200,NULL,1,0,0x000444A2,7,2,34,4,0,0,7,'bonus bAtkEle,Ele_Wind;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1315,'F_Right_Epsilon_C','Light Epsilon',5,1,NULL,0,229,NULL,1,0,0x000444A2,7,2,34,4,1,0,7,'bonus bAtkEle,Ele_Holy; bonus bStr,10;',NULL,NULL);
# 2-Handed Axes
REPLACE INTO `item_db` VALUES (1351,'Battle_Axe','Battle Axe',5,5400,NULL,1500,80,NULL,1,3,0x000444A2,7,2,34,1,3,1,7,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1352,'Battle_Axe_','Battle Axe',5,5400,NULL,1500,80,NULL,1,4,0x000444A2,7,2,34,1,3,1,7,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1353,'Battle_Axe__','Battle Axe',5,5400,NULL,1500,80,NULL,1,0,0x000444A2,7,2,34,1,3,1,7,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1354,'Hammer','Hammer',5,15500,NULL,2000,120,NULL,1,2,0x000444A2,7,2,34,2,16,1,7,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1355,'Hammer_','Hammer',5,15500,NULL,2000,120,NULL,1,3,0x000444A2,7,2,34,2,16,1,7,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1356,'Hammer__','Hammer',5,15500,NULL,2000,120,NULL,1,0,0x000444A2,7,2,34,2,16,1,7,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1357,'Buster','Buster',5,34000,NULL,2200,155,NULL,1,1,0x000444A2,7,2,34,3,30,1,7,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1358,'Buster_','Buster',5,34000,NULL,2200,155,NULL,1,2,0x000444A2,7,2,34,3,30,1,7,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1359,'Buster__','Buster',5,34000,NULL,2200,155,NULL,1,0,0x000444A2,7,2,34,3,30,1,7,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1360,'Two_Handed_Axe','Two-Handed Axe',5,55000,NULL,2500,185,NULL,1,1,0x000444A2,7,2,34,3,30,1,7,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1361,'Two_Handed_Axe_','Two-Handed Axe',5,55000,NULL,2500,185,NULL,1,2,0x000444A2,7,2,34,3,30,1,7,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1362,'Two_Handed_Axe__','Two-Handed Axe',5,55000,NULL,2500,185,NULL,1,0,0x000444A2,7,2,34,3,30,1,7,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1363,'Brood_Axe','Bloody Axe',5,20,NULL,4000,170,NULL,1,0,0x000444A2,7,2,34,4,44,1,7,'bonus bStr,10; bonus bSpeedRate,25;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1364,'Great_Axe','Great Axe',5,20,NULL,1800,187,NULL,1,0,0x000444A2,7,2,34,4,44,1,7,'bonus2 bAddSkillBlow,"MC_MAMMONITE",5; bonus2 bAddEff,Eff_Stun,1500;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1365,'Sabbath','Sabbath',5,20,NULL,2300,120,NULL,1,0,0x000444A2,7,2,34,4,44,1,7,'bonus bAtkEle,Ele_Dark; bonus2 bComaRace,RC_Demon,50; bonus2 bCriticalAddRace,RC_Undead,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1366,'Right_Epsilon','Light Epsilon',5,20,NULL,2300,180,NULL,1,0,0x000444A2,7,2,34,4,44,1,7,'bonus bAtkEle,Ele_Holy; skill "AL_HEAL",3; bonus2 bAddRace,RC_Demon,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1367,'Slaughter','Slaughter',5,20,NULL,2500,120,NULL,1,0,0x000444A2,7,2,34,4,44,1,7,'bonus bAtkEle,Ele_Earth; bonus bIgnoreDefRace,RC_Brute; bonus2 bComaRace,RC_Brute,40;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1368,'Tomahawk','Tomahawk',5,20,NULL,2500,165,NULL,1,0,0x000444A2,7,2,34,4,44,1,7,'bonus bAtkEle,Ele_Wind; skill "ITM_TOMAHAWK",1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1369,'Guillotine','Guillotine',5,20,NULL,3000,215,NULL,1,0,0x000444A2,7,2,34,4,44,1,7,'bonus2 bComaRace,RC_DemiHuman,30; bonus2 bComaRace,RC_Player,30; bonus2 bSPDrainValueRace,RC_DemiHuman,2; bonus2 bSPDrainValueRace,RC_Player,2; bonus2 bSPGainRace,RC_DemiHuman,20; bonus2 bSPGainRace,RC_Player,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1370,'Doom_Slayer','Doom Slayer',5,20,NULL,6000,10,NULL,1,0,0x000444A2,7,2,34,4,80,1,7,'bonus bAspdRate,-40; bonus bUseSPrate,100; if(readparam(bStr)>=95){ bonus bBaseAtk,340; bonus2 bAddEff,Eff_Stun,3000; bonus bBreakArmorRate,500; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (1371,'Doom_Slayer_','Doom Slayer',5,20,NULL,6000,10,NULL,1,1,0x000444A2,7,2,34,4,80,1,7,'bonus bAspdRate,-40; bonus bUseSPrate,100; if(readparam(bStr)>=95){ bonus bBaseAtk,340; bonus2 bAddEff,Eff_Stun,3000; bonus bBreakArmorRate,500; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (1372,'Right_Epsilon_C','Light Epsilon',5,1,NULL,0,229,NULL,1,0,0x000444A2,7,2,34,4,1,0,7,'bonus bAtkEle,Ele_Holy; skill "AL_HEAL",3; bonus2 bAddRace,RC_Demon,3; bonus bStr,10; bonus bSpeedRate,25;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1373,'Brood_Axe_C','Refined Bloody Axe',5,2,NULL,0,205,NULL,1,0,0x000444A2,7,2,34,4,0,0,7,'bonus bStr,20; bonus bSpeedRate,25; bonus bAspdRate,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1374,'Tomahawk_C','Tomahawk',5,2,NULL,0,200,NULL,1,0,0x000444A2,7,2,34,4,0,0,7,'bonus bAtkEle,Ele_Wind; skill "ITM_TOMAHAWK",1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1375,'Berdysz','Berdysz',5,20,NULL,2500,200,NULL,1,2,0x000444A2,2,2,34,3,70,1,7,'bonus2 bSubSize,Size_Medium,13; bonus2 bSubSize,Size_Large,15;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1376,'Heart_Breaker','Heart Breaker',5,20,NULL,2000,175,NULL,1,1,0x000444A2,2,2,34,4,70,1,7,'bonus bCritical,20+getrefine(); bonus bAspdRate,5; if((Class==Job_Whitesmith)||(Class==Job_Creator)) bonus3 bAutoSpell,"BS_HAMMERFALL",3,30;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1377,'Hurricane_Fury','Hurricane\'s Fury',5,20,NULL,3500,332,NULL,1,1,0x000444A2,2,2,34,4,80,1,7,'bonus2 bSubSize,Size_Medium,10+getrefine(); bonus bAspdRate,getrefine(); bonus3 bAutoSpell,"NPC_PULSESTRIKE",5,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1378,'Great_Axe_C','Refined Great Axe',5,1,NULL,0,215,NULL,1,0,0x000444A2,7,2,34,4,0,0,7,'bonus bStr,5; bonus bHit,20; bonus2 bAddSkillBlow,"MC_MAMMONITE",5; bonus2 bAddEff,Eff_Stun,2000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1379,'BF_Two_Handed_Axe1','Valorous Insane Battle Axe',5,20,NULL,0,200,NULL,1,0,0x000444A2,7,2,34,3,80,1,7,'bonus bStr,3; bonus2 bAddRace,RC_DemiHuman,55; bonus2 bAddRace,RC_Player,55; bonus2 bIgnoreDefRaceRate,RC_DemiHuman,20; bonus2 bIgnoreDefRaceRate,RC_Player,20; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1380,'BF_Two_Handed_Axe2','Brave Insane Battle Axe',5,20,NULL,0,200,NULL,1,0,0x000444A2,7,2,34,3,80,1,7,'bonus bStr,3; bonus2 bAddRace,RC_DemiHuman,55; bonus2 bAddRace,RC_Player,55; autobonus "{ bonus bBreakArmorRate,10000; }",20,3000,BF_WEAPON,"{ specialeffect2 EF_POTION_BERSERK; }"; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1381,'N_Battle_Axe','Novice Battle Axe',5,0,NULL,0,100,NULL,1,3,0x000444A2,7,2,34,1,3,0,7,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1382,'Krieger_Twohand_Axe1','Glorious Two-Handed Axe',5,20,NULL,0,220,NULL,1,0,0x000444A2,7,2,34,4,80,1,7,'bonus2 bAddRace,RC_DemiHuman,70; bonus2 bAddRace,RC_Player,70; bonus2 bIgnoreDefRaceRate,RC_DemiHuman,25; bonus2 bIgnoreDefRaceRate,RC_Player,25; bonus bUnbreakableWeapon; if(getrefine()>5) { bonus2 bAddRace,RC_DemiHuman,(getrefine()-3)*(getrefine()-3); bonus2 bAddRace,RC_Player,(getrefine()-3)*(getrefine()-3); bonus2 bIgnoreDefRaceRate,RC_DemiHuman,5; bonus2 bIgnoreDefRaceRate,RC_Player,5; bonus3 bAutoSpell,"NPC_CRITICALWOUND",1,50; } if(getrefine()>8) { bonus3 bAutoSpell,"NPC_CRITICALWOUND",1,100; bonus4 bAutoSpellOnSkill,"MC_MAMMONITE","NPC_CRITICALWOUND",2,200; bonus4 bAutoSpellOnSkill,"WS_CARTTERMINATION","NPC_CRITICALWOUND",2,200; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (1383,'Holy_Celestial_Axe','Celestial Axe',5,20,NULL,1500,200,NULL,1,0,0x000444A2,7,2,34,4,60,1,7,'bonus bAtkEle,Ele_Holy; bonus bVit,10; bonus2 bAddRace,RC_Undead,10; bonus3 bAutoSpell,"AL_BLESSING",5,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1384,'Veteran_Axe','Veteran Axe',5,10000,NULL,3000,250,NULL,1,2,0x000444A2,7,2,34,3,80,1,7,'if(getskilllv("BS_DAGGER")==3) { bonus bBaseAtk,10; } if(getskilllv("BS_SWORD")==3) { bonus bBaseAtk,10; } if(getskilllv("BS_TWOHANDSWORD")==3) { bonus bBaseAtk,10; } if(getskilllv("BS_KNUCKLE")==3) { bonus bBaseAtk,10; } if(getskilllv("BS_SPEAR")==3) { bonus bBaseAtk,10; } if(getskilllv("BS_AXE")==3) { bonus bBaseAtk,10; } if(getskilllv("BS_MACE")==3) { bonus bBaseAtk,10; } bonus bVit,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1385,'Bradium_Stonehammer','Bradium Stone Hammer',5,20,NULL,2700,210,NULL,1,0,0x000444A2,2,2,34,4,75,1,7,'bonus3 bAddEffOnSkill,"BS_HAMMERFALL",Eff_Stun,500+(200*getrefine());',NULL,NULL);
REPLACE INTO `item_db` VALUES (1386,'Doom_Slayer_I','Doom Slayer',5,0,NULL,0,20,NULL,1,0,0x000444A2,7,2,34,4,0,0,7,'if(readparam(bStr)>=95){ bonus bBaseAtk,400; bonus2 bAddEff,Eff_Stun,3000; bonus bAspdRate,-25; bonus bUseSPrate,100; bonus bBreakArmorRate,500; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (1387,'Giant_Axe','Giant Axe',5,20,NULL,4000,330,NULL,1,1,0x000444A2,2,2,34,3,50,1,7,'bonus2 bSkillAtk,"WS_CARTTERMINATION",15; if(readparam(bStr)>=95) { bonus bHit,10; bonus bAspdRate,3; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (1388,'Two_Handed_Axe_C','Two-Handed Axe',5,0,NULL,0,220,NULL,1,0,0x000444A2,7,2,34,3,1,0,7,'bonus2 bAddSize,Size_All,40;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1389,'E_Tomahawk_C','Tomahawk',5,2,NULL,0,200,NULL,1,0,0x000444A2,7,2,34,4,0,0,7,'bonus bAtkEle,Ele_Wind;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1390,'E_Right_Epsilon_C','Light Epsilon',5,1,NULL,0,229,NULL,1,0,0x000444A2,7,2,34,4,1,0,7,'bonus bAtkEle,Ele_Holy; bonus bStr,10;',NULL,NULL);
# 1-Handed Spears
REPLACE INTO `item_db` VALUES (1401,'Javelin','Javelin',5,150,NULL,700,28,NULL,3,3,0x00004082,7,2,2,1,4,1,4,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1402,'Javelin_','Javelin',5,150,NULL,700,28,NULL,3,4,0x00004082,7,2,2,1,4,1,4,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1403,'Javelin__','Javelin',5,150,NULL,700,28,NULL,3,0,0x00004082,7,2,2,1,4,1,4,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1404,'Spear','Spear',5,1700,NULL,850,44,NULL,3,3,0x00004082,7,2,2,1,4,1,4,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1405,'Spear_','Spear',5,1700,NULL,850,44,NULL,3,4,0x00004082,7,2,2,1,4,1,4,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1406,'Spear__','Spear',5,1700,NULL,850,44,NULL,3,0,0x00004082,7,2,2,1,4,1,4,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1407,'Pike','Pike',5,3450,NULL,1000,60,NULL,3,3,0x00004082,7,2,2,1,4,1,4,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1408,'Pike_','Pike',5,3450,NULL,1000,60,NULL,3,4,0x00004082,7,2,2,1,4,1,4,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1409,'Pike__','Pike',5,3450,NULL,1000,60,NULL,3,0,0x00004082,7,2,2,1,4,1,4,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1410,'Lance','Lance',5,60000,NULL,2500,185,NULL,3,0,0x00004082,7,2,34,3,33,1,5,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1411,'Lance_','Lance',5,60000,NULL,2500,185,NULL,3,0,0x00004082,7,2,34,3,33,1,5,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1412,'Lance__','Lance',5,60000,NULL,2500,185,NULL,3,0,0x00004082,7,2,34,3,33,1,5,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1413,'Gungnir','Gungnir',5,20,NULL,500,120,NULL,3,0,0x00004082,7,2,2,4,4,1,4,'bonus bAtkEle,Ele_Wind; bonus bPerfectHitRate,25; bonus bHit,30;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1414,'Gelerdria','Gelerdria',5,20,NULL,700,145,NULL,3,0,0x00004082,7,2,2,4,48,1,4,'bonus bAtkEle,Ele_Earth; bonus bMaxHP,800; bonus bMaxSP,-50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1415,'Skewer','Brocca',5,20,NULL,850,100,NULL,3,0,0x00004082,7,2,2,4,48,1,4,'bonus bIgnoreDefClass,Class_Normal; bonus2 bAddEle,Ele_Neutral,25;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1416,'Tjungkuletti','Tjungkuletti',5,20,NULL,1000,95,NULL,3,0,0x00004082,7,2,2,4,48,1,4,'bonus bSPDrainValue,1; bonus bSPGainValue,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1417,'Pole_Axe','Pole Axe',5,20,NULL,3800,160,NULL,3,1,0x00004082,7,2,2,3,71,1,4,'bonus bStr,1; bonus bInt,2; bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1418,'Gungnir_','Gungnir',5,20,NULL,500,120,NULL,3,2,0x00004082,7,2,2,4,4,1,4,'bonus bAtkEle,Ele_Wind; bonus bPerfectHitRate,25; bonus bHit,30;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1419,'Pole_Axe_C','Pole Axe',5,1,NULL,4800,159,NULL,3,0,0x00004082,7,2,2,3,1,0,4,'bonus bStr,1; bonus bInt,2; bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1420,'Long_Horn','Long Horn',5,20,NULL,1000,150,NULL,3,1,0x00004082,2,2,2,4,65,1,4,'bonus bAtkEle,Ele_Holy; bonus2 bAddEff,Eff_Bleeding,500; skill "TF_DETOXIFY",1; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1421,'Battle_Hook','Battle Hook',5,20,NULL,900,140,NULL,3,1,0x00004082,2,2,2,4,65,1,4,'bonus2 bAddEff,Eff_Stun,500; bonus2 bAddRace,RC_DemiHuman,20; bonus2 bAddRace,RC_Player,20; skill "KN_PIERCE",3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1422,'Hunting_Spear','Hunting Spear',5,20,NULL,4200,180,NULL,3,1,0x00004082,2,2,2,4,60,1,4,'bonus bIgnoreDefRace,RC_Brute; bonus3 bAddMonsterDropItem,517,RC_Brute,1000; bonus3 bAutoSpell,"LK_JOINTBEAT",3,100;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1423,'Pole_XO','Pole XO',5,20,NULL,0,120,NULL,3,0,0x00004082,7,2,2,1,0,0,4,'bonus2 bAddClass,Class_All,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1424,'Skewer_C','Refined Brocca',5,1,NULL,0,149,NULL,3,0,0x00004082,7,2,2,4,0,0,4,'bonus bIgnoreDefClass,Class_Normal; bonus2 bAddSize,Size_Medium,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1425,'BF_Spear1','Assaulter Spear',5,20,NULL,0,60,NULL,3,0,0x00004082,7,2,2,3,80,1,4,'bonus bStr,2; bonus2 bAddRace,RC_DemiHuman,95; bonus2 bAddRace,RC_Player,95; bonus2 bIgnoreDefRaceRate,RC_DemiHuman,20; bonus2 bIgnoreDefRaceRate,RC_Player,20; bonus bUnbreakableWeapon; if(BaseJob==Job_Crusader) bonus bAspdRate,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1426,'Krieger_Onehand_Spear1','Glorious Spear',5,20,NULL,0,130,NULL,3,0,0x00004082,7,2,2,4,80,1,4,'bonus2 bAddRace,RC_DemiHuman,95; bonus2 bAddRace,RC_Player,95; bonus2 bIgnoreDefRaceRate,RC_DemiHuman,20; bonus2 bIgnoreDefRaceRate,RC_Player,20; bonus bUnbreakableWeapon; if(getrefine()>5) { bonus2 bAddRace,RC_DemiHuman,(getrefine()-4)*(getrefine()-4); bonus2 bAddRace,RC_Player,(getrefine()-4)*(getrefine()-4); bonus2 bIgnoreDefRaceRate,RC_DemiHuman,5; bonus2 bIgnoreDefRaceRate,RC_Player,5; bonus bAspdRate,10; } if(getrefine()>8) { if(BaseJob==Job_Knight) bonus4 bAutoSpellOnSkill,"KN_PIERCE","NPC_CRITICALWOUND",2,200; else if(BaseJob==Job_Crusader) bonus3 bAutoSpell,"PA_PRESSURE",5,100; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (1427,'Spear_Of_Excellent','Spear Of Excellent',5,20,NULL,0,160,NULL,3,0,0x00004082,7,2,2,3,0,0,4,'bonus2 bSkillAtk,"SM_MAGNUM",25; bonus bStr,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1428,'Long_Horn_M','Long Horn',5,20,NULL,1000,150,NULL,3,1,0x00004082,2,2,2,4,65,1,4,'bonus bAtkEle,Ele_Holy; bonus2 bAddEff,Eff_Bleeding,500; skill "TF_DETOXIFY",1; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1429,'Hunting_Spear_M','Hunting Spear',5,20,NULL,4200,180,NULL,3,1,0x00004082,2,2,2,4,60,1,4,'bonus bIgnoreDefRace,RC_Brute; bonus3 bAddMonsterDropItem,517,RC_Brute,1000; bonus3 bAutoSpell,"LK_JOINTBEAT",3,500;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1430,'Pike_C','Pike',5,0,NULL,0,74,NULL,3,0,0x00004082,7,2,2,1,1,0,4,'bonus2 bAddSize,Size_All,70;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1431,'F_Pole_Axe_C','Pole Axe',5,1,NULL,4800,195,NULL,3,0,0x00004082,7,2,2,3,1,0,4,'bonus bStr,1; bonus bInt,2; bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1432,'E_Pole_Axe_C','Pole Axe',5,1,NULL,4800,195,NULL,3,0,0x00004082,7,2,2,3,1,0,4,'bonus bStr,1; bonus bInt,2; bonus bDex,1;',NULL,NULL);
# 2-Handed Spears
REPLACE INTO `item_db` VALUES (1451,'Guisarme','Guisarme',5,13000,NULL,1000,84,NULL,3,2,0x00004082,7,2,34,2,18,1,5,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1452,'Guisarme_','Guisarme',5,13000,NULL,1000,84,NULL,3,3,0x00004082,7,2,34,2,18,1,5,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1453,'Guisarme__','Guisarme',5,13000,NULL,1000,84,NULL,3,0,0x00004082,7,2,34,2,18,1,5,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1454,'Glaive','Glaive',5,20000,NULL,1200,104,NULL,3,2,0x00004082,7,2,34,2,18,1,5,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1455,'Glaive_','Glaive',5,20000,NULL,1200,104,NULL,3,3,0x00004082,7,2,34,2,18,1,5,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1456,'Glaive__','Glaive',5,20000,NULL,1200,104,NULL,3,0,0x00004082,7,2,34,2,18,1,5,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1457,'Partizan','Partizan',5,27000,NULL,2000,124,NULL,3,1,0x00004082,7,2,34,2,18,1,5,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1458,'Partizan_','Partizan',5,27000,NULL,2000,124,NULL,3,2,0x00004082,7,2,34,2,18,1,5,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1459,'Partizan__','Partizan',5,27000,NULL,2000,124,NULL,3,0,0x00004082,7,2,34,2,18,1,5,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1460,'Trident','Trident',5,51000,NULL,1200,150,NULL,3,2,0x00004082,7,2,34,3,33,1,5,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1461,'Trident_','Trident',5,51000,NULL,1200,150,NULL,3,3,0x00004082,7,2,34,3,33,1,5,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1462,'Trident__','Trident',5,51000,NULL,1200,150,NULL,3,0,0x00004082,7,2,34,3,33,1,5,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1463,'Halberd','Halberd',5,54000,NULL,2500,165,NULL,3,1,0x00004082,7,2,34,3,33,1,5,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1464,'Halberd_','Halberd',5,54000,NULL,2500,165,NULL,3,2,0x00004082,7,2,34,3,33,1,5,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1465,'Halberd__','Halberd',5,54000,NULL,2500,165,NULL,3,0,0x00004082,7,2,34,3,33,1,5,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1466,'Crescent_Scythe','Crescent Scythe',5,20,NULL,2500,180,NULL,3,0,0x00004082,7,2,34,4,48,1,5,'bonus bCritical,30; bonus bHit,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1467,'Bill_Guisarme','Bill Guisarme',5,20,NULL,1000,183,NULL,3,0,0x00004082,7,2,34,4,48,1,5,'bonus2 bAddRace,RC_Brute,10; bonus2 bAddRace,RC_DemiHuman,5; bonus2 bAddRace,RC_Player,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1468,'Zephyrus','Zephyrus',5,20,NULL,2000,170,NULL,3,0,0x00004082,7,2,34,4,48,1,5,'bonus bAtkEle,Ele_Wind; bonus2 bAddEff,Eff_Silence,200; bonus3 bAutoSpell,"MG_THUNDERSTORM",3,100;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1469,'Longinus\'s_Spear','Longinus\'s Spear',5,20,NULL,2500,180,NULL,3,0,0x00004082,7,2,34,4,48,1,5,'bonus bAtkEle,Ele_Dark; bonus2 bAddRace,RC_DemiHuman,10; bonus2 bAddRace,RC_Player,10; bonus2 bAddRace,RC_Angel,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1470,'Brionac','Brionac',5,20,NULL,3000,190,NULL,3,0,0x00004082,7,2,34,4,48,1,5,'bonus bAtkEle,Ele_Holy; skill "AL_HEAL",5; bonus3 bAutoSpell,"MG_SOULSTRIKE",3,100; bonus2 bAddClass,Class_Boss,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1471,'Hell_Fire','Hellfire',5,20,NULL,3500,200,NULL,3,0,0x00004082,7,2,34,4,48,1,5,'bonus bAtkEle,Ele_Fire; bonus3 bAutoSpell,"MG_FIREBALL",3,100; bonus bStr,3;',NULL,NULL);
# 2-Handed Staffs
REPLACE INTO `item_db` VALUES (1472,'Staff_Of_Soul','Soul Staff',5,20,NULL,1400,25,NULL,1,0,0x00810204,7,2,34,3,73,1,10,'bonus bInt,5; bonus bAgi,2; bonus bMatkRate,15;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1473,'Wizardy_Staff','Wizardry Staff',5,20,NULL,2400,120,NULL,1,0,0x00810204,7,2,34,4,90,1,10,'bonus bInt,6; bonus bDex,2; bonus bMatkRate,15;',NULL,NULL);
# 2-Handed Spears
REPLACE INTO `item_db` VALUES (1474,'Gae_Bolg','Gae Bolg',5,20,NULL,2000,160,NULL,3,0,0x00004082,7,2,34,4,60,1,5,'bonus bIgnoreDefRace,RC_Dragon; bonus2 bAddClass,Class_Boss,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1475,'Horseback_Lance','Equestrian\'s Spear',5,20,NULL,3700,200,NULL,4,0,0x00004082,7,2,34,4,75,1,5,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1476,'Crescent_Scythe_','Crescent Scythe',5,20,NULL,2500,180,NULL,3,1,0x00004082,7,2,34,4,48,1,5,'bonus bCritical,30; bonus bHit,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1477,'Spectral_Spear','Spectral Spear',5,20,NULL,2000,170,NULL,3,0,0x00004082,7,2,34,4,75,1,5,'bonus2 bAddEle,Ele_Dark,20; bonus2 bAddRace,RC_Demon,20; bonus2 bAddRace,RC_Undead,20; bonus2 bSubEle,Ele_Dark,10; bonus2 bSubRace,RC_Demon,10; bonus2 bSubRace,RC_Undead,10; bonus2 bAddEff2,Eff_Confusion,1000; bonus bHPGainValue,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1478,'Ahlspiess','Ahlspiess',5,20,NULL,1000,120,NULL,3,0,0x00004080,7,2,34,4,65,1,5,'bonus bIgnoreDefClass,Class_Normal; bonus bIgnoreDefClass,Class_Boss; bonus2 bAddRace,RC_DemiHuman,10; bonus2 bAddRace,RC_Player,10; bonus3 bAutoSpell,"KN_PIERCE",5,30;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1479,'Spectral_Spear_','Spectral Spear',5,20,NULL,2000,170,NULL,3,1,0x00004082,7,2,34,4,75,1,5,'bonus2 bAddEle,Ele_Dark,20; bonus2 bAddRace,RC_Demon,20; bonus2 bAddRace,RC_Undead,20; bonus2 bSubEle,Ele_Dark,10; bonus2 bSubRace,RC_Demon,10; bonus2 bSubRace,RC_Undead,10; bonus2 bAddEff2,Eff_Confusion,1000; bonus bHPGainValue,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1480,'Gae_Bolg_','Gae Bolg',5,20,NULL,2000,160,NULL,3,2,0x00004082,7,2,34,4,60,1,5,'bonus bIgnoreDefRace,RC_Dragon; bonus2 bAddClass,Class_Boss,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1481,'Zephyrus_','Zephyrus',5,20,NULL,2000,170,NULL,3,3,0x00004082,7,2,34,4,48,1,5,'bonus bAtkEle,Ele_Wind; bonus2 bAddEff,Eff_Silence,200; bonus3 bAutoSpell,"MG_THUNDERSTORM",3,100;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1482,'BF_Lance1','Assaulter Lance',5,NULL,NULL,0,160,NULL,3,0,0x00004082,7,2,34,3,80,1,5,'bonus bStr,2; bonus2 bAddRace,RC_DemiHuman,25; bonus2 bAddRace,RC_Player,25; bonus bIgnoreDefRace,RC_DemiHuman; bonus bIgnoreDefRace,RC_Player; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1483,'Ivory_Lance','Ivory Lance',5,20,NULL,1000,160,NULL,3,1,0x00004082,2,2,34,3,50,1,5,'bonus bAgi,2; bonus bAspdRate,3; bonus2 bAddEff,Eff_Bleeding,300; bonus3 bAutoSpell,"NPC_CRITICALWOUND",1,30; skill "KN_SPEARSTAB",5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1484,'Cardo','Cardo',5,20,NULL,5600,150,NULL,3,1,0x00000080,2,2,34,4,70,1,5,'bonus bAspdRate,-10; bonus bDef,getrefine()/2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1485,'Battle_Fork','Battle Fork',5,20,NULL,700,112,NULL,3,4,0x00004082,2,2,34,2,50,1,5,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1486,'Krieger_Twohand_Spear1','Glorious Lance',5,20,NULL,0,220,NULL,3,0,0x00004082,7,2,34,4,80,1,5,'bonus2 bAddRace,RC_DemiHuman,70; bonus2 bAddRace,RC_Player,70; bonus2 bIgnoreDefRaceRate,RC_DemiHuman,25; bonus2 bIgnoreDefRaceRate,RC_Player,25; bonus bUnbreakableWeapon; if(getrefine()>5) { bonus2 bAddRace,RC_DemiHuman,(getrefine()-4)*(getrefine()-4); bonus2 bAddRace,RC_Player,(getrefine()-4)*(getrefine()-4); bonus2 bIgnoreDefRaceRate,RC_DemiHuman,5; bonus2 bIgnoreDefRaceRate,RC_Player,5; } if(getrefine()>8) { if(BaseJob==Job_Knight) bonus4 bAutoSpellOnSkill,"KN_PIERCE","NPC_CRITICALWOUND",2,200; else if(BaseJob==Job_Crusader) bonus3 bAutoSpell,"PA_PRESSURE",5,200; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (1487,'Lance_C','Lance',5,0,NULL,0,220,NULL,3,0,0x00004082,7,2,34,3,1,0,5,'bonus2 bAddSize,Size_All,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1488,'Ahlspiess_C','Ahlspiess',5,20,NULL,0,135,NULL,3,0,0x00004080,7,2,34,4,1,1,5,'bonus bIgnoreDefClass,Class_Normal; bonus bIgnoreDefClass,Class_Boss; bonus2 bAddRace,RC_DemiHuman,10; bonus2 bAddRace,RC_Player,10; bonus3 bAutoSpell,"KN_PIERCE",5,30;',NULL,NULL);
# Maces
REPLACE INTO `item_db` VALUES (1501,'Club','Club',5,120,NULL,700,23,NULL,1,3,0x0004C5B3,7,2,2,1,2,1,8,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1502,'Club_','Club',5,120,NULL,700,23,NULL,1,4,0x0004C5B3,7,2,2,1,2,1,8,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1503,'Club__','Club',5,120,NULL,700,23,NULL,1,0,0x0004C5B3,7,2,2,1,2,1,8,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1504,'Mace','Mace',5,1600,NULL,800,37,NULL,1,3,0x0004C5B3,7,2,2,1,2,1,8,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1505,'Mace_','Mace',5,1600,NULL,800,37,NULL,1,4,0x0004C5B3,7,2,2,1,2,1,8,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1506,'Mace__','Mace',5,1600,NULL,800,37,NULL,1,0,0x0004C5B3,7,2,2,1,2,1,8,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1507,'Smasher','Smasher',5,9000,NULL,1000,54,NULL,1,2,0x0004C5B3,7,2,2,2,14,1,8,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1508,'Smasher_','Smasher',5,9000,NULL,1000,54,NULL,1,3,0x0004C5B3,7,2,2,2,14,1,8,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1509,'Smasher__','Smasher',5,9000,NULL,1000,54,NULL,1,3,0x0004C5B3,7,2,2,2,14,1,8,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1510,'Flail','Flail',5,16000,NULL,900,69,NULL,1,2,0x0004C5B2,7,2,2,2,14,1,8,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1511,'Flail_','Flail',5,16000,NULL,900,69,NULL,1,3,0x0004C5B2,7,2,2,2,14,1,8,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1512,'Flail__','Flail',5,16000,NULL,900,69,NULL,1,3,0x0004C5B2,7,2,2,2,14,1,8,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1513,'Morning_Star','Morning Star',5,41000,NULL,1500,110,NULL,1,1,0x0004C5B2,7,2,2,3,27,1,8,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1514,'Morning_Star_','Morning Star',5,41000,NULL,1500,110,NULL,1,2,0x0004C5B2,7,2,2,3,27,1,8,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1515,'Morning_Star__','Morning Star',5,41000,NULL,1500,110,NULL,1,2,0x0004C5B2,7,2,2,3,27,1,8,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1516,'Sword_Mace','Sword Mace',5,50000,NULL,1200,130,NULL,1,0,0x0004C5B2,7,2,2,3,27,1,8,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1517,'Sword_Mace_','Sword Mace',5,50000,NULL,1200,130,NULL,1,1,0x0004C5B2,7,2,2,3,27,1,8,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1518,'Sword_Mace__','Sword Mace',5,50000,NULL,1200,130,NULL,1,1,0x0004C5B2,7,2,2,3,27,1,8,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1519,'Chain','Chain',5,23000,NULL,800,84,NULL,1,2,0x0004C5B2,7,2,2,2,14,1,8,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1520,'Chain_','Chain',5,23000,NULL,800,84,NULL,1,3,0x0004C5B2,7,2,2,2,14,1,8,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1521,'Chain__','Chain',5,23000,NULL,800,84,NULL,1,3,0x0004C5B2,7,2,2,2,14,1,8,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1522,'Stunner','Stunner',5,60000,NULL,2000,140,NULL,1,0,0x00008110,7,2,2,3,27,1,8,'bonus2 bAddEff,Eff_Stun,1000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1523,'Spike','Spike',5,20,NULL,700,85,NULL,1,0,0x00008110,7,2,2,4,40,1,8,'bonus bCritical,40; bonus bDefRate,-67; bonus bDef2Rate,-67;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1524,'Golden_Mace','Golden Mace',5,20,NULL,800,110,NULL,1,1,0x00008110,7,2,2,4,40,1,8,'bonus2 bAddRace,RC_Undead,10; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1525,'Long_Mace','Long Mace',5,20,NULL,800,135,NULL,3,0,0x00008110,7,2,2,4,40,1,8,'bonus bLongAtkDef,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1526,'Slash','Slash',5,20,NULL,1000,145,NULL,1,0,0x00008110,7,2,2,4,40,1,8,'bonus2 bAddRace,RC_Undead,15; bonus2 bComaRace,RC_Undead,10; bonus2 bExpAddRace,RC_Undead,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1527,'Quadrille','Quadrille',5,20,NULL,900,165,NULL,1,0,0x00008110,7,2,2,4,40,1,8,'bonus2 bAddRace,RC_Undead,10; bonus2 bAddRace,RC_DemiHuman,10; bonus2 bAddRace,RC_Player,10; bonus2 bAddEle,Ele_Earth,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1528,'Grand_Cross','Grand Cross',5,20,NULL,1500,140,NULL,1,0,0x00008110,7,2,2,4,40,1,8,'bonus bAtkEle,Ele_Holy; skill "PR_TURNUNDEAD",3; bonus3 bAutoSpell,"PR_TURNUNDEAD",3,100; bonus2 bSPDrainValueRace,RC_Undead,1; bonus2 bSPGainRace,RC_Undead,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1529,'Iron_Driver','Iron Driver',5,20,NULL,3000,155,NULL,2,0,0x00008100,7,2,2,3,78,1,8,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1530,'Mjolnir','Mjolnir',5,20,NULL,6000,250,NULL,1,0,0x000444A2,7,2,2,4,95,0,8,'bonus bAtkEle,Ele_Wind; bonus bDex,40; bonus bStr,15; bonus bAspdRate,10; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1531,'Spanner','Wrench',5,20,NULL,2500,115,NULL,1,0,0x00008110,7,2,2,3,55,1,8,'bonus2 bAddEff,Eff_Blind,100; bonus2 bAddEff,Eff_Stun,100; bonus2 bAddEff,Eff_Poison,100; bonus2 bAddEff,Eff_Freeze,100;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1532,'Stunner_','Stunner',5,60000,NULL,2000,140,NULL,1,2,0x00008110,7,2,2,3,27,1,8,'bonus2 bAddEff,Eff_Stun,1000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1533,'Warrior_Balmung','Warrior\'s Balmung',5,20,NULL,1000,170,NULL,1,0,0xFFFFFFFF,7,2,2,4,48,1,8,'bonus bAllStats,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1534,'Spanner_C','Wrench',5,2,NULL,0,150,NULL,1,0,0x00008110,7,2,2,3,0,0,8,'bonus2 bAddEff,Eff_Blind,100; bonus2 bAddEff,Eff_Stun,100; bonus2 bAddEff,Eff_Poison,100; bonus2 bAddEff,Eff_Freeze,100;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1535,'Hollgrehenn_Hammer','Hollgrehenn\'s Hammer',5,4444,NULL,44,4,NULL,1,1,0x0004C5B2,7,2,2,4,44,1,8,'bonus bBreakArmorRate,100; bonus bBreakWeaponRate,100; if(readparam(bStr)>=44) { bonus bBaseAtk,44; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (1536,'Good_Morning_Star','Good Morning Star',5,20,NULL,0,120,NULL,1,0,0x0004C5B2,7,2,2,1,0,0,8,'bonus2 bAddClass,Class_All,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1537,'Quadrille_C','Refined Quadrille',5,1,NULL,0,193,NULL,1,0,0x00008110,7,2,2,4,0,0,8,'bonus2 bAddRace,RC_DemiHuman,30; bonus2 bAddRace,RC_Player,30; bonus2 bAddRace,RC_Demon,40; bonus2 bAddRace,RC_Undead,40;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1538,'Spike_','Spike',5,20,NULL,700,85,NULL,1,2,0x00008110,7,2,2,4,40,1,8,'bonus bCritical,40; bonus bDefRate,-67; bonus bDef2Rate,-67;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1539,'Golden_Mace_','Golden Mace',5,20,NULL,800,110,NULL,1,2,0x00008110,7,2,2,4,40,1,8,'bonus2 bAddRace,RC_Undead,10; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1540,'Grand_Cross_','Grand Cross',5,20,NULL,1500,140,NULL,1,1,0x00008110,7,2,2,4,40,1,8,'bonus bAtkEle,Ele_Holy; skill "PR_TURNUNDEAD",3; bonus3 bAutoSpell,"PR_TURNUNDEAD",3,100; bonus2 bSPDrainValueRace,RC_Undead,1; bonus2 bSPGainRace,RC_Undead,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1541,'Nemesis','Nemesis',5,20,NULL,900,120,NULL,1,0,0x00008110,7,2,2,4,60,1,8,'bonus bAtkEle,Ele_Holy; bonus2 bAddRace,RC_Undead,10; bonus2 bAddRace,RC_Demon,10; bonus3 bAutoSpell,"AL_CRUCIS",1+getrefine(),100; autobonus "{ bonus bBaseAtk,50; }",10,20000,BF_WEAPON,"{ specialeffect2 EF_BLOODDRAIN; }";',NULL,NULL);
REPLACE INTO `item_db` VALUES (1542,'BF_Morning_Star1','Valorous Battlefield Morning Star',5,20,NULL,0,105,NULL,1,0,0x0004C5B3,7,2,2,3,80,1,8,'bonus bStr,1; bonus bDex,1; bonus2 bAddRace,RC_DemiHuman,75; bonus2 bAddRace,RC_Player,75; bonus2 bIgnoreDefRaceRate,RC_DemiHuman,20; bonus2 bIgnoreDefRaceRate,RC_Player,20; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1543,'BF_Morning_Star2','Brave Battlefield Morning Star',5,20,NULL,0,105,NULL,1,0,0x0004C5B3,7,2,2,3,80,1,8,'bonus bStr,1; bonus bDex,1; bonus2 bAddRace,RC_DemiHuman,75; bonus2 bAddRace,RC_Player,75; bonus bUnbreakableWeapon; autobonus "{ bonus2 bAddEff,Eff_Stun,5000; }",10,6000,BF_WEAPON,"{ specialeffect2 EF_POTION_BERSERK; }";',NULL,NULL);
REPLACE INTO `item_db` VALUES (1544,'Lunakaligo','Lunakaligo',5,20,NULL,700,110,NULL,1,3,0x00008110,2,2,2,3,50,1,8,'if(readparam(bStr)>=77) { bonus bAspdRate,4; bonus2 bAddEff,Eff_Stun,1500; bonus3 bAddMonsterDropItem,12065,RC_Plant,500; bonus3 bAddMonsterDropItem,12043,RC_Brute,500; bonus3 bAddMonsterDropItem,12069,RC_Fish,500; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (1545,'N_Mace','Novice Mace',5,0,NULL,0,57,NULL,1,3,0x0004C5B3,7,2,2,1,2,0,8,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1546,'Krieger_Onehand_Mace1','Glorious Morning Star',5,20,NULL,0,130,NULL,1,0,0x0004C5B3,7,2,2,4,80,1,8,'bonus2 bAddRace,RC_DemiHuman,75; bonus2 bAddRace,RC_Player,75; bonus2 bIgnoreDefRaceRate,RC_DemiHuman,20; bonus2 bIgnoreDefRaceRate,RC_Player,20; bonus bUnbreakableWeapon; if(getrefine()>5) { bonus2 bAddRace,RC_DemiHuman,(getrefine()-4)*(getrefine()-4); bonus2 bAddRace,RC_Player,(getrefine()-4)*(getrefine()-4); bonus2 bIgnoreDefRaceRate,RC_DemiHuman,5; bonus2 bIgnoreDefRaceRate,RC_Player,5; bonus bAspdRate,5; } if(getrefine()>8) { bonus2 bAddEff,Eff_Stun,2000; bonus bAspdRate,5; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (1547,'Mace_Of_Madness','Mace Of Madness',5,20,NULL,0,150,NULL,1,0,0x0004C5B2,7,2,2,3,0,0,8,'bonus2 bSkillAtk,"MC_CARTREVOLUTION",25; bonus bStr,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1548,'Veteran_Hammer','Veteran Hammer',5,10000,NULL,1800,160,NULL,1,2,0x00008110,7,2,2,3,80,1,8,'bonus bHealPower,getskilllv("AL_DP"); bonus bCritical,getskilllv("PR_MACEMASTERY")*2; bonus bInt,1; bonus bLuk,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1549,'Pilebuncker','Pile Bunker',5,10000,NULL,3500,450,NULL,1,0,0x00000400,7,2,2,3,99,1,8,NULL,NULL,NULL);
# Books
REPLACE INTO `item_db` VALUES (1550,'Book','Book',5,30000,NULL,600,85,NULL,1,3,0x00410100,7,2,2,2,14,1,15,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1551,'Bible','Bible',5,60000,NULL,1000,115,NULL,1,2,0x00410100,7,2,2,3,27,1,15,'bonus bInt,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1552,'Tablet','Tablet',5,51000,NULL,800,125,NULL,1,1,0x00410100,7,2,2,3,27,1,15,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1553,'Book_Of_Billows','Book of Billows',5,35000,NULL,750,90,NULL,1,0,0x00410100,7,2,2,3,27,1,15,'bonus bAtkEle,Ele_Water;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1554,'Book_Of_Mother_Earth','Book of Mother Earth',5,35000,NULL,750,90,NULL,1,0,0x00410100,7,2,2,3,27,1,15,'bonus bAtkEle,Ele_Earth;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1555,'Book_Of_Blazing_Sun','Book of the Blazing Sun',5,35000,NULL,750,90,NULL,1,0,0x00410100,7,2,2,3,27,1,15,'bonus bAtkEle,Ele_Fire;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1556,'Book_Of_Gust_Of_Wind','Book of Gust of Wind',5,35000,NULL,750,90,NULL,1,0,0x00410100,7,2,2,3,27,1,15,'bonus bAtkEle,Ele_Wind;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1557,'Book_Of_The_Apocalypse','Book of the Apocalypse',5,60000,NULL,800,120,NULL,1,0,0x00410100,7,2,2,4,40,1,15,'bonus bAtkEle,Ele_Dark; bonus2 bAddEle,Ele_Holy,5; bonus2 bAddEle,Ele_Water,7; bonus2 bAddEle,Ele_Earth,7; bonus2 bAddEle,Ele_Fire,7; bonus2 bAddEle,Ele_Wind,7;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1558,'Girl\'s_Diary','Girl\'s Diary',5,1500,NULL,300,60,NULL,1,1,0x00410100,7,2,2,4,40,1,15,'bonus2 bAddDamageClass,1188,150;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1559,'Legacy_Of_Dragon','Legacy of Dragon',5,20,NULL,700,130,NULL,1,0,0x00410100,7,2,2,4,70,1,15,'bonus bInt,3; bonus bIgnoreDefRace,RC_Dragon; bonus2 bSPGainRace,RC_Dragon,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1560,'Diary_Of_Great_Sage','Sage\'s Diary',5,20,NULL,1100,100,NULL,1,2,0x00410100,7,2,2,3,60,1,15,'bonus bMatkRate,15; if(readparam(bStr)>=50) bonus bAspdRate,5; if(readparam(bInt)>=70) bonus bMatkRate,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1561,'Hardback','Hardcover Book',5,20,NULL,1500,140,NULL,1,1,0x00410100,7,2,2,4,55,1,15,'bonus bStr,3; bonus bDex,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1562,'Bible_Of_Battlefield','Battlefield Textbook',5,20,NULL,700,110,NULL,1,1,0x00410100,7,2,2,4,80,0,15,'bonus bInt,3; bonus3 bAutoSpell,"AL_BLESSING",3+(getskilllv("AL_BLESSING")>3)*(getskilllv("AL_BLESSING")-3),20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1563,'Diary_Of_Great_Sage_C','Sage\'s Diary',5,1,NULL,0,135,NULL,1,2,0x00410100,7,2,2,3,1,0,15,'bonus bMatkRate,20; bonus bAspdRate,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1564,'Encyclopedia','Encyclopedia',5,20,NULL,2000,110,NULL,1,2,0x00410100,7,2,2,3,70,1,15,'bonus bMatkRate,15; bonus bInt,3; bonus bDex,2; bonus bCritical,20+((readparam(bLuk)*2)/10);',NULL,NULL);
REPLACE INTO `item_db` VALUES (1565,'Death_Note','Ledger of Death',5,20,NULL,1000,137,NULL,1,2,0x00410100,7,2,2,4,85,1,15,'bonus bMatkRate,15; bonus bStr,3; bonus bInt,3; bonus bLuk,-20; bonus2 bComaRace,RC_DemiHuman,10; bonus2 bComaRace,RC_Player,10; bonus bAspdRate,getrefine(); if(BaseJob==Job_Sage) bonus3 bAutoSpell,"NPC_HELLJUDGEMENT",5,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1566,'Diary_Of_Great_Basil','Diary Of Great Basil',5,20,NULL,0,120,NULL,1,0,0x00410100,7,2,2,1,0,0,15,'bonus2 bAddClass,Class_All,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1567,'Hardback_C','Refined Hardcover Book',5,1,NULL,0,168,NULL,1,0,0x00410100,7,2,2,4,0,0,15,'bonus bStr,5; bonus bDex,2; bonus bMatkRate,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1568,'Book_Of_Billows_','Book of Billows',5,35000,NULL,750,90,NULL,1,3,0x00410100,7,2,2,3,27,1,15,'bonus bAtkEle,Ele_Water;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1569,'Book_Of_Mother_Earth_','Book of Mother Earth',5,35000,NULL,750,90,NULL,1,3,0x00410100,7,2,2,3,27,1,15,'bonus bAtkEle,Ele_Earth;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1570,'Book_Of_Blazing_Sun_','Book of Blazing Sun',5,35000,NULL,750,90,NULL,1,3,0x00410100,7,2,2,3,27,1,15,'bonus bAtkEle,Ele_Fire;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1571,'Book_Of_Gust_Of_Wind_','Book of Gust of Wind',5,35000,NULL,750,90,NULL,1,3,0x00410100,7,2,2,3,27,1,15,'bonus bAtkEle,Ele_Wind;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1572,'Principles_Of_Magic','Principles of Magic',5,20,NULL,300,60,NULL,1,2,0x00410100,7,2,2,3,60,1,15,'bonus bMatkRate,20; bonus bInt,3; bonus bSPrecovRate,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1573,'Ancient_Magic','Ancient Magic',5,20,NULL,700,30,NULL,1,2,0x00410100,7,2,2,3,70,1,15,'bonus bMatkRate,15;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1574,'BF_Book1','Brave Battle Strategy Book',5,20,NULL,0,90,NULL,1,0,0x00410100,7,2,2,3,80,1,15,'bonus bStr,2; bonus bInt,1; bonus bMatkRate,15; bonus2 bAddRace,RC_DemiHuman,75; bonus2 bAddRace,RC_Player,75; bonus2 bIgnoreDefRaceRate,RC_DemiHuman,20; bonus2 bIgnoreDefRaceRate,RC_Player,20; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1575,'BF_Book2','Valorous Battle Strategy Book',5,20,NULL,0,90,NULL,1,0,0x00410100,7,2,2,3,80,1,15,'bonus bStr,2; bonus bInt,1; bonus bMatkRate,15; bonus2 bIgnoreMdefRaceRate,RC_DemiHuman,25; bonus2 bIgnoreMdefRaceRate,RC_Player,25; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1576,'Krieger_Book1','Glorious Tablet',5,20,NULL,0,90,NULL,1,0,0x00410100,7,2,2,4,80,1,15,'bonus bMatkRate,15; bonus2 bAddRace,RC_DemiHuman,80; bonus2 bAddRace,RC_Player,80; bonus2 bIgnoreDefRaceRate,RC_DemiHuman,25; bonus2 bIgnoreDefRaceRate,RC_Player,25; bonus bUnbreakableWeapon; if(getrefine()>5) { bonus2 bAddRace,RC_DemiHuman,(getrefine()-4)*(getrefine()-4); bonus2 bAddRace,RC_Player,(getrefine()-4)*(getrefine()-4); bonus2 bIgnoreDefRaceRate,RC_DemiHuman,5; bonus2 bIgnoreDefRaceRate,RC_Player,5; } if(getrefine()>8) autobonus "{ bonus bBaseAtk,200; }",30,3000,BF_WEAPON,"{ specialeffect2 EF_BASH3D; }";',NULL,NULL);
REPLACE INTO `item_db` VALUES (1577,'Krieger_Book2','Glorious Apocalypse',5,20,NULL,0,90,NULL,1,0,0x00410100,7,2,2,4,80,1,15,'bonus bMatkRate,15; bonus2 bAddRace,RC_DemiHuman,80; bonus2 bAddRace,RC_Player,80; bonus2 bIgnoreDefRaceRate,RC_DemiHuman,25; bonus2 bIgnoreDefRaceRate,RC_Player,25; bonus bUnbreakableWeapon; if(getrefine()>5) bonus2 bIgnoreDefRaceRate,RC_DemiHuman,5; bonus2 bIgnoreDefRaceRate,RC_Player,5; if(getrefine()>8) { bonus bMatkRate,5; bonus bCastrate,-5; bonus bDelayRate,-5; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (1578,'Book_Of_Prayer','Book Of Prayer',5,20,NULL,0,140,NULL,1,0,0x00410100,7,2,2,3,0,0,15,'bonus bVit,2; bonus bMdef,2; bonus bMaxSPrate,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1579,'Death_Note_M','Book of the Dead',5,20,NULL,1000,137,NULL,1,2,0x00410100,7,2,2,4,85,1,15,'bonus bMatkRate,15; bonus bStr,3; bonus bInt,3; bonus bLuk,-20; bonus2 bComaRace,RC_DemiHuman,10; bonus2 bComaRace,RC_Player,10; bonus bAspdRate,getrefine(); if(BaseJob==Job_Sage) bonus3 bAutoSpell,"NPC_HELLJUDGEMENT",5,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1580,'Encyclopedia_C','Giant Encyclopedia',5,0,NULL,0,145,NULL,1,0,0x00410100,7,2,2,3,0,0,15,'bonus bMatkRate,15; bonus bInt,3; bonus bDex,2; bonus bCritical,20+((readparam(bLuk)*2)/10); bonus2 bAddSize,Size_All,40;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1581,'F_Diary_Of_Great_Sage_C','Diary Of Great Sage',5,1,NULL,0,135,NULL,1,2,0x00410100,7,2,2,3,1,0,15,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1582,'E_Diary_Of_Great_Sage_C','Diary Of Great Sage',5,1,NULL,0,135,NULL,1,2,0x00410100,7,2,2,3,1,0,15,NULL,NULL,NULL);
# GM Weapon
REPLACE INTO `item_db` VALUES (1599,'Angra_Manyu','Angra Manyu',5,1,NULL,10,200,NULL,2,0,0xFFFFFFFF,7,2,2,1,1,1,8,'bonus bAllStats,50; bonus bBaseAtk,3800; bonus bMatkRate,200; bonus2 bHPDrainRate,1000,100; bonus2 bSPDrainRate,1000,20; bonus bHealPower,200; bonus2 bAddClass,Class_All,100; skill "WZ_STORMGUST",10; Skill "WZ_METEOR",10; Skill "WZ_VERMILION",10; skill "GM_SANDMAN",1;',NULL,NULL);
# Staffs
REPLACE INTO `item_db` VALUES (1601,'Rod','Rod',5,50,NULL,400,15,NULL,1,3,0x00818315,7,2,2,1,1,1,10,'bonus bMatkRate,15;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1602,'Rod_','Rod',5,50,NULL,400,15,NULL,1,4,0x00818315,7,2,2,1,1,1,10,'bonus bMatkRate,15;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1603,'Rod__','Rod',5,50,NULL,400,15,NULL,1,0,0x00818315,7,2,2,1,1,1,10,'bonus bMatkRate,15;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1604,'Wand','Wand',5,2500,NULL,400,25,NULL,1,2,0x00818315,7,2,2,2,12,1,10,'bonus bInt,1; bonus bMatkRate,15;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1605,'Wand_','Wand',5,2500,NULL,400,25,NULL,1,3,0x00818315,7,2,2,2,12,1,10,'bonus bInt,1; bonus bMatkRate,15;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1606,'Wand__','Wand',5,2500,NULL,400,25,NULL,1,0,0x00818315,7,2,2,2,12,1,10,'bonus bInt,1; bonus bMatkRate,15;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1607,'Staff','Staff',5,9500,NULL,400,40,NULL,1,2,0x00818314,7,2,2,2,12,1,10,'bonus bInt,2; bonus bMatkRate,15;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1608,'Staff_','Staff',5,9500,NULL,400,40,NULL,1,3,0x00818314,7,2,2,2,12,1,10,'bonus bInt,2; bonus bMatkRate,15;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1609,'Staff__','Staff',5,9500,NULL,400,40,NULL,1,0,0x00818314,7,2,2,2,12,1,10,'bonus bInt,2; bonus bMatkRate,15;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1610,'Arc_Wand','Arc Wand',5,45000,NULL,400,60,NULL,1,1,0x00818314,7,2,2,3,24,1,10,'bonus bInt,3; bonus bMatkRate,15;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1611,'Arc_Wand_','Arc Wand',5,45000,NULL,400,60,NULL,1,2,0x00818314,7,2,2,3,24,1,10,'bonus bInt,3; bonus bMatkRate,15;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1612,'Arc_Wand__','Arc Wand',5,45000,NULL,400,60,NULL,1,0,0x00818314,7,2,2,3,24,1,10,'bonus bInt,3; bonus bMatkRate,15;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1613,'Mighty_Staff','Mighty Staff',5,20,NULL,700,130,NULL,1,0,0x00818314,7,2,2,3,24,1,10,'bonus bStr,10; bonus bMatkRate,15; bonus bSPDrainValue,-2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1614,'Blessed_Wand','Wand of Occult',5,20,NULL,700,75,NULL,1,0,0x00818314,7,2,2,3,24,1,10,'bonus bInt,3; bonus bMatkRate,15;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1615,'Bone_Wand','Evil Bone Wand',5,20,NULL,700,40,NULL,1,0,0x00818314,7,2,2,3,24,1,10,'bonus bInt,4; bonus bAtkEle,Ele_Undead; bonus bMatkRate,15;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1616,'Staff_Of_Wing','Wing Staff',5,20,NULL,500,60,NULL,1,0,0x00810204,7,2,2,4,40,1,10,'bonus bMatkRate,15; bonus bCastrate,-5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1617,'Survival_Rod','Survivor\'s Rod',5,85000,NULL,1000,50,NULL,1,0,0x00818314,7,2,2,3,24,1,10,'bonus bDex,2; bonus bMatkRate,15; bonus bMaxHP,300;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1618,'Survival_Rod_','Survivor\'s Rod',5,85000,NULL,1000,50,NULL,1,1,0x00818314,7,2,2,3,24,1,10,'bonus bDex,3; bonus bMatkRate,15; bonus bMaxHP,400;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1619,'Survival_Rod2','Survivor\'s Rod',5,85000,NULL,1000,50,NULL,1,0,0x00818314,7,2,2,3,24,1,10,'bonus bInt,2; bonus bMatkRate,15; bonus bMaxHP,300;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1620,'Survival_Rod2_','Survivor\'s Rod',5,85000,NULL,1000,50,NULL,1,1,0x00818314,7,2,2,3,24,1,10,'bonus bInt,3; bonus bMatkRate,15; bonus bMaxHP,400;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1621,'Hypnotist\'s_Staff','Hypnotist\'s Staff',5,43000,NULL,500,70,NULL,1,1,0x00000001,7,2,2,3,30,1,10,'bonus bInt,1; bonus bMatkRate,25;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1622,'Hypnotist\'s_Staff_','Hypnotist\'s Staff',5,20,NULL,500,70,NULL,1,2,0x00000001,7,2,2,3,30,1,10,'bonus bInt,1; bonus bMatkRate,25;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1623,'Mighty_Staff_C','Mighty Staff',5,1,NULL,0,165,NULL,1,0,0x00818314,7,2,2,3,1,0,10,'bonus bStr,10; bonus bInt,4; bonus bMatkRate,20; bonus bSPDrainValue,-1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1624,'Lich_Bone_Wand','Lich\'s Bone Wand',5,20,NULL,800,60,NULL,1,2,0x00018314,2,2,2,3,70,1,10,'bonus bInt,1; bonus bDex,1; bonus bAtkEle,Ele_Undead; bonus bMatkRate,20; bonus3 bAutoSpellWhenHit,"NPC_WIDECURSE",5,10+getrefine(); if(getrefine()>=9){ bonus bMatkRate,3; bonus bMaxSP,300; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (1625,'Healing_Staff','Healing Staff',5,20,NULL,400,10,NULL,1,0,0x00008110,7,2,2,3,55,1,10,'bonus bAtkEle,Ele_Holy; bonus bMatkRate,15; bonus bHealPower,(getrefine()*3/2);',NULL,NULL);
REPLACE INTO `item_db` VALUES (1626,'Piercing_Staff','Piercing Staff',5,20,NULL,500,80,NULL,1,0,0x00018314,2,2,2,3,70,1,10,'bonus bInt,4; bonus bMatkRate,15; bonus2 bIgnoreMdefClassRate,Class_Normal,10+getrefine(); bonus2 bIgnoreMdefClassRate,Class_Boss,10+getrefine();',NULL,NULL);
REPLACE INTO `item_db` VALUES (1627,'Staffy','Staffy',5,20,NULL,0,40,NULL,1,0,0x00818314,7,2,2,1,0,0,10,'bonus bMatkRate,15; bonus2 bAddClass,Class_All,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1628,'Survival_Rod_C','Refined Survivor\'s Rod',5,1,NULL,0,71,NULL,1,0,0x00818314,7,2,2,3,0,0,10,'bonus bDex,4; bonus bMatkRate,20; bonus bMaxHP,500;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1629,'Walking_Stick','Gentleman\'s Staff',5,20,NULL,500,40,NULL,1,1,0x00818314,7,2,2,4,50,1,10,'bonus bMatkRate,15; bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1630,'Release_Of_Wish','Release of Wish',5,20,NULL,500,30,NULL,1,0,0x00810204,7,2,2,3,50,1,10,'bonus bMatkRate,15; bonus bInt,3; bonus bHealPower,5; autobonus "{ bonus2 bSPRegenRate,100,2000; bonus2 bHPRegenRate,50,2000; }",10,10000,BF_MAGIC,"{ specialeffect2 EF_HEAL; }";',NULL,NULL);
REPLACE INTO `item_db` VALUES (1631,'Holy_Stick','Holy Stick',5,20,NULL,500,50,NULL,1,1,0x00008100,7,2,2,4,70,1,10,'bonus bAtkEle,Ele_Holy; bonus bMatkRate,15; bonus2 bCastrate,"AL_HOLYLIGHT",-25; bonus2 bCastrate,"PR_TURNUNDEAD",-25; bonus2 bCastrate,"PR_MAGNUS",-25;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1632,'BF_Staff1','Warlock\'s Magic Wand',5,20,NULL,0,70,NULL,1,0,0x00818314,7,2,2,3,80,1,10,'bonus bInt,4; bonus bDex,3; bonus bMatkRate,15; bonus2 bIgnoreMdefRaceRate,RC_DemiHuman,25; bonus2 bIgnoreMdefRaceRate,RC_Player,25; bonus3 bAddEff,Eff_Stun,500,ATF_SKILL; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1633,'BF_Staff2','Warlock\'s Battle Wand',5,20,NULL,0,70,NULL,1,0,0x00818314,7,2,2,3,80,1,10,'bonus bInt,3; bonus bDex,3; bonus bMatkRate,15; bonus2 bMagicAddRace,RC_DemiHuman,15; bonus2 bMagicAddRace,RC_Player,15; bonus3 bAddEff,Eff_Stun,500,ATF_SKILL; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1634,'BF_Staff3','Strong Recovery Wand',5,20,NULL,0,70,NULL,1,0,0x00818314,7,2,2,3,80,1,10,'bonus bMatkRate,15; bonus bHealPower,14; bonus2 bSPRegenRate,5,10000; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1635,'BF_Staff4','Speedy Recovery Wand',5,20,NULL,0,70,NULL,1,0,0x00818314,7,2,2,3,80,1,10,'bonus bInt,3; bonus bDex,2; bonus bMatkRate,15; bonus bDelayRate,-15; bonus2 bSPRegenRate,5,10000; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1636,'Thorn_Staff','Thorn Staff of Darkness',5,20,NULL,700,60,NULL,1,0,0x00018314,2,2,2,4,75,1,10,'bonus bInt,3; bonus bDex,3; bonus bMatkRate,20; bonus2 bIgnoreMdefClassRate,Class_Normal,getrefine(); bonus2 bIgnoreMdefClassRate,Class_Boss,getrefine(); bonus bDelayRate,-(getrefine()*3/2);',NULL,NULL);
REPLACE INTO `item_db` VALUES (1637,'Eraser','Eraser',5,20,NULL,500,80,NULL,1,0,0x00018314,2,2,2,4,70,1,10,'bonus bMatkRate,20; bonus bInt,3; bonus bDex,2; bonus bSPrecovRate,8; if( getrefine()>9 ) bonus5 bAutoSpell,"NPC_WIDESOULDRAIN",3,5,BF_MAGIC,0; else bonus5 bAutoSpell,"NPC_WIDESOULDRAIN",1,5,BF_MAGIC,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1638,'Healing_Staff_C','Staff Of Healing',5,20,NULL,0,10,NULL,1,0,0x00008110,7,2,2,3,1,1,10,'bonus bAtkEle,Ele_Holy; bonus bMatkRate,15; bonus bHealPower,(getrefine()*3/2);',NULL,NULL);
REPLACE INTO `item_db` VALUES (1639,'N_Rod','Novice Rod',5,0,NULL,0,15,NULL,1,3,0x00818315,7,2,2,1,1,0,10,'bonus bMatkRate,16;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1640,'Krieger_Onehand_Staff1','Glorious Arc Wand',5,20,NULL,0,70,NULL,1,0,0x00818314,7,2,2,4,80,1,10,'bonus2 bMagicAddRace,RC_DemiHuman,15; bonus2 bMagicAddRace,RC_Player,15; bonus2 bIgnoreMdefRaceRate,RC_DemiHuman,25 + ((getrefine()>5) ? 5 : 0); bonus2 bIgnoreMdefRaceRate,RC_Player,25 + ((getrefine()>5) ? 5 : 0); bonus bUnbreakableWeapon; if(getrefine()>8) { bonus bCastrate,-5; bonus bDelayRate,-5; bonus bMatkRate,5; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (1641,'Krieger_Onehand_Staff2','Glorious Cure Wand',5,20,NULL,0,70,NULL,1,0,0x00818314,7,2,2,4,80,1,10,'bonus bHealPower,14; bonus bDelayRate,-10; bonus bUnbreakableWeapon; if(getrefine()>5) { bonus2 bIgnoreMdefRaceRate,RC_DemiHuman,5; bonus2 bIgnoreMdefRaceRate,RC_Player,5; bonus bHealPower,5+(getrefine()-5)*2; } if(getrefine()>8) bonus5 bAutoSpellOnSkill,"AL_HEAL","AL_HEAL",10,100,1; if(getrefine()>9) { bonus bHealPower,10; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (1642,'Staff_Of_Darkness','Staff Of Darkness',5,20,NULL,0,100,NULL,1,0,0x00818314,7,2,2,2,0,0,10,'bonus bCastrate,-5; bonus bMatkRate,15; bonus bInt,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1643,'Dead_Tree_Cane','Dead Tree Cane',5,20,NULL,100,100,NULL,1,0,0x00818314,7,2,2,4,70,1,10,'bonus bMatk,15; bonus bInt,4; if(getrefine()>5) { bonus bInt,getrefine()-5; bonus bMaxHP,-200; bonus bMaxSP,-100; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (1644,'Piercing_Staff_M','Staff of Piercing',5,20,NULL,500,80,NULL,1,0,0x00018314,2,2,2,3,70,1,10,'bonus bInt,4; bonus bMatkRate,15; bonus2 bIgnoreMdefClassRate,Class_Normal,10+getrefine(); bonus2 bIgnoreMdefClassRate,Class_Boss,10+getrefine();',NULL,NULL);
REPLACE INTO `item_db` VALUES (1645,'Lich_Bone_Wand_M','Lich\'s Bone Wand',5,20,NULL,800,60,NULL,1,2,0x00018314,2,2,2,3,70,1,10,'bonus bInt,1; bonus bDex,1; bonus bAtkEle,Ele_Undead; bonus bMatkRate,20; bonus3 bAutoSpellWhenHit,"NPC_WIDECURSE",5,10+getrefine(); if(getrefine()>=9){ bonus bMatkRate,3; bonus bMaxSP,300; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (1646,'La\'cryma_Stick','La\'cryma Stick',5,20,NULL,500,30,NULL,1,2,0x00010204,2,2,2,3,50,1,10,'bonus bInt,4; bonus bMatkRate,15; bonus bMdef,getrefine(); bonus2 bSkillAtk,"WZ_STORMGUST",getrefine(); if(getrefine()>9) bonus2 bCastrate,"WZ_STORMGUST",-8;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1647,'Croce_Staff','Croce Staff',5,20,NULL,500,30,NULL,1,1,0x00008110,2,2,2,3,50,1,10,'bonus bAtkEle,Ele_Holy; bonus bMatkRate,15; bonus bInt,4; bonus4 bAutoSpellOnSkill,"AL_HEAL","AL_BLESSING",max(getskilllv("AL_BLESSING"),1),20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1648,'Staff_Of_Bordeaux','Staff Of Bordeaux',5,20,NULL,500,30,NULL,1,0,0x00010204,2,2,2,4,50,1,10,'bonus bMatkRate,15; bonus bInt,2; bonus bDex,1; if(getskilllv("SA_DRAGONOLOGY")==5) { bonus bUseSPrate,-15; bonus bInt,3; }',NULL,NULL);
# Bows
REPLACE INTO `item_db` VALUES (1701,'Bow','Bow',5,1000,NULL,500,15,NULL,5,3,0x000A0848,7,2,34,1,4,1,11,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1702,'Bow_','Bow',5,1000,NULL,500,15,NULL,5,4,0x000A0848,7,2,34,1,4,1,11,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1703,'Bow__','Bow',5,1000,NULL,0,15,NULL,5,0,0x000A0848,7,2,34,1,4,1,11,'bonus2 bAddDamageClass,1002,500; bonus2 bAddDamageClass,1113,500; bonus2 bAddDamageClass,1031,500; bonus2 bAddDamageClass,1242,500;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1704,'Composite_Bow','Composite Bow',5,2500,NULL,600,29,NULL,5,3,0x000A0848,7,2,34,1,4,1,11,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1705,'Composite_Bow_','Composite Bow',5,2500,NULL,600,29,NULL,5,4,0x000A0848,7,2,34,1,4,1,11,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1706,'Composite_Bow__','Composite Bow',5,2500,NULL,600,29,NULL,5,0,0x000A0848,7,2,34,1,4,1,11,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1707,'Great_Bow','Great Bow',5,10000,NULL,1000,50,NULL,5,2,0x000A0848,7,2,34,2,18,1,11,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1708,'Great_Bow_','Great Bow',5,10000,NULL,1000,50,NULL,5,3,0x000A0848,7,2,34,2,18,1,11,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1709,'Great_Bow__','Great Bow',5,10000,NULL,1000,50,NULL,5,0,0x000A0848,7,2,34,2,18,1,11,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1710,'CrossBow','Crossbow',5,17000,NULL,900,65,NULL,5,2,0x000A0848,7,2,34,2,18,1,11,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1711,'CrossBow_','Crossbow',5,17000,NULL,900,65,NULL,5,3,0x000A0848,7,2,34,2,18,1,11,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1712,'CrossBow__','Crossbow',5,17000,NULL,900,65,NULL,5,0,0x000A0848,7,2,34,2,18,1,11,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1713,'Arbalest','Arbalest',5,48000,NULL,1000,90,NULL,5,1,0x000A0848,7,2,34,3,33,1,11,'bonus bDex,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1714,'Kakkung','Gakkung Bow',5,42000,NULL,1100,100,NULL,5,1,0x000A0848,7,2,34,3,33,1,11,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1715,'Arbalest_','Arbalest',5,48000,NULL,1000,90,NULL,5,2,0x000A0848,7,2,34,3,33,1,11,'bonus bDex,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1716,'Kakkung_','Gakkung Bow',5,42000,NULL,1100,100,NULL,5,2,0x000A0848,7,2,34,3,33,1,11,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1718,'Hunter_Bow','Hunter Bow',5,64000,NULL,1500,125,NULL,5,0,0x00000800,7,2,34,3,33,1,11,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1719,'Bow_Of_Roguemaster','Roguemaster\'s Bow',5,20,NULL,500,75,NULL,11,0,0x00000040,7,2,34,4,48,1,11,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1720,'Bow_Of_Rudra','Rudra Bow',5,20,NULL,1200,150,NULL,5,0,0x000A0808,7,2,34,4,48,1,11,'bonus bAtkEle,Ele_Holy; bonus bInt,5; skill "AL_CURE",1; skill "AL_HEAL",1; bonus2 bResEff,Eff_Poison,5000; bonus2 bResEff,Eff_Curse,5000; bonus2 bResEff,Eff_Silence,5000; bonus2 bResEff,Eff_Confusion,5000; bonus2 bResEff,Eff_Blind,5000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1721,'Repeting_CrossBow','Repeating Crossbow',5,89000,NULL,2000,95,NULL,9,1,0x00020840,7,2,34,3,65,1,11,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1722,'Balistar','Ballista',5,124000,NULL,3500,145,NULL,5,0,0x00080800,7,2,34,4,77,1,11,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1723,'Luna_Bow','Luna Bow',5,20,NULL,2000,100,NULL,5,2,0x00000800,7,2,34,3,30,1,11,'bonus bDef,2+3*(getrefine()>5)+2*(getrefine()>8);',NULL,NULL);
REPLACE INTO `item_db` VALUES (1724,'Dragon_Wing','Dragon Wing',5,20,NULL,1200,100,NULL,5,0,0x000A0848,7,2,34,4,60,1,11,'bonus3 bAddMonsterDropItem,1765,RC_Dragon,300; bonus bIgnoreDefRace,RC_Dragon;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1725,'Bow_Of_Minstrel','Minstrel Bow',5,20,NULL,1700,120,NULL,5,1,0x00080800,7,2,34,4,70,1,11,'bonus bInt,2; bonus bSPrecovRate,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1726,'Hunter_Bow_','Hunter Bow',5,64000,NULL,1500,125,NULL,5,1,0x00000800,7,2,34,3,33,1,11,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1727,'Balistar_','Ballista',5,124000,NULL,3500,145,NULL,5,1,0x00080800,7,2,34,4,77,1,11,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1728,'Balistar_C','Ballista',5,1,NULL,0,194,NULL,5,0,0x00080800,7,2,34,4,1,0,11,'bonus bLongAtkRate,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1729,'Bow_Of_Rudra_C','Rudra Bow',5,2,NULL,0,185,NULL,5,0,0x000A0808,7,2,34,4,1,0,11,'bonus bAtkEle,Ele_Holy; bonus bInt,5; skill "AL_CURE",1; skill "AL_HEAL",1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1730,'Burning_Bow','Burning Bow',5,20,NULL,1400,95,NULL,5,1,0x000A0808,7,2,34,3,55,1,11,'bonus2 bSubEle,Ele_Fire,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1731,'Frozen_Bow','Frozen Bow',5,20,NULL,1400,100,NULL,5,1,0x000A0808,7,2,34,3,55,1,11,'bonus2 bAddEff,Eff_Freeze,1000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1732,'Earth_Bow','Earth Bow',5,20,NULL,1400,105,NULL,5,1,0x000A0808,7,2,34,3,55,1,11,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1733,'Gust_Bow','Gust Bow',5,20,NULL,1400,95,NULL,5,1,0x000A0808,7,2,34,3,55,1,11,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1734,'Orc_Archer_Bow','Orc Archer Bow',5,20,NULL,1600,120,NULL,5,0,0x000A0808,7,2,34,3,65,1,11,'bonus2 bAddMonsterDropItem,1753,200;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1735,'Kkakkung','Kkakkung',5,20,NULL,0,120,NULL,5,0,0x000A0848,7,2,34,1,1,0,11,'bonus2 bAddClass,Class_All,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1736,'Double_Bound','Double Bound',5,20,NULL,900,70,NULL,5,3,0x00000800,2,2,34,3,70,1,11,'bonus3 bAutoSpell,"AC_DOUBLE",GetSkillLv("AC_DOUBLE"),10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1737,'Ixion_Wing','Ixion Wings',5,20,NULL,300,135,NULL,5,1,0x00000800,2,2,34,4,70,1,11,'autobonus "{ bonus bAspdRate,7; }",10+(getrefine()*2),7000,BF_WEAPON,"{ specialeffect2 EF_HASTEUP; }"; bonus2 bAddSkillBlow,"AC_CHARGEARROW",3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1738,'BF_Bow1','Valorous Battle CrossBow',5,0,NULL,0,100,NULL,5,0,0x000A0848,7,2,34,3,80,1,11,'bonus bDex,2; bonus2 bAddRace,RC_DemiHuman,55; bonus2 bAddRace,RC_Player,55; bonus2 bIgnoreDefRaceRate,RC_DemiHuman,20; bonus2 bIgnoreDefRaceRate,RC_Player,20; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1739,'BF_Bow2','Brave Battle CrossBow',5,0,NULL,0,100,NULL,5,0,0x000A0848,7,2,34,3,80,1,11,'bonus bDex,2; bonus bInt,10; bonus2 bAddRace,RC_DemiHuman,55; bonus2 bAddRace,RC_Player,55; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1740,'Nepenthes_Bow','Nepenthes Bow',5,20,NULL,1000,105,NULL,5,2,0x00000800,2,2,34,4,60,1,11,'bonus4 bAutoSpellOnSkill,"AC_DOUBLE","AC_CHARGEARROW",1,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1741,'Cursed_Lyre','Cursed Lyre',5,20,NULL,1250,125,NULL,5,1,0x00080808,2,2,34,4,80,1,11,'bonus bLuk,-2; bonus2 bAddEff,Eff_Curse,400;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1742,'N_Composite_Bow','Novice Composite Bow',5,1,NULL,0,49,NULL,5,3,0x000A0848,7,2,34,1,4,0,11,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1743,'Krieger_Bow1','Glorious Hunter Bow',5,0,NULL,0,100,NULL,5,0,0x001A0848,7,2,34,4,80,1,11,'bonus2 bAddRace,RC_DemiHuman,55; bonus2 bAddRace,RC_Player,55; bonus2 bIgnoreDefRaceRate,RC_DemiHuman,20; bonus2 bIgnoreDefRaceRate,RC_Player,20; bonus bCritAtkRate,getrefine() * 2; bonus bUnbreakableWeapon; if(getrefine()>5) { bonus2 bAddRace,RC_DemiHuman,(getrefine()-4)*(getrefine()-4); bonus2 bAddRace,RC_Player,(getrefine()-4)*(getrefine()-4); bonus2 bIgnoreDefRaceRate,RC_DemiHuman,5; bonus2 bIgnoreDefRaceRate,RC_Player,5; } if(getrefine()>8) bonus2 bSkillAtk,"AC_DOUBLE",20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1744,'Bow_Of_Evil','Bow Of Evil',5,0,NULL,0,170,NULL,5,0,0x000A0848,7,2,34,4,1,0,11,'bonus2 bSkillAtk,"AC_DOUBLE",25; bonus bDex,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1745,'Falken_Blitz','Falken Blitz',5,0,NULL,1000,100,NULL,5,2,0x00080808,2,2,34,3,50,1,11,'bonus2 bSkillAtk,"SN_SHARPSHOOTING",10; bonus2 bSkillAtk,"AC_DOUBLE",10; bonus2 bSkillAtk,"AC_CHARGEARROW",10;',NULL,NULL);
# Arrows
REPLACE INTO `item_db` VALUES (1750,'Arrow','Arrow',10,1,NULL,1,25,NULL,NULL,NULL,0x000A1848,7,2,32768,NULL,1,NULL,1,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1751,'Silver_Arrow','Silver Arrow',10,3,NULL,2,30,NULL,NULL,NULL,0x000A1848,7,2,32768,NULL,1,NULL,1,'bonus bAtkEle,Ele_Holy;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1752,'Fire_Arrow','Fire Arrow',10,3,NULL,2,30,NULL,NULL,NULL,0x000A1848,7,2,32768,NULL,1,NULL,1,'bonus bAtkEle,Ele_Fire;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1753,'Steel_Arrow','Steel Arrow',10,4,NULL,2,40,NULL,NULL,NULL,0x000A1848,7,2,32768,NULL,1,NULL,1,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1754,'Crystal_Arrow','Crystal Arrow',10,3,NULL,2,30,NULL,NULL,NULL,0x000A1848,7,2,32768,NULL,1,NULL,1,'bonus bAtkEle,Ele_Water;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1755,'Arrow_Of_Wind','Arrow of Wind',10,3,NULL,2,30,NULL,NULL,NULL,0x000A1848,7,2,32768,NULL,1,NULL,1,'bonus bAtkEle,Ele_Wind;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1756,'Stone_Arrow','Stone Arrow',10,3,NULL,2,30,NULL,NULL,NULL,0x000A1848,7,2,32768,NULL,1,NULL,1,'bonus bAtkEle,Ele_Earth;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1757,'Immatrial_Arrow','Immaterial Arrow',10,3,NULL,1,30,NULL,NULL,NULL,0x000A1848,7,2,32768,NULL,1,NULL,1,'bonus bAtkEle,Ele_Ghost;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1758,'Stun_Arrow','Stun Arrow',10,10,NULL,3,1,NULL,NULL,NULL,0x000A1848,7,2,32768,NULL,1,NULL,1,'bonus2 bAddEff,Eff_Stun,1000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1759,'Freezing_Arrow','Frozen Arrow',10,10,NULL,3,1,NULL,NULL,NULL,0x000A1848,7,2,32768,NULL,1,NULL,1,'bonus bAtkEle,Ele_Water; bonus2 bAddEff,Eff_Freeze,1000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1760,'Flash_Arrow','Flash Arrow',10,10,NULL,3,1,NULL,NULL,NULL,0x000A1848,7,2,32768,NULL,1,NULL,1,'bonus2 bAddEff,Eff_Blind,1000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1761,'Curse_Arrow','Cursed Arrow',10,10,NULL,3,1,NULL,NULL,NULL,0x000A1848,7,2,32768,NULL,1,NULL,1,'bonus2 bAddEff,Eff_Curse,1000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1762,'Rusty_Arrow','Rusty Arrow',10,3,NULL,2,30,NULL,NULL,NULL,0x000A1848,7,2,32768,NULL,1,NULL,1,'bonus bAtkEle,Ele_Poison;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1763,'Poison_Arrow','Poison Arrow',10,10,NULL,3,1,NULL,NULL,NULL,0x000A1848,7,2,32768,NULL,1,NULL,1,'bonus bAtkEle,Ele_Poison; bonus2 bAddEff,Eff_Poison,2000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1764,'Incisive_Arrow','Sharp Arrow',10,20,NULL,3,10,NULL,NULL,NULL,0x000A1848,7,2,32768,NULL,1,NULL,1,'bonus bCriticalLong,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1765,'Oridecon_Arrow','Oridecon Arrow',10,30,NULL,3,50,NULL,NULL,NULL,0x000A1848,7,2,32768,NULL,1,NULL,1,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1766,'Arrow_Of_Counter_Evil','Arrow of Counter Evil',10,40,NULL,3,50,NULL,NULL,NULL,0x000A1848,7,2,32768,NULL,1,NULL,1,'bonus bAtkEle,Ele_Holy;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1767,'Arrow_Of_Shadow','Arrow of Shadow',10,3,NULL,2,30,NULL,NULL,NULL,0x000A1848,7,2,32768,NULL,1,NULL,1,'bonus bAtkEle,Ele_Dark;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1768,'Sleep_Arrow','Sleep Arrow',10,10,NULL,3,1,NULL,NULL,NULL,0x000A1848,7,2,32768,NULL,1,NULL,1,'bonus2 bAddEff,Eff_Sleep,2000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1769,'Silence_Arrow','Mute Arrow',10,10,NULL,3,1,NULL,NULL,NULL,0x000A1848,7,2,32768,NULL,1,NULL,1,'bonus2 bAddEff,Eff_Silence,1000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1770,'Iron_Arrow','Iron Arrow',10,2,NULL,1,30,NULL,NULL,NULL,0x000A1848,7,2,32768,NULL,1,NULL,1,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1771,'Venom_Knife','Venom Knife',10,50,NULL,5,30,NULL,NULL,NULL,0x00001000,7,2,32768,NULL,1,NULL,2,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1772,'Holy_Arrow','Holy Arrow',10,3,NULL,2,50,NULL,NULL,NULL,0x000A1848,7,2,32768,NULL,1,NULL,1,'bonus bAtkEle,Ele_Holy; bonus2 bAddRace,RC_Demon,5;',NULL,NULL);
# Knuckles
REPLACE INTO `item_db` VALUES (1801,'Waghnakh','Waghnak',5,8000,NULL,400,30,NULL,1,3,0x00008100,7,2,2,1,1,1,12,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1802,'Waghnakh_','Waghnak',5,8000,NULL,400,30,NULL,1,4,0x00008100,7,2,2,1,1,1,12,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1803,'Knuckle_Duster','Knuckle Dusters',5,25000,NULL,450,50,NULL,1,2,0x00008100,7,2,2,2,12,1,12,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1804,'Knuckle_Duster_','Knuckle Dusters',5,25000,NULL,450,50,NULL,1,3,0x00008100,7,2,2,2,12,1,12,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1805,'Hora','Studded Knuckles',5,32000,NULL,450,65,NULL,1,2,0x00008100,7,2,2,2,12,1,12,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1806,'Hora_','Studded Knuckles',5,32000,NULL,450,65,NULL,1,3,0x00008100,7,2,2,2,12,1,12,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1807,'Fist','Fist',5,53000,NULL,650,115,NULL,1,0,0x00008100,7,2,2,3,24,1,12,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1808,'Fist_','Fist',5,53000,NULL,650,115,NULL,1,1,0x00008100,7,2,2,3,24,1,12,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1809,'Claw','Claw',5,67000,NULL,500,86,NULL,1,1,0x00008100,7,2,2,3,24,1,12,'bonus bStr,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1810,'Claw_','Claw',5,67000,NULL,500,86,NULL,1,2,0x00008100,7,2,2,3,24,1,12,'bonus bStr,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1811,'Finger','Finger',5,58000,NULL,500,97,NULL,1,1,0x00008100,7,2,2,3,24,1,12,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1812,'Finger_','Finger',5,58000,NULL,500,97,NULL,1,2,0x00008100,7,2,2,3,24,1,12,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1813,'Kaiser_Knuckle','Kaiser Knuckle',5,20,NULL,450,110,NULL,1,0,0x00008100,7,2,2,4,36,1,12,'bonus bAtkEle,Ele_Wind; bonus2 bAddRace,RC_Undead,5; bonus2 bAddEle,Ele_Water,10; bonus2 bAddEle,Ele_Earth,10; bonus2 bAddEle,Ele_Fire,10; bonus2 bAddEle,Ele_Wind,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1814,'Berserk','Berserk',5,20,NULL,500,120,NULL,1,0,0x00008100,7,2,2,4,36,1,12,'bonus bAspdRate,12;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1815,'Claw_Of_Garm','Hatii Claw',5,20,NULL,550,152,NULL,1,1,0x00008100,7,2,2,4,70,1,12,'bonus bAtkEle,Ele_Dark; bonus bMaxHPrate,-2; bonus2 bAddEff,Eff_Bleeding,200;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1816,'Berserk_','Berserk',5,20,NULL,500,120,NULL,1,1,0x00008100,7,2,2,4,36,1,12,'bonus bAspdRate,12;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1817,'Kaiser_Knuckle_C','Kaiser Knuckle',5,1,NULL,0,159,NULL,1,0,0x00008100,7,2,2,4,1,0,12,'bonus bAtkEle,Ele_Wind; bonus2 bAddRace,RC_Undead,5; bonus2 bAddEle,Ele_Water,10; bonus2 bAddEle,Ele_Earth,10; bonus2 bAddEle,Ele_Fire,10; bonus2 bAddEle,Ele_Wind,10; bonus bAspdRate,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1818,'Magma_Fist','Magma Fist',5,20,NULL,650,80,NULL,1,3,0x00008100,7,2,2,3,75,1,12,'bonus3 bAutoSpell,"SA_FLAMELAUNCHER",5,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1819,'Icicle_Fist','Icicle Fist',5,20,NULL,650,80,NULL,1,3,0x00008100,7,2,2,3,75,1,12,'bonus3 bAutoSpell,"SA_FROSTWEAPON",5,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1820,'Electric_Fist','Electric Fist',5,20,NULL,650,80,NULL,1,3,0x00008100,7,2,2,3,75,1,12,'bonus3 bAutoSpell,"SA_LIGHTNINGLOADER",5,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1821,'Seismic_Fist','Seismic Fist',5,20,NULL,650,80,NULL,1,3,0x00008100,7,2,2,3,75,1,12,'bonus3 bAutoSpell,"SA_SEISMICWEAPON",5,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1822,'Combo_Battle_Glove','Combo Battle Glove',5,20,NULL,500,30,NULL,1,4,0x00008100,7,2,2,3,60,1,12,'bonus2 bSkillAtk,"MO_TRIPLEATTACK",15; bonus2 bSkillAtk,"MO_CHAINCOMBO",15; bonus2 bSkillAtk,"MO_COMBOFINISH",20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1823,'BF_Knuckle1','Valorous Battle Fist',5,20,NULL,0,30,NULL,1,0,0x00008100,7,2,2,3,80,1,12,'bonus bStr,2; bonus bAgi,1; bonus2 bAddRace,RC_DemiHuman,95; bonus2 bAddRace,RC_Player,95; bonus2 bIgnoreDefRaceRate,RC_DemiHuman,20; bonus2 bIgnoreDefRaceRate,RC_Player,20; bonus4 bAutoSpell,"CH_SOULCOLLECT",1,5,0; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1824,'BF_Knuckle2','Brave Battle Fist',5,20,NULL,0,30,NULL,1,0,0x00008100,7,2,2,3,80,1,12,'bonus bStr,2; bonus bInt,1; bonus2 bAddRace,RC_DemiHuman,95; bonus2 bAddRace,RC_Player,95; bonus2 bCastrate,"MO_EXTREMITYFIST",-25; autobonus "{ bonus2 bCastrate,\\\"MO_EXTREMITYFIST\\\",-100; }",50,6000,BF_WEAPON,"{ specialeffect2 EF_SUFFRAGIUM; }"; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1825,'Horn_Of_Hilthrion','Horn of Hillslion',5,20,NULL,600,95,NULL,1,3,0x00008000,2,2,2,3,60,1,12,'bonus3 bAutoSpell,"NPC_CRITICALWOUND",1,100; bonus4 bAutoSpellOnSkill,"CH_PALMSTRIKE","MO_INVESTIGATE",1,100; bonus3 bAutoSpell,"MO_CALLSPIRITS",5,100;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1826,'Krieger_Knuckle1','Glorious Claw',5,20,NULL,0,30,NULL,1,0,0x00008100,7,2,2,4,80,1,12,'bonus2 bAddRace,RC_DemiHuman,95; bonus2 bAddRace,RC_Player,95; bonus2 bIgnoreDefRaceRate,RC_DemiHuman,20; bonus2 bIgnoreDefRaceRate,RC_Player,20; bonus bUnbreakableWeapon; if(getrefine()>5) { bonus2 bAddRace,RC_DemiHuman,(getrefine()-4)*(getrefine()-4); bonus2 bAddRace,RC_Player,(getrefine()-4)*(getrefine()-4); bonus2 bIgnoreDefRaceRate,RC_DemiHuman,5; bonus2 bIgnoreDefRaceRate,RC_Player,5; } if(getrefine()>8) { bonus3 bAutoSpell,"MO_INVESTIGATE",5,(getrefine()*10-50); bonus3 bAutoSpell,"AL_DECAGI",1,(getrefine()*10-50); }',NULL,NULL);
REPLACE INTO `item_db` VALUES (1827,'Krieger_Knuckle2','Glorious Fist',5,20,NULL,0,30,NULL,1,0,0x00008100,7,2,2,4,80,1,12,'bonus2 bAddRace,RC_DemiHuman,95; bonus2 bAddRace,RC_Player,95; bonus2 bIgnoreDefRaceRate,RC_DemiHuman,20; bonus2 bIgnoreDefRaceRate,RC_Player,20; bonus bUnbreakableWeapon; if(getrefine()>5) { bonus2 bAddRace,RC_DemiHuman,(getrefine()-4)*(getrefine()-4); bonus2 bAddRace,RC_Player,(getrefine()-4)*(getrefine()-4); bonus2 bIgnoreDefRaceRate,RC_DemiHuman,5; bonus2 bIgnoreDefRaceRate,RC_Player,5; } if(getrefine()>8) { bonus2 bCastrate,"MO_EXTREMITYFIST",-100; bonus4 bautospellonskill,"MO_EXPLOSIONSPIRITS","CH_SOULCOLLECT",1,1000; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (1828,'Monk_Knuckle','Monk Knuckle',5,20,NULL,0,150,NULL,1,0,0x00008100,7,2,2,4,0,0,12,'bonus bInt,2; bonus2 bSkillAtk,"MO_FINGEROFFENSIVE",25;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1829,'Fist_C','Fist',5,0,NULL,0,150,NULL,1,0,0x00008100,7,2,2,3,1,0,12,'bonus2 bAddSize,Size_All,40;',NULL,NULL);
# Instruments
REPLACE INTO `item_db` VALUES (1901,'Violin','Violin',5,4000,NULL,700,50,NULL,1,3,0x00080000,7,1,2,1,2,1,13,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1902,'Violin_','Violin',5,4000,NULL,700,50,NULL,1,4,0x00080000,7,1,2,1,2,1,13,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1903,'Mandolin','Mandolin',5,18000,NULL,400,90,NULL,1,2,0x00080000,7,1,2,2,14,1,13,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1904,'Mandolin_','Mandolin',5,18000,NULL,400,90,NULL,1,3,0x00080000,7,1,2,2,14,1,13,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1905,'Lute','Lute',5,24500,NULL,500,105,NULL,1,2,0x00080000,7,1,2,2,14,1,13,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1906,'Lute_','Lute',5,24500,NULL,500,105,NULL,1,3,0x00080000,7,1,2,2,14,1,13,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1907,'Guitar','Guitar',5,47000,NULL,900,142,NULL,1,0,0x00080000,7,1,2,3,27,1,13,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1908,'Guitar_','Guitar',5,47000,NULL,900,142,NULL,1,1,0x00080000,7,1,2,3,27,1,13,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1909,'Harp','Harp',5,62000,NULL,900,114,NULL,1,1,0x00080000,7,1,2,3,27,1,13,'bonus bInt,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1910,'Harp_','Harp',5,62000,NULL,900,114,NULL,1,2,0x00080000,7,1,2,3,27,1,13,'bonus bInt,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1911,'Guh_Moon_Goh','Gumoongoh',5,54000,NULL,1300,126,NULL,1,1,0x00080000,7,1,2,3,27,1,13,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1912,'Guh_Moon_Goh_','Gumoongoh',5,54000,NULL,1300,126,NULL,1,2,0x00080000,7,1,2,3,27,1,13,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1913,'Electronic_Guitar','Electric Guitar',5,20,NULL,1800,110,NULL,1,0,0x00080000,7,1,2,4,70,1,13,'skill "WZ_JUPITEL",1; bonus3 bAutoSpell,"WZ_JUPITEL",1,100; bonus bAtkEle,Ele_Wind; bonus bInt,2; bonus bAgi,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1914,'Guitar_Of_Passion','Burning Passion Guitar',5,20,NULL,900,110,NULL,1,0,0x00080000,7,1,2,3,27,1,13,'bonus bAtkEle,Ele_Fire;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1915,'Guitar_Of_Blue_Solo','Loner\'s Guitar',5,20,NULL,900,110,NULL,1,0,0x00080000,7,1,2,3,27,1,13,'bonus bAtkEle,Ele_Water;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1916,'Guitar_Of_Vast_Land','Green Acre Guitar',5,20,NULL,900,110,NULL,1,0,0x00080000,7,1,2,3,27,1,13,'bonus bAtkEle,Ele_Earth;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1917,'Guitar_Of_Gentle_Breeze','Gentle Breeze Guitar',5,20,NULL,900,110,NULL,1,0,0x00080000,7,1,2,3,27,1,13,'bonus bAtkEle,Ele_Wind;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1918,'Oriental_Lute','Oriental Lute',5,20,NULL,1200,150,NULL,1,0,0x00080000,7,1,2,4,65,1,13,'bonus2 bSkillAtk,"CG_ARROWVULCAN",10; bonus2 bSkillAtk,"BA_MUSICALSTRIKE",10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1919,'Base_Guitar','Bass Guitar',5,20,NULL,1500,130,NULL,1,1,0x00080000,2,1,2,3,70,1,13,'bonus bSPGainValue,3; bonus4 bAutoSpellWhenHit,"WZ_HEAVENDRIVE",3,30,1; bonus3 bAutoSpell,"NPC_WIDECONFUSE",2,100;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1920,'Berserk_Guitar','Berserk Guitar',5,20,NULL,1800,10,NULL,1,0,0x00080000,2,1,2,4,70,1,13,'bonus bAspdRate,100; bonus bHPrecovRate,-100; bonus2 bHPLossRate,50,5000; bonus bDex,-readparam(bDex);',NULL,NULL);
REPLACE INTO `item_db` VALUES (1921,'Guh_Moon_Gom','Gun Moon Gom',5,20,NULL,0,120,NULL,1,0,0x00080000,7,1,2,1,0,0,13,'bonus2 bAddClass,Class_All,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1922,'Oriental_Lute_','Oriental Lute',5,20,NULL,1200,150,NULL,1,2,0x00080000,7,1,2,4,65,1,13,'bonus2 bSkillAtk,"CG_ARROWVULCAN",10; bonus2 bSkillAtk,"BA_MUSICALSTRIKE",10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1923,'BF_Instrument1','Valorous Battlefield Guitar',5,20,NULL,0,50,NULL,1,0,0x00080000,7,1,2,3,80,1,13,'bonus bDex,2; bonus2 bAddRace,RC_DemiHuman,95; bonus2 bAddRace,RC_Player,95; bonus2 bIgnoreDefRaceRate,RC_DemiHuman,20; bonus2 bIgnoreDefRaceRate,RC_Player,20; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1924,'BF_Instrument2','Brave Battlefield Guitar',5,20,NULL,0,50,NULL,1,0,0x00080000,7,1,2,3,80,1,13,'bonus bDex,2; bonus2 bAddRace,RC_DemiHuman,95; bonus2 bAddRace,RC_Player,95; bonus2 bSkillAtk,"CG_ARROWVULCAN",20; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1925,'Cello','Cello',5,20,NULL,700,110,NULL,1,3,0x00080000,2,1,2,3,70,1,13,'bonus bAgi,2; bonus bDex,3; bonus2 bAddSkillBlow,"BA_MUSICALSTRIKE",2; bonus2 bAddSkillBlow,"CG_ARROWVULCAN",3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1926,'Harp_Of_Nepenthes','Harp of Nepenthes',5,20,NULL,1000,120,NULL,1,2,0x00080000,2,1,2,4,60,1,13,'bonus bInt,2; if( getrefine()>9 ) { bonus3 bAddEffOnSkill,"BA_MUSICALSTRIKE",Eff_Stun,2000; } else { bonus3 bAddEffOnSkill,"BA_MUSICALSTRIKE",Eff_Stun,1000; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (1927,'Krieger_Instrument1','Glorious Guitar',5,20,NULL,0,50,NULL,1,0,0x00080000,7,1,2,4,80,1,13,'bonus2 bAddRace,RC_DemiHuman,95; bonus2 bAddRace,RC_Player,95; bonus2 bIgnoreDefRaceRate,RC_DemiHuman,20; bonus2 bIgnoreDefRaceRate,RC_Player,20; bonus bUnbreakableWeapon; if(getrefine()>5) { bonus2 bAddRace,RC_DemiHuman,(getrefine()-4)*(getrefine()-4); bonus2 bAddRace,RC_Player,(getrefine()-4)*(getrefine()-4); bonus2 bIgnoreDefRaceRate,RC_DemiHuman,5; bonus2 bIgnoreDefRaceRate,RC_Player,5; } if(getrefine()>8) bonus4 bAutoSpellOnSkill,"CG_ARROWVULCAN","CG_TAROTCARD",5,100;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1928,'Berserk_Guitar_I','Spirited Guitar',5,0,NULL,0,40,NULL,1,0,0x00080000,2,1,2,4,0,0,13,'bonus bAspdRate,100; bonus bHPrecovRate,-100; bonus2 bHPLossRate,50,5000; bonus bDex,-readparam(bDex);',NULL,NULL);
REPLACE INTO `item_db` VALUES (1929,'Guitar_C','Guitar',5,0,NULL,0,177,NULL,1,0,0x00080000,7,1,2,3,1,0,13,'bonus2 bAddSize,Size_All,40;',NULL,NULL);
# Whips
REPLACE INTO `item_db` VALUES (1950,'Rope','Rope',5,2500,NULL,400,45,NULL,2,3,0x00080000,7,0,2,1,3,1,14,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1951,'Rope_','Rope',5,2500,NULL,400,45,NULL,2,4,0x00080000,7,0,2,1,3,1,14,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1952,'Line','Whip',5,12000,NULL,300,80,NULL,2,2,0x00080000,7,0,2,2,16,1,14,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1953,'Line_','Whip',5,12000,NULL,300,80,NULL,2,3,0x00080000,7,0,2,2,16,1,14,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1954,'Wire','Wire Whip',5,17500,NULL,1000,95,NULL,2,2,0x00080000,7,0,2,2,16,1,14,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1955,'Wire_','Wire Whip',5,17500,NULL,1000,95,NULL,2,3,0x00080000,7,0,2,2,16,1,14,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1956,'Rante','Rante Whip',5,32000,NULL,900,135,NULL,2,0,0x00080000,7,0,2,3,30,1,14,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1957,'Rante_','Rante Whip',5,32000,NULL,900,135,NULL,2,1,0x00080000,7,0,2,3,30,1,14,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1958,'Tail','Tail Whip',5,41000,NULL,700,105,NULL,2,1,0x00080000,7,0,2,3,30,1,14,'bonus bLuk,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1959,'Tail_','Tail Whip',5,41000,NULL,700,105,NULL,2,2,0x00080000,7,0,2,3,30,1,14,'bonus bLuk,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1960,'Whip','Whip',5,38000,NULL,700,120,NULL,2,1,0x00080000,7,0,2,3,30,1,14,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1961,'Whip_','Whip',5,38000,NULL,700,120,NULL,2,2,0x00080000,7,0,2,3,30,1,14,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (1962,'Lariat','Lariat Whip',5,20,NULL,400,100,NULL,2,0,0x00080000,7,0,2,4,44,1,14,'bonus bDex,5; bonus bAgi,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1963,'Rapture_Rose','Rapture Rose',5,20,NULL,300,115,NULL,2,0,0x00080000,7,0,2,4,44,1,14,'bonus bAtkEle,Ele_Poison; bonus2 bAddEff,Eff_Poison,5000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1964,'Chemeti','Chemeti Whip',5,20,NULL,700,135,NULL,2,0,0x00080000,7,0,2,4,44,1,14,'bonus bCritical,5; bonus bFlee,10; bonus bFlee2,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1965,'Whip_Of_Red_Flame','Red Flame Whip',5,20,NULL,700,110,NULL,2,0,0x00080000,7,0,2,3,30,1,14,'bonus bAtkEle,Ele_Fire;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1966,'Whip_Of_Ice_Piece','Icicle Whip',5,20,NULL,700,110,NULL,2,0,0x00080000,7,0,2,3,30,1,14,'bonus bAtkEle,Ele_Water;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1967,'Whip_Of_Earth','Gaia Whip',5,20,NULL,700,110,NULL,2,0,0x00080000,7,0,2,3,30,1,14,'bonus bAtkEle,Ele_Earth;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1968,'Jump_Rope','Skipping Rope',5,20,NULL,400,120,NULL,2,0,0x00080000,7,0,2,3,30,1,14,'bonus bCritical,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1969,'Bladed_Whip','Blade Whip',5,20,NULL,1200,140,NULL,2,0,0x00080000,7,0,2,4,30,1,14,'bonus2 bAddEff,Eff_Bleeding,300;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1970,'Queen\'s_Whip','Queen\'s Whip',5,20,NULL,1100,150,NULL,2,0,0x00080000,7,0,2,4,65,1,14,'bonus2 bSkillAtk,"CG_ARROWVULCAN",10; bonus2 bSkillAtk,"DC_THROWARROW",10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1971,'Electric_Wire','Electric Wire',5,20,NULL,700,110,NULL,2,0,0x00080000,7,0,2,3,30,1,14,'bonus bAtkEle,Ele_Wind;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1972,'Electric_Eel','Electric Eel',5,20,NULL,2000,100,NULL,2,2,0x00080000,2,0,2,4,70,1,14,'bonus bAtkEle,Ele_Wind; bonus bInt,2; bonus bAgi,2; bonus3 bAutoSpell,"WZ_JUPITEL",3,20; if(getrefine()>0) bonus3 bAutoSpell,"CG_ARROWVULCAN",getrefine(),50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1973,'Sea_Witch_Foot','Sea Witch\'s Foot',5,20,NULL,1500,110,NULL,2,1,0x00080000,2,0,2,4,70,1,14,'bonus bSPGainValue,5; bonus4 bAutoSpellWhenHit,"WZ_FROSTNOVA",3,50,1; bonus3 bAutoSpell,"NPC_WIDESILENCE",2,100;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1974,'Carrot_Whip','Carrot Whip',5,20,NULL,1300,185,NULL,2,0,0x00080000,2,0,2,4,70,1,14,'if(getrefine()>0) bonus3 bAutoSpell,"AL_INCAGI",getrefine(),10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1975,'Queen_Is_Whip','Queen Is Whip',5,20,NULL,0,120,NULL,2,0,0x00080000,7,0,2,1,0,0,14,'bonus2 bAddClass,Class_All,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1976,'Queen\'s_Whip_','Queen\'s Whip',5,20,NULL,1100,150,NULL,2,2,0x00080000,7,0,2,4,65,1,14,'bonus2 bSkillAtk,"CG_ARROWVULCAN",10; bonus2 bSkillAtk,"DC_THROWARROW",10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1977,'BF_Whip1','Valorous Battle Lariat',5,20,NULL,0,50,NULL,2,0,0x00080000,7,0,2,3,80,1,14,'bonus bDex,2; bonus2 bAddRace,RC_DemiHuman,95; bonus2 bAddRace,RC_Player,95; bonus2 bIgnoreDefRaceRate,RC_DemiHuman,20; bonus2 bIgnoreDefRaceRate,RC_Player,20; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1978,'BF_Whip2','Brave Battle Lariat',5,20,NULL,0,50,NULL,2,0,0x00080000,7,0,2,3,80,1,14,'bonus bDex,2; bonus2 bAddRace,RC_DemiHuman,95; bonus2 bAddRace,RC_Player,95; bonus2 bSkillAtk,"CG_ARROWVULCAN",20; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1979,'Stem_Of_Nepenthes','Stem of Nepenthes',5,20,NULL,1000,120,NULL,2,2,0x00080000,2,0,2,4,60,1,14,'bonus bInt,2; if( getrefine()>=9 ) { bonus3 bAddEffOnSkill,"DC_THROWARROW",Eff_Freeze,2000; } else { bonus3 bAddEffOnSkill,"DC_THROWARROW",Eff_Freeze,1000; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (1980,'Whip_Of_Balance','Whip of Balance',5,20,NULL,700,110,NULL,2,3,0x00080000,2,0,2,3,70,1,14,'bonus bAgi,2; bonus bDex,3; bonus2 bAddSkillBlow,"DC_THROWARROW",2; bonus2 bAddSkillBlow,"CG_ARROWVULCAN",3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1981,'Krieger_Whip1','Glorious Lariat',5,20,NULL,0,50,NULL,2,0,0x00080000,7,0,2,4,80,1,14,'bonus2 bAddRace,RC_DemiHuman,95; bonus2 bAddRace,RC_Player,95; bonus2 bIgnoreDefRaceRate,RC_DemiHuman,20; bonus2 bIgnoreDefRaceRate,RC_Player,20; bonus bUnbreakableWeapon; if(getrefine()>5) { bonus2 bAddRace,RC_DemiHuman,(getrefine()-4)*(getrefine()-4); bonus2 bAddRace,RC_Player,(getrefine()-4)*(getrefine()-4); bonus2 bIgnoreDefRaceRate,RC_DemiHuman,5; bonus2 bIgnoreDefRaceRate,RC_Player,5; } if(getrefine()>8) bonus4 bAutoSpellOnSkill,"CG_ARROWVULCAN","CG_TAROTCARD",5,100;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1982,'Phenomena_Whip','Phenomena Whip',5,20,NULL,0,160,NULL,2,0,0x00080000,7,0,2,4,0,0,14,'bonus bDex,2; bonus2 bSkillAtk,"DC_THROWARROW",25;',NULL,NULL);
REPLACE INTO `item_db` VALUES (1983,'Rante_C','Rante Whip',5,0,NULL,0,170,NULL,2,0,0x00080000,7,0,2,3,1,0,14,'bonus2 bAddSize,Size_All,40;',NULL,NULL);
# Additional 2-Handed Staffs
REPLACE INTO `item_db` VALUES (2000,'Destruction_Rod','Staff of Destruction',5,20,NULL,2500,130,NULL,1,1,0x00000200,2,2,34,4,80,1,23,'bonus bMatkRate,25+getrefine()/2; bonus bInt,3; bonus bAgi,10; bonus bUseSPrate,(getrefine()*2); bonus3 bAutoSpellWhenHit,"WZ_JUPITEL",5,(getrefine()*20); bonus2 bCastrate,"HW_MAGICPOWER",-50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2001,'Divine_Cross','Divine Cross',5,20,NULL,1500,120,NULL,1,0,0x00008100,7,2,34,4,70,1,23,'bonus bAtkEle,Ele_Holy; bonus bMatkRate,15; bonus bDex,4; bonus2 bSubRace,RC_Demon,15; bonus2 bSubRace,RC_Undead,15;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2002,'Krieger_Twohand_Staff1','Glorious Destruction Staff',5,20,NULL,0,70,NULL,1,0,0x00018314,7,2,34,4,80,1,23,'bonus bMatkRate,getrefine(); bonus2 bMagicAddRace,RC_DemiHuman,15; bonus2 bMagicAddRace,RC_Player,15; bonus2 bIgnoreMdefRaceRate,RC_DemiHuman,25; bonus2 bIgnoreMdefRaceRate,RC_Player,25; bonus bUnbreakableWeapon; if(getrefine()>5) { bonus2 bMagicAddRace,RC_DemiHuman,(getrefine()-5)*2; bonus2 bMagicAddRace,RC_Player,(getrefine()-5)*2; bonus2 bIgnoreMdefRaceRate,RC_DemiHuman,5+(getrefine()-5)*2; bonus2 bIgnoreMdefRaceRate,RC_Player,5+(getrefine()-5)*2; } if(getrefine()>8) { bonus5 bAutoSpellOnSkill,"WZ_STORMGUST","MG_SAFETYWALL",10,200,1; bonus5 bAutoSpellOnSkill,"WZ_METEOR","MG_SAFETYWALL",10,200,1; bonus5 bAutoSpellOnSkill,"WZ_VERMILION","MG_SAFETYWALL",10,200,1; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (2003,'Destruction_Rod_M','Staff of Destruction',5,20,NULL,2500,130,NULL,1,1,0x00000200,2,2,34,4,80,1,23,'bonus bMatkRate,25+getrefine()/2; bonus bInt,3; bonus bAgi,10; bonus bUseSPrate,(getrefine()*2); bonus3 bAutoSpellWhenHit,"WZ_JUPITEL",5,(getrefine()*20); bonus2 bCastrate,"HW_MAGICPOWER",-50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2004,'Kronos','Kronos',5,20,NULL,1000,30,NULL,1,0,0x00010204,2,2,34,4,50,1,23,'bonus bMatkRate,20; bonus bInt,3+(getrefine()/2); bonus bMaxHP,300+(50*getrefine()/2); autobonus "{ bonus bMatkRate,12; bonus buseSPRate,20; }",1,5000,BF_MAGIC,"{ specialeffect2 EF_ENHANCE; }";',NULL,NULL);
REPLACE INTO `item_db` VALUES (2005,'Dea_Staff','Dea Staff',5,20,NULL,1000,30,NULL,1,1,0x00008110,2,2,34,3,50,1,23,'bonus bAtkEle,Ele_Holy; bonus bMatkRate,15+getrefine()/2; bonus bInt,6; bonus bVit,2; autobonus3 "{ }",20,1000,"AL_HEAL","{ specialeffect2 EF_MAGICALATTHIT; heal 0,200; }";',NULL,NULL);
REPLACE INTO `item_db` VALUES (2006,'G_Staff_Of_Light','Staff Of Light',5,20,NULL,1900,80,NULL,1,0,0x00810204,7,2,34,4,60,1,23,'/* bonus bMatk,150; */ bonus bAtkEle,Ele_Holy; bonus bInt,6;',NULL,NULL);
# Shields
#===================================================================
REPLACE INTO `item_db` VALUES (2101,'Guard','Guard',4,500,NULL,300,NULL,3,NULL,0,0xFFFFFFFF,7,2,32,NULL,0,1,1,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2102,'Guard_','Guard',4,500,NULL,300,NULL,3,NULL,1,0xFFFFFFFF,7,2,32,NULL,0,1,1,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2103,'Buckler','Buckler',4,14000,NULL,600,NULL,4,NULL,0,0x000ED5F2,7,2,32,NULL,0,1,2,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2104,'Buckler_','Buckler',4,14000,NULL,600,NULL,4,NULL,1,0x000ED5F2,7,2,32,NULL,0,1,2,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2105,'Shield','Shield',4,56000,NULL,1300,NULL,6,NULL,0,0x00004082,7,2,32,NULL,0,1,3,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2106,'Shield_','Shield',4,56000,NULL,1300,NULL,6,NULL,1,0x00004082,7,2,32,NULL,0,1,3,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2107,'Mirror_Shield','Mirror Shield',4,60000,NULL,1000,NULL,4,NULL,0,0x00404082,7,2,32,NULL,0,1,4,'bonus bMdef,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2108,'Mirror_Shield_','Mirror Shield',4,60000,NULL,1000,NULL,4,NULL,1,0x00404082,7,2,32,NULL,0,1,4,'bonus bMdef,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2109,'Memorize_Book','Memory Book',4,20,NULL,1000,NULL,3,NULL,0,0x00810204,7,2,32,NULL,0,1,5,'bonus bInt,1; bonus bMdef,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2110,'Holy_Guard','Holy Guard',4,85000,NULL,1400,NULL,5,NULL,0,0x00004000,7,2,32,NULL,68,0,4,'bonus bVit,2; bonus bMdef,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2111,'Herald_Of_GOD','Sacred Mission',4,128000,NULL,1600,NULL,5,NULL,0,0x00004000,7,2,32,NULL,83,1,4,'bonus bVit,3; bonus bInt,2; bonus bMdef,3; bonus bUnbreakableShield;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2112,'Novice_Guard','Novice Guard',4,1,NULL,1,NULL,3,NULL,0,0x00000001,7,2,32,NULL,0,0,1,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2113,'Novice_Shield','Novice Shield',4,5000,NULL,1000,NULL,3,NULL,1,0x00000001,7,2,32,NULL,40,1,3,'bonus2 bSubEle,Ele_Water,20; bonus2 bSubEle,Ele_Earth,20; bonus2 bSubEle,Ele_Fire,20; bonus2 bSubEle,Ele_Wind,20; bonus2 bSubEle,Ele_Poison,20; bonus2 bSubEle,Ele_Ghost,20; bonus2 bSubEle,Ele_Undead,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2114,'Stone_Buckler','Stone Buckler',4,30000,NULL,1500,NULL,3,NULL,1,0xFFFFFFFE,7,2,32,NULL,65,1,2,'bonus2 bSubSize,Size_Large,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2115,'Valkyrja\'s_Shield','Valkyrja\'s Shield',4,30000,NULL,500,NULL,3,NULL,1,0xFFFFFFFE,7,2,32,NULL,65,1,4,'bonus2 bSubEle,Ele_Water,20; bonus2 bSubEle,Ele_Fire,20; bonus2 bSubEle,Ele_Dark,20; bonus2 bSubEle,Ele_Undead,20; bonus bMdef,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2116,'Angel\'s_Safeguard','Angelic Guard',4,10000,NULL,400,NULL,3,NULL,1,0x00000001,7,2,32,NULL,20,1,1,'bonus2 bSubRace,RC_Demon,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2117,'Arm_Guard','Arm Guard',4,10000,NULL,150,NULL,5,NULL,0,0x02000000,7,2,32,NULL,20,1,1,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2118,'Arm_Guard_','Arm Guard',4,10000,NULL,150,NULL,5,NULL,1,0x02000000,7,2,32,NULL,20,1,1,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2119,'Improved_Arm_Guard','Advanced Arm Guard',4,40000,NULL,150,NULL,4,NULL,0,0x02000000,7,2,32,NULL,50,1,1,'bonus bMdef,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2120,'Improved_Arm_Guard_','Advanced Arm Guard',4,40000,NULL,150,NULL,4,NULL,1,0x02000000,7,2,32,NULL,50,1,1,'bonus bMdef,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2121,'Memorize_Book_','Memory Book',4,20,NULL,1000,NULL,3,NULL,1,0x00810204,7,2,32,NULL,0,1,5,'bonus bInt,1; bonus bMdef,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2122,'Platinum_Shield','Platinum Shield',4,20,NULL,1200,NULL,5,NULL,0,0xFFFFFFFE,2,2,32,NULL,68,1,4,'bonus bMdef,5; bonus2 bSubSize,Size_Medium,15; bonus2 bSubSize,Size_Large,15; bonus2 bSubRace,RC_Undead,10; bonus5 bAutoSpellWhenHit,"NPC_MAGICMIRROR",7,150,BF_MAGIC,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2123,'Orleans_Server','Orleans\'s Server',4,20,NULL,1000,NULL,5,NULL,1,0xFFFFFFFE,2,2,32,NULL,55,1,4,'bonus bMdef,2; bonus bMagicDamageReturn,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2124,'Thorny_Buckler','Thorny Buckler',4,20,NULL,1000,NULL,5,NULL,1,0xFFFFFFFE,2,2,32,NULL,55,1,2,'bonus bMdef,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2125,'Strong_Shield','Strong Shield',4,20,NULL,2500,NULL,4,NULL,1,0xFFFFFFFE,2,2,32,NULL,75,1,4,'bonus bNoKnockback; bonus2 bSubEle,Ele_Neutral,-20; bonus2 bSubEle,Ele_Fire,-20; bonus2 bSubEle,Ele_Water,-20; bonus2 bSubEle,Ele_Wind,-20; bonus2 bSubEle,Ele_Earth,-20; bonus2 bSubEle,Ele_Dark,-20; bonus2 bSubEle,Ele_Holy,-20; bonus2 bSubEle,Ele_Ghost,-20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2126,'Guyak_Shield','Guyak Shield',4,20,NULL,700,NULL,3,NULL,0,0xFFFFFFFE,7,2,32,NULL,75,1,2,'bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2127,'Secular_Mission','Secular Mission',4,20,NULL,0,NULL,10,NULL,0,0xFFFFFFFF,7,2,32,NULL,0,0,4,'bonus2 bSubClass,Class_All,25;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2128,'Herald_Of_GOD_','Sacred Mission',4,128000,NULL,1600,NULL,5,NULL,1,0x00004000,7,2,32,NULL,83,1,4,'bonus bVit,3; bonus bInt,2; bonus bMdef,3; bonus bUnbreakableShield;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2129,'Exorcism_Bible','Exorcism Bible',4,20,NULL,600,NULL,5,NULL,0,0x00008100,7,2,32,NULL,50,1,5,'bonus bHPrecovRate,3; bonus bSPrecovRate,3; bonus bInt,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2130,'Cross_Shield','Cross Shield',4,20,NULL,2000,NULL,6,NULL,1,0x00004000,7,2,32,NULL,80,1,4,'bonus bStr,1; bonus2 bSkillAtk,"PA_SHIELDCHAIN",30; bonus2 bSkillAtk,"CR_SHIELDBOOMERANG",30; bonus bUseSPrate,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2131,'Magic_Study_Vol1','Magic Bible Vol1',4,20,NULL,1000,NULL,2,NULL,1,0x00810204,2,2,32,NULL,70,1,5,'bonus bMdef,3; bonus bInt,2; bonus2 bAddEffWhenHit,Eff_Stun,1000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2132,'Shelter_Resistance','Shell Of Resistance',4,20,NULL,0,NULL,9,NULL,0,0xFFFFFFFF,7,2,32,NULL,0,0,2,'bonus2 bSubEle,Ele_All,20; bonus bShortWeaponDamageReturn,1; if (vip_status(VIP_STATUS_ACTIVE)) { bonus bAllStats,1; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (2133,'Tournament_Shield','Tournament Shield',4,20,NULL,1000,NULL,5,NULL,1,0x00004082,2,2,32,NULL,50,1,4,'bonus2 bAddClass,Class_All,1; if( Class==Job_Lord_Knight ) bonus bAspdRate,-5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2134,'Shield_Of_Naga','Shield of Naga',4,20,NULL,500,NULL,3,NULL,1,0x00CFFF80,2,2,32,NULL,70,1,2,'bonus bMdef,3; autobonus2 "{ bonus bShortWeaponDamageReturn,(getrefine()*3); }",10,5000,BF_WEAPON,"{ specialeffect2 EF_GUARD; }";',NULL,NULL);
REPLACE INTO `item_db` VALUES (2135,'Shadow_Guard','Shadow Guard',4,20,NULL,800,NULL,4,NULL,1,0x00020000,2,2,32,NULL,70,1,2,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2136,'Cracked_Buckler','Cracked Buckler',4,0,NULL,0,NULL,5,NULL,0,0xFFFFFFFF,7,2,32,NULL,0,0,2,'bonus bAgi,2; bonus2 bAddEle,Ele_Neutral,-10; bonus3 bAutoSpellWhenHit,"PR_KYRIE",1,50; bonus bMdef,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2137,'Valkyrja\'s_Shield_C','Neo Valkyrja\'s Shield',4,0,NULL,0,NULL,5,NULL,0,0xFFFFFFFE,2,2,32,NULL,95,0,4,'bonus2 bSubEle,Ele_Water,20; bonus2 bSubEle,Ele_Fire,20; bonus2 bSubEle,Ele_Dark,20; bonus2 bSubEle,Ele_Undead,20; bonus bMdef,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2138,'Bradium_Shield','Bradium Shield',4,20,NULL,1800,NULL,5,NULL,1,0x00CFFF80,2,2,32,NULL,65,1,3,'bonus2 bSkillAtk,"CR_SHIELDBOOMERANG",60; bonus bAgi,-1; bonus bMaxHP,500;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2139,'Flame_Thrower','Flame Thrower',4,20000,NULL,2000,NULL,60,NULL,0,0x00000400,63,2,32,NULL,99,0,1,NULL,NULL,NULL);
# GM Shield
REPLACE INTO `item_db` VALUES (2199,'Ahura_Mazda','Ahura Mazdah',4,1,NULL,10,NULL,100,NULL,0,0xFFFFFFFF,7,2,32,NULL,1,1,0,'bonus bAllStats,50; bonus bMdef,99; bonus bShortWeaponDamageReturn,100; bonus2 bSubRace,RC_DemiHuman,95; bonus2 bSubRace,RC_Player,95; skill "CR_FULLPROTECTION",5; Skill "WZ_ESTIMATION",1; Skill "ST_FULLSTRIP",5; Skill "HW_MAGICPOWER",10; bonus bMaxHPRate,200; bonus bNoGemStone; bonus bSpeedRate,25; bonus bNoWalkDelay;',NULL,NULL);
# Headgears
#===================================================================
REPLACE INTO `item_db` VALUES (2201,'Sunglasses','Sunglasses',4,5000,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,512,NULL,0,0,12,'bonus2 bResEff,Eff_Blind,500;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2202,'Sunglasses_','Sunglasses',4,5000,NULL,100,NULL,0,NULL,1,0xFFFFFFFF,7,2,512,NULL,0,0,12,'bonus2 bResEff,Eff_Blind,500;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2203,'Glasses','Glasses',4,4000,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,512,NULL,0,0,3,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2204,'Glasses_','Glasses',4,4000,NULL,100,NULL,0,NULL,1,0xFFFFFFFF,7,2,512,NULL,0,0,3,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2205,'Diver\'s_Goggles','Diver Goggles',4,3500,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,512,NULL,0,0,10,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2206,'Wedding_Veil','Wedding Veil',4,23000,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,0,256,NULL,0,1,44,'bonus bMdef,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2207,'Fancy_Flower','Fancy Flower',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,0,4,'bonus2 bSubRace,RC_Plant,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2208,'Ribbon','Ribbon',4,800,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,7,0,256,NULL,0,1,17,'bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2209,'Ribbon_','Ribbon',4,800,NULL,100,NULL,1,NULL,1,0xFFFFFFFF,7,0,256,NULL,0,1,17,'bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2210,'Hair_Band','Hair Band',4,500,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,0,9,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2211,'Bandana','Bandana',4,400,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,6,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2212,'Eye_Bandage','Eye Patch',4,1000,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,512,NULL,0,0,13,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2213,'Cat_Hairband','Kitty Band',4,20,NULL,100,NULL,2,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,2,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2214,'Bunny_Band','Bunny Band',4,20,NULL,100,NULL,2,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,15,'bonus bLuk,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2215,'Flower_Hairband','Flower Band',4,20,NULL,100,NULL,2,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,5,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2216,'Biretta','Biretta',4,9000,NULL,100,NULL,4,NULL,0,0x00008110,7,2,256,NULL,0,1,11,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2217,'Biretta_','Biretta',4,9000,NULL,100,NULL,4,NULL,1,0x00008110,7,2,256,NULL,0,1,11,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2218,'Flu_Mask','Flu Mask',4,300,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,1,NULL,0,0,8,'bonus2 bResEff,Eff_Silence,1000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2219,'Flu_Mask_','Flu Mask',4,300,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,1,NULL,0,0,8,'bonus2 bResEff,Eff_Silence,1000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2220,'Hat','Hat',4,1000,NULL,200,NULL,2,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,16,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2221,'Hat_','Hat',4,1000,NULL,200,NULL,2,NULL,1,0xFFFFFFFF,7,2,256,NULL,0,1,16,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2222,'Turban','Turban',4,4500,NULL,300,NULL,3,NULL,0,0xFFFFFFFE,7,2,256,NULL,0,1,7,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2223,'Turban_','Turban',4,4500,NULL,300,NULL,3,NULL,1,0xFFFFFFFE,7,2,256,NULL,0,1,7,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2224,'Goggle','Goggles',4,20,NULL,300,NULL,5,NULL,0,0x000E5CEA,7,2,768,NULL,0,1,1,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2225,'Goggle_','Goggles',4,20,NULL,300,NULL,5,NULL,1,0x000E5CEA,7,2,768,NULL,0,1,1,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2226,'Cap','Cap',4,12000,NULL,400,NULL,4,NULL,0,0x000E5CEA,7,2,256,NULL,0,1,14,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2227,'Cap_','Cap',4,12000,NULL,400,NULL,4,NULL,1,0x000E5CEA,7,2,256,NULL,0,1,14,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2228,'Helm','Helm',4,44000,NULL,600,NULL,6,NULL,0,0x00004082,7,2,256,NULL,0,1,40,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2229,'Helm_','Helm',4,44000,NULL,600,NULL,6,NULL,1,0x00004082,7,2,256,NULL,0,1,40,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2230,'Gemmed_Sallet','Gemmed Sallet',4,50000,NULL,500,NULL,4,NULL,0,0x000654E2,7,2,256,NULL,0,1,0,'bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2231,'Gemmed_Sallet_','Gemmed Sallet',4,50000,NULL,500,NULL,4,NULL,1,0x000654E2,7,2,256,NULL,0,1,0,'bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2232,'Circlet','Circlet',4,7500,NULL,300,NULL,3,NULL,0,0x00818314,7,2,256,NULL,0,1,18,'bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2233,'Circlet_','Circlet',4,7500,NULL,300,NULL,3,NULL,1,0x00818314,7,2,256,NULL,0,1,18,'bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2234,'Tiara','Tiara',4,20,NULL,400,NULL,4,NULL,0,0xFFFFFFFE,7,0,256,NULL,45,1,19,'bonus bInt,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2235,'Crown','Crown',4,20,NULL,400,NULL,4,NULL,0,0xFFFFFFFE,7,1,256,NULL,45,1,45,'bonus bInt,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2236,'Santa\'s_Hat','Santa Hat',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,20,'bonus bMdef,1; bonus bLuk,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2237,'Weird_Goatee','Bandit Beard',4,2,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,1,NULL,0,0,21,NULL,NULL,NULL);
#REPLACE INTO `item_db` VALUES (2238,'Weird_Moustache','Moustache',4,2,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,1,NULL,0,0,22,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2239,'One_Eyed_Glass','Monocle',4,10000,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,512,NULL,0,0,23,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2240,'Beard','Beard',4,2,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,1,NULL,0,0,24,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2241,'Granpa_Beard','Grampa Beard',4,5000,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,1,NULL,0,0,25,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2242,'Luxury_Sunglasses','Purple Glasses',4,24000,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,7,2,512,NULL,0,0,26,'bonus2 bResEff,Eff_Blind,1000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2243,'Spinning_Eyes','Geek Glasses',4,20000,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,7,2,512,NULL,0,0,27,'bonus2 bResEff,Eff_Blind,1500;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2244,'Big_Sis\'_Ribbon','Big Ribbon',4,15000,NULL,200,NULL,2,NULL,0,0xFFFFFFFE,7,2,256,NULL,0,1,28,'bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2245,'Sweet_Gents','Sweet Gent',4,15000,NULL,400,NULL,3,NULL,0,0xFFFFFFFE,7,2,256,NULL,0,1,29,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2246,'Golden_Gear','Golden Gear',4,20,NULL,900,NULL,5,NULL,0,0xFFFFFFFE,7,2,256,NULL,40,1,30,'bonus bUnbreakableHelm;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2247,'Oldman\'s_Romance','Romantic Gent',4,15000,NULL,400,NULL,3,NULL,0,0xFFFFFFFE,7,2,256,NULL,0,1,31,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2248,'Western_Grace','Western Grace',4,15000,NULL,400,NULL,3,NULL,0,0xFFFFFFFE,7,2,256,NULL,0,1,32,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2249,'Coronet','Coronet',4,20,NULL,300,NULL,3,NULL,0,0xFFFFFFFE,7,2,256,NULL,0,1,33,'bonus bInt,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2250,'Fillet','Cute Ribbon',4,500,NULL,100,NULL,1,NULL,0,0xFFFFFFFE,7,2,256,NULL,0,0,34,'bonus bMaxSP,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2251,'Holy_Bonnet','Monk Hat',4,30000,NULL,100,NULL,5,NULL,0,0x00008110,7,2,256,NULL,0,1,35,'bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2252,'Star_Sparkling','Wizard Hat',4,20,NULL,300,NULL,4,NULL,0,0x00810204,7,2,256,NULL,0,1,36,'bonus bMaxSP,100;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2253,'Sunflower','Sunflower',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,0,37,'bonus2 bSubRace,RC_Insect,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2254,'Angelic_Chain','Angel Wing',4,20,NULL,100,NULL,2,NULL,0,0xFFFFFFFE,7,2,256,NULL,0,1,38,'bonus bMdef,3; bonus bAgi,1; bonus bLuk,1; bonus2 bSubRace,RC_Demon,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2255,'Satanic_Chain','Evil Wing',4,20,NULL,100,NULL,3,NULL,0,0xFFFFFFFE,7,2,256,NULL,0,1,39,'bonus bMdef,2; bonus bStr,1; bonus2 bSubRace,RC_Angel,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2256,'Magestic_Goat','Majestic Goat',4,20,NULL,800,NULL,5,NULL,0,0x006444A2,7,2,256,NULL,0,1,41,'bonus bStr,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2257,'Snowy_Horn','Unicorn Horn',4,20,NULL,100,NULL,2,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,42,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2258,'Sharp_Gear','Spiky Band',4,20,NULL,1000,NULL,6,NULL,0,0x0066D5F2,7,2,256,NULL,50,1,43,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2259,'Mini_Propeller','Mini Propeller',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,46,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2260,'Mini_Glasses','Mini Glasses',4,28000,NULL,100,NULL,1,NULL,0,0xFFFFFFFE,7,2,512,NULL,0,0,47,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2261,'Prontera_Army_Cap','Army Cap',4,20,NULL,400,NULL,4,NULL,0,0x000654E2,7,2,256,NULL,0,1,48,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2262,'Pierrot_Nose','Clown Nose',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,1,NULL,0,0,49,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2263,'Gangster_Patch','Zorro Masque',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFE,7,2,512,NULL,0,0,50,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2264,'Munak_Turban','Munak Hat',4,20,NULL,300,NULL,5,NULL,0,0xFFFFFFFF,7,2,769,NULL,0,0,51,'bonus2 bSubRace,RC_Undead,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2265,'Ganster_Mask','Gangster Mask',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,1,NULL,0,0,52,'bonus2 bResEff,Eff_Silence,1500;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2266,'Iron_Cane','Iron Cain',4,20,NULL,300,NULL,1,NULL,0,0x00004082,7,2,1,NULL,50,0,53,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2267,'Cigar','Cigarette',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFE,7,2,1,NULL,0,0,54,'bonus2 bSubRace,RC_Insect,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2268,'Smoking_Pipe','Pipe',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFE,7,2,1,NULL,0,0,55,'bonus2 bSubRace,RC_Insect,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2269,'Centimental_Flower','Romantic Flower',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFE,7,2,1,NULL,0,0,56,'bonus2 bSubRace,RC_Plant,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2270,'Centimental_Leaf','Romantic Leaf',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFE,7,2,1,NULL,0,0,57,'bonus2 bSubRace,RC_Plant,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2271,'Jack_A_Dandy','Jack be Dandy',4,45000,NULL,100,NULL,1,NULL,0,0xFFFFFFFE,7,2,256,NULL,0,0,58,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2272,'Stop_Post','Stop Post',4,20,NULL,400,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,59,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2273,'Doctor_Cap','Doctor Band',4,20,NULL,100,NULL,3,NULL,0,0xFFFFFFFE,7,2,256,NULL,0,1,60,'bonus bInt,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2274,'Ghost_Bandana','Ghost Bandana',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFE,7,2,256,NULL,0,1,61,'bonus bAgi,2; bonus2 bSubEle,Ele_Ghost,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2275,'Red_Bandana','Red Bandana',4,20,NULL,100,NULL,2,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,62,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2276,'Eagle_Eyes','Angled Glasses',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,7,2,512,NULL,0,0,63,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2277,'Nurse_Cap','Nurse Cap',4,20,NULL,100,NULL,2,NULL,0,0x00008110,7,2,256,NULL,0,1,64,'bonus bInt,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2278,'Mr_Smile','Mr. Smile',4,60,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,7,2,513,NULL,0,0,65,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2279,'Bomb_Wick','Bomb Wick',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,0,66,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2280,'Sahkkat','Sakkat',4,20,NULL,300,NULL,3,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,67,'bonus bAgi,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2281,'Phantom_Of_Opera','Opera Masque',4,20,NULL,200,NULL,2,NULL,0,0xFFFFFFFE,7,2,513,NULL,0,0,68,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2282,'Spirit_Chain','Halo',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,0,69,'bonus2 bSubEle,Ele_Holy,15;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2283,'Ear_Mufs','Ear Muffs',4,20,NULL,200,NULL,3,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,70,'bonus2 bResEff,Eff_Curse,1000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2284,'Antler','Antlers',4,20,NULL,500,NULL,4,NULL,0,0xFFFFFFFE,7,2,256,NULL,0,1,71,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2285,'Apple_Of_Archer','Apple of Archer',4,20,NULL,200,NULL,0,NULL,0,0xFFFFFFFE,7,2,256,NULL,30,1,72,'bonus bDex,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2286,'Elven_Ears','Elven Ears',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFE,7,2,512,NULL,70,0,73,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2287,'Pirate_Bandana','Pirate Bandana',4,20,NULL,100,NULL,3,NULL,0,0xFFFFFFFE,7,2,256,NULL,0,1,74,'bonus bStr,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2288,'Mr_Scream','Mr. Scream',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFE,7,2,513,NULL,0,0,75,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2289,'Poo_Poo_Hat','Poo Poo Hat',4,20,NULL,700,NULL,0,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,0,76,'bonus2 bSubRace,RC_DemiHuman,10; bonus2 bSubRace,RC_Player,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2290,'Funeral_Costume','Funeral Hat',4,3000,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,0,77,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2291,'Masquerade','Masquerade',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFE,7,2,512,NULL,0,0,78,'bonus2 bAddRace,RC_DemiHuman,3; bonus2 bAddRace,RC_Player,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2292,'Welding_Mask','Welding Mask',4,20,NULL,300,NULL,2,NULL,0,0x00040420,7,2,513,NULL,50,0,79,'bonus2 bSubEle,Ele_Fire,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2293,'Pretend_Murdered','Pretend Murdered',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,0,80,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2294,'Star_Dust','Stellar',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,81,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2295,'Blinker','Blinker',4,1500,NULL,100,NULL,0,NULL,0,0xFFFFFFFE,7,2,512,NULL,0,0,82,'bonus2 bResEff,Eff_Blind,10000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2296,'Binoculars','Binoculars',4,20,NULL,100,NULL,1,NULL,0,0x00080808,7,2,512,NULL,50,0,83,'bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2297,'Goblini_Mask','Goblin Mask',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFE,7,2,513,NULL,0,0,84,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2298,'Green_Feeler','Green Feeler',4,20,NULL,100,NULL,2,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,0,85,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2299,'Viking_Helm','Orc Helm',4,20,NULL,500,NULL,5,NULL,0,0x000654E2,7,2,256,NULL,0,1,86,NULL,NULL,NULL);
# Armors
#===================================================================
REPLACE INTO `item_db` VALUES (2301,'Cotton_Shirt','Cotton Shirt',4,10,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,7,2,16,NULL,0,1,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2302,'Cotton_Shirt_','Cotton Shirt',4,10,NULL,100,NULL,1,NULL,1,0xFFFFFFFF,7,2,16,NULL,0,1,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2303,'Leather_Jacket','Jacket',4,200,NULL,200,NULL,2,NULL,0,0xFFFFFFFF,7,2,16,NULL,0,1,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2304,'Leather_Jacket_','Jacket',4,200,NULL,200,NULL,2,NULL,1,0xFFFFFFFF,7,2,16,NULL,0,1,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2305,'Adventure_Suit','Adventurer\'s Suit',4,1000,NULL,300,NULL,3,NULL,0,0xFFFFFFFF,7,2,16,NULL,0,1,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2306,'Adventurere\'s_Suit_','Adventurer\'s Suit',4,1000,NULL,300,NULL,3,NULL,1,0xFFFFFFFF,7,2,16,NULL,0,1,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2307,'Mantle','Mantle',4,10000,NULL,600,NULL,4,NULL,0,0xFFFFFFFE,7,2,16,NULL,0,1,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2308,'Mantle_','Mantle',4,10000,NULL,600,NULL,4,NULL,1,0xFFFFFFFE,7,2,16,NULL,0,1,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2309,'Coat','Coat',4,22000,NULL,1200,NULL,5,NULL,0,0xFFFFFFFE,7,2,16,NULL,0,1,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2310,'Coat_','Coat',4,22000,NULL,1200,NULL,5,NULL,1,0xFFFFFFFE,7,2,16,NULL,0,1,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2311,'Mink_Coat','Mink Coat',4,20,NULL,2300,NULL,6,NULL,1,0xFFFFFFFE,7,2,16,NULL,30,1,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2312,'Padded_Armor','Padded Armor',4,48000,NULL,2800,NULL,7,NULL,0,0x000654E2,7,2,16,NULL,0,1,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2313,'Padded_Armor_','Padded Armor',4,48000,NULL,2800,NULL,7,NULL,1,0x000654E2,7,2,16,NULL,0,1,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2314,'Chain_Mail','Chain Mail',4,65000,NULL,3300,NULL,8,NULL,0,0x000654E2,7,2,16,NULL,0,1,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2315,'Chain_Mail_','Chain Mail',4,65000,NULL,3300,NULL,8,NULL,1,0x000654E2,7,2,16,NULL,0,1,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2316,'Plate_Armor','Full Plate',4,80000,NULL,4500,NULL,10,NULL,0,0x00004082,7,2,16,NULL,40,1,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2317,'Plate_Armor_','Full Plate',4,80000,NULL,4500,NULL,10,NULL,1,0x00004082,7,2,16,NULL,40,1,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2318,'Clothes_Of_The_Lord','Lord\'s Clothes',4,20,NULL,2500,NULL,8,NULL,1,0x00040420,7,2,16,NULL,70,1,0,'bonus bMdef,5; bonus bInt,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2319,'Glittering_Clothes','Glittering Jacket',4,20,NULL,2500,NULL,7,NULL,1,0xFFFFFFFE,7,2,16,NULL,60,1,0,'bonus bMdef,5; bonus2 bAddEff,Eff_Blind,300;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2320,'Formal_Suit','Formal Suit',4,20,NULL,300,NULL,5,NULL,1,0xFFFFFFFE,7,2,16,NULL,0,1,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2321,'Silk_Robe','Silk Robe',4,8000,NULL,400,NULL,3,NULL,0,0x0085C7B6,7,2,16,NULL,0,1,0,'bonus bMdef,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2322,'Silk_Robe_','Silk Robe',4,8000,NULL,400,NULL,3,NULL,1,0x0085C7B6,7,2,16,NULL,0,1,0,'bonus bMdef,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2323,'Scapulare','Scapulare',4,6500,NULL,400,NULL,4,NULL,0,0x00008110,7,2,16,NULL,0,1,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2324,'Scapulare_','Scapulare',4,6500,NULL,400,NULL,4,NULL,1,0x00008110,7,2,16,NULL,0,1,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2325,'Saint_Robe','Saint\'s Robe',4,54000,NULL,600,NULL,6,NULL,0,0x00048530,7,2,16,NULL,0,1,0,'bonus bMdef,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2326,'Saint_Robe_','Saint\'s Robe',4,54000,NULL,600,NULL,6,NULL,1,0x00048530,7,2,16,NULL,0,1,0,'bonus bMdef,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2327,'Holy_Robe','Holy Robe',4,20,NULL,1700,NULL,7,NULL,0,0x00008110,7,2,16,NULL,60,1,0,'bonus bMdef,5; bonus2 bSubRace,RC_Demon,15; bonus2 bSubEle,Ele_Dark,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2328,'Wooden_Mail','Wooden Mail',4,5500,NULL,1000,NULL,4,NULL,0,0x000444A2,7,2,16,NULL,0,1,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2329,'Wooden_Mail_','Wooden Mail',4,5500,NULL,1000,NULL,4,NULL,1,0x000444A2,7,2,16,NULL,0,1,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2330,'Tights','Tights',4,71000,NULL,500,NULL,6,NULL,0,0x00080808,7,2,16,NULL,45,1,0,'bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2331,'Tights_','Tights',4,71000,NULL,500,NULL,6,NULL,1,0x00080808,7,2,16,NULL,45,1,0,'bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2332,'Silver_Robe','Silver Robe',4,7000,NULL,700,NULL,4,NULL,0,0x00810204,7,2,16,NULL,0,1,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2333,'Silver_Robe_','Silver Robe',4,7000,NULL,700,NULL,4,NULL,1,0x00810204,7,2,16,NULL,0,1,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2334,'Mage_Coat','Mage Coat',4,20,NULL,600,NULL,5,NULL,0,0x00810204,7,2,16,NULL,50,1,0,'bonus bMdef,5; bonus bInt,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2335,'Thief_Clothes','Thief Clothes',4,74000,NULL,100,NULL,6,NULL,0,0x02021040,7,2,16,NULL,0,1,0,'bonus bAgi,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2336,'Thief_Clothes_','Thief Clothes',4,74000,NULL,100,NULL,6,NULL,1,0x02021040,7,2,16,NULL,0,1,0,'bonus bAgi,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2337,'Ninja_Suit','Ninja Suit',4,20,NULL,1500,NULL,7,NULL,0,0x02021040,7,2,16,NULL,50,1,0,'bonus bAgi,1; bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2338,'Wedding_Dress','Wedding Dress',4,43000,NULL,500,NULL,0,NULL,0,0xFFFFFFFE,7,2,16,NULL,0,1,0,'bonus bMdef,15;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2339,'G_Strings','Pantie',4,1000,NULL,100,NULL,4,NULL,0,0xFFFFFFFF,7,2,16,NULL,0,1,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2340,'Novice_Breast','Novice Breastplate',4,89000,NULL,500,NULL,4,NULL,1,0x00000001,7,2,16,NULL,10,1,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2341,'Full_Plate_Armor','Legion Plate Armor',4,94000,NULL,5500,NULL,11,NULL,0,0x00004000,7,2,16,NULL,70,1,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2342,'Full_Plate_Armor_','Legion Plate Armor',4,102500,NULL,5500,NULL,11,NULL,1,0x00004000,7,2,16,NULL,70,1,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2343,'Robe_Of_Casting','Robe of Cast',4,124800,NULL,1100,NULL,5,NULL,0,0x00810200,7,2,16,NULL,75,1,0,'bonus bCastrate,-3; bonus bMdef,4;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2344,'Flame_Sprits_Armor','Lucius\'s Fierce Armor of Volcano',4,136000,NULL,2200,NULL,4,NULL,0,0x000444A2,7,2,16,NULL,45,1,0,'bonus bDefEle,Ele_Fire;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2345,'Flame_Sprits_Armor_','Lucius\'s Fierce Armor of Volcano',4,136000,NULL,2200,NULL,4,NULL,1,0xFFFFFFFE,7,2,16,NULL,45,1,0,'bonus bDefEle,Ele_Fire;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2346,'Water_Sprits_Armor','Saphien\'s Armor of Ocean',4,136000,NULL,2200,NULL,4,NULL,0,0x000444A2,7,2,16,NULL,45,1,0,'bonus bDefEle,Ele_Water;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2347,'Water_Sprits_Armor_','Saphien\'s Armor of Ocean',4,136000,NULL,2200,NULL,4,NULL,1,0xFFFFFFFE,7,2,16,NULL,45,1,0,'bonus bDefEle,Ele_Water;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2348,'Wind_Sprits_Armor','Aebecee\'s Raging Typhoon Armor',4,136000,NULL,2200,NULL,4,NULL,0,0x000444A2,7,2,16,NULL,45,1,0,'bonus bDefEle,Ele_Wind;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2349,'Wind_Sprits_Armor_','Aebecee\'s Raging Typhoon Armor',4,136000,NULL,2200,NULL,4,NULL,1,0xFFFFFFFE,7,2,16,NULL,45,1,0,'bonus bDefEle,Ele_Wind;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2350,'Earth_Sprits_Armor','Claytos Cracking Earth Armor',4,136000,NULL,2200,NULL,4,NULL,0,0x000444A2,7,2,16,NULL,45,1,0,'bonus bDefEle,Ele_Earth;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2351,'Earth_Sprits_Armor_','Claytos Cracking Earth Armor',4,136000,NULL,2200,NULL,4,NULL,1,0xFFFFFFFE,7,2,16,NULL,45,1,0,'bonus bDefEle,Ele_Earth;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2352,'Novice_Plate','Tattered Novice Ninja Suit',4,1,NULL,1,NULL,4,NULL,0,0x00000001,7,2,16,NULL,0,0,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2353,'Odin\'s_Blessing','Odin\'s Blessing',4,30000,NULL,2500,NULL,6,NULL,1,0xFFFFFFFE,7,2,16,NULL,65,1,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2354,'Goibne\'s_Armor','Goibne\'s Armor',4,50000,NULL,3500,NULL,7,NULL,0,0xFFFFFFFE,7,2,16,NULL,54,1,0,'bonus bVit,2; bonus bMaxHPrate,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2355,'Angel\'s_Protection','Angelic Protection',4,10000,NULL,600,NULL,4,NULL,1,0x00000001,7,2,16,NULL,40,1,0,'bonus bMdef,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2356,'Vestment_Of_Grace','Blessed Holy Robe',4,20,NULL,2500,NULL,5,NULL,1,0x00008100,7,2,16,NULL,70,1,0,'bonus bMdef,5; bonus2 bResEff,Eff_Blind,8000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2357,'Valkyrie_Armor','Valkyrian Armor',4,0,NULL,2800,NULL,6,NULL,1,0xFFFFFFFE,2,2,16,NULL,1,1,0,'bonus bAllStats,1; bonus bUnbreakableArmor; if(BaseClass==Job_Mage||BaseClass==Job_Archer||BaseClass==Job_Acolyte) bonus2 bResEff,Eff_Silence,5000; else if(BaseClass==Job_Swordman||BaseClass==Job_Merchant||BaseClass==Job_Thief) bonus2 bResEff,Eff_Stun,5000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2358,'Dress_Of_Angel','Angel\'s Dress',4,20,NULL,1000,NULL,5,NULL,0,0xFFFFFFFF,7,2,16,NULL,1,0,0,'bonus bLuk,4;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2359,'Ninja_Suit_','Ninja Suit',4,20,NULL,1500,NULL,7,NULL,1,0x02021040,7,2,16,NULL,50,1,0,'bonus bAgi,1; bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2360,'Robe_Of_Casting_','Robe of Cast',4,124800,NULL,1100,NULL,5,NULL,1,0x00810200,7,2,16,NULL,75,1,0,'bonus bCastrate,-3; bonus bMdef,4;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (2361,'Blue_Aodai','Blue Robe',4,20,NULL,500,NULL,0,NULL,0,0xFFFFFFFE,7,2,16,NULL,1,1,0,'bonus bAllStats,3; bonus bMdef,5;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (2362,'Red_Aodai','Red Robe',4,20,NULL,500,NULL,0,NULL,0,0xFFFFFFFE,7,2,16,NULL,1,1,0,'bonus bAllStats,3; bonus bMdef,5;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (2363,'White_Aodai','White Robe',4,20,NULL,500,NULL,0,NULL,0,0x00000001,7,2,16,NULL,1,1,0,'bonus bAllStats,3; bonus bMdef,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2364,'Meteo_Plate_Armor','Meteo Plate Armor',4,20,NULL,3000,NULL,10,NULL,1,0x000444A2,2,2,16,NULL,55,1,0,'bonus2 bResEff,Eff_Stun,3000; bonus2 bResEff,Eff_Freeze,3000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2365,'Orleans_Gown','Orleans\'s Gown',4,20,NULL,300,NULL,2,NULL,1,0xFFFFFFFE,2,2,16,NULL,55,1,0,'bonus bCastrate,15; bonus bNoCastCancel;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2366,'Divine_Cloth','Divine Cloth',4,20,NULL,1500,NULL,6,NULL,1,0xFFFFFFFE,2,2,16,NULL,55,1,0,'bonus2 bResEff,Eff_Curse,500; bonus2 bResEff,Eff_Silence,500; bonus2 bResEff,Eff_Stun,500; bonus2 bResEff,Eff_Stone,500; bonus2 bResEff,Eff_Sleep,500;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2367,'Sniping_Suit','Sniping Suit',4,20,NULL,750,NULL,5,NULL,1,0x00000800,2,2,16,NULL,50,1,0,'bonus bMdef,5; bonus bCritical,6+(readparam(bLuk)/10); bonus bDelayRate,-23;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2368,'Golden_Armor','Golden Armor',4,20,NULL,2000,NULL,4,NULL,0,0xFFFFFFFF,7,2,16,NULL,0,0,0,'bonus bMdef,4;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2369,'Freyja_Overcoat','Freyja Overcoat',4,0,NULL,500,NULL,12,NULL,0,0xFFFFFFFE,7,2,16,NULL,0,0,0,'bonus bUnbreakableArmor; bonus2 bSubRace,RC_DemiHuman,10; bonus2 bSubRace,RC_Player,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2370,'Used_Mage_Coat','Used Mage Coat',4,0,NULL,0,NULL,15,NULL,0,0xFFFFFFFF,7,2,16,NULL,0,0,0,'bonus bMaxHP,300; bonus bMaxSP,30; bonus bBaseAtk,10; bonus bAGI,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2371,'G_Strings_','Pantie',4,1000,NULL,100,NULL,4,NULL,1,0xFFFFFFFF,7,2,16,NULL,0,1,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2372,'Mage_Coat_','Mage Coat',4,20,NULL,600,NULL,5,NULL,1,0x00810204,7,2,16,NULL,50,1,0,'bonus bMdef,5; bonus bInt,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2373,'Holy_Robe_','Holy Robe',4,20,NULL,1700,NULL,7,NULL,1,0x00008110,7,2,16,NULL,60,1,0,'bonus bMdef,5; bonus2 bSubRace,RC_Demon,15; bonus2 bSubEle,Ele_Dark,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2374,'Diabolus_Robe','Diabolus Robe',4,20,NULL,300,NULL,6,NULL,1,0x00098B1C,2,2,16,NULL,55,1,0,'bonus bMaxSP,150; bonus bMdef,5; bonus bHealPower,6; bonus bDelayRate,-10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2375,'Diabolus_Armor','Diabolus Armor',4,20,NULL,600,NULL,7,NULL,1,0x000654E2,2,2,16,NULL,55,1,0,'bonus bStr,2; bonus bDex,1; bonus bMaxHP,150; bonus2 bResEff,Eff_Stun,500; bonus2 bResEff,Eff_Stone,500;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2376,'Assaulter_Plate','Assaulter Plate',4,10,NULL,0,NULL,7,NULL,1,0x006444A2,7,2,16,NULL,80,1,0,'bonus bMaxHP,150; bonus bMdef,2; bonus2 bSubRace,RC_DemiHuman,2; bonus2 bSubRace,RC_Player,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2377,'Elite_Engineer_Armor','Elite Engineer Armor',4,10,NULL,0,NULL,7,NULL,1,0x00040420,7,2,16,NULL,80,1,0,'bonus bMaxHP,150; bonus bMdef,2; bonus2 bSubRace,RC_DemiHuman,2; bonus2 bSubRace,RC_Player,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2378,'Assassin_Robe','Assassin Robe',4,10,NULL,0,NULL,7,NULL,1,0x02021040,7,2,16,NULL,80,1,0,'bonus bMaxHP,150; bonus bMdef,2; bonus2 bSubRace,RC_DemiHuman,2; bonus2 bSubRace,RC_Player,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2379,'Warlock_Battle_Robe','Warlock\'s Battle Robe',4,10,NULL,0,NULL,3,NULL,1,0x00810204,7,2,16,NULL,80,1,0,'bonus bMaxHP,150; bonus bMdef,2; bonus2 bSubRace,RC_DemiHuman,2; bonus2 bSubRace,RC_Player,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2380,'Medic_Robe','Medic\'s Robe',4,10,NULL,0,NULL,3,NULL,1,0x00008110,7,2,16,NULL,80,1,0,'bonus bMaxHP,150; bonus bMdef,2; bonus2 bSubRace,RC_DemiHuman,2; bonus2 bSubRace,RC_Player,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2381,'Elite_Archer_Suit','Elite Archer Suit',4,10,NULL,0,NULL,3,NULL,1,0x00080808,7,2,16,NULL,80,1,0,'bonus bMaxHP,150; bonus bMdef,2; bonus2 bSubRace,RC_DemiHuman,2; bonus2 bSubRace,RC_Player,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2382,'Elite_Shooter_Suit','Elite Shooter Suit',4,10,NULL,0,NULL,3,NULL,1,0x41000000,7,2,16,NULL,80,1,0,'bonus bMaxHP,150; bonus bMdef,2; bonus2 bSubRace,RC_DemiHuman,2; bonus2 bSubRace,RC_Player,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2383,'Brynhild','Brynhild',4,20,NULL,400,NULL,10,NULL,0,0xFFFFFFFF,7,2,16,NULL,94,0,0,'bonus bMdef,10; bonus bMaxHP,20*BaseLevel; bonus bMaxSP,5*BaseLevel; bonus2 bAddClass,Class_All,10; bonus bMatkRate,10; bonus bUnbreakableArmor; bonus bNoKnockback;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2384,'Spritual_Tunic','Spiritual Tunic',4,20,NULL,0,NULL,10,NULL,0,0xFFFFFFFF,7,2,16,NULL,0,0,0,'bonus bMaxHP,800; bonus2 bResEff,Eff_Freeze,10000; bonus2 bSubEle,Ele_Earth,20; bonus2 bSubEle,Ele_Fire,20; bonus2 bSubEle,Ele_Wind,20; bonus2 bSubEle,Ele_Poison,20; bonus2 bSubEle,Ele_Holy,20; bonus2 bSubEle,Ele_Dark,20; bonus2 bSubEle,Ele_Ghost,20; bonus2 bSubEle,Ele_Undead,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2385,'Recuperative_Armor','Recuperative Armor',4,20,NULL,0,NULL,12,NULL,0,0xFFFFFFFF,7,2,16,NULL,0,0,0,'bonus bNoRegen,1; bonus bNoRegen,2; bonus bHPGainValue,60; bonus bSPGainValue,6; bonus bMagicHPGainValue,60; bonus bMagicSPGainValue,6;',NULL,'heal 0,-100;');
REPLACE INTO `item_db` VALUES (2386,'Chameleon_Armor','Chameleon Armor',4,20,NULL,1700,NULL,5,NULL,0,0x00CFFF80,2,2,16,NULL,70,1,0,'bonus bMaxHP,(BaseLevel*7); bonus bMaxSP,(BaseLevel/2); autobonus2 "{ bonus bNoMagicDamage,100; }",10,2000,BF_MAGIC,"{ specialeffect2 EF_ENERGYCOAT; }"; if( BaseClass==Job_Mage||BaseClass==Job_Archer||BaseClass==Job_Acolyte ) bonus bMdef,5; else if( BaseClass==Job_Swordman||BaseClass==Job_Merchant||BaseClass==Job_Thief ) bonus bDef,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2387,'Sprint_Mail','Sprint Mail',4,20,NULL,1000,NULL,3,NULL,1,0x00CFFF80,2,2,16,NULL,70,1,0,'bonus bVit,1; bonus bHPrecovRate,5; bonus bAddItemHealRate,3; bonus2 bSkillHeal,"AL_HEAL",3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2388,'Kandura','Kandura',4,20,NULL,300,NULL,4,NULL,1,0x00001000,2,2,16,NULL,70,1,0,'bonus bAgi,1; bonus bFlee,5; bonus bAspdRate,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2389,'Armor_Of_Naga','Armor of Naga',4,20,NULL,1000,NULL,5,NULL,1,0x00CFFF80,2,2,16,NULL,70,1,0,'bonus bMdef,2; autobonus "{ bonus bBaseAtk,20; }",10,10000,BF_WEAPON,"{ specialeffect2 EF_ENHANCE; }";',NULL,NULL);
REPLACE INTO `item_db` VALUES (2390,'Improved_Tights','Improved Tights',4,20,NULL,400,NULL,6,NULL,1,0x00080808,2,2,16,NULL,75,1,0,'bonus bMdef,2; bonus bFlee2,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2391,'Life_Link','Life Link',4,20,NULL,3500,NULL,9,NULL,1,0x00004082,2,2,16,NULL,82,1,0,'bonus bVit,2; bonus bMdef,5; bonus bHPrecovRate,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2392,'Old_Pant','Old Green Pantie',4,0,NULL,0,NULL,10,NULL,0,0xFFFFFFFF,7,2,16,NULL,0,0,0,'bonus bStr,2; bonus bVit,2; bonus bMaxHP,200; bonus3 bAutoSpellWhenHit,"MO_CALLSPIRITS",5,20; bonus bMdef,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2393,'N_Adventurer\'s_Suit','Novice Adventurer\'s Suit',4,0,NULL,0,NULL,8,NULL,1,0xFFFFFFFF,7,2,16,NULL,0,0,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2394,'Krieger_Suit1','Glorious Suit',4,20,NULL,0,NULL,0,NULL,0,0xFFFFFFFE,7,2,16,NULL,81,1,0,'bonus bMaxHPRate,20; bonus2 bSubRace,RC_DemiHuman,7; bonus2 bSubRace,RC_Player,7;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2395,'Krieger_Suit2','Glorious Popularized Suit',4,20,NULL,0,NULL,0,NULL,0,0xFFFFFFFE,7,2,16,NULL,61,1,0,'bonus bMaxHP,600; bonus bSPrecovRate,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2396,'Krieger_Suit3','Glorious Mass-Production Suit',4,20,NULL,0,NULL,0,NULL,0,0xFFFFFFFE,7,2,16,NULL,0,1,0,'bonus bMaxHP,500;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2397,'Incredible_Coat','Incredible Event Resignation Coat',4,10,NULL,900,NULL,2,NULL,0,0xFFFFFFFE,7,2,16,NULL,0,1,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2398,'Sniping_Suit_M','Sniping Suit',4,20,NULL,750,NULL,5,NULL,1,0x00000800,2,2,16,NULL,50,1,0,'bonus bMdef,5; bonus bCritical,6+(readparam(bLuk)/10); bonus bDelayRate,-23;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2399,'Dragon_Vest','Dragon Vest',4,20,NULL,500,NULL,3,NULL,1,0xFFFFFFFE,2,2,16,NULL,0,1,0,'bonus bMdef,3;',NULL,NULL);
# Footgears
#===================================================================
REPLACE INTO `item_db` VALUES (2401,'Sandals','Sandals',4,400,NULL,200,NULL,1,NULL,0,0xFFFFFFFF,7,2,64,NULL,0,1,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2402,'Sandals_','Sandals',4,400,NULL,200,NULL,1,NULL,1,0xFFFFFFFF,7,2,64,NULL,0,1,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2403,'Shoes','Shoes',4,3500,NULL,400,NULL,2,NULL,0,0xFFFFFFFE,7,2,64,NULL,0,1,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2404,'Shoes_','Shoes',4,3500,NULL,400,NULL,2,NULL,1,0xFFFFFFFE,7,2,64,NULL,0,1,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2405,'Boots','Boots',4,18000,NULL,600,NULL,4,NULL,0,0x016E5CEA,7,2,64,NULL,0,1,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2406,'Boots_','Boots',4,18000,NULL,600,NULL,4,NULL,1,0x016E5CEA,7,2,64,NULL,0,1,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2407,'Chrystal_Pumps','Crystal Pumps',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFE,7,0,64,NULL,0,1,0,'bonus bMdef,10; bonus bLuk,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2408,'Cuffs','Shackles',4,5000,NULL,3000,NULL,3,NULL,0,0xFFFFFFFF,7,2,64,NULL,0,1,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2409,'Spiky_Heel','High Heels',4,8500,NULL,600,NULL,2,NULL,0,0xFFFFFFFE,7,2,64,NULL,0,1,0,'bonus bMdef,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2410,'Sleipnir','Sleipnir',4,20,NULL,3500,NULL,5,NULL,0,0xFFFFFFFF,7,2,64,NULL,94,0,0,'bonus bMdef,10; bonus bMaxHPrate,20; bonus bMaxSPrate,20; bonus bSPrecovRate,15; bonus bSpeedRate,25;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2411,'Grave','Greaves',4,48000,NULL,750,NULL,5,NULL,0,0x00004080,7,2,64,NULL,65,1,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2412,'Grave_','Greaves',4,54000,NULL,750,NULL,5,NULL,1,0x00004080,7,2,64,NULL,65,1,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2413,'Safty_Boots','Safety Boots',4,34000,NULL,350,NULL,6,NULL,0,0x00004082,7,2,64,NULL,30,0,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2414,'Novice_Boots','Novice Slippers',4,1,NULL,1,NULL,2,NULL,0,0x00000001,7,2,64,NULL,0,0,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2415,'Slipper','Bunny Slipper',4,34000,NULL,300,NULL,3,NULL,1,0xFFFFFFFE,7,0,64,NULL,30,1,0,'bonus bLuk,3; bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2416,'Novice_Shoes','Novice Shoes',4,35000,NULL,500,NULL,2,NULL,1,0x00000001,7,2,64,NULL,40,1,0,'bonus bMaxHPrate,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2417,'Fricco_Shoes','Fricco\'s Shoes',4,30000,NULL,500,NULL,3,NULL,0,0xFFFFFFFE,7,2,64,NULL,65,1,0,'bonus bAgi,2; bonus2 bAddItemGroupHealRate,IG_Potion,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2418,'Vidar\'s_Boots','Vidar\'s Boots',4,30000,NULL,650,NULL,4,NULL,0,0xFFFFFFFE,7,2,64,NULL,65,1,0,'bonus bMaxHPrate,9; bonus bMaxSPrate,9;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2419,'Goibne\'s_Combat_Boots','Goibne\'s Greaves',4,30000,NULL,700,NULL,4,NULL,0,0xFFFFFFFE,7,2,64,NULL,54,1,0,'bonus bMdef,3; bonus bMaxHPrate,5; bonus bMaxSPrate,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2420,'Angel\'s_Arrival','Angel\'s Reincarnation',4,10000,NULL,300,NULL,2,NULL,1,0x00000001,7,2,64,NULL,25,1,0,'bonus bMaxHP,100;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2421,'Valkyrie_Shoes','Valkyrian Shoes',4,0,NULL,500,NULL,4,NULL,1,0xFFFFFFFE,2,2,64,NULL,1,1,0,'bonus bUnbreakableShoes; if(BaseClass==Job_Mage||BaseClass==Job_Archer||BaseClass==Job_Acolyte) bonus bMaxHP,(BaseLevel*5); else if(BaseClass==Job_Swordman||BaseClass==Job_Merchant||BaseClass==Job_Thief) bonus bMaxSP,(JobLevel*2);',NULL,NULL);
REPLACE INTO `item_db` VALUES (2422,'High_Fashion_Sandals','High Fashion Sandals',4,24000,NULL,200,NULL,2,NULL,1,0x00818314,7,2,64,NULL,40,1,0,'bonus bMdef,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2423,'Variant_Shoes','Variant Shoes',4,20,NULL,500,NULL,3,NULL,0,0xFFFFFFFE,2,2,64,NULL,85,1,0,'bonus bMaxHPRate,20-getrefine(); bonus bMaxSPRate,20-getrefine(); bonus bDef,getrefine()/2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2424,'Tidal_Shoes','Tidal Shoes',4,20,NULL,300,NULL,3,NULL,1,0xFFFFFFFE,2,2,64,NULL,55,1,0,'bonus2 bSubEle,Ele_Water,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2425,'Black_Leather_Boots','Black Leather Boots',4,20,NULL,500,NULL,4,NULL,0,0xFFFFFFFE,2,2,64,NULL,55,1,0,'bonus bAgi,1; if(getrefine()>=9) bonus bAgi,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2426,'Shadow_Walk','Shadow Walk',4,20,NULL,2000,NULL,0,NULL,0,0xFFFFFFFE,2,2,64,NULL,75,1,0,'bonus bMdef,10; if(getskilllv("AS_CLOAKING")<2){ bonus5 bAutoSpellWhenHit,"AS_CLOAKING",2,100,BF_MAGIC,0; } else bonus5 bAutoSpellWhenHit,"AS_CLOAKING",getskilllv("AS_CLOAKING"),100,BF_MAGIC,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2427,'Golden_Shoes','Golden Shoes',4,20,NULL,300,NULL,4,NULL,0,0xFFFFFFFF,7,2,64,NULL,0,0,0,'bonus bMdef,4;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2428,'Freyja_Boots','Freyja Boots',4,0,NULL,300,NULL,10,NULL,0,0xFFFFFFFE,7,2,64,NULL,0,0,0,'bonus2 bSubRace,RC_DemiHuman,5; bonus2 bSubRace,RC_Player,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2429,'Iron_Boots01','Iron Boots',4,0,NULL,1500,NULL,5,NULL,0,0x000E5CEA,7,2,64,NULL,0,1,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2430,'Iron_Boots02','Iron Boots',4,0,NULL,800,NULL,5,NULL,0,0xFFFFFFFF,7,2,64,NULL,0,1,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2431,'Valley_Shoes','Valley Shoes',4,20,NULL,0,NULL,10,NULL,0,0xFFFFFFFF,7,2,64,NULL,0,0,0,'bonus bMaxHPRate,7; bonus bMaxSPRate,7;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2432,'Spiky_Heel_','High Heels',4,8500,NULL,600,NULL,2,NULL,1,0xFFFFFFFE,7,2,64,NULL,0,1,0,'bonus bMdef,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2433,'Diabolus_Boots','Diabolus Boots',4,20,NULL,250,NULL,4,NULL,1,0x00CFFF80,2,2,64,NULL,0,1,0,'bonus bMaxHP,(BaseLevel*10);',NULL,NULL);
REPLACE INTO `item_db` VALUES (2434,'Black_Leather_Boots_','Black Leather Boots',4,20,NULL,500,NULL,4,NULL,1,0xFFFFFFFE,2,2,64,NULL,55,1,0,'bonus bAgi,1; if(getrefine()>=9) bonus bAgi,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2435,'Battle_Greave','Battle Greaves',4,10,NULL,0,NULL,4,NULL,1,0x026654E2,7,2,64,NULL,80,1,0,'bonus bMaxHP,100; bonus bMdef,1; bonus2 bSubRace,RC_DemiHuman,1; bonus2 bSubRace,RC_Player,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2436,'Combat_Boots','Combat Boots',4,10,NULL,0,NULL,3,NULL,1,0x00898B1C,7,2,64,NULL,80,1,0,'bonus bMaxHP,100; bonus bMdef,1; bonus2 bSubRace,RC_DemiHuman,1; bonus2 bSubRace,RC_Player,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2437,'Battle_Boots','Battle Boots',4,10,NULL,0,NULL,3,NULL,1,0x41000000,7,2,64,NULL,80,1,0,'bonus bMaxHP,100; bonus bMdef,1; bonus2 bSubRace,RC_DemiHuman,1; bonus2 bSubRace,RC_Player,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2438,'Paw_Of_Cat','Paw Of Cat',4,10,NULL,300,NULL,0,NULL,0,0xFFFFFFFF,7,2,64,NULL,80,1,0,'bonus bFlee,5; bonus bAgi,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2439,'Refresh_Shoes','Refresh Shoes',4,20,NULL,0,NULL,9,NULL,0,0xFFFFFFFF,7,2,64,NULL,0,0,0,'bonus bMaxHPRate,17; bonus bMaxSPRate,8; bonus2 bHPRegenRate,20,10000; bonus2 bSPRegenRate,3,10000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2440,'Sprint_Shoes','Sprint Shoes',4,20,NULL,300,NULL,2,NULL,1,0x00CFFF80,2,2,64,NULL,70,1,0,'bonus bAgi,1; bonus bSPrecovRate,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2441,'Beach_Sandal','Beach Sandals',4,20,NULL,200,NULL,0,NULL,0,0xFFFFFFFF,7,2,64,NULL,0,1,0,'bonus bStr,1; bonus bInt,1; bonus bAgi,1; bonus2 bSubEle,Ele_Fire,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2442,'Boots_Perforated','Red Stocking Boots',4,0,NULL,0,NULL,7,NULL,0,0xFFFFFFFF,7,2,64,NULL,0,0,0,'bonus bLuk,2; bonus bHPrecovRate,10; bonus bSPrecovRate,10; bonus3 bAutoSpellWhenHit,"WZ_QUAGMIRE",3,20; bonus bMdef,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2443,'Fish_Shoes','Fisher\'s Boots',4,10,NULL,250,NULL,0,NULL,0,0xFFFFFFFF,7,2,64,NULL,0,0,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2444,'Krieger_Shoes1','Glorious Shoes',4,20,NULL,0,NULL,0,NULL,0,0xFFFFFFFE,7,2,64,NULL,81,1,0,'bonus bMaxHPRate,10; bonus2 bSubRace,RC_DemiHuman,4; bonus2 bSubRace,RC_Player,4; bonus3 bAutoSpellWhenHit,"AL_INCAGI",1,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2445,'Krieger_Shoes2','Glorious Popularized Shoes',4,20,NULL,0,NULL,0,NULL,0,0xFFFFFFFE,7,2,64,NULL,61,1,0,'bonus bMaxHPRate,5; bonus bMaxSPRate,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2446,'Krieger_Shoes3','Glorious Mass-Production Shoes',4,20,NULL,0,NULL,0,NULL,0,0xFFFFFFFE,7,2,64,NULL,0,1,0,'bonus bMaxHPRate,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2447,'Military_Boots','Army Boots',4,0,NULL,1000,NULL,5,NULL,0,0xFFFFFFFE,7,2,64,NULL,0,1,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2448,'Air_Boss','Air Boss',4,0,NULL,500,NULL,2,NULL,0,0xFFFFFFFF,7,2,64,NULL,0,1,0,'bonus bAgi,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2449,'Variant_Shoes_M','Variant Shoes',4,20,NULL,500,NULL,3,NULL,0,0xFFFFFFFE,2,2,64,NULL,85,1,0,'bonus bMaxHPRate,20-getrefine(); bonus bMaxSPRate,20-getrefine(); bonus bDef,getrefine()/2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2450,'Vital_Tree_Shoes','Vital Tree Shoes',4,20,NULL,500,NULL,4,NULL,0,0xFFFFFFFE,2,2,64,NULL,60,1,0,'bonus bMaxHPrate,10; bonus2 bHPRegenRate,30,10000; bonus bHealpower2,5; bonus bAddItemHealRate,5; bonus bMdef,3; bonus bVit,2;',NULL,NULL);
# Garments
#===================================================================
REPLACE INTO `item_db` VALUES (2501,'Hood','Hood',4,1000,NULL,200,NULL,1,NULL,0,0xFFFFFFFF,7,2,4,NULL,0,1,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2502,'Hood_','Hood',4,1000,NULL,200,NULL,1,NULL,1,0xFFFFFFFF,7,2,4,NULL,0,1,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2503,'Muffler','Muffler',4,5000,NULL,400,NULL,2,NULL,0,0xFFFFFFFE,7,2,4,NULL,0,1,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2504,'Muffler_','Muffler',4,5000,NULL,400,NULL,2,NULL,1,0xFFFFFFFE,7,2,4,NULL,0,1,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2505,'Manteau','Manteau',4,32000,NULL,600,NULL,4,NULL,0,0x006654E2,7,2,4,NULL,0,1,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2506,'Manteau_','Manteau',4,32000,NULL,600,NULL,4,NULL,1,0x006654E2,7,2,4,NULL,0,1,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2507,'Cape_Of_Ancient_Lord','Ancient Cape',4,82000,NULL,600,NULL,2,NULL,0,0xFFFFFFFE,7,2,4,NULL,40,1,0,'bonus bAgi,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2508,'Ragamuffin_Cape','Ragamuffin Manteau',4,56000,NULL,500,NULL,1,NULL,0,0xFFFFFFFE,7,2,4,NULL,0,1,0,'bonus bUnbreakableGarment; bonus bMdef,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2509,'Clack_Of_Servival','Survivor\'s Manteau',4,20000,NULL,550,NULL,0,NULL,0,0x00810204,7,2,4,NULL,75,1,0,'bonus bMdef,5; bonus bVit,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2510,'Novice_Hood','Somber Novice Hood',4,1,NULL,1,NULL,2,NULL,0,0x00000001,7,2,4,NULL,0,0,0,'bonus2 bSubEle,Ele_Neutral,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2511,'Skeleton\'s_Cape','Skeleton Manteau',4,5000,NULL,700,NULL,1,NULL,0,0xFFFFFFFE,7,2,4,NULL,75,1,0,'bonus bStr,2; bonus bInt,-3; bonus bDex,2; bonus bVit,-3; bonus bLuk,2; bonus bAgi,-4;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2512,'Novice_Manteau','Novice Manteau',4,50000,NULL,500,NULL,2,NULL,1,0x00000001,7,2,4,NULL,40,1,0,'bonus2 bSubEle,Ele_Neutral,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2513,'Celestial_Robe','Heavenly Maiden Robe',4,20,NULL,500,NULL,3,NULL,1,0xFFFFFFFE,7,2,4,NULL,80,1,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2514,'Pauldron','Pauldron',4,20,NULL,800,NULL,5,NULL,1,0x000654E2,7,2,4,NULL,80,1,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2515,'Wing_Of_Eagle','Eagle Wing',4,20000,NULL,300,NULL,1,NULL,1,0x00810204,7,2,4,NULL,85,1,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2516,'Falcon_Robe','Falcon Muffler',4,30000,NULL,400,NULL,3,NULL,0,0xFFFFFFFE,7,2,4,NULL,65,1,0,'bonus bFlee,15; bonus bFlee2,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2517,'Vali\'s_Manteau','Vali\'s Manteau',4,30000,NULL,600,NULL,4,NULL,0,0xFFFFFFFE,7,2,4,NULL,65,1,0,'bonus2 bSubEle,Ele_Neutral,15;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2518,'Morpheus\'s_Shawl','Morpheus\'s Shawl',4,30000,NULL,600,NULL,3,NULL,0,0xFFFFFFFE,7,2,4,NULL,33,1,0,'bonus bMaxSPrate,10; bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2519,'Morrigane\'s_Manteau','Morrigane\'s Manteau',4,30000,NULL,600,NULL,3,NULL,0,0xFFFFFFFE,7,2,4,NULL,61,1,0,'bonus bLuk,2; bonus bFlee2,8;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2520,'Goibne\'s_Shoulder_Arms','Goibne\'s Spaulders',4,30000,NULL,700,NULL,3,NULL,0,0xFFFFFFFE,7,2,4,NULL,54,1,0,'bonus bLongAtkDef,10; bonus bMdef,2; bonus bVit,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2521,'Angel\'s_Warmth','Angelic Cardigan',4,10000,NULL,400,NULL,2,NULL,1,0x00000001,7,2,4,NULL,20,1,0,'bonus bHPrecovRate,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2522,'Undershirt','Undershirt',4,20000,NULL,150,NULL,2,NULL,0,0xFFFFFFFF,7,2,4,NULL,1,1,0,'bonus bMdef,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2523,'Undershirt_','Undershirt',4,20000,NULL,150,NULL,2,NULL,1,0xFFFFFFFF,7,2,4,NULL,1,1,0,'bonus bMdef,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2524,'Valkyrie_Manteau','Valkyrian Manteau',4,0,NULL,500,NULL,3,NULL,1,0xFFFFFFFE,2,2,4,NULL,1,1,0,'bonus bUnbreakableGarment; if(BaseClass==Job_Mage||BaseClass==Job_Archer||BaseClass==Job_Acolyte) bonus bFlee2,5+(getequiprefinerycnt(EQI_GARMENT)*2); else if(BaseClass==Job_Swordman||BaseClass==Job_Merchant||BaseClass==Job_Thief) bonus bShortWeaponDamageReturn,5+(getequiprefinerycnt(EQI_GARMENT)*2);',NULL,NULL);
REPLACE INTO `item_db` VALUES (2525,'Cape_Of_Ancient_Lord_','Ancient Cape',4,82000,NULL,600,NULL,2,NULL,1,0xFFFFFFFE,7,2,4,NULL,40,1,0,'bonus bAgi,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2526,'Dragon_Scale_Coat','Coat of Dragon Scale',4,20,NULL,10,NULL,4,NULL,0,0xFFFFFFFF,7,2,4,NULL,50,1,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2527,'Dragon_Breath','Dragon Breath',4,20,NULL,600,NULL,4,NULL,1,0xFFFFFFFE,2,2,4,NULL,48,1,0,'bonus2 bSubRace,RC_Dragon,15;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2528,'Wool_Scarf','Wool Scarf',4,20,NULL,500,NULL,3,NULL,1,0xFFFFFFFE,2,2,4,NULL,55,1,0,'bonus bMdef,4;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2529,'Rider_Insignia','Rider Insignia',4,20,NULL,500,NULL,4,NULL,0,0xFFFFFFFE,2,2,4,NULL,55,1,0,'bonus bAgi,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2530,'Rider_Insignia_','Rider Insignia',4,20,NULL,500,NULL,4,NULL,1,0xFFFFFFFE,2,2,4,NULL,55,1,0,'bonus bAgi,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2531,'Ulfhedinn','Ulfhedinn',4,20,NULL,700,NULL,3,NULL,1,0x000654E2,2,2,4,NULL,70,1,0,'bonus3 bAutoSpellWhenHit,"NPC_STONESKIN",6,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2532,'Mithril_Magic_Cape','Mithril Magic Cape',4,20,NULL,400,NULL,3,NULL,1,0x00098B1C,2,2,4,NULL,70,1,0,'bonus bMdef,3; bonus5 bAutoSpellWhenHit,"NPC_ANTIMAGIC",6,200,BF_MAGIC,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2533,'Freyja_Cape','Freyja Cape',4,0,NULL,200,NULL,10,NULL,0,0xFFFFFFFE,7,2,4,NULL,0,0,0,'bonus2 bSubRace,RC_DemiHuman,15; bonus2 bSubRace,RC_Player,15;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2534,'Ruffler','Ruffler',4,20,NULL,0,NULL,10,NULL,0,0xFFFFFFFF,7,2,4,NULL,0,0,0,'bonus2 bSubEle,Ele_Neutral,17; bonus bFlee,17;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2535,'Cloak_Of_Survival_C','Cloak Of Survival',4,1,NULL,0,NULL,5,NULL,0,0x00810204,7,2,4,NULL,0,0,0,'bonus bVit,10; bonus bMdef,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2536,'Skin_Of_Ventus','Skin of Ventus',4,20,NULL,250,NULL,2,NULL,1,0xFFFFFFFE,7,2,4,NULL,60,1,0,'bonus bMdef,2; bonus bMaxHP,200; bonus bFlee,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2537,'Diabolus_Manteau','Diabolus Manteau',4,20,NULL,250,NULL,5,NULL,1,0x00CFFF80,2,2,4,NULL,0,1,0,'bonus2 bSubEle,Ele_Neutral,5; bonus bMaxHP,100; bonus2 bAddDamageClass,1916,10; bonus2 bAddDamageClass,1917,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2538,'Commander_Manteau','Captain\'s Manteau',4,10,NULL,0,NULL,4,NULL,1,0x026654E2,7,2,4,NULL,80,1,0,'bonus bMaxHP,50; bonus bMdef,1; bonus2 bSubRace,RC_DemiHuman,1; bonus2 bSubRace,RC_Player,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2539,'Commander_Manteau_','Commander\'s Manteau',4,10,NULL,0,NULL,3,NULL,1,0x00898B1C,7,2,4,NULL,80,1,0,'bonus bMaxHP,50; bonus bMdef,1; bonus2 bSubRace,RC_DemiHuman,1; bonus2 bSubRace,RC_Player,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2540,'Sheriff_Manteau','Sheriff\'s Manteau',4,10,NULL,0,NULL,3,NULL,1,0x41000000,7,2,4,NULL,80,1,0,'bonus bMaxHP,50; bonus bMdef,1; bonus2 bSubRace,RC_DemiHuman,1; bonus2 bSubRace,RC_Player,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2541,'Asprika','Asprika',4,20,NULL,400,NULL,5,NULL,0,0xFFFFFFFF,7,2,4,NULL,94,0,0,'bonus bMdef,5; bonus3 bSubEle,Ele_Neutral,30,BF_SHORT; bonus3 bSubEle,Ele_Water,30,BF_SHORT; bonus3 bSubEle,Ele_Earth,30,BF_SHORT; bonus3 bSubEle,Ele_Fire,30,BF_SHORT; bonus3 bSubEle,Ele_Wind,30,BF_SHORT; bonus3 bSubEle,Ele_Poison,30,BF_SHORT; bonus3 bSubEle,Ele_Holy,30,BF_SHORT; bonus3 bSubEle,Ele_Dark,30,BF_SHORT; bonus3 bSubEle,Ele_Ghost,30,BF_SHORT; bonus3 bSubEle,Ele_Undead,30,BF_SHORT; bonus bFlee,30; skill "AL_TELEPORT",1; bonus bUnbreakableGarment;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2542,'Flame_Manteau','Flame Manteau of Naght Sieger',4,20,NULL,70,NULL,4,NULL,1,0xFFFFFFFE,2,2,4,NULL,70,1,0,'bonus bMaxHPRate,5; bonus bMdef,2; bonus bMatkRate,1; bonus2 bAddEle,Ele_Fire,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2543,'Sylphid_Manteau','Sylphid Manteau',4,20,NULL,0,NULL,9,NULL,0,0xFFFFFFFF,7,2,4,NULL,0,0,0,'bonus bFlee,13; bonus2 bSubEle,Ele_Neutral,13; bonus bFlee2,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2544,'Leather_Of_Tendrilion','Leather of Tendrilion',4,20,NULL,300,NULL,3,NULL,1,0x00CFDF80,2,2,4,NULL,0,1,0,'bonus2 bSubEle,Ele_Water,5; bonus2 bSubEle,Ele_Earth,5; bonus2 bSubRace,RC_Plant,5; bonus2 bSubRace,RC_Brute,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2545,'Musika','Musika',4,20,NULL,500,NULL,2,NULL,1,0x00008100,2,2,4,NULL,70,1,0,'bonus bMdef,3; bonus3 bAutoSpellwhenhit,"AL_HEAL",max(1,getskilllv("AL_HEAL")),20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2546,'Beach_Manteau','Beach Manteau',4,20,NULL,600,NULL,0,NULL,1,0xFFFFFFFF,7,2,4,NULL,0,1,0,'bonus bStr,1; bonus bInt,1; bonus2 bSubEle,Ele_Fire,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2547,'Cheap_Running_Shirts','Cheap Undershirt',4,0,NULL,0,NULL,8,NULL,0,0xFFFFFFFF,7,2,4,NULL,0,1,0,'bonus bDex,2; bonus bFlee,10; bonus2 bSubEle,Ele_Neutral,10; bonus bMdef,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2548,'Muffler_C','Neo Muffler',4,0,NULL,0,NULL,5,NULL,0,0xFFFFFFFE,2,2,4,NULL,95,0,0,'bonus2 bSubRace,RC_DemiHuman,10; bonus2 bSubRace,RC_Player,10; bonus bMaxHPrate,10; bonus2 bSubEle,Ele_Water,5; bonus2 bSubEle,Ele_Fire,5; bonus2 bSubEle,Ele_Holy,5; bonus2 bSubEle,Ele_Dark,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2549,'Krieger_Muffler1','Glorious Muffler',4,20,NULL,0,NULL,0,NULL,0,0xFFFFFFFE,7,2,4,NULL,81,1,0,'bonus bMaxHPRate,5; bonus2 bSubRace,RC_DemiHuman,5; bonus2 bSubRace,RC_Player,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2550,'Fisher\'s_Muffler','Fisher\'s Muffler',4,20,NULL,200,NULL,0,NULL,0,0xFFFFFFFF,7,2,4,NULL,0,1,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2551,'Rider_Insignia_M','Crest of the Rider',4,20,NULL,500,NULL,4,NULL,1,0xFFFFFFFE,2,2,4,NULL,55,1,0,'bonus bAgi,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2552,'Mithril_Magic_Cape_M','Mithril Magic Manteau',4,20,NULL,400,NULL,3,NULL,1,0x00098B1C,2,2,4,NULL,70,1,0,'bonus bMdef,3; bonus5 bAutoSpellWhenHit,"NPC_ANTIMAGIC",6,200,BF_MAGIC,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2553,'Dragon_Manteau','Dragon Manteau',4,20,NULL,1000,NULL,5,NULL,1,0xFFFFFFFE,2,2,4,NULL,0,1,0,'bonus bAgi,1; bonus bMdef,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2554,'Piece_Of_Angent_Skin','Nydhorgg\'s Shadow Garb',4,20,NULL,400,NULL,5,NULL,1,0xFFFFFFFE,2,2,4,NULL,90,1,0,'bonus2 bSubEle,Ele_Neutral,7; bonus2 bSubEle,Ele_Water,7; bonus2 bSubEle,Ele_Earth,7; bonus2 bSubEle,Ele_Fire,7; bonus2 bSubEle,Ele_Wind,7; bonus2 bSubEle,Ele_Poison,7; bonus2 bSubEle,Ele_Holy,7; bonus2 bSubEle,Ele_Dark,7; bonus2 bSubEle,Ele_Ghost,7; bonus2 bSubEle,Ele_Undead,7; bonus bMaxSP,(BaseLevel/3)+(getrefine()*10); bonus2 bSPDrainRate,10,1; bonus bMdef,3;',NULL,NULL);
# Accessories
#===================================================================
REPLACE INTO `item_db` VALUES (2601,'Ring','Ring',4,30000,NULL,100,NULL,0,NULL,0,0xFFFFFFFE,7,2,136,NULL,20,0,0,'bonus bStr,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2602,'Earring','Earring',4,30000,NULL,100,NULL,0,NULL,0,0xFFFFFFFE,7,2,136,NULL,20,0,0,'bonus bInt,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2603,'Necklace','Necklace',4,30000,NULL,100,NULL,0,NULL,0,0xFFFFFFFE,7,2,136,NULL,20,0,0,'bonus bVit,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2604,'Glove','Glove',4,30000,NULL,100,NULL,0,NULL,0,0xFFFFFFFE,7,2,136,NULL,20,0,0,'bonus bDex,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2605,'Brooch','Brooch',4,30000,NULL,100,NULL,0,NULL,0,0xFFFFFFFE,7,2,136,NULL,20,0,0,'bonus bAgi,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2607,'Clip','Clip',4,30000,NULL,100,NULL,0,NULL,1,0xFFFFFFFF,7,2,136,NULL,0,0,0,'bonus bMaxSP,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2608,'Rosary','Rosary',4,15000,NULL,100,NULL,0,NULL,0,0xFFFFFFFE,7,2,136,NULL,20,0,0,'bonus bMdef,5; bonus bLuk,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2609,'Skul_Ring','Skull Ring',4,10000,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,136,NULL,0,0,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2610,'Gold_Ring','Gold Ring',4,30000,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,136,NULL,0,0,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2611,'Silver_Ring','Silver Ring',4,20000,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,136,NULL,0,0,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2612,'Flower_Ring','Flower Ring',4,1500,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,136,NULL,0,0,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2613,'Diamond_Ring','Diamond Ring',4,45000,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,136,NULL,0,0,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2614,'An_Eye_Of_Dullahan','Eye of Dullahan',4,90000,NULL,100,NULL,0,NULL,0,0xFFFFFFFE,7,2,136,NULL,50,0,0,'bonus2 bResEff,Eff_Poison,10000; bonus2 bSubRace,RC_Undead,4; bonus2 bSubRace,RC_Demon,4;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2615,'Safety_Ring','Safety Ring',4,75000,NULL,100,NULL,3,NULL,0,0xFFFFFFFE,7,2,136,NULL,40,0,0,'bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2616,'Critical_Ring','Critical Ring',4,75000,NULL,100,NULL,0,NULL,0,0xFFFFFFFE,7,2,136,NULL,40,0,0,'bonus bCritical,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2617,'Mitten_Of_Presbyter','Celebrant\'s Mitten',4,2,NULL,100,NULL,1,NULL,0,0xFFFFFFFE,7,2,136,NULL,35,0,0,'bonus bInt,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2618,'Matyr\'s_Flea_Guard','Matyr\'s Leash',4,2,NULL,100,NULL,1,NULL,0,0xFFFFFFFE,7,2,136,NULL,35,0,0,'bonus bAgi,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2619,'Thimble_Of_Archer','Bow Thimble',4,10000,NULL,100,NULL,0,NULL,0,0x00080808,7,2,136,NULL,65,0,0,'bonus bLongAtkRate,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2620,'Ring_Of_Rogue','Rogue\'s Treasure',4,10000,NULL,100,NULL,0,NULL,0,0x02021040,7,2,136,NULL,70,0,0,'if(readparam(bStr)>=90){ bonus bHit,10; bonus bFlee,10; } if(readparam(bAgi)>=90){ bonus bBaseAtk,10; bonus bCritical,10; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (2621,'Ring_','Ring',4,30000,NULL,200,NULL,0,NULL,1,0xFFFFFFFE,7,2,136,NULL,90,0,0,'bonus bStr,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2622,'Earring_','Earring',4,30000,NULL,200,NULL,0,NULL,1,0xFFFFFFFE,7,2,136,NULL,90,0,0,'bonus bInt,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2623,'Necklace_','Necklace',4,30000,NULL,200,NULL,0,NULL,1,0xFFFFFFFE,7,2,136,NULL,90,0,0,'bonus bVit,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2624,'Glove_','Glove',4,30000,NULL,200,NULL,0,NULL,1,0xFFFFFFFE,7,2,136,NULL,90,0,0,'bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2625,'Brooch_','Brooch',4,30000,NULL,200,NULL,0,NULL,1,0xFFFFFFFE,7,2,136,NULL,90,0,0,'bonus bAgi,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2626,'Rosary_','Rosary',4,15000,NULL,200,NULL,0,NULL,1,0xFFFFFFFE,7,2,136,NULL,90,0,0,'bonus bMdef,3; bonus bLuk,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2627,'Belt','Belt',4,20000,NULL,1200,NULL,0,NULL,1,0xFFFFFFFF,7,2,136,NULL,25,0,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2628,'Novice_Armlet','Novice Armlet',4,400,NULL,200,NULL,0,NULL,1,0x00000001,7,2,136,NULL,1,0,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2629,'Magingiorde','Megingjard',4,20,NULL,8000,NULL,2,NULL,0,0xFFFFFFFF,7,2,136,NULL,94,0,0,'bonus bStr,40; bonus bMdef,7;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2630,'Brysinggamen','Brisingamen',4,20,NULL,1500,NULL,1,NULL,0,0xFFFFFFFF,7,2,136,NULL,94,0,0,'bonus bStr,6; bonus bAgi,6; bonus bVit,6; bonus bInt,6; bonus bLuk,10; bonus bMdef,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2631,'First_Age_Ring','Celebration Ring',4,1,NULL,10,NULL,0,NULL,0,0xFFFFFFFF,7,2,136,NULL,1,0,0,NULL,NULL,NULL);
#REPLACE INTO `item_db` VALUES (2632,'Korean_Trinket','Korean Trinket',4,125000,NULL,100,NULL,1,NULL,0,0xFFFFFFFE,7,2,136,NULL,65,0,0,'bonus bVit,1; bonus bDex,1; bonus bLuk,1;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (2633,'Jade_Ring','Jade Ring',4,204000,NULL,100,NULL,0,NULL,0,0xFFFFFFFE,7,2,136,NULL,80,0,0,'bonus bStr,2; bonus bInt,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2634,'Bridegroom_Ring','Wedding Ring',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,7,1,136,NULL,0,0,0,'skill "WE_MALE",1; skill "WE_FEMALE",1; skill "WE_CALLPARTNER",1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2635,'Bride_Ring','Wedding Ring',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,7,0,136,NULL,0,0,0,'skill "WE_MALE",1; skill "WE_FEMALE",1; skill "WE_CALLPARTNER",1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2636,'Gold_Ring_','Gold Christmas Ring',4,30000,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,136,NULL,0,0,0,'bonus bLuk,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2637,'Silver_Ring_','Silver Christmas Ring',4,20000,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,136,NULL,0,0,0,'bonus bLuk,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2638,'Exorcize_Sachet','Sacred Incense',4,20000,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,136,NULL,0,0,0,'bonus bStr,1; bonus bLuk,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2639,'Purification_Sachet','Occult Incense',4,20000,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,136,NULL,0,0,0,'bonus bInt,1; bonus bAgi,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2640,'Kafra_Ring','Kafra Ring',4,40000,NULL,200,NULL,1,NULL,0,0xFFFFFFFE,7,2,136,NULL,0,0,0,'bonus bStr,1; bonus bInt,1; bonus bAgi,1; bonus bLuk,1; bonus bMdef,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2641,'Fashionable_Sack','Fashion Hip Sack',4,20,NULL,700,NULL,0,NULL,0,0x00040420,7,2,136,NULL,50,0,0,'bonus bStr,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2642,'Serin\'s_Gold_Ring','Serin\'s Gold Ring',4,20,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,7,2,136,NULL,0,0,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2643,'Serin\'s_Gold_Ring_','Serin\'s Gold Ring',4,45000,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,136,NULL,0,0,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2644,'The_Sign_','The Sign',4,2,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,7,2,136,NULL,0,0,0,'bonus2 bAddClass,Class_All,5; bonus bMatkRate,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2645,'Moonlight_Ring','Moonlight Ring',4,40000,NULL,200,NULL,0,NULL,0,0x02021040,7,2,136,NULL,60,0,0,'bonus bMdef,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2646,'Bunch_Of_Carnation','Bunch of Carnations',4,2,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,136,NULL,0,0,0,'bonus bAllStats,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2647,'Nile_Rose','Nile Rose',4,2,NULL,100,NULL,0,NULL,1,0xFFFFFFFF,7,2,136,NULL,0,0,0,'bonus bMaxHP,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2648,'Morpheus\'s_Ring','Morpheus\'s Ring',4,30000,NULL,100,NULL,0,NULL,0,0xFFFFFFFE,7,2,136,NULL,33,0,0,'bonus bInt,1; bonus bMaxSPrate,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2649,'Morpheus\'s_Armlet','Morpheus\'s Bracelet',4,30000,NULL,100,NULL,0,NULL,0,0xFFFFFFFE,7,2,136,NULL,33,0,0,'bonus bInt,1; bonus bMaxSPrate,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2650,'Morrigane\'s_Belt','Morrigane\'s Belt',4,30000,NULL,200,NULL,0,NULL,0,0xFFFFFFFE,7,2,136,NULL,61,0,0,'bonus bBaseAtk,5; bonus bCritical,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2651,'Morrigane\'s_Pendant','Morrigane\'s Pendant',4,30000,NULL,200,NULL,0,NULL,0,0xFFFFFFFE,7,2,136,NULL,61,0,0,'bonus bStr,2; bonus bCritical,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2652,'Cursed_Lucky_Brooch','Goddess of Fortune\'s Cursed Brooch',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,136,NULL,40,0,0,'bonus bCritical,6; bonus2 bAddEff2,Eff_Curse,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2653,'Sacrifice_Ring','Sacrifice Ring',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,136,NULL,90,0,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2654,'Shinobi\'s_Sash','Shinobi Sash',4,20000,NULL,300,NULL,1,NULL,0,0x02021040,7,2,136,NULL,30,0,0,'bonus bStr,1; bonus bAgi,1; bonus bMdef,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2655,'Bloody_Iron_Ball','Bloodied Shackle Ball',4,50000,NULL,4000,NULL,0,NULL,0,0xFFFFFFFE,7,2,136,NULL,1,0,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2656,'Hyper_Changer','Armor Charm',4,20000,NULL,1000,NULL,1,NULL,0,0x000654E2,7,2,136,NULL,1,0,0,'bonus bMaxHP,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2657,'Lab_Passport','Laboratory Permit',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,136,NULL,1,0,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2658,'Nile_Rose_','Nile Rose',4,2,NULL,100,NULL,0,NULL,1,0xFFFFFFFF,7,2,136,NULL,0,0,0,'bonus bMaxHP,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2659,'Vesper_Core01','Vesper Core 01',4,20,NULL,100,NULL,1,NULL,0,0x00CFFF80,2,2,136,NULL,1,0,0,'bonus bMdef,3; bonus bInt,2; bonus bMaxSPrate,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2660,'Vesper_Core02','Vesper Core 02',4,20,NULL,100,NULL,1,NULL,0,0x00CFFF80,2,2,136,NULL,1,0,0,'bonus bMdef,3; bonus bStr,3; bonus bBaseAtk,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2661,'Vesper_Core03','Vesper Core 03',4,20,NULL,100,NULL,1,NULL,0,0x00CFFF80,2,2,136,NULL,1,0,0,'bonus bMdef,3; bonus bAgi,3; bonus bFlee,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2662,'Vesper_Core04','Vesper Core 04',4,20,NULL,100,NULL,1,NULL,0,0x00CFFF80,2,2,136,NULL,1,0,0,'bonus bMdef,3; bonus bDex,3; bonus bHit,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2663,'Gauntlet_Of_Accuracy','Gauntlet of Hit',4,20,NULL,900,NULL,0,NULL,0,0xFFFFFFFF,7,2,136,NULL,75,0,0,'bonus bHit,15; bonus bStr,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2664,'Scarf_Belt','Belcarf',4,20,NULL,200,NULL,0,NULL,0,0xFFFFFFFE,7,2,136,NULL,75,0,0,'bonus bDex,2; bonus bInt,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2665,'Ring_Of_Exorcism','Exorcising Ring',4,20,NULL,500,NULL,0,NULL,0,0x00008110,7,2,136,NULL,60,0,0,'bonus bMdef,1; bonus2 bExpAddRace,RC_Undead,5; bonus2 bExpAddRace,RC_Demon,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2666,'Lamp_Of_Hope','Lantern of Hope',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,136,NULL,1,0,0,'bonus bStr,2; bonus2 bResEff,Eff_Blind,1000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2667,'Glove_Of_Archer','Renown Archer\'s Gloves',4,20,NULL,300,NULL,0,NULL,0,0xFFFFFFFE,7,2,136,NULL,60,0,0,'bonus bHit,5; bonus bCritical,5; bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2668,'Women\'s_Glory','Woman Glory',4,0,NULL,500,NULL,0,NULL,0,0xFFFFFFFF,7,2,136,NULL,1,0,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2669,'Golden_Necklace_','RJC Necklace',4,30000,NULL,100,NULL,0,NULL,1,0xFFFFFFFF,7,2,136,NULL,0,0,0,'bonus bMaxSP,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2670,'Ring_Of_Longing','Ring of Longing',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,7,2,136,NULL,30,0,0,'bonus bFlee,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2671,'Thimble_Of_Archer_','Bow Thimble',4,10000,NULL,100,NULL,0,NULL,1,0x00080808,7,2,136,NULL,65,0,0,'bonus bLongAtkRate,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2672,'Anniversary_Ring','3rd Anniversary Celebration Ring',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFE,7,2,136,NULL,0,0,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2673,'Shining_Ring','Warrior\'s Shining Ring',4,0,NULL,100,NULL,0,NULL,0,0xFFFFFFFE,7,2,136,NULL,48,0,0,'bonus bBaseAtk,10; bonus bSPrecovRate,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2674,'Honor_Ring','Ring of Honor',4,20,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,7,2,136,NULL,1,0,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2675,'Lord_Ring','Lord Ring',4,0,NULL,10,NULL,0,NULL,0,0xFFFFFFFF,7,2,136,NULL,1,0,0,'bonus bAllStats,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2676,'Hunter_Earring','Hunter\'s Earring',4,20,NULL,300,NULL,0,NULL,0,0xFFFFFFFF,7,2,136,NULL,1,0,0,'bonus2 bAddMonsterDropItem,7618,100;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2677,'Spiritual_Ring','Spiritual Ring',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,136,NULL,0,0,0,'bonus bInt,2; bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2678,'Ring_Of_Flame_Lord','Ring Of Flame Lord',4,20,NULL,100,NULL,0,NULL,0,0x00CFFF80,2,2,136,NULL,0,0,0,'bonus bStr,2; bonus bVit,1; bonus bBaseAtk,15; bonus2 bSubEle,Ele_Fire,10; bonus3 bAutoSpell,"CH_SOULCOLLECT",1,30; bonus3 bAutoSpell,"MO_EXPLOSIONSPIRITS",1,10; bonus3 bAutoSpell,"PA_PRESSURE",2,30; bonus3 bAutoSpell,"MG_FIREBALL",1,150; bonus3 bAutoSpell,"KN_BOWLINGBASH",5,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2679,'Ring_Of_Resonance','Ring Of Resonance',4,20,NULL,100,NULL,2,NULL,0,0x00CFFF80,2,2,136,NULL,0,0,0,'bonus bAgi,2; bonus bVit,1; bonus bMdef,2; bonus4 bAutoSpellWhenHit,"WZ_QUAGMIRE",1,50,0; bonus3 bAutoSpellWhenHit,"AS_SPLASHER",10,20; bonus3 bAutoSpellWhenHit,"AL_HEAL",10,30; bonus3 bAutoSpellWhenHit,"HP_ASSUMPTIO",3,20; bonus3 bAutoSpellWhenHit,"CG_TAROTCARD",5,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2680,'Lesser_Elemental_Ring','Lesser Elemental Ring',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,136,NULL,0,0,0,'bonus bAllStats,1; bonus3 bAutoSpell,"WZ_ESTIMATION",1,80; bonus3 bAutoSpell,"MC_IDENTIFY",1,50; bonus3 bAutoSpell,"TF_PICKSTONE",1,100; bonus3 bAutoSpell,"BS_GREED",1,10; bonus3 bAutoSpellWhenHit,"TK_RUN",5,20; bonus3 bAutoSpellWhenHit,"TK_HIGHJUMP",3,30; bonus3 bAutoSpellWhenHit,"NV_FIRSTAID",1,100; bonus3 bAutoSpellWhenHit,"TF_BACKSLIDING",1,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2681,'Republic_Ring','Republic Anniversary Ring',4,20,NULL,1000,NULL,0,NULL,0,0xFFFFFFFF,7,2,136,NULL,0,0,0,'bonus bAllStats,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2682,'Ring_Of_Water','Ring of Water',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFE,7,2,136,NULL,20,0,0,'bonus2 bSubEle,Ele_Water,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2683,'Ring_Of_Fire','Ring of Fire',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFE,7,2,136,NULL,20,0,0,'bonus2 bSubEle,Ele_Fire,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2684,'Ring_Of_Wind','Ring of Wind',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFE,7,2,136,NULL,20,0,0,'bonus2 bSubEle,Ele_Wind,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2685,'Ring_Of_Earth','Ring of Earth',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFE,7,2,136,NULL,20,0,0,'bonus2 bSubEle,Ele_Earth,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2686,'Elven_Ears_C','Elven Ears',4,1,NULL,0,NULL,2,NULL,0,0xFFFFFFFE,7,2,512,NULL,1,0,73,'bonus bInt,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2687,'Steel_Flower_C','Steel Flower',4,1,NULL,0,NULL,1,NULL,0,0xFFFFFFFE,7,2,1,NULL,1,0,56,'bonus2 bSubRace,RC_Plant,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2688,'Critical_Ring_C','Critical Ring',4,1,NULL,0,NULL,0,NULL,0,0xFFFFFFFE,7,2,136,NULL,1,0,0,'bonus bCritical,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2689,'Earring_C','Earring',4,1,NULL,0,NULL,0,NULL,0,0xFFFFFFFE,7,2,136,NULL,1,0,0,'bonus bInt,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2690,'Ring_C','Ring',4,1,NULL,0,NULL,0,NULL,0,0xFFFFFFFE,7,2,136,NULL,1,0,0,'bonus bStr,4;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2691,'Necklace_C','Necklace',4,1,NULL,0,NULL,0,NULL,0,0xFFFFFFFE,7,2,136,NULL,1,0,0,'bonus bVit,4;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2692,'Glove_C','Glove',4,1,NULL,0,NULL,0,NULL,0,0xFFFFFFFE,7,2,136,NULL,1,0,0,'bonus bDex,4;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2693,'Brooch_C','Brooch',4,1,NULL,0,NULL,0,NULL,0,0xFFFFFFFE,7,2,136,NULL,1,0,0,'bonus bAgi,4;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2694,'Rosary_C','Rosary',4,1,NULL,0,NULL,0,NULL,0,0xFFFFFFFE,7,2,136,NULL,1,0,0,'bonus bMdef,5; bonus bLuk,4;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2695,'Safety_Ring_C','Safety Ring',4,1,NULL,0,NULL,5,NULL,0,0xFFFFFFFE,7,2,136,NULL,1,0,0,'bonus bMdef,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2696,'Vesper_Core01_C','Vesper Core 01',4,1,NULL,0,NULL,1,NULL,0,0xFFFFFFFE,7,2,136,NULL,1,0,0,'bonus bMdef,3; bonus bInt,2; bonus bMaxSPrate,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2697,'Vesper_Core02_C','Vesper Core 02',4,1,NULL,0,NULL,1,NULL,0,0xFFFFFFFE,7,2,136,NULL,1,0,0,'bonus bMdef,3; bonus bStr,3; bonus bBaseAtk,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2698,'Vesper_Core03_C','Vesper Core 03',4,1,NULL,0,NULL,1,NULL,0,0xFFFFFFFE,7,2,136,NULL,1,0,0,'bonus bMdef,3; bonus bAgi,3; bonus bFlee,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2699,'Vesper_Core04_C','Vesper Core 04',4,1,NULL,0,NULL,1,NULL,0,0xFFFFFFFE,7,2,136,NULL,1,0,0,'bonus bMdef,3; bonus bDex,3; bonus bHit,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2700,'Red_Silk_Seal','Red Silk Seal',4,20,NULL,100,NULL,0,NULL,0,0x00004082,2,2,136,NULL,60,0,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2701,'Orleans_Glove','Orleans\'s Glove',4,20,NULL,100,NULL,0,NULL,1,0xFFFFFFFE,2,2,136,NULL,90,0,0,'bonus bDex,2; bonus bMatkRate,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2702,'Bison_Horn','Bison Horn',4,20,NULL,100,NULL,0,NULL,1,0xFFFFFFFE,2,2,136,NULL,90,0,0,'bonus bAgi,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2703,'Expert_Ring','Expert Ring',4,20,NULL,150,NULL,0,NULL,1,0xFFFFFFFE,2,2,136,NULL,50,0,0,'bonus bDelayRate,-5; bonus bUseSPrate,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2704,'Golden_Accessory','Golden Accessories',4,20,NULL,100,NULL,4,NULL,0,0xFFFFFFFF,7,2,136,NULL,0,0,0,'bonus bMdef,4;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2705,'Golden_Accessory2','Golden Accessories',4,20,NULL,100,NULL,4,NULL,0,0xFFFFFFFF,7,2,136,NULL,NULL,NULL,NULL,'bonus2 bAddMonsterDropItem,12018,500;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2706,'Handcuff','Arrest Handcuffs',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,7,2,136,NULL,0,0,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2707,'Gusli','GUSLI',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,136,NULL,0,0,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2708,'Chinese_Handicraft','Chinese Handicraft',4,0,NULL,50,NULL,0,NULL,0,0xFFFFFFFF,7,2,136,NULL,0,0,0,'bonus3 bAutoSpell,"MG_FIREBOLT",5,300;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2709,'5_Anniversary_Coin','5th Anniversary Coin',4,2,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,7,2,136,NULL,0,0,0,'bonus bAtkRate,5; bonus bMatkRate,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2710,'Bloody_Iron_Ball_C','Bloody Iron Ball',4,1,NULL,0,NULL,0,NULL,0,0xFFFFFFFE,7,2,136,NULL,0,0,0,'bonus bBaseAtk,30;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2711,'Spiritual_Ring_C','Spiritual Ring',4,1,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,7,2,136,NULL,0,0,0,'bonus bInt,2; bonus bDex,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2712,'Ragnarok_Limited_Ed','Ragnarok Limited Edition',4,0,NULL,300,NULL,0,NULL,0,0xFFFFFFFF,7,2,136,NULL,30,0,0,'bonus bVit,3; bonus bAgi,3; bonus bLuk,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2713,'Certificate_TW','Certificate',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,7,2,136,NULL,0,0,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2714,'Marvelous_Pandent','Marvelous Pendant',4,0,NULL,100,NULL,0,NULL,1,0xFFFFFFFF,7,2,136,NULL,0,0,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2715,'Skul_Ring_','Skull Ring',4,10000,NULL,100,NULL,0,NULL,1,0xFFFFFFFF,7,2,136,NULL,0,0,0,'bonus2 bSubRace,RC_Undead,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2716,'Librarian_Glove','Librarian Glove',4,20,NULL,100,NULL,0,NULL,1,0x00810200,7,2,136,NULL,80,0,0,'bonus bMaxSP,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2717,'Pocket_Watch_','Pocket Watch',4,20,NULL,200,NULL,0,NULL,0,0x00810204,7,2,136,NULL,80,0,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2718,'Lunatic_Brooch','Lunatic Brooch',4,20,NULL,200,NULL,0,NULL,1,0x00080808,7,2,136,NULL,65,0,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2719,'Iron_Wrist','Iron Wrist',4,20,NULL,700,NULL,1,NULL,0,0x000444A2,7,2,136,NULL,50,0,0,'bonus2 bSkillAtk,"SM_BASH",6; bonus2 bSkillAtk,"MC_MAMMONITE",6;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2720,'Medal_Swordman','Medal of Honor',4,20,NULL,0,NULL,1,NULL,0,0x00404082,7,2,136,NULL,70,0,0,'bonus2 bAddClass,Class_All,5; bonus bMatkRate,5; bonus bHit,10; bonus bMaxHP,500; bonus bMaxSP,50; bonus3 bAddEff,Eff_Stun,100,ATF_SHORT;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2721,'Medal_Thief','Medal of Honor',4,20,NULL,0,NULL,1,NULL,0,0x02021040,7,2,136,NULL,70,0,0,'bonus2 bAddClass,Class_All,5; bonus bMatkRate,5; bonus bFlee,10; bonus bMaxHP,300; bonus bMaxSP,80; bonus3 bAddEff,Eff_Poison,100,ATF_SHORT;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2722,'Medal_Acolyte','Medal of Honor',4,20,NULL,0,NULL,1,NULL,0,0x00008110,7,2,136,NULL,70,0,0,'bonus2 bAddClass,Class_All,5; bonus bMatkRate,5; bonus bMdef,6; bonus bMaxHP,600; bonus3 bAddEff,Eff_Silence,100,ATF_SHORT;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2723,'Medal_Mage','Medal of Honor',4,20,NULL,0,NULL,1,NULL,0,0x00810204,7,2,136,NULL,70,0,0,'bonus2 bAddClass,Class_All,5; bonus bMatkRate,5; bonus bMdef,6; bonus bMaxHP,600; bonus2 bAddEffWhenHit,Eff_Stone,100;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2724,'Medal_Archer','Medal of Honor',4,20,NULL,0,NULL,1,NULL,0,0x00080808,7,2,136,NULL,70,0,0,'bonus2 bAddClass,Class_All,5; bonus bMatkRate,5; bonus bCritical,10; bonus bMaxHP,300; bonus bMaxSP,80; bonus3 bAddEff,Eff_Blind,100,ATF_LONG;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2725,'Medal_Merchant','Medal of Honor',4,20,NULL,0,NULL,1,NULL,0,0x00040420,7,2,136,NULL,70,0,0,'bonus2 bAddClass,Class_All,5; bonus bMatkRate,5; bonus bAspdRate,10; bonus bMaxHP,500; bonus bMaxSP,50; bonus3 bAddEff,Eff_Curse,100,ATF_SHORT;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2726,'Icarus_Wing','Icarus Wings',4,20,NULL,100,NULL,0,NULL,0,0x00000800,2,2,136,NULL,70,0,0,'bonus bMaxSP,50; bonus bDex,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2727,'Bowman_Scarf','Bowman Scarf',4,20,NULL,200,NULL,0,NULL,0,0x00000800,2,2,136,NULL,70,0,0,'bonus bMaxSP,50; bonus bDex,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2728,'Cursed_Hand','Cursed Hand',4,20,NULL,50,NULL,0,NULL,1,0xFFFFFFFE,7,2,136,NULL,80,0,0,'bonus3 bAutoSpell,"NPC_CRITICALWOUND",1,30; bonus bHit,10; bonus bHPrecovRate,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2729,'Diabolus_Ring','Diabolus Ring',4,20,NULL,50,NULL,0,NULL,1,0x00CFFF80,2,2,136,NULL,0,0,0,'bonus bMaxHP,100; bonus bMaxSP,100; bonus bHealPower,5; bonus2 bAddDamageClass,1916,10; bonus2 bAddDamageClass,1917,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2730,'Morroc_Seal','Seal of Continental Guard',4,20,NULL,50,NULL,0,NULL,1,0xFFFFFFFE,7,2,136,NULL,80,0,0,'bonus bMaxHP,50; bonus bAspdRate,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2731,'Morroc_Charm_Stone','Rune Spellstone',4,20,NULL,50,NULL,0,NULL,1,0xFFFFFFFE,7,2,136,NULL,80,0,0,'bonus bMaxSP,50; bonus bCastRate,-1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2732,'Morroc_Ring','Death Loop',4,20,NULL,50,NULL,0,NULL,1,0xFFFFFFFE,7,2,136,NULL,80,0,0,'bonus bCritical,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2733,'Medal_Gunner','Sheriff Badge',4,20,NULL,0,NULL,1,NULL,0,0x41000000,7,2,136,NULL,70,0,0,'bonus2 bAddClass,Class_All,5; bonus bMatkRate,5; bonus bCritical,10; bonus bMaxHP,300; bonus bMaxSP,80; bonus3 bAddEff,Eff_Blind,100,ATF_LONG;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2734,'Directive_A','Directive',4,0,NULL,0,NULL,1,NULL,0,0x00000001,7,2,136,NULL,0,0,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2735,'Directive_B','Directive',4,0,NULL,0,NULL,1,NULL,0,0x00000001,7,2,136,NULL,0,0,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2736,'Navel_Ring','Navel Ring',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFE,7,2,136,NULL,75,0,0,'bonus bDex,3; bonus bLuk,3; bonus bMdef,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2737,'Foot_Ring','Foot Ring',4,20,NULL,150,NULL,0,NULL,0,0xFFFFFFFE,7,2,136,NULL,75,0,0,'bonus bVit,3; bonus bMaxHPRate,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2738,'Shiny_Coin','Shiny Coin',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,7,2,136,NULL,0,0,0,'bonus2 bAddClass,Class_All,6; bonus bMatkRate,6;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2739,'Ordinary_Coin','Ordinary Coin',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,7,2,136,NULL,0,0,0,'bonus2 bAddClass,Class_All,5; bonus bMatkRate,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2740,'Rusty_Coin','Rusty Coin',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,7,2,136,NULL,0,0,0,'bonus2 bAddClass,Class_All,3; bonus bMatkRate,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2741,'All_In_One_Ring','All In One Ring',4,20,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,7,2,136,NULL,0,0,0,'bonus bAllStats,1; bonus bNoCastCancel; bonus bCastRate,10; skill "AL_HEAL",1; skill "AL_TELEPORT",1;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (2742,'Lucky_Clip','Lucky Clip',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,7,2,136,NULL,0,0,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2743,'Angelic_Ring','Angelic Ring',4,20,NULL,100,NULL,0,NULL,0,0x00CFFF80,2,2,136,NULL,70,0,0,'bonus bInt,2; bonus bDex,1; bonus bMdef,2; autobonus3 "{ bonus bHealPower,20; }",100,3000,"AL_HEAL","{ specialeffect2 EF_HEAL3; }"; autobonus3 "{ bonus bHealPower,20; }",100,3000,"AM_POTIONPITCHER","{ specialeffect2 EF_HEAL3; }"; autobonus3 "{ bonus bHealPower,20; }",100,3000,"PR_SANCTUARY","{ specialeffect2 EF_HEAL3; }";',NULL,NULL);
REPLACE INTO `item_db` VALUES (2744,'Sprint_Ring','Sprint Ring',4,20,NULL,100,NULL,0,NULL,0,0x00CFFF80,2,2,136,NULL,70,0,0,'bonus bCastrate,-10; bonus bDelayRate,-5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2745,'Pinguicula_Corsage','Pinguicula Corsage',4,20,NULL,200,NULL,0,NULL,1,0x00CFFF80,2,2,136,NULL,70,0,0,'bonus bMdef,2; bonus bMaxSP,25;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2746,'Cold_Heart','Cold Heart',4,20,NULL,100,NULL,1,NULL,0,0x00001000,2,2,136,NULL,80,0,0,'bonus bAgi,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2747,'Black_Cat','Black Cat',4,20,NULL,100,NULL,1,NULL,0,0x00020000,2,2,136,NULL,80,0,0,'bonus bDex,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2748,'Cursed_Star','Cursed Star',4,20,NULL,200,NULL,0,NULL,0,0x00080808,2,2,136,NULL,84,0,0,'bonus bMdef,3; bonus bDex,2; bonus bLuk,-1; bonus2 bHPLossRate,50,10000; bonus3 bAddEff,Eff_Curse,200,ATF_WEAPON|ATF_LONG|ATF_TARGET;',NULL,'heal -300,0;');
REPLACE INTO `item_db` VALUES (2749,'Linen_Glove','Linen Glove',4,20,NULL,120,NULL,1,NULL,1,0x00CFFF80,2,2,136,NULL,90,0,0,'bonus bMdef,2; bonus bAgi,2; bonus bDex,1;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (2750,'Summer_Night_Dream','Summer Night Dream',4,20,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,7,2,136,NULL,0,0,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2751,'Academy_Badge','Academy Of Badge',4,0,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,136,NULL,0,0,0,'if(BaseLevel<80) { bonus bMaxHP,400; bonus bMaxSP,200; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (2752,'Praxinus_C','Praccsinos',4,2,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,7,2,136,NULL,1,0,0,'bonus2 bAddClass,Class_All,5; bonus bMatkrate,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2753,'Beholder_Ring','Beholder Ring',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,7,2,136,NULL,1,0,0,'bonus2 bExpAddRace,RC_Formless,15;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2754,'Hallow_Ring','Hallow Ring',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,7,2,136,NULL,1,0,0,'bonus2 bExpAddRace,RC_undead,15;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2755,'Clamorous_Ring','Clamorous Ring',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,7,2,136,NULL,1,0,0,'bonus2 bExpAddRace,RC_Brute,15;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2756,'Chemical_Ring','Chemical Ring',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,7,2,136,NULL,1,0,0,'bonus2 bExpAddRace,RC_Plant,15;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2757,'Insecticide_Ring','Insecticide Ring',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,7,2,136,NULL,1,0,0,'bonus2 bExpAddRace,RC_Insect,15;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2758,'Fisher_Ring','Fischer Ring',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,7,2,136,NULL,1,0,0,'bonus2 bExpAddRace,RC_Fish,15;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2759,'Decussate_Ring','Decussate Ring',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,7,2,136,NULL,1,0,0,'bonus2 bExpAddRace,RC_Demon,15;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2760,'Bloody_Ring','Bloody Ring',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,7,2,136,NULL,1,0,0,'bonus2 bExpAddRace,RC_DemiHuman,15;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2761,'Satanic_Ring','Satanic Ring',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,7,2,136,NULL,1,0,0,'bonus2 bExpAddRace,RC_Angel,15;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2762,'Dragoon_Ring','Dragon Ring',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,7,2,136,NULL,1,0,0,'bonus2 bExpAddRace,RC_Dragon,15;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2763,'Skul_Ring_C','Neo Skull Ring',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFE,2,2,136,NULL,95,0,0,'bonus bAtkRate,5; bonus bMatkrate,5; bonus bMaxHPrate,5; bonus2 bSkillHeal,"AL_HEAL",5; skill "MG_SIGHT",1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2764,'Small_Fishing_Rod','Small Fishing Rod',4,10,NULL,250,NULL,0,NULL,0,0xFFFFFFFF,7,2,136,NULL,0,0,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2765,'Novice_Figure','Novice Figure',4,0,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,136,NULL,0,0,0,'bonus bMaxHP,70; if(BaseJob==Job_Novice||BaseJob==Job_SuperNovice) bonus bMaxHP,30;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2766,'Swordman_Figure','Swordman Figure',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,7,2,136,NULL,0,0,0,'bonus bVit,1; if(Class==Job_Swordman) bonus bDef,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2767,'Acolyte_Figure','Acolyte Figure',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,7,2,136,NULL,0,0,0,'bonus bInt,1; if(Class==Job_Acolyte) bonus bMaxSP,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2768,'Mage_Figure','Mage Figure',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,7,2,136,NULL,0,0,0,'bonus bInt,1; if(Class==Job_Mage) bonus bSPrecovRate,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2769,'Archer_Figure','Archer Figure',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,7,2,136,NULL,0,0,0,'bonus bDex,1; if(Class==Job_Archer) bonus bBaseAtk,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2770,'Thief_Figure','Thief Figure',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,7,2,136,NULL,0,0,0,'bonus bAgi,1; if(Class==Job_Thief) bonus bAspdRate,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2771,'Merchant_Figure','Merchant Figure',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,7,2,136,NULL,0,0,0,'bonus bStr,1; if(Class==Job_Merchant) bonus bCritical,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2772,'Krieger_Ring1','Glorious Ring',4,20,NULL,0,NULL,0,NULL,0,0xFFFFFFFE,7,2,136,NULL,81,0,0,'bonus bMaxHP,300; bonus2 bSubEle,Ele_Water,10; bonus2 bSubEle,Ele_Wind,10; bonus2 bSubEle,Ele_Earth,10; bonus2 bSubEle,Ele_Fire,10; bonus bAspdRate,5; bonus bCastrate,-3; bonus bHealPower,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2773,'Krieger_Ring2','Glorious Mass-Production Ring',4,20,NULL,0,NULL,0,NULL,0,0xFFFFFFFE,7,2,136,NULL,61,0,0,'bonus bAllStats,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2774,'Krieger_Ring3','Glorious Popularized Ring',4,20,NULL,0,NULL,0,NULL,0,0xFFFFFFFE,7,2,136,NULL,0,0,0,'bonus bAllStats,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2775,'Lure','Lure',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,136,NULL,0,0,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2776,'Cool_Towel','Adventurer\'s Trusty Towel',4,20,NULL,100,NULL,NULL,NULL,0,0xFFFFFFFF,7,2,136,NULL,0,0,0,NULL,'sc_start SC_SUMMER,INFINITE_TICK,0;','sc_end SC_SUMMER;');
REPLACE INTO `item_db` VALUES (2777,'Shaman_Ring','Shaman Ring',4,20,NULL,100,NULL,0,NULL,1,0xFFFFFFFF,7,2,136,NULL,30,0,0,'bonus bUseSPrate,-5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2778,'Shaman_Earing','Shaman Earrings',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,136,NULL,30,0,0,'bonus bInt,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2779,'Dark_Knight_Belt','Dark Knight Belt',4,20,NULL,500,NULL,1,NULL,0,0xFFFFFFFF,7,2,136,NULL,30,0,0,'bonus bStr,2; bonus bAgi,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2780,'Dark_Knight_Glove','Dark Knight Glove',4,20,NULL,500,NULL,1,NULL,0,0xFFFFFFFF,7,2,136,NULL,80,0,0,'autobonus "{ bonus bAspdRate,2; }",10,10000,0,"{ specialeffect2 EF_POTION_BERSERK; }";',NULL,NULL);
REPLACE INTO `item_db` VALUES (2781,'Aumdura\'s_Grace','Aumdura\'s Benefit',4,0,NULL,100,NULL,1,NULL,1,0xFFFFFFFF,7,2,136,NULL,1,0,0,'bonus bAllStats,1; bonus bMdef,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2782,'Ring_Of_Wise_King','Ring of the Ancient Wise King',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,136,NULL,0,0,0,'bonus bMaxHP,50; bonus bMaxSP,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2783,'Eyes_Stone_Ring','Eye Stone Ring',4,20,NULL,100,NULL,0,NULL,1,0xFFFFFFFF,7,2,136,NULL,70,0,0,'bonus bCritical,2; bonus bMaxSP,25;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2784,'Oh_Holy_Night','Christmas Musicbox',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,136,NULL,1,0,0,'skill "ALL_WEWISH",1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2785,'Orleans_Glove_M','Orlean\'s Gloves',4,20,NULL,100,NULL,0,NULL,1,0xFFFFFFFE,2,2,136,NULL,90,0,0,'bonus bDex,2; bonus bMatkRate,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2786,'Spiritual_Ring_M','Spiritual Ring',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,136,NULL,0,0,0,'bonus bInt,2; bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2787,'Waterdrop_Brooch','Waterdrop Brooch',4,20,NULL,200,NULL,0,NULL,1,0xFFFFFFFE,2,2,136,NULL,75,0,0,'bonus2 bSubEle,Ele_Water,5; bonus bMaxHP,80; bonus bMdef,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2788,'Bradium_Earing','Bradium Earring',4,20,NULL,200,NULL,0,NULL,1,0xFFFFFFFE,2,2,136,NULL,60,0,0,'bonus bMatkRate,2; bonus bInt,1; bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2789,'Bradium_Ring','Bradium Ring',4,20,NULL,200,NULL,0,NULL,1,0xFFFFFFFE,2,2,136,NULL,60,0,0,'bonus2 bAddClass,Class_All,2; bonus bStr,1; bonus bVit,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2790,'Bradium_Brooch','Bradium Brooch',4,20,NULL,200,NULL,0,NULL,1,0xFFFFFFFE,2,2,136,NULL,60,0,0,'bonus bFlee,4; bonus bAspdRate,2; bonus bAgi,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2791,'Just_Got_Fish','Fresh Fish',4,20,NULL,500,NULL,0,NULL,1,0xFFFFFFFF,7,2,136,NULL,1,0,0,'bonus bHit,3;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (2792,'Ring_Of_Flame_Lord_I','Ring of Flame Lord',4,0,NULL,0,NULL,0,NULL,0,0x00CFFF80,2,2,136,NULL,0,0,0,'bonus bStr,2; bonus bVit,1; bonus bBaseAtk,15; bonus2 bSubEle,Ele_Fire,10; bonus3 bAutoSpell,"CH_SOULCOLLECT",1,30; bonus3 bAutoSpell,"MO_EXPLOSIONSPIRITS",1,10; bonus3 bAutoSpell,"PA_PRESSURE",2,30; bonus3 bAutoSpell,"MG_FIREBALL",1,150; bonus3 bAutoSpell,"KN_BOWLINGBASH",5,20;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (2793,'Ring_Of_Resonance_I','Ring of Resonance',4,0,NULL,0,NULL,2,NULL,0,0x00CFFF80,2,2,136,NULL,0,0,0,'bonus bAgi,2; bonus bVit,1; bonus bMdef,2; bonus4 bAutoSpellWhenHit,"WZ_QUAGMIRE",1,50,0; bonus3 bAutoSpellWhenHit,"AS_SPLASHER",10,20; bonus3 bAutoSpellWhenHit,"AL_HEAL",10,30; bonus3 bAutoSpellWhenHit,"HP_ASSUMPTIO",3,20; bonus3 bAutoSpellWhenHit,"CG_TAROTCARD",5,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2794,'Magic_Stone_Ring','Magic Stone Ring',4,0,NULL,0,NULL,0,NULL,1,0x00004082,7,2,136,NULL,99,0,0,'bonus bStr,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2795,'Green_Apple_Ring','Green Apple Ring',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFE,7,2,136,NULL,99,0,0,'bonus bAllStats,6; if(JobLevel <30) { bonus bAllStats,(JobLevel/5); }',NULL,NULL);
REPLACE INTO `item_db` VALUES (2796,'Magical_Stone','Rocks',4,0,NULL,200,NULL,0,NULL,0,0x00810204,7,2,136,NULL,99,0,0,'bonus2 bAddDamageClass,2047,10; bonus2 bAddDefMonster,2048,-10; bonus3 bAddMonsterIdDropItem,6152,2047,70;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2797,'Magical_Stone_','Rocks',4,0,NULL,200,NULL,0,NULL,0,0x00810204,7,2,136,NULL,99,0,0,'bonus2 bAddDamageClass,2049,10; bonus2 bAddDefMonster,2050,-10; bonus3 bAddMonsterIdDropItem,6151,2049,70;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2798,'Will_Of_Exhausted_Angel','Will Of Exhausted Angel',4,0,NULL,200,NULL,0,NULL,0,0x00008100,7,2,136,NULL,99,0,0,'if(strcharinfo(3)=="job3_arch02") { bonus2 bAddDefMonster,1761,50; bonus2 bAddDefMonster,1762,50; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (2799,'Kuirpenring','Kuirpenring',4,0,NULL,100,NULL,0,NULL,1,0xFFFFFFFF,7,2,136,NULL,0,0,0,'bonus bMdef,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2800,'Accelerator','Accelerator',4,100000,NULL,100,NULL,0,NULL,1,0x00000400,7,2,136,NULL,99,0,0,'bonus bAgi,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2801,'Hovering_Booster','Hovering Booster',4,100000,NULL,2000,NULL,0,NULL,1,0x00000400,7,2,136,NULL,99,0,0,'bonus bAgi,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2802,'Suicidal_Device','Suicidal Device',4,500000,NULL,1000,NULL,0,NULL,1,0x00000400,7,2,136,NULL,99,0,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2803,'Shape_Shifter','Shape Shifter',4,100000,NULL,500,NULL,0,NULL,1,0x00000400,7,2,136,NULL,99,0,0,'bonus bInt,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2804,'Cooling_Device','Cooling Device',4,100000,NULL,2500,NULL,0,NULL,1,0x00000400,7,2,136,NULL,99,0,0,'bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2805,'Mag_Field_Generator','Magnetic Field Generator',4,100000,NULL,6000,NULL,0,NULL,1,0x00000400,7,2,136,NULL,99,0,0,'bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2806,'Barrier_Builder','Barrier Builder',4,150000,NULL,8000,NULL,3,NULL,1,0x00000400,7,2,136,NULL,99,0,0,'bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2807,'Repair_Kit','Repair Kit',4,200000,NULL,400,NULL,0,NULL,1,0x00000400,7,2,136,NULL,99,0,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (2808,'Camouflage_Generator','Camouflague Generator',4,250000,NULL,1000,NULL,0,NULL,1,0x00000400,7,2,136,NULL,99,0,0,'bonus bAgi,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2809,'High_Quality_Cooler','High Quality Cooler',4,100000,NULL,2500,NULL,0,NULL,1,0x00000400,7,2,136,NULL,99,0,0,'bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2810,'Special_Cooler','Special Cooler',4,100000,NULL,2500,NULL,0,NULL,1,0x00000400,7,2,136,NULL,99,0,0,'bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2819,'Swordman_Manual','Swordsman Manual',4,0,NULL,100,NULL,0,NULL,0,0x00000001,7,2,136,NULL,1,0,0,'bonus bMaxSP,100; skill "SM_BASH",1; skill "SM_PROVOKE",1; skill "SM_MAGNUM",1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2820,'Thief_Manual','Thief Manual',4,0,NULL,100,NULL,0,NULL,0,0x00000001,7,2,136,NULL,1,0,0,'bonus bMaxSP,100; skill "TF_DOUBLE",3; bonus bDoubleRate,15; skill "TF_STEAL",1; skill "TF_HIDING",1; skill "TF_POISON",1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2821,'Acolyte_Manual','Acolyte Manual',4,0,NULL,100,NULL,0,NULL,0,0x00000001,7,2,136,NULL,1,0,0,'bonus bMaxSP,100; skill "AL_HEAL",1; skill "AL_INCAGI",1; skill "AL_BLESSING",1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2822,'Archer_Manual','Archer Manual',4,0,NULL,100,NULL,0,NULL,0,0x00000001,7,2,136,NULL,1,0,0,'bonus bMaxSP,100; skill "AC_OWL",1; skill "AC_CONCENTRATION",1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2823,'Merchant_Manual','Merchant Manual',4,0,NULL,100,NULL,0,NULL,0,0x00000001,7,2,136,NULL,1,0,0,'bonus bMaxSP,100; skill "MC_DISCOUNT",1; skill "MC_OVERCHARGE",10; skill "MC_IDENTIFY",1; skill "MC_MAMMONITE",1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (2824,'Mage_Manual','Mage Manual',4,0,NULL,100,NULL,0,NULL,0,0x00000001,7,2,136,NULL,1,0,0,'bonus bMaxSP,100; skill "MG_SRECOVERY",1; skill "MG_COLDBOLT",1; skill "MG_FIREWALL",1; skill "MG_FIREBOLT",1;',NULL,NULL);
# Cards
#===================================================================
REPLACE INTO `item_db` VALUES (4001,'Poring_Card','Poring Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bLuk,2; bonus bFlee2,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4002,'Fabre_Card','Fabre Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bVit,1; bonus bMaxHP,100;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4003,'Pupa_Card','Pupa Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bMaxHP,700;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4004,'Drops_Card','Drops Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bDex,1; bonus bHit,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4005,'Poring__Card','Santa Poring Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddEle,Ele_Dark,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4006,'Lunatic_Card','Lunatic Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bLuk,1; bonus bCritical,1; bonus bFlee2,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4007,'Pecopeco_Egg_Card','Peco Peco Egg Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddRace,RC_Formless,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4008,'Picky_Card','Picky Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bStr,1; bonus bBaseAtk,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4009,'Chonchon_Card','Chonchon Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus bAgi,1; bonus bFlee,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4010,'Wilow_Card','Willow Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bMaxSP,80;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4011,'Picky__Card','Picky Egg Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bVit,1; bonus bMaxHP,100;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4012,'Thief_Bug_Egg_Card','Thief Bug Egg Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus bMaxHP,400;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4013,'Andre_Egg_Card','Andre Egg Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus bMaxHPrate,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4014,'Roda_Frog_Card','Roda Frog Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bMaxHP,400; bonus bMaxSP,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4015,'Condor_Card','Condor Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus bFlee,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4016,'Thief_Bug_Card','Thief Bug Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bAgi,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4017,'Savage_Babe_Card','Savage Babe Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddEff,Eff_Stun,500;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4018,'Andre_Larva_Card','Andre Larva Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bInt,1; bonus bMaxSP,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4019,'Hornet_Card','Hornet Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bStr,1; bonus bBaseAtk,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4020,'Farmiliar_Card','Familiar Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddEff,Eff_Blind,500; bonus bBaseAtk,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4021,'Rocker_Card','Rocker Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bDex,1; bonus bBaseAtk,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4022,'Spore_Card','Spore Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus bVit,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4023,'Desert_Wolf_Babe_Card','Baby Desert Wolf Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bInt,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4024,'Plankton_Card','Plankton Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddEff,Eff_Sleep,500; bonus bBaseAtk,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4025,'Skeleton_Card','Skeleton Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bBaseAtk,10; bonus2 bAddEff,Eff_Stun,200;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4026,'Thief_Bug_Female_Card','Female Thief Bug Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bAgi,1; bonus bFlee,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4027,'Kukre_Card','Kukre Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus bAgi,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4028,'Tarou_Card','Tarou Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus bStr,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4029,'Wolf_Card','Wolf Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bBaseAtk,15; bonus bCritical,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4030,'Mandragora_Card','Mandragora Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddEle,Ele_Wind,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4031,'Pecopeco_Card','Peco Peco Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bMaxHPrate,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4032,'Ambernite_Card','Ambernite Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus bDef,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4033,'Poporing_Card','Poporing Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'skill "TF_DETOXIFY",1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4034,'Worm_Tail_Card','Wormtail Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus bDex,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4035,'Hydra_Card','Hydra Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddRace,RC_DemiHuman,20; bonus2 bAddRace,RC_Player,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4036,'Muka_Card','Muka Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus bHPrecovRate,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4037,'Snake_Card','Snake Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddEff,Eff_Poison,500; bonus bBaseAtk,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4038,'Zombie_Card','Zombie Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus bHPrecovRate,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4039,'Stainer_Card','Stainer Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus2 bResEff,Eff_Silence,2000; bonus bDef,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4040,'Creamy_Card','Creamy Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'skill "AL_TELEPORT",1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4041,'Coco_Card','Coco Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus2 bResEff,Eff_Sleep,2000; bonus bDef,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4042,'Steel_Chonchon_Card','Steel Chonchon Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus2 bSubEle,Ele_Wind,10; bonus bDef,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4043,'Andre_Card','Andre Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bBaseAtk,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4044,'Smokie_Card','Smokie Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'skill "TF_HIDING",1;',NULL,'sc_end SC_HIDING;');
REPLACE INTO `item_db` VALUES (4045,'Horn_Card','Horn Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus bLongAtkDef,35;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4046,'Martin_Card','Martin Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus2 bResEff,Eff_Blind,2000; bonus bDef,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4047,'Ghostring_Card','Ghostring Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bDefEle,Ele_Ghost; bonus bHPrecovRate,-25;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4048,'Poison_Spore_Card','Poison Spore Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'skill "TF_POISON",3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4049,'Vadon_Card','Vadon Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddEle,Ele_Fire,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4050,'Thief_Bug_Male_Card','Male Thief Bug Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus bAgi,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4051,'Yoyo_Card','Yoyo Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus bFlee2,5; bonus bAgi,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4052,'Elder_Wilow_Card','Elder Willow Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bInt,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4053,'Vitata_Card','Vitata Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'skill "AL_HEAL",1; bonus bUseSPrate,25;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4054,'Angeling_Card','Angeling Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bDefEle,Ele_Holy;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4055,'Marina_Card','Marina Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddEff,Eff_Freeze,500; bonus bBaseAtk,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4056,'Dustiness_Card','Dustiness Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus2 bSubEle,Ele_Wind,30; bonus bFlee,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4057,'Metaller_Card','Metaller Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddEff,Eff_Silence,500; bonus bBaseAtk,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4058,'Thara_Frog_Card','Thara Frog Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus2 bSubRace,RC_DemiHuman,30; bonus2 bSubRace,RC_Player,30;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4059,'Soldier_Andre_Card','Soldier Andre Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus2 bSubRace,RC_Plant,30;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4060,'Goblin_Card','Goblin Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddRace,RC_Brute,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4061,'Cornutus_Card','Cornutus Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bUnbreakableArmor; bonus bDef,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4062,'Anacondaq_Card','Anacondaq Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddEle,Ele_Poison,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4063,'Caramel_Card','Caramel Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddRace,RC_Insect,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4064,'Zerom_Card','Zerom Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus bDex,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4065,'Kaho_Card','Kaho Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddEle,Ele_Earth,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4066,'Orc_Warrior_Card','Orc Warrior Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus2 bSubRace,RC_Brute,30;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4067,'Megalodon_Card','Megalodon Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus2 bResEff,Eff_Freeze,2000; bonus bDef,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4068,'Scorpion_Card','Scorpion Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddRace,RC_Plant,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4069,'Drainliar_Card','Drainliar Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddEle,Ele_Water,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4070,'Eggyra_Card','Eggyra Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus bSPrecovRate,15;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4071,'Orc_Zombie_Card','Orc Zombie Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus2 bSubEle,Ele_Undead,30; bonus bFlee,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4072,'Golem_Card','Golem Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bUnbreakableWeapon; bonus bBaseAtk,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4073,'Pirate_Skel_Card','Pirate Skeleton Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'skill "MC_DISCOUNT",5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4074,'BigFoot_Card','Bigfoot Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus2 bSubRace,RC_Insect,30;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4075,'Argos_Card','Argos Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus2 bResEff,Eff_Stone,2000; bonus bDef,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4076,'Magnolia_Card','Magnolia Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddEff,Eff_Curse,500; bonus bBaseAtk,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4077,'Phen_Card','Phen Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus bNoCastCancel; bonus bCastrate,25;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4078,'Savage_Card','Savage Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bVit,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4079,'Mantis_Card','Mantis Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus bStr,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4080,'Flora_Card','Flora Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddRace,RC_Fish,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4081,'Hode_Card','Hode Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus2 bSubEle,Ele_Earth,30; bonus bFlee,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4082,'Desert_Wolf_Card','Desert Wolf Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddSize,Size_Small,15; bonus bBaseAtk,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4083,'Rafflesia_Card','Rafflesia Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus2 bSubRace,RC_Fish,30;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4084,'Marine_Sphere_Card','Marine Sphere Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'skill "SM_MAGNUM",3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4085,'Orc_Skeleton_Card','Orc Skeleton Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddEle,Ele_Holy,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4086,'Soldier_Skeleton_Card','Soldier Skeleton Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bCritical,9;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4087,'Giearth_Card','Giearth Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus2 bResEff,Eff_Confusion,10000; bonus2 bSubEle,Ele_Earth,15;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4088,'Frilldora_Card','Frilldora Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'skill "AS_CLOAKING",1;',NULL,'sc_end SC_CLOAKING;');
REPLACE INTO `item_db` VALUES (4089,'Sword_Fish_Card','Swordfish Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bDefEle,Ele_Water; bonus bDef,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4090,'Munak_Card','Munak Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus2 bResEff,Eff_Stone,1500; bonus2 bSubEle,Ele_Earth,5; bonus bDef,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4091,'Kobold_Card','Kobold Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus bStr,1; bonus bCritical,4;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4092,'Skel_Worker_Card','Skeleton Worker Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddSize,Size_Medium,15; bonus bBaseAtk,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4093,'Obeaune_Card','Obeaune Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'skill "AL_CURE",1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4094,'Archer_Skeleton_Card','Archer Skeleton Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bLongAtkRate,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4095,'Marse_Card','Marse Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus2 bSubEle,Ele_Water,30; bonus bFlee,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4096,'Zenorc_Card','Zenorc Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddEff,Eff_Poison,400; bonus bBaseAtk,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4097,'Matyr_Card','Matyr Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus bMaxHPrate,10; bonus bAgi,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4098,'Dokebi_Card','Dokebi Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bDefEle,Ele_Wind; bonus bDef,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4099,'Pasana_Card','Pasana Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bDefEle,Ele_Fire; bonus bDef,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4100,'Sohee_Card','Sohee Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus bMaxSPrate,15; bonus bSPrecovRate,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4101,'Sand_Man_Card','Sandman Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bDefEle,Ele_Earth; bonus bDef,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4102,'Whisper_Card','Whisper Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus bFlee,20; bonus2 bSubEle,Ele_Ghost,-50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4103,'Horong_Card','Horong Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'skill "MG_SIGHT",1;',NULL,'sc_end SC_SIGHT;');
REPLACE INTO `item_db` VALUES (4104,'Requiem_Card','Requiem Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddEff,Eff_Confusion,500;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4105,'Marc_Card','Marc Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus2 bSubEle,Ele_Water,5; bonus2 bResEff,Eff_Freeze,10000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4106,'Mummy_Card','Mummy Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bHit,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4107,'Verit_Card','Verit Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus bMaxHPrate,8; bonus bMaxSPrate,8;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4108,'Myst_Card','Myst Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus2 bSubEle,Ele_Poison,30; bonus bFlee,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4109,'Jakk_Card','Jakk Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus2 bSubEle,Ele_Fire,30; bonus bFlee,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4110,'Ghoul_Card','Ghoul Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus2 bResEff,Eff_Poison,2000; bonus bDef,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4111,'Strouf_Card','Strouf Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddRace,RC_Demon,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4112,'Marduk_Card','Marduk Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus2 bResEff,Eff_Silence,10000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4113,'Marionette_Card','Marionette Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus2 bSubEle,Ele_Ghost,30; bonus bFlee,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4114,'Argiope_Card','Argiope Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bDefEle,Ele_Poison; bonus bDef,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4115,'Hunter_Fly_Card','Hunter Fly Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bHPDrainRate,30,15;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4116,'Isis_Card','Isis Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus2 bSubEle,Ele_Dark,30; bonus bFlee,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4117,'Side_Winder_Card','Sidewinder Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'skill "TF_DOUBLE",1; bonus bDoubleRate,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4118,'Petit_Card','Earth Petite Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddRace,RC_Dragon,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4119,'Bathory_Card','Bathory Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bDefEle,Ele_Dark;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4120,'Petit__Card','Sky Petite Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus2 bSubRace,RC_Dragon,30;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4121,'Phreeoni_Card','Phreeoni Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bHit,100;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4122,'Deviruchi_Card','Deviruchi Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bStr,1; bonus2 bResEff,Eff_Blind,10000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4123,'Eddga_Card','Eddga Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus bMaxHPrate,-25; bonus bNoWalkDelay;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4124,'Medusa_Card','Medusa Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus2 bSubRace,RC_Demon,15; bonus2 bResEff,Eff_Stone,10000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4125,'Deviace_Card','Deviace Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddRace,RC_DemiHuman,7; bonus2 bAddRace,RC_Player,7; bonus2 bAddRace,RC_Brute,7; bonus2 bAddRace,RC_Plant,7; bonus2 bAddRace,RC_Insect,7;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4126,'Minorous_Card','Minorous Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddSize,Size_Large,15; bonus bBaseAtk,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4127,'Nightmare_Card','Nightmare Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus2 bResEff,Eff_Sleep,10000; bonus bAgi,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4128,'Golden_Bug_Card','Golden Thief Bug Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus bNoMagicDamage,100; bonus bUseSPrate,100;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4129,'Baphomet__Card','Bapho Jr. Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus bAgi,3; bonus bCritical,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4130,'Scorpion_King_Card','Scorpion King Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddEle,Ele_Undead,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4131,'Moonlight_Flower_Card','Moonlight Flower Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus bSpeedRate,25;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4132,'Mistress_Card','Mistress Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bNoGemStone; bonus bUseSPrate,25;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4133,'Daydric_Card','Raydric Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus2 bSubEle,Ele_Neutral,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4134,'Dracula_Card','Dracula Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bSPDrainRate,100,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4135,'Orc_Load_Card','Orc Lord Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bShortWeaponDamageReturn,30;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4136,'Khalitzburg_Card','Khalitzburg Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus2 bSubRace,RC_Demon,30;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4137,'Drake_Card','Drake Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bNoSizeFix;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4138,'Anubis_Card','Anubis Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus2 bSubRace,RC_Angel,30;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4139,'Joker_Card','Joker Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'skill "TF_STEAL",1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4140,'Knight_Of_Abyss_Card','Abysmal Knight Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddClass,Class_Boss,25;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4141,'Evil_Druid_Card','Evil Druid Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bDefEle,Ele_Undead; bonus bInt,1; bonus bDef,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4142,'Doppelganger_Card','Doppelganger Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bAspdRate,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4143,'Orc_Hero_Card','Orc Hero Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bVit,3; bonus2 bResEff,Eff_Stun,10000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4144,'Osiris_Card','Osiris Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus bRestartFullRecover;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4145,'Berzebub_Card','Berzebub Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus bCastrate,-30;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4146,'Maya_Card','Maya Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus bMagicDamageReturn,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4147,'Baphomet_Card','Baphomet Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bHit,-10; bonus bSplashRange,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4148,'Pharaoh_Card','Pharaoh Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bUseSPrate,-30;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4149,'Gargoyle_Card','Gargoyle Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus3 bAddMonsterDropItem,12028,RC_Insect,100;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4150,'Goat_Card','Goat Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'if(getrefine()<6) { bonus bDef,2; bonus bMdef,5; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (4151,'Gajomart_Card','Gajomart Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus2 bSubRace,RC_Plant,-20; bonus2 bExpAddRace,RC_Plant,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4152,'Galapago_Card','Galapago Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus2 bAddItemGroupHealRate,IG_Juice,50; bonus3 bAddMonsterDropItem,531,RC_Insect,300; bonus3 bAddMonsterDropItem,532,RC_Insect,300; bonus3 bAddMonsterDropItem,534,RC_Insect,300;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4153,'Crab_Card','Crab Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bBaseAtk,5; bonus2 bAddDamageClass,1266,30;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4154,'Rice_Cake_Boy_Card','Dumpling Child Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus2 bAddItemGroupHealRate,IG_Candy,50; bonus3 bAddMonsterDropItem,529,RC_DemiHuman,300; bonus3 bAddMonsterDropItem,530,RC_DemiHuman,100;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4155,'Goblin_Leader_Card','Goblin Leader Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddRace2,RC2_Goblin,30;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4156,'Steam_Goblin_Card','Goblin Steamrider Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bCritAtkRate,10; bonus2 bCriticalAddRace,RC_Formless,7;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4157,'Goblin_Archer_Card','Goblin Archer Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bCritAtkRate,10; bonus2 bCriticalAddRace,RC_Undead,7;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4158,'Flying_Deleter_Card','Sky Deleter Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bHPrecovRate,-100; bonus bHPGainValue,100;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4159,'Nine_Tail_Card','Nine Tail Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus bAgi,2; if(getrefine()>8) bonus bFlee,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4160,'Antique_Firelock_Card','Firelock Soldier Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus bStr,2; if(getrefine()>8) { bonus bMaxHPrate,10; bonus bMaxSPrate,10; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (4161,'Grand_Peco_Card','Grand Peco Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus3 bAutoSpellWhenHit,"PR_GLORIA",1,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4162,'Grizzly_Card','Grizzly Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus2 bAddEffWhenHit,Eff_Blind,300;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4163,'Gryphon_Card','Gryphon Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bFlee,2; bonus bCritical,7; if(BaseClass==Job_Swordman) bonus3 bAutoSpell,"KN_BOWLINGBASH",5,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4164,'Gullinbursti_Card','Gullinbursti Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus2 bSubRace,RC_Fish,-20; bonus2 bExpAddRace,RC_Fish,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4165,'Gig_Card','Gig Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bSPGainRace,RC_Insect,5;',NULL,'heal 0,-5;');
REPLACE INTO `item_db` VALUES (4166,'Nightmare_Terror_Card','Nightmare Terror Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus2 bAddEffWhenHit,Eff_Curse,300;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4167,'Neraid_Card','Nereid Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bSPGainRace,RC_Brute,5;',NULL,'heal 0,-5;');
REPLACE INTO `item_db` VALUES (4168,'Dark_Lord_Card','Dark Lord Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus3 bAutoSpellWhenHit,"WZ_METEOR",5,100;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4169,'Dark_Illusion_Card','Dark Illusion Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bMaxHPrate,-10; bonus bMaxSPrate,-10; bonus bCastrate,-10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4170,'Dark_Frame_Card','Dark Frame Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus2 bAddEffWhenHit,Eff_Stone,600;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4171,'Dark_Priest_Card','Dark Priest Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bSPVanishRate,50,10; if(BaseJob==Job_Sage) bonus bSPDrainValue,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4172,'The_Paper_Card','The Paper Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bCritAtkRate,20; bonus bSPDrainValue,-1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4173,'Demon_Pungus_Card','Demon Pungus Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus2 bAddEffWhenHit,Eff_Sleep,600;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4174,'Deviling_Card','Deviling Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus2 bSubEle,Ele_Neutral,50; bonus2 bSubEle,Ele_Water,-50; bonus2 bSubEle,Ele_Earth,-50; bonus2 bSubEle,Ele_Fire,-50; bonus2 bSubEle,Ele_Wind,-50; bonus2 bSubEle,Ele_Poison,-50; bonus2 bSubEle,Ele_Holy,-50; bonus2 bSubEle,Ele_Dark,-50; bonus2 bSubEle,Ele_Ghost,-50; bonus2 bSubEle,Ele_Undead,-50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4175,'Poison_Toad_Card','Poisonous Toad Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus3 bAutoSpell,"TF_POISON",1,20; bonus2 bAddSkillBlow,52,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4176,'Dullahan_Card','Dullahan Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bCritAtkRate,10; bonus2 bCriticalAddRace,RC_Dragon,7;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4177,'Dryad_Card','Dryad Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus3 bAddMonsterDropItem,993,RC_Plant,100; bonus2 bSubEle,Ele_Earth,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4178,'Dragon_Tail_Card','Dragon Tail Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus bAgi,1; bonus bFlee,10; bonus2 bSkillAtk,"AC_DOUBLE",5; bonus2 bSkillAtk,"AC_SHOWER",5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4179,'Dragon_Fly_Card','Dragon Fly Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus bAgi,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4180,'Driller_Card','Driller Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bSPGainRace,RC_Dragon,5;',NULL,'heal 0,-5;');
REPLACE INTO `item_db` VALUES (4181,'Disguise_Card','Disguise Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus2 bAddEffWhenHit,Eff_Silence,300+600*(readparam(bVit)>=77);',NULL,NULL);
REPLACE INTO `item_db` VALUES (4182,'Diabolic_Card','Diabolic Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bSPGainRace,RC_Demon,5;',NULL,'heal 0,-5;');
REPLACE INTO `item_db` VALUES (4183,'Vagabond_Wolf_Card','Vagabond Wolf Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus bStr,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4184,'Lava_Golem_Card','Lava Golem Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddRace2,RC2_Golem,30;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4185,'Rideword_Card','Rideword Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bInt,1; if(BaseClass==Job_Acolyte) { bonus bInt,1; bonus bMdef,1; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (4186,'Raggler_Card','Raggler Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus bStr,1; bonus bVit,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4187,'Raydric_Archer_Card','Raydric Archer Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus3 bAddMonsterDropItem,12030,RC_Demon,100;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4188,'Leib_Olmai_Card','Leib Olmai Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus2 bSubEle,Ele_Fire,10; bonus3 bAddMonsterDropItem,990,RC_Brute,100;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4189,'Wraith_Dead_Card','Wraith Dead Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus2 bAddEffWhenHit,Eff_Curse,600;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4190,'Wraith_Card','Wraith Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus3 bAddMonsterDropItem,12027,RC_Undead,100;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4191,'Loli_Ruri_Card','Loli Ruri Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus3 bAutoSpellWhenHit,"AL_HEAL",3,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4192,'Rotar_Zairo_Card','Rotar Zairo Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bCritAtkRate,10; bonus2 bCriticalAddRace,RC_Fish,7;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4193,'Lude_Card','Lude Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'if(BaseJob==Job_Novice||BaseJob==Job_SuperNovice) bonus3 bAutoSpellWhenHit,"SM_ENDURE",1,200;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4194,'Rybio_Card','Rybio Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus2 bAddEffWhenHit,Eff_Stun,300+600*(readparam(bDex)>=77);',NULL,NULL);
REPLACE INTO `item_db` VALUES (4195,'Leaf_Cat_Card','Leaf Cat Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus2 bSubEle,Ele_Water,10; bonus3 bAddMonsterDropItem,991,RC_Fish,100;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4196,'Marin_Card','Marin Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus2 bAddMonsterDropItem,909,2000; bonus2 bAddMonsterDropItem,7126,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4197,'Mastering_Card','Mastering Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus bLuk,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4198,'Maya_Puple_Card','Maya Purple Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bIntravision;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4199,'Merman_Card','Merman Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus bHPrecovRate,10; bonus bSPrecovRate,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4200,'Megalith_Card','Megalith Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'if(getrefine()<6) bonus bMdef,7;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4201,'Majoruros_Card','Majoruros Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus2 bAddEffWhenHit,Eff_Stun,600;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4202,'Civil_Servant_Card','Mao Guai Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddEle,Ele_Ghost,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4203,'Mutant_Dragon_Card','Mutant Dragonoid Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bBaseAtk,15; bonus3 bAutoSpell,"MG_FIREBALL",3+2*(getskilllv("MG_FIREBALL")==10),50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4204,'Mini_Demon_Card','Mini Demon Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus2 bSubRace,RC_Brute,-20; bonus2 bExpAddRace,RC_Brute,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4205,'Mimic_Card','Mimic Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus2 bAddMonsterDropItem,603,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4206,'Mystcase_Card','Myst Case Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus2 bAddMonsterDropItem,644,30;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4207,'Mysteltainn_Card','Mysteltainn Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus2 bSubSize,Size_Small,25; bonus bDef,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4208,'Miyabi_Ningyo_Card','Miyabi Doll Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus bMaxSPrate,10; bonus2 bSkillAtk,"MG_FROSTDIVER",5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4209,'Violy_Card','Violy Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus3 bAutoSpell,"BA_FROSTJOKER",1+4*(getskilllv("BA_FROSTJOKER")==5),20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4210,'Wander_Man_Card','Wanderer Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'if(!isequipped(4172,4257,4230,4272)) bonus3 bAutoSpell,"RG_INTIMIDATE",1,20; if(BaseClass==Job_Thief) bonus bFlee,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4211,'Vocal_Card','Vocal Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4212,'Bon_Gun_Card','Bongun Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus3 bAutoSpell,"SM_BASH",1,20; bonus2 bAddSkillBlow,"SM_BASH",5; bonus2 bAddDefMonster,1026,-100;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4213,'Brilight_Card','Brilight Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus2 bAddEffWhenHit,Eff_Silence,600;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4214,'Bloody_Murderer_Card','Bloody Murderer Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bCritAtkRate,10; bonus2 bCriticalAddRace,RC_Insect,7;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4215,'Blazzer_Card','Blazer Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus2 bAddMonsterDropItemGroup,IG_Food,600;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4216,'Sasquatch_Card','Sasquatch Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus2 bAddEffWhenHit,Eff_Freeze,600;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4217,'Live_Peach_Tree_Card','Enchanted Peach Tree Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus3 bAutoSpell,"AL_HEAL",1+9*(getskilllv("AL_HEAL")==10),20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4218,'Succubus_Card','Succubus Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bVit,-3; bonus bHPrecovRate,-20; bonus bMaxHP,1000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4219,'Sageworm_Card','Sage Worm Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus2 bAddMonsterDropItem,715,30; bonus2 bAddMonsterDropItem,716,30; bonus2 bAddMonsterDropItem,717,30;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4220,'Solider_Card','Solider Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bDef,2; bonus bMdef,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4221,'Skeleton_General_Card','Skeleton General Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus2 bSubRace,RC_Insect,-20; bonus2 bExpAddRace,RC_Insect,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4222,'Skel_Prisoner_Card','Skeleton Prisoner Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus2 bAddEffWhenHit,Eff_Sleep,300;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4223,'Stalactic_Golem_Card','Stalactic Golem Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bDef,1; bonus2 bResEff,Eff_Stun,2000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4224,'Stem_Worm_Card','Stem Worm Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus3 bAddMonsterDropItem,12032,RC_Brute,100;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4225,'Stone_Shooter_Card','Stone Shooter Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bBaseAtk,10; bonus bHit,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4226,'Sting_Card','Sting Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus bDef,2; if(getrefine()>8) bonus bMdef,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4227,'Spring_Rabbit_Card','Spring Rabbit Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus2 bAddItemGroupHealRate,IG_Meat,50; bonus3 bAddMonsterDropItem,517,RC_Brute,200; bonus3 bAddMonsterDropItem,528,RC_Brute,200;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4228,'Sleeper_Card','Sleeper Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus3 bAddMonsterDropItem,12031,RC_Fish,100;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4229,'C_Tower_Manager_Card','Tower Keeper Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bInt,1; bonus bCastrate,-5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4230,'Shinobi_Card','Shinobi Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus bAgi,1; bonus3 bAutoSpellWhenHit,"AS_CLOAKING",5,100;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4231,'Increase_Soil_Card','Mi Gao Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus2 bSubRace2,RC2_Guardian,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4232,'Wild_Ginseng_Card','Hermit Plant Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus2 bAddItemGroupHealRate,IG_Herb,50; bonus3 bAddMonsterDropItem,507,RC_Plant,300; bonus3 bAddMonsterDropItem,508,RC_Plant,200; bonus3 bAddMonsterDropItem,509,RC_Plant,100;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4233,'Baby_Leopard_Card','Baby Leopard Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bLuk,3; if(BaseClass==Job_Merchant) bonus bUnbreakableArmor;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4234,'Anolian_Card','Anolian Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus3 bAutoSpellWhenHit,"AC_CONCENTRATION",1+9*(getskilllv("AC_CONCENTRATION")==10),30;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4235,'Cookie_XMAS_Card','Christmas Cookie Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus2 bSubRace,RC_Angel,-20; bonus2 bExpAddRace,RC_Angel,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4236,'Amon_Ra_Card','Amon Ra Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus bAllStats,1; bonus3 bAutoSpellWhenHit,"PR_KYRIE",10,(30+70*(readparam(bInt)>=99));',NULL,NULL);
REPLACE INTO `item_db` VALUES (4237,'Owl_Duke_Card','Owl Duke Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus3 bAutoSpell,"PR_IMPOSITIO",3,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4238,'Owl_Baron_Card','Owl Baron Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus3 bAutoSpell,"PR_LEXAETERNA",1,30;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4239,'Iron_Fist_Card','Iron Fist Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus2 bSubRace,RC_Formless,-20; bonus2 bExpAddRace,RC_Formless,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4240,'Arclouse_Card','Arclouze Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'if(getrefine()<6) { bonus bDef,2; bonus bMdef,3; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (4241,'Archangeling_Card','Arc Angeling Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bMaxHP,300; if(readparam(bLuk)>=77) { bonus bHPrecovRate,100; bonus bSPrecovRate,100; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (4242,'Apocalips_Card','Apocalipse Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bVit,2; if(getrefine()>8) bonus bMaxHP,800;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4243,'Antonio_Card','Antonio Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus3 bAutoSpellWhenHit,"AL_TELEPORT",1,500;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4244,'Alarm_Card','Alarm Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus3 bAutoSpellWhenHit,"MG_SIGHT",1,200; bonus bMaxHP,300; bonus bVit,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4245,'Am_Mut_Card','Am Mut Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus2 bSubRace,RC_DemiHuman,-20; bonus2 bSubRace,RC_Player,-20; bonus2 bExpAddRace,RC_DemiHuman,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4246,'Assulter_Card','Assaulter Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bCritAtkRate,10; bonus2 bCriticalAddRace,RC_DemiHuman,7; bonus2 bCriticalAddRace,RC_Player,7;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4247,'Aster_Card','Aster Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bBaseAtk,5; bonus2 bAddDamageClass,1074,30;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4248,'Ancient_Mummy_Card','Ancient Mummy Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus3 bAutoSpellWhenHit,"AL_CRUCIS",5,30;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4249,'Ancient_Worm_Card','Ancient Worm Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus2 bSubRace,RC_Demon,-20; bonus2 bExpAddRace,RC_Demon,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4250,'Executioner_Card','Executioner Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus2 bSubSize,Size_Large,25; bonus bDef,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4251,'Elder_Card','Elder Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddRace2,RC2_Guardian,40;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4252,'Alligator_Card','Alligator Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus bLongAtkDef,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4253,'Alice_Card','Alice Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus2 bSubClass,Class_Boss,40; bonus2 bSubClass,Class_Normal,-40;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4254,'Tirfing_Card','Ogretooth Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus2 bSubSize,Size_Medium,25; bonus bDef,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4255,'Orc_Lady_Card','Orc Lady Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddRace2,3,30;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4256,'Orc_Archer_Card','Orc Archer Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus3 bAddMonsterDropItem,12034,RC_DemiHuman,100;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4257,'Wild_Rose_Card','Wild Rose Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus bAgi,1; if(BaseClass==Job_Thief) bonus bFlee2,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4258,'Wicked_Nymph_Card','Evil Nymph Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bInt,1; bonus bMaxSP,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4259,'Wooden_Golem_Card','Wooden Golem Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bDef,1; bonus bHPrecovRate,30;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4260,'Wootan_Shooter_Card','Wootan Shooter Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bDef,1; bonus2 bResEff,Eff_Confusion,2000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4261,'Wootan_Fighter_Card','Wootan Fighter Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bDef,1; bonus2 bResEff,Eff_Bleeding,2000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4262,'Evil_Cloud_Hermit_Card','Cloud Hermit Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus3 bAddMonsterDropItem,12029,RC_Plant,100;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4263,'Incant_Samurai_Card','Samurai Spector Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bIgnoreDefClass,Class_Normal; bonus bHPrecovRate,-100; bonus2 bHPLossRate,666,10000;',NULL,'if((Hp <= 999) && !getmapflag(strcharinfo(3),mf_pvp) && !getmapflag(strcharinfo(3),mf_pvp_noparty) && !getmapflag(strcharinfo(3),mf_pvp_noguild)) { heal (1-Hp),0; } else { heal -999,0; }');
REPLACE INTO `item_db` VALUES (4264,'Wind_Ghost_Card','Wind Ghost Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus3 bAutoSpell,"WZ_JUPITEL",3+7*(getskilllv("WZ_JUPITEL")==10),20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4265,'Li_Me_Mang_Ryang_Card','Jing Guai Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus3 bAddMonsterDropItem,12033,RC_Angel,100;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4266,'Eclipse_Card','Eclipse Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus bVit,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4267,'Explosion_Card','Explosion Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus2 bSubRace,RC_Dragon,-20; bonus2 bExpAddRace,RC_Dragon,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4268,'Injustice_Card','Injustice Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus3 bAutoSpell,"AS_SONICBLOW",1,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4269,'Incubus_Card','Incubus Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bInt,-3; bonus bSPrecovRate,-20; bonus bMaxSP,150;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4270,'Giant_Spider_Card','Giant Spider Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus2 bAddEffWhenHit,Eff_Poison,600;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4271,'Giant_Honet_Card','Giant Hornet Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus2 bSubEle,Ele_Wind,10; bonus3 bAddMonsterDropItem,992,RC_Insect,100;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4272,'Dancing_Dragon_Card','Zhu Po Long Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus bAgi,1; bonus bCritical,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4273,'Shellfish_Card','Shell Fish Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bBaseAtk,5; bonus2 bAddDamageClass,1073,30;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4274,'Zombie_Master_Card','Zombie Master Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bSPGainRace,RC_Undead,5;',NULL,'heal 0,-5;');
REPLACE INTO `item_db` VALUES (4275,'Zombie_Prisoner_Card','Zombie Prisoner Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus2 bSubRace,RC_Undead,-20; bonus2 bExpAddRace,RC_Undead,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4276,'Lord_Of_Death_Card','Lord of The Dead Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus3 bAddEff,Eff_Stun,500,ATF_SHORT; bonus3 bAddEff,Eff_Curse,500,ATF_SHORT; bonus3 bAddEff,Eff_Silence,500,ATF_SHORT; bonus3 bAddEff,Eff_Poison,500,ATF_SHORT; bonus3 bAddEff,Eff_Bleeding,500,ATF_SHORT; bonus2 bComaClass,Class_Normal,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4277,'Zherlthsh_Card','Zealotus Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus bLuk,2; bonus2 bSkillAtk,"BA_MUSICALSTRIKE",10; bonus2 bSkillAtk,"DC_THROWARROW",10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4278,'Gibbet_Card','Gibbet Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'if(getrefine()<6) bonus bMdef,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4279,'Deleter_Card','Earth Deleter Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bSPrecovRate,-100; bonus bSPGainValue,10;',NULL,'heal 0,-100;');
REPLACE INTO `item_db` VALUES (4280,'Geographer_Card','Geographer Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus3 bAutoSpellWhenHit,"AL_BLESSING",2+8*(getskilllv("AL_BLESSING")==10),30;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4281,'Zipper_Bear_Card','Zipper Bear Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bBaseAtk,30; bonus bSPDrainValue,-1; if(BaseClass==Job_Merchant) bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4282,'Tengu_Card','Tengu Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus2 bAddMonsterDropItemGroup,IG_Recovery,600;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4283,'Greatest_General_Card','Greatest General Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus3 bAutoSpell,"MO_CALLSPIRITS",5,2+18*(BaseClass==Job_Acolyte);',NULL,NULL);
REPLACE INTO `item_db` VALUES (4284,'Chepet_Card','Chepet Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus4 bAutoSpell,"AL_HEAL",5,50,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4285,'Choco_Card','Choco Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus bFlee2,5; bonus bFlee,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4286,'Karakasa_Card','Karakasa Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus2 bAddEffWhenHit,Eff_Confusion,300+600*(readparam(bStr)>=77);',NULL,NULL);
REPLACE INTO `item_db` VALUES (4287,'Kapha_Card','Kapha Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'if(getrefine()<6) bonus bMdef,8;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4288,'Carat_Card','Carat Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bInt,2; if(getrefine()>8) bonus bMaxSP,150;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4289,'Caterpillar_Card','Caterpillar Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bSPGainRace,RC_Plant,5;',NULL,'heal 0,-5;');
REPLACE INTO `item_db` VALUES (4290,'Cat_O_Nine_Tail_Card','Cat O\' Nine Tails Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus bMdef,3; bonus bMagicDamageReturn,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4291,'Kobold_Leader_Card','Kobold Leader Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddRace2,RC2_Kobold,30;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4292,'Kobold_Archer_Card','Kobold Archer Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bCritAtkRate,10; bonus2 bCriticalAddRace,RC_Plant,7;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4293,'Cookie_Card','Cookie Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus bLuk,2; bonus2 bSkillAtk,"AL_HOLYLIGHT",10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4294,'Quve_Card','Quve Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'if(BaseJob==Job_Novice||BaseJob==Job_SuperNovice) bonus3 bAutoSpellWhenHit,"AL_INCAGI",1,100;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4295,'Kraben_Card','Kraben Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus2 bAddEffWhenHit,Eff_Blind,600;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4296,'Cramp_Card','Cramp Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus2 bGetZenyNum,500,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4297,'Cruiser_Card','Cruiser Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bCritAtkRate,10; bonus2 bCriticalAddRace,RC_Brute,7;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4298,'Cremy_Fear_Card','Creamy Fear Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus2 bAddEffWhenHit,Eff_Confusion,600;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4299,'Clock_Card','Clock Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus3 bAutoSpellWhenHit,"CR_AUTOGUARD",3+7*(getskilllv("CR_AUTOGUARD")==10),30;',NULL,'sc_end SC_AUTOGUARD;');
REPLACE INTO `item_db` VALUES (4300,'Chimera_Card','Chimera Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus2 bAddEffWhenHit,Eff_Poison,300+600*(BaseJob==Job_Assassin);',NULL,NULL);
REPLACE INTO `item_db` VALUES (4301,'Killer_Mantis_Card','Killer Mantis Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus2 bAddEffWhenHit,Eff_Bleeding,600;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4302,'Tao_Gunka_Card','Tao Gunka Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bMaxHPrate,100; bonus bDef,-50; bonus bMdef,-50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4303,'Whisper_Boss_Card','Giant Whisper Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus bFlee,10; if(readparam(bStr)>=80) bonus bBaseAtk,20; if(readparam(bVit)>=80) bonus bMaxHPrate,3; if(readparam(bLuk)>=80) bonus bCritical,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4304,'Tamruan_Card','Tamruan Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus bDef,2; bonus2 bSkillAtk,"CR_SHIELDCHARGE",10; bonus2 bSkillAtk,"CR_SHIELDBOOMERANG",10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4305,'Turtle_General_Card','Turtle General Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddClass,Class_All,20; bonus3 bAutoSpell,"SM_MAGNUM",10,30;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4306,'Toad_Card','Toad Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus bFlee2,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4307,'Kind_Of_Beetle_Card','Beetle King Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bSPGainRace,RC_Fish,5;',NULL,'heal 0,-5;');
REPLACE INTO `item_db` VALUES (4308,'Tri_Joint_Card','Tri Joint Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bSPGainRace,RC_Formless,5;',NULL,'heal 0,-5;');
REPLACE INTO `item_db` VALUES (4309,'Parasite_Card','Parasite Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus bDef,1; bonus2 bSubRace,RC_Formless,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4310,'Panzer_Goblin_Card','Panzer Goblin Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bCritAtkRate,10; bonus2 bCriticalAddRace,RC_Demon,7;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4311,'Permeter_Card','Permeter Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus2 bSubEle,Ele_Dark,15; bonus2 bSubEle,Ele_Undead,15;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4312,'Fur_Seal_Card','Seal Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bFlee,3; bonus bHit,10; if(BaseClass==Job_Acolyte) { bonus2 bCriticalAddRace,RC_Undead,9; bonus2 bCriticalAddRace,RC_Demon,9; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (4313,'Punk_Card','Punk Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus4 bAutoSpellWhenHit,"WZ_QUAGMIRE",1+4*(getskilllv("WZ_QUAGMIRE")==5),50,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4314,'Penomena_Card','Penomena Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus2 bSubRace,RC_Formless,30;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4315,'Pest_Card','Pest Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus2 bAddEffWhenHit,Eff_Stone,300+600*(readparam(bInt)>=77);',NULL,NULL);
REPLACE INTO `item_db` VALUES (4316,'Fake_Angel_Card','False Angel Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bSPGainRace,RC_Angel,5;',NULL,'heal 0,-5;');
REPLACE INTO `item_db` VALUES (4317,'Mobster_Card','Mobster Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bCritAtkRate,15; if(BaseClass==Job_Thief) bonus bCritical,4;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4318,'Knight_Windstorm_Card','Stormy Knight Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus3 bAutoSpell,"WZ_STORMGUST",2,20; bonus2 bAddEff,Eff_Freeze,2000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4319,'Freezer_Card','Freezer Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus bMaxHP,300; if(getrefine()>=9) bonus2 bSkillAtk,"SM_BASH",10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4320,'Bloody_Knight_Card','Bloody Knight Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus3 bAutoSpell,"WZ_METEOR",1,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4321,'Hylozoist_Card','Hylozoist Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus bClassChange,100;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4322,'High_Orc_Card','High Orc Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus bDef,1; bonus bShortWeaponDamageReturn,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4323,'Garm_Baby_Card','Hatii Babe Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus3 bAutoSpell,"MG_FROSTDIVER",3,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4324,'Garm_Card','Hatii Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus2 bAddEffWhenHit,Eff_Freeze,5000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4325,'Harpy_Card','Harpy Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus2 bSubEle,Ele_Neutral,15; bonus2 bSkillAtk,"MG_NAPALMBEAT",5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4326,'See_Otter_Card','Sea-Otter Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus2 bAddItemGroupHealRate,IG_Fish,50; bonus3 bAddMonsterDropItem,551,RC_Fish,300; bonus3 bAddMonsterDropItem,544,RC_Fish,300;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4327,'Blood_Butterfly_Card','Bloody Butterfly Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus bCastrate,30; bonus bNoCastCancel; bonus2 bSkillAtk,"MG_FIREWALL",5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4328,'Hyegun_Card','Yao Jun Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus bFlee,15; bonus bCritical,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4329,'Phendark_Card','Phendark Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bSPGainRace,RC_DemiHuman,5; bonus2 bSPGainRace,RC_Player,5;',NULL,'heal 0,-5;');
REPLACE INTO `item_db` VALUES (4330,'Dark_Snake_Lord_Card','Evil Snake Lord Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bInt,3; bonus2 bResEff,Eff_Blind,10000; bonus2 bResEff,Eff_Curse,10000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4331,'Heater_Card','Heater Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus bCritical,3; if(BaseClass==Job_Swordman) bonus bFlee2,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4332,'Waste_Stove_Card','Waste Stove Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bBaseAtk,5; bonus bInt,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4333,'Venomous_Card','Venomous Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus3 bAddEffWhenHit,Eff_Poison,3000,ATF_TARGET|ATF_SELF;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4334,'Noxious_Card','Noxious Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus bLongAtkDef,10; bonus2 bSubEle,Ele_Neutral,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4335,'Pitman_Card','Pitman Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bSkillAtk,"WZ_EARTHSPIKE",5; bonus2 bSkillAtk,"WZ_HEAVENDRIVE",5;',NULL,'heal 0,-50;');
REPLACE INTO `item_db` VALUES (4336,'Ungoliant_Card','Ungoliant Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bHPrecovRate,10; bonus2 bResEff,Eff_Bleeding,10000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4337,'Porcellio_Card','Porcellio Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bBaseAtk,25; bonus bDef,-5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4338,'Obsidian_Card','Obsidian Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bVit,readparam(bDex)/18;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4339,'Mineral_Card','Mineral Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bBaseAtk,-25; bonus bDef,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4340,'Teddy_Bear_Card','Teddy Bear Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus2 bSubRace,RC_Undead,30;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4341,'Metaling_Card','Metaling Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus3 bAutoSpell,"RG_STRIPWEAPON",1,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4342,'Rsx_0806_Card','RSX-0806 Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bVit,3; bonus bUnbreakableArmor; bonus bNoKnockback;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4343,'Mole_Card','Holden Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bLuk,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4344,'Anopheles_Card','Anopheles Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus3 bAddMonsterDropItem,12058,RC_Insect,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4345,'Hill_Wind_Card','Hill Wind Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bSkillAtk,"MG_THUNDERSTORM",5; bonus2 bSkillAtk,"WZ_JUPITEL",5; bonus2 bSkillAtk,"WZ_VERMILION",5;',NULL,'heal 0,-50;');
REPLACE INTO `item_db` VALUES (4346,'Ygnizem_Card','Egnigem Cenia Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bStr,readparam(bInt)/18;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4347,'Armaia_Card','Armeyer Dinze Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus3 bAddMonsterDropItem,12053,RC_Fish,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4348,'Whikebain_Card','Wickebine Tres Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus3 bAutoSpell,"RG_STRIPARMOR",1,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4349,'Erend_Card','Errende Ebecee Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus4 bAutoSpellWhenHit,"AL_PNEUMA",1,50,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4350,'Rawrel_Card','Laurell Weinder Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bSkillAtk,"WZ_FROSTNOVA",3; bonus2 bSkillAtk,"WZ_STORMGUST",3;',NULL,'heal 0,-50;');
REPLACE INTO `item_db` VALUES (4351,'Kavac_Card','Kavach Icarus Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'if(getrefine()<=4) { bonus bFlee,20; bonus bFlee2,1; } else { bonus bFlee,10; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (4352,'B_Ygnizem_Card','General Egnigem Cenia Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus bMaxHPrate,10; bonus bMaxSPrate,10; bonus2 bHPRegenRate,50,10000; bonus2 bSPRegenRate,10,10000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4353,'Removal_Card','Remover Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bMaxHP,800-40*getrefine(); bonus bHPrecovRate,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4354,'Gemini_Card','Gemini-S58 Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'if(readparam(bAgi)>=90) { bonus2 bResEff,Eff_Silence,3000; bonus2 bResEff,Eff_Stun,3000; } if(readparam(bVit)>=80) { bonus2 bResEff,Eff_Stone,5000; bonus2 bResEff,Eff_Sleep,5000; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (4355,'Gremlin_Card','Gremlin Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus3 bAddMonsterDropItem,12043,RC_Brute,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4356,'Beholder_Card','Beholder Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'skill "SA_CASTCANCEL",1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4357,'B_Seyren_Card','Lord Knight Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'skill "LK_BERSERK",1; bonus bMaxHPrate,-50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4358,'Seyren_Card','Seyren Windsor Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bStr,getrefine()-6;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4359,'B_Eremes_Card','Assassin Cross Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'skill "AS_CLOAKING",3;',NULL,'sc_end SC_CLOAKING;');
REPLACE INTO `item_db` VALUES (4360,'Eremes_Card','Eremes Guile Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bCriticalAddRace,RC_DemiHuman,10; bonus2 bCriticalAddRace,RC_Player,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4361,'B_Harword_Card','MasterSmith Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bBreakWeaponRate,1000; bonus bBreakArmorRate,700;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4362,'Harword_Card','Howard Alt-Eisen Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bAspdRate,-5; bonus bHit,30;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4363,'B_Magaleta_Card','High Priest Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus5 bAutoSpellWhenHit,"HP_ASSUMPTIO",1,50,BF_WEAPON|BF_MAGIC,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4364,'Magaleta_Card','Margaretha Sorin Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bInt,1; bonus5 bAutoSpellWhenHit,"PR_LEXDIVINA",5,150,BF_MAGIC,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4365,'B_Katrinn_Card','High Wizard Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus2 bIgnoreMdefClassRate,Class_Normal,100; bonus bCastrate,100; bonus bSPrecovRate,-100;',NULL,'heal 0,-2000;');
REPLACE INTO `item_db` VALUES (4366,'Katrinn_Card','Kathryne Keyron Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bCastrate,getrefine()*-1; if(getrefine()>=9) { bonus bMatkRate,2; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (4367,'B_Shecil_Card','Sniper Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bHPDrainRate,50,20; bonus bHPrecovRate,-10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4368,'Shecil_Card','Cecil Damon Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bAspdRate,5; bonus bHit,-30;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4369,'Venatu_Card','Venatu Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bLuk,readparam(bAgi)/18;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4370,'Dimik_Card','Dimik Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bVit,getrefine()-5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4371,'Archdam_Card','Archdam Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bBaseAtk,10; bonus bCastrate,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4372,'Bacsojin_Card','White Lady Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bHealPower,30; bonus bUseSPrate,15;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4373,'Chung_E_Card','Green Maiden Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus bLuk,getrefine()-5; bonus bCritical,getrefine();',NULL,NULL);
REPLACE INTO `item_db` VALUES (4374,'Apocalips_H_Card','Vesper Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bDex,2; bonus2 bIgnoreMdefClassRate,Class_Boss,30;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4375,'Orc_Baby_Card','Orc Baby Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'if(getrefine()>=9) { bonus2 bSubEle,Ele_Neutral,15; bonus bFlee,15; } else { bonus2 bSubEle,Ele_Neutral,10; bonus bFlee,10; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (4376,'Lady_Tanee_Card','Lady Tanee Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus bMaxHPrate,-40; bonus bMaxSPrate,50; bonus2 bAddMonsterDropItem,513,200; bonus2 bAddItemHealRate,513,100;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4377,'Green_Iguana_Card','Grove Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus3 bAddMonsterDropItem,12063,RC_Formless,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4378,'Acidus_Card','Gold Acidus Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'if(getrefine()<=4) { bonus bMaxHPrate,8; bonus bMaxSPrate,8; bonus bHPrecovRate,5; bonus bSPrecovRate,5; } else { bonus bMaxHPrate,4; bonus bMaxSPrate,4; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (4379,'Acidus__Card','Blue Acidus Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'if(getrefine()<=4) { bonus bSPrecovRate,5; bonus bMaxSP,80; } else { bonus bMaxSP,40; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (4380,'Ferus_Card','Red Ferus Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bSkillAtk,"WZ_FIREPILLAR",5; bonus2 bSkillAtk,"WZ_METEOR",5;',NULL,'heal 0,-50;');
REPLACE INTO `item_db` VALUES (4381,'Ferus__Card','Green Ferus Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus bVit,1; bonus bMaxHPrate,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4382,'Novus__Card','Yellow Novus Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bMaxHP,500; bonus bHPrecovRate,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4383,'Novus_Card','Red Novus Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus3 bAddEffWhenHit,Eff_Confusion,3000,ATF_TARGET|ATF_SELF;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4384,'Hydro_Card','Hydrolancer Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus3 bAutoSpell,"SA_SPELLBREAKER",1,100;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4385,'Dragon_Egg_Card','Dragon Egg Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus3 bAddMonsterDropItem,12048,RC_Dragon,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4386,'Detale_Card','Detardeurus Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bMdef,-20; bonus2 bResEff,Eff_Freeze,10000; bonus5 bAutoSpellWhenHit,"SA_LANDPROTECTOR",1,70,BF_MAGIC,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4387,'Ancient_Mimic_Card','Ancient Mimic Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bAgi,readparam(bLuk)/18;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4388,'Deathword_Card','Death Word Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bSkillAtk,"MG_NAPALMBEAT",5; bonus2 bSkillAtk,"MG_SOULSTRIKE",5; bonus2 bSkillAtk,"HW_NAPALMVULCAN",5;',NULL,'heal 0,-50;');
REPLACE INTO `item_db` VALUES (4389,'Plasma_Card','Plasma Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus2 bAddMonsterDropItem,12118,50; bonus2 bAddMonsterDropItem,12119,50; bonus2 bAddMonsterDropItem,12120,50; bonus2 bAddMonsterDropItem,12121,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4390,'Breeze_Card','Breeze Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bBaseAtk,5; bonus2 bAddEff,Eff_Bleeding,500;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4391,'Retribution_Card','Baroness of Retribution Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus3 bAddMonsterDropItem,12068,RC_Angel,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4392,'Observation_Card','Dame of Sentinel Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bDex,readparam(bVit)/18;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4393,'Shelter_Card','Mistress of Shelter Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bInt,readparam(bStr)/18;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4394,'Solace_Card','Lady Solace Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'if(BaseJob==Job_Priest) bonus3 bAutoSpell,"CR_GRANDCROSS",5,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4395,'Tha_Maero_Card','Maero of Thanatos Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bBaseAtk,5; bonus3 bAutoSpell,"AL_DECAGI",3,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4396,'Tha_Odium_Card','Odium of Thanatos Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus bAgi,getrefine()-5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4397,'Tha_Despero_Card','Despero of Thanatos Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus bInt,getrefine()-6;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4398,'Tha_Dolor_Card','Dolor of Thanatos Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bMagicAddRace,RC_Angel,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4399,'Thanatos_Card','Memory of Thanatos Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bDefRatioAtkClass,Class_All; bonus bSPDrainValue,-1; bonus bDef,-30; bonus bFlee,-30;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4400,'Aliza_Card','Aliza Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus3 bAutoSpellWhenHit,"DC_WINKCHARM",1,50+50*(BaseJob==Job_Dancer);',NULL,NULL);
REPLACE INTO `item_db` VALUES (4401,'Alicel_Card','Alicel Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bFlee,10; bonus bDef,-5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4402,'Aliot_Card','Aliot Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'if(BaseClass==Job_Swordman||BaseClass==Job_Merchant||BaseClass==Job_Thief) { bonus bStr,2; bonus bMaxHPrate,5; } if(BaseClass==Job_Mage||BaseClass==Job_Archer||BaseClass==Job_Acolyte) { bonus bInt,2; bonus bMaxSPrate,5; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (4403,'Kiel_Card','Kiel-D-01 Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bDelayRate,-30;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4404,'Skogul_Card','Skogul Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus3 bAddEffWhenHit,Eff_Bleeding,3000,ATF_TARGET|ATF_SELF;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4405,'Frus_Card','Frus Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bMagicDamageReturn,getrefine()*2; if(BaseClass==Job_Mage) bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4406,'Skeggiold_Card','Skeggiold Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bMagicAddRace,RC_Demon,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4407,'Randgris_Card','Randgris Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bUnbreakableWeapon; bonus2 bAddClass,Class_All,10; bonus3 bAutoSpell,"SA_DISPELL",1,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4408,'Gloom_Under_Night_Card','Gloom Under Night Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus2 bAddEle,Ele_Holy,40; bonus2 bAddEle,Ele_Dark,40; bonus2 bAddRace,RC_Angel,40; bonus2 bAddRace,RC_Demon,40;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4409,'Agav_Card','Agav Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bMatkRate,5; bonus bDef,-10; if(BaseClass==Job_Mage) bonus bMaxSP,100;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4410,'Echio_Card','Echio Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bBaseAtk,15; if(BaseClass==Job_Swordman) bonus bMaxHP,500;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4411,'Vanberk_Card','Vanberk Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bStr,2; autobonus "{ bonus bCritical,100; }",5,5000,0,"{ specialeffect2 EF_ENHANCE; }";',NULL,NULL);
REPLACE INTO `item_db` VALUES (4412,'Isilla_Card','Isilla Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bInt,2; autobonus "{ bonus bCastrate,-50; bonus bFlee,30; }",50,5000,BF_MAGIC,"{ specialeffect2 EF_SUFFRAGIUM; }";',NULL,NULL);
REPLACE INTO `item_db` VALUES (4413,'Hodremlin_Card','Hodremlin Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus2 bSubSize,Size_All,15; autobonus2 "{ bonus bFlee2,30; }",3,10000,BF_WEAPON|BF_MAGIC,"{ specialeffect2 EF_WIND; }";',NULL,NULL);
REPLACE INTO `item_db` VALUES (4414,'Seeker_Card','Seeker Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'skill "MG_STONECURSE",1; bonus2 bResEff,Eff_Stone,3000; bonus bMdef,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4415,'Snowier_Card','Snowier Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus2 bAddMonsterDropItem,536,2000; bonus2 bAddItemHealRate,536,100;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4416,'Siroma_Card','Siroma Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus2 bSkillAtk,"MG_COLDBOLT",25; bonus2 bCastrate,"MG_COLDBOLT",-25;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4417,'Ice_Titan_Card','Ice Titan Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus bVit,2; autobonus2 "{ bonus bDef,10; }",3,10000,BF_WEAPON|BF_MAGIC,"{ specialeffect2 EF_FREEZED; }";',NULL,NULL);
REPLACE INTO `item_db` VALUES (4418,'Gazeti_Card','Gazeti Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus3 bAutoSpell,"MG_COLDBOLT",2,100;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4419,'Ktullanux_Card','Ktullanux Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus2 bAddEle,Ele_Fire,50; bonus5 bAutoSpellWhenHit,"WZ_FROSTNOVA",10,20,BF_WEAPON|BF_MAGIC,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4420,'Muscipular_Card','Muscipular Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus3 bAutoSpellWhenHit,"AL_HEAL",1,100; bonus3 bAutoSpellWhenHit,"AL_INCAGI",1,100;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4421,'Drosera_Card','Drosera Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bCriticalLong,15;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4422,'Roween_Card','Roween Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus bFlee,5; bonus bFlee2,3; bonus2 bAddEle,Ele_Water,10; bonus2 bCriticalAddRace,RC_Fish,15;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4423,'Galion_Card','Galion Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus bHit,5; bonus2 bAddEle,Ele_Water,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4424,'Stapo_Card','Stapo Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'skill "TF_PICKSTONE",1; skill "TF_THROWSTONE",1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4425,'Atroce_Card','Atroce Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bBaseAtk,25; autobonus "{ bonus bAspdRate,100; }",5,10000,0,"{ specialeffect2 EF_POTION_BERSERK; }";',NULL,NULL);
REPLACE INTO `item_db` VALUES (4426,'Byorgue_Card','Byorgue Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'if(BaseJob==Job_Rogue) { bonus bMatkRate,10; bonus2 bAddClass,Class_All,10; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (4427,'Sword_Guardian_Card','Sword Guardian Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'if(getiteminfo(getequipid(EQI_HAND_R),11)==W_1HSWORD||getiteminfo(getequipid(EQI_HAND_R),11)==W_2HSWORD) { bonus bHit,5; bonus bCritical,5; bonus2 bSkillAtk,62,25; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (4428,'Bow_Guardian_Card','Bow Guardian Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'if(getiteminfo(getequipid(EQI_HAND_R),11)==W_BOW) { bonus bHit,5; bonus bCritical,5; bonus2 bSkillAtk,47,50; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (4429,'Salamander_Card','Salamander Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus2 bSkillAtk,"WZ_FIREPILLAR",40; bonus2 bSkillAtk,"WZ_METEOR",40;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4430,'Ifrit_Card','Ifrit Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus bBaseAtk,(JobLevel/10); bonus bCritical,(JobLevel/10); bonus bHit,(JobLevel/10); bonus3 bAutoSpellWhenHit,"NPC_EARTHQUAKE",2,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4431,'Kasa_Card','Kasa Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus3 bAutoSpell,"MG_FIREBALL",5,20; bonus3 bAutoSpell,"MG_FIREBOLT",5,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4432,'Magmaring_Card','Magmaring Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus bBaseAtk,5; bonus2 bAddEle,Ele_Earth,10; bonus2 bCriticalAddRace,RC_Brute,15;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4433,'Imp_Card','Imp Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus2 bSkillAtk,"MG_FIREBOLT",25; bonus2 bCastrate,"MG_FIREBOLT",-25;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4434,'Knocker_Card','Knocker Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus2 bAddRace,RC_Formless,5; bonus3 bAddMonsterDropItem,756,RC_Formless,10; bonus3 bAddMonsterDropItem,757,RC_Formless,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4435,'Zombie_Slaughter_Card','Zombie Slaughter Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus2 bAddRace,RC_DemiHuman,1; bonus2 bAddRace,RC_Player,1; bonus2 bMagicAddRace,RC_DemiHuman,1; bonus2 bMagicAddRace,RC_Player,1; bonus bHPGainValue,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4436,'Ragged_Zombie_Card','Ragged Zombie Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus2 bCriticalAddRace,RC_DemiHuman,5; bonus2 bCriticalAddRace,RC_Player,5; bonus2 bAddRace,RC_DemiHuman,1; bonus2 bAddRace,RC_Player,1; bonus2 bMagicAddRace,RC_DemiHuman,1; bonus2 bMagicAddRace,RC_Player,1; bonus2 bAddEff2,Eff_Bleeding,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4437,'Hell_Poodle_Card','Hell Poodle Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus bHit,1; bonus2 bAddItemHealRate,517,100; bonus3 bAddEff,Eff_Bleeding,50,ATF_SHORT;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4438,'Banshee_Card','Banshee Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'if(BaseClass==Job_Mage){ bonus bMaxSP,100; bonus bMaxHP,-100; bonus2 bSkillAtk,"MG_NAPALMBEAT",20; bonus2 bSkillAtk,"MG_SOULSTRIKE",20; bonus2 bSkillAtk,"HW_NAPALMVULCAN",20; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (4439,'Flame_Skull_Card','Flame Skull Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus2 bResEff,Eff_Blind,3000; bonus2 bResEff,Eff_Stun,3000; bonus2 bResEff,Eff_Curse,3000; bonus2 bResEff,Eff_Stone,3000; bonus2 bAddEffWhenHit,Eff_Blind,500; bonus2 bAddEffWhenHit,Eff_Stun,500; bonus2 bAddEffWhenHit,Eff_Curse,500; bonus2 bAddEffWhenHit,Eff_Stone,500;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4440,'Necromancer_Card','Necromancer Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'if(getiteminfo(getequipid(EQI_HAND_R),11)==W_STAFF) { bonus bInt,1; bonus2 bIgnoreMdefClassRate,Class_Normal,2; bonus2 bIgnoreMdefClassRate,Class_Boss,2; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (4441,'Fallen_Bishop_Card','Fallen Bishop Hibram Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus bMatkRate,10; bonus bMaxSPrate,-50; bonus2 bMagicAddRace,RC_Angel,50; bonus2 bMagicAddRace,RC_DemiHuman,50; bonus2 bMagicAddRace,RC_Player,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4442,'Tatacho_Card','Tatacho Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus2 bSubEle,Ele_Neutral,20; bonus2 bAddEle,Ele_Neutral,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4443,'Aqua_Elemental_Card','Aqua Elemental Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus2 bSubEle,Ele_Water,20; bonus2 bAddEle,Ele_Water,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4444,'Draco_Card','Draco Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus2 bSubEle,Ele_Earth,20; bonus2 bAddEle,Ele_Earth,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4445,'Luciola_Vespa_Card','Luciola Vespa Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus2 bSubEle,Ele_Wind,20; bonus2 bAddEle,Ele_Wind,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4447,'Centipede_Card','Centipede Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus2 bSubEle,Ele_Poison,20; bonus2 bAddEle,Ele_Poison,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4448,'Cornus_Card','Cornus Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus2 bSubEle,Ele_Holy,20; bonus2 bAddEle,Ele_Holy,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4449,'Dark_Shadow_Card','Dark Shadow Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus2 bSubEle,Ele_Dark,20; bonus2 bAddEle,Ele_Dark,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4450,'Banshee_Master_Card','Banshee Master Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bInt,1; bonus bMatk,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4451,'Ant_Buyanne_Card','Entweihen Crothen Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bMatk,100;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4452,'Centipede_Larva_Card','Centipede Larva Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bInt,1; bonus bMatk,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4453,'Hilsrion_Card','Hillsrion Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bBaseAtk,25;',NULL,NULL);
# Armor Enchant System
#===================================================================
REPLACE INTO `item_db` VALUES (4700,'Strength1','STR+1',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bStr,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4701,'Strength2','STR+2',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bStr,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4702,'Strength3','STR+3',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bStr,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4703,'Strength4','STR+4',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bStr,4;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4704,'Strength5','STR+5',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bStr,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4705,'Strength6','STR+6',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bStr,6;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4706,'Strength7','STR+7',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bStr,7;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4707,'Strength8','STR+8',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bStr,8;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4708,'Strength9','STR+9',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bStr,9;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4709,'Strength10','STR+10',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bStr,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4710,'Inteligence1','INT+1',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bInt,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4711,'Inteligence2','INT+2',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bInt,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4712,'Inteligence3','INT+3',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bInt,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4713,'Inteligence4','INT+4',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bInt,4;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4714,'Inteligence5','INT+5',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bInt,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4715,'Inteligence6','INT+6',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bInt,6;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4716,'Inteligence7','INT+7',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bInt,7;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4717,'Inteligence8','INT+8',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bInt,8;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4718,'Inteligence9','INT+9',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bInt,9;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4719,'Inteligence10','INT+10',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bInt,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4720,'Dexterity1','DEX+1',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4721,'Dexterity2','DEX+2',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bDex,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4722,'Dexterity3','DEX+3',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bDex,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4723,'Dexterity4','DEX+4',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bDex,4;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4724,'Dexterity5','DEX+5',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bDex,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4725,'Dexterity6','DEX+6',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bDex,6;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4726,'Dexterity7','DEX+7',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bDex,7;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4727,'Dexterity8','DEX+8',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bDex,8;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4728,'Dexterity9','DEX+9',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bDex,9;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4729,'Dexterity10','DEX+10',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bDex,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4730,'Agility1','AGI+1',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bAgi,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4731,'Agility2','AGI+2',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bAgi,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4732,'Agility3','AGI+3',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bAgi,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4733,'Agility4','AGI+4',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bAgi,4;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4734,'Agility5','AGI+5',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bAgi,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4735,'Agility6','AGI+6',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bAgi,6;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4736,'Agility7','AGI+7',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bAgi,7;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4737,'Agility8','AGI+8',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bAgi,8;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4738,'Agility9','AGI+9',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bAgi,9;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4739,'Agility10','AGI+10',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bAgi,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4740,'Vitality1','VIT+1',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bVit,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4741,'Vitality2','VIT+2',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bVit,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4742,'Vitality3','VIT+3',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bVit,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4743,'Vitality4','VIT+4',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bVit,4;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4744,'Vitality5','VIT+5',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bVit,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4745,'Vitality6','VIT+6',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bVit,6;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4746,'Vitality7','VIT+7',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bVit,7;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4747,'Vitality8','VIT+8',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bVit,8;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4748,'Vitality9','VIT+9',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bVit,9;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4749,'Vitality10','VIT+10',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bVit,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4750,'Luck1','LUK+1',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bLuk,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4751,'Luck2','LUK+2',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bLuk,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4752,'Luck3','LUK+3',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bLuk,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4753,'Luck4','LUK+4',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bLuk,4;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4754,'Luck5','LUK+5',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bLuk,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4755,'Luck6','LUK+6',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bLuk,6;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4756,'Luck7','LUK+7',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bLuk,7;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4757,'Luck8','LUK+8',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bLuk,8;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4758,'Luck9','LUK+9',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bLuk,9;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4759,'Luck10','LUK+10',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bLuk,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4760,'Matk1','MATK+1%',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bMatkRate,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4761,'Matk2','MATK+2%',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bMatkRate,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4762,'Evasion6','FLEE+6',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bFlee,6;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4763,'Evasion12','FLEE+12',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bFlee,12;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4764,'Critical5','CRI+5',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bCritical,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4765,'Critical7','CRI+7',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bCritical,7;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4766,'Atk2','ATK+2%',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus2 bAddClass,Class_All,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4767,'Atk3','ATK+3%',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus2 bAddClass,Class_All,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (4768,'Str1_J','STR+1',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (4769,'Str2_J','STR+2',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (4770,'Str3_J','STR+3',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (4771,'Int1_J','INT+1',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (4772,'Int2_J','INT+2',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (4773,'Int3_J','INT+3',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (4774,'Vit1_J','VIT+1',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (4775,'Vit2_J','VIT+2',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (4776,'Vit3_J','VIT+3',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (4777,'Agi1_J','AGI+1',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (4778,'Agi2_J','AGI+2',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (4779,'Agi3_J','AGI+3',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (4780,'Dex1_J','DEX+1',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (4781,'Dex2_J','DEX+2',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (4782,'Dex3_J','DEX+3',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (4783,'Luk1_J','LUK+1',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (4784,'Luk2_J','LUK+2',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (4785,'Luk3_J','LUK+3',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
# More Headgears
#===================================================================
REPLACE INTO `item_db` VALUES (5001,'Headset','Headset',4,20,NULL,200,NULL,3,NULL,0,0xFFFFFFFE,7,2,256,NULL,1,1,87,'bonus2 bResEff,Eff_Curse,1000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5002,'Gemmed_Crown','Jewel Crown',4,20,NULL,600,NULL,4,NULL,0,0x000654E2,7,2,256,NULL,60,1,88,'bonus bInt,2; bonus bLuk,1; bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5003,'Joker_Jester','Joker Jester',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFE,7,2,256,NULL,0,1,89,'bonus bLuk,2; bonus bMdef,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5004,'Oxygen_Mask','Oxygen Mask',4,20,NULL,200,NULL,0,NULL,0,0xFFFFFFFE,7,2,1,NULL,0,0,90,'bonus2 bResEff,Eff_Poison,2000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5005,'Gas_Mask','Gas Mask',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFE,7,2,513,NULL,0,0,91,'bonus2 bResEff,Eff_Poison,3000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5006,'Machoman_Glasses','Machoman\'s Glasses',4,36000,NULL,100,NULL,1,NULL,0,0xFFFFFFFE,7,2,512,NULL,0,0,92,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5007,'Loard_Circlet','Grand Circlet',4,20,NULL,200,NULL,3,NULL,0,0xFFFFFFFE,7,2,256,NULL,55,1,93,'bonus bStr,1; bonus bInt,1; bonus bLuk,1; bonus bMdef,4;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5008,'Puppy_Love','Puppy Love',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFE,7,2,256,NULL,0,0,94,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5009,'Safety_Helmet','Safety Helmet',4,20,NULL,500,NULL,3,NULL,0,0xFFFFFFFE,7,2,256,NULL,0,1,95,'bonus bMdef,3; bonus bUnbreakableHelm;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5010,'Indian_Hair_Piece','Indian Fillet',4,20,NULL,100,NULL,3,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,96,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5011,'Antenna','Aerial',4,20,NULL,100,NULL,3,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,97,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5012,'Ph.D_Hat','Ph.D Hat',4,20,NULL,200,NULL,3,NULL,0,0xFFFFFFFE,7,2,256,NULL,0,1,98,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5013,'Horn_Of_Lord_Kaho','Lord Kaho\'s Horn',4,20,NULL,100,NULL,5,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,99,'bonus bMdef,10; bonus bStr,5; bonus bAgi,10; bonus bVit,10; bonus bInt,5; bonus bLuk,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5014,'Fin_Helm','Fin Helm',4,20,NULL,300,NULL,2,NULL,0,0x00004082,7,2,512,NULL,65,0,100,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5015,'Egg_Shell','Egg Shell',4,20,NULL,200,NULL,3,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,0,101,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5016,'Boy\'s_Cap','Boy\'s Cap',4,20,NULL,100,NULL,2,NULL,0,0xFFFFFFFE,7,2,256,NULL,0,1,102,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5017,'Bone_Helm','Bone Helm',4,20,NULL,800,NULL,7,NULL,0,0x000444A2,7,2,256,NULL,70,1,103,'bonus2 bSubEle,Ele_Dark,-15;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5018,'Feather_Bonnet','Feather Bonnet',4,20,NULL,300,NULL,4,NULL,0,0x00080808,7,2,256,NULL,0,1,104,'bonus bAgi,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5019,'Corsair','Corsair',4,20,NULL,500,NULL,5,NULL,0,0xFFFFFFFE,7,2,256,NULL,0,1,105,'bonus bVit,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5020,'Kafra_Band','Kafra Band',4,20,NULL,500,NULL,3,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,106,'bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5021,'Bankruptcy_Of_Heart','Grief for Greed',4,20,NULL,1200,NULL,4,NULL,0,0x00040420,7,2,256,NULL,38,1,107,'bonus bInt,1; bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5022,'Helm_Of_Sun','Hat of the Sun God',4,20,NULL,2400,NULL,4,NULL,0,0x00CFDF80,7,2,768,NULL,0,1,138,'bonus bStr,3; bonus bInt,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5023,'Hat_Of_Bundle','Parcel Hat',4,20,NULL,1000,NULL,0,NULL,0,0x00040420,7,2,256,NULL,0,1,108,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5024,'Hat_Of_Cake','Cake Hat',4,20,NULL,1000,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,109,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5025,'Helm_Of_Angel','Helm of Angel',4,20,NULL,1600,NULL,5,NULL,0,0x00CFDF80,7,2,256,NULL,74,1,110,'bonus bAgi,1; bonus bLuk,1; bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5026,'Hat_Of_Cook','Chef Hat',4,20,NULL,300,NULL,1,NULL,0,0xFFFFFFFE,7,2,256,NULL,50,1,111,'bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5027,'Wizardry_Hat','Mage Hat',4,20,NULL,300,NULL,1,NULL,0,0x00810204,7,2,256,NULL,0,1,112,'bonus bInt,2; bonus bMaxSP,150;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5028,'Candle','Candle',4,20,NULL,150,NULL,0,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,113,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5029,'Spore_Hat','Spore Hat',4,20,NULL,900,NULL,3,NULL,0,0xFFFFFFFE,7,2,256,NULL,20,1,114,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5030,'Panda_Cap','Panda Hat',4,20,NULL,800,NULL,3,NULL,0,0xFFFFFFFE,7,2,256,NULL,40,1,115,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5031,'Mine_Helm','Mine Hat',4,20,NULL,1500,NULL,4,NULL,0,0x0006D5F2,7,2,256,NULL,55,1,116,'bonus bDex,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5032,'Picnic_Hat','Sunday Hat',4,20,NULL,800,NULL,1,NULL,0,0xFFFFFFFE,7,2,256,NULL,0,1,117,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5033,'Smokie_Hat','Raccoon Hat',4,20,NULL,900,NULL,3,NULL,0,0xFFFFFFFE,7,2,256,NULL,50,1,118,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5034,'Light_Bulb_Band','Bulb Band',4,20,NULL,500,NULL,0,NULL,0,0xFFFFFFFE,7,2,256,NULL,0,1,119,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5035,'Poring_Hat','Poring Hat',4,20,NULL,700,NULL,2,NULL,0,0xFFFFFFFE,7,2,256,NULL,38,1,120,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5036,'Cross_Band','Cross Hat',4,20,NULL,250,NULL,1,NULL,0,0xFFFFFFFE,7,2,256,NULL,10,1,121,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5037,'Fruit_Shell','Nut Shell',4,20,NULL,150,NULL,4,NULL,0,0xFFFFFFFF,7,2,256,NULL,5,0,122,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5038,'Deviruchi_Cap','Deviruchi Hat',4,20,NULL,800,NULL,2,NULL,0,0xFFFFFFFE,7,2,256,NULL,64,1,123,'bonus bStr,1; bonus bInt,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5039,'Mottled_Egg_Shell','Rainbow Eggshell',4,20,NULL,400,NULL,4,NULL,0,0xFFFFFFFF,7,2,256,NULL,19,0,124,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5040,'Blush','Blush',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,512,NULL,0,0,125,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5041,'Heart_Hair_Pin','Heart Hairpin',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,126,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5042,'Hair_Protector','Bao Bao',4,20,NULL,150,NULL,0,NULL,0,0xFFFFFFFE,7,2,256,NULL,14,1,127,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5043,'Opera_Ghost_Mask','Opera Phantom Mask',4,20,NULL,200,NULL,1,NULL,0,0xFFFFFFFE,7,2,512,NULL,20,0,128,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5044,'Devil\'s_Wing','Evil Wing Ears',4,20,NULL,350,NULL,2,NULL,0,0x0,7,2,256,NULL,45,1,129,'bonus bVit,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5045,'Magician_Hat','Magician Hat',4,20,NULL,500,NULL,3,NULL,0,0x00818314,7,2,256,NULL,50,1,130,'bonus bDex,1; bonus bAgi,1; bonus bMaxSP,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5046,'Bongun_Hat','Bongun Hat',4,20,NULL,300,NULL,5,NULL,0,0xFFFFFFFF,7,2,769,NULL,0,0,139,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5047,'Fashion_Sunglass','Fashionable Glasses',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFE,7,2,256,NULL,0,1,131,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5048,'First_Moon_Hair_Pin','Cresent Hairpin',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,132,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5049,'Stripe_Band','Striped Hairband',4,20,NULL,150,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,0,133,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5050,'Mystery_Fruit_Shell','Wonder Nutshell',4,20,NULL,300,NULL,5,NULL,0,0xFFFFFFFF,7,2,256,NULL,30,0,134,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5051,'Kitty_Bell','Pussy Cat Bell',4,20,NULL,100,NULL,0,NULL,0,0x0,7,2,1,NULL,0,0,135,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5052,'Blue_Hair_Band','Blue Hairband',4,20,NULL,150,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,136,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5053,'Spinx_Helm','Sphinx Hat',4,20,NULL,3000,NULL,5,NULL,0,0x00004082,7,2,257,NULL,65,0,137,'bonus bStr,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5054,'Assassin_Mask','Assassin Mask',4,20,NULL,100,NULL,0,NULL,0,0x00001100,7,2,1,NULL,70,0,180,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5055,'Novice_Egg_Cap','Novice False Eggshell',4,1,NULL,1,NULL,3,NULL,0,0x00000001,7,2,256,NULL,0,0,101,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5056,'Love_Berry','Fruit of Love',4,1,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,0,140,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5057,'Ear_Of_Black_Cat','Black Cat Ears',4,16000,NULL,200,NULL,2,NULL,0,0xFFFFFFFF,7,2,256,NULL,45,1,141,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5058,'Drooping_Kitty','Drooping Cat',4,250000,NULL,500,NULL,1,NULL,0,0xFFFFFFFE,7,2,256,NULL,0,1,142,'bonus bMdef,15; bonus2 bResEff,Eff_Curse,3000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5059,'Brown_Bear_Cap','Teddybear Hat',4,20,NULL,800,NULL,3,NULL,0,0xFFFFFFFF,7,2,256,NULL,50,1,143,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5060,'Party_Hat','Party Hat',4,20,NULL,300,NULL,3,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,144,'bonus bLuk,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5061,'Flower_Hairpin','Flower Hairpin',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,145,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5062,'Straw_Hat','Straw Hat',4,20,NULL,200,NULL,3,NULL,0,0xFFFFFFFF,7,2,256,NULL,50,1,146,'bonus bAgi,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5063,'Plaster','Giant Band Aid',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFE,7,2,256,NULL,0,1,147,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5064,'Leaf_Headgear','Smokie Leaf',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,148,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5065,'Fish_On_Head','Blue Fish',4,20,NULL,500,NULL,2,NULL,0,0xFFFFFFFF,7,2,256,NULL,50,1,149,'bonus2 bAddRace,RC_Fish,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5066,'Horn_Of_Succubus','Succubus Horn',4,20,NULL,800,NULL,4,NULL,0,0xFFFFFFFE,7,2,256,NULL,70,1,150,'bonus bInt,1; bonus bMdef,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5067,'Sombrero','Sombrero',4,20,NULL,350,NULL,4,NULL,0,0xFFFFFFFE,7,2,256,NULL,0,1,151,'bonus bAgi,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5068,'Ear_Of_Devil\'s_Wing','Evil Wing Ears',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,7,2,512,NULL,70,0,152,'bonus bStr,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5069,'Mask_Of_Fox','Kitsune Mask',4,20,NULL,300,NULL,1,NULL,0,0xFFFFFFFE,7,2,256,NULL,0,1,153,'bonus bAgi,1; bonus bLuk,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5070,'Headband_Of_Power','Hot-blooded Headband',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFE,7,2,256,NULL,0,1,154,'bonus bStr,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5071,'Indian_Headband','Indian Headband',4,20,NULL,200,NULL,1,NULL,0,0xFFFFFFFE,7,2,256,NULL,0,1,155,'bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5072,'Inccubus_Horn','Incubus Horn',4,20,NULL,800,NULL,4,NULL,0,0xFFFFFFFE,7,2,256,NULL,70,1,156,'bonus bAgi,1; bonus bMdef,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5073,'Cap_Of_Concentration','Model Training Hat',4,20,NULL,700,NULL,2,NULL,0,0xFFFFFFFE,7,2,256,NULL,0,1,157,'bonus bDex,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5074,'Ear_Of_Angel\'s_Wing','Angel Wing Ears',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,7,2,512,NULL,70,0,158,'bonus bStr,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5075,'Cowboy_Hat','Cowboy Hat',4,20,NULL,500,NULL,4,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,159,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5076,'Fur_Hat','Beanie',4,20,NULL,350,NULL,2,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,160,'bonus bLuk,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5077,'Tulip_Hairpin','Tulip Hairpin',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,161,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5078,'Sea_Otter_Cap','Sea-Otter Hat',4,20,NULL,800,NULL,3,NULL,0,0xFFFFFFFF,7,2,256,NULL,50,1,162,'bonus bVit,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5079,'Crossed_Hair_Band','X Hairpin',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,163,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5080,'Headgear_Of_Queen','Crown of Ancient Queen',4,20,NULL,400,NULL,4,NULL,0,0xFFFFFFFF,7,2,256,NULL,45,1,164,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5081,'Mistress_Crown','Crown of Mistress',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFE,7,2,256,NULL,75,1,165,'bonus bMaxSP,100; bonus bInt,2; bonus bUnbreakableHelm;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5082,'Mushroom_Band','Decorative Mushroom',4,20,NULL,100,NULL,2,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,166,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5083,'Red_Tailed_Ribbon','Red Ribbon',4,20,NULL,200,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,45,1,167,'bonus bMdef,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5084,'Lazy_Raccoon','Lazy Smokie',4,20,NULL,500,NULL,1,NULL,0,0xFFFFFFFE,7,2,256,NULL,0,1,168,'bonus2 bResEff,Eff_Sleep,2000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5085,'Pair_Of_Red_Ribbon','Small Ribbons',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,7,2,512,NULL,45,0,169,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5086,'Alarm_Mask','Alarm Mask',4,20,NULL,100,NULL,2,NULL,0,0xFFFFFFFE,7,2,513,NULL,0,0,170,'bonus2 bResEff,Eff_Blind,5000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5087,'Goblin_Mask_01','Poker Face',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,7,2,513,NULL,0,0,171,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5088,'Goblin_Mask_02','Surprised Mask',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,7,2,513,NULL,0,0,172,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5089,'Goblin_Mask_03','Annoyed Mask',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,7,2,513,NULL,0,0,173,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5090,'Goblin_Mask_04','Goblin Leader Mask',4,20,NULL,100,NULL,2,NULL,0,0xFFFFFFFF,7,2,513,NULL,0,0,174,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5091,'Big_Golden_Bell','Decorative Golden Bell',4,20,NULL,200,NULL,2,NULL,0,0xFFFFFFFE,7,2,768,NULL,35,1,175,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5092,'Blue_Coif','Coif',4,150000,NULL,300,NULL,5,NULL,0,0x00001100,7,2,768,NULL,65,1,176,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5093,'Blue_Coif_','Coif',4,150000,NULL,300,NULL,5,NULL,1,0x00001100,7,2,768,NULL,65,1,177,'bonus bMaxSP,100;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5094,'Orc_Hero_Helm','Helmet of Orc Hero',4,500000,NULL,900,NULL,5,NULL,0,0xFFFFFFFE,7,2,768,NULL,55,1,178,'bonus bStr,2; bonus bVit,1;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5095,'Orc_Hero_Helm_','Helmet of Orc Hero',4,800000,NULL,1000,NULL,5,NULL,1,0xFFFFFFFE,7,2,768,NULL,55,1,179,'bonus bStr,2; bonus bVit,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5096,'Assassin_Mask_','Assassin Mask',4,20,NULL,100,NULL,0,NULL,0,0x00001100,7,2,1,NULL,70,0,180,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5097,'Cone_Hat_','Holiday Hat',4,0,NULL,400,NULL,0,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,144,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5098,'Tiger_Mask','Tiger Mask',4,20,NULL,400,NULL,2,NULL,0,0xFFFFFFFF,7,2,768,NULL,50,0,181,'bonus bStr,3; bonus bMaxHP,100;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5099,'Cat_Hat','Neko Mimi',4,20,NULL,300,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,182,'bonus bLuk,2; bonus bMdef,10; bonus2 bSubRace,RC_Brute,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5100,'Sales_Signboard','Sales Banner',4,20,NULL,800,NULL,0,NULL,0,0xFFFFFFFF,7,2,256,NULL,75,1,183,'bonus bStr,1; bonus bAgi,1; bonus bLuk,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5101,'Takius_Blindfold','Takius\'s Blindfold',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,512,NULL,0,0,184,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5102,'Round_Eyes','Blank Eyes',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,512,NULL,0,0,185,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5103,'Sunflower_Hairpin','Sunflower Hairpin',4,20,NULL,600,NULL,1,NULL,0,0xFFFFFFFE,7,2,256,NULL,30,0,186,'bonus bAgi,2; bonus bCritical,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5104,'Dark_Blindfold','Dark Blinder',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFE,7,2,512,NULL,0,0,187,'bonus2 bResEff,Eff_Blind,10000; bonus2 bResEff,Eff_Stun,200;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5105,'Hat_Of_Cake_','2nd Anniversary Hat',4,20,NULL,1000,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,24,1,109,'bonus bDex,1; bonus bMaxSP,80; bonus3 bAddMonsterDropItem,7864,7,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5106,'Cone_Hat_INA','2nd Anniversary Hat',4,20,NULL,300,NULL,3,NULL,0,0xFFFFFFFF,7,2,256,NULL,1,0,144,'bonus bLuk,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5107,'Well_Baked_Toast','Crunch Toast',4,20,NULL,50,NULL,0,NULL,0,0xFFFFFFFF,7,2,1,NULL,0,0,188,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5108,'Detective_Hat','Renown Detective\'s Cap',4,20,NULL,350,NULL,3,NULL,1,0xFFFFFFFF,7,2,256,NULL,0,1,189,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5109,'Red_Bonnet','Red Bonnet',4,20,NULL,400,NULL,2,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,190,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5110,'Baby_Pacifier','Baby Pacifier',4,20,NULL,50,NULL,0,NULL,0,0xFFFFFFFF,7,2,1,NULL,0,0,191,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5111,'Galapago_Cap','Galapago Cap',4,20,NULL,500,NULL,2,NULL,0,0xFFFFFFFF,7,2,256,NULL,55,1,192,'bonus2 bAddMonsterDropItem,605,100;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5112,'Super_Novice_Hat','Super Novice Hat',4,8500,NULL,400,NULL,4,NULL,0,0x00000001,7,2,256,NULL,40,1,193,'bonus bAllStats,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5113,'Angry_Mouth','Angry Snarl',4,20,NULL,50,NULL,0,NULL,0,0xFFFFFFFF,7,2,1,NULL,0,0,194,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5114,'Fedora','Bucket Hat',4,6000,NULL,300,NULL,3,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,195,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5115,'Winter_Hat','Winter Hat',4,20,NULL,500,NULL,3,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,196,'bonus2 bResEff,Eff_Freeze,1000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5116,'Banana_Hat','Banana Hat',4,20,NULL,200,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,197,'bonus3 bAutoSpell,"SM_PROVOKE",3,30;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5117,'Mistic_Rose','Mystic Rose',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,198,'bonus2 bSubRace,RC_Plant,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5118,'Ear_Of_Puppy','Puppy Headband',4,20,NULL,100,NULL,2,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,199,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5119,'Super_Novice_Hat_','Super Novice Hat',4,8500,NULL,400,NULL,4,NULL,1,0x00000001,7,2,256,NULL,40,1,193,'bonus bAllStats,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5120,'Fedora_','Bucket Hat',4,6000,NULL,300,NULL,3,NULL,1,0xFFFFFFFF,7,2,256,NULL,0,1,195,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5121,'Zherlthsh_Mask','Zealotus Mask',4,20,NULL,400,NULL,3,NULL,0,0xFFFFFFFE,7,2,768,NULL,70,1,200,'bonus2 bAddRace,RC_DemiHuman,5; bonus2 bAddRace,RC_Player,5; bonus2 bSubRace,RC_DemiHuman,5; bonus2 bSubRace,RC_Player,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5122,'Magni_Cap','Magni\'s Cap',4,30000,NULL,1000,NULL,5,NULL,0,0xFFFFFFFE,7,2,256,NULL,65,1,250,'bonus bStr,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5123,'Ulle_Cap','Ulle\'s Cap',4,30000,NULL,500,NULL,3,NULL,1,0xFFFFFFFE,7,2,256,NULL,65,1,254,'bonus bDex,2; bonus bAgi,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5124,'Fricca_Circlet','Fricca\'s Circlet',4,30000,NULL,300,NULL,3,NULL,0,0xFFFFFFFE,7,2,256,NULL,65,1,251,'bonus bMdef,10; bonus bInt,2; bonus bMaxSP,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5125,'Kiss_Of_Angel','Angel\'s Kiss',4,10000,NULL,300,NULL,3,NULL,1,0x00000001,7,2,256,NULL,50,1,255,'bonus bSPrecovRate,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5126,'Morpheus\'s_Hood','Morpheus\'s Hood',4,30000,NULL,200,NULL,1,NULL,0,0xFFFFFFFE,7,2,256,NULL,33,1,256,'bonus bInt,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5127,'Morrigane\'s_Helm','Morrigane\'s Helm',4,30000,NULL,500,NULL,4,NULL,0,0xFFFFFFFE,7,2,256,NULL,61,1,257,'bonus bLuk,2; bonus bBaseAtk,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5128,'Goibne\'s_Helmet','Goibne\'s Helm',4,30000,NULL,500,NULL,5,NULL,0,0xFFFFFFFE,7,2,256,NULL,54,1,258,'bonus bVit,3; bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5129,'Bird_Nest','Bird Nest',4,20,NULL,400,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,50,0,201,'bonus bAgi,2; bonus2 bSubRace,RC_Brute,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5130,'Lion_Mask','Lion Mask',4,20,NULL,700,NULL,0,NULL,0,0x00CFDF80,7,2,768,NULL,75,1,202,'bonus2 bAddEffWhenHit,Eff_Silence,500; bonus bMdef,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5131,'Close_Helmet','Close Helmet',4,20,NULL,1200,NULL,8,NULL,0,0x00004082,7,2,769,NULL,75,1,203,'bonus bVit,3; bonus bMaxHPrate,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5132,'Angeling_Hat','Angeling Hat',4,20,NULL,700,NULL,2,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,0,204,'bonus2 bSubRace,RC_DemiHuman,10; bonus2 bSubRace,RC_Player,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5133,'Sheep_Hat','Sheep Hat',4,20,NULL,150,NULL,1,NULL,0,0x00008110,7,2,256,NULL,0,0,205,'bonus bShortWeaponDamageReturn,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5134,'Pumpkin_Hat','Pumpkin-Head',4,20,NULL,200,NULL,2,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,206,'bonus2 bSubRace,RC_Demon,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5135,'Cyclops_Visor','Cyclop\'s Eye',4,0,NULL,200,NULL,0,NULL,0,0xFFFFFFFE,7,2,512,NULL,75,0,207,'bonus bMaxSP,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5136,'Santa\'s_Hat_','Antonio\'s Santa Hat',4,20,NULL,100,NULL,3,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,20,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5137,'Alice_Doll','Alice Doll',4,20,NULL,500,NULL,0,NULL,1,0xFFFFFFFE,7,2,256,NULL,30,0,208,'bonus bStr,1; bonus2 bAddRace,RC_DemiHuman,10; bonus2 bAddRace,RC_Player,10; bonus2 bAddEff2,Eff_Sleep,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5138,'Magic_Eyes','Magic Eyes',4,20,NULL,300,NULL,1,NULL,0,0x00810204,7,2,256,NULL,30,1,209,'bonus bMdef,5; bonus bCastrate,-10; bonus bUseSPrate,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5139,'Hibiscus','Hibiscus',4,20,NULL,200,NULL,0,NULL,0,0xFFFFFFFF,7,2,256,NULL,10,0,210,'bonus bDex,1; bonus bInt,1; bonus bMdef,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5140,'Charming_Ribbon','Charming Ribbon',4,20,NULL,400,NULL,1,NULL,1,0xFFFFFFFF,7,2,256,NULL,10,1,211,'bonus2 bSubRace,RC_Undead,5; bonus2 bSubRace,RC_Demon,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5141,'Marionette_Doll','Marionette Doll',4,20,NULL,400,NULL,0,NULL,1,0xFFFFFFFE,7,2,256,NULL,30,1,212,'bonus bStr,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5142,'Crescent_Helm','Crescent Helm',4,20,NULL,3000,NULL,8,NULL,0,0x000444A2,7,2,768,NULL,50,1,213,'bonus bVit,1; bonus2 bSubRace,RC_DemiHuman,5; bonus2 bSubRace,RC_Player,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5143,'Kabuki_Mask','Kabuki Mask',4,20,NULL,1000,NULL,5,NULL,1,0xFFFFFFFE,7,1,769,NULL,30,1,214,'bonus2 bResEff,Eff_Silence,3000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5144,'Gambler_Hat','Gambler Hat',4,20,NULL,200,NULL,2,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,16,'bonus bLuk,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5145,'Carnival_Joker_Jester','Carnival Joker Jester',4,10,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,89,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5146,'Elephant_Hat','Elephant Hat',4,0,NULL,500,NULL,0,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,215,'bonus bVit,1; bonus2 bSubRace,RC_Brute,7; skill "WZ_WATERBALL",1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5147,'Baseball_Cap','Baseball Cap',4,0,NULL,200,NULL,3,NULL,1,0xFFFFFFFF,7,2,256,NULL,0,1,216,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5148,'Phrygian_Cap','Phrygian Cap',4,0,NULL,500,NULL,0,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,217,'bonus bInt,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5149,'Silver_Tiara','Silver Tiara',4,0,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,218,'bonus bInt,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5150,'Joker_Jester_','Joker Jester',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,0,219,'bonus bSpeedRate,25;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5151,'Headset_OST','Note Headphones',4,20,NULL,200,NULL,4,NULL,1,0xFFFFFFFF,7,2,768,NULL,0,1,220,'bonus bMdef,3; bonus2 bResEff,Eff_Stun,1000; bonus2 bResEff,Eff_Freeze,1000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5152,'Chinese_Crown','Chinese Crown',4,20,NULL,2000,NULL,2,NULL,0,0xFFFFFFFF,7,2,768,NULL,1,1,221,'bonus2 bResEff,Eff_Stun,1000; bonus bInt,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5153,'Angeling_Hairpin','Angeling Hairpin',4,20,NULL,700,NULL,3,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,222,'bonus bFlee,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5154,'Sunglasses_F','Father\'s Sunglasses',4,20,NULL,100,NULL,3,NULL,0,0xFFFFFFFF,7,2,512,NULL,0,0,12,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5155,'Granpa_Beard_F','Father\'s White Moustache',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,1,NULL,0,0,25,'bonus bBaseAtk,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5156,'Flu_Mask_F','Father\'s Mask',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,1,NULL,0,0,8,'bonus bMatkRate,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5157,'Viking_Helm_','Orc Helm',4,20,NULL,500,NULL,5,NULL,1,0x000654E2,7,2,256,NULL,0,1,86,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5158,'Holy_Bonnet_','Monk Hat',4,30000,NULL,100,NULL,5,NULL,1,0x00008110,7,2,256,NULL,0,1,35,'bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5159,'Golden_Gear_','Golden Gear',4,20,NULL,900,NULL,5,NULL,1,0xFFFFFFFE,7,2,256,NULL,40,1,30,'bonus bUnbreakableHelm;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5160,'Magestic_Goat_','Majestic Goat',4,20,NULL,800,NULL,5,NULL,1,0x006444A2,7,2,256,NULL,0,1,41,'bonus bStr,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5161,'Sharp_Gear_','Spiky Band',4,20,NULL,1000,NULL,6,NULL,1,0x0066D5F2,7,2,256,NULL,50,1,43,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5162,'Bone_Helm_','Bone Helm',4,20,NULL,800,NULL,7,NULL,1,0x000444A2,7,2,256,NULL,70,1,103,'bonus2 bSubEle,Ele_Dark,-15;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5163,'Corsair_','Corsair',4,20,NULL,500,NULL,5,NULL,1,0xFFFFFFFE,7,2,256,NULL,0,1,105,'bonus bVit,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5164,'Tiara_','Tiara',4,20,NULL,400,NULL,4,NULL,1,0xFFFFFFFE,7,0,256,NULL,45,1,19,'bonus bInt,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5165,'Crown_','Crown',4,20,NULL,400,NULL,4,NULL,1,0xFFFFFFFE,7,1,256,NULL,45,1,45,'bonus bInt,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5166,'Spinx_Helm_','Sphinx Hat',4,20,NULL,3000,NULL,5,NULL,1,0x00004082,7,2,257,NULL,65,0,137,'bonus bStr,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5167,'Munak_Turban_','Munak Hat',4,20,NULL,300,NULL,5,NULL,1,0xFFFFFFFF,7,2,769,NULL,0,0,51,'bonus2 bSubRace,RC_Undead,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5168,'Bongun_Hat_','Bongun Hat',4,20,NULL,300,NULL,5,NULL,1,0xFFFFFFFF,7,2,769,NULL,0,0,139,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5169,'Bride_Mask','Bride Mask',4,30000,NULL,500,NULL,4,NULL,1,0xFFFFFFFF,7,2,768,NULL,40,1,223,'if(BaseClass==Job_Taekwon){ bonus bLuk,2; bonus bCritical,5; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (5170,'Feather_Beret','Feather Beret',4,30000,NULL,600,NULL,1,NULL,0,0xFFFFFFFE,7,2,256,NULL,0,1,224,'bonus bMdef,1; bonus2 bSubRace,RC_DemiHuman,10; bonus2 bSubRace,RC_Player,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5171,'Valkyrie_Helm','Valkyrie Helm',4,100000,NULL,1000,NULL,5,NULL,1,0xFFFFFFFE,2,2,256,NULL,0,1,225,'bonus bMdef,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5172,'Beret','Beret',4,30000,NULL,700,NULL,0,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,0,226,'bonus2 bSubRace,RC_DemiHuman,10; bonus2 bSubRace,RC_Player,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5173,'Satto_Hat','Magistrate Hat',4,30000,NULL,400,NULL,3,NULL,1,0xFFFFFFFF,7,2,256,NULL,60,1,227,'if(BaseClass==Job_Taekwon){ bonus bAgi,1; bonus bHPrecovRate,3; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (5174,'Ayam','Ayam',4,30000,NULL,400,NULL,3,NULL,1,0xFFFFFFFF,7,2,256,NULL,60,1,228,'if(BaseClass==Job_Taekwon){ bonus bInt,1; bonus bSPrecovRate,3; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (5175,'Censor_Bar','Censor Bar',4,30000,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,512,NULL,0,0,229,'bonus2 bResEff,Eff_Curse,500; bonus bMdef,1; bonus bHit,-5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5176,'Hahoe_Mask','Hahoe Mask',4,30000,NULL,100,NULL,2,NULL,0,0xFFFFFFFF,7,2,513,NULL,30,0,230,'if(BaseClass==Job_Taekwon){ bonus bLuk,1; bonus bFlee2,2; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (5177,'Guardian_Lion_Mask','Mythical Lion Mask',4,30000,NULL,500,NULL,5,NULL,1,0xFFFFFFFF,7,2,768,NULL,40,1,231,'if(BaseClass==Job_Taekwon){ bonus bDex,2; bonus bBaseAtk,2*getrefine(); bonus3 bAddEff,Eff_Stun,1000,ATF_SHORT; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (5178,'Candle_','Candle',4,20,NULL,150,NULL,0,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,113,'bonus bAllStats,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5179,'Gold_Tiara','Golden Tiara',4,0,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,232,'bonus bInt,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5180,'Phrygian_Cap_','France Holiday Hat',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,217,'bonus bVit,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5181,'Helm_Of_Darkness','Helm of Darkness',4,20,NULL,2000,NULL,3,NULL,1,0x000654E2,7,2,768,NULL,50,1,233,'bonus bStr,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5182,'Puppy_Hat','Puppy Hat',4,20,NULL,500,NULL,2,NULL,0,0xFFFFFFFF,7,2,256,NULL,30,0,234,'bonus bAgi,1; bonus3 bAutoSpell,"PR_GLORIA",1,10+20*(readparam(bAgi)>=77);',NULL,NULL);
REPLACE INTO `item_db` VALUES (5183,'Bird_Nest_Hat','Bird Nest Hat',4,20,NULL,500,NULL,2,NULL,0,0xFFFFFFFF,7,2,256,NULL,10,1,235,'bonus bDex,1; bonus bAgi,1; bonus2 bResEff,Eff_Stun,1000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5184,'Captain_Hat','Captain\'s Hat',4,20,NULL,500,NULL,4,NULL,0,0xFFFFFFFE,7,2,256,NULL,30,1,236,'bonus2 bSubEle,Ele_Water,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5185,'Laurel_Wreath','Laurel Wreath',4,20,NULL,100,NULL,1,NULL,1,0xFFFFFFFF,7,2,256,NULL,10,1,237,'bonus bLuk,3; bonus2 bResEff,Eff_Blind,500; bonus2 bResEff,Eff_Curse,500;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5186,'Geographer_Band','Geographer Band',4,20,NULL,500,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,30,0,238,'bonus bInt,1; bonus3 bAutoSpellWhenHit,"AL_HEAL",1,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5187,'Twin_Ribbon','Twin Ribbon',4,20,NULL,200,NULL,0,NULL,1,0xFFFFFFFF,7,2,256,NULL,30,1,239,'bonus bMaxSP,30; bonus bMdef,3; bonus3 bAutoSpellWhenHit,"NPC_STONESKIN",6,10; bonus5 bAutoSpellWhenHit,"NPC_ANTIMAGIC",6,120,BF_MAGIC,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5188,'Minstrel_Hat','Wandering Minstrel Hat',4,20,NULL,500,NULL,2,NULL,0,0xFFFFFFFF,7,2,256,NULL,50,1,240,'bonus bInt,1; bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5189,'Fallen_Leaves','Autumn Leaves',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,241,'bonus bMaxHP,40; bonus bMaxSP,40;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5190,'Baseball_Cap_','Independence Memorial Hat',4,20,NULL,20,NULL,3,NULL,1,0xFFFFFFFF,7,2,256,NULL,0,1,216,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5191,'Ribbon_Black','Black Ribbon',4,800,NULL,100,NULL,1,NULL,1,0xFFFFFFFF,7,0,256,NULL,0,1,242,'bonus bInt,1; bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5192,'Ribbon_Yellow','Yellow Ribbon',4,800,NULL,100,NULL,1,NULL,1,0xFFFFFFFF,7,0,256,NULL,0,1,243,'bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5193,'Ribbon_Green','Green Ribbon',4,800,NULL,100,NULL,1,NULL,1,0xFFFFFFFF,7,0,256,NULL,0,1,244,'bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5194,'Ribbon_Pink','Pink Ribbon',4,800,NULL,100,NULL,1,NULL,1,0xFFFFFFFF,7,0,256,NULL,0,1,245,'bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5195,'Ribbon_Red','Red Ribbon',4,800,NULL,100,NULL,1,NULL,1,0xFFFFFFFF,7,0,256,NULL,0,1,246,'bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5196,'Ribbon_Orange','Orange Ribbon',4,800,NULL,100,NULL,1,NULL,1,0xFFFFFFFF,7,0,256,NULL,0,1,247,'bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5197,'Ribbon_White','White Ribbon',4,800,NULL,100,NULL,1,NULL,1,0xFFFFFFFF,7,0,256,NULL,0,1,248,'bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5198,'Drooping_Bunny','Drooping Bunny',4,10,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,249,'bonus bDex,1; bonus bFlee,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5199,'Baseball_Cap_I','Baseball Cap',4,0,NULL,200,NULL,3,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,216,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5200,'Coppola','Coppola',4,10,NULL,300,NULL,0,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,252,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5201,'Party_Hat_B','Party Hat',4,20,NULL,300,NULL,3,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,144,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5202,'Pumpkin_Hat_','Fantastic Pumpkin-Head',4,20,NULL,200,NULL,2,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,206,'bonus2 bSubRace,RC_Demon,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5203,'Tongue_Mask','Smiling Mask',4,20,NULL,200,NULL,2,NULL,0,0xFFFFFFFF,7,2,513,NULL,0,0,253,'bonus bSpeedRate,25;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5204,'Event_Pierrot_Nose','Rudolph\'s Nose',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,1,NULL,0,0,49,'bonus2 bResEff,Eff_Blind,3000; bonus2 bAddMonsterDropItem,12130,30;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5205,'Wreath','Emperor\'s Laurel Crown',4,20,NULL,1000,NULL,3,NULL,0,0xFFFFFFFF,7,2,768,NULL,0,1,261,'bonus bAllStats,1; bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5206,'Romantic_White_Flower','Romantic White Flower',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFE,7,2,1,NULL,0,0,259,'bonus2 bSubRace,RC_Plant,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5207,'Gold_Spirit_Chain','Angel Blessing',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,0,260,'bonus bLuk,1; bonus2 bSubEle,Ele_Holy,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5208,'Rideword_Hat','Rideword Hat',4,20,NULL,300,NULL,2,NULL,1,0xFFFFFFFE,7,2,256,NULL,40,1,262,'bonus2 bHPDrainRate,50,8; bonus2 bSPDrainRate,10,4; bonus2 bHPLossRate,10,5000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5209,'Yellow_Baseball_Cap','Love Dad Cap',4,20,NULL,300,NULL,2,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,263,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5210,'Flying_Angel','Flapping Angel Wing',4,20,NULL,300,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,10,1,264,'bonus bCastrate,-3; bonus bAspdRate,3; bonus bInt,1; bonus bAgi,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5211,'Dress_Hat','Dress Hat',4,0,NULL,200,NULL,2,NULL,1,0xFFFFFFFF,7,2,256,NULL,20,1,265,'bonus bMdef,7; bonus bStr,1; bonus bInt,1; bonus2 bAddClass,Class_All,2; bonus bMAtkRate,2; bonus bHealPower,5; if(getrefine()>=7) { bonus2 bAddClass,Class_All,1; bonus bMAtkRate,1; bonus bHealPower,1; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (5212,'Satellite_Hairband','Satellite Hairband',4,0,NULL,1000,NULL,3,NULL,1,0xFFFFFFFF,7,2,256,NULL,30,1,266,'bonus bMaxHP,50; bonus bMaxSP,10; skill "AL_RUWACH",1;',NULL,'sc_end SC_RUWACH;');
REPLACE INTO `item_db` VALUES (5213,'Black_Bunny_Band','Sheila Hairnet',4,0,NULL,200,NULL,2,NULL,0,0xFFFFFFFF,7,2,256,NULL,1,1,267,'bonus bAgi,2; bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5214,'Moonlight_Flower_Hat','Moonlight Flower Hat',4,0,NULL,200,NULL,3,NULL,0,0xFFFFFFFF,7,2,768,NULL,1,1,268,'bonus bDex,2; bonus3 bAutoSpell,"AL_INCAGI",1,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5215,'Angelic_Chain_','Evolved Angel Wing',4,20,NULL,100,NULL,2,NULL,0,0xFFFFFFFE,7,2,256,NULL,0,1,38,'bonus bMdef,3; bonus bDex,1; bonus bInt,1; bonus2 bSubRace,RC_Demon,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5216,'Satanic_Chain_','Evolved Evil Wing',4,20,NULL,100,NULL,3,NULL,0,0xFFFFFFFE,7,2,256,NULL,0,1,39,'bonus bStr,1; bonus bAgi,1; bonus bFlee,3; bonus2 bSubRace,RC_Angel,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5217,'Magestic_Goat_TW','Evolved Majestic Goat',4,20,NULL,800,NULL,5,NULL,0,0x006444A2,7,2,256,NULL,0,1,41,'bonus bStr,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5218,'Bunny_Band_','Evolved Bunny Band',4,20,NULL,100,NULL,2,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,15,'bonus bInt,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5219,'Drooping_Kitty_','Evolved Drooping Cat',4,250000,NULL,500,NULL,1,NULL,0,0xFFFFFFFE,7,2,256,NULL,0,1,142,'bonus bMdef,18; bonus bFlee,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5220,'Smoking_Pipe_','Evolved Pipe',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFE,7,2,1,NULL,0,0,55,'bonus bVit,1; bonus2 bSubRace,RC_Brute,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5221,'Pair_Of_Red_Ribbon_','Evolved Pair of Red Ribbon',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,7,0,512,NULL,45,0,169,'bonus bFlee,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5222,'Fish_On_Head_','Evolved Blue Fish',4,20,NULL,500,NULL,2,NULL,0,0xFFFFFFFF,7,2,256,NULL,50,1,149,'bonus bAgi,1; bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5223,'Big_Golden_Bell_','Evolved Big Golden Bell',4,20,NULL,200,NULL,2,NULL,0,0xFFFFFFFE,7,2,768,NULL,35,1,175,'bonus bAgi,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5224,'Orc_Hero_Helm_TW','Evolved Orc Hero Helm',4,500000,NULL,900,NULL,5,NULL,0,0xFFFFFFFE,7,2,768,NULL,55,1,178,'bonus bStr,2; bonus bVit,1; bonus bMaxHPrate,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5225,'Marcher_Hat','Parade Hat',4,20,NULL,200,NULL,2,NULL,1,0xFFFFFFFF,7,2,256,NULL,10,1,269,'bonus bMdef,2; bonus bStr,2; bonus4 bAutoSpellWhenHit,"AL_ANGELUS",5,30,0; bonus4 bAutoSpellWhenHit,"HP_ASSUMPTIO",1,1,0; bonus2 bResEff,Eff_Stun,1000; if(BaseClass==Job_Acolyte) bonus4 bAutoSpellOnSkill,"AL_HEAL","PR_LEXAETERNA",1,1000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5226,'Mini_Propeller_','Mini Propeller',4,20,NULL,200,NULL,2,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,270,'bonus bAgi,2; bonus bDex,1; bonus bFlee,10; bonus bCastrate,-getrefine();',NULL,NULL);
REPLACE INTO `item_db` VALUES (5227,'Red_Deviruchi_Cap','Red Deviruchi Hat',4,20,NULL,800,NULL,2,NULL,0,0xFFFFFFFE,7,2,256,NULL,64,1,271,'bonus bStr,1; bonus bInt,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5228,'White_Deviruchi_Cap','Gray Deviruchi Hat',4,20,NULL,800,NULL,2,NULL,0,0xFFFFFFFE,7,2,256,NULL,64,1,272,'bonus bStr,1; bonus bInt,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5229,'Gray_Deviruchi_Cap','Brown Deviruchi Hat',4,20,NULL,800,NULL,2,NULL,0,0xFFFFFFFE,7,2,256,NULL,64,1,273,'bonus bStr,1; bonus bInt,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5230,'White_Drooping_Kitty','Gray Drooping Cat',4,250000,NULL,500,NULL,1,NULL,0,0xFFFFFFFE,7,2,256,NULL,0,1,274,'bonus2 bResEff,Eff_Curse,3000; bonus bMdef,15;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5231,'Gray_Drooping_Kitty','Brown Drooping Cat',4,250000,NULL,500,NULL,1,NULL,0,0xFFFFFFFE,7,2,256,NULL,0,1,275,'bonus2 bResEff,Eff_Curse,3000; bonus bMdef,15;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5232,'Pink_Drooping_Kitty','Pink Drooping Cat',4,250000,NULL,500,NULL,1,NULL,0,0xFFFFFFFE,7,2,256,NULL,0,1,276,'bonus2 bResEff,Eff_Curse,3000; bonus bMdef,15;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5233,'Blue_Drooping_Kitty','Blue Drooping Cat',4,250000,NULL,500,NULL,1,NULL,0,0xFFFFFFFE,7,2,256,NULL,0,1,277,'bonus2 bResEff,Eff_Curse,3000; bonus bMdef,15;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5234,'Yellow_Drooping_Kitty','Yellow Drooping Cat',4,250000,NULL,500,NULL,1,NULL,0,0xFFFFFFFE,7,2,256,NULL,0,1,278,'bonus2 bResEff,Eff_Curse,3000; bonus bMdef,15;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5235,'Gray_Fur_Hat','Brown Beanie',4,20,NULL,350,NULL,2,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,279,'bonus bLuk,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5236,'Blue_Fur_Hat','Blue Beanie',4,20,NULL,350,NULL,2,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,280,'bonus bLuk,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5237,'Pink_Fur_Hat','Pink Beanie',4,20,NULL,350,NULL,2,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,281,'bonus bLuk,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5238,'Red_Wizardry_Hat','Red Mage Hat',4,20,NULL,300,NULL,1,NULL,0,0x00810204,7,2,256,NULL,0,1,282,'bonus bInt,2; bonus bMaxSP,150;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5239,'White_Wizardry_Hat','Gray Mage Hat',4,20,NULL,300,NULL,1,NULL,0,0x00810204,7,2,256,NULL,0,1,283,'bonus bInt,2; bonus bMaxSP,150;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5240,'Gray_Wizardry_Hat','Brown Mage Hat',4,20,NULL,300,NULL,1,NULL,0,0x00810204,7,2,256,NULL,0,1,284,'bonus bInt,2; bonus bMaxSP,150;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5241,'Blue_Wizardry_Hat','Blue Mage Hat',4,20,NULL,300,NULL,1,NULL,0,0x00810204,7,2,256,NULL,0,1,285,'bonus bInt,2; bonus bMaxSP,150;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5242,'Yellow_Wizardry_Hat','Yellow Mage Hat',4,20,NULL,300,NULL,1,NULL,0,0x00810204,7,2,256,NULL,0,1,286,'bonus bInt,2; bonus bMaxSP,150;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5243,'Chullos','Shafka',4,20,NULL,800,NULL,2,NULL,1,0xFFFFFFFF,7,2,768,NULL,0,1,287,'bonus2 bResEff,Eff_Freeze,1000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5244,'Elven_Blindfold','Elven Blindfold',4,20,NULL,200,NULL,1,NULL,0,0xFFFFFFFF,7,2,512,NULL,0,0,288,'bonus2 bResEff,Eff_Blind,10000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5245,'Elven_Sunglasses','Elven Sunglasses',4,20,NULL,200,NULL,1,NULL,0,0xFFFFFFFF,7,2,512,NULL,0,0,289,'bonus2 bResEff,Eff_Blind,500;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5246,'Angelic_Helm','Angelic Helm',4,20,NULL,700,NULL,3,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,290,'bonus bAgi,1; bonus bLuk,1; bonus bMdef,3; bonus2 bSubRace,RC_Demon,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5247,'Satanic_Helm','Satanic Helm',4,20,NULL,700,NULL,4,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,291,'bonus bAgi,1; bonus bLuk,1; bonus bMdef,3; bonus2 bSubRace,RC_Demon,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5248,'Robotic_Blindfold','Robotic Blindfold',4,20,NULL,200,NULL,1,NULL,0,0xFFFFFFFF,7,2,512,NULL,0,0,292,'bonus2 bResEff,Eff_Blind,10000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5249,'Human_Blindfold','Human Blindfold',4,20,NULL,200,NULL,1,NULL,0,0xFFFFFFFF,7,2,512,NULL,0,0,293,'bonus2 bResEff,Eff_Blind,10000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5250,'Robotic_Ears','Robotic Ears',4,20,NULL,10,NULL,0,NULL,0,0xFFFFFFFF,7,2,512,NULL,0,0,294,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5251,'Round_Ears','Round Ears',4,20,NULL,10,NULL,0,NULL,0,0xFFFFFFFF,7,2,512,NULL,0,0,295,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5252,'Drooping_Nine_Tail','Drooping Ninetail',4,20,NULL,300,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,20,1,296,'bonus bAgi,1; bonus bDex,1; bonus3 bAutoSpellWhenHit,"PR_GLORIA",1,30;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5253,'Lif_Doll_Hat','Lif Doll Hat',4,20,NULL,200,NULL,1,NULL,1,0xFFFFFFFF,7,2,256,NULL,20,1,297,'bonus bInt,1; bonus bMdef,getrefine(); bonus bDef,getrefine()*-1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5254,'Deviling_Hat','Deviling Hat',4,20,NULL,500,NULL,1,NULL,1,0xFFFFFFFF,7,2,256,NULL,20,1,298,'bonus bStr,1; bonus bCritical,3; bonus2 bSubRace,RC_Angel,-20; if(getrefine()>=6){ bonus bCritical,getrefine()-5; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (5255,'Triple_Poring_Hat','Triple Poring Hat',4,20,NULL,600,NULL,3,NULL,0,0xFFFFFFFF,7,2,256,NULL,20,0,299,'bonus bLuk,3; bonus3 bAutoSpell,"BS_GREED",1,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5256,'Valkyrie_Feather_Band','Valkyrie Feather Band',4,20,NULL,100,NULL,1,NULL,1,0xFFFFFFFF,7,2,256,NULL,20,1,300,'bonus bInt,1; bonus3 bAutoSpellWhenHit,"AL_HEAL",1,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5257,'Soulless_Wing','Soul Ring',4,20,NULL,300,NULL,2,NULL,0,0xFFFFFFFE,7,2,256,NULL,20,1,301,'bonus bMdef,2; bonus3 bAutoSpellWhenHit,"HP_ASSUMPTIO",1,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5258,'Afro_Wig','Afro Wig',4,20,NULL,100,NULL,0,NULL,1,0xFFFFFFFF,7,2,768,NULL,10,1,302,'bonus3 bAutoSpellWhenHit,"NV_FIRSTAID",1,300; bonus2 bSubEle,Ele_Neutral,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5259,'Elephant_Hat_','Elephant Hat',4,20,NULL,500,NULL,3,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,215,'bonus bVit,1; bonus3 bAutoSpell,"WZ_WATERBALL",3,10; skill "AL_HOLYWATER",1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5260,'Cookie_Hat','Cookie Hat',4,20,NULL,500,NULL,2,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,217,'bonus bAgi,1; bonus bFlee2,5; bonus bCritAtkRate,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5261,'Silver_Tiara_','Silver Tiara',4,20,NULL,500,NULL,2,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,218,'bonus bInt,2; if(BaseClass==Job_Mage) bonus bMatkRate,(JobLevel/20); if(Baseclass==Job_Acolyte) bonus bUseSPrate,-(JobLevel/10); if(BaseClass==Job_Archer) bonus bMaxSP,(JobLevel*2);',NULL,NULL);
REPLACE INTO `item_db` VALUES (5262,'Gold_Tiara_','Golden Tiara',4,20,NULL,500,NULL,2,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,232,'bonus bStr,2; bonus bUnbreakableHelm; if((readparam(bDex)<56)&&(BaseClass==Job_Swordman||BaseClass==Job_Merchant||BaseClass==Job_Thief)) bonus bDex,JobLevel/7;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5263,'Ati_Atihan_Hat','Pagdayaw',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFE,7,2,769,NULL,20,1,303,'bonus2 bSubEle,Ele_Water,1; bonus2 bSubEle,Ele_Earth,1; bonus2 bSubEle,Ele_Fire,1; bonus2 bSubEle,Ele_Wind,1; bonus2 bAddEff,Eff_Curse,300;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5264,'Aussie_Flag_Hat','Australian Flag Hat',4,20,NULL,500,NULL,4,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,304,'bonus bAllStats,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5265,'Apple_Of_Archer_C','Apple of Archer',4,1,NULL,0,NULL,7,NULL,0,0xFFFFFFFE,7,2,256,NULL,1,0,72,'bonus bDex,4;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5266,'Bunny_Band_C','Bunny Band',4,1,NULL,0,NULL,9,NULL,0,0xFFFFFFFF,7,2,256,NULL,1,0,15,'bonus bMdef,5; bonus2 bSubRace,RC_DemiHuman,10; bonus2 bSubRace,RC_Player,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5267,'Sahkkat_C','Sakkat',4,1,NULL,0,NULL,10,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,0,67,'bonus bAgi,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5268,'Lord_Circlet_C','Grand Circlet',4,1,NULL,0,NULL,10,NULL,0,0xFFFFFFFE,7,2,256,NULL,1,0,93,'bonus bStr,3; bonus bInt,3; bonus bLuk,3; bonus bMdef,4;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5269,'Flying_Angel_','Flapping Angel Wing',4,20,NULL,300,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,10,1,264,'bonus bInt,1; bonus bAgi,1; bonus bAspdRate,3; bonus bSpeedRate,25;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5270,'Fallen_Leaves_','Autumn Leaves',4,20,NULL,100,NULL,1,NULL,1,0xFFFFFFFF,7,2,256,NULL,0,1,241,'bonus bFlee2,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5271,'Chinese_Crown_','Phoenix Crown',4,20,NULL,500,NULL,4,NULL,1,0xFFFFFFFF,7,2,768,NULL,0,1,221,'bonus bMdef,3; bonus2 bSubClass,Class_Boss,getrefine();',NULL,NULL);
REPLACE INTO `item_db` VALUES (5272,'Tongue_Mask_','Tongue Mask',4,20,NULL,100,NULL,2,NULL,0,0xFFFFFFFF,7,2,513,NULL,0,0,253,'bonus3 bAutoSpell,"SM_PROVOKE",5,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5273,'Happy_Wig','Happy Wig',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,7,2,768,NULL,0,1,305,'bonus bSpeedRate,25; bonus bDef,4; skill "TF_HIDING",1;',NULL,'sc_end SC_HIDING;');
REPLACE INTO `item_db` VALUES (5274,'Shiny_Wig','Shiny Wig',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,7,2,768,NULL,0,1,306,'bonus bSpeedRate,25; bonus bDef,4; skill "TF_HIDING",1;',NULL,'sc_end SC_HIDING;');
REPLACE INTO `item_db` VALUES (5275,'Marvelous_Wig','Marvelous Wig',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,7,2,768,NULL,0,1,307,'bonus bSpeedRate,25; bonus bDef,4; skill "TF_HIDING",1;',NULL,'sc_end SC_HIDING;');
REPLACE INTO `item_db` VALUES (5276,'Fantastic_Wig','Fantastic Wig',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,7,2,768,NULL,0,1,308,'bonus bSpeedRate,25; bonus bDef,4; skill "TF_HIDING",1;',NULL,'sc_end SC_HIDING;');
REPLACE INTO `item_db` VALUES (5277,'Yellow_Bandana','Yellow Bandana',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFE,7,2,256,NULL,20,1,309,'bonus bLuk,2; bonus bVit,2; bonus bLongAtkDef,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5278,'Yellow_Ribbon','Yellow Ribbon',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFE,7,2,256,NULL,20,1,310,'bonus bLuk,2; bonus bVit,2; bonus bLongAtkDef,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5279,'Drooping_Kitty_C','Refined Drooping Cat',4,2,NULL,0,NULL,1,NULL,0,0xFFFFFFFE,7,2,256,NULL,0,0,142,'bonus bMdef,15; bonus2 bResEff,Eff_Curse,3000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5280,'Magestic_Goat_C','Baphomet Horns',4,2,NULL,0,NULL,5,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,0,41,'bonus bStr,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5281,'Deviruchi_Cap_C','Refined Deviruchi Hat',4,2,NULL,0,NULL,2,NULL,0,0xFFFFFFFE,7,2,256,NULL,0,0,123,'bonus bStr,1; bonus bInt,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5282,'euRO_Baseball_Cap','Europe Baseball Cap',4,0,NULL,200,NULL,3,NULL,1,0xFFFFFFFF,7,2,256,NULL,0,1,216,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5283,'Chick_Hat','Chick Hat',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,10,0,311,'bonus bLuk,2; bonus bMaxHP,50; bonus bMaxSP,50; skill "TF_DOUBLE",2; bonus bDoubleRate,10; bonus2 bSubRace,RC_DemiHuman,3; bonus2 bSubRace,RC_Player,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5284,'Water_Lily_Crown','Water Lily Crown',4,20,NULL,200,NULL,0,NULL,1,0xFFFFFFFF,7,2,256,NULL,30,0,312,'bonus bDex,1; bonus bAgi,1; bonus bHPrecovRate,5; bonus bSPrecovRate,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5285,'Vane_Hairpin','Vane Hairpin',4,20,NULL,300,NULL,3,NULL,1,0xFFFFFFFF,7,2,256,NULL,30,0,313,'bonus bAgi,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5286,'Pecopeco_Hairband','Pecopeco Hairband',4,20,NULL,0,NULL,3,NULL,0,0xFFFFFFFF,7,2,256,NULL,70,0,314,'bonus bSpeedRate,25; bonus bAspdRate,-10; bonus bCastrate,25;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5287,'Vacation_Hat','Vacation Hat',4,20,NULL,200,NULL,1,NULL,1,0xFFFFFFFF,7,2,256,NULL,30,0,315,'bonus bVit,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5288,'Red_Glasses','Red Glasses',4,20,NULL,0,NULL,1,NULL,0,0xFFFFFFFF,7,2,512,NULL,0,0,316,'bonus bInt,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5289,'Vanilmirth_Hat','Vanilmirth Hat',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,256,NULL,30,0,317,'bonus bUnbreakableHelm; bonus3 bAutoSpell,"MG_FIREBOLT",1,10; bonus3 bAutoSpell,"MG_COLDBOLT",1,10; bonus3 bAutoSpell,"MG_LIGHTNINGBOLT",1,10; bonus bMdef,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5290,'Drooping_Bunny_','Drooping Bunny',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,249,'bonus bDex,1; bonus bFlee,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5291,'Kettle_Hat','Kettle Hat',4,20,NULL,600,NULL,4,NULL,0,0xFFFFFFFF,7,2,256,NULL,30,1,318,'bonus4 bAutoSpell,"SA_DELUGE",2,10,0; bonus3 bAutoSpell,"WZ_WATERBALL",3,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5292,'Dragon_Skull','Dragon Skull',4,20,NULL,800,NULL,5,NULL,0,0xFFFFFFFF,7,2,256,NULL,50,1,319,'bonus2 bSubRace,RC_Dragon,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5293,'Ramen_Hat','Ramen Hat',4,20,NULL,0,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,0,320,'bonus bDex,4; bonus4 bAutoSpellWhenHit,"AL_DECAGI",1,30,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5294,'Whisper_Mask','Whisper Mask',4,20,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,7,2,769,NULL,0,0,321,'bonus bAgi,3; bonus2 bSubEle,Ele_Ghost,-10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5295,'Golden_Bandana','Golden Bandana',4,20,NULL,2400,NULL,4,NULL,0,0xFFFFFFFF,7,2,768,NULL,0,0,138,'bonus bMdef,4;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5296,'Drooping_Nine_Tail_','Drooping Nine Tail',4,20,NULL,300,NULL,1,NULL,1,0xFFFFFFFF,7,2,256,NULL,0,1,296,'bonus bAgi,1; bonus bCritical,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5297,'Soulless_Wing_','Soul Wing',4,20,NULL,300,NULL,2,NULL,1,0xFFFFFFFF,7,2,256,NULL,0,1,301,'bonus bAllStats,1; bonus2 bSPRegenRate,2,10000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5298,'Marvelous_Wig_','Dokebi\'s Wig',4,20,NULL,100,NULL,1,NULL,1,0xFFFFFFFF,7,2,768,NULL,0,1,307,'bonus2 bSubEle,Ele_Neutral,5; bonus2 bSubEle,Ele_Fire,-5; bonus2 bSubEle,Ele_Water,-5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5299,'Ati_Atihan_Hat_','Pagdayaw',4,20,NULL,100,NULL,1,NULL,1,0xFFFFFFFF,7,2,769,NULL,0,0,303,'bonus3 bAutoSpell,"DC_SCREAM",1,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5300,'Bullock_Helm','Bullock Helm',4,20,NULL,800,NULL,2,NULL,0,0xFFFFFFFE,7,2,256,NULL,45,1,322,'bonus bMaxHP,100;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5301,'Russian_Ribbon','Victory Hairband',4,0,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,323,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5302,'Lotus_Flower_Hat','Flower Lily',4,0,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,30,1,324,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5303,'Flower_Coronet','Flower Crown',4,20,NULL,300,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,325,'bonus bMdef,3; bonus bMaxHP,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5304,'Cap_Of_Blindness','Cap Of Blindness',4,20,NULL,800,NULL,4,NULL,1,0xFFFFFFFF,7,2,769,NULL,50,1,326,'bonus2 bResEff,Eff_Curse,700; bonus2 bResEff,Eff_Blind,10000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5305,'Pirate_Dagger','Pirate Dagger',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,1,NULL,0,0,327,'bonus bBaseAtk,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5306,'Freyja_Crown','Freya\'s Crown',4,0,NULL,500,NULL,12,NULL,0,0xFFFFFFFE,7,2,256,NULL,0,0,328,'bonus2 bSubRace,RC_DemiHuman,5; bonus2 bSubRace,RC_Player,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5307,'Carmen_Miranda\'s_Hat','Carmen Miranda\'s Hat',4,20,NULL,400,NULL,3,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,329,'bonus bMdef,3; bonus3 bAutoSpellWhenHit,"DC_WINKCHARM",1,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5308,'Brazilian_Flag_Hat','Brazil National Flag Hat',4,20,NULL,300,NULL,3,NULL,1,0xFFFFFFFF,7,2,256,NULL,0,1,330,'bonus bSpeedAddRate,25;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5309,'Mahican','Wool Mask',4,20,NULL,200,NULL,1,NULL,0,0xFFFFFFFF,7,2,769,NULL,0,1,331,'skill "RG_GRAFFITI",1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5310,'Bulb_Hairband','Shining Electric Bulb Hairband',4,20,NULL,100,NULL,3,NULL,1,0xFFFFFFFF,7,2,256,NULL,0,1,332,'bonus2 bSubEle,Ele_Dark,10; skill "MG_SIGHT",1;',NULL,'sc_end SC_SIGHT;');
REPLACE INTO `item_db` VALUES (5311,'Large_Hibiscus','Large Hisbiscus',4,20,NULL,100,NULL,1,NULL,1,0xFFFFFFFF,7,2,256,NULL,0,1,333,'bonus bMdef,15;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5312,'Ayothaya_Hat','Ayothaya King\'s Hat',4,20,NULL,100,NULL,5,NULL,1,0x000654E2,7,2,256,NULL,0,1,334,'bonus bStr,1; bonus2 bAddRace,RC_DemiHuman,5; bonus2 bAddRace,RC_Player,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5313,'Diadem','Diadem',4,20,NULL,100,NULL,3,NULL,1,0xFFFFFFFF,7,2,768,NULL,0,1,335,'bonus bInt,1; bonus bMatkRate,3; bonus bCastrate,-3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5314,'Hockey_Mask','Hockey Mask',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,7,2,513,NULL,50,0,336,'bonus2 bAddRace,RC_DemiHuman,5; bonus2 bAddRace,RC_Player,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5315,'Observer','Observer',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,7,2,512,NULL,35,0,337,'skill "WZ_ESTIMATION",1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5316,'Umbrella_Hat','Umbrella Hat',4,20,NULL,100,NULL,2,NULL,0,0xFFFFFFFF,7,2,256,NULL,50,1,338,'bonus2 bSubEle,Ele_Water,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5317,'Fisherman_Hat','Fisherman\'s Hat',4,20,NULL,100,NULL,2,NULL,0,0xFFFFFFFF,7,2,256,NULL,50,1,339,'bonus3 bAutoSpell,"WZ_WATERBALL",3,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5318,'Poring_Party_Hat','Poring Party Hat',4,20,NULL,0,NULL,2,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,340,'bonus bAllStats,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5319,'Hellomother_Hat','Hello Mother Hat',4,20,NULL,200,NULL,2,NULL,0,0xFFFFFFFE,7,2,256,NULL,10,1,341,'bonus bLuk,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5320,'Champion_Wreath','Champion Wreath',4,20,NULL,500,NULL,4,NULL,0,0xFFFFFFFE,7,2,256,NULL,0,1,261,'bonus bAllStats,2; bonus4 bAutoSpellWhenHit,"AL_HEAL",1,50,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5321,'Indonesian_Bandana','Bandana Merah Putih',4,20,NULL,500,NULL,2,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,342,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5322,'Scarf','Kerchief',4,20,NULL,100,NULL,2,NULL,0,0xFFFFFFFF,7,2,256,NULL,24,1,343,'bonus bMdef,2; bonus bFlee,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5323,'Misstrance_Crown','Misstrance Crown',4,20,NULL,0,NULL,10,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,0,165,'bonus bAllStats,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5324,'Little_Angel_Doll','Little Angel Doll',4,20,NULL,300,NULL,2,NULL,0,0xFFFFFFFF,7,2,256,NULL,10,1,344,'bonus bDex,3; bonus4 bAutoSpellWhenHit,"CR_GRANDCROSS",3,30,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5325,'Robo_Eye','Robo Eye',4,20,NULL,200,NULL,2,NULL,0,0xFFFFFFFF,7,2,512,NULL,10,0,345,'bonus2 bAddClass,Class_All,2; bonus bMatkRate,2; bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5326,'Masquerade_C','Masquerade C',4,1,NULL,0,NULL,1,NULL,0,0xFFFFFFFF,7,2,512,NULL,0,0,78,'bonus2 bAddRace,RC_DemiHuman,7; bonus2 bAddRace,RC_Player,7;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5327,'Orc_Hero_Helm_C','Refined Helmet of Orc Hero',4,1,NULL,0,NULL,10,NULL,0,0xFFFFFFFE,7,2,768,NULL,0,0,178,'bonus bStr,5; bonus bVit,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5328,'Evil_Wing_Ears_C','Evil Wing Ears C',4,1,NULL,0,NULL,2,NULL,0,0xFFFFFFFF,7,2,512,NULL,0,0,152,'bonus bStr,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5329,'Dark_Blindfold_C','Dark Blindfold C',4,1,NULL,0,NULL,1,NULL,0,0xFFFFFFFF,7,2,512,NULL,0,0,187,'bonus2 bResEff,Eff_Blind,10000; bonus2 bResEff,Eff_Stun,500;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5330,'kRO_Drooping_Kitty_C','kRO Drooping Kitty C',4,1,NULL,0,NULL,6,NULL,0,0xFFFFFFFE,7,2,256,NULL,0,0,142,'bonus bMdef,15; bonus2 bResEff,Eff_Curse,4000; bonus2 bResEff,Eff_Curse,1000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5331,'Corsair_C','Corsair C',4,1,NULL,0,NULL,10,NULL,0,0xFFFFFFFE,7,2,256,NULL,0,0,105,'bonus bVit,3; bonus bInt,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5332,'Loki_Mask','Loki Mask',4,0,NULL,200,NULL,0,NULL,0,0xFFFFFFFF,7,2,513,NULL,20,0,346,'bonus bFlee2,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5333,'Radio_Antenna','Radio Antenna',4,0,NULL,1500,NULL,2,NULL,0,0xFFFFFFFF,7,2,256,NULL,50,1,347,'bonus bMdef,5; bonus bCritical,5; bonus bFlee,5; skill "MG_LIGHTNINGBOLT",1; bonus4 bAutoSpellWhenHit,"MG_THUNDERSTORM",5,30,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5334,'Angeling_Wanna_Fly','Flapping Angeling',4,0,NULL,700,NULL,0,NULL,0,0xFFFFFFFF,7,2,256,NULL,38,0,348,'bonus bLuk,2; bonus bMdef,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5335,'Jumping_Poring','Jumping Poring',4,0,NULL,300,NULL,2,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,0,349,'bonus bLuk,1; bonus bUnbreakableHelm;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5336,'Guildsman_Recruiter','Guildsman Recruiter Hat',4,NULL,NULL,0,NULL,2,NULL,0,0xFFFFFFFF,7,2,256,NULL,10,1,350,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5337,'Party_Recruiter_Hat','Party Recruiter Hat',4,0,NULL,0,NULL,2,NULL,0,0xFFFFFFFF,7,2,256,NULL,10,1,351,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5338,'Bf_Recruiter_Hat','Bf Recruiter Hat',4,0,NULL,0,NULL,2,NULL,0,0xFFFFFFFF,7,2,256,NULL,10,1,352,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5339,'Friend_Recruiter_Hat','Friend Recruiter Hat',4,0,NULL,0,NULL,2,NULL,0,0xFFFFFFFF,7,2,256,NULL,10,1,353,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5340,'Deprotai_Doll_Hat','Defolty Doll Hat',4,0,NULL,500,NULL,0,NULL,1,0xFFFFFFFF,7,2,256,NULL,60,0,354,'bonus2 bSubRace,RC_DemiHuman,5; bonus2 bSubRace,RC_Player,5; bonus bStr,2; bonus3 bAutoSpellWhenHit,"AL_ANGELUS",10,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5341,'Claris_Doll_Hat','Glaris Doll Hat',4,0,NULL,500,NULL,0,NULL,1,0xFFFFFFFF,7,2,256,NULL,60,0,355,'bonus2 bSubRace,RC_DemiHuman,5; bonus2 bSubRace,RC_Player,5; bonus bInt,2; bonus bMagicHPGainValue,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5342,'Sorin_Doll_Hat','Sorin Doll Hat',4,0,NULL,500,NULL,0,NULL,1,0xFFFFFFFF,7,2,256,NULL,60,0,356,'bonus2 bSubRace,RC_DemiHuman,5; bonus2 bSubRace,RC_Player,5; bonus bDex,2; autobonus "{ bonus bBaseAtk,50; }",20,10000,0,"{ specialeffect2 EF_POTION_BERSERK; }";',NULL,NULL);
REPLACE INTO `item_db` VALUES (5343,'Tayelin_Doll_Hat','Telling Doll Hat',4,0,NULL,500,NULL,0,NULL,1,0xFFFFFFFF,7,2,256,NULL,60,0,357,'bonus2 bSubRace,RC_DemiHuman,5; bonus2 bSubRace,RC_Player,5; bonus bAgi,2; bonus2 bAddItemHealRate,504,10; bonus2 bAddItemHealRate,547,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5344,'Binit_Doll_Hat','Bennit Doll Hat',4,0,NULL,500,NULL,0,NULL,1,0xFFFFFFFF,7,2,256,NULL,60,0,358,'bonus2 bSubRace,RC_DemiHuman,5; bonus2 bSubRace,RC_Player,5; bonus bVit,2; autobonus "{ bonus bAspdRate,5; }",20,30000,0,"{ specialeffect2 EF_HASTEUP; }";',NULL,NULL);
REPLACE INTO `item_db` VALUES (5345,'Debril_Doll_Hat','W Doll Hat',4,0,NULL,500,NULL,0,NULL,1,0xFFFFFFFF,7,2,256,NULL,60,0,359,'bonus2 bSubRace,RC_DemiHuman,5; bonus2 bSubRace,RC_Player,5; bonus bLuk,2; bonus2 bAddRace,RC_Undead,5; bonus2 bMagicAddRace,RC_Undead,5; bonus2 bSubRace,RC_Undead,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5346,'Gf_Recruiter_Hat','Gf Recruiter Hat',4,0,NULL,0,NULL,2,NULL,0,0xFFFFFFFF,7,2,256,NULL,10,1,360,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5347,'Ph.D_Hat_','Ph.D Hat',4,20,NULL,200,NULL,3,NULL,1,0xFFFFFFFE,7,2,256,NULL,0,1,98,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5348,'Big_Sis\'_Ribbon_','Big Ribbon',4,15000,NULL,200,NULL,2,NULL,1,0xFFFFFFFE,7,2,256,NULL,0,1,28,'bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5349,'Boy\'s_Cap_','Boy\'s Cap',4,20,NULL,100,NULL,2,NULL,1,0xFFFFFFFE,7,2,256,NULL,0,1,102,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5350,'Pirate_Bandana_','Pirate Bandana',4,20,NULL,100,NULL,3,NULL,1,0xFFFFFFFE,7,2,256,NULL,0,1,74,'bonus bStr,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5351,'Sunflower_','Sunflower',4,20,NULL,100,NULL,1,NULL,1,0xFFFFFFFF,7,2,256,NULL,0,0,37,'bonus2 bSubRace,RC_Insect,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5352,'Poporing_Cap','Poporing Cap',4,20,NULL,700,NULL,2,NULL,0,0xFFFFFFFE,7,2,256,NULL,38,1,361,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5353,'Helm_Of_Sun_','Hat of the Sun God',4,20,NULL,2400,NULL,4,NULL,1,0x00CFDF80,7,2,768,NULL,0,1,138,'bonus bStr,3; bonus bInt,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5354,'Muslim_Hat_M','Muslim Hat M',4,0,NULL,100,NULL,2,NULL,0,0xFFFFFFFF,7,1,256,NULL,0,0,362,'bonus bCastrate,-5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5355,'Muslim_Hat_F','Selendang',4,0,NULL,100,NULL,2,NULL,0,0xFFFFFFFF,7,0,256,NULL,0,0,363,'bonus bCastrate,-5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5356,'Pumpkin_Hat_H','Festival Pumpkin Hat',4,20,NULL,200,NULL,2,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,206,'bonus2 bSubRace,RC_Demon,5; bonus2 bAddRace,RC_Demon,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5357,'Wings_Of_Victory','Wings Of Victory',4,20,NULL,200,NULL,10,NULL,0,0xFFFFFFFF,7,2,768,NULL,0,0,365,'bonus bMdef,10; bonus bUnbreakableHelm;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5358,'Pecopeco_Wing_Ears','Peco Ears',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,7,2,512,NULL,70,0,366,'bonus bAgi,1; bonus bMdef,2; bonus bUnbreakableHelm;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5359,'J_Captain_Hat','Ship Captain Hat',4,20,NULL,300,NULL,3,NULL,1,0xFFFFFFFF,7,2,256,NULL,60,1,367,'bonus bDex,1; bonus bLongAtkRate,7; bonus bMaxHP,100;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5360,'Whikebain_Ears','Hyuke\'s Black Cat Ears',4,20,NULL,200,NULL,2,NULL,0,0xFFFFFFFF,7,2,256,NULL,45,1,368,'bonus bFlee,10; bonus bCritical,3; bonus bCritAtkRate,10; bonus bDefRate,-50; bonus bDef2Rate,-50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5361,'Gang_Scarf','Gangster Scarf',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,1,NULL,60,0,369,'bonus bBaseAtk,5; if(BaseJob==Job_Rogue) skill "RG_GANGSTER",1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5362,'Ninja_Scroll','Ninja Scroll',4,20,NULL,200,NULL,0,NULL,0,0xFFFFFFFF,7,2,1,NULL,60,0,370,'bonus bMatkRate,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5363,'Helm_Of_Abyss','Helm Of Abyss',4,20,NULL,1000,NULL,2,NULL,1,0x000654E2,7,2,256,NULL,70,1,371,'bonus2 bSubRace,RC_DemiHuman,-10; bonus2 bSubRace,RC_Player,-10; bonus2 bSubClass,Class_Boss,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5364,'Dark_Snake_Lord_Hat','Evil Snake Lord Hat',4,20,NULL,500,NULL,2,NULL,1,0xFFFFFFFF,7,2,256,NULL,60,1,372,'bonus bStr,1; bonus bInt,1; bonus bAgi,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5365,'Fried_Egg','Magnolia Hat',4,20,NULL,100,NULL,3,NULL,1,0xFFFFFFFF,7,2,256,NULL,1,0,373,'bonus2 bResEff,Eff_Stun,500; skill "HT_FLASHER",1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5366,'Hat_0f_King','Love Dad Bandana',4,20,NULL,200,NULL,3,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,374,'bonus bAllStats,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5367,'Hyegun_Hat','Hyegun Hat',4,20,NULL,100,NULL,5,NULL,1,0xFFFFFFFF,7,2,769,NULL,10,0,375,'bonus bMdef,3; bonus2 bSubRace,RC_Demon,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5368,'White_Wing','White Wing',4,20,NULL,100,NULL,2,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,38,'bonus2 bAddMonsterDropItem,12280,300;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5369,'Dark_Wing','Dark Wing',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,39,'bonus2 bAddMonsterDropItem,12279,300;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5370,'Orchid_Hairband','Orchid Hairband',4,20,NULL,200,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,376,'bonus bInt,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5371,'Hat_Of_Judge','Judge Hat',4,20,NULL,300,NULL,2,NULL,0,0xFFFFFFFF,7,2,768,NULL,0,1,377,'bonus bLuk,1; bonus bMaxSP,30;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5372,'Drooping_White_Kitty','Koneko Hat',4,20,NULL,500,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,378,'bonus bInt,1; bonus bDelayRate,-3; bonus bMatkRate,3; bonus bMaxSPrate,3; bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5373,'Darkness_Helm','Dark Randgris Helm',4,20,NULL,300,NULL,2,NULL,1,0xFFFFFFFF,7,2,768,NULL,0,1,379,'bonus bDex,3; bonus bMdef,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5374,'L_Magestic_Goat','Gigantic Majestic Goat',4,20,NULL,800,NULL,5,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,380,'bonus2 bAddRace,RC_DemiHuman,12; bonus2 bAddRace,RC_Player,12; bonus bBaseAtk,(JobLevel*2)/7;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5375,'L_Orc_Hero_Helm','Orc Hero Headdress',4,20,NULL,900,NULL,5,NULL,1,0xFFFFFFFF,7,2,768,NULL,0,1,381,'bonus bStr,2; bonus3 bAutoSpellWhenHit,"BS_WEAPONPERFECT",3,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5376,'Satanic_Chain_P','Flying Evil Wing',4,20,NULL,100,NULL,3,NULL,1,0xFFFFFFFF,7,2,256,NULL,0,1,382,'bonus bMaxSP,120; bonus2 bAddEff2,Eff_Curse,300;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5377,'Antique_Pipe','Gentleman\'s Pipe',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,1,NULL,0,0,383,'bonus2 bSubRace,RC_DemiHuman,2; bonus2 bSubRace,RC_Player,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5378,'Rabbit_Ear_Hat','Bunny Top Hat',4,20,NULL,300,NULL,0,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,384,'bonus bAgi,3; bonus3 bAutoSpellWhenHit,"AL_INCAGI",5,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5379,'Balloon_Hat','Tam',4,0,NULL,800,NULL,3,NULL,1,0xFFFFFFFF,7,2,256,NULL,50,1,385,'bonus bMdef,2; bonus bMatkRate,2+(getrefine()/2);',NULL,NULL);
REPLACE INTO `item_db` VALUES (5380,'Fish_Head_Hat','Fish Head Hat',4,20,NULL,400,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,386,'bonus3 bAutoSpell,"SA_FROSTWEAPON",1,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5381,'Santa_Poring_Hat','Santa Poring Hat',4,20,NULL,100,NULL,2,NULL,1,0xFFFFFFFF,7,2,256,NULL,0,0,387,'bonus bMdef,2; bonus2 bAddEle,Ele_Dark,3; bonus2 bSubEle,Ele_Dark,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5382,'Bell_Ribbon','Bell Ribbon',4,20,NULL,200,NULL,3,NULL,1,0xFFFFFFFF,7,2,256,NULL,0,1,388,'bonus bVit,1; skill "AL_ANGELUS",1;',NULL,'sc_end SC_ANGELUS;');
REPLACE INTO `item_db` VALUES (5383,'Hunting_Cap','Hunter\'s Cap',4,20,NULL,250,NULL,3,NULL,1,0xFFFFFFFE,7,2,256,NULL,50,1,389,'bonus bLuk,1; bonus2 bAddRace,RC_Brute,10; bonus2 bAddRace,RC_DemiHuman,5; bonus2 bAddRace,RC_Player,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5384,'Santa_Hat_1','Twin Pompom By JB',4,20,NULL,200,NULL,1,NULL,1,0xFFFFFFFF,7,2,256,NULL,20,1,390,'bonus bLuk,3; skill "WZ_ESTIMATION",1; bonus3 bAutoSpell,"AL_INCAGI",1,500;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5385,'Yoyo_Hat','Yoyo Hat',4,20,NULL,300,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,20,1,391,'skill "TF_HIDING", 1;',NULL,'sc_end SC_HIDING;');
REPLACE INTO `item_db` VALUES (5386,'Ayam_','Ayam',4,0,NULL,70,NULL,7,NULL,0,0xFFFFFFFF,7,2,256,NULL,1,0,228,'bonus bMdef,7; bonus bFlee,7; bonus2 bAddMonsterDropItem,12198,200;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5387,'Neko_Mimi_Kafra','Neko Mimi Kafra',4,20,NULL,200,NULL,1,NULL,1,0xFFFFFFFF,7,2,256,NULL,30,1,392,'bonus bMdef,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5388,'Snake_Head','Snake Head Hat',4,20,NULL,200,NULL,1,NULL,1,0xFFFFFFFF,7,2,256,NULL,30,1,393,'skill "TF_DOUBLE",5; bonus bDoubleRate,25;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5389,'Angel_Spirit','Angel Spirit',4,20,NULL,200,NULL,0,NULL,0,0xFFFFFFFF,7,2,512,NULL,30,0,394,'bonus bStr,2; bonus bHit,15;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5390,'Santa_Hat_2','Frozen Twin Pompom',4,20,NULL,100,NULL,2,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,395,'bonus2 bResEff, Eff_Freeze, 3000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5391,'Toast_C','Toast',4,20,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,7,2,1,NULL,0,0,188,'bonus bMaxHP,100; bonus2 bAddMonsterDropItem,617,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5392,'Louyang_Cap','Louyang NewYear Hat',4,20,NULL,300,NULL,3,NULL,1,0xFFFFFFFF,7,2,256,NULL,0,1,396,'bonus bLuk,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5393,'Valentine_Hat','Love Valentine\'s Hat',4,20,NULL,200,NULL,2,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,0,397,'bonus bMaxSPrate, 7; bonus bMaxHPrate, 7;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5394,'Bubblegum_Lower','Bubblegum',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,7,2,1,NULL,0,0,0,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5395,'Tiraya_Bonnet','Striped Hat',4,20,NULL,500,NULL,2,NULL,1,0xFFFFFFFF,7,2,256,NULL,50,1,398,'bonus bMaxHP,100+(getrefine()*20); bonus bLuk,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5396,'Jasper_Crest','Jasper Crest',4,20,NULL,700,NULL,2,NULL,1,0xFFFFFFFF,7,2,256,NULL,0,1,399,'bonus bDex,3; bonus bVit,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5397,'Scuba_Mask','Scuba Gear',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,512,NULL,0,0,400,'bonus2 bSubEle,Ele_Water, 10; bonus bUnbreakableHelm, 0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5398,'Bone_Head','Bone Head',4,20,NULL,1200,NULL,5,NULL,1,0x000444A2,2,2,256,NULL,85,1,401,'bonus bStr,2; bonus bMdef,5; bonus2 bResEff,Eff_Stun,500; bonus2 bResEff,Eff_Bleeding,500;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5399,'Mandragora_Cap','Mandragora Cap',4,20,NULL,300,NULL,1,NULL,1,0x00CFFF80,2,2,256,NULL,85,0,402,'bonus bVit,3; bonus3 bAutoSpellWhenHit,"DC_SCREAM",5,30;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5400,'Fox_Hat','Fox Hat',4,20,NULL,200,NULL,0,NULL,0,0xFFFFFFFF,7,0,769,NULL,0,0,403,'bonus bLuk,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5401,'Black_Glasses','Black Frame Glasses',4,20,NULL,200,NULL,1,NULL,0,0xFFFFFFFF,7,2,512,NULL,70,0,404,'bonus bInt,1; bonus bMdef,2; bonus bUnbreakableHelm, 0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5402,'Mischievous_Fairy','Mischievous Fairy',4,10,NULL,200,NULL,1,NULL,0,0xFFFFFFFF,7,2,512,NULL,70,0,405,'bonus bUnbreakableHelm, 0; bonus bFlee2, 3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5403,'Fish_In_Mouth','Fish In Mouth',4,10,NULL,200,NULL,0,NULL,0,0xFFFFFFFF,7,2,1,NULL,30,0,406,'bonus2 bAddMonsterDropItem,579,500; bonus2 bAddItemHealRate,579,25;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5404,'Blue_Ribbon','Blue Ribbon',4,10,NULL,100,NULL,1,NULL,1,0xFFFFFFFF,7,2,256,NULL,45,1,407,'bonus4 bAutoSpellWhenHit,"AC_CONCENTRATION",2,7,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5405,'Filir_Hat','Filir Hat',4,10,NULL,200,NULL,0,NULL,0,0xFFFFFFFF,7,2,256,NULL,80,0,408,'bonus bShortWeaponDamageReturn, 1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5406,'Academy_Freshman_Hat','Academy Freshman Hat',4,0,NULL,500,NULL,2,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,409,'bonus bMaxHP,80; bonus bMaxSP,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5407,'Academy_Graduating_Cap','Academy Completion Hat',4,0,NULL,200,NULL,2,NULL,1,0xFFFFFFFF,7,2,256,NULL,0,1,410,'bonus bMaxSP,30;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5408,'Old_Bandanna','Old Bandana',4,0,NULL,0,NULL,5,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,0,6,'bonus bInt,2; bonus bMaxSP,50; bonus bCastrate,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5409,'New_Cowboy_Hat','Purple Cowboy Hat',4,20,NULL,500,NULL,4,NULL,1,0xFFFFFFFF,7,2,256,NULL,0,1,411,'bonus bInt,2; bonus bVit,2; bonus bMaxSP,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5410,'Bread_Bag2','Brown Paperbag Hat',4,20,NULL,200,NULL,6,NULL,0,0xFFFFFFFF,7,2,769,NULL,0,0,412,'bonus bMaxHP,100; bonus2 bResEff, Eff_Stun, 400; bonus2 bSubRace,RC_DemiHuman,4; bonus2 bSubRace,RC_Player,4;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5411,'White_Snake_Hat','White Snake Hat',4,20,NULL,500,NULL,2,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,413,'bonus bDex,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5412,'Sweet_Candy','Sweet Candy',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,7,2,1,NULL,0,0,414,'bonus bUnbreakableHelm, 0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5413,'Popcorn_Hat','Pop Corn Hat',4,20,NULL,300,NULL,2,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,0,415,'bonus2 bSubEle,Ele_Wind, 10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5414,'Campfire_Hat','Camp Fire Hat',4,20,NULL,300,NULL,2,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,0,416,'bonus2 bSubEle,Ele_Fire,10; bonus4 bAutoSpellWhenHit,"MG_FIREBALL",5,100,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5415,'Poring_Cake_Cap','Poring Cake Hat',4,20,NULL,1000,NULL,5,NULL,0,0xFFFFFFFF,7,2,256,NULL,40,1,417,'bonus bMdef,5; bonus bCritical,5; bonus bFlee,5; bonus bFlee2,5; bonus bAspdRate,5; bonus bCastrate,-5; bonus bDelayRate,-5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5416,'Beer_Cap','Beer Hat',4,20,NULL,600,NULL,2,NULL,0,0xFFFFFFFE,7,2,256,NULL,18,1,418,'bonus bFlee2,5; skill "SM_RECOVERY",3; skill "MG_SRECOVERY",3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5417,'Crown_Parrot','Crown Parrots',4,20,NULL,200,NULL,1,NULL,1,0xFFFFFFFF,7,2,256,NULL,0,0,419,'bonus bInt,1; bonus2 bResEff,Eff_Silence,10000; bonus3 bAutoSpell,"DC_SCREAM",1,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5418,'Soldier_Hat','Legionnaire Hat',4,20,NULL,400,NULL,4,NULL,1,0xFFFFFFFF,7,2,256,NULL,0,1,420,'bonus bStr,1; bonus2 bAddClass,Class_All,3; bonus bUseSPrate,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5419,'Evolved_Leaf','Leaves Of Grass',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,1,NULL,0,0,57,'bonus bVit,1; bonus2 bSubRace,RC_Plant,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5420,'Mask_Of_Ifrit','Mask Of Ifrit',4,NULL,NULL,0,NULL,8,NULL,0,0xFFFFFFFE,7,2,769,NULL,70,0,421,'bonus bStr,1; bonus bInt,1; bonus bMdef,5; bonus2 bSubEle,Ele_Fire,10; bonus2 bSubEle,Ele_Water,-10; skill "MG_SIGHT",1; bonus3 bAutoSpellWhenHit,"WZ_METEOR",3,50; bonus3 bAutoSpell,"MG_FIREBOLT",3,50;',NULL,'sc_end SC_SIGHT;');
REPLACE INTO `item_db` VALUES (5421,'Ifrit\'s_Ear','Ears Of Ifrit',4,20,NULL,0,NULL,0,NULL,0,0xFFFFFFFE,7,2,512,NULL,70,0,422,'bonus bStr,1; bonus bMdef,3; bonus2 bSkillAtk,"MG_FIREBOLT",2; bonus2 bSkillAtk,"WZ_FIREPILLAR",2; bonus2 bSkillAtk,"WZ_METEOR",2; bonus2 bSkillAtk,"SM_BASH",2; bonus2 bSkillAtk,"SM_MAGNUM",2; bonus2 bSkillAtk,"KN_PIERCE",2; bonus2 bSubEle,Ele_Fire,5; bonus2 bSubEle,Ele_Water,-5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5422,'Linguistic_Book_Cap','Linguistic Book Hat',4,20,NULL,70,NULL,0,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,423,'bonus bInt,1; bonus bMdef,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5423,'Lovecap_China','I Love China',4,20,NULL,250,NULL,5,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,0,424,'bonus bDex,3; bonus2 bSubRace,RC_DemiHuman,10; bonus2 bSubRace,RC_Player,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5424,'Fanta_Orange_Can','Fanta Orange Can Hat',4,20,NULL,100,NULL,2,NULL,1,0xFFFFFFFF,7,2,256,NULL,0,1,425,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5425,'Fanta_Grape_Can','Fanta Grape Can Hat',4,20,NULL,100,NULL,2,NULL,1,0xFFFFFFFF,7,2,256,NULL,0,1,426,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5426,'Karada_Meguri_Tea_Hat','Karada Meguricha Hat',4,20,NULL,100,NULL,2,NULL,1,0xFFFFFFFF,7,2,256,NULL,0,1,427,'bonus bLuk,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5427,'Royal_Milk_Tea_Hat','Black Tea Kochakaden Hat',4,20,NULL,100,NULL,2,NULL,1,0xFFFFFFFF,7,2,256,NULL,0,1,428,'bonus bAgi,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5428,'Bread_Bag1','RWC Anniversary Bread Envelope',4,NULL,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,769,NULL,0,1,429,'bonus2 bSubRace,RC_DemiHuman,12; bonus2 bSubRace,RC_Player,12;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5429,'Bogy_Cap','Bogy Cap',4,20,NULL,100,NULL,2,NULL,1,0xFFFFFFFF,7,2,256,NULL,0,1,430,'bonus bHPrecovRate, 5; bonus bSPrecovRate, 5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5430,'Sacred_Torch_Coronet','Torch Cap',4,20,NULL,0,NULL,3,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,0,431,'bonus2 bSubEle,Ele_Fire,20; skill "MG_FIREBOLT",5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5431,'Chicken_Hat','Chicken Hat',4,20,NULL,1000,NULL,0,NULL,1,0xFFFFFFFF,7,2,256,NULL,30,1,432,'bonus3 bAutoSpell,"MC_LOUD",1,30; bonus bAspdRate,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5432,'Brazil_Baseball_Cap','bRO 4th Anniversary Hat',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,433,'if(gettime(DT_MONTH)==SEPTEMBER&&gettime(DT_DAYOFMONTH)>=10&&gettime(DT_DAYOFMONTH)<=24) bonus bAllStats, 4;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5433,'Golden_Wreath','Golden Laurel',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,434,NULL,NULL,NULL);
#REPLACE INTO `item_db` VALUES (5434,'Cola_Can','Cola Can',4,20,NULL,100,NULL,2,NULL,1,0xFFFFFFFF,7,2,256,NULL,0,1,435,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5435,'Coke_Hat','Red Minstrel Hat',4,20,NULL,100,NULL,1,NULL,1,0xFFFFFFFF,7,2,256,NULL,40,1,436,'bonus bInt,1; bonus bMaxSP,80; bonus bMdef,3; if(getrefine()>5) { bonus bMdef,getrefine()-5; bonus bMaxSP,(getrefine()-5)*10; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (5436,'Bride\'s_Corolla','Bride\'s Corolla',4,20,NULL,200,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,437,'bonus bLuk,3; bonus bMdef,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5437,'Flower_Of_Fairy','Fairy Flower',4,20,NULL,200,NULL,1,NULL,1,0xFFFFFFFF,7,2,256,NULL,0,1,438,'bonus bInt,1; bonus bMdef,1; bonus2 bSubRace,RC_Insect,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5438,'Fillet_Green','Cute Green Ribbon',4,500,NULL,100,NULL,1,NULL,0,0xFFFFFFFE,7,2,256,NULL,0,0,439,'bonus bMaxSP,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5439,'Fillet_Red','Cute Red Ribbon',4,500,NULL,100,NULL,1,NULL,0,0xFFFFFFFE,7,2,256,NULL,0,0,440,'bonus bMaxSP,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5440,'Fillet_Blue','Cute Blue Ribbon',4,500,NULL,100,NULL,1,NULL,0,0xFFFFFFFE,7,2,256,NULL,0,0,441,'bonus bMaxSP,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5441,'Fillet_White','Cute White Ribbon',4,500,NULL,100,NULL,1,NULL,0,0xFFFFFFFE,7,2,256,NULL,0,0,442,'bonus bMaxSP,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5442,'Necktie','Necktie',4,20,NULL,100,NULL,3,NULL,1,0xFFFFFFFF,7,2,256,NULL,70,1,443,'bonus bVit,1; bonus bHit,-5; bonus bUseSPrate,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5443,'Status_Of_Baby_Angel','Statue Of Baby Angel',4,20,NULL,600,NULL,3,NULL,1,0xFFFFFFFF,7,2,256,NULL,70,1,444,'bonus bMdef,2; bonus4 bAutoSpellWhenHit,"PR_STRECOVERY",1,20,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5444,'Hair_Brush','Hair Brush',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,445,'bonus bCritical,6;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5445,'Candy_Cane_In_The_Mouth','Candy Cane In Mouth',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,1,NULL,0,0,446,'bonus bMaxSP,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5446,'Cat_Foot_Hairpin','Catfoot Hairpin',4,20,NULL,200,NULL,0,NULL,1,0xFFFFFFFF,7,2,256,NULL,0,1,447,'bonus bFlee,5; bonus bFlee2,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5447,'Frog_Cap','Frog Hat',4,20,NULL,500,NULL,3,NULL,0,0xFFFFFFFF,7,2,256,NULL,70,1,448,'bonus bMdef,1; bonus2 bAddRace,RC_Insect,12; bonus2 bMagicAddRace,RC_Insect,12;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5448,'Solo_Play_Box1','Soloplay Box1',4,NULL,NULL,300,NULL,0,NULL,1,0xFFFFFFFF,7,2,769,NULL,0,1,449,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5449,'Solo_Play_Box2','Soloplay Box2',4,NULL,NULL,300,NULL,0,NULL,1,0xFFFFFFFF,7,2,769,NULL,0,1,450,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5450,'Sun_Cap','Solar Hat',4,20,NULL,1000,NULL,0,NULL,0,0xFFFFFFFE,7,2,256,NULL,20,1,451,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5451,'Dragonhelm_Gold','RWC 2008 Dragon Helm Gold',4,20,NULL,2500,NULL,7,NULL,1,0xFFFFFFFF,7,2,256,NULL,1,0,452,'bonus bAspdRate,10; bonus bAllStats,3; bonus2 bAddRace,RC_DemiHuman,5; bonus2 bAddRace,RC_Player,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5452,'Dragonhelm_Silver','RWC 2008 Dragon Helm Silver',4,20,NULL,2500,NULL,5,NULL,1,0xFFFFFFFF,7,2,256,NULL,1,0,453,'bonus bAspdRate,7; bonus bAllStats,2; bonus2 bAddRace,RC_DemiHuman,3; bonus2 bAddRace,RC_Player,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5453,'Dragonhelm_Copper','RWC 2008 Dragon Helm Copper',4,20,NULL,2500,NULL,0,NULL,1,0xFFFFFFFF,7,2,256,NULL,1,0,454,'bonus bAspdRate,5; bonus bAllStats,2; bonus2 bAddRace,RC_DemiHuman,1; bonus2 bAddRace,RC_Player,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5454,'Dog_Cap_','Puppy Hat',4,20,NULL,500,NULL,3,NULL,1,0xFFFFFFFF,7,2,256,NULL,0,1,234,'bonus bStr,1; bonus bInt,1; autobonus "{ bonus bCritical,100; }",10,3000,BF_WEAPON,"{ specialeffect2 EF_ENHANCE; }"; autobonus "{ bonus2 bIgnoreMdefClassRate,Class_Normal,100; bonus2 bIgnoreMdefClassRate,Class_Boss,100; }",10,3000,BF_MAGIC,"{ specialeffect2 EF_MAGICALATTHIT; }";',NULL,NULL);
REPLACE INTO `item_db` VALUES (5455,'Geographer_Band_','Decorative Geographer',4,20,NULL,500,NULL,1,NULL,1,0xFFFFFFFF,7,2,256,NULL,0,1,238,'bonus bInt,1; bonus3 bAutoSpell,"AL_HEAL",5,50; bonus3 bAutoSpellWhenHit,"AL_HEAL",5,30;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5456,'Vacation_Hat_','Summer Hat',4,20,NULL,200,NULL,0,NULL,1,0xFFFFFFFF,7,2,256,NULL,0,1,315,'bonus bVit,5; bonus bHPrecovRate,20; bonus bSPrecovRate,15;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5457,'Spring_Rabbit_Hat','Moon Rabbit Hat',4,20,NULL,300,NULL,2,NULL,1,0xFFFFFFFF,7,2,256,NULL,1,1,455,'bonus bAgi,3; bonus bBaseAtk,5; bonus bMatkRate,5; if(getrefine()>4) { bonus bBaseAtk,getrefine()-4; bonus bMatkRate,getrefine()-4; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (5458,'Pinwheel_Cap','Pinwheel Hat',4,20,NULL,200,NULL,2,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,456,'bonus bHPrecovRate, 5; bonus bHPrecovRate, 5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5459,'Drooping_Bunny_Chusuk','Drooping Bunny',4,0,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,249,'bonus bDex,1; bonus bFlee,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5460,'Adv_Dragon_Skull','Evolved Dragon Skull Hat',4,20,NULL,1000,NULL,7,NULL,0,0xFFFFFFFF,7,2,256,NULL,60,1,457,'bonus bAllStats, 2; bonus bMaxHPrate, 3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5461,'Adv_Whisper_Mask','Evolved Whisper Mask',4,20,NULL,300,NULL,1,NULL,0,0xFFFFFFFF,7,2,769,NULL,50,1,458,'bonus bDex,3; bonus2 bSubEle,Ele_Ghost, 20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5462,'Spiked_Scarf','Spiked Scarf',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,7,2,1,NULL,90,0,459,'bonus bVit,1; bonus2 bAddRace,RC_DemiHuman,1; bonus2 bAddRace,RC_Player,1; bonus2 bSubRace,RC_DemiHuman,1; bonus2 bSubRace,RC_Player,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5463,'Rainbow_Scarf','Rainbow Scarf',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,7,2,1,NULL,90,0,460,'bonus bInt,1; bonus bMdef,2; bonus bMatkRate,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5464,'Zaha_Doll_Hat','Zaha Doll Hat',4,20,NULL,0,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,0,461,'bonus bInt,2; skill "PR_MAGNIFICAT", 3;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5465,'Celestial_Hat','Hat Of Fortune',4,20,NULL,500,NULL,3,NULL,1,0xFFFFFFFF,7,2,256,NULL,40,1,462,'bonus bLuk,2; bonus bMdef,5; if(getrefine()>4) bonus bLuk,getrefine()-4;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5466,'Wind_Milestone','Wind Milestone',4,20,NULL,100,NULL,2,NULL,1,0xFFFFFFFF,7,2,256,NULL,30,1,463,'bonus bAgi,2; skill "AL_TELEPORT",1;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5467,'Helm_Of_Dragoon','Helm Of Dragon',4,20,NULL,2000,NULL,5,NULL,0,0xFFFFFFFF,7,2,256,NULL,50,1,464,'bonus2 bAddRace,RC_Dragon,20; bonus3 bAutoSpell,"NPC_DRAGONFEAR",1,30;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5468,'Parade_Cap','Parade Hat',4,20,NULL,800,NULL,3,NULL,1,0xFFFFFFFF,7,2,256,NULL,0,1,465,'bonus bDelayRate,-5; bonus bMdef,2; if(getrefine()>5) bonus bCastrate,-(getrefine()-5);',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5469,'Noble_Hat','Musketeer Hat',4,20,NULL,300,NULL,2,NULL,0,0xFFFFFFFF,7,2,256,NULL,30,1,466,'bonus bStr,2; bonus3 bAutoSpellWhenHit,"BS_ADRENALINE",1,7;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5470,'Eyes_Of_Darkness','Eye Of Darkness',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,7,2,512,NULL,50,0,467,'bonus bDex,1; bonus2 bResEff,Eff_Blind,10000;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5471,'Hairband_Of_Reginleif','Hairband Of Reginleif',4,20,NULL,800,NULL,1,NULL,0,0xFFFFFFFF,7,2,512,NULL,50,0,468,'bonus2 bSubEle,Ele_Water,3; bonus2 bSubEle,Ele_Fire,3; bonus2 bSubEle,Ele_Undead,3; bonus2 bSubEle,Ele_Ghost,3;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5472,'Red_White_Hat','Red Hat',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,469,'bonus3 bAddMonsterDropItem,550,RC_DemiHuman,3;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5473,'Forceps_Hairpin','Nipper Crab Hairpin',4,20,NULL,500,NULL,4,NULL,0,0xFFFFFFFF,7,2,256,NULL,30,1,470,'bonus3 bAutoSpellWhenHit,"MG_COLDBOLT",1,100; bonus3 bAddMonsterDropItem,991,RC_Fish,3;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5474,'Notice_Board','AFK Hat',4,20,NULL,700,NULL,2,NULL,0,0xFFFFFFFF,7,2,256,NULL,10,0,471,NULL,NULL,NULL);
#REPLACE INTO `item_db` VALUES (5475,'Cube_Mask','Mask Cube',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,7,2,513,NULL,0,0,472,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5476,'Hairband_Of_Grandpeco','Grand Peco Hairband',4,20,NULL,800,NULL,2,NULL,0,0xFFFFFFFF,7,2,768,NULL,30,1,473,'bonus bStr,2; bonus bMaxHPrate,-10; bonus2 bAddRace2,RC2_Orc,15;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5477,'Bro_Flag','Brazilian Flag Hat',4,20,NULL,100,NULL,1,NULL,1,0xFFFFFFFF,7,2,256,NULL,30,1,474,'skill "SM_BASH", 1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5478,'Classic_Hat','Classic Hat',4,20,NULL,500,NULL,3,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,475,'bonus bStr,2; bonus bMaxHP,300;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5479,'Shaman\'s_Hair_Ornament','Shaman\'s Hair Decoration',4,20,NULL,300,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,30,1,476,'bonus bMdef,3; bonus bMaxHP,50; bonus2 bSubEle,Ele_Neutral,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5480,'Bizofnil_Wing_Deco','Bijofnil Wings',4,20,NULL,1000,NULL,3,NULL,0,0xFFFFFFFF,7,2,256,NULL,30,1,477,'bonus bAllStats,2; bonus3 bAutoSpell,"PR_IMPOSITIO",3,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5481,'Hermose_Cap','Hermode Cap',4,20,NULL,1000,NULL,1,NULL,1,0xFFFFFFFF,7,2,256,NULL,1,1,478,'bonus bAspdRate,10; bonus bBaseAtk,-20; bonus bMatkRate,-10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5482,'Dark_Knight_Mask','Dark Knight Mask',4,NULL,NULL,3000,NULL,5,NULL,0,0xFFFFFFFF,7,2,769,NULL,80,1,479,'bonus bStr,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5483,'Odin_Mask','Odin Mask',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,7,2,513,NULL,50,0,480,'bonus bHit,-10; bonus2 bAddRace,RC_DemiHuman,6; bonus2 bAddRace,RC_Player,6;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5484,'Taiwan_Flag_Hat','Holidays Hat',4,20,NULL,500,NULL,4,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,0,482,'bonus bAllStats,5; bonus2 bResEff,Eff_Stun,500;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5485,'Tiger_Face','Tiger Face',4,20,NULL,1000,NULL,3,NULL,0,0xFFFFFFFF,7,2,769,NULL,60,1,483,'bonus2 bSubRace,RC_Brute,5; bonus2 bAddRace,RC_Brute,5; bonus2 bMagicAddRace,RC_Brute,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5486,'J_Anniversary_Hat','Anniversary Hat',4,20,NULL,300,NULL,3,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,395,'bonus bAllStats, 2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5487,'J_Poringcake_Hat','Poring Cake Hat',4,20,NULL,500,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,417,'bonus bLuk,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5488,'J_Twin_Santahat','Twin Santa Hat',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,390,'bonus bLuk,1; bonus bMdef,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5489,'Love_Daddy','Love Daddy Hat',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,484,'bonus bDex,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5490,'Anubis_Helm','Anubis Helm',4,20,NULL,0,NULL,3,NULL,0,0xFFFFFFFF,7,2,256,NULL,70,0,485,'bonus bMdef,5; bonus2 bSubClass,Class_Boss,10; bonus bHealpower2,10; bonus bAddItemHealRate,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5491,'Hat_Of_Outlaw','Bandit Hat',4,20,NULL,800,NULL,3,NULL,1,0xFFFFFFFF,7,2,256,NULL,0,1,486,'bonus bStr,2; bonus2 bSubEle,Ele_Fire, 10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5492,'Boy\'s_Cap_I','Student Cap',4,0,NULL,0,NULL,5,NULL,0,0xFFFFFFFE,7,2,256,NULL,0,0,102,'bonus bMdef,3; bonus2 bAddRace,RC_DemiHuman,5; bonus2 bAddRace,RC_Player,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5493,'Ulle_Cap_I','Ulle\'s Cap',4,0,NULL,0,NULL,3,NULL,0,0xFFFFFFFE,7,2,256,NULL,0,0,254,'bonus bDex,2; bonus bAgi,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5494,'Spinx_Helm_I','Sphinx Hat',4,0,NULL,0,NULL,5,NULL,0,0x00004082,7,2,257,NULL,0,0,137,'bonus bStr,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5495,'Power_Of_Thor','Power Of Thor',4,20,NULL,100,NULL,6,NULL,1,0xFFFFFFFF,7,2,256,NULL,75,1,493,'bonus bInt,1; bonus bDex,1; bonus bMdef,3; bonus bFlee,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5496,'Dice_Hat','Dice Hat',4,20,NULL,300,NULL,3,NULL,0,0xFFFFFFFF,7,2,256,NULL,50,0,494,'bonus bLuk,4;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5497,'King_Tiger_Doll_Hat','King Tiger Doll Hat',4,20,NULL,400,NULL,3,NULL,1,0xFFFFFFFE,7,2,256,NULL,30,1,495,'bonus bStr,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5498,'Wondering_Wolf_Helm','Wandering Wolf Helm',4,20,NULL,600,NULL,5,NULL,0,0xFFFFFFFE,7,2,768,NULL,50,1,490,'bonus bVit,5; bonus bFlee,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5499,'Pizza_Hat','Pizza Hat',4,20,NULL,600,NULL,0,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,0,487,'skill "SM_PROVOKE", 1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5500,'Icecream_Hat','Icecream Hat',4,0,NULL,300,NULL,6,NULL,0,0xFFFFFFFF,7,2,256,NULL,30,1,488,'bonus bMdef,3; skill "MG_FROSTDIVER",3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5501,'Pirate\'s_Pride','Pirate\'s Pride',4,0,NULL,100,NULL,6,NULL,0,0xFFFFFFFF,7,2,256,NULL,10,0,496,'bonus2 bAddRace2,RC2_Ninja,5; bonus2 bSubRace2,RC2_Ninja,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5502,'Necromencer\'s_Hood','Necromancer\'s Hood',4,0,NULL,500,NULL,2,NULL,0,0xFFFFFFFF,7,2,768,NULL,1,1,491,'bonus5 bAutoSpellWhenHit,"NPC_DARKSTRIKE",5,5,BF_WEAPON|BF_MAGIC,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5503,'Rabbit_Magic_Hat','Magic Rabit Hat',4,0,NULL,800,NULL,2,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,497,'bonus bDex,2; bonus bAgi,2; bonus bMdef,1; bonus bMaxSP,50; bonus3 bAutoSpellWhenHit,"MG_FIREBOLT",1,20; bonus3 bAutoSpellWhenHit,"MG_COLDBOLT",1,20; bonus3 bAutoSpellWhenHit,"MG_LIGHTNINGBOLT",1,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5504,'China_Wedding_Veil','Wedding Weil',4,20,NULL,500,NULL,5,NULL,0,0xFFFFFFFF,7,2,768,NULL,70,1,489,'bonus bMdef,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5505,'Asara_Fairy_Hat','Asara Fairy Hat',4,0,NULL,500,NULL,2,NULL,0,0xFFFFFFFF,7,2,768,NULL,50,1,492,'skill "DC_DONTFORGETME",1; bonus bDex,2; bonus bLuk,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5506,'Blue_Pajamas_Hat','Blue Night Cap',4,0,NULL,100,NULL,4,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,501,'bonus bBaseAtk,5; bonus bMatkRate,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5507,'Pink_Pajamas_Hat','Pink Night Cap',4,0,NULL,100,NULL,4,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,502,'bonus bBaseAtk,5; bonus bMatkRate,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5508,'Shark_Hat','Shark Hat',4,20,NULL,500,NULL,3,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,503,'bonus bStr,1; bonus bAgi,2; bonus bMdef,1; bonus2 bAddEle,Ele_Water,5; bonus2 bSubEle,Ele_Water,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5509,'Sting_Hat','Sting hat',4,20,NULL,1000,NULL,5,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,504,'bonus bStr,2; bonus bVit,1; bonus bMdef,3; bonus2 bAddEle,Ele_Fire,5; bonus2 bSubEle,Ele_Earth,5; bonus3 bAutoSpell,"WZ_EARTHSPIKE",1,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5510,'Shower_Cap','Shower Cap',4,20,NULL,0,NULL,4,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,507,'bonus bMdef,3; bonus bFlee,3; bonus2 bAddEle,Ele_Water,10; bonus2 bSubRace,RC_Fish,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5511,'Samambaia','Samambaia',4,20,NULL,200,NULL,5,NULL,1,0xFFFFFFFF,7,2,768,NULL,30,1,508,'bonus bSPrecovRate,8;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5512,'Aquarius_Diadem','Aquarius Diadem',4,20,NULL,300,NULL,6,NULL,0,0xFFFFFFFF,7,2,256,NULL,70,1,509,'bonus bStr,2; bonus bFlee,10; bonus2 bSubEle,Ele_Wind, 5; if(getrefine()>6) { bonus bDef, 1; bonus bBaseAtk,15; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (5513,'Aquarius_Crown','Aquarius Crown',4,20,NULL,300,NULL,6,NULL,0,0xFFFFFFFF,7,2,256,NULL,70,1,510,'bonus bStr,2; bonus bFlee,10; bonus2 bSubEle,Ele_Wind, 5; if(getrefine()>6) { bonus bDef, 1; bonus bBaseAtk,15; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (5514,'Pisces_Diadem','Pisces Diadem',4,20,NULL,300,NULL,6,NULL,0,0xFFFFFFFF,7,2,256,NULL,70,1,511,'bonus bInt,2; bonus bMdef,5; bonus2 bSubEle,Ele_Water, 5; if(getrefine()>6) { bonus bDef, 1; bonus bMatkRate,2; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (5515,'Pisces_Crown','Pisces Crown',4,20,NULL,300,NULL,6,NULL,0,0xFFFFFFFF,7,2,256,NULL,70,1,512,'bonus bInt,2; bonus bMdef,5; bonus2 bSubEle,Ele_Water, 5; if(getrefine()>6) { bonus bDef, 1; bonus bMatkRate,2; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (5516,'Hawk_Eyes01','hawk Eyes',4,10,NULL,100,NULL,0,NULL,0,0x00000800,2,2,512,NULL,60,0,23,'bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5517,'Hawk_Eyes02','Hawk Eyes',4,10,NULL,100,NULL,0,NULL,0,0x00080808,7,2,512,NULL,60,0,23,'bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5518,'L_Magestic_Goat2','Gigantic Majestic Goat',4,20,NULL,800,NULL,5,NULL,0,0xFFFFFFFF,7,2,256,NULL,50,1,513,'bonus2 bSubRace,RC_DemiHuman,12; bonus2 bSubRace,RC_Player,12; bonus bBaseAtk,(JobLevel*2)/7;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5519,'Peacock_Feather','Peacock Feather',4,20,NULL,800,NULL,4,NULL,1,0xFFFFFFFF,7,2,256,NULL,1,1,514,'bonus bInt,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5520,'Rabbit_Earplug','Rabbit Earplugs',4,NULL,NULL,400,NULL,0,NULL,1,0xFFFFFFFF,7,2,768,NULL,1,1,515,'bonus2 bAddClass,Class_All,4; bonus bMatkRate,4;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5521,'Angry_Mouth_C','Angry Mouth',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,7,2,1,NULL,0,0,194,'bonus bDelayRate,-3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5522,'Fanta_Zero_Lemon_Hat','Fanta Zero Lemon Hat',4,20,NULL,100,NULL,4,NULL,1,0xFFFFFFFF,7,2,256,NULL,0,1,516,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5523,'Sakura_Mist_Hat','Sakura Mist Hat',4,20,NULL,100,NULL,4,NULL,1,0xFFFFFFFF,7,2,256,NULL,0,1,517,'bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5524,'Sakura_Milk_Tea_Hat','Sakura Milk Tea Hat',4,20,NULL,100,NULL,4,NULL,1,0xFFFFFFFF,7,2,256,NULL,0,1,518,'bonus bVit,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5525,'First_Leaf_Tea_Hat','Flower Hat',4,20,NULL,100,NULL,4,NULL,1,0xFFFFFFFF,7,2,256,NULL,0,1,519,'bonus bMaxHP,80; bonus bMaxSP,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5526,'Lady_Tanee_Doll','Tanigumi Girl Doll',4,20,NULL,300,NULL,4,NULL,0,0xFFFFFFFF,7,2,256,NULL,60,0,520,'bonus bAgi,2; bonus bFlee,3; bonus2 bSubEle,Ele_Wind, 5; bonus2 bAddMonsterDropItem, 513, 200;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5527,'Lunatic_Hat','Lunatic Hat',4,20,NULL,300,NULL,2,NULL,0,0xFFFFFFFF,7,2,256,NULL,1,1,521,'bonus bLuk,5; bonus bMdef,2; bonus bFlee2,5; bonus2 bAddMonsterDropItem,622,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5528,'King_Frog_Hat','Frog King Hat',4,20,NULL,500,NULL,4,NULL,1,0xFFFFFFFE,7,2,256,NULL,30,0,522,'bonus bAgi,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5529,'Evil\'s_Bone_Hat','Satanic Bone Helm',4,20,NULL,600,NULL,6,NULL,1,0xFFFFFFFF,7,2,768,NULL,70,1,523,'bonus bDex,3; bonus2 bSubEle,Ele_Neutral,5; skill "WZ_FROSTNOVA",1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5530,'Raven_Cap','Raven Cap',4,20,NULL,100,NULL,6,NULL,1,0xFFFFFFFF,7,2,256,NULL,30,1,524,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5531,'B_Dragon_Hat','Baby Dragon Hat',4,45000,NULL,100,NULL,1,NULL,1,0xFFFFFFFF,7,2,256,NULL,0,1,525,'bonus bDex,2; .@bonus = max(getskilllv("TF_DOUBLE"), 5); skill "TF_DOUBLE",.@bonus; bonus bDoubleRate,.@bonus * 5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5532,'Pirate_Dagger_J','Pirate Dagger',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,1,NULL,0,1,327,'bonus bShortWeaponDamageReturn,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5533,'Emperor_Wreath_J','Emperor Wreath',4,20,NULL,800,NULL,3,NULL,1,0xFFFFFFFF,7,2,256,NULL,80,1,261,'bonus bAllStats,1;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5534,'Fox_Hat_J','Fox Hat',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,7,2,513,NULL,70,0,403,'bonus bAgi,1; bonus bFlee2,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5535,'Side_Cap','Side Cap',4,0,NULL,500,NULL,3,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,529,'bonus bVit,1; bonus bDex,1; bonus bMdef,3; bonus2 bSubRace,RC_DemiHuman,5; bonus2 bSubRace,RC_Player,5; bonus2 bAddRace,RC_DemiHuman,3; bonus2 bAddRace,RC_Player,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5536,'Spare_Card','Spare Card',4,20,NULL,10,NULL,1,NULL,0,0xFFFFFFFF,7,2,1,NULL,1,0,526,'bonus2 bAddMonsterDropItem,6187,1000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5537,'Quati_Hat','Kwati Hat',4,20,NULL,700,NULL,2,NULL,1,0xFFFFFFFF,7,2,256,NULL,45,0,527,'bonus bAgi,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5538,'Tucan_Hat','Tucan Hat',4,20,NULL,600,NULL,2,NULL,1,0xFFFFFFFF,7,2,768,NULL,45,0,528,'bonus bDex,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5539,'Jaguar_Hat','Jaguar Hat',4,20,NULL,400,NULL,4,NULL,1,0xFFFFFFFF,7,2,769,NULL,25,1,530,'bonus bMdef,2; skill "MC_LOUD", 1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5540,'Freyja_SCirclet7','Freyja SCirclet7',4,20,NULL,700,NULL,8,NULL,0,0xFFFFFFFF,7,2,256,NULL,20,0,18,'bonus bStr,1; bonus bInt,1; bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5541,'Freyja_SCirclet30','Freyja SCirclet30',4,20,NULL,700,NULL,8,NULL,0,0xFFFFFFFF,7,2,256,NULL,20,0,18,'bonus bStr,1; bonus bInt,1; bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5542,'Freyja_SCirclet60','Freyja SCirclet60',4,20,NULL,700,NULL,8,NULL,0,0xFFFFFFFF,7,2,256,NULL,20,0,18,'bonus bStr,1; bonus bInt,1; bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5543,'Freyja_SCirclet90','Freyja SCirclet90',4,20,NULL,700,NULL,8,NULL,0,0xFFFFFFFF,7,2,256,NULL,20,0,18,'bonus bStr,1; bonus bInt,1; bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5544,'Time_Keeper_Hat','Time Keeper Hat',4,30000,NULL,0,NULL,6,NULL,0,0xFFFFFFFF,7,2,256,NULL,1,1,240,'bonus bInt,2; bonus bMaxSP,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5545,'Aries_Diadem','Aries Diadem',4,20,NULL,400,NULL,3,NULL,0,0xFFFFFFFF,7,2,256,NULL,70,1,531,'bonus bVit,2; bonus2 bSubEle,Ele_fire,5; if(getrefine()>6) { bonus bDef,1; bonus bVit,1; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (5546,'Aries_Crown','Aries Crown',4,20,NULL,400,NULL,3,NULL,0,0xFFFFFFFF,7,2,256,NULL,70,1,532,'bonus bVit,2; bonus2 bSubEle,Ele_fire,5; if(getrefine()>6) { bonus bDef,1; bonus bVit,1; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (5547,'RJC_Katusa','RJC Katusa Flower',4,20,NULL,200,NULL,1,NULL,1,0xFFFFFFFF,7,2,256,NULL,0,1,533,'bonus2 bSkillAtk, "WZ_HEAVENDRIVE", 15 + getequiprefinerycnt(EQI_HAND_R); bonus2 bSkillAtk, "WZ_EARTHSPIKE", 15 + getequiprefinerycnt(EQI_HAND_R); bonus2 bCastrate, "WZ_HEAVENDRIVE", -25; bonus2 bCastrate, "WZ_EARTHSPIKE", -25; ;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5548,'Scarlet_Rose','Scarlet Rose',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,1,NULL,50,1,534,'bonus bLuk,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5549,'Taurus_Diadem','Taurus Diadem',4,20,NULL,300,NULL,3,NULL,0,0xFFFFFFFF,7,2,256,NULL,70,1,535,'bonus bDex,2; bonus bDelayRate,-2; bonus2 bSubEle,Ele_earth,5; if(getrefine()>6) { bonus bDex,1; bonus bMatkRate,1; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (5550,'Taurus_Crown','Taurus Crown',4,20,NULL,300,NULL,3,NULL,0,0xFFFFFFFF,7,2,256,NULL,70,1,536,'bonus bDex,2; bonus bDelayRate,-2; bonus2 bSubEle,Ele_earth,5; if(getrefine()>6) { bonus bDex,1; bonus bMatkRate,1; }',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5551,'Holy_Egg_Hat','Holy Egg Hat',4,20,NULL,0,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,537,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5552,'Fest_Lord_Circlet','Festival Grand Circlet',4,0,NULL,0,NULL,8,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,0,93,'bonus bStr,3; bonus bInt,3; bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5553,'Fest_Bunny_Band','Festival Bunny Band',4,0,NULL,0,NULL,7,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,0,15,'bonus bMdef,4; bonus2 bSubRace,RC_DemiHuman,9; bonus2 bSubRace,RC_Player,9;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5554,'Octopus_Hat','Octopus Hat',4,20,NULL,200,NULL,3,NULL,0,0xFFFFFFFF,7,2,256,NULL,20,1,538,'bonus3 bAutoSpell,"SM_PROVOKE",5,10; bonus bUnbreakableHelm;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5555,'Leaf_Cat_Hat','Leaf Cat Hat',4,20,NULL,100,NULL,3,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,539,'bonus bAgi,1; bonus3 bAutoSpellWhenHit,"AL_HEAL",3,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5556,'Fur_Seal_Hat','Seal Hat',4,20,NULL,500,NULL,3,NULL,0,0xFFFFFFFF,7,2,769,NULL,55,1,540,'bonus bInt,1; bonus3 bAutoSpell,"WZ_FROSTNOVA",1,30;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5557,'Wild_Rose_Hat','Wild Rose Hat',4,20,NULL,500,NULL,6,NULL,1,0xFFFFFFFE,7,2,256,NULL,20,1,541,'bonus bAgi,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5558,'Saci_Hat','Luxury Hat',4,20,NULL,100,NULL,6,NULL,1,0xFFFFFFFF,7,2,256,NULL,30,1,542,'bonus3 bAddMonsterDropItem,510,RC_Plant,500;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5559,'Piece_Of_White_Cloth_E','Piece Of White Cloth',4,0,NULL,0,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,543,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5560,'Bullock_Helm_J','Bullock Helm',4,20,NULL,3000,NULL,3,NULL,0,0xFFFFFFFF,7,2,256,NULL,75,1,322,'bonus bMaxHP,100; bonus bNoKnockback; bonus2 bSubEle,Ele_Neutral,-20; bonus2 bSubEle,Ele_Fire,-20; bonus2 bSubEle,Ele_Water,-20; bonus2 bSubEle,Ele_Wind,-20; bonus2 bSubEle,Ele_Earth,-20; bonus2 bSubEle,Ele_Dark,-20; bonus2 bSubEle,Ele_Holy,-20; bonus2 bSubEle,Ele_Ghost,-20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5561,'Rabbit_Magic_Hat_J','Magic Rabbit Hat',4,0,NULL,800,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,497,'bonus bInt,1; bonus bMaxSP,50; bonus4 bAutoSpellWhenHit,"MG_FIREBOLT",3,10,3; bonus4 bAutoSpellWhenHit,"MG_COLDBOLT",3,10,3; bonus4 bAutoSpellWhenHit,"MG_LIGHTNINGBOLT",3,10,3; bonus3 bAutoSpellWhenHit,"AL_HEAL",1,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5562,'Good_Wedding_Veil_J','Luxurious Wedding Veil',4,0,NULL,500,NULL,0,NULL,1,0xFFFFFFFF,7,2,768,NULL,45,0,489,'bonus bMdef,10; bonus bCastRate,-3; bonus bUseSPrate,-5;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5563,'Dolor_Hat','Dolor Hat',4,20,NULL,100,NULL,1,NULL,1,0xFFFFFFFF,7,2,256,NULL,0,0,547,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5564,'Crown_Of_Deceit','Crown of Deceit',4,20,NULL,300,NULL,3,NULL,1,0xFFFFFFFF,7,2,768,NULL,85,1,544,'bonus bInt,4; bonus bCastRate,-10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5565,'Dragon_Arhat_Mask','Dragon Arhat Mask',4,0,NULL,0,NULL,5,NULL,0,0xFFFFFFFF,7,2,513,NULL,1,0,545,'bonus2 bAddRace,RC_DemiHuman,10; bonus2 bAddRace,RC_Player,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5566,'Tiger_Arhat_Mask','Tiger Arhat Mask',4,0,NULL,0,NULL,1,NULL,0,0xFFFFFFFF,7,2,513,NULL,1,0,546,'bonus2 bAddRace,RC_DemiHuman,2; bonus2 bAddRace,RC_Player,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5567,'Bright_Fury','Bright Fury',4,20,NULL,300,NULL,1,NULL,1,0xFFFFFFFF,7,2,256,NULL,1,1,548,'bonus bStr,1; bonus2 bAddClass,Class_All,2; bonus bAspdRate,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5568,'Rabbit_Bonnet','Rabbit Bonnet',4,20,NULL,1000,NULL,1,NULL,1,0xFFFFFFFF,7,2,768,NULL,0,1,549,'bonus bInt,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5569,'Gemini_Diadem','Gemini Diadem',4,20,NULL,300,NULL,4,NULL,0,0xFFFFFFFF,7,2,256,NULL,70,1,550,'bonus bAgi,2; bonus bMatkRate,2; if(getrefine()>6) { bonus bMdef,7; bonus bMAtkRate,8; bonus2 bSubEle,Ele_Wind,5; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (5570,'Gemini_Crown','Gemini Crown',4,20,NULL,300,NULL,4,NULL,0,0xFFFFFFFF,7,2,256,NULL,70,1,551,'bonus bAgi,2; bonus bBaseAtk,2; bonus bMdef,5; if(getrefine()>6) { bonus bDef,1; bonus bMatk,15; bonus bFlee,10; bonus2 bSubEle,Ele_Wind,5; }',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5571,'Rasta_Wig','Rasta_Wig',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,552,'bonus bStr,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5572,'Savage_Baby_Hat','Savage Babe Hat',4,20,NULL,100,NULL,1,NULL,1,0xFFFFFFFF,7,2,256,NULL,1,1,553,'bonus bVit,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5573,'Bogy_Horn','Dokebi Horn',4,20,NULL,100,NULL,1,NULL,1,0xFFFFFFFF,7,2,256,NULL,0,1,554,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5574,'Pencil_In_Mouth','Well-Chewed Pencil',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,1,NULL,10,0,555,'bonus bdex,2; bonus bHitRate,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5575,'Onigiri_Hat','Rice Ball Hat',4,20,NULL,100,NULL,6,NULL,1,0xFFFFFFFF,7,2,256,NULL,30,0,556,NULL,NULL,NULL);
#REPLACE INTO `item_db` VALUES (5576,'Japan_Winecup','Wine Cup',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,7,2,1,NULL,0,0,557,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5577,'Dark_Knight_MaskB','Dark Knight Mask',4,NULL,NULL,3000,NULL,5,NULL,0,0xFFFFFFFF,7,2,769,NULL,80,1,479,'bonus bStr,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5578,'Voyage_Hat','Voyage_Hat',4,200,NULL,10,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,236,'bonus bAgi,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5579,'Wanderer\'s_Sakkat','Wanderer\'s Sakkat',4,20,NULL,300,NULL,2,NULL,1,0xFFFFFFFF,7,2,768,NULL,70,1,558,'bonus bAgi,2;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5580,'Red_Beret','Red Beret',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,0,559,'bonus bAllStats,3; bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5581,'Cancer_Diadem','Cancer Diadem',4,20,NULL,300,NULL,3,NULL,0,0xFFFFFFFF,7,2,256,NULL,70,1,560,'bonus bInt,2; bonus2 bSubEle,Ele_water, 5; if(getrefine()>6) { bonus bMdef,1; bonus bHealPower, 3; bonus bMatkRate,2; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (5582,'Cancer_Crown','Cancer Crown',4,20,NULL,300,NULL,3,NULL,0,0xFFFFFFFF,7,2,256,NULL,70,1,561,'bonus bStr,2; bonus2 bSubEle,Ele_water, 5; if(getrefine()>6) { bonus bDef, 1; bonus bBaseAtk,15; bonus bFlee,10; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (5583,'Para_Team_Hat','Eden Team Hat',4,0,NULL,0,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,12,1,465,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5584,'Majestic_Evil_Horn','Majestic Evil Horns',4,0,NULL,400,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,1,1,562,'bonus2 bSubRace,RC_Demon,3; bonus2 bHPDrainRate,3,15; bonus2 bSPDrainRate,1,7;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5585,'Rune_Hairband','Rune Cloth Circlet',4,20,NULL,400,NULL,1,NULL,1,0xFFFFFFFF,7,2,768,NULL,1,1,564,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5586,'Mosquito_Coil','Mosquito Coil',4,20,NULL,100,NULL,1,NULL,1,0xFFFFFFFF,7,2,256,NULL,1,1,563,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5587,'Mosquito_Coil_1Use','Mosquito Coil',4,0,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,1,1,563,NULL,NULL,NULL);
#REPLACE INTO `item_db` VALUES (5588,'Leo_Crown','Leo Crown',4,20,NULL,300,NULL,3,NULL,0,0xFFFFFFFF,7,2,256,NULL,70,1,565,'bonus bStr,2; bonus2 bSubEle,Ele_Fire,5; if(getrefine()>6) { bonus bDef,1; bonus bFlee,10; bonus3 bAutoSpell,"TK_SEVENWIND",4,50; }',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5589,'Leo_Diadem','Leo Diadem',4,20,NULL,300,NULL,3,NULL,0,0xFFFFFFFF,7,2,256,NULL,70,1,566,'bonus bDex,2; bonus2 bSubEle,Ele_Fire,5; if(getrefine()>6) { bonus bFlee,10; bonus bAspdRate,3; autobonus "{ bonus bSplashRange,1; }",10,10000,BF_WEAPON,"{ specialeffect2 EF_ENHANCE; }"; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (5590,'K_Poring_Cake_Cap','Poring Cake Hat',4,20,NULL,200,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,417,NULL,NULL,NULL);
#REPLACE INTO `item_db` VALUES (5591,'Desert_Prince','Desert Prince',4,20,NULL,100,NULL,1,NULL,1,0xFFFFFFFF,7,2,256,NULL,30,0,567,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5592,'Sigrun\'s_Wing','Sigrun\'s Wings',4,20,NULL,100,NULL,2,NULL,0,0xFFFFFFFF,7,2,512,NULL,80,0,568,'if(BaseClass==Job_Swordman||BaseClass==Job_Merchant||BaseClass==Job_Thief||(BaseJob==Job_Taekwon&&Class!=Job_Soul_Linker)) bonus bStr,1; else if(BaseClass==Job_Mage||BaseClass==Job_Acolyte||class==Job_Ninja||class==Job_Soul_Linker) bonus bInt,1; else if(BaseClass==Job_Archer||BaseClass==Job_Gunslinger) bonus bDex,1; else if(BaseJob==Job_Novice||BaseJob==Job_SuperNovice) { bonus bMaxHP,80; bonus bMaxSP,30; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (5593,'K_Rabbit_Bonnet','Rabbit Bonnet',4,20,NULL,200,NULL,1,NULL,1,0xFFFFFFFF,7,2,768,NULL,1,1,549,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5594,'Donut_In_Mouth','Donut In Mouth',4,20,NULL,50,NULL,1,NULL,0,0xFFFFFFFF,7,2,1,NULL,1,0,569,NULL,NULL,NULL);
#REPLACE INTO `item_db` VALUES (5595,'Eye_Of_Juno','Eye Of Juno',4,20,NULL,400,NULL,2,NULL,1,0xFFFFFFFF,7,2,256,NULL,1,1,570,'bonus bMdef,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5596,'4Leaf_Clover_In_Mouth','4Leaf Clover In Mouth',4,20,NULL,0,NULL,2,NULL,0,0xFFFFFFFF,7,2,1,NULL,1,0,571,'bonus bMdef,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5597,'Bubble_Gum_In_Mouth','Bubble Gum In Mouth',4,20,NULL,0,NULL,2,NULL,0,0xFFFFFFFF,7,2,1,NULL,1,0,572,'bonus bMdef,2;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5598,'Virgo_Crown','Virgo Crown',4,20,NULL,300,NULL,3,NULL,1,0xFFFFFFFF,7,2,256,NULL,70,1,573,'bonus bDex,2; bonus bAspdRate,1; if(getrefine()>6) { bonus2 bSubEle,Ele_Earth,5; autobonus "{ bonus bDex,20; }",10,6000,BF_WEAPON,"{ specialeffect2 EF_ENHANCE; }"; }',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5599,'Virgo_Diadem','Virgo Diadem',4,20,NULL,300,NULL,3,NULL,1,0xFFFFFFFF,7,2,256,NULL,70,1,574,'bonus bAspdRate,3; bonus2 bSubEle,Ele_Earth,5; if(getrefine()>6) bonus3 bAutoSpell,"MO_BALKYOUNG",1,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5600,'Br_Twin_Ribbon','Brazil Twin Ribbon',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,1,1,575,'bonus bAllStats,3; bonus bMdef,1;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5601,'Br_Beret','Brazil Beret',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,1,1,576,'bonus bAllStats,3; bonus bMdef,1;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5602,'Jaguar_Hat_J','Jaguar Hat J',4,20,NULL,300,NULL,0,NULL,1,0xFFFFFFFF,7,2,513,NULL,50,0,530,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5603,'RTC_Winner_Only','RTC First Place',4,0,NULL,250,NULL,8,NULL,1,0xFFFFFFFF,7,2,256,NULL,1,1,577,'bonus bAllStats, 3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5604,'RTC_Second_Best','RTC Second Place',4,0,NULL,250,NULL,6,NULL,1,0xFFFFFFFF,7,2,256,NULL,1,1,578,'bonus bAllStats, 2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5605,'RTC_Third_Best','RTC Third Place',4,0,NULL,250,NULL,4,NULL,1,0xFFFFFFFF,7,2,256,NULL,1,1,579,'bonus bAllStats, 1;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5606,'Campume_Hat','Champune Hat',4,500,NULL,1200,NULL,4,NULL,1,0xFFFFFFFF,7,2,256,NULL,3,1,580,'bonus bAllStats,1;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5607,'Lyria_Doll_Hat','Lyria Doll Hat',4,0,NULL,500,NULL,0,NULL,1,0xFFFFFFFF,7,2,256,NULL,60,0,581,NULL,NULL,NULL);
#REPLACE INTO `item_db` VALUES (5608,'Dorothy_Doll_Hat','Dorothy Doll Hat',4,0,NULL,500,NULL,0,NULL,1,0xFFFFFFFF,7,2,256,NULL,60,0,582,NULL,NULL,NULL);
#REPLACE INTO `item_db` VALUES (5609,'Chung_Hairband','Chung Hairband',4,0,NULL,500,NULL,5,NULL,1,0xFFFFFFFF,7,2,256,NULL,60,0,583,'bonus bLuk,3; bonus bMdef,4;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5610,'Ice_Wing_Ear','Ice Wing Ear',4,0,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,512,NULL,10,0,584,'bonus bLuk,1;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5611,'Turtle_Hat','Turtle_Hat',4,0,NULL,300,NULL,0,NULL,0,0xFFFFFFFF,7,2,256,NULL,10,1,585,'bonus bAgi,1;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5612,'F_Blue_Drooping_Kitty','F Blue Drooping Kitty',4,250000,NULL,500,NULL,1,NULL,0,0xFFFFFFFE,7,2,256,NULL,0,1,277,'bonus bMdef,15;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5613,'F_Flying_Angel','F Flying Angel',4,20,NULL,300,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,10,1,264,'bonus bInt,1; bonus bAgi,1;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5614,'F_Smoking_Pipe_','F Smoking Pipe',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFE,7,2,1,NULL,0,0,55,'bonus bVit,1;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5615,'F_Pair_Of_Red_Ribbon_','F Pair Of Red Ribbon',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,7,2,512,NULL,45,0,169,NULL,NULL,NULL);
#REPLACE INTO `item_db` VALUES (5616,'F_Fish_On_Head_','F Fish On Head',4,20,NULL,500,NULL,2,NULL,0,0xFFFFFFFF,7,2,256,NULL,50,1,149,'bonus bDex,1; bonus bAgi,1;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5617,'F_Hibiscus','F Hibiscus',4,20,NULL,200,NULL,0,NULL,0,0xFFFFFFFF,7,2,256,NULL,10,0,210,'bonus bInt,1; bonus bDex,1; bonus bMdef,5;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5618,'F_Cat_Hat','F Cat Hat',4,20,NULL,300,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,182,'bonus bLuk,2; bonus bMdef,10;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5619,'F_Bunny_Band_','F Bunny Band',4,20,NULL,100,NULL,2,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,15,'bonus bInt,2;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5620,'F_Magestic_Goat_TW','F Magestic Goat TW',4,20,NULL,800,NULL,5,NULL,0,0x006444A2,7,2,256,NULL,0,1,41,'bonus bStr,2;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5621,'F_Sheep_Hat','F Sheep Hat',4,20,NULL,150,NULL,1,NULL,0,0x00008110,7,2,256,NULL,0,0,205,NULL,NULL,NULL);
#REPLACE INTO `item_db` VALUES (5622,'F_Mini_Propeller_','F Mini Propeller',4,20,NULL,200,NULL,2,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,270,'bonus bDex,1; bonus bAgi,2;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5623,'F_Alice_Doll','F Alice Doll',4,20,NULL,500,NULL,0,NULL,1,0xFFFFFFFE,7,2,256,NULL,30,0,208,'bonus bStr,1;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5624,'F_Red_Glasses','F Red Glasses',4,20,NULL,0,NULL,1,NULL,0,0xFFFFFFFF,7,2,512,NULL,0,0,316,'bonus bInt,1;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5625,'F_Chick_Hat','F Chick Hat',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,10,0,311,'bonus bLuk,2;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5626,'F_White_Deviruchi_Cap','F White Deviruchi Cap',4,20,NULL,800,NULL,2,NULL,0,0xFFFFFFFE,7,2,256,NULL,64,1,272,'bonus bStr,1; bonus bInt,1;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5627,'F_Vane_Hairpin','F Vane Hairpin',4,20,NULL,300,NULL,2,NULL,1,0xFFFFFFFF,7,2,256,NULL,30,0,313,'bonus bAgi,2;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5628,'F_Pecopeco_Hairband','F Pecopeco Hairband',4,20,NULL,0,NULL,3,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,0,314,NULL,NULL,NULL);
#REPLACE INTO `item_db` VALUES (5629,'F_Vacation_Hat','F Vacation Hat',4,20,NULL,200,NULL,1,NULL,1,0xFFFFFFFF,7,2,256,NULL,30,0,315,'bonus bVit,1;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5630,'F_Charming_Ribbon','F Charming Ribbon',4,20,NULL,400,NULL,1,NULL,1,0xFFFFFFFF,7,2,256,NULL,10,1,211,NULL,NULL,NULL);
#REPLACE INTO `item_db` VALUES (5631,'F_Water_Lily_Crown','F Water Lily Crown',4,20,NULL,200,NULL,0,NULL,1,0xFFFFFFFF,7,2,256,NULL,30,0,312,'bonus bDex,1; bonus bAgi,1; bonus bMdef,3;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5632,'F_Vanilmirth_Hat','F Vanilmirth Hat',4,20,NULL,1000,NULL,0,NULL,0,0xFFFFFFFF,7,2,256,NULL,30,0,317,'bonus bMdef,5;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5633,'F_Drooping_Bunny_','F Drooping Bunny',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,249,'bonus bDex,1;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5634,'F_Kettle_Hat','F Kettle Hat',4,20,NULL,600,NULL,4,NULL,0,0xFFFFFFFF,7,2,256,NULL,30,1,318,NULL,NULL,NULL);
#REPLACE INTO `item_db` VALUES (5635,'F_Dragon_Skull','F Dragon Skull',4,20,NULL,800,NULL,5,NULL,0,0xFFFFFFFF,7,2,256,NULL,50,1,319,NULL,NULL,NULL);
#REPLACE INTO `item_db` VALUES (5636,'F_Ramen_Hat','F Ramen Hat',4,20,NULL,0,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,0,320,'bonus bDex,4;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5637,'F_Pink_Fur_Hat','F Pink Fur Hat',4,20,NULL,350,NULL,2,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,281,'bonus bLuk,1;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5638,'F_Puppy_Hat','F Puppy Hat',4,20,NULL,500,NULL,2,NULL,0,0xFFFFFFFF,7,2,256,NULL,30,0,234,'bonus bAgi,1;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5639,'F_Magic_Eyes','F Magic Eyes',4,20,NULL,300,NULL,1,NULL,0,0x00810204,7,2,256,NULL,30,1,209,'bonus bMdef,5;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5640,'F_Jumping_Poring','F Jumping Poring',4,0,NULL,300,NULL,2,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,0,349,'bonus bLuk,1;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5641,'F_Robo_Eye','F Robo Eye',4,20,NULL,200,NULL,1,NULL,0,0xFFFFFFFF,7,2,512,NULL,10,0,345,'bonus bDex,1;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5642,'F_Yellow_Wizardry_Hat','F Yellow Wizardry Hat',4,20,NULL,300,NULL,1,NULL,0,0x00810204,7,2,256,NULL,0,1,286,'bonus bInt,2;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5643,'F_Crescent_Helm','F Crescent Helm',4,20,NULL,3000,NULL,8,NULL,0,0x000444A2,7,2,768,NULL,50,1,213,'bonus bVit,1;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5644,'F_Tiger_Mask','F Tiger Mask',4,20,NULL,400,NULL,2,NULL,0,0xFFFFFFFF,7,2,768,NULL,50,0,181,'bonus bStr,3;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5645,'F_Fantastic_Wig','F Fantastic Wig',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,7,2,768,NULL,0,1,308,NULL,NULL,NULL);
#REPLACE INTO `item_db` VALUES (5646,'F_Whisper_Mask','F Whisper Mask',4,20,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,7,2,769,NULL,0,0,321,'bonus bAgi,3;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5647,'F_Bunny_Band_C','F Bunny Band C',4,1,NULL,0,NULL,9,NULL,0,0xFFFFFFFF,7,2,256,NULL,1,0,15,'bonus bMdef,5;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5648,'F_Centimental_Flower_C','F Centimental Flower C',4,1,NULL,0,NULL,1,NULL,0,0xFFFFFFFE,7,2,1,NULL,1,0,56,NULL,NULL,NULL);
#REPLACE INTO `item_db` VALUES (5649,'F_Apple_Of_Archer_C','F Apple Of Archer C',4,1,NULL,0,NULL,7,NULL,0,0xFFFFFFFE,7,2,256,NULL,1,0,72,'bonus bDex,4;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5650,'F_Elven_Ears_C','F Elven Ears C',4,1,NULL,0,NULL,2,NULL,0,0xFFFFFFFE,7,2,512,NULL,1,0,73,'bonus bInt,1;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5651,'F_Brooch_C','F Brooch C',4,1,NULL,0,NULL,0,NULL,0,0xFFFFFFFE,7,2,136,NULL,1,0,0,'bonus bAgi,4;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5652,'F_Magestic_Goat_C','F Magestic Goat C',4,2,NULL,0,NULL,5,NULL,0,0xFFFFFFFE,7,2,256,NULL,0,0,41,'bonus bStr,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5653,'Darkness_Helm_J','Darkness Helm',4,20,NULL,500,NULL,3,NULL,1,0xFFFFFFFF,7,2,256,NULL,70,1,586,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5654,'Holy_Marching_Hat_J','Holy Marching Hat',4,20,NULL,200,NULL,2,NULL,1,0xFFFFFFFF,7,2,256,NULL,10,1,587,'bonus bStr,2; bonus3 bAutoSpell,"PR_ASPERSIO",2,30;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5655,'Dark_Snake_Lord_Hat_J','Evil Snake Lord Hat',4,20,NULL,500,NULL,2,NULL,0,0xFFFFFFFF,7,2,256,NULL,60,1,372,'bonus bInt,2; bonus bAgi,2; bonus bDex,-2; autobonus "{ bonus bCastrate,-50; bonus bFlee,30; }",50,5000,BF_MAGIC,"{ specialeffect2 EF_SUFFRAGIUM; }";',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5656,'Scooter_Hat_J','Scooter Helmet',4,20,NULL,1000,NULL,7,NULL,1,0xFFFFFFFF,7,2,256,NULL,50,1,588,'bonus bUnbreakableHelm;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5657,'Antique_Pipe_J','Captain\'s Pipe',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,1,NULL,30,0,383,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5658,'Imp_Hat','Imp Hat',4,20,NULL,400,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,1,1,589,'bonus3 bAutoSpell,"SA_FLAMELAUNCHER",1,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5659,'Sleepr_Hat','Sleeper Hat',4,20,NULL,400,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,1,1,590,'bonus3 bAutoSpell,"SA_SEISMICWEAPON",1,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5660,'Gryphon_Hat','Gryphon Hat',4,20,NULL,400,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,1,1,591,'bonus3 bAutoSpell,"SA_LIGHTNINGLOADER",1,5;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5661,'Red_Pirate_Bandana','Red Pirate Banada',4,0,NULL,0,NULL,3,NULL,0,0xFFFFFFFF,7,2,256,NULL,10,1,592,'bonus bStr,1; bonus bDex,1; bonus bAspdRate,2; bonus bCastRate,-2; bonus3 bAutoSpell,"MO_EXTREMITYFIST",1,30;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5662,'Libra_Crown','Libra Crown',4,10,NULL,300,NULL,3,NULL,0,0xFFFFFFFF,7,2,256,NULL,1,1,593,'bonus bDex,3;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5663,'Libra_Diadem','Libra Diadem',4,10,NULL,300,NULL,3,NULL,0,0xFFFFFFFF,7,2,256,NULL,1,1,594,'bonus bDex,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5664,'Filir_Wing','Filir\'s Pinions',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,7,2,512,NULL,70,1,595,'bonus bAspdRate,2; bonus bCastRate,-2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5665,'Shaman_Hat','Shaman Hat',4,20,NULL,400,NULL,1,NULL,1,0xFFFFFFFF,7,2,256,NULL,1,1,596,'bonus2 bSubEle,Ele_Neutral,3; bonus2 bSubEle,Ele_Water,3; bonus2 bSubEle,Ele_Earth,3; bonus2 bSubEle,Ele_Fire,3; bonus2 bSubEle,Ele_Wind,3; bonus2 bSubEle,Ele_Poison,3; bonus2 bSubEle,Ele_Holy,3; bonus2 bSubEle,Ele_Dark,3; bonus2 bSubEle,Ele_Ghost,3; bonus2 bSubEle,Ele_Undead,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5666,'Golden_Crown','Golden Crown',4,20,NULL,500,NULL,8,NULL,1,0xFFFFFFFF,7,2,256,NULL,1,1,597,'bonus bInt,1; bonus bDex,1; bonus bLuk,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5667,'Skull_Hood','Skull Hood',4,20,NULL,100,NULL,1,NULL,1,0xFFFFFFFF,7,2,768,NULL,30,1,598,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5668,'Weird_Pumpkin_Hat','Weird Pumpkin Hat',4,20,NULL,0,NULL,5,NULL,0,0xFFFFFFFF,7,2,256,NULL,1,1,206,'bonus bMdef,5;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5669,'Poring_Party_Hat_J','Poring Party Hat J',4,20,NULL,300,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,1,1,340,NULL,NULL,NULL);
#REPLACE INTO `item_db` VALUES (5670,'Aniv_Star_Hat','Aniv Star Hat',4,20,NULL,300,NULL,0,NULL,0,0xFFFFFFFF,7,2,256,NULL,1,1,599,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5671,'Drooping_Morocc_Minion','Drooping Morocc Minion',4,20,NULL,300,NULL,0,NULL,1,0xFFFFFFFF,7,2,256,NULL,70,0,600,NULL,NULL,NULL);
#REPLACE INTO `item_db` VALUES (5672,'Southern_Cross','Southern Cross',4,20,NULL,600,NULL,3,NULL,1,0xFFFFFFFF,7,2,256,NULL,50,1,601,'bonus bInt,1;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5673,'Home_Cherry_Blossom','Home Cherry Blossom',4,20,NULL,100,NULL,2,NULL,1,0xFFFFFFFF,7,2,256,NULL,30,1,602,NULL,NULL,NULL);
#REPLACE INTO `item_db` VALUES (5674,'Pig_Moneybox','Pig Moneybox',4,20,NULL,1000,NULL,3,NULL,0,0xFFFFFFFF,7,2,256,NULL,10,0,603,NULL,NULL,NULL);
#REPLACE INTO `item_db` VALUES (5675,'Poring_Letter','Poring Letter',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,1,NULL,10,0,604,NULL,NULL,NULL);
#REPLACE INTO `item_db` VALUES (5676,'Scorpio_Crown','Scorpio Crown',4,20,NULL,300,NULL,3,NULL,0,0xFFFFFFFF,7,2,256,NULL,1,1,605,NULL,NULL,NULL);
#REPLACE INTO `item_db` VALUES (5677,'Scorpio_Diadem','Scorpio Diadem',4,20,NULL,300,NULL,3,NULL,1,0xFFFFFFFF,7,2,256,NULL,1,1,606,'bonus bDex,2;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5678,'Notation_Hairband','Notation Hairband',4,200,NULL,100,NULL,5,NULL,0,0xFFFFFFFF,7,2,256,NULL,1,1,607,NULL,NULL,NULL);
#REPLACE INTO `item_db` VALUES (5679,'Engineer_Cap','Engineer Cap',4,20,NULL,200,NULL,2,NULL,1,0xFFFFFFFF,7,2,256,NULL,10,1,608,NULL,NULL,NULL);
#REPLACE INTO `item_db` VALUES (5680,'Hawkeyes','Hawkeyes',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,512,NULL,10,0,609,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5681,'F_Ribbon_Green','Green Ribbon',4,800,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,7,0,256,NULL,0,1,244,'bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5682,'Triangle_Rune_Cap','Triangle Rune Cap',4,20,NULL,300,NULL,5,NULL,1,0xFFFFFFFF,7,2,256,NULL,1,1,610,'bonus bHealPower,2; if (getrefine() > 6) { bonus bMatk,10; bonus5 bAutoSpellWhenHit,"NPC_MAGICMIRROR",8,150,BF_MAGIC,0; } else { bonus5 bAutoSpellWhenHit,"NPC_MAGICMIRROR",7,150,BF_MAGIC,0; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (5683,'Majestic_Goat_Repl','Baphomet Horns',4,20,NULL,100,NULL,5,NULL,0,0xFFFFFFFF,7,2,256,NULL,1,1,41,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5684,'Jewel_Crown_Repl','Ornate Crown',4,20,NULL,100,NULL,5,NULL,0,0xFFFFFFFF,7,2,256,NULL,1,1,88,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5685,'Prontera_Army_Cap_Repl','Army Cap',4,20,NULL,100,NULL,5,NULL,0,0xFFFFFFFF,7,2,256,NULL,1,1,48,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5686,'Feather_Bonnet_Repl','Nice Hat Feather',4,20,NULL,100,NULL,5,NULL,0,0xFFFFFFFF,7,2,256,NULL,1,1,104,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5687,'Viking_Helm_Repl','Orc Helm',4,20,NULL,100,NULL,5,NULL,0,0xFFFFFFFF,7,2,256,NULL,1,1,86,NULL,NULL,NULL);
#REPLACE INTO `item_db` VALUES (5688,'2009_Love_Dad','2009 Love Dad',4,20,NULL,100,NULL,3,NULL,0,0xFFFFFFFF,7,2,256,NULL,1,1,611,'bonus bVit,2;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5689,'Queen_Ant_Diadem','Queen Ant Diadem',4,20,NULL,300,NULL,1,NULL,1,0xFFFFFFFF,7,2,256,NULL,75,1,612,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5690,'Red_Wing_Hat','Red Wing Hat',4,20,NULL,600,NULL,2,NULL,1,0xFFFFFFFF,7,2,256,NULL,50,1,613,'if(getrefine()>6) { bonus2 bAddClass,Class_All,2; bonus bMatkRate,2; } if(getrefine()>8) { bonus2 bAddClass,Class_All,2; bonus bMatkRate,2; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (5691,'Catain_Bandanna','Sailor\'s Bandana',4,20,NULL,10,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,1,1,542,'bonus bDex,1; bonus2 bSubEle,Ele_Poison,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5692,'Sea_Cat_Hat','Sea Cat Hat',4,20,NULL,10,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,1,1,539,'bonus bDex,1;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5693,'No_Fear_Underware','No Fear Underwear',4,0,NULL,0,NULL,10,NULL,0,0xFFFFFFFF,7,2,256,NULL,20,0,30,'bonus bStr,1; bonus bInt,1; bonus bDex,1;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5694,'No_Fear_P_Headgear','No Fear P Headgear',4,0,NULL,0,NULL,1,NULL,1,0xFFFFFFFE,7,2,256,NULL,20,0,614,'bonus bVit,1;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5695,'E_Blue_Drooping_Kitty','E Blue Drooping Kitty',4,250000,NULL,500,NULL,1,NULL,0,0,7,2,256,NULL,0,1,277,'bonus bMdef,15;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5696,'E_Flying_Angel','E Flying Angel',4,20,NULL,300,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,10,1,264,'bonus bInt,1; bonus bAgi,1;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5697,'E_Smoking_Pipe_','E Smoking Pipe',4,20,NULL,100,NULL,0,NULL,0,0,7,2,1,NULL,0,0,55,'bonus bVit,1;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5698,'E_Pair_OE_Red_Ribbon_','E Pair OE Red Ribbon',4,20,NULL,100,NULL,1,NULL,0,0,7,2,512,NULL,45,0,169,NULL,NULL,NULL);
#REPLACE INTO `item_db` VALUES (5699,'E_Fish_On_Head_','E Fish On Head',4,20,NULL,500,NULL,2,NULL,0,0xFFFFFFFF,7,2,256,NULL,50,1,149,'bonus bDex,1; bonus bAgi,1;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5700,'E_Hibiscus','E Hibiscus',4,20,NULL,200,NULL,0,NULL,0,0xFFFFFFFF,7,2,256,NULL,10,0,210,'bonus bInt,1; bonus bDex,1; bonus bMdef,5;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5701,'E_Cat_Hat','E Cat Hat',4,20,NULL,300,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,182,'bonus bLuk,2; bonus bMdef,10;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5702,'E_Bunny_Band_','E Bunny Band',4,20,NULL,100,NULL,2,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,15,'bonus bInt,2;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5703,'E_Magestic_Goat_TW','E Magestic Goat TW',4,20,NULL,800,NULL,5,NULL,0,0x006444A2,7,2,256,NULL,0,1,41,'bonus bStr,2;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5704,'E_Sheep_Hat','E Sheep Hat',4,20,NULL,150,NULL,1,NULL,0,0x00008110,7,2,256,NULL,0,0,205,NULL,NULL,NULL);
#REPLACE INTO `item_db` VALUES (5705,'E_Mini_Propeller_','E Mini Propeller',4,20,NULL,200,NULL,2,NULL,0,0,7,2,256,NULL,0,1,270,'bonus bDex,1; bonus bAgi,2;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5706,'E_Alice_Doll','E Alice Doll',4,20,NULL,500,NULL,0,NULL,1,0xFFFFFFFE,7,2,256,NULL,30,0,208,'bonus bStr,1;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5707,'E_Red_Glasses','E Red Glasses',4,20,NULL,0,NULL,1,NULL,0,0xFFFFFFFF,7,2,512,NULL,0,0,316,'bonus bInt,1;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5708,'E_Chick_Hat','E Chick Hat',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,10,0,311,'bonus bLuk,2;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5709,'E_White_Deviruchi_Cap','E White Deviruchi Cap',4,20,NULL,800,NULL,2,NULL,0,0xFFFFFFFE,7,2,256,NULL,64,1,272,'bonus bStr,1; bonus bInt,1;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5710,'E_Vane_Hairpin','E Vane Hairpin',4,20,NULL,300,NULL,2,NULL,1,0xFFFFFFFF,7,2,256,NULL,30,0,313,'bonus bAgi,2;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5711,'E_Pecopeco_Hairband','E Pecopeco Hairband',4,20,NULL,0,NULL,3,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,0,314,NULL,NULL,NULL);
#REPLACE INTO `item_db` VALUES (5712,'E_Vacation_Hat','E Vacation Hat',4,20,NULL,200,NULL,1,NULL,1,0xFFFFFFFF,7,2,256,NULL,30,0,315,'bonus bVit,1;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5713,'E_Charming_Ribbon','E Charming Ribbon',4,20,NULL,400,NULL,1,NULL,1,0xFFFFFFFF,7,2,256,NULL,10,1,211,NULL,NULL,NULL);
#REPLACE INTO `item_db` VALUES (5714,'E_Water_Lily_Crown','E Water Lily Crown',4,20,NULL,200,NULL,0,NULL,1,0,7,2,256,NULL,30,0,312,'bonus bDex,1; bonus bAgi,1; bonus bMdef,3;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5715,'E_Vanilmirth_Hat','E Vanilmirth Hat',4,20,NULL,1000,NULL,0,NULL,0,0xFFFFFFFF,7,2,256,NULL,30,0,317,'bonus bMdef,5;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5716,'E_Drooping_Bunny_','E Drooping Bunny',4,20,NULL,100,NULL,1,NULL,0,0,7,2,256,NULL,0,1,249,'bonus bDex,1;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5717,'E_Kettle_Hat','E Kettle Hat',4,20,NULL,600,NULL,4,NULL,0,0xFFFFFFFF,7,2,256,NULL,30,1,318,NULL,NULL,NULL);
#REPLACE INTO `item_db` VALUES (5718,'E_Dragon_Skull','E Dragon Skull',4,20,NULL,800,NULL,5,NULL,0,0xFFFFFFFF,7,2,256,NULL,50,1,319,NULL,NULL,NULL);
#REPLACE INTO `item_db` VALUES (5719,'E_Ramen_Hat','E Ramen Hat',4,20,NULL,0,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,0,320,'bonus bDex,4;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5720,'E_Pink_Fur_Hat','E Pink Fur Hat',4,20,NULL,350,NULL,2,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,281,'bonus bLuk,1;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5721,'E_Puppy_Hat','E Puppy Hat',4,20,NULL,500,NULL,2,NULL,0,0xFFFFFFFF,7,2,256,NULL,30,0,234,'bonus bAgi,1;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5722,'E_Magic_Eyes','E Magic Eyes',4,20,NULL,300,NULL,1,NULL,0,0x00810204,7,2,256,NULL,30,1,209,'bonus bMdef,5;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5723,'E_Jumping_Poring','E Jumping Poring',4,0,NULL,300,NULL,2,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,0,349,'bonus bLuk,1;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5724,'E_Robo_Eye','E Robo Eye',4,20,NULL,200,NULL,1,NULL,0,0xFFFFFFFF,7,2,512,NULL,10,0,345,'bonus bDex,1;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5725,'E_Yellow_Wizardry_Hat','E Yellow Wizardry Hat',4,20,NULL,300,NULL,1,NULL,0,0x00810204,7,2,256,NULL,0,1,286,'bonus bInt,2;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5726,'E_Crescent_Helm','E Crescent Helm',4,20,NULL,3000,NULL,8,NULL,0,0x000444A2,7,2,768,NULL,50,1,213,'bonus bVit,1;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5727,'E_Tiger_Mask','E Tiger Mask',4,20,NULL,400,NULL,2,NULL,0,0xFFFFFFFF,7,2,768,NULL,50,0,181,'bonus bStr,3;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5728,'E_Fantastic_Wig','E Fantastic Wig',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,7,2,768,NULL,0,1,308,NULL,NULL,NULL);
#REPLACE INTO `item_db` VALUES (5729,'E_Bunny_Band_C','E Bunny Band C',4,1,NULL,0,NULL,9,NULL,0,0xFFFFFFFF,7,2,256,NULL,1,0,15,'bonus bMdef,5;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5730,'E_Centimental_Flower_C','E Centimental Flower C',4,1,NULL,0,NULL,1,NULL,0,0xFFFFFFFE,7,2,1,NULL,1,0,56,NULL,NULL,NULL);
#REPLACE INTO `item_db` VALUES (5731,'E_Apple_OE_Archer_C','E Apple OE Archer C',4,1,NULL,0,NULL,7,NULL,0,0xFFFFFFFE,7,2,256,NULL,1,0,72,'bonus bDex,4;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5732,'E_Elven_Ears_C','E Elven Ears C',4,1,NULL,0,NULL,2,NULL,0,0xFFFFFFFE,7,2,512,NULL,1,0,73,'bonus bInt,1;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5733,'E_Brooch_C','E Brooch C',4,1,NULL,0,NULL,0,NULL,0,0xFFFFFFFE,7,2,136,NULL,1,0,0,'bonus bAgi,4;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5734,'E_Magestic_Goat_C','E Magestic Goat C',4,2,NULL,0,NULL,5,NULL,0,0xFFFFFFFE,7,2,256,NULL,0,0,41,'bonus bStr,1;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5735,'E_Ribbon_Green','Green Ribbon',4,800,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,7,0,256,NULL,0,1,244,'bonus bMdef,3;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5736,'EF_Whisper_Mask','Whisper Mask',4,20,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,7,2,769,NULL,0,0,321,'bonus bAgi,3; bonus2 bSubEle,Ele_Ghost,-10;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5737,'Cactus_Hat','Cactus Hat',4,20,NULL,300,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,1,0,615,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5738,'Snowman_Hat','Snowman Hat',4,20,NULL,300,NULL,4,NULL,1,0xFFFFFFFF,7,2,256,NULL,1,1,616,'bonus bStr,1; bonus bInt,1; bonus bMdef,3; bonus2 bSubEle,Ele_Water,7; bonus2 bAddMonsterDropItem,530,100; bonus2 bAddMonsterDropItem,12354,300; if(getrefine()>7) { bonus5 bAutoSpellwhenhit,"BA_FROSTJOKER",5,20,BF_WEAPON|BF_MAGIC,0; } else { bonus5 bAutoSpellwhenhit,"BA_FROSTJOKER",1,20,BF_WEAPON|BF_MAGIC,0; }',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5739,'Sagittarius_Crown','Sagittarius Crown',4,20,NULL,300,NULL,3,NULL,0,0xFFFFFFFF,7,2,256,NULL,1,1,617,'bonus bDex,2;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5740,'Sagittarius_Diadem','Sagittarius Diadem',4,20,NULL,300,NULL,3,NULL,0,0xFFFFFFFF,7,2,256,NULL,1,1,618,'bonus bDex,2; bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5741,'Im_Egg_Shell_Hat','Eternal Egg Shell',4,20,NULL,0,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,10,1,101,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5742,'Rudolf_Santa_Hat','Rudolph Santa Hat',4,20,NULL,400,NULL,5,NULL,0,0xFFFFFFFF,7,2,256,NULL,10,1,619,'bonus bLuk,1;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5743,'Orange_Stem_Hat','Orange Stem Hat',4,20,NULL,100,NULL,0,NULL,0,0x00000000,7,2,256,NULL,1,0,620,'bonus bLuk,3;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5744,'Capricon_Crown','Capricon Crown',4,20,NULL,300,NULL,3,NULL,1,0xFFFFFFFF,7,2,256,NULL,1,1,621,'bonus bVit,2; bonus bDex,2;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5745,'Capricon_Diadem','Capricon Diadem',4,20,NULL,300,NULL,3,NULL,0,0xFFFFFFFF,7,2,256,NULL,1,1,622,'bonus bDex,2; bonus bMdef,5;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5746,'Rune_Circlet','Rune Circlet',4,20,NULL,100,NULL,12,NULL,1,0x00000080,8,2,256,NULL,100,1,623,'bonus bStr,1; bonus bInt,1; bonus bMdef,5; if(readparam(bStr)>=120){ bonus bBaseAtk,10; bonus bMatk,5; }',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5747,'Mitra','Mitra',4,20,NULL,100,NULL,12,NULL,1,0x00000100,8,2,256,NULL,100,1,624,'bonus bVit,1; bonus bInt,1; bonus bMdef,5; bonus bHealPower,5; if(readparam(bInt)>=120){ bonus bMatk,10; }',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5748,'Sniper_Goggles','Sniper Goggles',4,20,NULL,100,NULL,12,NULL,1,0x00000800,8,2,768,NULL,100,1,625,'bonus bAgi,1; bonus bDex,1; bonus bMdef,5; if(readparam(bAgi)>=120){ bonus bLongAtkRate,4; bonus bAspd,1; }',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5749,'Driver_Band_M','Driver Band',4,20,NULL,100,NULL,12,NULL,1,0x00000400,8,1,256,NULL,100,1,626,'bonus bStr,1; bonus bDex,1; bonus bMdef,5; if(readparam(bStr)>=120){ bonus bBaseAtk,10; bonus bCritical,3; }',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5750,'Shadow_Crown','Shadow Crown',4,20,NULL,100,NULL,12,NULL,1,0x00020000,8,2,256,NULL,100,1,627,'bonus bAgi,1; bonus bInt,1; bonus bMdef,1; if(readparam(bAgi)>=120){ bonus bBaseAtk,10; bonus bFlee,3; }',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5751,'Minstrel_Song_Hat','Minstrel Song Hat',4,20,NULL,100,NULL,12,NULL,1,0x00080000,8,1,256,NULL,100,1,628,'bonus bInt,1; bonus bLuk,1; bonus bMdef,5; bonus bLongAtkRate,4; bonus bUseSPrate,-10;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5752,'Midas_Whispers','Midas Whispers',4,20,NULL,100,NULL,12,NULL,1,0x00040000,8,2,256,NULL,100,1,629,'bonus bStr,1; bonus bDex,1; bonus bMdef,5; if(readparam(bStr)>=120){ bonus bBaseAtk,5; bonus bAspd,1; }',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5753,'Magic_Stone_Hat','Magic Stone Hat',4,20,NULL,100,NULL,12,NULL,1,0x00000200,8,2,256,NULL,100,1,630,'bonus bInt,1; bonus bDex,1; bonus bMdef,5; if(readparam(bDex)>=120){ bonus bMatkRate,10; bonus bCastrate,-2; }',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5754,'Burning_Spirit','Burning Spirit',4,20,NULL,100,NULL,12,NULL,1,0x00008000,8,2,256,NULL,100,1,631,'bonus bStr,1; bonus bVit,1; bonus bMdef,5; if(readparam(bStr)>=120){ bonus bBaseAtk,10; bonus bHit,3; }',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5755,'Silent_Enforcer','Silent Enforcer',4,20,NULL,100,NULL,12,NULL,0,0x00001000,8,2,513,NULL,100,1,632,'bonus bAgi,1; bonus bMdef,5; if(readparam(bAgi)>=120){ bonus bBaseAtk,10; bonus bFlee2,5; }',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5756,'Wispers_of_Wind','Wispers of Wind',4,20,NULL,100,NULL,12,NULL,1,0x00010000,8,2,256,NULL,100,1,633,'bonus bInt,1; bonus bDex,1; bonus bMdef,5; if(readparam(bInt)>=120){ bonus bMatkRate,10; bonus bFlee,3; }',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5757,'Reissue_Schmitz_Helm','Reissue Schmitz Helm',4,20,NULL,100,NULL,12,NULL,1,0x00004000,8,2,768,NULL,100,1,634,'bonus bVit,2; bonus bInt,1; bonus bMdef,5; if(readparam(bInt)>=120){ bonus bMatkRate,10; bonus bDef,5; }',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5758,'Resting_Swan','Resting Swan',4,20,NULL,100,NULL,17,NULL,1,0x00080000,8,0,256,NULL,100,1,635,'bonus bInt,1; bonus bLuk,1; bonus bMdef,5; bonus bAtkRate,5; bonus bUseSPrate,-10;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5759,'Noah_Hat','Noah Hat',4,20,NULL,500,NULL,1,NULL,1,0xFFFFFFFF,7,2,256,NULL,1,1,636,'bonus bMdef,3;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5760,'Driver_Band_F','Driver Band',4,20,NULL,100,NULL,12,NULL,1,0x00000400,8,0,256,NULL,100,1,637,'bonus bStr,1; bonus bDex,1; bonus bMdef,5; if(readparam(bStr)>=120){ bonus bBaseAtk,10; bonus bCritical,3; }',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5761,'Sloth_Hat','Sloth Hat',4,20,NULL,800,NULL,3,NULL,1,0xFFFFFFFF,7,2,256,NULL,1,1,638,'bonus bAgi,2; bonus3 bAutoSpell,"AS_SONICBLOW",5,50;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5762,'Duneyrr_Helm','Duneyrr Helm',4,20,NULL,100,NULL,5,NULL,0,0xFFFFFFFF,7,2,256,NULL,1,1,639,'bonus bAllStats,1; bonus bMdef,5;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5763,'Red_Bunny_Band','Red Bunny Band',4,0,NULL,200,NULL,4,NULL,0,0xFFFFFFFF,7,2,256,NULL,1,1,640,'bonus bAgi,2; bonus bMdef,3;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5765,'Black_Tail_Ribbon','Black Tail Ribbon',4,20,NULL,100,NULL,0,NULL,1,0xFFFFFFFF,7,2,256,NULL,10,1,642,'bonus bMdef,5;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5766,'Amistr_Cap','Amistr Cap',4,20,NULL,500,NULL,4,NULL,0,0xFFFFFFFF,7,2,256,NULL,50,1,643,'bonus bVit,5;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5767,'Samurai_Mask','Samurai Mask',4,20,NULL,300,NULL,1,NULL,0,0xFFFFFFFF,7,2,1,NULL,50,0,644,NULL,NULL,NULL);
#REPLACE INTO `item_db` VALUES (5768,'Sakura_Coronet','Sakura Coronet',4,20,NULL,800,NULL,1,NULL,1,0xFFFFFFFF,7,2,256,NULL,1,1,645,'bonus bMdef,3;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5769,'Gold_Angel_Sculpture','Gold Angel Sculpture',4,100,NULL,0,NULL,2,NULL,0,0xFFFFFFFF,7,2,256,NULL,70,0,646,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5770,'Splash_Hat','Splash Hat',4,20,NULL,100,NULL,3,NULL,1,0xFFFFFFFF,7,2,256,NULL,1,1,349,'autobonus "{ sc_start SC_WINDWEAPON, 180000, 1; }", 3, 180000, BF_WEAPON, "{ specialeffect2 EF_ENHANCE; }";',NULL,NULL);
REPLACE INTO `item_db` VALUES (5771,'Family_Hat','Family Hat',4,20,NULL,100,NULL,3,NULL,1,0xFFFFFFFF,7,2,256,NULL,1,1,109,'bonus bDex,1; bonus bMdef,1;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5772,'Red_Navy_Hat','Red Navy Hat',4,3000,NULL,500,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,95,1,651,NULL,NULL,NULL);
#REPLACE INTO `item_db` VALUES (5773,'Navy_Beret','Navy Beret',4,3000,NULL,500,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,95,1,652,NULL,NULL,NULL);
#REPLACE INTO `item_db` VALUES (5774,'Red_Pirate_Hat','Red Pirate Hat',4,3000,NULL,500,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,95,1,496,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5775,'Choco_Donut_In_Mouth','Choco Donut In Mouth',4,20,NULL,50,NULL,1,NULL,0,0xFFFFFFFF,7,2,1,NULL,1,0,653,NULL,NULL,NULL);
#REPLACE INTO `item_db` VALUES (5776,'Blazing_Sun','Blazing Sun',4,0,NULL,500,NULL,0,NULL,0,0xFFFFFFFF,7,2,256,NULL,1,1,654,NULL,NULL,NULL);
#REPLACE INTO `item_db` VALUES (5777,'Remover_Hat','Remover Hat',4,20,NULL,800,NULL,2,NULL,0,0xFFFFFFFF,7,2,256,NULL,30,0,655,'bonus bMdef,1;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5778,'Blue_Arara_Hat','Blue Arara Hat',4,20,NULL,100,NULL,3,NULL,1,0xFFFFFFFF,7,2,256,NULL,1,1,656,'bonus bStr,2;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5779,'Drooping_Boto','Drooping Boto',4,20,NULL,100,NULL,3,NULL,1,0xFFFFFFFF,7,2,256,NULL,1,1,657,'bonus bInt,2;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5780,'Tendrilion_Hat','Tendrilion Hat',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,256,NULL,1,1,658,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5781,'Persika','Persika',4,20,NULL,100,NULL,0,NULL,1,0xFFFFFFFF,7,2,256,NULL,0,0,659,NULL,NULL,NULL);
#
#REPLACE INTO `item_db` VALUES (5783,'YellowBunny_Hairband','YellowBunny Hairband',4,20,NULL,200,NULL,0,NULL,1,0xFFFFFFFF,7,2,256,NULL,1,1,662,'bonus bStr,1; bonus bInt,1; bonus bDex,2;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5784,'PinkBunny_Hairband','PinkBunny Hairband',4,20,NULL,200,NULL,0,NULL,1,0xFFFFFFFF,7,2,256,NULL,1,1,663,'bonus bStr,1; bonus bInt,2; bonus bDex,1;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5785,'Green_Bunny_Hairband','Green Bunny Hairband',4,20,NULL,200,NULL,0,NULL,1,0xFFFFFFFF,7,2,256,NULL,1,1,664,'bonus bStr,2; bonus bInt,1; bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5786,'Ancient_Elven_Ear','Ancient Elven Ear',4,10,NULL,200,NULL,1,NULL,0,0xFFFFFFFF,7,2,512,NULL,1,0,665,'bonus bLuk,1;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5787,'Tha_Maero_Mask','Tha Maero Mask',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,513,NULL,30,0,666,'bonus bMdef,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5788,'3D_Glasses','3D Glasses',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,7,2,512,NULL,1,0,661,NULL,NULL,NULL);
#REPLACE INTO `item_db` VALUES (5789,'Thanatos_Mal_Mask','Thanatos Mal Mask',4,20,NULL,100,NULL,3,NULL,0,0xFFFFFFFF,7,2,513,NULL,30,0,667,'bonus bVit,1;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5790,'Holy_Mom_Love','TM',4,20,NULL,500,NULL,0,NULL,1,0xFFFFFFFF,7,2,768,NULL,45,1,610,NULL,NULL,NULL);
#REPLACE INTO `item_db` VALUES (5791,'Tenkaippin_Ramen','Tenkaippin Ramen',4,20,NULL,500,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,30,0,668,'bonus bInt,-1; bonus bDex,4;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5792,'Fish_Pin','Fish Pin',4,20,NULL,100,NULL,3,NULL,0,0xFFFFFFFF,7,2,256,NULL,1,1,669,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5793,'Ribbon_Of_Life','Ribbon Of Life',4,20,NULL,0,NULL,2,NULL,0,0xFFFFFFFF,7,2,512,NULL,1,0,575,'bonus bInt,1; bonus bMdef,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5794,'3D_Glasses_','3D Glasses',4,20,NULL,0,NULL,1,NULL,0,0xFFFFFFFF,7,2,512,NULL,1,0,661,NULL,NULL,NULL);
#REPLACE INTO `item_db` VALUES (5795,'Red_Dress_Hat','Red Dress Hat',4,20,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,7,2,256,NULL,1,1,670,'bonus bMdef,7;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5796,'Cheer_Scarf','Cheer Scarf',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,7,2,1,NULL,1,0,369,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5797,'Cheer_Scarf2','Cheer Scarf2',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,7,2,1,NULL,1,0,369,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5798,'Cheer_Scarf3','Cheer Scarf3',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,7,2,1,NULL,1,0,369,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5799,'Cheer_Scarf4','Cheer Scarf4',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,7,2,1,NULL,1,0,369,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5800,'Blush_Of_Groom','Blush of Groom',4,20,NULL,50,NULL,0,NULL,0,0xFFFFFFFF,7,2,512,NULL,0,0,125,'bonus2 bSubRace,RC_DemiHuman,3; bonus2 bSubRace,RC_Player,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5801,'Ribbon_Of_Bride','Red Tailed Ribbon',4,20,NULL,100,NULL,5,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,167,'bonus bAllStats,2; bonus2 bSubRace,RC_DemiHuman,10; bonus2 bSubRace,RC_Player,10; if(getskilllv("AL_HEAL")==10) { bonus3 bAutoSpellWhenHit,"AL_HEAL",10,20; } else { bonus3 bAutoSpellWhenHit,"AL_HEAL",5,20; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (5802,'Upgrade_Elephant_Hat','Upgraded Elephant Hat',4,0,NULL,500,NULL,3,NULL,1,0xFFFFFFFF,7,2,256,NULL,0,1,215,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5803,'Flower_Love_Hat','Love Flower Hat',4,20,NULL,100,NULL,2,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,5,'bonus2 bAddMonsterDropItem,608,100;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5804,'Pirate_Eyepatch','Pirate Eye Bandage',4,1000,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,7,2,512,NULL,0,0,13,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5805,'Victorious_Coronet','Victorious Coronet',4,0,NULL,150,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,70,0,43,'bonus bMaxHPrate,15; bonus bSPrecovRate,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5806,'Poem_Natalia_Hat','Poet Natalie\'s Hat',4,20,NULL,300,NULL,5,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,0,67,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5807,'October_Fest_Cap','October Fest Cap',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFE,7,2,256,NULL,50,1,104,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5808,'Diabolus_Helmet','Dark Bacilium',4,20,NULL,250,NULL,5,NULL,1,0x000FDF80,2,2,769,NULL,0,1,364,'bonus2 bResEff,Eff_Stone,2000+(getrefine()*200); bonus2 bResEff,Eff_Freeze,2000+(getrefine()*200); bonus2 bResEff,Eff_Stun,2000+(getrefine()*200);',NULL,NULL);
REPLACE INTO `item_db` VALUES (5809,'Boom_Boom_Hat','Boom Boom Hat',4,0,NULL,100,NULL,6,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,0,216,'bonus bAllStats,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5810,'Ph.D_Hat_V','Ph.D Hat V',4,20,NULL,100,NULL,3,NULL,0,0xFFFFFFFE,7,2,256,NULL,0,1,98,'bonus bInt,5; bonus bVit,3; bonus bDex,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5811,'Santa_Beard','Santa\'s Beard',4,20,NULL,100,NULL,5,NULL,0,0xFFFFFFFF,7,2,1,NULL,0,0,25,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5812,'Hat_Of_Expert','Hat Of Expert',4,0,NULL,0,NULL,2,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,16,NULL,NULL,NULL);
#REPLACE INTO `item_db` VALUES (5813,'Red_Ph.D_Hat','Red Ph.D Hat',4,1000,NULL,500,NULL,0,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,481,'bonus bInt,1;',NULL,NULL);
#5814,Ati_Atihan_Hat3
REPLACE INTO `item_db` VALUES (5815,'Classic_Hat_J','Classic Hat',4,20,NULL,500,NULL,2,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,475,'bonus bStr,1; bonus2 bSubSize, 0, 5; bonus2 bSubSize, 1, 5; bonus2 bSubSize, 2, 5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5816,'Cowboy_Hat_J','Purple Cowboy Hat',4,20,NULL,500,NULL,0,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,411,'bonus bBaseAtk,15; bonus bFlee,-5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5817,'Valentine_Pledge','Valentine Pledge',4,20,NULL,0,NULL,3,NULL,0,0xFFFFFFFF,7,2,136,NULL,0,0,0,'bonus bAllStats,2; bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5818,'Carnival_Hat','Carnival Hat',4,0,NULL,0,NULL,6,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,505,'bonus bAllStats, 3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5819,'Carnival_Circlet','Carnival Circlet',4,0,NULL,0,NULL,6,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,506,'bonus bAllStats, 3;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5820,'Black_Elven_Ears','Black Elven Ears',4,10,NULL,100,NULL,2,NULL,0,0xFFFFFFFF,7,2,512,NULL,0,0,498,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5821,'Gold_Tulip_Hairpin','Gold Tulip Hairpin',4,10,NULL,100,NULL,2,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,499,'bonus2 bExpAddClass,Class_All,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5822,'Love_Chick_Hat','Love Chick Hat',4,10000,NULL,100,NULL,4,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,1,500,'bonus bLuk,4; bonus bMaxHP,100; bonus bMaxSP,100; bonus2 bSubRace,RC_DemiHuman,7; bonus2 bSubRace,RC_Player,7; bonus2 bSubRace,RC_Undead,7;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5823,'Love_Arrow','Love Arrow',4,5000,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,7,2,136,NULL,0,0,0,'bonus bDex,5; bonus bAgi,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5824,'Fools_Day_Hat','Fools Day Hat',4,20,NULL,300,NULL,6,NULL,1,0xFFFFFFFF,7,2,256,NULL,30,1,265,NULL,NULL,NULL);
#REPLACE INTO `item_db` VALUES (5825,'Badge_Of_Order_Grace','Badge Of Order Grace',4,0,NULL,0,NULL,1,NULL,0,0xFFFFFFFF,7,2,136,NULL,0,0,0,'bonus bMdef,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5826,'Valkyrie_Helmet','Valkyrie Helmet',4,0,NULL,0,NULL,10,NULL,0,0xFFFFFFFF,7,2,256,NULL,0,0,225,'bonus bStr,2; bonus bInt,2; bonus bDex,2; bonus bAgi,2; bonus bMdef,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5827,'Book_File_Hat','Book File Hat',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,7,2,256,NULL,1,1,423,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5828,'Honor_Gold_Ring','Honor Gold Ring',4,0,NULL,50,NULL,0,NULL,0,0xFFFFFFFF,7,2,136,NULL,1,0,0,'bonus bAllStats,1; bonus bMdef,5;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5829,'Ordinary_Armor','Ordinary Armor',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,7,2,16,NULL,30,1,0,NULL,NULL,NULL);
#REPLACE INTO `item_db` VALUES (5830,'Woe_Sahkkat','Woe Sahkkat',4,20,NULL,10,NULL,0,NULL,0,0xFFFFFFFF,7,2,256,NULL,60,1,67,NULL,NULL,NULL);
#REPLACE INTO `item_db` VALUES (5831,'Woe_Big_Sis_Ribbon','Woe Big Sis Ribbon',4,20,NULL,10,NULL,0,NULL,0,0xFFFFFFFF,7,2,256,NULL,60,1,28,NULL,NULL,NULL);
#REPLACE INTO `item_db` VALUES (5832,'Woe_Vane_Hairpin','Woe Vane Hairpin',4,20,NULL,10,NULL,0,NULL,0,0xFFFFFFFF,7,2,256,NULL,60,1,313,NULL,NULL,NULL);
#REPLACE INTO `item_db` VALUES (5833,'Woe_Picnic_Hat','Woe Picnic Hat',4,20,NULL,10,NULL,0,NULL,0,0xFFFFFFFF,7,2,256,NULL,60,1,117,NULL,NULL,NULL);
#REPLACE INTO `item_db` VALUES (5834,'Woe_Crown','Woe Crown',4,20,NULL,10,NULL,0,NULL,0,0xFFFFFFFF,7,2,256,NULL,60,1,45,NULL,NULL,NULL);
#REPLACE INTO `item_db` VALUES (5835,'Woe_Tiara','Woe Tiara',4,20,NULL,10,NULL,0,NULL,0,0xFFFFFFFF,7,2,256,NULL,60,1,19,NULL,NULL,NULL);
#REPLACE INTO `item_db` VALUES (5836,'Woe_Boys_Cap','Woe Boys Cap',4,20,NULL,10,NULL,0,NULL,0,0xFFFFFFFF,7,2,256,NULL,60,1,102,NULL,NULL,NULL);
#REPLACE INTO `item_db` VALUES (5837,'Woe_Sunglass','Woe Sunglass',4,20,NULL,10,NULL,0,NULL,0,0xFFFFFFFF,7,2,512,NULL,70,0,12,NULL,NULL,NULL);
#REPLACE INTO `item_db` VALUES (5838,'Woe_Fin_Helm','Woe Fin Helm',4,20,NULL,10,NULL,0,NULL,0,0xFFFFFFFF,7,2,512,NULL,70,0,100,NULL,NULL,NULL);
#REPLACE INTO `item_db` VALUES (5839,'Woe_Blush','Woe Blush',4,20,NULL,10,NULL,0,NULL,0,0xFFFFFFFF,7,2,512,NULL,70,0,125,NULL,NULL,NULL);
#REPLACE INTO `item_db` VALUES (5840,'Woe_Elven_Ears','Woe Elven Ears',4,20,NULL,10,NULL,0,NULL,0,0xFFFFFFFF,7,2,512,NULL,70,0,73,NULL,NULL,NULL);
#REPLACE INTO `item_db` VALUES (5841,'Shaman_Hat_','Shaman_Hat',4,20,NULL,100,NULL,1,NULL,1,0xFFFFFFFF,7,2,256,NULL,30,1,596,'bonus bLuk,2;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5842,'Loyal_Ring1','Loyal Ring1',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,7,2,136,NULL,1,1,0,NULL,NULL,NULL);
#REPLACE INTO `item_db` VALUES (5843,'Loyal_Ring2','Loyal Ring2',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,7,2,136,NULL,1,1,0,'bonus bAllStats,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5844,'Loyal_Ring3','Loyal Ring3',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,7,2,136,NULL,1,0,0,'bonus bAllStats,3;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5845,'Buzzy_Ball_Board','Buzzy Ball Board',4,50,NULL,400,NULL,0,NULL,0,0xFFFFFFFF,7,2,256,NULL,1,1,641,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5846,'Buzzy_Ball_Gum','Buzzy Ball Gum',4,50,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,7,2,1,NULL,1,0,572,'bonus bMdef,5;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5847,'Fools_Day_Helmet','Fools Day Helmet',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,7,2,256,NULL,1,0,647,'bonus bInt,5; bonus bVit,-3;',NULL,NULL);
#REPLACE INTO `item_db` VALUES (5848,'Robin_Eyepatch','Robin Eyepatch',4,20,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,7,2,512,NULL,1,0,50,NULL,NULL,NULL);
#REPLACE INTO `item_db` VALUES (5849,'Doctor_Hairband','Doctor Hairband',4,20,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,7,2,256,NULL,1,0,60,NULL,NULL,NULL);
#REPLACE INTO `item_db` VALUES (5850,'Golden_Savage_Hat','Golden Savage Hat',4,20,NULL,500,NULL,5,NULL,0,0xFFFFFFFF,7,2,256,NULL,50,1,648,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (5851,'Summer_Knight','Summer Knight',4,20,NULL,0,NULL,1,NULL,0,0xFFFFFFFF,7,2,768,NULL,60,0,138,NULL,NULL,NULL);
#REPLACE INTO `item_db` VALUES (5852,'Resurrect_Egg_Shell','Resurrect Egg Shell',4,20,NULL,500,NULL,-7,NULL,0,0xFFFFFFFF,7,2,256,NULL,40,1,537,'bonus bMdef,-7;',NULL,NULL);
#
REPLACE INTO `item_db` VALUES (5856,'Passion_FB_Hat','Passion FB Hat',4,20,NULL,600,NULL,2,NULL,1,0xFFFFFFFF,7,2,256,NULL,1,1,671,'bonus bStr,2; bonus bDex,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5857,'Cool_FB_Hat','Cool FB Hat',4,20,NULL,600,NULL,2,NULL,1,0xFFFFFFFF,7,2,256,NULL,1,1,672,'bonus bInt,2; bonus bVit,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5858,'Victory_FB_Hat','Victory FB Hat',4,20,NULL,600,NULL,2,NULL,1,0xFFFFFFFF,7,2,256,NULL,1,1,673,'bonus bInt,2; bonus bDex,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (5859,'Glory_FB_Hat','Glory FB Hat',4,20,NULL,600,NULL,2,NULL,1,0xFFFFFFFF,7,2,256,NULL,1,1,674,'bonus bAllStats,1;',NULL,NULL);
# More Etc Items
#===================================================================
REPLACE INTO `item_db` VALUES (6000,'Dark_Ashes','Ashes of Darkness',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6001,'Essence_Of_Fire','Essence of Fire',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6002,'Token_Of_Apostle','Token of Apostle',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6003,'Soul_Pendant','Pendant of Spirit',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6004,'Bapho_Doll','Cursed Baphomet Doll',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6005,'New_Year_Rice_Cake','New Year Rice Cake',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6006,'Rice_Cake_Delivery_Box','Rice Cake Delivery Box',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6007,'New_Year_Rice_Cake_Soup','New Year Rice Cake Soup',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6008,'Wood','Wood',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6009,'Large_Magical_Fan','Big Fan Of Magic',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6010,'Pickaxe','Hoe',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6011,'Blue_Card_B','Blue B Card',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6012,'Blue_Card_C','Blue C Card',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6013,'Blue_Card_J','Blue J Card',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6015,'Blue_Card_M','Blue M Card',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6016,'Blue_Card_Q','Blue Q Card',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6017,'Blue_Card_T','Blue T Card',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6018,'Blue_Card_V','Blue V Card',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6019,'Blue_Card_Z','Blue Z Card',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6020,'Fur','Fur',3,704,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6021,'Peaked_Hat','Peaked Hat',3,433,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6022,'Hard_Skin','Hard Skin',3,884,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6023,'Mystic_Horn','Mystic Horn',3,1000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6024,'17Carat_Dia','17Carat Diamond',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6025,'Towel_Of_Memory','Towel of Memory',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6026,'Marriage_Covenant','Written Oath Of Marriage',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6027,'Crystal_Of_Feardoom','Crystal Of Feardom',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6028,'Seal_Scroll','Sealed Scroll',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6029,'Morocc_Tracing_Log','Morroc Tracing Log',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6030,'Glitering_PaperA','Glittering Paper',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6031,'Glitering_PaperB','Glittering Paper',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6032,'Horn_Of_Hilsrion','Horn of Hillslion',3,500,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6033,'Horn_Of_Tendrilion','Horn of Tendrilion',3,500,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6034,'Weird_Part','Weird Part',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6035,'Decaying_Stem','Decaying Stem',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6036,'Invite_To_Meeting','Meeting Invitation',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6037,'Rough_File','Messy File',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6038,'Neat_Report','Neat Report',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6039,'Piece_Of_Fish','Piece of Fish',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6040,'Some_Of_Report','Part of a Report',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6041,'Strong_Bine','Strong Vine',3,30,NULL,50,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6042,'Ordinary_Branch','Ordinary Branch',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6043,'Letter_From_Lugen','Letter from Lugen',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6044,'Letter_From_Otto','Letter from Otto',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6045,'Supply_Box','Supply Box',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6046,'Clothing_Dye_Coupon','Clothing Dye Coupon',2,0,NULL,0,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6047,'Clothing_Dye_Coupon_II','Clothing Dye Coupon II',2,0,NULL,0,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6048,'Unidentified_Mineral','Unidentified Mineral',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6049,'Marlin','Marlin',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6050,'Mercenary_Contract','Mercenary Contract',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6051,'Gray_Hollow','Gray Hollow',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6052,'Ornamental_Hairpin','Ornament Hairpin',3,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6053,'Yuanbao','Circle Step',3,100,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6054,'Blue_Card_6','Number 6 Card',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6055,'Blue_Card_Annyver','Character Week Card',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6056,'Blue_Card_Sary','Character Year Card',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6057,'Blue_Card_E','Character Lee Card',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6058,'Blue_Card_Ven','Character Ben Card',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6059,'Blue_Card_Nt','Character Project Card',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6060,'Moon_Admin_Ticket','Month Viewing Ticket',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6061,'Plantain','Blood Beginner',3,100,NULL,50,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6062,'Moon_Cake15','Letter Moon Cake',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6063,'Moon_Cake16','Letter Moon Cake',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6064,'Moon_Cake17','Letter Moon Cake',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6065,'Moon_Cake18','Letter Moon Cake',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6066,'Moon_Cake19','Letter Moon Cake',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6067,'Moon_Cake20','Letter Moon Cake',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6068,'Rabbit_Skin','Leather Rabbit',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6069,'ABUNDANCE','Abundance',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6070,'Shaman\'s_Old_Paper','Shaman\'s Document',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6071,'Broken_Sword','Broken Sword',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6072,'Wing_Of_Bizofnil','Bijofnil Feather',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6073,'Dragon\'s_Mane','Dragon\'s Mane',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6074,'Bazett\'s_Order','Bazett\'s Order',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6075,'Crystalized_Teardrop','Crystalized Teardrop',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6076,'Portable_Toolbox','Portable Toolbox',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6077,'Rough_Mineral','Rough Mineral',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6078,'Stone_Fragments','Stone Fragment',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6079,'Flower_Of_Alfheim','Flower Of Alfheim',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6080,'Manuk_Coin','Manuk Coin',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6081,'Splendide_Coin','Splendide Coin',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6082,'Spirit_Of_Alfheim','Spirit Of Alfheim',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6083,'Dolly_Capsule','Capsule Dolls',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6084,'Bradium_Fragments','Bradium Fragments',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6085,'Shaggy_Muffler','Shaggy Muffler',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6086,'Withered_Flower','Withered Flower',3,890,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6087,'Crystal_Of_Soul_01','Spiritual Crystal',3,1050,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6088,'Crystal_Of_Soul_02','Spiritual Crystal',3,1050,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6089,'Piece_Of_Darkness','Dark Piece',3,1000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6090,'Purified_Bradium','Refined Bradium',3,1100,NULL,50,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6091,'Dark_Red_Scale','Dark Red Scale',3,200000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6092,'Singing_Crystal_Piece','Piece Of Singing Crystal',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6093,'Egg_Of_Draco','Draco\'s Egg',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6094,'Traditional_Cookie','Traditional Sweets',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6095,'Flavored_Alcohol','Flavored Alcohol',3,1000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6096,'Fish_With_Blue_Back','Fish With Blue Back',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6097,'Pumpkin_Pie_','Pumpkin Pie',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6098,'Small_Snow_Flower','Small Snow Flower',3,1000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6099,'Grilled_Rice_Cake','Grilled Rice Cake',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6100,'Damp_Darkness','Damp Darkness',3,1000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6101,'Attendance_Card','Attendance Card',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6102,'Report_On_Splendide','Report On Splendide',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6103,'Report_On_Manuk','Report On Manuk',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6104,'Big_Cell','Big Cell',3,1000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6105,'Morning_Dew','Morning Dew',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6106,'Well_Ripened_Berry','Well Ripened Berry',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6107,'Sunset_On_The_Rock','Sunset On The Rock',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6108,'Apple_Pudding','Apple Pudding',3,1000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6109,'Plant_Neutrient','Plant Neutrient',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6110,'Vital_Flower','Vital Flower',3,1000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6111,'Mystic_Stone','Mystic Stone',3,1000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6112,'Fresh_Plant','Fresh Plant',3,1000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6113,'Vital_Flower_','Vital Flower',3,1000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6114,'Flame_Gemstone','Flame Gemstone',3,1000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6115,'Bun_','Bun',3,1000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6116,'Succu_Pet_Coupon','Succubus Pet Exchange Coupon',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6117,'Imp_Pet_Coupon','Imp Pet Exchange Coupon',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6118,'Chung_E_Pet_Coupon','Chung E Exchange Coupon',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6119,'Natural_Leather','Cow Leather',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6120,'Face_Paint','Face Paint',3,120,NULL,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6121,'Makeover_Brush','Makeover Brush',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6122,'Paint_Brush','Paint Brush',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6123,'Surface_Paint','Surface Paint',3,200,NULL,30,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6124,'Wolf\'s_Flute','Wolf Flute',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6125,'Lucky_Box','Spring Time Box',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6126,'Happy_Box','Summer Happy Box',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6127,'Purification_Stone','Purification Stone',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6128,'Guillotine_Antidote','Antidote',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6129,'Ticket_Nightmare','Nightmare Terror Exchange Coupon',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6130,'Ticket_Loli_Ruri','Loli Ruri Exchange Coupon',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6131,'Ticket_Goblin_Leader','Goblin Leader Exchange Coupon',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6132,'Ticket_Incubus','Incubus Exchange Coupon',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6133,'Ticket_Miyabi_Ningyo','Miyabi Ningyo Exchange Coupon',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6134,'Ticket_Whisper','Giant Whisper Exchange Coupon',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6135,'Ticket_Wicked_Nymph','Evil Nymph Exchange Coupon',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6136,'Ticket_Medusa','Medusa Exchange Coupon',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6137,'Ticket_Stoneshooter','Stone Shooter Exchange Coupon',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6138,'Ticket_Marionette','Marionette Exchange Coupon',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6139,'Ticket_Leafcat','Leaf Cat Exchange Coupon',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6140,'Ticket_Dullahan','Dullahan Exchange Coupon',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6141,'Ticket_Shinobi','Shinobi Exchange Coupon',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6142,'Ticket_Golem','Golem Exchange Coupon',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6143,'Ticket_Civil_Servant','Civil Servant Exchange Coupon',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6144,'Heartbroken_Tears','Regrettable Tears',3,1000,NULL,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6145,'Vulcan_Bullet','Vulcan Bullet',3,10,NULL,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6146,'Magic_Gear_Fuel','Magic Gear Fuel',3,300,NULL,30,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6147,'Liquid_Condensed_Bullet','Liquid Condensed Bullet',3,100,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6148,'Chocolate_Of_Eternity','Eternity Of Chocolate',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6149,'Plain_Chocolate','Simple Chocolate',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6150,'Key_Of_The_Mansion','Key of The Mansion',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6151,'Peice_Of_Great_Bradium','Giant Bradium Fragment',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6152,'Glittering_Crystal','Glittering Crystal',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6153,'Special_Exchange_Coupon','Special Exchange Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6154,'Broken_Horn_Pipe','Broken Horn Pipe',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6155,'Coke_Membership_Card','Member Card',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6156,'Approval_Report','Approval Report',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6157,'Poring_Ticket','Poring Exchange Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6158,'Drops_Ticket','Drops Exchange Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6159,'Poporing_Ticket','Poporing Exchange Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6160,'Lunatic_Ticket','Lunatic Exchange Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6161,'Picky_Ticket','Picky Exchange Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6162,'Pecopeco_Ticket','Peco Peco Exchange Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6163,'Savage_Baby_Ticket','Savage Babe Exchange Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6164,'Spore_Ticket','Spore Exchange Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6165,'Poison_Spore_Ticket','Poison Spore Exchange Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6166,'Chonchon_Ticket','Chonchon Exchange Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6167,'Steel_Chonchon_Ticket','Steel Chonchon Exchange Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6168,'Petit_Ticket','Sky Petite Exchange Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6169,'Deviruchi_Ticket','Deviruchi Exchange Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6170,'Isis_Ticket','Isis Exchange Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6171,'Smokie_Ticket','Smokie Exchange Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6172,'Dokebi_Ticket','Dokebi Exchange Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6173,'Desert_Wolf_B_Ticket','Baby Desert Wolf Exchange Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6174,'Yoyo_Ticket','Yoyo Exchange Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6175,'Sohee_Ticket','Sohee Exchange Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6176,'Rocker_Ticket','Rocker Exchange Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6177,'Hunter_Fly_Ticket','Hunter Fly Exchange Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6178,'Orc_Warrior_Ticket','Orc Warrior Exchange Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6179,'Bapho_Jr_Ticket','Bapho Jr. Exchange Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6180,'Munak_Ticket','Munak Exchange Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6181,'Bongun_Ticket','Bongun Exchange Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6182,'Goblin_Ticket','Christmas Goblin Exchange Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6183,'Hardtack_Ticket','Rice Cake Exchange Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6184,'Zherlthsh_Ticket','Zherlthsh Exchange Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6185,'Alice_Ticket','Alice Exchange Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6186,'Monkey_Wrench','Monkey Wrench',3,500,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6187,'Blank_Card','Blank Card',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6188,'Slot_Coupon','Slotting Advertisement',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6189,'Magic_Book_FB','Spell Book (Fire Bolt)',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6190,'Magic_Book_CB','Spell Book (Cold Bolt)',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6191,'Magic_Book_LB','Spell Book (Lightening Bolt)',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6192,'Magic_Book_SG','Spell Book (Storm Gust)',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6193,'Magic_Book_LOV','Spell Book (Lord Of Vermilion)',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6194,'Magic_Book_MS','Spell Book (Meteor Storm)',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6195,'Magic_Book_CM','Spell Book (Comet)',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6196,'Magic_Book_TV','Spell Book (Tetra Vortex)',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6197,'Magic_Book_TS','Spell Book (Thunder Storm)',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6198,'Magic_Book_JT','Spell Book (Jupitel Thunder)',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6199,'Magic_Book_WB','Spell Book (Water Ball)',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6200,'Magic_Book_HD','Spell Book (Heaven\'s Drive)',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6201,'Magic_Book_ES','Spell Book (Earth Spike)',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6202,'Magic_Book_ES_','Spell Book (Earth Strain)',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6203,'Magic_Book_CL','Spell Book (Chain Lightning)',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6204,'Magic_Book_CR','Spell Book (Crimson Rock)',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6205,'Magic_Book_DL','Spell Book (Drain Life)',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6206,'I_Love_You','I Love You',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6207,'Thank_You','Thank You',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6208,'I_Respect_You','I Respect You',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6209,'Glory_Of_Knights','Knight\'s Honor',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6210,'Seed_Of_Horny_Plant','Seed Of Thorny Plant',3,600,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6211,'Bloodsuck_Plant_Seed','Bloodsuck Plant Seed',3,800,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6212,'Bomb_Mushroom_Spore','Bomb Mushroom Spore',3,1000,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6213,'Explosive_Powder','Explosive Powder',3,500,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6214,'Smoke_Powder','Smoke Powder',3,500,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6215,'Tear_Gas','Tear Gas',3,500,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6216,'Oil_Bottle','Oil Bottle',3,1000,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6217,'Mandragora_Flowerpot','Mandragora Flowerpot',3,2000,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6218,'Disin_Delivery_Box','Delivery_Daishin_Box',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6219,'Para_Team_Mark','Eden Group Mark',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6220,'Mysterious_Dyestuff','Mysterious Dyestuff',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6221,'Mystic_Leaf_Cat_Ball','Mystic Leaf Cat Ball',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6222,'Shining_Beads','Shining Beads',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6223,'Carnium','Carnium',3,2000,NULL,150,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6224,'Bradium','Bradium',3,2000,NULL,150,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6225,'HD_Carnium','HD Carnium',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6226,'HD_Bradium','HD Bradium',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6228,'Guarantee_Weapon_9Up','+9 Weapon Refine Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6229,'Guarantee_Weapon_8Up','+8 Weapon Refine Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6230,'Guarantee_Weapon_7Up','+7 Weapon Refine Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6231,'Guarantee_Weapon_6Up','+6 Weapon Refine Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6232,'Guarantee_Armor_9Up','+9 Armor Refine Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6233,'Guarantee_Armor_8Up','+8 Armor Refine Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6234,'Guarantee_Armor_7Up','+7 Armor Refine Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6235,'Guarantee_Armor_6Up','+6 Armor Refine Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6236,'Blue_Card_7','Blue Card 7',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6237,'Guarana_Fruit','Guarana Fruit',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6238,'Guarantee_Weapon_11Up','+11 Weapon Refine Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6239,'Guarantee_Armor_11Up','+11 Armor Refine Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6240,'HD_Oridecon','HD Oridecon',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6241,'HD_Elunium','HD Elunium',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6242,'Midgard_Coin','Midgard Coin',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6243,'Exchange_Coupon','Exchange Coupon',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6244,'Gun_Powder','Gun Powder',3,10,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6245,'Black_Powder','Black Powder',3,100,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6246,'Yellow_Powder','Yellow Powder',3,100,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6247,'White_Powder','White Powder',3,100,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6248,'Melange_Pot','Melange Pot',3,600,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6249,'Savage_Meat','Savage Meat',3,100,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6250,'Cooking_Skewer','Cooking Skewer',3,300,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6251,'Black_Charcoal','Black Charcoal',3,300,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6252,'Wolf_Blood','Blood Of Wolf',3,100,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6253,'Cold_Ice','Cold Ice',3,100,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6254,'Beef_Head_Meat','Beef Head',3,100,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6255,'Large_Cookpot','Large Cookpot',3,500,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6256,'Ice_Fragment','Ice Piece',3,100,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6257,'Ice_Crystal','Ice Crystal',3,100,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6258,'Comodo_Tropic_Fruit','Comodo Tropical Fruit',3,800,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6259,'Drocera_Tentacle','Drosera Tentacle',3,100,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6260,'Petti_Tail','Petite\'s Tail',3,100,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6261,'Fine_Noodle','Fine Noodles',3,500,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6262,'Cool_Gravy','Cool Gravy',3,400,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6263,'Coconut_Fruit','Coconut Fruit',3,100,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6264,'Melon','Melon',3,100,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6265,'Pineapple','Pineapple',3,100,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6266,'Cheat_Key','Key Of Deception',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6267,'Virtual_Key','Key Of Illusion',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6268,'Mirth_Key','Key Of Gaiety',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6269,'Master_Brush','A Master\'s Blush',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6270,'Mins_Picture','A Picture Of Minstrel Song',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6271,'Mins_Receipt','Receipt',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6272,'Experiment_Seed','Experiment Seed',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6273,'Altered_Seed','Seed For Experiment',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6274,'Saint_Cloth_Piece','A Piece Of Cloth Of A Saint',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6275,'King_Shield','Shield Of King',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6276,'Clear_Reagent','Clear Reagent',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6277,'Red_Reagent','Red Reagent',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6278,'Black_Reagent','Black Reagent',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6279,'Apple_Bomb_CB','Apple Bomb Guidebook',3,1000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6280,'Pinepple_Bomb_CB','Pineapple Bomb Guidebook',3,1000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6281,'Coconut_Bomb_CB','Coconut Fruit Bomb Guidebook',3,1000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6282,'Melon_Bomb_CB','Melon Bomb Guidebook',3,1000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6283,'Banana_Bomb_CB','Banana Bomb Guidebook',3,1000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6284,'Plant_Genetic_Grow','How To Grow Plant Genes',3,1000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6285,'Quality_Potion_Book','Manual: How To Make High Quality Potion',3,1000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6286,'F_Max_Weight_Up_Scroll','F Max Weight Up Scroll',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6287,'F_Clothing_Dye_Coupon','F Clothing Dye Coupon',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6288,'F_Happy_Box','F Happy Box',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6289,'F_Mysterious_Dyestuff','F Mysterious Dyestuff',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6290,'F_New_Style_Coupon','F New Style Coupon',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6291,'F_Enriched_Elunium','F Enriched Elunium',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6292,'F_Enriched_Oridecon','F Enriched Oridecon',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6293,'F_Token_Of_Siegfried','F Token Of Siegfried',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6294,'F_Marriage_Covenant','F Marriage Covenant',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6295,'F_Clothing_Dye_Coupon2','F Clothing Dye Coupon2',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6296,'RF_Taining_Notice','Training Notice',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6297,'Bottle_To_Throw','Throwing Bottle',3,300,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6298,'Pumpkin_Head_Crushed','Pumpkin Head Crushed',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6299,'Worn_Cloth_Piece','Worn Cloth Piece',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6300,'J_7Draw','event',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6301,'J_Semi_Draw','event',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6302,'GM_Handwriting','GM Handwriting',3,20004,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6303,'Changed_Hydra_Ball','Changed Hydra Ball',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6304,'Sapa_Feat_Cert','Proof Of Sapha\'s Honor',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6305,'Frozen_Skin_Piece','Frozen Piece Of Skin',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6306,'Solid_Bloodstain','Hard Bloodstain',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6307,'Suspicious_Magic_Stone','Cursed Magical Stone',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6308,'Unidentified_Relic','Unidentified Relic',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6309,'E_Max_Weight_Up_Scroll','E Max Weight Up Scroll',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6310,'E_Cloth_Dye_Coupon','E Cloth Dye Coupon',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6311,'E_Happy_Box','E Happy Box',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6312,'E_Mysterious_Dyestuff','E Mysterious Dyestuff',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6313,'E_New_Style_Coupon','E New Style Coupon',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6314,'E_Enriched_Elunium','E Enriched Elunium',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6315,'E_Enriched_Oridecon','E Enriched Oridecon',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6316,'E_Token_Of_Siegfried','E Token Of Siegfried',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6317,'E_Marriage_Covenant','E Marriage Covenant',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6318,'E_Cloth_Dye_Coupon2','E Cloth Dye Coupon2',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6319,'Small_Bradium','Small Bradium',3,324,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6320,'Premium_Reset_Stone','Premium Reset Stone',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6321,'Rakehorn_Helm','Rakehorn Helm',3,822,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6322,'Antler_Helm','Antler Helmet',3,800,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6323,'Twinhorn_Helm','Two-Horned Helmet',3,728,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6324,'Singlehorn_Helm','Single Horned Helmet',3,702,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6325,'White_Spider_Limb','White Spider Limb',3,1004,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6326,'Queen_Wing_Piece','Queen Wing Piece',3,1630,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6328,'Calender_January','Calender January',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6329,'Calender_February','Calender February',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6330,'Calender_March','Calender March',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6331,'Calender_April','Calender April',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6332,'Calender_May','Calender May',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6333,'Calender_June','Calender June',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6334,'Calender_July','Calender July',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6335,'Calender_August','Calender August',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6336,'Calender_September','Calender September',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6337,'Calender_October','Calender October',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6338,'Calender_November','Calender November',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6339,'Calender_December','Calender December',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6340,'Fade_Notation_Green','Fade Notation Green',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6341,'Fade_Notation_Red','Fade Notation Red',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6342,'Fade_Notation_Purple','Fade Notation Purple',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6343,'Fade_Notation_Blue','Fade Notation Blue',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6344,'Muscle_Story','Muscle Story',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6345,'Love_Ball','Love Ball',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6346,'Seagate_Mark','Seagate Mark',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6347,'Bless_Word_Paper1','Bless Word Paper',3,4020,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6348,'Bless_Word_Paper2','Bless Word Paper',3,4020,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6349,'Bless_Word_Paper3','Bless Word Paper',3,4020,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6350,'Bless_Word_Paper4','Bless Word Paper',3,4020,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6351,'Bless_Word_Paper5','Bless Word Paper',3,4020,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6352,'Bless_Word_Paper6','Bless Word Paper',3,4020,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6353,'Bless_Word_Paper7','Bless Word Paper',3,4020,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6354,'Bless_Word_Paper8','Bless Word Paper',3,4020,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6355,'Bless_Word_Paper9','Bless Word Paper',3,4020,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6356,'Bless_Word_Paper10','Bless Word Paper',3,4020,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6357,'Fortune_Cookie_Fail','Fortune Cookie Fail',3,4020,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6358,'Free_Cash_Coupon','Free Cash Coupon',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6359,'Guidebook_Exchange','Guidebook Exchange',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6360,'Scarlet_Pts','Scarlet Point',3,100,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6361,'Indigo_Pts','Indigo Point',3,100,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6362,'Yellow_Wish_Pts','Yellow Wish Point',3,100,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6363,'Lime_Green_Pts','Lime Green Point',3,100,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6369,'Amatsu_Bead_A','Amatsu Bead A',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6370,'Amatsu_Bead_Ma','Amatsu Bead Ma',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6371,'Amatsu_Bead_Tsu','Amatsu Bead Tsu',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6372,'Amatsu_Bead_Jam','Amatsu Bead Jam',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6373,'Amatsu_Bead_Bo','Amatsu Bead Bo',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6374,'Amatsu_Bead_Ree','Amatsu Bead Ree',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6375,'Amatsu_Bead_!','Amatsu Bead !',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6376,'KVM_Badge','KVM Badge',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6377,'Buy_Market_Permit','Buy Market Permit',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6378,'Winning_Mark','Winning Mark',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6379,'7Star_Board','7Star Board',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6380,'Mora_Coin','Mora Coin',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6381,'Field_Shovel','Field Shovel',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6382,'Urn','Urn',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6383,'Clue_Of_Lope','Lope\'s Clue',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6384,'Ring_Of_Lope','Lope\'s Ring',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6385,'Research_Tool_Bag','Research Tool Bag',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6386,'Bathtub_R_Sample','Bath Water Sample',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6387,'Teeth_Sample','Teeth Sample',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6388,'Scale_Sample','Scale Sample',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6389,'Puddle_R_Sample','Sample Of Puddle Research',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6390,'Small_Pocket','Small Pocket',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6391,'Splendid_Supply_Kit','Splendid Supply Kit',3,20,NULL,2000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6392,'Bradium_Box','Bradium Box',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6393,'Round_Feather','Round Feather',3,700,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6394,'Golden_Feather','Golden Feather',3,650,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6395,'Angel_Magic_Power','Angel Magic Power',3,820,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6396,'Auger_Of_Spirit','Auger Of Spirit',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#
REPLACE INTO `item_db` VALUES (6456,'Guarantee_Weapon_5Up','+5 Weapon Refine Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6457,'Guarantee_Armor_5Up','+5 Armor Refine Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6493,'Makibishi','Makibishi',3,30,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6499,'Ancient_Grudge','Ancient Grudge',3,500,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6512,'Charm_Fire','Fire Amulet',3,100,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6513,'Charm_Ice','Ice Amulet',3,100,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6514,'Charm_Wind','Wind Amulet',3,100,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (6515,'Charm_Earth','Earth Amulet',3,100,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#
REPLACE INTO `item_db` VALUES (7001,'Mould_Powder','Mould Powder',3,466,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7002,'Ogre_Tooth','Ogre Tooth',3,658,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7003,'Anolian_Skin','Anolian Skin',3,968,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7004,'Mud_Lump','Mud Lump',3,876,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7005,'Skull','Skull',3,1044,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7006,'Wing_Of_Red_Bat','Wing of Red Bat',3,168,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7007,'Claw_Of_Rat','Claw of Rat',3,748,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7008,'Stiff_Horn','Stiff Horn',3,636,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7009,'Glitter_Shell','Glitter Shell',3,528,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7010,'Tail_Of_Steel_Scorpion','Tail of Steel Scorpion',3,548,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7011,'Claw_Of_Monkey','Claw of Monkey',3,466,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7012,'Tough_Scalelike_Stem','Tough Scalelike Stem',3,412,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7013,'Coral_Reef','Coral Reef',3,772,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7014,'Old_Portrait','Old Portrait',3,1500,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7015,'Bookclip_In_Memory','Bookclip in Memory',3,3000,NULL,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7016,'Spoon_Stub','Spoon Stub',3,2500,NULL,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7017,'Executioner\'s_Mitten','Executioner\'s Mitten',3,4500,NULL,30,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7018,'Young_Twig','Young Twig',3,50,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7019,'Loki\'s_Whispers','Loki\'s Whispers',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7020,'Mother\'s_Nightmare','Mother\'s Nightmare',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7021,'Foolishness_Of_Blind','Foolishness of the Blind',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7022,'Old_Hilt','Old Hilt',3,150,NULL,30,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7023,'Blade_Lost_In_Darkness','Blade Lost in Darkness',3,12000,NULL,40,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7024,'Bloody_Edge','Bloody Edge',3,10000,NULL,40,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7025,'Lucifer\'s_Lament','Lucifer\'s Lament',3,30000,NULL,50,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7026,'Key_Of_Clock_Tower','Key of Clock Tower',3,100,NULL,30,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7027,'Underground_Key','Key of Underground',3,100,NULL,30,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7028,'Invite_For_Duel','Invite for Duel',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7029,'Admission_For_Duel','Admission for Duel',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7030,'Claw_Of_Desert_Wolf','Claw of Desert Wolf',3,208,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7031,'Old_Frying_Pan','Old Frying Pan',3,196,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7032,'Piece_Of_Egg_Shell','Piece of Egg Shell',3,168,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7033,'Poison_Spore','Poison Spore',3,114,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7034,'Red_Socks_With_Holes','Red Stocking',3,100,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7035,'Matchstick','Matchstick',3,100,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7036,'Fang_Of_Garm','Fang of Hatii',3,100,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7037,'Trade_Coupon','Coupon',3,100,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7038,'Yarn','Yarn',3,100,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7039,'Novice_Nametag','Newbie Tag',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7040,'Megaphone','Megaphone',3,1,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7041,'Fine_Grit','Fine Grit',3,120,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7042,'Leather_Bag_Of_Infinity','Leather Bag of Infinity',3,1,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7043,'Fine_Sand','Fine Sand',3,100,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7044,'Vigorgra','Vigorgra',3,1,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7045,'Magic_Paint','Magic Paint',3,1,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7046,'Cart_Parts','Cart Parts',3,1,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7047,'Alice\'s_Apron','Alice\'s Apron',3,2424,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7048,'Talon_Of_Griffin','Talon of Griffon',3,5418,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7049,'Stone','Stone',3,0,NULL,30,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7050,'Cotton_Mat','Cotton Mat',3,100,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7051,'Silk_Mat','Silk Mat',3,100,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7052,'Old_Magazine','Old Papers',3,100,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7053,'Cyfar','Cyfar',3,772,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7054,'Brigan','Brigan',3,746,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7055,'Animal_Pooopoo','Animal Poop',3,100,NULL,50,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7056,'Payroll_Of_Kafra','Payment Statement for Kafra Employee',3,1,NULL,50,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7057,'Gallar_Horn','Gjallar',3,1,NULL,500,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7058,'Gullraifnir','Gleipnir',3,1,NULL,500,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7059,'Cargo_Free_Ticket','Free Ticket for Kafra Storage',3,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7060,'Warp_Free_Ticket','Free Ticket for Kafra Transportation',3,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7061,'Cart_Free_Ticket','Free Ticket for the Cart Service',3,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7062,'Broken_Turtle_Shell','Broken Turtle Shell',3,280,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7063,'Soft_Feather','Soft Feather',3,280,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7064,'Dragon_Fly_Wing','Wing of Dragonfly',3,520,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7065,'Sea_Otter_Leather','Sea-Otter Fur',3,820,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7066,'Ice_Piece','Ice Cubic',3,660,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7067,'Stone_Piece','Stone Fragment',3,640,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7068,'Burn_Tree','Burnt Tree',3,722,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7069,'Broken_Armor_Piece','Destroyed Armor',3,1042,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7070,'Broken_Shell','Broken Shell',3,900,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7071,'Tatters_Clothes','Tattered Clothes',3,1280,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7072,'Rust_Suriken','Old Shuriken',3,1780,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7073,'Jewel_Of_Prayer','Freya\'s Jewel',3,1,NULL,500,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7074,'Iron_Glove','Thor\'s Gauntlets',3,1,NULL,500,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7075,'Iron_Maiden','Iron Maiden',3,1,NULL,500,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7076,'Mystery_Wheel','Wheel of the Unknown',3,1,NULL,500,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7077,'Silver_Fancy','Silver Ornament',3,1,NULL,500,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7078,'Anger_Of_Valkurye','Wrath of Valkyrie',3,1,NULL,500,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7079,'Feather_Of_Angel','Feather of Angel Wing',3,1,NULL,500,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7080,'Foot_Step_Of_Cat','Cat Tread',3,1,NULL,500,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7081,'Beard_Of_Women','Woman\'s Moustache',3,1,NULL,500,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7082,'Root_Of_Stone','Root of Stone',3,1,NULL,500,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7083,'Soul_Of_Fish','Spirit of Fish',3,1,NULL,500,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7084,'Saliva_Of_Bird','Sputum of Bird',3,1,NULL,500,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7085,'Tendon_Of_Bear','Sinew of Bear',3,1,NULL,500,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7086,'Symbol_Of_Sun','Emblem of the Sun God',3,1,NULL,500,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7087,'Breath_Of_Soul','Breath of Spirit',3,1,NULL,500,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7088,'Crystal_Of_Snow','Snow Crystal',3,1,NULL,500,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7089,'Indication_Of_Tempest','Omen of Tempest',3,1,NULL,500,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7090,'Slilince_Wave','Ripple',3,1,NULL,500,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7091,'Rough_Billows','Billow',3,1,NULL,500,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7092,'Air_Stream','Drifting Air',3,1,NULL,500,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7093,'Wheel','Cogwheel',3,1512,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7094,'Mystery_Piece','Fragment',3,1344,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7095,'Broken_Steel_Piece','Metal Fragment',3,1075,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7096,'Cold_Magma','Lava',3,1109,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7097,'Burning_Heart','Burning Heart',3,924,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7098,'Live_Coal','Live Coal',3,638,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7099,'Old_Magic_Circle','Worn-out Magic Scroll',3,773,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7100,'Sharp_Leaf','Sharp Leaf',3,806,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7101,'Peco_Wing_Feather','Peco Peco Feather',3,454,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7102,'Hideous_Dream','Nightmare',3,1075,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7103,'Unknown_Liquid_Bottle','Unknown Liquid Bottle',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7104,'Fake_Angel_Wing','False Angel Wing',3,756,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7105,'Fake_Angel_Loop','False Heaven Ring',3,924,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7106,'Goat\'s_Horn','Antelope Horn',3,672,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7107,'Gaoat\'s_Skin','Antelope Skin',3,756,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7108,'Boroken_Shiled_Piece','Piece of Shield',3,1680,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7109,'Shine_Spear_Blade','Shining Spear Blade',3,840,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7110,'Vroken_Sword','Broken Sword',3,588,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7111,'Smooth_Paper','Slick Paper',3,706,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7112,'Fright_Paper_Blade','Sharp Paper',3,907,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7113,'Broken_Pharaoh_Symbol','Broken Pharaoh Emblem',3,2016,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7114,'Tutankhamen\'s_Mask','Masque of Tutankhamen',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7115,'Harpy\'s_Feather','Harpy Feather',3,1142,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7116,'Harpy\'s_Claw','Harpy Talon',3,1210,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7117,'Rent_Spell_Book','Torn Magic Book',3,1142,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7118,'Rent_Scroll','Torn Scroll',3,1361,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7119,'Spawns','Bacillus',3,1025,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7120,'Burning_Horse_Shoe','Burning Horseshoe',3,823,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7121,'Honey_Jar','Honey Pot',3,622,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7122,'Hot_Hair','Burning Hair',3,974,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7123,'Dragon\'s_Skin','Dragon Skin',3,1025,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7124,'Sand_Lump','Sand Clump',3,706,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7125,'Scropion\'s_Nipper','Scorpion Claw',3,706,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7126,'Large_Jellopy','Large Jellopy',3,840,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7127,'Alcol_Create_Book','Alcohol Creation Guide',3,100000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7128,'FireBottle_Create_Book','Bottle Grenade Creation Guide',3,100000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7129,'Acid_Create_Book','Acid Bottle Creation Guide',3,100000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7130,'Plant_Create_Book','Plant Bottle Creation Guide',3,100000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7131,'Mine_Create_Book','Marine Sphere Creation Guide',3,100000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7132,'Coating_Create_Book','Glistening Coat Creation Guide',3,100000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7133,'Slim_Potion_Create_Book','Condensed Potion Creation Guide',3,240000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7134,'Medicine_Bowl','Medicine Bowl',3,8,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7135,'Fire_Bottle','Bottle Grenade',3,200,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7136,'Acid_Bottle','Acid Bottle',3,200,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7137,'MenEater_Plant_Bottle','Plant Bottle',3,200,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7138,'Mini_Bottle','Marine Sphere Bottle',3,200,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7139,'Coating_Bottle','Glistening Coat',3,200,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7140,'Seed_Of_Life','Seed of Life',3,60000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7141,'Yggdrasilberry_Dew','Morning Dew of Yggdrasil',3,20000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7142,'Germination_Breed','Embryo',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7143,'Life_Force_Pot','Glass Tube',3,5000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7144,'Normal_Potion_Book','Potion Creation Guide',3,100000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7145,'Rag_T_Shirts','Ragnarok T-shirt',3,1,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7146,'Vacance_Ticket','Vacation Ticket',3,1,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7147,'Jasmin','Jasmine',3,1,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7148,'Mother_Letter','Mother\'s Letter',3,1,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7149,'Yellow_Plate','Yellow Plate',3,220,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7150,'Bamboo_Cut','Piece of Bamboo',3,310,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7151,'Oil_Paper','Oil Paper',3,210,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7152,'Glossy_Hair','Glossy Hair',3,340,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7153,'Old_Japaness_Clothes','Worn-out Kimono',3,590,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7154,'Poison_Powder','Poisonous Powder',3,160,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7155,'Poison_Toad\'s_Skin','Poisonous Toad Skin',3,280,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7156,'Broken_Shuriken','Broken Shuriken',3,470,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7157,'Black_Mask','Dark Mask',3,315,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7158,'Broken_Wine_Vessel','Broken Liquor Jar',3,160,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7159,'Tengu\'s_Nose','Tengu Nose',3,400,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7160,'Lord\'s_Passable_Ticket','Feudal Lord Permit',3,1,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7161,'Black_Bear\'s_Skin','Black Bear Skin',3,384,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7162,'Cloud_Piece','Cloud Crumb',3,390,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7163,'Sharp_Feeler','Hard Feeler',3,570,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7164,'Hard_Peach','Solid Peach',3,400,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7165,'Limpid_Celestial_Robe','Transparent Celestial Robe',3,650,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7166,'Soft_Silk_Cloth','Soft Silk',3,1200,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7167,'Mystery_Iron_Bit','Strange Steel Piece',3,430,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7168,'Great_Wing','Giant Butterfly Wing',3,614,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7169,'Taegeuk_Plate','Ba Gua',3,2800,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7170,'Tuxedo','Tuxedo',3,43000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7171,'Leopard_Skin','Leopard Skin',3,282,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7172,'Leopard_Talon','Leopard Claw',3,290,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7173,'BurnBuster_Bag','iROGM02\'s Backpack',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7174,'Packing_Ribbon','Wrapping Lace',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7175,'Packing_Paper','Wrapping Paper',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7176,'XMAS_Coupon','Royal Certificate',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7177,'Part_Of_Star\'s_Sob','Crumb of Sobbing Starlight',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7178,'Star\'s_Sob','Sobbing Starlight',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7179,'Donation_Card','Proof of Donation',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7180,'Introduction_Of_Mr.Han','Hahn Sukbong\'s Recommendation',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7181,'Receipt_01','Receipt',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7182,'Cacao','Cacao',3,200,NULL,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7183,'Sister_Letter','Letter from Sister',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7184,'Piano_Keyboard','Piano Key',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7185,'Quiz_Ticket','Quiz Entry',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7186,'Thin_Stem','Thin Trunk',3,380,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7187,'Festival_Mask','Festival Mask',3,100,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7188,'Browny_Root','Brown Root',3,560,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7189,'Heart_Of_Tree','Wooden Heart',3,680,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7190,'Solid_Peeling','Solid Husk',3,140,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7191,'Lamplight','Lamp',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7192,'Blade_Of_Pinwheel','Vane',3,160,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7193,'Germinating_Sprout','Sprout',3,230,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7194,'Soft_Leaf','Soft Blade of Grass',3,400,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7195,'Air_Rifle','Slingshot',3,210,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7196,'Shoulder_Protection','Shoulder Protector',3,230,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7197,'Tough_Vines','Tough Vines',3,500,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7198,'Great_Leaf','Huge Leaf',3,610,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7199,'Coupon','Coupon',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7200,'Flexible_String','Elastic Band',3,380,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7201,'Log','Log',3,250,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7202,'Beetle_Nipper','Pincher of Beetle',3,290,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7203,'Solid_Twig','Strong Branch',3,190,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7204,'Gunpowder','Gunpowder',3,320,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7205,'Piece_Of_Black_Cloth','Piece of Black Cloth',3,526,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7206,'Black_Kitty_Doll','Black Cat Doll',3,1440,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7207,'Old_Manteau','Old Manteau',3,1050,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7208,'Rusty_Cleaver','Rusty Kitchen Knife',3,1780,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7209,'Dullahan\'s_Helm','Helm of Dullahan',3,1350,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7210,'Dullahan_Armor','Armor Piece of Dullahan',3,790,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7211,'Rojerta_Piece','Fragment of Rossata Stone',3,2600,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7212,'Hanging_Doll','Hung Doll',3,1020,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7213,'Needle_Pouch','Needle Packet',3,832,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7214,'Bat_Cage','Bat Cage',3,880,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7215,'Broken_Needle','Broken Needle',3,690,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7216,'Red_Scarf','Red Muffler',3,660,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7217,'Spool','Spool',3,424,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7218,'Rotten_Rope','Decomposed Rope',3,390,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7219,'Striped_Socks','Striped Sock',3,920,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7220,'Ectoplasm','Ectoplasm',3,322,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7221,'Tangled_Chain','Tangled Chains',3,740,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7222,'Tree_Knot','Wooden Gnarl',3,468,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7223,'Distorted_Portrait','Contorted Self-Portrait',3,2032,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7224,'Stone_Of_Intelligence','Stone of Sage',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7225,'Pumpkin_Bucket','Pumpkin Lantern',3,486,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7226,'Pill','Pellet',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7227,'TCG_Card','TCG Card',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7228,'Gold_Bullion','Gold Bullion',3,100000,NULL,300,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7229,'Silver_Bullion','Silver Bullion',3,50000,NULL,300,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7230,'White_Gold_Bullion','Platinum Bullion',3,200000,NULL,300,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7231,'Gold_Ore','Gold Ore',3,20,NULL,150,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7232,'Silver_Ore','Silver Ore',3,20,NULL,150,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7233,'Mithril_Ore','Mithril Ore',3,20,NULL,150,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7234,'Soul_Of_Guild','Spirit of Guild',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7235,'Soul_Of_Courage','Spirit of Charge',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7236,'Soul_Of_Guard','Spirit of Protection',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7237,'Soul_Of_Partnership','Spirit of Association',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7238,'Soul_Of_Correspondence','Spirit of Coordination',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7239,'Soul_Of_Proceeding','Spirit of Advance',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7240,'Soul_Of_Confidence','Spirit of Trust',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7241,'Soul_Of_Agreement','Spirit of Union',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7242,'Soul_Of_Harmony','Spirit of Combination',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7243,'Soul_Of_Cooperate','Spirit of Cooperation',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7244,'Soul_Of_Unity','Spirit of Solidarity',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7245,'Soul_Of_Friendship','Spirit of Friendship',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7246,'Soul_Of_Peace','Spirit of Peace',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7247,'Soul_Of_Spirit','Spirit of Determination',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7248,'Soul_Of_Honor','Spirit of Honor',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7249,'Soul_Of_Service','Spirit of Service',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7250,'Soul_Of_Glory','Spirit of Glory',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7251,'Soul_Of_Victory','Spirit of Victory',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7252,'Herb_Medicine','Herbal Medicine',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7253,'Taeguk_Flag','Golden Korean Flag',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7254,'Digital_Print_Ticket','Digital Picture Printing Coupon',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7255,'China_Marble01','Mystic Orb',3,0,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7256,'China_Marble02','Mystic Orb',3,0,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7257,'China_Marble03','Mystic Orb',3,0,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7258,'China_Marble04','Mystic Orb',3,0,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7259,'China_Marble05','Mystic Orb',3,0,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7260,'China_Marble06','Mystic Orb',3,0,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7261,'China_Marble07','Mystic Orb',3,0,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7262,'Fan','Folding Fan of Cat Ghost',3,466,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7263,'Cat_Eyed_Stone','Cat\'s Eye',3,954,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7264,'Dried_Sand','Dry Sand',3,322,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7265,'Dragon_Horn','Dragon Horn',3,544,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7266,'Dragon_Fang','Denture from Dragon Mask',3,436,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7267,'Tiger_Skin_Panties','Tiger Panty',3,298,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7268,'Little_Blacky_Ghost','Little Ghost Doll',3,1210,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7269,'Bib','Pinafore',3,960,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7270,'Milk_Bottle','Nursing Bottle',3,1100,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7271,'Figure','Novice Figure',3,10000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7272,'Meat_Dumpling_Doll','Rice Ball Doll',3,500,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7273,'Golden_Necklace','RWC Necklace',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7274,'Ancient_Translator','Translated Ancient Language',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7275,'Ancient_Document','Record of Ancient Language',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7276,'Picture_Letter','Doodled Message',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7277,'Munak_Doll','Munak Doll',3,8900,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7278,'Wellbeing_Letter','Letter to Wife',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7279,'Vita500_Lid','Vita500 Lid',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7280,'Quiz_Ticket01','1st Quiz Entry',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7281,'Quiz_Ticket02','2nd Quiz Entry',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7282,'Quiz_Ticket03','3rd Quiz Entry',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7283,'Quiz_Ticket04','4th Quiz Entry',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7284,'Quiz_Ticket05','5th Quiz Entry',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7285,'Thread_Skein','Holy Threads',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7286,'Chilli','Red Chile',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7287,'Thread_Skein_','Holier Threads',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7288,'Thai_Ring','Engagement Ring',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7289,'Olivine','Peridot',3,3000,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7290,'Phlogopite','Phlogopite',3,3000,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7291,'Agate','Agate',3,3000,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7292,'Muscovite','Muscovite',3,3000,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7293,'Rose_Quartz','Rose Quartz',3,3000,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7294,'Turquoise','Turquoise',3,3000,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7295,'Citrine','Citrin',3,3000,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7296,'Pyroxene','Pyroxene',3,3000,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7297,'Biotite','Biotite',3,3000,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7298,'Leaf_Clothes','Fig Leaf',3,538,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7299,'Bamboo_Basket','Straw Basket',3,632,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7300,'Gemstone','Gemstone',3,1420,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7301,'Sword_Accessory','Tassel',3,798,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7302,'KRATHONG','Krathong',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7303,'Bag_Of_Rice','Straw Rice Bag',3,0,NULL,800,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7304,'Witch\'s_Spell_Book','Witch\'s Spell Scroll',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7305,'Authority_Of_Nine_World','Symbol of the Nine Realms',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7306,'Fragment_Of_Soul','Piece of Spirit',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7307,'Whisper_Of_Soul','Spiritual Whispers',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7308,'Witch\'s_Potion','Witch\'s Tonic',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7309,'Wing_Of_Crow','Crow Wing',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7310,'Free_Peco_Ticket','Free Ticket for Peco Ride',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7311,'Free_Flying_Ship_Ticket','Free Ticket for Flyship',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7312,'Jubilee','Jubilee',3,32,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7313,'Seal_Of_Witch','Witch\'s Medal',3,2,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7314,'The_Sign','The Sign',3,2,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7315,'Dark_Crystal_Fragment','Dark Crystal Fragment',3,422,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7316,'Long_Limb','Insect Leg',3,658,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7317,'Screw','Rusty Screw',3,534,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7318,'Old_Pick','Old Pick',3,512,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7319,'Old_Steel_Plate','Used Iron Plate',3,1024,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7320,'Air_Pollutant','Dust Pollutant',3,256,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7321,'Fragment_Of_Crystal','Crystal Fragment',3,552,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7322,'Poisonous_Gas','Toxic Gas',3,666,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7323,'Battered_Kettle','Battered Kettle',3,256,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7325,'Tube','Flexible Tube',3,102,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7326,'Fluorescent_Liquid','Fluorescent Liquid',3,712,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7327,'Headlamp','Flashlight',3,1024,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7328,'Legendary_Scroll','Legend of Songkran',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7329,'Old_Copper_Key','Old Bronze Key',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7330,'2anny','Mystic Orb',3,0,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7331,'Flower_Of_Heaven','Heaven Flower',3,500,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7332,'Slate','Complete Tablet',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7333,'Piece_Of_Slate_1','Prontera Tablet',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7334,'Piece_Of_Slate_2','Payon Tablet',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7335,'Piece_Of_Slate_3','Morroc Tablet',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7336,'Piece_Of_Slate_4','Geffen Tablet',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7337,'Eye_Of_Hellion','Eye of Hellion',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7338,'RO_Transportation_Card','One-way Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7339,'RO_Transportation_Card_','Commemorative Travel Card',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7340,'Will_Of_Darkness','Will of the Darkness',3,734,NULL,50,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7341,'Worn_Out_Pendant','Old Pendant',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7342,'File01','File Folder',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7343,'File02','Sealed File Folder',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7344,'File03','Shinokas Case File',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7345,'Armlet_Of_Prisoner','Handcuffs',3,724,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7346,'Pile_Of_Ymir_Heart','Ymir\'s Heart Piece',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7347,'Lab_Staff_Record','Research Chart',3,840,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7348,'Indication_Of_Member01','Membership Card',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7349,'Indication_Of_Member02','Archive Permit',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7350,'Pass','Pass',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7351,'Friend\'s_Diary','Friend\'s Diary',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7352,'Transparent_Plate01','Transparent Plate',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7353,'Transparent_Plate02','Transparent Plate',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7354,'Transparent_Plate03','Transparent Plate',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7355,'Transparent_Plate04','Transparent Plate',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7356,'Piece_Of_Crest1','Crest Piece',3,5000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7357,'Piece_Of_Crest2','Crest Piece',3,5000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7358,'Piece_Of_Crest3','Crest Piece',3,5000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7359,'Piece_Of_Crest4','Crest Piece',3,5000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7360,'RO_Festival_Ticket','RO Festival Invitation',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7361,'Lotto01','Lotto Ball 01',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7362,'Lotto02','Lotto Ball 02',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7363,'Lotto03','Lotto Ball 03',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7364,'Lotto04','Lotto Ball 04',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7365,'Lotto05','Lotto Ball 05',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7366,'Lotto06','Lotto Ball 06',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7367,'Lotto07','Lotto Ball 07',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7368,'Lotto08','Lotto Ball 08',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7369,'Lotto09','Lotto Ball 09',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7370,'Lotto10','Lotto Ball 10',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7371,'Lotto11','Lotto Ball 11',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7372,'Lotto12','Lotto Ball 12',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7373,'Lotto13','Lotto Ball 13',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7374,'Lotto14','Lotto Ball 14',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7375,'Lotto15','Lotto Ball 15',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7376,'Lotto16','Lotto Ball 16',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7377,'Lotto17','Lotto Ball 17',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7378,'Lotto18','Lotto Ball 18',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7379,'Lotto19','Lotto Ball 19',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7380,'Lotto20','Lotto Ball 20',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7381,'Lotto21','Lotto Ball 21',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7382,'Lotto22','Lotto Ball 22',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7383,'Lotto23','Lotto Ball 23',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7384,'Lotto24','Lotto Ball 24',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7385,'Lotto25','Lotto Ball 25',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7386,'Lotto26','Lotto Ball 26',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7387,'Lotto27','Lotto Ball 27',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7388,'Lotto28','Lotto Ball 28',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7389,'Lotto29','Lotto Ball 29',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7390,'Lotto30','Lotto Ball 30',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7391,'Lotto31','Lotto Ball 31',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7392,'Lotto32','Lotto Ball 32',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7393,'Lotto33','Lotto Ball 33',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7394,'Lotto34','Lotto Ball 34',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7395,'Lotto35','Lotto Ball 35',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7396,'Lotto36','Lotto Ball 36',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7397,'Lotto37','Lotto Ball 37',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7398,'Lotto38','Lotto Ball 38',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7399,'Word_Card01','Selamat',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7400,'Word_Card02','Hari',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7401,'Word_Card03','Kemerdekaan',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7402,'Word_Card04','Republik',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7403,'Word_Card05','Indonesia',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7404,'Word_Card06','Ke-60',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7405,'Crushed_Can','Crushed Can',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7406,'Moon_Cake1','Yuebing',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7407,'Moon_Cake2','Yuebing',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7408,'Moon_Cake3','Yuebing',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7409,'Moon_Cake4','Yuebing',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7410,'Moon_Cake5','Yuebing',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7411,'Moon_Cake6','Yuebing',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7412,'Moon_Cake7','Yuebing',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7413,'Moon_Cake8','Yuebing',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7414,'Moon_Cake9','Yuebing',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7415,'Stone_Of_Summons','Summoning Stone',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7416,'Letter_Of_Recommend','Letter of Recommendation',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7417,'Mission_ScrollA','Written Request(A)',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7418,'Mission_ScrollB','Written Request(B)',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7419,'Embryo_HandBook','Embryo Creation Guide',3,48000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7420,'Skull_','Skull',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7421,'Key_Red','Red Key',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7422,'Key_Yellow','Yellow Key',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7423,'Key_Blue','Blue Key',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7424,'Key_Green','Green Key',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7425,'Key_Black','Black Key',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7426,'Magic_Gem_Red','Red Charm Stone',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7427,'Magic_Gem_Yellow','Yellow Charm Stone',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7428,'Magic_Gem_Blue','Blue Charm Stone',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7429,'Magic_Gem_Green','Green Charm Stone',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7430,'Magic_Gem_Black','Black Charm Stone',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7431,'Several_Books','Pile of Books',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7432,'Leather_Pouch','Leather Pouch',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7433,'Scroll','Blank Scroll',3,4000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7434,'Elemental_Potion_Book','Elemental Potion Creation Guide',3,100000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7435,'Golden_Bracelet','Golden Ornament',3,1907,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7436,'Piece_Of_Memory_Green','Fragment of Agony',3,1506,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7437,'Piece_Of_Memory_Purple','Fragment of Misery',3,1506,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7438,'Piece_Of_Memory_Blue','Fragment of Hatred',3,1506,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7439,'Piece_Of_Memory_Red','Fragment of Despair',3,1506,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7440,'Red_Feather','Red Feather',3,1335,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7441,'Blue_Feather','Blue Feather',3,1408,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7442,'Cursed_Seal','Cursed Seal',3,1332,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7443,'Tri_Headed_Dragon_Head','Three-Headed Dragon\'s Head',3,956,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7444,'Treasure_Box','Treasure Box',3,300000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7445,'Dragonball_Green','Green Bijou',3,887,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7446,'Dragonball_Blue','Blue Bijou',3,887,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7447,'Dragonball_Red','Red Bijou',3,887,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7448,'Dragonball_Yellow','Yellow Bijou',3,887,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7449,'Bloody_Page','Bloody Page',3,681,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7450,'Piece_Of_Bone_Armor','Skeletal Armor Piece',3,2050,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7451,'Scale_Of_Red_Dragon','Fire Dragon Scale',3,1852,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7452,'Yellow_Spice','Yellow Spice',3,1000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7453,'Sweet_Sauce','Sweet Sauce',3,700,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7454,'Plain_Sauce','Savory Sauce',3,700,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7455,'Hot_Sauce','Spicy Sauce',3,700,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7456,'Red_Spice','Red Spice',3,1000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7457,'Cooking_Oil','Cooking Oil',3,500,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7458,'Baphomet\'s_Horn','Fortune Horn',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7459,'RAMADAN_','Idul Fitri Card',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7460,'Niflheim_Ticket','Niflheim Express Ticket',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7461,'BlueCard_A','Blue A Card',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7462,'BlueCard_E','Blue E Card',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7463,'BlueCard_F','Blue F Card',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7464,'BlueCard_H','Blue H Card',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7465,'BlueCard_L','Blue L Card',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7466,'BlueCard_N','Blue N Card',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7467,'BlueCard_O','Blue O Card',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7468,'BlueCard_P','Blue P Card',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7469,'BlueCard_U','Blue U Card',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7470,'BlueCard_W','Blue W Card',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7471,'BlueCard_Y','Blue Y Card',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7472,'Cookbook01','Level 1 Cookbook',3,1000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7473,'Cookbook02','Level 2 Cookbook',3,1000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7474,'Cookbook03','Level 3 Cookbook',3,1000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7475,'Cookbook04','Level 4 Cookbook',3,1000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7476,'Cookbook05','Level 5 Cookbook',3,1000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7477,'Cookbook06','Level 6 Cookbook',3,1000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7478,'Cookbook07','Level 7 Cookbook',3,1000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7479,'Cookbook08','Level 8 Cookbook',3,1000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7480,'Cookbook09','Level 9 Cookbook',3,1000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7481,'Cookbook10','Level 10 Cookbook',3,1000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7482,'Pot','Pot',3,200,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7483,'Key_Of_Seal','Key of the Seal',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7484,'Warrior_Symbol','Symbol of a Brave Warrior',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7485,'2nd_Floor_Pass','Cloud General',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7486,'3rd_Floor_Pass','Wind General',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7487,'Tavern_Wine','Culinary Wine',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7488,'Delivery_Box','Delivery Package',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7489,'Villa_Spare_Key','Cottage Key',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7490,'Kyll_Hire_Letter','Letter to Elly',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7491,'Iron_Box','Steel Box',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7492,'Yellow_Key_Card','Yellow Keycard',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7493,'Golden_Key','Golden Key',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7494,'Kiel_Button','Luxurious Button',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7495,'Blue_Key_Card','Blue Keycard',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7496,'Red_Key_Card','Red Keycard',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7497,'Steel_Piece','Metal Fragment',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7498,'Rosimier_Key','Rosimier Mansion Keys',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7499,'Family_Portrait','Family Portrait',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7500,'Elysia_Portrait','Woman\'s Portrait',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7501,'Kyll_Hire_Letter2','K.H\'s Letter',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7502,'Piece_Memo_Of_James','James\'s Note',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7503,'Man_Portrait','Man\'s Portrait',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7504,'Toy_Motor','Power Device',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7505,'Toy_Key','Toy Key',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7506,'Black_Key_Card','Black Keycard',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7507,'Sturdy_Iron_Piece','Solid Iron Piece',3,842,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7508,'Elysia_Ring','Allysia\'s Ring',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7509,'Fancy_Key_Card','Luxurious Keycard',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7510,'Valhalla_Flower','Valhalla\'s Flower',3,200000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7511,'Rune_Of_Darkness','Rune of Darkness',3,2526,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7512,'Burnt_Parts','Burnt Part',3,1600,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7513,'Pocket_Watch','Pocket Watch',3,3420,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7514,'Monster_Ticket','Monster Ticket',3,2,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7515,'Marvelous_Medal','Prize Medal',3,2,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7516,'Green_Key_Card','Green Keycard',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7517,'Gold_Coin_','Gold Coin',3,1000,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7518,'Women\'s_Medal','Women\'s Medal',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7519,'Money_Envelope','Handsel',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7520,'Chinese_Scroll','Please Be Rich',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7521,'Flame_Stone','Flame Stone',3,150,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7522,'Ice_Stone','Ice Stone',3,150,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7523,'Wind_Stone','Wind Stone',3,150,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7524,'Shadow_Orb','Shadow Orb',3,300,NULL,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7525,'Summer_Feast_Ticket','Summer Festival Ticket',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7526,'Manuscript_Paper','Manuscript Paper',3,2,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7527,'Life_Book','Book About True Life',3,0,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7528,'Id_Lottery_Ticket','Lottery Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7529,'Stolen_Sandals','Stolen Sandal',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7530,'Travel_Brochure_01','Travel Brochure [Amatsu]',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7531,'Travel_Brochure_02','Travel Brochure [Kunlun]',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7532,'Travel_Brochure_03','Travel Brochure [Louyang]',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7533,'Travel_Brochure_04','Travel Brochure [Ayothaya]',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7534,'Photo_Album_01','Amatsu Completed Photo Album',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7535,'Photo_Album_02','Kunlun Completed Photo Album',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7536,'Photo_Album_03','Louyang Completed Photo Album',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7537,'Photo_Album_04','Ayothaya Completed Photo Album',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7538,'Sifted_Sand','Sand for Work',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7539,'Poring_Coin','Poring Coin',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7540,'Lotto39','Lotto Ball 39',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7541,'Lotto40','Lotto Ball 40',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7542,'Lotto41','Lotto Ball 41',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7543,'Lotto42','Lotto Ball 42',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7544,'Lotto43','Lotto Ball 43',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7545,'Lotto44','Lotto Ball 44',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7546,'Lotto45','Lotto Ball 45',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7547,'Soccer_Ball','Soccer Ball',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7548,'Soccer_Shoes','Soccer Shoes',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7549,'Brazilian_Flag','Brazilian Flag',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7550,'Ticket01','6.13 Ticket',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7551,'Ticket02','6.18 Ticket',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7552,'Ticket03','6.22 Ticket',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7553,'Lotus_Flower','Lotus Flower',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7554,'Striped_Candle','Striped Candle',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7555,'Green_Incense','Green Incense',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7556,'Longing_Heart','Longing Heart',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7557,'Invitation_Letter','Invitation Letter',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7558,'Invitation_Ticket','Invitation Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7559,'Key_Of_Flower_Garden','Key to the Secret Garden',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7560,'Longing_Heart2','Longing Heart',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7561,'Ice_Heart','Glacial Heart',3,606,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7562,'Ice_Scale','Ice Scale',3,3020,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7563,'Bloody_Rune','Bloody Rune',3,2016,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7564,'Rotten_Meat','Rotten Meat',3,102,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7565,'Sticky_Poison','Sticky Poison',3,350,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7566,'Will_Of_Darkness_','Will of Red Darkness',3,1530,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7567,'Suspicious_Hat','Suspicious Hat',3,1290,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7568,'White_Mask','White Mask',3,1060,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7569,'Hammer_Of_Wind','Wind Hammer',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7570,'Temple_Lottery_Ticket','Temple Lottery Ticket',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7571,'Diary_Of_Blue','Bruspetti\'s Diary',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7572,'Magic_Necklace','Ashy Necklace',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7573,'Magic_Necklace_','Sparkling Necklace',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7574,'Ice_Particle','Freezing Snow Powder',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7575,'Red_Jewel_','Red Jewel',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7576,'Blue_Jewel_','Blue Jewel',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7577,'Golden_Jewel_','Yellow Jewel',3,20,NULL,50,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7578,'Anti_Spell_Bead','Countermagic Crystal',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7579,'Silk_Handkerchief','Silk Handkerchief of Zhi Nu',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7580,'Black_Bead','Black Marble',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7581,'Anniversary_Ticket','Celebration Document',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7582,'Gem_Of_Ruin','Jewel of Destruction',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7583,'Evil_Mind','Evil Mind',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7584,'Proof_Of_Guard1','Guard\'s First Proof',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7585,'Proof_Of_Guard2','Guard\'s Second Proof',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7586,'Proof_Of_Guard3','Guard\'s Third Proof',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7587,'Proof_Of_Guard4','Guard\'s Fourth Proof',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7588,'IPOD_Ticker','IPOD Coupon',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7589,'Moon_Cake10','Lettered Moon Snack 01',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7590,'Moon_Cake11','Lettered Moon Snack 02',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7591,'Moon_Cake12','Lettered Moon Snack 03',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7592,'Moon_Cake13','Lettered Moon Snack 04',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7593,'Moon_Cake14','Lettered Moon Snack 05',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7594,'Sonia\'s_Letter','Sonia\'s Letter',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7595,'Unique_Sword','Special Sword',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7596,'Unique_Shield','Special Shield',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7597,'Magic_Stone','Magic Stone',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `item_db` VALUES (7598,'BlueCard_I','Blue I Card',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `item_db` VALUES (7599,'BlueCard_D','Blue D Card',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `item_db` VALUES (7600,'BlueCard_K','Blue K Card',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `item_db` VALUES (7601,'BlueCard_S','Blue S Card',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `item_db` VALUES (7602,'BlueCard_R','Blue R Card',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7603,'RO_Party_Ticket','RO Party Invitation Ticket',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7604,'Flour','Flour',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7605,'Chicken_Egg','Chicken Egg',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7606,'Coin','Token of the Ox',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7607,'Evil_Dragon_Head','Neck of Demon Dragon',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7608,'Premium_Ticket','Premium Ticket',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7609,'Pumpkin_Mojo','Pumpkin Mojo',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7610,'Food_Ticket','Food Exchange Ticket',3,1000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7611,'Fox_Symbol','Symbol of Fox',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7612,'Heart_Of_Fox_Queen','Heart of Queen Fox',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7613,'Small_Rice_Dough','Small Rice Cake Dough',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7614,'Special_Packing_Paper','Wrapping Paper',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7615,'MVP_Ticket','MVP Voucher',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7616,'Mini_Boss_Ticket','Miniboss Voucher',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7617,'Monster_Ticket_','Monster Voucher',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7618,'Monster_Crystal','Monster Crystal',3,2,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7619,'Enriched_Elunium','Enriched Elunium',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7620,'Enriched_Oridecon','Enriched Oridecon',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7621,'Token_Of_Siegfried','Token Of Siegfried',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7622,'New_Style_Coupon','Hairstyle Coupon',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7623,'Name_Change_Coupon','Ticket Of Identification',3,2,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7624,'Spring_Stanza23','Spring Stanza23',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7625,'Registration_Ticket','Registration Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7626,'Bubble_Gum_Token','Bubble Gum Token',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7627,'Sage_Key','Sage Key',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7628,'Idiot_Key','Idiot Key',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7629,'Pink_Gift_Box','Pink Gift Box',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7630,'Clean_Beach_Brush','Clean Beach Brush',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7631,'Trash_Debris','Trash Debris',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7635,'Sachet','Sachet',3,100,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#
REPLACE INTO `item_db` VALUES (7701,'Dragon_Spirit','Soul',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7702,'Special_Cogwheel','Special Cogwheel',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7703,'Piece_Of_Cogwheel','Piece of Cogwheel',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7704,'Broken_Thermometer','Broken Thermometer',3,2,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7705,'Note_Of_Geologist','Note of Geologist',3,2,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7706,'Spoiled_Carrot_Juice','Broken Carrot Juice',3,20,NULL,40,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7707,'Spoiled_Banana_Juice','Broken Banana Juice',3,20,NULL,40,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7708,'Spoiled_Apple_Juice','Broken Apple Juice',3,20,NULL,40,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7709,'Spoiled_Grape_Juice','Broken Grape Juice',3,20,NULL,40,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7710,'Black_Gemstone','Black Gemstone',3,600,NULL,30,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7711,'Update_Ticket','Event Ticket',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7712,'Nokia5500','Nokia 5500',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7713,'BlueCard_A_','Blue A(2) Card',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7714,'BlueCard_R_','Blue R(2) Card',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7715,'Handmade_Choco_Recipe','Handmade Chocolate Recipe',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7716,'Strawberry_Choco_Recipe','Chocolate Strawberry Recipe',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7717,'Choco_Tart_Recipe','Chocolate Tart Recipe',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7718,'Cacao_Bean','Cacao Bean',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7719,'BlueCard_G','Blue G Card',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7720,'Gold_Coin_US','Gold Coin',3,100,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7721,'Treasure_Box_','Treasure Box',3,100,NULL,500,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7722,'Debt_Note','Debt Note',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7723,'Diamond_Of_Ruin','Diamond of Ruin',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7724,'Forbidden_Secret_Art','Forbidden Secret Art',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7725,'Unlucky_Emerald','Unlucky Emerald',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7726,'Token_Of_King','Token of King',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7727,'HP_Doctor_Ticket','HP Doctor Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7728,'SP_Doctor_Ticket','SP Doctor Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7729,'Rok_Star_Badge','Rok Star Badge',3,20,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7730,'Mission_Certificate1','Mission Ticket 1',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7731,'Mission_Certificate2','Mission Ticket 2',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7732,'Mission_Certificate3','Mission Ticket 3',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7733,'Mission_Certificate4','Mission Ticket 4',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7734,'Mission_Certificate5','Mission Ticket 5',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7735,'Mission_Certificate6','Mission Ticket 6',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7736,'Mission_Certificate7','Mission Ticket 7',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7737,'Mission_Certificate8','Mission Ticket 8',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7738,'Mission_Certificate9','Mission Ticket 9',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7739,'Mission_Certificate10','Mission Ticket 10',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7740,'Mission_Certificate11','Mission Ticket 11',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7741,'Mission_Certificate12','Mission Ticket 12',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7742,'Kaong','Kaong',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7743,'Gulaman','Gulaman',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7744,'Leche_Flan','Leche Flan',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7745,'Ube_Jam','Ube Jam',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7746,'Sago','Sago',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7747,'Langka','Langka',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7748,'Sweet_Bean','Sweet Beans',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7749,'Sweet_Banana','Sweet Bananas',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7750,'Macapuno','Macapuno',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7751,'Old_White_Cloth','Old White Cloth',3,550,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7752,'Clattering_Skull','Clattering Skull',3,840,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7753,'Broken_Farming_Utensil','Broken Farming Utensil',3,330,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7754,'Broken_Crown','Broken Crown',3,3000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7755,'Research_Note','Research Note',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7756,'Sealed_Book','Sealed Book',3,2000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7757,'Mithril','Mithril',3,20,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7758,'Star_Crystal','Star Crystal',3,20,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7759,'Geology_Report','Geologist\'s Report',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7760,'Yaga_Magic_Book','Yaga\'s Magic Book',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7761,'Magic_Gourd_Bottle','Magic Gourd Bottle',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7762,'Yaga_Pestle','Yaga\'s Pestle',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7763,'Sticky_Herb','Sticky Herb',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7764,'High_Strength_Adhesive','High Strength Adhesive',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7765,'Yaga_Secret_Medicine','Baba Yaga\'s Secret Medicine',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7766,'Bok_Choy','Bok Choy',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7767,'Chung_E_Cake','Green Maiden\'s Cake',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7768,'Squid','Squid',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7769,'Egg_Yolk','Egg Yolk',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7770,'Sweet_Rice','Sweet Rice',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7771,'Lotus_Leaf','Lotus Leaf',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7772,'String','String',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7773,'War_Badge','Wat Badge',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7774,'Chung_E_Ticket','Green Maiden Ticket',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7775,'Spring_Rabbit_Ticket','Spring Rabbit Ticket',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7776,'Max_Weight_Up_Scroll','Gym Pass',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7777,'Gold_Box','Sealed Golden Box',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7778,'Silver_Box','Sealed Silver Box',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7779,'Gold_Key_TW','Golden Key',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7780,'Silver_Key','Silver Key',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7781,'Heart_Box','Engrave Treasure Box',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7782,'Gold_Key77','Episode 13.1 Poporing Key',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7783,'Silver_Key77','Episode 13.2 Poring Key',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7784,'Fawner_Coupon1','Free Coupon 1',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7785,'Fawner_Coupon2','Free Coupon 2',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7786,'Fawner_Coupon3','Free Coupon 3',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7787,'Fawner_Coupon4','Free Coupon 4',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7788,'Fawner_Coupon5','Free Coupon 5',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7789,'Fawner_Coupon6','Free Coupon 6',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7790,'Fawner_Coupon7','Free Coupon 7',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7791,'Fawner_Coupon8','Free Coupon 8',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7792,'Guyak','Guyak',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7793,'Golden_Apple','Golden Apple',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7794,'Fate_Of_Crow','The Crow of Destiny',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7795,'Mami_Photo_Album','Mammi\'s Photo Album',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7796,'Author_Autograph','Author\'s Autograph',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7797,'Author_Memo','Author\'s Memo',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7798,'Dark_Debris','Fragment of Darkness',3,500,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7799,'Dark_Crystal','Crystal of Darkness',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7800,'Golden_Apple_','Golden Charm Apple',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7801,'Girl_Fan_Letter','Girl\'s Letter',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7802,'Autograph_Book','Signature Notebook',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7803,'Battle_Manual_TW','Beginner\'s Field Manual',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `item_db` VALUES (7804,'????_???','????_???',3,NULL,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7805,'Brown_Ring','Brown Jenoss\'s Family Ring',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7806,'Black_Anvil','God Anvil',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7807,'Ore','God Mineral',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7808,'Gold_Hammer','God Hammer',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7809,'Gold_Furnace','God Furnace',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7810,'Yellow_Cat_Eyed_Stone','Symbol of Richness',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7811,'Gold_Anvil','Anvil',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7812,'Red_Cat_Eyed_Stone','Symbol of Bravery',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7813,'Th_Red_Ring','Red Jenoss\'s Family Ring',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7814,'Green_Ring','Green Jenoss\'s Family Ring',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7815,'Blue_Ring','Blue Jenoss\'s Family Ring',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7816,'Blue_Cat_Eyed_Stone','Symbol of Faith',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7817,'White_Cat_Eyed_Stone','Symbol of Peace',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7818,'RJC_Golden_Necklace','Jessur\'s Necklace',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7819,'Nokia5300','Nokia 5300',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7820,'Morroc_Skin','Piece of Morocc Skin',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7821,'Green_Apple','Green Apple',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7822,'Whole_Barbecue','Whole Barbecue',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7823,'Meat_Veg_Skewer','Meat Veg Skewer',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7824,'Spirit_Liquor','Spirit Liquor',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7825,'Heroic_Stone','Heroic Stone',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7826,'Continental_Guard_Paper','Continental Guard Paper',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7827,'Mineral_Report','Mineral Evals',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7828,'BF_Badge1','Bravery Badge',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7829,'BF_Badge2','Valor Badge',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7830,'Goddess_Tear','Goddess Tear',3,1,NULL,500,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7831,'Valkyrie_Token','Valkyrie\'s Token',3,1,NULL,500,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7832,'Brynhild_Armor_Piece','Brynhild Armor Piece',3,1,NULL,500,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7833,'Hero_Remains','Hero\'s Remains',3,1,NULL,500,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7834,'Andvari_Ring','Andvari\'s Ring',3,1,NULL,500,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7835,'Dusk_Glow','Dusk Glow',3,1,NULL,500,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7836,'Dawn_Essence','Dawn Essence',3,1,NULL,500,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7837,'Cold_Moonlight','Cold Moonlight',3,1,NULL,500,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7838,'Hazy_Starlight','Hazy Starlight',3,1,NULL,500,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7839,'Crystal_Key','Crystal Key',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7840,'Valkyrie_Gift','Valkyrie\'s Gift',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7841,'Spotted_Paper','Stained Piece Of Paper',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7842,'Torn_Paper','Torn Piece Of Paper',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7843,'Old_Paper','Old Piece Of Paper',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7844,'Burnt_Paper','Burnt Pieces Of Paper',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7845,'Copy_Of_Spotted_Paper','Copy Of Spotted Paper',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7846,'Copy_Of_Torn_Paper','Copy Of Torn Paper',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7847,'Copy_Of_Old_Paper','Copy Of Old Paper',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7848,'Copy_Of_Burnt_Paper','Copy Of Burnt Paper',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7849,'Soul_Crystal','Soul Crystal',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7850,'Wooden_Block_','Wooden Block',3,20,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7851,'Pass_F1','Wii Raffle Ticket',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7852,'Pass_F2','Divx Player Raffle Ticket',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7853,'Pass_F3','iPod nano Raffle Ticket',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7854,'Pass_CF','Comodo Festival Ticket',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7855,'Heart','Heart',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7856,'Girl_Bunch_Of_Flower_','Girl\'s Bouquet',3,20,NULL,50,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7857,'Handmade_Kitty_Doll','Hand-made Kitty Doll',3,20,NULL,30,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7858,'Dragonball_Yellow_','Dragonball Yellow',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7859,'Game_Ticket','Game Ticket',3,20,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7860,'Peeps','Peeps',3,0,NULL,50,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7861,'Jelly_Bean','Jelly Bean',3,0,NULL,50,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7862,'Marshmallow','Marshmallow',3,0,NULL,50,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7863,'GOLD_ID4','Special Gold',3,20,NULL,200,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7864,'Love_Flower','Love Flower',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7865,'Gold_Pouch','Gold Pouch',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7866,'Certificate','Certificate',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7867,'SesamePouch','Sesame Bag',3,10,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7868,'Water','Fresh Water',3,10,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7869,'RicePouch','Rice Pouch',3,10,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7870,'Corn','Corn',3,5,NULL,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7871,'BeanPouch','Bean Bag',3,10,NULL,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7872,'Grass','Herb',3,10,NULL,30,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7873,'MVP_Monster_Scroll','MVP Monster Scroll',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7874,'Monster_Scroll','Create Monster Scroll',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7875,'Pirate_Box','Pirate Treasure',3,300000,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7876,'Gold_Key','Golden Key',3,0,NULL,50,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7877,'Red_Ring','Red Ring',3,0,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7878,'Lusalka_Hair','Lusalka\'s Hair',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7879,'Golden_Thread','Golden Thread',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7880,'Babayaga_Silver_Spoon','Baba Yaga\'s Silver Spoon',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7881,'Book_Of_Magic','Mystery Magic Book',3,0,NULL,50,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7882,'Pointed_Branch','Sharp Branch',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7883,'Pointed_Wooden_Flute','Wooden Flute',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7884,'Jade_Plate','Jade Plate',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7885,'Sacred_Arrow','Sacred Arrow',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7886,'Bean_Paste','Bean Paste',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7887,'Dried_Fruit_Box','Dried Fruit Box',3,0,NULL,30,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7888,'Bag_Of_Nuts','Bag of Nuts',3,0,NULL,30,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7889,'Chicken_Feed','Chicken Feed',3,0,NULL,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7891,'Mug','Mug',3,2,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7892,'Charcoal','Charcoal',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7893,'Sulfur','Sulphur',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7894,'Nitrate','Nitrogen Acid',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7895,'TRO_Memory_Book01','Rama5 Book',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7896,'TRO_Memory_Book02','Loykrathong Book',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7897,'TRO_Memory_Book03','Constitution Book',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7898,'VVS_Balmung','VV Strong Balmung',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7899,'Spiritualist_Dagger','Dagger Of Psychic',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7900,'Jenoss_Ring1','Jonathan Family Ring',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7901,'Jenoss_Ring2','Jillberriel Family Ring',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7902,'Jenoss_Ring3','Jessur Family Ring',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7903,'Jenoss_Ring4','Jenoss Family Ring',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7904,'Piano_Key','Piano Key',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7905,'Rok_Star_Badge_','Rok Star Badge',3,20,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7906,'Poppy_Wreath','Poppy Wreath',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7907,'Bobbin_Of_Goddess','Bobbin Of Goddess',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7908,'Louis_Hair_Coupon','Louise\'s Beauty Coupon',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7909,'Stolen_Cookie','Stolen Cookie',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7910,'Stolen_Candy','Stolen Candy',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7911,'Yulia_Hat','Yulia\'s Hat',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7912,'Portable_Snowman','Portable Snowman Machine',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7913,'Test_Certificate','Battle Test Certificate',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7914,'Ancient_Document_TW','Ancient Language Document',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7915,'Copper_Coin_','Bronze Coin',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7916,'Silver_Coin_','Silver Coin',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7917,'Magic_Potion','Magic Potion',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7918,'Particle_Of_Memory','Fragment Of Memory',3,2000,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7919,'Festival_Ticket','Festival Ticket',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7920,'Hero\'s_Arsenal','He\'s Arsenal',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7921,'Essence_Of_Dragon','Essence Of Dragon',3,1000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7922,'RWC_Ticket','RWC Voucher Items',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7923,'KRATHONG_','Krathong',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7928,'Brazilian_Flag_','Brazil National Flag',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7929,'Golden_Coin_','Gold Coin',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7930,'Cowking\'s_Nose_Ring','Devil\'s Cattle Ring',3,0,NULL,1000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7931,'Poison_Kit','Poison Kit',3,1,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7932,'Poison_Herb_Nerium','Poison Herb Nerium',3,1,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7933,'Poison_Herb_Rantana','Poison Herb Rantana',3,1,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7934,'Poison_Herb_Makulata','Poison Herb Makulata',3,1,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7935,'Poison_Herb_Seratum','Poison Herb Seratum',3,1,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7936,'Poison_Herb_Scopolia','Poison Herb Scoporia',3,1,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7937,'Poison_Herb_Amoena','Poison Herb Amoena',3,1,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7938,'Light_Granule','Light Granule',3,1000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7939,'Elder_Branch','Elder Branch',3,1000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7940,'Special_Alloy_Trap','Special Alloy Trap',3,200,NULL,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7941,'Halloween_Ticket','Halloween Ticket',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7942,'Letter_From_Chico','Chico Cesar Letter',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7943,'Caskinya','Caskinya',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7944,'Sealed_Box','Sealed Box',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7945,'Almighty_Charm','Universal Amulet',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7946,'Valentine_Gold_Ring','Gold Ring Of Valentine',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7947,'Valentine_Silver_Ring','Silver Ring Of Valentine',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7948,'Box','Box',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7949,'Woven_Wool','Woven Wool',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7950,'Ayothaya_Ticket','Ayothaya Fest Ticket',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7951,'Gold_Tulip','Golden Tulip Flower',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7952,'Gift_From_Romiros','Gift Of Lomi Ross',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7953,'Gift_From_Juliedge','Gift Of Juliet',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7954,'Festival_Ticket_','Summer Festival Ticket',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7955,'Lost_Card1','Lost Card1',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7956,'Lost_Card2','Lost Card2',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7957,'Lost_Card3','Lost Card3',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7958,'Lost_Card4','Lost Card4',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7959,'Ancient_Gold_Coin','Ancient Gold Coin',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7960,'Ancient_Silver_Coin','Ancient Silver Coin',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7961,'Weapon_Exchange','Weapon Exchange',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7962,'Treasure_Map1','Treasure Map1',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7963,'Treasure_Map2','Treasure Map2',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7964,'Treasure_Map3','Treasure Map3',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7965,'Treasure_Map4','Treasure Map4',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7966,'Weird_Parchment1','Weird Parchment1',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7967,'Weird_Parchment2','Weird Parchment2',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7968,'Weird_Parchment3','Weird Parchment3',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7969,'Weird_Parchment4','Weird Parchment4',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7970,'Unwritten_Letter1','Unwritten Letter1',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7971,'Unwritten_Letter2','Unwritten Letter2',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7972,'Oath_Day_Letter','Oath Day Letter',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7973,'Immortality_Egg','Immortality Egg',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7974,'Illusion_Piece','Illusion Piece',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7975,'Cupid_Choco','Cupid Choco',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7976,'Gf_Magic_Coin','Gf Magic Coin',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7977,'Hunting_Medal_Badge','Hunting Medal Badge',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7978,'Spring_Stanza1','Spring Stanza1',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7979,'Spring_Stanza2','Spring Stanza2',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7980,'Spring_Stanza3','Spring Stanza3',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7981,'Spring_Stanza4','Spring Stanza4',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7982,'Spring_Stanza5','Spring Stanza5',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7983,'Spring_Stanza6','Spring Stanza6',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7984,'Spring_Stanza7','Spring Stanza7',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7985,'Spring_Stanza8','Spring Stanza8',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7986,'Spring_Stanza9','Spring Stanza9',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7987,'Spring_Stanza10','Spring Stanza10',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7988,'Spring_Stanza11','Spring Stanza11',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7989,'Spring_Stanza12','Spring Stanza12',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7990,'Spring_Stanza13','Spring Stanza13',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7991,'Spring_Stanza14','Spring Stanza14',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7992,'Spring_Stanza15','Spring Stanza15',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7993,'Spring_Stanza16','Spring Stanza16',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7994,'Spring_Stanza17','Spring Stanza17',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7995,'Spring_Stanza18','Spring Stanza18',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7996,'Spring_Stanza19','Spring Stanza19',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7997,'Spring_Stanza20','Spring Stanza20',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7998,'Spring_Stanza21','Spring Stanza21',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (7999,'Spring_Stanza22','Spring Stanza22',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
# Pet Eggs
#===================================================================
REPLACE INTO `item_db` VALUES (9001,'Poring_Egg','Poring Egg',7,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (9002,'Drops_Egg','Drops Egg',7,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (9003,'Poporing_Egg','Poporing Egg',7,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (9004,'Lunatic_Egg','Lunatic Egg',7,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (9005,'Picky_Egg','Picky Egg',7,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (9006,'Chonchon_Egg','Chonchon Egg',7,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (9007,'Steel_Chonchon_Egg','Steel Chonchon Egg',7,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (9008,'Hunter_Fly_Egg','Hunter Fly Egg',7,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (9009,'Savage_Bebe_Egg','Savage Babe Egg',7,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (9010,'Baby_Desert_Wolf_Egg','Baby Desert Wolf Egg',7,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (9011,'Rocker_Egg','Rocker Egg',7,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (9012,'Spore_Egg','Spore Egg',7,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (9013,'Poison_Spore_Egg','Poison Spore Egg',7,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (9014,'PecoPeco_Egg','Peco Peco Egg',7,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (9015,'Smokie_Egg','Smokie Egg',7,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (9016,'Yoyo_Egg','Yoyo Egg',7,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (9017,'Orc_Warrior_Egg','Orc Warrior Egg',7,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (9018,'Munak_Egg','Munak Egg',7,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (9019,'Dokkaebi_Egg','Dokebi Egg',7,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (9020,'Sohee_Egg','Sohee Egg',7,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (9021,'Isis_Egg','Isis Egg',7,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (9022,'Green_Petite_Egg','Green Petite Egg',7,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (9023,'Deviruchi_Egg','Deviruchi Egg',7,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (9024,'Bapho_Jr._Egg','Bapho Jr. Egg',7,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (9025,'Bongun_Egg','Bongun Egg',7,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (9026,'Zherlthsh_Egg','Zealotus Egg',7,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (9027,'Alice_Egg','Alice Egg',7,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (9028,'Rice_Cake_Egg','Hard Rice Cake',7,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (9029,'Santa_Goblin_Egg','Christmas Goblin\'s Egg',7,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (9030,'Chung_E_Egg','Green Maiden Egg',7,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (9031,'Spring_Rabbit_Egg','Spring Rabbit Egg',7,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (9032,'Knife_Goblin_Egg','Knife Goblin Egg',7,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (9033,'Flail_Goblin_Egg','Flail Goblin Egg',7,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (9034,'Hammer_Goblin_Egg','Hammer Goblin Egg',7,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (9035,'Red_Deleter_Egg','Red Deleter Egg',7,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (9036,'Diabolic_Egg','Diabolic Egg',7,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (9037,'Wanderer_Egg','Wanderer Egg',7,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (9038,'New_Year_Doll_Egg','New Year Doll Egg',7,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (9039,'Bacsojin_Egg','Bacsojin Egg',7,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (9040,'Civil_Servant_Egg','Civil Servant Egg',7,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (9041,'Leaf_Cat_Egg','Leaf Cat Egg',7,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (9042,'Loli_Ruri_Egg','Loli Ruri Egg',7,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (9043,'Marionette_Egg','Marionette Egg',7,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (9044,'Shinobi_Egg','Shinobi Egg',7,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (9045,'Whisper_Egg','Whisper Egg',7,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (9046,'Goblin_Leader_Egg','Goblin Leader Egg',7,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (9047,'Wicked_Nymph_Egg','Wicked Nymph Egg',7,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (9048,'Miyabi_Ningyo_Egg','Miyabi Ningyo Egg',7,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (9049,'Dullahan_Egg','Dullahan Egg',7,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (9050,'Medusa_Egg','Medusa Egg',7,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (9051,'Stone_Shooter_Egg','Stone Shooter Egg',7,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (9052,'Incubus_Egg','Incubus Egg',7,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (9053,'Golem_Egg','Golem Egg',7,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (9054,'Nightmare_Terror_Egg','Nightmare Terror Egg',7,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (9055,'Succubus_Egg','Succubus Egg',7,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (9056,'Imp_Egg','Imp Egg',7,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
# Pet Accessories
#===================================================================
REPLACE INTO `item_db` VALUES (10001,'Skull_Helm','Skull Helm',8,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (10002,'Monster_Oxygen_Mask','Monster Oxygen Mask',8,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (10003,'Transparent_Headgear','Transparent Head Protector',8,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (10004,'Pacifier','Pacifier',8,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (10005,'Wig','Wig',8,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (10006,'Queen\'s_Hair_Ornament','Queen\'s Hair Ornament',8,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (10007,'Silk_Ribbon','Silk Ribbon',8,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (10008,'Punisher','Punisher',8,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (10009,'Wild_Flower','Wild Flower',8,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (10010,'Battered_Pot','Battered Pot',8,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (10011,'Stellar_Hairpin','Stellar Hairpin',8,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (10012,'Tiny_Egg_Shell','Tiny Egg Shell',8,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (10013,'Backpack','Backpack',8,1500,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (10014,'Rocker_Glasses','Rocker Glasses',8,2000,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (10015,'Green_Lace','Green Lace',8,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (10016,'Golden_Bell','Golden Bell',8,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (10017,'Bark_Shorts','Bark Shorts',8,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (10018,'Monkey_Circlet','Monkey Circlet',8,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (10019,'Red_Muffler','Red Scarf',8,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (10020,'Sword_Of_Grave_Keeper','Grave Keeper\'s Sword',8,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (10021,'Round_Hair_Ornament','Circular Headgear',8,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (10022,'Golden_Earing','Gold Earring',8,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (10023,'Green_Lucky_Bag','Green Jewel Bag',8,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (10024,'Fashionable_Glasses','Fashion Glasses',8,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (10025,'Star_Hairband','Hairband Of Stars',8,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (10026,'Wine_On_Sleeve','Tassel for Durumagi',8,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (10027,'Spirit_Chain_','Pet Soul Ring',8,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (10028,'Nice_Badge','Beautiful Badges',8,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (10029,'Jade_Trinket','Jade Trinket',8,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (10030,'Summer_Fan','Summer Fan',8,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (10031,'Death_Coil','Ring Of Death',8,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (10032,'Queen\'s_Coronet','Queen\'s Coronet',8,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (10033,'Apro_Hair','Afro',8,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (10034,'Ball_Mask','Masked Ball',8,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (10035,'Windup_Spring','Spring',8,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (10036,'Hell_Horn','Horn Of Hell',8,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (10037,'Black_Butterfly_Mask','Black Butterfly Mask',8,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (10038,'Horn_Protector','Horn Barrier',8,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
# Misc "Etc" Books
#===================================================================
REPLACE INTO `item_db` VALUES (11000,'Prontera_Book_01','History book of Prontera',3,8000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (11001,'Adventure_Story01','Adventure Story Vol.1',3,8000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (11002,'Great_Chef_Orleans01','Chef King Orleans Vol.1',3,8000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (11003,'Legend_Of_Kafra01','Kafra Legend Vol.1',3,8000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (11004,'Mercenary_Rebellion','Old Book',3,10000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (11005,'Tyrant_Schmidt','Rune Royal Family Book',3,10000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (11006,'Blood_Flower01','Blood Flower Vol.1',3,8000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (11007,'Blood_Flower02','Blood Flower Vol.2',3,8000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (11008,'Barmund','Biographical Dictionary Copy Edition',3,10000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (11009,'Adventure_Story02','Adventure Story Vol.2',3,8000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (11010,'Reward_List_Book','Battlegrounds Catalog',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (11011,'Barmund_Note','Varmunt\'s Note',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (11012,'Expedition_Report','Expedition Report',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (11013,'Expedition_Report_Vol1','Expedition Report Vol1',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (11014,'Expedition_Report_Vol2','Expedition Report Vol2',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (11015,'Expedition_Report_Vol3','Expedition Report Vol3',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (11016,'Expedition_Report_Vol4','Expedition Report Vol4',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (11017,'Reward_List_Book2','KVM Reward Items Catalog',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (11018,'Splendide_Selling_Item','Splendide Selling Item',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (11019,'Manuk_Selling_Item','Manuk Selling Item',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (11020,'Japan_Book1','Japan Book1',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (11021,'Japan_Book2','Japan Book2',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (11022,'Mix_Cook_Book','Mix Cook Book',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (11023,'Increase_Stamina_Study','Increase Stamina Study',3,10,NULL,50,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (11024,'Vital_Drink_CB','Vital Drink CB',3,10,NULL,50,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (11025,'Swordman_Book_Basic','Swordman Book Basic',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (11026,'Swordman_Book_Practice','Swordman Book Practice',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (11027,'Swrodman_Book_Misc','Swrodman Book Misc',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (11028,'Thief_Book_Basic','Thief Book Basic',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (11029,'Thief_Book_Practice','Thief Book Practice',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (11030,'Thief_Book_Misc','Thief Book Misc',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (11031,'Archer_Book_Basic','Archer Book Basic',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (11032,'Archer_Book_Practice','Archer Book Practice',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (11033,'Archer_Book_Misc','Archer Book Misc',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (11034,'Acol_Book_Basic','Acol Book Basic',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (11035,'Acol_Book_Practice','Acol Book Practice',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (11036,'Acol_Book_Misc','Acol Book Misc',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (11037,'Mage_Book_Basic','Mage Book Basic',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (11038,'Mage_Book_Practice','Mage Book Practice',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (11039,'Mage_Book_Misc','Mage Book Misc',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (11040,'Mer_Book_Basic','Mer Book Basic',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (11041,'Mer_Book_Practice','Mer Book Practice',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (11042,'Mer_Book_Misc','Mer Book Misc',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (11043,'TK_Book_Basic','TK Book Basic',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (11044,'TK_Book_Practice','TK Book Practice',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (11045,'TK_Book_Misc','TK Book Misc',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (11046,'Ninja_Book_Basic','Ninja Book Basic',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (11047,'Ninja_Book_Practice','Ninja Book Practice',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (11048,'Ninja_Book_Misc','Ninja Book Misc',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (11049,'Gun_Book_Basic','Gun Book Basic',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (11050,'Gun_Book_Practice','Gun Book Practice',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (11051,'Gun_Book_Misc','Gun Book Misc',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (11052,'SN_Book_Basic','SN Book Basic',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (11053,'SN_Book_Practice','SN Book Practice',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (11054,'SN_Book_Misc','SN Book Misc',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (11055,'Basic_Adventure','Basic Adventure',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (11056,'Elemental_Spirit_Guide','Elemental Spirit Guide',3,1000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
# More Usable Items
#===================================================================
REPLACE INTO `item_db` VALUES (11500,'Light_Yellow_Pot','Light Yellow Potion',0,550,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(175,235),0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (11501,'Light_White_Pot','Light White Potion',0,1200,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(325,405),0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (11502,'Light_Blue_Pot','Light Blue Potion',0,5000,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal 0,rand(40,60);',NULL,NULL);
REPLACE INTO `item_db` VALUES (11503,'Siege_White_Potion','WoE White Potion',0,0,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(400,500),0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (11504,'Siege_Blue_Potion','WoE Blue Potion',0,0,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal 0,rand(50,70);',NULL,NULL);
REPLACE INTO `item_db` VALUES (11505,'Iris','Iris',0,0,NULL,30,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal 0,150;',NULL,NULL);
REPLACE INTO `item_db` VALUES (11506,'Fanta_Orange','Fanta Orange',0,800,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(50,70),rand(10,12);',NULL,NULL);
REPLACE INTO `item_db` VALUES (11507,'Fanta_Grape','Fanta Grape',0,800,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(50,70),rand(10,12);',NULL,NULL);
REPLACE INTO `item_db` VALUES (11508,'Karada_Meguri_Tea','Karada Meguricha',0,800,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(50,70),rand(10,12);',NULL,NULL);
REPLACE INTO `item_db` VALUES (11509,'Royal_Milk_Tea','Black Tea Kochakaden',0,800,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(50,70),rand(10,12);',NULL,NULL);
REPLACE INTO `item_db` VALUES (11510,'Coke_Zero','Coca Cola Zero',0,800,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(50,70),rand(10,12);',NULL,NULL);
REPLACE INTO `item_db` VALUES (11511,'Coke_No_Cal','Diet Coca Cola',0,800,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(50,70),rand(10,12);',NULL,NULL);
REPLACE INTO `item_db` VALUES (11512,'Coca_Cola','Coca Cola',0,800,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(50,70),rand(10,12);',NULL,NULL);
REPLACE INTO `item_db` VALUES (11513,'Protect_Neck_Candy','Protect Neck Candy',0,200,NULL,1,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(5,25),0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (11514,'Enriched_Slim_Pot','Enriched Slim Pot',0,0,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(335,415),0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (11515,'Coconut','Coconut',0,1500,NULL,120,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(300,400),0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (11516,'Asai_Fruit','Asai Fruit',0,15,NULL,20,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(16,22),0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (11517,'Puri_Potion','Puri Potion',0,20,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(400,600),0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (11518,'N_Blue_Potion','Blue Potion',0,0,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal 0,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (11519,'Beef_Toast','Beef Toast',0,650,NULL,40,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(170,250),0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (11520,'Mora_Mandarin','Mora Mandar',0,500,NULL,20,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal 0,rand(50,80);',NULL,NULL);
REPLACE INTO `item_db` VALUES (11521,'Pingui_Berry_Juice','Pingui Berry Juice',0,500,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(400,800),rand(50,80);',NULL,NULL);
REPLACE INTO `item_db` VALUES (11522,'Red_Raffle_Sap','Red Raffle Sap',0,2000,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(400,800),0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (11523,'Yellow_Raffle_Sap','Yellow Raffle Sap',0,2400,NULL,120,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(600,1000),0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (11524,'White_Raffle_Sap','White Raffle Sap',0,2800,NULL,140,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(800,1200),0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (11525,'Mora_Hip_Tea','Mora HIp Tea',0,20,NULL,150,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(1500,2000),0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (11526,'Rafflecino','Rafflecino',0,20,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal 0,rand(120,160);',NULL,NULL);
REPLACE INTO `item_db` VALUES (11527,'Baklava','Baklava',0,3500,NULL,600,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal 1200,440;',NULL,NULL);
REPLACE INTO `item_db` VALUES (11528,'Kanafeh','Kanafeh',0,1500,NULL,200,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal 300,240;',NULL,NULL);
REPLACE INTO `item_db` VALUES (11529,'MAAMOUL_','Maamoul',0,500,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal 120,60;',NULL,NULL);
REPLACE INTO `item_db` VALUES (11530,'Jujube','Jujube',0,10,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal 30,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (11531,'Coffee','Coffee',0,10,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal 0,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (11701,'Girl_Bunch_Of_Flower','Girl\'s Bouquet',0,20,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(105,145),0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (11702,'Moon_Cookie','Moon Cookie',0,0,NULL,300,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (11703,'Mysterious_Blood','Mystery Blood',0,0,NULL,30,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal 0,rand(25,35);',NULL,NULL);
REPLACE INTO `item_db` VALUES (11704,'KETUPAT_F','Ketupat',0,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(70,90),0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (11705,'Special_White_Potion','Children\'s Potion',0,1,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(425,425),0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (11706,'Steak','Steak',0,1,NULL,200,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(700,1000),0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (11707,'Roasted_Beef','Roast Beef',0,1,NULL,200,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal 0,rand(100,200);',NULL,NULL);
REPLACE INTO `item_db` VALUES (11708,'Fore_Flank_Sirloin','Fore Flank Sirloin',0,20,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(30,50),rand(1,5);',NULL,NULL);
REPLACE INTO `item_db` VALUES (11709,'Fanta_Zero_Lemon','Fanta Zero Lemon',0,800,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(50,70),rand(10,12);',NULL,NULL);
REPLACE INTO `item_db` VALUES (11710,'Sakura_Mist','Sakura Mist',0,800,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(50,70),rand(10,12);',NULL,NULL);
REPLACE INTO `item_db` VALUES (11711,'Sakura_Milk_Tea','Sakura Milk Tea',0,800,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(50,70),rand(10,12);',NULL,NULL);
REPLACE INTO `item_db` VALUES (11712,'First_Leaf_Tea','Flower',0,800,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(50,70),rand(10,12);',NULL,NULL);
REPLACE INTO `item_db` VALUES (12000,'Cold_Scroll_2_5','Level 5 Frost Diver',11,2000,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemskill "MG_FROSTDIVER",5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12001,'Holy_Scroll_1_3','Level 3 Heal',11,2000,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemskill "AL_HEAL",3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12002,'Holy_Scroll_1_5','Level 5 Heal',11,2000,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemskill "AL_HEAL",5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12003,'Holy_Scroll_2_1','Level 1 Teleport',11,1000,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemskill "AL_TELEPORT",1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12004,'Arrow_Container','Quiver',2,2,NULL,250,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 1750,500;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12005,'Iron_Arrow_Container','Iron Arrow Quiver',2,2,NULL,250,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 1770,500;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12006,'Steel_Arrow_Container','Steel Arrow Quiver',2,2,NULL,250,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 1753,500;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12007,'Ori_Arrow_Container','Oridecon Arrow Quiver',2,2,NULL,250,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 1765,500;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12008,'Fire_Arrow_Container','Fire Arrow Quiver',2,2,NULL,250,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 1752,500;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12009,'Silver_Arrow_Container','Silver Arrow Quiver',2,2,NULL,250,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 1751,500;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12010,'Wind_Arrow_Container','Wind Arrow Quiver',2,2,NULL,250,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 1755,500;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12011,'Stone_Arrow_Container','Stone Arrow Quiver',2,2,NULL,250,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 1756,500;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12012,'Crystal_Arrow_Container','Crystal Arrow Quiver',2,2,NULL,250,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 1754,500;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12013,'Shadow_Arrow_Container','Shadow Arrow Quiver',2,2,NULL,250,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 1767,500;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12014,'Imma_Arrow_Container','Immaterial Arrow Quiver',2,2,NULL,250,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 1757,500;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12015,'Rusty_Arrow_Container','Rusty Arrow Quiver',2,2,NULL,250,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 1762,500;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12016,'Speed_Up_Potion','Speed Potion',2,2,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_SPEEDUP1,5000,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12017,'Slow_Down_Potion','Slow Potion',2,2,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_SlowDown,5000,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12018,'Fire_Cracker','Firecracker',2,2,NULL,20,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12019,'Holy_Egg','Holy Egg',11,2,NULL,150,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemskill "ALL_RESURRECTION",2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12020,'Water_Of_Darkness','Cursed Water',11,2,NULL,30,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemskill "ITEM_ENCHANTARMS",8;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12021,'Pork_Belly','Pork',0,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(70,99),0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12022,'Spareribs','Galbi',0,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(70,99),0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12023,'Giftbox_China','Wrapped Box',2,1000,NULL,200,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getrandgroupitem(IG_GiftBoxChina),1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12024,'Red_Pouch_Of_Surprise','Red Pouch',2,50,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'monster "this",-1,-1,"--ja--",-4,1,"";',NULL,NULL);
REPLACE INTO `item_db` VALUES (12025,'Egg_Boy','Dano Festival Egg',2,1000,NULL,200,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getrandgroupitem(IG_EggBoy),1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12026,'Egg_Girl','Dano Festival Egg',2,1000,NULL,200,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getrandgroupitem(IG_EggGirl),1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12027,'Giggling_Box','Giggling Box',2,1000,NULL,200,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'percentheal 9,0; sc_start SC_Curse,30000,0,3000,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12028,'Box_Of_Thunder','Box of Thunder',2,1000,NULL,200,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_SPEEDUP0,20000,25;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12029,'Gloomy_Box','Box of Gloom',11,1000,NULL,200,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemskill "AC_CONCENTRATION",1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12030,'Box_Of_Grudge','Box of Resentment',2,1000,NULL,200,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_ATKPOTION,60000,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12031,'Sleepy_Box','Box of Drowsiness',2,1000,NULL,200,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_MATKPOTION,60000,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12032,'Box_Of_Storm','Box of Storms',11,1000,NULL,200,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemskill "ITEM_ENCHANTARMS",2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12033,'Box_Of_Sunlight','Box of Sunlight',2,1000,NULL,200,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_Intravision,30000,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12034,'Painting_Box','Box of Panting',2,1000,NULL,200,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'percentheal 0,9; sc_start SC_Silence,30000,0,3000,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12035,'Lotto_Box01','Lotto Box 01',2,0,NULL,20,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem rand(7361,7370),1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12036,'Lotto_Box02','Lotto Box 02',2,0,NULL,20,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem rand(7371,7380),1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12037,'Lotto_Box03','Lotto Box 03',2,0,NULL,20,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem rand(7381,7390),1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12038,'Lotto_Box04','Lotto Box 04',2,0,NULL,20,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getrandgroupitem(IG_LottoBox),1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12039,'Lotto_Box05','Lotto Box 05',2,0,NULL,20,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem rand(7542,7546),1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12040,'Stone_Of_Intelligence_','Stone of Sage',2,100000,NULL,300,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'homevolution;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12041,'Str_Dish01','Fried Grasshopper Legs',0,2000,NULL,60,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_STRFOOD,1200000,1; percentheal 5,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12042,'Str_Dish02','Seasoned Sticky Webfoot',0,4000,NULL,500,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_STRFOOD,1200000,2; percentheal 5,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12043,'Str_Dish03','Bomber Steak',0,6000,NULL,500,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_STRFOOD,1200000,3; percentheal 5,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12044,'Str_Dish04','Herb Marinade Beef',0,8000,NULL,500,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_STRFOOD,1200000,4; percentheal 5,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12045,'Str_Dish05','Lutie Lady\'s Pancake',0,10000,NULL,500,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_STRFOOD,1200000,5; percentheal 10,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12046,'Int_Dish01','Grape Juice Herbal Tea',0,2000,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_INTFOOD,1200000,1; percentheal 0,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12047,'Int_Dish02','Autumn Red Tea',0,4000,NULL,500,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_INTFOOD,1200000,2; percentheal 0,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12048,'Int_Dish03','Honey Herbal Tea',0,6000,NULL,500,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_INTFOOD,1200000,3; percentheal 0,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12049,'Int_Dish04','Morroc Fruit Wine',0,8000,NULL,300,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_INTFOOD,1200000,4; percentheal 0,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12050,'Int_Dish05','Mastela Fruit Wine',0,10000,NULL,400,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_INTFOOD,1200000,5; percentheal 0,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12051,'Vit_Dish01','Steamed Crab Nippers',0,2000,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_VITFOOD,1200000,1; percentheal 5,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12052,'Vit_Dish02','Assorted Seafood',0,4000,NULL,200,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_VITFOOD,1200000,2; percentheal 5,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12053,'Vit_Dish03','Clam Soup',0,6000,NULL,300,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_VITFOOD,1200000,3; percentheal 5,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12054,'Vit_Dish04','Seasoned Jellyfish',0,8000,NULL,500,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_VITFOOD,1200000,4; percentheal 5,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12055,'Vit_Dish05','Spicy Fried Bao',0,10000,NULL,800,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_VITFOOD,1200000,5; percentheal 10,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12056,'Agi_Dish01','Frog Egg Squid Ink Soup',0,2000,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_AGIFOOD,1200000,1; percentheal 3,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12057,'Agi_Dish02','Smooth Noodle',0,4000,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_AGIFOOD,1200000,2; percentheal 3,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12058,'Agi_Dish03','Tentacle Cheese Gratin',0,6000,NULL,500,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_AGIFOOD,1200000,3; percentheal 3,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12059,'Agi_Dish04','Lutie Cold Noodle',0,8000,NULL,400,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_AGIFOOD,1200000,4; percentheal 3,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12060,'Agi_Dish05','Steamed Bat Wing in Pumpkin',0,10000,NULL,500,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_AGIFOOD,1200000,5; percentheal 6,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12061,'Dex_Dish01','Honey Grape Juice',0,2000,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_DEXFOOD,1200000,1; percentheal 2,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12062,'Dex_Dish02','Chocolate Mousse Cake',0,4000,NULL,200,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_DEXFOOD,1200000,2; percentheal 2,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12063,'Dex_Dish03','Fruit Mix',0,6000,NULL,200,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_DEXFOOD,1200000,3; percentheal 2,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12064,'Dex_Dish04','Cream Sandwich',0,8000,NULL,500,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_DEXFOOD,1200000,4; percentheal 2,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12065,'Dex_Dish05','Green Salad',0,10000,NULL,200,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_DEXFOOD,1200000,5; percentheal 5,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12066,'Luk_Dish01','Fried Monkey Tails',0,2000,NULL,60,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_LUKFOOD,1200000,1; percentheal 3,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12067,'Luk_Dish02','Mixed Juice',0,4000,NULL,200,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_LUKFOOD,1200000,2; percentheal 3,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12068,'Luk_Dish03','Fried Sweet Potato',0,6000,NULL,500,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_LUKFOOD,1200000,3; percentheal 4,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12069,'Luk_Dish04','Steamed Ancient Lips',0,8000,NULL,500,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_LUKFOOD,1200000,4; percentheal 4,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12070,'Luk_Dish05','Fried Scorpion Tails',0,10000,NULL,400,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_LUKFOOD,1200000,5; percentheal 5,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12071,'Str_Dish06','Shiny Marinade Beef',0,20000,NULL,800,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_STRFOOD,1200000,6; percentheal 10,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12072,'Str_Dish07','Whole Roast',0,40000,NULL,1000,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_STRFOOD,1200000,7; percentheal 10,4;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12073,'Str_Dish08','Bearfoot Special',0,60000,NULL,500,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_STRFOOD,1200000,8; percentheal 15,6;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12074,'Str_Dish09','Tendon Satay',0,80000,NULL,1000,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_STRFOOD,1200000,9; percentheal 15,8;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12075,'Str_Dish10','Steamed Tongue',0,100000,NULL,1000,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_STRFOOD,1200000,10; percentheal 20,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12076,'Int_Dish06','Red Mushroom Wine',0,20000,NULL,300,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_INTFOOD,1200000,6; percentheal 2,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12077,'Int_Dish07','Special Royal Jelly Herbal Tea',0,40000,NULL,800,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_INTFOOD,1200000,7; percentheal 4,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12078,'Int_Dish08','Royal Family Tea',0,60000,NULL,1000,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_INTFOOD,1200000,8; percentheal 6,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12079,'Int_Dish09','Tristan XII',0,80000,NULL,1000,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_INTFOOD,1200000,9; percentheal 8,15;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12080,'Int_Dish10','Dragon Breath Cocktail',0,100000,NULL,1000,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_INTFOOD,1200000,10; percentheal 10,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12081,'Vit_Dish06','Awfully Bitter Bracer',0,20000,NULL,500,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_VITFOOD,1200000,6; percentheal 13,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12082,'Vit_Dish07','Sumptuous Feast',0,40000,NULL,400,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_VITFOOD,1200000,7; percentheal 16,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12083,'Vit_Dish08','Giant Burito',0,60000,NULL,1000,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_VITFOOD,1200000,8; percentheal 19,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12084,'Vit_Dish09','Ascending Dragon Soup',0,80000,NULL,1000,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_VITFOOD,1200000,9; percentheal 22,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12085,'Vit_Dish10','Immortal Stew',0,100000,NULL,1000,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_VITFOOD,1200000,10; percentheal 25,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12086,'Agi_Dish06','Chile Shrimp Gratin',0,20000,NULL,800,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_AGIFOOD,1200000,6; percentheal 7,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12087,'Agi_Dish07','Steamed Alligator with Vegetable',0,40000,NULL,800,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_AGIFOOD,1200000,7; percentheal 8,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12088,'Agi_Dish08','Incredibly Spicy Curry',0,60000,NULL,1000,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_AGIFOOD,1200000,8; percentheal 9,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12089,'Agi_Dish09','Special Meat Stew',0,80000,NULL,1000,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_AGIFOOD,1200000,9; percentheal 10,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12090,'Agi_Dish10','Steamed Desert Scorpions',0,100000,NULL,1000,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_AGIFOOD,1200000,10; percentheal 15,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12091,'Dex_Dish06','Peach Cake',0,20000,NULL,800,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_DEXFOOD,1200000,6; percentheal 5,6;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12092,'Dex_Dish07','Soul Haunted Bread',0,40000,NULL,800,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_DEXFOOD,1200000,7; percentheal 5,7;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12093,'Dex_Dish08','Special Toast',0,60000,NULL,1000,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_DEXFOOD,1200000,8; percentheal 5,8;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12094,'Dex_Dish09','Heavenly Fruit Juice',0,80000,NULL,500,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_DEXFOOD,1200000,9; percentheal 5,9;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12095,'Dex_Dish10','Hwergelmir\'s Tonic',0,100000,NULL,1000,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_DEXFOOD,1200000,10; percentheal 10,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12096,'Luk_Dish06','Lucky Soup',0,20000,NULL,300,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_LUKFOOD,1200000,6; percentheal 6,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12097,'Luk_Dish07','Assorted Shish Kebob',0,40000,NULL,800,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_LUKFOOD,1200000,7; percentheal 7,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12098,'Luk_Dish08','Strawberry Flavored Rice Ball',0,60000,NULL,400,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_LUKFOOD,1200000,8; percentheal 9,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12099,'Luk_Dish09','Blood Flavored Soda',0,80000,NULL,1000,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_LUKFOOD,1200000,9; percentheal 10,4;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12100,'Luk_Dish10','Cooked Nine Tail\'s Tails',0,100000,NULL,500,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_LUKFOOD,1200000,10; percentheal 14,8;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12101,'Citron','Citron',0,20,NULL,300,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12102,'Meat_Skewer','Grilled Skewer',0,20,NULL,300,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12103,'Bloody_Dead_Branch','Bloody Branch',2,10000,NULL,200,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'monster "this",-1,-1,"--ja--",-3,1,"";',NULL,NULL);
REPLACE INTO `item_db` VALUES (12104,'Random_Quiver','Random Quiver',2,10000,NULL,200,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getrandgroupitem(IG_Quiver),1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12105,'Set_Of_Taiming_Item','Taming Gift Set',2,10000,NULL,200,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getrandgroupitem(IG_Taming),1; getrandgroupitem(IG_Taming),1; getrandgroupitem(IG_Taming),1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12106,'Accessory_Box','Jewelry Box',2,10000,NULL,200,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getrandgroupitem(IG_Accesory),1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12107,'Wrapped_Mask','Wrapped Mask',2,10000,NULL,200,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getrandgroupitem(IG_Mask),1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12108,'Bundle_Of_Magic_Scroll','Scroll Package',2,10000,NULL,200,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getrandgroupitem(IG_Scroll),1; getrandgroupitem(IG_Scroll),1; getrandgroupitem(IG_Scroll),1; getrandgroupitem(IG_Scroll),1; getrandgroupitem(IG_Scroll),1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12109,'Poring_Box','Poring Box',2,10000,NULL,200,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'monster "this",-1,-1,"--ja--",-2,1,"";',NULL,NULL);
REPLACE INTO `item_db` VALUES (12110,'First_Aid_Kit','First Aid Kit',2,10000,NULL,200,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getrandgroupitem(IG_FirstAid),1; getrandgroupitem(IG_FirstAid),1; getrandgroupitem(IG_FirstAid),1; getrandgroupitem(IG_FirstAid),1; getrandgroupitem(IG_FirstAid),1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12111,'Food_Package','Bundle of Food',2,10000,NULL,200,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getrandgroupitem(IG_FoodBag),1; getrandgroupitem(IG_FoodBag),1; getrandgroupitem(IG_FoodBag),1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12112,'Tropical_Sograt','Tropical Sograt',2,1000,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_Curse,10000,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12113,'Vermilion_The_Beach','Vermilion on the Beach',2,1000,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_Stun,10000,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12114,'Elemental_Fire','Elemental Converter',11,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemskill "ITEM_ENCHANTARMS",4;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12115,'Elemental_Water','Elemental Converter',11,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemskill "ITEM_ENCHANTARMS",2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12116,'Elemental_Earth','Elemental Converter',11,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemskill "ITEM_ENCHANTARMS",3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12117,'Elemental_Wind','Elemental Converter',11,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemskill "ITEM_ENCHANTARMS",5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12118,'Resist_Fire','Fireproof Potion',2,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start4 SC_ARMOR_ELEMENT_FIRE,1200000,-15,0,20,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12119,'Resist_Water','Coldproof Potion',2,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start4 SC_ARMOR_ELEMENT_WATER,1200000,20,0,0,-15;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12120,'Resist_Earth','Earthproof Potion',2,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start4 SC_ARMOR_ELEMENT_EARTH,1200000,0,20,-15,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12121,'Resist_Wind','Thunderproof Potion',2,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start4 SC_ARMOR_ELEMENT_WIND,1200000,0,-15,0,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12122,'Sesame_Pastry','Sesame Pastry',2,2,NULL,70,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_HITFOOD,1200000,30;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12123,'Honey_Pastry','Honey Pastry',2,2,NULL,70,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_FLEEFOOD,1200000,30;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12124,'Rainbow_Cake','Rainbow Cake',2,2,NULL,70,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_BATKFOOD,1200000,10; sc_start SC_MATKFOOD,120000,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12125,'Outdoor_Cooking_Kits','Outdoor Cooking Kit',2,500,NULL,20,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'cooking 11;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12126,'Indoor_Cooking_Kits','Home Cooking Kit',2,1000,NULL,30,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'cooking 12;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12127,'High_end_Cooking_Kits','Professional Cooking Kit',2,2000,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'cooking 13;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12128,'Imperial_Cooking_Kits','Royal Cooking Kit',2,5000,NULL,70,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'cooking 14;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12129,'Fantastic_Cooking_Kits','Fantastic Cooking Kit',2,10000,NULL,70,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'cooking 15;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12130,'Cookie_Bag','Cookie Bag',2,2,NULL,70,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getrandgroupitem(IG_CookieBag),1; getrandgroupitem(IG_CookieBag),1; getrandgroupitem(IG_CookieBag),1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12131,'Lucky_Potion','Lucky Potion',0,2,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12132,'Red_Bag','Santa\'s Bag',2,0,NULL,200,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_Xmas,600000,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12133,'Ice_Cream_','McDonald\'s Ice Cone',0,0,NULL,80,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'if(gettime(DT_DAYOFMONTH)!=MDiceCone) { set MDiceCone,gettime(DT_DAYOFMONTH); percentheal 50,50; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (12134,'Red_Envelope','Red Envelope',2,1,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'set Zeny,Zeny+rand(1000,10000);',NULL,NULL);
REPLACE INTO `item_db` VALUES (12135,'Green_Ale','Green Ale',2,20,NULL,30,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'percentheal 50,50; sc_start SC_Confusion,10000,0,1000,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12136,'Women\'s_Bundle','Women\'s Bundle',2,0,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem callfunc("F_Rand",558,529,2668,7518),1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12137,'1st_Stage_Prize','First Stage Prize',2,0,NULL,0,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12138,'2nd_Stage_Prize','Second Stage Prize',2,0,NULL,0,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12139,'3rd_Stage_Prize','Third Stage Prize',2,0,NULL,0,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12140,'4th_Stage_Prize','Fourth Stage Prize',2,0,NULL,0,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12141,'5th_Stage_Prize','Fifth Stage Prize',2,0,NULL,0,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12142,'Magic_Book','Book of Magic',2,0,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_AGIFOOD,1800000,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12143,'Red_Can','Red Can',2,50000,NULL,300,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12144,'Sphere_Case_Wind','Lightning Sphere Pack',2,2,NULL,350,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 13204,500;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12145,'Sphere_Case_Darkness','Blind Sphere Pack',2,2,NULL,350,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 13206,500;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12146,'Sphere_Case_Poison','Poison Sphere Pack',2,2,NULL,350,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 13205,500;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12147,'Sphere_Case_Water','Freezing Sphere Pack',2,2,NULL,350,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 13207,500;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12148,'Sphere_Case_Fire','Flare Sphere Pack',2,2,NULL,350,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 13203,500;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12149,'Bullet_Case','Cartridge',2,2,NULL,250,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 13200,500;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12150,'Bullet_Case_Blood','Blood Cartridge',2,2,NULL,250,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 13202,500;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12151,'Bullet_Case_Silver','Silver Cartridge',2,2,NULL,250,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 13201,500;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12152,'Special_Box','Special Present',2,0,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12153,'Bow_Mercenary_Scroll1','Bowman Scroll 1',2,2,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'mercenary_create 6017,1800000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12154,'Bow_Mercenary_Scroll2','Bowman Scroll 2',2,2,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'mercenary_create 6018,1800000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12155,'Bow_Mercenary_Scroll3','Bowman Scroll 3',2,2,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'mercenary_create 6019,1800000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12156,'Bow_Mercenary_Scroll4','Bowman Scroll 4',2,2,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'mercenary_create 6020,1800000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12157,'Bow_Mercenary_Scroll5','Bowman Scroll 5',2,2,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'mercenary_create 6021,1800000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12158,'Bow_Mercenary_Scroll6','Bowman Scroll 6',2,2,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'mercenary_create 6022,1800000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12159,'Bow_Mercenary_Scroll7','Bowman Scroll 7',2,2,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'mercenary_create 6023,1800000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12160,'Bow_Mercenary_Scroll8','Bowman Scroll 8',2,2,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'mercenary_create 6024,1800000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12161,'Bow_Mercenary_Scroll9','Bowman Scroll 9',2,2,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'mercenary_create 6025,1800000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12162,'Bow_Mercenary_Scroll10','Bowman Scroll 10',2,2,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'mercenary_create 6026,1800000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12163,'SwordMercenary_Scroll1','Fencer Scroll 1',2,2,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'mercenary_create 6037,1800000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12164,'SwordMercenary_Scroll2','Fencer Scroll 2',2,2,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'mercenary_create 6038,1800000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12165,'SwordMercenary_Scroll3','Fencer Scroll 3',2,2,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'mercenary_create 6039,1800000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12166,'SwordMercenary_Scroll4','Fencer Scroll 4',2,2,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'mercenary_create 6040,1800000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12167,'SwordMercenary_Scroll5','Fencer Scroll 5',2,2,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'mercenary_create 6041,1800000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12168,'SwordMercenary_Scroll6','Fencer Scroll 6',2,2,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'mercenary_create 6042,1800000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12169,'SwordMercenary_Scroll7','Fencer Scroll 7',2,2,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'mercenary_create 6043,1800000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12170,'SwordMercenary_Scroll8','Fencer Scroll 8',2,2,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'mercenary_create 6044,1800000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12171,'SwordMercenary_Scroll9','Fencer Scroll 9',2,2,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'mercenary_create 6045,1800000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12172,'SwordMercenary_Scroll10','Fencer Scroll 10',2,2,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'mercenary_create 6046,1800000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12173,'SpearMercenary_Scroll1','Spearman Scroll 1',2,2,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'mercenary_create 6027,1800000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12174,'SpearMercenary_Scroll2','Spearman Scroll 2',2,2,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'mercenary_create 6028,1800000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12175,'SpearMercenary_Scroll3','Spearman Scroll 3',2,2,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'mercenary_create 6029,1800000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12176,'SpearMercenary_Scroll4','Spearman Scroll 4',2,2,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'mercenary_create 6030,1800000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12177,'SpearMercenary_Scroll5','Spearman Scroll 5',2,2,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'mercenary_create 6031,1800000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12178,'SpearMercenary_Scroll6','Spearman Scroll 6',2,2,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'mercenary_create 6032,1800000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12179,'SpearMercenary_Scroll7','Spearman Scroll 7',2,2,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'mercenary_create 6033,1800000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12180,'SpearMercenary_Scroll8','Spearman Scroll 8',2,2,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'mercenary_create 6034,1800000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12181,'SpearMercenary_Scroll9','Spearman Scroll 9',2,2,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'mercenary_create 6035,1800000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12182,'SpearMercenary_Scroll10','Spearman Scroll 10',2,2,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'mercenary_create 6036,1800000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12183,'Holy_Arrow_Quiver','Holy Arrow Quiver',2,2,NULL,250,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 1772,500;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12184,'Mercenary_Red_Potion','Mercenary Red Potion',2,500,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'mercenary_heal 1000,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12185,'Mercenary_Blue_Potion','Mercenary Blue Potion',2,1000,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'mercenary_heal 0,100;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12186,'Red_Box','Old Red Box',2,50000,NULL,200,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getrandgroupitem(IG_RedBox),1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12187,'Green_Box','Old Green Box',2,50000,NULL,200,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getrandgroupitem(IG_GreenBox),1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12188,'Magical_Moon_Cake','Grace Moon Cake',0,20,NULL,300,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'percentheal 50,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12189,'Red_Box_','Old Red Box',2,50000,NULL,200,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getrandgroupitem(IG_RedBox_2),1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12190,'Moon_Cake','Moon Cake',2,2,NULL,300,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12191,'Special_Moon_Cake','Special Moon Cake',2,2,NULL,500,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12192,'Pumpkin_Pie','Pumpkin Pie',0,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'percentheal 5,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12193,'Brezel','Pretzel',2,20,NULL,20,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12194,'Hometown_Gift','Hometown Gift',2,20,NULL,200,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getrandgroupitem(IG_HometownGift),1; getrandgroupitem(IG_HometownGift),1; getrandgroupitem(IG_HometownGift),1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12195,'Plain_Rice_Cake','Plain Rice Cake',0,20,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'percentheal 0,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12196,'Hearty_Rice_Cake','Hearty Rice Cake',0,20,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'percentheal 50,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12197,'Salty_Rice_Cake','Salty Rice Cake',0,20,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'percentheal 10,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12198,'Lucky_Rice_Cake','Lucky Rice Cake',2,20,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_INCLUK,1200000,21;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12199,'Rice_Scroll','Scroll of Magic',2,0,NULL,0,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12200,'Event_Cake','X-mas Cake',11,20,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemskill "PR_MAGNIFICAT",3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12201,'Red_Box_C','Commonplace Red Box',2,20,NULL,200,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
# Cash Shop Usable Items
REPLACE INTO `item_db` VALUES (12202,'Str_Dish10_','Steamed Tongue',0,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_FOOD_STR_CASH,1800000,10; percentheal 15,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12203,'Agi_Dish10_','Steamed Scorpion',0,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_FOOD_AGI_CASH,1800000,10; percentheal 15,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12204,'Int_Dish10_','Dragon Breath Cocktail',0,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_FOOD_INT_CASH,1800000,10; percentheal 15,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12205,'Dex_Dish10_','Hwergelmir\'s Tonic',0,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_FOOD_DEX_CASH,1800000,10; percentheal 15,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12206,'Luk_Dish10_','Cooked Nine Tail\'s Tails',0,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_FOOD_LUK_CASH,1800000,10; percentheal 15,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12207,'Vit_Dish10_','Stew Of Immortality',0,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_FOOD_VIT_CASH,1800000,10; percentheal 15,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12208,'Battle_Manual','Battle Manual',2,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_EXPBOOST,1800000,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12209,'Insurance','Life Insurance',2,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_LIFEINSURANCE,1800000,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12210,'Bubble_Gum','Bubble Gum',2,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_ITEMBOOST,1800000,200;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12211,'Kafra_Card','Kafra Card',2,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'callfunc "F_CashStore";',NULL,NULL);
REPLACE INTO `item_db` VALUES (12212,'Giant_Fly_Wing','Giant Fly Wing',2,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'callfunc "F_CashPartyCall";',NULL,NULL);
REPLACE INTO `item_db` VALUES (12213,'Neuralizer','Neuralizer',11,2,NULL,0,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'callfunc "F_CashReset";',NULL,NULL);
REPLACE INTO `item_db` VALUES (12214,'Convex_Mirror','Convex Mirror',2,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_BOSSMAPINFO,600000,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12215,'Blessing_10_Scroll','LV10 Blessing Scroll',2,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'skilleffect "AL_BLESSING",0; sc_start SC_BLESSING,240000,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12216,'Inc_Agi_10_Scroll','LV10 Agil Scroll',2,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'if(Hp>15) { skilleffect "AL_INCAGI",0; sc_start SC_INCREASEAGI,240000,10; heal -15,0; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (12217,'Aspersio_5_Scroll','LV5 Aspersio Scroll',2,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'if(countitem(523)>0) { skilleffect "PR_ASPERSIO",0; sc_start SC_ASPERSIO,180000,5; delitem 523,1; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (12218,'Assumptio_5_Scroll','LV5 Assumptio Scroll',2,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_ASSUMPTIO,100000,5; skilleffect "HP_ASSUMPTIO",0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12219,'Wind_Walk_10_Scroll','LV10 Wind Walker Scroll',2,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'skilleffect "SN_WINDWALK",0; sc_start SC_WINDWALK,250000,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12220,'Adrenaline_Scroll','LV5 Adrenaline Scroll',2,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'set .@type,getiteminfo(getequipid(EQI_HAND_R),11); if (.@type==W_1HAXE||.@type==W_2HAXE||.@type==W_MACE) { skilleffect "BS_ADRENALINE",0; sc_start SC_ADRENALINE,150000,5; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (12221,'Megaphone_','Megaphone',2,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'input @megaphone$; announce strcharinfo(0) + ": " + @megaphone$,bc_all,0xFF0000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12225,'Sweet_Candy_Striper','Sweet Candy Cane',2,20,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'pet 1245;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12226,'Examination1','Examination 1',0,20,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_SPEEDUP0,5400000,25; percentheal 100,100; sc_start SC_STRFOOD,5400000,10; sc_start SC_DEXFOOD,5400000,5; sc_start SC_ATKPOTION,5400000,22; sc_start SC_MATKFOOD,5400000,15;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12227,'Examination2','Examination 2',0,20,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_SPEEDUP0,5400000,25; percentheal 100,100; sc_start SC_INTFOOD,5400000,8; sc_start SC_VITFOOD,5400000,7; sc_start SC_LUKFOOD,5400000,7; sc_start SC_ATKPOTION,5400000,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12228,'Examination3','Examination 3',0,20,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_SPEEDUP0,5400000,25; percentheal 100,100; sc_start SC_AGIFOOD,5400000,15; sc_start SC_ATKPOTION,5400000,52; sc_start SC_MATKFOOD,5400000,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12229,'Examination4','Examination 4',0,20,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_SPEEDUP0,5400000,25; percentheal 100,100; sc_start SC_STRFOOD,5400000,3; sc_start SC_AGIFOOD,5400000,5; sc_start SC_VITFOOD,5400000,10; sc_start SC_MATKFOOD,5400000,52;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12230,'Examination5','Examination 5',0,20,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_SPEEDUP0,5400000,25; percentheal 100,100; sc_start SC_INTFOOD,5400000,3; sc_start SC_DEXFOOD,5400000,12; sc_start SC_ATKPOTION,5400000,20; sc_start SC_MATKFOOD,5400000,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12231,'Examination6','Examination 6',0,20,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'percentheal 100,100; sc_start SC_SPEEDUP0,5400000,25; sc_start SC_STRFOOD,5400000,6; sc_start SC_DEXFOOD,5400000,6; sc_start SC_AGIFOOD,5400000,6; sc_start SC_INTFOOD,5400000,6; sc_start SC_VITFOOD,5400000,6; sc_start SC_LUKFOOD,5400000,6; sc_start SC_ATKPOTION,5400000,24; sc_start SC_MATKFOOD,5400000,24;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12232,'Gingerbread','Ginger Bread',2,20,NULL,150,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_ASPDPOTION1,900000,0; sc_start SC_SPEEDUP0,900000,25;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12233,'Kvass','Kvass',0,20,NULL,200,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'percentheal 100,100;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12234,'Cacao99','Fierce Cacao 99%',0,20,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'percentheal 25,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12235,'Strawberry_Choco','Chocolate Strawberry',2,20,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'percentheal 0,5; skilleffect "AL_BLESSING",0; sc_start SC_BLESSING,240000,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12236,'Choco_Tart','Chocolate Tart',11,20,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'percentheal 5,0; itemskill "AL_ANGELUS",5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12237,'Choco_Lump','Junky Chocolate',2,0,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'percentheal 0,5; sc_start SC_Poison,18000,0; sc_start SC_Bleeding,18000,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12238,'New_Year_Rice_Cake_1','New Year Rice Cake',2,20,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_DPoison,10000,0,1000,0; sc_start SC_Poison,50000,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12239,'New_Year_Rice_Cake_2','New Year Rice Cake',2,20,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_DPoison,10000,0,1000,0; sc_start SC_Poison,50000,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12240,'Old_Yellow_Box','Old Yellow Box',2,20,NULL,200,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getrandgroupitem(IG_YellowBox),1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12241,'M_Center_Potion','Mercenary Concentration Potion',2,800,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'mercenary_sc_start SC_ASPDPOTION0,1800000,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12242,'M_Awakening_Potion','Mercenary Awakening Potion',2,1500,NULL,150,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'mercenary_sc_start SC_ASPDPOTION1,1800000,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12243,'M_Berserk_Potion','Mercenary Berserk Potion',2,3000,NULL,200,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'mercenary_sc_start SC_ASPDPOTION2,1800000,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12244,'Old_Gift_Box','Old Gift Box',2,20,NULL,200,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getrandgroupitem(IG_OldGiftBox),1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12245,'Green_Ale_US','Green Ale',0,5000,NULL,500,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'percentheal 100,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12246,'Magic_Card_Album','Mystical Card Album',2,10000,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getrandgroupitem(IG_MagicCardAlbum),1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12247,'Halohalo','Halo-Halo',2,2,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,20,NULL,NULL,'sc_start SC_INCALLSTATUS,600000,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12248,'Masquerade_Ball_Box','Fancy Ball Box',2,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getrandgroupitem(IG_Masquerade),1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12249,'Payroll_Of_Kafra_','Payment Statement for Kafra Employee',2,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12250,'Str_Dish10_M','Steamed Tongue',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_STRFOOD,3600000,10; percentheal 20,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12251,'Agi_Dish10_M','Steamed Desert Scorpions',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_AGIFOOD,3600000,10; percentheal 15,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12252,'Int_Dish10_M','Dragon Breath Cocktail',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_INTFOOD,3600000,10; percentheal 10,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12253,'Dex_Dish10_M','Hwergelmir\'s Tonic',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_DEXFOOD,3600000,10; percentheal 10,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12254,'Luk_Dish10_M','Cooked Nine Tail',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_LUKFOOD,3600000,10; percentheal 14,8;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12255,'Vit_Dish10_M','Immortal Stew',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_VITFOOD,3600000,10; percentheal 25,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12256,'PRO_Gift_Box','PRO Gift Box',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12257,'Cold_Medicine','Cold Medicine',0,20,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,50,NULL,NULL,'percentheal 25,25;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12258,'Bombring_Box','Bomb Poring Box',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'if(strcharinfo(3)=="job3_rang02") { monster "this",-1,-1,"--ja--",1904,1,""; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (12259,'Miracle_Medicine','Miracle Tonic',2,0,NULL,0,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getexp2(3000000,1500000);',NULL,NULL);
REPLACE INTO `item_db` VALUES (12260,'Cool_Summer_Outfit','Cool Summer Outfit',2,0,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_Summer,600000,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12261,'Secret_Medicine','Leap of Fantasy',2,0,NULL,0,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getexp2(2000000,1000000);',NULL,NULL);
REPLACE INTO `item_db` VALUES (12262,'Inspector_Certificate_','Authoritative Badge',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_SPEEDUP0,540000,25;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12263,'Comp_Battle_Manual','Field Manual',2,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_EXPBOOST,1800000,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12264,'Comp_Bubble_Gum','Bubble Gum',2,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_ITEMBOOST,1800000,200;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12265,'Comp_Insurance','Life Insurrance',2,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_LIFEINSURANCE,1800000,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12266,'Sesame_Pastry_','Sesame Pastry',2,2,NULL,70,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_HITFOOD,1200000,30;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12267,'Honey_Pastry_','Honey Pastry',2,2,NULL,70,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_FLEEFOOD,1200000,30;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12268,'Rainbow_Cake_','Rainbow Cake',2,2,NULL,70,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_ATKPOTION,60000,10; sc_start SC_MATKFOOD,120000,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12269,'Tasty_Colonel','Tasty Pink Ration',2,2,NULL,70,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_ATKPOTION,600000,15;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12270,'Tasty_Major','Tasty White Ration',2,2,NULL,70,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_MATKPOTION,600000,15;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12271,'Mre_A','Military Ration A',0,2,NULL,70,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'percentheal 5,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12272,'Mre_B','Military Ration B',2,2,NULL,70,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_INCHIT,600000,33;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12273,'Mre_C','Military Ration C',2,2,NULL,70,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_INCFLEE,600000,33;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12274,'Gold_Pill_1','Daehwandan',0,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_INCMHPRATE,3600000,5; percentheal 10,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12275,'Gold_Pill_2','Taecheongdan',0,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_INCMSPRATE,3600000,5; percentheal 0,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12276,'Mimic_Scroll','Mimic Scroll',2,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'mercenary_create 2058,1800000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12277,'Disguise_Scroll','Disguise Scroll',2,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'mercenary_create 2059,1800000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12278,'Alice_Scroll','Alice Scroll',2,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'mercenary_create 2060,1800000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12279,'Undead_Element_Scroll','Undead Elemental Scroll',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start4 SC_ARMOR_RESIST,300000,20,20,20,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12280,'Holy_Element_Scroll','Holy Elemental Scroll',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'specialeffect2 EF_BENEDICTIO; sc_start SC_BENEDICTIO,300000,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12281,'Tresure_Box_WoE','Event Treasure Box',2,20,NULL,150,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getrandgroupitem(IG_Tresure_Box_WoE),1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12282,'Internet_Cafe1','Internet Cafe1',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_INCALLSTATUS,5400000,3; sc_start SC_ATKPOTION,5400000,15; sc_start SC_MATKPOTION,5400000,15;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12283,'Internet_Cafe2','Internet Cafe2',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_INCSTR,5400000,8; sc_start SC_INCDEX,5400000,4; sc_start SC_INCAGI,5400000,6; sc_start SC_ATKPOTION,5400000,32; sc_start SC_INCFLEE,5400000,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12284,'Internet_Cafe3','Internet Cafe3',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_INCINT,5400000,8; sc_start SC_INCVIT,5400000,4; sc_start SC_INCDEX,5400000,6; sc_start SC_MATKPOTION,5400000,40;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12285,'Internet_Cafe4','Internet Cafe4',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_INCDEX,5400000,8; sc_start SC_INCLUK,5400000,4; sc_start SC_INCAGI,5400000,6; sc_start SC_ATKPOTION,5400000,24; sc_start SC_MATKPOTION,5400000,24;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12286,'Masquerade_Ball_Box2','Masquerade Ball Box2',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getrandgroupitem(IG_Masquerade_2),1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12287,'Love_Angel','Love Angel Magic Powder',2,0,NULL,0,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'setfont 1;',NULL,'setfont 0;');
REPLACE INTO `item_db` VALUES (12288,'Squirrel','Squirrel Magic Powder',2,0,NULL,0,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'setfont 2;',NULL,'setfont 0;');
REPLACE INTO `item_db` VALUES (12289,'Gogo','Gogo Magic Powder',2,0,NULL,0,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'setfont 3;',NULL,'setfont 0;');
REPLACE INTO `item_db` VALUES (12290,'Mysterious_Can','Mysterious Can Magic Powder',2,10,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'percentheal 5,0; skilleffect "AL_BLESSING",0; sc_start SC_BLESSING,120000,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12291,'Mysterious_PET_Bottle','Mysterious PET Bottle',2,10,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'percentheal 5,0; skilleffect "AL_INCAGI",0; sc_start SC_INCREASEAGI,120000,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12292,'Unripe_Fruit','Unripe Fruit',0,500,NULL,200,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'percentheal 20,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12293,'Dried_Yggdrasilberry','Dried Yggdrasilberry',0,500,NULL,200,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'percentheal 0,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12294,'PC_Bang_Coin_Box1','PC-Room Coin Box',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 2740,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12295,'PC_Bang_Coin_Box2','PC-Room Coin Box',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 2739,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12296,'PC_Bang_Coin_Box3','PC-Room Coin Box',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 2738,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12297,'PC_Bang_Coin_Box4','PC-Room Coin Box',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 2738,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12298,'SP_Potion','SP Consumption Reduction Potion',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_SPCOST_RATE,3600000,15;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12299,'Mega_Resist_Potion','Mega Resist Potion',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_COMMONSC_RESIST,3600000,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12300,'Wild_Rose_Scroll','Wild Rose Contract',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'mercenary_create 1965,1800000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12301,'Doppelganger_Scroll','Doppelganger Contract',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'mercenary_create 1966,1800000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12302,'Ygnizem_Scroll','Egnigem Cenia Contract',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'mercenary_create 1967,1800000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12303,'Water_Of_Blessing','Blessing Of Water',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12304,'Picture_Diary','Diary Magic Powder',2,0,NULL,0,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'setfont 4;',NULL,'setfont 0;');
REPLACE INTO `item_db` VALUES (12305,'Mini_Heart','Mini Heart Magic Powder',2,0,NULL,0,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'setfont 5;',NULL,'setfont 0;');
REPLACE INTO `item_db` VALUES (12306,'Newcomer','Freshman Magic Powder',2,0,NULL,0,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'setfont 6;',NULL,'setfont 0;');
REPLACE INTO `item_db` VALUES (12307,'Kid','Kid Magic Powder',2,0,NULL,0,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'setfont 7;',NULL,'setfont 0;');
REPLACE INTO `item_db` VALUES (12308,'Magic_Castle','Magic Magic Powder',2,0,NULL,0,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'setfont 8;',NULL,'setfont 0;');
REPLACE INTO `item_db` VALUES (12309,'Bulging_Head','JJangu Magic Powder',2,0,NULL,0,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'setfont 9;',NULL,'setfont 0;');
REPLACE INTO `item_db` VALUES (12310,'Spray_Of_Flowers','Spray Of Flowers',2,0,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_INCFLEE,600000,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12311,'Large_Spray_Of_Flowers','Huge Spray Of Flowers',11,0,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemskill "ALL_PARTYFLEE",1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12312,'Thick_Manual50','Thick Battle Manual',2,0,NULL,0,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_EXPBOOST,3600000,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12313,'Protection_Of_Angel','Guardian Angel',2,0,NULL,0,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12314,'Noive_Box','Noive Box',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12315,'Goddess_Bless','Goddess Of Blessing',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12316,'Angel_Bless','Angel Of Blessing',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12317,'Powder_Snow','Snow Powder',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12318,'Little_Heart','Small Hearts',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12319,'Strawberry_Cake','Rune Strawberry Cake',2,0,NULL,300,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_ATKPOTION,600000,5; sc_start SC_MATKPOTION,600000,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12320,'Pineapple_Juice','Schwartzwald Pine Jubilee',2,0,NULL,300,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_INCHIT,600000,10; sc_start SC_INCFLEE2,600000,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12321,'Spicy_Sandwich','Arunafeltz Desert Sandwich',2,0,NULL,300,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_INCCRI,600000,7;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12322,'Chocolate_Pie','Chocolate Pie',0,0,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'percentheal 5,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12323,'N_Fly_Wing','Novice Fly Wing',11,0,NULL,0,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemskill "AL_TELEPORT",1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12324,'N_Butterfly_Wing','Novice Butterfly Wing',11,0,NULL,0,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemskill "AL_TELEPORT",3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12325,'N_Magnifier','Novice Magnifier',11,0,NULL,0,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemskill "MC_IDENTIFY",1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12326,'J_Firecracker','Large Firecracker',2,2,NULL,20,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12327,'Charm_Of_Luck','Charm Of Luck',2,1000,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12328,'Charm_Of_Happiness','Charm Of Happiness',2,1800,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_INCLUK,3600000,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12329,'Recall_MaleGM','Summon Male GameMaster Scroll',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'mercenary_create 2000,1800000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12330,'Recall_FemaleGM','Summon Female GameMaster Scroll',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'mercenary_create 2001,1800000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12331,'Ginseng','Ginseng',0,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'percentheal 6,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12332,'Fruit_Juice','Fruit Juice',0,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'percentheal 0,6;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12333,'Ansila','Ancilla',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'percentheal 0,15;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12334,'Cherish_Box','Treasure Edition Helm Box',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getrandgroupitem(IG_Cherish_Box),1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12335,'Yummy_Skewered_Dish','Grilled Delicious Skewer',0,1000,NULL,350,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'percentheal 60,60;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12336,'Baked_Mushroom','Grilled Mushroom',0,500,NULL,300,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'percentheal 30,30;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12337,'Grilled_Sausage','Grilled Sausages',0,300,NULL,200,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'percentheal 20,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12338,'Grilled_Corn','Grilled Corn',2,100,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_INCSTR,180000,2; sc_start SC_INCINT,180000,2; sc_start SC_INCAGI,180000,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12339,'Cherish_Box_Ori','Treasure Edition Box',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getrandgroupitem(IG_Cherish_Box_Ori),1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12340,'Mysterious_Rice_Powder','Chewy Rice Powder',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'pet 1815;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12341,'Special_Alloy_Trap_Box','Special Alloy Trap Box',2,30000,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 7940,100;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12342,'Manuk\'s_Opportunity','Manuk\'s Opportunity',2,0,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'specialeffect2 EF_POTION_BERSERK; sc_start SC_MANU_ATK,600000,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12343,'Manuk\'s_Courage','Manuk\'s Courage',2,0,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'specialeffect2 EF_GUARD; sc_start SC_MANU_DEF,600000,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12344,'Pinguicula\'s_fruit_Jam','Pinguicula\'s Fruit Jam',2,0,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'specialeffect2 EF_POTION_BERSERK; sc_start SC_SPL_ATK,600000,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12345,'Luciola\'s_Honey_Jam','Luciola\'s Honey Jam',2,0,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'specialeffect2 EF_GUARD; sc_start SC_SPL_DEF,600000,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12346,'Unripe_Acorn','Unripe Acorn',2,0,NULL,0,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'heal -100,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12347,'Acorn_Jelly','Acorn Jelly',11,0,NULL,0,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemskill "ALL_REVERSEORCISH",1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12348,'Manuk\'s_Faith','Manuk\'s Faith',2,0,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'specialeffect2 EF_POTION_BERSERK; sc_start SC_MANU_MATK,600000,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12349,'Cornus\'_Tears','Cornus\' Tears',2,0,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'specialeffect2 EF_POTION_BERSERK; sc_start SC_SPL_MATK,600000,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12350,'Angeling_Potion','Angeling Potion',11,20,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'skilleffect "AL_BLESSING",0; sc_start SC_BLESSING,120000,5; itemskill "AL_ANGELUS",5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12351,'Shout_Megaphone','Scream Megaphone',11,20,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemskill "MC_LOUD",1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12352,'Dun_Tele_Scroll3','Dungeon Teleport Scroll 3',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'callfunc "F_CashDungeon",3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12353,'Tiny_Waterbottle','Small Bottle',2,800,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_WATERWEAPON,90000,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12354,'Buche_De_Noel','Buche De Noel',2,2,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'specialeffect2 EF_ANGELUS; sc_start SC_INCMHPRATE,600000,3; sc_start SC_INCMSPRATE,600000,3; sc_start SC_INCHITRATE,600000,3; sc_start SC_INCCRI,600000,7;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12355,'Xmas_Gift','Xmas Gift',2,2,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getrandgroupitem(IG_Xmas_Gift),1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12356,'Louise_Costume_Box','Louise Costume Box',2,2,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getrandgroupitem(IG_Louise_Costume_Box),1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12357,'Shiny_Wing_Gown','Shiny Wing Gown',2,20,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'pet 1630;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12358,'Fan_Of_Wind','Fan Of Wind',2,20,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'pet 1513;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12359,'Very_Soft_Plant','Very Soft Plant',2,20,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'pet 1586;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12360,'Very_Red_Juice','Very Red Juice',2,20,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'pet 1505;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12361,'Delicious_Shaved_Ice','Delicious Shaved Ice',2,0,NULL,0,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'pet 1143;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12362,'Kuloren','Kuloren',2,20,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'pet 1401;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12363,'Fit_Pipe','Fit Pipe',2,0,NULL,0,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'pet 1179;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12364,'Staff_Of_Leader','Staff Of Leader',2,20,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'pet 1299;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12365,'Charming_Lotus','Charming Lotus',2,20,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'pet 1416;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12366,'Gril_Doll','Girl\'s Doll',2,20,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'pet 1404;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12367,'Luxury_Whisky_Bottle','Luxury Whisky Bottle',2,20,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'pet 1504;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12368,'Splendid_Mirror','Splendid Mirror',2,20,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'pet 1148;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12369,'Oilpalm_Coconut','Oilpalm Coconut',2,20,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'pet 1495;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12370,'Gril\'s_Naivety','Girl\'s Naivety',2,0,NULL,0,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'pet 1374;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12371,'Magical_Lithography','Magical Lithography',2,20,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'pet 1040;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12372,'Hell_Contract','Hell Contract',2,20,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'pet 1379;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12373,'Boy\'s_Naivety','Boy\'s Pure Heart',2,20,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'pet 1370;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12374,'Flaming_Ice','Ice Fireworks',2,20,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'pet 1837;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12375,'Acaraje','Akaraje',2,0,NULL,80,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'specialeffect2 EF_STEAL; bonus_script "{ bonus bHit,5; bonus bAspdRate,10; }",1200,0,0,EFST_ACARAJE;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12376,'Mysterious_Can2','Mysterious Can2',2,10,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'percentheal 3,0; itemskill "PR_GLORIA",2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12377,'Mysterious_PET_Bottle2','Mysterious PET Bottle2',2,10,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'percentheal 0,3; itemskill "PR_MAGNIFICAT",1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12378,'2009_Rice_Cake_Soup','Rice Cake Soup',2,10,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'/* percentheal 50,50; */',NULL,NULL);
REPLACE INTO `item_db` VALUES (12379,'Pope\'s_Cookie','Pope Cookie',2,10,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12380,'Desert_Wolf_Babe_Scroll','Job Change Flute',2,10,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'mercenary_create 2034,1800000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12381,'ValkyrieA_Scroll','Ancient Languages Scroll',2,10,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'if(strcharinfo(3)=="job3_arch02") { mercenary_create 2037,1800000; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (12382,'ValkyrieB_Scroll','Ancient Languages Scroll',2,10,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'if(strcharinfo(3)=="job3_arch02") { mercenary_create 2038,1800000; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (12383,'Vulcan_Bullet_Magazine','Vulcan Bullet Magazine',2,11000,NULL,500,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 6145,1000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12384,'Rainbow_Ruby_Water','Rainbow Ruby',11,0,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'/* if(strcharinfo(3)=="job3_war02") { itemskill "WL_FROSTMISTY",5; } */',NULL,NULL);
REPLACE INTO `item_db` VALUES (12385,'Rainbow_Ruby_Fire','Rainbow Ruby',11,0,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'/* if(strcharinfo(3)=="job3_war02") { itemskill "WL_CRIMSONROCK",5; } */',NULL,NULL);
REPLACE INTO `item_db` VALUES (12386,'Rainbow_Ruby_Wind','Rainbow Ruby',11,0,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'/* if(strcharinfo(3)=="job3_war02") { itemskill "WL_CHAINLIGHTNING",5; } */',NULL,NULL);
REPLACE INTO `item_db` VALUES (12387,'Rainbow_Ruby_Earth','Rainbow Ruby',11,0,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'/* if(strcharinfo(3)=="job3_war02") { itemskill "WL_EARTHSTRAIN",5; } */',NULL,NULL);
REPLACE INTO `item_db` VALUES (12388,'Runstone_Crush','Rhydo Runestone For Apprentice',11,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'/* if(strcharinfo(3)=="job3_rune02") { itemskill "RK_CRUSHSTRIKE",1; } */',NULL,NULL);
REPLACE INTO `item_db` VALUES (12389,'Runstone_Storm','Pertz Runestone For Apprentice',11,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'/* if(strcharinfo(3)=="job3_rune02") { itemskill "RK_STORMBLAST",1; } */',NULL,NULL);
REPLACE INTO `item_db` VALUES (12390,'Runstone_Millennium','Verkana Runestone For Apprentice',11,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'/* if(strcharinfo(3)=="job3_rune02") { itemskill "RK_MILLENNIUMSHIELD",1; } */',NULL,NULL);
REPLACE INTO `item_db` VALUES (12391,'Lucky_Egg_C','Lucky Egg',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12392,'RepairA','Repair A',2,220,NULL,100,NULL,NULL,NULL,NULL,0x00000400,8,2,NULL,NULL,NULL,NULL,NULL,'if ( checkmadogear() ) { itemheal rand(200,300),0; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (12393,'RepairB','Repair B',2,500,NULL,140,NULL,NULL,NULL,NULL,0x00000400,8,2,NULL,NULL,NULL,NULL,NULL,'if ( checkmadogear() ) { itemheal rand(300,400),0; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (12394,'RepairC','Repair C',2,1100,NULL,180,NULL,NULL,NULL,NULL,0x00000400,8,2,NULL,NULL,NULL,NULL,NULL,'if ( checkmadogear() ) { itemheal rand(400,500),0; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (12395,'Tantanmen','Tantan Noodle',2,20,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'pet 1519;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12396,'Fools_Day_Box','Gift Box?',11,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'.@rnd = rand(1,10); if(.@rnd==1) itemskill "AL_TELEPORT",1; else if(.@rnd==2) itemskill "AL_TELEPORT",3; else if(.@rnd==3) percentheal 50,0; else if(.@rnd==4) percentheal 0,50; else if(.@rnd==5) end; else if(.@rnd==6) getitem 512,1; else if(.@rnd==7) itemskill "ALL_REVERSEORCISH",1; else if(.@rnd==8) specialeffect2 EF_MAPPILLAR2; else if(.@rnd==9) specialeffect2 EF_ANGEL2; else specialeffect2 EF_COIN;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12397,'Fools_Day_Box2','Gift Box?',11,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'.@rnd = rand(1,10); if(.@rnd==1) itemskill "TF_DETOXIFY",1; else if(.@rnd==2) itemskill "TF_PICKSTONE",1; else if(.@rnd==3) itemskill "BA_FROSTJOKER",1; else if(.@rnd==4) itemskill "DC_SCREAM",1; else if(.@rnd==5) end; else if(.@rnd==6) getitem 909,1; else if(.@rnd==7) itemskill "AL_RUWACH",1; else if(.@rnd==8) specialeffect2 EF_BEGINASURA; else if(.@rnd==9) specialeffect2 EF_MVP; else specialeffect2 EF_CURSEATTACK;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12398,'PCBang_Gift_Box','PCBang Gift Box',2,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12399,'Castle_Treasure_Box','Castle Treasure Box',2,20,NULL,1000,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12400,'Water_Of_Blessing_','Water Of Blessing',2,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12401,'Rune_Kn_Test_Int','Rune Kn Test Int',2,0,NULL,0,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_INCINT,300000,40;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12402,'29Fruit','29Fruit',2,0,NULL,0,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'percentheal 5,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12403,'Lucky_Egg_C2','Lucky Egg2',2,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12404,'Acti_Potion','Acti Potion',2,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12405,'Underripe_Yggseed','Underripe Yggseed',2,20,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'percentheal 30,30; skilleffect "AL_BLESSING",0; sc_start SC_BLESSING,140000,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12406,'Psychic_ArmorS','Psychic ArmorS',2,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12407,'PCBang_Coupon_Box','PCBang Coupon Box',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12408,'Leaf_Cat_Ball','Leaf Cat Ball',2,0,NULL,0,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'pet 2081;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12409,'Pork_Belly_H','1st Class Pork Belly',2,0,NULL,0,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12410,'Spareribs_H','Thick Pork Belly H',2,0,NULL,0,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12411,'HE_Battle_Manual','HE Battle Manual',2,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_EXPBOOST,900000,200;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12412,'HE_Bubble_Gum','HE Bubble Gum',2,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_ITEMBOOST,900000,300;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12413,'PCBang_Coupon_Box2','PCBang Coupon Box2',2,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12414,'Guarana_Candy','Guarana Candy',2,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_ASPDPOTION0,1800000,0; sc_start SC_INCREASEAGI,140000,5; skilleffect "AL_INCAGI",0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12415,'Siege_Teleport_Scroll2','Siege Teleport Scroll Silver',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12416,'Lucky_Egg_C3','Lucky Egg C3',2,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12417,'Boost500','Boost500',2,100,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_BOOST500,500000,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12418,'Full_SwingK','Full SwingK',2,100,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_FULL_SWING_K,500000,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12419,'Mana_Plus','Mana Plus',2,100,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_MANA_PLUS,500000,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12420,'Stamina_Up_M','Stamina Up M',2,100,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_MUSTLE_M,500000,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12421,'Digestive_F','Falmons F',2,10,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_LIFE_FORCE_F,500000,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12422,'HP_Increase_PotionS','HP Increase Potion (Small)',2,100,NULL,20,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'sc_start2 SC_PROMOTE_HEALTH_RESERCH,500000,1,1; percentheal 1,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12423,'HP_Increase_PotionM','HP Increase Potion (Medium)',2,100,NULL,40,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'sc_start2 SC_PROMOTE_HEALTH_RESERCH,500000,1,2; percentheal 2,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12424,'HP_Increase_PotionL','HP Increase Potion (Large)',2,100,NULL,80,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'sc_start2 SC_PROMOTE_HEALTH_RESERCH,500000,1,3; percentheal 5,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12425,'SP_Increase_PotionS','SP Increase Potion (Small)',2,100,NULL,20,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'sc_start2 SC_ENERGY_DRINK_RESERCH,500000,1,1; percentheal 0,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12426,'SP_Increase_PotionM','SP Increase Potion (Medium)',2,100,NULL,40,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'sc_start2 SC_ENERGY_DRINK_RESERCH,500000,1,2; percentheal 0,4;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12427,'SP_Increase_PotionL','SP Increase Potion (Large)',2,100,NULL,80,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'sc_start2 SC_ENERGY_DRINK_RESERCH,500000,1,3; percentheal 0,8;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12428,'Enrich_White_PotionZ','Concentrated White Potion Z',0,10,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_EXTRACT_WHITE_POTION_Z,500000,20; heal 1000,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12429,'Savage_BBQ','Savage Full Roast',2,NULL,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_SAVAGE_STEAK,300000,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12430,'Wug_Blood_Cocktail','Cocktail Warg Blood',2,NULL,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_COCKTAIL_WARG_BLOOD,300000,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12431,'Minor_Brisket','Minor Stew',2,NULL,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_MINOR_BBQ,300000,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12432,'Siroma_Icetea','Siroma Iced Tea',2,NULL,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_SIROMA_ICE_TEA,300000,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12433,'Drocera_Herb_Stew','Drosera Herb Salad',2,NULL,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_DROCERA_HERB_STEAMED,300000,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12434,'Petti_Tail_Noodle','Petite Tail Noodles',2,NULL,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_PUTTI_TAILS_NOODLES,300000,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12435,'Black_Thing','Black Mass',2,NULL,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_STOMACHACHE,60000,rand(5,10);',NULL,NULL);
REPLACE INTO `item_db` VALUES (12436,'Vitata500','Vitata 500',0,10,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_VITATA_500,500000,0; itemheal 0,200;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12437,'Enrich_Celermine_Juice','Concentrated Ceromain Soup',2,10,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_EXTRACT_SALAMINE_JUICE,500000,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12438,'F_Giant_Fly_Wing','F Giant Fly Wing',2,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12439,'F_Battle_Manual','F Battle Manual',2,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12440,'F_Insurance','F Insurance',2,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12441,'F_Bubble_Gum','F Bubble Gum',2,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12442,'F_Kafra_Card','F Kafra Card',2,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12443,'F_Neuralizer','F Neuralizer',2,2,NULL,0,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12444,'F_Dun_Tele_Scroll1','F Dun Tele Scroll1',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12445,'F_Str_Dish10_','F Str Dish10',2,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12446,'F_Agi_Dish10_','F Agi Dish10',2,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12447,'F_Int_Dish10_','F Int Dish10',2,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12448,'F_Dex_Dish10_','F Dex Dish10',2,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12449,'F_Luk_Dish10_','F Luk Dish10',2,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12450,'F_Vit_Dish10_','F Vit Dish10',2,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12451,'F_WOB_Rune','F WOB Rune',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12452,'F_WOB_Schwaltz','F WOB Schwaltz',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12453,'F_WOB_Rachel','F WOB Rachel',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12454,'F_WOB_Local','F WOB Local',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12456,'F_Greed_Scroll','F Greed Scroll',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12457,'F_Glass_Of_Illusion','F Glass Of Illusion',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12458,'F_Abrasive','F Abrasive',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12459,'F_Med_Life_Potion','F Med Life Potion',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12460,'F_Small_Life_Potion','F Small Life Potion',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12461,'F_Regeneration_Potion','F Regeneration Potion',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12462,'F_B_Mdef_Potion','F B Mdef Potion',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12463,'F_S_Mdef_Potion','F S Mdef Potion',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12464,'F_B_Def_Potion','F B Def Potion',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12465,'F_S_Def_Potion','F S Def Potion',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12466,'F_Blessing_10_Scroll','F Blessing 10 Scroll',2,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12467,'F_Inc_Agi_10_Scroll','F Inc Agi 10 Scroll',2,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12468,'F_Aspersio_5_Scroll','F Aspersio 5 Scroll',2,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12470,'F_Wind_Walk_10_Scroll','F Wind Walk 10 Scroll',2,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12471,'F_Adrenaline_Scroll','F Adrenaline Scroll',2,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12472,'F_Convex_Mirror','F Convex Mirror',2,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12473,'RWC_Parti_Box','RWC Parti Box',2,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12474,'RWC_Final_Comp_Box','RWC Final Comp Box',2,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12475,'Cure_Free','Cure Free',2,20,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_end SC_SILENCE; sc_end SC_BLEEDING; sc_end SC_POISON; sc_end SC_CURSE; sc_end SC_ORCISH; sc_end SC_CHANGEUNDEAD; itemheal 500,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12476,'PCBang_Coupon_Box3','PCBang Coupon Box3',2,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12477,'Gift_Bundle','Gift Bundle',2,0,NULL,0,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12478,'Chance_Box','Chance Box',2,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12479,'Caracas_Ring_Box','Caracas Ring Box',2,0,NULL,0,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12480,'Attend_3Day_Box','Attend 3Day Box',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12481,'Attend_7Day_Box','Attend 7Day Box',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12482,'Attend_10Day_Box','Attend 10Day Box',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12483,'Attend_15Day_Box','Attend 15Day Box',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12484,'Attend_20Day_Box','Attend 20Day Box',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12485,'Attend_25Day_Box','Attend 25Day Box',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12486,'GoldPC_First_Box','GoldPC First Box',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12487,'PC_4Leaf_Clover_Box','PC 4Leaf Clover Box',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12488,'Ticket_Gift_Box','Ticket Gift Box',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12489,'Ticket_Gift_Box2','Ticket Gift Box2',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12490,'Vivid_Notation','Vivid Notation',2,20,NULL,0,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12491,'Curious_Snowball','Curious Snowball',2,20,NULL,0,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'callfunc "F_Snowball";',NULL,NULL);
REPLACE INTO `item_db` VALUES (12492,'Crumpled_Paper','Crumpled Paper',2,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12493,'Lucky_Egg_C4','Lucky Egg C4',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12494,'E_Giant_Fly_Wing','E Giant Fly Wing',2,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12495,'E_Battle_Manual','E Battle Manual',2,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12496,'E_Insurance','E Insurance',2,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12497,'E_Bubble_Gum','E Bubble Gum',2,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12498,'E_Kafra_Card','E Kafra Card',2,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12499,'E_Neuralizer','E Neuralizer',2,2,NULL,0,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12500,'E_Dun_Tele_Scroll1','E Dun Tele Scroll1',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12501,'E_Str_Dish10_','E Str Dish10',2,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12502,'E_Agi_Dish10_','E Agi Dish10',2,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12503,'E_Int_Dish10_','E Int Dish10',2,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12504,'E_Dex_Dish10_','E Dex Dish10',2,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12505,'E_Luk_Dish10_','E Luk Dish10',2,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12506,'E_Vit_Dish10_','E Vit Dish10',2,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12507,'E_WOB_Rune','Yellow Butterfly Wing',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'callfunc "F_CashCity",1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12508,'E_WOB_Schwaltz','Green Butterfly Wing',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'callfunc "F_CashCity",2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12509,'E_WOB_Rachel','Red Butterfly Wing',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'callfunc "F_CashCity",3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12510,'E_WOB_Local','Blue Butterfly Wing',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'callfunc "F_CashCity",5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12511,'E_Siege_Teleport_Scroll','E Siege Teleport Scroll',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12512,'E_Greed_Scroll','E Greed Scroll',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12513,'E_Glass_Of_Illusion','E Glass Of Illusion',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12514,'E_Abrasive','E Abrasive',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12515,'E_Med_Life_Potion','E Med Life Potion',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12516,'E_Small_Life_Potion','E Small Life Potion',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12517,'E_Regeneration_Potion','E Regeneration Potion',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12518,'E_B_Mdef_Potion','E B Mdef Potion',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12519,'E_S_Mdef_Potion','E S Mdef Potion',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12520,'E_B_Def_Potion','E B Def Potion',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12521,'E_S_Def_Potion','E S Def Potion',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12522,'E_Blessing_10_Scroll','E Blessing 10 Scroll',2,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12523,'E_Inc_Agi_10_Scroll','E Inc Agi 10 Scroll',2,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12524,'E_Aspersio_5_Scroll','E Aspersio 5 Scroll',2,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12525,'E_Assumptio_5_Scroll','E Assumptio 5 Scroll',2,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12526,'E_Wind_Walk_10_Scroll','E Wind Walk 10 Scroll',2,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12527,'E_Adrenaline_Scroll','E Adrenaline Scroll',2,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12528,'E_Convex_Mirror','E Convex Mirror',2,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12529,'White_Slim_Potion_Box','White Slim Potion Box',2,0,NULL,0,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12530,'Mastela_Fruit_Box','Mastela Fruit Box',2,0,NULL,0,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12531,'White_Potion_Box','White Potion Box',2,0,NULL,0,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12532,'Royal_Jelly_Box2','Royal Jelly Box2',2,0,NULL,0,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12533,'Blue_Herb_Box2','Blue Herb Box2',2,0,NULL,0,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12534,'Yggdrasil_Seed_Box','Yggdrasil Seed Box',2,0,NULL,0,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12535,'Iggdrasilberry_Box','Iggdrasilberry Box',2,0,NULL,0,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12536,'NY_Rice_Cake_Soup','NY Rice Cake Soup',2,20,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12537,'Solo_Gift_Basket','Solo Gift Basket',2,1000,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12538,'Couple_Event_Basket','Couple Event Basket',2,2000,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12539,'Splendid_Box','Splendid Box',2,20,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12540,'GM_Warp_Box','GM Warp Box',2,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12541,'Fortune_Cookie1','Fortune Cookie1',2,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12542,'Fortune_Cookie2','Fortune Cookie2',2,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12543,'Fortune_Cookie3','Fortune Cookie3',2,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12544,'Mystic_Tree_Branch','Mystic Tree Branch',2,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12545,'Lucky_Egg_C5','Lucky Egg C5',2,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12546,'Suspicious_Dish','Suspicious Dish',2,100,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12547,'Chalcenodny_Box','Chalcenodny Box',2,0,NULL,200,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12548,'Buy_Market_Permit2','Shabby Purchase Street Stall License',2,500,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'buyingstore 2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12549,'White_Slim_Pot_Box2','White Slim Pot Box2',2,0,NULL,0,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12550,'Poison_Bottle_Box2','Poison Bottle Box2',2,0,NULL,0,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12551,'MVP_Tele_Scroll','MVP Tele Scroll',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12552,'Quest_Tele_Scroll','Quest Tele Scroll',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12553,'Brysinggamen_Piece_Box','Brysinggamen Piece Box',2,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12554,'Asprika_Piece_Box','Asprika Piece Box',2,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12555,'Brynhild_Piece_Box','Brynhild Piece Box',2,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12556,'Sleipnir_Piece_Box','Sleipnir Piece Box',2,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12557,'Mjolnir_Piece_Box','Mjolnir Piece Box',2,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12558,'Magingiorde_Piece_Box','Magingiorde Piece Box',2,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12559,'Tenkaippin_Strong','Tenkaippin Strong',2,650,NULL,200,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12560,'Tenkaippin_Clean','Tenkaippin Clean',2,650,NULL,200,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12561,'Mysterious_Seed','Mysterious Seed',2,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12562,'Bubble_Gum_Plus','Bubble Gum Plus',2,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12563,'BM75','BM75',2,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12564,'3D_Glasses_Box','3D Glasses Box',2,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12565,'Cheer_Scarf_Box','Cheer Scarf Box',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12566,'Cheer_Scarf2_Box','Cheer Scarf2 Box',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12567,'Cheer_Scarf3_Box','Cheer Scarf3 Box',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12568,'Cheer_Scarf4_Box','Cheer Scarf4 Box',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12569,'Cheer_Scarf6_Box','Cheer Scarf6 Box',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12570,'Cheer_Scarf8_Box','Cheer Scarf8 Box',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12571,'Cheer_Scarf10_Box','Cheer Scarf10 Box',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12572,'Cheer_Scarf10_Box2','Cheer Scarf10 Box2',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12573,'Fruit_Basket','Fruit Basket',2,20,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12574,'Mora_Berry','Mora Berry',2,0,NULL,20,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12575,'Arrow_Of_Elf_Cntr','Arrow Of Elf Cntr',2,500,NULL,250,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12576,'Hunting_Arrow_Cntr','Hunting Arrow Cntr',2,500,NULL,250,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12577,'Lucky_Egg_C6','Lucky Egg C6',2,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12578,'Rapid_Life_Water','Rapid Life Water',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12579,'Ring_Of_Valkyrie_Box','Ring Of Valkyrie Box',2,20,NULL,0,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12580,'Vending_Search_Scroll','Universal Catalog Silver',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'searchstores 10,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12581,'Vending_Search_Scroll2','Universal Catalog Gold',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'searchstores 10,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12591,'Uni_Catalog_Bz','Universal Catalog Bronze',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'searchstores 10,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12609,'Old_Ore_Box','Old Ore Box',2,20,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12701,'Old_Blue_Box_F','Old Blue Box',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12702,'Old_Bleu_Box','Old Navy Box',2,0,NULL,200,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getrandgroupitem(IG_BleuBox),1; getrandgroupitem(IG_BleuBox),1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12703,'Holy_Egg_2','Holy Egg',11,0,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12704,'Elixir_Of_Life','Elixir of Life',0,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,85,NULL,NULL,'percentheal 100,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12705,'Noble_Nameplate','Noble Nameplate',2,0,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,90,NULL,NULL,'sc_start SC_EXPBOOST,1800000,100;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12706,'Lucky_Cookie01','Lucky Cookie',11,0,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemskill "PR_GLORIA",5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12707,'Lucky_Cookie02','Lucky Cookie',11,0,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemskill "PR_MAGNIFICAT",1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12708,'Lucky_Cookie03','Lucky Cookie',11,0,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemskill "PR_IMPOSITIO",3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12709,'Guyak_Candy','Guyak Candy',0,0,NULL,150,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'percentheal 30,30;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12710,'Guyak_Pudding','Guyak Pudding',2,0,NULL,200,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_SPEEDUP1,300000,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12711,'Pretzel','Pretzel',0,2,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(50,90),0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12712,'Green_Beer','Green Beer',2,2,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'percentheal 0,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12713,'Monster_Extract','Monster Extract',2,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12714,'Easter_Scroll','Easter Scroll',2,1,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getrandgroupitem(IG_Easter_Scroll),1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12715,'Black_Treasure_Box','Black Treasure Box',2,0,NULL,0,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12716,'Indian_Rice_Cake','Indian Rice Cake',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
# Guillotine Cross Poisons
REPLACE INTO `item_db` VALUES (12717,'Poison_Paralysis','Paralyze',0,2,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_PARALYSE,300000,0,10,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12718,'Poison_Leech','Leech End',0,2,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_LEECHESEND,300000,0,10,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12719,'Poison_Oblivion','Oblivion Curse',0,2,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_OBLIVIONCURSE,300000,0,10,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12720,'Poison_Contamination','Disheart',0,2,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_DEATHHURT,300000,0,10,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12721,'Poison_Numb','Toxin',0,2,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_TOXIN,300000,0,10,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12722,'Poison_Fever','Pyrexia',0,2,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_PYREXIA,300000,0,10,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12723,'Poison_Laughing','Magic Mushroom',0,2,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_MAGICMUSHROOM,300000,0,10,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12724,'Poison_Fatigue','Venom Bleed',0,2,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_VENOMBLEED,15000,0,10,0;',NULL,NULL);

# Rune Knight's Rune Stones
REPLACE INTO `item_db` VALUES (12725,'Runstone_Nosiege','Nauthiz Rune',2,100,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,8,2,NULL,NULL,NULL,NULL,NULL,'if ((eaclass()&EAJ_THIRDMASK) == EAJ_RUNE_KNIGHT) unitskilluseid getcharid(3),"RK_REFRESH",1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12726,'Runstone_Rhydo','Raido Rune',2,100,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,8,2,NULL,NULL,NULL,NULL,NULL,'if ((eaclass()&EAJ_THIRDMASK) == EAJ_RUNE_KNIGHT) unitskilluseid getcharid(3),"RK_CRUSHSTRIKE",1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12727,'Runstone_Verkana','Berkana Rune',2,100,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,8,2,NULL,NULL,NULL,NULL,NULL,'if ((eaclass()&EAJ_THIRDMASK) == EAJ_RUNE_KNIGHT) unitskilluseid getcharid(3),"RK_MILLENNIUMSHIELD",1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12728,'Runstone_Isia','Isa Rune',2,100,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,8,2,NULL,NULL,NULL,NULL,NULL,'if ((eaclass()&EAJ_THIRDMASK) == EAJ_RUNE_KNIGHT) unitskilluseid getcharid(3),"RK_VITALITYACTIVATION",1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12729,'Runstone_Asir','Othila Rune',2,100,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,8,2,NULL,NULL,NULL,NULL,NULL,'if ((eaclass()&EAJ_THIRDMASK) == EAJ_RUNE_KNIGHT) unitskilluseid getcharid(3),"RK_FIGHTINGSPIRIT",1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12730,'Runstone_Urj','Uruz Rune',2,100,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,8,2,NULL,NULL,NULL,NULL,NULL,'if ((eaclass()&EAJ_THIRDMASK) == EAJ_RUNE_KNIGHT) unitskilluseid getcharid(3),"RK_ABUNDANCE",1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12731,'Runstone_Turisus','Thurisaz Rune',2,100,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,8,2,NULL,NULL,NULL,NULL,NULL,'if ((eaclass()&EAJ_THIRDMASK) == EAJ_RUNE_KNIGHT) unitskilluseid getcharid(3),"RK_GIANTGROWTH",1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12732,'Runstone_Pertz','Wyrd Rune',2,100,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,8,2,NULL,NULL,NULL,NULL,NULL,'if ((eaclass()&EAJ_THIRDMASK) == EAJ_RUNE_KNIGHT) unitskilluseid getcharid(3),"RK_STORMBLAST",1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12733,'Runstone_Hagalas','Hagalaz Rune',2,100,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,8,2,NULL,NULL,NULL,NULL,NULL,'if ((eaclass()&EAJ_THIRDMASK) == EAJ_RUNE_KNIGHT) unitskilluseid getcharid(3),"RK_STONEHARDSKIN",1;',NULL,NULL);

# Rune Knight Rune Ores
REPLACE INTO `item_db` VALUES (12734,'Runstone_Quality','Luxurious Rune',0,2,NULL,100,NULL,NULL,NULL,NULL,0x00000080,8,2,NULL,NULL,NULL,NULL,NULL,'makerune 5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12735,'Runstone_Ancient','Ancient Rune',0,2,NULL,100,NULL,NULL,NULL,NULL,0x00000080,8,2,NULL,NULL,NULL,NULL,NULL,'makerune 11;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12736,'Runstone_Mystic','Mystic Rune',0,2,NULL,100,NULL,NULL,NULL,NULL,0x00000080,8,2,NULL,NULL,NULL,NULL,NULL,'makerune 14;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12737,'Runstone_Ordinary','General Rune',0,2,NULL,100,NULL,NULL,NULL,NULL,0x00000080,8,2,NULL,NULL,NULL,NULL,NULL,'makerune 2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12738,'Runstone_Rare','Rare Rune',0,2,NULL,100,NULL,NULL,NULL,NULL,0x00000080,8,2,NULL,NULL,NULL,NULL,NULL,'makerune 8;',NULL,NULL);

REPLACE INTO `item_db` VALUES (12739,'Snow_Flower','Snow Flowers',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12740,'Inc_Str_Scroll','Amplification Scroll',2,1,NULL,0,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12741,'Inc_Int_Scroll','Intellect Amplification Scroll',2,1,NULL,0,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12742,'Valentine_Gift_Box1','Valentine Gift Box',2,0,NULL,0,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12743,'Valentine_Gift_Box2','Valentine Gift Box',2,0,NULL,0,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12744,'Chocotate_Box','Chocolate Box',2,0,NULL,0,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12745,'Skull_Scroll','Skull Scroll',2,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12746,'Destruction_Scroll','Destruction Scroll',2,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12747,'Royal_Scroll','Royal Scroll',2,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12748,'Immune_Scroll','Immune Scroll',2,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12749,'Mystic_Scroll','Mystic Scroll',2,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12750,'Battle_Scroll','Battle Scroll',2,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12751,'Armor_Scroll','Armor Scroll',2,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12752,'Prayer_Scroll','Prayer Scroll',2,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12753,'Soul_Scroll','Soul Scroll',2,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12754,'New_Year_Bun','Chinese Pastel',2,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12755,'Traditional_Firecrack','Chinese Fireworks',2,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'specialeffect2 EF_POK_JAP; /* itemskill "MO_CALLSPIRITS",3; itemskill "MO_FINGEROFFENSIVE",5; */',NULL,NULL);
REPLACE INTO `item_db` VALUES (12756,'New_Gift_Envelope','Chinese New Year Envelope',2,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12757,'Loyal_Ring1_Box','Loyal Ring1 Box',2,10,NULL,0,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12758,'Loyal_Ring2_Box','Loyal Ring2 Box',2,10,NULL,0,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12759,'Loyal_Ring3_Box','Loyal Ring3 Box',2,10,NULL,0,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12760,'Bubble_Gum_Green','Bubble Gum Green',2,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12761,'Bubble_Gum_Yellow','Bubble Gum Yellow',2,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12762,'Bubble_Gum_Orange','Bubble Gum Orange',2,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12763,'Bubble_Gum_Red','Bubble Gum Red',2,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12764,'Fools_Day_Box_Tw','Fools Day Box Tw',2,0,NULL,0,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12765,'Summer_Knight_Box','Summer Knight Box',2,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12766,'Reward_Job_BM25','Reward Job BM25',2,0,NULL,0,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12767,'Passion_FB_Hat_Box','Passion FB Hat Box',2,0,NULL,0,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12768,'Cool_FB_Hat_Box','Cool FB Hat Box',2,0,NULL,0,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12769,'Victory_FB_Hat_Box','Victory FB Hat Box',2,0,NULL,0,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12770,'Glory_FB_Hat_Box','Glory FB Hat Box',2,0,NULL,0,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12771,'Passion_Hat_Box2','Passion Hat Box2',2,0,NULL,0,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12772,'Cool_Hat_Box2','Cool Hat Box2',2,0,NULL,0,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12773,'Victory_Hat_Box2','Victory Hat Box2',2,0,NULL,0,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12831,'Potion_Box','Potion Box',2,0,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12848,'Falcon_Flute','Falcon Flute',11,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'if(getskilllv("HT_FALCON")) { if(!checkoption(Option_Wug) && !checkoption(Option_Wugrider)) setfalcon (!checkfalcon()); }',NULL,NULL);
REPLACE INTO `item_db` VALUES (12900,'Battle_Manual_Box','Battle Manual Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 12208,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12901,'Insurance_Package','Insurance Package',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 12209,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12902,'Bubble_Gum_Box','Bubble Gum Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 12210,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12903,'Str_Dish_Box','Steamed Tongue Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 12202,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12904,'Agi_Dish_Box','Steamed Scorpion Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 12203,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12905,'Int_Dish_Box','Dragon Breath Cocktail Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 12204,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12906,'Dex_Dish_Box','Hwergelmir\'s Tonic Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 12205,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12907,'Luk_Dish_Box','Nine Tail Dish Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 12206,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12908,'Vit_Dish_Box','Stew Of Immortality Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 12207,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12909,'Kafra_Card_Box','Kafra Card Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 12211,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12910,'Giant_Fly_Wing_Box','Giant Fly Wing Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 12212,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12911,'Neuralizer_Box','Neuralizer Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 12213,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12912,'Convex_Mirror_Box','Convex Mirror Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 12214,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12913,'Blessing_10_Scroll_Box','Blessing 10 Scroll Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 12215,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12914,'Inc_Agi_10_Scroll_Box','Increase AGI 10 scroll Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 12216,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12915,'Aspersio_5_Scroll_Box','Aspersio 5 Scroll Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 12217,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12916,'Assumptio_5_Scroll_Box','Assumptio 5 Scroll Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 12218,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12917,'Wind_Walk_10_Scroll_Box','Wind Walk 10 Scroll Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 12219,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12918,'Adrenaline_Scroll_Box','Adrenaline 5 Scroll Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 12220,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12919,'Megaphone_Box','Megaphone Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 12221,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12920,'Enriched_Elunium_Box','Enriched Elunium Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 7619,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12921,'Enriched_Oridecon_Box','Enriched Oridecon Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 7620,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12922,'Token_Of_Siegfried_Box','Token of Siegfried Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 7621,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12923,'Pet_Egg_Scroll_Box1','December Lucky Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 12925,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12924,'Pet_Egg_Scroll_Box2','Pet Egg Box 2',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 12926,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12925,'Pet_Egg_Scroll1','Kafra Item Mall Prize Package',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12926,'Pet_Egg_Scroll2','December Lucky Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12927,'J_Aspersio_5_Scroll_Box','Aspersio Scroll Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 12928,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12928,'J_Aspersio_5_Scroll','Sacred Scroll',11,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'itemskill "PR_ASPERSIO",5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12929,'Pet_Egg_Scroll_Box3','Pet Egg Box 3',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 12932,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12930,'Pet_Egg_Scroll_Box4','Pet Egg Box 4',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 12933,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12931,'Pet_Egg_Scroll_Box5','Pet Egg Box 5',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 12934,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12932,'Pet_Egg_Scroll3','Episode 13.2 Key Package',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12933,'Pet_Egg_Scroll4','Summer Hat Pack',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12934,'Pet_Egg_Scroll5','Pet Egg Scroll5',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12935,'Infiltrator_Box','Infiltrator Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'rentitem 1267,604800;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12936,'Muramasa_Box','Muramasa Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'rentitem 1173,604800;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12937,'Excalibur_Box','Excalibur Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'rentitem 13401,604800;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12938,'Combat_Knife_Box','Combat Knife Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'rentitem 13021,604800;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12939,'Counter_Dagger_Box','Dagger of Counter Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'rentitem 13022,604800;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12940,'Kaiser_Knuckle_Box','Kaiser Knuckle Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'rentitem 1817,604800;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12941,'Pole_Axe_Box','Poll Axe Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'rentitem 1419,604800;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12942,'Mighty_Staff_Box','Mighty Staff Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'rentitem 1623,604800;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12943,'Right_Epsilon_Box','Light Epsilon Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'rentitem 1372,604800;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12944,'Balistar_Box','Ballista Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'rentitem 1728,604800;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12945,'Diary_Of_Great_Sage_Box','Sage\'s Diary Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'rentitem 1563,604800;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12946,'Asura_Box','Asura Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'rentitem 13023,604800;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12947,'Apple_Of_Archer_Box','Apple of Archer Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'rentitem 5265,1209600;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12948,'Bunny_Band_Box','Bunny Band Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'rentitem 5266,1209600;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12949,'Sahkkat_Box','Sakkat Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'rentitem 5267,1209600;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12950,'Lord_Circlet_Box','Grand Circlet Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'rentitem 5268,1209600;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12951,'Elven_Ears_Box','Elven Ears Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'rentitem 2686,604800;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12952,'Steel_Flower_Box','Steel Flower Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'rentitem 2687,1209600;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12953,'Critical_Ring_Box','Critical Ring Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'rentitem 2688,604800;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12954,'Earring_Box','Earring Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'rentitem 2689,604800;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12955,'Ring_Box','Ring Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'rentitem 2690,604800;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12956,'Necklace_Box','Necklace Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'rentitem 2691,604800;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12957,'Glove_Box','Glove Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'rentitem 2692,604800;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12958,'Brooch_Box','Brooch Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'rentitem 2693,604800;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12959,'Rosary_Box','Rosary Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'rentitem 2694,604800;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12960,'Safety_Ring_Box','Safety Ring Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'rentitem 2695,604800;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12961,'Vesper_Core01_Box','Vesper Core 01 Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'rentitem 2696,604800;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12962,'Vesper_Core02_Box','Vesper Core 02 Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'rentitem 2697,604800;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12963,'Vesper_Core03_Box','Vesper Core 03 Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'rentitem 2698,604800;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12964,'Vesper_Core04_Box','Vesper Core 04 Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'rentitem 2699,604800;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12965,'Emergency_Box1','Emergency Level 1 Scroll Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 12968,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12966,'Emergency_Box2','Emergency Level 2 Scroll Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 12969,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12967,'Emergency_Box3','Emergency Level 3 Scroll Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 12970,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12968,'Emergency_Scroll1','Emergency Level 1 Scroll',2,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'unitskilluseid getcharid(3),"GD_ITEMEMERGENCYCALL",1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12969,'Emergency_Scroll2','Emergency Level 2 Scroll',2,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'unitskilluseid getcharid(3),"GD_ITEMEMERGENCYCALL",2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12970,'Emergency_Scroll3','Emergency Level 3 Scroll',2,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'unitskilluseid getcharid(3),"GD_ITEMEMERGENCYCALL",3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12971,'Teleport_Box1','Teleport Scroll Box 1',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 12977,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12972,'Teleport_Box2','Teleport Scroll Box 2',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 12978,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12973,'Teleport_Box3','Teleport Scroll Box 3',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 12979,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12974,'Teleport_Box4','Teleport Scroll Box 4',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 12980,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12975,'Teleport_Box5','Teleport Scroll Box 5',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 12981,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12976,'Teleport_Box6','Teleport Scroll Box 6',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 12982,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12977,'Teleport_Scroll1','Teleport Scroll 1',2,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'callfunc "F_CashTele",1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12978,'Teleport_Scroll2','Teleport Scroll 2',2,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'callfunc "F_CashTele",2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12979,'Teleport_Scroll3','Teleport Scroll 3',2,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'callfunc "F_CashTele",3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12980,'Teleport_Scroll4','Teleport Scroll 4',2,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'callfunc "F_CashTele",4;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12981,'Teleport_Scroll5','Teleport Scroll 5',2,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'callfunc "F_CashTele",5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12982,'Teleport_Scroll6','Teleport Scroll 6',2,2,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'callfunc "F_CashTele",6;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12983,'Pet_Egg_Scroll_Box6','Pet Egg Scroll Box 6',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 12989,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12984,'Pet_Egg_Scroll_Box7','Pet Egg Scroll Box 7',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 12990,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12985,'Pet_Egg_Scroll_Box8','Pet Egg Scroll Box 8',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 12991,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12986,'Pet_Egg_Scroll_Box9','Adventurer Pack Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 12992,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12987,'Pet_Egg_Scroll_Box10','Pet Egg Scroll Box 10',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 12993,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12988,'Pet_Egg_Scroll_Box11','Pet Egg Scroll Box 11',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 12994,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12989,'Pet_Egg_Scroll6','Pet Egg Scroll 6',11,NULL,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12990,'Pet_Egg_Scroll7','Pet Egg Scroll 7',11,NULL,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12991,'Pet_Egg_Scroll8','Party Hard Pack',11,NULL,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12992,'Pet_Egg_Scroll9','Adventurer Pack',11,NULL,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12993,'Pet_Egg_Scroll10','Pet Egg Scroll 10',11,NULL,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12994,'Pet_Egg_Scroll11','Pet Egg Scroll 11',11,NULL,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (12995,'White_Herb_Box','White Herb Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 509,15;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12996,'Blue_Herb_Box','Blue Herb Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 510,15;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12997,'Elunium_Box','Elunium Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 985,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12998,'Oridecon_Box','Oridecon Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 984,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (12999,'Branch_Of_Dead_Tree_Box','Dead Branch Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 604,3;',NULL,NULL);
# More Weapons
#===================================================================
# Daggers and Ninja Weapons
REPLACE INTO `item_db` VALUES (13000,'Jujube_Dagger','Jujube Dagger',5,10000,NULL,600,39,NULL,1,0,0x3E9F7EEF,7,2,2,1,1,1,1,'bonus bAtkEle,Ele_Wind;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13001,'Dragon_Killer','Dragon Killer',5,20,NULL,900,110,NULL,1,0,0x3E9F7EEF,7,2,2,4,60,1,1,'bonus bIgnoreDefRace,RC_Dragon; bonus2 bExpAddRace,RC_Dragon,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13002,'Ginnungagap','Ginnungagap',5,20,NULL,700,148,NULL,1,0,0x3E9F7EEF,7,2,2,4,70,1,1,'bonus bAtkEle,Ele_Dark; bonus2 bAddEff,Eff_Blind,500; bonus2 bAddEff2,Eff_Blind,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13003,'Coward','Cowardice Blade',5,52000,NULL,700,80,NULL,1,1,0x02021040,7,2,2,3,55,1,1,'bonus bDef,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13004,'Coward_','Cowardice Blade',5,52000,NULL,700,80,NULL,1,2,0x02021040,7,2,2,3,55,1,1,'bonus bDef,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13005,'Angelwing_Short_Sword','Angelic Wing Dagger',5,20,NULL,600,120,NULL,1,2,0x00000001,7,2,2,4,50,1,1,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (13006,'Khukri','Khukri',5,240000,NULL,600,150,NULL,1,0,0x02000000,7,2,2,3,65,1,1,'bonus bAtkEle,Ele_Dark; bonus2 bAddEff,Eff_Curse,1000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13007,'Jitte','Jitte',5,20000,NULL,400,70,NULL,1,0,0x02000000,7,2,2,2,35,1,1,'bonus bBreakWeaponRate,200;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13008,'Jitte_','Jitte',5,20000,NULL,400,70,NULL,1,1,0x02000000,7,2,2,2,35,1,1,'bonus bBreakWeaponRate,200;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13009,'Kamaitachi','Kamaitachi',5,48000,NULL,900,125,NULL,2,0,0x02000000,7,2,2,4,70,1,1,'bonus bAtkEle,Ele_Wind; bonus bCritical,3; bonus bAspdRate,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13010,'Asura','Asura',5,3000,NULL,600,50,NULL,1,2,0x02000000,7,2,2,1,12,1,1,'bonus bMatkRate,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13011,'Asura_','Asura',5,3000,NULL,600,50,NULL,1,3,0x02000000,7,2,2,1,12,1,1,'bonus bMatkRate,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13012,'Murasame','Murasame',5,20,NULL,700,95,NULL,1,1,0x02000000,7,2,2,2,24,1,1,'bonus bAtkEle,Ele_Water; bonus2 bCriticalAddRace,RC_DemiHuman,10; bonus2 bCriticalAddRace,RC_Player,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13013,'Murasame_','Murasame',5,20,NULL,700,95,NULL,1,2,0x02000000,7,2,2,2,24,1,1,'bonus bAtkEle,Ele_Water; bonus2 bCriticalAddRace,RC_DemiHuman,10; bonus2 bCriticalAddRace,RC_Player,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13014,'Hakujin','Hakujin',5,20,NULL,800,120,NULL,1,0,0x02000000,7,2,2,3,42,1,1,'bonus bInt,2; bonus3 bAutoSpell,"AL_HEAL",1,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13015,'Hakujin_','Hakujin',5,20,NULL,800,120,NULL,1,1,0x02000000,7,2,2,3,42,1,1,'bonus bInt,2; bonus3 bAutoSpell,"AL_HEAL",1,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13016,'Poison_Knife_','Poison Knife',5,20,NULL,800,64,NULL,1,2,0x028F5EEE,7,2,2,3,65,1,1,'bonus bAtkEle,Ele_Poison; bonus2 bAddEff,Eff_Poison,3000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13017,'House_Auger_','Ice Pick',5,20,NULL,600,70,NULL,1,1,0x028F5EEE,7,2,2,4,36,1,1,'bonus bDefRatioAtkClass,Class_All;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13018,'Sucsamad_','Sucsamad',5,20,NULL,800,140,NULL,1,1,0x028F5EEE,7,2,2,4,36,1,1,'bonus2 bAddEle,Ele_Earth,10; bonus2 bAddEle,Ele_Wind,10; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13019,'Ginnungagap_','Ginnungagap',5,20,NULL,700,148,NULL,1,1,0x3E9F7EEF,7,2,2,4,70,1,1,'bonus bAtkEle,Ele_Dark; bonus2 bAddEff,Eff_Blind,500; bonus2 bAddEff2,Eff_Blind,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13020,'Warrior_Balmung_','Warrior\'s Balmung',5,20,NULL,1000,170,NULL,1,0,0xFFFFFFFF,7,2,2,4,48,1,1,'bonus bAllStats,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13021,'Combat_Knife_C','Combat Knife',5,1,NULL,0,129,NULL,1,0,0x028F5EEE,7,2,2,4,1,0,1,'bonus bIgnoreDefRace,RC_DemiHuman; bonus bIgnoreDefRace,RC_Player; bonus2 bSubRace,RC_DemiHuman,10; bonus2 bSubRace,RC_Player,10; bonus2 bSubRace,RC_Demon,-10; bonus bMaxSPrate,10; bonus bSPDrainValue,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13022,'Counter_Dagger_C','Dagger of Counter',5,1,NULL,0,209,NULL,1,0,0x00810204,7,2,2,4,1,0,1,'bonus bCritical,90;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13023,'Asura_C','Ashura',5,1,NULL,0,120,NULL,1,0,0x02000000,7,2,2,1,1,0,1,'bonus bMatkRate,15;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13024,'Sword_Breaker_C','Refined Swordbreaker',5,2,NULL,0,105,NULL,1,0,0x028F5EEE,7,2,2,4,0,0,1,'bonus bBreakWeaponRate,500;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13025,'Mail_Breaker_C','Refined Mailbreaker',5,2,NULL,0,105,NULL,1,0,0x028F5EEE,7,2,2,4,0,0,1,'bonus bBreakArmorRate,500;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13026,'Moonlight_Sword_C','Moonlight Dagger',5,2,NULL,0,85,NULL,1,0,0x028F5EEE,7,2,2,4,0,0,1,'bonus bMaxSPrate,10; bonus bSPDrainValue,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13027,'Scalpel','Scalpel',5,20,NULL,500,120,NULL,1,3,0x028F5EEE,2,2,2,4,55,1,1,'bonus2 bAddEff,Eff_Bleeding,500;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13028,'Tooth_Blade','Tooth Blade',5,20,NULL,700,130,NULL,1,1,0x028F5EEE,2,2,2,4,55,1,1,'if(getrefine()>=9){ bonus3 bAutoSpell,"NPC_SLOWCAST",2,70; } else bonus3 bAutoSpell,"NPC_SLOWCAST",1,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13029,'Prinsence_Knife','Prinsense Knife',5,20,NULL,0,120,NULL,1,0,0x028F5EEE,7,2,2,1,0,0,1,'bonus2 bAddClass,Class_All,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13030,'Dragon_Killer_','Dragon Killer',5,20,NULL,900,110,NULL,1,2,0x3E9F7EEF,7,2,2,4,60,1,1,'bonus bIgnoreDefRace,RC_Dragon; bonus2 bExpAddRace,RC_Dragon,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13031,'Sword_Breaker_','Swordbreaker',5,20,NULL,1000,70,NULL,1,3,0x028F5EEE,7,2,2,4,36,1,1,'bonus bBreakWeaponRate,500;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13032,'Mail_Breaker_','Mailbreaker',5,20,NULL,1000,70,NULL,1,3,0x028F5EEE,7,2,2,4,36,1,1,'bonus bBreakArmorRate,500;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13033,'Assasin_Dagger_','Assassin Dagger',5,20,NULL,600,140,NULL,1,1,0x00001000,7,2,2,4,36,1,1,'bonus bMaxHPrate,20; bonus bMaxSPrate,15; bonus bAspdRate,2; bonus bAtkEle,Ele_Dark;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13034,'Twilight_Desert','Desert Twilight',5,20,NULL,600,130,NULL,1,2,0x00001000,2,2,2,2,70,1,1,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (13035,'Sandstorm','Sandstorm',5,20,NULL,600,50,NULL,1,4,0x00001000,2,2,2,2,70,1,1,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (13036,'BF_Dagger1','Brave Assassin\'s Damascus',5,20,NULL,0,120,NULL,1,0,0x3E9F7EEF,7,2,2,3,80,1,1,'bonus bStr,1; bonus bAgi,1; bonus2 bAddRace,RC_DemiHuman,75; bonus2 bAddRace,RC_Player,75; bonus2 bIgnoreDefRaceRate,RC_DemiHuman,20; bonus2 bIgnoreDefRaceRate,RC_Player,20; bonus bUnbreakableWeapon; if(Class==Job_Ninja||Class==Job_Rogue||Class==Job_Stalker) bonus bMatkRate,15;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13037,'BF_Dagger2','Valorous Assassin\'s Damascus',5,20,NULL,0,120,NULL,1,0,0x3E9F7EEF,7,2,2,3,80,1,1,'bonus bStr,1; bonus bAgi,1; bonus2 bAddRace,RC_DemiHuman,75; bonus2 bAddRace,RC_Player,75; bonus bUnbreakableWeapon; autobonus "{ bonus bDefRatioAtkClass,Class_All; }",10,6000,BF_WEAPON,"{ specialeffect2 EF_HASTEUP; }"; if(Class==Job_Ninja||Class==Job_Rogue||Class==Job_Stalker) bonus bMatkRate,15;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13038,'Dagger_Of_Hunter','Dagger of Hunter',5,20,NULL,700,120,NULL,1,3,0x00020000,2,2,2,3,70,1,1,'bonus bStr,1; bonus bAgi,2; bonus bDex,1; bonus4 bAutoSpellOnSkill,"RG_BACKSTAP","SM_BASH",10,100; bonus2 bSkillAtk,"RG_BACKSTAP",20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13039,'Ivory_Knife','Ivory Knife',5,20,NULL,700,130,NULL,1,2,0x028F5EEE,2,2,2,3,50,1,1,'bonus bAgi,2; bonus bAspdRate,3; bonus2 bAddEff,Eff_Bleeding,300; bonus3 bAutoSpell,"NPC_CRITICALWOUND",1,30;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13040,'N_Cutter','Novice Cutter',5,0,NULL,0,50,NULL,1,3,0x3E9F7EEF,7,2,2,1,1,0,1,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (13041,'N_Main_Gauche','Novice Main Gauche',5,0,NULL,0,63,NULL,1,3,0x3E9F7EEF,7,2,2,1,1,0,1,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (13042,'Krieger_Dagger1','Glorious Gladius',5,20,NULL,0,120,NULL,1,0,0x3E9F7EEF,7,2,2,4,80,1,1,'bonus2 bAddRace,RC_DemiHuman,75; bonus2 bAddRace,RC_Player,75; bonus2 bIgnoreDefRaceRate,RC_DemiHuman,20; bonus2 bIgnoreDefRaceRate,RC_Player,20; bonus3 bAutoSpell,"PR_LEXDIVINA",1,20; bonus bUnbreakableWeapon; if(getrefine()>5) { bonus2 bAddRace,RC_DemiHuman,(getrefine()-4)*(getrefine()-4); bonus2 bAddRace,RC_Player,(getrefine()-4)*(getrefine()-4); bonus2 bIgnoreDefRaceRate,RC_DemiHuman,5; bonus2 bIgnoreDefRaceRate,RC_Player,5; } if(getrefine()>8) bonus4 bAutoSpellOnSkill,"RG_RAID","NPC_WIDEBLEEDING",1,250;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13043,'Fortune_Sword_I','Fortune Sword',5,0,NULL,0,120,NULL,1,0,0x028F5EEE,7,2,2,4,0,0,1,'bonus bLuk,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13044,'House_Auger_I','Ice Pick',5,0,NULL,0,105,NULL,1,0,0x028F5EEE,7,2,2,4,0,0,1,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (13045,'Kamaitachi_I','Kamaitachi',5,0,NULL,0,155,NULL,2,0,0x02000000,7,2,2,4,0,0,1,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (13046,'Krieg','Krierg',5,20,NULL,500,110,NULL,1,3,0x00021040,2,2,2,2,50,1,1,'bonus3 bAddEffOnSkill,"RG_BACKSTAP",Eff_Bleeding,1000; bonus2 bSkillAtk,"RG_BACKSTAP",15;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13047,'Weihna','Weihna',5,20,NULL,500,135,NULL,1,2,0x00021040,2,2,2,3,50,1,1,'bonus3 bAddEffOnSkill,"RG_RAID",Eff_Poison,1000; autobonus "{ bonus2 bAddClass,Class_All,10; }",5,5000,BF_WEAPON|BF_SHORT,"{ specialeffect2 EF_POTION_BERSERK; }";',NULL,NULL);
REPLACE INTO `item_db` VALUES (13048,'Damascus_C','Damascus',5,0,NULL,0,153,NULL,1,0,0x028F5EEE,7,2,2,3,1,0,1,'bonus2 bAddSize,Size_All,40;',NULL,NULL);
# Revolvers
REPLACE INTO `item_db` VALUES (13100,'Six_Shooter','Six Shooter',5,4500,NULL,400,30,NULL,7,1,0x41000000,7,2,34,1,10,1,17,'bonus bHit,-10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13101,'Six_Shooter_','Six Shooter',5,4500,NULL,400,30,NULL,7,2,0x41000000,7,2,34,1,10,1,17,'bonus bHit,-10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13102,'Crimson_Bolt','Crimson Bolt',5,20000,NULL,450,45,NULL,7,1,0x41000000,7,2,34,2,35,1,17,'bonus bHit,-10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13103,'Crimson_Bolt_','Crimson Bolt',5,20000,NULL,450,45,NULL,7,2,0x41000000,7,2,34,2,35,1,17,'bonus bHit,-10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13104,'The_Garrison','Garrison',5,48000,NULL,500,70,NULL,7,1,0x41000000,7,2,34,2,55,1,17,'bonus bHit,-10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13105,'The_Garrison_','Garrison',5,48000,NULL,500,70,NULL,7,2,0x41000000,7,2,34,2,55,1,17,'bonus bHit,-10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13106,'Gold_Lux','Gold Lux',5,100000,NULL,500,20,NULL,7,0,0x41000000,7,2,34,3,12,1,17,'bonus bHit,-10; if(getskilllv("GS_GLITTERING")>0) bonus3 bAutoSpell,"GS_GLITTERING",getskilllv("GS_GLITTERING"),100;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13107,'Wasteland_Outlaw','Wasteland\'s Outlaw',5,20,NULL,580,68,NULL,7,2,0x41000000,7,2,34,3,70,1,17,'bonus bHit,readparam(bAgi)/10; bonus bAspdRate,readparam(bAgi)/14;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13108,'BF_Pistol1','Soldier Revolver',5,0,NULL,0,70,NULL,7,0,0x41000000,7,2,34,3,80,1,17,'bonus bDex,2; bonus bHit,-10; bonus2 bAddRace,RC_DemiHuman,55; bonus2 bAddRace,RC_Player,55; bonus2 bIgnoreDefRaceRate,RC_DemiHuman,20; bonus2 bIgnoreDefRaceRate,RC_Player,20; autobonus "{ bonus bAspdRate,100; }",10,3000,BF_WEAPON,"{ specialeffect2 EF_POTION_BERSERK; }"; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13109,'Wasteland_Outlaw_C','Wasteland Outlaw',5,20,NULL,0,100,NULL,7,0,0x41000000,7,2,34,3,0,0,17,'bonus bHit,readparam(bAgi)/10; bonus bAspdRate,readparam(bAgi)/14; bonus2 bAddClass,Class_All,10; bonus bMatkRate,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13110,'Krieger_Pistol1','Glorious Pistol',5,0,NULL,0,80,NULL,7,0,0x41000000,7,2,34,4,80,1,17,'bonus2 bAddRace,RC_DemiHuman,55; bonus2 bAddRace,RC_Player,55; bonus2 bIgnoreDefRaceRate,RC_DemiHuman,20; bonus2 bIgnoreDefRaceRate,RC_Player,20; bonus bUnbreakableWeapon; if(getrefine()>5){ bonus2 bAddRace,RC_DemiHuman,pow(getrefine()-4,2); bonus2 bAddRace,RC_Player,pow(getrefine()-4,2); bonus2 bIgnoreDefRaceRate,RC_DemiHuman,5; bonus2 bIgnoreDefRaceRate,RC_Player,5; } if(getrefine()>8) { bonus4 bAutoSpellOnSkill,"GS_RAPIDSHOWER","GS_GLITTERING",1,1000; bonus2 bSkillAtk,"GS_RAPIDSHOWER",getrefine()*2; }',NULL,NULL);
#13111,Sharpshooter_Revolver
REPLACE INTO `item_db` VALUES (13112,'P_Revolver1','Eden Revlover I',5,0,NULL,0,4,NULL,7,0,0x41000000,7,2,34,1,26,0,17,'bonus bHit,-5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13113,'P_Revolver2','Eden Revlover II',5,0,NULL,0,60,NULL,7,0,0x41000000,7,2,34,1,40,0,17,'bonus bHit,-5;',NULL,NULL);
# Guns
REPLACE INTO `item_db` VALUES (13150,'Branch','Branch',5,3000,NULL,500,50,NULL,9,3,0x41000000,7,2,34,1,1,1,18,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (13151,'The_Cyclone','Cyclone',5,17500,NULL,700,120,NULL,9,1,0x41000000,7,2,34,2,24,1,18,'bonus bHit,10; bonus bCritical,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13152,'The_Cyclone_','Cyclone',5,17500,NULL,700,120,NULL,9,2,0x41000000,7,2,34,2,24,1,18,'bonus bHit,10; bonus bCritical,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13153,'Dusk','Dusk',5,23500,NULL,750,150,NULL,9,1,0x41000000,7,2,34,2,56,1,18,'bonus bHit,10; bonus bCritical,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13154,'Rolling_Stone','Rolling Stone',5,12000,NULL,900,135,NULL,9,1,0x41000000,7,2,34,1,14,1,20,'bonus bSplashRange,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13155,'Black_Rose','Black Rose',5,32000,NULL,900,180,NULL,9,1,0x41000000,7,2,34,2,35,1,20,'bonus bSplashRange,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13156,'Gate_Keeper','Gate Keeper',5,56000,NULL,1000,210,NULL,9,0,0x41000000,7,2,34,2,24,1,20,'bonus bSplashRange,1; bonus3 bAutoSpell,"GS_SPREADATTACK",6,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13157,'Drifter','Drifter',5,80000,NULL,2300,50,NULL,9,1,0x41000000,7,2,34,2,55,1,19,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (13158,'Butcher','Butcher',5,130000,NULL,2500,75,NULL,9,0,0x41000000,7,2,34,3,68,1,19,'bonus2 bCriticalAddRace,RC_Brute,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13159,'Butcher_','Butcher',5,130000,NULL,2500,75,NULL,9,1,0x41000000,7,2,34,3,68,1,19,'bonus2 bCriticalAddRace,RC_Brute,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13160,'Destroyer','Destroyer',5,110000,NULL,1200,220,NULL,9,0,0x41000000,7,2,34,2,52,1,21,'bonus bBreakArmorRate,200;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13161,'Destroyer_','Destroyer',5,110000,NULL,1200,220,NULL,9,1,0x41000000,7,2,34,2,52,1,21,'bonus bBreakArmorRate,200;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13162,'Inferno','Inferno',5,230000,NULL,1250,280,NULL,9,1,0x41000000,7,2,34,2,65,1,21,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (13163,'Long_Barrel','Long Barrel',5,40000,NULL,1000,150,NULL,9,0,0x41000000,7,2,34,3,70,1,18,'bonus bHit,10; bonus bCritical,20; bonus bAspdRate,-3; bonus3 bAutoSpell,"GS_TRACKING",5,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13164,'Long_Barrel_','Long Barrel',5,40000,NULL,1000,150,NULL,9,1,0x41000000,7,2,34,3,70,1,18,'bonus bHit,10; bonus bCritical,20; bonus bAspdRate,-3; bonus3 bAutoSpell,"GS_TRACKING",5,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13165,'Jungle_Carbine','Jungle Carbine',5,56000,NULL,700,170,NULL,9,0,0x41000000,7,2,34,3,70,1,18,'bonus bHit,10; bonus bCritical,4; bonus bAspdRate,10; bonus bHit,-readparam(bDex)/3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13166,'Jungle_Carbine_','Jungle Carbine',5,56000,NULL,700,170,NULL,9,1,0x41000000,7,2,34,3,70,1,18,'bonus bHit,10; bonus bCritical,4; bonus bAspdRate,10; bonus bHit,-readparam(bDex)/3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13167,'Gate_KeeperDD','Gate Keeper-DD',5,72000,NULL,1300,200,NULL,9,0,0x41000000,7,2,34,4,70,1,20,'bonus bSplashRange,1; bonus3 bAutoSpell,"GS_SPREADATTACK",6,50; bonus bDef,getrefine(); bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13168,'Thunder_P','Thunder P',5,76000,NULL,700,80,NULL,9,1,0x41000000,7,2,34,3,70,1,20,'bonus bSplashRange,1; bonus bHit,-5; bonus bAspdRate,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13169,'Thunder_P_','Thunder P',5,76000,NULL,700,80,NULL,9,2,0x41000000,7,2,34,3,70,1,20,'bonus bSplashRange,1; bonus bHit,-5; bonus bAspdRate,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13170,'Lever_Action_Rifle','Lever Action Rifle',5,20,NULL,770,138,NULL,9,2,0x41000000,7,2,34,3,70,1,18,'bonus bHit,20; bonus bCritical,50; bonus bAspdRate,-5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13171,'BF_Rifle1','Soldier Rifle',5,0,NULL,0,50,NULL,9,0,0x41000000,7,2,34,3,80,1,18,'bonus bDex,2; bonus bHit,10; bonus bCritical,10; bonus2 bAddRace,RC_DemiHuman,75; bonus2 bAddRace,RC_Player,75; bonus2 bCastrate,"GS_TRACKING",-25; bonus2 bIgnoreDefRaceRate,RC_DemiHuman,20; bonus2 bIgnoreDefRaceRate,RC_Player,20; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13172,'BF_Gatling_Gun1','Soldier Gatling Gun',5,0,NULL,0,80,NULL,9,0,0x41000000,7,2,34,3,80,1,19,'bonus bDex,2; bonus2 bAddRace,RC_DemiHuman,35; bonus2 bAddRace,RC_Player,35; bonus2 bIgnoreDefRaceRate,RC_DemiHuman,20; bonus2 bIgnoreDefRaceRate,RC_Player,20; autobonus "{ bonus bBaseAtk,80; bonus2 bHPLossRate,120,1000; }",10,6000,BF_WEAPON,"{ specialeffect2 EF_BASH3D; }"; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13173,'BF_Shotgun1','Soldier Shotgun',5,0,NULL,0,100,NULL,9,0,0x41000000,7,2,34,3,80,1,20,'bonus bDex,2; bonus bSplashRange,1; bonus2 bAddRace,RC_DemiHuman,55; bonus2 bAddRace,RC_Player,55; bonus2 bIgnoreDefRaceRate,RC_DemiHuman,20; bonus2 bIgnoreDefRaceRate,RC_Player,20; autobonus "{ bonus bBaseAtk,80; bonus2 bHPLossRate,100,1000; }",30,6000,BF_WEAPON,"{ specialeffect2 EF_BASH3D; }"; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13174,'BF_Launcher1','Soldier Grenade Launcher',5,0,NULL,0,300,NULL,9,0,0x41000000,7,2,34,3,80,1,21,'bonus bDex,2; bonus2 bAddRace,RC_DemiHuman,35; bonus2 bAddRace,RC_Player,35; bonus2 bIgnoreDefRaceRate,RC_DemiHuman,20; bonus2 bIgnoreDefRaceRate,RC_Player,20; autobonus "{ bonus bBaseAtk,300; bonus2 bHPLossRate,120,1000; }",30,9000,BF_WEAPON,"{ specialeffect2 EF_BASH3D; }"; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13175,'Lever_Action_Rifle_C','Lever Action Rifle',5,20,NULL,0,170,NULL,9,0,0x41000000,7,2,34,3,0,0,18,'bonus bHit,20; bonus bCritical,50; bonus bAspdRate,-5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13176,'Krieger_Rifle1','Glorious Rifle',5,0,NULL,0,90,NULL,9,0,0x41000000,7,2,34,4,80,1,18,'bonus2 bAddRace,RC_DemiHuman,75; bonus2 bAddRace,RC_Player,75; bonus2 bIgnoreDefRaceRate,RC_DemiHuman,20; bonus2 bIgnoreDefRaceRate,RC_Player,20; bonus2 bSkillAtk,"GS_TRIPLEACTION",30; bonus bUnbreakableWeapon; if(getrefine()>5) { bonus2 bAddRace,RC_DemiHuman,(getrefine()-4)*(getrefine()-4); bonus2 bAddRace,RC_Player,(getrefine()-4)*(getrefine()-4); bonus2 bIgnoreDefRaceRate,RC_DemiHuman,5; bonus2 bIgnoreDefRaceRate,RC_Player,5; } if(getrefine()>8) { bonus2 bCastrate,"GS_TRACKING",25; bonus2 bSkillAtk,"GS_TRACKING",getrefine() * 3; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (13177,'Krieger_Gatling1','Glorious Gatling Gun',5,0,NULL,0,90,NULL,9,0,0x41000000,7,2,34,4,80,1,19,'bonus2 bAddRace,RC_DemiHuman,35; bonus2 bAddRace,RC_Player,35; bonus2 bIgnoreDefRaceRate,RC_DemiHuman,20; bonus2 bIgnoreDefRaceRate,RC_Player,20; bonus2 bSkillAtk,"GS_TRIPLEACTION",30; bonus bUnbreakableWeapon; if(getrefine()>5) { bonus2 bAddRace,RC_DemiHuman,(getrefine()-4)*(getrefine()-4); bonus2 bAddRace,RC_Player,(getrefine()-4)*(getrefine()-4); bonus2 bIgnoreDefRaceRate,RC_DemiHuman,5; bonus2 bIgnoreDefRaceRate,RC_Player,5; } if(getrefine()>8) {bonus2 bAddClass,Class_All,getrefine(); }',NULL,NULL);
REPLACE INTO `item_db` VALUES (13178,'Krieger_Shotgun1','Glorious Shotgun',5,0,NULL,0,110,NULL,9,0,0x41000000,7,2,34,4,80,1,20,'bonus2 bAddRace,RC_DemiHuman,55; bonus2 bAddRace,RC_Player,55; bonus2 bIgnoreDefRaceRate,RC_DemiHuman,20; bonus2 bIgnoreDefRaceRate,RC_Player,20; bonus bSplashRange,1; bonus2 bSkillAtk,"GS_TRIPLEACTION",30; bonus bUnbreakableWeapon; if(getrefine()>5) { bonus2 bAddRace,RC_DemiHuman,(getrefine()-4)*(getrefine()-4); bonus2 bAddRace,RC_Player,(getrefine()-4)*(getrefine()-4); bonus2 bIgnoreDefRaceRate,RC_DemiHuman,5; bonus2 bIgnoreDefRaceRate,RC_Player,5; } if(getrefine()>8) { bonus2 bSkillAtk,"GS_SPREADATTACK",getrefine() * 2; bonus3 bAddEffOnSkill,"GS_SPREADATTACK",Eff_Stun,2000; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (13179,'Krieger_Launcher1','Glorious Grenade Launcher',5,0,NULL,0,330,NULL,9,0,0x41000000,7,2,34,4,80,1,21,'bonus2 bAddRace,RC_DemiHuman,35; bonus2 bAddRace,RC_Player,35; bonus2 bIgnoreDefRaceRate,RC_DemiHuman,20; bonus2 bIgnoreDefRaceRate,RC_Player,20; bonus2 bSkillAtk,"GS_TRIPLEACTION",30; bonus bUnbreakableWeapon; if(getrefine()>5) { bonus2 bAddRace,RC_DemiHuman,(getrefine()-4)*(getrefine()-4); bonus2 bAddRace,RC_Player,(getrefine()-4)*(getrefine()-4); bonus2 bIgnoreDefRaceRate,RC_DemiHuman,5; bonus2 bIgnoreDefRaceRate,RC_Player,5; } if(getrefine()>8) { bonus2 bSkillAtk,"GS_GROUNDDRIFT",getrefine() * 2; bonus3 bAddEffOnSkill,"GS_SPREADATTACK",Eff_Stun,2000; autobonus "{ bonus bAspdRate,20; }",200,20000,BF_WEAPON,"{ specialeffect2 EF_POTION_BERSERK; }"; }',NULL,NULL);
# Bullets
REPLACE INTO `item_db` VALUES (13200,'Bullet','Bullet',10,1,NULL,2,10,NULL,NULL,NULL,0x41000000,7,2,32768,NULL,1,NULL,3,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (13201,'Silver_Bullet','Silver Bullet',10,15,NULL,2,15,NULL,NULL,NULL,0x41000000,7,2,32768,NULL,1,NULL,3,'bonus bAtkEle,Ele_Holy;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13202,'Shell_Of_Blood','Bloody Shell',10,30,NULL,2,30,NULL,NULL,NULL,0x41000000,7,2,32768,NULL,1,NULL,3,'bonus2 bAddEff,Eff_Bleeding,100;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13203,'Flare_Sphere','Flare Sphere',10,80,NULL,5,50,NULL,NULL,NULL,0x41000000,7,2,32768,NULL,1,NULL,5,'bonus bAtkEle,Ele_Fire;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13204,'Lighting_Sphere','Lightning Sphere',10,80,NULL,5,50,NULL,NULL,NULL,0x41000000,7,2,32768,NULL,1,NULL,5,'bonus bAtkEle,Ele_Wind;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13205,'Poison_Sphere','Poison Sphere',10,80,NULL,5,50,NULL,NULL,NULL,0x41000000,7,2,32768,NULL,1,NULL,5,'bonus bAtkEle,Ele_Poison; bonus2 bAddEff,Eff_Poison,500;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13206,'Blind_Sphere','Blind Sphere',10,80,NULL,5,50,NULL,NULL,NULL,0x41000000,7,2,32768,NULL,1,NULL,5,'bonus bAtkEle,Ele_Dark; bonus2 bAddEff,Eff_Blind,500;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13207,'Freezing_Sphere','Freezing Sphere',10,80,NULL,5,50,NULL,NULL,NULL,0x41000000,7,2,32768,NULL,1,NULL,5,'bonus bAtkEle,Ele_Water;',NULL,NULL);
# Shurikens & Kunais
REPLACE INTO `item_db` VALUES (13250,'Shuriken','Shuriken',10,4,NULL,5,10,NULL,NULL,NULL,0x02000000,7,2,32768,NULL,1,NULL,6,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (13251,'Nimbus_Shuriken','Nimbus Shuriken',10,10,NULL,5,30,NULL,NULL,NULL,0x02000000,7,2,32768,NULL,20,NULL,6,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (13252,'Flash_Shuriken','Flash Shuriken',10,20,NULL,5,45,NULL,NULL,NULL,0x02000000,7,2,32768,NULL,40,NULL,6,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (13253,'Sharp_Leaf_Shuriken','Sharp Leaf Shuriken',10,40,NULL,5,70,NULL,NULL,NULL,0x02000000,7,2,32768,NULL,60,NULL,6,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (13254,'Thorn_Needle_Shuriken','Thorn Needle Shuriken',10,100,NULL,5,100,NULL,NULL,NULL,0x02000000,7,2,32768,NULL,80,NULL,6,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (13255,'Kunai_Of_Icicle','Icicle Kunai',10,10,NULL,20,30,NULL,NULL,NULL,0x02000000,7,2,32768,NULL,1,NULL,7,'bonus bAtkEle,Ele_Water;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13256,'Kunai_Of_Black_Soil','Black Earth Kunai',10,10,NULL,20,30,NULL,NULL,NULL,0x02000000,7,2,32768,NULL,1,NULL,7,'bonus bAtkEle,Ele_Earth;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13257,'Kunai_Of_Furious_Wind','High Wind Kunai',10,10,NULL,20,30,NULL,NULL,NULL,0x02000000,7,2,32768,NULL,1,NULL,7,'bonus bAtkEle,Ele_Wind;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13258,'Kunai_Of_Fierce_Flame','Heat Wave Kunai',10,10,NULL,20,30,NULL,NULL,NULL,0x02000000,7,2,32768,NULL,1,NULL,7,'bonus bAtkEle,Ele_Fire;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13259,'Kunai_Of_Deadly_Poison','Fell Poison Kunai',10,10,NULL,20,30,NULL,NULL,NULL,0x02000000,7,2,32768,NULL,1,NULL,7,'bonus bAtkEle,Ele_Poison; bonus2 bAddEff,Eff_Poison,500;',NULL,NULL);
# Genetic Created Bombs And Throwing Items
REPLACE INTO `item_db` VALUES (13260,'Apple_Bomb','Apple Bomb',10,100,NULL,1,0,NULL,NULL,NULL,0x00040000,8,2,32768,NULL,99,NULL,9,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (13261,'Coconut_Bomb','Coconut Bomb',10,100,NULL,1,0,NULL,NULL,NULL,0x00040000,8,2,32768,NULL,99,NULL,9,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (13262,'Melon_Bomb','Melon Bomb',10,100,NULL,1,0,NULL,NULL,NULL,0x00040000,8,2,32768,NULL,99,NULL,9,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (13263,'Pineapple_Bomb','Pineapple Bomb',10,100,NULL,1,0,NULL,NULL,NULL,0x00040000,8,2,32768,NULL,99,NULL,9,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (13264,'Banana_Bomb','Banana Bomb',10,100,NULL,1,0,NULL,NULL,NULL,0x00040000,8,2,32768,NULL,99,NULL,9,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (13265,'Black_Lump','Black Lump',10,100,NULL,50,0,NULL,NULL,NULL,0x00040000,8,2,32768,NULL,99,NULL,9,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (13266,'Black_Hard_Lump','Hard Black Lump',10,100,NULL,50,0,NULL,NULL,NULL,0x00040000,8,2,32768,NULL,99,NULL,9,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (13267,'Very_Hard_Lump','Extremely Hard Black Lump',10,100,NULL,50,0,NULL,NULL,NULL,0x00040000,8,2,32768,NULL,99,NULL,9,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (13268,'Mysterious_Powder','Mysterious Powder',10,100,NULL,10,0,NULL,NULL,NULL,0x00040000,8,2,32768,NULL,99,NULL,9,'sc_start SC_MYSTERIOUS_POWDER,10000,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13269,'Boost500_To_Throw','Throwing Boost 500',10,100,NULL,10,0,NULL,NULL,NULL,0x00040000,8,2,32768,NULL,99,NULL,9,'sc_start SC_BOOST500,500000,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13270,'Full_SwingK_To_Throw','Throwing Full Swing K',10,100,NULL,50,0,NULL,NULL,NULL,0x00040000,8,2,32768,NULL,99,NULL,9,'sc_start SC_FULL_SWING_K,500000,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13271,'Mana_Plus_To_Throw','Throwing Mana Plus',10,100,NULL,50,0,NULL,NULL,NULL,0x00040000,8,2,32768,NULL,99,NULL,9,'sc_start SC_MANA_PLUS,500000,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13272,'Cure_Free_To_Throw','Throwing Cure Free',10,100,NULL,50,0,NULL,NULL,NULL,0x00040000,8,2,32768,NULL,99,NULL,9,'sc_end SC_BLEEDING; sc_end SC_CURSE; sc_end SC_SILENCE; sc_end SC_POISON; sc_end SC_ORCISH; sc_end SC_CHANGEUNDEAD; sc_end SC_BLIND; sc_end SC_CONFUSION; sc_end SC_DPOISON; itemheal 500,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13273,'Stamina_Up_M_To_Throw','Throwing Muramura M',10,100,NULL,10,0,NULL,NULL,NULL,0x00040000,8,2,32768,NULL,99,NULL,9,'sc_start SC_MUSTLE_M,500000,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13274,'Digestive_F_To_Throw','Throwing Falmons F',10,100,NULL,10,0,NULL,NULL,NULL,0x00040000,8,2,32768,NULL,99,NULL,9,'sc_start SC_LIFE_FORCE_F,500000,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13275,'HP_Inc_PotS_To_Throw','Throwing Increase HP Potion (Small)',10,100,NULL,20,0,NULL,NULL,NULL,0x00040000,8,2,32768,NULL,99,NULL,9,'/* Item bonus in source because of BaseLevel check */',NULL,NULL);
REPLACE INTO `item_db` VALUES (13276,'HP_Inc_PotM_To_Throw','Throwing Increase HP Potion (Medium)',10,100,NULL,40,0,NULL,NULL,NULL,0x00040000,8,2,32768,NULL,99,NULL,9,'/* Item bonus in source because of BaseLevel check */',NULL,NULL);
REPLACE INTO `item_db` VALUES (13277,'HP_Inc_PotL_To_Throw','Throwing Increase HP Potion (Large)',10,100,NULL,80,0,NULL,NULL,NULL,0x00040000,8,2,32768,NULL,99,NULL,9,'/* Item bonus in source because of BaseLevel check */',NULL,NULL);
REPLACE INTO `item_db` VALUES (13278,'SP_Inc_PotS_To_Throw','Throwing Increase SP Potion (Small)',10,100,NULL,20,0,NULL,NULL,NULL,0x00040000,8,2,32768,NULL,99,NULL,9,'/* Item bonus in source because of BaseLevel check */',NULL,NULL);
REPLACE INTO `item_db` VALUES (13279,'SP_Inc_PotM_To_Throw','Throwing Increase SP Potion (Medium)',10,100,NULL,40,0,NULL,NULL,NULL,0x00040000,8,2,32768,NULL,99,NULL,9,'/* Item bonus in source because of BaseLevel check */',NULL,NULL);
REPLACE INTO `item_db` VALUES (13280,'SP_Inc_PotL_To_Throw','Throwing Increase SP Potion (Large)',10,100,NULL,80,0,NULL,NULL,NULL,0x00040000,8,2,32768,NULL,99,NULL,9,'/* Item bonus in source because of BaseLevel check */',NULL,NULL);
REPLACE INTO `item_db` VALUES (13281,'En_White_PotZ_To_Throw','Throwing Concentrated White Potion Z',10,100,NULL,70,0,NULL,NULL,NULL,0x00040000,8,2,32768,NULL,99,NULL,9,'sc_start SC_EXTRACT_WHITE_POTION_Z,500000,20; itemheal 1000,0;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13282,'Vitata500_To_Throw','Throwing Vitata 500',10,100,NULL,50,0,NULL,NULL,NULL,0x00040000,8,2,32768,NULL,99,NULL,9,'sc_start2 SC_VITATA_500,500000,20,5; itemheal 0,200;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13283,'En_Cel_Juice_To_Throw','Throwing Ceromain Soup',10,100,NULL,50,0,NULL,NULL,NULL,0x00040000,8,2,32768,NULL,99,NULL,9,'sc_start SC_EXTRACT_SALAMINE_JUICE,500000,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13284,'Savage_BBQ_To_Throw','Throwing Savage Full Roast',10,100,NULL,50,0,NULL,NULL,NULL,0x00040000,8,2,32768,NULL,99,NULL,9,'sc_start SC_SAVAGE_STEAK,300000,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13285,'Wug_Cocktail_To_Throw','Throwing Cocktail Warg Blood',10,100,NULL,50,0,NULL,NULL,NULL,0x00040000,8,2,32768,NULL,99,NULL,9,'sc_start SC_COCKTAIL_WARG_BLOOD,300000,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13286,'M_Brisket_To_Throw','Throwing Minor Stew',10,100,NULL,50,0,NULL,NULL,NULL,0x00040000,8,2,32768,NULL,99,NULL,9,'sc_start SC_MINOR_BBQ,300000,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13287,'Siroma_Icetea_To_Throw','Throwing Siroma Iced Tea',10,100,NULL,50,0,NULL,NULL,NULL,0x00040000,8,2,32768,NULL,99,NULL,9,'sc_start SC_SIROMA_ICE_TEA,300000,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13288,'Drocera_Stew_To_Throw','Throwing Drosera Herb Salad',10,100,NULL,50,0,NULL,NULL,NULL,0x00040000,8,2,32768,NULL,99,NULL,9,'sc_start SC_DROCERA_HERB_STEAMED,300000,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13289,'Petti_Noodle_To_Throw','Throwing Petite Tail Soup',10,100,NULL,50,0,NULL,NULL,NULL,0x00040000,8,2,32768,NULL,99,NULL,9,'sc_start SC_PUTTI_TAILS_NOODLES,300000,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13290,'Black_Thing_To_Throw','Throwing Black Mass',10,100,NULL,50,0,NULL,NULL,NULL,0x00040000,8,2,32768,NULL,99,NULL,9,'sc_start SC_STOMACHACHE,60000,rand(5,10);',NULL,NULL);
REPLACE INTO `item_db` VALUES (13294,'Explosive_Kunai','Explosive Kunai',10,100,NULL,30,50,NULL,NULL,NULL,0x02000000,63,2,32768,NULL,100,NULL,7,'bonus bAtkEle,Ele_Neutral;',NULL,NULL);
# Ninja Fuuma Shurikens
REPLACE INTO `item_db` VALUES (13300,'Huuma_Bird_Wing','Huuma Wing Shuriken',5,90000,NULL,3000,150,NULL,1,0,0x02000000,7,2,34,4,65,1,22,'bonus bUnbreakableWeapon; bonus bAtkEle,Ele_Wind; bonus bDex,-2; bonus bAgi,-1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13301,'Huuma_Giant_Wheel','Huuma Giant Wheel Shuriken',5,40000,NULL,2500,50,NULL,1,3,0x02000000,7,2,34,4,42,1,22,'bonus bUnbreakableWeapon; bonus2 bAddEff,Eff_Bleeding,100;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13302,'Huuma_Giant_Wheel_','Huuma Giant Wheel Shuriken',5,40000,NULL,2500,50,NULL,1,4,0x02000000,7,2,34,4,42,1,22,'bonus bUnbreakableWeapon; bonus2 bAddEff,Eff_Bleeding,100;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13303,'Huuma_Blaze','Huuma Blaze Shuriken',5,78000,NULL,1500,185,NULL,1,0,0x02000000,7,2,34,4,55,1,22,'bonus bUnbreakableWeapon; bonus bAtkEle,Ele_Fire; bonus bDex,-2; bonus3 bAutoSpell,"MG_FIREBALL",5,30;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13304,'Huuma_Calm_Mind','Huuma Calm Mind',5,20,NULL,1550,112,NULL,1,2,0x02000000,7,2,34,3,70,1,22,'bonus bUnbreakableWeapon; bonus2 bSkillAtk,"NJ_HUUMA",30; bonus bNoCastCancel;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13305,'BF_Huuma_Shuriken1','Brave Huuma Front Shuriken',5,20,NULL,0,55,NULL,1,0,0x02000000,7,2,34,3,80,1,22,'bonus bStr,2; bonus bDex,1; bonus2 bAddRace,RC_DemiHuman,95; bonus2 bAddRace,RC_Player,95; bonus2 bIgnoreDefRaceRate,RC_DemiHuman,20; bonus2 bIgnoreDefRaceRate,RC_Player,20; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13306,'BF_Huuma_Shuriken2','Valorous Huuma Front Shuriken',5,20,NULL,0,55,NULL,1,0,0x02000000,7,2,34,3,80,1,22,'bonus bStr,2; bonus bDex,1; bonus2 bAddRace,RC_DemiHuman,95; bonus2 bAddRace,RC_Player,95; autobonus "{ bonus2 bSkillAtk,\\\"NJ_HUUMA\\\",100; bonus2 bSkillAtk,\\\"NJ_ISSEN\\\",100; }",50,10000,BF_WEAPON,"{specialeffect2 EF_POTION_BERSERK; }"; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13307,'Krieger_Huuma_Shuriken1','Glorious Shuriken',5,20,NULL,0,55,NULL,1,0,0x02000000,7,2,34,4,80,1,22,'bonus2 bAddRace,RC_DemiHuman,95; bonus2 bAddRace,RC_Player,95; bonus2 bIgnoreDefRaceRate,RC_DemiHuman,20; bonus2 bIgnoreDefRaceRate,RC_Player,20; bonus bMatkRate,15; autobonus "{ bonus2 bSkillAtk,\\\"NJ_HUUMA\\\",100; bonus2 bSkillAtk,\\\"NJ_ISSEN\\\",100; }",50,10000; bonus bUnbreakableWeapon; if(getrefine()>5) { bonus2 bAddRace,RC_DemiHuman,(getrefine()-3)*(getrefine()-3); bonus2 bAddRace,RC_Player,(getrefine()-3)*(getrefine()-3); bonus2 bIgnoreDefRaceRate,RC_DemiHuman,5; bonus2 bIgnoreDefRaceRate,RC_Player,5; } if(getrefine()>8) { bonus5 bAutoSpellOnSkill,"NJ_ISSEN","AL_HEAL",10,1000,1; bonus4 bAutoSpellOnSkill,"NJ_HUUMA","NPC_CRITICALWOUND",2,200; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (13308,'Huuma_Blaze_I','Huuma Blaze Shuriken',5,0,NULL,0,230,NULL,1,0,0x02000000,7,2,34,4,0,0,22,'bonus bUnbreakableWeapon; bonus bAtkEle,Ele_Fire; bonus bDex,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13309,'Huuma_Giant_Wheel_C','Huuma Giant Wheel Shuriken',5,0,NULL,0,99,NULL,1,0,0x02000000,7,2,34,4,1,0,22,'bonus2 bAddSize,Size_All,80;',NULL,NULL);
# More 1-Handed Swords
REPLACE INTO `item_db` VALUES (13400,'Cutlas_','Cutlus',5,20,NULL,900,150,NULL,1,1,0x000654E2,7,2,2,4,40,1,2,'skill "SM_BASH",5; bonus bStr,2; bonus bDef,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13401,'Excalibur_C','Excalibur',5,1,NULL,0,199,NULL,1,0,0x000654E2,7,2,2,4,1,0,2,'bonus bInt,10; bonus bLuk,10; bonus bAtkEle,Ele_Holy;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13402,'Cutlas_C','Cutlus',5,2,NULL,0,185,NULL,1,0,0x000654E2,7,2,2,4,0,0,2,'skill "SM_BASH",5; bonus bStr,2; bonus bDef,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13403,'Solar_Sword_C','Solar Sword',5,2,NULL,0,120,NULL,1,0,0x000654E2,7,2,2,4,0,0,2,'bonus bAtkEle,Ele_Fire; bonus bHPDrainRate,1; bonus2 bSPLossRate,15,10000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13404,'Platinum_Shotel','Platinum Shotel',5,20,NULL,1500,130,NULL,1,1,0x000654E2,7,2,2,4,55,1,2,'bonus bCritical,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13405,'Curved_Sword','Curved Sword',5,20,NULL,800,125,NULL,1,2,0x000654E2,7,2,2,4,55,1,2,'bonus bAspdRate,10; bonus2 bAddEff,Eff_Curse,300;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13406,'Edger','Edger',5,20,NULL,0,120,NULL,1,0,0x000654E2,7,2,2,1,0,0,2,'bonus2 bAddClass,Class_All,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13407,'Nagan_C','Refined Nagan',5,1,NULL,0,148,NULL,1,0,0x000654E2,7,2,2,4,0,0,2,'skill "TF_DOUBLE",5; bonus bDoubleRate,25; bonus2 bAddRace,RC_DemiHuman,40; bonus2 bAddRace,RC_Player,40;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13408,'Fire_Brand_C','Refined Fireblend',5,1,NULL,0,120,NULL,1,0,0x000654E2,7,2,2,4,0,0,2,'bonus bAtkEle,Ele_Fire; bonus bInt,2; skill "MG_FIREBOLT",5; bonus3 bAutoSpell,"MG_FIREBOLT",5,100;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13409,'Immaterial_Sword_C','Refined Immaterial Sword',5,1,NULL,0,160,NULL,1,0,0x000654E2,7,2,2,4,0,0,2,'bonus bAtkEle,Ele_Ghost; bonus2 bSPVanishRate,45,30; bonus bSPDrainValue,-1; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13410,'BF_Sword1','Valorous Gladiator Blade',5,20,NULL,0,115,NULL,1,0,0x000654E3,7,2,2,3,80,1,2,'bonus bStr,1; bonus bDex,1; bonus2 bAddRace,RC_DemiHuman,75; bonus2 bAddRace,RC_Player,75; bonus2 bIgnoreDefRaceRate,RC_DemiHuman,20; bonus2 bIgnoreDefRaceRate,RC_Player,20; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13411,'BF_Sword2','Brave Gladiator Blade',5,20,NULL,0,115,NULL,1,0,0x000654E3,7,2,2,3,80,1,2,'bonus bStr,1; bonus bDex,1; bonus2 bAddRace,RC_DemiHuman,75; bonus2 bAddRace,RC_Player,75; bonus bMatkRate,10; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13412,'Twin_Edge_B','Twin Edge of Naght Sieger',5,20,NULL,1500,150,NULL,1,3,0x000654E2,2,2,2,4,75,1,2,'bonus bAtkEle,Ele_Water; skill "MG_FROSTDIVER",5; autobonus "{ bonus bIgnoreDefClass,Class_Normal; }",50,5000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13413,'Twin_Edge_R','Twin Edge of Naght Sieger',5,20,NULL,1500,160,NULL,1,3,0x000654E2,2,2,2,4,75,1,2,'bonus bAtkEle,Ele_Fire; skill "WZ_METEOR",3; autobonus "{ bonus bIgnoreDefClass,Class_Normal; }",50,5000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13414,'Elemental_Sword','Elemental Sword',5,20,NULL,1200,105,NULL,1,3,0x000654E2,2,2,2,3,70,1,2,'bonus bStr,2; bonus bInt,4; bonus bDex,1; bonus bMatkRate,5; bonus2 bAddEle,Ele_Neutral,10; bonus3 bAutoSpell,"MG_COLDBOLT",3,50; bonus4 bAutoSpellOnSkill,"MG_COLDBOLT","MG_FIREBOLT",3,1000; bonus4 bAutoSpellOnSkill,"MG_FIREBOLT","MG_LIGHTNINGBOLT",3,1000; bonus4 bAutoSpellOnSkill,"MG_LIGHTNINGBOLT","WZ_EARTHSPIKE",3,1000;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13415,'N_Falchion','Novice Falchion',5,0,NULL,0,59,NULL,1,3,0x000654E3,7,2,2,1,2,0,2,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (13416,'Krieger_Onehand_Sword1','Glorious Flamberge',5,20,NULL,0,130,NULL,1,0,0x000654E3,7,2,2,4,80,1,2,'bonus2 bAddRace,RC_DemiHuman,75; bonus2 bAddRace,RC_Player,75; bonus2 bIgnoreDefRaceRate,RC_DemiHuman,20; bonus2 bIgnoreDefRaceRate,RC_Player,20; bonus bUnbreakableWeapon; if(getrefine()>5) { bonus2 bAddRace,RC_DemiHuman,(getrefine()-4)*(getrefine()-4); bonus2 bAddRace,RC_Player,(getrefine()-4)*(getrefine()-4); bonus2 bIgnoreDefRaceRate,RC_DemiHuman,5; bonus2 bIgnoreDefRaceRate,RC_Player,5; } if(getrefine()>6) bonus bAspdRate,5; if(getrefine()>8) { bonus bAspdRate,5; bonus4 bAutoSpellOnSkill,"SM_BASH","NPC_CRITICALWOUND",2,200; }',NULL,NULL);
REPLACE INTO `item_db` VALUES (13417,'Krieger_Onehand_Sword2','Glorious Rapier',5,20,NULL,0,130,NULL,1,0,0x000654E3,7,2,2,4,80,1,2,'bonus bInt,getrefine()-5; bonus bMatkRate,10; bonus bUnbreakableWeapon; if(getrefine()>5) bonus bUseSPrate,-10; if(getrefine()>8) bonus bInt,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13418,'Krieger_Onehand_Sword3','Glorious Holy Avenger',5,20,NULL,0,130,NULL,1,0,0x000444A2,7,2,2,4,80,1,2,'bonus bInt,getrefine()-5; bonus bMatkRate,10; bonus bUnbreakableWeapon; if(getrefine()>5) bonus bUseSPrate,-10; if(getrefine()>8) bonus4 bAutoSpellOnSkill,"PA_PRESSURE","PR_LEXAETERNA",1,1000; if(getrefine()>9) bonus bInt,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13419,'Holy_Saber','Holy saber',5,20,NULL,0,160,NULL,1,0,0x000654E2,7,2,2,3,0,0,2,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (13420,'Honglyun\'s_Sword','Honglyun\'s Sword',5,20,NULL,1200,160,NULL,1,1,0x000654E2,7,2,2,4,70,1,2,'bonus bAtkEle,Ele_Fire; bonus bStr,2; bonus bInt,2;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13421,'Ruber','Ruber',5,20,NULL,1500,170,NULL,1,1,0x000444A2,2,2,2,3,50,1,2,'autobonus "{ bonus2 bSkillAtk,\\\"KN_BOWLINGBASH\\\",20; bonus2 bSkillAtk,\\\"SM_BASH\\\",20; }",5,15000,BF_WEAPON,"{ specialeffect2 EF_ENHANCE; }";',NULL,NULL);
REPLACE INTO `item_db` VALUES (13422,'Flamberge_C','Flamberge',5,0,NULL,0,185,NULL,1,0,0x00004080,7,2,2,3,1,0,2,'bonus bUnbreakableWeapon; bonus2 bAddSize,Size_All,40;',NULL,NULL);
# More Cash Shop Items
REPLACE INTO `item_db` VALUES (13500,'Insurance60_Package','Life Insurrance Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 14500,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13501,'Assorted_Scroll_Box','Experience Scroll Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db` VALUES (13502,'Drooping_Kitty_Box','Refined Drooping Cat Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'rentitem 5279,604800;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13503,'Magestic_Goat_Box','Baphomet Horns Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'rentitem 5280,604800;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13504,'Deviruchi_Cap_Box','Refined Deviruchi Hat Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'rentitem 5281,604800;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13505,'Executioner_Box','Executioner Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'rentitem 1174,604800;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13506,'Brood_Axe_Box','Refined Bloody Axe Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'rentitem 1373,604800;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13507,'Tomahawk_Box','Tomahawk Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'rentitem 1374,604800;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13508,'Bow_Of_Rudra_Box','Rudra Bow Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'rentitem 1729,604800;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13509,'Cutlas_Box','Cutlus Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'rentitem 13402,604800;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13510,'Solar_Sword_Box','Solar Sword Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'rentitem 13403,604800;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13511,'Sword_Breaker_Box','Refined Swordbreaker Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'rentitem 13024,604800;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13512,'Mail_Breaker_Box','Refined Mailbreaker Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'rentitem 13025,604800;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13513,'Moonlight_Sword_Box','Moonlight Dagger Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'rentitem 13026,604800;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13514,'Spanner_Box','Wrench Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'rentitem 1534,604800;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13515,'Grape_Box','Grape Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 514,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13516,'Royal_Jelly_Box','Royal Jelly Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 526,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13517,'Yggdrasilberry_Box','Yggdrasil Berry Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 607,3;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13518,'Weapon_Card_Scroll_Box','Weapon Card Pet Egg Scroll Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 13558,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13519,'Armor_Card_Scroll_Box','Armor Card Pet Egg Scroll Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 13559,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13520,'Helmet_Card_Scroll_Box','Helmet Card Pet Egg Scroll Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 13560,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13521,'Hood_Card_Scroll_Box','Garment Card Pet Egg Scroll Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 13561,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13522,'Hood_Card_Scroll_Box2','Shield Card Pet Egg Scroll Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 13562,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13523,'Shoes_Card_Scroll_Box','Shoes Card Pet Egg Scroll Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 13563,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13524,'Accy_Card_Scroll_Box','Accessory Card Pet Egg Scroll Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 13564,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13525,'Zeny_Scroll_Box','Zeny Pet Egg Scroll Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 14508,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13526,'Pet_Egg_Scroll_Box1_','Pet Egg Scroll Box 12',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 12925,30;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13527,'Pet_Egg_Scroll_Box2_','Pet Egg Scroll Box 13',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 12926,30;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13528,'Pet_Egg_Scroll_Box3_','Pet Egg Scroll Box 14',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 12932,30;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13529,'Pet_Egg_Scroll_Box4_','Pet Egg Scroll Box 15',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 12933,30;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13530,'Pet_Egg_Scroll_Box5_','Pet Egg Scroll Box 16',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 12934,30;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13531,'Light_Red_Pot_Box','Light Red Potion Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 598,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13532,'Light_Orange_Pot_Box','Light Orange Potion Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 599,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13533,'Light_Yellow_Pot_Box','Light Yellow Potion Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 11500,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13534,'Light_White_Pot_Box','Light White Potion Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 11501,50;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13535,'Light_Center_Pot_Box','Light Concentration Potion Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 14509,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13536,'Light_Awakening_Pot_Box','Light Awakening Potion Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 14510,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13537,'Light_Berserk_Pot_Box','Light Berserk Potion Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 14511,20;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13538,'Meteor_10_Scroll_Box','Meteor Storm Scroll Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 14512,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13539,'Storm_10_Scroll_Box','Storm Gust Scroll Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 14513,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13540,'Vermilion_10_Scroll_Box','Lord of Vermilion Scroll Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 14514,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13541,'Lex_Aeterna_Scroll_Box','Lex Aeterna Scroll Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 14515,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13542,'Magnificat_5_Scroll_Box','Magnificat Scroll Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 14516,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13543,'CP_Helm_Scroll_Box','Chemical Protection Helm Scroll Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 14517,10; getitem 7139,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13544,'CP_Shield_Scroll_Box','Chemical Protection Shield Scroll Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 14518,10; getitem 7139,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13545,'CP_Armor_Scroll_Box','Chemical Protection Armor Scroll Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 14519,10; getitem 7139,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13546,'CP_Weapon_Scroll_Box','Chemical Protection Weapon Scroll Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 14520,10; getitem 7139,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13547,'Repair_Scroll_Box','Repair Weapon Scroll Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 14587,5; getitem 1002,5; getitem 998,5; getitem 756,5; getitem 999,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13548,'Big_Bun_Box','Big Bun Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 14522,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13549,'Pill__Box','Pill Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 14523,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13550,'Superb_Fish_Slice_Box','Fish Slice Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 14524,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13551,'Chewy_Ricecake_Box','Chewy Ricecake Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 14525,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13552,'Oriental_Pastry_Box','Pastry Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 14526,10;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13553,'Dun_Tele_Scroll1_Box','Dungeon Teleport Scroll 5 Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 14527,5;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13554,'Weapon_Card_Scroll_Box2','Weapon Card Pet Egg Scroll Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 13565,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13555,'Weapon_Card_Scroll_Box3','Weapon Card Pet Egg Scroll Box',18,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,7,2,NULL,NULL,NULL,NULL,NULL,'getitem 13566,1;',NULL,NULL);
REPLACE INTO `item_db` VALUES (13556,'Armor_Card_Scroll_Box2','Armor Card Pet Egg Scroll Box',18,20,NULL,10,NULL,NULL,