# SC 技能状态一览

------

使用方法：
- 通过函数命令 [`sc_start <type>,<tick>,<val1>[,<target_id>];`](https://lyy289065406.github.io/api-online/javadoc/RO-EA-API/exp/ro/cmd/ch/04_player/0400_Player_Commands.html#Z:Z_sc_start--) 调用
<br/>　参数 `<type>` 表示技能状态的编号（下表为可选范围，数值或常量均可） 
<br/>　参数 `<tick>` 异常状态持续的时间（数值类型，单位为ms） 
<br/>　参数 `<val1>` 表示造成该状态的对应技能的等级（数值类型） 
<br/>　参数 `<target_id>` 目标ID（数值类型，省略时为自己） 
- 示例：`sc_start SC_BLESSING,600000,10;` 表示使自己陷入 10 级天使之赐福效果 600 秒

> 注意区分 [`skilleffect`](https://lyy289065406.github.io/api-online/javadoc/RO-EA-API/exp/ro/cmd/ch/04_player/0400_Player_Commands.html#Z:Z_skilleffect--) 函数命令
<br/>　该命令仅是使画面呈现技能发动效果，而不会使得角色陷入技能状态，但是一般和 `sc_start` 一起使用

------

| 状态编号 | 状态常量值 | 状态描述 |
|:----:|:------:|:---------|
| 0 | SC_STONE | 石化 |
| 1 | 1 | SC_FREEZE | 冰冻 |
| 2 | SC_STUN | 晕眩 |
| 3 | SC_SLEEP | 睡眠 |
| 4 | SC_POISON | 中毒 |
| 5 | SC_CURSE | 诅咒 |
| 6 | SC_SILENCE | 沉默 |
| 7 | SC_CONFUSION | 混乱 |
| 8 | SC_BLIND | 黑暗 |
| 9 | SC_BLEEDING | 出血 |
| 10 | SC_DPOISON | 剧毒(猛毒) |
| 20 | SC_PROVOKE | 挑衅 |
| 21 | SC_ENDURE | 霸体 |
| 22 | SC_TWOHANDQUICKEN | 双手剑加速 |
| 23 | SC_CONCENTRATE | 心神凝聚 |
| 24 | SC_HIDING | 隐匿 |
| 25 | SC_CLOAKING | 伪装 |
| 26 | SC_ENCPOISON | 涂毒 |
| 27 | SC_POISONREACT | 毒性反弹 |
| 28 | SC_QUAGMIRE | 泥沼地 |
| 29 | SC_ANGELUS | 天使之障壁 |
| 30 | SC_BLESSING | 天使之赐福 |
| 31 | SC_SIGNUMCRUCIS | 治疗术 |
| 32 | SC_INCREASEAGI | 加速术 |
| 33 | SC_DECREASEAGI | 缓速术 |
| 34 | SC_SLOWPOISON | 缓毒术 |
| 35 | SC_IMPOSITIO  | 神威祈福 |
| 36 | SC_SUFFRAGIUM | 牺牲祈福 |
| 37 | SC_ASPERSIO | 撒水祈福、武器圣属性附加(温暖的风7级) |
| 38 | SC_BENEDICTIO | 圣之祈福 |
| 39 | SC_KYRIE | 霸邪之阵 |
| 40 | SC_MAGNIFICAT | 圣母之颂歌 |
| 41 | SC_GLORIA | 幸运之颂歌 |
| 42 | SC_AETERNA | 天使之怒 |
| 43 | SC_ADRENALINE | 速度激发 |
| 44 | SC_WEAPONPERFECTION | 无视体型 |
| 45 | SC_OVERTHRUST | 凶砍 |
| 46 | SC_MAXIMIZEPOWER | 武器值最大化 |
| 47 | SC_TRICKDEAD | 装死 |
| 48 | SC_LOUD | 大声呐喊 |
| 49 | SC_ENERGYCOAT | 能量外套 |
| 50 | SC_BROKENARMOR | 防具破碎 |
| 51 | SC_BROKENWEAPON | 武器破碎 |
| 52 | SC_HALLUCINATION | 幻觉 |
| 53 | SC_WEIGHT50 | 50%负重 |
| 54 | SC_WEIGHT90 | 90%负重 |
| 55 | SC_ASPDPOTION0 | 集中药水 |
| 56 | SC_ASPDPOTION1 | 觉醒药水 |
| 57 | SC_ASPDPOTION2 | 菠色克药水 |
| 58 | SC_ASPDPOTION3 | 攻击加速3(比菠色克更快，例如刺客吃毒药) |
| 59 | SC_SPEEDUP0 | 移动速度提升0(和加速术一样快) |
| 60 | SC_SPEEDUP1 | 移动速度提升1(比加速术更快) |
| 61 | SC_ATKPOTION | atk提升药水 |
| 62 | SC_MATKPOTION | matk提升药水 |
| 63 | SC_WEDDING | 结婚 |
| 64 | SC_SLOWDOWN | 走路变慢(结婚用这个) |
| 65 | SC_ANKLE | 定位陷阱 |
| 66 | SC_KEEPING | 防御提升(提升到DEF 90，但这个不是金刚不坏) |
| 67 | SC_BARRIER | 能源外套 |
| 68 | SC_STRIPWEAPON | 卸除武器 |
| 69 | SC_STRIPSHIELD | 卸除盾牌 |
| 70 | SC_STRIPARMOR | 卸除盔甲 |
| 71 | SC_STRIPHELM | 卸除头盔 |
| 72 | SC_CP_WEAPON | 化学武器保护 |
| 73 | SC_CP_SHIELD | 化学盾牌保护 |
| 74 | SC_CP_ARMOR | 化学盔甲保护 |
| 75 | SC_CP_HELM | 化学头盔保护 |
| 76 | SC_AUTOGUARD | 自动防御 |
| 77 | SC_REFLECTSHIELD | 反射盾 |
| 78 | SC_SPLASHER | 毒性感染 |
| 79 | SC_PROVIDENCE | 神佑之光 |
| 80 | SC_DEFENDER | 光之盾 |
| 81 | SC_MAGICROD | 魔法惩罚 |
| 82 | SC_SPELLBREAKER | 念咒拆除 |
| 83 | SC_AUTOSPELL | 自动念咒 |
| 84 | SC_SIGHTTRASHER | 火柱攻击 |
| 85 | SC_AUTOBERSERK | 狂暴 |
| 86 | SC_SPEARQUICKEN | 长矛加速术 |
| 87 | SC_AUTOCOUNTER | 反击 |
| 88 | SC_SIGHT | 火狩 |
| 89 | SC_SAFETYWALL | 暗之障壁 |
| 90 | SC_RUWACH | 光猎 |
| 91 | SC_EXTREMITYFIST | 阿修罗霸凰拳 |
| 92 | SC_EXPLOSIONSPIRITS | 爆气 |
| 93 | SC_COMBO | 连续技准备(六合拳) |
| 94 | SC_BLADESTOP_WAIT | 真剑百破道(等待触发) |
| 95 | SC_BLADESTOP | 真剑百破道(抓住变黑的) |
| 96 | SC_FIREWEAPON | 武器火属性附加(温暖的风4级) |
| 97 | SC_WATERWEAPON | 武器水属性附加(温暖的风3级) |
| 98 | SC_WINDWEAPON | 武器风属性附加(温暖的风2级) |
| 99 | SC_EARTHWEAPON | 武器地属性附加(温暖的风1级) |
| 100 | SC_VOLCANO | 火元素领域 |
| 101 | SC_DELUGE | 水元素领域 |
| 102 | SC_VIOLENTGALE | 风元素领域 |
| 103 | SC_WATK_ELEMENT | 武器攻击属性伤害(例如怒爆) |
| 104 | SC_ARMOR | 属性变化卷轴 |
| 105 | SC_ARMOR_ELEMENT | 盔甲属性 |
| 106 | SC_NOCHAT | 禁言 |
| 107 | SC_BABY | 养子 |
| 108 | SC_AURABLADE | 灵气剑 |
| 109 | SC_PARRYING | 双剑挌挡 |
| 110 | SC_CONCENTRATION | 心神凝聚 |
| 111 | SC_TENSIONRELAX | 极速回复 |
| 112 | SC_BERSERK | 狂怒之枪 |
| 113 | SC_FURY | 尚末使用 |
| 114 | SC_GOSPEL | 圣音 |
| 115 | SC_ASSUMPTIO | 圣母之祈福 |
| 116 | SC_BASILICA | 神圣殿堂 |
| 117 | SC_GUILDAURA | 工会技能范围效果 |
| 118 | SC_MAGICPOWER | 魔力增幅 |
| 119 | SC_EDP | 致命涂毒 |
| 120 | SC_TRUESIGHT | 狙杀瞄准 |
| 121 | SC_WINDWALK | 风之步 |
| 122 | SC_MELTDOWN | 野蛮凶砍 |
| 123 | SC_CARTBOOST | 手推车加速 |
| 124 | SC_CHASEWALK | 暗影追踪 |
| 125 | SC_REJECTSWORD | 霸王魂 |
| 126 | SC_MARIONETTE | 傀儡师的把戏(施展) |
| 127 | SC_MARIONETTE2 | 傀儡师的把戏(被施展) |
| 128 | SC_CHANGEUNDEAD | 变身不死族 |
| 129 | SC_JOINTBEAT | 巧打 |
| 130 | SC_MINDBREAKER | 精神撼动 |
| 131 | SC_MEMORIZE | 速读术 |
| 132 | SC_FOGWALL | 薄雾墙 |
| 133 | SC_SPIDERWEB | 易燃之网 |
| 134 | SC_DEVOTION | 牺牲 |
| 135 | SC_SACRIFICE | 舍命攻击 |
| 136 | SC_STEELBODY | 金刚不坏 |
| 137 | SC_ORCISH | 变成兽人面孔 |
| 138 | SC_READYSTORM | 回旋准备 |
| 139 | SC_READYDOWN | 砸踢准备 |
| 140 | SC_READYTURN | 踢准备 |
| 141 | SC_READYCOUNTER | 还击踢准备 |
| 142 | SC_DODGE | 落法 |
| 143 | SC_RUN | 跑步 |
| 144 | SC_SHADOWWEAPON | 武器暗属性附加(温暖的风6级) |
| 145 | SC_ADRENALINE2 | 所有速度激发 |
| 146 | SC_GHOSTWEAPON | 武器念属性附加(温暖的风5级) |
| 147 | SC_KAIZEL | 可立即复活(凯易哲) |
| 148 | SC_KAAHI | 受物理伤害消耗SP恢复HP(凯阿希) |
| 149 | SC_KAUPE | 物理攻击回避一次(凯诬仆) |
| 150 | SC_ONEHAND | 单手剑攻击速度增加 |
| 151 | SC_PRESERVE | 自由保护 |
| 152 | SC_BATTLEORDERS | 下达战斗命令(SID+5) |
| 153 | SC_REGENERATION | 复兴公会员体力 |
| 154 | SC_DOUBLECAST | 双倍投掷 |
| 155 | SC_GRAVITATION | 重力原野 |
| 156 | SC_MAXOVERTHRUST | 凶砍最大值 |
| 157 | SC_LONGING | 不要拘束我 |
| 158 | SC_HERMODE | 海罗默德的手杖 |
| 159 | SC_SHRINK | 防御反弹 |
| 160 | SC_SIGHTBLASTER | 火狩冲击 |
| 161 | SC_WINKCHARM | 被抛媚眼 |
| 162 | SC_CLOSECONFINE | 紧密的约束施展 |
| 163 | SC_CLOSECONFINE2 | 紧密的约束被施展 |
| 164 | SC_DANCING | 歌唱舞蹈 |
| 165 | SC_ELEMENTALCHANGE | 铠甲属性变化 |
| 166 | SC_RICHMANKIM | 经验值倍增 |
| 167 | SC_ETERNALCHAOS | 永远的混沌 |
| 168 | SC_DRUMBATTLE | 战鼓震天 |
| 169 | SC_NIBELUNGEN | 尼贝隆根之戒指 |
| 170 | SC_ROKISWEIL | 洛奇的悲鸣 |
| 171 | SC_INTOABYSS | 触媒之所 |
| 172 | SC_SIEGFRIED | 不死神齐格弗里德 |
| 173 | SC_WHISTLE | 吹口哨 |
| 174 | SC_ASSNCROS | 刺客的黄昏 |
| 175 | SC_POEMBRAGI | 布莱奇之诗 |
| 176 | SC_APPLEIDUN | 伊登的苹果 |
| 177 | SC_MODECHANGE | 魔物行为模式改变 |
| 178 | SC_HUMMING | 哼唱之音 |
| 179 | SC_DONTFORGETME | 勿忘我 |
| 180 | SC_FORTUNE | 女神之吻 |
| 181 | SC_SERVICE4U | 为你服务 |
| 182 | SC_STOP | 停止 |
| 183 | SC_SPURT | 跑步飞奔中的 |
| 184 | SC_SPIRIT | 赋予灵魂 |
| 185 | SC_COMA | 频死 |
| 186 | SC_INTRAVISION | 看见隐身的(例如阳光的箱子) |
| 187 | SC_INCALLSTATUS | 给所有素质加成 |
| 188 | SC_INCSTR | STR提升 |
| 189 | SC_INCAGI | AGI提升 |
| 190 | SC_INCVIT | VIT提升 |
| 191 | SC_INCINT | INT提升 |
| 192 | SC_INCDEX | DEX提升 |
| 193 | SC_INCLUK | LUK提升 |
| 194 | SC_INCHIT | 命中提升 |
| 195 | SC_INCHITRATE | 命中率提升 |
| 196 | SC_INCFLEE | 回避提升 |
| 197 | SC_INCFLEERATE | 回避率提升 |
| 198 | SC_INCMHPRATE | 最大HP倍率提升 |
| 199 | SC_INCMSPRATE | 最大SP倍率提升 |
| 200 | SC_INCATKRATE | 物理攻击力倍率提升 |
| 201 | SC_INCMATKRATE | 魔法攻击力倍率提升 |
| 202 | SC_INCDEFRATE | 防御力倍率提升 |
| 203 | SC_STRFOOD | 力量料理 |
| 204 | SC_AGIFOOD | 敏捷料理 |
| 205 | SC_VITFOOD | 体力料理 |
| 206 | SC_INTFOOD | 智力料理 |
| 207 | SC_DEXFOOD | 灵巧料理 |
| 208 | SC_LUKFOOD | 幸运料理 |
| 209 | SC_HITFOOD |  命中率提升料理 |
| 210 | SC_FLEEFOOD | 回避率提升料理 |
| 211 | SC_BATKFOOD | 基础ATK提升料理 |
| 212 | SC_WATKFOOD | 武器ATK提升料理 |
| 213 | SC_MATKFOOD | 魔法攻击力提升料理 |
| 214 | SC_SCRESIST | 异常底抗力倍率 |
| 215 | SC_XMAS | 圣诞装造型 |
| 216 | SC_WARM | 加热器 |
| 217 | SC_SUN_COMFORT | 太阳的平安感 |
| 218 | SC_MOON_COMFORT | 月亮的平安感 |
| 219 | SC_STAR_COMFORT | 星星的平安感 |
| 220 | SC_FUSION | 太阳和月亮和星星的融合 |
| 221 | SC_SKILLRATE_UP |  技能发动率提升 |
| 222 | SC_SKE | 魔物攻击力X4防御力%2(艾斯克) |
| 223 | SC_KAITE | 魔法反射(凯易特) |
| 224 | SC_SWOO | 魔物变小移动降低(艾斯诬) |
| 225 | SC_SKA | 艾斯卡 |
| 226 | SC_EARTH | 快乐的休息 |  |
| 227 | SC_MIRACLE | 太阳与月亮与星星的奇迹 |
| 228 | SC_MADNESSCANCEL | 疯狂取消 |
| 229 | SC_ADJUSTMENT | 终极闪躲 |
| 230 | SC_INCREASING | 命中率递增 |
| 231 | SC_GATLINGFEVER | 格林狂热 |
| 232 | SC_TATAMIGAESHI | 榻榻米攻击 |
| 233 | SC_UTSUSEMI | 金蝉脱壳 |
| 234 | SC_BUNSINJYUTSU | 幻影分身 |
| 235 | SC_KAENSIN | 尚未使用 |
| 236 | SC_SUITON | 水遁 |
| 237 | SC_NEN | 忍者[念] |
| 238 | SC_KNOWLEDGE | 太阳和月亮和星星的知识(效果是提升最大负重) |
| 239 | SC_SMA | 可咏唱艾斯麻 |
| 240 | SC_FLING | 投掷硬币 |
| 241 | SC_AVOID | 轻捷移动 |
| 242 | SC_CHANGE | 智力变换 |
| 243 | SC_BLOODLUST | 血的贪求 |
| 244 | SC_FLEET | 横越速度 |
| 245 | SC_SPEED | 紧急回避 |
| 246 | SC_DEFENCE | 圣音 |
| 247 | SC_INCASPDRATE | 增加攻速倍率 |
| 248 | SC_INCFLEE2 | 提升完全回避率 |
| 249 | SC_JAILED | 监禁 |
| 250 | SC_ENCHANTARMS | 武器属性附加 |
| 251 | SC_MAGICALATTACK | 魔耗攻击 |
| 252 | SC_ARMORCHANGE | 巨石外壳 |
| 253 | SC_CRITICALWOUND | 致命伤口 |
| 254 | SC_MAGICMIRROR | 魔术之镜 |
| 255 | SC_SLOWCAST | 咏唱减缓 |
| 256 | SC_SUMMER | 夏天泳装 |
| 257 | SC_EXPBOOST | 基础经验倍增 |
| 258 | SC_ITEMBOOST | 掉宝率倍增 |
| 259 | SC_BOSSMAPINFO | BOSS雷达 |
| 260 | SC_LIFEINSURANCE | 免掉啪 |
| 261 | SC_INCCRI | 必杀攻击率提升 |
| 262 | SC_INCDEF | 防御提升 |
| 263 | SC_INCBASEATK | 基础攻击力增加 |
| 264 | SC_FASTCAST | 尚末使用 |
| 265 | SC_MDEF_RATE | 对魔法防御倍率提升 |
| 266 | SC_HPREGEN | 尚末使用 |
| 267 | SC_INCHEALRATE | 对恢复补品的性能提升 |
| 268 | SC_PNEUMA | 光壁 |
| 269 | SC_AUTOTRADE | 离线挂店 |
| 270 | SC_KSPROTECTED | 魔物的防抢保护 |
| 271 | SC_ARMOR_RESIST | 水、地、火、风元素抵抗率提升 |
| 272 | SC_SPCOST_RATE | 减少sp消秏率 |
| 273 | SC_COMMONSC_RESIST | 提升异常防御抵抗率 |
| 274 | SC_SEVENWIND | 温暖的风(不会改变属性) |
| 275 | SC_DEF_RATE | 对物理攻击的耐性提升 |
| 276 | SC_SPREGEN | 尚未使用(可能是sp恢复提升) |
| 277 | SC_WALKSPEED | 移速提升 |
| 278 | SC_MERC_FLEEUP | 佣兵回避提升 |
| 279 | SC_MERC_ATKUP | 佣兵攻击力提升 |
| 280 | SC_MERC_HPUP | 佣兵HP增加 |
| 281 | SC_MERC_SPUP | 佣兵SP增加 |
| 282 | SC_MERC_HITUP | 佣兵命中率提升 |
| 283 | SC_MERC_QUICKEN | 佣兵加速武器 |
| 284 | SC_REBIRTH | 魔物的重生 |
| 285 | SC_SKILLCASTRATE | 尚未使用(变动施法时间减少) |
| 286 | SC_DEFRATIOATK | 尚未使用(浸透劲效果) |
| 287 | SC_HPDRAIN | 每n秒减少xHP(以前跳跳糖用的) |
| 288 | SC_SKILLATKBONUS | 猫叫 |
| 289 | SC_ITEMSCRIPT | 道具脚本SC |
| 290 | SC_S_LIFEPOTION | 小型生命水 |
| 291 | SC_L_LIFEPOTION | 中型生命水 |
| 292 | SC_JEXPBOOST | JOB职业经验值倍增 |
| 293 | SC_IGNOREDEF | 无视防御力 |
| 294 | SC_HELLPOWER | 地狱之权威 |
| 295 | SC_INVINCIBLE | 无敌开启 |
| 296 | SC_INVINCIBLEOFF | 取消无敌 |
| 297 | SC_MANU_ATK | 魔怒克的良机 |
| 298 | SC_MANU_DEF | 魔怒克的意志 |
| 299 | SC_SPL_ATK | 捕虫堇妖果酱 |
| 300 | SC_SPL_DEF | 鲁修拉的蜜酱 |
| 301 | SC_MANU_MATK | 魔怒克的信念 |
| 302 | SC_SPL_MATK | 独角飞马之泪 |
| 303 | SC_FOOD_STR_CASH | STR提升料理 |
| 304 | SC_FOOD_AGI_CASH | AGI提升料理 |
| 305 | SC_FOOD_VIT_CASH | VIT提升料理 |
| 306 | SC_FOOD_DEX_CASH | DEX提升料理 |
| 307 | SC_FOOD_INT_CASH | INI提升料理 |
| 308 | SC_FOOD_LUK_CASH | LUK提升料理 |
| 309 | SC_FEAR | 微风恐惧 |
| 310 | SC_BURNING |  燃烧 |
| 311 | SC_FREEZING | 冻僵 |
| 312 | SC_ENCHANTBLADE | 魔力剑 |
| 313 | SC_DEATHBOUND | 死亡反弹 |
| 314 | SC_MILLENNIUMSHIELD | 千年神盾 |
| 315 | SC_CRUSHSTRIKE | 重击强袭 |
| 316 | SC_REFRESH | 恢复 |
| 317 | SC_REUSE_REFRESH | 恢复冷却 |
| 318 | SC_GIANTGROWTH | 力量成长 |
| 319 | SC_STONEHARDSKIN | 岩石皮肤 |
| 320 | SC_VITALITYACTIVATION | 生命激化 |
| 321 | SC_STORMBLAST | 风暴冲击 |
| 322 | SC_FIGHTINGSPIRIT | 提升斗志 |
| 323 | SC_ABUNDANCE | 丰足 |
| 324 | SC_ADORAMUS | 讴歌 |
| 325 | SC_EPICLESIS | 圣灵降临祈祷 |
| 326 | SC_ORATIO | 祈祷文 |
| 327 | SC_LAUDAAGNUS | 羔羊歌颂 |
| 328 | SC_LAUDARAMUS | 折枝赞颂 |
| 329 | SC_RENOVATIO | 净化 |
| 330 | SC_EXPIATIO | 赎罪 |
| 331 | SC_DUPLELIGHT | 二道圣光 |
| 332 | SC_SECRAMENT | 圣典 |
| 333 | SC_WHITEIMPRISON | 白色监狱 |
| 334 | SC_MARSHOFABYSS | 深渊沼地 |
| 335 | SC_RECOGNIZEDSPELL | 魔法省悟 |
| 336 | SC_STASIS | 魔力冻结 |
| 337 | SC_SPHERE_1 | 属性漩涡元素球1 |
| 338 | SC_SPHERE_2 | 属性漩涡元素球2 |
| 339 | SC_SPHERE_3 | 属性漩涡元素球3 |
| 340 | SC_SPHERE_4 | 属性漩涡元素球4 |
| 341 | SC_SPHERE_5 | 属性漩涡元素球5 |
| 342 | SC_READING_SB | 尚未使用 |
| 343 | SC_FREEZE_SP | 魔法保存 |
| 344 | SC_FEARBREEZE | 微风恐惧 |
| 345 | SC_ELECTRICSHOCKER | 电击陷阱 |
| 346 | SC_WUGDASH | 疾狼术 |
| 347 | SC_BITE | 发动狼咬 |
| 348 | SC_CAMOUFLAGE | 伪装战术 |
| 349 | SC_ACCELERATION | 魔导机甲加速 |
| 350 | SC_HOVERING | 悬停 |
| 351 | SC_SHAPESHIFT | 形态转换 |
| 352 | SC_INFRARED | 红外线扫瞄 |  |
| 353 | SC_ANALYZE | 解析 |
| 354 | SC_MAGNETICFIELD | 磁场 |
| 355 | SC_NEUTRALBARRIER | 中性防护罩 |
| 356 | SC_NEUTRALBARRIER_MASTER | 中性防护罩(施展) |
| 357 | SC_STEALTHFIELD | 隐形力场 |
| 358 | SC_STEALTHFIELD_MASTER | 隐形力场(施展) |
| 359 | SC_OVERHEAT | 极限过热 |
| 360 | SC_OVERHEAT_LIMITPOINT | 极限过热 |
| 361 | SC_VENOMIMPRESS | 毒耐性弱化 |
| 362 | SC_POISONINGWEAPON | 剧毒武器 |
| 363 | SC_WEAPONBLOCKING | 武器抵御 |
| 364 | SC_CLOAKINGEXCEED | 伪装强化 |
| 365 | SC_HALLUCINATIONWALK | 幻影步 |
| 366 | SC_HALLUCINATIONWALK_POSTDELAY | 幻影步延迟 |
| 367 | SC_ROLLINGCUTTER | 回旋刀刃 |
| 368 | SC_TOXIN | 麻醉之毒 |
| 369 | SC_PARALYSE | 麻痹之毒 |
| 370 | SC_VENOMBLEED | 衰弱之毒 |
| 371 | SC_MAGICMUSHROOM | 狂笑之毒 |
| 372 | SC_DEATHHURT | 污染之毒 |
| 373 | SC_PYREXIA | 热病之毒 |
| 374 | SC_OBLIVIONCURSE | 失忆之毒 |
| 375 | SC_LEECHESEND | 吸血之毒 |
| 376 | SC_REFLECTDAMAGE | 反射伤害 |
| 377 | SC_FORCEOFVANGUARD | 先锋部队 |
| 378 | SC_SHIELDSPELL_DEF | 盾咒-防御力 |
| 379 | SC_SHIELDSPELL_MDEF | 盾咒-魔法防御力 |
| 380 | SC_SHIELDSPELL_REF | 盾咒-精炼效果 |
| 381 | SC_EXEEDBREAK | 强化冲击 |
| 382 | SC_PRESTIGE | 威信 |
| 383 | SC_BANDING | 聚集 |
| 384 | SC_BANDING_DEFENCE | 聚集(皇家禁卫队) |
| 385 | SC_EARTHDRIVE | 大地毁灭 |
| 386 | SC_INSPIRATION | 灵感 |
| 387 | SC_SPELLFIST | 魔力拳 |
| 388 | SC_CRYSTALIZE | 钻石星尘 |
| 389 | SC_STRIKING | 打击强化 |
| 390 | SC_WARMER | 加热器 |
| 391 | SC_VACUUM_EXTREME | 极限空虚 |
| 392 | SC_PROPERTYWALK | 火焰电流步计算步数 |
| 393 | SC_SWINGDANCE | 摇摆舞声唱 |
| 394 | SC_SYMPHONYOFLOVER | 爱人的交响曲声唱 |
| 395 | SC_MOONLITSERENADE | 月光小夜曲声唱 |
| 396 | SC_RUSHWINDMILL | 风车突击 |
| 397 | SC_ECHOSONG | 回音之歌 |
| 398 | SC_HARMONIZE | 和声演奏 |
| 399 | SC_VOICEOFSIREN | 塞壬之音 |
| 400 | SC_DEEPSLEEP | 沉睡摇篮曲 |
| 401 | SC_SIRCLEOFNATURE | 循环的大自然之音 |
| 402 | SC_GLOOMYDAY | 羞怯一天的忧郁 |
| 403 | SC_GLOOMYDAY_SK | 会被羞怯一天的忧郁影响的技能判别 |
| 404 | SC_SONGOFMANA | 魔力之歌声唱 |
| 405 | SC_DANCEWITHWUG | 与狼共舞声唱 |
| 406 | SC_SATURDAYNIGHTFEVER | 狂欢周末夜声唱 |
| 407 | SC_LERADSDEW | 雷拉多露水声唱 |
| 408 | SC_MELODYOFSINK | 消沈旋律 |
| 409 | SC_BEYONDOFWARCRY | 战嚎的彼端声唱 |
| 410 | SC_UNLIMITEDHUMMINGVOICE | 无限哼唱声旋律 |
| 411 | SC_SITDOWN_FORCE | 强制坐下 |
| 412 | SC_NETHERWORLD | 绝望之歌 |
| 413 | SC_CRE | 破碎柱 |
| 414 | SC_CURSEDCIRCLE_ATKER | 咒缚阵_攻击 |
| 415 | SC_CURSEDCIRCLE_TARGET | 咒缚阵_目标 |
| 416 | SC_LIGHTNINGWALK | 闪电步 |
| 417 | SC_RAISINGDRAGON | 潜龙升天 |
| 418 | SC_GT_ENERGYGAIN | 点穴-救 |
| 419 | SC_GT_CHANGE | 点穴-反 |
| 420 | SC_GT_REVITALIZE | 点穴-活 |
| 421 | SC_GN_CARTBOOST | 手推车加速 |
| 422 | SC_THORNSTRAP | 荆棘陷阱 |
| 423 | SC_BLOODSUCKER | 吸血植物 |
| 424 | SC_SMOKEPOWDER | 火焰扩散(烟幕弹) |
| 425 | SC_TEARGAS | 火焰扩散(催泪瓦斯) |
| 426 | SC_MANDRAGORA | 曼陀罗魔花的尖叫 |
| 427 | SC_STOMACHACHE | 腹痛 |
| 428 | SC_MYSTERIOUS_POWDER | 神秘能量 |
| 429 | SC_MELON_BOMB | 哈密瓜炸弹 |
| 430 | SC_BANANA_BOMB | 香蕉炸弹 |
| 431 | SC_BANANA_BOMB_SITDOWN | 香蕉炸弹坐下效果 |
| 432 | SC_SAVAGE_STEAK | 烤小野猪排 |
| 433 | SC_COCKTAIL_WARG_BLOOD | 鸡尾酒狼血 |
| 434 | SC_MINOR_BBQ | 米洛斯烧烤 |
| 435 | SC_SIROMA_ICE_TEA | 小雪兽冰茶 |
| 436 | SC_DROCERA_HERB_STEAMED | 捕虫草药草煎 |
| 437 | SC_PUTTI_TAILS_NOODLES | 毕帝特龙尾面 |
| 438 | SC_BOOST500 | 攻速倍增%数药 |
| 439 | SC_FULL_SWING_K | 基础攻击力增加 |
| 440 | SC_MANA_PLUS | 魔力增加(提高魔法攻击力) |
| 441 | SC_MUSTLE_M | 最大hp倍率增加 |
| 442 | SC_LIFE_FORCE_F | 最大sp倍率提升 |
| 443 | SC_EXTRACT_WHITE_POTION_Z | HP和HP 自然恢复速度增加 |
| 444 | SC_VITATA_500 | 投掷药水SP提升5%、SP自然恢复速度增加20% |
| 445 | SC_EXTRACT_SALAMINE_JUICE | 攻速增加浓缩汁 |
| 446 | SC_REPRODUCE | 繁殖 |
| 447 | SC_AUTOSHADOWSPELL | 自动魅影念咒 |
| 448 | SC_SHADOWFORM | 魅影形态 |
| 449 | SC_BODYPAINT | 人体彩绘 |
| 450 | SC_INVISIBILITY | 透明术 |
| 451 | SC_DEADLYINFECT | 致命感染 |
| 452 | SC_ENERVATION | 面具-无力 |
| 453 | SC_GROOMY | 面具-忧郁 |
| 454 | SC_IGNORANCE | 面具-无知 |
| 455 | SC_LAZINESS | 面具-懒散 |
| 456 | SC_UNLUCKY | 面具-不幸 |
| 457 | SC_WEAKNESS | 面具-衰弱 |
| 458 | SC_STRIPACCESSORY | 卸除配件 |
| 459 | SC_MANHOLE | 人孔 |
| 460 | SC_BLOODYLUST | 血腥欲望 |
| 461 | SC_CIRCLE_OF_FIRE | 烈焰之环 |
| 462 | SC_CIRCLE_OF_FIRE_OPTION | 烈焰之环状攻击伤害态 |
| 463 | SC_FIRE_CLOAK | 急速降温 |
| 464 | SC_FIRE_CLOAK_OPTION | 急速降温 |
| 465 | SC_WATER_SCREEN | 水之守护 |  |
| 466 | SC_WATER_SCREEN_OPTION | 水之守护 |  |
| 467 | SC_WATER_DROP | 大豪雨 |
| 468 | SC_WATER_DROP_OPTION | 大豪雨 |
| 469 | SC_WATER_BARRIER | 水之屏障 |
| 470 | SC_WIND_STEP | 风之闪现 |
| 471 | SC_WIND_STEP_OPTION | 风之闪现 |
| 472 | SC_WIND_CURTAIN | 风之魂 |
| 473 | SC_WIND_CURTAIN_OPTION | 风之魂 |
| 474 | SC_ZEPHYR | 风之结界 |
| 475 | SC_SOLID_SKIN | 皮肤固化 |
| 476 | SC_SOLID_SKIN_OPTION | 皮肤固化 |
| 477 | SC_STONE_SHIELD | 岩石盾 |
| 478 | SC_STONE_SHIELD_OPTION | 岩石盾 |
| 479 | SC_POWER_OF_GAIA | 天神下凡 |
| 480 | SC_PYROTECHNIC | 烈焰强化 |
| 481 | SC_PYROTECHNIC_OPTION | 烈焰强化 |
| 482 | SC_HEATER | 急速升温 |
| 483 | SC_HEATER_OPTION | 急速升温 |
| 484 | SC_TROPIC | 灼热地带 |
| 485 | SC_TROPIC_OPTION | 灼热地带 |
| 486 | SC_AQUAPLAY | 冰封领域 |
| 487 | SC_AQUAPLAY_OPTION | 冰封领域 |
| 488 | SC_COOLER | 急速降温 |
| 489 | SC_COOLER_OPTION | 急速降温 |
| 490 | SC_CHILLY_AIR | 绝对零度 |
| 491 | SC_CHILLY_AIR_OPTION | 绝对零度 |
| 492 | SC_GUST | 雷电强化 |
| 493 | SC_GUST_OPTION | 雷电强化 |
| 494 | SC_BLAST | 风暴冲击 |
| 495 | SC_BLAST_OPTION | 风暴冲击 |
| 496 | SC_WILD_STORM | 荒野风暴 |
| 497 | SC_WILD_STORM_OPTION | 荒野风暴 |
| 498 | SC_PETROLOGY | 岩石领域 |
| 499 | SC_PETROLOGY_OPTION | 岩石领域 |
| 500 | SC_CURSED_SOIL | 诅咒之地 |
| 501 | SC_CURSED_SOIL_OPTION | 诅咒之地 |
| 502 | SC_UPHEAVAL | 天崩地裂 |
| 503 | SC_UPHEAVAL_OPTION | 天崩地裂 |
| 504 | SC_TIDAL_WEAPON | 海啸武器 |
| 505 | SC_TIDAL_WEAPON_OPTION | 海啸武器 |
| 506 | SC_ROCK_CRUSHER | 碎石 |
| 507 | SC_ROCK_CRUSHER_ATK | 碎石~ |
| 508 | SC_LEADERSHIP | 伟大的指导力 |
| 509 | SC_GLORYWOUNDS | 光荣的伤口 |
| 510 | SC_SOULCOLD | 冷漠之心 |
| 511 | SC_HAWKEYES | 尖锐的视线 |
| 512 | SC_ODINS_POWER | 奥丁能量 |
| 513 | SC_RAID | 潜击 |
| 514 | SC_FIRE_INSIGNIA | 火之纹章 |
| 515 | SC_WATER_INSIGNIA | 水之纹章 |
| 516 | SC_WIND_INSIGNIA | 地之纹章 |
| 517 | SC_EARTH_INSIGNIA | 风之纹章 |
| 518 | SC_PUSH_CART | 手推车状备 |
| 519 | SC_SPELLBOOK1 | 第一魔法书 |
| 520 | SC_SPELLBOOK2 | 第二魔法书 |
| 521 | SC_SPELLBOOK3 | 第三魔法书 |
| 522 | SC_SPELLBOOK4 | 第四魔法书 |
| 523 | SC_SPELLBOOK5 | 第五魔法书 |
| 524 | SC_SPELLBOOK6 | 第六魔法书 |
| 525 | SC_MAXSPELLBOOK | 技能咏唱魔法书最大数量 |
| 526 | SC_INCMHP | HP增加药水 |
| 527 | SC_INCMSP | SP增加药水 |
| 528 | SC_PARTYFLEE | 回避率增加 |
| 529 | SC_MEIKYOUSISUI | 明镜止水 |
| 530 | SC_JYUMONJIKIRI | 幽冥十字斩 |
| 531 | SC_KYOUGAKU | 幻术–惊恐 |
| 532 | SC_IZAYOI | 第十六个夜晚 |
| 533 | SC_ZENKAI | 法术–施展 |
| 534 | SC_KAGEHUMI | 踏影 |
| 535 | SC_KYOMU | 虚无飘妙之影 |
| 536 | SC_KAGEMUSYA | 影子武士 |
| 537 | SC_ZANGETSU | 变形的上弦月 |
| 538 | SC_GENSOU | 阴月的幻影 |
| 539 | SC_AKAITSUKI | 不祥的红月 |
| 540 | SC_STYLE_CHANGE | 人工生命体s转换型态 |
| 541 | SC_TINDER_BREAKER | 人工生命体s粉碎骨折 |
| 542 | SC_TINDER_BREAKER2 |  | 人工生命体s粉碎骨折延时时间计算 |
| 543 | SC_CBC | 生命体s连续突破组合 |
| 544 | SC_EQC | 生命体s永恒快速组合 |
| 545 | SC_GOLDENE_FERSE | 生命体s黄金脚跟 |
| 546 | SC_ANGRIFFS_MODUS | 生命体s攻击准备 |
| 547 | SC_OVERED_BOOST | 生命体s瞬间增压 |
| 548 | SC_LIGHT_OF_REGENE | 生命体s重生之光 |
| 549 | SC_ASH | 生命体s火山灰 |
| 550 | SC_GRANITIC_ARMOR | 生命体s花岗岩铠甲 |
| 551 | SC_MAGMA_FLOW | 生命体s岩浆流动 |
| 552 | SC_PYROCLASTIC | 生命体s火山尘暴 |
| 553 | SC_PARALYSIS | 生命体s麻痹针 |
| 554 | SC_PAIN_KILLER | 生命体s镇痛剂 |
| 555 | SC_HANBOK | 韩服外观 |
| 556 | SC_DEFSET | 指定防御力 |
| 557 | SC_MDEFSET | 指定魔法防御力 |
| 558 | SC_DARKCROW | 致命爪痕 |
| 559 | SC_FULL_THROTTLE | 烈火战车 |
| 560 | SC_REBOUND | hp和sp不自然恢复 |
| 561 | SC_UNLIMIT | 无限哼唱声 |
| 562 | SC_KINGS_GRACE | 王的恩典 |
| 563 | SC_TELEKINESIS_INTENSE | 终极念力 |
| 564 | SC_OFFERTORIUM | 奉献颂 |
| 565 | SC_FRIGG_SONG | 丰年颂唱声 |
| 566 | SC_MONSTER_TRANSFORM | 变身怪物 |
| 567 | SC_ANGEL_PROTECT | 感谢您!技能 |
| 568 | SC_ILLUSIONDOPING | 幻觉禁药 |
| 569 | SC_FLASHCOMBO | 闪光连击 |
| 570 | SC_MOONSTAR | 时装月亮与星星的外观 |
| 571 | SC_SUPER_STAR | 时装超级明星的外观 |
| 572 | SC_HEAT_BARREL | 加速子弹 |
| 573 | SC_HEAT_BARREL_AFTER | 加速子弹下不能使用消秏品的 |
| 574 | SC_P_ALTER | 白金祭坛 |
| 575 | SC_E_CHAIN | 无限连锁 |
| 576 | SC_C_MARKER | 血色烙印 |
| 577 | SC_ANTI_M_BLAST | 毁灭之击 |
| 578 | SC_B_TRAP | 黑暗地狱 |
| 579 | SC_H_MINE | 破坏怒吼 |
| 580 | SC_QD_SHOT_READY | 瞬速子弹完成准备 |
| 581 | SC_MTF_ASPD | 变身魔物攻速提升 |
| 582 | SC_MTF_RANGEATK | 变身魔物远距离攻击力提升百分比 |
| 583 | SC_MTF_MATK | 变身魔物魔法攻击力提升百分比 |
| 584 | SC_MTF_MLEATKED | 变身魔物无属性耐性提升倍率 |
| 585 | SC_MTF_CRIDAMAGE | 变身魔物爆击伤害提升倍率 |
| 586 | SC_OKTOBERFEST | 啤酒服务生时装外观 |
| 587 | SC_STRANGELIGHTS | 时装鬼火的装饰的外观 |
| 588 | SC_DECORATION_OF_MUSIC | 时装音乐的装饰的外观 |
| 589 | SC_QUEST_BUFF1 | 任务辅助效果1 |
| 590 | SC_QUEST_BUFF2 | 任务辅助效果2 |
| 591 | SC_QUEST_BUFF3 | 任务辅助效果3 |
| 592 | SC_ALL_RIDING | 坐骑搭乘中 |
| 593 | SC_TEARGAS_SOB | 命中火焰扩散(催泪瓦斯)的表情 |
| 594 | SC_FEINTBOMB | 虚击炸弹 |
| 595 | SC__CHAOS | 尚末使用 |
| 596 | SC_CHASEWALK2 | STR增加 |
| 597 | SC_VACUUM_EXTREME_POSTDELAY |  |
| 598 | SC_MTF_ASPD2 | 变身魔物攻速提升 |
| 599 | SC_MTF_RANGEATK2 | 变身魔物远距离攻击力提升倍率 |
| 600 | SC_MTF_MATK2 | 变身魔物魔法攻击力提升 |
| 601 | SC_2011RWC_ | 红色助推器 |
| 602 | SC_JP_EVENT04 | 鱼贝类怪物所获经验值增加 |
| 603 | SC_MTF_MHP | 变身魔物最大hp增加 |
| 604 | SC_MTF_MSP | 恋身魔物最大sp增加 |
| 605 | SC_MTF_PUMPKIN | 变身魔物使用hp恢复道具恢复量提升 |
| 606 | SC_MTF_HITFLEE | 恋身魔物命中率和回避率提升 |
| 607 | SC_CRIFOOD | 爆击率提升 |
| 608 | SC_ATTHASTE_CASH | ASPD强化药水 |
| 609 | SC_REUSE_LIMIT_A | A类物品冷却 |
| 610 | SC_REUSE_LIMIT_B | B类物品冷却 |
| 611 | SC_REUSE_LIMIT_C | C类物品冷却 |
| 612 | SC_REUSE_LIMIT_D | D类物品冷却 |
| 613 | SC_REUSE_LIMIT_E | E类物品冷却 |
| 614 | SC_REUSE_LIMIT_F | F类物品冷却 |
| 615 | SC_REUSE_LIMIT_G | G类物品冷却 |
| 616 | SC_REUSE_LIMIT_H | H类物品冷却 |
| 617 | SC_REUSE_LIMIT_MTF | 变身卷轴物品冷却 |
| 618 | SC_REUSE_LIMIT_ASPD_POTION | 攻速药水冷却 |
| 619 | SC_REUSE_MILLENNIUMSHIELD | 千年神盾冷却 |
| 620 | SC_REUSE_CRUSHSTRIKE | 重击强袭冷却 |
| 621 | SC_REUSE_STORMBLAST | 风暴冲击冷却 |
| 622 | SC_ALL_RIDING_REUSE_LIMIT | 坐骑物品冷却 |
| 623 | SC_REUSE_LIMIT_ECL | 一般物品冷却 |
| 624 | SC_REUSE_LIMIT_RECALL | 招换卷轴冷却 |
| 625 | SC_PROMOTE_HEALTH_RESERCH | HP增加药水(大) |
| 626 | SC_ENERGY_DRINK_RESERCH | MSP上升 |
| 627 | SC_NORECOVER_STATE | 吃补无法恢复 |
| 628 | SC_SUHIDE | 禁止行动( 不能走动使用技能使用物品) |
| 629 | SC_SU_STOOP | 猫背技能 |
| 630 | SC_SPRITEMABLE | 灵魂之珠技能 |
| 631 | SC_CATNIPPOWDER | 木天蓼撒粉技能 |
| 632 | SC_SV_ROOTTWIST | 狝猴桃根须缠绕技能 |
| 633 | SC_BITESCAR | 狼咬伤 |
| 634 | SC_ARCLOUSEDASH | 卷甲虫冲刺技能 |
| 635 | SC_TUNAPARTY | 金枪鱼派对技能 |
| 636 | SC_SHRIMP | 虾群技能(基本攻击力魔法攻击力提升百分比) |
| 637 | SC_FRESHSHRIMP | 鲜虾技能 |
| 638 | SC_ACTIVE_MONSTER_TRANSFORM | 变身怪物 |
| 639 | SC_CLOUD_KILL | 云杀 |
| 640 | SC_LJOSALFAR | 时装光精灵发夹的外观 |
| 641 | SC_MERMAID_LONGING | 时装人鱼姬的思念的外观 |
| 642 | SC_HAT_EFFECT | 时装天使的阶梯的外观 |
| 643 | SC_FLOWERSMOKE | 时装未知名称的外观 |
| 644 | SC_FSTONE | 时装飘浮的贤者之石的外观 |
| 645 | SC_HAPPINESS_STAR | 时装未知名称的外观 |
| 646 | SC_MAPLE_FALLS | 时装秋风落叶眼罩的外观 |
| 647 | SC_TIME_ACCESSORY | 时装时间装饰品的外观 |
| 648 | SC_MAGICAL_FEATHER | 时装未知名称的外观 |
| 649 | SC_EXTREMITYFIST2 | 阿修罗霸凰拳不能吃补品 |

------