#! perl
use Text::Wrap;

# generate output data for noise generators

srand(31456);

print <<END
//========= Copyright  1996-2006, Valve Corporation, All rights reserved. ============//
//
// Purpose: static data for noise() primitives.
//
// \$Workfile:     \$
// \$NoKeywords: \$
//=============================================================================//
//
//    **** DO NOT EDIT THIS FILE. GENERATED BY DATAGEN.PL ****
//

END
;

@perm_a=0..255;

&fisher_yates_shuffle(\@perm_a);

$Text::Wrap::Columns=78;
$Text::Wrap::break=",";
$Text::Wrap::separator=",\n";

print "static int perm_a[]={\n",wrap('    ','   ',join(",",@perm_a)),"\n};\n\n";
&fisher_yates_shuffle(\@perm_a);
print "static int perm_b[]={\n",wrap('    ','    ',join(",",@perm_a)),"\n};\n\n";
&fisher_yates_shuffle(\@perm_a);
print "static int perm_c[]={\n",wrap('    ','    ',join(",",@perm_a)),"\n};\n\n";
&fisher_yates_shuffle(\@perm_a);
print "static int perm_d[]={\n",wrap('    ','    ',join(",",@perm_a)),"\n};\n\n";

for ($i=0;$i<256;$i++)
  {
	$float_perm=(1.0/255.0)*$perm_a[$i];
	$perm_a[$i] = sprintf("%f",$float_perm);
  }
&fisher_yates_shuffle(\@perm_a);
print "static float impulse_xcoords[]={\n",wrap('    ','    ',join(",",@perm_a)),"\n};\n\n";
&fisher_yates_shuffle(\@perm_a);
print "static float impulse_ycoords[]={\n",wrap('    ','    ',join(",",@perm_a)),"\n};\n\n";
&fisher_yates_shuffle(\@perm_a);
print "static float impulse_zcoords[]={\n",wrap('    ','    ',join(",",@perm_a)),"\n};\n\n";



# fisher_yates_shuffle( \@array ) : generate a random permutation
# of @array in place
sub fisher_yates_shuffle {
    my $array = shift;
    my $i;
    for ($i = @$array; --$i; ) {
        my $j = int rand ($i+1);
        next if $i == $j;
        @$array[$i,$j] = @$array[$j,$i];
    }
}
