/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.enterprise.impl;

import java.util.function.Supplier;
import org.gradle.internal.buildtree.BuildModelParameters;
import org.gradle.internal.enterprise.GradleEnterprisePluginCheckInResult;
import org.gradle.internal.enterprise.GradleEnterprisePluginCheckInService;
import org.gradle.internal.enterprise.GradleEnterprisePluginMetadata;
import org.gradle.internal.enterprise.GradleEnterprisePluginServiceFactory;
import org.gradle.internal.enterprise.GradleEnterprisePluginServiceRef;
import org.gradle.internal.enterprise.core.GradleEnterprisePluginAdapter;
import org.gradle.internal.enterprise.core.GradleEnterprisePluginManager;
import org.gradle.internal.enterprise.impl.DefaultGradleEnterprisePluginAdapter;
import org.gradle.util.internal.VersionNumber;

public class DefaultGradleEnterprisePluginCheckInService
implements GradleEnterprisePluginCheckInService {
    private final GradleEnterprisePluginManager manager;
    private final DefaultGradleEnterprisePluginAdapter adapter;
    private final boolean isConfigurationCacheEnabled;
    public static final String UNSUPPORTED_TOGGLE = "org.gradle.internal.unsupported-enterprise-plugin";
    public static final String UNSUPPORTED_TOGGLE_MESSAGE = "Enterprise plugin unsupported due to secret toggle";
    public static final VersionNumber MINIMUM_SUPPORTED_PLUGIN_VERSION_FOR_CONFIGURATION_CACHING = VersionNumber.version((int)3, (int)12);
    public static final String UNSUPPORTED_PLUGIN_DUE_TO_CONFIGURATION_CACHING_MESSAGE = String.format("The Gradle Enterprise plugin has been disabled as it is incompatible with this version of Gradle and the configuration caching feature - please upgrade to version %s.%s or later of the Gradle Enterprise plugin to restore functionality.", MINIMUM_SUPPORTED_PLUGIN_VERSION_FOR_CONFIGURATION_CACHING.getMajor(), MINIMUM_SUPPORTED_PLUGIN_VERSION_FOR_CONFIGURATION_CACHING.getMinor());

    public DefaultGradleEnterprisePluginCheckInService(BuildModelParameters buildModelParameters, GradleEnterprisePluginManager manager, DefaultGradleEnterprisePluginAdapter adapter) {
        this.manager = manager;
        this.adapter = adapter;
        this.isConfigurationCacheEnabled = buildModelParameters.isConfigurationCache();
    }

    @Override
    public GradleEnterprisePluginCheckInResult checkIn(GradleEnterprisePluginMetadata pluginMetadata, GradleEnterprisePluginServiceFactory serviceFactory) {
        if (Boolean.getBoolean(UNSUPPORTED_TOGGLE)) {
            this.manager.unsupported();
            return DefaultGradleEnterprisePluginCheckInService.checkInResult(UNSUPPORTED_TOGGLE_MESSAGE, () -> {
                throw new IllegalStateException();
            });
        }
        if (this.isUnsupportedWithConfigurationCaching(pluginMetadata)) {
            this.manager.unsupported();
            return DefaultGradleEnterprisePluginCheckInService.checkInResult(UNSUPPORTED_PLUGIN_DUE_TO_CONFIGURATION_CACHING_MESSAGE, () -> {
                throw new IllegalStateException();
            });
        }
        GradleEnterprisePluginServiceRef ref = this.adapter.register(serviceFactory);
        this.manager.registerAdapter((GradleEnterprisePluginAdapter)this.adapter);
        return DefaultGradleEnterprisePluginCheckInService.checkInResult(null, () -> ref);
    }

    private static GradleEnterprisePluginCheckInResult checkInResult(final String unsupportedMessage, final Supplier<GradleEnterprisePluginServiceRef> pluginServiceRefSupplier) {
        return new GradleEnterprisePluginCheckInResult(){

            @Override
            public String getUnsupportedMessage() {
                return unsupportedMessage;
            }

            @Override
            public GradleEnterprisePluginServiceRef getPluginServiceRef() {
                return (GradleEnterprisePluginServiceRef)pluginServiceRefSupplier.get();
            }
        };
    }

    private boolean isUnsupportedWithConfigurationCaching(GradleEnterprisePluginMetadata pluginMetadata) {
        VersionNumber version = VersionNumber.parse((String)pluginMetadata.getVersion()).getBaseVersion();
        return this.isConfigurationCacheEnabled && MINIMUM_SUPPORTED_PLUGIN_VERSION_FOR_CONFIGURATION_CACHING.compareTo(version) > 0;
    }
}

