/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.eclipse;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.Directory;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.IConventionAware;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.WarPlugin;
import org.gradle.api.plugins.internal.JavaPluginHelper;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.War;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.xml.XmlTransformer;
import org.gradle.plugins.ear.Ear;
import org.gradle.plugins.ear.EarPlugin;
import org.gradle.plugins.ide.api.XmlFileContentMerger;
import org.gradle.plugins.ide.eclipse.EclipsePlugin;
import org.gradle.plugins.ide.eclipse.GenerateEclipseWtpComponent;
import org.gradle.plugins.ide.eclipse.GenerateEclipseWtpFacet;
import org.gradle.plugins.ide.eclipse.internal.AfterEvaluateHelper;
import org.gradle.plugins.ide.eclipse.model.Classpath;
import org.gradle.plugins.ide.eclipse.model.EclipseModel;
import org.gradle.plugins.ide.eclipse.model.EclipseWtpComponent;
import org.gradle.plugins.ide.eclipse.model.Facet;
import org.gradle.plugins.ide.eclipse.model.WbResource;
import org.gradle.plugins.ide.eclipse.model.internal.WtpClasspathAttributeSupport;
import org.gradle.plugins.ide.internal.IdePlugin;
import org.gradle.util.internal.RelativePathUtil;
import org.gradle.util.internal.WrapUtil;

public abstract class EclipseWtpPlugin
extends IdePlugin {
    public static final String ECLIPSE_WTP_COMPONENT_TASK_NAME = "eclipseWtpComponent";
    public static final String ECLIPSE_WTP_FACET_TASK_NAME = "eclipseWtpFacet";
    public static final String WEB_LIBS_CONTAINER = "org.eclipse.jst.j2ee.internal.web.container";
    public final Instantiator instantiator;

    @Inject
    public EclipseWtpPlugin(Instantiator instantiator) {
        this.instantiator = instantiator;
    }

    @Override
    protected String getLifecycleTaskName() {
        return "eclipseWtp";
    }

    @Override
    protected void onApply(Project project) {
        project.getPluginManager().apply(EclipsePlugin.class);
        this.getLifecycleTask().configure(EclipseWtpPlugin.withDescription("Generates Eclipse wtp configuration files."));
        this.getCleanTask().configure(EclipseWtpPlugin.withDescription("Cleans Eclipse wtp configuration files."));
        project.getTasks().named("eclipse", EclipseWtpPlugin.dependsOn(this.getLifecycleTask()));
        project.getTasks().named(this.cleanName("eclipse"), EclipseWtpPlugin.dependsOn(this.getCleanTask()));
        EclipseModel model = (EclipseModel)project.getExtensions().getByType(EclipseModel.class);
        this.configureEclipseProject(project, model);
        this.configureEclipseWtpComponent(project, model);
        this.configureEclipseWtpFacet(project, model);
        this.configureEclipseClasspath(project, model);
    }

    private void configureEclipseClasspath(final Project project, final EclipseModel model) {
        project.getPlugins().withType(JavaPlugin.class, (Action)new Action<JavaPlugin>(){

            public void execute(JavaPlugin javaPlugin) {
                AfterEvaluateHelper.afterEvaluateOrExecute(project, new Action<Project>(){

                    public void execute(Project project) {
                        Collection<Configuration> plusConfigurations = model.getClasspath().getPlusConfigurations();
                        EclipseWtpComponent component = model.getWtp().getComponent();
                        plusConfigurations.addAll(component.getRootConfigurations());
                        plusConfigurations.addAll(component.getLibConfigurations());
                    }
                });
                model.getClasspath().getFile().whenMerged(new Action<Classpath>(){

                    public void execute(Classpath classpath) {
                        new WtpClasspathAttributeSupport(project, model).enhance(classpath);
                    }
                });
            }
        });
        project.getPlugins().withType(WarPlugin.class, (Action)new Action<WarPlugin>(){

            public void execute(WarPlugin warPlugin) {
                model.getClasspath().containers(EclipseWtpPlugin.WEB_LIBS_CONTAINER);
            }
        });
    }

    private void configureEclipseWtpComponent(final Project project, final EclipseModel model) {
        XmlTransformer xmlTransformer = new XmlTransformer();
        xmlTransformer.setIndentation("\t");
        final EclipseWtpComponent component = (EclipseWtpComponent)project.getObjects().newInstance(EclipseWtpComponent.class, new Object[]{project, new XmlFileContentMerger(xmlTransformer)});
        model.getWtp().setComponent(component);
        TaskProvider task = project.getTasks().register(ECLIPSE_WTP_COMPONENT_TASK_NAME, GenerateEclipseWtpComponent.class, new Object[]{component});
        task.configure((Action)new Action<GenerateEclipseWtpComponent>(){

            public void execute(GenerateEclipseWtpComponent task) {
                task.setDescription("Generates the Eclipse WTP component settings file.");
                task.setInputFile(project.file((Object)".settings/org.eclipse.wst.common.component"));
                task.setOutputFile(project.file((Object)".settings/org.eclipse.wst.common.component"));
            }
        });
        this.addWorker((TaskProvider<? extends Task>)task, ECLIPSE_WTP_COMPONENT_TASK_NAME);
        ((IConventionAware)component).getConventionMapping().map("deployName", (Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return model.getProject().getName();
            }
        });
        project.getPlugins().withType(JavaPlugin.class, (Action)new Action<JavaPlugin>(){

            public void execute(JavaPlugin javaPlugin) {
                if (EclipseWtpPlugin.this.hasWarOrEarPlugin(project)) {
                    return;
                }
                Set<Configuration> libConfigurations = component.getLibConfigurations();
                libConfigurations.add(JavaPluginHelper.getJavaComponent((Project)project).getRuntimeClasspathConfiguration());
                component.setClassesDeployPath("/");
                ((IConventionAware)component).getConventionMapping().map("libDeployPath", (Callable)new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        return "../";
                    }
                });
                ((IConventionAware)component).getConventionMapping().map("sourceDirs", (Callable)new Callable<Set<File>>(){

                    @Override
                    public Set<File> call() throws Exception {
                        return EclipseWtpPlugin.this.getMainSourceDirs(project);
                    }
                });
            }
        });
        project.getPlugins().withType(WarPlugin.class, (Action)new Action<WarPlugin>(){

            public void execute(WarPlugin warPlugin) {
                Set<Configuration> libConfigurations = component.getLibConfigurations();
                Set<Configuration> minusConfigurations = component.getMinusConfigurations();
                libConfigurations.add(JavaPluginHelper.getJavaComponent((Project)project).getRuntimeClasspathConfiguration());
                minusConfigurations.add(project.getConfigurations().getByName("providedRuntime"));
                component.setClassesDeployPath("/WEB-INF/classes");
                ConventionMapping convention = ((IConventionAware)component).getConventionMapping();
                convention.map("libDeployPath", (Callable)new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        return "/WEB-INF/lib";
                    }
                });
                convention.map("contextPath", (Callable)new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        return (String)((War)project.getTasks().getByName("war")).getArchiveBaseName().getOrNull();
                    }
                });
                convention.map("resources", (Callable)new Callable<List<WbResource>>(){

                    @Override
                    public List<WbResource> call() throws Exception {
                        File projectDir = project.getProjectDir();
                        File webAppDir = ((Directory)((War)project.getTasks().getByName("war")).getWebAppDirectory().get()).getAsFile();
                        String webAppDirName = RelativePathUtil.relativePath((File)projectDir, (File)webAppDir);
                        return Lists.newArrayList((Object[])new WbResource[]{new WbResource("/", webAppDirName)});
                    }
                });
                convention.map("sourceDirs", (Callable)new Callable<Set<File>>(){

                    @Override
                    public Set<File> call() throws Exception {
                        return EclipseWtpPlugin.this.getMainSourceDirs(project);
                    }
                });
            }
        });
        project.getPlugins().withType(EarPlugin.class, (Action)new Action<EarPlugin>(){

            public void execute(EarPlugin earPlugin) {
                Set<Configuration> libConfigurations = component.getLibConfigurations();
                Set<Configuration> rootConfigurations = component.getRootConfigurations();
                rootConfigurations.clear();
                rootConfigurations.add(project.getConfigurations().getByName("deploy"));
                libConfigurations.clear();
                libConfigurations.add(project.getConfigurations().getByName("earlib"));
                component.setClassesDeployPath("/");
                final ConventionMapping convention = ((IConventionAware)component).getConventionMapping();
                convention.map("libDeployPath", (Callable)new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        String deployPath = ((Ear)project.getTasks().findByName("ear")).getLibDirName();
                        if (!deployPath.startsWith("/")) {
                            deployPath = "/" + deployPath;
                        }
                        return deployPath;
                    }
                });
                convention.map("sourceDirs", (Callable)new Callable<Set<File>>(){

                    @Override
                    public Set<File> call() throws Exception {
                        return WrapUtil.toSet((Object[])new File[]{((Directory)((Ear)project.getTasks().findByName("ear")).getAppDirectory().get()).getAsFile()});
                    }
                });
                project.getPlugins().withType(JavaPlugin.class, (Action)new Action<JavaPlugin>(){

                    public void execute(JavaPlugin javaPlugin) {
                        convention.map("sourceDirs", (Callable)new Callable<Set<File>>(){

                            @Override
                            public Set<File> call() throws Exception {
                                return EclipseWtpPlugin.this.getMainSourceDirs(project);
                            }
                        });
                    }
                });
            }
        });
    }

    private void configureEclipseWtpFacet(final Project project, final EclipseModel eclipseModel) {
        TaskProvider task = project.getTasks().register(ECLIPSE_WTP_FACET_TASK_NAME, GenerateEclipseWtpFacet.class, new Object[]{eclipseModel.getWtp().getFacet()});
        task.configure((Action)new Action<GenerateEclipseWtpFacet>(){

            public void execute(GenerateEclipseWtpFacet task) {
                task.setDescription("Generates the Eclipse WTP facet settings file.");
                task.setInputFile(project.file((Object)".settings/org.eclipse.wst.common.project.facet.core.xml"));
                task.setOutputFile(project.file((Object)".settings/org.eclipse.wst.common.project.facet.core.xml"));
            }
        });
        this.addWorker((TaskProvider<? extends Task>)task, ECLIPSE_WTP_FACET_TASK_NAME);
        project.getPlugins().withType(JavaPlugin.class, (Action)new Action<JavaPlugin>(){

            public void execute(JavaPlugin javaPlugin) {
                if (EclipseWtpPlugin.this.hasWarOrEarPlugin(project)) {
                    return;
                }
                ((IConventionAware)eclipseModel.getWtp().getFacet()).getConventionMapping().map("facets", (Callable)new Callable<List<Facet>>(){

                    @Override
                    public List<Facet> call() throws Exception {
                        return Lists.newArrayList((Object[])new Facet[]{new Facet(Facet.FacetType.fixed, "jst.java", null), new Facet(Facet.FacetType.installed, "jst.utility", "1.0"), new Facet(Facet.FacetType.installed, "jst.java", EclipseWtpPlugin.this.toJavaFacetVersion(((JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class)).getSourceCompatibility()))});
                    }
                });
            }
        });
        project.getPlugins().withType(WarPlugin.class, (Action)new Action<WarPlugin>(){

            public void execute(WarPlugin warPlugin) {
                ((IConventionAware)eclipseModel.getWtp().getFacet()).getConventionMapping().map("facets", (Callable)new Callable<List<Facet>>(){

                    @Override
                    public List<Facet> call() throws Exception {
                        return Lists.newArrayList((Object[])new Facet[]{new Facet(Facet.FacetType.fixed, "jst.java", null), new Facet(Facet.FacetType.fixed, "jst.web", null), new Facet(Facet.FacetType.installed, "jst.web", "2.4"), new Facet(Facet.FacetType.installed, "jst.java", EclipseWtpPlugin.this.toJavaFacetVersion(((JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class)).getSourceCompatibility()))});
                    }
                });
            }
        });
        project.getPlugins().withType(EarPlugin.class, (Action)new Action<EarPlugin>(){

            public void execute(EarPlugin earPlugin) {
                ((IConventionAware)eclipseModel.getWtp().getFacet()).getConventionMapping().map("facets", (Callable)new Callable<List<Facet>>(){

                    @Override
                    public List<Facet> call() throws Exception {
                        return Lists.newArrayList((Object[])new Facet[]{new Facet(Facet.FacetType.fixed, "jst.ear", null), new Facet(Facet.FacetType.installed, "jst.ear", "5.0")});
                    }
                });
            }
        });
    }

    private void configureEclipseProject(Project project, final EclipseModel model) {
        Action<Object> action = new Action<Object>(){

            public void execute(Object ignored) {
                model.getProject().buildCommand("org.eclipse.wst.common.project.facet.core.builder");
                model.getProject().buildCommand("org.eclipse.wst.validation.validationbuilder");
                model.getProject().natures("org.eclipse.wst.common.project.facet.core.nature");
                model.getProject().natures("org.eclipse.wst.common.modulecore.ModuleCoreNature");
                model.getProject().natures("org.eclipse.jem.workbench.JavaEMFNature");
            }
        };
        project.getPlugins().withType(JavaPlugin.class, (Action)action);
        project.getPlugins().withType(EarPlugin.class, (Action)action);
    }

    private boolean hasWarOrEarPlugin(Project project) {
        return project.getPlugins().hasPlugin(WarPlugin.class) || project.getPlugins().hasPlugin(EarPlugin.class);
    }

    private Set<File> getMainSourceDirs(Project project) {
        return ((SourceSet)((JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class)).getSourceSets().getByName("main")).getAllSource().getSrcDirs();
    }

    private String toJavaFacetVersion(JavaVersion version) {
        if (version.equals((Object)JavaVersion.VERSION_1_5)) {
            return "5.0";
        }
        if (version.equals((Object)JavaVersion.VERSION_1_6)) {
            return "6.0";
        }
        return version.toString();
    }
}

