from enum import IntEnum
from typing import overload, NewType, Optional, Tuple

from OCC.Core.Standard import *
from OCC.Core.NCollection import *
from OCC.Core.TopAbs import *

class Sweep_NumShape:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(
        self,
        Index: int,
        Type: TopAbs_ShapeEnum,
        Closed: Optional[bool] = False,
        BegInf: Optional[bool] = False,
        EndInf: Optional[bool] = False,
    ) -> None: ...
    def BegInfinite(self) -> bool: ...
    def Closed(self) -> bool: ...
    def EndInfinite(self) -> bool: ...
    def Index(self) -> int: ...
    def Init(
        self,
        Index: int,
        Type: TopAbs_ShapeEnum,
        Closed: Optional[bool] = False,
        BegInf: Optional[bool] = False,
        EndInf: Optional[bool] = False,
    ) -> None: ...
    def Orientation(self) -> TopAbs_Orientation: ...
    def Type(self) -> TopAbs_ShapeEnum: ...

class Sweep_NumShapeIterator:
    def __init__(self) -> None: ...
    def Init(self, aShape: Sweep_NumShape) -> None: ...
    def More(self) -> bool: ...
    def Next(self) -> None: ...
    def Orientation(self) -> TopAbs_Orientation: ...
    def Value(self) -> Sweep_NumShape: ...

class Sweep_NumShapeTool:
    def __init__(self, aShape: Sweep_NumShape) -> None: ...
    def FirstVertex(self) -> Sweep_NumShape: ...
    def HasFirstVertex(self) -> bool: ...
    def HasLastVertex(self) -> bool: ...
    def Index(self, aShape: Sweep_NumShape) -> int: ...
    def LastVertex(self) -> Sweep_NumShape: ...
    def NbShapes(self) -> int: ...
    def Orientation(self, aShape: Sweep_NumShape) -> TopAbs_Orientation: ...
    def Shape(self, anIndex: int) -> Sweep_NumShape: ...
    def Type(self, aShape: Sweep_NumShape) -> TopAbs_ShapeEnum: ...

# harray1 classes
# harray2 classes
# hsequence classes
