from enum import IntEnum
from typing import overload, NewType, Optional, Tuple

from OCC.Core.Standard import *
from OCC.Core.NCollection import *
from OCC.Core.StepShape import *
from OCC.Core.Interface import *
from OCC.Core.StepRepr import *
from OCC.Core.StepBasic import *
from OCC.Core.IFSelect import *
from OCC.Core.TCollection import *
from OCC.Core.XSControl import *

class STEPSelections_SequenceOfAssemblyComponent:
    def Assign(self, theItem: False) -> False: ...
    def Clear(self) -> None: ...
    def First(self) -> False: ...
    def IsDeletables(self) -> bool: ...
    def IsEmpty(self) -> bool: ...
    def Last(self) -> False: ...
    def Length(self) -> int: ...
    def Lower(self) -> int: ...
    def Prepend(self, theItem: False) -> False: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def SetValue(self, theIndex: int, theValue: False) -> None: ...
    def Size(self) -> int: ...
    def UpdateUpperBound(self, int) -> None: ...
    def UpdateLowerBound(self, int) -> None: ...
    def Upper(self) -> int: ...
    def Value(self, theIndex: int) -> False: ...
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...

class STEPSelections_SequenceOfAssemblyLink:
    def Assign(self, theItem: False) -> False: ...
    def Clear(self) -> None: ...
    def First(self) -> False: ...
    def IsDeletables(self) -> bool: ...
    def IsEmpty(self) -> bool: ...
    def Last(self) -> False: ...
    def Length(self) -> int: ...
    def Lower(self) -> int: ...
    def Prepend(self, theItem: False) -> False: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def SetValue(self, theIndex: int, theValue: False) -> None: ...
    def Size(self) -> int: ...
    def UpdateUpperBound(self, int) -> None: ...
    def UpdateLowerBound(self, int) -> None: ...
    def Upper(self) -> int: ...
    def Value(self, theIndex: int) -> False: ...
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...

class STEPSelections_AssemblyComponent(Standard_Transient):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(
        self,
        sdr: StepShape_ShapeDefinitionRepresentation,
        list: STEPSelections_HSequenceOfAssemblyLink,
    ) -> None: ...
    def GetList(self) -> STEPSelections_HSequenceOfAssemblyLink: ...
    def GetSDR(self) -> StepShape_ShapeDefinitionRepresentation: ...
    def SetList(self, list: STEPSelections_HSequenceOfAssemblyLink) -> None: ...
    def SetSDR(self, sdr: StepShape_ShapeDefinitionRepresentation) -> None: ...

class STEPSelections_AssemblyExplorer:
    def __init__(self, G: Interface_Graph) -> None: ...
    def Dump(self) -> str: ...
    def FillListWithGraph(self, cmp: STEPSelections_AssemblyComponent) -> None: ...
    def FindItemWithNAUO(
        self, nauo: StepRepr_NextAssemblyUsageOccurrence
    ) -> Standard_Transient: ...
    def FindSDRWithProduct(
        self, product: StepBasic_ProductDefinition
    ) -> StepShape_ShapeDefinitionRepresentation: ...
    def Init(self, G: Interface_Graph) -> None: ...
    def NbAssemblies(self) -> int: ...
    def Root(self, rank: Optional[int] = 1) -> STEPSelections_AssemblyComponent: ...

class STEPSelections_AssemblyLink(Standard_Transient):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(
        self,
        nauo: StepRepr_NextAssemblyUsageOccurrence,
        item: Standard_Transient,
        part: STEPSelections_AssemblyComponent,
    ) -> None: ...
    def GetComponent(self) -> STEPSelections_AssemblyComponent: ...
    def GetItem(self) -> Standard_Transient: ...
    def GetNAUO(self) -> StepRepr_NextAssemblyUsageOccurrence: ...
    def SetComponent(self, part: STEPSelections_AssemblyComponent) -> None: ...
    def SetItem(self, item: Standard_Transient) -> None: ...
    def SetNAUO(self, nauo: StepRepr_NextAssemblyUsageOccurrence) -> None: ...

class STEPSelections_Counter:
    def __init__(self) -> None: ...
    def Clear(self) -> None: ...
    def Count(self, graph: Interface_Graph, start: Standard_Transient) -> None: ...
    def NbInstancesOfEdges(self) -> int: ...
    def NbInstancesOfFaces(self) -> int: ...
    def NbInstancesOfShells(self) -> int: ...
    def NbInstancesOfSolids(self) -> int: ...
    def NbInstancesOfWires(self) -> int: ...
    def NbSourceEdges(self) -> int: ...
    def NbSourceFaces(self) -> int: ...
    def NbSourceShells(self) -> int: ...
    def NbSourceSolids(self) -> int: ...
    def NbSourceWires(self) -> int: ...

class STEPSelections_SelectAssembly(IFSelect_SelectExplore):
    def __init__(self) -> None: ...
    def Explore(
        self,
        level: int,
        ent: Standard_Transient,
        G: Interface_Graph,
        explored: Interface_EntityIterator,
    ) -> bool: ...
    def ExploreLabel(self) -> str: ...

class STEPSelections_SelectDerived(StepSelect_StepType):
    def __init__(self) -> None: ...
    def Matches(
        self,
        ent: Standard_Transient,
        model: Interface_InterfaceModel,
        text: str,
        exact: bool,
    ) -> bool: ...

class STEPSelections_SelectFaces(IFSelect_SelectExplore):
    def __init__(self) -> None: ...
    def Explore(
        self,
        level: int,
        ent: Standard_Transient,
        G: Interface_Graph,
        explored: Interface_EntityIterator,
    ) -> bool: ...
    def ExploreLabel(self) -> str: ...

class STEPSelections_SelectForTransfer(XSControl_SelectForTransfer):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, TR: XSControl_TransferReader) -> None: ...
    def RootResult(self, G: Interface_Graph) -> Interface_EntityIterator: ...

class STEPSelections_SelectGSCurves(IFSelect_SelectExplore):
    def __init__(self) -> None: ...
    def Explore(
        self,
        level: int,
        ent: Standard_Transient,
        G: Interface_Graph,
        explored: Interface_EntityIterator,
    ) -> bool: ...
    def ExploreLabel(self) -> str: ...

class STEPSelections_SelectInstances(IFSelect_SelectExplore):
    def __init__(self) -> None: ...
    def Explore(
        self,
        level: int,
        ent: Standard_Transient,
        G: Interface_Graph,
        explored: Interface_EntityIterator,
    ) -> bool: ...
    def ExploreLabel(self) -> str: ...
    def RootResult(self, G: Interface_Graph) -> Interface_EntityIterator: ...

# harray1 classes
# harray2 classes
# hsequence classes

class STEPSelections_HSequenceOfAssemblyLink(
    STEPSelections_SequenceOfAssemblyLink, Standard_Transient
):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: STEPSelections_SequenceOfAssemblyLink) -> None: ...
    def Sequence(self) -> STEPSelections_SequenceOfAssemblyLink: ...
    def Append(self, theSequence: STEPSelections_SequenceOfAssemblyLink) -> None: ...
