from enum import IntEnum
from typing import overload, NewType, Optional, Tuple

from OCC.Core.Standard import *
from OCC.Core.NCollection import *
from OCC.Core.TCollection import *
from OCC.Core.Image import *
from OCC.Core.Graphic3d import *

class Media_BufferPool(Standard_Transient):
    def __init__(self) -> None: ...
    def BufferSize(self) -> int: ...
    def GetBuffer(self) -> False: ...
    def Init(self, theBufferSize: int) -> bool: ...
    def Release(self) -> None: ...

class Media_CodecContext(Standard_Transient):
    def __init__(self) -> None: ...
    def CanProcessPacket(self, thePacket: Media_Packet) -> bool: ...
    def Close(self) -> None: ...
    def Context(self) -> False: ...
    def Flush(self) -> None: ...
    def ReceiveFrame(self, theFrame: Media_Frame) -> bool: ...
    def SendPacket(self, thePacket: Media_Packet) -> bool: ...
    def SizeX(self) -> int: ...
    def SizeY(self) -> int: ...
    def StreamIndex(self) -> int: ...

class Media_FormatContext(Standard_Transient):
    def __init__(self) -> None: ...
    def Close(self) -> None: ...
    def Context(self) -> False: ...
    def Duration(self) -> float: ...
    @staticmethod
    def FormatAVErrorDescription(theErrCodeAV: int) -> str: ...
    @staticmethod
    def FormatTime(theSeconds: float) -> str: ...
    @staticmethod
    def FormatTimeProgress(theProgress: float, theDuration: float) -> str: ...
    def NbSteams(self) -> int: ...
    def OpenInput(self, theInput: str) -> bool: ...
    def PtsStartBase(self) -> float: ...
    def ReadPacket(self, thePacket: Media_Packet) -> bool: ...
    @overload
    @staticmethod
    def SecondsToUnits(theTimeSeconds: float) -> int: ...
    def Seek(self, theSeekPts: float, toSeekBack: bool) -> bool: ...
    def SeekStream(
        self, theStreamId: int, theSeekPts: float, toSeekBack: bool
    ) -> bool: ...
    def Stream(self, theIndex: int) -> False: ...

class Media_Frame(Standard_Transient):
    def __init__(self) -> None: ...
    def BestEffortTimestamp(self) -> False: ...
    def ChangeFrame(self) -> False: ...
    def Format(self) -> int: ...
    @staticmethod
    def FormatFFmpeg2Occt(theFormat: int) -> Image_Format: ...
    @staticmethod
    def FormatOcct2FFmpeg(theFormat: Image_Format) -> int: ...
    def Frame(self) -> False: ...
    def InitWrapper(self, thePixMap: Image_PixMap) -> bool: ...
    def IsEmpty(self) -> bool: ...
    def IsFullRangeYUV(self) -> bool: ...
    def IsLocked(self) -> bool: ...
    def LineSize(self, thePlaneId: int) -> int: ...
    def PixelAspectRatio(self) -> float: ...
    def Plane(self, thePlaneId: int) -> False: ...
    def Pts(self) -> float: ...
    def SetLocked(self, theToLock: bool) -> None: ...
    def SetPixelAspectRatio(self, theRatio: float) -> None: ...
    def SetPts(self, thePts: float) -> None: ...
    def Size(self) -> Graphic3d_Vec2i: ...
    def SizeX(self) -> int: ...
    def SizeY(self) -> int: ...
    @staticmethod
    def Swap(theFrame1: Media_Frame, theFrame2: Media_Frame) -> None: ...
    def Unref(self) -> None: ...

class Media_IFrameQueue:
    def LockFrame(self) -> Media_Frame: ...
    def ReleaseFrame(self, theFrame: Media_Frame) -> None: ...

class Media_Packet(Standard_Transient):
    def __init__(self) -> None: ...
    def ChangeData(self) -> False: ...
    def ChangePacket(self) -> False: ...
    def Data(self) -> False: ...
    def Dts(self) -> False: ...
    def Duration(self) -> False: ...
    def DurationSeconds(self) -> float: ...
    def IsKeyFrame(self) -> bool: ...
    def Packet(self) -> False: ...
    def Pts(self) -> False: ...
    def SetDurationSeconds(self, theDurationSec: float) -> None: ...
    def SetKeyFrame(self) -> None: ...
    def Size(self) -> int: ...
    def StreamIndex(self) -> int: ...
    def Unref(self) -> None: ...

class Media_PlayerContext(Standard_Transient):
    def __init__(self, theFrameQueue: Media_IFrameQueue) -> None: ...
    @overload
    @staticmethod
    def DumpFirstFrame(theSrcVideo: str, theMediaInfo: str) -> Media_Frame: ...
    @overload
    @staticmethod
    def DumpFirstFrame(
        theSrcVideo: str,
        theOutImage: str,
        theMediaInfo: str,
        theMaxSize: Optional[int] = 0,
    ) -> bool: ...
    def Pause(self) -> None: ...
    def PlayPause(self) -> Tuple[bool, float, float]: ...
    def PlaybackState(self) -> Tuple[bool, float, float]: ...
    def Resume(self) -> None: ...
    def Seek(self, thePosSec: float) -> None: ...
    def SetForceRgb(self, theToForce: bool) -> None: ...
    def SetInput(self, theInputPath: str, theToWait: bool) -> None: ...
    def ToForceRgb(self) -> bool: ...

class Media_Scaler(Standard_Transient):
    def __init__(self) -> None: ...
    def Convert(self, theSrc: Media_Frame, theRes: Media_Frame) -> bool: ...
    def Init(
        self,
        theSrcDims: Graphic3d_Vec2i,
        theSrcFormat: int,
        theResDims: Graphic3d_Vec2i,
        theResFormat: int,
    ) -> bool: ...
    def IsValid(self) -> bool: ...
    def Release(self) -> None: ...

class Media_Timer(Standard_Transient):
    def __init__(self) -> None: ...
    def ElapsedTime(self) -> float: ...
    def IsStarted(self) -> bool: ...
    def Pause(self) -> None: ...
    def PlaybackSpeed(self) -> float: ...
    def Seek(self, theTime: float) -> None: ...
    def SetPlaybackSpeed(self, theSpeed: float) -> None: ...
    def Start(self) -> None: ...
    def Stop(self) -> None: ...

# harray1 classes
# harray2 classes
# hsequence classes
