from enum import IntEnum
from typing import overload, NewType, Optional, Tuple

from OCC.Core.Standard import *
from OCC.Core.NCollection import *
from OCC.Core.BVH import *
from OCC.Core.Quantity import *
from OCC.Core.gp import *
from OCC.Core.Aspect import *
from OCC.Core.TCollection import *
from OCC.Core.TopLoc import *
from OCC.Core.Bnd import *
from OCC.Core.TColStd import *
from OCC.Core.Image import *
from OCC.Core.OSD import *
from OCC.Core.Media import *

Graphic3d_ArrayFlags = NewType("Graphic3d_ArrayFlags", Standard_Integer)
# the following typedef cannot be wrapped as is
Graphic3d_ArrayOfIndexedMapOfStructure = NewType(
    "Graphic3d_ArrayOfIndexedMapOfStructure", Any
)
# the following typedef cannot be wrapped as is
Graphic3d_BndBox3d = NewType("Graphic3d_BndBox3d", Any)
# the following typedef cannot be wrapped as is
Graphic3d_BndBox4d = NewType("Graphic3d_BndBox4d", Any)
# the following typedef cannot be wrapped as is
Graphic3d_BndBox4f = NewType("Graphic3d_BndBox4f", Any)
# the following typedef cannot be wrapped as is
Graphic3d_CameraLerp = NewType("Graphic3d_CameraLerp", Any)
# the following typedef cannot be wrapped as is
Graphic3d_IndexedMapOfStructure = NewType("Graphic3d_IndexedMapOfStructure", Any)
# the following typedef cannot be wrapped as is
Graphic3d_IndexedMapOfView = NewType("Graphic3d_IndexedMapOfView", Any)
# the following typedef cannot be wrapped as is
Graphic3d_MapIteratorOfMapOfStructure = NewType(
    "Graphic3d_MapIteratorOfMapOfStructure", Any
)
# the following typedef cannot be wrapped as is
Graphic3d_MapOfStructure = NewType("Graphic3d_MapOfStructure", Any)
# the following typedef cannot be wrapped as is
Graphic3d_Mat4 = NewType("Graphic3d_Mat4", Any)
# the following typedef cannot be wrapped as is
Graphic3d_Mat4d = NewType("Graphic3d_Mat4d", Any)
# the following typedef cannot be wrapped as is
Graphic3d_NMapOfTransient = NewType("Graphic3d_NMapOfTransient", Any)
Graphic3d_Texture2Dmanual = NewType("Graphic3d_Texture2Dmanual", Graphic3d_Texture2D)
# the following typedef cannot be wrapped as is
Graphic3d_UniformFloat = NewType("Graphic3d_UniformFloat", Any)
# the following typedef cannot be wrapped as is
Graphic3d_UniformInt = NewType("Graphic3d_UniformInt", Any)
# the following typedef cannot be wrapped as is
Graphic3d_UniformVec2 = NewType("Graphic3d_UniformVec2", Any)
# the following typedef cannot be wrapped as is
Graphic3d_UniformVec2i = NewType("Graphic3d_UniformVec2i", Any)
# the following typedef cannot be wrapped as is
Graphic3d_UniformVec3 = NewType("Graphic3d_UniformVec3", Any)
# the following typedef cannot be wrapped as is
Graphic3d_UniformVec3i = NewType("Graphic3d_UniformVec3i", Any)
# the following typedef cannot be wrapped as is
Graphic3d_UniformVec4 = NewType("Graphic3d_UniformVec4", Any)
# the following typedef cannot be wrapped as is
Graphic3d_UniformVec4i = NewType("Graphic3d_UniformVec4i", Any)
# the following typedef cannot be wrapped as is
Graphic3d_Vec2 = NewType("Graphic3d_Vec2", Any)
# the following typedef cannot be wrapped as is
Graphic3d_Vec2b = NewType("Graphic3d_Vec2b", Any)
# the following typedef cannot be wrapped as is
Graphic3d_Vec2d = NewType("Graphic3d_Vec2d", Any)
# the following typedef cannot be wrapped as is
Graphic3d_Vec2i = NewType("Graphic3d_Vec2i", Any)
# the following typedef cannot be wrapped as is
Graphic3d_Vec2ub = NewType("Graphic3d_Vec2ub", Any)
# the following typedef cannot be wrapped as is
Graphic3d_Vec3 = NewType("Graphic3d_Vec3", Any)
# the following typedef cannot be wrapped as is
Graphic3d_Vec3b = NewType("Graphic3d_Vec3b", Any)
# the following typedef cannot be wrapped as is
Graphic3d_Vec3d = NewType("Graphic3d_Vec3d", Any)
# the following typedef cannot be wrapped as is
Graphic3d_Vec3i = NewType("Graphic3d_Vec3i", Any)
# the following typedef cannot be wrapped as is
Graphic3d_Vec3ub = NewType("Graphic3d_Vec3ub", Any)
# the following typedef cannot be wrapped as is
Graphic3d_Vec4 = NewType("Graphic3d_Vec4", Any)
# the following typedef cannot be wrapped as is
Graphic3d_Vec4b = NewType("Graphic3d_Vec4b", Any)
# the following typedef cannot be wrapped as is
Graphic3d_Vec4d = NewType("Graphic3d_Vec4d", Any)
# the following typedef cannot be wrapped as is
Graphic3d_Vec4i = NewType("Graphic3d_Vec4i", Any)
# the following typedef cannot be wrapped as is
Graphic3d_Vec4ub = NewType("Graphic3d_Vec4ub", Any)
Graphic3d_ZLayerId = NewType("Graphic3d_ZLayerId", Standard_Integer)

class Graphic3d_Array1OfAttribute:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def __getitem__(self, index: int) -> Graphic3d_Attribute: ...
    def __setitem__(self, index: int, value: Graphic3d_Attribute) -> None: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator[Graphic3d_Attribute]: ...
    def next(self) -> Graphic3d_Attribute: ...
    __next__ = next
    def Init(self, theValue: Graphic3d_Attribute) -> None: ...
    def Size(self) -> int: ...
    def Length(self) -> int: ...
    def IsEmpty(self) -> bool: ...
    def Lower(self) -> int: ...
    def Upper(self) -> int: ...
    def IsDetectable(self) -> bool: ...
    def IsAllocated(self) -> bool: ...
    def First(self) -> Graphic3d_Attribute: ...
    def Last(self) -> Graphic3d_Attribute: ...
    def Value(self, theIndex: int) -> Graphic3d_Attribute: ...
    def SetValue(self, theIndex: int, theValue: Graphic3d_Attribute) -> None: ...

class Graphic3d_GraphicDriverFactoryList:
    def Append(self, theItem: False) -> False: ...
    def Assign(
        self, theItem: Graphic3d_GraphicDriverFactoryList
    ) -> Graphic3d_GraphicDriverFactoryList: ...
    def Clear(self) -> None: ...
    def First(self) -> False: ...
    def Last(self) -> False: ...
    def Prepend(self, theItem: False) -> False: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def Size(self) -> int: ...
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> False: ...

class Graphic3d_SequenceOfGroup:
    def Assign(self, theItem: False) -> False: ...
    def Clear(self) -> None: ...
    def First(self) -> False: ...
    def IsDeletables(self) -> bool: ...
    def IsEmpty(self) -> bool: ...
    def Last(self) -> False: ...
    def Length(self) -> int: ...
    def Lower(self) -> int: ...
    def Prepend(self, theItem: False) -> False: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def SetValue(self, theIndex: int, theValue: False) -> None: ...
    def Size(self) -> int: ...
    def UpdateUpperBound(self, int) -> None: ...
    def UpdateLowerBound(self, int) -> None: ...
    def Upper(self) -> int: ...
    def Value(self, theIndex: int) -> False: ...
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...

class Graphic3d_SequenceOfStructure:
    def Assign(self, theItem: False) -> False: ...
    def Clear(self) -> None: ...
    def First(self) -> False: ...
    def IsDeletables(self) -> bool: ...
    def IsEmpty(self) -> bool: ...
    def Last(self) -> False: ...
    def Length(self) -> int: ...
    def Lower(self) -> int: ...
    def Prepend(self, theItem: False) -> False: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def SetValue(self, theIndex: int, theValue: False) -> None: ...
    def Size(self) -> int: ...
    def UpdateUpperBound(self, int) -> None: ...
    def UpdateLowerBound(self, int) -> None: ...
    def Upper(self) -> int: ...
    def Value(self, theIndex: int) -> False: ...
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...

class Graphic3d_ShaderAttributeList:
    def Assign(self, theItem: False) -> False: ...
    def Clear(self) -> None: ...
    def First(self) -> False: ...
    def IsDeletables(self) -> bool: ...
    def IsEmpty(self) -> bool: ...
    def Last(self) -> False: ...
    def Length(self) -> int: ...
    def Lower(self) -> int: ...
    def Prepend(self, theItem: False) -> False: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def SetValue(self, theIndex: int, theValue: False) -> None: ...
    def Size(self) -> int: ...
    def UpdateUpperBound(self, int) -> None: ...
    def UpdateLowerBound(self, int) -> None: ...
    def Upper(self) -> int: ...
    def Value(self, theIndex: int) -> False: ...
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...

class Graphic3d_ShaderObjectList:
    def Assign(self, theItem: False) -> False: ...
    def Clear(self) -> None: ...
    def First(self) -> False: ...
    def IsDeletables(self) -> bool: ...
    def IsEmpty(self) -> bool: ...
    def Last(self) -> False: ...
    def Length(self) -> int: ...
    def Lower(self) -> int: ...
    def Prepend(self, theItem: False) -> False: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def SetValue(self, theIndex: int, theValue: False) -> None: ...
    def Size(self) -> int: ...
    def UpdateUpperBound(self, int) -> None: ...
    def UpdateLowerBound(self, int) -> None: ...
    def Upper(self) -> int: ...
    def Value(self, theIndex: int) -> False: ...
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...

class Graphic3d_ShaderVariableList:
    def Assign(self, theItem: False) -> False: ...
    def Clear(self) -> None: ...
    def First(self) -> False: ...
    def IsDeletables(self) -> bool: ...
    def IsEmpty(self) -> bool: ...
    def Last(self) -> False: ...
    def Length(self) -> int: ...
    def Lower(self) -> int: ...
    def Prepend(self, theItem: False) -> False: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def SetValue(self, theIndex: int, theValue: False) -> None: ...
    def Size(self) -> int: ...
    def UpdateUpperBound(self, int) -> None: ...
    def UpdateLowerBound(self, int) -> None: ...
    def Upper(self) -> int: ...
    def Value(self, theIndex: int) -> False: ...
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...

class Graphic3d_AlphaMode(IntEnum):
    Graphic3d_AlphaMode_Opaque: int = ...
    Graphic3d_AlphaMode_Mask: int = ...
    Graphic3d_AlphaMode_Blend: int = ...
    Graphic3d_AlphaMode_MaskBlend: int = ...
    Graphic3d_AlphaMode_BlendAuto: int = ...

Graphic3d_AlphaMode_Opaque = Graphic3d_AlphaMode.Graphic3d_AlphaMode_Opaque
Graphic3d_AlphaMode_Mask = Graphic3d_AlphaMode.Graphic3d_AlphaMode_Mask
Graphic3d_AlphaMode_Blend = Graphic3d_AlphaMode.Graphic3d_AlphaMode_Blend
Graphic3d_AlphaMode_MaskBlend = Graphic3d_AlphaMode.Graphic3d_AlphaMode_MaskBlend
Graphic3d_AlphaMode_BlendAuto = Graphic3d_AlphaMode.Graphic3d_AlphaMode_BlendAuto

class Graphic3d_FresnelModel(IntEnum):
    Graphic3d_FM_SCHLICK: int = ...
    Graphic3d_FM_CONSTANT: int = ...
    Graphic3d_FM_CONDUCTOR: int = ...
    Graphic3d_FM_DIELECTRIC: int = ...

Graphic3d_FM_SCHLICK = Graphic3d_FresnelModel.Graphic3d_FM_SCHLICK
Graphic3d_FM_CONSTANT = Graphic3d_FresnelModel.Graphic3d_FM_CONSTANT
Graphic3d_FM_CONDUCTOR = Graphic3d_FresnelModel.Graphic3d_FM_CONDUCTOR
Graphic3d_FM_DIELECTRIC = Graphic3d_FresnelModel.Graphic3d_FM_DIELECTRIC

class Graphic3d_TypeOfAttribute(IntEnum):
    Graphic3d_TOA_POS: int = ...
    Graphic3d_TOA_NORM: int = ...
    Graphic3d_TOA_UV: int = ...
    Graphic3d_TOA_COLOR: int = ...
    Graphic3d_TOA_CUSTOM: int = ...

Graphic3d_TOA_POS = Graphic3d_TypeOfAttribute.Graphic3d_TOA_POS
Graphic3d_TOA_NORM = Graphic3d_TypeOfAttribute.Graphic3d_TOA_NORM
Graphic3d_TOA_UV = Graphic3d_TypeOfAttribute.Graphic3d_TOA_UV
Graphic3d_TOA_COLOR = Graphic3d_TypeOfAttribute.Graphic3d_TOA_COLOR
Graphic3d_TOA_CUSTOM = Graphic3d_TypeOfAttribute.Graphic3d_TOA_CUSTOM

class Graphic3d_TypeOfData(IntEnum):
    Graphic3d_TOD_USHORT: int = ...
    Graphic3d_TOD_UINT: int = ...
    Graphic3d_TOD_VEC2: int = ...
    Graphic3d_TOD_VEC3: int = ...
    Graphic3d_TOD_VEC4: int = ...
    Graphic3d_TOD_VEC4UB: int = ...
    Graphic3d_TOD_FLOAT: int = ...

Graphic3d_TOD_USHORT = Graphic3d_TypeOfData.Graphic3d_TOD_USHORT
Graphic3d_TOD_UINT = Graphic3d_TypeOfData.Graphic3d_TOD_UINT
Graphic3d_TOD_VEC2 = Graphic3d_TypeOfData.Graphic3d_TOD_VEC2
Graphic3d_TOD_VEC3 = Graphic3d_TypeOfData.Graphic3d_TOD_VEC3
Graphic3d_TOD_VEC4 = Graphic3d_TypeOfData.Graphic3d_TOD_VEC4
Graphic3d_TOD_VEC4UB = Graphic3d_TypeOfData.Graphic3d_TOD_VEC4UB
Graphic3d_TOD_FLOAT = Graphic3d_TypeOfData.Graphic3d_TOD_FLOAT

class Graphic3d_BufferType(IntEnum):
    Graphic3d_BT_RGB: int = ...
    Graphic3d_BT_RGBA: int = ...
    Graphic3d_BT_Depth: int = ...
    Graphic3d_BT_RGB_RayTraceHdrLeft: int = ...
    Graphic3d_BT_Red: int = ...
    Graphic3d_BT_ShadowMap: int = ...

Graphic3d_BT_RGB = Graphic3d_BufferType.Graphic3d_BT_RGB
Graphic3d_BT_RGBA = Graphic3d_BufferType.Graphic3d_BT_RGBA
Graphic3d_BT_Depth = Graphic3d_BufferType.Graphic3d_BT_Depth
Graphic3d_BT_RGB_RayTraceHdrLeft = Graphic3d_BufferType.Graphic3d_BT_RGB_RayTraceHdrLeft
Graphic3d_BT_Red = Graphic3d_BufferType.Graphic3d_BT_Red
Graphic3d_BT_ShadowMap = Graphic3d_BufferType.Graphic3d_BT_ShadowMap

class Graphic3d_CappingFlags(IntEnum):
    Graphic3d_CappingFlags_None: int = ...
    Graphic3d_CappingFlags_ObjectMaterial: int = ...
    Graphic3d_CappingFlags_ObjectTexture: int = ...
    Graphic3d_CappingFlags_ObjectShader: int = ...
    Graphic3d_CappingFlags_ObjectAspect: int = ...

Graphic3d_CappingFlags_None = Graphic3d_CappingFlags.Graphic3d_CappingFlags_None
Graphic3d_CappingFlags_ObjectMaterial = (
    Graphic3d_CappingFlags.Graphic3d_CappingFlags_ObjectMaterial
)
Graphic3d_CappingFlags_ObjectTexture = (
    Graphic3d_CappingFlags.Graphic3d_CappingFlags_ObjectTexture
)
Graphic3d_CappingFlags_ObjectShader = (
    Graphic3d_CappingFlags.Graphic3d_CappingFlags_ObjectShader
)
Graphic3d_CappingFlags_ObjectAspect = (
    Graphic3d_CappingFlags.Graphic3d_CappingFlags_ObjectAspect
)

class Graphic3d_ClipState(IntEnum):
    Graphic3d_ClipState_Out: int = ...
    Graphic3d_ClipState_In: int = ...
    Graphic3d_ClipState_On: int = ...

Graphic3d_ClipState_Out = Graphic3d_ClipState.Graphic3d_ClipState_Out
Graphic3d_ClipState_In = Graphic3d_ClipState.Graphic3d_ClipState_In
Graphic3d_ClipState_On = Graphic3d_ClipState.Graphic3d_ClipState_On

class Graphic3d_CubeMapSide(IntEnum):
    Graphic3d_CMS_POS_X: int = ...
    Graphic3d_CMS_NEG_X: int = ...
    Graphic3d_CMS_POS_Y: int = ...
    Graphic3d_CMS_NEG_Y: int = ...
    Graphic3d_CMS_POS_Z: int = ...
    Graphic3d_CMS_NEG_Z: int = ...

Graphic3d_CMS_POS_X = Graphic3d_CubeMapSide.Graphic3d_CMS_POS_X
Graphic3d_CMS_NEG_X = Graphic3d_CubeMapSide.Graphic3d_CMS_NEG_X
Graphic3d_CMS_POS_Y = Graphic3d_CubeMapSide.Graphic3d_CMS_POS_Y
Graphic3d_CMS_NEG_Y = Graphic3d_CubeMapSide.Graphic3d_CMS_NEG_Y
Graphic3d_CMS_POS_Z = Graphic3d_CubeMapSide.Graphic3d_CMS_POS_Z
Graphic3d_CMS_NEG_Z = Graphic3d_CubeMapSide.Graphic3d_CMS_NEG_Z

class Graphic3d_DiagnosticInfo(IntEnum):
    Graphic3d_DiagnosticInfo_Device: int = ...
    Graphic3d_DiagnosticInfo_FrameBuffer: int = ...
    Graphic3d_DiagnosticInfo_Limits: int = ...
    Graphic3d_DiagnosticInfo_Memory: int = ...
    Graphic3d_DiagnosticInfo_NativePlatform: int = ...
    Graphic3d_DiagnosticInfo_Extensions: int = ...
    Graphic3d_DiagnosticInfo_Short: int = ...
    Graphic3d_DiagnosticInfo_Basic: int = ...
    Graphic3d_DiagnosticInfo_Complete: int = ...

Graphic3d_DiagnosticInfo_Device = (
    Graphic3d_DiagnosticInfo.Graphic3d_DiagnosticInfo_Device
)
Graphic3d_DiagnosticInfo_FrameBuffer = (
    Graphic3d_DiagnosticInfo.Graphic3d_DiagnosticInfo_FrameBuffer
)
Graphic3d_DiagnosticInfo_Limits = (
    Graphic3d_DiagnosticInfo.Graphic3d_DiagnosticInfo_Limits
)
Graphic3d_DiagnosticInfo_Memory = (
    Graphic3d_DiagnosticInfo.Graphic3d_DiagnosticInfo_Memory
)
Graphic3d_DiagnosticInfo_NativePlatform = (
    Graphic3d_DiagnosticInfo.Graphic3d_DiagnosticInfo_NativePlatform
)
Graphic3d_DiagnosticInfo_Extensions = (
    Graphic3d_DiagnosticInfo.Graphic3d_DiagnosticInfo_Extensions
)
Graphic3d_DiagnosticInfo_Short = Graphic3d_DiagnosticInfo.Graphic3d_DiagnosticInfo_Short
Graphic3d_DiagnosticInfo_Basic = Graphic3d_DiagnosticInfo.Graphic3d_DiagnosticInfo_Basic
Graphic3d_DiagnosticInfo_Complete = (
    Graphic3d_DiagnosticInfo.Graphic3d_DiagnosticInfo_Complete
)

class Graphic3d_DisplayPriority(IntEnum):
    Graphic3d_DisplayPriority_INVALID: int = ...
    Graphic3d_DisplayPriority_Bottom: int = ...
    Graphic3d_DisplayPriority_AlmostBottom: int = ...
    Graphic3d_DisplayPriority_Below2: int = ...
    Graphic3d_DisplayPriority_Below1: int = ...
    Graphic3d_DisplayPriority_Below: int = ...
    Graphic3d_DisplayPriority_Normal: int = ...
    Graphic3d_DisplayPriority_Above: int = ...
    Graphic3d_DisplayPriority_Above1: int = ...
    Graphic3d_DisplayPriority_Above2: int = ...
    Graphic3d_DisplayPriority_Highlight: int = ...
    Graphic3d_DisplayPriority_Topmost: int = ...

Graphic3d_DisplayPriority_INVALID = (
    Graphic3d_DisplayPriority.Graphic3d_DisplayPriority_INVALID
)
Graphic3d_DisplayPriority_Bottom = (
    Graphic3d_DisplayPriority.Graphic3d_DisplayPriority_Bottom
)
Graphic3d_DisplayPriority_AlmostBottom = (
    Graphic3d_DisplayPriority.Graphic3d_DisplayPriority_AlmostBottom
)
Graphic3d_DisplayPriority_Below2 = (
    Graphic3d_DisplayPriority.Graphic3d_DisplayPriority_Below2
)
Graphic3d_DisplayPriority_Below1 = (
    Graphic3d_DisplayPriority.Graphic3d_DisplayPriority_Below1
)
Graphic3d_DisplayPriority_Below = (
    Graphic3d_DisplayPriority.Graphic3d_DisplayPriority_Below
)
Graphic3d_DisplayPriority_Normal = (
    Graphic3d_DisplayPriority.Graphic3d_DisplayPriority_Normal
)
Graphic3d_DisplayPriority_Above = (
    Graphic3d_DisplayPriority.Graphic3d_DisplayPriority_Above
)
Graphic3d_DisplayPriority_Above1 = (
    Graphic3d_DisplayPriority.Graphic3d_DisplayPriority_Above1
)
Graphic3d_DisplayPriority_Above2 = (
    Graphic3d_DisplayPriority.Graphic3d_DisplayPriority_Above2
)
Graphic3d_DisplayPriority_Highlight = (
    Graphic3d_DisplayPriority.Graphic3d_DisplayPriority_Highlight
)
Graphic3d_DisplayPriority_Topmost = (
    Graphic3d_DisplayPriority.Graphic3d_DisplayPriority_Topmost
)

class Graphic3d_FrameStatsCounter(IntEnum):
    Graphic3d_FrameStatsCounter_NbLayers: int = ...
    Graphic3d_FrameStatsCounter_NbStructs: int = ...
    Graphic3d_FrameStatsCounter_EstimatedBytesGeom: int = ...
    Graphic3d_FrameStatsCounter_EstimatedBytesFbos: int = ...
    Graphic3d_FrameStatsCounter_EstimatedBytesTextures: int = ...
    Graphic3d_FrameStatsCounter_NbLayersNotCulled: int = ...
    Graphic3d_FrameStatsCounter_NbStructsNotCulled: int = ...
    Graphic3d_FrameStatsCounter_NbGroupsNotCulled: int = ...
    Graphic3d_FrameStatsCounter_NbElemsNotCulled: int = ...
    Graphic3d_FrameStatsCounter_NbElemsFillNotCulled: int = ...
    Graphic3d_FrameStatsCounter_NbElemsLineNotCulled: int = ...
    Graphic3d_FrameStatsCounter_NbElemsPointNotCulled: int = ...
    Graphic3d_FrameStatsCounter_NbElemsTextNotCulled: int = ...
    Graphic3d_FrameStatsCounter_NbTrianglesNotCulled: int = ...
    Graphic3d_FrameStatsCounter_NbLinesNotCulled: int = ...
    Graphic3d_FrameStatsCounter_NbPointsNotCulled: int = ...
    Graphic3d_FrameStatsCounter_NbLayersImmediate: int = ...
    Graphic3d_FrameStatsCounter_NbStructsImmediate: int = ...
    Graphic3d_FrameStatsCounter_NbGroupsImmediate: int = ...
    Graphic3d_FrameStatsCounter_NbElemsImmediate: int = ...
    Graphic3d_FrameStatsCounter_NbElemsFillImmediate: int = ...
    Graphic3d_FrameStatsCounter_NbElemsLineImmediate: int = ...
    Graphic3d_FrameStatsCounter_NbElemsPointImmediate: int = ...
    Graphic3d_FrameStatsCounter_NbElemsTextImmediate: int = ...
    Graphic3d_FrameStatsCounter_NbTrianglesImmediate: int = ...
    Graphic3d_FrameStatsCounter_NbLinesImmediate: int = ...
    Graphic3d_FrameStatsCounter_NbPointsImmediate: int = ...

Graphic3d_FrameStatsCounter_NbLayers = (
    Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbLayers
)
Graphic3d_FrameStatsCounter_NbStructs = (
    Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbStructs
)
Graphic3d_FrameStatsCounter_EstimatedBytesGeom = (
    Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_EstimatedBytesGeom
)
Graphic3d_FrameStatsCounter_EstimatedBytesFbos = (
    Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_EstimatedBytesFbos
)
Graphic3d_FrameStatsCounter_EstimatedBytesTextures = (
    Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_EstimatedBytesTextures
)
Graphic3d_FrameStatsCounter_NbLayersNotCulled = (
    Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbLayersNotCulled
)
Graphic3d_FrameStatsCounter_NbStructsNotCulled = (
    Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbStructsNotCulled
)
Graphic3d_FrameStatsCounter_NbGroupsNotCulled = (
    Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbGroupsNotCulled
)
Graphic3d_FrameStatsCounter_NbElemsNotCulled = (
    Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbElemsNotCulled
)
Graphic3d_FrameStatsCounter_NbElemsFillNotCulled = (
    Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbElemsFillNotCulled
)
Graphic3d_FrameStatsCounter_NbElemsLineNotCulled = (
    Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbElemsLineNotCulled
)
Graphic3d_FrameStatsCounter_NbElemsPointNotCulled = (
    Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbElemsPointNotCulled
)
Graphic3d_FrameStatsCounter_NbElemsTextNotCulled = (
    Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbElemsTextNotCulled
)
Graphic3d_FrameStatsCounter_NbTrianglesNotCulled = (
    Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbTrianglesNotCulled
)
Graphic3d_FrameStatsCounter_NbLinesNotCulled = (
    Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbLinesNotCulled
)
Graphic3d_FrameStatsCounter_NbPointsNotCulled = (
    Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbPointsNotCulled
)
Graphic3d_FrameStatsCounter_NbLayersImmediate = (
    Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbLayersImmediate
)
Graphic3d_FrameStatsCounter_NbStructsImmediate = (
    Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbStructsImmediate
)
Graphic3d_FrameStatsCounter_NbGroupsImmediate = (
    Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbGroupsImmediate
)
Graphic3d_FrameStatsCounter_NbElemsImmediate = (
    Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbElemsImmediate
)
Graphic3d_FrameStatsCounter_NbElemsFillImmediate = (
    Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbElemsFillImmediate
)
Graphic3d_FrameStatsCounter_NbElemsLineImmediate = (
    Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbElemsLineImmediate
)
Graphic3d_FrameStatsCounter_NbElemsPointImmediate = (
    Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbElemsPointImmediate
)
Graphic3d_FrameStatsCounter_NbElemsTextImmediate = (
    Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbElemsTextImmediate
)
Graphic3d_FrameStatsCounter_NbTrianglesImmediate = (
    Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbTrianglesImmediate
)
Graphic3d_FrameStatsCounter_NbLinesImmediate = (
    Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbLinesImmediate
)
Graphic3d_FrameStatsCounter_NbPointsImmediate = (
    Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbPointsImmediate
)

class Graphic3d_FrameStatsTimer(IntEnum):
    Graphic3d_FrameStatsTimer_ElapsedFrame: int = ...
    Graphic3d_FrameStatsTimer_CpuFrame: int = ...
    Graphic3d_FrameStatsTimer_CpuCulling: int = ...
    Graphic3d_FrameStatsTimer_CpuPicking: int = ...
    Graphic3d_FrameStatsTimer_CpuDynamics: int = ...

Graphic3d_FrameStatsTimer_ElapsedFrame = (
    Graphic3d_FrameStatsTimer.Graphic3d_FrameStatsTimer_ElapsedFrame
)
Graphic3d_FrameStatsTimer_CpuFrame = (
    Graphic3d_FrameStatsTimer.Graphic3d_FrameStatsTimer_CpuFrame
)
Graphic3d_FrameStatsTimer_CpuCulling = (
    Graphic3d_FrameStatsTimer.Graphic3d_FrameStatsTimer_CpuCulling
)
Graphic3d_FrameStatsTimer_CpuPicking = (
    Graphic3d_FrameStatsTimer.Graphic3d_FrameStatsTimer_CpuPicking
)
Graphic3d_FrameStatsTimer_CpuDynamics = (
    Graphic3d_FrameStatsTimer.Graphic3d_FrameStatsTimer_CpuDynamics
)

class Graphic3d_GroupAspect(IntEnum):
    Graphic3d_ASPECT_LINE: int = ...
    Graphic3d_ASPECT_TEXT: int = ...
    Graphic3d_ASPECT_MARKER: int = ...
    Graphic3d_ASPECT_FILL_AREA: int = ...

Graphic3d_ASPECT_LINE = Graphic3d_GroupAspect.Graphic3d_ASPECT_LINE
Graphic3d_ASPECT_TEXT = Graphic3d_GroupAspect.Graphic3d_ASPECT_TEXT
Graphic3d_ASPECT_MARKER = Graphic3d_GroupAspect.Graphic3d_ASPECT_MARKER
Graphic3d_ASPECT_FILL_AREA = Graphic3d_GroupAspect.Graphic3d_ASPECT_FILL_AREA

class Graphic3d_HorizontalTextAlignment(IntEnum):
    Graphic3d_HTA_LEFT: int = ...
    Graphic3d_HTA_CENTER: int = ...
    Graphic3d_HTA_RIGHT: int = ...

Graphic3d_HTA_LEFT = Graphic3d_HorizontalTextAlignment.Graphic3d_HTA_LEFT
Graphic3d_HTA_CENTER = Graphic3d_HorizontalTextAlignment.Graphic3d_HTA_CENTER
Graphic3d_HTA_RIGHT = Graphic3d_HorizontalTextAlignment.Graphic3d_HTA_RIGHT

class Graphic3d_LevelOfTextureAnisotropy(IntEnum):
    Graphic3d_LOTA_OFF: int = ...
    Graphic3d_LOTA_FAST: int = ...
    Graphic3d_LOTA_MIDDLE: int = ...
    Graphic3d_LOTA_QUALITY: int = ...

Graphic3d_LOTA_OFF = Graphic3d_LevelOfTextureAnisotropy.Graphic3d_LOTA_OFF
Graphic3d_LOTA_FAST = Graphic3d_LevelOfTextureAnisotropy.Graphic3d_LOTA_FAST
Graphic3d_LOTA_MIDDLE = Graphic3d_LevelOfTextureAnisotropy.Graphic3d_LOTA_MIDDLE
Graphic3d_LOTA_QUALITY = Graphic3d_LevelOfTextureAnisotropy.Graphic3d_LOTA_QUALITY

class Graphic3d_NameOfMaterial(IntEnum):
    Graphic3d_NameOfMaterial_Brass: int = ...
    Graphic3d_NameOfMaterial_Bronze: int = ...
    Graphic3d_NameOfMaterial_Copper: int = ...
    Graphic3d_NameOfMaterial_Gold: int = ...
    Graphic3d_NameOfMaterial_Pewter: int = ...
    Graphic3d_NameOfMaterial_Plastered: int = ...
    Graphic3d_NameOfMaterial_Plastified: int = ...
    Graphic3d_NameOfMaterial_Silver: int = ...
    Graphic3d_NameOfMaterial_Steel: int = ...
    Graphic3d_NameOfMaterial_Stone: int = ...
    Graphic3d_NameOfMaterial_ShinyPlastified: int = ...
    Graphic3d_NameOfMaterial_Satin: int = ...
    Graphic3d_NameOfMaterial_Metalized: int = ...
    Graphic3d_NameOfMaterial_Ionized: int = ...
    Graphic3d_NameOfMaterial_Chrome: int = ...
    Graphic3d_NameOfMaterial_Aluminum: int = ...
    Graphic3d_NameOfMaterial_Obsidian: int = ...
    Graphic3d_NameOfMaterial_Neon: int = ...
    Graphic3d_NameOfMaterial_Jade: int = ...
    Graphic3d_NameOfMaterial_Charcoal: int = ...
    Graphic3d_NameOfMaterial_Water: int = ...
    Graphic3d_NameOfMaterial_Glass: int = ...
    Graphic3d_NameOfMaterial_Diamond: int = ...
    Graphic3d_NameOfMaterial_Transparent: int = ...
    Graphic3d_NameOfMaterial_DEFAULT: int = ...
    Graphic3d_NameOfMaterial_UserDefined: int = ...
    Graphic3d_NOM_BRASS: int = ...
    Graphic3d_NOM_BRONZE: int = ...
    Graphic3d_NOM_COPPER: int = ...
    Graphic3d_NOM_GOLD: int = ...
    Graphic3d_NOM_PEWTER: int = ...
    Graphic3d_NOM_PLASTER: int = ...
    Graphic3d_NOM_PLASTIC: int = ...
    Graphic3d_NOM_SILVER: int = ...
    Graphic3d_NOM_STEEL: int = ...
    Graphic3d_NOM_STONE: int = ...
    Graphic3d_NOM_SHINY_PLASTIC: int = ...
    Graphic3d_NOM_SATIN: int = ...
    Graphic3d_NOM_METALIZED: int = ...
    Graphic3d_NOM_NEON_GNC: int = ...
    Graphic3d_NOM_CHROME: int = ...
    Graphic3d_NOM_ALUMINIUM: int = ...
    Graphic3d_NOM_OBSIDIAN: int = ...
    Graphic3d_NOM_NEON_PHC: int = ...
    Graphic3d_NOM_JADE: int = ...
    Graphic3d_NOM_CHARCOAL: int = ...
    Graphic3d_NOM_WATER: int = ...
    Graphic3d_NOM_GLASS: int = ...
    Graphic3d_NOM_DIAMOND: int = ...
    Graphic3d_NOM_TRANSPARENT: int = ...
    Graphic3d_NOM_DEFAULT: int = ...
    Graphic3d_NOM_UserDefined: int = ...

Graphic3d_NameOfMaterial_Brass = Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Brass
Graphic3d_NameOfMaterial_Bronze = (
    Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Bronze
)
Graphic3d_NameOfMaterial_Copper = (
    Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Copper
)
Graphic3d_NameOfMaterial_Gold = Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Gold
Graphic3d_NameOfMaterial_Pewter = (
    Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Pewter
)
Graphic3d_NameOfMaterial_Plastered = (
    Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Plastered
)
Graphic3d_NameOfMaterial_Plastified = (
    Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Plastified
)
Graphic3d_NameOfMaterial_Silver = (
    Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Silver
)
Graphic3d_NameOfMaterial_Steel = Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Steel
Graphic3d_NameOfMaterial_Stone = Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Stone
Graphic3d_NameOfMaterial_ShinyPlastified = (
    Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_ShinyPlastified
)
Graphic3d_NameOfMaterial_Satin = Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Satin
Graphic3d_NameOfMaterial_Metalized = (
    Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Metalized
)
Graphic3d_NameOfMaterial_Ionized = (
    Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Ionized
)
Graphic3d_NameOfMaterial_Chrome = (
    Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Chrome
)
Graphic3d_NameOfMaterial_Aluminum = (
    Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Aluminum
)
Graphic3d_NameOfMaterial_Obsidian = (
    Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Obsidian
)
Graphic3d_NameOfMaterial_Neon = Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Neon
Graphic3d_NameOfMaterial_Jade = Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Jade
Graphic3d_NameOfMaterial_Charcoal = (
    Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Charcoal
)
Graphic3d_NameOfMaterial_Water = Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Water
Graphic3d_NameOfMaterial_Glass = Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Glass
Graphic3d_NameOfMaterial_Diamond = (
    Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Diamond
)
Graphic3d_NameOfMaterial_Transparent = (
    Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Transparent
)
Graphic3d_NameOfMaterial_DEFAULT = (
    Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_DEFAULT
)
Graphic3d_NameOfMaterial_UserDefined = (
    Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_UserDefined
)
Graphic3d_NOM_BRASS = Graphic3d_NameOfMaterial.Graphic3d_NOM_BRASS
Graphic3d_NOM_BRONZE = Graphic3d_NameOfMaterial.Graphic3d_NOM_BRONZE
Graphic3d_NOM_COPPER = Graphic3d_NameOfMaterial.Graphic3d_NOM_COPPER
Graphic3d_NOM_GOLD = Graphic3d_NameOfMaterial.Graphic3d_NOM_GOLD
Graphic3d_NOM_PEWTER = Graphic3d_NameOfMaterial.Graphic3d_NOM_PEWTER
Graphic3d_NOM_PLASTER = Graphic3d_NameOfMaterial.Graphic3d_NOM_PLASTER
Graphic3d_NOM_PLASTIC = Graphic3d_NameOfMaterial.Graphic3d_NOM_PLASTIC
Graphic3d_NOM_SILVER = Graphic3d_NameOfMaterial.Graphic3d_NOM_SILVER
Graphic3d_NOM_STEEL = Graphic3d_NameOfMaterial.Graphic3d_NOM_STEEL
Graphic3d_NOM_STONE = Graphic3d_NameOfMaterial.Graphic3d_NOM_STONE
Graphic3d_NOM_SHINY_PLASTIC = Graphic3d_NameOfMaterial.Graphic3d_NOM_SHINY_PLASTIC
Graphic3d_NOM_SATIN = Graphic3d_NameOfMaterial.Graphic3d_NOM_SATIN
Graphic3d_NOM_METALIZED = Graphic3d_NameOfMaterial.Graphic3d_NOM_METALIZED
Graphic3d_NOM_NEON_GNC = Graphic3d_NameOfMaterial.Graphic3d_NOM_NEON_GNC
Graphic3d_NOM_CHROME = Graphic3d_NameOfMaterial.Graphic3d_NOM_CHROME
Graphic3d_NOM_ALUMINIUM = Graphic3d_NameOfMaterial.Graphic3d_NOM_ALUMINIUM
Graphic3d_NOM_OBSIDIAN = Graphic3d_NameOfMaterial.Graphic3d_NOM_OBSIDIAN
Graphic3d_NOM_NEON_PHC = Graphic3d_NameOfMaterial.Graphic3d_NOM_NEON_PHC
Graphic3d_NOM_JADE = Graphic3d_NameOfMaterial.Graphic3d_NOM_JADE
Graphic3d_NOM_CHARCOAL = Graphic3d_NameOfMaterial.Graphic3d_NOM_CHARCOAL
Graphic3d_NOM_WATER = Graphic3d_NameOfMaterial.Graphic3d_NOM_WATER
Graphic3d_NOM_GLASS = Graphic3d_NameOfMaterial.Graphic3d_NOM_GLASS
Graphic3d_NOM_DIAMOND = Graphic3d_NameOfMaterial.Graphic3d_NOM_DIAMOND
Graphic3d_NOM_TRANSPARENT = Graphic3d_NameOfMaterial.Graphic3d_NOM_TRANSPARENT
Graphic3d_NOM_DEFAULT = Graphic3d_NameOfMaterial.Graphic3d_NOM_DEFAULT
Graphic3d_NOM_UserDefined = Graphic3d_NameOfMaterial.Graphic3d_NOM_UserDefined

class Graphic3d_NameOfTexture1D(IntEnum):
    Graphic3d_NOT_1D_ELEVATION: int = ...
    Graphic3d_NOT_1D_UNKNOWN: int = ...

Graphic3d_NOT_1D_ELEVATION = Graphic3d_NameOfTexture1D.Graphic3d_NOT_1D_ELEVATION
Graphic3d_NOT_1D_UNKNOWN = Graphic3d_NameOfTexture1D.Graphic3d_NOT_1D_UNKNOWN

class Graphic3d_NameOfTexture2D(IntEnum):
    Graphic3d_NOT_2D_MATRA: int = ...
    Graphic3d_NOT_2D_ALIENSKIN: int = ...
    Graphic3d_NOT_2D_BLUE_ROCK: int = ...
    Graphic3d_NOT_2D_BLUEWHITE_PAPER: int = ...
    Graphic3d_NOT_2D_BRUSHED: int = ...
    Graphic3d_NOT_2D_BUBBLES: int = ...
    Graphic3d_NOT_2D_BUMP: int = ...
    Graphic3d_NOT_2D_CAST: int = ...
    Graphic3d_NOT_2D_CHIPBD: int = ...
    Graphic3d_NOT_2D_CLOUDS: int = ...
    Graphic3d_NOT_2D_FLESH: int = ...
    Graphic3d_NOT_2D_FLOOR: int = ...
    Graphic3d_NOT_2D_GALVNISD: int = ...
    Graphic3d_NOT_2D_GRASS: int = ...
    Graphic3d_NOT_2D_ALUMINUM: int = ...
    Graphic3d_NOT_2D_ROCK: int = ...
    Graphic3d_NOT_2D_KNURL: int = ...
    Graphic3d_NOT_2D_MAPLE: int = ...
    Graphic3d_NOT_2D_MARBLE: int = ...
    Graphic3d_NOT_2D_MOTTLED: int = ...
    Graphic3d_NOT_2D_RAIN: int = ...
    Graphic3d_NOT_2D_CHESS: int = ...
    Graphic3d_NOT_2D_UNKNOWN: int = ...

Graphic3d_NOT_2D_MATRA = Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_MATRA
Graphic3d_NOT_2D_ALIENSKIN = Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_ALIENSKIN
Graphic3d_NOT_2D_BLUE_ROCK = Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_BLUE_ROCK
Graphic3d_NOT_2D_BLUEWHITE_PAPER = (
    Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_BLUEWHITE_PAPER
)
Graphic3d_NOT_2D_BRUSHED = Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_BRUSHED
Graphic3d_NOT_2D_BUBBLES = Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_BUBBLES
Graphic3d_NOT_2D_BUMP = Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_BUMP
Graphic3d_NOT_2D_CAST = Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_CAST
Graphic3d_NOT_2D_CHIPBD = Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_CHIPBD
Graphic3d_NOT_2D_CLOUDS = Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_CLOUDS
Graphic3d_NOT_2D_FLESH = Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_FLESH
Graphic3d_NOT_2D_FLOOR = Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_FLOOR
Graphic3d_NOT_2D_GALVNISD = Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_GALVNISD
Graphic3d_NOT_2D_GRASS = Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_GRASS
Graphic3d_NOT_2D_ALUMINUM = Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_ALUMINUM
Graphic3d_NOT_2D_ROCK = Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_ROCK
Graphic3d_NOT_2D_KNURL = Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_KNURL
Graphic3d_NOT_2D_MAPLE = Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_MAPLE
Graphic3d_NOT_2D_MARBLE = Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_MARBLE
Graphic3d_NOT_2D_MOTTLED = Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_MOTTLED
Graphic3d_NOT_2D_RAIN = Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_RAIN
Graphic3d_NOT_2D_CHESS = Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_CHESS
Graphic3d_NOT_2D_UNKNOWN = Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_UNKNOWN

class Graphic3d_NameOfTextureEnv(IntEnum):
    Graphic3d_NOT_ENV_CLOUDS: int = ...
    Graphic3d_NOT_ENV_CV: int = ...
    Graphic3d_NOT_ENV_MEDIT: int = ...
    Graphic3d_NOT_ENV_PEARL: int = ...
    Graphic3d_NOT_ENV_SKY1: int = ...
    Graphic3d_NOT_ENV_SKY2: int = ...
    Graphic3d_NOT_ENV_LINES: int = ...
    Graphic3d_NOT_ENV_ROAD: int = ...
    Graphic3d_NOT_ENV_UNKNOWN: int = ...

Graphic3d_NOT_ENV_CLOUDS = Graphic3d_NameOfTextureEnv.Graphic3d_NOT_ENV_CLOUDS
Graphic3d_NOT_ENV_CV = Graphic3d_NameOfTextureEnv.Graphic3d_NOT_ENV_CV
Graphic3d_NOT_ENV_MEDIT = Graphic3d_NameOfTextureEnv.Graphic3d_NOT_ENV_MEDIT
Graphic3d_NOT_ENV_PEARL = Graphic3d_NameOfTextureEnv.Graphic3d_NOT_ENV_PEARL
Graphic3d_NOT_ENV_SKY1 = Graphic3d_NameOfTextureEnv.Graphic3d_NOT_ENV_SKY1
Graphic3d_NOT_ENV_SKY2 = Graphic3d_NameOfTextureEnv.Graphic3d_NOT_ENV_SKY2
Graphic3d_NOT_ENV_LINES = Graphic3d_NameOfTextureEnv.Graphic3d_NOT_ENV_LINES
Graphic3d_NOT_ENV_ROAD = Graphic3d_NameOfTextureEnv.Graphic3d_NOT_ENV_ROAD
Graphic3d_NOT_ENV_UNKNOWN = Graphic3d_NameOfTextureEnv.Graphic3d_NOT_ENV_UNKNOWN

class Graphic3d_NameOfTexturePlane(IntEnum):
    Graphic3d_NOTP_XY: int = ...
    Graphic3d_NOTP_YZ: int = ...
    Graphic3d_NOTP_ZX: int = ...
    Graphic3d_NOTP_UNKNOWN: int = ...

Graphic3d_NOTP_XY = Graphic3d_NameOfTexturePlane.Graphic3d_NOTP_XY
Graphic3d_NOTP_YZ = Graphic3d_NameOfTexturePlane.Graphic3d_NOTP_YZ
Graphic3d_NOTP_ZX = Graphic3d_NameOfTexturePlane.Graphic3d_NOTP_ZX
Graphic3d_NOTP_UNKNOWN = Graphic3d_NameOfTexturePlane.Graphic3d_NOTP_UNKNOWN

class Graphic3d_RenderTransparentMethod(IntEnum):
    Graphic3d_RTM_BLEND_UNORDERED: int = ...
    Graphic3d_RTM_BLEND_OIT: int = ...
    Graphic3d_RTM_DEPTH_PEELING_OIT: int = ...

Graphic3d_RTM_BLEND_UNORDERED = (
    Graphic3d_RenderTransparentMethod.Graphic3d_RTM_BLEND_UNORDERED
)
Graphic3d_RTM_BLEND_OIT = Graphic3d_RenderTransparentMethod.Graphic3d_RTM_BLEND_OIT
Graphic3d_RTM_DEPTH_PEELING_OIT = (
    Graphic3d_RenderTransparentMethod.Graphic3d_RTM_DEPTH_PEELING_OIT
)

class Graphic3d_RenderingMode(IntEnum):
    Graphic3d_RM_RASTERIZATION: int = ...
    Graphic3d_RM_RAYTRACING: int = ...

Graphic3d_RM_RASTERIZATION = Graphic3d_RenderingMode.Graphic3d_RM_RASTERIZATION
Graphic3d_RM_RAYTRACING = Graphic3d_RenderingMode.Graphic3d_RM_RAYTRACING

class Graphic3d_ShaderFlags(IntEnum):
    Graphic3d_ShaderFlags_VertColor: int = ...
    Graphic3d_ShaderFlags_TextureRGB: int = ...
    Graphic3d_ShaderFlags_TextureEnv: int = ...
    Graphic3d_ShaderFlags_TextureNormal: int = ...
    Graphic3d_ShaderFlags_PointSimple: int = ...
    Graphic3d_ShaderFlags_PointSprite: int = ...
    Graphic3d_ShaderFlags_PointSpriteA: int = ...
    Graphic3d_ShaderFlags_StippleLine: int = ...
    Graphic3d_ShaderFlags_ClipPlanes1: int = ...
    Graphic3d_ShaderFlags_ClipPlanes2: int = ...
    Graphic3d_ShaderFlags_ClipPlanesN: int = ...
    Graphic3d_ShaderFlags_ClipChains: int = ...
    Graphic3d_ShaderFlags_MeshEdges: int = ...
    Graphic3d_ShaderFlags_AlphaTest: int = ...
    Graphic3d_ShaderFlags_WriteOit: int = ...
    Graphic3d_ShaderFlags_OitDepthPeeling: int = ...
    Graphic3d_ShaderFlags_NB: int = ...
    Graphic3d_ShaderFlags_IsPoint: int = ...
    Graphic3d_ShaderFlags_HasTextures: int = ...
    Graphic3d_ShaderFlags_NeedsGeomShader: int = ...

Graphic3d_ShaderFlags_VertColor = Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_VertColor
Graphic3d_ShaderFlags_TextureRGB = (
    Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_TextureRGB
)
Graphic3d_ShaderFlags_TextureEnv = (
    Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_TextureEnv
)
Graphic3d_ShaderFlags_TextureNormal = (
    Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_TextureNormal
)
Graphic3d_ShaderFlags_PointSimple = (
    Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_PointSimple
)
Graphic3d_ShaderFlags_PointSprite = (
    Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_PointSprite
)
Graphic3d_ShaderFlags_PointSpriteA = (
    Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_PointSpriteA
)
Graphic3d_ShaderFlags_StippleLine = (
    Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_StippleLine
)
Graphic3d_ShaderFlags_ClipPlanes1 = (
    Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_ClipPlanes1
)
Graphic3d_ShaderFlags_ClipPlanes2 = (
    Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_ClipPlanes2
)
Graphic3d_ShaderFlags_ClipPlanesN = (
    Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_ClipPlanesN
)
Graphic3d_ShaderFlags_ClipChains = (
    Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_ClipChains
)
Graphic3d_ShaderFlags_MeshEdges = Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_MeshEdges
Graphic3d_ShaderFlags_AlphaTest = Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_AlphaTest
Graphic3d_ShaderFlags_WriteOit = Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_WriteOit
Graphic3d_ShaderFlags_OitDepthPeeling = (
    Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_OitDepthPeeling
)
Graphic3d_ShaderFlags_NB = Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_NB
Graphic3d_ShaderFlags_IsPoint = Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_IsPoint
Graphic3d_ShaderFlags_HasTextures = (
    Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_HasTextures
)
Graphic3d_ShaderFlags_NeedsGeomShader = (
    Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_NeedsGeomShader
)

class Graphic3d_GlslExtension(IntEnum):
    Graphic3d_GlslExtension_GL_OES_standard_derivatives: int = ...
    Graphic3d_GlslExtension_GL_EXT_shader_texture_lod: int = ...
    Graphic3d_GlslExtension_GL_EXT_frag_depth: int = ...
    Graphic3d_GlslExtension_GL_EXT_gpu_shader4: int = ...

Graphic3d_GlslExtension_GL_OES_standard_derivatives = (
    Graphic3d_GlslExtension.Graphic3d_GlslExtension_GL_OES_standard_derivatives
)
Graphic3d_GlslExtension_GL_EXT_shader_texture_lod = (
    Graphic3d_GlslExtension.Graphic3d_GlslExtension_GL_EXT_shader_texture_lod
)
Graphic3d_GlslExtension_GL_EXT_frag_depth = (
    Graphic3d_GlslExtension.Graphic3d_GlslExtension_GL_EXT_frag_depth
)
Graphic3d_GlslExtension_GL_EXT_gpu_shader4 = (
    Graphic3d_GlslExtension.Graphic3d_GlslExtension_GL_EXT_gpu_shader4
)

class Graphic3d_StereoMode(IntEnum):
    Graphic3d_StereoMode_QuadBuffer: int = ...
    Graphic3d_StereoMode_Anaglyph: int = ...
    Graphic3d_StereoMode_RowInterlaced: int = ...
    Graphic3d_StereoMode_ColumnInterlaced: int = ...
    Graphic3d_StereoMode_ChessBoard: int = ...
    Graphic3d_StereoMode_SideBySide: int = ...
    Graphic3d_StereoMode_OverUnder: int = ...
    Graphic3d_StereoMode_SoftPageFlip: int = ...
    Graphic3d_StereoMode_OpenVR: int = ...

Graphic3d_StereoMode_QuadBuffer = Graphic3d_StereoMode.Graphic3d_StereoMode_QuadBuffer
Graphic3d_StereoMode_Anaglyph = Graphic3d_StereoMode.Graphic3d_StereoMode_Anaglyph
Graphic3d_StereoMode_RowInterlaced = (
    Graphic3d_StereoMode.Graphic3d_StereoMode_RowInterlaced
)
Graphic3d_StereoMode_ColumnInterlaced = (
    Graphic3d_StereoMode.Graphic3d_StereoMode_ColumnInterlaced
)
Graphic3d_StereoMode_ChessBoard = Graphic3d_StereoMode.Graphic3d_StereoMode_ChessBoard
Graphic3d_StereoMode_SideBySide = Graphic3d_StereoMode.Graphic3d_StereoMode_SideBySide
Graphic3d_StereoMode_OverUnder = Graphic3d_StereoMode.Graphic3d_StereoMode_OverUnder
Graphic3d_StereoMode_SoftPageFlip = (
    Graphic3d_StereoMode.Graphic3d_StereoMode_SoftPageFlip
)
Graphic3d_StereoMode_OpenVR = Graphic3d_StereoMode.Graphic3d_StereoMode_OpenVR

class Graphic3d_TextPath(IntEnum):
    Graphic3d_TP_UP: int = ...
    Graphic3d_TP_DOWN: int = ...
    Graphic3d_TP_LEFT: int = ...
    Graphic3d_TP_RIGHT: int = ...

Graphic3d_TP_UP = Graphic3d_TextPath.Graphic3d_TP_UP
Graphic3d_TP_DOWN = Graphic3d_TextPath.Graphic3d_TP_DOWN
Graphic3d_TP_LEFT = Graphic3d_TextPath.Graphic3d_TP_LEFT
Graphic3d_TP_RIGHT = Graphic3d_TextPath.Graphic3d_TP_RIGHT

class Graphic3d_TextureSetBits(IntEnum):
    Graphic3d_TextureSetBits_NONE: int = ...
    Graphic3d_TextureSetBits_BaseColor: int = ...
    Graphic3d_TextureSetBits_Emissive: int = ...
    Graphic3d_TextureSetBits_Occlusion: int = ...
    Graphic3d_TextureSetBits_Normal: int = ...
    Graphic3d_TextureSetBits_MetallicRoughness: int = ...

Graphic3d_TextureSetBits_NONE = Graphic3d_TextureSetBits.Graphic3d_TextureSetBits_NONE
Graphic3d_TextureSetBits_BaseColor = (
    Graphic3d_TextureSetBits.Graphic3d_TextureSetBits_BaseColor
)
Graphic3d_TextureSetBits_Emissive = (
    Graphic3d_TextureSetBits.Graphic3d_TextureSetBits_Emissive
)
Graphic3d_TextureSetBits_Occlusion = (
    Graphic3d_TextureSetBits.Graphic3d_TextureSetBits_Occlusion
)
Graphic3d_TextureSetBits_Normal = (
    Graphic3d_TextureSetBits.Graphic3d_TextureSetBits_Normal
)
Graphic3d_TextureSetBits_MetallicRoughness = (
    Graphic3d_TextureSetBits.Graphic3d_TextureSetBits_MetallicRoughness
)

class Graphic3d_TextureUnit(IntEnum):
    Graphic3d_TextureUnit_0: int = ...
    Graphic3d_TextureUnit_1: int = ...
    Graphic3d_TextureUnit_2: int = ...
    Graphic3d_TextureUnit_3: int = ...
    Graphic3d_TextureUnit_4: int = ...
    Graphic3d_TextureUnit_5: int = ...
    Graphic3d_TextureUnit_6: int = ...
    Graphic3d_TextureUnit_7: int = ...
    Graphic3d_TextureUnit_8: int = ...
    Graphic3d_TextureUnit_9: int = ...
    Graphic3d_TextureUnit_10: int = ...
    Graphic3d_TextureUnit_11: int = ...
    Graphic3d_TextureUnit_12: int = ...
    Graphic3d_TextureUnit_13: int = ...
    Graphic3d_TextureUnit_14: int = ...
    Graphic3d_TextureUnit_15: int = ...
    Graphic3d_TextureUnit_BaseColor: int = ...
    Graphic3d_TextureUnit_Emissive: int = ...
    Graphic3d_TextureUnit_Occlusion: int = ...
    Graphic3d_TextureUnit_Normal: int = ...
    Graphic3d_TextureUnit_MetallicRoughness: int = ...
    Graphic3d_TextureUnit_EnvMap: int = ...
    Graphic3d_TextureUnit_PointSprite: int = ...
    Graphic3d_TextureUnit_DepthPeelingDepth: int = ...
    Graphic3d_TextureUnit_DepthPeelingFrontColor: int = ...
    Graphic3d_TextureUnit_ShadowMap: int = ...
    Graphic3d_TextureUnit_PbrEnvironmentLUT: int = ...
    Graphic3d_TextureUnit_PbrIblDiffuseSH: int = ...
    Graphic3d_TextureUnit_PbrIblSpecular: int = ...

Graphic3d_TextureUnit_0 = Graphic3d_TextureUnit.Graphic3d_TextureUnit_0
Graphic3d_TextureUnit_1 = Graphic3d_TextureUnit.Graphic3d_TextureUnit_1
Graphic3d_TextureUnit_2 = Graphic3d_TextureUnit.Graphic3d_TextureUnit_2
Graphic3d_TextureUnit_3 = Graphic3d_TextureUnit.Graphic3d_TextureUnit_3
Graphic3d_TextureUnit_4 = Graphic3d_TextureUnit.Graphic3d_TextureUnit_4
Graphic3d_TextureUnit_5 = Graphic3d_TextureUnit.Graphic3d_TextureUnit_5
Graphic3d_TextureUnit_6 = Graphic3d_TextureUnit.Graphic3d_TextureUnit_6
Graphic3d_TextureUnit_7 = Graphic3d_TextureUnit.Graphic3d_TextureUnit_7
Graphic3d_TextureUnit_8 = Graphic3d_TextureUnit.Graphic3d_TextureUnit_8
Graphic3d_TextureUnit_9 = Graphic3d_TextureUnit.Graphic3d_TextureUnit_9
Graphic3d_TextureUnit_10 = Graphic3d_TextureUnit.Graphic3d_TextureUnit_10
Graphic3d_TextureUnit_11 = Graphic3d_TextureUnit.Graphic3d_TextureUnit_11
Graphic3d_TextureUnit_12 = Graphic3d_TextureUnit.Graphic3d_TextureUnit_12
Graphic3d_TextureUnit_13 = Graphic3d_TextureUnit.Graphic3d_TextureUnit_13
Graphic3d_TextureUnit_14 = Graphic3d_TextureUnit.Graphic3d_TextureUnit_14
Graphic3d_TextureUnit_15 = Graphic3d_TextureUnit.Graphic3d_TextureUnit_15
Graphic3d_TextureUnit_BaseColor = Graphic3d_TextureUnit.Graphic3d_TextureUnit_BaseColor
Graphic3d_TextureUnit_Emissive = Graphic3d_TextureUnit.Graphic3d_TextureUnit_Emissive
Graphic3d_TextureUnit_Occlusion = Graphic3d_TextureUnit.Graphic3d_TextureUnit_Occlusion
Graphic3d_TextureUnit_Normal = Graphic3d_TextureUnit.Graphic3d_TextureUnit_Normal
Graphic3d_TextureUnit_MetallicRoughness = (
    Graphic3d_TextureUnit.Graphic3d_TextureUnit_MetallicRoughness
)
Graphic3d_TextureUnit_EnvMap = Graphic3d_TextureUnit.Graphic3d_TextureUnit_EnvMap
Graphic3d_TextureUnit_PointSprite = (
    Graphic3d_TextureUnit.Graphic3d_TextureUnit_PointSprite
)
Graphic3d_TextureUnit_DepthPeelingDepth = (
    Graphic3d_TextureUnit.Graphic3d_TextureUnit_DepthPeelingDepth
)
Graphic3d_TextureUnit_DepthPeelingFrontColor = (
    Graphic3d_TextureUnit.Graphic3d_TextureUnit_DepthPeelingFrontColor
)
Graphic3d_TextureUnit_ShadowMap = Graphic3d_TextureUnit.Graphic3d_TextureUnit_ShadowMap
Graphic3d_TextureUnit_PbrEnvironmentLUT = (
    Graphic3d_TextureUnit.Graphic3d_TextureUnit_PbrEnvironmentLUT
)
Graphic3d_TextureUnit_PbrIblDiffuseSH = (
    Graphic3d_TextureUnit.Graphic3d_TextureUnit_PbrIblDiffuseSH
)
Graphic3d_TextureUnit_PbrIblSpecular = (
    Graphic3d_TextureUnit.Graphic3d_TextureUnit_PbrIblSpecular
)

class Graphic3d_ToneMappingMethod(IntEnum):
    Graphic3d_ToneMappingMethod_Disabled: int = ...
    Graphic3d_ToneMappingMethod_Filmic: int = ...

Graphic3d_ToneMappingMethod_Disabled = (
    Graphic3d_ToneMappingMethod.Graphic3d_ToneMappingMethod_Disabled
)
Graphic3d_ToneMappingMethod_Filmic = (
    Graphic3d_ToneMappingMethod.Graphic3d_ToneMappingMethod_Filmic
)

class Graphic3d_TransModeFlags(IntEnum):
    Graphic3d_TMF_None: int = ...
    Graphic3d_TMF_ZoomPers: int = ...
    Graphic3d_TMF_RotatePers: int = ...
    Graphic3d_TMF_TriedronPers: int = ...
    Graphic3d_TMF_2d: int = ...
    Graphic3d_TMF_CameraPers: int = ...
    Graphic3d_TMF_OrthoPers: int = ...
    Graphic3d_TMF_AxialScalePers: int = ...
    Graphic3d_TMF_ZoomRotatePers: int = ...
    Graphic3d_TMF_AxialZoomPers: int = ...

Graphic3d_TMF_None = Graphic3d_TransModeFlags.Graphic3d_TMF_None
Graphic3d_TMF_ZoomPers = Graphic3d_TransModeFlags.Graphic3d_TMF_ZoomPers
Graphic3d_TMF_RotatePers = Graphic3d_TransModeFlags.Graphic3d_TMF_RotatePers
Graphic3d_TMF_TriedronPers = Graphic3d_TransModeFlags.Graphic3d_TMF_TriedronPers
Graphic3d_TMF_2d = Graphic3d_TransModeFlags.Graphic3d_TMF_2d
Graphic3d_TMF_CameraPers = Graphic3d_TransModeFlags.Graphic3d_TMF_CameraPers
Graphic3d_TMF_OrthoPers = Graphic3d_TransModeFlags.Graphic3d_TMF_OrthoPers
Graphic3d_TMF_AxialScalePers = Graphic3d_TransModeFlags.Graphic3d_TMF_AxialScalePers
Graphic3d_TMF_ZoomRotatePers = Graphic3d_TransModeFlags.Graphic3d_TMF_ZoomRotatePers
Graphic3d_TMF_AxialZoomPers = Graphic3d_TransModeFlags.Graphic3d_TMF_AxialZoomPers

class Graphic3d_TypeOfAnswer(IntEnum):
    Graphic3d_TOA_YES: int = ...
    Graphic3d_TOA_NO: int = ...
    Graphic3d_TOA_COMPUTE: int = ...

Graphic3d_TOA_YES = Graphic3d_TypeOfAnswer.Graphic3d_TOA_YES
Graphic3d_TOA_NO = Graphic3d_TypeOfAnswer.Graphic3d_TOA_NO
Graphic3d_TOA_COMPUTE = Graphic3d_TypeOfAnswer.Graphic3d_TOA_COMPUTE

class Graphic3d_TypeOfBackfacingModel(IntEnum):
    Graphic3d_TypeOfBackfacingModel_Auto: int = ...
    Graphic3d_TypeOfBackfacingModel_DoubleSided: int = ...
    Graphic3d_TypeOfBackfacingModel_BackCulled: int = ...
    Graphic3d_TypeOfBackfacingModel_FrontCulled: int = ...
    Graphic3d_TOBM_AUTOMATIC: int = ...
    Graphic3d_TOBM_FORCE: int = ...
    Graphic3d_TOBM_DISABLE: int = ...
    V3d_TOBM_AUTOMATIC: int = ...
    V3d_TOBM_ALWAYS_DISPLAYED: int = ...
    V3d_TOBM_NEVER_DISPLAYED: int = ...

Graphic3d_TypeOfBackfacingModel_Auto = (
    Graphic3d_TypeOfBackfacingModel.Graphic3d_TypeOfBackfacingModel_Auto
)
Graphic3d_TypeOfBackfacingModel_DoubleSided = (
    Graphic3d_TypeOfBackfacingModel.Graphic3d_TypeOfBackfacingModel_DoubleSided
)
Graphic3d_TypeOfBackfacingModel_BackCulled = (
    Graphic3d_TypeOfBackfacingModel.Graphic3d_TypeOfBackfacingModel_BackCulled
)
Graphic3d_TypeOfBackfacingModel_FrontCulled = (
    Graphic3d_TypeOfBackfacingModel.Graphic3d_TypeOfBackfacingModel_FrontCulled
)
Graphic3d_TOBM_AUTOMATIC = Graphic3d_TypeOfBackfacingModel.Graphic3d_TOBM_AUTOMATIC
Graphic3d_TOBM_FORCE = Graphic3d_TypeOfBackfacingModel.Graphic3d_TOBM_FORCE
Graphic3d_TOBM_DISABLE = Graphic3d_TypeOfBackfacingModel.Graphic3d_TOBM_DISABLE
V3d_TOBM_AUTOMATIC = Graphic3d_TypeOfBackfacingModel.V3d_TOBM_AUTOMATIC
V3d_TOBM_ALWAYS_DISPLAYED = Graphic3d_TypeOfBackfacingModel.V3d_TOBM_ALWAYS_DISPLAYED
V3d_TOBM_NEVER_DISPLAYED = Graphic3d_TypeOfBackfacingModel.V3d_TOBM_NEVER_DISPLAYED

class Graphic3d_TypeOfBackground(IntEnum):
    Graphic3d_TOB_NONE: int = ...
    Graphic3d_TOB_GRADIENT: int = ...
    Graphic3d_TOB_TEXTURE: int = ...
    Graphic3d_TOB_CUBEMAP: int = ...

Graphic3d_TOB_NONE = Graphic3d_TypeOfBackground.Graphic3d_TOB_NONE
Graphic3d_TOB_GRADIENT = Graphic3d_TypeOfBackground.Graphic3d_TOB_GRADIENT
Graphic3d_TOB_TEXTURE = Graphic3d_TypeOfBackground.Graphic3d_TOB_TEXTURE
Graphic3d_TOB_CUBEMAP = Graphic3d_TypeOfBackground.Graphic3d_TOB_CUBEMAP

class Graphic3d_TypeOfConnection(IntEnum):
    Graphic3d_TOC_ANCESTOR: int = ...
    Graphic3d_TOC_DESCENDANT: int = ...

Graphic3d_TOC_ANCESTOR = Graphic3d_TypeOfConnection.Graphic3d_TOC_ANCESTOR
Graphic3d_TOC_DESCENDANT = Graphic3d_TypeOfConnection.Graphic3d_TOC_DESCENDANT

class Graphic3d_TypeOfLightSource(IntEnum):
    Graphic3d_TypeOfLightSource_Ambient: int = ...
    Graphic3d_TypeOfLightSource_Directional: int = ...
    Graphic3d_TypeOfLightSource_Positional: int = ...
    Graphic3d_TypeOfLightSource_Spot: int = ...
    Graphic3d_TOLS_AMBIENT: int = ...
    Graphic3d_TOLS_DIRECTIONAL: int = ...
    Graphic3d_TOLS_POSITIONAL: int = ...
    Graphic3d_TOLS_SPOT: int = ...
    V3d_AMBIENT: int = ...
    V3d_DIRECTIONAL: int = ...
    V3d_POSITIONAL: int = ...
    V3d_SPOT: int = ...

Graphic3d_TypeOfLightSource_Ambient = (
    Graphic3d_TypeOfLightSource.Graphic3d_TypeOfLightSource_Ambient
)
Graphic3d_TypeOfLightSource_Directional = (
    Graphic3d_TypeOfLightSource.Graphic3d_TypeOfLightSource_Directional
)
Graphic3d_TypeOfLightSource_Positional = (
    Graphic3d_TypeOfLightSource.Graphic3d_TypeOfLightSource_Positional
)
Graphic3d_TypeOfLightSource_Spot = (
    Graphic3d_TypeOfLightSource.Graphic3d_TypeOfLightSource_Spot
)
Graphic3d_TOLS_AMBIENT = Graphic3d_TypeOfLightSource.Graphic3d_TOLS_AMBIENT
Graphic3d_TOLS_DIRECTIONAL = Graphic3d_TypeOfLightSource.Graphic3d_TOLS_DIRECTIONAL
Graphic3d_TOLS_POSITIONAL = Graphic3d_TypeOfLightSource.Graphic3d_TOLS_POSITIONAL
Graphic3d_TOLS_SPOT = Graphic3d_TypeOfLightSource.Graphic3d_TOLS_SPOT
V3d_AMBIENT = Graphic3d_TypeOfLightSource.V3d_AMBIENT
V3d_DIRECTIONAL = Graphic3d_TypeOfLightSource.V3d_DIRECTIONAL
V3d_POSITIONAL = Graphic3d_TypeOfLightSource.V3d_POSITIONAL
V3d_SPOT = Graphic3d_TypeOfLightSource.V3d_SPOT

class Graphic3d_TypeOfLimit(IntEnum):
    Graphic3d_TypeOfLimit_MaxNbLights: int = ...
    Graphic3d_TypeOfLimit_MaxNbClipPlanes: int = ...
    Graphic3d_TypeOfLimit_MaxNbViews: int = ...
    Graphic3d_TypeOfLimit_MaxTextureSize: int = ...
    Graphic3d_TypeOfLimit_MaxViewDumpSizeX: int = ...
    Graphic3d_TypeOfLimit_MaxViewDumpSizeY: int = ...
    Graphic3d_TypeOfLimit_MaxCombinedTextureUnits: int = ...
    Graphic3d_TypeOfLimit_MaxMsaa: int = ...
    Graphic3d_TypeOfLimit_HasPBR: int = ...
    Graphic3d_TypeOfLimit_HasRayTracing: int = ...
    Graphic3d_TypeOfLimit_HasRayTracingTextures: int = ...
    Graphic3d_TypeOfLimit_HasRayTracingAdaptiveSampling: int = ...
    Graphic3d_TypeOfLimit_HasRayTracingAdaptiveSamplingAtomic: int = ...
    Graphic3d_TypeOfLimit_HasSRGB: int = ...
    Graphic3d_TypeOfLimit_HasBlendedOit: int = ...
    Graphic3d_TypeOfLimit_HasBlendedOitMsaa: int = ...
    Graphic3d_TypeOfLimit_HasFlatShading: int = ...
    Graphic3d_TypeOfLimit_HasMeshEdges: int = ...
    Graphic3d_TypeOfLimit_IsWorkaroundFBO: int = ...
    Graphic3d_TypeOfLimit_NB: int = ...

Graphic3d_TypeOfLimit_MaxNbLights = (
    Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_MaxNbLights
)
Graphic3d_TypeOfLimit_MaxNbClipPlanes = (
    Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_MaxNbClipPlanes
)
Graphic3d_TypeOfLimit_MaxNbViews = (
    Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_MaxNbViews
)
Graphic3d_TypeOfLimit_MaxTextureSize = (
    Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_MaxTextureSize
)
Graphic3d_TypeOfLimit_MaxViewDumpSizeX = (
    Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_MaxViewDumpSizeX
)
Graphic3d_TypeOfLimit_MaxViewDumpSizeY = (
    Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_MaxViewDumpSizeY
)
Graphic3d_TypeOfLimit_MaxCombinedTextureUnits = (
    Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_MaxCombinedTextureUnits
)
Graphic3d_TypeOfLimit_MaxMsaa = Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_MaxMsaa
Graphic3d_TypeOfLimit_HasPBR = Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_HasPBR
Graphic3d_TypeOfLimit_HasRayTracing = (
    Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_HasRayTracing
)
Graphic3d_TypeOfLimit_HasRayTracingTextures = (
    Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_HasRayTracingTextures
)
Graphic3d_TypeOfLimit_HasRayTracingAdaptiveSampling = (
    Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_HasRayTracingAdaptiveSampling
)
Graphic3d_TypeOfLimit_HasRayTracingAdaptiveSamplingAtomic = (
    Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_HasRayTracingAdaptiveSamplingAtomic
)
Graphic3d_TypeOfLimit_HasSRGB = Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_HasSRGB
Graphic3d_TypeOfLimit_HasBlendedOit = (
    Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_HasBlendedOit
)
Graphic3d_TypeOfLimit_HasBlendedOitMsaa = (
    Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_HasBlendedOitMsaa
)
Graphic3d_TypeOfLimit_HasFlatShading = (
    Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_HasFlatShading
)
Graphic3d_TypeOfLimit_HasMeshEdges = (
    Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_HasMeshEdges
)
Graphic3d_TypeOfLimit_IsWorkaroundFBO = (
    Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_IsWorkaroundFBO
)
Graphic3d_TypeOfLimit_NB = Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_NB

class Graphic3d_TypeOfMaterial(IntEnum):
    Graphic3d_MATERIAL_ASPECT: int = ...
    Graphic3d_MATERIAL_PHYSIC: int = ...

Graphic3d_MATERIAL_ASPECT = Graphic3d_TypeOfMaterial.Graphic3d_MATERIAL_ASPECT
Graphic3d_MATERIAL_PHYSIC = Graphic3d_TypeOfMaterial.Graphic3d_MATERIAL_PHYSIC

class Graphic3d_TypeOfPrimitiveArray(IntEnum):
    Graphic3d_TOPA_UNDEFINED: int = ...
    Graphic3d_TOPA_POINTS: int = ...
    Graphic3d_TOPA_SEGMENTS: int = ...
    Graphic3d_TOPA_POLYLINES: int = ...
    Graphic3d_TOPA_TRIANGLES: int = ...
    Graphic3d_TOPA_TRIANGLESTRIPS: int = ...
    Graphic3d_TOPA_TRIANGLEFANS: int = ...
    Graphic3d_TOPA_LINES_ADJACENCY: int = ...
    Graphic3d_TOPA_LINE_STRIP_ADJACENCY: int = ...
    Graphic3d_TOPA_TRIANGLES_ADJACENCY: int = ...
    Graphic3d_TOPA_TRIANGLE_STRIP_ADJACENCY: int = ...
    Graphic3d_TOPA_QUADRANGLES: int = ...
    Graphic3d_TOPA_QUADRANGLESTRIPS: int = ...
    Graphic3d_TOPA_POLYGONS: int = ...

Graphic3d_TOPA_UNDEFINED = Graphic3d_TypeOfPrimitiveArray.Graphic3d_TOPA_UNDEFINED
Graphic3d_TOPA_POINTS = Graphic3d_TypeOfPrimitiveArray.Graphic3d_TOPA_POINTS
Graphic3d_TOPA_SEGMENTS = Graphic3d_TypeOfPrimitiveArray.Graphic3d_TOPA_SEGMENTS
Graphic3d_TOPA_POLYLINES = Graphic3d_TypeOfPrimitiveArray.Graphic3d_TOPA_POLYLINES
Graphic3d_TOPA_TRIANGLES = Graphic3d_TypeOfPrimitiveArray.Graphic3d_TOPA_TRIANGLES
Graphic3d_TOPA_TRIANGLESTRIPS = (
    Graphic3d_TypeOfPrimitiveArray.Graphic3d_TOPA_TRIANGLESTRIPS
)
Graphic3d_TOPA_TRIANGLEFANS = Graphic3d_TypeOfPrimitiveArray.Graphic3d_TOPA_TRIANGLEFANS
Graphic3d_TOPA_LINES_ADJACENCY = (
    Graphic3d_TypeOfPrimitiveArray.Graphic3d_TOPA_LINES_ADJACENCY
)
Graphic3d_TOPA_LINE_STRIP_ADJACENCY = (
    Graphic3d_TypeOfPrimitiveArray.Graphic3d_TOPA_LINE_STRIP_ADJACENCY
)
Graphic3d_TOPA_TRIANGLES_ADJACENCY = (
    Graphic3d_TypeOfPrimitiveArray.Graphic3d_TOPA_TRIANGLES_ADJACENCY
)
Graphic3d_TOPA_TRIANGLE_STRIP_ADJACENCY = (
    Graphic3d_TypeOfPrimitiveArray.Graphic3d_TOPA_TRIANGLE_STRIP_ADJACENCY
)
Graphic3d_TOPA_QUADRANGLES = Graphic3d_TypeOfPrimitiveArray.Graphic3d_TOPA_QUADRANGLES
Graphic3d_TOPA_QUADRANGLESTRIPS = (
    Graphic3d_TypeOfPrimitiveArray.Graphic3d_TOPA_QUADRANGLESTRIPS
)
Graphic3d_TOPA_POLYGONS = Graphic3d_TypeOfPrimitiveArray.Graphic3d_TOPA_POLYGONS

class Graphic3d_TypeOfReflection(IntEnum):
    Graphic3d_TOR_AMBIENT: int = ...
    Graphic3d_TOR_DIFFUSE: int = ...
    Graphic3d_TOR_SPECULAR: int = ...
    Graphic3d_TOR_EMISSION: int = ...

Graphic3d_TOR_AMBIENT = Graphic3d_TypeOfReflection.Graphic3d_TOR_AMBIENT
Graphic3d_TOR_DIFFUSE = Graphic3d_TypeOfReflection.Graphic3d_TOR_DIFFUSE
Graphic3d_TOR_SPECULAR = Graphic3d_TypeOfReflection.Graphic3d_TOR_SPECULAR
Graphic3d_TOR_EMISSION = Graphic3d_TypeOfReflection.Graphic3d_TOR_EMISSION

class Graphic3d_TypeOfShaderObject(IntEnum):
    Graphic3d_TOS_VERTEX: int = ...
    Graphic3d_TOS_TESS_CONTROL: int = ...
    Graphic3d_TOS_TESS_EVALUATION: int = ...
    Graphic3d_TOS_GEOMETRY: int = ...
    Graphic3d_TOS_FRAGMENT: int = ...
    Graphic3d_TOS_COMPUTE: int = ...

Graphic3d_TOS_VERTEX = Graphic3d_TypeOfShaderObject.Graphic3d_TOS_VERTEX
Graphic3d_TOS_TESS_CONTROL = Graphic3d_TypeOfShaderObject.Graphic3d_TOS_TESS_CONTROL
Graphic3d_TOS_TESS_EVALUATION = (
    Graphic3d_TypeOfShaderObject.Graphic3d_TOS_TESS_EVALUATION
)
Graphic3d_TOS_GEOMETRY = Graphic3d_TypeOfShaderObject.Graphic3d_TOS_GEOMETRY
Graphic3d_TOS_FRAGMENT = Graphic3d_TypeOfShaderObject.Graphic3d_TOS_FRAGMENT
Graphic3d_TOS_COMPUTE = Graphic3d_TypeOfShaderObject.Graphic3d_TOS_COMPUTE

class Graphic3d_TypeOfShadingModel(IntEnum):
    Graphic3d_TypeOfShadingModel_DEFAULT: int = ...
    Graphic3d_TypeOfShadingModel_Unlit: int = ...
    Graphic3d_TypeOfShadingModel_PhongFacet: int = ...
    Graphic3d_TypeOfShadingModel_Gouraud: int = ...
    Graphic3d_TypeOfShadingModel_Phong: int = ...
    Graphic3d_TypeOfShadingModel_Pbr: int = ...
    Graphic3d_TypeOfShadingModel_PbrFacet: int = ...
    Graphic3d_TOSM_DEFAULT: int = ...
    Graphic3d_TOSM_UNLIT: int = ...
    Graphic3d_TOSM_FACET: int = ...
    Graphic3d_TOSM_VERTEX: int = ...
    Graphic3d_TOSM_FRAGMENT: int = ...
    Graphic3d_TOSM_PBR: int = ...
    Graphic3d_TOSM_PBR_FACET: int = ...
    Graphic3d_TOSM_NONE: int = ...
    V3d_COLOR: int = ...
    V3d_FLAT: int = ...
    V3d_GOURAUD: int = ...
    V3d_PHONG: int = ...

Graphic3d_TypeOfShadingModel_DEFAULT = (
    Graphic3d_TypeOfShadingModel.Graphic3d_TypeOfShadingModel_DEFAULT
)
Graphic3d_TypeOfShadingModel_Unlit = (
    Graphic3d_TypeOfShadingModel.Graphic3d_TypeOfShadingModel_Unlit
)
Graphic3d_TypeOfShadingModel_PhongFacet = (
    Graphic3d_TypeOfShadingModel.Graphic3d_TypeOfShadingModel_PhongFacet
)
Graphic3d_TypeOfShadingModel_Gouraud = (
    Graphic3d_TypeOfShadingModel.Graphic3d_TypeOfShadingModel_Gouraud
)
Graphic3d_TypeOfShadingModel_Phong = (
    Graphic3d_TypeOfShadingModel.Graphic3d_TypeOfShadingModel_Phong
)
Graphic3d_TypeOfShadingModel_Pbr = (
    Graphic3d_TypeOfShadingModel.Graphic3d_TypeOfShadingModel_Pbr
)
Graphic3d_TypeOfShadingModel_PbrFacet = (
    Graphic3d_TypeOfShadingModel.Graphic3d_TypeOfShadingModel_PbrFacet
)
Graphic3d_TOSM_DEFAULT = Graphic3d_TypeOfShadingModel.Graphic3d_TOSM_DEFAULT
Graphic3d_TOSM_UNLIT = Graphic3d_TypeOfShadingModel.Graphic3d_TOSM_UNLIT
Graphic3d_TOSM_FACET = Graphic3d_TypeOfShadingModel.Graphic3d_TOSM_FACET
Graphic3d_TOSM_VERTEX = Graphic3d_TypeOfShadingModel.Graphic3d_TOSM_VERTEX
Graphic3d_TOSM_FRAGMENT = Graphic3d_TypeOfShadingModel.Graphic3d_TOSM_FRAGMENT
Graphic3d_TOSM_PBR = Graphic3d_TypeOfShadingModel.Graphic3d_TOSM_PBR
Graphic3d_TOSM_PBR_FACET = Graphic3d_TypeOfShadingModel.Graphic3d_TOSM_PBR_FACET
Graphic3d_TOSM_NONE = Graphic3d_TypeOfShadingModel.Graphic3d_TOSM_NONE
V3d_COLOR = Graphic3d_TypeOfShadingModel.V3d_COLOR
V3d_FLAT = Graphic3d_TypeOfShadingModel.V3d_FLAT
V3d_GOURAUD = Graphic3d_TypeOfShadingModel.V3d_GOURAUD
V3d_PHONG = Graphic3d_TypeOfShadingModel.V3d_PHONG

class Graphic3d_TypeOfStructure(IntEnum):
    Graphic3d_TOS_WIREFRAME: int = ...
    Graphic3d_TOS_SHADING: int = ...
    Graphic3d_TOS_COMPUTED: int = ...
    Graphic3d_TOS_ALL: int = ...

Graphic3d_TOS_WIREFRAME = Graphic3d_TypeOfStructure.Graphic3d_TOS_WIREFRAME
Graphic3d_TOS_SHADING = Graphic3d_TypeOfStructure.Graphic3d_TOS_SHADING
Graphic3d_TOS_COMPUTED = Graphic3d_TypeOfStructure.Graphic3d_TOS_COMPUTED
Graphic3d_TOS_ALL = Graphic3d_TypeOfStructure.Graphic3d_TOS_ALL

class Graphic3d_TypeOfTexture(IntEnum):
    Graphic3d_TypeOfTexture_1D: int = ...
    Graphic3d_TypeOfTexture_2D: int = ...
    Graphic3d_TypeOfTexture_3D: int = ...
    Graphic3d_TypeOfTexture_CUBEMAP: int = ...
    Graphic3d_TOT_2D_MIPMAP: int = ...
    Graphic3d_TOT_1D: int = ...
    Graphic3d_TOT_2D: int = ...
    Graphic3d_TOT_CUBEMAP: int = ...

Graphic3d_TypeOfTexture_1D = Graphic3d_TypeOfTexture.Graphic3d_TypeOfTexture_1D
Graphic3d_TypeOfTexture_2D = Graphic3d_TypeOfTexture.Graphic3d_TypeOfTexture_2D
Graphic3d_TypeOfTexture_3D = Graphic3d_TypeOfTexture.Graphic3d_TypeOfTexture_3D
Graphic3d_TypeOfTexture_CUBEMAP = (
    Graphic3d_TypeOfTexture.Graphic3d_TypeOfTexture_CUBEMAP
)
Graphic3d_TOT_2D_MIPMAP = Graphic3d_TypeOfTexture.Graphic3d_TOT_2D_MIPMAP
Graphic3d_TOT_1D = Graphic3d_TypeOfTexture.Graphic3d_TOT_1D
Graphic3d_TOT_2D = Graphic3d_TypeOfTexture.Graphic3d_TOT_2D
Graphic3d_TOT_CUBEMAP = Graphic3d_TypeOfTexture.Graphic3d_TOT_CUBEMAP

class Graphic3d_TypeOfTextureFilter(IntEnum):
    Graphic3d_TOTF_NEAREST: int = ...
    Graphic3d_TOTF_BILINEAR: int = ...
    Graphic3d_TOTF_TRILINEAR: int = ...

Graphic3d_TOTF_NEAREST = Graphic3d_TypeOfTextureFilter.Graphic3d_TOTF_NEAREST
Graphic3d_TOTF_BILINEAR = Graphic3d_TypeOfTextureFilter.Graphic3d_TOTF_BILINEAR
Graphic3d_TOTF_TRILINEAR = Graphic3d_TypeOfTextureFilter.Graphic3d_TOTF_TRILINEAR

class Graphic3d_TypeOfTextureMode(IntEnum):
    Graphic3d_TOTM_OBJECT: int = ...
    Graphic3d_TOTM_SPHERE: int = ...
    Graphic3d_TOTM_EYE: int = ...
    Graphic3d_TOTM_MANUAL: int = ...
    Graphic3d_TOTM_SPRITE: int = ...

Graphic3d_TOTM_OBJECT = Graphic3d_TypeOfTextureMode.Graphic3d_TOTM_OBJECT
Graphic3d_TOTM_SPHERE = Graphic3d_TypeOfTextureMode.Graphic3d_TOTM_SPHERE
Graphic3d_TOTM_EYE = Graphic3d_TypeOfTextureMode.Graphic3d_TOTM_EYE
Graphic3d_TOTM_MANUAL = Graphic3d_TypeOfTextureMode.Graphic3d_TOTM_MANUAL
Graphic3d_TOTM_SPRITE = Graphic3d_TypeOfTextureMode.Graphic3d_TOTM_SPRITE

class Graphic3d_TypeOfVisualization(IntEnum):
    Graphic3d_TOV_WIREFRAME: int = ...
    Graphic3d_TOV_SHADING: int = ...

Graphic3d_TOV_WIREFRAME = Graphic3d_TypeOfVisualization.Graphic3d_TOV_WIREFRAME
Graphic3d_TOV_SHADING = Graphic3d_TypeOfVisualization.Graphic3d_TOV_SHADING

class Graphic3d_VerticalTextAlignment(IntEnum):
    Graphic3d_VTA_BOTTOM: int = ...
    Graphic3d_VTA_CENTER: int = ...
    Graphic3d_VTA_TOP: int = ...
    Graphic3d_VTA_TOPFIRSTLINE: int = ...

Graphic3d_VTA_BOTTOM = Graphic3d_VerticalTextAlignment.Graphic3d_VTA_BOTTOM
Graphic3d_VTA_CENTER = Graphic3d_VerticalTextAlignment.Graphic3d_VTA_CENTER
Graphic3d_VTA_TOP = Graphic3d_VerticalTextAlignment.Graphic3d_VTA_TOP
Graphic3d_VTA_TOPFIRSTLINE = Graphic3d_VerticalTextAlignment.Graphic3d_VTA_TOPFIRSTLINE

class Graphic3d_ArrayOfPrimitives(Standard_Transient):
    @overload
    def AddBound(self, theEdgeNumber: int) -> int: ...
    @overload
    def AddBound(self, theEdgeNumber: int, theBColor: Quantity_Color) -> int: ...
    @overload
    def AddBound(
        self, theEdgeNumber: int, theR: float, theG: float, theB: float
    ) -> int: ...
    def AddEdge(self, theVertexIndex: int) -> int: ...
    @overload
    def AddEdges(self, theVertexIndex1: int, theVertexIndex2: int) -> int: ...
    @overload
    def AddEdges(
        self, theVertexIndex1: int, theVertexIndex2: int, theVertexIndex3: int
    ) -> int: ...
    @overload
    def AddEdges(
        self,
        theVertexIndex1: int,
        theVertexIndex2: int,
        theVertexIndex3: int,
        theVertexIndex4: int,
    ) -> int: ...
    def AddPolylineEdges(
        self, theVertexLower: int, theVertexUpper: int, theToClose: bool
    ) -> None: ...
    def AddQuadEdges(
        self,
        theVertexIndex1: int,
        theVertexIndex2: int,
        theVertexIndex3: int,
        theVertexIndex4: int,
    ) -> int: ...
    @overload
    def AddQuadTriangleEdges(
        self,
        theVertexIndex1: int,
        theVertexIndex2: int,
        theVertexIndex3: int,
        theVertexIndex4: int,
    ) -> int: ...
    @overload
    def AddQuadTriangleEdges(self, theIndexes: Graphic3d_Vec4i) -> int: ...
    def AddSegmentEdges(self, theVertexIndex1: int, theVertexIndex2: int) -> int: ...
    @overload
    def AddTriangleEdges(
        self, theVertexIndex1: int, theVertexIndex2: int, theVertexIndex3: int
    ) -> int: ...
    @overload
    def AddTriangleEdges(self, theIndexes: Graphic3d_Vec3i) -> int: ...
    @overload
    def AddTriangleEdges(self, theIndexes: Graphic3d_Vec4i) -> int: ...
    def AddTriangleFanEdges(
        self, theVertexLower: int, theVertexUpper: int, theToClose: bool
    ) -> None: ...
    def AddTriangleStripEdges(
        self, theVertexLower: int, theVertexUpper: int
    ) -> None: ...
    @overload
    def AddVertex(self, theVertex: gp_Pnt) -> int: ...
    @overload
    def AddVertex(self, theVertex: Graphic3d_Vec3) -> int: ...
    @overload
    def AddVertex(self, theX: float, theY: float, theZ: float) -> int: ...
    @overload
    def AddVertex(self, theX: float, theY: float, theZ: float) -> int: ...
    @overload
    def AddVertex(self, theVertex: gp_Pnt, theColor: Quantity_Color) -> int: ...
    @overload
    def AddVertex(self, theVertex: gp_Pnt, theColor32: int) -> int: ...
    @overload
    def AddVertex(self, theVertex: gp_Pnt, theColor: Graphic3d_Vec4ub) -> int: ...
    @overload
    def AddVertex(self, theVertex: gp_Pnt, theNormal: gp_Dir) -> int: ...
    @overload
    def AddVertex(
        self,
        theX: float,
        theY: float,
        theZ: float,
        theNX: float,
        theNY: float,
        theNZ: float,
    ) -> int: ...
    @overload
    def AddVertex(
        self,
        theX: float,
        theY: float,
        theZ: float,
        theNX: float,
        theNY: float,
        theNZ: float,
    ) -> int: ...
    @overload
    def AddVertex(
        self, theVertex: gp_Pnt, theNormal: gp_Dir, theColor: Quantity_Color
    ) -> int: ...
    @overload
    def AddVertex(
        self, theVertex: gp_Pnt, theNormal: gp_Dir, theColor32: int
    ) -> int: ...
    @overload
    def AddVertex(self, theVertex: gp_Pnt, theTexel: gp_Pnt2d) -> int: ...
    @overload
    def AddVertex(
        self, theX: float, theY: float, theZ: float, theTX: float, theTY: float
    ) -> int: ...
    @overload
    def AddVertex(
        self, theX: float, theY: float, theZ: float, theTX: float, theTY: float
    ) -> int: ...
    @overload
    def AddVertex(
        self, theVertex: gp_Pnt, theNormal: gp_Dir, theTexel: gp_Pnt2d
    ) -> int: ...
    @overload
    def AddVertex(
        self,
        theX: float,
        theY: float,
        theZ: float,
        theNX: float,
        theNY: float,
        theNZ: float,
        theTX: float,
        theTY: float,
    ) -> int: ...
    @overload
    def AddVertex(
        self,
        theX: float,
        theY: float,
        theZ: float,
        theNX: float,
        theNY: float,
        theNZ: float,
        theTX: float,
        theTY: float,
    ) -> int: ...
    def Attributes(self) -> Graphic3d_Buffer: ...
    def Bound(self, theRank: int) -> int: ...
    @overload
    def BoundColor(self, theRank: int) -> Quantity_Color: ...
    @overload
    def BoundColor(self, theRank: int) -> Tuple[float, float, float]: ...
    def BoundNumber(self) -> int: ...
    def BoundNumberAllocated(self) -> int: ...
    def Bounds(self) -> Graphic3d_BoundBuffer: ...
    @overload
    @staticmethod
    def CreateArray(
        theType: Graphic3d_TypeOfPrimitiveArray,
        theMaxVertexs: int,
        theMaxEdges: int,
        theArrayFlags: int,
    ) -> Graphic3d_ArrayOfPrimitives: ...
    @overload
    @staticmethod
    def CreateArray(
        theType: Graphic3d_TypeOfPrimitiveArray,
        theMaxVertexs: int,
        theMaxBounds: int,
        theMaxEdges: int,
        theArrayFlags: int,
    ) -> Graphic3d_ArrayOfPrimitives: ...
    def Edge(self, theRank: int) -> int: ...
    def EdgeNumber(self) -> int: ...
    def EdgeNumberAllocated(self) -> int: ...
    def HasBoundColors(self) -> bool: ...
    def HasVertexColors(self) -> bool: ...
    def HasVertexNormals(self) -> bool: ...
    def HasVertexTexels(self) -> bool: ...
    def Indices(self) -> Graphic3d_IndexBuffer: ...
    def IsValid(self) -> bool: ...
    def ItemNumber(self) -> int: ...
    @overload
    def SetBoundColor(self, theIndex: int, theColor: Quantity_Color) -> None: ...
    @overload
    def SetBoundColor(
        self, theIndex: int, theR: float, theG: float, theB: float
    ) -> None: ...
    @overload
    def SetVertexColor(self, theIndex: int, theColor: Quantity_Color) -> None: ...
    @overload
    def SetVertexColor(
        self, theIndex: int, theR: float, theG: float, theB: float
    ) -> None: ...
    @overload
    def SetVertexColor(self, theIndex: int, theColor: Graphic3d_Vec4ub) -> None: ...
    @overload
    def SetVertexColor(self, theIndex: int, theColor32: int) -> None: ...
    @overload
    def SetVertexNormal(self, theIndex: int, theNormal: gp_Dir) -> None: ...
    @overload
    def SetVertexNormal(
        self, theIndex: int, theNX: float, theNY: float, theNZ: float
    ) -> None: ...
    @overload
    def SetVertexTexel(self, theIndex: int, theTexel: gp_Pnt2d) -> None: ...
    @overload
    def SetVertexTexel(self, theIndex: int, theTX: float, theTY: float) -> None: ...
    @overload
    def SetVertice(self, theIndex: int, theVertex: gp_Pnt) -> None: ...
    @overload
    def SetVertice(
        self, theIndex: int, theX: float, theY: float, theZ: float
    ) -> None: ...
    def StringType(self) -> str: ...
    def Type(self) -> Graphic3d_TypeOfPrimitiveArray: ...
    @overload
    def VertexColor(self, theRank: int) -> Quantity_Color: ...
    @overload
    def VertexColor(self, theIndex: int, theColor: Graphic3d_Vec4ub) -> None: ...
    @overload
    def VertexColor(self, theRank: int) -> Tuple[float, float, float]: ...
    @overload
    def VertexColor(self, theRank: int) -> int: ...
    @overload
    def VertexNormal(self, theRank: int) -> gp_Dir: ...
    @overload
    def VertexNormal(self, theRank: int) -> Tuple[float, float, float]: ...
    def VertexNumber(self) -> int: ...
    def VertexNumberAllocated(self) -> int: ...
    @overload
    def VertexTexel(self, theRank: int) -> gp_Pnt2d: ...
    @overload
    def VertexTexel(self, theRank: int) -> Tuple[float, float]: ...
    @overload
    def Vertice(self, theRank: int) -> gp_Pnt: ...
    @overload
    def Vertice(self, theRank: int) -> Tuple[float, float, float]: ...

class Graphic3d_Aspects(Standard_Transient):
    def __init__(self) -> None: ...
    def AllowBackFace(self) -> None: ...
    def AlphaCutoff(self) -> float: ...
    def AlphaMode(self) -> Graphic3d_AlphaMode: ...
    def BackFace(self) -> bool: ...
    def BackInteriorColor(self) -> Quantity_Color: ...
    def BackInteriorColorRGBA(self) -> Quantity_ColorRGBA: ...
    def BackMaterial(self) -> Graphic3d_MaterialAspect: ...
    def ChangeBackMaterial(self) -> Graphic3d_MaterialAspect: ...
    def ChangeFrontMaterial(self) -> Graphic3d_MaterialAspect: ...
    def Color(self) -> Quantity_Color: ...
    def ColorRGBA(self) -> Quantity_ColorRGBA: ...
    def ColorSubTitle(self) -> Quantity_Color: ...
    def ColorSubTitleRGBA(self) -> Quantity_ColorRGBA: ...
    @staticmethod
    def DefaultLinePatternForType(theType: Aspect_TypeOfLine) -> False: ...
    def Distinguish(self) -> bool: ...
    def DumpJson(self, depth: Optional[int] = -1) -> str: ...
    def EdgeColor(self) -> Quantity_Color: ...
    def EdgeColorRGBA(self) -> Quantity_ColorRGBA: ...
    def EdgeLineType(self) -> Aspect_TypeOfLine: ...
    def EdgeWidth(self) -> float: ...
    def FaceCulling(self) -> Graphic3d_TypeOfBackfacingModel: ...
    def FrontMaterial(self) -> Graphic3d_MaterialAspect: ...
    def HatchStyle(self) -> Graphic3d_HatchStyle: ...
    def InteriorColor(self) -> Quantity_Color: ...
    def InteriorColorRGBA(self) -> Quantity_ColorRGBA: ...
    def InteriorStyle(self) -> Aspect_InteriorStyle: ...
    def IsEqual(self, theOther: Graphic3d_Aspects) -> bool: ...
    def IsMarkerSprite(self) -> bool: ...
    def IsTextZoomable(self) -> bool: ...
    def LinePattern(self) -> False: ...
    def LineStippleFactor(self) -> False: ...
    def LineType(self) -> Aspect_TypeOfLine: ...
    def LineWidth(self) -> float: ...
    def MarkerImage(self) -> Graphic3d_MarkerImage: ...
    def MarkerScale(self) -> float: ...
    def MarkerType(self) -> Aspect_TypeOfMarker: ...
    def PolygonOffset(self) -> Graphic3d_PolygonOffset: ...
    def PolygonOffsets(self) -> Tuple[int, float, float]: ...
    def SetAlphaMode(
        self, theMode: Graphic3d_AlphaMode, theAlphaCutoff: Optional[float] = 0.5
    ) -> None: ...
    @overload
    def SetBackInteriorColor(self, theColor: Quantity_Color) -> None: ...
    @overload
    def SetBackInteriorColor(self, theColor: Quantity_ColorRGBA) -> None: ...
    def SetBackMaterial(self, theMaterial: Graphic3d_MaterialAspect) -> None: ...
    def SetColor(self, theColor: Quantity_Color) -> None: ...
    @overload
    def SetColorSubTitle(self, theColor: Quantity_Color) -> None: ...
    @overload
    def SetColorSubTitle(self, theColor: Quantity_ColorRGBA) -> None: ...
    def SetDistinguish(self, toDistinguish: bool) -> None: ...
    def SetDistinguishOff(self) -> None: ...
    def SetDistinguishOn(self) -> None: ...
    def SetDrawEdges(self, theToDraw: bool) -> None: ...
    def SetDrawSilhouette(self, theToDraw: bool) -> None: ...
    @overload
    def SetEdgeColor(self, theColor: Quantity_Color) -> None: ...
    @overload
    def SetEdgeColor(self, theColor: Quantity_ColorRGBA) -> None: ...
    def SetEdgeLineType(self, theType: Aspect_TypeOfLine) -> None: ...
    def SetEdgeOff(self) -> None: ...
    def SetEdgeOn(self) -> None: ...
    def SetEdgeWidth(self, theWidth: float) -> None: ...
    def SetFaceCulling(self, theCulling: Graphic3d_TypeOfBackfacingModel) -> None: ...
    def SetFrontMaterial(self, theMaterial: Graphic3d_MaterialAspect) -> None: ...
    @overload
    def SetHatchStyle(self, theStyle: Graphic3d_HatchStyle) -> None: ...
    @overload
    def SetHatchStyle(self, theStyle: Aspect_HatchStyle) -> None: ...
    @overload
    def SetInteriorColor(self, theColor: Quantity_Color) -> None: ...
    @overload
    def SetInteriorColor(self, theColor: Quantity_ColorRGBA) -> None: ...
    def SetInteriorStyle(self, theStyle: Aspect_InteriorStyle) -> None: ...
    def SetLineType(self, theType: Aspect_TypeOfLine) -> None: ...
    def SetLineWidth(self, theWidth: float) -> None: ...
    def SetMarkerImage(self, theImage: Graphic3d_MarkerImage) -> None: ...
    def SetMarkerScale(self, theScale: float) -> None: ...
    def SetMarkerType(self, theType: Aspect_TypeOfMarker) -> None: ...
    def SetPolygonOffset(self, theOffset: Graphic3d_PolygonOffset) -> None: ...
    def SetPolygonOffsets(
        self,
        theMode: int,
        theFactor: Optional[float] = 1.0,
        theUnits: Optional[float] = 0.0,
    ) -> None: ...
    def SetShaderProgram(self, theProgram: Graphic3d_ShaderProgram) -> None: ...
    def SetShadingModel(
        self, theShadingModel: Graphic3d_TypeOfShadingModel
    ) -> None: ...
    def SetSkipFirstEdge(self, theToSkipFirstEdge: bool) -> None: ...
    def SetSuppressBackFaces(self, theToSuppress: bool) -> None: ...
    def SetTextAngle(self, theAngle: float) -> None: ...
    def SetTextDisplayType(self, theType: Aspect_TypeOfDisplayText) -> None: ...
    def SetTextFont(self, theFont: TCollection_HAsciiString) -> None: ...
    def SetTextStyle(self, theStyle: Aspect_TypeOfStyleText) -> None: ...
    def SetTextZoomable(self, theFlag: bool) -> None: ...
    def SetTextureMap(self, theTexture: Graphic3d_TextureMap) -> None: ...
    def SetTextureMapOff(self) -> None: ...
    @overload
    def SetTextureMapOn(self, theToMap: bool) -> None: ...
    @overload
    def SetTextureMapOn(self) -> None: ...
    def SetTextureSet(self, theTextures: Graphic3d_TextureSet) -> None: ...
    def ShaderProgram(self) -> Graphic3d_ShaderProgram: ...
    def ShadingModel(self) -> Graphic3d_TypeOfShadingModel: ...
    def SuppressBackFace(self) -> None: ...
    def TextAngle(self) -> float: ...
    def TextDisplayType(self) -> Aspect_TypeOfDisplayText: ...
    def TextFont(self) -> TCollection_HAsciiString: ...
    def TextFontAspect(self) -> False: ...
    def TextStyle(self) -> Aspect_TypeOfStyleText: ...
    def TextureMap(self) -> Graphic3d_TextureMap: ...
    def TextureMapState(self) -> bool: ...
    def TextureSet(self) -> Graphic3d_TextureSet: ...
    def ToDrawEdges(self) -> bool: ...
    def ToDrawSilhouette(self) -> bool: ...
    def ToMapTexture(self) -> bool: ...
    def ToSkipFirstEdge(self) -> bool: ...
    def ToSuppressBackFaces(self) -> bool: ...

class Graphic3d_Attribute:
    @overload
    def Stride(self) -> int: ...
    @overload
    @staticmethod
    def Stride(theType: Graphic3d_TypeOfData) -> int: ...

class Graphic3d_BSDF:
    def __init__(self) -> None: ...
    @staticmethod
    def CreateDiffuse(theWeight: Graphic3d_Vec3) -> Graphic3d_BSDF: ...
    @staticmethod
    def CreateGlass(
        theWeight: Graphic3d_Vec3,
        theAbsorptionColor: Graphic3d_Vec3,
        theAbsorptionCoeff: float,
        theRefractionIndex: float,
    ) -> Graphic3d_BSDF: ...
    @staticmethod
    def CreateMetallic(
        theWeight: Graphic3d_Vec3, theFresnel: Graphic3d_Fresnel, theRoughness: float
    ) -> Graphic3d_BSDF: ...
    @staticmethod
    def CreateMetallicRoughness(thePbr: Graphic3d_PBRMaterial) -> Graphic3d_BSDF: ...
    @staticmethod
    def CreateTransparent(
        theWeight: Graphic3d_Vec3,
        theAbsorptionColor: Graphic3d_Vec3,
        theAbsorptionCoeff: float,
    ) -> Graphic3d_BSDF: ...
    def DumpJson(self, depth: Optional[int] = -1) -> str: ...
    def Normalize(self) -> None: ...

class Graphic3d_BoundBuffer(NCollection_Buffer):
    def __init__(self, theAlloc: NCollection_BaseAllocator) -> None: ...
    def DumpJson(self, depth: Optional[int] = -1) -> str: ...
    def Init(self, theNbBounds: int, theHasColors: bool) -> bool: ...

class Graphic3d_BufferRange:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theStart: int, theLength: int) -> None: ...
    def Clear(self) -> None: ...
    def IsEmpty(self) -> bool: ...
    def Unite(self, theRange: Graphic3d_BufferRange) -> None: ...
    def Upper(self) -> int: ...

class Graphic3d_BvhCStructureSet(BVH_PrimitiveSet3d):
    def Box(self, theIdx: int) -> Graphic3d_BndBox3d: ...
    def Center(self, theIdx: int, theAxis: int) -> float: ...
    def Size(self) -> int: ...
    def Structures(self) -> False: ...
    def Swap(self, theIdx1: int, theIdx2: int) -> None: ...

class Graphic3d_CLight(Standard_Transient):
    def __init__(self, theType: Graphic3d_TypeOfLightSource) -> None: ...
    def Angle(self) -> float: ...
    def Attenuation(self) -> Tuple[float, float]: ...
    def Color(self) -> Quantity_Color: ...
    def Concentration(self) -> float: ...
    def ConstAttenuation(self) -> float: ...
    def CopyFrom(self, theLight: Graphic3d_CLight) -> None: ...
    @overload
    def Direction(self) -> gp_Dir: ...
    @overload
    def Direction(self) -> Tuple[float, float, float]: ...
    def DisplayPosition(self) -> gp_Pnt: ...
    def DumpJson(self, depth: Optional[int] = -1) -> str: ...
    def GetId(self) -> str: ...
    def HasRange(self) -> bool: ...
    def Headlight(self) -> bool: ...
    def Intensity(self) -> float: ...
    def IsEnabled(self) -> bool: ...
    def IsHeadlight(self) -> bool: ...
    def LinearAttenuation(self) -> float: ...
    def Name(self) -> str: ...
    def PackedColor(self) -> Graphic3d_Vec4: ...
    def PackedDirection(self) -> Graphic3d_Vec3: ...
    def PackedDirectionRange(self) -> Graphic3d_Vec4: ...
    def PackedParams(self) -> Graphic3d_Vec4: ...
    @overload
    def Position(self) -> gp_Pnt: ...
    @overload
    def Position(self) -> Tuple[float, float, float]: ...
    def Range(self) -> float: ...
    def Revision(self) -> int: ...
    def SetAngle(self, theAngle: float) -> None: ...
    def SetAttenuation(
        self, theConstAttenuation: float, theLinearAttenuation: float
    ) -> None: ...
    def SetCastShadows(self, theToCast: bool) -> None: ...
    def SetColor(self, theColor: Quantity_Color) -> None: ...
    def SetConcentration(self, theConcentration: float) -> None: ...
    @overload
    def SetDirection(self, theDir: gp_Dir) -> None: ...
    @overload
    def SetDirection(self, theVx: float, theVy: float, theVz: float) -> None: ...
    def SetDisplayPosition(self, thePosition: gp_Pnt) -> None: ...
    def SetEnabled(self, theIsOn: bool) -> None: ...
    def SetHeadlight(self, theValue: bool) -> None: ...
    def SetIntensity(self, theValue: float) -> None: ...
    def SetName(self, theName: str) -> None: ...
    @overload
    def SetPosition(self, thePosition: gp_Pnt) -> None: ...
    @overload
    def SetPosition(self, theX: float, theY: float, theZ: float) -> None: ...
    def SetRange(self, theValue: float) -> None: ...
    def SetSmoothAngle(self, theValue: float) -> None: ...
    def SetSmoothRadius(self, theValue: float) -> None: ...
    def Smoothness(self) -> float: ...
    def ToCastShadows(self) -> bool: ...
    def Type(self) -> Graphic3d_TypeOfLightSource: ...

class Graphic3d_CStructure(Standard_Transient):
    def BndBoxClipCheck(self) -> bool: ...
    def BoundingBox(self) -> Graphic3d_BndBox3d: ...
    def ChangeBoundingBox(self) -> Graphic3d_BndBox3d: ...
    def Clear(self) -> None: ...
    def ClipPlanes(self) -> Graphic3d_SequenceOfHClipPlane: ...
    def Connect(self, theStructure: Graphic3d_CStructure) -> None: ...
    def Disconnect(self, theStructure: Graphic3d_CStructure) -> None: ...
    def DumpJson(self, depth: Optional[int] = -1) -> str: ...
    def GraphicDriver(self) -> Graphic3d_GraphicDriver: ...
    def GraphicHighlight(self, theStyle: Graphic3d_PresentationAttributes) -> None: ...
    def GraphicUnhighlight(self) -> None: ...
    def Groups(self) -> Graphic3d_SequenceOfGroup: ...
    def HasGroupTransformPersistence(self) -> bool: ...
    def HighlightStyle(self) -> Graphic3d_PresentationAttributes: ...
    def Identification(self) -> int: ...
    def IsAlwaysRendered(self) -> bool: ...
    def IsCulled(self) -> bool: ...
    @overload
    def IsVisible(self) -> bool: ...
    @overload
    def IsVisible(self, theViewId: int) -> bool: ...
    def MarkAsNotCulled(self) -> None: ...
    def NewGroup(self, theStruct: Graphic3d_Structure) -> Graphic3d_Group: ...
    def OnVisibilityChanged(self) -> None: ...
    def PreviousPriority(self) -> Graphic3d_DisplayPriority: ...
    def Priority(self) -> Graphic3d_DisplayPriority: ...
    def RemoveGroup(self, theGroup: Graphic3d_Group) -> None: ...
    def SetBndBoxClipCheck(self, theBndBoxClipCheck: bool) -> None: ...
    def SetClipPlanes(self, thePlanes: Graphic3d_SequenceOfHClipPlane) -> None: ...
    def SetCulled(self, theIsCulled: bool) -> None: ...
    def SetGroupTransformPersistence(self, theValue: bool) -> None: ...
    def SetPreviousPriority(self, thePriority: Graphic3d_DisplayPriority) -> None: ...
    def SetPriority(self, thePriority: Graphic3d_DisplayPriority) -> None: ...
    def SetTransformPersistence(self, theTrsfPers: Graphic3d_TransformPers) -> None: ...
    def SetTransformation(self, theTrsf: TopLoc_Datum3D) -> None: ...
    def SetZLayer(self, theLayerIndex: int) -> None: ...
    def ShadowLink(
        self, theManager: Graphic3d_StructureManager
    ) -> Graphic3d_CStructure: ...
    def TransformPersistence(self) -> Graphic3d_TransformPers: ...
    def Transformation(self) -> TopLoc_Datum3D: ...
    def ZLayer(self) -> Graphic3d_ZLayerId: ...
    def updateLayerTransformation(self) -> None: ...

class Graphic3d_Camera(Standard_Transient):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theOther: Graphic3d_Camera) -> None: ...
    def Aspect(self) -> float: ...
    def AxialScale(self) -> gp_XYZ: ...
    def Center(self) -> gp_Pnt: ...
    def ConvertProj2View(self, thePnt: gp_Pnt) -> gp_Pnt: ...
    def ConvertView2Proj(self, thePnt: gp_Pnt) -> gp_Pnt: ...
    def ConvertView2World(self, thePnt: gp_Pnt) -> gp_Pnt: ...
    def ConvertWorld2View(self, thePnt: gp_Pnt) -> gp_Pnt: ...
    def Copy(self, theOther: Graphic3d_Camera) -> None: ...
    def CopyMappingData(self, theOtherCamera: Graphic3d_Camera) -> None: ...
    def CopyOrientationData(self, theOtherCamera: Graphic3d_Camera) -> None: ...
    def Direction(self) -> gp_Dir: ...
    def Distance(self) -> float: ...
    def DumpJson(self, depth: Optional[int] = -1) -> str: ...
    def Eye(self) -> gp_Pnt: ...
    def FOV2d(self) -> float: ...
    def FOVx(self) -> float: ...
    def FOVy(self) -> float: ...
    def FitMinMax(
        self, theBox: Bnd_Box, theResolution: float, theToEnlargeIfLine: bool
    ) -> bool: ...
    def Frustum(
        self,
        theLeft: gp_Pln,
        theRight: gp_Pln,
        theBottom: gp_Pln,
        theTop: gp_Pln,
        theNear: gp_Pln,
        theFar: gp_Pln,
    ) -> None: ...
    def GetIODType(self) -> False: ...
    def IOD(self) -> float: ...
    @staticmethod
    def Interpolate(
        theStart: Graphic3d_Camera,
        theEnd: Graphic3d_Camera,
        theT: float,
        theCamera: Graphic3d_Camera,
    ) -> None: ...
    def InvalidateOrientation(self) -> None: ...
    def InvalidateProjection(self) -> None: ...
    def IsCustomMonoProjection(self) -> bool: ...
    def IsCustomStereoFrustum(self) -> bool: ...
    def IsCustomStereoProjection(self) -> bool: ...
    def IsOrthographic(self) -> bool: ...
    def IsStereo(self) -> bool: ...
    def IsZeroToOneDepth(self) -> bool: ...
    def MoveEyeTo(self, theEye: gp_Pnt) -> None: ...
    def NDC2dOffsetX(self) -> float: ...
    def NDC2dOffsetY(self) -> float: ...
    def OrientationMatrix(self) -> Graphic3d_Mat4d: ...
    def OrientationMatrixF(self) -> Graphic3d_Mat4: ...
    def OrthogonalizeUp(self) -> None: ...
    def OrthogonalizedUp(self) -> gp_Dir: ...
    def Project(self, thePnt: gp_Pnt) -> gp_Pnt: ...
    def ProjectionMatrix(self) -> Graphic3d_Mat4d: ...
    def ProjectionMatrixF(self) -> Graphic3d_Mat4: ...
    def ProjectionState(self) -> int: ...
    def ProjectionStereoLeft(self) -> Graphic3d_Mat4d: ...
    def ProjectionStereoLeftF(self) -> Graphic3d_Mat4: ...
    def ProjectionStereoRight(self) -> Graphic3d_Mat4d: ...
    def ProjectionStereoRightF(self) -> Graphic3d_Mat4: ...
    def ProjectionType(self) -> False: ...
    def ResetCustomProjection(self) -> None: ...
    def Scale(self) -> float: ...
    def SetAspect(self, theAspect: float) -> None: ...
    def SetAxialScale(self, theAxialScale: gp_XYZ) -> None: ...
    def SetCenter(self, theCenter: gp_Pnt) -> None: ...
    def SetCustomMonoProjection(self, theProj: Graphic3d_Mat4d) -> None: ...
    def SetCustomStereoProjection(
        self,
        theProjL: Graphic3d_Mat4d,
        theHeadToEyeL: Graphic3d_Mat4d,
        theProjR: Graphic3d_Mat4d,
        theHeadToEyeR: Graphic3d_Mat4d,
    ) -> None: ...
    def SetDirection(self, theDir: gp_Dir) -> None: ...
    def SetDirectionFromEye(self, theDir: gp_Dir) -> None: ...
    def SetDistance(self, theDistance: float) -> None: ...
    def SetEye(self, theEye: gp_Pnt) -> None: ...
    def SetEyeAndCenter(self, theEye: gp_Pnt, theCenter: gp_Pnt) -> None: ...
    def SetFOV2d(self, theFOV: float) -> None: ...
    def SetFOVy(self, theFOVy: float) -> None: ...
    def SetIdentityOrientation(self) -> None: ...
    def SetScale(self, theScale: float) -> None: ...
    def SetTile(self, theTile: Graphic3d_CameraTile) -> None: ...
    def SetUp(self, theUp: gp_Dir) -> None: ...
    def SetZRange(self, theZNear: float, theZFar: float) -> None: ...
    def SetZeroToOneDepth(self, theIsZeroToOne: bool) -> None: ...
    def SideRight(self) -> gp_Dir: ...
    def StereoProjection(
        self,
        theProjL: Graphic3d_Mat4d,
        theHeadToEyeL: Graphic3d_Mat4d,
        theProjR: Graphic3d_Mat4d,
        theHeadToEyeR: Graphic3d_Mat4d,
    ) -> None: ...
    def StereoProjectionF(
        self,
        theProjL: Graphic3d_Mat4,
        theHeadToEyeL: Graphic3d_Mat4,
        theProjR: Graphic3d_Mat4,
        theHeadToEyeR: Graphic3d_Mat4,
    ) -> None: ...
    def Tile(self) -> Graphic3d_CameraTile: ...
    def Transform(self, theTrsf: gp_Trsf) -> None: ...
    def UnProject(self, thePnt: gp_Pnt) -> gp_Pnt: ...
    def Up(self) -> gp_Dir: ...
    @overload
    def ViewDimensions(self) -> gp_XYZ: ...
    @overload
    def ViewDimensions(self, theZValue: float) -> gp_XYZ: ...
    def WorldViewProjState(self) -> Graphic3d_WorldViewProjState: ...
    def WorldViewState(self) -> int: ...
    def ZFar(self) -> float: ...
    @overload
    def ZFitAll(
        self, theScaleFactor: float, theMinMax: Bnd_Box, theGraphicBB: Bnd_Box
    ) -> Tuple[bool, float, float]: ...
    @overload
    def ZFitAll(
        self, theScaleFactor: float, theMinMax: Bnd_Box, theGraphicBB: Bnd_Box
    ) -> None: ...
    def ZFocus(self) -> float: ...
    def ZFocusType(self) -> False: ...
    def ZNear(self) -> float: ...

class Graphic3d_CameraTile:
    def __init__(self) -> None: ...
    def Cropped(self) -> Graphic3d_CameraTile: ...
    def DumpJson(self, depth: Optional[int] = -1) -> str: ...
    def IsValid(self) -> bool: ...
    def OffsetLowerLeft(self) -> Graphic3d_Vec2i: ...

class Graphic3d_ClipPlane(Standard_Transient):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theOther: Graphic3d_ClipPlane) -> None: ...
    @overload
    def __init__(self, theEquation: Graphic3d_Vec4d) -> None: ...
    @overload
    def __init__(self, thePlane: gp_Pln) -> None: ...
    def CappingAspect(self) -> Graphic3d_AspectFillArea3d: ...
    def CappingColor(self) -> Quantity_Color: ...
    def CappingCustomHatch(self) -> Graphic3d_HatchStyle: ...
    def CappingHatch(self) -> Aspect_HatchStyle: ...
    def CappingMaterial(self) -> Graphic3d_MaterialAspect: ...
    def CappingTexture(self) -> Graphic3d_TextureMap: ...
    def ChainNextPlane(self) -> Graphic3d_ClipPlane: ...
    def ChainPreviousPlane(self) -> Graphic3d_ClipPlane: ...
    def Clone(self) -> Graphic3d_ClipPlane: ...
    def DumpJson(self, depth: Optional[int] = -1) -> str: ...
    def GetEquation(self) -> Graphic3d_Vec4d: ...
    def GetId(self) -> str: ...
    def IsBoxFullInHalfspace(self, theBox: Graphic3d_BndBox3d) -> bool: ...
    def IsBoxFullOutHalfspace(self, theBox: Graphic3d_BndBox3d) -> bool: ...
    def IsCapping(self) -> bool: ...
    def IsChain(self) -> bool: ...
    def IsHatchOn(self) -> bool: ...
    def IsOn(self) -> bool: ...
    def IsPointOutHalfspace(self, thePoint: Graphic3d_Vec4d) -> bool: ...
    def MCountAspect(self) -> int: ...
    def MCountEquation(self) -> int: ...
    def NbChainNextPlanes(self) -> int: ...
    def ProbeBox(self, theBox: Graphic3d_BndBox3d) -> Graphic3d_ClipState: ...
    def ProbeBoxHalfspace(self, theBox: Graphic3d_BndBox3d) -> Graphic3d_ClipState: ...
    def ProbeBoxMaxPointHalfspace(
        self, theBox: Graphic3d_BndBox3d
    ) -> Graphic3d_ClipState: ...
    def ProbeBoxTouch(self, theBox: Graphic3d_BndBox3d) -> bool: ...
    def ProbePoint(self, thePoint: Graphic3d_Vec4d) -> Graphic3d_ClipState: ...
    def ProbePointHalfspace(self, thePoint: Graphic3d_Vec4d) -> Graphic3d_ClipState: ...
    def ReversedEquation(self) -> Graphic3d_Vec4d: ...
    def SetCapping(self, theIsOn: bool) -> None: ...
    def SetCappingAspect(self, theAspect: Graphic3d_AspectFillArea3d) -> None: ...
    def SetCappingColor(self, theColor: Quantity_Color) -> None: ...
    def SetCappingCustomHatch(self, theStyle: Graphic3d_HatchStyle) -> None: ...
    def SetCappingHatch(self, theStyle: Aspect_HatchStyle) -> None: ...
    def SetCappingHatchOff(self) -> None: ...
    def SetCappingHatchOn(self) -> None: ...
    def SetCappingMaterial(self, theMat: Graphic3d_MaterialAspect) -> None: ...
    def SetCappingTexture(self, theTexture: Graphic3d_TextureMap) -> None: ...
    def SetChainNextPlane(self, thePlane: Graphic3d_ClipPlane) -> None: ...
    @overload
    def SetEquation(self, thePlane: gp_Pln) -> None: ...
    @overload
    def SetEquation(self, theEquation: Graphic3d_Vec4d) -> None: ...
    def SetOn(self, theIsOn: bool) -> None: ...
    def SetUseObjectMaterial(self, theToUse: bool) -> None: ...
    def SetUseObjectShader(self, theToUse: bool) -> None: ...
    def SetUseObjectTexture(self, theToUse: bool) -> None: ...
    def ToPlane(self) -> gp_Pln: ...
    def ToUseObjectMaterial(self) -> bool: ...
    def ToUseObjectProperties(self) -> bool: ...
    def ToUseObjectShader(self) -> bool: ...
    def ToUseObjectTexture(self) -> bool: ...

class Graphic3d_CullingTool:
    def __init__(self) -> None: ...
    def CacheClipPtsProjections(self) -> None: ...
    def Camera(self) -> Graphic3d_Camera: ...
    def CameraDirection(self) -> Graphic3d_Vec3d: ...
    def CameraEye(self) -> Graphic3d_Vec3d: ...
    def IsOutFrustum(
        self,
        theMinPnt: Graphic3d_Vec3d,
        theMaxPnt: Graphic3d_Vec3d,
        theIsInside: Optional[bool] = None,
    ) -> bool: ...
    def ProjectionMatrix(self) -> Graphic3d_Mat4d: ...
    def SetViewVolume(
        self,
        theCamera: Graphic3d_Camera,
        theModelWorld: Optional[Graphic3d_Mat4d] = Graphic3d_Mat4d(),
    ) -> None: ...
    def SetViewportSize(
        self, theViewportWidth: int, theViewportHeight: int, theResolutionRatio: float
    ) -> None: ...
    def SignedPlanePointDistance(
        self, theNormal: Graphic3d_Vec4d, thePnt: Graphic3d_Vec4d
    ) -> float: ...
    def ViewportHeight(self) -> int: ...
    def ViewportWidth(self) -> int: ...
    def WorldViewMatrix(self) -> Graphic3d_Mat4d: ...
    def WorldViewProjState(self) -> Graphic3d_WorldViewProjState: ...

class Graphic3d_DataStructureManager(Standard_Transient):
    pass

class Graphic3d_FrameStats(Standard_Transient):
    def ActiveDataFrame(self) -> Graphic3d_FrameStatsDataTmp: ...
    def ChangeCounter(self, theCounter: Graphic3d_FrameStatsCounter) -> int: ...
    def ChangeDataFrames(self) -> False: ...
    def GetChangeTimer(self, theTimer: Graphic3d_FrameStatsTimer) -> float: ...
    def SetChangeTimer(
        self, theTimer: Graphic3d_FrameStatsTimer, value: float
    ) -> None: ...
    def CounterValue(self, theCounter: Graphic3d_FrameStatsCounter) -> int: ...
    def DataFrames(self) -> False: ...
    def FrameDuration(self) -> float: ...
    def FrameEnd(self, theView: Graphic3d_CView, theIsImmediateOnly: bool) -> None: ...
    def FrameRate(self) -> float: ...
    def FrameRateCpu(self) -> float: ...
    def FrameStart(
        self, theView: Graphic3d_CView, theIsImmediateOnly: bool
    ) -> None: ...
    def HasCulledLayers(self) -> bool: ...
    def HasCulledStructs(self) -> bool: ...
    def IsLongLineFormat(self) -> bool: ...
    def LastDataFrame(self) -> Graphic3d_FrameStatsData: ...
    def LastDataFrameIndex(self) -> int: ...
    def SetLongLineFormat(self, theValue: bool) -> None: ...
    def SetUpdateInterval(self, theInterval: float) -> None: ...
    def TimerValue(self, theTimer: Graphic3d_FrameStatsTimer) -> float: ...
    def UpdateInterval(self) -> float: ...

class Graphic3d_FrameStatsData:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theOther: Graphic3d_FrameStatsData) -> None: ...
    @overload
    def __init__(self, theOther: Graphic3d_FrameStatsData) -> None: ...
    def CounterValue(self, theIndex: Graphic3d_FrameStatsCounter) -> int: ...
    def FillMax(self, theOther: Graphic3d_FrameStatsData) -> None: ...
    def FrameRate(self) -> float: ...
    def FrameRateCpu(self) -> float: ...
    def ImmediateFrameRate(self) -> float: ...
    def ImmediateFrameRateCpu(self) -> float: ...
    def Reset(self) -> None: ...
    def TimerValue(self, theIndex: Graphic3d_FrameStatsTimer) -> float: ...

class Graphic3d_Fresnel:
    def __init__(self) -> None: ...
    @overload
    @staticmethod
    def CreateConductor(
        theRefractionIndex: float, theAbsorptionIndex: float
    ) -> Graphic3d_Fresnel: ...
    @overload
    @staticmethod
    def CreateConductor(
        theRefractionIndex: Graphic3d_Vec3, theAbsorptionIndex: Graphic3d_Vec3
    ) -> Graphic3d_Fresnel: ...
    @staticmethod
    def CreateConstant(theReflection: float) -> Graphic3d_Fresnel: ...
    @staticmethod
    def CreateDielectric(theRefractionIndex: float) -> Graphic3d_Fresnel: ...
    @staticmethod
    def CreateSchlick(theSpecularColor: Graphic3d_Vec3) -> Graphic3d_Fresnel: ...
    def DumpJson(self, depth: Optional[int] = -1) -> str: ...
    def FresnelType(self) -> Graphic3d_FresnelModel: ...
    def Serialize(self) -> Graphic3d_Vec4: ...

class Graphic3d_GraduatedTrihedron:
    def ArrowsLength(self) -> float: ...
    def AxisAspectAt(self, theIndex: int) -> False: ...
    def ChangeAxisAspect(self, theIndex: int) -> False: ...
    def ChangeXAxisAspect(self) -> False: ...
    def ChangeYAxisAspect(self) -> False: ...
    def ChangeZAxisAspect(self) -> False: ...
    def CubicAxesCallback(self, theView: Graphic3d_CView) -> bool: ...
    def GridColor(self) -> Quantity_Color: ...
    def NamesFont(self) -> str: ...
    def NamesFontAspect(self) -> False: ...
    def NamesSize(self) -> int: ...
    def SetArrowsLength(self, theValue: float) -> None: ...
    def SetDrawAxes(self, theToDraw: bool) -> None: ...
    def SetDrawGrid(self, theToDraw: bool) -> None: ...
    def SetGridColor(self, theColor: Quantity_Color) -> None: ...
    def SetNamesFont(self, theFont: str) -> None: ...
    def SetNamesSize(self, theValue: int) -> None: ...
    def SetValuesFont(self, theFont: str) -> None: ...
    def SetValuesSize(self, theValue: int) -> None: ...
    def ToDrawAxes(self) -> bool: ...
    def ToDrawGrid(self) -> bool: ...
    def ValuesFont(self) -> str: ...
    def ValuesFontAspect(self) -> False: ...
    def ValuesSize(self) -> int: ...
    def XAxisAspect(self) -> False: ...
    def YAxisAspect(self) -> False: ...
    def ZAxisAspect(self) -> False: ...

class Graphic3d_GraphicDriver(Standard_Transient):
    def CreateStructure(
        self, theManager: Graphic3d_StructureManager
    ) -> Graphic3d_CStructure: ...
    def CreateView(self, theMgr: Graphic3d_StructureManager) -> Graphic3d_CView: ...
    def DefaultTextHeight(self) -> float: ...
    def DumpJson(self, depth: Optional[int] = -1) -> str: ...
    def EnableVBO(self, status: bool) -> None: ...
    def GetDisplayConnection(self) -> Aspect_DisplayConnection: ...
    def InquireLightLimit(self) -> int: ...
    def InquireLimit(self, theType: Graphic3d_TypeOfLimit) -> int: ...
    def InquirePlaneLimit(self) -> int: ...
    def InquireViewLimit(self) -> int: ...
    def InsertLayerAfter(
        self,
        theNewLayerId: int,
        theSettings: Graphic3d_ZLayerSettings,
        theLayerBefore: int,
    ) -> None: ...
    def InsertLayerBefore(
        self,
        theNewLayerId: int,
        theSettings: Graphic3d_ZLayerSettings,
        theLayerAfter: int,
    ) -> None: ...
    def IsVerticalSync(self) -> bool: ...
    def MemoryInfo(self, theFreeBytes: int, theInfo: str) -> bool: ...
    def NewIdentification(self) -> int: ...
    def RemoveIdentification(self, theId: int) -> None: ...
    def RemoveStructure(self, theCStructure: Graphic3d_CStructure) -> None: ...
    def RemoveView(self, theView: Graphic3d_CView) -> None: ...
    def RemoveZLayer(self, theLayerId: int) -> None: ...
    def SetVerticalSync(self, theToEnable: bool) -> None: ...
    def SetZLayerSettings(
        self, theLayerId: int, theSettings: Graphic3d_ZLayerSettings
    ) -> None: ...
    def TextSize(
        self, theView: Graphic3d_CView, theText: str, theHeight: float
    ) -> Tuple[float, float, float]: ...
    def ViewExists(
        self, theWindow: Aspect_Window, theView: Graphic3d_CView
    ) -> bool: ...
    def ZLayerSettings(self, theLayerId: int) -> Graphic3d_ZLayerSettings: ...
    def ZLayers(self, theLayerSeq: TColStd_SequenceOfInteger) -> None: ...

class Graphic3d_GraphicDriverFactory(Standard_Transient):
    def CreateDriver(
        self, theDisp: Aspect_DisplayConnection
    ) -> Graphic3d_GraphicDriver: ...
    @staticmethod
    def DefaultDriverFactory() -> Graphic3d_GraphicDriverFactory: ...
    @staticmethod
    def DriverFactories() -> Graphic3d_GraphicDriverFactoryList: ...
    def Name(self) -> str: ...
    @staticmethod
    def RegisterFactory(
        theFactory: Graphic3d_GraphicDriverFactory,
        theIsPreferred: Optional[bool] = false,
    ) -> None: ...
    @staticmethod
    def UnregisterFactory(theName: str) -> None: ...

class Graphic3d_Group(Standard_Transient):
    @overload
    def AddPrimitiveArray(
        self,
        theType: Graphic3d_TypeOfPrimitiveArray,
        theIndices: Graphic3d_IndexBuffer,
        theAttribs: Graphic3d_Buffer,
        theBounds: Graphic3d_BoundBuffer,
        theToEvalMinMax: Optional[bool] = True,
    ) -> None: ...
    @overload
    def AddPrimitiveArray(
        self,
        thePrim: Graphic3d_ArrayOfPrimitives,
        theToEvalMinMax: Optional[bool] = True,
    ) -> None: ...
    def AddText(
        self, theTextParams: Graphic3d_Text, theToEvalMinMax: Optional[bool] = True
    ) -> None: ...
    def Aspects(self) -> Graphic3d_Aspects: ...
    def BoundingBox(self) -> Graphic3d_BndBox4f: ...
    def ChangeBoundingBox(self) -> Graphic3d_BndBox4f: ...
    def Clear(self, theUpdateStructureMgr: Optional[bool] = True) -> None: ...
    def DumpJson(self, depth: Optional[int] = -1) -> str: ...
    def IsClosed(self) -> bool: ...
    def IsDeleted(self) -> bool: ...
    def IsEmpty(self) -> bool: ...
    def Marker(
        self, thePoint: Graphic3d_Vertex, theToEvalMinMax: Optional[bool] = True
    ) -> None: ...
    def MinMaxValues(self) -> Tuple[float, float, float, float, float, float]: ...
    def Remove(self) -> None: ...
    def ReplaceAspects(self, theMap: Graphic3d_MapOfAspectsToAspects) -> None: ...
    def SetClosed(self, theIsClosed: bool) -> None: ...
    def SetFlippingOptions(self, theIsEnabled: bool, theRefPlane: gp_Ax2) -> None: ...
    def SetMinMaxValues(
        self,
        theXMin: float,
        theYMin: float,
        theZMin: float,
        theXMax: float,
        theYMax: float,
        theZMax: float,
    ) -> None: ...
    def SetPrimitivesAspect(self, theAspect: Graphic3d_Aspects) -> None: ...
    def SetStencilTestOptions(self, theIsEnabled: bool) -> None: ...
    def SetTransformPersistence(self, theTrsfPers: Graphic3d_TransformPers) -> None: ...
    def SetTransformation(self, theTrsf: gp_Trsf) -> None: ...
    def Structure(self) -> Graphic3d_Structure: ...
    def SynchronizeAspects(self) -> None: ...
    @overload
    def Text(
        self,
        AText: str,
        APoint: Graphic3d_Vertex,
        AHeight: float,
        AAngle: float,
        ATp: Graphic3d_TextPath,
        AHta: Graphic3d_HorizontalTextAlignment,
        AVta: Graphic3d_VerticalTextAlignment,
        EvalMinMax: Optional[bool] = True,
    ) -> None: ...
    @overload
    def Text(
        self,
        AText: str,
        APoint: Graphic3d_Vertex,
        AHeight: float,
        EvalMinMax: Optional[bool] = True,
    ) -> None: ...
    @overload
    def Text(
        self,
        AText: str,
        APoint: Graphic3d_Vertex,
        AHeight: float,
        AAngle: float,
        ATp: Graphic3d_TextPath,
        AHta: Graphic3d_HorizontalTextAlignment,
        AVta: Graphic3d_VerticalTextAlignment,
        EvalMinMax: Optional[bool] = True,
    ) -> None: ...
    @overload
    def Text(
        self,
        AText: str,
        APoint: Graphic3d_Vertex,
        AHeight: float,
        EvalMinMax: Optional[bool] = True,
    ) -> None: ...
    @overload
    def Text(
        self,
        theTextUtf: str,
        theOrientation: gp_Ax2,
        theHeight: float,
        theAngle: float,
        theTp: Graphic3d_TextPath,
        theHTA: Graphic3d_HorizontalTextAlignment,
        theVTA: Graphic3d_VerticalTextAlignment,
        theToEvalMinMax: Optional[bool] = True,
        theHasOwnAnchor: Optional[bool] = True,
    ) -> None: ...
    @overload
    def Text(
        self,
        theText: str,
        theOrientation: gp_Ax2,
        theHeight: float,
        theAngle: float,
        theTp: Graphic3d_TextPath,
        theHTA: Graphic3d_HorizontalTextAlignment,
        theVTA: Graphic3d_VerticalTextAlignment,
        theToEvalMinMax: Optional[bool] = True,
        theHasOwnAnchor: Optional[bool] = True,
    ) -> None: ...
    def TransformPersistence(self) -> Graphic3d_TransformPers: ...
    def Transformation(self) -> gp_Trsf: ...

class Graphic3d_HatchStyle(Standard_Transient):
    @overload
    def __init__(self, thePattern: Image_PixMap) -> None: ...
    @overload
    def __init__(self, theType: Aspect_HatchStyle) -> None: ...
    def DumpJson(self, depth: Optional[int] = -1) -> str: ...
    def HatchType(self) -> int: ...
    def Pattern(self) -> str: ...

class Graphic3d_Layer(Standard_Transient):
    def Add(
        self,
        theStruct: Graphic3d_CStructure,
        thePriority: Graphic3d_DisplayPriority,
        isForChangePriority: Optional[bool] = False,
    ) -> None: ...
    def Append(self, theOther: Graphic3d_Layer) -> bool: ...
    def ArrayOfStructures(self) -> Graphic3d_ArrayOfIndexedMapOfStructure: ...
    def BoundingBox(
        self,
        theViewId: int,
        theCamera: Graphic3d_Camera,
        theWindowWidth: int,
        theWindowHeight: int,
        theToIncludeAuxiliary: bool,
    ) -> Bnd_Box: ...
    def CullableStructuresBVH(self) -> Graphic3d_BvhCStructureSet: ...
    def CullableTrsfPersStructuresBVH(self) -> Graphic3d_BvhCStructureSetTrsfPers: ...
    def DumpJson(self, depth: Optional[int] = -1) -> str: ...
    def InvalidateBVHData(self) -> None: ...
    def InvalidateBoundingBox(self) -> None: ...
    def IsCulled(self) -> bool: ...
    def IsImmediate(self) -> bool: ...
    def LayerId(self) -> Graphic3d_ZLayerId: ...
    def LayerSettings(self) -> Graphic3d_ZLayerSettings: ...
    def NbOfTransformPersistenceObjects(self) -> int: ...
    def NbPriorities(self) -> int: ...
    def NbStructures(self) -> int: ...
    def NbStructuresNotCulled(self) -> int: ...
    def NonCullableStructures(self) -> False: ...
    def Remove(
        self,
        theStruct: Graphic3d_CStructure,
        isForChangePriority: Optional[bool] = False,
    ) -> Tuple[bool, Graphic3d_DisplayPriority]: ...
    def SetLayerSettings(self, theSettings: Graphic3d_ZLayerSettings) -> None: ...
    def Structures(
        self, thePriority: Graphic3d_DisplayPriority
    ) -> Graphic3d_IndexedMapOfStructure: ...
    def considerZoomPersistenceObjects(
        self,
        theViewId: int,
        theCamera: Graphic3d_Camera,
        theWindowWidth: int,
        theWindowHeight: int,
    ) -> float: ...

class Graphic3d_LightSet(Standard_Transient):
    def __init__(self) -> None: ...
    def Add(self, theLight: Graphic3d_CLight) -> bool: ...
    def AmbientColor(self) -> Graphic3d_Vec4: ...
    def Contains(self, theLight: Graphic3d_CLight) -> bool: ...
    def Extent(self) -> int: ...
    def IsEmpty(self) -> bool: ...
    def KeyEnabledLong(self) -> str: ...
    def KeyEnabledShort(self) -> str: ...
    def Lower(self) -> int: ...
    def NbCastShadows(self) -> int: ...
    def NbEnabled(self) -> int: ...
    def NbEnabledLightsOfType(self, theType: Graphic3d_TypeOfLightSource) -> int: ...
    def NbLightsOfType(self, theType: Graphic3d_TypeOfLightSource) -> int: ...
    def Remove(self, theLight: Graphic3d_CLight) -> bool: ...
    def Revision(self) -> int: ...
    def UpdateRevision(self) -> int: ...
    def Upper(self) -> int: ...
    def Value(self, theIndex: int) -> Graphic3d_CLight: ...

class Graphic3d_MarkerImage(Standard_Transient):
    @overload
    def __init__(
        self,
        theImage: Image_PixMap,
        theImageAlpha: Optional[Image_PixMap] = Image_PixMap(),
    ) -> None: ...
    @overload
    def __init__(
        self, theBitMap: TColStd_HArray1OfByte, theWidth: int, theHeight: int
    ) -> None: ...
    def GetBitMapArray(
        self, theAlphaValue: Optional[float] = 0.5, theIsTopDown: Optional[bool] = false
    ) -> TColStd_HArray1OfByte: ...
    def GetImage(self) -> Image_PixMap: ...
    def GetImageAlpha(self) -> Image_PixMap: ...
    def GetImageAlphaId(self) -> str: ...
    def GetImageId(self) -> str: ...
    def GetTextureSize(self) -> Tuple[int, int]: ...
    def IsColoredImage(self) -> bool: ...
    @staticmethod
    def StandardMarker(
        theMarkerType: Aspect_TypeOfMarker, theScale: float, theColor: Graphic3d_Vec4
    ) -> Graphic3d_MarkerImage: ...

class Graphic3d_MaterialAspect:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theName: Graphic3d_NameOfMaterial) -> None: ...
    def Alpha(self) -> float: ...
    def AmbientColor(self) -> Quantity_Color: ...
    def BSDF(self) -> Graphic3d_BSDF: ...
    def Color(self) -> Quantity_Color: ...
    def DiffuseColor(self) -> Quantity_Color: ...
    def DumpJson(self, depth: Optional[int] = -1) -> str: ...
    def EmissiveColor(self) -> Quantity_Color: ...
    def IncreaseShine(self, theDelta: float) -> None: ...
    def IsDifferent(self, theOther: Graphic3d_MaterialAspect) -> bool: ...
    def IsEqual(self, theOther: Graphic3d_MaterialAspect) -> bool: ...
    @overload
    @staticmethod
    def MaterialFromName(theName: str) -> Tuple[bool, Graphic3d_NameOfMaterial]: ...
    @overload
    @staticmethod
    def MaterialFromName(theName: str) -> Graphic3d_NameOfMaterial: ...
    @overload
    @staticmethod
    def MaterialName(theRank: int) -> str: ...
    @overload
    def MaterialName(self) -> str: ...
    @overload
    @staticmethod
    def MaterialType(theRank: int) -> Graphic3d_TypeOfMaterial: ...
    @overload
    def MaterialType(self) -> Graphic3d_TypeOfMaterial: ...
    @overload
    def MaterialType(self, theType: Graphic3d_TypeOfMaterial) -> bool: ...
    def Name(self) -> Graphic3d_NameOfMaterial: ...
    @staticmethod
    def NumberOfMaterials() -> int: ...
    def PBRMaterial(self) -> Graphic3d_PBRMaterial: ...
    def ReflectionMode(self, theType: Graphic3d_TypeOfReflection) -> bool: ...
    def RefractionIndex(self) -> float: ...
    def RequestedName(self) -> Graphic3d_NameOfMaterial: ...
    def Reset(self) -> None: ...
    def SetAlpha(self, theValue: float) -> None: ...
    def SetAmbientColor(self, theColor: Quantity_Color) -> None: ...
    def SetBSDF(self, theBSDF: Graphic3d_BSDF) -> None: ...
    def SetColor(self, theColor: Quantity_Color) -> None: ...
    def SetDiffuseColor(self, theColor: Quantity_Color) -> None: ...
    def SetEmissiveColor(self, theColor: Quantity_Color) -> None: ...
    def SetMaterialName(self, theName: str) -> None: ...
    def SetMaterialType(self, theType: Graphic3d_TypeOfMaterial) -> None: ...
    def SetPBRMaterial(self, thePBRMaterial: Graphic3d_PBRMaterial) -> None: ...
    def SetReflectionModeOff(self, theType: Graphic3d_TypeOfReflection) -> None: ...
    def SetRefractionIndex(self, theValue: float) -> None: ...
    def SetShininess(self, theValue: float) -> None: ...
    def SetSpecularColor(self, theColor: Quantity_Color) -> None: ...
    def SetTransparency(self, theValue: float) -> None: ...
    def Shininess(self) -> float: ...
    def SpecularColor(self) -> Quantity_Color: ...
    def StringName(self) -> str: ...
    def Transparency(self) -> float: ...

class Graphic3d_PBRMaterial:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theBSDF: Graphic3d_BSDF) -> None: ...
    def Alpha(self) -> float: ...
    def Color(self) -> Quantity_ColorRGBA: ...
    def DumpJson(self, depth: Optional[int] = -1) -> str: ...
    def Emission(self) -> Graphic3d_Vec3: ...
    @staticmethod
    def GenerateEnvLUT(
        theLUT: Image_PixMap, theNbIntegralSamples: Optional[int] = 1024
    ) -> None: ...
    def IOR(self) -> float: ...
    def Metallic(self) -> float: ...
    @staticmethod
    def MetallicFromSpecular(theSpecular: Quantity_Color) -> float: ...
    @staticmethod
    def MinRoughness() -> float: ...
    def NormalizedRoughness(self) -> float: ...
    @overload
    @staticmethod
    def Roughness(theNormalizedRoughness: float) -> float: ...
    @overload
    def Roughness(self) -> float: ...
    @staticmethod
    def RoughnessFromSpecular(
        theSpecular: Quantity_Color, theShiness: float
    ) -> float: ...
    def SetAlpha(self, theAlpha: float) -> None: ...
    def SetBSDF(self, theBSDF: Graphic3d_BSDF) -> None: ...
    @overload
    def SetColor(self, theColor: Quantity_ColorRGBA) -> None: ...
    @overload
    def SetColor(self, theColor: Quantity_Color) -> None: ...
    def SetEmission(self, theEmission: Graphic3d_Vec3) -> None: ...
    def SetIOR(self, theIOR: float) -> None: ...
    def SetMetallic(self, theMetallic: float) -> None: ...
    def SetRoughness(self, theRoughness: float) -> None: ...
    @staticmethod
    def SpecIBLMapSamplesFactor(
        theProbability: float, theRoughness: float
    ) -> float: ...

class Graphic3d_PolygonOffset:
    def __init__(self) -> None: ...
    def DumpJson(self, depth: Optional[int] = -1) -> str: ...

class Graphic3d_PresentationAttributes(Standard_Transient):
    def __init__(self) -> None: ...
    def BasicFillAreaAspect(self) -> Graphic3d_AspectFillArea3d: ...
    def Color(self) -> Quantity_Color: ...
    def ColorRGBA(self) -> Quantity_ColorRGBA: ...
    def DisplayMode(self) -> int: ...
    def DumpJson(self, depth: Optional[int] = -1) -> str: ...
    def Method(self) -> Aspect_TypeOfHighlightMethod: ...
    def SetBasicFillAreaAspect(self, theAspect: Graphic3d_AspectFillArea3d) -> None: ...
    def SetColor(self, theColor: Quantity_Color) -> None: ...
    def SetDisplayMode(self, theMode: int) -> None: ...
    def SetMethod(self, theMethod: Aspect_TypeOfHighlightMethod) -> None: ...
    def SetTransparency(self, theTranspCoef: float) -> None: ...
    def SetZLayer(self, theLayer: int) -> None: ...
    def Transparency(self) -> float: ...
    def ZLayer(self) -> Graphic3d_ZLayerId: ...

class Graphic3d_RenderingParams:
    def __init__(self) -> None: ...
    def DumpJson(self, depth: Optional[int] = -1) -> str: ...
    def ResolutionRatio(self) -> float: ...

class Graphic3d_SequenceOfHClipPlane(Standard_Transient):
    def __init__(self) -> None: ...
    def Append(self, theItem: Graphic3d_ClipPlane) -> bool: ...
    def Clear(self) -> None: ...
    def DumpJson(self, depth: Optional[int] = -1) -> str: ...
    def First(self) -> Graphic3d_ClipPlane: ...
    def IsEmpty(self) -> bool: ...
    def SetOverrideGlobal(self, theToOverride: bool) -> None: ...
    def Size(self) -> int: ...
    def ToOverrideGlobal(self) -> bool: ...

class Graphic3d_ShaderAttribute(Standard_Transient):
    def __init__(self, theName: str, theLocation: int) -> None: ...
    def Location(self) -> int: ...
    def Name(self) -> str: ...

class Graphic3d_ShaderManager(Standard_Transient):
    def __init__(self, theGapi: Aspect_GraphicsLibrary) -> None: ...
    def EnableGlslExtension(
        self, theExt: Graphic3d_GlslExtension, theToEnable: Optional[bool] = true
    ) -> None: ...
    def GapiVersionMajor(self) -> int: ...
    def GapiVersionMinor(self) -> int: ...
    def HasFlatShading(self) -> bool: ...
    def HasGlslExtension(self, theExt: Graphic3d_GlslExtension) -> bool: ...
    def IsGapiGreaterEqual(self, theVerMajor: int, theVerMinor: int) -> bool: ...
    def SetEmulateDepthClamp(self, theToEmulate: bool) -> None: ...
    def SetFlatShading(self, theToUse: bool, theToReverseSign: bool) -> None: ...
    def SetGapiVersion(self, theVerMajor: int, theVerMinor: int) -> None: ...
    def SetUseRedAlpha(self, theUseRedAlpha: bool) -> None: ...
    def ToEmulateDepthClamp(self) -> bool: ...
    def ToReverseDFdxSign(self) -> bool: ...
    def UseRedAlpha(self) -> bool: ...

class Graphic3d_ShaderObject(Standard_Transient):
    @staticmethod
    def CreateFromFile(
        theType: Graphic3d_TypeOfShaderObject, thePath: str
    ) -> Graphic3d_ShaderObject: ...
    @staticmethod
    def CreateFromSource(
        theType: Graphic3d_TypeOfShaderObject, theSource: str
    ) -> Graphic3d_ShaderObject: ...
    def GetId(self) -> str: ...
    def IsDone(self) -> bool: ...
    def Path(self) -> OSD_Path: ...
    def Source(self) -> str: ...
    def Type(self) -> Graphic3d_TypeOfShaderObject: ...

class Graphic3d_ShaderProgram(Standard_Transient):
    def __init__(self) -> None: ...
    def AppendToHeader(self, theHeaderLine: str) -> None: ...
    def AttachShader(self, theShader: Graphic3d_ShaderObject) -> bool: ...
    def ClearVariables(self) -> None: ...
    def DetachShader(self, theShader: Graphic3d_ShaderObject) -> bool: ...
    def GetId(self) -> str: ...
    def HasAlphaTest(self) -> bool: ...
    def HasDefaultSampler(self) -> bool: ...
    def Header(self) -> str: ...
    def IsDone(self) -> bool: ...
    def IsPBR(self) -> bool: ...
    def NbClipPlanesMax(self) -> int: ...
    def NbFragmentOutputs(self) -> int: ...
    def NbLightsMax(self) -> int: ...
    def NbShadowMaps(self) -> int: ...
    def OitOutput(self) -> Graphic3d_RenderTransparentMethod: ...
    def PushVariableFloat(self, theName: str, theValue: float) -> bool: ...
    def PushVariableInt(self, theName: str, theValue: int) -> bool: ...
    def PushVariableVec2(self, theName: str, theValue: Graphic3d_Vec2) -> bool: ...
    def PushVariableVec2i(self, theName: str, theValue: Graphic3d_Vec2i) -> bool: ...
    def PushVariableVec3(self, theName: str, theValue: Graphic3d_Vec3) -> bool: ...
    def PushVariableVec3i(self, theName: str, theValue: Graphic3d_Vec3i) -> bool: ...
    def PushVariableVec4(self, theName: str, theValue: Graphic3d_Vec4) -> bool: ...
    def PushVariableVec4i(self, theName: str, theValue: Graphic3d_Vec4i) -> bool: ...
    def SetAlphaTest(self, theAlphaTest: bool) -> None: ...
    def SetDefaultSampler(self, theHasDefSampler: bool) -> None: ...
    def SetHeader(self, theHeader: str) -> None: ...
    def SetId(self, theId: str) -> None: ...
    def SetNbClipPlanesMax(self, theNbPlanes: int) -> None: ...
    def SetNbFragmentOutputs(self, theNbOutputs: int) -> None: ...
    def SetNbLightsMax(self, theNbLights: int) -> None: ...
    def SetNbShadowMaps(self, theNbMaps: int) -> None: ...
    def SetOitOutput(self, theOutput: Graphic3d_RenderTransparentMethod) -> None: ...
    def SetPBR(self, theIsPBR: bool) -> None: ...
    def SetTextureSetBits(self, theBits: int) -> None: ...
    def SetVertexAttributes(
        self, theAttributes: Graphic3d_ShaderAttributeList
    ) -> None: ...
    def ShaderObjects(self) -> Graphic3d_ShaderObjectList: ...
    @staticmethod
    def ShadersFolder() -> str: ...
    def TextureSetBits(self) -> int: ...
    def Variables(self) -> Graphic3d_ShaderVariableList: ...
    def VertexAttributes(self) -> Graphic3d_ShaderAttributeList: ...

class Graphic3d_ShaderVariable(Standard_Transient):
    def IsDone(self) -> bool: ...
    def Name(self) -> str: ...
    def Value(self) -> Graphic3d_ValueInterface: ...

class Graphic3d_Structure(Standard_Transient):
    def __init__(
        self,
        theManager: Graphic3d_StructureManager,
        theLinkPrs: Optional[Graphic3d_Structure] = Graphic3d_Structure(),
    ) -> None: ...
    @staticmethod
    def AcceptConnection(
        theStructure1: Graphic3d_Structure,
        theStructure2: Graphic3d_Structure,
        theType: Graphic3d_TypeOfConnection,
    ) -> bool: ...
    def Ancestors(self, SG: Graphic3d_MapOfStructure) -> None: ...
    def CStructure(self) -> Graphic3d_CStructure: ...
    def CalculateBoundBox(self) -> None: ...
    def Clear(self, WithDestruction: Optional[bool] = True) -> None: ...
    def ClipPlanes(self) -> Graphic3d_SequenceOfHClipPlane: ...
    def Compute(self) -> None: ...
    def ComputeVisual(self) -> Graphic3d_TypeOfStructure: ...
    @overload
    def Connect(
        self,
        theStructure: Graphic3d_Structure,
        theType: Graphic3d_TypeOfConnection,
        theWithCheck: Optional[bool] = False,
    ) -> None: ...
    @overload
    def Connect(self, thePrs: Graphic3d_Structure) -> None: ...
    def CurrentGroup(self) -> Graphic3d_Group: ...
    def Descendants(self, SG: Graphic3d_MapOfStructure) -> None: ...
    def Disconnect(self, theStructure: Graphic3d_Structure) -> None: ...
    def DisconnectAll(self, AType: Graphic3d_TypeOfConnection) -> None: ...
    def Display(self) -> None: ...
    def DisplayPriority(self) -> Graphic3d_DisplayPriority: ...
    def DumpJson(self, depth: Optional[int] = -1) -> str: ...
    def Erase(self) -> None: ...
    def GetZLayer(self) -> Graphic3d_ZLayerId: ...
    def GraphicClear(self, WithDestruction: bool) -> None: ...
    def GraphicConnect(self, theDaughter: Graphic3d_Structure) -> None: ...
    def GraphicDisconnect(self, theDaughter: Graphic3d_Structure) -> None: ...
    def GraphicTransform(self, theTrsf: TopLoc_Datum3D) -> None: ...
    def Groups(self) -> Graphic3d_SequenceOfGroup: ...
    def HLRValidation(self) -> bool: ...
    def Highlight(
        self,
        theStyle: Graphic3d_PresentationAttributes,
        theToUpdateMgr: Optional[bool] = True,
    ) -> None: ...
    def HighlightStyle(self) -> Graphic3d_PresentationAttributes: ...
    def Identification(self) -> int: ...
    def IsDeleted(self) -> bool: ...
    def IsDisplayed(self) -> bool: ...
    def IsEmpty(self) -> bool: ...
    def IsHighlighted(self) -> bool: ...
    def IsInfinite(self) -> bool: ...
    def IsMutable(self) -> bool: ...
    def IsTransformed(self) -> bool: ...
    def IsVisible(self) -> bool: ...
    def MinMaxValues(
        self, theToIgnoreInfiniteFlag: Optional[bool] = False
    ) -> Bnd_Box: ...
    def NewGroup(self) -> Graphic3d_Group: ...
    def NumberOfGroups(self) -> int: ...
    def Owner(self) -> None: ...
    @staticmethod
    def PrintNetwork(
        AStructure: Graphic3d_Structure, AType: Graphic3d_TypeOfConnection
    ) -> None: ...
    @overload
    def ReCompute(self) -> None: ...
    @overload
    def ReCompute(self, aProjector: Graphic3d_DataStructureManager) -> None: ...
    def RecomputeTransformation(self, theProjector: Graphic3d_Camera) -> None: ...
    @overload
    def Remove(self) -> None: ...
    @overload
    def Remove(self, thePrs: Graphic3d_Structure) -> None: ...
    @overload
    def Remove(
        self, thePtr: Graphic3d_Structure, theType: Graphic3d_TypeOfConnection
    ) -> None: ...
    def RemoveAll(self) -> None: ...
    def ResetDisplayPriority(self) -> None: ...
    def SetClipPlanes(self, thePlanes: Graphic3d_SequenceOfHClipPlane) -> None: ...
    def SetComputeVisual(self, theVisual: Graphic3d_TypeOfStructure) -> None: ...
    @overload
    def SetDisplayPriority(self, thePriority: Graphic3d_DisplayPriority) -> None: ...
    @overload
    def SetDisplayPriority(self, thePriority: int) -> None: ...
    def SetHLRValidation(self, theFlag: bool) -> None: ...
    def SetInfiniteState(self, theToSet: bool) -> None: ...
    def SetIsForHighlight(self, isForHighlight: bool) -> None: ...
    def SetMutable(self, theIsMutable: bool) -> None: ...
    def SetOwner(self, theOwner: None) -> None: ...
    def SetTransformPersistence(self, theTrsfPers: Graphic3d_TransformPers) -> None: ...
    def SetTransformation(self, theTrsf: TopLoc_Datum3D) -> None: ...
    def SetVisible(self, AValue: bool) -> None: ...
    def SetVisual(self, AVisual: Graphic3d_TypeOfStructure) -> None: ...
    def SetZLayer(self, theLayerId: int) -> None: ...
    def SetZoomLimit(self, LimitInf: float, LimitSup: float) -> None: ...
    def TransformPersistence(self) -> Graphic3d_TransformPers: ...
    def Transformation(self) -> TopLoc_Datum3D: ...
    @staticmethod
    def Transforms(
        theTrsf: gp_Trsf, theX: float, theY: float, theZ: float
    ) -> Tuple[float, float, float]: ...
    def UnHighlight(self) -> None: ...
    def Visual(self) -> Graphic3d_TypeOfStructure: ...
    def computeHLR(
        self, theProjector: Graphic3d_Camera, theStructure: Graphic3d_Structure
    ) -> None: ...

class Graphic3d_StructureManager(Standard_Transient):
    def __init__(self, theDriver: Graphic3d_GraphicDriver) -> None: ...
    def ChangeDisplayPriority(
        self,
        theStructure: Graphic3d_Structure,
        theOldPriority: Graphic3d_DisplayPriority,
        theNewPriority: Graphic3d_DisplayPriority,
    ) -> None: ...
    def ChangeZLayer(
        self, theStructure: Graphic3d_Structure, theLayerId: int
    ) -> None: ...
    def Clear(
        self, theStructure: Graphic3d_Structure, theWithDestruction: bool
    ) -> None: ...
    def Connect(
        self, theMother: Graphic3d_Structure, theDaughter: Graphic3d_Structure
    ) -> None: ...
    def DefinedViews(self) -> Graphic3d_IndexedMapOfView: ...
    def Disconnect(
        self, theMother: Graphic3d_Structure, theDaughter: Graphic3d_Structure
    ) -> None: ...
    def Display(self, theStructure: Graphic3d_Structure) -> None: ...
    def DisplayedStructures(self, SG: Graphic3d_MapOfStructure) -> None: ...
    def DumpJson(self, depth: Optional[int] = -1) -> str: ...
    @overload
    def Erase(self) -> None: ...
    @overload
    def Erase(self, theStructure: Graphic3d_Structure) -> None: ...
    def GraphicDriver(self) -> Graphic3d_GraphicDriver: ...
    def Highlight(self, theStructure: Graphic3d_Structure) -> None: ...
    def HighlightedStructures(self, SG: Graphic3d_MapOfStructure) -> None: ...
    @overload
    def Identification(self, theView: Graphic3d_CView) -> int: ...
    @overload
    def Identification(self, AId: int) -> Graphic3d_Structure: ...
    def IsDeviceLost(self) -> bool: ...
    def MaxNumOfViews(self) -> int: ...
    def ObjectAffinity(
        self, theObject: Standard_Transient
    ) -> Graphic3d_ViewAffinity: ...
    @overload
    def ReCompute(self, theStructure: Graphic3d_Structure) -> None: ...
    @overload
    def ReCompute(
        self,
        theStructure: Graphic3d_Structure,
        theProjector: Graphic3d_DataStructureManager,
    ) -> None: ...
    @overload
    def RecomputeStructures(self) -> None: ...
    def RegisterObject(
        self, theObject: Standard_Transient, theAffinity: Graphic3d_ViewAffinity
    ) -> None: ...
    def Remove(self) -> None: ...
    def SetDeviceLost(self) -> None: ...
    def SetTransform(
        self, theStructure: Graphic3d_Structure, theTrsf: TopLoc_Datum3D
    ) -> None: ...
    @overload
    def UnHighlight(self, AStructure: Graphic3d_Structure) -> None: ...
    @overload
    def UnHighlight(self) -> None: ...
    def UnIdentification(self, theView: Graphic3d_CView) -> None: ...
    def UnregisterObject(self, theObject: Standard_Transient) -> None: ...
    def Update(
        self, theLayerId: Optional[int] = Graphic3d_ZLayerId_UNKNOWN
    ) -> None: ...

class Graphic3d_Text(Standard_Transient):
    def __init__(self, theHeight: float) -> None: ...
    def HasOwnAnchorPoint(self) -> bool: ...
    def HasPlane(self) -> bool: ...
    def Height(self) -> float: ...
    def HorizontalAlignment(self) -> Graphic3d_HorizontalTextAlignment: ...
    def Orientation(self) -> gp_Ax2: ...
    def Position(self) -> gp_Pnt: ...
    def ResetOrientation(self) -> None: ...
    def SetHeight(self, theHeight: float) -> None: ...
    def SetHorizontalAlignment(
        self, theJustification: Graphic3d_HorizontalTextAlignment
    ) -> None: ...
    def SetOrientation(self, theOrientation: gp_Ax2) -> None: ...
    def SetOwnAnchorPoint(self, theHasOwnAnchor: bool) -> None: ...
    def SetPosition(self, thePoint: gp_Pnt) -> None: ...
    @overload
    def SetText(self, theText: NCollection_String) -> None: ...
    @overload
    def SetText(self, theText: str) -> None: ...
    @overload
    def SetText(self, theText: str) -> None: ...
    def SetVerticalAlignment(
        self, theJustification: Graphic3d_VerticalTextAlignment
    ) -> None: ...
    def Text(self) -> NCollection_String: ...
    def TextFormatter(self) -> False: ...
    def VerticalAlignment(self) -> Graphic3d_VerticalTextAlignment: ...

class Graphic3d_TextureParams(Standard_Transient):
    def __init__(self) -> None: ...
    def AnisoFilter(self) -> Graphic3d_LevelOfTextureAnisotropy: ...
    def BaseLevel(self) -> int: ...
    def Filter(self) -> Graphic3d_TypeOfTextureFilter: ...
    def GenMode(self) -> Graphic3d_TypeOfTextureMode: ...
    def GenPlaneS(self) -> Graphic3d_Vec4: ...
    def GenPlaneT(self) -> Graphic3d_Vec4: ...
    def IsModulate(self) -> bool: ...
    def IsRepeat(self) -> bool: ...
    def MaxLevel(self) -> int: ...
    def Rotation(self) -> float: ...
    def SamplerRevision(self) -> int: ...
    def Scale(self) -> Graphic3d_Vec2: ...
    def SetAnisoFilter(self, theLevel: Graphic3d_LevelOfTextureAnisotropy) -> None: ...
    def SetFilter(self, theFilter: Graphic3d_TypeOfTextureFilter) -> None: ...
    def SetGenMode(
        self,
        theMode: Graphic3d_TypeOfTextureMode,
        thePlaneS: Graphic3d_Vec4,
        thePlaneT: Graphic3d_Vec4,
    ) -> None: ...
    def SetLevelsRange(
        self, theFirstLevel: int, theSecondLevel: Optional[int] = 0
    ) -> None: ...
    def SetModulate(self, theToModulate: bool) -> None: ...
    def SetRepeat(self, theToRepeat: bool) -> None: ...
    def SetRotation(self, theAngleDegrees: float) -> None: ...
    def SetScale(self, theScale: Graphic3d_Vec2) -> None: ...
    def SetTextureUnit(self, theUnit: Graphic3d_TextureUnit) -> None: ...
    def SetTranslation(self, theVec: Graphic3d_Vec2) -> None: ...
    def TextureUnit(self) -> Graphic3d_TextureUnit: ...
    def Translation(self) -> Graphic3d_Vec2: ...

class Graphic3d_TextureRoot(Standard_Transient):
    def GetCompressedImage(
        self, theSupported: Image_SupportedFormats
    ) -> Image_CompressedPixMap: ...
    def GetId(self) -> str: ...
    def GetImage(self, theSupported: Image_SupportedFormats) -> Image_PixMap: ...
    def GetParams(self) -> Graphic3d_TextureParams: ...
    def HasMipmaps(self) -> bool: ...
    def IsColorMap(self) -> bool: ...
    def IsDone(self) -> bool: ...
    def IsTopDown(self) -> bool: ...
    def Path(self) -> OSD_Path: ...
    def Revision(self) -> int: ...
    def SetColorMap(self, theIsColor: bool) -> None: ...
    def SetMipmapsGeneration(self, theToGenerateMipmaps: bool) -> None: ...
    @staticmethod
    def TexturesFolder() -> str: ...
    def Type(self) -> Graphic3d_TypeOfTexture: ...
    def UpdateRevision(self) -> None: ...

class Graphic3d_TransformPers(Standard_Transient):
    @overload
    def __init__(self, theMode: Graphic3d_TransModeFlags) -> None: ...
    @overload
    def __init__(self, theMode: Graphic3d_TransModeFlags, thePnt: gp_Pnt) -> None: ...
    @overload
    def __init__(
        self,
        theMode: Graphic3d_TransModeFlags,
        theCorner: Aspect_TypeOfTriedronPosition,
        theOffset: Optional[Graphic3d_Vec2i] = Graphic3d_Vec2i(0, 0),
    ) -> None: ...
    def AnchorPoint(self) -> gp_Pnt: ...
    def ComputeApply(
        self,
        theCamera: Graphic3d_Camera,
        theViewportWidth: int,
        theViewportHeight: int,
        theAnchor: Optional[gp_Pnt] = None,
    ) -> False: ...
    def Corner2d(self) -> Aspect_TypeOfTriedronPosition: ...
    def DumpJson(self, depth: Optional[int] = -1) -> str: ...
    def Flags(self) -> Graphic3d_TransModeFlags: ...
    @overload
    @staticmethod
    def IsAxial(theMode: Graphic3d_TransModeFlags) -> bool: ...
    @overload
    def IsAxial(self) -> bool: ...
    @overload
    @staticmethod
    def IsOrthoPers(theMode: Graphic3d_TransModeFlags) -> bool: ...
    @overload
    def IsOrthoPers(self) -> bool: ...
    @overload
    @staticmethod
    def IsTrihedronOr2d(theMode: Graphic3d_TransModeFlags) -> bool: ...
    @overload
    def IsTrihedronOr2d(self) -> bool: ...
    @overload
    @staticmethod
    def IsZoomOrRotate(theMode: Graphic3d_TransModeFlags) -> bool: ...
    @overload
    def IsZoomOrRotate(self) -> bool: ...
    def Mode(self) -> Graphic3d_TransModeFlags: ...
    def Offset2d(self) -> Graphic3d_Vec2i: ...
    def SetAnchorPoint(self, thePnt: gp_Pnt) -> None: ...
    def SetCorner2d(self, thePos: Aspect_TypeOfTriedronPosition) -> None: ...
    def SetOffset2d(self, theOffset: Graphic3d_Vec2i) -> None: ...
    @overload
    def SetPersistence(
        self, theMode: Graphic3d_TransModeFlags, thePnt: gp_Pnt
    ) -> None: ...
    @overload
    def SetPersistence(
        self,
        theMode: Graphic3d_TransModeFlags,
        theCorner: Aspect_TypeOfTriedronPosition,
        theOffset: Graphic3d_Vec2i,
    ) -> None: ...
    def persistentRotationMatrix(
        self, theCamera: Graphic3d_Camera, theViewportWidth: int, theViewportHeight: int
    ) -> False: ...
    def persistentScale(
        self, theCamera: Graphic3d_Camera, theViewportWidth: int, theViewportHeight: int
    ) -> float: ...

class Graphic3d_UniformValueTypeID:
    pass

class Graphic3d_UniformValueTypeID:
    pass

class Graphic3d_UniformValueTypeID:
    pass

class Graphic3d_UniformValueTypeID:
    pass

class Graphic3d_UniformValueTypeID:
    pass

class Graphic3d_UniformValueTypeID:
    pass

class Graphic3d_UniformValueTypeID:
    pass

class Graphic3d_UniformValueTypeID:
    pass

class Graphic3d_ValidatedCubeMapOrder:
    def __init__(self, theOther: Graphic3d_ValidatedCubeMapOrder) -> None: ...

class Graphic3d_ValueInterface:
    def TypeID(self) -> int: ...

class Graphic3d_Vertex:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theX: float, theY: float, theZ: float) -> None: ...
    @overload
    def __init__(self, theX: float, theY: float, theZ: float) -> None: ...
    @overload
    def Coord(self) -> Tuple[float, float, float]: ...
    @overload
    def Coord(self) -> Tuple[float, float, float]: ...
    def Distance(self, theOther: Graphic3d_Vertex) -> float: ...
    def DumpJson(self, depth: Optional[int] = -1) -> str: ...
    @overload
    def SetCoord(self, theX: float, theY: float, theZ: float) -> None: ...
    @overload
    def SetCoord(self, theX: float, theY: float, theZ: float) -> None: ...
    def X(self) -> float: ...
    def Y(self) -> float: ...
    def Z(self) -> float: ...

class Graphic3d_ViewAffinity(Standard_Transient):
    def __init__(self) -> None: ...
    def DumpJson(self, depth: Optional[int] = -1) -> str: ...
    def IsVisible(self, theViewId: int) -> bool: ...
    @overload
    def SetVisible(self, theIsVisible: bool) -> None: ...
    @overload
    def SetVisible(self, theViewId: int, theIsVisible: bool) -> None: ...

class Graphic3d_WorldViewProjState:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(
        self,
        theProjectionState: int,
        theWorldViewState: int,
        theCamera: Optional[Standard_Transient] = None,
    ) -> None: ...
    def DumpJson(self, depth: Optional[int] = -1) -> str: ...
    @overload
    def Initialize(
        self,
        theProjectionState: int,
        theWorldViewState: int,
        theCamera: Optional[Standard_Transient] = None,
    ) -> None: ...
    @overload
    def Initialize(self, theCamera: Optional[Standard_Transient] = None) -> None: ...
    def IsChanged(self, theState: Graphic3d_WorldViewProjState) -> bool: ...
    def IsProjectionChanged(self, theState: Graphic3d_WorldViewProjState) -> bool: ...
    def IsValid(self) -> bool: ...
    def IsWorldViewChanged(self, theState: Graphic3d_WorldViewProjState) -> bool: ...
    def ProjectionState(self) -> int: ...
    def Reset(self) -> None: ...
    def WorldViewState(self) -> int: ...

class Graphic3d_ZLayerSettings:
    def __init__(self) -> None: ...
    def ChangePolygonOffset(self) -> Graphic3d_PolygonOffset: ...
    def CullingDistance(self) -> float: ...
    def CullingSize(self) -> float: ...
    def DumpJson(self, depth: Optional[int] = -1) -> str: ...
    def HasCullingDistance(self) -> bool: ...
    def HasCullingSize(self) -> bool: ...
    def IsImmediate(self) -> bool: ...
    def IsRaytracable(self) -> bool: ...
    def Lights(self) -> Graphic3d_LightSet: ...
    def Name(self) -> str: ...
    def Origin(self) -> gp_XYZ: ...
    def OriginTransformation(self) -> TopLoc_Datum3D: ...
    def PolygonOffset(self) -> Graphic3d_PolygonOffset: ...
    def SetClearDepth(self, theValue: bool) -> None: ...
    def SetCullingDistance(self, theDistance: float) -> None: ...
    def SetCullingSize(self, theSize: float) -> None: ...
    def SetDepthOffsetNegative(self) -> None: ...
    def SetDepthOffsetPositive(self) -> None: ...
    def SetEnableDepthTest(self, theValue: bool) -> None: ...
    def SetEnableDepthWrite(self, theValue: bool) -> None: ...
    def SetEnvironmentTexture(self, theValue: bool) -> None: ...
    def SetImmediate(self, theValue: bool) -> None: ...
    def SetLights(self, theLights: Graphic3d_LightSet) -> None: ...
    def SetName(self, theName: str) -> None: ...
    def SetOrigin(self, theOrigin: gp_XYZ) -> None: ...
    def SetPolygonOffset(self, theParams: Graphic3d_PolygonOffset) -> None: ...
    def SetRaytracable(self, theToRaytrace: bool) -> None: ...
    def SetRenderInDepthPrepass(self, theToRender: bool) -> None: ...
    def ToClearDepth(self) -> bool: ...
    def ToEnableDepthTest(self) -> bool: ...
    def ToEnableDepthWrite(self) -> bool: ...
    def ToRenderInDepthPrepass(self) -> bool: ...
    def UseEnvironmentTexture(self) -> bool: ...

class Graphic3d_ArrayOfPoints(Graphic3d_ArrayOfPrimitives):
    @overload
    def __init__(self, theMaxVertexs: int, theArrayFlags: int) -> None: ...
    @overload
    def __init__(
        self,
        theMaxVertexs: int,
        theHasVColors: Optional[bool] = False,
        theHasVNormals: Optional[bool] = False,
    ) -> None: ...

class Graphic3d_ArrayOfPolygons(Graphic3d_ArrayOfPrimitives):
    @overload
    def __init__(
        self,
        theMaxVertexs: int,
        theMaxBounds: int,
        theMaxEdges: int,
        theArrayFlags: int,
    ) -> None: ...
    @overload
    def __init__(
        self,
        theMaxVertexs: int,
        theMaxBounds: Optional[int] = 0,
        theMaxEdges: Optional[int] = 0,
        theHasVNormals: Optional[bool] = False,
        theHasVColors: Optional[bool] = False,
        theHasBColors: Optional[bool] = False,
        theHasVTexels: Optional[bool] = False,
    ) -> None: ...

class Graphic3d_ArrayOfPolylines(Graphic3d_ArrayOfPrimitives):
    @overload
    def __init__(
        self,
        theMaxVertexs: int,
        theMaxBounds: int,
        theMaxEdges: int,
        theArrayFlags: int,
    ) -> None: ...
    @overload
    def __init__(
        self,
        theMaxVertexs: int,
        theMaxBounds: Optional[int] = 0,
        theMaxEdges: Optional[int] = 0,
        theHasVColors: Optional[bool] = False,
        theHasBColors: Optional[bool] = False,
    ) -> None: ...

class Graphic3d_ArrayOfQuadrangleStrips(Graphic3d_ArrayOfPrimitives):
    @overload
    def __init__(
        self, theMaxVertexs: int, theMaxStrips: int, theArrayFlags: int
    ) -> None: ...
    @overload
    def __init__(
        self,
        theMaxVertexs: int,
        theMaxStrips: Optional[int] = 0,
        theHasVNormals: Optional[bool] = False,
        theHasVColors: Optional[bool] = False,
        theHasSColors: Optional[bool] = False,
        theHasVTexels: Optional[bool] = False,
    ) -> None: ...

class Graphic3d_ArrayOfQuadrangles(Graphic3d_ArrayOfPrimitives):
    @overload
    def __init__(
        self, theMaxVertexs: int, theMaxEdges: int, theArrayFlags: int
    ) -> None: ...
    @overload
    def __init__(
        self,
        theMaxVertexs: int,
        theMaxEdges: Optional[int] = 0,
        theHasVNormals: Optional[bool] = False,
        theHasVColors: Optional[bool] = False,
        theHasVTexels: Optional[bool] = False,
    ) -> None: ...

class Graphic3d_ArrayOfSegments(Graphic3d_ArrayOfPrimitives):
    @overload
    def __init__(
        self, theMaxVertexs: int, theMaxEdges: int, theArrayFlags: int
    ) -> None: ...
    @overload
    def __init__(
        self,
        theMaxVertexs: int,
        theMaxEdges: Optional[int] = 0,
        theHasVColors: Optional[bool] = False,
    ) -> None: ...

class Graphic3d_ArrayOfTriangleFans(Graphic3d_ArrayOfPrimitives):
    @overload
    def __init__(
        self, theMaxVertexs: int, theMaxFans: int, theArrayFlags: int
    ) -> None: ...
    @overload
    def __init__(
        self,
        theMaxVertexs: int,
        theMaxFans: Optional[int] = 0,
        theHasVNormals: Optional[bool] = False,
        theHasVColors: Optional[bool] = False,
        theHasBColors: Optional[bool] = False,
        theHasVTexels: Optional[bool] = False,
    ) -> None: ...

class Graphic3d_ArrayOfTriangleStrips(Graphic3d_ArrayOfPrimitives):
    @overload
    def __init__(
        self, theMaxVertexs: int, theMaxStrips: int, theArrayFlags: int
    ) -> None: ...
    @overload
    def __init__(
        self,
        theMaxVertexs: int,
        theMaxStrips: Optional[int] = 0,
        theHasVNormals: Optional[bool] = False,
        theHasVColors: Optional[bool] = False,
        theHasBColors: Optional[bool] = False,
        theHasVTexels: Optional[bool] = False,
    ) -> None: ...

class Graphic3d_ArrayOfTriangles(Graphic3d_ArrayOfPrimitives):
    @overload
    def __init__(
        self, theMaxVertexs: int, theMaxEdges: int, theArrayFlags: int
    ) -> None: ...
    @overload
    def __init__(
        self,
        theMaxVertexs: int,
        theMaxEdges: Optional[int] = 0,
        theHasVNormals: Optional[bool] = False,
        theHasVColors: Optional[bool] = False,
        theHasVTexels: Optional[bool] = False,
    ) -> None: ...

class Graphic3d_AspectFillArea3d(Graphic3d_Aspects):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(
        self,
        theInterior: Aspect_InteriorStyle,
        theInteriorColor: Quantity_Color,
        theEdgeColor: Quantity_Color,
        theEdgeLineType: Aspect_TypeOfLine,
        theEdgeWidth: float,
        theFrontMaterial: Graphic3d_MaterialAspect,
        theBackMaterial: Graphic3d_MaterialAspect,
    ) -> None: ...
    def Edge(self) -> bool: ...

class Graphic3d_AspectLine3d(Graphic3d_Aspects):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(
        self, theColor: Quantity_Color, theType: Aspect_TypeOfLine, theWidth: float
    ) -> None: ...
    def SetType(self, theType: Aspect_TypeOfLine) -> None: ...
    @overload
    def SetWidth(self, theWidth: float) -> None: ...
    @overload
    def SetWidth(self, theWidth: float) -> None: ...
    def Type(self) -> Aspect_TypeOfLine: ...
    def Width(self) -> float: ...

class Graphic3d_AspectMarker3d(Graphic3d_Aspects):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(
        self, theType: Aspect_TypeOfMarker, theColor: Quantity_Color, theScale: float
    ) -> None: ...
    @overload
    def __init__(
        self,
        theColor: Quantity_Color,
        theWidth: int,
        theHeight: int,
        theTextureBitmap: TColStd_HArray1OfByte,
    ) -> None: ...
    @overload
    def __init__(self, theTextureImage: Image_PixMap) -> None: ...
    def GetMarkerImage(self) -> Graphic3d_MarkerImage: ...
    def GetTextureSize(self) -> Tuple[int, int]: ...
    def Scale(self) -> float: ...
    def SetBitMap(
        self, theWidth: int, theHeight: int, theTexture: TColStd_HArray1OfByte
    ) -> None: ...
    @overload
    def SetScale(self, theScale: float) -> None: ...
    @overload
    def SetScale(self, theScale: float) -> None: ...
    def SetType(self, theType: Aspect_TypeOfMarker) -> None: ...
    def Type(self) -> Aspect_TypeOfMarker: ...

class Graphic3d_AspectText3d(Graphic3d_Aspects):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(
        self,
        theColor: Quantity_Color,
        theFont: str,
        theExpansionFactor: float,
        theSpace: float,
        theStyle: Optional[Aspect_TypeOfStyleText] = Aspect_TOST_NORMAL,
        theDisplayType: Optional[Aspect_TypeOfDisplayText] = Aspect_TODT_NORMAL,
    ) -> None: ...
    def Color(self) -> Quantity_Color: ...
    def ColorRGBA(self) -> Quantity_ColorRGBA: ...
    def DisplayType(self) -> Aspect_TypeOfDisplayText: ...
    def DumpJson(self, depth: Optional[int] = -1) -> str: ...
    def Font(self) -> str: ...
    def GetTextAngle(self) -> float: ...
    def GetTextFontAspect(self) -> False: ...
    def GetTextZoomable(self) -> bool: ...
    @overload
    def SetColor(self, theColor: Quantity_Color) -> None: ...
    @overload
    def SetColor(self, theColor: Quantity_ColorRGBA) -> None: ...
    def SetDisplayType(self, theDisplayType: Aspect_TypeOfDisplayText) -> None: ...
    @overload
    def SetFont(self, theFont: str) -> None: ...
    @overload
    def SetFont(self, theFont: str) -> None: ...
    def SetStyle(self, theStyle: Aspect_TypeOfStyleText) -> None: ...
    def SetTextAngle(self, theAngle: float) -> None: ...
    def Style(self) -> Aspect_TypeOfStyleText: ...

class Graphic3d_AttribBuffer(Graphic3d_Buffer):
    def __init__(self, theAlloc: NCollection_BaseAllocator) -> None: ...
    @overload
    def Init(
        self, theNbElems: int, theAttribs: Graphic3d_Attribute, theNbAttribs: int
    ) -> bool: ...
    @overload
    def Init(
        self, theNbElems: int, theAttribs: Graphic3d_Array1OfAttribute
    ) -> bool: ...
    @overload
    def Invalidate(self) -> None: ...
    @overload
    def Invalidate(self, theAttributeIndex: int) -> None: ...
    @overload
    def Invalidate(
        self, theAttributeIndex: int, theVertexLower: int, theVertexUpper: int
    ) -> None: ...
    @overload
    def Invalidate(self, theVertexLower: int, theVertexUpper: int) -> None: ...
    def InvalidatedRange(self) -> Graphic3d_BufferRange: ...
    def IsInterleaved(self) -> bool: ...
    def IsMutable(self) -> bool: ...
    def SetInterleaved(self, theIsInterleaved: bool) -> None: ...
    def SetMutable(self, theMutable: bool) -> None: ...
    def Validate(self) -> None: ...
    def invalidate(self, theRange: Graphic3d_BufferRange) -> None: ...

class Graphic3d_CView(Graphic3d_DataStructureManager):
    def Activate(self) -> None: ...
    def AddSubview(self, theView: Graphic3d_CView) -> None: ...
    def BackfacingModel(self) -> Graphic3d_TypeOfBackfacingModel: ...
    def Background(self) -> Aspect_Background: ...
    def BackgroundCubeMap(self) -> Graphic3d_CubeMap: ...
    def BackgroundImage(self) -> Graphic3d_TextureMap: ...
    def BackgroundImageStyle(self) -> Aspect_FillMethod: ...
    def BackgroundSkydome(self) -> Aspect_SkydomeBackground: ...
    def BackgroundType(self) -> Graphic3d_TypeOfBackground: ...
    def BaseXRCamera(self) -> Graphic3d_Camera: ...
    def BufferDump(
        self, theImage: Image_PixMap, theBufferType: Graphic3d_BufferType
    ) -> bool: ...
    def Camera(self) -> Graphic3d_Camera: ...
    def ChangeRenderingParams(self) -> Graphic3d_RenderingParams: ...
    def ClipPlanes(self) -> Graphic3d_SequenceOfHClipPlane: ...
    def Compute(self) -> None: ...
    def ComputeXRBaseCameraFromPosed(
        self, theCamPosed: Graphic3d_Camera, thePoseTrsf: gp_Trsf
    ) -> None: ...
    def ComputeXRPosedCameraFromBase(
        self, theCam: Graphic3d_Camera, theXRTrsf: gp_Trsf
    ) -> None: ...
    def ComputedMode(self) -> bool: ...
    def ConsiderZoomPersistenceObjects(self) -> float: ...
    def CopySettings(self, theOther: Graphic3d_CView) -> None: ...
    def Deactivate(self) -> None: ...
    def DiagnosticInformation(
        self,
        theDict: TColStd_IndexedDataMapOfStringString,
        theFlags: Graphic3d_DiagnosticInfo,
    ) -> None: ...
    def DisplayedStructures(self, theStructures: Graphic3d_MapOfStructure) -> None: ...
    def DumpJson(self, depth: Optional[int] = -1) -> str: ...
    def FBO(self) -> Standard_Transient: ...
    def FBOChangeViewport(
        self, theFbo: Standard_Transient, theWidth: int, theHeight: int
    ) -> None: ...
    def FBOCreate(self, theWidth: int, theHeight: int) -> Standard_Transient: ...
    def FBOGetDimensions(
        self, theFbo: Standard_Transient
    ) -> Tuple[int, int, int, int]: ...
    def FBORelease(self, theFbo: Standard_Transient) -> None: ...
    def GetGraduatedTrihedron(self) -> Graphic3d_GraduatedTrihedron: ...
    def GradientBackground(self) -> Aspect_GradientBackground: ...
    def GraduatedTrihedronDisplay(
        self, theTrihedronData: Graphic3d_GraduatedTrihedron
    ) -> None: ...
    def GraduatedTrihedronErase(self) -> None: ...
    def GraduatedTrihedronMinMaxValues(
        self, theMin: Graphic3d_Vec3, theMax: Graphic3d_Vec3
    ) -> None: ...
    def IBLCubeMap(self) -> Graphic3d_CubeMap: ...
    def Identification(self) -> int: ...
    def InitXR(self) -> bool: ...
    def InsertLayerAfter(
        self,
        theNewLayerId: int,
        theSettings: Graphic3d_ZLayerSettings,
        theLayerBefore: int,
    ) -> None: ...
    def InsertLayerBefore(
        self,
        theNewLayerId: int,
        theSettings: Graphic3d_ZLayerSettings,
        theLayerAfter: int,
    ) -> None: ...
    def Invalidate(self) -> None: ...
    def InvalidateBVHData(self, theLayerId: int) -> None: ...
    def InvalidateZLayerBoundingBox(self, theLayerId: int) -> None: ...
    def IsActive(self) -> bool: ...
    def IsActiveXR(self) -> bool: ...
    def IsComputed(
        self, theStructId: int, theComputedStruct: Graphic3d_Structure
    ) -> bool: ...
    def IsDefined(self) -> bool: ...
    def IsInvalidated(self) -> bool: ...
    def IsRemoved(self) -> bool: ...
    def IsSubViewRelativeSize(self) -> bool: ...
    def IsSubview(self) -> bool: ...
    def IsSubviewComposer(self) -> bool: ...
    def Layer(self, theLayerId: int) -> Graphic3d_Layer: ...
    def Layers(self) -> False: ...
    def Lights(self) -> Graphic3d_LightSet: ...
    @overload
    def MinMaxValues(
        self, theToIncludeAuxiliary: Optional[bool] = False
    ) -> Bnd_Box: ...
    @overload
    def MinMaxValues(
        self,
        theSet: Graphic3d_MapOfStructure,
        theToIncludeAuxiliary: Optional[bool] = False,
    ) -> Bnd_Box: ...
    def NumberOfDisplayedStructures(self) -> int: ...
    def ParentView(self) -> Graphic3d_CView: ...
    def PoseXRToWorld(self, thePoseXR: gp_Trsf) -> gp_Trsf: ...
    def PosedXRCamera(self) -> Graphic3d_Camera: ...
    def ProcessXRInput(self) -> None: ...
    def ReCompute(self, theStructure: Graphic3d_Structure) -> None: ...
    def Redraw(self) -> None: ...
    def RedrawImmediate(self) -> None: ...
    def ReleaseXR(self) -> None: ...
    def Remove(self) -> None: ...
    def RemoveSubview(self, theView: Graphic3d_CView) -> bool: ...
    def RemoveZLayer(self, theLayerId: int) -> None: ...
    def RenderingParams(self) -> Graphic3d_RenderingParams: ...
    def Resized(self) -> None: ...
    def SetBackfacingModel(self, theModel: Graphic3d_TypeOfBackfacingModel) -> None: ...
    def SetBackground(self, theBackground: Aspect_Background) -> None: ...
    def SetBackgroundImage(
        self,
        theTextureMap: Graphic3d_TextureMap,
        theToUpdatePBREnv: Optional[bool] = True,
    ) -> None: ...
    def SetBackgroundImageStyle(self, theFillStyle: Aspect_FillMethod) -> None: ...
    def SetBackgroundSkydome(
        self,
        theAspect: Aspect_SkydomeBackground,
        theToUpdatePBREnv: Optional[bool] = True,
    ) -> None: ...
    def SetBackgroundType(self, theType: Graphic3d_TypeOfBackground) -> None: ...
    def SetBaseXRCamera(self, theCamera: Graphic3d_Camera) -> None: ...
    def SetCamera(self, theCamera: Graphic3d_Camera) -> None: ...
    def SetClipPlanes(self, thePlanes: Graphic3d_SequenceOfHClipPlane) -> None: ...
    def SetComputedMode(self, theMode: bool) -> None: ...
    def SetFBO(self, theFbo: Standard_Transient) -> None: ...
    def SetGradientBackground(
        self, theBackground: Aspect_GradientBackground
    ) -> None: ...
    def SetImageBasedLighting(self, theToEnableIBL: bool) -> None: ...
    def SetImmediateModeDrawToFront(self, theDrawToFrontBuffer: bool) -> bool: ...
    def SetLights(self, theLights: Graphic3d_LightSet) -> None: ...
    def SetPosedXRCamera(self, theCamera: Graphic3d_Camera) -> None: ...
    def SetShadingModel(self, theModel: Graphic3d_TypeOfShadingModel) -> None: ...
    def SetSubviewComposer(self, theIsComposer: bool) -> None: ...
    def SetSubviewCorner(self, thePos: Aspect_TypeOfTriedronPosition) -> None: ...
    def SetSubviewMargins(self, theMargins: Graphic3d_Vec2i) -> None: ...
    def SetSubviewOffset(self, theOffset: Graphic3d_Vec2d) -> None: ...
    def SetSubviewSize(self, theSize: Graphic3d_Vec2d) -> None: ...
    def SetTextureEnv(self, theTextureEnv: Graphic3d_TextureEnv) -> None: ...
    def SetUnitFactor(self, theFactor: float) -> None: ...
    def SetVisualizationType(self, theType: Graphic3d_TypeOfVisualization) -> None: ...
    def SetWindow(
        self,
        theParentVIew: Graphic3d_CView,
        theWindow: Aspect_Window,
        theContext: Aspect_RenderingContext,
    ) -> None: ...
    def SetXRSession(self, theSession: Aspect_XRSession) -> None: ...
    def SetZLayerRedrawMode(self, theMode: bool) -> None: ...
    def SetZLayerSettings(
        self, theLayerId: int, theSettings: Graphic3d_ZLayerSettings
    ) -> None: ...
    def SetZLayerTarget(self, theTarget: int) -> None: ...
    def SetupXRPosedCamera(self) -> None: ...
    def ShadingModel(self) -> Graphic3d_TypeOfShadingModel: ...
    def ShadowMapDump(self, theImage: Image_PixMap, theLightName: str) -> bool: ...
    @overload
    def StatisticInformation(self) -> str: ...
    @overload
    def StatisticInformation(
        self, theDict: TColStd_IndexedDataMapOfStringString
    ) -> None: ...
    def StructureManager(self) -> Graphic3d_StructureManager: ...
    def SubviewCorner(self) -> Aspect_TypeOfTriedronPosition: ...
    def SubviewMargins(self) -> Graphic3d_Vec2i: ...
    def SubviewOffset(self) -> Graphic3d_Vec2d: ...
    def SubviewResized(self, theWindow: Aspect_NeutralWindow) -> None: ...
    def SubviewSize(self) -> Graphic3d_Vec2d: ...
    def SubviewTopLeft(self) -> Graphic3d_Vec2i: ...
    def Subviews(self) -> False: ...
    def SynchronizeXRBaseToPosedCamera(self) -> None: ...
    def SynchronizeXRPosedToBaseCamera(self) -> None: ...
    def TextureEnv(self) -> Graphic3d_TextureEnv: ...
    def ToFlipOutput(self) -> bool: ...
    def TurnViewXRCamera(self, theTrsfTurn: gp_Trsf) -> None: ...
    def UnitFactor(self) -> float: ...
    def UnsetXRPosedCamera(self) -> None: ...
    def Update(
        self, theLayerId: Optional[int] = Graphic3d_ZLayerId_UNKNOWN
    ) -> None: ...
    def ViewAxisInWorld(self, thePoseXR: gp_Trsf) -> gp_Ax1: ...
    def VisualizationType(self) -> Graphic3d_TypeOfVisualization: ...
    def Window(self) -> Aspect_Window: ...
    def XRSession(self) -> Aspect_XRSession: ...
    def ZLayerMax(self) -> int: ...
    def ZLayerRedrawMode(self) -> bool: ...
    def ZLayerTarget(self) -> Graphic3d_ZLayerId: ...

class Graphic3d_FrameStatsDataTmp(Graphic3d_FrameStatsData):
    def __init__(self) -> None: ...
    def ChangeCounterValue(self, theIndex: Graphic3d_FrameStatsCounter) -> int: ...
    def GetChangeFrameRate(self) -> float: ...
    def SetChangeFrameRate(self, value: float) -> None: ...
    def GetChangeFrameRateCpu(self) -> float: ...
    def SetChangeFrameRateCpu(self, value: float) -> None: ...
    def GetChangeImmediateFrameRate(self) -> float: ...
    def SetChangeImmediateFrameRate(self, value: float) -> None: ...
    def GetChangeImmediateFrameRateCpu(self) -> float: ...
    def SetChangeImmediateFrameRateCpu(self, value: float) -> None: ...
    def ChangeTimer(self, theTimer: Graphic3d_FrameStatsTimer) -> OSD_Timer: ...
    def GetChangeTimerValue(self, theIndex: Graphic3d_FrameStatsTimer) -> float: ...
    def SetChangeTimerValue(
        self, theIndex: Graphic3d_FrameStatsTimer, value: float
    ) -> None: ...
    def FlushTimers(self, theNbFrames: int, theIsFinal: bool) -> None: ...
    def Reset(self) -> None: ...

class Graphic3d_MediaTextureSet(Graphic3d_TextureSet, Media_IFrameQueue):
    def __init__(self) -> None: ...
    def Duration(self) -> float: ...
    def FrameSize(self) -> Graphic3d_Vec2i: ...
    def Input(self) -> str: ...
    def IsFullRangeYUV(self) -> bool: ...
    def IsPlanarYUV(self) -> bool: ...
    def Notify(self) -> None: ...
    def OpenInput(self, thePath: str, theToWait: bool) -> None: ...
    def PlayerContext(self) -> Media_PlayerContext: ...
    def Progress(self) -> float: ...
    def ShaderProgram(self) -> Graphic3d_ShaderProgram: ...
    def SwapFrames(self) -> bool: ...

class Graphic3d_TextureEnv(Graphic3d_TextureRoot):
    @overload
    def __init__(self, theFileName: str) -> None: ...
    @overload
    def __init__(self, theName: Graphic3d_NameOfTextureEnv) -> None: ...
    @overload
    def __init__(self, thePixMap: Image_PixMap) -> None: ...
    def Name(self) -> Graphic3d_NameOfTextureEnv: ...
    @staticmethod
    def NumberOfTextures() -> int: ...
    @staticmethod
    def TextureName(theRank: int) -> str: ...

class Graphic3d_TextureMap(Graphic3d_TextureRoot):
    def AnisoFilter(self) -> Graphic3d_LevelOfTextureAnisotropy: ...
    def DisableModulate(self) -> None: ...
    def DisableRepeat(self) -> None: ...
    def DisableSmooth(self) -> None: ...
    def EnableModulate(self) -> None: ...
    def EnableRepeat(self) -> None: ...
    def EnableSmooth(self) -> None: ...
    def IsModulate(self) -> bool: ...
    def IsRepeat(self) -> bool: ...
    def IsSmoothed(self) -> bool: ...
    def SetAnisoFilter(self, theLevel: Graphic3d_LevelOfTextureAnisotropy) -> None: ...

class Graphic3d_TransformPersScaledAbove(Graphic3d_TransformPers):
    def __init__(self, theScale: float, thePnt: gp_Pnt) -> None: ...
    def persistentScale(
        self, theCamera: Graphic3d_Camera, theViewportWidth: int, theViewportHeight: int
    ) -> float: ...

class Graphic3d_CubeMap(Graphic3d_TextureMap):
    def CompressedValue(
        self, theSupported: Image_SupportedFormats
    ) -> Image_CompressedPixMap: ...
    def CurrentSide(self) -> Graphic3d_CubeMapSide: ...
    def HasMipmaps(self) -> bool: ...
    def More(self) -> bool: ...
    def Next(self) -> None: ...
    def Reset(self) -> Graphic3d_CubeMap: ...
    def SetMipmapsGeneration(self, theToGenerateMipmaps: bool) -> None: ...
    def SetZInversion(self, theZIsInverted: bool) -> None: ...
    def Value(self, theSupported: Image_SupportedFormats) -> Image_PixMap: ...
    def ZIsInverted(self) -> bool: ...

class Graphic3d_MutableIndexBuffer(Graphic3d_IndexBuffer):
    def __init__(self, theAlloc: NCollection_BaseAllocator) -> None: ...
    @overload
    def Invalidate(self) -> None: ...
    @overload
    def Invalidate(self, theIndexLower: int, theIndexUpper: int) -> None: ...
    def InvalidatedRange(self) -> Graphic3d_BufferRange: ...
    def IsMutable(self) -> bool: ...
    def Validate(self) -> None: ...
    def invalidate(self, theRange: Graphic3d_BufferRange) -> None: ...

class Graphic3d_Texture1D(Graphic3d_TextureMap):
    def Name(self) -> Graphic3d_NameOfTexture1D: ...
    @staticmethod
    def NumberOfTextures() -> int: ...
    @staticmethod
    def TextureName(aRank: int) -> str: ...

class Graphic3d_Texture2D(Graphic3d_TextureMap):
    @overload
    def __init__(self, theFileName: str) -> None: ...
    @overload
    def __init__(self, theNOT: Graphic3d_NameOfTexture2D) -> None: ...
    @overload
    def __init__(self, thePixMap: Image_PixMap) -> None: ...
    def Name(self) -> Graphic3d_NameOfTexture2D: ...
    @staticmethod
    def NumberOfTextures() -> int: ...
    def SetImage(self, thePixMap: Image_PixMap) -> None: ...
    @staticmethod
    def TextureName(theRank: int) -> str: ...

class Graphic3d_Texture3D(Graphic3d_TextureMap):
    @overload
    def __init__(self, theFileName: str) -> None: ...
    @overload
    def __init__(self, thePixMap: Image_PixMap) -> None: ...
    def GetImage(self, theSupported: Image_SupportedFormats) -> Image_PixMap: ...
    def SetImage(self, thePixMap: Image_PixMap) -> None: ...

class Graphic3d_CubeMapSeparate(Graphic3d_CubeMap):
    def CompressedValue(
        self, theSupported: Image_SupportedFormats
    ) -> Image_CompressedPixMap: ...
    def IsDone(self) -> bool: ...
    def Value(self, theSupported: Image_SupportedFormats) -> Image_PixMap: ...

class Graphic3d_MediaTexture(Graphic3d_Texture2D):
    def __init__(
        self, theMutex: Standard_HMutex, thePlane: Optional[int] = -1
    ) -> None: ...
    def Frame(self) -> Media_Frame: ...
    def GenerateNewId(self) -> None: ...
    def GetImage(self, theSupported: Image_SupportedFormats) -> Image_PixMap: ...
    def SetFrame(self, theFrame: Media_Frame) -> None: ...

class Graphic3d_Texture1Dmanual(Graphic3d_Texture1D):
    @overload
    def __init__(self, theFileName: str) -> None: ...
    @overload
    def __init__(self, theNOT: Graphic3d_NameOfTexture1D) -> None: ...
    @overload
    def __init__(self, thePixMap: Image_PixMap) -> None: ...

class Graphic3d_Texture1Dsegment(Graphic3d_Texture1D):
    @overload
    def __init__(self, theFileName: str) -> None: ...
    @overload
    def __init__(self, theNOT: Graphic3d_NameOfTexture1D) -> None: ...
    @overload
    def __init__(self, thePixMap: Image_PixMap) -> None: ...
    def Segment(self) -> Tuple[float, float, float, float, float, float]: ...
    def SetSegment(
        self,
        theX1: float,
        theY1: float,
        theZ1: float,
        theX2: float,
        theY2: float,
        theZ2: float,
    ) -> None: ...

class Graphic3d_Texture2Dplane(Graphic3d_Texture2D):
    @overload
    def __init__(self, theFileName: str) -> None: ...
    @overload
    def __init__(self, theNOT: Graphic3d_NameOfTexture2D) -> None: ...
    @overload
    def __init__(self, thePixMap: Image_PixMap) -> None: ...
    def Plane(self) -> Graphic3d_NameOfTexturePlane: ...
    def PlaneS(self) -> Tuple[float, float, float, float]: ...
    def PlaneT(self) -> Tuple[float, float, float, float]: ...
    def Rotation(self) -> float: ...
    def ScaleS(self) -> float: ...
    def ScaleT(self) -> float: ...
    def SetPlane(self, thePlane: Graphic3d_NameOfTexturePlane) -> None: ...
    def SetPlaneS(self, A: float, B: float, C: float, D: float) -> None: ...
    def SetPlaneT(self, A: float, B: float, C: float, D: float) -> None: ...
    def SetRotation(self, theVal: float) -> None: ...
    def SetScaleS(self, theVal: float) -> None: ...
    def SetScaleT(self, theVal: float) -> None: ...
    def SetTranslateS(self, theVal: float) -> None: ...
    def SetTranslateT(self, theVal: float) -> None: ...
    def TranslateS(self) -> float: ...
    def TranslateT(self) -> float: ...

# classnotwrapped
class Graphic3d_UniformValue: ...

# classnotwrapped
class Graphic3d_UniformValueType: ...

# classnotwrapped
class Graphic3d_UniformValueTypeID: ...

# classnotwrapped
class Graphic3d_Buffer: ...

# classnotwrapped
class Graphic3d_IndexBuffer: ...

# classnotwrapped
class Graphic3d_TextureSet: ...

# classnotwrapped
class Graphic3d_CubeMapOrder: ...

# classnotwrapped
class Graphic3d_CubeMapPacked: ...

# classnotwrapped
class Graphic3d_BvhCStructureSetTrsfPers: ...

# harray1 classes
# harray2 classes
# hsequence classes
