from enum import IntEnum
from typing import overload, NewType, Optional, Tuple

from OCC.Core.Standard import *
from OCC.Core.NCollection import *
from OCC.Core.gp import *
from OCC.Core.Geom2d import *
from OCC.Core.math import *
from OCC.Core.TColgp import *
from OCC.Core.TColStd import *

class FairCurve_AnalysisCode(IntEnum):
    FairCurve_OK: int = ...
    FairCurve_NotConverged: int = ...
    FairCurve_InfiniteSliding: int = ...
    FairCurve_NullHeight: int = ...

FairCurve_OK = FairCurve_AnalysisCode.FairCurve_OK
FairCurve_NotConverged = FairCurve_AnalysisCode.FairCurve_NotConverged
FairCurve_InfiniteSliding = FairCurve_AnalysisCode.FairCurve_InfiniteSliding
FairCurve_NullHeight = FairCurve_AnalysisCode.FairCurve_NullHeight

class FairCurve_Batten:
    def __init__(
        self, P1: gp_Pnt2d, P2: gp_Pnt2d, Height: float, Slope: Optional[float] = 0
    ) -> None: ...
    def Compute(
        self, NbIterations: Optional[int] = 50, Tolerance: Optional[float] = 1.0e-3
    ) -> Tuple[bool, FairCurve_AnalysisCode]: ...
    def Curve(self) -> Geom2d_BSplineCurve: ...
    def Dump(self) -> str: ...
    def GetAngle1(self) -> float: ...
    def GetAngle2(self) -> float: ...
    def GetConstraintOrder1(self) -> int: ...
    def GetConstraintOrder2(self) -> int: ...
    def GetFreeSliding(self) -> bool: ...
    def GetHeight(self) -> float: ...
    def GetP1(self) -> gp_Pnt2d: ...
    def GetP2(self) -> gp_Pnt2d: ...
    def GetSlidingFactor(self) -> float: ...
    def GetSlope(self) -> float: ...
    def SetAngle1(self, Angle1: float) -> None: ...
    def SetAngle2(self, Angle2: float) -> None: ...
    def SetConstraintOrder1(self, ConstraintOrder: int) -> None: ...
    def SetConstraintOrder2(self, ConstraintOrder: int) -> None: ...
    def SetFreeSliding(self, FreeSliding: bool) -> None: ...
    def SetHeight(self, Height: float) -> None: ...
    def SetP1(self, P1: gp_Pnt2d) -> None: ...
    def SetP2(self, P2: gp_Pnt2d) -> None: ...
    def SetSlidingFactor(self, SlidingFactor: float) -> None: ...
    def SetSlope(self, Slope: float) -> None: ...
    def SlidingOfReference(self) -> float: ...

class FairCurve_BattenLaw(math_Function):
    def __init__(self, Heigth: float, Slope: float, Sliding: float) -> None: ...
    def SetHeigth(self, Heigth: float) -> None: ...
    def SetSliding(self, Sliding: float) -> None: ...
    def SetSlope(self, Slope: float) -> None: ...
    def Value(self, T: float) -> Tuple[bool, float]: ...

class FairCurve_DistributionOfEnergy(math_FunctionSet):
    def NbEquations(self) -> int: ...
    def NbVariables(self) -> int: ...
    def SetDerivativeOrder(self, DerivativeOrder: int) -> None: ...

class FairCurve_Energy(math_MultipleVarFunctionWithHessian):
    def Gradient(self, X: math_Vector, G: math_Vector) -> bool: ...
    def NbVariables(self) -> int: ...
    def Poles(self) -> TColgp_HArray1OfPnt2d: ...
    def Value(self, X: math_Vector) -> Tuple[bool, float]: ...
    @overload
    def Values(self, X: math_Vector, G: math_Vector) -> Tuple[bool, float]: ...
    @overload
    def Values(
        self, X: math_Vector, G: math_Vector, H: math_Matrix
    ) -> Tuple[bool, float]: ...
    def Variable(self, X: math_Vector) -> bool: ...

class FairCurve_Newton(math_NewtonMinimum):
    def __init__(
        self,
        theFunction: math_MultipleVarFunctionWithHessian,
        theSpatialTolerance: Optional[float] = 1.0e-7,
        theCriteriumTolerance: Optional[float] = 1.0e-7,
        theNbIterations: Optional[int] = 40,
        theConvexity: Optional[float] = 1.0e-6,
        theWithSingularity: Optional[bool] = True,
    ) -> None: ...
    def IsConverged(self) -> bool: ...

class FairCurve_DistributionOfJerk(FairCurve_DistributionOfEnergy):
    def __init__(
        self,
        BSplOrder: int,
        FlatKnots: TColStd_HArray1OfReal,
        Poles: TColgp_HArray1OfPnt2d,
        DerivativeOrder: int,
        Law: FairCurve_BattenLaw,
        NbValAux: Optional[int] = 0,
    ) -> None: ...
    def Value(self, X: math_Vector, F: math_Vector) -> bool: ...

class FairCurve_DistributionOfSagging(FairCurve_DistributionOfEnergy):
    def __init__(
        self,
        BSplOrder: int,
        FlatKnots: TColStd_HArray1OfReal,
        Poles: TColgp_HArray1OfPnt2d,
        DerivativeOrder: int,
        Law: FairCurve_BattenLaw,
        NbValAux: Optional[int] = 0,
    ) -> None: ...
    def Value(self, X: math_Vector, F: math_Vector) -> bool: ...

class FairCurve_DistributionOfTension(FairCurve_DistributionOfEnergy):
    def __init__(
        self,
        BSplOrder: int,
        FlatKnots: TColStd_HArray1OfReal,
        Poles: TColgp_HArray1OfPnt2d,
        DerivativeOrder: int,
        LengthSliding: float,
        Law: FairCurve_BattenLaw,
        NbValAux: Optional[int] = 0,
        Uniform: Optional[bool] = False,
    ) -> None: ...
    def SetLengthSliding(self, LengthSliding: float) -> None: ...
    def Value(self, X: math_Vector, F: math_Vector) -> bool: ...

class FairCurve_EnergyOfBatten(FairCurve_Energy):
    def __init__(
        self,
        BSplOrder: int,
        FlatKnots: TColStd_HArray1OfReal,
        Poles: TColgp_HArray1OfPnt2d,
        ContrOrder1: int,
        ContrOrder2: int,
        Law: FairCurve_BattenLaw,
        LengthSliding: float,
        FreeSliding: Optional[bool] = True,
        Angle1: Optional[float] = 0,
        Angle2: Optional[float] = 0,
    ) -> None: ...
    def LengthSliding(self) -> float: ...
    def Status(self) -> FairCurve_AnalysisCode: ...
    def Variable(self, X: math_Vector) -> bool: ...

class FairCurve_EnergyOfMVC(FairCurve_Energy):
    def __init__(
        self,
        BSplOrder: int,
        FlatKnots: TColStd_HArray1OfReal,
        Poles: TColgp_HArray1OfPnt2d,
        ContrOrder1: int,
        ContrOrder2: int,
        Law: FairCurve_BattenLaw,
        PhysicalRatio: float,
        LengthSliding: float,
        FreeSliding: Optional[bool] = True,
        Angle1: Optional[float] = 0,
        Angle2: Optional[float] = 0,
        Curvature1: Optional[float] = 0,
        Curvature2: Optional[float] = 0,
    ) -> None: ...
    def LengthSliding(self) -> float: ...
    def Status(self) -> FairCurve_AnalysisCode: ...
    def Variable(self, X: math_Vector) -> bool: ...

class FairCurve_MinimalVariation(FairCurve_Batten):
    def __init__(
        self,
        P1: gp_Pnt2d,
        P2: gp_Pnt2d,
        Heigth: float,
        Slope: Optional[float] = 0,
        PhysicalRatio: Optional[float] = 0,
    ) -> None: ...
    def Compute(
        self, NbIterations: Optional[int] = 50, Tolerance: Optional[float] = 1.0e-3
    ) -> Tuple[bool, FairCurve_AnalysisCode]: ...
    def Dump(self) -> str: ...
    def GetCurvature1(self) -> float: ...
    def GetCurvature2(self) -> float: ...
    def GetPhysicalRatio(self) -> float: ...
    def SetCurvature1(self, Curvature: float) -> None: ...
    def SetCurvature2(self, Curvature: float) -> None: ...
    def SetPhysicalRatio(self, Ratio: float) -> None: ...

# harray1 classes
# harray2 classes
# hsequence classes
