from enum import IntEnum
from typing import overload, NewType, Optional, Tuple

from OCC.Core.Standard import *
from OCC.Core.NCollection import *
from OCC.Core.TColgp import *
from OCC.Core.TColStd import *
from OCC.Core.gp import *

Convert_SequenceOfArray1OfPoles2d = NewType(
    "Convert_SequenceOfArray1OfPoles2d", TColgp_SequenceOfArray1OfPnt2d
)

class Convert_SequenceOfArray1OfPoles:
    def Assign(self, theItem: False) -> False: ...
    def Clear(self) -> None: ...
    def First(self) -> False: ...
    def IsDeletables(self) -> bool: ...
    def IsEmpty(self) -> bool: ...
    def Last(self) -> False: ...
    def Length(self) -> int: ...
    def Lower(self) -> int: ...
    def Prepend(self, theItem: False) -> False: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def SetValue(self, theIndex: int, theValue: False) -> None: ...
    def Size(self) -> int: ...
    def UpdateUpperBound(self, int) -> None: ...
    def UpdateLowerBound(self, int) -> None: ...
    def Upper(self) -> int: ...
    def Value(self, theIndex: int) -> False: ...
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...

class Convert_ParameterisationType(IntEnum):
    Convert_TgtThetaOver2: int = ...
    Convert_TgtThetaOver2_1: int = ...
    Convert_TgtThetaOver2_2: int = ...
    Convert_TgtThetaOver2_3: int = ...
    Convert_TgtThetaOver2_4: int = ...
    Convert_QuasiAngular: int = ...
    Convert_RationalC1: int = ...
    Convert_Polynomial: int = ...

Convert_TgtThetaOver2 = Convert_ParameterisationType.Convert_TgtThetaOver2
Convert_TgtThetaOver2_1 = Convert_ParameterisationType.Convert_TgtThetaOver2_1
Convert_TgtThetaOver2_2 = Convert_ParameterisationType.Convert_TgtThetaOver2_2
Convert_TgtThetaOver2_3 = Convert_ParameterisationType.Convert_TgtThetaOver2_3
Convert_TgtThetaOver2_4 = Convert_ParameterisationType.Convert_TgtThetaOver2_4
Convert_QuasiAngular = Convert_ParameterisationType.Convert_QuasiAngular
Convert_RationalC1 = Convert_ParameterisationType.Convert_RationalC1
Convert_Polynomial = Convert_ParameterisationType.Convert_Polynomial

class Convert_CompBezierCurves2dToBSplineCurve2d:
    def __init__(self, AngularTolerance: Optional[float] = 1.0e-4) -> None: ...
    def AddCurve(self, Poles: TColgp_Array1OfPnt2d) -> None: ...
    def Degree(self) -> int: ...
    def KnotsAndMults(
        self, Knots: TColStd_Array1OfReal, Mults: TColStd_Array1OfInteger
    ) -> None: ...
    def NbKnots(self) -> int: ...
    def NbPoles(self) -> int: ...
    def Perform(self) -> None: ...
    def Poles(self, Poles: TColgp_Array1OfPnt2d) -> None: ...

class Convert_CompBezierCurvesToBSplineCurve:
    def __init__(self, AngularTolerance: Optional[float] = 1.0e-4) -> None: ...
    def AddCurve(self, Poles: TColgp_Array1OfPnt) -> None: ...
    def Degree(self) -> int: ...
    def KnotsAndMults(
        self, Knots: TColStd_Array1OfReal, Mults: TColStd_Array1OfInteger
    ) -> None: ...
    def NbKnots(self) -> int: ...
    def NbPoles(self) -> int: ...
    def Perform(self) -> None: ...
    def Poles(self, Poles: TColgp_Array1OfPnt) -> None: ...

class Convert_CompPolynomialToPoles:
    @overload
    def __init__(
        self,
        NumCurves: int,
        Continuity: int,
        Dimension: int,
        MaxDegree: int,
        NumCoeffPerCurve: TColStd_HArray1OfInteger,
        Coefficients: TColStd_HArray1OfReal,
        PolynomialIntervals: TColStd_HArray2OfReal,
        TrueIntervals: TColStd_HArray1OfReal,
    ) -> None: ...
    @overload
    def __init__(
        self,
        NumCurves: int,
        Dimension: int,
        MaxDegree: int,
        Continuity: TColStd_Array1OfInteger,
        NumCoeffPerCurve: TColStd_Array1OfInteger,
        Coefficients: TColStd_Array1OfReal,
        PolynomialIntervals: TColStd_Array2OfReal,
        TrueIntervals: TColStd_Array1OfReal,
    ) -> None: ...
    @overload
    def __init__(
        self,
        Dimension: int,
        MaxDegree: int,
        Degree: int,
        Coefficients: TColStd_Array1OfReal,
        PolynomialIntervals: TColStd_Array1OfReal,
        TrueIntervals: TColStd_Array1OfReal,
    ) -> None: ...
    def Degree(self) -> int: ...
    def IsDone(self) -> bool: ...
    def Knots(self, K: TColStd_HArray1OfReal) -> None: ...
    def Multiplicities(self, M: TColStd_HArray1OfInteger) -> None: ...
    def NbKnots(self) -> int: ...
    def NbPoles(self) -> int: ...
    def Poles(self, Poles: TColStd_HArray2OfReal) -> None: ...

class Convert_ConicToBSplineCurve:
    @overload
    def BuildCosAndSin(
        self,
        Parametrisation: Convert_ParameterisationType,
        CosNumerator: TColStd_HArray1OfReal,
        SinNumerator: TColStd_HArray1OfReal,
        Denominator: TColStd_HArray1OfReal,
        Knots: TColStd_HArray1OfReal,
        Mults: TColStd_HArray1OfInteger,
    ) -> int: ...
    @overload
    def BuildCosAndSin(
        self,
        Parametrisation: Convert_ParameterisationType,
        UFirst: float,
        ULast: float,
        CosNumerator: TColStd_HArray1OfReal,
        SinNumerator: TColStd_HArray1OfReal,
        Denominator: TColStd_HArray1OfReal,
        Knots: TColStd_HArray1OfReal,
        Mults: TColStd_HArray1OfInteger,
    ) -> int: ...
    def Degree(self) -> int: ...
    def IsPeriodic(self) -> bool: ...
    def Knot(self, Index: int) -> float: ...
    def Multiplicity(self, Index: int) -> int: ...
    def NbKnots(self) -> int: ...
    def NbPoles(self) -> int: ...
    def Pole(self, Index: int) -> gp_Pnt2d: ...
    def Weight(self, Index: int) -> float: ...

class Convert_ElementarySurfaceToBSplineSurface:
    def IsUPeriodic(self) -> bool: ...
    def IsVPeriodic(self) -> bool: ...
    def NbUKnots(self) -> int: ...
    def NbUPoles(self) -> int: ...
    def NbVKnots(self) -> int: ...
    def NbVPoles(self) -> int: ...
    def Pole(self, UIndex: int, VIndex: int) -> gp_Pnt: ...
    def UDegree(self) -> int: ...
    def UKnot(self, UIndex: int) -> float: ...
    def UMultiplicity(self, UIndex: int) -> int: ...
    def VDegree(self) -> int: ...
    def VKnot(self, UIndex: int) -> float: ...
    def VMultiplicity(self, VIndex: int) -> int: ...
    def Weight(self, UIndex: int, VIndex: int) -> float: ...

class Convert_GridPolynomialToPoles:
    @overload
    def __init__(
        self,
        MaxUDegree: int,
        MaxVDegree: int,
        NumCoeff: TColStd_HArray1OfInteger,
        Coefficients: TColStd_HArray1OfReal,
        PolynomialUIntervals: TColStd_HArray1OfReal,
        PolynomialVIntervals: TColStd_HArray1OfReal,
    ) -> None: ...
    @overload
    def __init__(
        self,
        NbUSurfaces: int,
        NBVSurfaces: int,
        UContinuity: int,
        VContinuity: int,
        MaxUDegree: int,
        MaxVDegree: int,
        NumCoeffPerSurface: TColStd_HArray2OfInteger,
        Coefficients: TColStd_HArray1OfReal,
        PolynomialUIntervals: TColStd_HArray1OfReal,
        PolynomialVIntervals: TColStd_HArray1OfReal,
        TrueUIntervals: TColStd_HArray1OfReal,
        TrueVIntervals: TColStd_HArray1OfReal,
    ) -> None: ...
    def IsDone(self) -> bool: ...
    def NbUKnots(self) -> int: ...
    def NbUPoles(self) -> int: ...
    def NbVKnots(self) -> int: ...
    def NbVPoles(self) -> int: ...
    def Perform(
        self,
        UContinuity: int,
        VContinuity: int,
        MaxUDegree: int,
        MaxVDegree: int,
        NumCoeffPerSurface: TColStd_HArray2OfInteger,
        Coefficients: TColStd_HArray1OfReal,
        PolynomialUIntervals: TColStd_HArray1OfReal,
        PolynomialVIntervals: TColStd_HArray1OfReal,
        TrueUIntervals: TColStd_HArray1OfReal,
        TrueVIntervals: TColStd_HArray1OfReal,
    ) -> None: ...
    def Poles(self) -> TColgp_HArray2OfPnt: ...
    def UDegree(self) -> int: ...
    def UKnots(self) -> TColStd_HArray1OfReal: ...
    def UMultiplicities(self) -> TColStd_HArray1OfInteger: ...
    def VDegree(self) -> int: ...
    def VKnots(self) -> TColStd_HArray1OfReal: ...
    def VMultiplicities(self) -> TColStd_HArray1OfInteger: ...

class Convert_CircleToBSplineCurve(Convert_ConicToBSplineCurve):
    @overload
    def __init__(
        self,
        C: gp_Circ2d,
        Parameterisation: Optional[
            Convert_ParameterisationType
        ] = Convert_TgtThetaOver2,
    ) -> None: ...
    @overload
    def __init__(
        self,
        C: gp_Circ2d,
        U1: float,
        U2: float,
        Parameterisation: Optional[
            Convert_ParameterisationType
        ] = Convert_TgtThetaOver2,
    ) -> None: ...

class Convert_ConeToBSplineSurface(Convert_ElementarySurfaceToBSplineSurface):
    @overload
    def __init__(
        self, C: gp_Cone, U1: float, U2: float, V1: float, V2: float
    ) -> None: ...
    @overload
    def __init__(self, C: gp_Cone, V1: float, V2: float) -> None: ...

class Convert_CylinderToBSplineSurface(Convert_ElementarySurfaceToBSplineSurface):
    @overload
    def __init__(
        self, Cyl: gp_Cylinder, U1: float, U2: float, V1: float, V2: float
    ) -> None: ...
    @overload
    def __init__(self, Cyl: gp_Cylinder, V1: float, V2: float) -> None: ...

class Convert_EllipseToBSplineCurve(Convert_ConicToBSplineCurve):
    @overload
    def __init__(
        self,
        E: gp_Elips2d,
        Parameterisation: Optional[
            Convert_ParameterisationType
        ] = Convert_TgtThetaOver2,
    ) -> None: ...
    @overload
    def __init__(
        self,
        E: gp_Elips2d,
        U1: float,
        U2: float,
        Parameterisation: Optional[
            Convert_ParameterisationType
        ] = Convert_TgtThetaOver2,
    ) -> None: ...

class Convert_HyperbolaToBSplineCurve(Convert_ConicToBSplineCurve):
    def __init__(self, H: gp_Hypr2d, U1: float, U2: float) -> None: ...

class Convert_ParabolaToBSplineCurve(Convert_ConicToBSplineCurve):
    def __init__(self, Prb: gp_Parab2d, U1: float, U2: float) -> None: ...

class Convert_SphereToBSplineSurface(Convert_ElementarySurfaceToBSplineSurface):
    @overload
    def __init__(
        self, Sph: gp_Sphere, U1: float, U2: float, V1: float, V2: float
    ) -> None: ...
    @overload
    def __init__(
        self, Sph: gp_Sphere, Param1: float, Param2: float, UTrim: Optional[bool] = True
    ) -> None: ...
    @overload
    def __init__(self, Sph: gp_Sphere) -> None: ...

class Convert_TorusToBSplineSurface(Convert_ElementarySurfaceToBSplineSurface):
    @overload
    def __init__(
        self, T: gp_Torus, U1: float, U2: float, V1: float, V2: float
    ) -> None: ...
    @overload
    def __init__(
        self, T: gp_Torus, Param1: float, Param2: float, UTrim: Optional[bool] = True
    ) -> None: ...
    @overload
    def __init__(self, T: gp_Torus) -> None: ...

# harray1 classes
# harray2 classes
# hsequence classes
