from enum import IntEnum
from typing import overload, NewType, Optional, Tuple

from OCC.Core.Standard import *
from OCC.Core.NCollection import *
from OCC.Core.TopoDS import *
from OCC.Core.GeomAbs import *
from OCC.Core.TopTools import *
from OCC.Core.TopAbs import *
from OCC.Core.Adaptor3d import *

class brepalgo:
    @staticmethod
    def ConcatenateWire(
        Wire: TopoDS_Wire,
        Option: GeomAbs_Shape,
        AngularTolerance: Optional[float] = 1.0e-4,
    ) -> TopoDS_Wire: ...
    @staticmethod
    def ConcatenateWireC0(Wire: TopoDS_Wire) -> TopoDS_Edge: ...
    @staticmethod
    def ConvertFace(theFace: TopoDS_Face, theAngleTolerance: float) -> TopoDS_Face: ...
    @staticmethod
    def ConvertWire(
        theWire: TopoDS_Wire, theAngleTolerance: float, theFace: TopoDS_Face
    ) -> TopoDS_Wire: ...
    @staticmethod
    def IsTopologicallyValid(S: TopoDS_Shape) -> bool: ...
    @overload
    @staticmethod
    def IsValid(S: TopoDS_Shape) -> bool: ...
    @overload
    @staticmethod
    def IsValid(
        theArgs: TopTools_ListOfShape,
        theResult: TopoDS_Shape,
        closedSolid: Optional[bool] = False,
        GeomCtrl: Optional[bool] = True,
    ) -> bool: ...

class BRepAlgo_AsDes(Standard_Transient):
    def __init__(self) -> None: ...
    @overload
    def Add(self, S: TopoDS_Shape, SS: TopoDS_Shape) -> None: ...
    @overload
    def Add(self, S: TopoDS_Shape, SS: TopTools_ListOfShape) -> None: ...
    def Ascendant(self, S: TopoDS_Shape) -> TopTools_ListOfShape: ...
    def ChangeDescendant(self, S: TopoDS_Shape) -> TopTools_ListOfShape: ...
    def Clear(self) -> None: ...
    def Descendant(self, S: TopoDS_Shape) -> TopTools_ListOfShape: ...
    def HasAscendant(self, S: TopoDS_Shape) -> bool: ...
    def HasCommonDescendant(
        self, S1: TopoDS_Shape, S2: TopoDS_Shape, LC: TopTools_ListOfShape
    ) -> bool: ...
    def HasDescendant(self, S: TopoDS_Shape) -> bool: ...
    def Remove(self, theS: TopoDS_Shape) -> None: ...
    def Replace(self, theOldS: TopoDS_Shape, theNewS: TopoDS_Shape) -> None: ...

class BRepAlgo_FaceRestrictor:
    def __init__(self) -> None: ...
    def Add(self, W: TopoDS_Wire) -> None: ...
    def Clear(self) -> None: ...
    def Current(self) -> TopoDS_Face: ...
    def Init(
        self,
        F: TopoDS_Face,
        Proj: Optional[bool] = False,
        ControlOrientation: Optional[bool] = False,
    ) -> None: ...
    def IsDone(self) -> bool: ...
    def More(self) -> bool: ...
    def Next(self) -> None: ...
    def Perform(self) -> None: ...

class BRepAlgo_Image:
    def __init__(self) -> None: ...
    @overload
    def Add(self, OldS: TopoDS_Shape, NewS: TopoDS_Shape) -> None: ...
    @overload
    def Add(self, OldS: TopoDS_Shape, NewS: TopTools_ListOfShape) -> None: ...
    @overload
    def Bind(self, OldS: TopoDS_Shape, NewS: TopoDS_Shape) -> None: ...
    @overload
    def Bind(self, OldS: TopoDS_Shape, NewS: TopTools_ListOfShape) -> None: ...
    def Clear(self) -> None: ...
    def Compact(self) -> None: ...
    def Filter(self, S: TopoDS_Shape, ShapeType: TopAbs_ShapeEnum) -> None: ...
    def HasImage(self, S: TopoDS_Shape) -> bool: ...
    def Image(self, S: TopoDS_Shape) -> TopTools_ListOfShape: ...
    def ImageFrom(self, S: TopoDS_Shape) -> TopoDS_Shape: ...
    def IsImage(self, S: TopoDS_Shape) -> bool: ...
    def LastImage(self, S: TopoDS_Shape, L: TopTools_ListOfShape) -> None: ...
    def Remove(self, S: TopoDS_Shape) -> None: ...
    def RemoveRoot(self, Root: TopoDS_Shape) -> None: ...
    def ReplaceRoot(self, OldRoot: TopoDS_Shape, NewRoot: TopoDS_Shape) -> None: ...
    def Root(self, S: TopoDS_Shape) -> TopoDS_Shape: ...
    def Roots(self) -> TopTools_ListOfShape: ...
    def SetRoot(self, S: TopoDS_Shape) -> None: ...

class BRepAlgo_Loop:
    def __init__(self) -> None: ...
    def AddConstEdge(self, E: TopoDS_Edge) -> None: ...
    def AddConstEdges(self, LE: TopTools_ListOfShape) -> None: ...
    def AddEdge(self, E: TopoDS_Edge, LV: TopTools_ListOfShape) -> None: ...
    def CutEdge(
        self, E: TopoDS_Edge, VonE: TopTools_ListOfShape, NE: TopTools_ListOfShape
    ) -> None: ...
    def GetTolConf(self) -> float: ...
    def GetVerticesForSubstitute(
        self, VerVerMap: TopTools_DataMapOfShapeShape
    ) -> None: ...
    def Init(self, F: TopoDS_Face) -> None: ...
    def NewEdges(self, E: TopoDS_Edge) -> TopTools_ListOfShape: ...
    def NewFaces(self) -> TopTools_ListOfShape: ...
    def NewWires(self) -> TopTools_ListOfShape: ...
    def Perform(self) -> None: ...
    def SetImageVV(self, theImageVV: BRepAlgo_Image) -> None: ...
    def SetTolConf(self, theTolConf: float) -> None: ...
    def UpdateVEmap(
        self, theVEmap: TopTools_IndexedDataMapOfShapeListOfShape
    ) -> None: ...
    def VerticesForSubstitute(
        self, VerVerMap: TopTools_DataMapOfShapeShape
    ) -> None: ...
    def WiresToFaces(self) -> None: ...

class BRepAlgo_NormalProjection:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, S: TopoDS_Shape) -> None: ...
    def Add(self, ToProj: TopoDS_Shape) -> None: ...
    def Ancestor(self, E: TopoDS_Edge) -> TopoDS_Shape: ...
    def Build(self) -> None: ...
    def BuildWire(self, Liste: TopTools_ListOfShape) -> bool: ...
    def Compute3d(self, With3d: Optional[bool] = True) -> None: ...
    def Couple(self, E: TopoDS_Edge) -> TopoDS_Shape: ...
    def Generated(self, S: TopoDS_Shape) -> TopTools_ListOfShape: ...
    def Init(self, S: TopoDS_Shape) -> None: ...
    def IsDone(self) -> bool: ...
    def IsElementary(self, C: Adaptor3d_Curve) -> bool: ...
    def Projection(self) -> TopoDS_Shape: ...
    def SetDefaultParams(self) -> None: ...
    def SetLimit(self, FaceBoundaries: Optional[bool] = True) -> None: ...
    def SetMaxDistance(self, MaxDist: float) -> None: ...
    def SetParams(
        self,
        Tol3D: float,
        Tol2D: float,
        InternalContinuity: GeomAbs_Shape,
        MaxDegree: int,
        MaxSeg: int,
    ) -> None: ...

# harray1 classes
# harray2 classes
# hsequence classes
