/*
Copyright 2008-2025 Thomas Paviot (tpaviot@gmail.com)

This file is part of pythonOCC.
pythonOCC is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

pythonOCC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with pythonOCC.  If not, see <http://www.gnu.org/licenses/>.
*/
%define ADAPTOR2DDOCSTRING
"Adaptor2d module, see official documentation at
https://dev.opencascade.org/doc/occt-7.9.0/refman/html/package_adaptor2d.html"
%enddef
%module (package="OCC.Core", docstring=ADAPTOR2DDOCSTRING) Adaptor2d


%{
#ifdef WNT
#pragma warning(disable : 4716)
#endif
%}

%include ../common/CommonIncludes.i
%include ../common/ExceptionCatcher.i
%include ../common/FunctionTransformers.i
%include ../common/EnumTemplates.i
%include ../common/Operators.i
%include ../common/OccHandle.i
%include ../common/IOStream.i
%include ../common/ArrayMacros.i


%{
#include<Adaptor2d_module.hxx>

//Dependencies
#include<Standard_module.hxx>
#include<NCollection_module.hxx>
#include<Geom2d_module.hxx>
#include<gp_module.hxx>
#include<GeomAbs_module.hxx>
#include<TColStd_module.hxx>
#include<TColgp_module.hxx>
#include<TColStd_module.hxx>
#include<TCollection_module.hxx>
#include<Storage_module.hxx>
%};
%import Standard.i
%import NCollection.i
%import Geom2d.i
%import gp.i
%import GeomAbs.i
%import TColStd.i

%pythoncode {
from enum import IntEnum
from OCC.Core.Exception import *
};

/* public enums */
/* end public enums declaration */

/* python proxy classes for enums */
%pythoncode {
};
/* end python proxy for enums */

/* handles */
%wrap_handle(Adaptor2d_Curve2d)
%wrap_handle(Adaptor2d_Line2d)
%wrap_handle(Adaptor2d_OffsetCurve)
/* end handles declaration */

/* templates */
/* end templates declaration */

/* typedefs */
/* end typedefs declaration */

/**************************
* class Adaptor2d_Curve2d *
**************************/
class Adaptor2d_Curve2d : public Standard_Transient {
	public:
		/****** Adaptor2d_Curve2d::BSpline ******/
		/****** md5 signature: b2a7a571ebf1b38738b883a277ef794f ******/
		%feature("compactdefaultargs") BSpline;
		%feature("autodoc", "Return
-------
opencascade::handle<Geom2d_BSplineCurve>

Description
-----------
No available documentation.
") BSpline;
		virtual opencascade::handle<Geom2d_BSplineCurve> BSpline();

		/****** Adaptor2d_Curve2d::Bezier ******/
		/****** md5 signature: f8f04b3add4103e9f0350b8ed2285dc4 ******/
		%feature("compactdefaultargs") Bezier;
		%feature("autodoc", "Return
-------
opencascade::handle<Geom2d_BezierCurve>

Description
-----------
No available documentation.
") Bezier;
		virtual opencascade::handle<Geom2d_BezierCurve> Bezier();

		/****** Adaptor2d_Curve2d::Circle ******/
		/****** md5 signature: 624ff1e0c75139ee893a5066be1b5a0c ******/
		%feature("compactdefaultargs") Circle;
		%feature("autodoc", "Return
-------
gp_Circ2d

Description
-----------
No available documentation.
") Circle;
		virtual gp_Circ2d Circle();

		/****** Adaptor2d_Curve2d::Continuity ******/
		/****** md5 signature: 8564d2514f3a14a163da9fa2b30a9284 ******/
		%feature("compactdefaultargs") Continuity;
		%feature("autodoc", "Return
-------
GeomAbs_Shape

Description
-----------
No available documentation.
") Continuity;
		virtual GeomAbs_Shape Continuity();

		/****** Adaptor2d_Curve2d::D0 ******/
		/****** md5 signature: 032807b33fd2114f83050446452a9d16 ******/
		%feature("compactdefaultargs") D0;
		%feature("autodoc", "
Parameters
----------
U: float
P: gp_Pnt2d

Return
-------
None

Description
-----------
Computes the point of parameter U on the curve.
") D0;
		virtual void D0(const Standard_Real U, gp_Pnt2d & P);

		/****** Adaptor2d_Curve2d::D1 ******/
		/****** md5 signature: 62f67df0ec10ce52e6bbc3e7f976f93f ******/
		%feature("compactdefaultargs") D1;
		%feature("autodoc", "
Parameters
----------
U: float
P: gp_Pnt2d
V: gp_Vec2d

Return
-------
None

Description
-----------
Computes the point of parameter U on the curve with its first derivative. Raised if the continuity of the current interval is not C1.
") D1;
		virtual void D1(const Standard_Real U, gp_Pnt2d & P, gp_Vec2d & V);

		/****** Adaptor2d_Curve2d::D2 ******/
		/****** md5 signature: 7ba7fbaac090150f487dc89b64867507 ******/
		%feature("compactdefaultargs") D2;
		%feature("autodoc", "
Parameters
----------
U: float
P: gp_Pnt2d
V1: gp_Vec2d
V2: gp_Vec2d

Return
-------
None

Description
-----------
Returns the point P of parameter U, the first and second derivatives V1 and V2. Raised if the continuity of the current interval is not C2.
") D2;
		virtual void D2(const Standard_Real U, gp_Pnt2d & P, gp_Vec2d & V1, gp_Vec2d & V2);

		/****** Adaptor2d_Curve2d::D3 ******/
		/****** md5 signature: ad3456ec57f07904ba35638d0146d01f ******/
		%feature("compactdefaultargs") D3;
		%feature("autodoc", "
Parameters
----------
U: float
P: gp_Pnt2d
V1: gp_Vec2d
V2: gp_Vec2d
V3: gp_Vec2d

Return
-------
None

Description
-----------
Returns the point P of parameter U, the first, the second and the third derivative. Raised if the continuity of the current interval is not C3.
") D3;
		virtual void D3(const Standard_Real U, gp_Pnt2d & P, gp_Vec2d & V1, gp_Vec2d & V2, gp_Vec2d & V3);

		/****** Adaptor2d_Curve2d::DN ******/
		/****** md5 signature: f633d1449599e5f52db1c34ec4b27035 ******/
		%feature("compactdefaultargs") DN;
		%feature("autodoc", "
Parameters
----------
U: float
N: int

Return
-------
gp_Vec2d

Description
-----------
The returned vector gives the value of the derivative for the order of derivation N. Raised if the continuity of the current interval is not CN. Raised if N < 1.
") DN;
		virtual gp_Vec2d DN(const Standard_Real U, const Standard_Integer N);

		/****** Adaptor2d_Curve2d::Degree ******/
		/****** md5 signature: d442d1b77ae7b1ce10d9531914b14be7 ******/
		%feature("compactdefaultargs") Degree;
		%feature("autodoc", "Return
-------
int

Description
-----------
No available documentation.
") Degree;
		virtual Standard_Integer Degree();

		/****** Adaptor2d_Curve2d::Ellipse ******/
		/****** md5 signature: ad57dba8c1c2fed98a4ee4d518e5af58 ******/
		%feature("compactdefaultargs") Ellipse;
		%feature("autodoc", "Return
-------
gp_Elips2d

Description
-----------
No available documentation.
") Ellipse;
		virtual gp_Elips2d Ellipse();

		/****** Adaptor2d_Curve2d::FirstParameter ******/
		/****** md5 signature: adaac52a0f2d3263c19caadcbea394a2 ******/
		%feature("compactdefaultargs") FirstParameter;
		%feature("autodoc", "Return
-------
float

Description
-----------
No available documentation.
") FirstParameter;
		virtual Standard_Real FirstParameter();

		/****** Adaptor2d_Curve2d::GetType ******/
		/****** md5 signature: 657f9e3cbd23a069ca4adcba08a9b196 ******/
		%feature("compactdefaultargs") GetType;
		%feature("autodoc", "Return
-------
GeomAbs_CurveType

Description
-----------
Returns the type of the curve in the current interval: Line, Circle, Ellipse, Hyperbola, Parabola, BezierCurve, BSplineCurve, OtherCurve.
") GetType;
		virtual GeomAbs_CurveType GetType();

		/****** Adaptor2d_Curve2d::Hyperbola ******/
		/****** md5 signature: ec5c753a319a89563396073e20a5375e ******/
		%feature("compactdefaultargs") Hyperbola;
		%feature("autodoc", "Return
-------
gp_Hypr2d

Description
-----------
No available documentation.
") Hyperbola;
		virtual gp_Hypr2d Hyperbola();

		/****** Adaptor2d_Curve2d::Intervals ******/
		/****** md5 signature: 1b47d9fadea42b0a52e1ad5844faff05 ******/
		%feature("compactdefaultargs") Intervals;
		%feature("autodoc", "
Parameters
----------
T: TColStd_Array1OfReal
S: GeomAbs_Shape

Return
-------
None

Description
-----------
Stores in <T> the parameters bounding the intervals of continuity <S>. //! The array must provide enough room to accommodate for the parameters. i.e. T.Length() > NbIntervals().
") Intervals;
		virtual void Intervals(TColStd_Array1OfReal & T, const GeomAbs_Shape S);

		/****** Adaptor2d_Curve2d::IsClosed ******/
		/****** md5 signature: d57ef0715a5abf96ea6273eee63d5417 ******/
		%feature("compactdefaultargs") IsClosed;
		%feature("autodoc", "Return
-------
bool

Description
-----------
No available documentation.
") IsClosed;
		virtual Standard_Boolean IsClosed();

		/****** Adaptor2d_Curve2d::IsPeriodic ******/
		/****** md5 signature: aac83d336e26e94b4cd1076ac72ce2c9 ******/
		%feature("compactdefaultargs") IsPeriodic;
		%feature("autodoc", "Return
-------
bool

Description
-----------
No available documentation.
") IsPeriodic;
		virtual Standard_Boolean IsPeriodic();

		/****** Adaptor2d_Curve2d::IsRational ******/
		/****** md5 signature: 5389f1211fc99cfdcbd6575b8eec7b5c ******/
		%feature("compactdefaultargs") IsRational;
		%feature("autodoc", "Return
-------
bool

Description
-----------
No available documentation.
") IsRational;
		virtual Standard_Boolean IsRational();

		/****** Adaptor2d_Curve2d::LastParameter ******/
		/****** md5 signature: 38a37eecbdff8d3a1b5ffdd6b12bf4d9 ******/
		%feature("compactdefaultargs") LastParameter;
		%feature("autodoc", "Return
-------
float

Description
-----------
No available documentation.
") LastParameter;
		virtual Standard_Real LastParameter();

		/****** Adaptor2d_Curve2d::Line ******/
		/****** md5 signature: c030f66e64195409bcfc92be438de5d5 ******/
		%feature("compactdefaultargs") Line;
		%feature("autodoc", "Return
-------
gp_Lin2d

Description
-----------
No available documentation.
") Line;
		virtual gp_Lin2d Line();

		/****** Adaptor2d_Curve2d::NbIntervals ******/
		/****** md5 signature: 0b37dc42182e542f53017d0e52c8cd03 ******/
		%feature("compactdefaultargs") NbIntervals;
		%feature("autodoc", "
Parameters
----------
S: GeomAbs_Shape

Return
-------
int

Description
-----------
If necessary, breaks the curve in intervals of continuity <S>. And returns the number of intervals.
") NbIntervals;
		virtual Standard_Integer NbIntervals(const GeomAbs_Shape S);

		/****** Adaptor2d_Curve2d::NbKnots ******/
		/****** md5 signature: 22b54658d4850824758b23cad1529c2f ******/
		%feature("compactdefaultargs") NbKnots;
		%feature("autodoc", "Return
-------
int

Description
-----------
No available documentation.
") NbKnots;
		virtual Standard_Integer NbKnots();

		/****** Adaptor2d_Curve2d::NbPoles ******/
		/****** md5 signature: 1b49ced11f88c6092f4e3b2473fe0460 ******/
		%feature("compactdefaultargs") NbPoles;
		%feature("autodoc", "Return
-------
int

Description
-----------
No available documentation.
") NbPoles;
		virtual Standard_Integer NbPoles();

		/****** Adaptor2d_Curve2d::NbSamples ******/
		/****** md5 signature: fa9dfaedc08a9e4459ffebec8ddb6476 ******/
		%feature("compactdefaultargs") NbSamples;
		%feature("autodoc", "Return
-------
int

Description
-----------
No available documentation.
") NbSamples;
		virtual Standard_Integer NbSamples();

		/****** Adaptor2d_Curve2d::Parabola ******/
		/****** md5 signature: 2bbe5ac6a61b052fd2bae484e8f0313c ******/
		%feature("compactdefaultargs") Parabola;
		%feature("autodoc", "Return
-------
gp_Parab2d

Description
-----------
No available documentation.
") Parabola;
		virtual gp_Parab2d Parabola();

		/****** Adaptor2d_Curve2d::Period ******/
		/****** md5 signature: e4913c399f3a0a7037e498c5a9da8e1f ******/
		%feature("compactdefaultargs") Period;
		%feature("autodoc", "Return
-------
float

Description
-----------
No available documentation.
") Period;
		virtual Standard_Real Period();

		/****** Adaptor2d_Curve2d::Resolution ******/
		/****** md5 signature: 66fa92ada4ec8706453c0525abd4ecd6 ******/
		%feature("compactdefaultargs") Resolution;
		%feature("autodoc", "
Parameters
----------
R3d: float

Return
-------
float

Description
-----------
Returns the parametric resolution corresponding to the real space resolution <R3d>.
") Resolution;
		virtual Standard_Real Resolution(const Standard_Real R3d);

		/****** Adaptor2d_Curve2d::ShallowCopy ******/
		/****** md5 signature: b866918647453effb47966d082097526 ******/
		%feature("compactdefaultargs") ShallowCopy;
		%feature("autodoc", "Return
-------
opencascade::handle<Adaptor2d_Curve2d>

Description
-----------
Shallow copy of adaptor.
") ShallowCopy;
		virtual opencascade::handle<Adaptor2d_Curve2d> ShallowCopy();

		/****** Adaptor2d_Curve2d::Trim ******/
		/****** md5 signature: aa66325f9b552366d3dd9f832a9cb16d ******/
		%feature("compactdefaultargs") Trim;
		%feature("autodoc", "
Parameters
----------
First: float
Last: float
Tol: float

Return
-------
opencascade::handle<Adaptor2d_Curve2d>

Description
-----------
Returns a curve equivalent of <self> between parameters <First> and <Last>. <Tol> is used to test for 3d points confusion. If <First> >= <Last>.
") Trim;
		virtual opencascade::handle<Adaptor2d_Curve2d> Trim(const Standard_Real First, const Standard_Real Last, const Standard_Real Tol);

		/****** Adaptor2d_Curve2d::Value ******/
		/****** md5 signature: af409c62c74a5e93d7c7e76240b9de9b ******/
		%feature("compactdefaultargs") Value;
		%feature("autodoc", "
Parameters
----------
U: float

Return
-------
gp_Pnt2d

Description
-----------
Computes the point of parameter U on the curve.
") Value;
		virtual gp_Pnt2d Value(const Standard_Real U);

};


%make_alias(Adaptor2d_Curve2d)

%extend Adaptor2d_Curve2d {
	%pythoncode {
	__repr__ = _dumps_object
	}
};

/*************************
* class Adaptor2d_Line2d *
*************************/
class Adaptor2d_Line2d : public Adaptor2d_Curve2d {
	public:
		/****** Adaptor2d_Line2d::Adaptor2d_Line2d ******/
		/****** md5 signature: a217d4c2f1a39c468576f503c72e4282 ******/
		%feature("compactdefaultargs") Adaptor2d_Line2d;
		%feature("autodoc", "Return
-------
None

Description
-----------
No available documentation.
") Adaptor2d_Line2d;
		 Adaptor2d_Line2d();

		/****** Adaptor2d_Line2d::Adaptor2d_Line2d ******/
		/****** md5 signature: b3b555011ccd08a69e1a951ee36e4ce2 ******/
		%feature("compactdefaultargs") Adaptor2d_Line2d;
		%feature("autodoc", "
Parameters
----------
P: gp_Pnt2d
D: gp_Dir2d
UFirst: float
ULast: float

Return
-------
None

Description
-----------
No available documentation.
") Adaptor2d_Line2d;
		 Adaptor2d_Line2d(const gp_Pnt2d & P, const gp_Dir2d & D, const Standard_Real UFirst, const Standard_Real ULast);

		/****** Adaptor2d_Line2d::BSpline ******/
		/****** md5 signature: 9439c331c4f14f299277aa5a4ff16cec ******/
		%feature("compactdefaultargs") BSpline;
		%feature("autodoc", "Return
-------
opencascade::handle<Geom2d_BSplineCurve>

Description
-----------
No available documentation.
") BSpline;
		opencascade::handle<Geom2d_BSplineCurve> BSpline();

		/****** Adaptor2d_Line2d::Bezier ******/
		/****** md5 signature: cabcbe9e94c679dcfc142972b20ab60b ******/
		%feature("compactdefaultargs") Bezier;
		%feature("autodoc", "Return
-------
opencascade::handle<Geom2d_BezierCurve>

Description
-----------
No available documentation.
") Bezier;
		opencascade::handle<Geom2d_BezierCurve> Bezier();

		/****** Adaptor2d_Line2d::Circle ******/
		/****** md5 signature: 031880777795958cc554fa5739cb3a95 ******/
		%feature("compactdefaultargs") Circle;
		%feature("autodoc", "Return
-------
gp_Circ2d

Description
-----------
No available documentation.
") Circle;
		gp_Circ2d Circle();

		/****** Adaptor2d_Line2d::Continuity ******/
		/****** md5 signature: 9381b370dfdd50af7f1b79ce202f0c6f ******/
		%feature("compactdefaultargs") Continuity;
		%feature("autodoc", "Return
-------
GeomAbs_Shape

Description
-----------
No available documentation.
") Continuity;
		GeomAbs_Shape Continuity();

		/****** Adaptor2d_Line2d::D0 ******/
		/****** md5 signature: 93720dcd9f9e8e8980602530da337c79 ******/
		%feature("compactdefaultargs") D0;
		%feature("autodoc", "
Parameters
----------
X: float
P: gp_Pnt2d

Return
-------
None

Description
-----------
No available documentation.
") D0;
		void D0(const Standard_Real X, gp_Pnt2d & P);

		/****** Adaptor2d_Line2d::D1 ******/
		/****** md5 signature: 423f97f4cd493b4f6cf5b9cd8bc9c101 ******/
		%feature("compactdefaultargs") D1;
		%feature("autodoc", "
Parameters
----------
X: float
P: gp_Pnt2d
V: gp_Vec2d

Return
-------
None

Description
-----------
No available documentation.
") D1;
		void D1(const Standard_Real X, gp_Pnt2d & P, gp_Vec2d & V);

		/****** Adaptor2d_Line2d::D2 ******/
		/****** md5 signature: fe409137f7ff4361ef92efcdab935654 ******/
		%feature("compactdefaultargs") D2;
		%feature("autodoc", "
Parameters
----------
X: float
P: gp_Pnt2d
V1: gp_Vec2d
V2: gp_Vec2d

Return
-------
None

Description
-----------
No available documentation.
") D2;
		void D2(const Standard_Real X, gp_Pnt2d & P, gp_Vec2d & V1, gp_Vec2d & V2);

		/****** Adaptor2d_Line2d::D3 ******/
		/****** md5 signature: 802e53b731cc18884f89925d02e1d5fb ******/
		%feature("compactdefaultargs") D3;
		%feature("autodoc", "
Parameters
----------
X: float
P: gp_Pnt2d
V1: gp_Vec2d
V2: gp_Vec2d
V3: gp_Vec2d

Return
-------
None

Description
-----------
No available documentation.
") D3;
		void D3(const Standard_Real X, gp_Pnt2d & P, gp_Vec2d & V1, gp_Vec2d & V2, gp_Vec2d & V3);

		/****** Adaptor2d_Line2d::DN ******/
		/****** md5 signature: a05d2f76912764cef5ac7bb40ebda3d7 ******/
		%feature("compactdefaultargs") DN;
		%feature("autodoc", "
Parameters
----------
U: float
N: int

Return
-------
gp_Vec2d

Description
-----------
No available documentation.
") DN;
		gp_Vec2d DN(const Standard_Real U, const Standard_Integer N);

		/****** Adaptor2d_Line2d::Degree ******/
		/****** md5 signature: 5ce473e72cc7bb935a667f4c839dab09 ******/
		%feature("compactdefaultargs") Degree;
		%feature("autodoc", "Return
-------
int

Description
-----------
No available documentation.
") Degree;
		Standard_Integer Degree();

		/****** Adaptor2d_Line2d::Ellipse ******/
		/****** md5 signature: 57e9088d9546fb79032102b676477b62 ******/
		%feature("compactdefaultargs") Ellipse;
		%feature("autodoc", "Return
-------
gp_Elips2d

Description
-----------
No available documentation.
") Ellipse;
		gp_Elips2d Ellipse();

		/****** Adaptor2d_Line2d::FirstParameter ******/
		/****** md5 signature: eb9ebe94572bd67588fe8811eac261fb ******/
		%feature("compactdefaultargs") FirstParameter;
		%feature("autodoc", "Return
-------
float

Description
-----------
No available documentation.
") FirstParameter;
		Standard_Real FirstParameter();

		/****** Adaptor2d_Line2d::GetType ******/
		/****** md5 signature: 0ad61dcbb5497908c1b536e766f0fcb9 ******/
		%feature("compactdefaultargs") GetType;
		%feature("autodoc", "Return
-------
GeomAbs_CurveType

Description
-----------
No available documentation.
") GetType;
		GeomAbs_CurveType GetType();

		/****** Adaptor2d_Line2d::Hyperbola ******/
		/****** md5 signature: 951e1971b5974627f011740e5c4c9ecb ******/
		%feature("compactdefaultargs") Hyperbola;
		%feature("autodoc", "Return
-------
gp_Hypr2d

Description
-----------
No available documentation.
") Hyperbola;
		gp_Hypr2d Hyperbola();

		/****** Adaptor2d_Line2d::Intervals ******/
		/****** md5 signature: fc573cb56cf1a9c05ee189fd913ff6f5 ******/
		%feature("compactdefaultargs") Intervals;
		%feature("autodoc", "
Parameters
----------
T: TColStd_Array1OfReal
S: GeomAbs_Shape

Return
-------
None

Description
-----------
Stores in <T> the parameters bounding the intervals of continuity <S>. //! The array must provide enough room to accommodate for the parameters. i.e. T.Length() > NbIntervals().
") Intervals;
		void Intervals(TColStd_Array1OfReal & T, const GeomAbs_Shape S);

		/****** Adaptor2d_Line2d::IsClosed ******/
		/****** md5 signature: 00978070ec4cb5f00d1d002a8d5d3763 ******/
		%feature("compactdefaultargs") IsClosed;
		%feature("autodoc", "Return
-------
bool

Description
-----------
No available documentation.
") IsClosed;
		Standard_Boolean IsClosed();

		/****** Adaptor2d_Line2d::IsPeriodic ******/
		/****** md5 signature: 15e3ccfd3ad4ae42959489f7f64aa8ca ******/
		%feature("compactdefaultargs") IsPeriodic;
		%feature("autodoc", "Return
-------
bool

Description
-----------
No available documentation.
") IsPeriodic;
		Standard_Boolean IsPeriodic();

		/****** Adaptor2d_Line2d::IsRational ******/
		/****** md5 signature: 82ca56fad113156125f40128b25c0d8e ******/
		%feature("compactdefaultargs") IsRational;
		%feature("autodoc", "Return
-------
bool

Description
-----------
No available documentation.
") IsRational;
		Standard_Boolean IsRational();

		/****** Adaptor2d_Line2d::LastParameter ******/
		/****** md5 signature: cb4925a2d4a451ceec8f6ad486530f9c ******/
		%feature("compactdefaultargs") LastParameter;
		%feature("autodoc", "Return
-------
float

Description
-----------
No available documentation.
") LastParameter;
		Standard_Real LastParameter();

		/****** Adaptor2d_Line2d::Line ******/
		/****** md5 signature: d41344e9c3febf8a7347a9e78e837373 ******/
		%feature("compactdefaultargs") Line;
		%feature("autodoc", "Return
-------
gp_Lin2d

Description
-----------
No available documentation.
") Line;
		gp_Lin2d Line();

		/****** Adaptor2d_Line2d::Load ******/
		/****** md5 signature: 7620a23c09d16846209666736fe05b85 ******/
		%feature("compactdefaultargs") Load;
		%feature("autodoc", "
Parameters
----------
L: gp_Lin2d

Return
-------
None

Description
-----------
No available documentation.
") Load;
		void Load(const gp_Lin2d & L);

		/****** Adaptor2d_Line2d::Load ******/
		/****** md5 signature: 3737a9da343db0c1813b6fdf3bdda8e1 ******/
		%feature("compactdefaultargs") Load;
		%feature("autodoc", "
Parameters
----------
L: gp_Lin2d
UFirst: float
ULast: float

Return
-------
None

Description
-----------
No available documentation.
") Load;
		void Load(const gp_Lin2d & L, const Standard_Real UFirst, const Standard_Real ULast);

		/****** Adaptor2d_Line2d::NbIntervals ******/
		/****** md5 signature: 8ce4f61bff96d1ce0784028b47edd8dc ******/
		%feature("compactdefaultargs") NbIntervals;
		%feature("autodoc", "
Parameters
----------
S: GeomAbs_Shape

Return
-------
int

Description
-----------
If necessary, breaks the curve in intervals of continuity <S>. And returns the number of intervals.
") NbIntervals;
		Standard_Integer NbIntervals(const GeomAbs_Shape S);

		/****** Adaptor2d_Line2d::NbKnots ******/
		/****** md5 signature: 841663cbf96bec3b939f307c52df6c7c ******/
		%feature("compactdefaultargs") NbKnots;
		%feature("autodoc", "Return
-------
int

Description
-----------
No available documentation.
") NbKnots;
		Standard_Integer NbKnots();

		/****** Adaptor2d_Line2d::NbPoles ******/
		/****** md5 signature: 52e5fadf897540545847ef59cc0ba942 ******/
		%feature("compactdefaultargs") NbPoles;
		%feature("autodoc", "Return
-------
int

Description
-----------
No available documentation.
") NbPoles;
		Standard_Integer NbPoles();

		/****** Adaptor2d_Line2d::Parabola ******/
		/****** md5 signature: 38729705f952495154cecf7cf9964648 ******/
		%feature("compactdefaultargs") Parabola;
		%feature("autodoc", "Return
-------
gp_Parab2d

Description
-----------
No available documentation.
") Parabola;
		gp_Parab2d Parabola();

		/****** Adaptor2d_Line2d::Period ******/
		/****** md5 signature: 88909a321398632744c0d6841580c626 ******/
		%feature("compactdefaultargs") Period;
		%feature("autodoc", "Return
-------
float

Description
-----------
No available documentation.
") Period;
		Standard_Real Period();

		/****** Adaptor2d_Line2d::Resolution ******/
		/****** md5 signature: cc4a4d9111fadd20ad48e62bc4df1579 ******/
		%feature("compactdefaultargs") Resolution;
		%feature("autodoc", "
Parameters
----------
R3d: float

Return
-------
float

Description
-----------
No available documentation.
") Resolution;
		Standard_Real Resolution(const Standard_Real R3d);

		/****** Adaptor2d_Line2d::ShallowCopy ******/
		/****** md5 signature: 7526aff3b770b4e3b1eb3cc08adfb4b0 ******/
		%feature("compactdefaultargs") ShallowCopy;
		%feature("autodoc", "Return
-------
opencascade::handle<Adaptor2d_Curve2d>

Description
-----------
Shallow copy of adaptor.
") ShallowCopy;
		virtual opencascade::handle<Adaptor2d_Curve2d> ShallowCopy();

		/****** Adaptor2d_Line2d::Trim ******/
		/****** md5 signature: b5ce1c7f3b02aa6680da8e9ad704acc6 ******/
		%feature("compactdefaultargs") Trim;
		%feature("autodoc", "
Parameters
----------
First: float
Last: float
Tol: float

Return
-------
opencascade::handle<Adaptor2d_Curve2d>

Description
-----------
Returns a curve equivalent of <self> between parameters <First> and <Last>. <Tol> is used to test for 3d points confusion. If <First> >= <Last>.
") Trim;
		opencascade::handle<Adaptor2d_Curve2d> Trim(const Standard_Real First, const Standard_Real Last, const Standard_Real Tol);

		/****** Adaptor2d_Line2d::Value ******/
		/****** md5 signature: 98884cb0e60eec266d8c9645d817f1b5 ******/
		%feature("compactdefaultargs") Value;
		%feature("autodoc", "
Parameters
----------
X: float

Return
-------
gp_Pnt2d

Description
-----------
No available documentation.
") Value;
		gp_Pnt2d Value(const Standard_Real X);

};


%make_alias(Adaptor2d_Line2d)

%extend Adaptor2d_Line2d {
	%pythoncode {
	__repr__ = _dumps_object
	}
};

/******************************
* class Adaptor2d_OffsetCurve *
******************************/
class Adaptor2d_OffsetCurve : public Adaptor2d_Curve2d {
	public:
		/****** Adaptor2d_OffsetCurve::Adaptor2d_OffsetCurve ******/
		/****** md5 signature: 451c0a1cc0af1792697a4f563e2766d2 ******/
		%feature("compactdefaultargs") Adaptor2d_OffsetCurve;
		%feature("autodoc", "Return
-------
None

Description
-----------
The Offset is set to 0.
") Adaptor2d_OffsetCurve;
		 Adaptor2d_OffsetCurve();

		/****** Adaptor2d_OffsetCurve::Adaptor2d_OffsetCurve ******/
		/****** md5 signature: 5654e6bb9cb8b9bac1b0469cd906dc2c ******/
		%feature("compactdefaultargs") Adaptor2d_OffsetCurve;
		%feature("autodoc", "
Parameters
----------
C: Adaptor2d_Curve2d

Return
-------
None

Description
-----------
The curve is loaded. The Offset is set to 0.
") Adaptor2d_OffsetCurve;
		 Adaptor2d_OffsetCurve(const opencascade::handle<Adaptor2d_Curve2d> & C);

		/****** Adaptor2d_OffsetCurve::Adaptor2d_OffsetCurve ******/
		/****** md5 signature: 2b9b1c473de25b65f79a33cf02d9d422 ******/
		%feature("compactdefaultargs") Adaptor2d_OffsetCurve;
		%feature("autodoc", "
Parameters
----------
C: Adaptor2d_Curve2d
Offset: float

Return
-------
None

Description
-----------
Creates an OffsetCurve curve. The Offset is set to Offset.
") Adaptor2d_OffsetCurve;
		 Adaptor2d_OffsetCurve(const opencascade::handle<Adaptor2d_Curve2d> & C, const Standard_Real Offset);

		/****** Adaptor2d_OffsetCurve::Adaptor2d_OffsetCurve ******/
		/****** md5 signature: bcca54868ea581c1cf7db2b8ab1074bc ******/
		%feature("compactdefaultargs") Adaptor2d_OffsetCurve;
		%feature("autodoc", "
Parameters
----------
C: Adaptor2d_Curve2d
Offset: float
WFirst: float
WLast: float

Return
-------
None

Description
-----------
Create an Offset curve. WFirst,WLast define the bounds of the Offset curve.
") Adaptor2d_OffsetCurve;
		 Adaptor2d_OffsetCurve(const opencascade::handle<Adaptor2d_Curve2d> & C, const Standard_Real Offset, const Standard_Real WFirst, const Standard_Real WLast);

		/****** Adaptor2d_OffsetCurve::BSpline ******/
		/****** md5 signature: 9439c331c4f14f299277aa5a4ff16cec ******/
		%feature("compactdefaultargs") BSpline;
		%feature("autodoc", "Return
-------
opencascade::handle<Geom2d_BSplineCurve>

Description
-----------
No available documentation.
") BSpline;
		opencascade::handle<Geom2d_BSplineCurve> BSpline();

		/****** Adaptor2d_OffsetCurve::Bezier ******/
		/****** md5 signature: cabcbe9e94c679dcfc142972b20ab60b ******/
		%feature("compactdefaultargs") Bezier;
		%feature("autodoc", "Return
-------
opencascade::handle<Geom2d_BezierCurve>

Description
-----------
No available documentation.
") Bezier;
		opencascade::handle<Geom2d_BezierCurve> Bezier();

		/****** Adaptor2d_OffsetCurve::Circle ******/
		/****** md5 signature: 031880777795958cc554fa5739cb3a95 ******/
		%feature("compactdefaultargs") Circle;
		%feature("autodoc", "Return
-------
gp_Circ2d

Description
-----------
No available documentation.
") Circle;
		gp_Circ2d Circle();

		/****** Adaptor2d_OffsetCurve::Continuity ******/
		/****** md5 signature: 9381b370dfdd50af7f1b79ce202f0c6f ******/
		%feature("compactdefaultargs") Continuity;
		%feature("autodoc", "Return
-------
GeomAbs_Shape

Description
-----------
No available documentation.
") Continuity;
		GeomAbs_Shape Continuity();

		/****** Adaptor2d_OffsetCurve::Curve ******/
		/****** md5 signature: 49c261ed663fbe8204b6afa365e067a9 ******/
		%feature("compactdefaultargs") Curve;
		%feature("autodoc", "Return
-------
opencascade::handle<Adaptor2d_Curve2d>

Description
-----------
No available documentation.
") Curve;
		const opencascade::handle<Adaptor2d_Curve2d> & Curve();

		/****** Adaptor2d_OffsetCurve::D0 ******/
		/****** md5 signature: 01a5234aae6db090351bac35b3718fd9 ******/
		%feature("compactdefaultargs") D0;
		%feature("autodoc", "
Parameters
----------
U: float
P: gp_Pnt2d

Return
-------
None

Description
-----------
Computes the point of parameter U on the curve.
") D0;
		void D0(const Standard_Real U, gp_Pnt2d & P);

		/****** Adaptor2d_OffsetCurve::D1 ******/
		/****** md5 signature: 79a293d0b91ab6d1359881075119fb56 ******/
		%feature("compactdefaultargs") D1;
		%feature("autodoc", "
Parameters
----------
U: float
P: gp_Pnt2d
V: gp_Vec2d

Return
-------
None

Description
-----------
Computes the point of parameter U on the curve with its first derivative. Raised if the continuity of the current interval is not C1.
") D1;
		void D1(const Standard_Real U, gp_Pnt2d & P, gp_Vec2d & V);

		/****** Adaptor2d_OffsetCurve::D2 ******/
		/****** md5 signature: acc8c0955596bb0bf809102736ad1124 ******/
		%feature("compactdefaultargs") D2;
		%feature("autodoc", "
Parameters
----------
U: float
P: gp_Pnt2d
V1: gp_Vec2d
V2: gp_Vec2d

Return
-------
None

Description
-----------
Returns the point P of parameter U, the first and second derivatives V1 and V2. Raised if the continuity of the current interval is not C2.
") D2;
		void D2(const Standard_Real U, gp_Pnt2d & P, gp_Vec2d & V1, gp_Vec2d & V2);

		/****** Adaptor2d_OffsetCurve::D3 ******/
		/****** md5 signature: 28315b7efe2f6c64fe9497aa5c5ddaf6 ******/
		%feature("compactdefaultargs") D3;
		%feature("autodoc", "
Parameters
----------
U: float
P: gp_Pnt2d
V1: gp_Vec2d
V2: gp_Vec2d
V3: gp_Vec2d

Return
-------
None

Description
-----------
Returns the point P of parameter U, the first, the second and the third derivative. Raised if the continuity of the current interval is not C3.
") D3;
		void D3(const Standard_Real U, gp_Pnt2d & P, gp_Vec2d & V1, gp_Vec2d & V2, gp_Vec2d & V3);

		/****** Adaptor2d_OffsetCurve::DN ******/
		/****** md5 signature: a05d2f76912764cef5ac7bb40ebda3d7 ******/
		%feature("compactdefaultargs") DN;
		%feature("autodoc", "
Parameters
----------
U: float
N: int

Return
-------
gp_Vec2d

Description
-----------
The returned vector gives the value of the derivative for the order of derivation N. Raised if the continuity of the current interval is not CN. Raised if N < 1.
") DN;
		gp_Vec2d DN(const Standard_Real U, const Standard_Integer N);

		/****** Adaptor2d_OffsetCurve::Degree ******/
		/****** md5 signature: 5ce473e72cc7bb935a667f4c839dab09 ******/
		%feature("compactdefaultargs") Degree;
		%feature("autodoc", "Return
-------
int

Description
-----------
No available documentation.
") Degree;
		Standard_Integer Degree();

		/****** Adaptor2d_OffsetCurve::Ellipse ******/
		/****** md5 signature: 57e9088d9546fb79032102b676477b62 ******/
		%feature("compactdefaultargs") Ellipse;
		%feature("autodoc", "Return
-------
gp_Elips2d

Description
-----------
No available documentation.
") Ellipse;
		gp_Elips2d Ellipse();

		/****** Adaptor2d_OffsetCurve::FirstParameter ******/
		/****** md5 signature: 93c381754667baab23468a195644e410 ******/
		%feature("compactdefaultargs") FirstParameter;
		%feature("autodoc", "Return
-------
float

Description
-----------
No available documentation.
") FirstParameter;
		virtual Standard_Real FirstParameter();

		/****** Adaptor2d_OffsetCurve::GetType ******/
		/****** md5 signature: 0ad61dcbb5497908c1b536e766f0fcb9 ******/
		%feature("compactdefaultargs") GetType;
		%feature("autodoc", "Return
-------
GeomAbs_CurveType

Description
-----------
Returns the type of the curve in the current interval: Line, Circle, Ellipse, Hyperbola, Parabola, BezierCurve, BSplineCurve, OtherCurve.
") GetType;
		GeomAbs_CurveType GetType();

		/****** Adaptor2d_OffsetCurve::Hyperbola ******/
		/****** md5 signature: 951e1971b5974627f011740e5c4c9ecb ******/
		%feature("compactdefaultargs") Hyperbola;
		%feature("autodoc", "Return
-------
gp_Hypr2d

Description
-----------
No available documentation.
") Hyperbola;
		gp_Hypr2d Hyperbola();

		/****** Adaptor2d_OffsetCurve::Intervals ******/
		/****** md5 signature: fc573cb56cf1a9c05ee189fd913ff6f5 ******/
		%feature("compactdefaultargs") Intervals;
		%feature("autodoc", "
Parameters
----------
T: TColStd_Array1OfReal
S: GeomAbs_Shape

Return
-------
None

Description
-----------
Stores in <T> the parameters bounding the intervals of continuity <S>. //! The array must provide enough room to accommodate for the parameters. i.e. T.Length() > NbIntervals().
") Intervals;
		void Intervals(TColStd_Array1OfReal & T, const GeomAbs_Shape S);

		/****** Adaptor2d_OffsetCurve::IsClosed ******/
		/****** md5 signature: 00978070ec4cb5f00d1d002a8d5d3763 ******/
		%feature("compactdefaultargs") IsClosed;
		%feature("autodoc", "Return
-------
bool

Description
-----------
No available documentation.
") IsClosed;
		Standard_Boolean IsClosed();

		/****** Adaptor2d_OffsetCurve::IsPeriodic ******/
		/****** md5 signature: 15e3ccfd3ad4ae42959489f7f64aa8ca ******/
		%feature("compactdefaultargs") IsPeriodic;
		%feature("autodoc", "Return
-------
bool

Description
-----------
No available documentation.
") IsPeriodic;
		Standard_Boolean IsPeriodic();

		/****** Adaptor2d_OffsetCurve::IsRational ******/
		/****** md5 signature: 82ca56fad113156125f40128b25c0d8e ******/
		%feature("compactdefaultargs") IsRational;
		%feature("autodoc", "Return
-------
bool

Description
-----------
No available documentation.
") IsRational;
		Standard_Boolean IsRational();

		/****** Adaptor2d_OffsetCurve::LastParameter ******/
		/****** md5 signature: a2893a92f9c4af09acb0cd59d959d964 ******/
		%feature("compactdefaultargs") LastParameter;
		%feature("autodoc", "Return
-------
float

Description
-----------
No available documentation.
") LastParameter;
		virtual Standard_Real LastParameter();

		/****** Adaptor2d_OffsetCurve::Line ******/
		/****** md5 signature: d41344e9c3febf8a7347a9e78e837373 ******/
		%feature("compactdefaultargs") Line;
		%feature("autodoc", "Return
-------
gp_Lin2d

Description
-----------
No available documentation.
") Line;
		gp_Lin2d Line();

		/****** Adaptor2d_OffsetCurve::Load ******/
		/****** md5 signature: 9061983eb8107070a51888448966855a ******/
		%feature("compactdefaultargs") Load;
		%feature("autodoc", "
Parameters
----------
S: Adaptor2d_Curve2d

Return
-------
None

Description
-----------
Changes the curve. The Offset is reset to 0.
") Load;
		void Load(const opencascade::handle<Adaptor2d_Curve2d> & S);

		/****** Adaptor2d_OffsetCurve::Load ******/
		/****** md5 signature: 9a0b0df619b9827b4c54ec1608be65ca ******/
		%feature("compactdefaultargs") Load;
		%feature("autodoc", "
Parameters
----------
Offset: float

Return
-------
None

Description
-----------
Changes the Offset on the current Curve.
") Load;
		void Load(const Standard_Real Offset);

		/****** Adaptor2d_OffsetCurve::Load ******/
		/****** md5 signature: 3322ee7ce92e3dcbd7a1a9bc1c56530c ******/
		%feature("compactdefaultargs") Load;
		%feature("autodoc", "
Parameters
----------
Offset: float
WFirst: float
WLast: float

Return
-------
None

Description
-----------
Changes the Offset Curve on the current Curve.
") Load;
		void Load(const Standard_Real Offset, const Standard_Real WFirst, const Standard_Real WLast);

		/****** Adaptor2d_OffsetCurve::NbIntervals ******/
		/****** md5 signature: 8ce4f61bff96d1ce0784028b47edd8dc ******/
		%feature("compactdefaultargs") NbIntervals;
		%feature("autodoc", "
Parameters
----------
S: GeomAbs_Shape

Return
-------
int

Description
-----------
If necessary, breaks the curve in intervals of continuity <S>. And returns the number of intervals.
") NbIntervals;
		Standard_Integer NbIntervals(const GeomAbs_Shape S);

		/****** Adaptor2d_OffsetCurve::NbKnots ******/
		/****** md5 signature: 841663cbf96bec3b939f307c52df6c7c ******/
		%feature("compactdefaultargs") NbKnots;
		%feature("autodoc", "Return
-------
int

Description
-----------
No available documentation.
") NbKnots;
		Standard_Integer NbKnots();

		/****** Adaptor2d_OffsetCurve::NbPoles ******/
		/****** md5 signature: 52e5fadf897540545847ef59cc0ba942 ******/
		%feature("compactdefaultargs") NbPoles;
		%feature("autodoc", "Return
-------
int

Description
-----------
No available documentation.
") NbPoles;
		Standard_Integer NbPoles();

		/****** Adaptor2d_OffsetCurve::NbSamples ******/
		/****** md5 signature: 4121a3c2901a01f0443f1a396ebcd6f7 ******/
		%feature("compactdefaultargs") NbSamples;
		%feature("autodoc", "Return
-------
int

Description
-----------
No available documentation.
") NbSamples;
		Standard_Integer NbSamples();

		/****** Adaptor2d_OffsetCurve::Offset ******/
		/****** md5 signature: dc63f42d21519182e8aed77d60677eb8 ******/
		%feature("compactdefaultargs") Offset;
		%feature("autodoc", "Return
-------
float

Description
-----------
No available documentation.
") Offset;
		Standard_Real Offset();

		/****** Adaptor2d_OffsetCurve::Parabola ******/
		/****** md5 signature: 38729705f952495154cecf7cf9964648 ******/
		%feature("compactdefaultargs") Parabola;
		%feature("autodoc", "Return
-------
gp_Parab2d

Description
-----------
No available documentation.
") Parabola;
		gp_Parab2d Parabola();

		/****** Adaptor2d_OffsetCurve::Period ******/
		/****** md5 signature: 88909a321398632744c0d6841580c626 ******/
		%feature("compactdefaultargs") Period;
		%feature("autodoc", "Return
-------
float

Description
-----------
No available documentation.
") Period;
		Standard_Real Period();

		/****** Adaptor2d_OffsetCurve::Resolution ******/
		/****** md5 signature: cc4a4d9111fadd20ad48e62bc4df1579 ******/
		%feature("compactdefaultargs") Resolution;
		%feature("autodoc", "
Parameters
----------
R3d: float

Return
-------
float

Description
-----------
Returns the parametric resolution corresponding to the real space resolution <R3d>.
") Resolution;
		Standard_Real Resolution(const Standard_Real R3d);

		/****** Adaptor2d_OffsetCurve::ShallowCopy ******/
		/****** md5 signature: 7526aff3b770b4e3b1eb3cc08adfb4b0 ******/
		%feature("compactdefaultargs") ShallowCopy;
		%feature("autodoc", "Return
-------
opencascade::handle<Adaptor2d_Curve2d>

Description
-----------
Shallow copy of adaptor.
") ShallowCopy;
		virtual opencascade::handle<Adaptor2d_Curve2d> ShallowCopy();

		/****** Adaptor2d_OffsetCurve::Trim ******/
		/****** md5 signature: b5ce1c7f3b02aa6680da8e9ad704acc6 ******/
		%feature("compactdefaultargs") Trim;
		%feature("autodoc", "
Parameters
----------
First: float
Last: float
Tol: float

Return
-------
opencascade::handle<Adaptor2d_Curve2d>

Description
-----------
Returns a curve equivalent of <self> between parameters <First> and <Last>. <Tol> is used to test for 3d points confusion. If <First> >= <Last>.
") Trim;
		opencascade::handle<Adaptor2d_Curve2d> Trim(const Standard_Real First, const Standard_Real Last, const Standard_Real Tol);

		/****** Adaptor2d_OffsetCurve::Value ******/
		/****** md5 signature: 91dcf5c5229f25c64d3a714347090b29 ******/
		%feature("compactdefaultargs") Value;
		%feature("autodoc", "
Parameters
----------
U: float

Return
-------
gp_Pnt2d

Description
-----------
Computes the point of parameter U on the curve.
") Value;
		gp_Pnt2d Value(const Standard_Real U);

};


%make_alias(Adaptor2d_OffsetCurve)

%extend Adaptor2d_OffsetCurve {
	%pythoncode {
	__repr__ = _dumps_object
	}
};

/* harray1 classes */
/* harray2 classes */
/* hsequence classes */
/* class aliases */
%pythoncode {
}
