from typing import Dict, List, Optional, Tuple

from OCC.Core.AIS import AIS_InteractiveContext, AIS_Shape
from OCC.Core.gp import gp_Trsf
from OCC.Core.Graphic3d import Graphic3d_NameOfMaterial
from OCC.Core.TopoDS import TopoDS_Shape

class Layer:
    color: int
    display: AIS_InteractiveContext
    transparency: float
    material: Graphic3d_NameOfMaterial
    element_to_display: Dict[int, Tuple[TopoDS_Shape, AIS_Shape]]
    count: int

    def __init__(
        self,
        from_display: AIS_InteractiveContext,
        shape: Optional[TopoDS_Shape] = None,
        color: int = 0,
        transparency: float = 0.0,
        material: Graphic3d_NameOfMaterial = Graphic3d_NameOfMaterial.Graphic3d_NOM_DEFAULT,
    ) -> None: ...
    def add_shape(self, shape: TopoDS_Shape) -> None: ...
    def replace_shape(self, shape: TopoDS_Shape, index: int) -> None: ...
    def update_trsf_shape(
        self, shape: TopoDS_Shape, index: int, transformations: gp_Trsf
    ) -> None: ...
    def merge(self, layer: "Layer", clear: bool = False) -> None: ...
    def delete_shape_with_index(self, index: int) -> None: ...
    def delete_shape(self, shape_to_del: TopoDS_Shape) -> None: ...
    def clear(self) -> None: ...
    def get_shapes(self) -> List[TopoDS_Shape]: ...
    def get_aisshape_from_topodsshape(
        self, topshape: TopoDS_Shape
    ) -> Optional[Tuple[AIS_Shape, int]]: ...
    def hide(self) -> None: ...
    def show(self) -> None: ...
