/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 7.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

/*
 * SWGWDSPRxSettings.h
 *
 * WDSPRx
 */

#ifndef SWGWDSPRxSettings_H_
#define SWGWDSPRxSettings_H_

#include <QJsonObject>


#include "SWGChannelMarker.h"
#include "SWGGLSpectrum.h"
#include "SWGRollupState.h"
#include <QList>
#include <QString>

#include "SWGObject.h"
#include "export.h"

namespace SWGSDRangel {

class SWG_API SWGWDSPRxSettings: public SWGObject {
public:
    SWGWDSPRxSettings();
    SWGWDSPRxSettings(QString* json);
    virtual ~SWGWDSPRxSettings();
    void init();
    void cleanup();

    virtual QString asJson () override;
    virtual QJsonObject* asJsonObject() override;
    virtual void fromJsonObject(QJsonObject &json) override;
    virtual SWGWDSPRxSettings* fromJson(QString &jsonString) override;

    qint64 getInputFrequencyOffset();
    void setInputFrequencyOffset(qint64 input_frequency_offset);

    qint32 getProfileIndex();
    void setProfileIndex(qint32 profile_index);

    qint32 getDemod();
    void setDemod(qint32 demod);

    float getVolume();
    void setVolume(float volume);

    qint32 getAudioBinaural();
    void setAudioBinaural(qint32 audio_binaural);

    qint32 getAudioFlipChannels();
    void setAudioFlipChannels(qint32 audio_flip_channels);

    qint32 getDsb();
    void setDsb(qint32 dsb);

    qint32 getAudioMute();
    void setAudioMute(qint32 audio_mute);

    qint32 getAgc();
    void setAgc(qint32 agc);

    qint32 getAgcMode();
    void setAgcMode(qint32 agc_mode);

    qint32 getAgcGain();
    void setAgcGain(qint32 agc_gain);

    qint32 getAgcSlope();
    void setAgcSlope(qint32 agc_slope);

    qint32 getAgcHangThreshold();
    void setAgcHangThreshold(qint32 agc_hang_threshold);

    qint32 getDnb();
    void setDnb(qint32 dnb);

    qint32 getNbScheme();
    void setNbScheme(qint32 nb_scheme);

    qint32 getNb2Mode();
    void setNb2Mode(qint32 nb2_mode);

    float getNbSlewTime();
    void setNbSlewTime(float nb_slew_time);

    float getNbLeadTime();
    void setNbLeadTime(float nb_lead_time);

    float getNbLagTime();
    void setNbLagTime(float nb_lag_time);

    qint32 getNbThreshold();
    void setNbThreshold(qint32 nb_threshold);

    float getNbAvgTime();
    void setNbAvgTime(float nb_avg_time);

    qint32 getDnr();
    void setDnr(qint32 dnr);

    qint32 getAnf();
    void setAnf(qint32 anf);

    qint32 getNrScheme();
    void setNrScheme(qint32 nr_scheme);

    qint32 getNr2Gain();
    void setNr2Gain(qint32 nr2_gain);

    qint32 getNr2Npe();
    void setNr2Npe(qint32 nr2_npe);

    qint32 getNrPosition();
    void setNrPosition(qint32 nr_position);

    qint32 getNr2ArtifactReduction();
    void setNr2ArtifactReduction(qint32 nr2_artifact_reduction);

    qint32 getAmFadeLevel();
    void setAmFadeLevel(qint32 am_fade_level);

    qint32 getCwPeaking();
    void setCwPeaking(qint32 cw_peaking);

    float getCwPeakFrequency();
    void setCwPeakFrequency(float cw_peak_frequency);

    float getCwBandwidth();
    void setCwBandwidth(float cw_bandwidth);

    float getCwGain();
    void setCwGain(float cw_gain);

    float getFmDeviation();
    void setFmDeviation(float fm_deviation);

    float getFmAfLow();
    void setFmAfLow(float fm_af_low);

    float getFmAfHigh();
    void setFmAfHigh(float fm_af_high);

    qint32 getFmAfLimiter();
    void setFmAfLimiter(qint32 fm_af_limiter);

    float getFmAfLimiterGain();
    void setFmAfLimiterGain(float fm_af_limiter_gain);

    qint32 getFmCtcssNotch();
    void setFmCtcssNotch(qint32 fm_ctcss_notch);

    float getFmCtcssNotchFrequency();
    void setFmCtcssNotchFrequency(float fm_ctcss_notch_frequency);

    qint32 getSquelch();
    void setSquelch(qint32 squelch);

    qint32 getSquelchThreshold();
    void setSquelchThreshold(qint32 squelch_threshold);

    qint32 getSquelchMode();
    void setSquelchMode(qint32 squelch_mode);

    float getSsqlTauMute();
    void setSsqlTauMute(float ssql_tau_mute);

    float getSsqlTauUnmute();
    void setSsqlTauUnmute(float ssql_tau_unmute);

    float getAmsqMaxTail();
    void setAmsqMaxTail(float amsq_max_tail);

    qint32 getEqualizer();
    void setEqualizer(qint32 equalizer);

    QList<float>* getEqF();
    void setEqF(QList<float>* eq_f);

    QList<float>* getEqG();
    void setEqG(QList<float>* eq_g);

    qint32 getRit();
    void setRit(qint32 rit);

    float getRitFrequency();
    void setRitFrequency(float rit_frequency);

    qint32 getSpanLog2();
    void setSpanLog2(qint32 span_log2);

    float getRfBandwidth();
    void setRfBandwidth(float rf_bandwidth);

    float getLowCutoff();
    void setLowCutoff(float low_cutoff);

    qint32 getFftWindow();
    void setFftWindow(qint32 fft_window);

    qint32 getRgbColor();
    void setRgbColor(qint32 rgb_color);

    QString* getTitle();
    void setTitle(QString* title);

    QString* getAudioDeviceName();
    void setAudioDeviceName(QString* audio_device_name);

    qint32 getStreamIndex();
    void setStreamIndex(qint32 stream_index);

    qint32 getUseReverseApi();
    void setUseReverseApi(qint32 use_reverse_api);

    QString* getReverseApiAddress();
    void setReverseApiAddress(QString* reverse_api_address);

    qint32 getReverseApiPort();
    void setReverseApiPort(qint32 reverse_api_port);

    qint32 getReverseApiDeviceIndex();
    void setReverseApiDeviceIndex(qint32 reverse_api_device_index);

    qint32 getReverseApiChannelIndex();
    void setReverseApiChannelIndex(qint32 reverse_api_channel_index);

    SWGGLSpectrum* getSpectrumConfig();
    void setSpectrumConfig(SWGGLSpectrum* spectrum_config);

    SWGChannelMarker* getChannelMarker();
    void setChannelMarker(SWGChannelMarker* channel_marker);

    SWGRollupState* getRollupState();
    void setRollupState(SWGRollupState* rollup_state);


    virtual bool isSet() override;

private:
    qint64 input_frequency_offset;
    bool m_input_frequency_offset_isSet;

    qint32 profile_index;
    bool m_profile_index_isSet;

    qint32 demod;
    bool m_demod_isSet;

    float volume;
    bool m_volume_isSet;

    qint32 audio_binaural;
    bool m_audio_binaural_isSet;

    qint32 audio_flip_channels;
    bool m_audio_flip_channels_isSet;

    qint32 dsb;
    bool m_dsb_isSet;

    qint32 audio_mute;
    bool m_audio_mute_isSet;

    qint32 agc;
    bool m_agc_isSet;

    qint32 agc_mode;
    bool m_agc_mode_isSet;

    qint32 agc_gain;
    bool m_agc_gain_isSet;

    qint32 agc_slope;
    bool m_agc_slope_isSet;

    qint32 agc_hang_threshold;
    bool m_agc_hang_threshold_isSet;

    qint32 dnb;
    bool m_dnb_isSet;

    qint32 nb_scheme;
    bool m_nb_scheme_isSet;

    qint32 nb2_mode;
    bool m_nb2_mode_isSet;

    float nb_slew_time;
    bool m_nb_slew_time_isSet;

    float nb_lead_time;
    bool m_nb_lead_time_isSet;

    float nb_lag_time;
    bool m_nb_lag_time_isSet;

    qint32 nb_threshold;
    bool m_nb_threshold_isSet;

    float nb_avg_time;
    bool m_nb_avg_time_isSet;

    qint32 dnr;
    bool m_dnr_isSet;

    qint32 anf;
    bool m_anf_isSet;

    qint32 nr_scheme;
    bool m_nr_scheme_isSet;

    qint32 nr2_gain;
    bool m_nr2_gain_isSet;

    qint32 nr2_npe;
    bool m_nr2_npe_isSet;

    qint32 nr_position;
    bool m_nr_position_isSet;

    qint32 nr2_artifact_reduction;
    bool m_nr2_artifact_reduction_isSet;

    qint32 am_fade_level;
    bool m_am_fade_level_isSet;

    qint32 cw_peaking;
    bool m_cw_peaking_isSet;

    float cw_peak_frequency;
    bool m_cw_peak_frequency_isSet;

    float cw_bandwidth;
    bool m_cw_bandwidth_isSet;

    float cw_gain;
    bool m_cw_gain_isSet;

    float fm_deviation;
    bool m_fm_deviation_isSet;

    float fm_af_low;
    bool m_fm_af_low_isSet;

    float fm_af_high;
    bool m_fm_af_high_isSet;

    qint32 fm_af_limiter;
    bool m_fm_af_limiter_isSet;

    float fm_af_limiter_gain;
    bool m_fm_af_limiter_gain_isSet;

    qint32 fm_ctcss_notch;
    bool m_fm_ctcss_notch_isSet;

    float fm_ctcss_notch_frequency;
    bool m_fm_ctcss_notch_frequency_isSet;

    qint32 squelch;
    bool m_squelch_isSet;

    qint32 squelch_threshold;
    bool m_squelch_threshold_isSet;

    qint32 squelch_mode;
    bool m_squelch_mode_isSet;

    float ssql_tau_mute;
    bool m_ssql_tau_mute_isSet;

    float ssql_tau_unmute;
    bool m_ssql_tau_unmute_isSet;

    float amsq_max_tail;
    bool m_amsq_max_tail_isSet;

    qint32 equalizer;
    bool m_equalizer_isSet;

    QList<float>* eq_f;
    bool m_eq_f_isSet;

    QList<float>* eq_g;
    bool m_eq_g_isSet;

    qint32 rit;
    bool m_rit_isSet;

    float rit_frequency;
    bool m_rit_frequency_isSet;

    qint32 span_log2;
    bool m_span_log2_isSet;

    float rf_bandwidth;
    bool m_rf_bandwidth_isSet;

    float low_cutoff;
    bool m_low_cutoff_isSet;

    qint32 fft_window;
    bool m_fft_window_isSet;

    qint32 rgb_color;
    bool m_rgb_color_isSet;

    QString* title;
    bool m_title_isSet;

    QString* audio_device_name;
    bool m_audio_device_name_isSet;

    qint32 stream_index;
    bool m_stream_index_isSet;

    qint32 use_reverse_api;
    bool m_use_reverse_api_isSet;

    QString* reverse_api_address;
    bool m_reverse_api_address_isSet;

    qint32 reverse_api_port;
    bool m_reverse_api_port_isSet;

    qint32 reverse_api_device_index;
    bool m_reverse_api_device_index_isSet;

    qint32 reverse_api_channel_index;
    bool m_reverse_api_channel_index_isSet;

    SWGGLSpectrum* spectrum_config;
    bool m_spectrum_config_isSet;

    SWGChannelMarker* channel_marker;
    bool m_channel_marker_isSet;

    SWGRollupState* rollup_state;
    bool m_rollup_state_isSet;

};

}

#endif /* SWGWDSPRxSettings_H_ */
