/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 7.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


#include "SWGVORDemodReport.h"

#include "SWGHelpers.h"

#include <QJsonDocument>
#include <QJsonArray>
#include <QObject>
#include <QDebug>

namespace SWGSDRangel {

SWGVORDemodReport::SWGVORDemodReport(QString* json) {
    init();
    this->fromJson(*json);
}

SWGVORDemodReport::SWGVORDemodReport() {
    channel_power_db = 0.0f;
    m_channel_power_db_isSet = false;
    squelch = 0;
    m_squelch_isSet = false;
    audio_sample_rate = 0;
    m_audio_sample_rate_isSet = false;
    volume = 0.0f;
    m_volume_isSet = false;
    nav_id = 0;
    m_nav_id_isSet = false;
    radial = 0.0f;
    m_radial_isSet = false;
    ref_mag = 0.0f;
    m_ref_mag_isSet = false;
    var_mag = 0.0f;
    m_var_mag_isSet = false;
    valid_radial = 0;
    m_valid_radial_isSet = false;
    valid_ref_mag = 0;
    m_valid_ref_mag_isSet = false;
    valid_var_mag = 0;
    m_valid_var_mag_isSet = false;
    morse_ident = nullptr;
    m_morse_ident_isSet = false;
}

SWGVORDemodReport::~SWGVORDemodReport() {
    this->cleanup();
}

void
SWGVORDemodReport::init() {
    channel_power_db = 0.0f;
    m_channel_power_db_isSet = false;
    squelch = 0;
    m_squelch_isSet = false;
    audio_sample_rate = 0;
    m_audio_sample_rate_isSet = false;
    volume = 0.0f;
    m_volume_isSet = false;
    nav_id = 0;
    m_nav_id_isSet = false;
    radial = 0.0f;
    m_radial_isSet = false;
    ref_mag = 0.0f;
    m_ref_mag_isSet = false;
    var_mag = 0.0f;
    m_var_mag_isSet = false;
    valid_radial = 0;
    m_valid_radial_isSet = false;
    valid_ref_mag = 0;
    m_valid_ref_mag_isSet = false;
    valid_var_mag = 0;
    m_valid_var_mag_isSet = false;
    morse_ident = new QString("");
    m_morse_ident_isSet = false;
}

void
SWGVORDemodReport::cleanup() {











    if(morse_ident != nullptr) { 
        delete morse_ident;
    }
}

SWGVORDemodReport*
SWGVORDemodReport::fromJson(QString &json) {
    QByteArray array (json.toStdString().c_str());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
    return this;
}

void
SWGVORDemodReport::fromJsonObject(QJsonObject &pJson) {
    ::SWGSDRangel::setValue(&channel_power_db, pJson["channelPowerDB"], "float", "");
    
    ::SWGSDRangel::setValue(&squelch, pJson["squelch"], "qint32", "");
    
    ::SWGSDRangel::setValue(&audio_sample_rate, pJson["audioSampleRate"], "qint32", "");
    
    ::SWGSDRangel::setValue(&volume, pJson["volume"], "float", "");
    
    ::SWGSDRangel::setValue(&nav_id, pJson["navId"], "qint32", "");
    
    ::SWGSDRangel::setValue(&radial, pJson["radial"], "float", "");
    
    ::SWGSDRangel::setValue(&ref_mag, pJson["refMag"], "float", "");
    
    ::SWGSDRangel::setValue(&var_mag, pJson["varMag"], "float", "");
    
    ::SWGSDRangel::setValue(&valid_radial, pJson["validRadial"], "qint32", "");
    
    ::SWGSDRangel::setValue(&valid_ref_mag, pJson["validRefMag"], "qint32", "");
    
    ::SWGSDRangel::setValue(&valid_var_mag, pJson["validVarMag"], "qint32", "");
    
    ::SWGSDRangel::setValue(&morse_ident, pJson["morseIdent"], "QString", "QString");
    
}

QString
SWGVORDemodReport::asJson ()
{
    QJsonObject* obj = this->asJsonObject();

    QJsonDocument doc(*obj);
    QByteArray bytes = doc.toJson();
    delete obj;
    return QString(bytes);
}

QJsonObject*
SWGVORDemodReport::asJsonObject() {
    QJsonObject* obj = new QJsonObject();
    if(m_channel_power_db_isSet){
        obj->insert("channelPowerDB", QJsonValue(channel_power_db));
    }
    if(m_squelch_isSet){
        obj->insert("squelch", QJsonValue(squelch));
    }
    if(m_audio_sample_rate_isSet){
        obj->insert("audioSampleRate", QJsonValue(audio_sample_rate));
    }
    if(m_volume_isSet){
        obj->insert("volume", QJsonValue(volume));
    }
    if(m_nav_id_isSet){
        obj->insert("navId", QJsonValue(nav_id));
    }
    if(m_radial_isSet){
        obj->insert("radial", QJsonValue(radial));
    }
    if(m_ref_mag_isSet){
        obj->insert("refMag", QJsonValue(ref_mag));
    }
    if(m_var_mag_isSet){
        obj->insert("varMag", QJsonValue(var_mag));
    }
    if(m_valid_radial_isSet){
        obj->insert("validRadial", QJsonValue(valid_radial));
    }
    if(m_valid_ref_mag_isSet){
        obj->insert("validRefMag", QJsonValue(valid_ref_mag));
    }
    if(m_valid_var_mag_isSet){
        obj->insert("validVarMag", QJsonValue(valid_var_mag));
    }
    if(morse_ident != nullptr && *morse_ident != QString("")){
        toJsonValue(QString("morseIdent"), morse_ident, obj, QString("QString"));
    }

    return obj;
}

float
SWGVORDemodReport::getChannelPowerDb() {
    return channel_power_db;
}
void
SWGVORDemodReport::setChannelPowerDb(float channel_power_db) {
    this->channel_power_db = channel_power_db;
    this->m_channel_power_db_isSet = true;
}

qint32
SWGVORDemodReport::getSquelch() {
    return squelch;
}
void
SWGVORDemodReport::setSquelch(qint32 squelch) {
    this->squelch = squelch;
    this->m_squelch_isSet = true;
}

qint32
SWGVORDemodReport::getAudioSampleRate() {
    return audio_sample_rate;
}
void
SWGVORDemodReport::setAudioSampleRate(qint32 audio_sample_rate) {
    this->audio_sample_rate = audio_sample_rate;
    this->m_audio_sample_rate_isSet = true;
}

float
SWGVORDemodReport::getVolume() {
    return volume;
}
void
SWGVORDemodReport::setVolume(float volume) {
    this->volume = volume;
    this->m_volume_isSet = true;
}

qint32
SWGVORDemodReport::getNavId() {
    return nav_id;
}
void
SWGVORDemodReport::setNavId(qint32 nav_id) {
    this->nav_id = nav_id;
    this->m_nav_id_isSet = true;
}

float
SWGVORDemodReport::getRadial() {
    return radial;
}
void
SWGVORDemodReport::setRadial(float radial) {
    this->radial = radial;
    this->m_radial_isSet = true;
}

float
SWGVORDemodReport::getRefMag() {
    return ref_mag;
}
void
SWGVORDemodReport::setRefMag(float ref_mag) {
    this->ref_mag = ref_mag;
    this->m_ref_mag_isSet = true;
}

float
SWGVORDemodReport::getVarMag() {
    return var_mag;
}
void
SWGVORDemodReport::setVarMag(float var_mag) {
    this->var_mag = var_mag;
    this->m_var_mag_isSet = true;
}

qint32
SWGVORDemodReport::getValidRadial() {
    return valid_radial;
}
void
SWGVORDemodReport::setValidRadial(qint32 valid_radial) {
    this->valid_radial = valid_radial;
    this->m_valid_radial_isSet = true;
}

qint32
SWGVORDemodReport::getValidRefMag() {
    return valid_ref_mag;
}
void
SWGVORDemodReport::setValidRefMag(qint32 valid_ref_mag) {
    this->valid_ref_mag = valid_ref_mag;
    this->m_valid_ref_mag_isSet = true;
}

qint32
SWGVORDemodReport::getValidVarMag() {
    return valid_var_mag;
}
void
SWGVORDemodReport::setValidVarMag(qint32 valid_var_mag) {
    this->valid_var_mag = valid_var_mag;
    this->m_valid_var_mag_isSet = true;
}

QString*
SWGVORDemodReport::getMorseIdent() {
    return morse_ident;
}
void
SWGVORDemodReport::setMorseIdent(QString* morse_ident) {
    this->morse_ident = morse_ident;
    this->m_morse_ident_isSet = true;
}


bool
SWGVORDemodReport::isSet(){
    bool isObjectUpdated = false;
    do{
        if(m_channel_power_db_isSet){
            isObjectUpdated = true; break;
        }
        if(m_squelch_isSet){
            isObjectUpdated = true; break;
        }
        if(m_audio_sample_rate_isSet){
            isObjectUpdated = true; break;
        }
        if(m_volume_isSet){
            isObjectUpdated = true; break;
        }
        if(m_nav_id_isSet){
            isObjectUpdated = true; break;
        }
        if(m_radial_isSet){
            isObjectUpdated = true; break;
        }
        if(m_ref_mag_isSet){
            isObjectUpdated = true; break;
        }
        if(m_var_mag_isSet){
            isObjectUpdated = true; break;
        }
        if(m_valid_radial_isSet){
            isObjectUpdated = true; break;
        }
        if(m_valid_ref_mag_isSet){
            isObjectUpdated = true; break;
        }
        if(m_valid_var_mag_isSet){
            isObjectUpdated = true; break;
        }
        if(morse_ident && *morse_ident != QString("")){
            isObjectUpdated = true; break;
        }
    }while(false);
    return isObjectUpdated;
}
}

