/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 7.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


#include "SWGTestMiStreamSettings.h"

#include "SWGHelpers.h"

#include <QJsonDocument>
#include <QJsonArray>
#include <QObject>
#include <QDebug>

namespace SWGSDRangel {

SWGTestMiStreamSettings::SWGTestMiStreamSettings(QString* json) {
    init();
    this->fromJson(*json);
}

SWGTestMiStreamSettings::SWGTestMiStreamSettings() {
    stream_index = 0;
    m_stream_index_isSet = false;
    center_frequency = 0L;
    m_center_frequency_isSet = false;
    frequency_shift = 0;
    m_frequency_shift_isSet = false;
    sample_rate = 0;
    m_sample_rate_isSet = false;
    log2_decim = 0;
    m_log2_decim_isSet = false;
    fc_pos = 0;
    m_fc_pos_isSet = false;
    sample_size_index = 0;
    m_sample_size_index_isSet = false;
    amplitude_bits = 0;
    m_amplitude_bits_isSet = false;
    auto_corr_options = 0;
    m_auto_corr_options_isSet = false;
    modulation = 0;
    m_modulation_isSet = false;
    modulation_tone = 0;
    m_modulation_tone_isSet = false;
    am_modulation = 0;
    m_am_modulation_isSet = false;
    fm_deviation = 0;
    m_fm_deviation_isSet = false;
    dc_factor = 0.0f;
    m_dc_factor_isSet = false;
    i_factor = 0.0f;
    m_i_factor_isSet = false;
    q_factor = 0.0f;
    m_q_factor_isSet = false;
    phase_imbalance = 0.0f;
    m_phase_imbalance_isSet = false;
}

SWGTestMiStreamSettings::~SWGTestMiStreamSettings() {
    this->cleanup();
}

void
SWGTestMiStreamSettings::init() {
    stream_index = 0;
    m_stream_index_isSet = false;
    center_frequency = 0L;
    m_center_frequency_isSet = false;
    frequency_shift = 0;
    m_frequency_shift_isSet = false;
    sample_rate = 0;
    m_sample_rate_isSet = false;
    log2_decim = 0;
    m_log2_decim_isSet = false;
    fc_pos = 0;
    m_fc_pos_isSet = false;
    sample_size_index = 0;
    m_sample_size_index_isSet = false;
    amplitude_bits = 0;
    m_amplitude_bits_isSet = false;
    auto_corr_options = 0;
    m_auto_corr_options_isSet = false;
    modulation = 0;
    m_modulation_isSet = false;
    modulation_tone = 0;
    m_modulation_tone_isSet = false;
    am_modulation = 0;
    m_am_modulation_isSet = false;
    fm_deviation = 0;
    m_fm_deviation_isSet = false;
    dc_factor = 0.0f;
    m_dc_factor_isSet = false;
    i_factor = 0.0f;
    m_i_factor_isSet = false;
    q_factor = 0.0f;
    m_q_factor_isSet = false;
    phase_imbalance = 0.0f;
    m_phase_imbalance_isSet = false;
}

void
SWGTestMiStreamSettings::cleanup() {

















}

SWGTestMiStreamSettings*
SWGTestMiStreamSettings::fromJson(QString &json) {
    QByteArray array (json.toStdString().c_str());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
    return this;
}

void
SWGTestMiStreamSettings::fromJsonObject(QJsonObject &pJson) {
    ::SWGSDRangel::setValue(&stream_index, pJson["streamIndex"], "qint32", "");
    
    ::SWGSDRangel::setValue(&center_frequency, pJson["centerFrequency"], "qint64", "");
    
    ::SWGSDRangel::setValue(&frequency_shift, pJson["frequencyShift"], "qint32", "");
    
    ::SWGSDRangel::setValue(&sample_rate, pJson["sampleRate"], "qint32", "");
    
    ::SWGSDRangel::setValue(&log2_decim, pJson["log2Decim"], "qint32", "");
    
    ::SWGSDRangel::setValue(&fc_pos, pJson["fcPos"], "qint32", "");
    
    ::SWGSDRangel::setValue(&sample_size_index, pJson["sampleSizeIndex"], "qint32", "");
    
    ::SWGSDRangel::setValue(&amplitude_bits, pJson["amplitudeBits"], "qint32", "");
    
    ::SWGSDRangel::setValue(&auto_corr_options, pJson["autoCorrOptions"], "qint32", "");
    
    ::SWGSDRangel::setValue(&modulation, pJson["modulation"], "qint32", "");
    
    ::SWGSDRangel::setValue(&modulation_tone, pJson["modulationTone"], "qint32", "");
    
    ::SWGSDRangel::setValue(&am_modulation, pJson["amModulation"], "qint32", "");
    
    ::SWGSDRangel::setValue(&fm_deviation, pJson["fmDeviation"], "qint32", "");
    
    ::SWGSDRangel::setValue(&dc_factor, pJson["dcFactor"], "float", "");
    
    ::SWGSDRangel::setValue(&i_factor, pJson["iFactor"], "float", "");
    
    ::SWGSDRangel::setValue(&q_factor, pJson["qFactor"], "float", "");
    
    ::SWGSDRangel::setValue(&phase_imbalance, pJson["phaseImbalance"], "float", "");
    
}

QString
SWGTestMiStreamSettings::asJson ()
{
    QJsonObject* obj = this->asJsonObject();

    QJsonDocument doc(*obj);
    QByteArray bytes = doc.toJson();
    delete obj;
    return QString(bytes);
}

QJsonObject*
SWGTestMiStreamSettings::asJsonObject() {
    QJsonObject* obj = new QJsonObject();
    if(m_stream_index_isSet){
        obj->insert("streamIndex", QJsonValue(stream_index));
    }
    if(m_center_frequency_isSet){
        obj->insert("centerFrequency", QJsonValue(center_frequency));
    }
    if(m_frequency_shift_isSet){
        obj->insert("frequencyShift", QJsonValue(frequency_shift));
    }
    if(m_sample_rate_isSet){
        obj->insert("sampleRate", QJsonValue(sample_rate));
    }
    if(m_log2_decim_isSet){
        obj->insert("log2Decim", QJsonValue(log2_decim));
    }
    if(m_fc_pos_isSet){
        obj->insert("fcPos", QJsonValue(fc_pos));
    }
    if(m_sample_size_index_isSet){
        obj->insert("sampleSizeIndex", QJsonValue(sample_size_index));
    }
    if(m_amplitude_bits_isSet){
        obj->insert("amplitudeBits", QJsonValue(amplitude_bits));
    }
    if(m_auto_corr_options_isSet){
        obj->insert("autoCorrOptions", QJsonValue(auto_corr_options));
    }
    if(m_modulation_isSet){
        obj->insert("modulation", QJsonValue(modulation));
    }
    if(m_modulation_tone_isSet){
        obj->insert("modulationTone", QJsonValue(modulation_tone));
    }
    if(m_am_modulation_isSet){
        obj->insert("amModulation", QJsonValue(am_modulation));
    }
    if(m_fm_deviation_isSet){
        obj->insert("fmDeviation", QJsonValue(fm_deviation));
    }
    if(m_dc_factor_isSet){
        obj->insert("dcFactor", QJsonValue(dc_factor));
    }
    if(m_i_factor_isSet){
        obj->insert("iFactor", QJsonValue(i_factor));
    }
    if(m_q_factor_isSet){
        obj->insert("qFactor", QJsonValue(q_factor));
    }
    if(m_phase_imbalance_isSet){
        obj->insert("phaseImbalance", QJsonValue(phase_imbalance));
    }

    return obj;
}

qint32
SWGTestMiStreamSettings::getStreamIndex() {
    return stream_index;
}
void
SWGTestMiStreamSettings::setStreamIndex(qint32 stream_index) {
    this->stream_index = stream_index;
    this->m_stream_index_isSet = true;
}

qint64
SWGTestMiStreamSettings::getCenterFrequency() {
    return center_frequency;
}
void
SWGTestMiStreamSettings::setCenterFrequency(qint64 center_frequency) {
    this->center_frequency = center_frequency;
    this->m_center_frequency_isSet = true;
}

qint32
SWGTestMiStreamSettings::getFrequencyShift() {
    return frequency_shift;
}
void
SWGTestMiStreamSettings::setFrequencyShift(qint32 frequency_shift) {
    this->frequency_shift = frequency_shift;
    this->m_frequency_shift_isSet = true;
}

qint32
SWGTestMiStreamSettings::getSampleRate() {
    return sample_rate;
}
void
SWGTestMiStreamSettings::setSampleRate(qint32 sample_rate) {
    this->sample_rate = sample_rate;
    this->m_sample_rate_isSet = true;
}

qint32
SWGTestMiStreamSettings::getLog2Decim() {
    return log2_decim;
}
void
SWGTestMiStreamSettings::setLog2Decim(qint32 log2_decim) {
    this->log2_decim = log2_decim;
    this->m_log2_decim_isSet = true;
}

qint32
SWGTestMiStreamSettings::getFcPos() {
    return fc_pos;
}
void
SWGTestMiStreamSettings::setFcPos(qint32 fc_pos) {
    this->fc_pos = fc_pos;
    this->m_fc_pos_isSet = true;
}

qint32
SWGTestMiStreamSettings::getSampleSizeIndex() {
    return sample_size_index;
}
void
SWGTestMiStreamSettings::setSampleSizeIndex(qint32 sample_size_index) {
    this->sample_size_index = sample_size_index;
    this->m_sample_size_index_isSet = true;
}

qint32
SWGTestMiStreamSettings::getAmplitudeBits() {
    return amplitude_bits;
}
void
SWGTestMiStreamSettings::setAmplitudeBits(qint32 amplitude_bits) {
    this->amplitude_bits = amplitude_bits;
    this->m_amplitude_bits_isSet = true;
}

qint32
SWGTestMiStreamSettings::getAutoCorrOptions() {
    return auto_corr_options;
}
void
SWGTestMiStreamSettings::setAutoCorrOptions(qint32 auto_corr_options) {
    this->auto_corr_options = auto_corr_options;
    this->m_auto_corr_options_isSet = true;
}

qint32
SWGTestMiStreamSettings::getModulation() {
    return modulation;
}
void
SWGTestMiStreamSettings::setModulation(qint32 modulation) {
    this->modulation = modulation;
    this->m_modulation_isSet = true;
}

qint32
SWGTestMiStreamSettings::getModulationTone() {
    return modulation_tone;
}
void
SWGTestMiStreamSettings::setModulationTone(qint32 modulation_tone) {
    this->modulation_tone = modulation_tone;
    this->m_modulation_tone_isSet = true;
}

qint32
SWGTestMiStreamSettings::getAmModulation() {
    return am_modulation;
}
void
SWGTestMiStreamSettings::setAmModulation(qint32 am_modulation) {
    this->am_modulation = am_modulation;
    this->m_am_modulation_isSet = true;
}

qint32
SWGTestMiStreamSettings::getFmDeviation() {
    return fm_deviation;
}
void
SWGTestMiStreamSettings::setFmDeviation(qint32 fm_deviation) {
    this->fm_deviation = fm_deviation;
    this->m_fm_deviation_isSet = true;
}

float
SWGTestMiStreamSettings::getDcFactor() {
    return dc_factor;
}
void
SWGTestMiStreamSettings::setDcFactor(float dc_factor) {
    this->dc_factor = dc_factor;
    this->m_dc_factor_isSet = true;
}

float
SWGTestMiStreamSettings::getIFactor() {
    return i_factor;
}
void
SWGTestMiStreamSettings::setIFactor(float i_factor) {
    this->i_factor = i_factor;
    this->m_i_factor_isSet = true;
}

float
SWGTestMiStreamSettings::getQFactor() {
    return q_factor;
}
void
SWGTestMiStreamSettings::setQFactor(float q_factor) {
    this->q_factor = q_factor;
    this->m_q_factor_isSet = true;
}

float
SWGTestMiStreamSettings::getPhaseImbalance() {
    return phase_imbalance;
}
void
SWGTestMiStreamSettings::setPhaseImbalance(float phase_imbalance) {
    this->phase_imbalance = phase_imbalance;
    this->m_phase_imbalance_isSet = true;
}


bool
SWGTestMiStreamSettings::isSet(){
    bool isObjectUpdated = false;
    do{
        if(m_stream_index_isSet){
            isObjectUpdated = true; break;
        }
        if(m_center_frequency_isSet){
            isObjectUpdated = true; break;
        }
        if(m_frequency_shift_isSet){
            isObjectUpdated = true; break;
        }
        if(m_sample_rate_isSet){
            isObjectUpdated = true; break;
        }
        if(m_log2_decim_isSet){
            isObjectUpdated = true; break;
        }
        if(m_fc_pos_isSet){
            isObjectUpdated = true; break;
        }
        if(m_sample_size_index_isSet){
            isObjectUpdated = true; break;
        }
        if(m_amplitude_bits_isSet){
            isObjectUpdated = true; break;
        }
        if(m_auto_corr_options_isSet){
            isObjectUpdated = true; break;
        }
        if(m_modulation_isSet){
            isObjectUpdated = true; break;
        }
        if(m_modulation_tone_isSet){
            isObjectUpdated = true; break;
        }
        if(m_am_modulation_isSet){
            isObjectUpdated = true; break;
        }
        if(m_fm_deviation_isSet){
            isObjectUpdated = true; break;
        }
        if(m_dc_factor_isSet){
            isObjectUpdated = true; break;
        }
        if(m_i_factor_isSet){
            isObjectUpdated = true; break;
        }
        if(m_q_factor_isSet){
            isObjectUpdated = true; break;
        }
        if(m_phase_imbalance_isSet){
            isObjectUpdated = true; break;
        }
    }while(false);
    return isObjectUpdated;
}
}

