/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 7.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


#include "SWGSkyMapSettings.h"

#include "SWGHelpers.h"

#include <QJsonDocument>
#include <QJsonArray>
#include <QObject>
#include <QDebug>

namespace SWGSDRangel {

SWGSkyMapSettings::SWGSkyMapSettings(QString* json) {
    init();
    this->fromJson(*json);
}

SWGSkyMapSettings::SWGSkyMapSettings() {
    display_names = 0;
    m_display_names_isSet = false;
    display_constellations = 0;
    m_display_constellations_isSet = false;
    display_reticle = 0;
    m_display_reticle_isSet = false;
    display_grid = 0;
    m_display_grid_isSet = false;
    display_antenna_fo_v = 0;
    m_display_antenna_fo_v_isSet = false;
    map = nullptr;
    m_map_isSet = false;
    background = nullptr;
    m_background_isSet = false;
    projection = nullptr;
    m_projection_isSet = false;
    source = nullptr;
    m_source_isSet = false;
    track = 0;
    m_track_isSet = false;
    latitude = 0.0f;
    m_latitude_isSet = false;
    longitude = 0.0f;
    m_longitude_isSet = false;
    altitude = 0.0f;
    m_altitude_isSet = false;
    hpbw = 0.0f;
    m_hpbw_isSet = false;
    use_my_position = 0.0f;
    m_use_my_position_isSet = false;
    title = nullptr;
    m_title_isSet = false;
    rgb_color = 0;
    m_rgb_color_isSet = false;
    use_reverse_api = 0;
    m_use_reverse_api_isSet = false;
    reverse_api_address = nullptr;
    m_reverse_api_address_isSet = false;
    reverse_api_port = 0;
    m_reverse_api_port_isSet = false;
    reverse_api_feature_set_index = 0;
    m_reverse_api_feature_set_index_isSet = false;
    reverse_api_feature_index = 0;
    m_reverse_api_feature_index_isSet = false;
    rollup_state = nullptr;
    m_rollup_state_isSet = false;
}

SWGSkyMapSettings::~SWGSkyMapSettings() {
    this->cleanup();
}

void
SWGSkyMapSettings::init() {
    display_names = 0;
    m_display_names_isSet = false;
    display_constellations = 0;
    m_display_constellations_isSet = false;
    display_reticle = 0;
    m_display_reticle_isSet = false;
    display_grid = 0;
    m_display_grid_isSet = false;
    display_antenna_fo_v = 0;
    m_display_antenna_fo_v_isSet = false;
    map = new QString("");
    m_map_isSet = false;
    background = new QString("");
    m_background_isSet = false;
    projection = new QString("");
    m_projection_isSet = false;
    source = new QString("");
    m_source_isSet = false;
    track = 0;
    m_track_isSet = false;
    latitude = 0.0f;
    m_latitude_isSet = false;
    longitude = 0.0f;
    m_longitude_isSet = false;
    altitude = 0.0f;
    m_altitude_isSet = false;
    hpbw = 0.0f;
    m_hpbw_isSet = false;
    use_my_position = 0.0f;
    m_use_my_position_isSet = false;
    title = new QString("");
    m_title_isSet = false;
    rgb_color = 0;
    m_rgb_color_isSet = false;
    use_reverse_api = 0;
    m_use_reverse_api_isSet = false;
    reverse_api_address = new QString("");
    m_reverse_api_address_isSet = false;
    reverse_api_port = 0;
    m_reverse_api_port_isSet = false;
    reverse_api_feature_set_index = 0;
    m_reverse_api_feature_set_index_isSet = false;
    reverse_api_feature_index = 0;
    m_reverse_api_feature_index_isSet = false;
    rollup_state = new SWGRollupState();
    m_rollup_state_isSet = false;
}

void
SWGSkyMapSettings::cleanup() {





    if(map != nullptr) { 
        delete map;
    }
    if(background != nullptr) { 
        delete background;
    }
    if(projection != nullptr) { 
        delete projection;
    }
    if(source != nullptr) { 
        delete source;
    }






    if(title != nullptr) { 
        delete title;
    }


    if(reverse_api_address != nullptr) { 
        delete reverse_api_address;
    }



    if(rollup_state != nullptr) { 
        delete rollup_state;
    }
}

SWGSkyMapSettings*
SWGSkyMapSettings::fromJson(QString &json) {
    QByteArray array (json.toStdString().c_str());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
    return this;
}

void
SWGSkyMapSettings::fromJsonObject(QJsonObject &pJson) {
    ::SWGSDRangel::setValue(&display_names, pJson["displayNames"], "qint32", "");
    
    ::SWGSDRangel::setValue(&display_constellations, pJson["displayConstellations"], "qint32", "");
    
    ::SWGSDRangel::setValue(&display_reticle, pJson["displayReticle"], "qint32", "");
    
    ::SWGSDRangel::setValue(&display_grid, pJson["displayGrid"], "qint32", "");
    
    ::SWGSDRangel::setValue(&display_antenna_fo_v, pJson["displayAntennaFoV"], "qint32", "");
    
    ::SWGSDRangel::setValue(&map, pJson["map"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&background, pJson["background"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&projection, pJson["projection"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&source, pJson["source"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&track, pJson["track"], "qint32", "");
    
    ::SWGSDRangel::setValue(&latitude, pJson["latitude"], "float", "");
    
    ::SWGSDRangel::setValue(&longitude, pJson["longitude"], "float", "");
    
    ::SWGSDRangel::setValue(&altitude, pJson["altitude"], "float", "");
    
    ::SWGSDRangel::setValue(&hpbw, pJson["hpbw"], "float", "");
    
    ::SWGSDRangel::setValue(&use_my_position, pJson["useMyPosition"], "float", "");
    
    ::SWGSDRangel::setValue(&title, pJson["title"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&rgb_color, pJson["rgbColor"], "qint32", "");
    
    ::SWGSDRangel::setValue(&use_reverse_api, pJson["useReverseAPI"], "qint32", "");
    
    ::SWGSDRangel::setValue(&reverse_api_address, pJson["reverseAPIAddress"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&reverse_api_port, pJson["reverseAPIPort"], "qint32", "");
    
    ::SWGSDRangel::setValue(&reverse_api_feature_set_index, pJson["reverseAPIFeatureSetIndex"], "qint32", "");
    
    ::SWGSDRangel::setValue(&reverse_api_feature_index, pJson["reverseAPIFeatureIndex"], "qint32", "");
    
    ::SWGSDRangel::setValue(&rollup_state, pJson["rollupState"], "SWGRollupState", "SWGRollupState");
    
}

QString
SWGSkyMapSettings::asJson ()
{
    QJsonObject* obj = this->asJsonObject();

    QJsonDocument doc(*obj);
    QByteArray bytes = doc.toJson();
    delete obj;
    return QString(bytes);
}

QJsonObject*
SWGSkyMapSettings::asJsonObject() {
    QJsonObject* obj = new QJsonObject();
    if(m_display_names_isSet){
        obj->insert("displayNames", QJsonValue(display_names));
    }
    if(m_display_constellations_isSet){
        obj->insert("displayConstellations", QJsonValue(display_constellations));
    }
    if(m_display_reticle_isSet){
        obj->insert("displayReticle", QJsonValue(display_reticle));
    }
    if(m_display_grid_isSet){
        obj->insert("displayGrid", QJsonValue(display_grid));
    }
    if(m_display_antenna_fo_v_isSet){
        obj->insert("displayAntennaFoV", QJsonValue(display_antenna_fo_v));
    }
    if(map != nullptr && *map != QString("")){
        toJsonValue(QString("map"), map, obj, QString("QString"));
    }
    if(background != nullptr && *background != QString("")){
        toJsonValue(QString("background"), background, obj, QString("QString"));
    }
    if(projection != nullptr && *projection != QString("")){
        toJsonValue(QString("projection"), projection, obj, QString("QString"));
    }
    if(source != nullptr && *source != QString("")){
        toJsonValue(QString("source"), source, obj, QString("QString"));
    }
    if(m_track_isSet){
        obj->insert("track", QJsonValue(track));
    }
    if(m_latitude_isSet){
        obj->insert("latitude", QJsonValue(latitude));
    }
    if(m_longitude_isSet){
        obj->insert("longitude", QJsonValue(longitude));
    }
    if(m_altitude_isSet){
        obj->insert("altitude", QJsonValue(altitude));
    }
    if(m_hpbw_isSet){
        obj->insert("hpbw", QJsonValue(hpbw));
    }
    if(m_use_my_position_isSet){
        obj->insert("useMyPosition", QJsonValue(use_my_position));
    }
    if(title != nullptr && *title != QString("")){
        toJsonValue(QString("title"), title, obj, QString("QString"));
    }
    if(m_rgb_color_isSet){
        obj->insert("rgbColor", QJsonValue(rgb_color));
    }
    if(m_use_reverse_api_isSet){
        obj->insert("useReverseAPI", QJsonValue(use_reverse_api));
    }
    if(reverse_api_address != nullptr && *reverse_api_address != QString("")){
        toJsonValue(QString("reverseAPIAddress"), reverse_api_address, obj, QString("QString"));
    }
    if(m_reverse_api_port_isSet){
        obj->insert("reverseAPIPort", QJsonValue(reverse_api_port));
    }
    if(m_reverse_api_feature_set_index_isSet){
        obj->insert("reverseAPIFeatureSetIndex", QJsonValue(reverse_api_feature_set_index));
    }
    if(m_reverse_api_feature_index_isSet){
        obj->insert("reverseAPIFeatureIndex", QJsonValue(reverse_api_feature_index));
    }
    if((rollup_state != nullptr) && (rollup_state->isSet())){
        toJsonValue(QString("rollupState"), rollup_state, obj, QString("SWGRollupState"));
    }

    return obj;
}

qint32
SWGSkyMapSettings::getDisplayNames() {
    return display_names;
}
void
SWGSkyMapSettings::setDisplayNames(qint32 display_names) {
    this->display_names = display_names;
    this->m_display_names_isSet = true;
}

qint32
SWGSkyMapSettings::getDisplayConstellations() {
    return display_constellations;
}
void
SWGSkyMapSettings::setDisplayConstellations(qint32 display_constellations) {
    this->display_constellations = display_constellations;
    this->m_display_constellations_isSet = true;
}

qint32
SWGSkyMapSettings::getDisplayReticle() {
    return display_reticle;
}
void
SWGSkyMapSettings::setDisplayReticle(qint32 display_reticle) {
    this->display_reticle = display_reticle;
    this->m_display_reticle_isSet = true;
}

qint32
SWGSkyMapSettings::getDisplayGrid() {
    return display_grid;
}
void
SWGSkyMapSettings::setDisplayGrid(qint32 display_grid) {
    this->display_grid = display_grid;
    this->m_display_grid_isSet = true;
}

qint32
SWGSkyMapSettings::getDisplayAntennaFoV() {
    return display_antenna_fo_v;
}
void
SWGSkyMapSettings::setDisplayAntennaFoV(qint32 display_antenna_fo_v) {
    this->display_antenna_fo_v = display_antenna_fo_v;
    this->m_display_antenna_fo_v_isSet = true;
}

QString*
SWGSkyMapSettings::getMap() {
    return map;
}
void
SWGSkyMapSettings::setMap(QString* map) {
    this->map = map;
    this->m_map_isSet = true;
}

QString*
SWGSkyMapSettings::getBackground() {
    return background;
}
void
SWGSkyMapSettings::setBackground(QString* background) {
    this->background = background;
    this->m_background_isSet = true;
}

QString*
SWGSkyMapSettings::getProjection() {
    return projection;
}
void
SWGSkyMapSettings::setProjection(QString* projection) {
    this->projection = projection;
    this->m_projection_isSet = true;
}

QString*
SWGSkyMapSettings::getSource() {
    return source;
}
void
SWGSkyMapSettings::setSource(QString* source) {
    this->source = source;
    this->m_source_isSet = true;
}

qint32
SWGSkyMapSettings::getTrack() {
    return track;
}
void
SWGSkyMapSettings::setTrack(qint32 track) {
    this->track = track;
    this->m_track_isSet = true;
}

float
SWGSkyMapSettings::getLatitude() {
    return latitude;
}
void
SWGSkyMapSettings::setLatitude(float latitude) {
    this->latitude = latitude;
    this->m_latitude_isSet = true;
}

float
SWGSkyMapSettings::getLongitude() {
    return longitude;
}
void
SWGSkyMapSettings::setLongitude(float longitude) {
    this->longitude = longitude;
    this->m_longitude_isSet = true;
}

float
SWGSkyMapSettings::getAltitude() {
    return altitude;
}
void
SWGSkyMapSettings::setAltitude(float altitude) {
    this->altitude = altitude;
    this->m_altitude_isSet = true;
}

float
SWGSkyMapSettings::getHpbw() {
    return hpbw;
}
void
SWGSkyMapSettings::setHpbw(float hpbw) {
    this->hpbw = hpbw;
    this->m_hpbw_isSet = true;
}

float
SWGSkyMapSettings::getUseMyPosition() {
    return use_my_position;
}
void
SWGSkyMapSettings::setUseMyPosition(float use_my_position) {
    this->use_my_position = use_my_position;
    this->m_use_my_position_isSet = true;
}

QString*
SWGSkyMapSettings::getTitle() {
    return title;
}
void
SWGSkyMapSettings::setTitle(QString* title) {
    this->title = title;
    this->m_title_isSet = true;
}

qint32
SWGSkyMapSettings::getRgbColor() {
    return rgb_color;
}
void
SWGSkyMapSettings::setRgbColor(qint32 rgb_color) {
    this->rgb_color = rgb_color;
    this->m_rgb_color_isSet = true;
}

qint32
SWGSkyMapSettings::getUseReverseApi() {
    return use_reverse_api;
}
void
SWGSkyMapSettings::setUseReverseApi(qint32 use_reverse_api) {
    this->use_reverse_api = use_reverse_api;
    this->m_use_reverse_api_isSet = true;
}

QString*
SWGSkyMapSettings::getReverseApiAddress() {
    return reverse_api_address;
}
void
SWGSkyMapSettings::setReverseApiAddress(QString* reverse_api_address) {
    this->reverse_api_address = reverse_api_address;
    this->m_reverse_api_address_isSet = true;
}

qint32
SWGSkyMapSettings::getReverseApiPort() {
    return reverse_api_port;
}
void
SWGSkyMapSettings::setReverseApiPort(qint32 reverse_api_port) {
    this->reverse_api_port = reverse_api_port;
    this->m_reverse_api_port_isSet = true;
}

qint32
SWGSkyMapSettings::getReverseApiFeatureSetIndex() {
    return reverse_api_feature_set_index;
}
void
SWGSkyMapSettings::setReverseApiFeatureSetIndex(qint32 reverse_api_feature_set_index) {
    this->reverse_api_feature_set_index = reverse_api_feature_set_index;
    this->m_reverse_api_feature_set_index_isSet = true;
}

qint32
SWGSkyMapSettings::getReverseApiFeatureIndex() {
    return reverse_api_feature_index;
}
void
SWGSkyMapSettings::setReverseApiFeatureIndex(qint32 reverse_api_feature_index) {
    this->reverse_api_feature_index = reverse_api_feature_index;
    this->m_reverse_api_feature_index_isSet = true;
}

SWGRollupState*
SWGSkyMapSettings::getRollupState() {
    return rollup_state;
}
void
SWGSkyMapSettings::setRollupState(SWGRollupState* rollup_state) {
    this->rollup_state = rollup_state;
    this->m_rollup_state_isSet = true;
}


bool
SWGSkyMapSettings::isSet(){
    bool isObjectUpdated = false;
    do{
        if(m_display_names_isSet){
            isObjectUpdated = true; break;
        }
        if(m_display_constellations_isSet){
            isObjectUpdated = true; break;
        }
        if(m_display_reticle_isSet){
            isObjectUpdated = true; break;
        }
        if(m_display_grid_isSet){
            isObjectUpdated = true; break;
        }
        if(m_display_antenna_fo_v_isSet){
            isObjectUpdated = true; break;
        }
        if(map && *map != QString("")){
            isObjectUpdated = true; break;
        }
        if(background && *background != QString("")){
            isObjectUpdated = true; break;
        }
        if(projection && *projection != QString("")){
            isObjectUpdated = true; break;
        }
        if(source && *source != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_track_isSet){
            isObjectUpdated = true; break;
        }
        if(m_latitude_isSet){
            isObjectUpdated = true; break;
        }
        if(m_longitude_isSet){
            isObjectUpdated = true; break;
        }
        if(m_altitude_isSet){
            isObjectUpdated = true; break;
        }
        if(m_hpbw_isSet){
            isObjectUpdated = true; break;
        }
        if(m_use_my_position_isSet){
            isObjectUpdated = true; break;
        }
        if(title && *title != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_rgb_color_isSet){
            isObjectUpdated = true; break;
        }
        if(m_use_reverse_api_isSet){
            isObjectUpdated = true; break;
        }
        if(reverse_api_address && *reverse_api_address != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_reverse_api_port_isSet){
            isObjectUpdated = true; break;
        }
        if(m_reverse_api_feature_set_index_isSet){
            isObjectUpdated = true; break;
        }
        if(m_reverse_api_feature_index_isSet){
            isObjectUpdated = true; break;
        }
        if(rollup_state && rollup_state->isSet()){
            isObjectUpdated = true; break;
        }
    }while(false);
    return isObjectUpdated;
}
}

