/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 7.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


#include "SWGSatelliteTrackerReport.h"

#include "SWGHelpers.h"

#include <QJsonDocument>
#include <QJsonArray>
#include <QObject>
#include <QDebug>

namespace SWGSDRangel {

SWGSatelliteTrackerReport::SWGSatelliteTrackerReport(QString* json) {
    init();
    this->fromJson(*json);
}

SWGSatelliteTrackerReport::SWGSatelliteTrackerReport() {
    running_state = 0;
    m_running_state_isSet = false;
    target_azimuth = 0.0f;
    m_target_azimuth_isSet = false;
    target_elevation = 0.0f;
    m_target_elevation_isSet = false;
    satellite_state = nullptr;
    m_satellite_state_isSet = false;
}

SWGSatelliteTrackerReport::~SWGSatelliteTrackerReport() {
    this->cleanup();
}

void
SWGSatelliteTrackerReport::init() {
    running_state = 0;
    m_running_state_isSet = false;
    target_azimuth = 0.0f;
    m_target_azimuth_isSet = false;
    target_elevation = 0.0f;
    m_target_elevation_isSet = false;
    satellite_state = new QList<SWGSatelliteState*>();
    m_satellite_state_isSet = false;
}

void
SWGSatelliteTrackerReport::cleanup() {



    if(satellite_state != nullptr) { 
        auto arr = satellite_state;
        for(auto o: *arr) { 
            delete o;
        }
        delete satellite_state;
    }
}

SWGSatelliteTrackerReport*
SWGSatelliteTrackerReport::fromJson(QString &json) {
    QByteArray array (json.toStdString().c_str());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
    return this;
}

void
SWGSatelliteTrackerReport::fromJsonObject(QJsonObject &pJson) {
    ::SWGSDRangel::setValue(&running_state, pJson["runningState"], "qint32", "");
    
    ::SWGSDRangel::setValue(&target_azimuth, pJson["targetAzimuth"], "float", "");
    
    ::SWGSDRangel::setValue(&target_elevation, pJson["targetElevation"], "float", "");
    
    
    ::SWGSDRangel::setValue(&satellite_state, pJson["satelliteState"], "QList", "SWGSatelliteState");
}

QString
SWGSatelliteTrackerReport::asJson ()
{
    QJsonObject* obj = this->asJsonObject();

    QJsonDocument doc(*obj);
    QByteArray bytes = doc.toJson();
    delete obj;
    return QString(bytes);
}

QJsonObject*
SWGSatelliteTrackerReport::asJsonObject() {
    QJsonObject* obj = new QJsonObject();
    if(m_running_state_isSet){
        obj->insert("runningState", QJsonValue(running_state));
    }
    if(m_target_azimuth_isSet){
        obj->insert("targetAzimuth", QJsonValue(target_azimuth));
    }
    if(m_target_elevation_isSet){
        obj->insert("targetElevation", QJsonValue(target_elevation));
    }
    if(satellite_state && satellite_state->size() > 0){
        toJsonArray((QList<void*>*)satellite_state, obj, "satelliteState", "SWGSatelliteState");
    }

    return obj;
}

qint32
SWGSatelliteTrackerReport::getRunningState() {
    return running_state;
}
void
SWGSatelliteTrackerReport::setRunningState(qint32 running_state) {
    this->running_state = running_state;
    this->m_running_state_isSet = true;
}

float
SWGSatelliteTrackerReport::getTargetAzimuth() {
    return target_azimuth;
}
void
SWGSatelliteTrackerReport::setTargetAzimuth(float target_azimuth) {
    this->target_azimuth = target_azimuth;
    this->m_target_azimuth_isSet = true;
}

float
SWGSatelliteTrackerReport::getTargetElevation() {
    return target_elevation;
}
void
SWGSatelliteTrackerReport::setTargetElevation(float target_elevation) {
    this->target_elevation = target_elevation;
    this->m_target_elevation_isSet = true;
}

QList<SWGSatelliteState*>*
SWGSatelliteTrackerReport::getSatelliteState() {
    return satellite_state;
}
void
SWGSatelliteTrackerReport::setSatelliteState(QList<SWGSatelliteState*>* satellite_state) {
    this->satellite_state = satellite_state;
    this->m_satellite_state_isSet = true;
}


bool
SWGSatelliteTrackerReport::isSet(){
    bool isObjectUpdated = false;
    do{
        if(m_running_state_isSet){
            isObjectUpdated = true; break;
        }
        if(m_target_azimuth_isSet){
            isObjectUpdated = true; break;
        }
        if(m_target_elevation_isSet){
            isObjectUpdated = true; break;
        }
        if(satellite_state && (satellite_state->size() > 0)){
            isObjectUpdated = true; break;
        }
    }while(false);
    return isObjectUpdated;
}
}

