/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 7.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


#include "SWGRadioClockReport.h"

#include "SWGHelpers.h"

#include <QJsonDocument>
#include <QJsonArray>
#include <QObject>
#include <QDebug>

namespace SWGSDRangel {

SWGRadioClockReport::SWGRadioClockReport(QString* json) {
    init();
    this->fromJson(*json);
}

SWGRadioClockReport::SWGRadioClockReport() {
    channel_power_db = 0.0f;
    m_channel_power_db_isSet = false;
    channel_sample_rate = 0;
    m_channel_sample_rate_isSet = false;
    date = nullptr;
    m_date_isSet = false;
    time = nullptr;
    m_time_isSet = false;
}

SWGRadioClockReport::~SWGRadioClockReport() {
    this->cleanup();
}

void
SWGRadioClockReport::init() {
    channel_power_db = 0.0f;
    m_channel_power_db_isSet = false;
    channel_sample_rate = 0;
    m_channel_sample_rate_isSet = false;
    date = new QString("");
    m_date_isSet = false;
    time = new QString("");
    m_time_isSet = false;
}

void
SWGRadioClockReport::cleanup() {


    if(date != nullptr) { 
        delete date;
    }
    if(time != nullptr) { 
        delete time;
    }
}

SWGRadioClockReport*
SWGRadioClockReport::fromJson(QString &json) {
    QByteArray array (json.toStdString().c_str());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
    return this;
}

void
SWGRadioClockReport::fromJsonObject(QJsonObject &pJson) {
    ::SWGSDRangel::setValue(&channel_power_db, pJson["channelPowerDB"], "float", "");
    
    ::SWGSDRangel::setValue(&channel_sample_rate, pJson["channelSampleRate"], "qint32", "");
    
    ::SWGSDRangel::setValue(&date, pJson["date"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&time, pJson["time"], "QString", "QString");
    
}

QString
SWGRadioClockReport::asJson ()
{
    QJsonObject* obj = this->asJsonObject();

    QJsonDocument doc(*obj);
    QByteArray bytes = doc.toJson();
    delete obj;
    return QString(bytes);
}

QJsonObject*
SWGRadioClockReport::asJsonObject() {
    QJsonObject* obj = new QJsonObject();
    if(m_channel_power_db_isSet){
        obj->insert("channelPowerDB", QJsonValue(channel_power_db));
    }
    if(m_channel_sample_rate_isSet){
        obj->insert("channelSampleRate", QJsonValue(channel_sample_rate));
    }
    if(date != nullptr && *date != QString("")){
        toJsonValue(QString("date"), date, obj, QString("QString"));
    }
    if(time != nullptr && *time != QString("")){
        toJsonValue(QString("time"), time, obj, QString("QString"));
    }

    return obj;
}

float
SWGRadioClockReport::getChannelPowerDb() {
    return channel_power_db;
}
void
SWGRadioClockReport::setChannelPowerDb(float channel_power_db) {
    this->channel_power_db = channel_power_db;
    this->m_channel_power_db_isSet = true;
}

qint32
SWGRadioClockReport::getChannelSampleRate() {
    return channel_sample_rate;
}
void
SWGRadioClockReport::setChannelSampleRate(qint32 channel_sample_rate) {
    this->channel_sample_rate = channel_sample_rate;
    this->m_channel_sample_rate_isSet = true;
}

QString*
SWGRadioClockReport::getDate() {
    return date;
}
void
SWGRadioClockReport::setDate(QString* date) {
    this->date = date;
    this->m_date_isSet = true;
}

QString*
SWGRadioClockReport::getTime() {
    return time;
}
void
SWGRadioClockReport::setTime(QString* time) {
    this->time = time;
    this->m_time_isSet = true;
}


bool
SWGRadioClockReport::isSet(){
    bool isObjectUpdated = false;
    do{
        if(m_channel_power_db_isSet){
            isObjectUpdated = true; break;
        }
        if(m_channel_sample_rate_isSet){
            isObjectUpdated = true; break;
        }
        if(date && *date != QString("")){
            isObjectUpdated = true; break;
        }
        if(time && *time != QString("")){
            isObjectUpdated = true; break;
        }
    }while(false);
    return isObjectUpdated;
}
}

