/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 7.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


#include "SWGPERTesterActions_aos.h"

#include "SWGHelpers.h"

#include <QJsonDocument>
#include <QJsonArray>
#include <QObject>
#include <QDebug>

namespace SWGSDRangel {

SWGPERTesterActions_aos::SWGPERTesterActions_aos(QString* json) {
    init();
    this->fromJson(*json);
}

SWGPERTesterActions_aos::SWGPERTesterActions_aos() {
    satellite_name = nullptr;
    m_satellite_name_isSet = false;
    aos_time = nullptr;
    m_aos_time_isSet = false;
    los_time = nullptr;
    m_los_time_isSet = false;
}

SWGPERTesterActions_aos::~SWGPERTesterActions_aos() {
    this->cleanup();
}

void
SWGPERTesterActions_aos::init() {
    satellite_name = new QString("");
    m_satellite_name_isSet = false;
    aos_time = new QString("");
    m_aos_time_isSet = false;
    los_time = new QString("");
    m_los_time_isSet = false;
}

void
SWGPERTesterActions_aos::cleanup() {
    if(satellite_name != nullptr) { 
        delete satellite_name;
    }
    if(aos_time != nullptr) { 
        delete aos_time;
    }
    if(los_time != nullptr) { 
        delete los_time;
    }
}

SWGPERTesterActions_aos*
SWGPERTesterActions_aos::fromJson(QString &json) {
    QByteArray array (json.toStdString().c_str());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
    return this;
}

void
SWGPERTesterActions_aos::fromJsonObject(QJsonObject &pJson) {
    ::SWGSDRangel::setValue(&satellite_name, pJson["satelliteName"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&aos_time, pJson["aosTime"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&los_time, pJson["losTime"], "QString", "QString");
    
}

QString
SWGPERTesterActions_aos::asJson ()
{
    QJsonObject* obj = this->asJsonObject();

    QJsonDocument doc(*obj);
    QByteArray bytes = doc.toJson();
    delete obj;
    return QString(bytes);
}

QJsonObject*
SWGPERTesterActions_aos::asJsonObject() {
    QJsonObject* obj = new QJsonObject();
    if(satellite_name != nullptr && *satellite_name != QString("")){
        toJsonValue(QString("satelliteName"), satellite_name, obj, QString("QString"));
    }
    if(aos_time != nullptr && *aos_time != QString("")){
        toJsonValue(QString("aosTime"), aos_time, obj, QString("QString"));
    }
    if(los_time != nullptr && *los_time != QString("")){
        toJsonValue(QString("losTime"), los_time, obj, QString("QString"));
    }

    return obj;
}

QString*
SWGPERTesterActions_aos::getSatelliteName() {
    return satellite_name;
}
void
SWGPERTesterActions_aos::setSatelliteName(QString* satellite_name) {
    this->satellite_name = satellite_name;
    this->m_satellite_name_isSet = true;
}

QString*
SWGPERTesterActions_aos::getAosTime() {
    return aos_time;
}
void
SWGPERTesterActions_aos::setAosTime(QString* aos_time) {
    this->aos_time = aos_time;
    this->m_aos_time_isSet = true;
}

QString*
SWGPERTesterActions_aos::getLosTime() {
    return los_time;
}
void
SWGPERTesterActions_aos::setLosTime(QString* los_time) {
    this->los_time = los_time;
    this->m_los_time_isSet = true;
}


bool
SWGPERTesterActions_aos::isSet(){
    bool isObjectUpdated = false;
    do{
        if(satellite_name && *satellite_name != QString("")){
            isObjectUpdated = true; break;
        }
        if(aos_time && *aos_time != QString("")){
            isObjectUpdated = true; break;
        }
        if(los_time && *los_time != QString("")){
            isObjectUpdated = true; break;
        }
    }while(false);
    return isObjectUpdated;
}
}

