/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 7.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

/*
 * SWGMapAircraftState.h
 *
 * Aircraft state for PFD/ND
 */

#ifndef SWGMapAircraftState_H_
#define SWGMapAircraftState_H_

#include <QJsonObject>


#include <QString>

#include "SWGObject.h"
#include "export.h"

namespace SWGSDRangel {

class SWG_API SWGMapAircraftState: public SWGObject {
public:
    SWGMapAircraftState();
    SWGMapAircraftState(QString* json);
    virtual ~SWGMapAircraftState();
    void init();
    void cleanup();

    virtual QString asJson () override;
    virtual QJsonObject* asJsonObject() override;
    virtual void fromJsonObject(QJsonObject &json) override;
    virtual SWGMapAircraftState* fromJson(QString &jsonString) override;

    QString* getCallsign();
    void setCallsign(QString* callsign);

    QString* getAircraftType();
    void setAircraftType(QString* aircraft_type);

    qint32 getOnSurface();
    void setOnSurface(qint32 on_surface);

    float getAirspeed();
    void setAirspeed(float airspeed);

    QString* getAirspeedDateTime();
    void setAirspeedDateTime(QString* airspeed_date_time);

    float getTrueAirspeed();
    void setTrueAirspeed(float true_airspeed);

    float getGroundspeed();
    void setGroundspeed(float groundspeed);

    float getMach();
    void setMach(float mach);

    float getAltitude();
    void setAltitude(float altitude);

    QString* getAltitudeDateTime();
    void setAltitudeDateTime(QString* altitude_date_time);

    float getQnh();
    void setQnh(float qnh);

    float getVerticalSpeed();
    void setVerticalSpeed(float vertical_speed);

    QString* getVerticalSpeedDateTime();
    void setVerticalSpeedDateTime(QString* vertical_speed_date_time);

    float getHeading();
    void setHeading(float heading);

    float getTrack();
    void setTrack(float track);

    float getSelectedAirspeed();
    void setSelectedAirspeed(float selected_airspeed);

    float getSelectedAltitude();
    void setSelectedAltitude(float selected_altitude);

    float getSelectedHeading();
    void setSelectedHeading(float selected_heading);

    qint32 getAutopilot();
    void setAutopilot(qint32 autopilot);

    qint32 getVerticalMode();
    void setVerticalMode(qint32 vertical_mode);

    qint32 getLateralMode();
    void setLateralMode(qint32 lateral_mode);

    qint32 getTcasMode();
    void setTcasMode(qint32 tcas_mode);

    float getWindSpeed();
    void setWindSpeed(float wind_speed);

    float getWindDirection();
    void setWindDirection(float wind_direction);

    float getStaticAirTemperature();
    void setStaticAirTemperature(float static_air_temperature);


    virtual bool isSet() override;

private:
    QString* callsign;
    bool m_callsign_isSet;

    QString* aircraft_type;
    bool m_aircraft_type_isSet;

    qint32 on_surface;
    bool m_on_surface_isSet;

    float airspeed;
    bool m_airspeed_isSet;

    QString* airspeed_date_time;
    bool m_airspeed_date_time_isSet;

    float true_airspeed;
    bool m_true_airspeed_isSet;

    float groundspeed;
    bool m_groundspeed_isSet;

    float mach;
    bool m_mach_isSet;

    float altitude;
    bool m_altitude_isSet;

    QString* altitude_date_time;
    bool m_altitude_date_time_isSet;

    float qnh;
    bool m_qnh_isSet;

    float vertical_speed;
    bool m_vertical_speed_isSet;

    QString* vertical_speed_date_time;
    bool m_vertical_speed_date_time_isSet;

    float heading;
    bool m_heading_isSet;

    float track;
    bool m_track_isSet;

    float selected_airspeed;
    bool m_selected_airspeed_isSet;

    float selected_altitude;
    bool m_selected_altitude_isSet;

    float selected_heading;
    bool m_selected_heading_isSet;

    qint32 autopilot;
    bool m_autopilot_isSet;

    qint32 vertical_mode;
    bool m_vertical_mode_isSet;

    qint32 lateral_mode;
    bool m_lateral_mode_isSet;

    qint32 tcas_mode;
    bool m_tcas_mode_isSet;

    float wind_speed;
    bool m_wind_speed_isSet;

    float wind_direction;
    bool m_wind_direction_isSet;

    float static_air_temperature;
    bool m_static_air_temperature_isSet;

};

}

#endif /* SWGMapAircraftState_H_ */
