/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 7.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


#include "SWGLimeRFEActions.h"

#include "SWGHelpers.h"

#include <QJsonDocument>
#include <QJsonArray>
#include <QObject>
#include <QDebug>

namespace SWGSDRangel {

SWGLimeRFEActions::SWGLimeRFEActions(QString* json) {
    init();
    this->fromJson(*json);
}

SWGLimeRFEActions::SWGLimeRFEActions() {
    select_channel = 0;
    m_select_channel_isSet = false;
    device_set_index = 0;
    m_device_set_index_isSet = false;
    switch_channel = 0;
    m_switch_channel_isSet = false;
    get_state = 0;
    m_get_state_isSet = false;
    from_to_settings = 0;
    m_from_to_settings_isSet = false;
    open_close_device = 0;
    m_open_close_device_isSet = false;
    set_rx = 0;
    m_set_rx_isSet = false;
    set_tx = 0;
    m_set_tx_isSet = false;
}

SWGLimeRFEActions::~SWGLimeRFEActions() {
    this->cleanup();
}

void
SWGLimeRFEActions::init() {
    select_channel = 0;
    m_select_channel_isSet = false;
    device_set_index = 0;
    m_device_set_index_isSet = false;
    switch_channel = 0;
    m_switch_channel_isSet = false;
    get_state = 0;
    m_get_state_isSet = false;
    from_to_settings = 0;
    m_from_to_settings_isSet = false;
    open_close_device = 0;
    m_open_close_device_isSet = false;
    set_rx = 0;
    m_set_rx_isSet = false;
    set_tx = 0;
    m_set_tx_isSet = false;
}

void
SWGLimeRFEActions::cleanup() {








}

SWGLimeRFEActions*
SWGLimeRFEActions::fromJson(QString &json) {
    QByteArray array (json.toStdString().c_str());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
    return this;
}

void
SWGLimeRFEActions::fromJsonObject(QJsonObject &pJson) {
    ::SWGSDRangel::setValue(&select_channel, pJson["selectChannel"], "qint32", "");
    
    ::SWGSDRangel::setValue(&device_set_index, pJson["deviceSetIndex"], "qint32", "");
    
    ::SWGSDRangel::setValue(&switch_channel, pJson["switchChannel"], "qint32", "");
    
    ::SWGSDRangel::setValue(&get_state, pJson["getState"], "qint32", "");
    
    ::SWGSDRangel::setValue(&from_to_settings, pJson["fromToSettings"], "qint32", "");
    
    ::SWGSDRangel::setValue(&open_close_device, pJson["openCloseDevice"], "qint32", "");
    
    ::SWGSDRangel::setValue(&set_rx, pJson["setRx"], "qint32", "");
    
    ::SWGSDRangel::setValue(&set_tx, pJson["setTx"], "qint32", "");
    
}

QString
SWGLimeRFEActions::asJson ()
{
    QJsonObject* obj = this->asJsonObject();

    QJsonDocument doc(*obj);
    QByteArray bytes = doc.toJson();
    delete obj;
    return QString(bytes);
}

QJsonObject*
SWGLimeRFEActions::asJsonObject() {
    QJsonObject* obj = new QJsonObject();
    if(m_select_channel_isSet){
        obj->insert("selectChannel", QJsonValue(select_channel));
    }
    if(m_device_set_index_isSet){
        obj->insert("deviceSetIndex", QJsonValue(device_set_index));
    }
    if(m_switch_channel_isSet){
        obj->insert("switchChannel", QJsonValue(switch_channel));
    }
    if(m_get_state_isSet){
        obj->insert("getState", QJsonValue(get_state));
    }
    if(m_from_to_settings_isSet){
        obj->insert("fromToSettings", QJsonValue(from_to_settings));
    }
    if(m_open_close_device_isSet){
        obj->insert("openCloseDevice", QJsonValue(open_close_device));
    }
    if(m_set_rx_isSet){
        obj->insert("setRx", QJsonValue(set_rx));
    }
    if(m_set_tx_isSet){
        obj->insert("setTx", QJsonValue(set_tx));
    }

    return obj;
}

qint32
SWGLimeRFEActions::getSelectChannel() {
    return select_channel;
}
void
SWGLimeRFEActions::setSelectChannel(qint32 select_channel) {
    this->select_channel = select_channel;
    this->m_select_channel_isSet = true;
}

qint32
SWGLimeRFEActions::getDeviceSetIndex() {
    return device_set_index;
}
void
SWGLimeRFEActions::setDeviceSetIndex(qint32 device_set_index) {
    this->device_set_index = device_set_index;
    this->m_device_set_index_isSet = true;
}

qint32
SWGLimeRFEActions::getSwitchChannel() {
    return switch_channel;
}
void
SWGLimeRFEActions::setSwitchChannel(qint32 switch_channel) {
    this->switch_channel = switch_channel;
    this->m_switch_channel_isSet = true;
}

qint32
SWGLimeRFEActions::getGetState() {
    return get_state;
}
void
SWGLimeRFEActions::setGetState(qint32 get_state) {
    this->get_state = get_state;
    this->m_get_state_isSet = true;
}

qint32
SWGLimeRFEActions::getFromToSettings() {
    return from_to_settings;
}
void
SWGLimeRFEActions::setFromToSettings(qint32 from_to_settings) {
    this->from_to_settings = from_to_settings;
    this->m_from_to_settings_isSet = true;
}

qint32
SWGLimeRFEActions::getOpenCloseDevice() {
    return open_close_device;
}
void
SWGLimeRFEActions::setOpenCloseDevice(qint32 open_close_device) {
    this->open_close_device = open_close_device;
    this->m_open_close_device_isSet = true;
}

qint32
SWGLimeRFEActions::getSetRx() {
    return set_rx;
}
void
SWGLimeRFEActions::setSetRx(qint32 set_rx) {
    this->set_rx = set_rx;
    this->m_set_rx_isSet = true;
}

qint32
SWGLimeRFEActions::getSetTx() {
    return set_tx;
}
void
SWGLimeRFEActions::setSetTx(qint32 set_tx) {
    this->set_tx = set_tx;
    this->m_set_tx_isSet = true;
}


bool
SWGLimeRFEActions::isSet(){
    bool isObjectUpdated = false;
    do{
        if(m_select_channel_isSet){
            isObjectUpdated = true; break;
        }
        if(m_device_set_index_isSet){
            isObjectUpdated = true; break;
        }
        if(m_switch_channel_isSet){
            isObjectUpdated = true; break;
        }
        if(m_get_state_isSet){
            isObjectUpdated = true; break;
        }
        if(m_from_to_settings_isSet){
            isObjectUpdated = true; break;
        }
        if(m_open_close_device_isSet){
            isObjectUpdated = true; break;
        }
        if(m_set_rx_isSet){
            isObjectUpdated = true; break;
        }
        if(m_set_tx_isSet){
            isObjectUpdated = true; break;
        }
    }while(false);
    return isObjectUpdated;
}
}

