/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 7.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


#include "SWGFreqScannerReport.h"

#include "SWGHelpers.h"

#include <QJsonDocument>
#include <QJsonArray>
#include <QObject>
#include <QDebug>

namespace SWGSDRangel {

SWGFreqScannerReport::SWGFreqScannerReport(QString* json) {
    init();
    this->fromJson(*json);
}

SWGFreqScannerReport::SWGFreqScannerReport() {
    channel_sample_rate = 0;
    m_channel_sample_rate_isSet = false;
    scan_state = 0;
    m_scan_state_isSet = false;
    channel_state = nullptr;
    m_channel_state_isSet = false;
}

SWGFreqScannerReport::~SWGFreqScannerReport() {
    this->cleanup();
}

void
SWGFreqScannerReport::init() {
    channel_sample_rate = 0;
    m_channel_sample_rate_isSet = false;
    scan_state = 0;
    m_scan_state_isSet = false;
    channel_state = new QList<SWGFreqScannerChannelState*>();
    m_channel_state_isSet = false;
}

void
SWGFreqScannerReport::cleanup() {


    if(channel_state != nullptr) { 
        auto arr = channel_state;
        for(auto o: *arr) { 
            delete o;
        }
        delete channel_state;
    }
}

SWGFreqScannerReport*
SWGFreqScannerReport::fromJson(QString &json) {
    QByteArray array (json.toStdString().c_str());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
    return this;
}

void
SWGFreqScannerReport::fromJsonObject(QJsonObject &pJson) {
    ::SWGSDRangel::setValue(&channel_sample_rate, pJson["channelSampleRate"], "qint32", "");
    
    ::SWGSDRangel::setValue(&scan_state, pJson["scanState"], "qint32", "");
    
    
    ::SWGSDRangel::setValue(&channel_state, pJson["channelState"], "QList", "SWGFreqScannerChannelState");
}

QString
SWGFreqScannerReport::asJson ()
{
    QJsonObject* obj = this->asJsonObject();

    QJsonDocument doc(*obj);
    QByteArray bytes = doc.toJson();
    delete obj;
    return QString(bytes);
}

QJsonObject*
SWGFreqScannerReport::asJsonObject() {
    QJsonObject* obj = new QJsonObject();
    if(m_channel_sample_rate_isSet){
        obj->insert("channelSampleRate", QJsonValue(channel_sample_rate));
    }
    if(m_scan_state_isSet){
        obj->insert("scanState", QJsonValue(scan_state));
    }
    if(channel_state && channel_state->size() > 0){
        toJsonArray((QList<void*>*)channel_state, obj, "channelState", "SWGFreqScannerChannelState");
    }

    return obj;
}

qint32
SWGFreqScannerReport::getChannelSampleRate() {
    return channel_sample_rate;
}
void
SWGFreqScannerReport::setChannelSampleRate(qint32 channel_sample_rate) {
    this->channel_sample_rate = channel_sample_rate;
    this->m_channel_sample_rate_isSet = true;
}

qint32
SWGFreqScannerReport::getScanState() {
    return scan_state;
}
void
SWGFreqScannerReport::setScanState(qint32 scan_state) {
    this->scan_state = scan_state;
    this->m_scan_state_isSet = true;
}

QList<SWGFreqScannerChannelState*>*
SWGFreqScannerReport::getChannelState() {
    return channel_state;
}
void
SWGFreqScannerReport::setChannelState(QList<SWGFreqScannerChannelState*>* channel_state) {
    this->channel_state = channel_state;
    this->m_channel_state_isSet = true;
}


bool
SWGFreqScannerReport::isSet(){
    bool isObjectUpdated = false;
    do{
        if(m_channel_sample_rate_isSet){
            isObjectUpdated = true; break;
        }
        if(m_scan_state_isSet){
            isObjectUpdated = true; break;
        }
        if(channel_state && (channel_state->size() > 0)){
            isObjectUpdated = true; break;
        }
    }while(false);
    return isObjectUpdated;
}
}

