/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 7.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


#include "SWGDATVModSettings.h"

#include "SWGHelpers.h"

#include <QJsonDocument>
#include <QJsonArray>
#include <QObject>
#include <QDebug>

namespace SWGSDRangel {

SWGDATVModSettings::SWGDATVModSettings(QString* json) {
    init();
    this->fromJson(*json);
}

SWGDATVModSettings::SWGDATVModSettings() {
    input_frequency_offset = 0L;
    m_input_frequency_offset_isSet = false;
    rf_bandwidth = 0.0f;
    m_rf_bandwidth_isSet = false;
    standard = 0;
    m_standard_isSet = false;
    modulation = 0;
    m_modulation_isSet = false;
    fec = 0;
    m_fec_isSet = false;
    symbol_rate = 0;
    m_symbol_rate_isSet = false;
    roll_off = 0.0f;
    m_roll_off_isSet = false;
    ts_source = 0;
    m_ts_source_isSet = false;
    image_file_name = nullptr;
    m_image_file_name_isSet = false;
    image_overlay_timestamp = 0;
    m_image_overlay_timestamp_isSet = false;
    image_service_provider = nullptr;
    m_image_service_provider_isSet = false;
    image_service_name = nullptr;
    m_image_service_name_isSet = false;
    image_codec = 0;
    m_image_codec_isSet = false;
    ts_file_name = nullptr;
    m_ts_file_name_isSet = false;
    ts_file_play_loop = 0;
    m_ts_file_play_loop_isSet = false;
    ts_file_play = 0;
    m_ts_file_play_isSet = false;
    udp_address = nullptr;
    m_udp_address_isSet = false;
    udp_port = 0;
    m_udp_port_isSet = false;
    channel_mute = 0;
    m_channel_mute_isSet = false;
    rgb_color = 0;
    m_rgb_color_isSet = false;
    title = nullptr;
    m_title_isSet = false;
    stream_index = 0;
    m_stream_index_isSet = false;
    use_reverse_api = 0;
    m_use_reverse_api_isSet = false;
    reverse_api_address = nullptr;
    m_reverse_api_address_isSet = false;
    reverse_api_port = 0;
    m_reverse_api_port_isSet = false;
    reverse_api_device_index = 0;
    m_reverse_api_device_index_isSet = false;
    reverse_api_channel_index = 0;
    m_reverse_api_channel_index_isSet = false;
    channel_marker = nullptr;
    m_channel_marker_isSet = false;
    rollup_state = nullptr;
    m_rollup_state_isSet = false;
}

SWGDATVModSettings::~SWGDATVModSettings() {
    this->cleanup();
}

void
SWGDATVModSettings::init() {
    input_frequency_offset = 0L;
    m_input_frequency_offset_isSet = false;
    rf_bandwidth = 0.0f;
    m_rf_bandwidth_isSet = false;
    standard = 0;
    m_standard_isSet = false;
    modulation = 0;
    m_modulation_isSet = false;
    fec = 0;
    m_fec_isSet = false;
    symbol_rate = 0;
    m_symbol_rate_isSet = false;
    roll_off = 0.0f;
    m_roll_off_isSet = false;
    ts_source = 0;
    m_ts_source_isSet = false;
    image_file_name = new QString("");
    m_image_file_name_isSet = false;
    image_overlay_timestamp = 0;
    m_image_overlay_timestamp_isSet = false;
    image_service_provider = new QString("");
    m_image_service_provider_isSet = false;
    image_service_name = new QString("");
    m_image_service_name_isSet = false;
    image_codec = 0;
    m_image_codec_isSet = false;
    ts_file_name = new QString("");
    m_ts_file_name_isSet = false;
    ts_file_play_loop = 0;
    m_ts_file_play_loop_isSet = false;
    ts_file_play = 0;
    m_ts_file_play_isSet = false;
    udp_address = new QString("");
    m_udp_address_isSet = false;
    udp_port = 0;
    m_udp_port_isSet = false;
    channel_mute = 0;
    m_channel_mute_isSet = false;
    rgb_color = 0;
    m_rgb_color_isSet = false;
    title = new QString("");
    m_title_isSet = false;
    stream_index = 0;
    m_stream_index_isSet = false;
    use_reverse_api = 0;
    m_use_reverse_api_isSet = false;
    reverse_api_address = new QString("");
    m_reverse_api_address_isSet = false;
    reverse_api_port = 0;
    m_reverse_api_port_isSet = false;
    reverse_api_device_index = 0;
    m_reverse_api_device_index_isSet = false;
    reverse_api_channel_index = 0;
    m_reverse_api_channel_index_isSet = false;
    channel_marker = new SWGChannelMarker();
    m_channel_marker_isSet = false;
    rollup_state = new SWGRollupState();
    m_rollup_state_isSet = false;
}

void
SWGDATVModSettings::cleanup() {








    if(image_file_name != nullptr) { 
        delete image_file_name;
    }

    if(image_service_provider != nullptr) { 
        delete image_service_provider;
    }
    if(image_service_name != nullptr) { 
        delete image_service_name;
    }

    if(ts_file_name != nullptr) { 
        delete ts_file_name;
    }


    if(udp_address != nullptr) { 
        delete udp_address;
    }



    if(title != nullptr) { 
        delete title;
    }


    if(reverse_api_address != nullptr) { 
        delete reverse_api_address;
    }



    if(channel_marker != nullptr) { 
        delete channel_marker;
    }
    if(rollup_state != nullptr) { 
        delete rollup_state;
    }
}

SWGDATVModSettings*
SWGDATVModSettings::fromJson(QString &json) {
    QByteArray array (json.toStdString().c_str());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
    return this;
}

void
SWGDATVModSettings::fromJsonObject(QJsonObject &pJson) {
    ::SWGSDRangel::setValue(&input_frequency_offset, pJson["inputFrequencyOffset"], "qint64", "");
    
    ::SWGSDRangel::setValue(&rf_bandwidth, pJson["rfBandwidth"], "float", "");
    
    ::SWGSDRangel::setValue(&standard, pJson["standard"], "qint32", "");
    
    ::SWGSDRangel::setValue(&modulation, pJson["modulation"], "qint32", "");
    
    ::SWGSDRangel::setValue(&fec, pJson["fec"], "qint32", "");
    
    ::SWGSDRangel::setValue(&symbol_rate, pJson["symbolRate"], "qint32", "");
    
    ::SWGSDRangel::setValue(&roll_off, pJson["rollOff"], "float", "");
    
    ::SWGSDRangel::setValue(&ts_source, pJson["tsSource"], "qint32", "");
    
    ::SWGSDRangel::setValue(&image_file_name, pJson["imageFileName"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&image_overlay_timestamp, pJson["imageOverlayTimestamp"], "qint32", "");
    
    ::SWGSDRangel::setValue(&image_service_provider, pJson["imageServiceProvider"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&image_service_name, pJson["imageServiceName"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&image_codec, pJson["imageCodec"], "qint32", "");
    
    ::SWGSDRangel::setValue(&ts_file_name, pJson["tsFileName"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&ts_file_play_loop, pJson["tsFilePlayLoop"], "qint32", "");
    
    ::SWGSDRangel::setValue(&ts_file_play, pJson["tsFilePlay"], "qint32", "");
    
    ::SWGSDRangel::setValue(&udp_address, pJson["udpAddress"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&udp_port, pJson["udpPort"], "qint32", "");
    
    ::SWGSDRangel::setValue(&channel_mute, pJson["channelMute"], "qint32", "");
    
    ::SWGSDRangel::setValue(&rgb_color, pJson["rgbColor"], "qint32", "");
    
    ::SWGSDRangel::setValue(&title, pJson["title"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&stream_index, pJson["streamIndex"], "qint32", "");
    
    ::SWGSDRangel::setValue(&use_reverse_api, pJson["useReverseAPI"], "qint32", "");
    
    ::SWGSDRangel::setValue(&reverse_api_address, pJson["reverseAPIAddress"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&reverse_api_port, pJson["reverseAPIPort"], "qint32", "");
    
    ::SWGSDRangel::setValue(&reverse_api_device_index, pJson["reverseAPIDeviceIndex"], "qint32", "");
    
    ::SWGSDRangel::setValue(&reverse_api_channel_index, pJson["reverseAPIChannelIndex"], "qint32", "");
    
    ::SWGSDRangel::setValue(&channel_marker, pJson["channelMarker"], "SWGChannelMarker", "SWGChannelMarker");
    
    ::SWGSDRangel::setValue(&rollup_state, pJson["rollupState"], "SWGRollupState", "SWGRollupState");
    
}

QString
SWGDATVModSettings::asJson ()
{
    QJsonObject* obj = this->asJsonObject();

    QJsonDocument doc(*obj);
    QByteArray bytes = doc.toJson();
    delete obj;
    return QString(bytes);
}

QJsonObject*
SWGDATVModSettings::asJsonObject() {
    QJsonObject* obj = new QJsonObject();
    if(m_input_frequency_offset_isSet){
        obj->insert("inputFrequencyOffset", QJsonValue(input_frequency_offset));
    }
    if(m_rf_bandwidth_isSet){
        obj->insert("rfBandwidth", QJsonValue(rf_bandwidth));
    }
    if(m_standard_isSet){
        obj->insert("standard", QJsonValue(standard));
    }
    if(m_modulation_isSet){
        obj->insert("modulation", QJsonValue(modulation));
    }
    if(m_fec_isSet){
        obj->insert("fec", QJsonValue(fec));
    }
    if(m_symbol_rate_isSet){
        obj->insert("symbolRate", QJsonValue(symbol_rate));
    }
    if(m_roll_off_isSet){
        obj->insert("rollOff", QJsonValue(roll_off));
    }
    if(m_ts_source_isSet){
        obj->insert("tsSource", QJsonValue(ts_source));
    }
    if(image_file_name != nullptr && *image_file_name != QString("")){
        toJsonValue(QString("imageFileName"), image_file_name, obj, QString("QString"));
    }
    if(m_image_overlay_timestamp_isSet){
        obj->insert("imageOverlayTimestamp", QJsonValue(image_overlay_timestamp));
    }
    if(image_service_provider != nullptr && *image_service_provider != QString("")){
        toJsonValue(QString("imageServiceProvider"), image_service_provider, obj, QString("QString"));
    }
    if(image_service_name != nullptr && *image_service_name != QString("")){
        toJsonValue(QString("imageServiceName"), image_service_name, obj, QString("QString"));
    }
    if(m_image_codec_isSet){
        obj->insert("imageCodec", QJsonValue(image_codec));
    }
    if(ts_file_name != nullptr && *ts_file_name != QString("")){
        toJsonValue(QString("tsFileName"), ts_file_name, obj, QString("QString"));
    }
    if(m_ts_file_play_loop_isSet){
        obj->insert("tsFilePlayLoop", QJsonValue(ts_file_play_loop));
    }
    if(m_ts_file_play_isSet){
        obj->insert("tsFilePlay", QJsonValue(ts_file_play));
    }
    if(udp_address != nullptr && *udp_address != QString("")){
        toJsonValue(QString("udpAddress"), udp_address, obj, QString("QString"));
    }
    if(m_udp_port_isSet){
        obj->insert("udpPort", QJsonValue(udp_port));
    }
    if(m_channel_mute_isSet){
        obj->insert("channelMute", QJsonValue(channel_mute));
    }
    if(m_rgb_color_isSet){
        obj->insert("rgbColor", QJsonValue(rgb_color));
    }
    if(title != nullptr && *title != QString("")){
        toJsonValue(QString("title"), title, obj, QString("QString"));
    }
    if(m_stream_index_isSet){
        obj->insert("streamIndex", QJsonValue(stream_index));
    }
    if(m_use_reverse_api_isSet){
        obj->insert("useReverseAPI", QJsonValue(use_reverse_api));
    }
    if(reverse_api_address != nullptr && *reverse_api_address != QString("")){
        toJsonValue(QString("reverseAPIAddress"), reverse_api_address, obj, QString("QString"));
    }
    if(m_reverse_api_port_isSet){
        obj->insert("reverseAPIPort", QJsonValue(reverse_api_port));
    }
    if(m_reverse_api_device_index_isSet){
        obj->insert("reverseAPIDeviceIndex", QJsonValue(reverse_api_device_index));
    }
    if(m_reverse_api_channel_index_isSet){
        obj->insert("reverseAPIChannelIndex", QJsonValue(reverse_api_channel_index));
    }
    if((channel_marker != nullptr) && (channel_marker->isSet())){
        toJsonValue(QString("channelMarker"), channel_marker, obj, QString("SWGChannelMarker"));
    }
    if((rollup_state != nullptr) && (rollup_state->isSet())){
        toJsonValue(QString("rollupState"), rollup_state, obj, QString("SWGRollupState"));
    }

    return obj;
}

qint64
SWGDATVModSettings::getInputFrequencyOffset() {
    return input_frequency_offset;
}
void
SWGDATVModSettings::setInputFrequencyOffset(qint64 input_frequency_offset) {
    this->input_frequency_offset = input_frequency_offset;
    this->m_input_frequency_offset_isSet = true;
}

float
SWGDATVModSettings::getRfBandwidth() {
    return rf_bandwidth;
}
void
SWGDATVModSettings::setRfBandwidth(float rf_bandwidth) {
    this->rf_bandwidth = rf_bandwidth;
    this->m_rf_bandwidth_isSet = true;
}

qint32
SWGDATVModSettings::getStandard() {
    return standard;
}
void
SWGDATVModSettings::setStandard(qint32 standard) {
    this->standard = standard;
    this->m_standard_isSet = true;
}

qint32
SWGDATVModSettings::getModulation() {
    return modulation;
}
void
SWGDATVModSettings::setModulation(qint32 modulation) {
    this->modulation = modulation;
    this->m_modulation_isSet = true;
}

qint32
SWGDATVModSettings::getFec() {
    return fec;
}
void
SWGDATVModSettings::setFec(qint32 fec) {
    this->fec = fec;
    this->m_fec_isSet = true;
}

qint32
SWGDATVModSettings::getSymbolRate() {
    return symbol_rate;
}
void
SWGDATVModSettings::setSymbolRate(qint32 symbol_rate) {
    this->symbol_rate = symbol_rate;
    this->m_symbol_rate_isSet = true;
}

float
SWGDATVModSettings::getRollOff() {
    return roll_off;
}
void
SWGDATVModSettings::setRollOff(float roll_off) {
    this->roll_off = roll_off;
    this->m_roll_off_isSet = true;
}

qint32
SWGDATVModSettings::getTsSource() {
    return ts_source;
}
void
SWGDATVModSettings::setTsSource(qint32 ts_source) {
    this->ts_source = ts_source;
    this->m_ts_source_isSet = true;
}

QString*
SWGDATVModSettings::getImageFileName() {
    return image_file_name;
}
void
SWGDATVModSettings::setImageFileName(QString* image_file_name) {
    this->image_file_name = image_file_name;
    this->m_image_file_name_isSet = true;
}

qint32
SWGDATVModSettings::getImageOverlayTimestamp() {
    return image_overlay_timestamp;
}
void
SWGDATVModSettings::setImageOverlayTimestamp(qint32 image_overlay_timestamp) {
    this->image_overlay_timestamp = image_overlay_timestamp;
    this->m_image_overlay_timestamp_isSet = true;
}

QString*
SWGDATVModSettings::getImageServiceProvider() {
    return image_service_provider;
}
void
SWGDATVModSettings::setImageServiceProvider(QString* image_service_provider) {
    this->image_service_provider = image_service_provider;
    this->m_image_service_provider_isSet = true;
}

QString*
SWGDATVModSettings::getImageServiceName() {
    return image_service_name;
}
void
SWGDATVModSettings::setImageServiceName(QString* image_service_name) {
    this->image_service_name = image_service_name;
    this->m_image_service_name_isSet = true;
}

qint32
SWGDATVModSettings::getImageCodec() {
    return image_codec;
}
void
SWGDATVModSettings::setImageCodec(qint32 image_codec) {
    this->image_codec = image_codec;
    this->m_image_codec_isSet = true;
}

QString*
SWGDATVModSettings::getTsFileName() {
    return ts_file_name;
}
void
SWGDATVModSettings::setTsFileName(QString* ts_file_name) {
    this->ts_file_name = ts_file_name;
    this->m_ts_file_name_isSet = true;
}

qint32
SWGDATVModSettings::getTsFilePlayLoop() {
    return ts_file_play_loop;
}
void
SWGDATVModSettings::setTsFilePlayLoop(qint32 ts_file_play_loop) {
    this->ts_file_play_loop = ts_file_play_loop;
    this->m_ts_file_play_loop_isSet = true;
}

qint32
SWGDATVModSettings::getTsFilePlay() {
    return ts_file_play;
}
void
SWGDATVModSettings::setTsFilePlay(qint32 ts_file_play) {
    this->ts_file_play = ts_file_play;
    this->m_ts_file_play_isSet = true;
}

QString*
SWGDATVModSettings::getUdpAddress() {
    return udp_address;
}
void
SWGDATVModSettings::setUdpAddress(QString* udp_address) {
    this->udp_address = udp_address;
    this->m_udp_address_isSet = true;
}

qint32
SWGDATVModSettings::getUdpPort() {
    return udp_port;
}
void
SWGDATVModSettings::setUdpPort(qint32 udp_port) {
    this->udp_port = udp_port;
    this->m_udp_port_isSet = true;
}

qint32
SWGDATVModSettings::getChannelMute() {
    return channel_mute;
}
void
SWGDATVModSettings::setChannelMute(qint32 channel_mute) {
    this->channel_mute = channel_mute;
    this->m_channel_mute_isSet = true;
}

qint32
SWGDATVModSettings::getRgbColor() {
    return rgb_color;
}
void
SWGDATVModSettings::setRgbColor(qint32 rgb_color) {
    this->rgb_color = rgb_color;
    this->m_rgb_color_isSet = true;
}

QString*
SWGDATVModSettings::getTitle() {
    return title;
}
void
SWGDATVModSettings::setTitle(QString* title) {
    this->title = title;
    this->m_title_isSet = true;
}

qint32
SWGDATVModSettings::getStreamIndex() {
    return stream_index;
}
void
SWGDATVModSettings::setStreamIndex(qint32 stream_index) {
    this->stream_index = stream_index;
    this->m_stream_index_isSet = true;
}

qint32
SWGDATVModSettings::getUseReverseApi() {
    return use_reverse_api;
}
void
SWGDATVModSettings::setUseReverseApi(qint32 use_reverse_api) {
    this->use_reverse_api = use_reverse_api;
    this->m_use_reverse_api_isSet = true;
}

QString*
SWGDATVModSettings::getReverseApiAddress() {
    return reverse_api_address;
}
void
SWGDATVModSettings::setReverseApiAddress(QString* reverse_api_address) {
    this->reverse_api_address = reverse_api_address;
    this->m_reverse_api_address_isSet = true;
}

qint32
SWGDATVModSettings::getReverseApiPort() {
    return reverse_api_port;
}
void
SWGDATVModSettings::setReverseApiPort(qint32 reverse_api_port) {
    this->reverse_api_port = reverse_api_port;
    this->m_reverse_api_port_isSet = true;
}

qint32
SWGDATVModSettings::getReverseApiDeviceIndex() {
    return reverse_api_device_index;
}
void
SWGDATVModSettings::setReverseApiDeviceIndex(qint32 reverse_api_device_index) {
    this->reverse_api_device_index = reverse_api_device_index;
    this->m_reverse_api_device_index_isSet = true;
}

qint32
SWGDATVModSettings::getReverseApiChannelIndex() {
    return reverse_api_channel_index;
}
void
SWGDATVModSettings::setReverseApiChannelIndex(qint32 reverse_api_channel_index) {
    this->reverse_api_channel_index = reverse_api_channel_index;
    this->m_reverse_api_channel_index_isSet = true;
}

SWGChannelMarker*
SWGDATVModSettings::getChannelMarker() {
    return channel_marker;
}
void
SWGDATVModSettings::setChannelMarker(SWGChannelMarker* channel_marker) {
    this->channel_marker = channel_marker;
    this->m_channel_marker_isSet = true;
}

SWGRollupState*
SWGDATVModSettings::getRollupState() {
    return rollup_state;
}
void
SWGDATVModSettings::setRollupState(SWGRollupState* rollup_state) {
    this->rollup_state = rollup_state;
    this->m_rollup_state_isSet = true;
}


bool
SWGDATVModSettings::isSet(){
    bool isObjectUpdated = false;
    do{
        if(m_input_frequency_offset_isSet){
            isObjectUpdated = true; break;
        }
        if(m_rf_bandwidth_isSet){
            isObjectUpdated = true; break;
        }
        if(m_standard_isSet){
            isObjectUpdated = true; break;
        }
        if(m_modulation_isSet){
            isObjectUpdated = true; break;
        }
        if(m_fec_isSet){
            isObjectUpdated = true; break;
        }
        if(m_symbol_rate_isSet){
            isObjectUpdated = true; break;
        }
        if(m_roll_off_isSet){
            isObjectUpdated = true; break;
        }
        if(m_ts_source_isSet){
            isObjectUpdated = true; break;
        }
        if(image_file_name && *image_file_name != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_image_overlay_timestamp_isSet){
            isObjectUpdated = true; break;
        }
        if(image_service_provider && *image_service_provider != QString("")){
            isObjectUpdated = true; break;
        }
        if(image_service_name && *image_service_name != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_image_codec_isSet){
            isObjectUpdated = true; break;
        }
        if(ts_file_name && *ts_file_name != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_ts_file_play_loop_isSet){
            isObjectUpdated = true; break;
        }
        if(m_ts_file_play_isSet){
            isObjectUpdated = true; break;
        }
        if(udp_address && *udp_address != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_udp_port_isSet){
            isObjectUpdated = true; break;
        }
        if(m_channel_mute_isSet){
            isObjectUpdated = true; break;
        }
        if(m_rgb_color_isSet){
            isObjectUpdated = true; break;
        }
        if(title && *title != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_stream_index_isSet){
            isObjectUpdated = true; break;
        }
        if(m_use_reverse_api_isSet){
            isObjectUpdated = true; break;
        }
        if(reverse_api_address && *reverse_api_address != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_reverse_api_port_isSet){
            isObjectUpdated = true; break;
        }
        if(m_reverse_api_device_index_isSet){
            isObjectUpdated = true; break;
        }
        if(m_reverse_api_channel_index_isSet){
            isObjectUpdated = true; break;
        }
        if(channel_marker && channel_marker->isSet()){
            isObjectUpdated = true; break;
        }
        if(rollup_state && rollup_state->isSet()){
            isObjectUpdated = true; break;
        }
    }while(false);
    return isObjectUpdated;
}
}

