/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 7.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


#include "SWGBladeRF2MIMOReport.h"

#include "SWGHelpers.h"

#include <QJsonDocument>
#include <QJsonArray>
#include <QObject>
#include <QDebug>

namespace SWGSDRangel {

SWGBladeRF2MIMOReport::SWGBladeRF2MIMOReport(QString* json) {
    init();
    this->fromJson(*json);
}

SWGBladeRF2MIMOReport::SWGBladeRF2MIMOReport() {
    frequency_range_rx = nullptr;
    m_frequency_range_rx_isSet = false;
    sample_rate_range_rx = nullptr;
    m_sample_rate_range_rx_isSet = false;
    bandwidth_range_rx = nullptr;
    m_bandwidth_range_rx_isSet = false;
    global_gain_range_rx = nullptr;
    m_global_gain_range_rx_isSet = false;
    gain_modes_rx = nullptr;
    m_gain_modes_rx_isSet = false;
    frequency_range_tx = nullptr;
    m_frequency_range_tx_isSet = false;
    sample_rate_range_tx = nullptr;
    m_sample_rate_range_tx_isSet = false;
    bandwidth_range_tx = nullptr;
    m_bandwidth_range_tx_isSet = false;
    global_gain_range_tx = nullptr;
    m_global_gain_range_tx_isSet = false;
}

SWGBladeRF2MIMOReport::~SWGBladeRF2MIMOReport() {
    this->cleanup();
}

void
SWGBladeRF2MIMOReport::init() {
    frequency_range_rx = new SWGFrequencyRange();
    m_frequency_range_rx_isSet = false;
    sample_rate_range_rx = new SWGRange();
    m_sample_rate_range_rx_isSet = false;
    bandwidth_range_rx = new SWGRange();
    m_bandwidth_range_rx_isSet = false;
    global_gain_range_rx = new SWGRange();
    m_global_gain_range_rx_isSet = false;
    gain_modes_rx = new QList<SWGNamedEnum*>();
    m_gain_modes_rx_isSet = false;
    frequency_range_tx = new SWGFrequencyRange();
    m_frequency_range_tx_isSet = false;
    sample_rate_range_tx = new SWGRange();
    m_sample_rate_range_tx_isSet = false;
    bandwidth_range_tx = new SWGRange();
    m_bandwidth_range_tx_isSet = false;
    global_gain_range_tx = new SWGRange();
    m_global_gain_range_tx_isSet = false;
}

void
SWGBladeRF2MIMOReport::cleanup() {
    if(frequency_range_rx != nullptr) { 
        delete frequency_range_rx;
    }
    if(sample_rate_range_rx != nullptr) { 
        delete sample_rate_range_rx;
    }
    if(bandwidth_range_rx != nullptr) { 
        delete bandwidth_range_rx;
    }
    if(global_gain_range_rx != nullptr) { 
        delete global_gain_range_rx;
    }
    if(gain_modes_rx != nullptr) { 
        auto arr = gain_modes_rx;
        for(auto o: *arr) { 
            delete o;
        }
        delete gain_modes_rx;
    }
    if(frequency_range_tx != nullptr) { 
        delete frequency_range_tx;
    }
    if(sample_rate_range_tx != nullptr) { 
        delete sample_rate_range_tx;
    }
    if(bandwidth_range_tx != nullptr) { 
        delete bandwidth_range_tx;
    }
    if(global_gain_range_tx != nullptr) { 
        delete global_gain_range_tx;
    }
}

SWGBladeRF2MIMOReport*
SWGBladeRF2MIMOReport::fromJson(QString &json) {
    QByteArray array (json.toStdString().c_str());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
    return this;
}

void
SWGBladeRF2MIMOReport::fromJsonObject(QJsonObject &pJson) {
    ::SWGSDRangel::setValue(&frequency_range_rx, pJson["frequencyRangeRx"], "SWGFrequencyRange", "SWGFrequencyRange");
    
    ::SWGSDRangel::setValue(&sample_rate_range_rx, pJson["sampleRateRangeRx"], "SWGRange", "SWGRange");
    
    ::SWGSDRangel::setValue(&bandwidth_range_rx, pJson["bandwidthRangeRx"], "SWGRange", "SWGRange");
    
    ::SWGSDRangel::setValue(&global_gain_range_rx, pJson["globalGainRangeRx"], "SWGRange", "SWGRange");
    
    
    ::SWGSDRangel::setValue(&gain_modes_rx, pJson["gainModesRx"], "QList", "SWGNamedEnum");
    ::SWGSDRangel::setValue(&frequency_range_tx, pJson["frequencyRangeTx"], "SWGFrequencyRange", "SWGFrequencyRange");
    
    ::SWGSDRangel::setValue(&sample_rate_range_tx, pJson["sampleRateRangeTx"], "SWGRange", "SWGRange");
    
    ::SWGSDRangel::setValue(&bandwidth_range_tx, pJson["bandwidthRangeTx"], "SWGRange", "SWGRange");
    
    ::SWGSDRangel::setValue(&global_gain_range_tx, pJson["globalGainRangeTx"], "SWGRange", "SWGRange");
    
}

QString
SWGBladeRF2MIMOReport::asJson ()
{
    QJsonObject* obj = this->asJsonObject();

    QJsonDocument doc(*obj);
    QByteArray bytes = doc.toJson();
    delete obj;
    return QString(bytes);
}

QJsonObject*
SWGBladeRF2MIMOReport::asJsonObject() {
    QJsonObject* obj = new QJsonObject();
    if((frequency_range_rx != nullptr) && (frequency_range_rx->isSet())){
        toJsonValue(QString("frequencyRangeRx"), frequency_range_rx, obj, QString("SWGFrequencyRange"));
    }
    if((sample_rate_range_rx != nullptr) && (sample_rate_range_rx->isSet())){
        toJsonValue(QString("sampleRateRangeRx"), sample_rate_range_rx, obj, QString("SWGRange"));
    }
    if((bandwidth_range_rx != nullptr) && (bandwidth_range_rx->isSet())){
        toJsonValue(QString("bandwidthRangeRx"), bandwidth_range_rx, obj, QString("SWGRange"));
    }
    if((global_gain_range_rx != nullptr) && (global_gain_range_rx->isSet())){
        toJsonValue(QString("globalGainRangeRx"), global_gain_range_rx, obj, QString("SWGRange"));
    }
    if(gain_modes_rx && gain_modes_rx->size() > 0){
        toJsonArray((QList<void*>*)gain_modes_rx, obj, "gainModesRx", "SWGNamedEnum");
    }
    if((frequency_range_tx != nullptr) && (frequency_range_tx->isSet())){
        toJsonValue(QString("frequencyRangeTx"), frequency_range_tx, obj, QString("SWGFrequencyRange"));
    }
    if((sample_rate_range_tx != nullptr) && (sample_rate_range_tx->isSet())){
        toJsonValue(QString("sampleRateRangeTx"), sample_rate_range_tx, obj, QString("SWGRange"));
    }
    if((bandwidth_range_tx != nullptr) && (bandwidth_range_tx->isSet())){
        toJsonValue(QString("bandwidthRangeTx"), bandwidth_range_tx, obj, QString("SWGRange"));
    }
    if((global_gain_range_tx != nullptr) && (global_gain_range_tx->isSet())){
        toJsonValue(QString("globalGainRangeTx"), global_gain_range_tx, obj, QString("SWGRange"));
    }

    return obj;
}

SWGFrequencyRange*
SWGBladeRF2MIMOReport::getFrequencyRangeRx() {
    return frequency_range_rx;
}
void
SWGBladeRF2MIMOReport::setFrequencyRangeRx(SWGFrequencyRange* frequency_range_rx) {
    this->frequency_range_rx = frequency_range_rx;
    this->m_frequency_range_rx_isSet = true;
}

SWGRange*
SWGBladeRF2MIMOReport::getSampleRateRangeRx() {
    return sample_rate_range_rx;
}
void
SWGBladeRF2MIMOReport::setSampleRateRangeRx(SWGRange* sample_rate_range_rx) {
    this->sample_rate_range_rx = sample_rate_range_rx;
    this->m_sample_rate_range_rx_isSet = true;
}

SWGRange*
SWGBladeRF2MIMOReport::getBandwidthRangeRx() {
    return bandwidth_range_rx;
}
void
SWGBladeRF2MIMOReport::setBandwidthRangeRx(SWGRange* bandwidth_range_rx) {
    this->bandwidth_range_rx = bandwidth_range_rx;
    this->m_bandwidth_range_rx_isSet = true;
}

SWGRange*
SWGBladeRF2MIMOReport::getGlobalGainRangeRx() {
    return global_gain_range_rx;
}
void
SWGBladeRF2MIMOReport::setGlobalGainRangeRx(SWGRange* global_gain_range_rx) {
    this->global_gain_range_rx = global_gain_range_rx;
    this->m_global_gain_range_rx_isSet = true;
}

QList<SWGNamedEnum*>*
SWGBladeRF2MIMOReport::getGainModesRx() {
    return gain_modes_rx;
}
void
SWGBladeRF2MIMOReport::setGainModesRx(QList<SWGNamedEnum*>* gain_modes_rx) {
    this->gain_modes_rx = gain_modes_rx;
    this->m_gain_modes_rx_isSet = true;
}

SWGFrequencyRange*
SWGBladeRF2MIMOReport::getFrequencyRangeTx() {
    return frequency_range_tx;
}
void
SWGBladeRF2MIMOReport::setFrequencyRangeTx(SWGFrequencyRange* frequency_range_tx) {
    this->frequency_range_tx = frequency_range_tx;
    this->m_frequency_range_tx_isSet = true;
}

SWGRange*
SWGBladeRF2MIMOReport::getSampleRateRangeTx() {
    return sample_rate_range_tx;
}
void
SWGBladeRF2MIMOReport::setSampleRateRangeTx(SWGRange* sample_rate_range_tx) {
    this->sample_rate_range_tx = sample_rate_range_tx;
    this->m_sample_rate_range_tx_isSet = true;
}

SWGRange*
SWGBladeRF2MIMOReport::getBandwidthRangeTx() {
    return bandwidth_range_tx;
}
void
SWGBladeRF2MIMOReport::setBandwidthRangeTx(SWGRange* bandwidth_range_tx) {
    this->bandwidth_range_tx = bandwidth_range_tx;
    this->m_bandwidth_range_tx_isSet = true;
}

SWGRange*
SWGBladeRF2MIMOReport::getGlobalGainRangeTx() {
    return global_gain_range_tx;
}
void
SWGBladeRF2MIMOReport::setGlobalGainRangeTx(SWGRange* global_gain_range_tx) {
    this->global_gain_range_tx = global_gain_range_tx;
    this->m_global_gain_range_tx_isSet = true;
}


bool
SWGBladeRF2MIMOReport::isSet(){
    bool isObjectUpdated = false;
    do{
        if(frequency_range_rx && frequency_range_rx->isSet()){
            isObjectUpdated = true; break;
        }
        if(sample_rate_range_rx && sample_rate_range_rx->isSet()){
            isObjectUpdated = true; break;
        }
        if(bandwidth_range_rx && bandwidth_range_rx->isSet()){
            isObjectUpdated = true; break;
        }
        if(global_gain_range_rx && global_gain_range_rx->isSet()){
            isObjectUpdated = true; break;
        }
        if(gain_modes_rx && (gain_modes_rx->size() > 0)){
            isObjectUpdated = true; break;
        }
        if(frequency_range_tx && frequency_range_tx->isSet()){
            isObjectUpdated = true; break;
        }
        if(sample_rate_range_tx && sample_rate_range_tx->isSet()){
            isObjectUpdated = true; break;
        }
        if(bandwidth_range_tx && bandwidth_range_tx->isSet()){
            isObjectUpdated = true; break;
        }
        if(global_gain_range_tx && global_gain_range_tx->isSet()){
            isObjectUpdated = true; break;
        }
    }while(false);
    return isObjectUpdated;
}
}

