/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 7.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


#include "SWGAPRSSettings.h"

#include "SWGHelpers.h"

#include <QJsonDocument>
#include <QJsonArray>
#include <QObject>
#include <QDebug>

namespace SWGSDRangel {

SWGAPRSSettings::SWGAPRSSettings(QString* json) {
    init();
    this->fromJson(*json);
}

SWGAPRSSettings::SWGAPRSSettings() {
    igate_server = nullptr;
    m_igate_server_isSet = false;
    igate_port = 0;
    m_igate_port_isSet = false;
    igate_callsign = nullptr;
    m_igate_callsign_isSet = false;
    igate_passcode = nullptr;
    m_igate_passcode_isSet = false;
    igate_filter = nullptr;
    m_igate_filter_isSet = false;
    igate_enabled = 0;
    m_igate_enabled_isSet = false;
    title = nullptr;
    m_title_isSet = false;
    rgb_color = 0;
    m_rgb_color_isSet = false;
    use_reverse_api = 0;
    m_use_reverse_api_isSet = false;
    reverse_api_address = nullptr;
    m_reverse_api_address_isSet = false;
    reverse_api_port = 0;
    m_reverse_api_port_isSet = false;
    reverse_api_feature_set_index = 0;
    m_reverse_api_feature_set_index_isSet = false;
    reverse_api_feature_index = 0;
    m_reverse_api_feature_index_isSet = false;
    rollup_state = nullptr;
    m_rollup_state_isSet = false;
    packets_table_column_indexes = new QList<qint32>();
    m_packets_table_column_indexes_isSet = false;
    packets_table_column_sizes = new QList<qint32>();
    m_packets_table_column_sizes_isSet = false;
    weather_table_column_indexes = new QList<qint32>();
    m_weather_table_column_indexes_isSet = false;
    weather_table_column_sizes = new QList<qint32>();
    m_weather_table_column_sizes_isSet = false;
    status_table_column_indexes = new QList<qint32>();
    m_status_table_column_indexes_isSet = false;
    status_table_column_sizes = new QList<qint32>();
    m_status_table_column_sizes_isSet = false;
    messages_table_column_indexes = new QList<qint32>();
    m_messages_table_column_indexes_isSet = false;
    messages_table_column_sizes = new QList<qint32>();
    m_messages_table_column_sizes_isSet = false;
    telemetry_table_column_indexes = new QList<qint32>();
    m_telemetry_table_column_indexes_isSet = false;
    telemetry_table_column_sizes = new QList<qint32>();
    m_telemetry_table_column_sizes_isSet = false;
    motion_table_column_indexes = new QList<qint32>();
    m_motion_table_column_indexes_isSet = false;
    motion_table_column_sizes = new QList<qint32>();
    m_motion_table_column_sizes_isSet = false;
}

SWGAPRSSettings::~SWGAPRSSettings() {
    this->cleanup();
}

void
SWGAPRSSettings::init() {
    igate_server = new QString("");
    m_igate_server_isSet = false;
    igate_port = 0;
    m_igate_port_isSet = false;
    igate_callsign = new QString("");
    m_igate_callsign_isSet = false;
    igate_passcode = new QString("");
    m_igate_passcode_isSet = false;
    igate_filter = new QString("");
    m_igate_filter_isSet = false;
    igate_enabled = 0;
    m_igate_enabled_isSet = false;
    title = new QString("");
    m_title_isSet = false;
    rgb_color = 0;
    m_rgb_color_isSet = false;
    use_reverse_api = 0;
    m_use_reverse_api_isSet = false;
    reverse_api_address = new QString("");
    m_reverse_api_address_isSet = false;
    reverse_api_port = 0;
    m_reverse_api_port_isSet = false;
    reverse_api_feature_set_index = 0;
    m_reverse_api_feature_set_index_isSet = false;
    reverse_api_feature_index = 0;
    m_reverse_api_feature_index_isSet = false;
    rollup_state = new SWGRollupState();
    m_rollup_state_isSet = false;
    packets_table_column_indexes = new QList<qint32>();
    m_packets_table_column_indexes_isSet = false;
    packets_table_column_sizes = new QList<qint32>();
    m_packets_table_column_sizes_isSet = false;
    weather_table_column_indexes = new QList<qint32>();
    m_weather_table_column_indexes_isSet = false;
    weather_table_column_sizes = new QList<qint32>();
    m_weather_table_column_sizes_isSet = false;
    status_table_column_indexes = new QList<qint32>();
    m_status_table_column_indexes_isSet = false;
    status_table_column_sizes = new QList<qint32>();
    m_status_table_column_sizes_isSet = false;
    messages_table_column_indexes = new QList<qint32>();
    m_messages_table_column_indexes_isSet = false;
    messages_table_column_sizes = new QList<qint32>();
    m_messages_table_column_sizes_isSet = false;
    telemetry_table_column_indexes = new QList<qint32>();
    m_telemetry_table_column_indexes_isSet = false;
    telemetry_table_column_sizes = new QList<qint32>();
    m_telemetry_table_column_sizes_isSet = false;
    motion_table_column_indexes = new QList<qint32>();
    m_motion_table_column_indexes_isSet = false;
    motion_table_column_sizes = new QList<qint32>();
    m_motion_table_column_sizes_isSet = false;
}

void
SWGAPRSSettings::cleanup() {
    if(igate_server != nullptr) { 
        delete igate_server;
    }

    if(igate_callsign != nullptr) { 
        delete igate_callsign;
    }
    if(igate_passcode != nullptr) { 
        delete igate_passcode;
    }
    if(igate_filter != nullptr) { 
        delete igate_filter;
    }

    if(title != nullptr) { 
        delete title;
    }


    if(reverse_api_address != nullptr) { 
        delete reverse_api_address;
    }



    if(rollup_state != nullptr) { 
        delete rollup_state;
    }












}

SWGAPRSSettings*
SWGAPRSSettings::fromJson(QString &json) {
    QByteArray array (json.toStdString().c_str());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
    return this;
}

void
SWGAPRSSettings::fromJsonObject(QJsonObject &pJson) {
    ::SWGSDRangel::setValue(&igate_server, pJson["igateServer"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&igate_port, pJson["igatePort"], "qint32", "");
    
    ::SWGSDRangel::setValue(&igate_callsign, pJson["igateCallsign"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&igate_passcode, pJson["igatePasscode"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&igate_filter, pJson["igateFilter"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&igate_enabled, pJson["igateEnabled"], "qint32", "");
    
    ::SWGSDRangel::setValue(&title, pJson["title"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&rgb_color, pJson["rgbColor"], "qint32", "");
    
    ::SWGSDRangel::setValue(&use_reverse_api, pJson["useReverseAPI"], "qint32", "");
    
    ::SWGSDRangel::setValue(&reverse_api_address, pJson["reverseAPIAddress"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&reverse_api_port, pJson["reverseAPIPort"], "qint32", "");
    
    ::SWGSDRangel::setValue(&reverse_api_feature_set_index, pJson["reverseAPIFeatureSetIndex"], "qint32", "");
    
    ::SWGSDRangel::setValue(&reverse_api_feature_index, pJson["reverseAPIFeatureIndex"], "qint32", "");
    
    ::SWGSDRangel::setValue(&rollup_state, pJson["rollupState"], "SWGRollupState", "SWGRollupState");
    
    
    ::SWGSDRangel::setValue(&packets_table_column_indexes, pJson["packetsTableColumnIndexes"], "QList", "qint32");
    
    ::SWGSDRangel::setValue(&packets_table_column_sizes, pJson["packetsTableColumnSizes"], "QList", "qint32");
    
    ::SWGSDRangel::setValue(&weather_table_column_indexes, pJson["weatherTableColumnIndexes"], "QList", "qint32");
    
    ::SWGSDRangel::setValue(&weather_table_column_sizes, pJson["weatherTableColumnSizes"], "QList", "qint32");
    
    ::SWGSDRangel::setValue(&status_table_column_indexes, pJson["statusTableColumnIndexes"], "QList", "qint32");
    
    ::SWGSDRangel::setValue(&status_table_column_sizes, pJson["statusTableColumnSizes"], "QList", "qint32");
    
    ::SWGSDRangel::setValue(&messages_table_column_indexes, pJson["messagesTableColumnIndexes"], "QList", "qint32");
    
    ::SWGSDRangel::setValue(&messages_table_column_sizes, pJson["messagesTableColumnSizes"], "QList", "qint32");
    
    ::SWGSDRangel::setValue(&telemetry_table_column_indexes, pJson["telemetryTableColumnIndexes"], "QList", "qint32");
    
    ::SWGSDRangel::setValue(&telemetry_table_column_sizes, pJson["telemetryTableColumnSizes"], "QList", "qint32");
    
    ::SWGSDRangel::setValue(&motion_table_column_indexes, pJson["motionTableColumnIndexes"], "QList", "qint32");
    
    ::SWGSDRangel::setValue(&motion_table_column_sizes, pJson["motionTableColumnSizes"], "QList", "qint32");
}

QString
SWGAPRSSettings::asJson ()
{
    QJsonObject* obj = this->asJsonObject();

    QJsonDocument doc(*obj);
    QByteArray bytes = doc.toJson();
    delete obj;
    return QString(bytes);
}

QJsonObject*
SWGAPRSSettings::asJsonObject() {
    QJsonObject* obj = new QJsonObject();
    if(igate_server != nullptr && *igate_server != QString("")){
        toJsonValue(QString("igateServer"), igate_server, obj, QString("QString"));
    }
    if(m_igate_port_isSet){
        obj->insert("igatePort", QJsonValue(igate_port));
    }
    if(igate_callsign != nullptr && *igate_callsign != QString("")){
        toJsonValue(QString("igateCallsign"), igate_callsign, obj, QString("QString"));
    }
    if(igate_passcode != nullptr && *igate_passcode != QString("")){
        toJsonValue(QString("igatePasscode"), igate_passcode, obj, QString("QString"));
    }
    if(igate_filter != nullptr && *igate_filter != QString("")){
        toJsonValue(QString("igateFilter"), igate_filter, obj, QString("QString"));
    }
    if(m_igate_enabled_isSet){
        obj->insert("igateEnabled", QJsonValue(igate_enabled));
    }
    if(title != nullptr && *title != QString("")){
        toJsonValue(QString("title"), title, obj, QString("QString"));
    }
    if(m_rgb_color_isSet){
        obj->insert("rgbColor", QJsonValue(rgb_color));
    }
    if(m_use_reverse_api_isSet){
        obj->insert("useReverseAPI", QJsonValue(use_reverse_api));
    }
    if(reverse_api_address != nullptr && *reverse_api_address != QString("")){
        toJsonValue(QString("reverseAPIAddress"), reverse_api_address, obj, QString("QString"));
    }
    if(m_reverse_api_port_isSet){
        obj->insert("reverseAPIPort", QJsonValue(reverse_api_port));
    }
    if(m_reverse_api_feature_set_index_isSet){
        obj->insert("reverseAPIFeatureSetIndex", QJsonValue(reverse_api_feature_set_index));
    }
    if(m_reverse_api_feature_index_isSet){
        obj->insert("reverseAPIFeatureIndex", QJsonValue(reverse_api_feature_index));
    }
    if((rollup_state != nullptr) && (rollup_state->isSet())){
        toJsonValue(QString("rollupState"), rollup_state, obj, QString("SWGRollupState"));
    }
    if(packets_table_column_indexes && packets_table_column_indexes->size() > 0){
        toJsonArray((QList<void*>*)packets_table_column_indexes, obj, "packetsTableColumnIndexes", "qint32");
    }
    if(packets_table_column_sizes && packets_table_column_sizes->size() > 0){
        toJsonArray((QList<void*>*)packets_table_column_sizes, obj, "packetsTableColumnSizes", "qint32");
    }
    if(weather_table_column_indexes && weather_table_column_indexes->size() > 0){
        toJsonArray((QList<void*>*)weather_table_column_indexes, obj, "weatherTableColumnIndexes", "qint32");
    }
    if(weather_table_column_sizes && weather_table_column_sizes->size() > 0){
        toJsonArray((QList<void*>*)weather_table_column_sizes, obj, "weatherTableColumnSizes", "qint32");
    }
    if(status_table_column_indexes && status_table_column_indexes->size() > 0){
        toJsonArray((QList<void*>*)status_table_column_indexes, obj, "statusTableColumnIndexes", "qint32");
    }
    if(status_table_column_sizes && status_table_column_sizes->size() > 0){
        toJsonArray((QList<void*>*)status_table_column_sizes, obj, "statusTableColumnSizes", "qint32");
    }
    if(messages_table_column_indexes && messages_table_column_indexes->size() > 0){
        toJsonArray((QList<void*>*)messages_table_column_indexes, obj, "messagesTableColumnIndexes", "qint32");
    }
    if(messages_table_column_sizes && messages_table_column_sizes->size() > 0){
        toJsonArray((QList<void*>*)messages_table_column_sizes, obj, "messagesTableColumnSizes", "qint32");
    }
    if(telemetry_table_column_indexes && telemetry_table_column_indexes->size() > 0){
        toJsonArray((QList<void*>*)telemetry_table_column_indexes, obj, "telemetryTableColumnIndexes", "qint32");
    }
    if(telemetry_table_column_sizes && telemetry_table_column_sizes->size() > 0){
        toJsonArray((QList<void*>*)telemetry_table_column_sizes, obj, "telemetryTableColumnSizes", "qint32");
    }
    if(motion_table_column_indexes && motion_table_column_indexes->size() > 0){
        toJsonArray((QList<void*>*)motion_table_column_indexes, obj, "motionTableColumnIndexes", "qint32");
    }
    if(motion_table_column_sizes && motion_table_column_sizes->size() > 0){
        toJsonArray((QList<void*>*)motion_table_column_sizes, obj, "motionTableColumnSizes", "qint32");
    }

    return obj;
}

QString*
SWGAPRSSettings::getIgateServer() {
    return igate_server;
}
void
SWGAPRSSettings::setIgateServer(QString* igate_server) {
    this->igate_server = igate_server;
    this->m_igate_server_isSet = true;
}

qint32
SWGAPRSSettings::getIgatePort() {
    return igate_port;
}
void
SWGAPRSSettings::setIgatePort(qint32 igate_port) {
    this->igate_port = igate_port;
    this->m_igate_port_isSet = true;
}

QString*
SWGAPRSSettings::getIgateCallsign() {
    return igate_callsign;
}
void
SWGAPRSSettings::setIgateCallsign(QString* igate_callsign) {
    this->igate_callsign = igate_callsign;
    this->m_igate_callsign_isSet = true;
}

QString*
SWGAPRSSettings::getIgatePasscode() {
    return igate_passcode;
}
void
SWGAPRSSettings::setIgatePasscode(QString* igate_passcode) {
    this->igate_passcode = igate_passcode;
    this->m_igate_passcode_isSet = true;
}

QString*
SWGAPRSSettings::getIgateFilter() {
    return igate_filter;
}
void
SWGAPRSSettings::setIgateFilter(QString* igate_filter) {
    this->igate_filter = igate_filter;
    this->m_igate_filter_isSet = true;
}

qint32
SWGAPRSSettings::getIgateEnabled() {
    return igate_enabled;
}
void
SWGAPRSSettings::setIgateEnabled(qint32 igate_enabled) {
    this->igate_enabled = igate_enabled;
    this->m_igate_enabled_isSet = true;
}

QString*
SWGAPRSSettings::getTitle() {
    return title;
}
void
SWGAPRSSettings::setTitle(QString* title) {
    this->title = title;
    this->m_title_isSet = true;
}

qint32
SWGAPRSSettings::getRgbColor() {
    return rgb_color;
}
void
SWGAPRSSettings::setRgbColor(qint32 rgb_color) {
    this->rgb_color = rgb_color;
    this->m_rgb_color_isSet = true;
}

qint32
SWGAPRSSettings::getUseReverseApi() {
    return use_reverse_api;
}
void
SWGAPRSSettings::setUseReverseApi(qint32 use_reverse_api) {
    this->use_reverse_api = use_reverse_api;
    this->m_use_reverse_api_isSet = true;
}

QString*
SWGAPRSSettings::getReverseApiAddress() {
    return reverse_api_address;
}
void
SWGAPRSSettings::setReverseApiAddress(QString* reverse_api_address) {
    this->reverse_api_address = reverse_api_address;
    this->m_reverse_api_address_isSet = true;
}

qint32
SWGAPRSSettings::getReverseApiPort() {
    return reverse_api_port;
}
void
SWGAPRSSettings::setReverseApiPort(qint32 reverse_api_port) {
    this->reverse_api_port = reverse_api_port;
    this->m_reverse_api_port_isSet = true;
}

qint32
SWGAPRSSettings::getReverseApiFeatureSetIndex() {
    return reverse_api_feature_set_index;
}
void
SWGAPRSSettings::setReverseApiFeatureSetIndex(qint32 reverse_api_feature_set_index) {
    this->reverse_api_feature_set_index = reverse_api_feature_set_index;
    this->m_reverse_api_feature_set_index_isSet = true;
}

qint32
SWGAPRSSettings::getReverseApiFeatureIndex() {
    return reverse_api_feature_index;
}
void
SWGAPRSSettings::setReverseApiFeatureIndex(qint32 reverse_api_feature_index) {
    this->reverse_api_feature_index = reverse_api_feature_index;
    this->m_reverse_api_feature_index_isSet = true;
}

SWGRollupState*
SWGAPRSSettings::getRollupState() {
    return rollup_state;
}
void
SWGAPRSSettings::setRollupState(SWGRollupState* rollup_state) {
    this->rollup_state = rollup_state;
    this->m_rollup_state_isSet = true;
}

QList<qint32>*
SWGAPRSSettings::getPacketsTableColumnIndexes() {
    return packets_table_column_indexes;
}
void
SWGAPRSSettings::setPacketsTableColumnIndexes(QList<qint32>* packets_table_column_indexes) {
    this->packets_table_column_indexes = packets_table_column_indexes;
    this->m_packets_table_column_indexes_isSet = true;
}

QList<qint32>*
SWGAPRSSettings::getPacketsTableColumnSizes() {
    return packets_table_column_sizes;
}
void
SWGAPRSSettings::setPacketsTableColumnSizes(QList<qint32>* packets_table_column_sizes) {
    this->packets_table_column_sizes = packets_table_column_sizes;
    this->m_packets_table_column_sizes_isSet = true;
}

QList<qint32>*
SWGAPRSSettings::getWeatherTableColumnIndexes() {
    return weather_table_column_indexes;
}
void
SWGAPRSSettings::setWeatherTableColumnIndexes(QList<qint32>* weather_table_column_indexes) {
    this->weather_table_column_indexes = weather_table_column_indexes;
    this->m_weather_table_column_indexes_isSet = true;
}

QList<qint32>*
SWGAPRSSettings::getWeatherTableColumnSizes() {
    return weather_table_column_sizes;
}
void
SWGAPRSSettings::setWeatherTableColumnSizes(QList<qint32>* weather_table_column_sizes) {
    this->weather_table_column_sizes = weather_table_column_sizes;
    this->m_weather_table_column_sizes_isSet = true;
}

QList<qint32>*
SWGAPRSSettings::getStatusTableColumnIndexes() {
    return status_table_column_indexes;
}
void
SWGAPRSSettings::setStatusTableColumnIndexes(QList<qint32>* status_table_column_indexes) {
    this->status_table_column_indexes = status_table_column_indexes;
    this->m_status_table_column_indexes_isSet = true;
}

QList<qint32>*
SWGAPRSSettings::getStatusTableColumnSizes() {
    return status_table_column_sizes;
}
void
SWGAPRSSettings::setStatusTableColumnSizes(QList<qint32>* status_table_column_sizes) {
    this->status_table_column_sizes = status_table_column_sizes;
    this->m_status_table_column_sizes_isSet = true;
}

QList<qint32>*
SWGAPRSSettings::getMessagesTableColumnIndexes() {
    return messages_table_column_indexes;
}
void
SWGAPRSSettings::setMessagesTableColumnIndexes(QList<qint32>* messages_table_column_indexes) {
    this->messages_table_column_indexes = messages_table_column_indexes;
    this->m_messages_table_column_indexes_isSet = true;
}

QList<qint32>*
SWGAPRSSettings::getMessagesTableColumnSizes() {
    return messages_table_column_sizes;
}
void
SWGAPRSSettings::setMessagesTableColumnSizes(QList<qint32>* messages_table_column_sizes) {
    this->messages_table_column_sizes = messages_table_column_sizes;
    this->m_messages_table_column_sizes_isSet = true;
}

QList<qint32>*
SWGAPRSSettings::getTelemetryTableColumnIndexes() {
    return telemetry_table_column_indexes;
}
void
SWGAPRSSettings::setTelemetryTableColumnIndexes(QList<qint32>* telemetry_table_column_indexes) {
    this->telemetry_table_column_indexes = telemetry_table_column_indexes;
    this->m_telemetry_table_column_indexes_isSet = true;
}

QList<qint32>*
SWGAPRSSettings::getTelemetryTableColumnSizes() {
    return telemetry_table_column_sizes;
}
void
SWGAPRSSettings::setTelemetryTableColumnSizes(QList<qint32>* telemetry_table_column_sizes) {
    this->telemetry_table_column_sizes = telemetry_table_column_sizes;
    this->m_telemetry_table_column_sizes_isSet = true;
}

QList<qint32>*
SWGAPRSSettings::getMotionTableColumnIndexes() {
    return motion_table_column_indexes;
}
void
SWGAPRSSettings::setMotionTableColumnIndexes(QList<qint32>* motion_table_column_indexes) {
    this->motion_table_column_indexes = motion_table_column_indexes;
    this->m_motion_table_column_indexes_isSet = true;
}

QList<qint32>*
SWGAPRSSettings::getMotionTableColumnSizes() {
    return motion_table_column_sizes;
}
void
SWGAPRSSettings::setMotionTableColumnSizes(QList<qint32>* motion_table_column_sizes) {
    this->motion_table_column_sizes = motion_table_column_sizes;
    this->m_motion_table_column_sizes_isSet = true;
}


bool
SWGAPRSSettings::isSet(){
    bool isObjectUpdated = false;
    do{
        if(igate_server && *igate_server != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_igate_port_isSet){
            isObjectUpdated = true; break;
        }
        if(igate_callsign && *igate_callsign != QString("")){
            isObjectUpdated = true; break;
        }
        if(igate_passcode && *igate_passcode != QString("")){
            isObjectUpdated = true; break;
        }
        if(igate_filter && *igate_filter != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_igate_enabled_isSet){
            isObjectUpdated = true; break;
        }
        if(title && *title != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_rgb_color_isSet){
            isObjectUpdated = true; break;
        }
        if(m_use_reverse_api_isSet){
            isObjectUpdated = true; break;
        }
        if(reverse_api_address && *reverse_api_address != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_reverse_api_port_isSet){
            isObjectUpdated = true; break;
        }
        if(m_reverse_api_feature_set_index_isSet){
            isObjectUpdated = true; break;
        }
        if(m_reverse_api_feature_index_isSet){
            isObjectUpdated = true; break;
        }
        if(rollup_state && rollup_state->isSet()){
            isObjectUpdated = true; break;
        }
        if(m_packets_table_column_indexes_isSet){
            isObjectUpdated = true; break;
        }
        if(packets_table_column_indexes && (packets_table_column_indexes->size() > 0)){
            isObjectUpdated = true; break;
        }
        if(m_packets_table_column_sizes_isSet){
            isObjectUpdated = true; break;
        }
        if(packets_table_column_sizes && (packets_table_column_sizes->size() > 0)){
            isObjectUpdated = true; break;
        }
        if(m_weather_table_column_indexes_isSet){
            isObjectUpdated = true; break;
        }
        if(weather_table_column_indexes && (weather_table_column_indexes->size() > 0)){
            isObjectUpdated = true; break;
        }
        if(m_weather_table_column_sizes_isSet){
            isObjectUpdated = true; break;
        }
        if(weather_table_column_sizes && (weather_table_column_sizes->size() > 0)){
            isObjectUpdated = true; break;
        }
        if(m_status_table_column_indexes_isSet){
            isObjectUpdated = true; break;
        }
        if(status_table_column_indexes && (status_table_column_indexes->size() > 0)){
            isObjectUpdated = true; break;
        }
        if(m_status_table_column_sizes_isSet){
            isObjectUpdated = true; break;
        }
        if(status_table_column_sizes && (status_table_column_sizes->size() > 0)){
            isObjectUpdated = true; break;
        }
        if(m_messages_table_column_indexes_isSet){
            isObjectUpdated = true; break;
        }
        if(messages_table_column_indexes && (messages_table_column_indexes->size() > 0)){
            isObjectUpdated = true; break;
        }
        if(m_messages_table_column_sizes_isSet){
            isObjectUpdated = true; break;
        }
        if(messages_table_column_sizes && (messages_table_column_sizes->size() > 0)){
            isObjectUpdated = true; break;
        }
        if(m_telemetry_table_column_indexes_isSet){
            isObjectUpdated = true; break;
        }
        if(telemetry_table_column_indexes && (telemetry_table_column_indexes->size() > 0)){
            isObjectUpdated = true; break;
        }
        if(m_telemetry_table_column_sizes_isSet){
            isObjectUpdated = true; break;
        }
        if(telemetry_table_column_sizes && (telemetry_table_column_sizes->size() > 0)){
            isObjectUpdated = true; break;
        }
        if(m_motion_table_column_indexes_isSet){
            isObjectUpdated = true; break;
        }
        if(motion_table_column_indexes && (motion_table_column_indexes->size() > 0)){
            isObjectUpdated = true; break;
        }
        if(m_motion_table_column_sizes_isSet){
            isObjectUpdated = true; break;
        }
        if(motion_table_column_sizes && (motion_table_column_sizes->size() > 0)){
            isObjectUpdated = true; break;
        }
    }while(false);
    return isObjectUpdated;
}
}

